# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx.nvds_urt.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class Precheck(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.nvds_urt.precheck'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _PrecheckStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               tolerate_different_configurations=None,
               ):
        """
        Precheck is peformed at a global level across all NVDSes present in the
        system. It is expected to check the status once the precheck API is
        invoked via GetNvdsUpgradeReadinessCheckSummary API. If NVDS
        configuration like HostSwitchProfiles differs across TransportNodes,
        precheck will fail and status will be FAILED and error will be reported
        via the status API. Once the reported errors are fixed, precheck API is
        expected to be invoked again to rerun precheck. Once NVDS configuration
        is consistent across all TransportNodes, precheck will pass and a
        topology will be generated and status will be PENDING_TOPOLOGY.
        Generated toplogy can be retrieved via GetRecommendedVdsTopology API.
        User can apply the recommended topology via SetTargetVdsTopology API.

        .. deprecated:: unknown

        :type  tolerate_different_configurations: :class:`bool` or ``None``
        :param tolerate_different_configurations: tolerate differnet configurations (optional, default to true)
        :rtype: :class:`com.vmware.nsx.model_client.NvdsUpgradePrecheckId`
        :return: com.vmware.nsx.model.NvdsUpgradePrecheckId
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx.nvds_urt.Precheck.create is deprecated.', DeprecationWarning)
        return self._invoke('create',
                            {
                            'tolerate_different_configurations': tolerate_different_configurations,
                            })

    def get(self):
        """
        Retrieve latest precheck ID of the N-VDS to VDS migration

        .. deprecated:: unknown


        :rtype: :class:`com.vmware.nsx.model_client.NvdsUpgradePrecheckId`
        :return: com.vmware.nsx.model.NvdsUpgradePrecheckId
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx.nvds_urt.Precheck.get is deprecated.', DeprecationWarning)
        return self._invoke('get', None)
class PrecheckByCluster(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.nvds_urt.precheck_by_cluster'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _PrecheckByClusterStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               cluster_id,
               tolerate_different_configurations=None,
               ):
        """
        Start precheck for N-VDS to VDS migration by cluster

        .. deprecated:: unknown

        :type  cluster_id: :class:`str`
        :param cluster_id: (required)
        :type  tolerate_different_configurations: :class:`bool` or ``None``
        :param tolerate_different_configurations: tolerate differnet configurations (optional, default to true)
        :rtype: :class:`com.vmware.nsx.model_client.NvdsUpgradePrecheckId`
        :return: com.vmware.nsx.model.NvdsUpgradePrecheckId
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx.nvds_urt.PrecheckByCluster.create is deprecated.', DeprecationWarning)
        return self._invoke('create',
                            {
                            'cluster_id': cluster_id,
                            'tolerate_different_configurations': tolerate_different_configurations,
                            })

    def get(self,
            cluster_id,
            ):
        """
        Retrieve latest precheck ID of the N-VDS to VDS migration for the
        cluster

        .. deprecated:: unknown

        :type  cluster_id: :class:`str`
        :param cluster_id: (required)
        :rtype: :class:`com.vmware.nsx.model_client.NvdsUpgradePrecheckId`
        :return: com.vmware.nsx.model.NvdsUpgradePrecheckId
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx.nvds_urt.PrecheckByCluster.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'cluster_id': cluster_id,
                            })
class PrecheckByClusters(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.nvds_urt.precheck_by_clusters'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _PrecheckByClustersStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               precheck_parameters,
               tolerate_different_configurations=None,
               ):
        """
        Start precheck for N-VDS to VDS migration by clusters

        .. deprecated:: unknown

        :type  precheck_parameters: :class:`com.vmware.nsx.model_client.PrecheckParameters`
        :param precheck_parameters: (required)
        :type  tolerate_different_configurations: :class:`bool` or ``None``
        :param tolerate_different_configurations: tolerate differnet configurations (optional, default to true)
        :rtype: :class:`com.vmware.nsx.model_client.NvdsUpgradePrecheckId`
        :return: com.vmware.nsx.model.NvdsUpgradePrecheckId
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx.nvds_urt.PrecheckByClusters.create is deprecated.', DeprecationWarning)
        return self._invoke('create',
                            {
                            'precheck_parameters': precheck_parameters,
                            'tolerate_different_configurations': tolerate_different_configurations,
                            })
class StatusSummary(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.nvds_urt.status_summary'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _StatusSummaryStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            precheck_id,
            cluster_id=None,
            ):
        """
        Provides overall status for Precheck as well as actual NVDS to CVDS
        upgrade status per host. Precheck statuses are as follows 1.
        IN_PROGRESS: Precheck is in progress 2. FAILED: Precheck is failed,
        error can be found in precheck_issue field 3. PENDING_TOPOLOGY:
        Precheck is successful, recommended topology is generated 4.
        APPLYING_TOPOLOGY: SetTargetToplogy is in progress 5.
        APPLY_TOPOLOGY_FAILED: SetTargetTopology is failed 6. REDAY:
        SetTargetTopology is successful and TransportNodes provided as part of
        topology are ready for upgrade from NVDS to CVDS

        .. deprecated:: unknown

        :type  precheck_id: :class:`str`
        :param precheck_id: (required)
        :type  cluster_id: :class:`str` or ``None``
        :param cluster_id: cluster identifier (optional)
        :rtype: :class:`com.vmware.nsx.model_client.NvdsUpgradeStatusSummary`
        :return: com.vmware.nsx.model.NvdsUpgradeStatusSummary
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx.nvds_urt.StatusSummary.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'precheck_id': precheck_id,
                            'cluster_id': cluster_id,
                            })
class StatusSummaryByCluster(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.nvds_urt.status_summary_by_cluster'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _StatusSummaryByClusterStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            precheck_id,
            ):
        """
        Get summary of N-VDS to VDS migration

        .. deprecated:: unknown

        :type  precheck_id: :class:`str`
        :param precheck_id: (required)
        :rtype: :class:`com.vmware.nsx.model_client.NvdsUpgradeStatusSummary`
        :return: com.vmware.nsx.model.NvdsUpgradeStatusSummary
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx.nvds_urt.StatusSummaryByCluster.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'precheck_id': precheck_id,
                            })
class Topology(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.nvds_urt.topology'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _TopologyStub)
        self._VAPI_OPERATION_IDS = {}


    def apply(self,
              upgrade_topology,
              cluster_id=None,
              use_recommended_topology_config=None,
              ):
        """
        Upon successful preheck status goes to PENDING_TOPOLOGY and global
        recommended topology is generated which can be retrieved via
        GetRecommendedVdsTopology API. User can apply the entire recommeneded
        topology all together or can apply partial depending on which
        TrasportNodes user wants to be upgraded from NVDS to CVDS. User can
        change system generated vds_name field, all other fields cannot be
        changed when applying topology.

        .. deprecated:: unknown

        :type  upgrade_topology: :class:`com.vmware.nsx.model_client.UpgradeTopology`
        :param upgrade_topology: (required)
        :type  cluster_id: :class:`str` or ``None``
        :param cluster_id: cluster identifier (optional)
        :type  use_recommended_topology_config: :class:`bool` or ``None``
        :param use_recommended_topology_config: Flag to indicate if use recommended topology got from the latest
            precheck (optional)
        :rtype: :class:`com.vmware.nsx.model_client.UpgradeTopology`
        :return: com.vmware.nsx.model.UpgradeTopology
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx.nvds_urt.Topology.apply is deprecated.', DeprecationWarning)
        return self._invoke('apply',
                            {
                            'upgrade_topology': upgrade_topology,
                            'cluster_id': cluster_id,
                            'use_recommended_topology_config': use_recommended_topology_config,
                            })

    def get(self,
            precheck_id,
            cluster_id=None,
            compute_manager_id=None,
            show_vds_config=None,
            ):
        """
        This returns global recommended topology generated when precheck is
        successful.

        .. deprecated:: unknown

        :type  precheck_id: :class:`str`
        :param precheck_id: (required)
        :type  cluster_id: :class:`str` or ``None``
        :param cluster_id: cluster identifier (optional)
        :type  compute_manager_id: :class:`str` or ``None``
        :param compute_manager_id: vCenter identifier (optional)
        :type  show_vds_config: :class:`bool` or ``None``
        :param show_vds_config: Flag to indicate if VdsTopology should contain VDS configuration
            (optional)
        :rtype: :class:`com.vmware.nsx.model_client.UpgradeTopology`
        :return: com.vmware.nsx.model.UpgradeTopology
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx.nvds_urt.Topology.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'precheck_id': precheck_id,
                            'cluster_id': cluster_id,
                            'compute_manager_id': compute_manager_id,
                            'show_vds_config': show_vds_config,
                            })

    def revert(self,
               upgrade_topology,
               ):
        """
        This will revert corresponding VDS to PENDING_TOPOLOGY state. User can
        revert the entire topology all together or can revert partially
        depending on which TrasportNodes user does not want to upgrade to VDS.

        .. deprecated:: unknown

        :type  upgrade_topology: :class:`com.vmware.nsx.model_client.UpgradeTopology`
        :param upgrade_topology: (required)
        :rtype: :class:`com.vmware.nsx.model_client.UpgradeTopology`
        :return: com.vmware.nsx.model.UpgradeTopology
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx.nvds_urt.Topology.revert is deprecated.', DeprecationWarning)
        return self._invoke('revert',
                            {
                            'upgrade_topology': upgrade_topology,
                            })
class TopologyByCluster(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.nvds_urt.topology_by_cluster'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _TopologyByClusterStub)
        self._VAPI_OPERATION_IDS = {}


    def apply(self,
              precheck_id,
              upgrade_topology,
              cluster_id=None,
              use_recommended_topology_config=None,
              ):
        """
        Set VDS configuration and create it in vCenter

        .. deprecated:: unknown

        :type  precheck_id: :class:`str`
        :param precheck_id: (required)
        :type  upgrade_topology: :class:`com.vmware.nsx.model_client.UpgradeTopology`
        :param upgrade_topology: (required)
        :type  cluster_id: :class:`str` or ``None``
        :param cluster_id: cluster identifier (optional)
        :type  use_recommended_topology_config: :class:`bool` or ``None``
        :param use_recommended_topology_config: Flag to indicate if use recommended topology got from the latest
            precheck (optional)
        :rtype: :class:`com.vmware.nsx.model_client.UpgradeTopology`
        :return: com.vmware.nsx.model.UpgradeTopology
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx.nvds_urt.TopologyByCluster.apply is deprecated.', DeprecationWarning)
        return self._invoke('apply',
                            {
                            'precheck_id': precheck_id,
                            'upgrade_topology': upgrade_topology,
                            'cluster_id': cluster_id,
                            'use_recommended_topology_config': use_recommended_topology_config,
                            })

    def get(self,
            precheck_id,
            cluster_id=None,
            compute_manager_id=None,
            show_vds_config=None,
            ):
        """
        Recommmended topology

        .. deprecated:: unknown

        :type  precheck_id: :class:`str`
        :param precheck_id: (required)
        :type  cluster_id: :class:`str` or ``None``
        :param cluster_id: cluster identifier (optional)
        :type  compute_manager_id: :class:`str` or ``None``
        :param compute_manager_id: vCenter identifier (optional)
        :type  show_vds_config: :class:`bool` or ``None``
        :param show_vds_config: Flag to indicate if VdsTopology should contain VDS configuration
            (optional)
        :rtype: :class:`com.vmware.nsx.model_client.UpgradeTopology`
        :return: com.vmware.nsx.model.UpgradeTopology
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx.nvds_urt.TopologyByCluster.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'precheck_id': precheck_id,
                            'cluster_id': cluster_id,
                            'compute_manager_id': compute_manager_id,
                            'show_vds_config': show_vds_config,
                            })
class _PrecheckStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for create operation
        create_input_type = type.StructType('operation-input', {
            'tolerate_different_configurations': type.OptionalType(type.BooleanType()),
        })
        create_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        create_input_value_validator_list = [
        ]
        create_output_validator_list = [
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/nvds-urt/precheck',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
                'tolerate_different_configurations': 'tolerate_different_configurations',
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {})
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/nvds-urt/precheck',
            path_variables={
            },
             header_parameters={
             },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'create': {
                'input_type': create_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'NvdsUpgradePrecheckId'),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'NvdsUpgradePrecheckId'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'create': create_rest_metadata,
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.nvds_urt.precheck',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _PrecheckByClusterStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for create operation
        create_input_type = type.StructType('operation-input', {
            'cluster_id': type.StringType(),
            'tolerate_different_configurations': type.OptionalType(type.BooleanType()),
        })
        create_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        create_input_value_validator_list = [
        ]
        create_output_validator_list = [
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/nvds-urt/precheck-by-cluster/{cluster_id}',
            path_variables={
                'cluster_id': 'cluster_id',
            },
             header_parameters={
                 },
            query_parameters={
                'tolerate_different_configurations': 'tolerate_different_configurations',
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'cluster_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/nvds-urt/precheck-by-cluster/{cluster_id}',
            path_variables={
                'cluster_id': 'cluster_id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'create': {
                'input_type': create_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'NvdsUpgradePrecheckId'),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'NvdsUpgradePrecheckId'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'create': create_rest_metadata,
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.nvds_urt.precheck_by_cluster',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _PrecheckByClustersStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for create operation
        create_input_type = type.StructType('operation-input', {
            'precheck_parameters': type.ReferenceType('com.vmware.nsx.model_client', 'PrecheckParameters'),
            'tolerate_different_configurations': type.OptionalType(type.BooleanType()),
        })
        create_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        create_input_value_validator_list = [
        ]
        create_output_validator_list = [
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/nvds-urt/precheck-by-clusters',
            request_body_parameter='precheck_parameters',
            path_variables={
            },
             header_parameters={
                 },
            query_parameters={
                'tolerate_different_configurations': 'tolerate_different_configurations',
            },
            content_type='application/json'
        )

        operations = {
            'create': {
                'input_type': create_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'NvdsUpgradePrecheckId'),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'create': create_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.nvds_urt.precheck_by_clusters',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _StatusSummaryStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'precheck_id': type.StringType(),
            'cluster_id': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/nvds-urt/status-summary/{precheck-id}',
            path_variables={
                'precheck_id': 'precheck-id',
            },
             header_parameters={
                 },
            query_parameters={
                'cluster_id': 'cluster_id',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'NvdsUpgradeStatusSummary'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.nvds_urt.status_summary',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _StatusSummaryByClusterStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'precheck_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/nvds-urt/status-summary-by-cluster/{precheck-id}',
            path_variables={
                'precheck_id': 'precheck-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'NvdsUpgradeStatusSummary'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.nvds_urt.status_summary_by_cluster',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _TopologyStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for apply operation
        apply_input_type = type.StructType('operation-input', {
            'upgrade_topology': type.ReferenceType('com.vmware.nsx.model_client', 'UpgradeTopology'),
            'cluster_id': type.OptionalType(type.StringType()),
            'use_recommended_topology_config': type.OptionalType(type.BooleanType()),
        })
        apply_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        apply_input_value_validator_list = [
        ]
        apply_output_validator_list = [
        ]
        apply_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/nvds-urt/topology?action=apply',
            request_body_parameter='upgrade_topology',
            path_variables={
            },
             header_parameters={
                   },
            query_parameters={
                'cluster_id': 'cluster_id',
                'use_recommended_topology_config': 'use_recommended_topology_config',
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'precheck_id': type.StringType(),
            'cluster_id': type.OptionalType(type.StringType()),
            'compute_manager_id': type.OptionalType(type.StringType()),
            'show_vds_config': type.OptionalType(type.BooleanType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/nvds-urt/topology/{precheck-id}',
            path_variables={
                'precheck_id': 'precheck-id',
            },
             header_parameters={
                     },
            query_parameters={
                'cluster_id': 'cluster_id',
                'compute_manager_id': 'compute_manager_id',
                'show_vds_config': 'show_vds_config',
            },
            content_type='application/json'
        )

        # properties for revert operation
        revert_input_type = type.StructType('operation-input', {
            'upgrade_topology': type.ReferenceType('com.vmware.nsx.model_client', 'UpgradeTopology'),
        })
        revert_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        revert_input_value_validator_list = [
        ]
        revert_output_validator_list = [
        ]
        revert_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/nvds-urt/topology?action=revert',
            request_body_parameter='upgrade_topology',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'apply': {
                'input_type': apply_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'UpgradeTopology'),
                'errors': apply_error_dict,
                'input_value_validator_list': apply_input_value_validator_list,
                'output_validator_list': apply_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'UpgradeTopology'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'revert': {
                'input_type': revert_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'UpgradeTopology'),
                'errors': revert_error_dict,
                'input_value_validator_list': revert_input_value_validator_list,
                'output_validator_list': revert_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'apply': apply_rest_metadata,
            'get': get_rest_metadata,
            'revert': revert_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.nvds_urt.topology',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _TopologyByClusterStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for apply operation
        apply_input_type = type.StructType('operation-input', {
            'precheck_id': type.StringType(),
            'upgrade_topology': type.ReferenceType('com.vmware.nsx.model_client', 'UpgradeTopology'),
            'cluster_id': type.OptionalType(type.StringType()),
            'use_recommended_topology_config': type.OptionalType(type.BooleanType()),
        })
        apply_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        apply_input_value_validator_list = [
        ]
        apply_output_validator_list = [
        ]
        apply_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/nvds-urt/topology-by-cluster/{precheck-id}?action=apply',
            request_body_parameter='upgrade_topology',
            path_variables={
                'precheck_id': 'precheck-id',
            },
             header_parameters={
                     },
            query_parameters={
                'cluster_id': 'cluster_id',
                'use_recommended_topology_config': 'use_recommended_topology_config',
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'precheck_id': type.StringType(),
            'cluster_id': type.OptionalType(type.StringType()),
            'compute_manager_id': type.OptionalType(type.StringType()),
            'show_vds_config': type.OptionalType(type.BooleanType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/nvds-urt/topology-by-cluster/{precheck-id}',
            path_variables={
                'precheck_id': 'precheck-id',
            },
             header_parameters={
                     },
            query_parameters={
                'cluster_id': 'cluster_id',
                'compute_manager_id': 'compute_manager_id',
                'show_vds_config': 'show_vds_config',
            },
            content_type='application/json'
        )

        operations = {
            'apply': {
                'input_type': apply_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'UpgradeTopology'),
                'errors': apply_error_dict,
                'input_value_validator_list': apply_input_value_validator_list,
                'output_validator_list': apply_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'UpgradeTopology'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'apply': apply_rest_metadata,
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.nvds_urt.topology_by_cluster',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'Precheck': Precheck,
        'PrecheckByCluster': PrecheckByCluster,
        'PrecheckByClusters': PrecheckByClusters,
        'StatusSummary': StatusSummary,
        'StatusSummaryByCluster': StatusSummaryByCluster,
        'Topology': Topology,
        'TopologyByCluster': TopologyByCluster,
    }

