/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.util.BaseUtilities;

public class ArchiveURLMapper
extends URLMapper {
    private static final Logger LOG = Logger.getLogger(ArchiveURLMapper.class.getName());
    private static final String JAR_PROTOCOL = "jar";
    private static final Map<File, SoftReference<JarFileSystem>> mountRoots = new ConcurrentHashMap<File, SoftReference<JarFileSystem>>();
    private static final Map<URI, File> copiedJARs = new HashMap<URI, File>();

    public URL getURL(FileObject fileObject, int n) {
        assert (fileObject != null);
        if ((n == 1 || n == 0) && fileObject.isValid()) {
            File file = null;
            try {
                JarFileSystem jarFileSystem;
                FileSystem fileSystem = fileObject.getFileSystem();
                if (fileSystem instanceof JarFileSystem && ArchiveURLMapper.isRoot(file = (jarFileSystem = (JarFileSystem)fileSystem).getJarFile())) {
                    try {
                        return new URL("jar:" + BaseUtilities.toURI((File)file) + "!/" + new URI(null, fileObject.getPath(), null).getRawSchemeSpecificPart() + (fileObject.isFolder() && !fileObject.isRoot() ? "/" : ""));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        String string = new URI(null, fileObject.getPath(), null).toString();
                        return new URL("jar:" + BaseUtilities.toURI((File)file) + "!/" + string + (fileObject.isFolder() && !fileObject.isRoot() ? "/" : ""));
                    }
                }
            }
            catch (Exception exception) {
                LOG.log(Level.INFO, "fo: " + fileObject + " archiveFile: " + file, exception);
            }
        }
        return null;
    }

    public FileObject[] getFileObjects(URL uRL) {
        String string;
        int n;
        assert (uRL != null);
        String string2 = uRL.getProtocol();
        if (JAR_PROTOCOL.equals(string2) && (n = (string = uRL.getPath()).lastIndexOf(33)) >= 0) {
            try {
                URL uRL2;
                URI uRI = new URI(string.substring(0, n));
                try {
                    uRL2 = uRI.toURL();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LOG.log(Level.INFO, "checking " + uRI, illegalArgumentException);
                    return null;
                }
                FileObject fileObject = URLMapper.findFileObject((URL)uRL2);
                if (fileObject == null || fileObject.isVirtual()) {
                    return null;
                }
                File file = FileUtil.toFile((FileObject)fileObject);
                if (file == null) {
                    file = ArchiveURLMapper.copyJAR(fileObject, uRI, false);
                }
                String string3 = string.length() > n + 2 ? URLDecoder.decode(string.substring(n + 2), "UTF-8") : "";
                JarFileSystem jarFileSystem = ArchiveURLMapper.getFileSystem(file);
                FileObject fileObject2 = jarFileSystem.findResource(string3);
                if (fileObject2 != null) {
                    return new FileObject[]{fileObject2};
                }
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "checking " + uRL, iOException);
            }
            catch (URISyntaxException uRISyntaxException) {
                LOG.log(Level.INFO, "Can't get fo for " + uRL, uRISyntaxException);
            }
        }
        return null;
    }

    private static boolean isRoot(File file) {
        return mountRoots.containsKey(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JarFileSystem getFileSystem(File file) throws IOException {
        Map<File, SoftReference<JarFileSystem>> map = mountRoots;
        synchronized (map) {
            Reference reference = mountRoots.get(file);
            JarFileSystem jarFileSystem = null;
            if (reference == null || (jarFileSystem = (JarFileSystem)reference.get()) == null) {
                jarFileSystem = ArchiveURLMapper.findJarFileSystemInRepository(file);
                if (jarFileSystem == null) {
                    File file2 = FileUtil.normalizeFile((File)file);
                    jarFileSystem = new JarFileSystem(file2);
                }
                mountRoots.put(file, new JFSReference(jarFileSystem));
            }
            return jarFileSystem;
        }
    }

    private static JarFileSystem findJarFileSystemInRepository(File file) {
        Enumeration enumeration = Repository.getDefault().getFileSystems();
        while (enumeration.hasMoreElements()) {
            JarFileSystem jarFileSystem;
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            if (!(fileSystem instanceof JarFileSystem) || !file.equals((jarFileSystem = (JarFileSystem)fileSystem).getJarFile())) continue;
            return jarFileSystem;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File copyJAR(FileObject fileObject, URI uRI, boolean bl) throws IOException {
        Map<URI, File> map = copiedJARs;
        synchronized (map) {
            File file = copiedJARs.get(uRI);
            if (file == null || bl) {
                if (file == null) {
                    file = Files.createTempFile("copy", "-" + uRI.toString().replaceFirst(".+/", ""), new FileAttribute[0]).toFile();
                    file = file.getCanonicalFile();
                    file.deleteOnExit();
                }
                try (InputStream inputStream = fileObject.getInputStream();
                     FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    FileUtil.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
                }
                copiedJARs.put(uRI, file);
            }
            return file;
        }
    }

    private static class JFSReference
    extends SoftReference<JarFileSystem> {
        private FileChangeListener fcl;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JFSReference(JarFileSystem jarFileSystem) throws IOException {
            super(jarFileSystem);
            final File file = jarFileSystem.getJarFile();
            URI uRI = null;
            FileObject fileObject = null;
            Map map = copiedJARs;
            synchronized (map) {
                if (copiedJARs.containsValue(file)) {
                    for (Map.Entry entry : copiedJARs.entrySet()) {
                        if (!((File)entry.getValue()).equals(file)) continue;
                        uRI = (URI)entry.getKey();
                        fileObject = URLMapper.findFileObject((URL)uRI.toURL());
                    }
                } else {
                    fileObject = FileUtil.toFileObject((File)file);
                }
            }
            map = uRI;
            if (fileObject != null) {
                this.fcl = new FileChangeAdapter((URI)((Object)map)){
                    final /* synthetic */ URI val$nestedRootURIFinal;
                    {
                        this.val$nestedRootURIFinal = uRI;
                    }

                    public void fileDeleted(FileEvent fileEvent) {
                        this.releaseMe(file);
                    }

                    public void fileRenamed(FileRenameEvent fileRenameEvent) {
                        this.releaseMe(file);
                    }

                    public void fileChanged(FileEvent fileEvent) {
                        if (this.val$nestedRootURIFinal != null) {
                            try {
                                ArchiveURLMapper.copyJAR(fileEvent.getFile(), this.val$nestedRootURIFinal, true);
                                this.releaseMe(file);
                                ArchiveURLMapper.getFileSystem(file);
                            }
                            catch (IOException iOException) {
                                LOG.log(Level.INFO, "Can't copy JAR " + fileEvent.getFile() + " to " + this.val$nestedRootURIFinal, iOException);
                            }
                        }
                    }
                };
                fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.fcl, (Object)fileObject));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseMe(File file) {
            JarFileSystem jarFileSystem = (JarFileSystem)this.get();
            if (jarFileSystem != null) {
                Map map = mountRoots;
                synchronized (map) {
                    File file2 = file != null ? file : jarFileSystem.getJarFile();
                    mountRoots.remove(file2);
                }
            }
        }
    }
}

