/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseProtocolEncoder;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;
import org.traccar.model.Command;

public class CastelProtocolEncoder
extends BaseProtocolEncoder {
    public CastelProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    private ByteBuf encodeContent(long deviceId, short type, ByteBuf content) {
        ByteBuf buf = Unpooled.buffer((int)0);
        String uniqueId = this.getUniqueId(deviceId);
        buf.writeByte(64);
        buf.writeByte(64);
        buf.writeShortLE(27 + content.readableBytes() + 2 + 2);
        buf.writeByte(1);
        buf.writeBytes(uniqueId.getBytes(StandardCharsets.US_ASCII));
        buf.writeZero(20 - uniqueId.length());
        buf.writeShort((int)type);
        buf.writeBytes(content);
        buf.writeShortLE(Checksum.crc16(Checksum.CRC16_X25, buf.nioBuffer()));
        buf.writeByte(13);
        buf.writeByte(10);
        return buf;
    }

    @Override
    protected Object encodeCommand(Command command) {
        ByteBuf content = Unpooled.buffer((int)0);
        return switch (command.getType()) {
            case "engineStop" -> {
                content.writeByte(1);
                yield this.encodeContent(command.getDeviceId(), (short)17795, content);
            }
            case "engineResume" -> {
                content.writeByte(0);
                yield this.encodeContent(command.getDeviceId(), (short)17795, content);
            }
            default -> null;
        };
    }
}

