/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.tracker;

import java.util.Arrays;
import java.util.LinkedHashMap;
import org.ops4j.pax.web.extender.whiteboard.internal.WhiteboardExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.AbstractContextTracker;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.spi.context.WebContainerContextWrapper;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.util.tracker.ServiceTracker;

public class HttpContextTracker
extends AbstractContextTracker<HttpContext> {
    private HttpContextTracker(WhiteboardExtenderContext whiteboardExtenderContext, BundleContext bundleContext) {
        super(whiteboardExtenderContext, bundleContext);
    }

    public static ServiceTracker<HttpContext, OsgiContextModel> createTracker(WhiteboardExtenderContext whiteboardExtenderContext, BundleContext bundleContext) {
        return new HttpContextTracker(whiteboardExtenderContext, bundleContext).create(HttpContext.class);
    }

    @Override
    protected void configureContextModel(ServiceReference<HttpContext> serviceReference, OsgiContextModel model) {
        String scope;
        String value;
        model.setShared(Boolean.valueOf(false));
        String name = Utils.getStringProperty(serviceReference, (String)"httpContext.id");
        if (name == null || "".equals(name.trim())) {
            name = "default";
        }
        model.setName(name);
        String contextPath = Utils.getStringProperty(serviceReference, (String)"httpContext.path");
        if (contextPath == null || "".equals(contextPath.trim())) {
            contextPath = "/";
        }
        model.setContextPath(contextPath);
        LinkedHashMap<String, String> initParams = new LinkedHashMap<String, String>();
        String legacyInitPrefix = Utils.getStringProperty(serviceReference, (String)"init-prefix");
        if (legacyInitPrefix == null) {
            legacyInitPrefix = "init.";
        }
        for (String key : serviceReference.getPropertyKeys()) {
            if (!key.startsWith(legacyInitPrefix) || (value = Utils.getStringProperty(serviceReference, (String)key)) == null) continue;
            initParams.put(key.substring(legacyInitPrefix.length()), value);
        }
        if (initParams.size() == 0) {
            for (String key : serviceReference.getPropertyKeys()) {
                if (!key.startsWith("context.init.") || (value = Utils.getStringProperty(serviceReference, (String)key)) == null) continue;
                initParams.put(key.substring("context.init.".length()), value);
            }
        }
        model.getContextParams().clear();
        model.getContextParams().putAll(initParams);
        model.getContextRegistrationProperties().putAll(Utils.toMap(serviceReference));
        model.getContextRegistrationProperties().put("httpContext.id", name);
        model.getContextRegistrationProperties().put("httpContext.path", contextPath);
        model.getContextRegistrationProperties().put("osgi.http.whiteboard.context.httpservice", name);
        model.getContextRegistrationProperties().put("osgi.http.whiteboard.context.path", contextPath);
        String[] virtualHosts = (String[])Utils.getPaxWebProperty(serviceReference, (String)"httpContext.virtualhosts", null, (n, v) -> Utils.asStringArray((String)n, (Object)v, (boolean)true));
        String[] connectors = (String[])Utils.getPaxWebProperty(serviceReference, (String)"httpContext.connectors", null, (n, v) -> Utils.asStringArray((String)n, (Object)v, (boolean)true));
        model.getVirtualHosts().clear();
        model.getConnectors().clear();
        if (virtualHosts != null) {
            model.getVirtualHosts().addAll(Arrays.asList(virtualHosts));
        }
        if (connectors != null) {
            model.getConnectors().addAll(Arrays.asList(connectors));
        }
        if ("singleton".equals(scope = Utils.getStringProperty(serviceReference, (String)"service.scope"))) {
            LOG.debug("Dereferencing singleton service {} to obtain HttpContext instance", serviceReference);
            HttpContext context = (HttpContext)model.getOwnerBundle().getBundleContext().getService(serviceReference);
            if (context instanceof WebContainerContext) {
                model.setHttpContext((WebContainerContext)context);
                model.setShared(Boolean.valueOf(((WebContainerContext)context).isShared()));
                String actualName = ((WebContainerContext)context).getContextId();
                if (!name.equals(actualName)) {
                    LOG.warn("The registered context has name \"{}\", but {} service property was \"{}\". Switching to \"{}\".", new Object[]{actualName, "httpContext.id", name, actualName});
                    model.setName(actualName);
                }
            } else {
                Boolean shared = Utils.getBooleanProperty(serviceReference, (String)"httpContext.shared");
                if (shared != null && shared.booleanValue()) {
                    LOG.warn("{} property is true, but the service is not an instance of WebContainerContext with \"shared\" property. Switching to non-shared.", (Object)context);
                }
                model.setHttpContext((WebContainerContext)new WebContainerContextWrapper(serviceReference.getBundle(), context, name));
                model.setShared(Boolean.valueOf(false));
            }
            model.getContextRegistrationProperties().remove("osgi.http.whiteboard.context.name");
        } else {
            model.setContextReference(serviceReference);
            Boolean shared = Utils.getBooleanProperty(serviceReference, (String)"httpContext.shared");
            if (shared != null) {
                model.setShared(shared);
            }
        }
    }

    @Override
    protected void cleanupContextModel(ServiceReference<HttpContext> serviceReference, OsgiContextModel unpublished) {
        String scope = Utils.getStringProperty(serviceReference, (String)"service.scope");
        if ("singleton".equals(scope)) {
            BundleContext context;
            BundleContext bundleContext = context = unpublished.getOwnerBundle() == null ? null : unpublished.getOwnerBundle().getBundleContext();
            if (context != null) {
                context.ungetService(serviceReference);
            }
        }
    }
}

