/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.core.internal.thing;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.common.registry.RegistryChangedRunnableListener;
import org.openhab.core.config.core.ConfigDescription;
import org.openhab.core.config.core.ConfigDescriptionRegistry;
import org.openhab.core.config.core.ConfigUtil;
import org.openhab.core.config.core.Configuration;
import org.openhab.core.config.core.status.ConfigStatusInfo;
import org.openhab.core.config.core.status.ConfigStatusMessage;
import org.openhab.core.config.core.status.ConfigStatusService;
import org.openhab.core.config.core.validation.ConfigValidationException;
import org.openhab.core.io.rest.DTOMapper;
import org.openhab.core.io.rest.JSONResponse;
import org.openhab.core.io.rest.LocaleService;
import org.openhab.core.io.rest.RESTConstants;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.io.rest.Stream2JSONInputStream;
import org.openhab.core.io.rest.core.thing.EnrichedThingDTO;
import org.openhab.core.io.rest.core.thing.EnrichedThingDTOMapper;
import org.openhab.core.items.ItemFactory;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.ManagedItemProvider;
import org.openhab.core.thing.Channel;
import org.openhab.core.thing.ChannelUID;
import org.openhab.core.thing.ManagedThingProvider;
import org.openhab.core.thing.Thing;
import org.openhab.core.thing.ThingManager;
import org.openhab.core.thing.ThingRegistry;
import org.openhab.core.thing.ThingStatusInfo;
import org.openhab.core.thing.ThingTypeUID;
import org.openhab.core.thing.ThingUID;
import org.openhab.core.thing.UID;
import org.openhab.core.thing.binding.ThingHandler;
import org.openhab.core.thing.binding.firmware.Firmware;
import org.openhab.core.thing.dto.ChannelDTO;
import org.openhab.core.thing.dto.ChannelDTOMapper;
import org.openhab.core.thing.dto.ThingDTO;
import org.openhab.core.thing.dto.ThingDTOMapper;
import org.openhab.core.thing.firmware.FirmwareRegistry;
import org.openhab.core.thing.firmware.FirmwareStatusInfo;
import org.openhab.core.thing.firmware.FirmwareUpdateService;
import org.openhab.core.thing.firmware.dto.FirmwareDTO;
import org.openhab.core.thing.firmware.dto.FirmwareStatusDTO;
import org.openhab.core.thing.i18n.ThingStatusInfoI18nLocalizationService;
import org.openhab.core.thing.link.ItemChannelLinkRegistry;
import org.openhab.core.thing.link.ManagedItemChannelLinkProvider;
import org.openhab.core.thing.type.BridgeType;
import org.openhab.core.thing.type.ChannelType;
import org.openhab.core.thing.type.ChannelTypeRegistry;
import org.openhab.core.thing.type.ChannelTypeUID;
import org.openhab.core.thing.type.ThingType;
import org.openhab.core.thing.type.ThingTypeRegistry;
import org.openhab.core.thing.util.ThingHelper;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="things")
@Tag(name="things")
@Component
@JaxrsResource
@JaxrsName(value="things")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class ThingResource
implements RESTResource {
    private final Logger logger = LoggerFactory.getLogger(ThingResource.class);
    public static final String PATH_THINGS = "things";
    private final DTOMapper dtoMapper;
    private final ChannelTypeRegistry channelTypeRegistry;
    private final ConfigStatusService configStatusService;
    private final ConfigDescriptionRegistry configDescRegistry;
    private final FirmwareRegistry firmwareRegistry;
    private final FirmwareUpdateService firmwareUpdateService;
    private final ItemChannelLinkRegistry itemChannelLinkRegistry;
    private final LocaleService localeService;
    private final ManagedThingProvider managedThingProvider;
    private final ThingManager thingManager;
    private final ThingRegistry thingRegistry;
    private final ThingStatusInfoI18nLocalizationService thingStatusInfoI18nLocalizationService;
    private final ThingTypeRegistry thingTypeRegistry;
    private final RegistryChangedRunnableListener<Thing> resetLastModifiedChangeListener = new RegistryChangedRunnableListener(() -> {
        Date date = this.lastModified = null;
    });
    @Context
    @NonNullByDefault(value={})
    private UriInfo uriInfo;
    private @Nullable Date lastModified = null;

    @Activate
    public ThingResource(@Reference DTOMapper dtoMapper, @Reference ChannelTypeRegistry channelTypeRegistry, @Reference ConfigStatusService configStatusService, @Reference ConfigDescriptionRegistry configDescRegistry, @Reference FirmwareRegistry firmwareRegistry, @Reference FirmwareUpdateService firmwareUpdateService, @Reference ItemChannelLinkRegistry itemChannelLinkRegistry, @Reference ItemFactory itemFactory, @Reference ItemRegistry itemRegistry, @Reference LocaleService localeService, @Reference ManagedItemChannelLinkProvider managedItemChannelLinkProvider, @Reference ManagedItemProvider managedItemProvider, @Reference ManagedThingProvider managedThingProvider, @Reference ThingManager thingManager, @Reference ThingRegistry thingRegistry, @Reference ThingStatusInfoI18nLocalizationService thingStatusInfoI18nLocalizationService, @Reference ThingTypeRegistry thingTypeRegistry) {
        this.dtoMapper = dtoMapper;
        this.channelTypeRegistry = channelTypeRegistry;
        this.configStatusService = configStatusService;
        this.configDescRegistry = configDescRegistry;
        this.firmwareRegistry = firmwareRegistry;
        this.firmwareUpdateService = firmwareUpdateService;
        this.itemChannelLinkRegistry = itemChannelLinkRegistry;
        this.localeService = localeService;
        this.managedThingProvider = managedThingProvider;
        this.thingManager = thingManager;
        this.thingRegistry = thingRegistry;
        this.thingStatusInfoI18nLocalizationService = thingStatusInfoI18nLocalizationService;
        this.thingTypeRegistry = thingTypeRegistry;
        this.thingRegistry.addRegistryChangeListener(this.resetLastModifiedChangeListener);
    }

    @Deactivate
    void deactivate() {
        this.thingRegistry.removeRegistryChangeListener(this.resetLastModifiedChangeListener);
    }

    @POST
    @RolesAllowed(value={"administrator"})
    @Consumes(value={"application/json"})
    @Operation(operationId="createThingInRegistry", summary="Creates a new thing and adds it to the registry.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="201", description="Created", content={@Content(schema=@Schema(implementation=EnrichedThingDTO.class))}), @ApiResponse(responseCode="400", description="Thing uid does not match bridge uid."), @ApiResponse(responseCode="400", description="A uid must be provided, if no binding can create a thing of this type."), @ApiResponse(responseCode="409", description="A thing with the same uid already exists.")})
    public Response create(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @Parameter(description="thing data", required=true) ThingDTO thingBean) {
        Thing thing;
        Thing thing2;
        Locale locale = this.localeService.getLocale(language);
        ThingUID thingUID = thingBean.UID == null ? null : new ThingUID(thingBean.UID);
        ThingTypeUID thingTypeUID = new ThingTypeUID(thingBean.thingTypeUID);
        if (thingUID != null && (thing2 = this.thingRegistry.get(thingUID)) != null) {
            return this.getThingResponse(Response.Status.CONFLICT, thing2, locale, "Thing " + thingUID.toString() + " already exists!");
        }
        ThingUID bridgeUID = null;
        if (thingBean.bridgeUID != null) {
            bridgeUID = new ThingUID(thingBean.bridgeUID);
            if (!(thingUID == null || thingUID.getBindingId().equals(bridgeUID.getBindingId()) && thingUID.getBridgeIds().contains(bridgeUID.getId()))) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Thing UID '" + String.valueOf(thingUID) + "' does not match bridge UID '" + String.valueOf(bridgeUID) + "'")).build();
            }
        }
        Configuration configuration = new Configuration(this.normalizeConfiguration((Map<String, Object>)thingBean.configuration, thingTypeUID, thingUID));
        if (thingUID != null) {
            this.normalizeChannels(thingBean, thingUID);
        }
        if ((thing = this.thingRegistry.createThingOfType(thingTypeUID, thingUID, bridgeUID, thingBean.label, configuration)) != null) {
            if (thingBean.properties != null) {
                for (Map.Entry entry : thingBean.properties.entrySet()) {
                    thing.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (thingBean.channels != null) {
                ArrayList<Channel> channels = new ArrayList<Channel>();
                for (ChannelDTO channelDTO : thingBean.channels) {
                    channels.add(ChannelDTOMapper.map((ChannelDTO)channelDTO));
                }
                ThingHelper.addChannelsToThing((Thing)thing, channels);
            }
            if (thingBean.location != null) {
                thing.setLocation(thingBean.location);
            }
        } else if (thingUID != null) {
            thing = ThingDTOMapper.map((ThingDTO)thingBean, (boolean)(this.thingTypeRegistry.getThingType(thingTypeUID) instanceof BridgeType));
        } else {
            return this.getThingResponse(Response.Status.BAD_REQUEST, thing, locale, "A UID must be provided, since no binding can create the thing!");
        }
        this.thingRegistry.add((Identifiable)thing);
        return this.getThingResponse(Response.Status.CREATED, thing, locale, null);
    }

    @GET
    @RolesAllowed(value={"administrator"})
    @Produces(value={"application/json"})
    @Operation(operationId="getThings", summary="Get all available things.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=EnrichedThingDTO.class), uniqueItems=true))})})
    public Response getAll(@Context Request request, @HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @QueryParam(value="summary") @Parameter(description="summary fields only") @Nullable Boolean summary, @DefaultValue(value="false") @QueryParam(value="staticDataOnly") @Parameter(description="provides a cacheable list of values not expected to change regularly and checks the If-Modified-Since header") boolean staticDataOnly) {
        Locale locale = this.localeService.getLocale(language);
        Stream thingStream = this.thingRegistry.stream().map(t -> this.convertToEnrichedThingDTO((Thing)t, locale)).distinct();
        if (staticDataOnly) {
            if (this.lastModified != null) {
                Response.ResponseBuilder responseBuilder = request.evaluatePreconditions(this.lastModified);
                if (responseBuilder != null) {
                    return responseBuilder.build();
                }
            } else {
                this.lastModified = Date.from(Instant.now().truncatedTo(ChronoUnit.SECONDS));
            }
            thingStream = this.dtoMapper.limitToFields(thingStream, "UID,label,bridgeUID,thingTypeUID,location,editable");
            return Response.ok((Object)new Stream2JSONInputStream(thingStream)).lastModified(this.lastModified).cacheControl(RESTConstants.CACHE_CONTROL).build();
        }
        if (summary != null && summary.booleanValue()) {
            thingStream = this.dtoMapper.limitToFields(thingStream, "UID,label,bridgeUID,thingTypeUID,statusInfo,firmwareStatus,location,editable");
        }
        return Response.ok((Object)new Stream2JSONInputStream(thingStream)).build();
    }

    @GET
    @RolesAllowed(value={"administrator"})
    @Path(value="/{thingUID}")
    @Produces(value={"application/json"})
    @Operation(operationId="getThingById", summary="Gets thing by UID.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=EnrichedThingDTO.class))}), @ApiResponse(responseCode="404", description="Thing not found.")})
    public Response getByUID(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="thingUID") @Parameter(description="thingUID") String thingUID) {
        Locale locale = this.localeService.getLocale(language);
        Thing thing = this.thingRegistry.get(new ThingUID(thingUID));
        if (thing != null) {
            return this.getThingResponse(Response.Status.OK, thing, locale, null);
        }
        return ThingResource.getThingNotFoundResponse(thingUID);
    }

    @DELETE
    @RolesAllowed(value={"administrator"})
    @Path(value="/{thingUID}")
    @Operation(operationId="removeThingById", summary="Removes a thing from the registry. Set 'force' to __true__ if you want the thing to be removed immediately.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK, was deleted."), @ApiResponse(responseCode="202", description="ACCEPTED for asynchronous deletion."), @ApiResponse(responseCode="404", description="Thing not found."), @ApiResponse(responseCode="409", description="Thing could not be deleted because it's not editable.")})
    public Response remove(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="thingUID") @Parameter(description="thingUID") String thingUID, @DefaultValue(value="false") @QueryParam(value="force") @Parameter(description="force") boolean force) {
        Locale locale = this.localeService.getLocale(language);
        ThingUID thingUIDObject = new ThingUID(thingUID);
        Thing thing = this.thingRegistry.get(thingUIDObject);
        if (thing == null) {
            this.logger.info("Received HTTP DELETE request for update at '{}' for the unknown thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return ThingResource.getThingNotFoundResponse(thingUID);
        }
        Thing managed = (Thing)this.managedThingProvider.get((Object)thingUIDObject);
        if (managed == null) {
            this.logger.info("Received HTTP DELETE request for update at '{}' for an unmanaged thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return this.getThingResponse(Response.Status.CONFLICT, thing, locale, "Cannot delete Thing " + thingUID + " as it is not editable.");
        }
        if (force) {
            if (this.thingRegistry.forceRemove(thingUIDObject) == null) {
                return this.getThingResponse(Response.Status.INTERNAL_SERVER_ERROR, thing, locale, "Cannot delete Thing " + thingUID + " for unknown reasons.");
            }
        } else if (this.thingRegistry.remove(thingUIDObject) != null) {
            return this.getThingResponse(Response.Status.ACCEPTED, thing, locale, null);
        }
        return Response.ok(null, (String)"text/plain").build();
    }

    @PUT
    @RolesAllowed(value={"administrator"})
    @Path(value="/{thingUID}")
    @Consumes(value={"application/json"})
    @Operation(operationId="updateThing", summary="Updates a thing.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=EnrichedThingDTO.class))}), @ApiResponse(responseCode="404", description="Thing not found."), @ApiResponse(responseCode="409", description="Thing could not be updated as it is not editable.")})
    public Response update(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="thingUID") @Parameter(description="thingUID") String thingUID, @Parameter(description="thing", required=true) ThingDTO thingBean) throws IOException {
        Locale locale = this.localeService.getLocale(language);
        ThingUID thingUIDObject = new ThingUID(thingUID);
        Thing thing = this.thingRegistry.get(thingUIDObject);
        if (thing == null) {
            this.logger.info("Received HTTP PUT request for update at '{}' for the unknown thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return ThingResource.getThingNotFoundResponse(thingUID);
        }
        Thing managed = (Thing)this.managedThingProvider.get((Object)thingUIDObject);
        if (managed == null) {
            this.logger.info("Received HTTP PUT request for update at '{}' for an unmanaged thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return this.getThingResponse(Response.Status.CONFLICT, thing, locale, "Cannot update Thing " + thingUID + " as it is not editable.");
        }
        thingBean.configuration = this.normalizeConfiguration((Map<String, Object>)thingBean.configuration, thing.getThingTypeUID(), thing.getUID());
        this.normalizeChannels(thingBean, thing.getUID());
        thing = ThingHelper.merge((Thing)thing, (ThingDTO)thingBean);
        Thing oldthing = (Thing)this.managedThingProvider.update((Identifiable)thing);
        if (oldthing == null) {
            return ThingResource.getThingNotFoundResponse(thingUID);
        }
        return this.getThingResponse(Response.Status.OK, thing, locale, null);
    }

    @PUT
    @RolesAllowed(value={"administrator"})
    @Path(value="/{thingUID}/config")
    @Consumes(value={"application/json"})
    @Operation(operationId="updateThingConfig", summary="Updates thing's configuration.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=EnrichedThingDTO.class))}), @ApiResponse(responseCode="400", description="Configuration of the thing is not valid."), @ApiResponse(responseCode="404", description="Thing not found"), @ApiResponse(responseCode="409", description="Thing could not be updated as it is not editable.")})
    public Response updateConfiguration(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="thingUID") @Parameter(description="thing") String thingUID, @Parameter(description="configuration parameters") @Nullable Map<String, Object> configurationParameters) throws IOException {
        Locale locale = this.localeService.getLocale(language);
        ThingUID thingUIDObject = new ThingUID(thingUID);
        Thing thing = this.thingRegistry.get(thingUIDObject);
        if (thing == null) {
            this.logger.info("Received HTTP PUT request for update configuration at '{}' for the unknown thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return ThingResource.getThingNotFoundResponse(thingUID);
        }
        Thing managed = (Thing)this.managedThingProvider.get((Object)thingUIDObject);
        if (managed == null) {
            this.logger.info("Received HTTP PUT request for update configuration at '{}' for an unmanaged thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return this.getThingResponse(Response.Status.CONFLICT, thing, locale, "Cannot update Thing " + thingUID + " as it is not editable.");
        }
        ThingHandler thingHandler = thing.getHandler();
        if (thingHandler == null) {
            this.logger.info("Received HTTP PUT request for update configuration at '{}' for an uninitialized thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return this.getThingResponse(Response.Status.CONFLICT, thing, locale, "Cannot update Thing " + thingUID + " as it is not initialized.");
        }
        try {
            this.thingRegistry.updateConfiguration(thingUIDObject, new Configuration(this.normalizeConfiguration(configurationParameters, thing.getThingTypeUID(), thing.getUID())).getProperties());
        }
        catch (ConfigValidationException ex) {
            this.logger.debug("Config description validation exception occurred for thingUID {} - Messages: {}", (Object)thingUID, (Object)ex.getValidationMessages());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ex.getValidationMessages(locale)).build();
        }
        catch (Exception ex) {
            this.logger.error("Exception during HTTP PUT request for update config at '{}'", (Object)this.uriInfo.getPath(), (Object)ex);
            return JSONResponse.createResponse((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, null, (String)ex.getMessage());
        }
        return this.getThingResponse(Response.Status.OK, thing, locale, null);
    }

    @GET
    @RolesAllowed(value={"administrator"})
    @Path(value="/{thingUID}/status")
    @Produces(value={"application/json"})
    @Operation(operationId="getThingStatus", summary="Gets thing status.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ThingStatusInfo.class))}), @ApiResponse(responseCode="404", description="Thing not found.")})
    public Response getStatus(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="thingUID") @Parameter(description="thing") String thingUID) throws IOException {
        ThingUID thingUIDObject = new ThingUID(thingUID);
        Thing thing = this.thingRegistry.get(thingUIDObject);
        if (thing == null) {
            this.logger.info("Received HTTP GET request for thing config status at '{}' for the unknown thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return ThingResource.getThingNotFoundResponse(thingUID);
        }
        ThingStatusInfo thingStatusInfo = this.thingStatusInfoI18nLocalizationService.getLocalizedThingStatusInfo(thing, this.localeService.getLocale(language));
        return Response.ok().entity((Object)thingStatusInfo).build();
    }

    @PUT
    @RolesAllowed(value={"administrator"})
    @Path(value="/{thingUID}/enable")
    @Consumes(value={"text/plain"})
    @Operation(operationId="enableThing", summary="Sets the thing enabled status.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=EnrichedThingDTO.class))}), @ApiResponse(responseCode="404", description="Thing not found.")})
    public Response setEnabled(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="thingUID") @Parameter(description="thing") String thingUID, @Parameter(description="enabled") String enabled) throws IOException {
        Locale locale = this.localeService.getLocale(language);
        ThingUID thingUIDObject = new ThingUID(thingUID);
        Thing thing = this.thingRegistry.get(thingUIDObject);
        if (thing == null) {
            this.logger.info("Received HTTP PUT request for set enabled at '{}' for the unknown thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return ThingResource.getThingNotFoundResponse(thingUID);
        }
        this.thingManager.setEnabled(thingUIDObject, Boolean.parseBoolean(enabled));
        return this.getThingResponse(Response.Status.OK, thing, locale, null);
    }

    @GET
    @RolesAllowed(value={"administrator"})
    @Path(value="/{thingUID}/config/status")
    @Produces(value={"application/json"})
    @Operation(operationId="getThingConfigStatus", summary="Gets thing config status.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ConfigStatusMessage.class)))}), @ApiResponse(responseCode="404", description="Thing not found.")})
    public Response getConfigStatus(@HeaderParam(value="Accept-Language") @Parameter(description="language") String language, @PathParam(value="thingUID") @Parameter(description="thing") String thingUID) throws IOException {
        ThingUID thingUIDObject = new ThingUID(thingUID);
        Thing thing = this.thingRegistry.get(thingUIDObject);
        if (thing == null) {
            this.logger.info("Received HTTP GET request for thing config status at '{}' for the unknown thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return ThingResource.getThingNotFoundResponse(thingUID);
        }
        ConfigStatusInfo info = this.configStatusService.getConfigStatus(thingUID, this.localeService.getLocale(language));
        if (info != null) {
            return Response.ok().entity((Object)info.getConfigStatusMessages()).build();
        }
        return Response.ok().entity(Set.of()).build();
    }

    @PUT
    @RolesAllowed(value={"administrator"})
    @Path(value="/{thingUID}/firmware/{firmwareVersion}")
    @Consumes(value={"application/json"})
    @Operation(operationId="updateThingFirmware", summary="Update thing firmware.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Firmware update preconditions not satisfied."), @ApiResponse(responseCode="404", description="Thing not found.")})
    public Response updateFirmware(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="thingUID") @Parameter(description="thing") String thingUID, @PathParam(value="firmwareVersion") @Parameter(description="version") String firmwareVersion) throws IOException {
        Thing thing = this.thingRegistry.get(new ThingUID(thingUID));
        if (thing == null) {
            this.logger.info("Received HTTP PUT request for firmware update at '{}' for the unknown thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return ThingResource.getThingNotFoundResponse(thingUID);
        }
        if (firmwareVersion.isEmpty()) {
            this.logger.info("Received HTTP PUT request for firmware update at '{}' for thing '{}' with unknown firmware version '{}'.", new Object[]{this.uriInfo.getPath(), thingUID, firmwareVersion});
            return JSONResponse.createResponse((Response.StatusType)Response.Status.BAD_REQUEST, null, (String)"Firmware version is empty");
        }
        try {
            this.firmwareUpdateService.updateFirmware(thing.getUID(), firmwareVersion, this.localeService.getLocale(language));
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            return JSONResponse.createResponse((Response.StatusType)Response.Status.BAD_REQUEST, null, (String)"Firmware update preconditions not satisfied.");
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @RolesAllowed(value={"administrator"})
    @Path(value="/{thingUID}/firmware/status")
    @Operation(operationId="getThingFirmwareStatus", summary="Gets thing's firmware status.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=FirmwareStatusDTO.class))}), @ApiResponse(responseCode="204", description="No firmware status provided by this Thing.")})
    public Response getFirmwareStatus(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="thingUID") @Parameter(description="thing") String thingUID) throws IOException {
        ThingUID thingUIDObject = new ThingUID(thingUID);
        FirmwareStatusDTO firmwareStatusDto = this.getThingFirmwareStatusInfo(thingUIDObject);
        if (firmwareStatusDto == null) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        return Response.ok((Object)firmwareStatusDto, (String)"application/json").build();
    }

    @GET
    @RolesAllowed(value={"administrator"})
    @Path(value="/{thingUID}/firmwares")
    @Produces(value={"application/json"})
    @Operation(operationId="getAvailableFirmwaresForThing", summary="Get all available firmwares for provided thing UID", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=FirmwareDTO.class), uniqueItems=true))}), @ApiResponse(responseCode="204", description="No firmwares found.")})
    public Response getFirmwares(@PathParam(value="thingUID") @Parameter(description="thingUID") String thingUID, @HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language) {
        ThingUID aThingUID = new ThingUID(thingUID);
        Thing thing = this.thingRegistry.get(aThingUID);
        if (thing == null) {
            this.logger.info("Received HTTP GET request for listing available firmwares at {} for unknown thing with UID '{}'", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return ThingResource.getThingNotFoundResponse(thingUID);
        }
        Collection firmwares = this.firmwareRegistry.getFirmwares(thing, this.localeService.getLocale(language));
        if (firmwares.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        Stream<FirmwareDTO> firmwareStream = firmwares.stream().map(this::convertToFirmwareDTO);
        return Response.ok().entity((Object)new Stream2JSONInputStream(firmwareStream)).build();
    }

    private FirmwareDTO convertToFirmwareDTO(Firmware firmware) {
        return new FirmwareDTO(firmware.getThingTypeUID().getAsString(), firmware.getVendor(), firmware.getModel(), firmware.isModelRestricted(), firmware.getDescription(), firmware.getVersion(), firmware.getPrerequisiteVersion(), firmware.getChangelog());
    }

    private @Nullable FirmwareStatusDTO getThingFirmwareStatusInfo(ThingUID thingUID) {
        FirmwareStatusInfo info = this.firmwareUpdateService.getFirmwareStatusInfo(thingUID);
        if (info != null) {
            return this.buildFirmwareStatusDTO(info);
        }
        return null;
    }

    private FirmwareStatusDTO buildFirmwareStatusDTO(FirmwareStatusInfo info) {
        return new FirmwareStatusDTO(info.getFirmwareStatus().name(), info.getUpdatableFirmwareVersion());
    }

    private static Response getThingNotFoundResponse(String thingUID) {
        String message = "Thing " + thingUID + " does not exist!";
        return JSONResponse.createResponse((Response.StatusType)Response.Status.NOT_FOUND, null, (String)message);
    }

    private Response getThingResponse(Response.Status status, @Nullable Thing thing, Locale locale, @Nullable String errormessage) {
        ThingStatusInfo thingStatusInfo = this.thingStatusInfoI18nLocalizationService.getLocalizedThingStatusInfo(thing, locale);
        boolean managed = thing != null && this.managedThingProvider.get((Object)thing.getUID()) != null;
        EnrichedThingDTO enrichedThingDTO = thing != null ? EnrichedThingDTOMapper.map(thing, thingStatusInfo, this.getThingFirmwareStatusInfo(thing.getUID()), this.getLinkedItemsMap(thing), managed) : null;
        return JSONResponse.createResponse((Response.StatusType)status, enrichedThingDTO, (String)errormessage);
    }

    private EnrichedThingDTO convertToEnrichedThingDTO(Thing thing, Locale locale) {
        boolean managed = this.managedThingProvider.get((Object)thing.getUID()) != null;
        ThingStatusInfo thingStatusInfo = this.thingStatusInfoI18nLocalizationService.getLocalizedThingStatusInfo(thing, locale);
        return EnrichedThingDTOMapper.map(thing, thingStatusInfo, this.getThingFirmwareStatusInfo(thing.getUID()), this.getLinkedItemsMap(thing), managed);
    }

    private Map<String, Set<String>> getLinkedItemsMap(Thing thing) {
        HashMap<String, Set<String>> linkedItemsMap = new HashMap<String, Set<String>>();
        for (Channel channel : thing.getChannels()) {
            Set linkedItems = this.itemChannelLinkRegistry.getLinkedItemNames((UID)channel.getUID());
            linkedItemsMap.put(channel.getUID().getId(), linkedItems);
        }
        return linkedItemsMap;
    }

    private @Nullable Map<String, Object> normalizeConfiguration(@Nullable Map<String, Object> properties, ThingTypeUID thingTypeUID, @Nullable ThingUID thingUID) {
        ConfigDescription thingConfigDesc;
        ConfigDescription typeConfigDesc;
        if (properties == null || properties.isEmpty()) {
            return properties;
        }
        ThingType thingType = this.thingTypeRegistry.getThingType(thingTypeUID);
        if (thingType == null) {
            return properties;
        }
        ArrayList<ConfigDescription> configDescriptions = new ArrayList<ConfigDescription>(2);
        URI descURI = thingType.getConfigDescriptionURI();
        if (descURI != null && (typeConfigDesc = this.configDescRegistry.getConfigDescription(descURI)) != null) {
            configDescriptions.add(typeConfigDesc);
        }
        if (thingUID != null && (thingConfigDesc = this.configDescRegistry.getConfigDescription(this.getConfigDescriptionURI(thingUID))) != null) {
            configDescriptions.add(thingConfigDesc);
        }
        if (configDescriptions.isEmpty()) {
            return properties;
        }
        return ConfigUtil.normalizeTypes(properties, configDescriptions);
    }

    private @Nullable Map<String, Object> normalizeConfiguration(Map<String, Object> properties, ChannelTypeUID channelTypeUID, ChannelUID channelUID) {
        ConfigDescription channelConfigDesc;
        ConfigDescription typeConfigDesc;
        if (properties == null || properties.isEmpty()) {
            return properties;
        }
        ChannelType channelType = this.channelTypeRegistry.getChannelType(channelTypeUID);
        if (channelType == null) {
            return properties;
        }
        ArrayList<ConfigDescription> configDescriptions = new ArrayList<ConfigDescription>(2);
        URI descURI = channelType.getConfigDescriptionURI();
        if (descURI != null && (typeConfigDesc = this.configDescRegistry.getConfigDescription(descURI)) != null) {
            configDescriptions.add(typeConfigDesc);
        }
        if (this.getConfigDescriptionURI(channelUID) != null && (channelConfigDesc = this.configDescRegistry.getConfigDescription(this.getConfigDescriptionURI(channelUID))) != null) {
            configDescriptions.add(channelConfigDesc);
        }
        if (configDescriptions.isEmpty()) {
            return properties;
        }
        return ConfigUtil.normalizeTypes(properties, configDescriptions);
    }

    private void normalizeChannels(ThingDTO thingBean, ThingUID thingUID) {
        if (thingBean.channels != null) {
            for (ChannelDTO channelBean : thingBean.channels) {
                if (channelBean.channelTypeUID == null) continue;
                channelBean.configuration = this.normalizeConfiguration((Map<String, Object>)channelBean.configuration, new ChannelTypeUID(channelBean.channelTypeUID), new ChannelUID(thingUID, channelBean.id));
            }
        }
    }

    private URI getConfigDescriptionURI(ThingUID thingUID) {
        String uriString = "thing:" + String.valueOf(thingUID);
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new BadRequestException("Invalid URI syntax: " + uriString);
        }
    }

    private URI getConfigDescriptionURI(ChannelUID channelUID) {
        String uriString = "channel:" + String.valueOf(channelUID);
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new BadRequestException("Invalid URI syntax: " + uriString);
        }
    }
}

