/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CBSystemProperties {
    private static Logger log = Logger.getLogger(CBSystemProperties.class.getName());

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        if (os != null && os.toLowerCase().indexOf("windows") > -1) {
            log.fine("this is a windows machine.");
            return true;
        }
        log.fine("this is a unix machine.");
        return false;
    }

    private static void writeBatchFile(String batchFileName) throws IOException {
        File setBatch = new File(batchFileName);
        if (!setBatch.exists()) {
            FileWriter out = new FileWriter(setBatch);
            out.write("set", 0, 3);
            out.flush();
            out.close();
        }
    }

    private static void deleteBatchFile(String batchFileName) {
        File setBatch = new File(batchFileName);
        try {
            setBatch.delete();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "unable to delete batch file " + batchFileName, e);
        }
    }

    private static void readSystemProperties(String batchFileName) throws IOException {
        Process bloop = Runtime.getRuntime().exec(batchFileName);
        BufferedReader input = new BufferedReader(new InputStreamReader(bloop.getInputStream()));
        BufferedReader errors = new BufferedReader(new InputStreamReader(bloop.getErrorStream()));
        String line = "";
        log.fine("reading output from batch file");
        CBSystemProperties.setSystemPropertiesFromBufferedReader(input);
        while ((line = errors.readLine()) != null) {
            System.out.println("ERRORS: " + line);
        }
    }

    private static void setSystemPropertiesFromBufferedReader(BufferedReader input) throws IOException {
        String line;
        while ((line = input.readLine()) != null) {
            log.finest("read raw line: " + line);
            int pos = line.indexOf(61);
            if (pos <= 0) continue;
            String name = line.substring(0, pos);
            String value = line.length() > pos ? line.substring(pos + 1).trim() : "";
            if (System.getProperty(name) == null) {
                System.setProperty(name, value);
                log.fine("SET setting property '" + name + "' equal '" + value + "'");
                continue;
            }
            log.fine("skipping existing value for: " + name);
        }
    }

    private static void dumpProperties() {
        Enumeration<?> keys = System.getProperties().propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            log.fine("SYSPROPS: " + key + " : " + System.getProperty(key));
        }
    }

    public static boolean loadSystemProperties(File propertiesListFile) {
        if (!propertiesListFile.exists()) {
            log.warning("Unable to find system properties file: '" + propertiesListFile.toString() + "' - attempting batch load instead");
            return CBSystemProperties.loadSystemProperties();
        }
        try {
            CBSystemProperties.setSystemPropertiesFromBufferedReader(new BufferedReader(new FileReader(propertiesListFile)));
            CBSystemProperties.dumpProperties();
            return true;
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Error trying to load system properties file '" + propertiesListFile.toString() + "' - - attempting batch load instead.", e);
            return CBSystemProperties.loadSystemProperties();
        }
    }

    public static boolean loadSystemProperties() {
        try {
            String batchFileName = CBSystemProperties.isWindows() ? "runset.bat" : "runset.sh";
            CBSystemProperties.writeBatchFile(batchFileName);
            CBSystemProperties.readSystemProperties(batchFileName);
            CBSystemProperties.dumpProperties();
            CBSystemProperties.deleteBatchFile(batchFileName);
            return true;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error reading system properties...\n", e);
            return false;
        }
    }

    public static void main(String[] argsv) {
        log.addHandler(new ConsoleHandler());
        log.setLevel(Level.FINEST);
        log.fine("CBSystemProperties log active");
        CBSystemProperties.loadSystemProperties();
    }
}

