/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.elgamal;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import net.i2p.crypto.SHA256Generator;
import net.i2p.crypto.SigUtil;
import net.i2p.crypto.elgamal.ElGamalKey;
import net.i2p.crypto.elgamal.ElGamalPrivateKey;
import net.i2p.crypto.elgamal.ElGamalPublicKey;
import net.i2p.util.NativeBigInteger;
import net.i2p.util.RandomSource;

public final class ElGamalSigEngine
extends Signature {
    private final MessageDigest digest;
    private ElGamalKey key;

    public ElGamalSigEngine() {
        this(SHA256Generator.getDigestInstance());
    }

    public ElGamalSigEngine(MessageDigest digest) {
        super("ElGamal");
        this.digest = digest;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.digest.reset();
        if (!(privateKey instanceof ElGamalPrivateKey)) {
            throw new InvalidKeyException("cannot identify ElGamal private key: " + privateKey.getClass());
        }
        ElGamalPrivateKey privKey = (ElGamalPrivateKey)privateKey;
        this.key = privKey;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.digest.reset();
        if (!(publicKey instanceof ElGamalPublicKey)) {
            throw new InvalidKeyException("cannot identify ElGamal public key: " + publicKey.getClass());
        }
        this.key = (ElGamalPublicKey)publicKey;
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.digest.update(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.digest.update(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] rv;
        BigInteger k;
        boolean ok;
        BigInteger elgp = this.key.getParams().getP();
        BigInteger pm1 = elgp.subtract(BigInteger.ONE);
        BigInteger elgg = this.key.getParams().getG();
        BigInteger x = ((ElGamalPrivateKey)this.key).getX();
        if (!(x instanceof NativeBigInteger)) {
            x = new NativeBigInteger(x);
        }
        byte[] data = this.digest.digest();
        do {
            ok = (k = new BigInteger(2048, RandomSource.getInstance())).compareTo(pm1) == -1;
            ok = ok && k.compareTo(BigInteger.ONE) == 1;
        } while (!(ok = ok && k.gcd(pm1).equals(BigInteger.ONE)));
        BigInteger r = elgg.modPow(k, elgp);
        BigInteger kinv = k.modInverse(pm1);
        NativeBigInteger h = new NativeBigInteger(1, data);
        BigInteger s = kinv.multiply(h.subtract(x.multiply(r))).mod(pm1);
        try {
            rv = SigUtil.sigBytesToASN1(r, s);
        }
        catch (IllegalArgumentException iae) {
            throw new SignatureException("ASN1", iae);
        }
        return rv;
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        BigInteger elgp = this.key.getParams().getP();
        BigInteger pm1 = elgp.subtract(BigInteger.ONE);
        BigInteger elgg = this.key.getParams().getG();
        BigInteger y = ((ElGamalPublicKey)this.key).getY();
        if (!(y instanceof NativeBigInteger)) {
            y = new NativeBigInteger(y);
        }
        byte[] data = this.digest.digest();
        try {
            NativeBigInteger[] rs = SigUtil.aSN1ToBigInteger(sigBytes, 256);
            NativeBigInteger r = rs[0];
            NativeBigInteger s = rs[1];
            if (r.signum() != 1 || s.signum() != 1 || r.compareTo(elgp) != -1 || s.compareTo(pm1) != -1) {
                return false;
            }
            NativeBigInteger h = new NativeBigInteger(1, data);
            BigInteger modvalr = ((BigInteger)r).modPow(s, elgp);
            BigInteger modvaly = y.modPow(r, elgp);
            BigInteger modmulval = modvalr.multiply(modvaly).mod(elgp);
            BigInteger v = elgg.modPow(h, elgp);
            boolean ok = v.compareTo(modmulval) == 0;
            return ok;
        }
        catch (RuntimeException e) {
            throw new SignatureException("verify", e);
        }
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }
}

