/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl.critic.impl;

import ca.sqlpower.architect.ddl.critic.CriticAndSettings;
import ca.sqlpower.architect.ddl.critic.CriticFix;
import ca.sqlpower.architect.ddl.critic.Criticism;
import ca.sqlpower.architect.ddl.critic.impl.Messages;
import ca.sqlpower.sqlobject.SQLRelationship;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class H2UnsupportedFeaturesCritic
extends CriticAndSettings {
    public H2UnsupportedFeaturesCritic() {
        super(CriticAndSettings.StarterPlatformTypes.H2.getName(), Messages.getString("UnsupportedFeaturesCritic.name", CriticAndSettings.StarterPlatformTypes.H2.getName()));
    }

    @Override
    public List<Criticism> criticize(Object subject) {
        if (!(subject instanceof SQLRelationship)) {
            return Collections.emptyList();
        }
        SQLRelationship r = (SQLRelationship)subject;
        ArrayList<Criticism> criticisms = new ArrayList<Criticism>();
        if (r.getDeleteRule() == SQLRelationship.UpdateDeleteRule.RESTRICT) {
            criticisms.add(new Criticism(subject, Messages.getString("UnsupportedFeaturesCritic.deleteRuleNotSupported", this.getPlatformType(), r.getName()), this, new CriticFix[0]));
        }
        if (r.getUpdateRule() == SQLRelationship.UpdateDeleteRule.RESTRICT) {
            criticisms.add(new Criticism(subject, Messages.getString("UnsupportedFeaturesCritic.updateRuleNotSupported", this.getPlatformType(), r.getName()), this, new CriticFix[0]));
        }
        if (r.getDeferrability() != SQLRelationship.Deferrability.NOT_DEFERRABLE) {
            criticisms.add(new Criticism(subject, Messages.getString("UnsupportedFeaturesCritic.deferrabilityRuleNotSupported", this.getPlatformType(), r.getName()), this, new CriticFix[0]));
        }
        return criticisms;
    }
}

