/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.math.BigDecimal;
import org.w3c.css.atrules.css.media.MediaFeature;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssValue;

public abstract class CssCheckableValue
extends CssValue {
    boolean contains_variable = false;

    public abstract boolean isPositive();

    public abstract boolean isStrictlyPositive();

    public abstract boolean isZero();

    public boolean hasCssVariable() {
        return this.contains_variable;
    }

    public void markCssVariable() {
        this.contains_variable = true;
    }

    public void checkPositiveness(ApplContext ac, String callername) throws InvalidParamException {
        if (!this.isPositive()) {
            throw new InvalidParamException("negative-value", this.toString(), callername, ac);
        }
    }

    public void checkPositiveness(ApplContext ac, CssProperty property) throws InvalidParamException {
        this.checkPositiveness(ac, property.getPropertyName());
    }

    public void checkPositiveness(ApplContext ac, MediaFeature mediafeature) throws InvalidParamException {
        this.checkPositiveness(ac, mediafeature.getFeatureName());
    }

    public void checkStrictPositiveness(ApplContext ac, String callername) throws InvalidParamException {
        if (!this.isStrictlyPositive()) {
            throw new InvalidParamException("strictly-positive", this.toString(), callername, ac);
        }
    }

    public void checkStrictPositiveness(ApplContext ac, MediaFeature mediafeature) throws InvalidParamException {
        this.checkStrictPositiveness(ac, mediafeature.getFeatureName());
    }

    public void checkStrictPositiveness(ApplContext ac, CssProperty property) throws InvalidParamException {
        this.checkStrictPositiveness(ac, property.getPropertyName());
    }

    public boolean warnPositiveness(ApplContext ac, String callername) {
        if (!this.isPositive()) {
            ac.getFrame().addWarning("negative", new String[]{this.toString(), callername});
            return false;
        }
        return true;
    }

    public boolean warnPositiveness(ApplContext ac, CssProperty property) {
        return this.warnPositiveness(ac, property.getPropertyName());
    }

    public boolean warnPositiveness(ApplContext ac, MediaFeature mediafeature) {
        return this.warnPositiveness(ac, mediafeature.getFeatureName());
    }

    public void checkEqualsZero(ApplContext ac, String[] messages) throws InvalidParamException {
        if (!this.isZero()) {
            throw new InvalidParamException("zero", messages, ac);
        }
    }

    public void checkEqualsZero(ApplContext ac, String callername) throws InvalidParamException {
        this.checkEqualsZero(ac, new String[]{this.toString(), callername});
    }

    public void checkEqualsZero(ApplContext ac, CssProperty property) throws InvalidParamException {
        this.checkEqualsZero(ac, property.getPropertyName());
    }

    public void checkEqualsZero(ApplContext ac, MediaFeature mediafeature) throws InvalidParamException {
        this.checkEqualsZero(ac, mediafeature.getFeatureName());
    }

    public boolean warnEqualsZero(ApplContext ac, String[] messages) {
        if (!this.isZero()) {
            ac.getFrame().addWarning("zero", messages);
            return false;
        }
        return true;
    }

    public boolean warnEqualsZero(ApplContext ac, String callername) {
        return this.warnEqualsZero(ac, new String[]{callername});
    }

    public boolean warnEqualsZero(ApplContext ac, CssProperty property) {
        return this.warnEqualsZero(ac, property.getPropertyName());
    }

    public boolean warnEqualsZero(ApplContext ac, MediaFeature mediafeature) {
        return this.warnEqualsZero(ac, mediafeature.getFeatureName());
    }

    public boolean isInteger() {
        return false;
    }

    public void checkInteger(ApplContext ac, String callername) throws InvalidParamException {
    }

    public void checkInteger(ApplContext ac, CssProperty property) throws InvalidParamException {
        this.checkInteger(ac, property.getPropertyName());
    }

    public void checkInteger(ApplContext ac, MediaFeature mediafeature) throws InvalidParamException {
        this.checkPositiveness(ac, mediafeature.getFeatureName());
    }

    public abstract void setValue(BigDecimal var1);

    @Override
    public CssCheckableValue getCheckableValue() {
        return this;
    }
}

