/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.factories.report.flow;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.jfree.report.util.CharacterEntityParser;
import org.jfree.report.util.beans.BeanException;
import org.jfree.report.util.beans.ConverterRegistry;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.Base64;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.PropertyReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AttributeReadHandler
extends PropertyReadHandler {
    private String encoding;
    private String className;
    private Object value;
    private CharacterEntityParser entityParser = CharacterEntityParser.createXMLEntityParser();
    private String namespace;

    protected void doneParsing() throws SAXException {
        super.doneParsing();
        try {
            String string = this.getResult();
            if ("base64".equals(this.encoding)) {
                byte[] byArray = Base64.decode((char[])string.trim().toCharArray());
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                this.value = objectInputStream.readObject();
            } else if (this.className != null) {
                ClassLoader classLoader = ObjectUtilities.getClassLoader(AttributeReadHandler.class);
                Class<?> clazz = classLoader.loadClass(this.className);
                ConverterRegistry.toPropertyValue(this.entityParser.decodeEntities(string), clazz);
            } else {
                ConverterRegistry.toPropertyValue(this.entityParser.decodeEntities(string), String.class);
            }
        }
        catch (BeanException beanException) {
            throw new ParseException("Unable to set attribute '" + this.getName() + "'", (Exception)((Object)beanException), this.getLocator());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ParseException("Unable to set attribute '" + this.getName() + "'", (Exception)classNotFoundException, this.getLocator());
        }
        catch (IOException iOException) {
            throw new ParseException("Unable to set attribute '" + this.getName() + "'", (Exception)iOException, this.getLocator());
        }
    }

    protected void startParsing(Attributes attributes) throws SAXException {
        super.startParsing(attributes);
        this.namespace = attributes.getValue(this.getUri(), "namespace-uri");
        if (this.namespace == null) {
            this.namespace = this.getNamespace();
        }
        this.className = attributes.getValue(this.getUri(), "class");
        if (this.className == null) {
            this.className = "java.lang.String";
        }
        this.encoding = attributes.getValue(this.getUri(), "encoding");
        if (this.encoding == null) {
            this.encoding = "text";
        } else if (!"text".equals(this.encoding) && !"base64".equals(this.encoding)) {
            DebugLog.log((Object)"Invalid value for attribute 'encoding'. Defaulting to 'text'");
            this.encoding = "text";
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Object getObject() {
        return this.value;
    }
}

