/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.threads;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.graalvm.visualvm.lib.charts.axis.TimeAxisUtils;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.swing.renderer.BaseRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.threads.ViewManager;

public class TimelineHeaderRenderer
extends BaseRenderer
implements TableCellRenderer {
    private final TableCellRenderer impl;
    private final int column;
    private final ViewManager view;
    private static LabelRenderer painter;
    private static int Y_LAF_OFFSET;

    public TimelineHeaderRenderer(TableCellRenderer impl, int column, ViewManager view) {
        this.impl = impl;
        this.column = column;
        this.view = view;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        boolean timelineColumn = this.column == table.convertColumnIndexToModel(col);
        this.setVisible(timelineColumn);
        Component c = this.impl.getTableCellRendererComponent(table, timelineColumn ? " " : value, isSelected, hasFocus, row, col);
        if (timelineColumn) {
            if (this.getParent() == null && c instanceof Container) {
                ((Container)c).add(this);
            }
            JTableHeader header = table.getTableHeader();
            if (painter == null) {
                TimelineHeaderRenderer.initStaticUI(c, header);
            }
            TableColumn _column = header.getColumnModel().getColumn(col);
            this.setSize(_column.getWidth(), header.getSize().height);
        }
        return c;
    }

    @Override
    public void paint(Graphics g) {
        long time = this.view.getFirstTimeMark(true);
        long step = this.view.getTimeMarksStep();
        String format = this.view.getTimeMarksFormat();
        int w = this.getWidth();
        int h = this.getHeight();
        int x = this.view.getTimePosition(time, true);
        g.setColor(painter.getForeground());
        int oldX = x;
        while (x < w) {
            this.paintTimeMark(x, TimeAxisUtils.formatTime((Long)time, (String)format), h, g);
            x = this.view.getTimePosition(time += step, true);
            if (x <= oldX) break;
            oldX = x;
        }
    }

    private void paintTimeMark(int x, String time, int h, Graphics g) {
        painter.setText(time);
        Dimension d = painter.getPreferredSize();
        painter.setSize(d);
        painter.move(x - d.width / 2, (h - d.height) / 2 + Y_LAF_OFFSET);
        painter.paint(g);
    }

    private static void initStaticUI(Component c, JTableHeader header) {
        Font font;
        painter = new LabelRenderer(true);
        Color color = c.getForeground();
        if (color == null) {
            color = header.getForeground();
        }
        if (color == null) {
            color = UIManager.getColor("TableHeader.foreground");
        }
        if (color != null) {
            painter.setForeground(color);
        }
        if ((font = c.getFont()) == null) {
            font = header.getFont();
        }
        if (font == null) {
            font = UIManager.getFont("TableHeader.font");
        }
        if (font != null) {
            painter.setFont(font);
        }
        Y_LAF_OFFSET = UIUtils.isWindowsXPLookAndFeel() ? 1 : (UIUtils.isNimbusLookAndFeel() ? -1 : 0);
    }
}

