/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRStringUtil;

public class JRBshGenerator {
    private JasperDesign jasperDesign = null;
    private static Map fieldPrefixMap = null;
    private static Map variablePrefixMap = null;
    private static Map methodSuffixMap = null;

    protected JRBshGenerator(JasperDesign jasperDesign) {
        this.jasperDesign = jasperDesign;
        fieldPrefixMap = new HashMap();
        fieldPrefixMap.put(new Byte(1), "Old");
        fieldPrefixMap.put(new Byte(2), "");
        fieldPrefixMap.put(new Byte(3), "");
        variablePrefixMap = new HashMap();
        variablePrefixMap.put(new Byte(1), "Old");
        variablePrefixMap.put(new Byte(2), "Estimated");
        variablePrefixMap.put(new Byte(3), "");
        methodSuffixMap = new HashMap();
        methodSuffixMap.put(new Byte(1), "Old");
        methodSuffixMap.put(new Byte(2), "Estimated");
        methodSuffixMap.put(new Byte(3), "");
    }

    public static String generateScript(JasperDesign jasperDesign) throws JRException {
        JRBshGenerator jRBshGenerator = new JRBshGenerator(jasperDesign);
        return jRBshGenerator.generateScript();
    }

    protected String generateScript() throws JRException {
        Iterator iterator;
        String string;
        Object object;
        JRVariable[] jRVariableArray;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("//\n");
        stringBuffer.append("// Generated by JasperReports - ");
        stringBuffer.append(new SimpleDateFormat().format(new Date()));
        stringBuffer.append("\n");
        stringBuffer.append("//\n");
        stringBuffer.append("import net.sf.jasperreports.engine.*;\n");
        stringBuffer.append("import net.sf.jasperreports.engine.fill.*;\n");
        stringBuffer.append("\n");
        stringBuffer.append("import java.util.*;\n");
        stringBuffer.append("import java.math.*;\n");
        stringBuffer.append("import java.text.*;\n");
        stringBuffer.append("import java.io.*;\n");
        stringBuffer.append("import java.net.*;\n");
        stringBuffer.append("\n");
        String[] stringArray = this.jasperDesign.getImports();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append("import ");
                stringBuffer.append(stringArray[i]);
                stringBuffer.append(";\n");
            }
        }
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("createBshCalculator()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("    JRCalculator calculator = null;\n");
        stringBuffer.append("\n");
        Map map = this.jasperDesign.getParametersMap();
        if (map != null && map.size() > 0) {
            object2 = map.keySet();
            jRVariableArray = object2.iterator();
            while (jRVariableArray.hasNext()) {
                stringBuffer.append("    JRFillParameter parameter_");
                stringBuffer.append(JRStringUtil.getLiteral((String)jRVariableArray.next()));
                stringBuffer.append(" = null;\n");
            }
        }
        stringBuffer.append("\n");
        object2 = this.jasperDesign.getFieldsMap();
        if (object2 != null && object2.size() > 0) {
            jRVariableArray = object2.keySet();
            object = jRVariableArray.iterator();
            while (object.hasNext()) {
                stringBuffer.append("    JRFillField field_");
                stringBuffer.append(JRStringUtil.getLiteral((String)object.next()));
                stringBuffer.append(" = null;\n");
            }
        }
        stringBuffer.append("\n");
        jRVariableArray = this.jasperDesign.getVariables();
        if (jRVariableArray != null && jRVariableArray.length > 0) {
            for (int i = 0; i < jRVariableArray.length; ++i) {
                stringBuffer.append("    JRFillVariable variable_");
                stringBuffer.append(JRStringUtil.getLiteral(jRVariableArray[i].getName()));
                stringBuffer.append(" = null;\n");
            }
        }
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("    init(\n");
        stringBuffer.append("        JRCalculator calculator,\n");
        stringBuffer.append("        Map parsm,\n");
        stringBuffer.append("        Map fldsm,\n");
        stringBuffer.append("        Map varsm\n");
        stringBuffer.append("        )\n");
        stringBuffer.append("    {\n");
        stringBuffer.append("        super.calculator = calculator;\n");
        stringBuffer.append("\n");
        map = this.jasperDesign.getParametersMap();
        if (map != null && map.size() > 0) {
            object = map.keySet();
            string = null;
            iterator = object.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer.append("        super.parameter_");
                stringBuffer.append(JRStringUtil.getLiteral(string));
                stringBuffer.append(" = (JRFillParameter)parsm.get(\"");
                stringBuffer.append(string);
                stringBuffer.append("\");\n");
            }
        }
        stringBuffer.append("\n");
        object2 = this.jasperDesign.getFieldsMap();
        if (object2 != null && object2.size() > 0) {
            object = object2.keySet();
            string = null;
            iterator = object.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer.append("        super.field_");
                stringBuffer.append(JRStringUtil.getLiteral(string));
                stringBuffer.append(" = (JRFillField)fldsm.get(\"");
                stringBuffer.append(string);
                stringBuffer.append("\");\n");
            }
        }
        stringBuffer.append("\n");
        jRVariableArray = this.jasperDesign.getVariables();
        if (jRVariableArray != null && jRVariableArray.length > 0) {
            object = null;
            for (int i = 0; i < jRVariableArray.length; ++i) {
                object = jRVariableArray[i].getName();
                stringBuffer.append("        super.variable_");
                stringBuffer.append(JRStringUtil.getLiteral((String)object));
                stringBuffer.append(" = (JRFillVariable)varsm.get(\"");
                stringBuffer.append((String)object);
                stringBuffer.append("\");\n");
            }
        }
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append(this.generateMethod((byte)3));
        stringBuffer.append(this.generateMethod((byte)1));
        stringBuffer.append(this.generateMethod((byte)2));
        stringBuffer.append("\n");
        stringBuffer.append("    str(String key)\n");
        stringBuffer.append("    {\n");
        stringBuffer.append("        return super.calculator.str(key);\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("    msg(String pattern, Object arg0)\n");
        stringBuffer.append("    {\n");
        stringBuffer.append("        return super.calculator.msg(pattern, arg0);\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("    msg(String pattern, Object arg0, Object arg1)\n");
        stringBuffer.append("    {\n");
        stringBuffer.append("        return super.calculator.msg(pattern, arg0, arg1);\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("    msg(String pattern, Object arg0, Object arg1, Object arg2)\n");
        stringBuffer.append("    {\n");
        stringBuffer.append("        return super.calculator.msg(pattern, arg0, arg1, arg2);\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("    return this;\n");
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    private String generateMethod(byte by) throws JRException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    Object evaluate");
        stringBuffer.append((String)methodSuffixMap.get(new Byte(by)));
        stringBuffer.append("(int id)\n");
        stringBuffer.append("    {\n");
        stringBuffer.append("        Object value = null;\n");
        stringBuffer.append("\n");
        stringBuffer.append("        switch (id)\n");
        stringBuffer.append("        {\n");
        Collection collection = this.jasperDesign.getExpressions();
        if (collection != null && collection.size() > 0) {
            JRExpression jRExpression2 = null;
            for (JRExpression jRExpression2 : collection) {
                stringBuffer.append("            case ");
                stringBuffer.append(jRExpression2.getId());
                stringBuffer.append(" : // ");
                stringBuffer.append(jRExpression2.getId());
                stringBuffer.append("\n");
                stringBuffer.append("            {\n");
                stringBuffer.append("                value = (");
                stringBuffer.append(jRExpression2.getValueClassName());
                stringBuffer.append(")(");
                stringBuffer.append(this.generateExpression(jRExpression2, by));
                stringBuffer.append(");\n");
                stringBuffer.append("                break;\n");
                stringBuffer.append("            }\n");
            }
        }
        stringBuffer.append("           default :\n");
        stringBuffer.append("           {\n");
        stringBuffer.append("           }\n");
        stringBuffer.append("        }\n");
        stringBuffer.append("        \n");
        stringBuffer.append("        return value;\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private String generateExpression(JRExpression jRExpression, byte by) throws JRException {
        Map map = this.jasperDesign.getParametersMap();
        Map map2 = this.jasperDesign.getFieldsMap();
        Map map3 = this.jasperDesign.getVariablesMap();
        JRParameter jRParameter = null;
        JRField jRField = null;
        JRVariable jRVariable = null;
        StringBuffer stringBuffer = new StringBuffer();
        JRExpressionChunk[] jRExpressionChunkArray = jRExpression.getChunks();
        JRExpressionChunk jRExpressionChunk = null;
        String string = null;
        if (jRExpressionChunkArray != null && jRExpressionChunkArray.length > 0) {
            block7: for (int i = 0; i < jRExpressionChunkArray.length; ++i) {
                jRExpressionChunk = jRExpressionChunkArray[i];
                string = jRExpressionChunk.getText();
                if (string == null) {
                    string = "";
                }
                switch (jRExpressionChunk.getType()) {
                    case 1: {
                        stringBuffer.append(string);
                        continue block7;
                    }
                    case 2: {
                        jRParameter = (JRParameter)map.get(string);
                        stringBuffer.append("((");
                        stringBuffer.append(jRParameter.getValueClassName());
                        stringBuffer.append(")super.parameter_");
                        stringBuffer.append(JRStringUtil.getLiteral(string));
                        stringBuffer.append(".getValue())");
                        continue block7;
                    }
                    case 3: {
                        jRField = (JRField)map2.get(string);
                        stringBuffer.append("((");
                        stringBuffer.append(jRField.getValueClassName());
                        stringBuffer.append(")super.field_");
                        stringBuffer.append(JRStringUtil.getLiteral(string));
                        stringBuffer.append(".get");
                        stringBuffer.append((String)fieldPrefixMap.get(new Byte(by)));
                        stringBuffer.append("Value())");
                        continue block7;
                    }
                    case 4: {
                        jRVariable = (JRVariable)map3.get(string);
                        stringBuffer.append("((");
                        stringBuffer.append(jRVariable.getValueClassName());
                        stringBuffer.append(")super.variable_");
                        stringBuffer.append(JRStringUtil.getLiteral(string));
                        stringBuffer.append(".get");
                        stringBuffer.append((String)variablePrefixMap.get(new Byte(by)));
                        stringBuffer.append("Value())");
                        continue block7;
                    }
                    case 5: {
                        jRParameter = (JRParameter)map.get(string);
                        stringBuffer.append("super.calculator.str(\"");
                        stringBuffer.append(string);
                        stringBuffer.append("\")");
                    }
                }
            }
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }
}

