/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ColumnMappingPanel;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.RelationshipEditPanel;
import ca.sqlpower.architect.swingui.Selectable;
import ca.sqlpower.architect.swingui.TabbedDataEntryPanel;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.action.Messages;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.architect.swingui.event.SelectionListener;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.DataEntryPanelBuilder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class EditRelationshipAction
extends AbstractArchitectAction
implements SelectionListener {
    private static final Logger logger = Logger.getLogger(EditRelationshipAction.class);

    public EditRelationshipAction(ArchitectFrame frame) {
        super(frame, Messages.getString("EditRelationshipAction.name"), Messages.getString("EditRelationshipAction.description"), "edit_relationship");
        this.setEnabled(false);
        frame.addSelectionListener(this);
        this.setupAction(this.getPlaypen().getSelectedItems());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("PlayPen")) {
            List<PlayPenComponent> selection = this.getPlaypen().getSelectedItems();
            if (selection.size() < 1) {
                JOptionPane.showMessageDialog(this.getPlaypen(), Messages.getString("EditRelationshipAction.noRelationshipsSelected"));
            } else if (selection.size() > 1) {
                JOptionPane.showMessageDialog(this.getPlaypen(), Messages.getString("EditRelationshipAction.multipleItemsSelected"));
            } else if (selection.get(0) instanceof Relationship) {
                Relationship r = (Relationship)selection.get(0);
                this.makeDialog(r.getModel());
            } else {
                JOptionPane.showMessageDialog(this.getPlaypen(), Messages.getString("EditRelationshipAction.pleaseSelectRelationship"));
            }
        } else if (evt.getActionCommand().equals("DBTree")) {
            TreePath[] selections = this.getSession().getDBTree().getSelectionPaths();
            if (selections.length < 1) {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("EditRelationshipAction.noRelationshipsSelected"));
            } else if (selections.length > 2) {
                JOptionPane.showMessageDialog(this.getPlaypen(), Messages.getString("EditRelationshipAction.multipleItemsSelected"));
            } else {
                SQLObject secondObj;
                TreePath tp = selections[0];
                SQLObject so = (SQLObject)tp.getLastPathComponent();
                if (selections.length == 2 && !so.equals((Object)(secondObj = (SQLObject)selections[1].getLastPathComponent()))) {
                    JOptionPane.showMessageDialog(this.frame, Messages.getString("EditRelationshipAction.pleaseSelectRelationship"));
                    return;
                }
                if (so instanceof SQLRelationship) {
                    SQLRelationship sr = (SQLRelationship)so;
                    this.makeDialog(sr);
                } else {
                    JOptionPane.showMessageDialog(this.frame, Messages.getString("EditRelationshipAction.pleaseSelectRelationship"));
                }
            }
        }
    }

    private void makeDialog(SQLRelationship sqr) {
        logger.debug((Object)"making edit relationship dialog");
        Relationship r = this.getSession().getPlayPen().getSelectedRelationShips().get(0);
        RelationshipEditPanel editPanel = new RelationshipEditPanel(r);
        ColumnMappingPanel mappingPanel = new ColumnMappingPanel(this.getSession(), sqr);
        TabbedDataEntryPanel panel = new TabbedDataEntryPanel();
        panel.addTab(Messages.getString("EditRelationshipAction.relationshipTab"), (DataEntryPanel)editPanel);
        panel.addTab(Messages.getString("EditRelationshipAction.mappingsTab"), (DataEntryPanel)mappingPanel);
        JDialog editDialog = DataEntryPanelBuilder.createDataEntryPanelDialog((DataEntryPanel)panel, (Component)this.frame, (String)Messages.getString("EditRelationshipAction.dialogTitle"), (String)Messages.getString("EditRelationshipAction.okOption"));
        editPanel.setEditDialog(editDialog);
        editDialog.pack();
        editDialog.setLocationRelativeTo(this.frame);
        editDialog.setVisible(true);
    }

    public void setupAction(List<PlayPenComponent> selectedItems) {
        if (selectedItems.size() == 0) {
            this.setEnabled(false);
            logger.debug((Object)"Disabling edit relationship");
            this.putValue("ShortDescription", Messages.getString("EditRelationshipAction.shortDescription"));
        } else {
            Selectable item = selectedItems.get(0);
            if (item instanceof Relationship) {
                this.setEnabled(true);
            }
        }
    }

    @Override
    public void itemSelected(SelectionEvent e) {
        this.setupAction(this.getPlaypen().getSelectedItems());
    }

    @Override
    public void itemDeselected(SelectionEvent e) {
        this.setupAction(this.getPlaypen().getSelectedItems());
    }
}

