//////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2004-2023 musikcube team
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//    * Redistributions of source code must retain the above copyright notice,
//      this list of conditions and the following disclaimer.
//
//    * Redistributions in binary form must reproduce the above copyright
//      notice, this list of conditions and the following disclaimer in the
//      documentation and/or other materials provided with the distribution.
//
//    * Neither the name of the author nor the names of other contributors may
//      be used to endorse or promote products derived from this software
//      without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//
//////////////////////////////////////////////////////////////////////////////

#pragma once

#include "constants.h"

namespace musik { namespace core { namespace sdk {

    typedef long PositionType;

    class IDataStream {
        public:
            virtual ~IDataStream() {}
            virtual bool Open(const char *uri, OpenFlags flags) = 0;
            virtual bool Close() = 0;
            virtual void Interrupt() = 0;
            virtual void Release() = 0;
            virtual bool Readable() = 0;
            virtual bool Writable() = 0;
            virtual PositionType Read(void *buffer, PositionType readBytes) = 0;
            virtual PositionType Write(void *buffer, PositionType writeBytes) = 0;
            virtual bool SetPosition(PositionType position) = 0;
            virtual PositionType Position() = 0;
            virtual bool Seekable() = 0;
            virtual bool Eof() = 0;
            virtual long Length() = 0;
            virtual const char* Type() = 0;
            virtual const char* Uri() = 0;
            virtual bool CanPrefetch() = 0;
    };

} } }