/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.ServerPortPlaceHolder;
import java.text.MessageFormat;
import java.util.logging.Level;

final class FailoverInfo {
    private String failoverPartner;
    private int portNumber;
    private String failoverInstance;
    private boolean setUpInfocalled;
    private boolean useFailoverPartner;

    boolean getUseFailoverPartner() {
        return this.useFailoverPartner;
    }

    FailoverInfo(String string, SQLServerConnection sQLServerConnection, boolean bl) {
        this.failoverPartner = string;
        this.useFailoverPartner = bl;
        this.portNumber = -1;
    }

    void log(SQLServerConnection sQLServerConnection) {
        if (sQLServerConnection.getConnectionLogger().isLoggable(Level.FINE)) {
            sQLServerConnection.getConnectionLogger().fine(sQLServerConnection.toString() + " Failover server :" + this.failoverPartner + " Failover partner is primary : " + this.useFailoverPartner);
        }
    }

    private void setupInfo(SQLServerConnection sQLServerConnection) throws SQLServerException {
        if (this.setUpInfocalled) {
            return;
        }
        if (0 == this.failoverPartner.length()) {
            this.portNumber = 1433;
        } else {
            int n = this.failoverPartner.indexOf(92);
            String string = null;
            String string2 = null;
            if (n >= 0) {
                if (sQLServerConnection.getConnectionLogger().isLoggable(Level.FINE)) {
                    sQLServerConnection.getConnectionLogger().fine(sQLServerConnection.toString() + " Failover server :" + this.failoverPartner);
                }
                string2 = this.failoverPartner.substring(n + 1, this.failoverPartner.length());
                this.failoverPartner = this.failoverPartner.substring(0, n);
                sQLServerConnection.ValidateMaxSQLLoginName("instanceName", string2);
                this.failoverInstance = string2;
                string = sQLServerConnection.getInstancePort(this.failoverPartner, string2);
                try {
                    this.portNumber = new Integer(string);
                }
                catch (NumberFormatException numberFormatException) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPortNumber"));
                    Object[] objectArray = new Object[]{string};
                    SQLServerException.makeFromDriverError(sQLServerConnection, null, messageFormat.format(objectArray), null, false);
                }
            } else {
                this.portNumber = 1433;
            }
        }
        this.setUpInfocalled = true;
    }

    synchronized ServerPortPlaceHolder failoverPermissionCheck(SQLServerConnection sQLServerConnection, boolean bl) throws SQLServerException {
        this.setupInfo(sQLServerConnection);
        return new ServerPortPlaceHolder(this.failoverPartner, this.portNumber, this.failoverInstance, bl);
    }

    synchronized void failoverAdd(SQLServerConnection sQLServerConnection, boolean bl, String string) throws SQLServerException {
        if (this.useFailoverPartner != bl) {
            if (sQLServerConnection.getConnectionLogger().isLoggable(Level.FINE)) {
                sQLServerConnection.getConnectionLogger().fine(sQLServerConnection.toString() + " Failover detected. failover partner=" + string);
            }
            this.useFailoverPartner = bl;
        }
        if (!bl && !this.failoverPartner.equals(string)) {
            this.failoverPartner = string;
            this.setUpInfocalled = false;
        }
    }
}

