/**
*
* Jquery Mapael - Dynamic maps jQuery plugin (based on raphael.js)
* Requires jQuery and raphael.js
*
* Map of Belgium with provinces and INS codes
*
* @author Antoine DURET
* @source http://commons.wikimedia.org/wiki/File:Belgique_vierge.svg
*
*/
(function($) {
	$.extend(true, $.fn.mapael, 
		{
			maps : {
				belgium : {
					width : 500, 
					height : 500,
					elems : {
						// Hainaut
						"50000" : "m 125.31217,204.93438 -2.81119,0.41211 -0.63048,3.05966 -3.76276,0.58198 -0.78264,3.41156 -4.83892,-2.50434 0.36374,-2.43239 -2.54864,-3.3313 -5.21769,0.16055 -4.57552,-3.21089 -4.736055,2.8898 3.210887,7.06395 3.531978,0.64218 2.8898,3.53197 -2.24763,4.81633 2.24763,10.27484 1.92653,11.55919 3.85306,6.42178 7.70613,4.81633 11.55919,-6.74286 5.45851,0.96326 -3.85306,5.7796 8.99048,-1.92654 7.06395,4.17416 5.45851,8.99048 -1.60544,10.59593 0.93103,6.91222 5.03665,6.00924 1.88064,-2.33727 1.19725,-5.82295 7.50516,-1.16687 6.24656,0.90087 5.13742,4.17415 14.37108,-5.06285 12.60037,11.16354 1.60545,7.38504 3.53197,-0.32109 -0.64218,-5.45851 5.7796,3.53198 0,4.81633 -7.06395,5.4585 0.32109,9.63267 -3.85306,4.49524 2.88979,1.28435 5.7796,-0.64217 0.32109,5.77959 3.53197,6.10069 -4.17415,4.17415 -4.81633,-0.32109 -2.24762,5.7796 3.53197,3.53197 -1.60544,3.85307 5.7796,2.88979 12.20137,-1.92653 15.41226,5.7796 1.28435,-2.56871 -3.85307,-8.3483 -0.32108,-9.63266 -1.92654,-4.17416 -0.96326,-8.02722 2.24762,-1.60544 -1.92653,-4.81633 -2.8898,-2.24762 3.53197,-4.17415 0,-4.49525 0.96327,-3.85306 -3.53197,-1.92653 -3.21089,2.24762 -6.74286,-4.17416 6.42177,-5.4585 6.10068,-2.56871 0.64218,-3.53198 8.34831,1.28436 0.96326,-3.53198 3.53198,0 2.8898,2.56871 7.38504,-2.24762 -0.32109,-2.8898 -0.96327,-5.45851 2.56871,-2.5687 -1.92653,-2.24763 1.92653,-1.60544 1.92653,-4.49524 -2.88979,0 -2.56871,-4.17416 2.56871,-4.49524 -0.64218,-3.53197 -3.53198,-0.32109 0,-3.85306 1.92653,-1.28436 0,-3.21089 -7.70613,2.56871 -1.28435,-2.56871 -3.85306,2.24763 0.96326,-4.81634 -8.99048,-1.60544 -4.17415,0 -3.53198,3.85306 -0.32109,-4.49524 -3.85306,-1.60544 -2.8898,-3.21089 -3.21089,-0.64218 -0.32109,-3.53197 -5.13742,-1.92653 -0.32108,-4.81633 -2.56871,-1.92653 -4.17415,6.42177 -5.45851,-1.60545 0,-5.77959 0.64217,-3.53198 -1.28435,-3.85306 -1.92653,-0.64218 -3.21089,2.24762 -8.99048,2.56871 -5.7796,-1.92653 -3.53198,-3.21089 0.64218,-4.17415 -1.92653,-2.56871 -5.13742,0.96327 -3.53198,-1.60545 -3.53197,0 -2.24762,-4.17415 -4.81633,0.96326 0,-2.24762 -4.17416,1.60545 -4.49524,6.42177 0,4.17416 -4.49524,-3.53198 -6.42177,0 0,-3.21089 -1.28436,-2.24762 -4.81633,1.28436 -4.49524,-2.24763 -3.21089,3.21089 z",
						
						// Flandre Occidentale
						"30000" : "m 92.796002,199.49992 2.976013,4.4712 4.736055,-2.8898 4.57552,3.21089 5.21769,-0.16055 2.54864,3.3313 -0.36374,2.43239 4.83892,2.50434 0.78264,-3.41156 3.76276,-0.58198 0.63048,-3.05966 2.81119,-0.41211 3.21089,-3.21089 3.09747,-2.22357 1.36226,-2.72453 2.72453,-0.45408 1.13522,-1.13522 -2.95157,-4.54088 1.5893,-0.45409 -3.40566,-4.99497 -2.04339,0 -2.27044,-2.95157 2.27044,-0.22704 2.04339,-2.95158 -3.40565,-3.17861 -2.27045,2.04339 -2.49748,-2.27044 1.81635,-2.27044 -0.22704,-2.72453 2.95157,1.58932 0.90817,-1.58932 -2.49748,-0.90817 2.49748,-0.22704 -1.36226,-1.81636 -3.6327,-0.22704 -0.45409,-1.36226 3.40566,-1.81635 -1.81635,-1.81636 1.36226,-2.49748 2.0434,-2.27044 -3.63271,-6.35723 1.58931,-0.45409 0.90818,-1.13522 -6.13019,-4.31384 -5.90314,-4.54088 -0.68114,-1.5893 5.67611,-4.0868 2.72452,-5.6761 -2.0434,-5.90314 -3.17861,-0.90818 2.95157,-2.04339 -1.36226,-3.40566 -0.45409,-1.13522 3.6327,-1.58931 0,-1.81635 -2.49748,-5.90315 0.90817,-1.58931 -2.27044,-2.04339 1.36227,-0.90818 -2.0434,-2.27044 3.85975,-3.405655 -2.27044,-2.72453 0.45409,-2.043397 -1.58931,-2.043393 -15.89308,5.903142 -4.08679,-2.043397 -1.362264,3.405662 -11.806288,4.313838 -2.951572,3.40566 -13.168551,7.7195 -2.27044,0.22704 -3.632704,3.6327 -26.110059,16.12013 -15.211948,7.03836 2.27044,5.22201 1.13522,8.85472 0.681132,3.17861 3.178616,0.90818 -0.227044,2.27044 2.724528,7.49245 -5.449055,4.54088 2.270439,0.68113 0.681132,9.08176 -2.043396,2.72453 2.27044,0 2.043396,6.81132 3.178616,0.68113 0.681132,-2.27044 1.589308,2.04339 3.859748,-0.68112 1.13522,1.13522 0,2.49748 4.086792,4.54088 -0.227044,1.81635 2.497484,2.27044 2.951572,6.58428 4.540879,-1.13522 2.27044,2.95157 0.908176,-1.13522 -3.178616,-4.54088 1.589308,-0.68113 -1.362264,-2.27044 3.632704,-1.58931 2.27044,2.04339 2.951572,-1.36226 0,-1.13522 5.222012,-1.81635 -2.27044,-3.85975 6.357232,-2.72453 2.043396,0.68114 0,4.31383 1.816352,0.68113 -1.135221,1.81636 4.767924,-2.0434 3.178616,2.27044 2.497484,-4.54088 1.816352,1.36226 2.951572,0 0.227044,2.27044 z",
						
						// Flandre Orientale
						"40000" : "m 182.02429,209.03577 -2.12704,-0.8905 -1.92653,-2.56871 -5.13742,0.96327 -3.53198,-1.60545 -3.53197,0 -2.24762,-4.17415 -4.81633,0.96326 0,-2.24762 -4.17416,1.60545 -4.49524,6.42177 0,4.17416 -4.49524,-3.53198 -6.42177,0 0,-3.21089 -1.28436,-2.24762 -4.81633,1.28436 -4.49524,-2.24763 3.09747,-2.22357 1.36226,-2.72453 2.72453,-0.45408 1.13522,-1.13522 -2.95157,-4.54088 1.5893,-0.45409 -3.40566,-4.99497 -2.04339,0 -2.27044,-2.95157 2.27044,-0.22704 2.04339,-2.95158 -3.40565,-3.17861 -2.27045,2.04339 -2.49748,-2.27044 1.81635,-2.27044 -0.22704,-2.72453 2.95157,1.58932 0.90817,-1.58932 -2.49748,-0.90817 2.49748,-0.22704 -1.36226,-1.81636 -3.6327,-0.22704 -0.45409,-1.36226 3.40566,-1.81635 -1.81635,-1.81636 1.36226,-2.49748 2.0434,-2.27044 -3.63271,-6.35723 1.58931,-0.45409 0.90818,-1.13522 -6.13019,-4.31384 -5.90314,-4.54088 -0.68114,-1.5893 5.67611,-4.0868 2.72452,-5.6761 -2.0434,-5.90314 -3.17861,-0.90818 2.95157,-2.04339 -1.36226,-3.40566 -0.45409,-1.13522 3.6327,-1.58931 0,-1.81635 -2.49748,-5.90315 4.76792,4.0868 1.36227,2.95157 11.3522,-1.13522 -1.13522,-7.49245 6.13018,-0.90818 1.36227,0.90818 1.36226,-2.95157 5.44906,3.17861 2.04339,-0.68113 6.81132,3.85975 9.08176,2.72453 -0.68113,8.17358 8.40063,0.45409 2.27044,-2.27044 1.58931,0 -1.81636,4.08679 3.85975,-0.90818 1.58931,-2.95157 1.58931,1.58931 8.40063,-5.22201 5.44905,0 12.94151,-9.53585 7.94654,-10.89811 3.6327,1.816352 0,5.449058 1.13522,3.17861 4.31384,1.13522 0,2.72453 -2.49749,3.40566 0.68113,7.94654 1.81636,5.22201 1.36226,0 -0.45409,9.76289 -2.04339,2.0434 -3.63271,-0.22704 -3.17861,2.04339 -2.95157,-1.58931 -1.81636,0 -3.6327,3.17862 -0.68113,3.6327 1.81635,0 0,4.31384 1.58931,0 -1.58931,3.17862 1.81635,2.27043 2.95158,-2.04339 1.5893,1.36226 -0.45408,2.95157 -2.0434,1.13522 1.5893,2.0434 -4.99496,4.08679 -3.85975,-1.58931 -1.81635,4.08679 2.0434,3.85975 -1.13523,1.13522 -1.5893,4.08679 -4.76793,-2.49748 -1.5893,5.22201 -1.58931,0 2.27044,2.95158 -0.68113,2.72453 -2.27045,0.22704 -2.95157,7.03836 4.08679,0 0,3.63271 -2.95157,5.44905 -2.95157,0.22704 -1.13522,2.27045 -1.81635,-2.0434 -0.68113,2.49748 -3.40566,0 0.45409,-2.27044 -2.0434,0 -1.81635,3.85975 0,2.0434 1.81635,2.27044 -1.13522,1.36226 -3.40566,-0.45409 z",
						
						// Anvers
						"10000" : "m 220.62177,93.92447 -2.83605,-3.939837 13.48572,-0.481633 2.8898,4.013608 3.85306,0.160547 5.13743,-4.013608 -6.26124,-8.348306 2.08708,-4.013608 -2.08708,-0.963268 10.1143,-5.779595 8.3483,-0.321091 1.60545,2.087078 -2.8898,2.568707 0.64218,5.7796 4.65578,-2.087078 7.54559,2.247621 3.53197,-0.642177 -0.96327,-3.531979 4.01362,-1.12381 0.80272,-3.210884 5.29796,-5.7796 3.53198,-1.284353 4.33469,2.889798 0.96327,1.765987 1.76599,0.160547 -0.64218,4.816328 -0.80272,1.284358 0.32109,5.137419 -5.29797,-2.247621 -2.08707,0 0.64217,3.05034 1.92654,0.963268 6.10068,-1.284354 2.40817,1.60544 2.72925,-1.60544 4.3347,4.495242 10.27484,-11.719738 -1.12381,-2.087078 3.85306,-4.174151 1.28436,3.050341 3.85306,0.32109 2.72925,7.224492 -3.37143,7.063953 6.58232,8.990484 0.32109,4.655784 3.69252,1.765987 3.85306,-2.408163 4.97688,3.371433 -1.4449,6.26123 1.12381,1.60544 -2.40817,2.56871 0.16055,6.58232 5.29796,5.13742 -0.16054,6.90341 -3.05035,2.72925 -2.72925,-1.76599 -2.08707,3.85306 -6.58232,1.28436 -4.17416,4.17415 -0.96326,1.4449 -8.82994,2.56871 -0.96327,2.72926 -3.05034,4.0136 -1.76599,-2.24762 -2.24762,1.92654 -3.85306,0 -0.96327,2.24762 -3.53198,0.80272 -3.69252,2.08708 -3.69251,0 -0.16055,-2.72926 -2.40817,-2.72925 -3.05034,3.21088 -3.53197,-0.80272 -2.72926,3.53198 -1.28435,2.08707 0.80272,-3.53197 -1.4449,-0.32109 -0.64218,-1.28436 -4.49524,0.64218 -2.56871,1.60545 -2.08707,0 -0.80273,3.53197 -3.05034,0.16055 -2.56871,-2.24762 -3.21088,2.08707 -4.17416,-3.21088 -2.56871,2.72925 -1.76598,-1.60544 -3.69253,1.60544 -3.69252,-0.80272 0.16055,-1.92653 -2.08708,-0.64218 0.48164,-3.05035 -2.24762,2.56872 -3.21089,-0.64218 -2.72926,-3.53198 -4.33469,-0.64218 -0.48164,1.28436 -2.7165,0.13193 -1.5893,-1.36226 -2.95158,2.04339 -1.81635,-2.27043 1.58931,-3.17862 -1.58931,0 0,-4.31384 -1.81635,0 0.68113,-3.6327 3.6327,-3.17862 1.81636,0 2.95157,1.58931 3.17861,-2.04339 3.63271,0.22704 2.04339,-2.0434 0.45409,-9.76289 -1.36226,0 -1.81636,-5.22201 -0.68113,-7.94654 2.49749,-3.40566 0,-2.72453 -4.31384,-1.13522 -1.13522,-3.17861 0,-5.449058 -3.6327,-1.816352 z m 78.0783,-15.499027 3.21088,1.444897 1.28436,-5.297962 -3.53198,1.605444 -0.96326,2.247621 z",
						
						// Limbourg
						"70000" : "m 336.42799,110.21322 3.21088,-1.12381 3.21089,1.12381 5.61905,-0.16054 0.32109,-2.72926 8.6694,2.8898 2.56871,-4.49524 2.56871,0.32109 2.24762,-3.05035 3.37143,0.3211 5.77959,5.94013 -0.16054,7.06396 11.07756,4.97687 0.16055,2.08708 6.42177,0.80272 4.81633,-1.12381 3.21089,1.76599 -0.64218,2.40816 0.96326,2.40817 5.61906,-2.72926 3.21088,4.17416 -1.12381,2.56871 -2.56871,0 -1.76599,3.21088 2.72926,1.12381 -0.32109,2.72926 -2.24762,-0.80272 -1.92653,0.80272 2.08708,1.92653 -1.12381,1.76599 0.16054,2.24762 -3.37143,-0.32109 0,2.08708 -1.60545,3.21088 2.72926,1.28436 -2.08708,2.24762 0.96327,2.72925 -5.61906,7.54558 0.64218,1.76599 2.56871,-2.5687 1.4449,1.60544 -3.69252,5.4585 -0.32109,3.69253 -2.8898,-1.12381 -2.08707,5.4585 -3.85306,2.24763 -0.96327,5.13741 2.24762,4.49525 4.17415,1.60544 -4.97688,0.96326 -0.32108,3.53198 -6.10069,2.24762 -4.81633,2.08708 -3.21088,0.96326 -0.64218,3.05035 -4.65579,3.21088 -0.48163,-1.4449 -1.60544,-1.4449 0,1.76599 -1.92654,1.76599 -3.37143,0 -2.72925,-2.40817 -0.80272,-2.40816 -0.80273,0.80272 -3.69251,-0.16054 -4.3347,3.21089 -0.16055,2.24762 -3.85306,-2.56872 -2.08708,2.72926 -2.24762,-0.16054 -0.32109,-1.76599 -1.12381,1.60544 -6.58232,-0.80272 0.16055,1.92653 1.4449,2.08708 -1.76599,1.12381 -4.17415,-0.96327 -3.53198,-2.72925 1.76599,-4.01361 -1.92653,-1.60544 1.12381,-3.53198 0,-5.45851 2.24762,0.32109 1.4449,-3.85306 -1.60544,-0.16055 0.96326,-7.06395 1.92653,-3.21088 -0.32109,-1.76599 2.08708,1.12381 1.60545,-4.17416 -0.96327,-3.21088 -4.65579,0 -0.64217,-1.76599 -4.97688,2.08708 -1.76599,-2.08708 -1.76599,0.96327 -2.72925,-5.45851 4.97687,-3.37144 -0.32108,-3.37143 3.85306,-2.72925 1.4449,0 -0.96326,-4.49524 1.12381,0.96326 1.60544,0 1.60544,-1.44489 -4.49524,-4.81633 -4.3347,0 0.48163,4.65578 -2.5687,1.76599 -1.60545,-1.60544 -3.05034,0.80272 -1.76599,-3.21089 -3.05034,0.48163 3.05034,-4.0136 0.96327,-2.72926 8.82994,-2.56871 0.96326,-1.4449 4.17416,-4.17415 6.58232,-1.28436 2.08707,-3.85306 2.72925,1.76599 3.05035,-2.72925 0.16054,-6.90341 -5.29796,-5.13742 -0.16055,-6.58232 2.40817,-2.56871 z",
						
						// Namur
						"90000" : "m 286.4987,351.99301 4.17415,1.92653 1.12381,-0.96327 2.08708,4.01361 2.72925,0.96327 0.96326,3.37143 -1.28435,2.40816 -1.60544,5.45851 -1.92653,0 1.28435,3.69252 1.4449,0.64218 0,3.37143 1.4449,1.28436 -1.60545,0.16054 -0.64217,2.72925 -0.96327,1.60545 7.70613,0.96326 3.69252,-2.40816 2.72926,-0.48164 1.44489,-4.49524 0.80273,-4.97687 3.85306,-2.24763 -0.32109,-1.28435 1.76599,0 3.05034,-2.56871 -1.92653,-1.60544 2.56871,-3.69252 3.37143,-0.96327 2.56871,-0.32109 -2.40817,-3.37143 0.48164,-4.17415 -1.60545,-0.16055 -3.21088,-3.53197 -1.4449,-0.80272 -3.37143,1.76598 -1.92654,-0.96326 0.96327,-2.08708 -4.49524,-6.58232 1.76599,-0.32108 0.96326,-2.72926 1.60545,1.28436 2.72925,-2.40817 2.72925,-4.97687 -0.64217,-4.81634 1.60544,-3.53197 -0.32109,3.05035 1.12381,2.24762 4.81633,-0.96327 4.17415,1.28435 8.6694,-1.44489 0.64218,-2.24763 4.65578,0.48163 0.48164,-1.60544 -3.05034,-3.05034 3.37143,-0.80272 1.12381,-2.56871 -4.97688,-6.26123 0.16054,-3.53198 -1.60544,-1.76598 -3.21088,-0.32109 2.24762,-2.08708 1.60544,1.60544 3.05034,-1.92653 -1.76598,-1.76598 4.17415,-1.60545 1.12381,1.4449 5.61905,-4.3347 6.42178,-4.49524 -0.64219,-4.81633 -2.72925,-0.96327 -2.40816,2.24762 -0.80272,-1.28435 1.12381,-1.60544 2.5687,-1.12381 2.88981,-2.08708 -1.92654,-2.24762 2.72925,-3.21089 -1.23496,-2.57489 -1.01266,-0.79654 -2.08707,1.28436 -1.60545,-1.76599 -6.42177,4.49524 -2.40816,-2.40816 0.80272,-3.53198 -5.7796,-0.64218 -1.4449,-3.05034 1.28436,-0.80272 0,-2.56871 -4.81633,-8.02722 -1.76599,0.48163 -0.96327,1.92654 -2.08708,-2.24762 0.32109,-2.08708 -2.24762,0.96327 -1.12381,-3.05035 1.60545,-1.92653 -4.3347,1.12381 -2.08708,-4.17415 -3.85306,-0.48163 -0.48163,-3.53198 -2.72926,-5.94014 -3.37143,-2.72926 0,-1.60544 -2.08708,-2.08708 -0.16054,-3.85306 -2.24762,-1.60544 -2.40817,0.64217 -1.60544,3.21089 -2.72925,-0.32109 -1.44491,1.12381 -8.3483,2.56871 -1.76599,0 -1.76599,3.69252 c 0,0 -1.12381,-1.4449 -1.12381,-2.08708 0,-0.64217 -2.72925,0.16055 -2.72925,0.16055 l -1.92653,1.76599 -1.60545,-4.01361 -2.5687,1.4449 -0.48164,1.76598 -3.69252,-2.5687 -2.24762,0.80272 0.48163,4.65579 2.08708,1.76598 -3.53198,1.76599 -4.49524,-1.76599 -4.17415,2.40817 0.48163,2.88979 0,3.21089 -1.92653,1.28436 0,3.85306 3.53198,0.32109 0.64218,3.53197 -2.56871,4.49524 2.56871,4.17416 2.88979,0 -1.92653,4.49524 -1.92653,1.60544 1.92653,2.24763 -2.56871,2.5687 0.96327,5.45851 0.32109,2.8898 -7.38504,2.24762 -2.8898,-2.56871 -3.53198,0 -0.96326,3.53198 -8.34831,-1.28436 -0.64218,3.53198 -6.10068,2.56871 -6.42177,5.4585 6.74286,4.17416 3.21089,-2.24762 3.53197,1.92653 -0.96327,3.85306 0,4.49525 -3.53197,4.17415 2.8898,2.24762 1.92653,4.81633 -2.24762,1.60544 0.96326,8.02722 1.92654,4.17416 0.32108,9.63266 3.85307,8.3483 -1.28435,2.56871 3.21088,0 2.24762,-1.60544 4.49524,0 3.21089,-3.53198 2.56871,0 2.56871,-3.53197 5.45851,0 7.06395,-2.24762 -0.32109,-6.10069 1.28435,-4.81633 -1.60544,-0.32109 1.60544,-6.74286 6.10069,-3.21089 1.60544,-4.49524 4.17415,-2.56871 2.24763,-3.21089 1.92653,3.21089 4.81633,-0.32109 0.32109,2.24762 1.92653,0 -2.8898,3.21089 0.64218,7.06395 -2.56871,-3.21088 -1.92653,0.32108 0.64217,5.7796 -2.24762,0 -0.32108,2.8898 2.24762,1.28435 0.32108,2.56871 -2.24762,0.32109 -0.96326,6.42177 -2.24762,2.8898 -0.32109,2.56871 0.32109,1.60545 z",
						
						// Luxembourg
						"80000" : "m 307.8511,380.73044 2.90713,0.5182 1.70283,3.29214 6.81132,3.85975 3.0651,-1.13522 4.31383,6.69779 -0.34056,3.17862 3.17861,0.34056 0.56761,-1.70282 1.0217,1.13521 0.90817,3.85975 9.08176,0.79466 2.61101,-1.92988 7.7195,8.06006 -3.17862,4.42736 0.90818,3.63271 3.40566,-1.24875 1.13522,-2.83804 6.13019,3.29213 3.29213,3.51918 1.36227,4.99497 2.04339,-0.11352 -1.58931,3.17861 3.17862,2.61101 0,1.81635 -2.38396,1.81636 2.38396,1.81635 -0.34056,1.92987 2.49748,-1.70283 6.92484,-1.81635 1.13522,-2.49748 5.22201,1.24874 1.70283,2.72452 1.47579,-2.38396 -0.79465,-1.92987 4.6544,-4.42736 5.78962,2.38397 5.44906,-0.34057 0.90817,-2.95157 2.0434,-1.36227 2.611,2.49748 3.85975,0 4.76792,-4.76792 0,-2.72453 -2.49748,0.22705 0,-1.92988 3.40566,-2.15691 0.90817,-4.88145 2.38396,-0.34057 0,-4.54088 -4.76792,-2.27043 -0.22704,-2.95158 2.611,-3.40566 -3.06509,-3.6327 -1.92987,1.81635 -2.27044,-0.90818 0.34056,-4.6544 -5.22201,-8.51415 -3.85974,1.0217 -1.92988,-8.74119 1.92988,-2.72453 -0.4541,-3.51918 2.72453,0.45408 1.0217,-1.92987 -5.90314,-3.29214 2.72452,-3.17861 1.92988,-4.54088 -0.11352,-4.20032 3.6327,-0.56761 0.79465,-1.47578 2.95158,-1.0217 0,-2.38396 -2.0434,-1.24874 -0.45409,-2.61101 4.42736,-2.95157 1.58931,-4.31384 -2.15692,-1.47578 0.45409,-1.92988 3.17861,-2.04339 0.79466,-5.90315 7.83302,-3.74622 0.34056,-7.7195 6.92484,-2.04339 1.13522,-4.99497 -2.49748,0.68113 0.56761,-8.62767 -0.90817,-11.46572 -3.74623,-1.70283 0,-1.13522 -2.38396,0.34056 -2.83805,-1.47578 -1.24874,1.24874 -7.94654,-3.0651 -0.90818,3.74623 2.27044,1.24874 -2.61101,7.83302 4.20032,-0.22705 -1.13522,2.38397 -7.37893,1.0217 -0.45409,1.47578 -0.56761,-1.47578 -4.99497,-1.24875 -1.47578,2.72453 -3.63271,-1.70283 3.85975,-6.6978 -3.74623,-1.5893 -0.68113,-7.15189 1.36227,-0.90818 0,-1.13521 -6.35724,0.79465 -4.54087,-2.49748 -5.44906,-5.6761 -4.20031,2.49748 -3.74623,-3.06509 -1.36226,-3.85975 -4.99497,3.06509 -4.99497,-4.20031 -2.27044,1.47578 -0.11352,2.27044 1.81635,0 1.24874,1.70283 -4.40901,3.9766 1.23496,2.57489 -2.72925,3.21089 1.92654,2.24762 -2.88981,2.08708 -2.5687,1.12381 -1.12381,1.60544 0.80272,1.28435 2.40816,-2.24762 2.72925,0.96327 0.64219,4.81633 -6.42178,4.49524 -5.61905,4.3347 -1.12381,-1.4449 -4.17415,1.60545 1.76598,1.76598 -3.05034,1.92653 -1.60544,-1.60544 -2.24762,2.08708 3.21088,0.32109 1.60544,1.76598 -0.16054,3.53198 4.97688,6.26123 -1.12381,2.56871 -3.37143,0.80272 3.05034,3.05034 -0.48164,1.60544 -4.65578,-0.48163 -0.64218,2.24763 -8.6694,1.44489 -4.17415,-1.28435 -4.81633,0.96327 -1.12381,-2.24762 0.32109,-3.05035 -1.60544,3.53197 0.64217,4.81634 -2.72925,4.97687 -2.72925,2.40817 -1.60545,-1.28436 -0.96326,2.72926 -1.76599,0.32108 4.49524,6.58232 -0.96327,2.08708 1.92654,0.96326 3.37143,-1.76598 1.4449,0.80272 3.21088,3.53197 1.60545,0.16055 -0.48164,4.17415 2.40817,3.37143 -2.56871,0.32109 -3.37143,0.96327 -2.56871,3.69252 1.92653,1.60544 -3.05034,2.56871 -1.76599,0 0.32109,1.28435 -3.85306,2.24763 -0.80273,4.97687 -1.44489,4.49524 z",
						
						// Liège
						"60000" : "m 431.99972,308.254 0.91542,3.60292 3.53197,1.76599 2.08708,-0.96327 0.48164,-2.40816 4.81632,1.28435 -0.48163,2.08708 0.80272,0.48163 -1.12381,2.72925 2.56871,0.48164 2.56871,-1.12382 -0.48163,-2.5687 -1.92653,-0.48164 1.12381,-1.60544 -0.64218,-1.60544 5.61905,-2.08708 -0.96326,-4.81633 -1.92653,-2.72925 3.53197,-2.72926 1.4449,-3.05034 9.7932,-4.49524 -1.4449,-1.76599 3.21089,-6.58232 2.40817,-0.16054 3.53197,3.05034 5.61906,-3.85307 -1.28436,-3.85306 -3.69252,-2.40816 -2.56871,-4.49525 3.05035,-4.49524 -0.64219,-2.24762 0.96327,-2.72925 -0.80272,-3.85307 -3.37143,-0.80272 0.16054,-4.81633 -4.3347,-2.56871 -1.92653,1.12381 -2.56871,-1.60544 -5.61905,1.92653 -1.92653,-4.49524 -2.40816,-0.96326 1.44489,-2.08708 -2.72925,-0.96327 0.16055,-3.05034 2.72925,-1.60544 2.8898,-4.3347 2.08707,0 0,-2.72926 3.21089,-3.53197 -1.60544,-0.96327 -2.08708,0.96327 -5.94014,-1.28436 -0.48163,1.92653 -1.4449,-0.64217 0.48163,-2.08708 -1.60545,-1.4449 2.24763,-1.28435 -2.8898,-4.3347 -2.56871,-1.60544 -2.56871,-6.58232 -2.72926,-0.96327 -2.72925,0.96327 -3.37143,-1.60544 -0.80272,2.24762 -0.64218,-2.56871 0.80272,-2.56871 -2.8898,-2.40817 -4.65578,0.80273 -1.4449,-1.766 -5.61905,2.56872 -2.72925,-0.32109 2.08707,3.05034 -3.05034,4.97688 -3.05035,-1.76599 -5.13741,0.96326 -2.40817,-4.49524 -3.69252,-1.92653 -2.40816,1.12381 -4.17416,-0.48163 -3.21088,-1.92653 2.40816,-4.81634 -1.28435,-2.40816 0.80272,-1.28436 -0.64218,-0.96326 -4.97688,0.96326 -0.32108,3.53198 -6.10069,2.24762 -4.81633,2.08708 -3.21088,0.96326 -0.64218,3.05035 -4.65579,3.21088 -0.48163,-1.4449 -1.60544,-1.4449 0,1.76599 -1.92654,1.76599 -3.37143,0 -2.72925,-2.40817 -0.80272,-2.40816 -0.80273,0.80272 -3.69251,-0.16054 -4.3347,3.21089 -0.16055,2.24762 -3.85306,-2.56872 -2.08708,2.72926 -2.24762,-0.16054 -0.32109,-1.76599 -1.12381,1.60544 -6.58232,-0.80272 0.16055,1.92653 1.4449,2.08708 -1.76599,1.12381 -4.17415,-0.96327 -3.53198,-2.72925 -0.64218,2.08707 -3.85306,-0.96326 -2.40816,-2.56871 0,-3.21089 -3.05035,-1.92653 -0.48163,3.05034 -2.08708,0 0,4.01361 1.76599,0 0.64218,2.40817 -2.56871,0.48163 0.48163,6.10068 -1.28435,1.4449 -0.64218,3.21089 0.16054,3.85306 2.08708,2.08708 0,1.60544 3.37143,2.72926 2.72926,5.94014 0.48163,3.53198 3.85306,0.48163 2.08708,4.17415 4.3347,-1.12381 -1.60545,1.92653 1.12381,3.05035 2.24762,-0.96327 -0.32109,2.08708 2.08708,2.24762 0.96327,-1.92654 1.76599,-0.48163 4.81633,8.02722 0,2.56871 -1.28436,0.80272 1.4449,3.05034 5.7796,0.64218 -0.80272,3.53198 2.40816,2.40816 6.42177,-4.49524 1.60545,1.76599 2.08707,-1.28436 1.01266,0.79654 4.40901,-3.9766 -1.24874,-1.70283 -1.81635,0 0.11352,-2.27044 2.27044,-1.47578 4.99497,4.20031 4.99497,-3.06509 1.36226,3.85975 3.74623,3.06509 4.20031,-2.49748 5.44906,5.6761 4.54087,2.49748 6.35724,-0.79465 0,1.13521 -1.36227,0.90818 0.68113,7.15189 3.74623,1.5893 -3.85975,6.6978 3.63271,1.70283 1.47578,-2.72453 4.99497,1.24875 0.56761,1.47578 0.45409,-1.47578 7.37893,-1.0217 1.13522,-2.38397 -4.20032,0.22705 2.61101,-7.83302 -2.27044,-1.24874 0.90818,-3.74623 7.94654,3.0651 1.24874,-1.24874 2.83805,1.47578 2.38396,-0.34056 0,1.13522 3.74623,1.70283 0.90817,11.46572 -0.56761,8.62767 2.49748,-0.68113 -1.13522,4.99497 z",
						
						// Brabant Flamand
						"20001" : "m 322.13954,211.67725 -0.64218,2.08707 -3.85306,-0.96326 -2.40816,-2.56871 0,-3.21089 -3.05035,-1.92653 -2.72925,-2.8898 -2.8898,0.32109 -5.29796,4.01361 -2.24762,-1.12381 0.32109,-3.85306 -1.60545,-0.80273 -1.12381,1.76599 -6.58232,0.32109 -0.32109,-2.24762 -2.08707,0 -1.76599,-3.85307 -5.61905,-2.08707 -3.69252,3.37143 -5.94015,0 -2.88979,-1.76599 -0.32109,2.72925 -0.64218,1.76599 2.24763,3.53198 -1.766,2.40816 -4.33469,0.48164 -0.96327,-4.3347 -2.56871,3.37143 -4.65578,1.28435 -0.64218,2.24763 -3.37143,-2.24763 -0.16055,-2.88979 -3.85306,0.16054 -4.81633,3.69252 -5.61905,0.64218 0.16054,2.8898 -2.8898,-0.16055 -1.76599,-3.05034 -1.12381,0.80272 0.64218,1.4449 -1.92653,0 -2.72925,4.3347 -3.53198,-0.64218 -1.92653,2.08708 -4.01361,-3.05035 -2.56871,-0.48163 -3.85306,-3.85306 -2.08708,0 0,2.08707 -2.24762,0.80273 -3.69252,0.96326 -1.92653,-0.64218 -3.21089,2.24762 -8.99048,2.56871 -5.7796,-1.92653 -3.53198,-3.21089 0.64218,-4.17415 2.12704,0.8905 3.40566,0.45409 1.13522,-1.36226 -1.81635,-2.27044 0,-2.0434 1.81635,-3.85975 2.0434,0 -0.45409,2.27044 3.40566,0 0.68113,-2.49748 1.81635,2.0434 1.13522,-2.27045 2.95157,-0.22704 2.95157,-5.44905 0,-3.63271 -4.08679,0 2.95157,-7.03836 2.27045,-0.22704 0.68113,-2.72453 -2.27044,-2.95158 1.58931,0 1.5893,-5.22201 4.76793,2.49748 1.5893,-4.08679 1.13523,-1.13522 -2.0434,-3.85975 1.81635,-4.08679 3.85975,1.58931 4.99496,-4.08679 -1.5893,-2.0434 2.0434,-1.13522 0.45408,-2.95157 2.7165,-0.13193 0.48164,-1.28436 4.33469,0.64218 2.72926,3.53198 3.21089,0.64218 2.24762,-2.56872 -0.48164,3.05035 2.08708,0.64218 -0.16055,1.92653 3.69252,0.80272 3.69253,-1.60544 1.76598,1.60544 2.56871,-2.72925 4.17416,3.21088 3.21088,-2.08707 2.56871,2.24762 3.05034,-0.16055 0.80273,-3.53197 2.08707,0 2.56871,-1.60545 4.49524,-0.64218 0.64218,1.28436 1.4449,0.32109 -0.80272,3.53197 1.28435,-2.08707 2.72926,-3.53198 3.53197,0.80272 3.05034,-3.21088 2.40817,2.72925 0.16055,2.72926 3.69251,0 3.69252,-2.08708 3.53198,-0.80272 0.96327,-2.24762 3.85306,0 2.24762,-1.92654 1.76599,2.24762 3.05034,-0.48163 1.76599,3.21089 3.05034,-0.80272 1.60545,1.60544 2.5687,-1.76599 -0.48163,-4.65578 4.3347,0 4.49524,4.81633 -1.60544,1.44489 -1.60544,0 -1.12381,-0.96326 0.96326,4.49524 -1.4449,0 -3.85306,2.72925 0.32108,3.37143 -4.97687,3.37144 2.72925,5.45851 1.76599,-0.96327 1.76599,2.08708 4.97688,-2.08708 0.64217,1.76599 4.65579,0 0.96327,3.21088 -1.60545,4.17416 -2.08708,-1.12381 0.32109,1.76599 -1.92653,3.21088 -0.96326,7.06395 1.60544,0.16055 -1.4449,3.85306 -2.24762,-0.32109 0,5.45851 -1.12381,3.53198 1.92653,1.60544 -1.76599,4.01361 z",
						
						// Brabant Wallon
						"20002" : "m 260.16942,244.1072 -0.48163,-2.88979 4.17415,-2.40817 4.49524,1.76599 3.53198,-1.76599 -2.08708,-1.76598 -0.48163,-4.65579 2.24762,-0.80272 3.69252,2.5687 0.48164,-1.76598 2.5687,-1.4449 1.60545,4.01361 1.92653,-1.76599 c 0,0 2.72925,-0.80272 2.72925,-0.16055 0,0.64218 1.12381,2.08708 1.12381,2.08708 l 1.76599,-3.69252 1.76599,0 8.3483,-2.56871 1.44491,-1.12381 2.72925,0.32109 1.60544,-3.21089 2.40817,-0.64217 2.24762,1.60544 0.64218,-3.21089 1.28435,-1.4449 -0.48163,-6.10068 2.56871,-0.48163 -0.64218,-2.40817 -1.76599,0 0,-4.01361 2.08708,0 0.48163,-3.05034 -2.72925,-2.8898 -2.8898,0.32109 -5.29796,4.01361 -2.24762,-1.12381 0.32109,-3.85306 -1.60545,-0.80273 -1.12381,1.76599 -6.58232,0.32109 -0.32109,-2.24762 -2.08707,0 -1.76599,-3.85307 -5.61905,-2.08707 -3.69252,3.37143 -5.94015,0 -2.88979,-1.76599 -0.32109,2.72925 -0.64218,1.76599 2.24763,3.53198 -1.766,2.40816 -4.33469,0.48164 -0.96327,-4.3347 -2.56871,3.37143 -4.65578,1.28435 -0.64218,2.24763 -3.37143,-2.24763 -0.16055,-2.88979 -3.85306,0.16054 -4.81633,3.69252 -5.61905,0.64218 0.16054,2.8898 -2.8898,-0.16055 -1.76599,-3.05034 -1.12381,0.80272 0.64218,1.4449 -1.92653,0 -2.72925,4.3347 -3.53198,-0.64218 -1.92653,2.08708 -4.01361,-3.05035 -2.56871,-0.48163 -3.85306,-3.85306 -2.08708,0 0,2.08707 -2.24762,0.80273 -3.69252,0.96326 1.28435,3.85306 -0.64217,3.53198 0,5.77959 5.45851,1.60545 4.17415,-6.42177 2.56871,1.92653 0.32108,4.81633 5.13742,1.92653 0.32109,3.53197 3.21089,0.64218 2.8898,3.21089 3.85306,1.60544 0.32109,4.49524 3.53198,-3.85306 4.17415,0 8.99048,1.60544 -0.96326,4.81634 3.85306,-2.24763 1.28435,2.56871 7.70613,-2.56871 z",
						
						// Région de Bruxelles-Capitale	
						"04000" : "m 237.53267,203.1684 11.55919,-5.7796 -4.17415,-3.05034 0.80272,-1.76599 2.40817,0 -1.28436,-5.7796 -5.45851,-3.21088 1.92654,-2.08708 -0.48164,-3.21089 -3.85306,-2.88979 -2.72925,3.21088 -4.01361,-1.76598 -6.58232,4.65578 1.4449,7.54558 -4.17415,0.64218 -1.76599,3.69252 3.53197,1.60545 3.37144,-0.48164 3.21088,6.74287 4.81633,0.32109 1.4449,1.60544 z",
					}
				}
			}
		}
	);
})(jQuery);
