# 更新履歴

 - master/HEAD
 - 4.2.7 (2025.10.21)
   * ピン留めされたタブが無いときに最初のタブの前に項目をドロップできなくなっていたのを修正
   * ドロップしたタブをピン留めするためのドロップ領域を表示するまでの既定の遅延時間を500ミリ秒から740ミリ秒へ増やした（隠し設定`pinInteractionCueDelayMS`で変更可能）
   * 明示的にセッションを復元した際に、最初のウィンドウ内に復元されたタブのアイコンがグレイアウトされないようにした
   * キャッシュからのタブ復元に失敗した時に、TST初期化時点でアンロードされていたタブを「読み込み待機状態のタブ」として認識できていなかったのを修正
   * Firefox本体のコンテキストメニューと同様に、アンロードされているタブの上では「タブを解放」を表示しないようにした
   * ピン留めされたタブの領域がスクロールされたときに通常タブの領域が無駄に再描画されないようにした
   * `en`ロケールの誤記修正（by [purplnecropanda](https://github.com/purplnecropanda). Thanks!）
 - 4.2.6 (2025.9.22)
   * Firefoxの垂直タブにおけるドラッグ操作の再現として、タブをドラッグ＆ドロップ操作でピン留めしたりピン留めを解除したりできるようにした（ピン留めされたタブの間に通常のタブをドロップしたり、通常のタブの間にピン留めされたタブをドロップしたりできるようにした）
   * ピン留めされたタブの表示領域の高さを、タブ1つ分の高さより小さくできないようにした
   * 可能な場合は、タブのコンテキストメニューの「新しいタブ」のラベルにFirefox本体の物と同様のラベルを使うようにした
   * 暗い配色の時に設定画面のドロップダウンリストの文字が判読不可能な色になっていたのを修正
   * ネイティブのタブグループの操作用コンテキストメニューパネルの表示位置を制御する設定項目を上級者向けに開放
   * `ja`ロケール更新（by [tkng](https://github.com/tkng). Thanks!）
 - 4.2.5 (2025.7.11)
   * Firefox 142以降での、折りたたまれたグループ内でアクティブなタブを表示する動作に対応
   * タブでない項目の上ではタブのプレビューパネルを表示しないようにした
   * ピン留めされたタブの領域の高さがタブの高さよりも小さいときに、ピン留めされたタブがフォーカスされても上下に振動しないようにした
   * タブバーの余白領域にオブジェクトをドラッグ＆ドロップできない問題を修正（4.2.0での後退バグ）
   * API: タブのコンテンツの下に追加の要素を埋め込めなかった不具合を修正（by [emmanuel-ferdman](https://github.com/emmanuel-ferdman). Thanks!）
   * `uk`ロケール更新（by [Taron-art](https://github.com/Taron-art). Thanks!）
 - 4.2.4 (2025.6.26)
   * タブグループのメニュー、タブのプレビューなど、コンテンツ内UIで発生したイベントを正しく処理するようにした（4.2.3での後退バグ）
   * 複数のカスタムダイアログが同時に表示されているときに反応が混ざってしまう問題を修正
   * `uk`ロケール更新（by [Taron-art](https://github.com/Taron-art). Thanks!）
 - 4.2.3 (2025.6.23)
   * 空白領域上で開いたコンテキストメニューの機能が動作しなくなっていたのを修正（by [joanbm](https://github.com/joanbm). Thanks!）
   * タブグループに関するUIを非表示にするための上級者向け設定を追加（Firefox自体の設定の`browser.tabs.groups.enabled`に相当）
   * ピン留めされたタブが溢れているときに、アクティブになったピン留めされたタブの位置まで自動スクロールするようにした
   * グループ化されたタブを明示的にグループのヘッダーの直前に意図的にドロップした場合に、それらのタブをグループから取り除くようにした
   * タブグループの最後のタブを隣接する次のグループのヘッダーの前にドロップして、実際にはタブの位置が変更されなかった場合に、元のグループと同じ名前の新しいグループを作らないようにした
   * ピン留めされたタブの領域の大きさを必要以上に大きくできないようにした
   * ウィンドウをまたいでタブをドラッグ＆ドロップした後で、ドラッグ元のサイドバーでの操作がブロックされたままになっていたのを修正（4.2.0での後退バグ）
   * WindowsでのShift-F10など、キーボード操作でコンテキストメニューが開かれた場合に、アクティブなタブの上でコンテキストメニューが開かれたものとして扱うようにした
   * ネイティブのタブバーからのドラッグ＆ドロップ操作をより確実に受け容れられるようにした
   * タブの複数選択APIの使用の有無を切り替える古い設定を廃止した
 - 4.2.2 (2025.6.9)
   * ピン留めされたタブをドラッグ＆ドロップで並べ替えた後の表示順が期待通りになっていなかったのを修正（4.2.0での後退バグ）
   * 「サイドバー」スキン選択時はカラースキームがダークモードでも常にスキンの配色を優先するようにした（4.2.0での後退バグ）
 - 4.2.1 (2025.6.7)
   * アニメーション効果無効時にアクティブなタブまでタブバーが自動スクロールしなくなっていたのを修正（4.2.0での後退バグ）
   * ウィンドウがプライマリディスプレイより左に配置されている画面にあるときにも、タブバーが右側に置かれているかどうかを自動的に判別するようにした
   * 折りたたまれている途中のタブやタブバー端に貼り付けられたタブがある時でも、アクティブなタブが可視範囲に入るようスクロールする動作をより確実に実現するようにした
   * API: [`scroll`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#scroll-the-tab-bar) のメッセージで、特定のタブグループの位置までタブバーをスクロールするためのパラメータ `group` を受け付けるようにした
 - 4.2.0 (2025.6.2)
   * Firefox 139より古いバージョンへの対応を終了
   * Firefoxネイティブのタブグループ機能に対応（タブのアイコン側の端付近に別のタブをドロップすると、ツリーの編集ではなくFirefoxネイティブのタブグループを作成します）
   * ミュート状態制御ボタンおよびマイク・カメラ・画面の共有状態アイコンの表示位置をFirefox本体のタブと揃えるようにした
   * API: `tab-mousedown` などの通知型メッセージにおいて、Firefoxのタブグループを`tab`（ツリーの項目）として通知するようになった（`type`プロパティの値が`"group"`である特殊なタブとして通知されます）
 - 4.1.11 (2025.5.29)
   * ピン留めされたタブの領域の高さを0にした後に再びリサイズできなくなる問題を修正
   * ピン留めされたタブの領域の高さを手動で変更してから再起動すると高さが0になってしまう問題を修正
 - 4.1.10 (2025.5.27)
   * Multiple Tab Handlerなどのアドオンによって表示される偽コンテキストメニューのコマンドが長らく機能しなくなっていたのを修正
 - 4.1.9 (2025.5.25)
   * ピン留めされたタブの領域の高さをドラッグ操作で変更可能にした（ダブルクリックで自動計算された高さに戻ります）
 - 4.1.8 (2025.5.24)
   * コンテキストメニューからタブをアンロードする操作のラベルの翻訳をFirefoxに合わせ「タブを解放」にした
   * 「タブを解放」実行後に意図しないタブがアクティブになる問題を修正
   * タブのアイコンとラベルの位置が頻繁に移動することになり却って煩わしいため、既定の位置以外に表示されたサイドバー用に外観を左右反転した状態においては「アクティブなタブ以外のクローズボックスをhover時以外は非表示にする」動作を無効にするようにした
   * 折りたたまれた子孫タブの一覧をネイティブのツールチップで表示する動作を制御する上級者向け設定を追加し、サイドバー内で常にタブのプレビューパネルで折りたたまれた子孫タブの一覧を表示できるようにした
   * 1つ前のバージョンで追加した隠し設定の`fadeOutPendingTabs`および`fadeOutDiscardedTabs`を制御する上級者向け設定のUIを追加
 - 4.1.7 (2025.5.16)
   * Firefoxの縦型タブバーに倣って、すべてのテーマでアクティブなタブ以外のクローズボックスをhover時以外は非表示にするようにした
   * ドラッグ操作中はタブのプレビューを表示しないようにした
   * タブバー末尾にある折りたたまれたツリーの後にタブをドロップした時に、タブがツリーの中に組み込まれてしまっていたのを修正
   * Firefoxのタブバー上でアクティブなタブを別のウィンドウに移動した後、TSTのサイドバー上でアクティブなタブがハイライト表示されていなかったのを修正
   * Firefox 140でタブのコンテキストメニューに追加された「タブをアンロード」機能を再現するようにした（同時に、`browser.tabs.fadeOutUnloadedTabs`に対応する`fadeOutPendingTabs`、および`browser.tabs.fadeOutExplicitlyUnloadedTabs`に対応する`fadeOutDiscardedTabs`の2つの隠し設定も追加）
 - 4.1.6 (2025.5.7)
   * ツリー展開時のアニメーション効果が適用されなくなっていたのを修正
   * `<all_urls>`権限が付与されているときにダイアログが開けなくなる問題を修正（4.1.5での後退バグ）
 - 4.1.5 (2025.5.2)
   * Ctrl-Tab/Ctrl-Shift-Tab時に固有の反応（タブの切り替え中に折りたたまれたタブがフォーカスされたら、それらを飛ばしてフォーカスするよう別のタブにリダイレクトする）を、Ctrl-Tab/Ctrl-Shift-Tab以外のTST外での操作でタブがフォーカスされたとき（例：Firefox本体のタブバーでタブをクリックしたときなど）には抑制するようにした
   * 「前/次の同階層のタブにフォーカス」にキーボードショートカットを割り当てた場合にフォーカス移動がタブバー端で循環するようにした
   * タブのプレビューパネルの埋め込み方法をより単純化した
   * API: 各タブのインデント領域をクリックしたときに、他の拡張機能向けに [`tab-mousedown`|`tab-mouseup`|`tab-clicked`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#when-a-tab-is-clicked) ではなく [`tabbar-mousedown`|`tabbar-mouseup`|`tabbar-clicked`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#when-the-non-tab-area-is-clicked) を通知するようにした
 - 4.1.4 (2025.3.13)
   * ミュート状態を表すアイコンの外観をFirefox 136以降のスタイルに合わせた
   * タブのプレビューをサイドバー内にのみ表示するオプションを追加
   * 追加の権限を必要とする設定項目のチェック状態が正しく更新されない問題を修正
   * [初期化処理中のパフォーマンスプロファイルを収集するための仕組みを導入した](https://github.com/piroor/treestyletab/discussions/3097#discussioncomment-12159391)
 - 4.1.3 (2025.1.16)
   * macOS環境でタブのプレビューの背景色が適切に設定されていなかったのを修正
   * macOS環境（Retinaディスプレイ）でタブのプレビューを期待通りの大きさで表示するようにした（4.1.2での後退バグ）
 - 4.1.2 (2025.1.14)
   * FirefoxのDarkテーマを選択してタブのプレビュー表示を有効にするとコンテンツ領域が真っ白になってしまう問題を解消
   * Photonテーマを含む全てのテーマで、音声の再生状態のボタンを同じ外観で表示するようにした
   * プライバシー保護が有効なとき（`privacy.resistFingerprinting`=`true`など）でもタブのプレビューを期待通りの大きさで表示できるようにした
   * プライバシー保護が有効なときにタブのプレビューの表示位置のどれだけずらすかを設定する上級者向け設定を追加
 - 4.1.1 (2025.1.10)
   * RTLの環境（アラビア語など、書字方向が右から左の言語の環境）でUIの方向を切り替えるようにした
 - 4.1.0 (2024.12.25)
   * ブックマーク作成ダイアログを再実装し、Firefoxネイティブのダイアログに近い機能を提供するようにした
   * サイドバー上でのタブのプレビュー表示を再現できるようにした（Webページ上での任意のスクリプトの実行を許可する権限、あるいは「すべてのWebサイトの保存されたデータへのアクセス」権限が必要）
   * タブのプレビュー表示再現を有効にしている場合に、折りたたまれたツリーの子孫タブをプレビューパネル内でより見やすい表示の仕方で示すようにした
   * 追加で要求される権限について、権限を必要とする機能が全て無効化された場合は権限を手放すようにした
   *タブバーへのリンクなどのドロップでタブを開く場合に、タブを待機状態で開く上級者向け設定を追加
   * Firefoxのタブバーと同様に、タブやリンクなどを「新しいタブ」ボタンにドロップできるようにした
   * 音声再生中である事を示すタブ上のボタンの見え方を、最近のバージョンのFirefoxに合わせるようにした
   * TSTのインストール後の初回使用時のみ、TSTのツールバーボタン上にバッジを表示して、クリック操作で初期設定のページを開くようにした
 - 4.0.25 (2024.11.11)
   * 他のアドオン向けの`get-tree`APIおよびグループ化用タブのツリー表示が機能しなくなっていたのを修正（4.0.24での後退バグ）
 - 4.0.24 (2024.10.29)
   * ユーザーのプライバシー保護のため、不要な場面でタブのURLを保存しないようにした（タブごとに有効なfaviconのURLを保持してタブと関連付けるためにだけ使われており、どこかに送信するということは元々ありませんでしたが、現在のWebExtensions APIではfaviconのURLは多くの場合でdata: URIとして通知されるようになっており、保持する必要自体もないため、ほとんどの場合ではURLを保存しなくなりました。また、有効なfaviconのURLを関連付ける必要がある場合も、生のURLではなくハッシュ化した文字列のみを保持するようになりました。）
   * ユーザーのプライバシー保護のため、プライベートウィンドウのツリー構造のキャッシュを保持しないように↓
 - 4.0.23 (2024.9.11)
   * 最近のバージョンで廃止されたCSS2のシステムカラーを使わないようにした
   * Shift-ドラッグ時のタブのドラッグデータに`text/plain`型の表現を加え、任意のテキスト入力欄へドロップできるようにした
   * 再利用されたタブ要素のラベルのオーバーフロー状態をより正しく更新するようにした
   * TST外部から行われた、タブを閉じたり移動したりする操作について、TST内部での処理であると誤検出されにくくなるようにした
   * グループタブから設定画面を開く際のエラーを修正し、タブをアクティブな状態で開くようにした
   * Windows 11においてFirefox自身のタブと同じ文字色・背景色を使用するようにした（ただし、タイトルバーと一体になったFirefox自身のタブバーとは異なり、非アクティブなウィンドウでも色は変わりません）
   * ブックマークツールバーなどへのタブのドラッグ＆ドロップによるブックマーク作成時の動作を改善し、Firefox自身のタブからのドラッグ時でも可能であればツリー構造を保存するようにしたと同時に、ツリー構造を持たないタブ群からブックマークを作成した場合は、作成されたブックマーク項目を新規のフォルダーにまとめないないようにした
   * ツリー構造を持つタブのブックマークツールバーなどへのドラッグ＆ドロップ時に、作成されたブックマーク項目をフォルダー配下にまとめる動作を、設定で無効化できるようにした
   * API: 新しい通知型のAPI [`try-scroll-to-activated-tab`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#suppress-auto-scrolling-to-activated-tabs) を追加し、タブが選択されたときのサイドバーの自動スクロール処理を抑制できるようにした
   * API: タブがサイドバーの端に実際に貼り付いて表示されているかどうかを示す `stuck` という状態の情報を、[ツリー項目](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#data-format)の情報の一部として返すようにした
   * API: 優先度が高い状態で空の文字列がタブのツールチップに設定された場合に、タブのツールチップを完全に非表示にするようにした
   * `nl`ロケール追加（by [Vistaus](https://github.com/Vistaus). Thanks!）
 - 4.0.22 (2024.8.9)
   * 水平タブバー上での複数選択したタブのドラッグ＆ドロップ操作や[Move Tab Hotkeys](https://addons.mozilla.org/firefox/addon/move-tab-hotkeys/)によって一緒に移動されたタブについて、移動先にの位置で矛盾がない状態になるようツリー構造を自動修復するようにした
   * サイドバー開閉後にタブの読み込み中アニメーションが同期されない問題を修正
   * サイドバー開閉後に複数選択したタブのハイライト状態が失われる問題を修正
   * 古い`overflow`/`underflow`イベントが廃止された環境でタブバーの溢れ状態を正しく判定できていなかったのを修正
   * キャッシュを使用しない設定のときに、再起動後にタブのタブバー端への貼り付け状態が復元されていなかったのを優勢
 - 4.0.21 (2024.8.4)
   * アクティブなタブを含む複数のタブが一度に閉じられた場合に、可能な限り、ユーザーの設定に基づいて適切なタブを次のアクティブなタブにするようにした
   * 親タブが閉じられた後にツリー構造を維持するために代わりに開かれるグループ化用のタブを任意に閉じられるようにした（従来通りにこのようなグループ化用のタブを閉じられない動作に戻すには、隠し設定の `closeParentBehavior_replaceWithGroup_thresholdToPrevent` を `-1` に設定して下さい）
   * タブバーが溢れるかどうかのギリギリの場面でスクロールバーの表示・非表示を無限に切り替え続けてしまう問題を起こりにくくした
   * システムの速度が低下していて、他に自動グループ化を待っている状態のタブがある場合に、ピン留めされたタブから開かれた子タブが既存の子タブから遠く離れた位置に開かれてしまうことがあったのを修正
   * ツリーを構成するタブを[`group-tabs` API](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#create-new-group-from-given-tabs)を用いて一部だけグループ化した場合に、グループ化後も元のツリー構造を可能な限り保ち、また、残されたタブのツリー構造も矛盾無く維持するようにした
   * Photonテーマ使用時にエッジケースにおいてスクロールバーが点滅する問題を修正
   * 閉じたタブにアニメーション効果が適用される場面を想定した、タブの上での連続したクリック操作がタブバーの空白領域のクリック操作と誤認されないようにするための対策が、全く無関係の場合にまでイベントをキャンセルしてしまっていたのを修正
   * グループ化用のタブの中に表示されるツリーについて、マルチカラム表示にするかどうかの判断を、ユーザースタイルシートで折り返しの制御が変更されていても期待通りに行えるようにした
   * 内部的なリンクで設定画面に遷移したときに、遷移先の設定項目が上級者向け設定として隠れていた場合、一時的に上級者向け設定を表示するようにした
   * ピン留めされたタブの子タブをグループ化するために開かれたグループ化用のタブにおいて、設定画面へのリンクからより適切な設定項目へ遷移するようにした
   * 新しいタブを開くボタンの上での中クリックでクリップボードのURLを貼り付ける機能について、権限が許可されていても内部的な設定がまだ有効化されていないときは、混乱を避けるため、設定のチェックボックスをオフのままにするようにした
   * ドラッグ＆ドロップ操作時に`dataTransfer`にアクセスできなかったときのエラー情報がコンソールに現れないようにした
 - 4.0.20 (2024.6.28)
   * IndexedDBのエラーが原因で初期化に失敗する場合があったのを修正
 - 4.0.19 (2024.6.24)
   * `browser.tabs.selectOwnerOnClose` などの作用によって可視範囲外のタブがアクティブになったときに、マウスポインターがサイドバー領域から離れるまでは、アクティブなタブの位置までタブバーを自動スクロールする動作を遅延するようにした（この動作は `deferScrollingToOutOfViewportSuccessor` を `false` に設定することで無効化できます）
   * 複数のタブをウィンドウをまたいでドラッグ＆ドロップで移動した後にどのタブをアクティブにするかについて、明示的に設定された情報を優先的に反映するようにした
   * [Tree Style Tab in Separate Window](https://addons.mozilla.org/firefox/addon/tst-in-separate-window/)などによってサイドバーパネルが別ウィンドウで開かれている場合にも、ツリー上での→/↓キー操作のショートカットを、ツリーが見えている場合の動作にするようにした
   * API経由でグループ化用のタブを開くときに、自動的に閉じる条件のチェックボックスの状態を制御できるようにした
   * 対象のウィンドウが明示されているときには、タブ以外の要素への追加のコンテンツを、対象ウィンドウ以外のウィンドウに反映しないようにした
 - 4.0.18 (2024.6.13)
   * Firefox 127以降のタブのコンテキストメニューの「重複タブを閉じる」コマンドと同等の機能をタブのコンテキストメニューに追加
   * ツリー上での矢印キー操作に割り当てるmacOS向けの規定のショートカットをAlt-Shift-↑/↓/←/→からMacCtrl-Shift-↑/↓/←/→に変更
   * サイドバーが非表示のときに、ツリー上での→/↓キー操作のショートカットの動作を「次のタブにフォーカスを移す」に正しくフォールバックするようにした
 - 4.0.17 (2024.6.10)
   * 開いた直後に移動されたタブのインデントがおかしくなる問題を修正（4.0.16での後退バグ）
   * 起動直後のネストの深いツリーのインデントがおかしくなる問題を修正（4.0.16での後退バグ）
 - 4.0.16 (2024.6.9)
   * 新しいキーボードショートカット用機能の「ツリー上での↑/↓/←/→キーを模倣」を追加し、それらに初期状態でAlt-Shift-↑/↓/←/→を割り当てた（favicon状態のピン留めされたタブや折りたたまれたツリーに対する画面上の表示位置に基づくフォーカス移動と、ツリー項目上での←/→キーによるツリー開閉のそれぞれを、場合によって行う動作となります）
   * 新しいキーボードショートカット用機能の「ツリーを折りたたむか、親のタブにフォーカスを移す」「ツリーを展開するか、最初の子タブにフォーカスを移す」を追加（ツリー項目上での←/→キーでの操作を再現するため）
   * ピン留めされたタブ自体がスクロール可能でないときは、ピン留めされたタブの上でのホイールスクロールや、ピン留めされたタブが選択されているときのタブバーをスクロールするキーボードショートカットによって、通常のタブの方をスクロールするようにした
   * `overflow`と`underflow`イベントが使用できない状況での代替処理をより最適化
   * ウィンドウをまたいだタブのドラッグ＆ドロップでの移動で起こっていた問題（移動後にツリー構造が一部失われる、移動後にグループ化用のタブが消える、移動後にタブがすべて再読み込みされる）を修正
   * 閉じて開き直した後のタブが最後の子タブだったときに、最後の子タブを閉じた後に設定通りに親タブにフォーカスを移すようにした
   * 仮想スクロールのレンダリング中に各タブにアニメーション効果が意図せず複数回適用される場合があったのを修正
   * 処理が順番どおりに行われないせいでタブに意図せず一部のクラスが残ってしまっていたのを修正
   * 個々のタブの上下にコンテンツを挿入した場合に意図せず無限ループ（CPU使用率の増大とGCの動作不良の原因）が発生してしまっていたのを修正
   * `zh_CN`ロケール更新（by [NightSharp](https://github.com/NightSharp), thanks!）
   * `ru`、`de`、および`en`ロケール更新（by [vadcx](https://github.com/vadcx), thanks!）
 - 4.0.15 (2024.5.21)
   * 親タブのドラッグ操作でツリー全体を移動するように設定している場合でも、親タブを子孫のタブにドラッグ＆ドロップした際には個別のタブとしてドロップ位置に移動するようにした（従来のように子孫のタブの位置へのドロップを禁止するには、隠し設定の `moveSoloTabOnDropParentToDescendant` を `false` に設定してください）
   * ネイティブのタブコンテキストメニューでの「新しいコンテナータブで開く」→「コンテナーなし」で開いたタブに誤って親タブのコンテナーが継承されていたのを修正
   * Firefox 128以降との互換性のため、`overflow`と`underflow`イベントに依存しない実装に変更した
   * キーボードショートカット設定用のコマンドとして「ツリーの折りたたみ状態を切り替える」「ツリーの折りたたみ状態を再帰的に切り替える」を追加
   * ネイティブのタブコンテキストメニューにTSTのコンテキストメニュー項目を表示するかどうかを制御する設定を追加
   * 初期化の最中に新たにタブが開かれた場面での動作の堅牢性を改善
   * サイドバーパネルの表示幅が0でサイドバーの内容が更新された際に、それ以後の動作がおかしくなっていたのを修正
   * コンテナーを示すマーカーの表示幅を、タブの高さに限らず細い幅で表示するようにした
 - 4.0.14 (2024.4.17)
   * 最大化またはフルスクリーン状態のウィンドウからタブを別ウィンドウに切り離せなくなっていたのを修正（4.0.13での後退バグ）
   * ヘルパーアドオンによってタブの上下に挿入されたコンテンツでタブの高さが変化している場合に、タブバーのスクロール時にスクロール位置が不安定になる問題を修正
 - 4.0.13 (2024.4.10)
   * 「新しい空のタブ」のための挙動が反映されなくなっていたのを修正（4.0.12での後退バグ）
   * 「ハイコントラスト」テーマにおいて、高すぎるコントラストによるストレスを軽減するためタブの境界線に `ButtonText` ではなく `GrayText` を使うように変更
   * サイドバー上のコンテキストメニューの「タブを移動」→「新しいウィンドウに移動」で、常にツリー全体を移動するようにした
   * 「新しいウィンドウに移動」で開かれるウィンドウを、元のウィンドウから少しずれた位置に開くように修正
   * `<all_urls>`の権限が承認されていない場合に無関係の設定項目が無効化されてしまっていたのを修正
   * タブのウィンドウからの切り離し・結合時に、意図せずサイドバーパネル全体が再読み込みされることがあったのを修正
   * ピン留めされたタブがアクティブになったときに、そのタブから開かれた子タブをまとめているグループ化用のタブを自動展開したりそのタブの位置までタブバーをスクロールしたりする挙動を制御する隠し設定 `syncActiveStateToBundledTabs` を追加
 - 4.0.12 (2024.4.5)
   * タブの寸法・位置をより正しく計算するようにした（4.0.11での後退バグ）
   * `--tab-size`でタブの高さを変更したときの挙動がおかしくなっていたのを修正
   * 「ハイコントラスト」テーマにおいて、視認性を高めるためタブの境界線に `ButtonShadow` ではなく `ButtonText` を使うように変更
   * 「新しい空のタブを開く」操作以外の契機で開かれたタブ（他のアプリケーションから開かれたタブなど）に誤って「新しい空のタブ」のための挙動が反映される場合があったのを修正
 - 4.0.11 (2024.4.3)
   * タブ描画周りの処理をさらに最適化
   * アニメーション無効時のタブのインデント更新処理を最適化
   * 再利用されたタブ要素に別のタブの追加コンテンツが埋め込まれたままになる問題を修正
   * favicon未設定のページに対して適切なfaviconでない別のfaviconが表示される問題を解消
   * ブックマークから開かれたタブをまとめるためのグループタブについて、設定に従って正しくオプションが設定されるようにした
   * API: 応答性向上のため、API経由で返されるタブの情報をキャッシュできるようにした（初期状態では無効で、隠し設定 `cacheAPITreeItems` で有効化できます）
   * API: ピン留めされたタブの中に追加されたコンテンツを正しく表示するようにした
 - 4.0.10 (2024.3.21)
   * Firefoxのメジャーアップデート後にツリー構造がズレる問題を修正（参考：[ツリー構造がズレてしまった場合の修正手順](https://github.com/piroor/treestyletab/issues/3504#issuecomment-2010003298)）
   * いくつかのコンテキストメニュー項目が設定で有効になっていても表示されない問題を修正
 - 4.0.9 (2024.3.20)
   * 何らかの理由でクリップボードにアクセスできないときに「新しいタブ」ボタンの上での中クリックが動作しなくなっていたのを修正
   * TSTの初期化処理中にタブを閉じる他のアドオン（Tab Session Mあなげｒ、Firefox Multi-Account Containersなど）との互換性を改善
   * ユーザースタイルシートを組み込みのスタイル指定よりも優先的に反映する処理が機能しなくなっていたのを修正
   * 上級者向け設定として、他のアドオンによって非表示にされたタブを強制表示するオプションと、事前にタブをレンダリングしておく画面数を制御するオプションのUIを追加
   * 初期化中の致命的でないエラーをなるべくコンソールに出力しないようにした
   * `zh_CN`ロケール更新（by [NightSharp](https://github.com/NightSharp), thanks!）
 - 4.0.8 (2024.3.18)
   * 新しいタブを開いたときにスクロール位置が戦闘まで意図せず戻ってしまう場合があったのを修正
   * 仮想スクロールにおいて再利用されたタブに古い情報が残らないようにした
   * 静的レンダリング（`outOfScreenTabsRenderingPages`=`-1` による物理スクロール）時のスクロール処理をより最適化
   * ピン留めされたタブから開かれたタブが初期状態でグループ化されなくなっていたのを修正（最近のバージョンでの後退バグ）
 - 4.0.7 (2024.3.16)
   * `outOfScreenTabsRenderingPages`が意図通りに反映されていなかったのを修正
 - 4.0.6 (2024.3.16)
   * 仮想スクロールの処理の最適化を進めた
   * サイドバー上でタブを選択した後にキーボードショートカットやFirefoxのタブバー上でタブを選択したときタブのハイライト状態がおかしくなっていたのを修正
 - 4.0.5 (2024.3.15)
   * 仮想スクロールの性能のバランスを制御する隠し設定 `outOfScreenTabsRenderingPages` を追加（`-1`のような負の値を設定すると、仮想スクロールが行われないTST 3.xの状態とほぼ同等になります）
   * 仮想スクロールの処理の最適化を進めた
   * 「新しいタブ」ボタンの中クリックでクリップボード内のURLを開く機能を追加（Linuxで有効になっているFirefoxの隠し設定 `browser.tabs.searchclipboardfor.middleclick` の再現を目的とした物で、事前にクリップボードの読み取り権限を許可し、`dom.events.asyncClipboard.clipboardItem` を `true` に設定しておく必要があります）
   * Windows 10でのスクロールバーの外観が制御されていなかったのを修正
   * タブの高さを変更するユーザースタイルシートの指定の互換性を高めた
   * `zh_CN`ロケール更新（by [NightSharp](https://github.com/NightSharp), thanks!）
 - 4.0.4 (2024.3.14)
   * タブの上下両方にマージンが追加されているときにスクロール領域のサイズとタブのドロップ位置の計算結果が期待通りでなかったのを修正
   * API: `sidebar-show` の通知をより確実に送出するようにした
   * `zh_CN`ロケール更新（by [NightSharp](https://github.com/NightSharp), thanks!）
 - 4.0.3 (2024.3.13)
   * 「Photon」テーマ使用時にタブのドロップ位置の計算結果が期待通りでなかったのを修正
   * ピン留めされたタブのコンテナーの高さが正しく計算されない場合があったのを修正
 - 4.0.2 (2024.3.13)
   * タブのラベルのオーバーフロー状態の検出に関する処理に起因するパフォーマンス低下を修正
   * 「Photon」テーマ使用時に最後のタブの下に無用なスペースが表示されていたのを修正
   * 「すべてのウェブサイトの保存されたデータへのアクセス」の権限が無い場合にダイアログを開けなくなっていたのを修正
   * コンテキストメニュー内に不要な項目が表示されたままになる場合があったのを修正
   * タブバーの空白領域でのコンテキストメニュー項目のラベルをネイティブの物に合わせるようにした
   * `zh_CN`ロケール更新（by [NightSharp](https://github.com/NightSharp), thanks!）
 - 4.0.1 (2024.3.8)
   * API経由で貼り付けられたタブを含むツリーも、他のツリーの展開時に自動的には折りたたまないようにした
 - 4.0 (2024.3.7)
   * 多数のタブがある場合のパフォーマンスを向上（画面に見えている範囲内のタブのみレンダリングするようになりました）
     * ピン留めされたタブとそうでない（通常の）タブは、それぞれ別々のコンテナー要素（`#pinned-tabs-container > .tabs.pinned` および `#normal-tabs-container > .virtual-scroll-container > .tabs.normal`）の配下に置かれるようになりました
     * 各タブの要素は [`tabs.Tab.index`](https://developer.mozilla.org/en-US/docs/Mozilla/Add-ons/WebExtensions/API/tabs/Tab#index) に対応する属性 `data-index` を持つようになりました
     * この設計変更により、CSSの`counter`を使用したカスタマイズは期待通りに動作しなくなりました（同等のことをするにはヘルパーアドオンを作成する必要があります）
   * コンテキストメニューのコマンドやその他のアクションで、任意のタブをタブバーの端に貼り付けられるようにした（貼り付けたタブの振る舞いはピン留めされたタブに似ていますが、配下のツリーが維持される点が異なります）
   * タブの共有状態（カメラ、マイク、および画面）をアイコンで表示するようにした
   * タブバーがスクロールされている時にタブバーの上端にドロップシャドウを表示するようにした
   * タブバーが最大までスクロールされていない時にタブバーの下端にドロップシャドウを表示するようにした
   * Firefox起動直後の初期化時に、タブの数・ピン留め状態・コンテナーの状態だけ一致していればキャッシュからツリーを復元するようにした
   * Firefox Viewから開かれたタブの取り扱いを制御できるようにした
   * ライブラリーなどの画面上でブックマークを複数個コピーした場合に、タブからブックマークを作成した時の自動グループ化処理が誤爆しないようにした
   * Firefoxのタブバー上で単独のタブを移動した先がTSTのにおける最上位の階層だった場合に、子孫のブックマークが追従して移動されずそのまま取り残されてしまっていたのを修正
   * ピン留めされたタブから複数のタブを開くときに、最近開いた子タブの次の位置に開く設定が機能していなかったのを修正
   * Firefox 116以降のバージョンでCtrl-Shift-Tで空のダイアログウィンドウが意図せず復元されてしまわないようにした
   * まとめて閉じたサブツリーのタブを復元した際に、復元後のタブのツリー構造が壊れる場合があったのを修正
   * タブバー末尾近くのツリーを折りたたんだときに、タブを閉じたときと同様に、一時的にスクロール位置を固定するようにした
   * タブバーに直接ローカルファイルをドロップした時に、単に無視するのではなく、blob: URLを使用してタブで開くようにした
   * タブのツリーからブックマークを作成した時に、それらをまとめるためのフォルダーが複数個作成されてしまう問題を修正
   * 設定画面の項目の大部分を上級者向け設定扱いにして、初期状態で非表示にするようにした
   * APIの機能強化・改善
     * TST自身のバージョンを問い合わせるためのメッセージ型 [`get-version`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#detecting-version-of-tst-itself) を追加した
     * 新しい通知型の [`tabs-rendered` と `tabs-unrendered`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#when-one-or-more-tabs-are-renderedun-rendered) を追加し、タブのレンダリング状態を監視できるようにした
     * ツリー項目の情報を[必要最小限だけ得る](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#data-format)ためのAPI [`get-light-tree`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#apis-to-get-tree-information) を追加
     * [`get-tree`などで得られるツリー項目の情報](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#data-format)について、TST内での判別結果に対応する情報を含めるようにした
     * タブのタブバー端への貼り付け状態を制御するためのメッセージ型として[`stick-tab`、`unstick-tab`、`toggle-sticky-state`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#control-sticky-state-of-tabs-at-tab-bar-edges)を追加
     * 特定の状態のタブを自動的にタブバー端へ貼り付けるためのメッセージ型として [`register-auto-sticky-states` と `unregister-auto-sticky-states`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#set-locked-as-collapsed-state-of-tree) を追加
     * 新しい通知型の [`tab-sticky-state-changed`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#when-a-tab-is-stuck-or-unstuck-tofrom-tab-bar-edges) を追加し、タブの貼り付け状態の変化を監視できるようにした
     * [`get-tree` と `get-light-tree` の `rendered:true` オプションによってレンダリング済みのタブの情報だけを得られるようにした](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#when-one-or-more-tabs-are-renderedun-rendered)
     * パフォーマンス向上のため、[複数のメッセージをまとめてTSTに送ったり](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#abstract)、[TSTからのメッセージをまとめて受け取ったり](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#bulk-messages-from-tst)できるようにした
     * [通知型メッセージから送られてくるツリー項目の情報を最小限の物にできるようにした](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#listening-of-notification-messages)
     * `get-tree` や `get-light-tree` で特定の状態の複数項目を一度に取得するための特別なキーワードとして [`allVisibles` と `normalVisibles`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#basics-to-specify-tabs) を追加
     * `get-tree` や `get-light-tree` であらかじめ `states` の情報に基づいて絞り込んだ結果を得るための [`states` および `statesNot` オプション](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#basics-to-specify-tabs)を追加
     * タブの追加コンテンツの挿入位置の指定として [`tab-above` と `tab-below`](https://github.com/piroor/treestyletab/wiki/Extra-Tab-Contents-API#how-to-insert-extra-contents) に対応
     * タブのツールチップを明示的に設定するためのAPIとして [`set-tooltip-text` と `clear-tooltip-text`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#set-custom-tooltip-text-to-tabs) を追加
     * [`try-expand-tree-from-attached-child` の通知](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#suppress-unintentional-expansion-of-collapsed-tree-by-tst)において、新たに追加された子タブの情報を `child` で含めるようにした
   * **このバージョンでの改善作業の多くはWaterfoxプロジェクト・BrowserWorks社からの資金的支援に基づいて行われました。Alex Kontosさん、ありがとうございます！**（[Waterfoxプロジェクトによるアナウンス](https://www.waterfox.net/blog/waterfox-x-treestyletab/)）
 - 3.9.22 (2024.1.31)
   * 追加の権限「ブックマークの読み取りと変更」が許可されていない時に初期化に失敗する問題を修正（3.9.21での後退バグ）
 - 3.9.21 (2024.1.26)
   * [3.9.20でのオンメモリーキャッシュ使用時のパフォーマンスの低下](https://github.com/piroor/treestyletab/issues/3434)を解消した
   * [グループ化用のタブ上で組み込みのアイコンが複数列に分割されて表示される問題を解消](https://github.com/piroor/treestyletab/pull/3435)
 - 3.9.20 (2024.1.18)
   * Firefox 115より古いバージョンへの対応を終了
   * 新しくタブを開く位置の制御に関する設定を整理し、効果が重複するオプション同士の関係を考えなくてもよいようにした（タブを開く位置の制御の選択肢の時点で「最初の子タブとして開く」「最後の子タブとして開く」といった選択を可能にした）
   * リンクから開かれた子タブおよびコンテキストメニューの「新しいタブ」コマンドで開かれたタブの取り扱いの設定をUI上で変更できるようにした
   * Firefoxのセッションファイルの肥大化を防ぐために、サイドバーの内容のキャッシュを揮発性のRAM上にのみ保持するようにした（副作用としてブラウザーの起動時などの初期化処理に時間がかかるようになった恐れがあるため、従来の挙動に戻すための設定も追加済み）
   * 「新しいタブ」コマンドで開かれたタブの検出をより確実にした
   * アニメーションを含むテーマを使用している時のRAM使用量増大の問題に対処した（詳しくは[bug 1875100](https://bugzilla.mozilla.org/show_bug.cgi?id=1875100)を参照）
   * Syncのシミュレート機能において、デバイス毎の識別子をより安全に保持するようにした
   * `zh_CN`ロケール更新（by [NightSharp](https://github.com/NightSharp), thanks!）
 - 3.9.19 (2023.11.20)
   * ローカルファイルやabout:ページのようにアドオンの権限で開けないURLを持つタブは、コンテナー継承のためであっても開き直さないようにした
   * アドオンの権限で開けないURLを持つタブに対しては、コンテキストメニューの「新しいコンテナータブで開く」を無効化するようにした
   * アイコンの表示色をFirefox 120自身の配色に合わせた
 - 3.9.18 (2023.11.10)
   * コンテキストメニューの項目とキーボードショートカット設定用スロットに「ツリーをミュート/ミュート解除」「配下のタブをミュート/ミュート解除」を追加
   * CPU使用率低減のため、サイドバーとバックグラウンドページの間の生存確認の通信を1秒間隔から5秒間隔に減らした
   * アニメーション効果が無効になっているときの、ツリーの最大の深さの再計算処理を最適化した
   * SVGアイコンの色をCSS prefers-color-schemeを用いてプラットフォームの配色に合わせるようにした
   * [`fr`ロケール更新（by cayenne17, thanks!）](https://github.com/piroor/treestyletab/pull/3406)
 - 3.9.17 (2023.9.8)
   * TSTによる内部的なタブの再配置時の取り扱いを改善し、ピン留めされたタブを親として開かれた子タブが誤った位置に配置されにくくなるようにした
   * サイドバー上でのコンテキストメニューの初期化処理を最適化し、メニューが画面に現れてから遅れて項目が更新される様子を観測されにくくした
   * Protonテーマでの最後のタブと「新しいタブ」ボタンの間の無駄なスペースを減らした
   * タブをまっすぐ左右どちらかにドラッグしてドロップ不可能な場所にドロップした際の別ウィンドウへの切り離し操作がより確実に動作するようになった（操作を妨げる原因となっていた、[Firefox 71ですでに修正された古い不具合](https://github.com/piroor/treestyletab/issues/1778)への回避策を廃止した）
   * Firefoxネイティブのタブバーからの複数選択されたタブのドロップを、ツリー項目のドロップと同等に扱うようにした
   * ヘルパーアドオンの一覧へのリンクを更新（[Wikiのページになりました](https://github.com/piroor/treestyletab/wiki/Helper-addons-extending-functionality-of-TST)）
   * [特定のプラットフォームでドラッグ＆ドロップ操作の後に予期されないドラッグイベントへの反応が起こる事がある問題](https://github.com/piroor/treestyletab/issues/3374)を回避するようにした
   * API: 新しい通知型の [`try-collapse-tree-from-collapse-command` と `try-collapse-tree-from-collapse-all-command`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#suppress-unintentional-collapsion-of-expanded-tree-by-tst) を追加し、ユーザーの操作でツリーが折りたたまれるのを防げるようにした
   * ツリーの開閉つまみのスタイル定義を更新し、`margin`と`padding`で簡単に位置を調整できるようにした
   * ユーザー定義のスタイル指定によるカスタマイズ機能の名前付けを「ユーザースタイルシート」に統一した
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.9.16 (2023.7.21)
   * faviconの取り扱いに関するメモリ消費を削減
   * 「新しいタブ」ボタンの上での右クリックでコンテナーの選択肢を表示するようにした（最近のバージョンのFirefoxの挙動を再現）
   * 利便性向上のため、Ctrl-PageUp/PageDownでのタブの移動中は、ツリーの祖先を展開するようにした
   * 最後のタブを閉じる処理が進行中にマウスカーソルを移動しても、スクロール位置の固定状態を維持するようにした
   * 同階層の前後のタブにフォーカスを移動する操作にキーボードショートカットを割り当てている時に、同階層のタブの間でフォーカスを循環するようにした
   * ブックマークフォルダーから開いたタブがツリー構造を伴っていた場合に、グループ化用のタブを最上位に開かない動作を無効化する上級者向け設定を追加（グループ化用のタブが当初はブックマークフォルダーから開かれたフラットなタブをツリーとしてまとめるためだけに導入されたことから、開かれたタブがツリー構造になっている場合は不要な物としてグループ化用のタブを開かない挙動で固定されていた）
   * 「既存のタブからタブが開かれた場合：親のタブの子として、直近に開いた子タブの隣に開く」が選択されていた場合に、既存の子孫タブが無いと子タブが親タブの子にならない問題を修正
   * 複数選択したタブの中にツリーの最上位レベルのタブが複数あった場合に、最初のグループ化用のタブに対応するブックマークが作成されていなかったのを修正
   * Darkモードにおいて、設定画面のドラッグ＆ドロップの項目の表の枠線が見えにくかったのを修正
   * Protonテーマでのアクティブなタブや複数選択されたタブの見た目を、Firefox 102以降での見た目に合わせるようにした
   * Protonテーマでのタブのドロップシャドウの表示の仕方を、Firefoxのネイティブタブのドロップシャドウと同様にするようにした
   * `de`ロケール更新（by [juwbr](https://github.com/juwbr), thanks!）
 - 3.9.15 (2023.3.24)
   * [Popup window](https://addons.mozilla.org/firefox/addon/popup-window/)などによって既存のタブがポップアップウィンドウに切り離された時に無限リロードに陥らないようにした
   * アクティブなタブのコンテナーを引き継ぐように開き直された新しい空のタブが、アクティブにならない問題を修正
   * 大量のタブが開かれている場面でのサイドバーとコントローラーとの間の接続の意図しない切断を防ぐために、生存確認の間隔をタブの数に応じて増大するようにした（これによりツールバーボタンやキーボードショートカットによるサイドバーの表示・非表示切り替えにより大きな遅延が発生するようになる場合があります）
 - 3.9.14 (2023.3.13)
   * 遅い環境での`browser.tabs.selectOwnerOnClose`再現の挙動を改善
 - 3.9.13 (2023.3.12)
   * [ピン留めされたタブから開かれた子タブの位置が制御されているときに、ピン留めされたタブがアクティブな状態で新しい空のタブがアクティブなタブの子として開かれたら、ピン留めされたタブから開かれた子タブとしての制御を適用するようにした](https://github.com/piroor/treestyletab/issues/3296)
   * 他のアプリケーションから開かれたタブに対する`browser.tabs.selectOwnerOnClose`再現の挙動を改善
   * リンクのドロップ操作に対するFirefox組み込みの設定項目「リンク、画像、メディアを新しいタブで開いたとき、すぐにそのタブに切り替える」の振る舞いを再現するための設定項目を追加
   * Windows 11その他の環境において、ホバー状態以外でもスクロールバーの表示幅分サイドバーの内容をずらして表示して、ツリー操作用のUIが操作不能になら内容にした
   * API: コンテキストメニューのコマンド「このツリーを再帰的に展開」「すべてのツリーを展開」によるツリーの展開をキャンセルできるようにする通知型 [`try-expand-tree-from-expand-command` と `try-expand-tree-from-expand-all-command`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#suppress-unintentional-expansion-of-collapsed-tree-by-tst) を追加
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.9.12 (2023.1.7)
   * グループ化用のタブのページ内UIで、中クリックまたはクローズボックスでタブを閉じられるようにした
   * グループ化用のタブのページ内UIにおいて、タブの一覧の更新時の画面のチラつきをなくした
   * 「新しいタブを開く」操作で開かれたタブを検出するためのURLを複数指定できるようにした（プライベートウィンドウ対応のため）
   * タブの読み込みアイコンのアニメーションの再生タイミングをより適切に同期するようにした（[by Lej77](https://github.com/piroor/treestyletab/pull/3269), thanks!）
 - 3.9.11 (2022.12.6)
   * ブックマーク以外から開かれたタブをグループ化する設定が機能しなくなっていたのを修正（3.9.8での後退バグ）
   * いっくつかの設定項目の数値指定用の入力欄の桁数を拡大した
 - 3.9.10 (2022.11.10)
   * [アイコンが表示されなくなる問題](https://github.com/piroor/treestyletab/issues/3142)の回避策が期待通りに適用されていなかったのを修正
   * タブの一時的な状態の誤検出に起因する最近のバージョンでの後退バグを修正
 - 3.9.9 (2022.11.9)
   * サブフォルダーを含むブックマークフォルダーからタブを開いた場合にグループ化されない問題を修正
   * ブックマークから開かれたタブの自動グループ化に関する設定UIからブックマークのアクセス権を要求できるようにした
   * 内部の設定にゴミが残留していた場合に追加の権限の要求が行えなくなってしまっていたのを修正
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.9.8 (2022.11.3)
   * [メモリ消費](https://github.com/piroor/webextensions-lib-event-listener-manager/pull/1)と[CPU使用率](https://github.com/piroor/treestyletab/pull/3238)を削減（by [nirvdrum](https://github.com/nirvdrum), thanks!）
   * ブックマークフォルダーを中クリックして開かれたタブについて、可能であればツリー構造を復元するようにした
   * 3.9.6で追加した選択肢がツールバーボタンのメニューからの簡易設定に含まれていなかったのを修正
   * `ext+treestyletab:`で始まるURLの読み込み時にフラグメント識別子が機能していなかったのを修正
 - 3.9.7 (2022.10.18)
   * 3.9.6での、タブの数が多いときのパフォーマンス低下の後退バグを修正
   * 現在のタブが何らかのコンテナーで開かれていて、新しいタブに現在のタブのコンテナーを引き継ぐ設定のときに、明示的に「コンテナーなし」を指定して新しいタブを開けない不具合を修正
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.9.6 (2022.10.12)
   * デスクトップ通知と初回起動時の通知ページのアイコンが見えなくなっていたのを修正（3.9.4での後退バグ）
   * 「Dark」を含むいくつかのテーマにおいて、スクロールバーのつまみをより見やすい色で表示するようにした
   * 上級者向けに、既存のタブから開かれた新しい子タブの取り扱いの選択肢について、`browser.tabs.insertRelatedAfterCurrent`=`true`の時のFirefox既定の動作に合わせる動作を追加
   * `browser.tabs.insertAfterCurrent`=`true`の時に既存のタブの中に開かれたタブが正しくツリー構造に組み込まれなくなっていたのを修正
   * グループ化用のタブのタイトルをより確実に初期化するようにした
   * いくつかの操作の後の不安定な動作の原因となっていた、誤って保持されていた「Ctrlキーが押されている」という内部状態を、タブが開かれたり閉じられたりしたタイミングで消去するようにした
   * 複数のタブをブックマークしたときの既定のブックマークフォルダーの名前に使用できるプレースホルダを追加
       * `%GROUP%`: ツリーの親タブがグループ化用のタブだった場合はそのタイトル、そうでなければ空文字
       * `%HOURS%`: 2桁で表した現在時刻の時間
       * `%MINUTES%`: 2桁で表した現在時刻の分
       * `%SECONDS%`: 2桁で表した現在時刻の秒
       * `%MILLISECONDS%`: 3桁で表した現在時刻のミリ秒
       * `%ANY(value1, value2, ...)%`: 指定された値の中で最初に有効な値
   * グループ化用のタブをピン留めできるようにした
       * タブがあった元々の位置には、エイリアスとなるタブが残されます
       * ピン留めされたグループ化用のタブへのドラッグ＆ドロップ操作は、エイリアスとして残されたタブへのドロップ操作として扱われます
   * API: 開かれたタブのTSTによる取り扱い動作をヘルパーアドオンから上書きできるようにする新しい通知型のメッセージである[`try-handle-newtab`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#suppress-handling-of-new-tabs-by-tst)を追加
 - 3.9.5 (2022.9.21)
   * `de`ロケール更新（by [SammysHP](https://github.com/SammysHP), thanks!）
 - 3.9.4 (2022.9.21)
   * 開かれた直後に閉じられたタブ（ダウンロードリンクに対して開かれたタブなど）に対する堅牢性を向上し、サイドバーにタブの「残像」が残りにくくした
   * タブを開いている最中にウィンドウをまたいで移動された場合、そのタブは移動後のウィンドウのアクティブタブから開かれたものとしては扱わないようにした（[メインウィンドウにタブを集約](https://addons.mozilla.org/firefox/addon/aggregate-tabs-to-main-window/)との互換性を向上）
   * ツールバーボタンにより適切にテーマの配色を反映するようにした
 - 3.9.3 (2022.9.19)
   * グループ化用のタブを親としたツリーに対して「このツリーをブックマーク」機能を使ったとき、可能であればグループ化用のタブの名前を既定のフォルダー名として使うようにした
   * Firefox 105以降のバージョンで、タブがブックマークから開かれたかどうかを検出できなくなっていたのを修正
   * 読み込み保留状態のタブをウィンドウ間で移動した後に、よりタブの内容が読み込まれてしまわれにくくした
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.9.2 (2022.9.15)
   * ウィンドウ間でツリーをドラッグ＆ドロップした際にフリーズする場合があったのを修正（3.9.0での後退バグ）
   * マウスカーソルがスクロールバーの上に乗っている間もタブをずらしたままにするようにした
   * 自動で表示されるスクロールバーをよけるためのタブをずらす距離について、不正な値が指定された場合でも安全に動作するようにした
 - 3.9.1 (2022.9.14)
   * `@media`や擬似要素を含むユーザースタイルとの互換性の不具合を解消
   * 自動表示されるスクロールバーをよけるためにタブをずらす動作の設定を上級者向けに公開
   * 初期状態では、自動表示されるスクロールバーの近くにマウスカーソルが近付いた時にだけタブをずらすようにした
 - 3.9.0 (2022.9.13)
   * Firefox自身がそうするのと同様に、既存のウィンドウからタブを切り離した際に、新しいウィンドウが元のウィンドウのサイズと状態（最大化またはフルスクリーン）を引き継ぐようにした
   * サイドバーの内容の再レイアウト処理やFirefoxのタブバーとの同期について、いくつかのエッジケースの問題（無限ループ、動作の停止など）が発生しにくくなるようにした
   * TSTの外の操作で親タブがウィンドウから切り離された際に、残された子孫タブのツリー情報とインデントが更新されないままとなっていたのを修正
   * `browser.tabs.insertRelatedAfterCurrent`と`browser.tabs.selectOwnerOnClose`に基づくFirefoxのタブの取り扱いの動作をより正しく模倣するようにした
   * 読み込み保留状態のタブをウィンドウ間で移動した後に、タブの内容が読み込まれてしまわないようにした
   * ウィンドウ間でのドラッグ＆ドロップの以後、選択した複数のツリーのドラッグ&ドロップに失敗するようになる問題を修正
   * `about:reader`のURLのブックマークを開く際、（そのままではアドオンから開けないため）元のURLを開くようにした
   * [Fennec上で実行されている場合、タブのコンテキストメニューにおいて](https://github.com/piroor/treestyletab/issues/3174)「タブを端末に送信」配下に「端末を管理...」を常に表示するようにした
   * 設定画面の見出しの「他のタブ」表記を「既存のタブ」に変更
   * 設定のリセット操作で、設定値をより安全に初期値にリセットするようにした
   * 自動的に隠れるスクロールバーが表示されるスペースを確保するための方法を、`tab-item-substance`の`padding`から`margin`へ変更
   * 自動的に隠れるスクロールバーの配色を変更しないようにした
   * ユーザースタイルで再び`@import`を使用できるようにした
   * [TSTのサイドバー領域に追加の要素を挿入するAPI](https://github.com/piroor/treestyletab/wiki/Extra-Tab-Contents-API)を全面的に刷新し、タブ全体の上や下への任意のUI要素の挿入や、キーボード入力およびフォーカス移動のイベントを検知できるようにした
   * `tabs.onCreated`のリスナーから`Tab.id`を伴ってリクエストされた[`get-tree`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#get-tree-information)に対し、より確実に結果を返すようにした
   * ログ出力対象モジュールに`sidebar/tst-api-frontend`を追加
   * `zh_CN`ロケール更新（by [NightSharp](https://github.com/NightSharp), thanks!）
 - 3.8.26 (2022.7.15)
   * 古いバージョンのTST向けに書かれたユーザースタイル定義が機能しない場合がある問題に対処（詳細は[関連issue](https://github.com/piroor/treestyletab/issues/3153)を参照）
   * macOSでのピンチイン・アウト操作でサイドバーの内容がズームされないようにした
   * [アイコンが消える問題](https://github.com/piroor/treestyletab/issues/3142)に対する回避策を無効化するための隠し設定 `enableWorkaroundForBug1763420_reloadMaskImage` を追加
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.8.25 (2022.7.8)
   * より動作が分かりやすくなるように、新しいタブの振る舞いに関する設定UIの構成を見直した
   * [アイコンが消える問題](https://github.com/piroor/treestyletab/issues/3142)に対する回避策を導入
   * ブロックされたページに対するfaviconを追加
   * `fr`ロケール更新（by [tbertels](https://github.com/tbertels), thanks!）
 - 3.8.24 (2022.6.2)
   * macOS、Linux、Windows 11において、スクロールバーに重ならないようにツリーの開閉つまみをずらして表示するようにした
   * グループ化用のタブを移動した後にタブのラベルがおかしくなる問題を修正
   * サイドバーを開き直した後にヘルパーアドオンに `tab-mouseover` などのメッセージが通知されなくなる問題を修正
   * タブの自動グループ化の確認のダイアログを、タブの数に合わせて自動的にリサイズするようにした
   * Firefox 99と100で`dragend`イベントの座標がおかしくなる問題（[bug 1767165](https://bugzilla.mozilla.org/show_bug.cgi?id=1767165)）への回避策を、対称範囲外のバージョンのFirefoxでは無効化するようにした
   * APIの改善：TSTによる処理が完了した時点での結果を通知する新しい通知型のメッセージ [`new-tab-processed`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#when-the-tst-finishes-its-handling-for-a-newly-opened-tab) を追加
 - 3.8.23 (2022.5.1)
   * Firefox 99以降のバージョンで`dragend`イベントの座標がおかしくなる問題（[bug 1767165](https://bugzilla.mozilla.org/show_bug.cgi?id=1767165)）への回避策を導入し、サイドバーを右側に置いている場合にタブが意図せず切り離されて画面外に配置されてしまう事態が発生しにくくなるようにした（この回避策を無効化するには、TSTの設定の「開発者向け」-「すべての設定」で`enableWorkaroundForBug1767165_fixDragEndCoordinates`のチェックを外して下さい）
 - 3.8.22 (2022.4.22)
   * [ブックマークフォルダーの選択用UIにおいて、連続したキー入力による項目のインクリメンタルサーチに対応](https://github.com/piroor/treestyletab/issues/3077)
   * 複数のタブを閉じる確認のダイアログを、タブの数に合わせて自動的にリサイズするようにした
   * Protonテーマにおいて、複数選択されたタブの外観をFirefox 99での表示に合わせるようにした（[Bug 1751807](https://bugzilla.mozilla.org/show_bug.cgi?id=1751807)での変更への追従）
   * デバッグモードにおいて、ダイアログをmodal状態で開かないようにした
   * APIの改善：他のツリーが展開されたときのツリーの折りたたみを制御する新しい通知型のメッセージ [`try-collapse-tree-from-other-expansion`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#suppress-unintentional-collapsion-of-expanded-tree-by-tst) を追加
 - 3.8.21 (2022.2.13)
   * TST Bookmarks Subpanel 1.2.4以降のバージョンからドロップされた項目の読み込みに失敗する問題を修正
 - 3.8.20 (2022.2.8)
   * Firefox 97以降でドラッグ操作の挙動が不安定になっていたのを修正
   * 新しく開かれたタブにアクティブなタブからコンテナーを引き継ぐ際に、タブの開き直しでURLが変わってしまわないようにした
   * タブのタイトルに二重引用符が含まれる場合でも、ブックマークのタイトルとして正しく引用するようにした
   * Ctrl-Tab操作を検知する権限が与えられていないときに、Ctrlキーの長押しでツリーを自動展開しないようにした
   * 「about:config」のタブに歯車型のアイコンを表示するようにした（Firefox 98での仕様変更に追従）
   * `de`ロケール更新（by [SammysHP](https://github.com/SammysHP), thanks!）
 - 3.8.19 (2022.1.13)
   * Firefox 96.0以降のバージョンで、Windows 10の暗い配色と「ハイコントラスト」テーマの組み合わせにおいてタブの背景色がタイトルを読みにくい色になっていたのを修正
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.8.18 (2021.12.26)
   * [Tree Style Tab in Separate Window](https://addons.mozilla.org/firefox/addon/tst-in-separate-window/)などによってタブバーが通常のタブに読み込まれている状況と、TSTでのタブの切り離しを無効化する設定が組み合わさった場面において、タブのドラッグ＆ドロップでタブバーの内容が失われてしまわないようにした
   * Firefox Sync使用時に複数デバイス間でTSTの設定のみ同期しないようにする隠し設定（TSTの設定→開発用→すべての設定→`syncEnabled`）を追加した（[SyncによってCPU使用率が急上昇することがある問題](https://github.com/piroor/treestyletab/issues/3057)の回避策）
 - 3.8.17 (2021.12.15)
   * `browser.tabs.insertAfterCurrent`が`true`に設定されている場合に、受け側のFirefoxが動作していない状態で他のデバイスからタブが送られた時に、Firefox起動後に開かれたそれらのタブを、ツリー構造を壊さないよう既存のツリーに組み込むようにした
   * `browser.tabs.insertAfterCurrent`が`true`に設定されている場合に、他のデバイスから複数のタブを一度に送ると受け側のFirefoxでタブが飛び飛びに開かれてしまう問題について、可能な限りタブの位置を一箇所にまとめるようにした（この挙動は隠し設定 `fixupOrderOfTabsFromOtherDevice` で無効化できます）
   * ページのタイトルの最初に置かれたRight-to-Leftの制御文字を受け付けるようにした
   * 「Sidebar」テーマでの折りたたまれた子孫タブの数の数字の表示をより自然な見た目にした
   * タブのクローズボックス上でのダブルクリックではツリーを折りたたまないようにした（この動作の結果として、閉じようとしているツリーが意図せず折りたたまれてしまい、子孫タブまで誤って閉じられてしまうケースがあった）
   * サイドバー内において、タブのコンテキストメニューの「新しいタブ」上での中クリックおよびCtrl/⌘-クリックを、「新しいタブ」ボタン上でのアクションと同様に処理する用にした
   * ユーザースタイルシートでのカスタマイズ性向上のために、`<tab-item-substance>`、`<tab-label>` 、`<span class="label-content">`に対し、親要素の`<tab-item>`の`data-tab-id`属性と`data-window-id`属性を継承するようにした
   * favicon化されていないタブでも、「attention」の状態にあるタブはFirefox本体のタブ同様にハイライト表示するようにした
   * Linux上において、「ハイコントラスト」テーマ選択時に背景色に確実に視認性の高い（暗い）色を使用するようにした
 - 3.8.16 (2021.11.11)
   * タブのラベルが長い時に、単一の設定ではなくラベル文字列自体の書字方向のみに従って、右または左にフェードアウトするようにした
   * タブのラベルの書字方向を制御する設定を廃止した
   * `ko`ロケール更新（by [OctopusET](https://github.com/OctopusET), thanks!）
 - 3.8.15 (2021.10.25)
   * ブックマークフォルダのコンテキストメニューの「ツリーとしてすべて開く」でタブを開く際、[Container Bookmarks](https://addons.mozilla.org/firefox/addon/container-bookmarks/)によって保存されたコンテナーの情報を正しく反映するようにした
   * TST Lock Tree Collapsedによって折りたたまれた状態に固定されたツリーにタブがドロップされたときに、正しく非表示にするようにした
   * 他のアドオン向けのAPIを無効化する隠し設定 `APIEnabled` を追加した
   * `zh_TW`ロケール更新（by [SiderealArt](https://github.com/SiderealArt), thanks!）
 - 3.8.14 (2021.10.15)
   * テーマが色情報を提供している（例：Firefox 95以降のColorwaysなど）場合、ツールバーボタンのアイコン、メニューのアイコン、およびサイドバーヘッダーのアイコンに適切な色を適用するようにした
 - 3.8.13 (2021.10.3)
   * 閉じられた親タブを開き直して、折りたたまれた状態のタブが復元された親タブの配下に移動されたときに、それらのタブが見えない状態のままになっていたのを修正
   * API経由でタブが1つ上の階層に移動されたときに、移動先が最上位階層の場合子孫タブが置き去りになっていたのを修正
   * `zh_CN`ロケール更新（by [NightSharp](https://github.com/NightSharp), thanks!）
 - 3.8.12 (2021.8.26)
   * WebExtensions API経由で非表示にされていながらCSSで強制的にサイドバー内に表示されているタブがあるときでも、サイドバーがスクロール可能かどうかの判定をより正しく行えるように修正
   * プライマリでなくかつ高DPIの画面がプライマリの画面の左に配置されているときに発生する不安定な動作を減らすため、この状況に合致する場合はサイドバーの↔位置の判定を行わないようにした
   * ネットワークエラーのページについて、FirefoxのPhotonテーマと同じアイコンが使われるように修正
   * Ctrl-Tabでのタブのフォーカス移動中に、フォーカスがツリーから外れた後のタイミングで意図せずツリーが展開されてしまう場合があったのを修正
   * ツールバーアイコン上での短縮メニューからタブのドラッグ＆ドロップの設定を変更しようとした場合、設定画面をタブで自動的に開くようにした（より良い解決策が見つかるまでの暫定対処）
   * サイドバーの初期化処理中において、まったくの想定外の致命的なエラーが生じた場合に、サイドバー自体を自動的に再読み込みするようにした
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
   * `ko`ロケール更新（by [OctopusET](https://github.com/OctopusET), thanks!）
   * `zh_CN`ロケール更新（by [NightSharp](https://github.com/NightSharp), thanks!）
 - 3.8.11 (2021.8.17)
   * サイドバーパネルの表示を右側用に切り替えるかどうかの確認が、サイドバーパネルが左側に表示されているときにまで表示されてしまっていたのを修正
 - 3.8.10 (2021.8.17)
   * サイドバーパネルが右側に表示されていることを初めて検出したときに、表示を右側用に切り替えるかどうかの確認を表示するようにした
 - 3.8.9 (2021.8.15)
   * 規定の動作として、サイドバーの位置（左または右）に合わせた外観を自動的に適用するようにした（サイドバーの位置を変更した後、TSTのサイドバーパネルを開き直す必要があります）
   * `privacy.resistFingerprinting`=`true` を使用している場合向けに、サイドバーの近くにタブをドロップしても別ウィンドウに切り離せるようにするエキスパート設定を追加
   * 最近のバージョンのFirefoxで複製されたタブの検出のための遅延を設定しているときに、ブラウザ起動直後のセッション復元でツリーが復元されない場合があったのを改善
   * 新しいウィンドウが開かれたときに最初のタブを即座に開き直すアドオン（Temporary Containersなど）と併用時の安定性を向上
   * 全設定のエクスポート・インポート時に、デバイス依存の情報を除外して安全に処理するようにした
   * APIの改善：新しい通知型APIの [`tabbar-overflow` と `tabbar-underflow`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#when-the-tab-bar-becomes-scrollable-or-unscrollable) を追加
   * APIの改善：[`scrolled` の通知メッセージ](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#messages-notified-by-mouse-wheel-rotation)に、タブバーのスクロール可否を示すプロパティ `overflow` を追加
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.8.8 (2021.7.17)
   * 複数の祖先タブが一度に閉じられた時に残されたタブのインデントが解除されない場合があったのを修正
   * Firefoxのネイティブのタブのサイドバーへのドロップを受け付けるように修正（最近のバージョンでの後退バグ）
   * タブ内の各ボタン要素に静的な `aria-label` を設定するようにした（これによりDragonを含むいくつかの音声認識システムとの互換性が向上する事が期待されます）
 - 3.8.7 (2021.7.8)
   * Photonテーマの外観がおかしくなっていたのを修正（3.8.5での後退バグ）
   * タブの高さの合計をより安全に計算するように修正
 - 3.8.6 (2021.7.7)
   * 非常に古いバージョンで表示が崩れる問題を修正（3.8.5での後退バグ）
 - 3.8.5 (2021.7.6)
   * タブのDOM構造に破壊的な変更があります:
       * 各タブの `tab-item` と内容（ `tab-favicon` など）との間に、中間コンテナとして `tab-item-substance` を追加しました。
         ユーザースタイルを使用している場合、セレクタ内で `tab-item` の後に記述していた[`>`（子結合子）](https://developer.mozilla.org/en-US/docs/Web/CSS/Child_combinator)は削除する必要があります。
         [セレクタ更新のヒントも参照して下さい](https://github.com/piroor/treestyletab/discussions/2960#discussioncomment-972745)。
       * TST 3.8.4までのDOM構造に依存しているヘルパーアドオンは動作しない場合があります。
   * `about:newtab`を含む項目がある時に、フォルダー内のブックマークをタブで開けなくなっていたのを修正
   * 権限設定のためのUIに他のアドオンの一覧を表示できなくなっていたのを修正
   * エラーコンソールに表示されるエラーの量を減らした
   * APIの改善：[タブに追加の内容を挿入する位置として指定可能な選択肢](https://github.com/piroor/treestyletab/wiki/Extra-Tab-Contents-API#how-to-insert-extra-contents-to-tabs)に `indent` を追加した
   * APIの改善：[ツリー構造に基づいてタブを取得するための `parent`, `parent-of-<id>`, `root`, `root-of-<id>` キーワード指定](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#basics-to-specify-tabs)に対応した
 - 3.8.4 (2021.6.20)
   * タブバーの内容が溢れたかどうかの状態をより正しく検出・更新し、「新しいタブ」ボタンが最後のタブの上に重ならないようにした
   * 初回起動時にタブのコンテキストメニューの項目の表示・非表示を正しく更新できていなかった問題を修正
   * 複数のタブをまとめて閉じた後でCtrl-Shift-Tでタブを復元した場合に、ツリーの構造をより正しく復元するようにした
   * ピン留めされたタブの表示領域（`--pinned-tabs-area-size`）、サブパネルの表示領域（`--subpanel-area-size`）、および「新しいタブ」ボタンの表示領域（`--after-tabs-area-size`）のそれぞれのサイズについて、ユーザースタイルでこれらの変数を上書きすることで容易に外観を制御できるようにした
   * 設定画面の初期化中のエラーからの回復を図り、一部の機能が動作しない場合であっても設定UIを表示するようにした
   * 「新しいタブ」ボタンの長押しで表示されるポップアップについて、ポップアップが開かれた後でボタンを放した次点ではポップアップを閉じないようにした（3.8.2での後退バグ）
   * `--multiselected-color`を使ったユーザースタイルとの互換性が損なわれていた問題を修正（3.8.2での後退バグ）
 - 3.8.3 (2021.6.13)
   * Firefoxのテーマ、システムのDarkモード、GTKのテーマとより互換性が高くなるようにProtonテーマを作り直した
   * ダイアログの操作で無駄に1秒待たされる問題を修正
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.8.2 (2021.6.11)
   * "Proton"テーマの外観を、よりFirefoxの物に近くなるようにした
   * 「新しいタブ」ボタンをShift-ドラッグで `about:newtab` へのリンクとして取り扱うようにした（これにより、サイドバー内の任意の位置に新しいタブを開くこと画できます）
   * 識別性を高めるために、新しいタブを位置を指定して開く操作のパネルの各項目にアイコンを表示するようにした
   * ピン留めされたタブのラベルを、スクリーンリーダーや音声認識システムから参照できるようにした
   * サイドバー内にドロップされた`about:newtab`のリンクをタブで開けるようにした
   * サイドバー内で確認のダイアログを表示する設定の時に、操作スピードが速い場合でも安定して動作するようにした
   * サイドバー内に表示された確認ダイアログ上でのミドルクリックでタブを開かないようにした
   * 動機対象のデバイス一覧に、不正な「undefined」の項目が表示されないようにした
   * 設定がインポートされたときに、ユーザースタイル編集欄の高さを即座に反映するようにした
   * 新しいタブを開く位置が「制御しない」または「最後に開いたタブの隣」に設定されている場合に、新しい空のタブを開けない場合があったのを修正
   * アクセシビリティ確保のため、ツールバーボタンの表示色を明示的に設定できるように設定UIを再導入した
   * Linux環境において、ドラッグ操作中にドロップ位置の表示を消さないようにした
   * ツールバーボタンの右クリックメニューからの設定変更で、新しいタブの挿入位置の設定が保存されない場合があったのを修正
   * サイドバーの背景色をなるべく早いタイミングで反映するようにした
   * （ユーザースタイルでボタンが強制表示されている場合に）音声を再生中でないタブでもミュート状態を切り替えられるようにした
   * サブパネルとして読み込まれるページのURLに、親ウィンドウのIDを`windowId`というURLパラメータで渡すようにした（[by NiklasGollenstede](https://github.com/piroor/treestyletab/pull/2899). Thanks!）
   * サブパネルとして読み込めるページを、提供元のアドオンのパッケージ内に含まれているページのみに制限するようにした（[by NiklasGollenstede](https://github.com/piroor/treestyletab/pull/2898). Thanks!）
   * APIの改善：[通知型のメッセージ`new-tab-button-mousedown`、`new-tab-button-mouseup`、`new-tab-button-clicked`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#when-the-new-tab-button-is-clicked)を使って「新しいタブ」ボタンの動作を外部から制御できるようにした
   * APIの改善：[`set-extra-new-tab-button-contents`と`clear-extra-new-tab-button-contents`](https://github.com/piroor/treestyletab/wiki/Extra-Tab-Contents-API#extra-contents-in-the-new-tab-button)を使って、「新しいタブ」ボタンの中に任意のUI要素を挿入できるようにした
   * APIの挙動の変更：[通知型のメッセージ`tab-clicked`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#when-a-tab-is-clicked)を、`tab-mousedown`と`tab-mouseup`のいずれもキャンセルされなかった場合にのみ通知するように変更した
   * `de`ロケール更新（by [SammysHP](https://github.com/SammysHP), thanks!）
   * `ko`ロケール更新（by [BoredSomeone](https://github.com/BoredSomeone), thanks!）
 - 3.8.1 (2021.5.7)
   * macOSにおいて、サイドバーが表示されるギリギリの数のタブがあるときに、サイドバーのスクロールバーが表示されたり消えたりを繰り返す問題を修正（修正したはずが、リリースまでの間に再発してしまっていた）
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.8.0 (2021.5.5)
   * 親タブを閉じたり移動したりしたときの振る舞いに関する設定を整理
       * サイドバー内での操作について、以下の場面では常に固定の挙動が反映されます：
           * 折りたたまれたツリーの親を閉じる：ツリー全体を閉じる。
           * 折りたたまれたツリーの親を移動する：ツリー全体を移動する。
           * 展開状態のツリーの親を移動する：「ドラッグ＆ドロップ」セクションでの設定に従う
       * Firefox自身のタブバーを、タブをツリーではなく単独のタブとして操作するためのUIとして使いたい人向けのプリセット設定では、サイドバー外（Firefox自身のタブバー、キーボードショートカット、他のアドオン）での操作はツリーではなく単独のタブに対する操作として扱われます。
       * タブをTSTによって制御されたツリーとして常に取り扱いたい人向けのプリセット設定では、サイドバー外（Firefox自身のタブバー、キーボードショートカット、他のアドオン）での操作であっても常にサイドバー内のタブに対する操作と同じ動作をします。
       * それ以外の場合、以下のそれぞれの場面向けに個別の動作を設定できます：サイドバー内で展開状態のツリーの親を閉じた場合、サイドバー外で折りたたまれた状態・展開状態のツリーの親を閉じた場合、サイドバー外で折りたたまれた状態・展開状態のツリーの親を移動した場合、および、サイドバーが閉じられた状態での操作。。
   * サイドバー内のUI要素にアクセシビリティ情報を提供するようにし、[音声認識経由でのサイドバーの操作をより容易に行えるようにした](https://github.com/piroor/treestyletab/wiki/How-to-control-Tree-Style-Tab-via-speech-recognition).
   * タブのコンテキストメニューに、Firefox本体の物を再現した「新しいタブ」コマンドを追加
   * コンテキストメニューの「下のタブを閉じる」と「他のタブを閉じる」について、メニューを開いたタブの配下にある折りたたまれたツリーは、閉じる対象に含めないようにした
   * ブックマークフォルダから開くタブを、正しい順番で開くようにした（最近のバージョンでの後退バグにより発生していた問題）
   * macOSにおいて、サイドバーが表示されるギリギリの数のタブがあるときに、サイドバーのスクロールバーが表示されたり消えたりを繰り返す問題を修正
   * macOSにおいて、クリック可能な要素にサイドバーが重ならないようにするタブ内の余白を正しく適用するようにした（誤って反対方向に余白が適用されてしまっていた）
   * Protonテーマにおいて、コンテナー識別用のマーカーをタブ上部に表示するよう改めた
   * Protonテーマにおいて、ピン留めされたタブと通常のタブの間に境界線を表示しないようにした
   * 現在のテーマのアイコン色またはタブの文字色を、ツールバーボタン･コンテキストメニュー項目･サイドバーパネルのアイコンに反映するようにした
   * メインプロセスとサイドバーの間でタブの状態の同期が崩れたときの、サイドバーの内容の自動再構築処理を、より安定して動作するように修正
   * Temporary Containersなどの他のアドオンによって、新規に開かれた直後にタブが開き直される場面で、より安定して動作するようにした
   * 親タブを単独で閉じたり移動したりした後の挙動について、より安定して動作するように修正
   * タブ以外の上でのコンテキストメニューで「タブを端末に送信」を表示しないようにした
   * 更新ボタンのミドルクリックなどで開かれた、複製されたタブの開き方について、より正しく設定を反映するようにした
   * キーボードショートカットでのスクロール行数を制御する上級者向け設定を追加
   * サブパネル領域の大きさを、アドオンごとに保存･復元するようにした
   * サブパネル切り替えUIについて、よりUIらしく見えるように見た目を調整
   * サブパネル切り替えUIのアイコンに、16ピクセル以外の大きさで与えられたアイコンも表示するようにした
   * APIの改善：サブパネルの登録時に[`initialHeight`（初期状態の高さ）および`fixedHeight`（固定の高さ）を指定できるようにした](https://github.com/piroor/treestyletab/wiki/SubPanel-API#how-to-register-a-subpanel)。
   * APIの改善：[A任意のタブ状態を設定するAPI](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#apis-to-set-custom-state-for-tabs)について、文字列が大概の値もより安全に取り扱うように↓
   * APIの改善：[`scroll` API](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#scroll-the-tab-bar)の`delta`や`position`パラメータでCSS長さの指定を受け付けるようにした
   * APIの改善：[`scroll` API](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#scroll-the-tab-bar)でアニメーションに要する時間を制御する`duration`パラメータに対応
   * APIの改善：進行中のスクロールを中断する[`stop-scroll`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#scroll-the-tab-bar)を追加
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.7.4 (2021.3.31)
   * Firefoxの次期UIテーマの[Proton](https://www.omgubuntu.co.uk/2021/02/try-firefox-proton-redesign-ubuntu)風テーマを追加
   * テーマ「Plain」を「Photon」に名称変更（Firefoxの現在のテーマ名に合わせた）
   * Nightly 89.0a1に合わせてタブのコンテキストメニューの構成を変更
   * 折りたたまれた子タブを持つ親タブについて、サイドバーが表示されている場合にTSTのUI外での操作でタブを閉じるとき、親タブを単独で閉じられるようにする上級者向け設定を追加
   * ユーザースタイル定義の保存可能最大サイズを約12KB拡大
   * [複製されたタブを検出する処理の待ち時間を変更するデバッグ用設定](https://github.com/piroor/treestyletab/issues/2845)を追加
   * APIの強化：[TSTのタブ位置制御に関する動作を迂回して新しいタブを開く`create`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#open-new-tab-bypassing-tsts-tab-control-behavior)を実装
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.7.3 (2021.3.1)
   * Firefox 88以降と互換性のある「左（上）のタブを閉じる」機能をコンテキストメニューに追加
   * 既知のヘルパーアドオンの情報をFirefox Syncで同期しないようにした（TSTが動的に更新された後にヘルパーアドオンが初期化されないことがある問題が発生しないようにした）
   * 「その他の契機で開かれたタブ」の設定がTSTのサイドバー上の新規タブボタンや新規タブメニューから開かれたタブに適用されないようにした
   * タブのドラッグ＆ドロップ操作中にドロップ対象がよく見えるように、タブのドラッグ中のフィードバック画像を、Firefox自身の物と同様にポインタの右下に表示するようにした
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.7.2 (2021.2.19)
   * ピン留めされたタブの表示行数を制限するようにし（初期値はサイドバーの高さの半分まで）、それを超える分のタブはホイールスクロールで表示できるようにした
   * 開かれた直後に他のアドオンによって別のコンテナーで開き直されたタブについて、より正確にツリー構造を維持するように↓
   * 複数のタブを一度に閉じた後でCtrl-Shift-Tabでタブを復元した際に、タブが二重に復元されないようにした
   * 「それ以外の契機で開かれたタブ」の挙動を制御するようにしているときに、最上位のレベルのタブを閉じて開き直した際の復元位置がおかしくなっていたのを修正（最近のバージョンでの後退バグ）
   * 親タブが単独で閉じられたときに子孫のタブをすべて閉じる挙動が選択されている場合に、不要になったグループ化用のタブの自動消去処理で子孫タブを巻き込まないようにした
   * 親タブが単独で閉じられたときに、親タブをグループ化用のタブで置き換える挙動が選択されていても機能しなくなっていたのを修正（最近のバージョンでの後退バグ）
   * 折りたたまれたツリーをキーボードショートカット経由で閉じる際に、子孫のタブを閉じるかどうかの確認が表示されなくなっていたのを修正（最近のバージョンでの後退バグ）
   * タブがツリーから切り離されたときに、ツリー構造を壊さないように既存のすべての子孫タブの後の位置に移動する挙動が働かなくなっていたのを修正（最近のバージョンでの後退バグ）
   * `ui.key.accelKey`で変更されたFirefox自身のアクセラレータキーを認識するための上級者向け設定を追加
 - 3.7.1 (2021.2.12)
   * 通常のウィンドウとプライベートウィンドウとで、新しいタブの開き方を明示するボタンを同じ位置に表示するようにした
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.7.0 (2021.2.9)
   * タブ内に表示するコンテナー識別用のバーの表示のされ方を、Firefox本体のタブの物と似た形に変更した
   * ユーザースタイル入力欄のシンタックスハイライトに対応（[CodeMirror](https://codemirror.net/)を使用）
   * ユーザースタイル入力欄の高さの変更状態を記憶するようにした
   * 動的に表示・非表示が切り替わったツールバーによって引き起こされるサイドバーの内容の表示のずれについて、初期状態では、通常の（フルスクリーンモードでない）ウィンドウでのサイドバー内でのマウス操作が契機の場合にのみ、表示のずれをキャンセルするようにした
   * 既存の設定項目でカバーされていなかった他のケース全般について、タブを開く位置の制御を可能とする上級者向け設定を追加した
   * Firefox自体の動作と同様に、プライベートウィンドウでは「コンテナーを開きなおす」などのコンテナータブ関連の機能を無効化するようにした
   * APIの改善：[任意のタブからの位置関係でタブを取得するための、`*-of-<id>` 接尾辞が付いたキーワード指定](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#basics-to-specify-tabs)に対応した
   * APIの改善：[ツリー構造に基づいてタブを取得するための `lastDescendant` キーワード指定](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#basics-to-specify-tabs)に対応した
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
   * `de`ロケール更新（by [SammysHP](https://github.com/SammysHP), thanks!）
 - 3.6.5 (2021.1.8)
   * `about:logins`, `about:profiling`, `about:protections` および `about:robots` のタブについて、Firefox組み込みの物と同じfaviconを表示するようにした
   * 外部アプリケーションから開かれたタブをより正しく検出するようにした（今までは、すべてのFirefoxのウィンドウが非アクティブな状態で`openerTabId`を伴って開かれたタブのみが、「外部アプリケーションから開かれたタブ」として検出されていた）
   * 初期化処理の最中、初期化前のメニュー要素が見えてしまわないようにした
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.6.4 (2020.12.21)
   * (*, 0)のような座標に置かれたフルスクリーン表示でないウィンドウの通常のタブにおいて、サイドバーの内容が意図せず上にずれて表示されていたのを修正
   * 一時的に表示されたツールバーのためにサイドバーの内容をずらして表示する動作を無効化する上級者向け設定を追加
   * Firefox 84以降での[Tree Style Tab Mouse Wheel](https://addons.mozilla.org/firefox/addon/tree-style-tab-mouse-wheel/)との非互換性を修正（[Thanks to @MISONLN41!](https://github.com/piroor/treestyletab/pull/2784)）
   * キーボードショートカット Ctrl-Shift-PageUp/PageDownで現在のタブが移動された場合に、サイドバーのスクロール位置をタブに追従するようにした
   * キーボードショートカットでタブがツリー配下から最上位の階層に移動されたときに、タブが非表示のままになっていたのを修正
   * 背景色描画のための要素の後ろに置かれているダミーのタブ要素を完全に非表示とした
   * `tab_background_text`などのテーマ由来の色を参照するためのカスタムプロパティについて、`--theme-colors-tab_background_text-30`のように10％刻みでで数値の接尾辞を使って不透明度を変えられるようにした（この例では`tab_background_text`の色で不透明度30%ということになる）
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.6.3 (2020.12.2)
   * [Firefox 84以降での新規タブでのブックマークツールバー](https://bugzilla.mozilla.org/show_bug.cgi?id=727668)と、フルスクリーンモードでのナビゲーションツールバーについて、ツールバーの表示・非表示が切り替わったときにサイドバーの内容の視覚的なズレを打ち消すようにした（見えなくなったタブを操作したい場合はサイドバーの内容の上端付近にカーソルをあてて少し待ってください）
   * コンテキストメニューの「他のタブを閉じる」「下のタブを閉じる」で非表示のタブを閉じないようにした（Firefox本体の機能と動作が異なっていたのを修正した）
   * [Simple Tab Groups](https://addons.mozilla.org/firefox/addon/simple-tab-groups/)などの他のアドオンによってタブがウィンドウ間を移動された場合の互換性を向上した（そのような場面でタブの`openerTabId`を積極的には消去しないようにした）
   * Firefox 73以降の環境で、Fiキーおよびツールバーボタンによるサイドバーの切り替え動作の応答性を向上
   * 既に閉じられたサイドバーとの間の接続を強制切断するまでの待ち時間を5秒から0.5秒に減らした
   * 親タブだったタブがCtrl-Shift-Tで開き直された場合にツリー構造が復元されなくなっていたのを修正
   * ネットワークエラーが表示されているタブについて、Firefox本体のタブと同様、警告のアイコンを見やすい色で表示するようにした
   * 「何もしない/何もしない」が選択されている場合はタブのドラッグ操作でドラッグセッション自体を開始しないようにした
   * タブをクリックしたときにFirefoxのIPC周りのバグに起因して意図せずドラッグセッションが開始される問題を、より起こりにくいようにした
   * ブックマークの既定の保存先をFirefox 84以降に合わせて「ブックマークツールバー」に変更した
   * Linux環境では「ここをクリック」ではなく「ボタンをクリック」という文言を使って、デスクトップ通知自体ではなくボタンをクリックするよう案内するようにした
   * ユーザースタイル入力欄でのキー操作中にカーソル位置がより失われにくいようにした
   * アニメーション効果が無効の場合に、サイドバーの内容が新しく開かれたタブの位置までスクロールされなくなっていたのを修正（3.5.33での後退バグ）
   * アニメーション効果が無効の場合に、タブが画面外で開かれたことを示す青いグラデーションが表示されなくなっていたのを修正（3.5.33での後退バグ）
 - 3.6.2 (2020.11.19)
   * F1キーおよびツールバーボタンによるサイドバーの切り替え処理をより安定化（既に閉じられたサイドバーのページとバックグラウンドページの間で接続が意図せず残ってしまうせいでサイドバーの状態を把握できなくなっていたのを修正）
   * ユーザースタイル入力欄でのキー操作中にカーソル位置が失われないようにした
   * 予期しない`dragend`イベントによってタブが意図せずウィンドウから切り離されたり移動されたりする現象を起こりにくくした
   * 上級者向け設定として、タブのドラッグ&ドロップ操作を完全に無効化する選択肢を追加
   * APIエラーの修正：`{ type: 'get-tree', windowId: (integer) }`に対して（単一のツリー項目ではなく）APIドキュメントの説明どおりに最上位のツリー項目の配列が返るようになった
 - 3.6.1 (2020.11.10)
   * 独自の確認ダイアログが動作しなくなっていたのを修正（3.6.0での後退バグ）
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.6.0 (2020.11.06)
   * Firefox Sync経由でコンテキストメニューからタブを他の端末に送信できるようにした（[Firefox Syncを直接利用するWebExtensions APIが当面実装されない模様](https://bugzilla.mozilla.org/show_bug.cgi?id=1417183)なので、Sync Storageベースで暫定的に実装した）
   * メニュー項目とキーボードショートカット用コマンドから「選択中のタブを新しいグループにする」「タブのグループ化を解除」「現在のタブを1階層深くする」「現在のタブを1階層浅くする」を削除した（これらの機能は新しいヘルパーアドオンの[TST More Tree Commands](https://addons.mozilla.org/firefox/addon/tst-more-tree-commands/)に分割されました）
   * [Simple Tab Groups](https://addons.mozilla.org/firefox/addon/simple-tab-groups/)のようにウィンドウ間でタブを移動する機能を持つアドオンとの互換性を向上（ウィンドウをまたいでタブを移動した後もツリー構造が壊れにくくなった）
   * ウィンドウ間でタブを移動した後にタブバーの内容の溢れ状態が更新されていなかったのを修正
   * macOSでブラウザウィンドウがフルスクリーン表示になっているときに、複数タブを閉じる確認などのダイアログがそれ自体フルスクリーン表示の1つのウィンドウになってしまっていたのを、一時的なタブの中でダイアログとして表示するように改めた
   * コンテナーのアイコンの色として「toolbar」に対応
   * [Facebook Container](https://addons.mozilla.org/firefox/addon/facebook-container/)アドオンのコンテナー用に使われる「柵」のアイコンを追加（[by maciekmm](https://github.com/piroor/treestyletab/pull/2748). Thanks!）
   * プラットフォームごとに固有の挙動をテストするためのデバッグオプションを追加
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
   * 韓国語のロケールのディレクトリ名を`kr`から`ko`に変更（by [dfkdream](https://github.com/dfkdream), thanks!）
 - 3.5.34 (2020.10.22)
   * 子タブを開く位置を制御しない設定の時に、ピン留めされたタブから開かれた子タブがグループされなくなっていたのを修正（3.5.33での後退バグ）
 - 3.5.33 (2020.10.20)
   * 子タブを開く位置を `browser.tabs.insertRelatedAfterCurrent`=`true` の時のFirefoxの動作と同様（直近に開いた子タブの隣、もしくは親タブの隣に開く）に明示的に設定する選択肢を追加
   * 親タブ自身にタブをドロップした時の子タブの挿入位置を明示的に制御する上級者向け設定を追加
   * 場合に応じて開かれるグループ化用のタブのチェックボックスの初期状態を設定する上級者向け設定を追加
   * `browser.tabs.insertRelatedAfterCurrent`=`true` 且つ `browser.tabs.selectOwnerOnClose`=`true` の状態におけるFirefoxのタブのフォーカス動作の再現度を向上（従来版では手動操作でのフォーカス移動があった後でも子タブを閉じた後に親タブにフォーカスが戻りやすかった問題を修正）
   * ピン留めされたタブから開かれた子タブの自動グループ化処理について、動作をより安定させた
   * グループ化用のタブにURLが読み込まれたときにタブを無限に再読み込みしてしまう問題を修正（[bug 1671500](https://bugzilla.mozilla.org/show_bug.cgi?id=1671500)として報告されていた現象）
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.5.32 (2020.10.11)
   * クローズボックスのクリック操作で複数のタブを一度に閉じる場面での確認ダイアログにおいて「同時に複数のタブを閉じるときは確認する」のチェック状態が保存されない問題を修正
   * 開かれてすぐに閉じられたタブの取り扱いをより安全にした（Temporary Containersなどの、新しいタブをすぐに開き直す動作をするアドオンとの互換性を向上）
   * 複数のタブを一度に閉じる操作において、処理中にタブが別経路で閉じられていても安全に動作するようにした
   * 展開したツリーの位置までタブバーがスクロールしなくなっていたのを修正（最近のバージョンでの後退バグ）
   * アニメーション効果が無効化されている場合でも、展開したツリーの位置までタブバーをスクロールするようにした
   * 閉じたツリーをすぐに開き直したときに、タブの並び順やツリー構造をより正しく復元するようにした
   * グループ化用のタブのチェックボックスの状態が意図せず失われてしまう問題を修正（最近のバージョンでの後退バグ）
   * 設定をインポートした際に、ユーザースタイル定義の入力欄の内容が更新されていなかったのを修正
   * `ext+treestyletab:tabbar`のエイリアスとして`ext+treestyletabi:sidebar`を受け付けるようにした
 - 3.5.31 (2020.10.4)
   * グループ化用タブのタイトルが正しく復元されなくなっていたのを修正（3.5.30での後退バグ）
 - 3.5.30 (2020.10.4)
   * サイドバー用のページを読み込む際、`ext+treestyletab:tabbar?title=...` のようにURLパラメータ `title` でページのタイトルを制御できるようにした（[Tree Style Tab in Separate Window](https://addons.mozilla.org/firefox/addon/tst-in-separate-window/)などのアドオンとの互換性向上のため）
   * `ext+treestyletab:tabbar` と指定してサイドバー用のページを読み込む際、選択された組み込みのテーマを反映した状態でページを読み込むようにした（[Tree Style Tab in Separate Window](https://addons.mozilla.org/firefox/addon/tst-in-separate-window/)などのアドオンとの互換性向上のため）
   * サイドバー用のページの読み込み時に、組み込みのテーマの選択情報が指定されていない場合でもブラウザのテーマとユーザー定義のスタイルを正しく反映するようにした（[Thank you Lej77!](https://github.com/piroor/treestyletab/pull/2733)）
 - 3.5.29 (2020.10.4)
   * ユーザースタイル定義の入力欄の「ファイルから読み込み」ボタンについて、画像を選択した場合はカーソル位置にdata: URIを埋め込むようにした
   * ユーザースタイル定義の入力欄でファイルのドラッグ＆ドロップを受け付けて「ファイルから読み込み」ボタンと同等のことをできるようにした（ただし、[Bug 1408756](https://bugzilla.mozilla.org/show_bug.cgi?id=1408756)のため、アドオンマネージャ内での埋め込み状態ではなく独立したタブとして設定画面を開いている状態でのみ有効です）
   * Firefoxの外から開かれたタブに親タブや現在のタブからコンテナーを継承する設定が機能していなかったのを修正
   * タブがユーザーによって明示的に規定以外のコンテナーで開かれた場合、コンテナーを親タブや現在のタブから無理に継承しないようにした
   * グループ化用のタブ内のツリー項目が多いときに、不要な縦スクロールバーを表示しないようにした
   * グループ化用のタブ内のツリー項目が何重にも表示されてしまうことがあったのを修正（最近のバージョンでの後退バグ）
   * 自動生成するブックマークフォルダー名のプレースホルダーとして、「年」の下2桁を表す `$SHORT_YEAR%` に対応した
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.5.28 (2020.9.29)
   * ハイコントラストモードでのアクティブなタブとクローズボックスの視認性を向上
   * 複数のタブが同時に開かれた場合などのタブの並び順の補正処理が機能しなくなっていたのを修正（3.5.24での後退バグ）
   * 閉じられた親タブとその子タブの間で、子タブを閉じた後にフォーカスが次の兄弟タブでなく常に親タブに移ってしまう問題を修正
   * タブバー上にURL出ない文字列がドロップされた時に、既定の検索エンジンでの検索が行われなくなっていたのを修正
   * セッション復元後などにグループ化用のタブの復元が意図せず中断される場合があったのを修正
   * ドラッグ＆ドロップ操作の通常の選択肢として、ドロップされたタブを別ウィンドウに切り離さない選択肢を追加した
   * 新しく開かれたタブのコンテナーをより細かく制御できるようにした（継承なし、現在のタブから継承、ツリーの親から継承のいずれかから選択）
   * くらいテーマが使用されている状況でタブの読み込み状況インジケータがタブのラベルと同じ色で表示されなくなっていたのを修正
   * 「Sidebar」テーマでタブのラベルに不要な下線が表示されていたのを修正
   * 「Plain」をWindowsとLinuxでの既定のテーマとして正しく設定するようにした
   * 「すべての設定」のUIの不備を改善：インポートした設定をUIに即座に反映し、また、数値型の一部の設定項目で小数が不正な値として警告されてしまわないようにした
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.5.27 (2020.9.6)
   * [プラットフォームの設定でアニメーション効果が抑制されている場合](https://developer.mozilla.org/ja/docs/Web/CSS/@media/prefers-reduced-motion)に、視覚的な変化をより抑制するようにした
   * プラットフォームの設定を無視してアニメーション効果を有効化するための上級者向け設定を追加
   * `de`ロケール更新（by [SammysHP](https://github.com/SammysHP). Thanks!）
 - 3.5.26 (2020.9.3)
   * [プラットフォームの設定でアニメーション効果が抑制されている場合](https://developer.mozilla.org/ja/docs/Web/CSS/@media/prefers-reduced-motion)、全体的にアニメーション効果を無効化するようにした
   * プラットフォームの設定でアニメーション効果が抑制されている場合、タブの読み込み中のアニメーションを無効化するようにした
 - 3.5.25 (2020.9.2)
   * タブバーのスクロール位置を固定する処理のパフォーマンスを改善
   * コンテキストメニューに「グループ化を解除」を追加
   * 更新通知のポップアップから変更履歴に遷移するようにした
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
   * 英語ロケールの誤記訂正（by [reaverxai](https://github.com/reaverxai), thanks!）
 - 3.5.24 (2020.8.28)
   * Firefox本体のタブバーの「中程にあるタブをマウス操作で閉じている間はスクロール位置を維持する」動作を真似るようにした
   * 非常に長いタイトルのタブがあるときに、タブをまとめて閉じる際の確認ダイアログの幅が大きくなりすぎないようにした
   * ブックマークのURLのホスト名部分が「www.」で始まる場合でも、ブックマークから開かれたタブをより正しく検出するようにした
 - 3.5.23 (2020.8.26)
   * 組み込みのテーマの["Vertigo"](https://github.com/piroor/treestyletab/wiki/Vertigo-theme-%28patch-for-the-theme-%22Plain%22%29)と["Mixed"](https://github.com/piroor/treestyletab/wiki/Mixed-theme-%28patch-for-the-theme-%22Plain%22%29)を削除した（[ユーザースタイル定義](https://github.com/piroor/treestyletab/wiki/Code-snippets-for-custom-style-rules#restore-old-built-in-themes)での代替は可能です）
   * タブのクローズボックスのhover時とactive時の見た目をFirefoxのタブのクローズボックスに合わせるようにした
   * タブのクローズボックス上でボタンを押してボタン外までドラッグし、再びボタン上にカーソルを戻してボタンを放したときに、Firefoxのタブ同様にタブを閉じるようにした（動作を揃えるようにした）
   * 「装飾なし」テーマ選択時でもタブのクローズボックス等が見えるように既定の色を指定するようにした
   * ツリーの状態のキャッシュをタブではなくウィンドウに対するメタデータとして保存するようにした
   * リンクなどをサイドバーにドロップした時に開かれたタブが適切にツリーに組み込まれなくなっていたのを修正（最近のバージョンでの後退バグ）
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.5.22 (2020.8.12)
   * TST外の要因でタブのフォーカスが切り替わった後の、Shift-クリック時にクリックされたタブとアクティブなタブの間のタブが正しく選択されない問題を修正
   * Simple Tab Groupsなどの他のアドオンによって一度にタブの表示状態が切り替えられた後の場面で、閉じたタブを正しく元通りの位置に開き直すようにした
   * 大きなユーザースタイル定義をより安全に保存するようにした
 - 3.5.21 (2020.8.8)
   * グループ化用のタブの内容にユーザースタイル定義が反映されなくなっていたのを修正（3.5.20での後退バグ）
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.5.20 (2020.8.7)
   * すべての場面でPNGアイコンでなくSVGアイコンを使うようにした
   * Linux上でDarkテーマでないときだけ、既定の設定としてシステムカラーを使うようにした
   * 保持できるユーザースタイルシートの最大サイズを8KBから48KBに拡大した
   * 変更点の通知を煩わしい新規タブではなくデスクトップ通知で表示するようにした
 - 3.5.19 (2020.8.4)
   * テーマのツールバーの色をタブの色に反映するようにした
   * テーマで`hsl()`や`hsla()`が使われている場合の表示を修正
 - 3.5.18 (2020.8.4)
   * 復元したタブの元々の親だったタブが既に閉じられてしまった後であっても、タブをツリー内の適切な位置に復元するようにした（3.5.16での後退バグ）
   * 「表示中のタブに基づいてツリー構造を自動的に修正する」モードの時に、復元したタブのツリー構造が復元されない問題を修正（3.5.17での後退バグ）
 - 3.5.17 (2020.8.3)
   * Firefoxを起動した時に非表示状態で復元されたタブについて、閉じた後に「閉じたタブを開き直す」で誤った位置に復元されてしまう問題を修正
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.5.16 (2020.8.1)
   * 組み込みのテーマの["Metal"](https://github.com/piroor/treestyletab/wiki/Metal-theme)と["Plain Dark"](https://github.com/piroor/treestyletab/wiki/Plain-Dark-theme-%28patch-for-the-theme-%22Plain%22%29)を削除した（[ユーザースタイル定義](https://github.com/piroor/treestyletab/wiki/Code-snippets-for-custom-style-rules#restore-old-built-in-themes)での代替は可能です）
   * OSの暗い配色と明るいテーマの組み合わせでアクティブなタブの色が暗くなってしまう問題を修正
   * [Windows 10のハイコントラストモードでサイドバーや設定画面の内容をまったく読めなくなってしまう問題](https://bugzilla.mozilla.org/show_bug.cgi?id=1656637)を回避するようにした
   * ブラウザのテーマに設定された画像のタイリング設定を尊重し、設定が無い場合は画像の縦横比が4:1より横長の場合繰り返しに不適当と判断して拡大表示するようにした
   * Linux環境において初期状態ではシステムカラーを参照するように戻した
   * 復元されたタブが非表示のときは、非表示のタブの子として復元できるようにした
   * タブでないオブジェクトのドラッグ＆ドロップ時に余計なエラーが発生しないように↓
 - 3.5.15 (2020.7.30)
   * ブラウザのテーマで設定された背景画像を反映する際、繰り返し表示する代わりにサイドバー全体に拡大表示するようにした
   * ツリー構造を可視状態のタブに合わせて自動的に修復する設定のとき、復元されたタブの元の親タブが非表示の場合は子タブにしないようにした
 - 3.5.14 (2020.7.29)
   * サイドバー上のコンテキストメニューから複数のタブを閉じるときに確認が表示されなくなっていたのを修正（最近のバージョンでの後退バグ）
   * Linux環境においてもPhotonの配色を常に反映するようにした
   * Mixed, Plain, Vertigoを使用している時は、常にブラウザのテーマをサイドバーの内容に反映するようにした
   * Facebook Containerなどのアドオンによって最上位の階層のタブが他の最上位のタブの直前に移動された場合の互換性を向上
   * ブックマークのプロパティダイアログの入力欄をウィンドウに合わせて拡大するようにした
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.5.13 (2020.7.21)
   * 複数のタブを閉じるときや一度に開かれたタブをグループ化するときに、確認のダイアログに対象のタブの一覧を表示して、どのタブを操作しようとしているか示すようにした
   * タブの選択（アクティブ）状態、ピン留め状態、非表示状態、折りたたみ状態が正しく反映されないことがあったのを修正（3.5.12での後退バグ）
   * MetaulとSidebarテーマにおいて、タブを複数選択したときに非選択状態のタブの見た目が変わらなくなっていたのを修正（3.5.12での後退バグ）
   * 一度に複数のタブが閉じられた後の復元操作について、ツリー構造をより正しく復元するようにした
 - 3.5.12 (2020.7.12)
   * バックグラウンドページからサイドバーページへ非同期に通知されるメッセージの取り扱いをより安定化させた（特にセッション復元時に顕著だった、インデントの深さやツリーの開閉状態などが崩れることがあった問題を解消）
   * ユーザー定義のスタイル指定でのカスタマイズにおいて、コンテナータブの特定に `tab-item[data-contextual-identity-name="Personal"]` のようなセレクタを使えるようにした
 - 3.5.11 (2020.7.12)
   * TSTの外からタブが閉じられた際、複数のタブを閉じる操作の確認のダイアログを、TSTのタブが閉じられる前ではなく閉じられた後に表示するようにして、タブを閉じたときの応答性を改善した
   * タブの上でクリックした直後に同じ座標でタブバー自体がクリックされた場合は、意図した操作ではないと見なして無視するようにした
   * ユーザー定義のスタイル指定をCSSファイルとして保存したりCSSファイルから読み込んだりできるようにした
 - 3.5.10 (2020.7.11)
   * Windows 7のクラシックテーマ使用時に、文字を通常通りの太さで表示するようにした
   * 既定のキーボードショートカットを`manifest.json`で静的に定義するようにした（これにより、意図せずショートカットが失われる問題が発生しなくなる事が期待されますが、Firefox 74以前のバージョンでは初期ショートカットを割り当て解除できなくなります）
   * 「新しいタブ」ボタンの上などで表示されるポップアップについて、フォーカスされた項目が既に可視領域の中にある場合はポップアップ全体をスクロールしないようにした
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.5.9 (2020.7.10)
   * タブをそのタブ自身の親の直後にドロップした時に1階層昇格する動作が機能しなくなっていたのを修正（最近のバージョンでの後退バグ）
 - 3.5.8 (2020.7.10)
   * [TST Hoverswitch](https://addons.mozilla.org/firefox/addon/tst-hoverswitch/)などの`tab-mouseover` APIを使用しているアドオンが動作しなくなっていたのを修正（[by Klemens Schölhorn, thanks!](https://github.com/piroor/treestyletab/pull/2633)）
   * TSTの外で行われた捜査によって複数のタブが閉じられる場面では不要な確認を表示しないようにした
   * 初回起動時に開くタブの内容がセンタリングされなくなっていたのを修正
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.5.7 (2020.7.6)
   * `ext+treestyletab:*` 形式の短縮URIをリダイレクトする際にクエリーパラメーターが正しく引き継がれていなかったのを修正
 - 3.5.6 (2020.7.5)
   * Firefox 78以降のコンテキストメニューに合わせ、「下のタブを閉じる」「他のタブをすべて閉じる」を「複数のタブを閉じる」サブメニューの下に置くようにした
   * TST上での操作で複数のタブが一度に閉じられた後、閉じられたタブ群の中の1つが「閉じたタブを元に戻す」で開き直された場合、他に同時に閉じられたタブも可能な限り復元するようにした
   * アニメーション効果がOFFのときは、ツリーのインデント幅の自動調整を即座に反映するようにした
   * OSの設定でアニメーション効果が無効化されている時は、TSTのアニメーション効果も無効化するようにした
   * 「新しいタブ」ボタンのミドルクリックの動作をCtrl-クリックと同じに設定できるようにした
   * ブックマークフォルダから開かれたタブ群の検出と自動グループ化処理を高速化した
   * Firefoxのタブと同様、コンテナータブのツールチップにコンテナー名を表示するようにした
   * グループタブ内でコンテナータブをそれらしく表示するようにした
   * グループタブ内のツリーの列幅を `:root.group-tab { --column-width: 30em; }` のようなスタイル指定で変更できるようにした
   * `tab-mousedown` および `tab-mouseup` の通知を介して、タブのクリック時のTSTの既定の動作をより正しくキャンセルするようにした
   * `ext+treestyletab:tabbar?windowId=(Window.id)` というURIでタブバーを任意のタブやウィンドウで開けるようにした（[TST in Separate Window](https://addons.mozilla.org/firefox/addon/tst-in-separate-window/)のようなアドオン向けの変更）
   * `sidebar-show` および `sidebar-hide` の通知について、現在開かれているタブバーのページの数を含めるようにした
   * Firefox 79以降のバージョンにおいて、`browser.tabs.warmup()`を使用してタブの切り替え時の応答性を向上した
   * 不要など浮きデータを消すなどして、Syncのストレージの使用量を減らすようにした[（ストレージの送料は100KB、個々の設定項目ごとには16KBまでという容量制限があり、特にカスタムユーザースタイルなどがこの上限を超えると同期されなくなることに注意してください）](https://github.com/piroor/treestyletab/issues/2623)
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.5.5 (2020.6.6)
   * DPI値が異なる画面をまたいでウィンドウを移動した後にツリーの描画が崩れていたのを修正
   * 複数のタブが一度に開かれた時に自動的にグループ化する機能について、同じブックマークフォルダから開かれたと思われるタブに対してのみ発動するように初期動作を変更し、自動グループ化機能の設定をより単純化した
   * 設定画面でチェックボックスとラジオボタンのクリック可能な領域を最小限に縮小した
   * サイドバー上の新規タブボタン上でのCtrl-クリックとShift-クリックの動作をFirefoxネイティブのタブバーの動作に合わせた（Ctrl-クリックで現在のタブの隣にコンテナーを継承して新しいタブを開く、Shift-クリックで新しいウィンドウを開く）
   * `browser.tabs.insertAfterCurrent`=`true`の時に折りたたまれたツリーの親タブの隣（＝折りたたまれたツリーの中）に新しいタブが開かれた場合はツリーを自動展開するようにした
   * `browser.tabs.closeTabByDblclick`=`true`の時の動作をシミュレートする設定を、タブのダブルクリックに対する割り当て操作の設定と統合した
   * グループタブの内容にもユーザー定義のスタイル指定を反映するようにした
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.5.4 (2020.5.5)
   * モーダル風ダイアログの表示サイズを、実際にウィンドウを開く前にある程度計算するようにして、初期化前のウィンドウによる不快なチラつきを低減した
   * 設定ページの「外観」配下に、ダイアログをサイドバー内に表示する（確認とブックマークのダイアログの動作を以前の物に戻す）設定を追加
   * グループ化用のタブ内で、ツリー構造の表示領域の下にあった無駄なスペースを減らした
   * 最近のバージョンの[Firefox Multi-Account Containers](https://addons.mozilla.org/firefox/addon/multi-account-containers/)との互換性を向上
   * [Container Bookmarks](https://addons.mozilla.org/firefox/addon/container-bookmarks/)との互換性を向上し、ブックマークをツリーとして開く際にコンテナーの情報を検出できた場合はブックマークを直接そのコンテナーのタブで開くようにした
   * [TSTのタブとサブパネルとの間のドラッグ＆ドロップを可能にした](https://github.com/piroor/treestyletab/wiki/SubPanel-API#drag-and-drop-between-your-subpanel-and-tst)（新APIの[`get-drag-data`](https://github.com/piroor/treestyletab/wiki/SubPanel-API#transfer-drag-data-from-a-subpanel-to-tst)を含む）
   * [サブパネル上でのネイティブコンテキストメニューの表示に対応した](https://github.com/piroor/treestyletab/wiki/SubPanel-API#how-to-provide-custom-context-menu-on-your-subpanel)（新APIの[`override-context`](https://github.com/piroor/treestyletab/wiki/SubPanel-API#override-the-context)を含む）
   * コンテキストメニューに関わるAPIについて、`fake-contextMenu-*` という体系だったのを `fake-` プレフィクスなしの `contextMenu-*` に改めた（後方互換性のため、従来通りのAPI名も引き続き使用可能）
   * `de`ロケール更新（by [SammysHP](https://github.com/SammysHP). Thanks!）
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.5.3 (2020.4.28)
   * モーダル風ダイアログがクローズボックスで閉じられた時の挙動を改善
   * モーダル風ダイアログを開くのに要する時間を若干短縮した
   * ブックマークの件数が非常に多い場合のブックマークフォルダ選択UIの動作を最適化
   * ブックマークの保存先として設定されたフォルダが存在しなくなった場合、「その他のブックマーク」を自動的に選択するようにした
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.5.2 (2020.4.25)
   * モーダル風ダイアログの実装を改善した（安定性の向上、ネイティブのダイアログを模したボタンの配置、Darkモードへの対応、閉じられたダイアログが「最近閉じたウィンドウ」の一覧になるべく現れないようにした）
 - 3.5.1 (2020.4.24)
   * Firefox ESR68でポップアップウィンドウが表示されない問題を修正（3.5.0での後退バグ）
 - 3.5.0 (2020.4.23)
   * 各種ダイアログをモーダル風ポップアップウィンドウで表示するようにした
   * プライベートウィンドウではコンテキストメニューの「コンテナーを開きなおす」を表示しないようにした（Firefox本体の動作に合わせた）
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.4.10 (2020.4.19)
   * ブックマークフォルダ上のコンテキストメニューの「ツリーとしてすべて開く」で開かれたタブに適切にタイトルが設定されていなかった問題を修正
   * `browser.tabs.insertAfterCurrent`が`true`のときに、ブックマークフォルダ上のコンテキストメニューの「ツリーとしてすべて開く」でタブが開かれると順番やツリー構造がおかしくなっていたのを修正
   * 新しい通知型のAPIを追加: [`try-fixup-tree-on-tab-moved`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#suppress-autofixing-of-tree-structure-for-moved-tabs)
 - 3.4.9 (2020.4.16)
   * ツリーや複数タブのドラッグ＆ドロップでブックマークが作成されたときに、項目をフォルダにまとめてツリー構造を保持するようにした
   * キーボードショートカット「Ctrl-Shift-PageDown」でツリーを下方向に移動できなかったのを修正
   * ドラッグ＆ドロップ操作などの後で、不可視状態のタブが最上位に取り残される場合があったのを修正
   * ヘルパーアドオンが削除または無効化された後に偽コンテキストメニューが表示されなくなる問題を修正
   * ドキュメントの説明どおり、`{type:"get-tree",windowId}`のようなAPI呼び出しで当該ウィンドウの最上位のタブの配列を返却するように修正
   * 初回およびフォーカスの循環時に `try-redirect-focus-from-collaped-tab` および `try-expand-tree-from-focused-collapsed-tab` で通知される `focusDirection` の値がおかしかったのを修正
   * 不可視状態のタブについてAPI経由でツリー構造を編集した後で、タブが不可視のままにならないようにした
   * [APIまわりのパフォーマンスを向上](https://github.com/piroor/treestyletab/issues/2554)（by [account-login](https://github.com/account-login). Thanks!）
   * 英語ロケールの誤記を修正（by [jaens](https://github.com/jaens). Thanks!）
   * `zh_CN`ロケールで「タブのツリー」の項目にアクセスキーを設定（by [no1xsyzy](https://github.com/no1xsyzy). Thanks!）
 - 3.4.8 (2020.3.27)
   * 新しく開かれたタブがすぐにフォーカスを失ったときに、表示上フォーカスされた状態のままになってしまっていたのを修正
   * 未処理のエラーが原因でヘルパーアドオンの登録が意図せず解除されてしまっていたのを修正
   * タブでない要素からタブの上にカーソルを移動した後のmouseupに対応する`tab-mouseup`と`tab-clicked`の通知において、`tab`の内容がmouseupしたタブではなく`null`になってしまっていたのを修正
   * 最初のピン留めされていないタブを開き直した後にエラーが発生していたのを修正
   * ドラッグ＆ドロップ操作の設定の説明をより分かりやすくした
   * `zh_CN`言語リソース更新（by [NightSharp](https://github.com/NightSharp), thanks!）
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw), thanks!）
 - 3.4.7 (2020.3.17)
   * リンクやその他のオブジェクトをタブにドロップできない場合があったのを修正（最近のバージョンでの回帰バグ）
   * 設定画面自体を新規タブで開くためのリンクを、設定画面の最上部に追加した
   * 設定画面の最下部に「Reset All」ボタンを追加した
   * `de`ロケール更新（by [SammysHP](https://github.com/SammysHP). Thanks!）
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw). Thanks!）
 - 3.4.6 (2020.3.12)
   * コンテキストメニューとキーボードショートカット用コマンドに「ツリーを再帰的にたたむ」「ツリーを再帰的に展開する」を追加した
   * 以下のコンテキストメニュー項目で、未読リックによる動作の反転に対応した：ツリーをリロード/配下のタブをリロード、ツリーを閉じる/配下のタブを閉じる、1レベルだけたたむ/再帰的にたたむ、1レベルだけ展開する/再帰的に展開する
   * 以下のコンテキストメニュー項目（および対応するキーボードショートカット）で、タブの複数選択に対応した：ツリーをリロード、配下のタブをリロード、ツリーを閉じる、配下のタブを閉じる、指定したツリー以外を閉じる、ツリーをたたむ、ツリーを展開する
   * サイドバーが非表示のときに、親タブを閉じる動作をツリー全体ではなく親タブ単独に対してのみ反映する上級者向け設定を追加（既定でON）
   * 親タブを閉じたときの挙動について、「Firefox本体のタブバーと併用するユーザー」向けの設定が既定になるようにした（そのようになることが期待されていたが、設定の移行処理によって意図せず別の設定になってしまっていた）
   * APIの[`collapse-tree`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#collapse-expanded-tree)と[`expand-tree`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#expand-collapsed-tree)で、`recursively`オプションで効果を再帰的に反映するかどうかを選択できるようにした
   * `fake-contextMenu-click`の通知内容に、クリックされたマウスのボタンを示す`button`を含めるように↓
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw). Thanks!）
 - 3.4.5 (2020.3.9)
   * Firefox自身のタブと同じ操作性にするために、開閉つまみ、音声再生ボタン、クローズボックス上でのCtrl-クリックおよびShift-クリックはタブの複数選択の操作として扱うようにした
   * [TST Lock Tree Collapsed](https://addons.mozilla.org/firefox/addon/tst-lock-tree-collapsed/)、[TST Active Tab in Collapsed Tree](https://addons.mozilla.org/firefox/addon/tst-active-tab-in-collapsed-tr)との併用時の挙動を改善
   * 新しい通知型のAPIメッセージを追加した：[`try-redirect-focus-from-collaped-tab`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#suppress-unintentional-focus-change-by-tst)
 - 3.4.4 (2020.3.8)
   * mousedownの時点でタブをアクティブにするように挙動を戻した（TST 3.1.0以降での後退バグによって意図せずこの動作が失われていたのを修正）
   * ヘルパーアドオンにによってツリーが折りたたみ状態で固定されている場合についても、Ctrl-Tab/Ctrl-Shift-Tabでのタブ切り替え中に、折りたたまれた子孫タブを飛ばすようにした
   * `tab-mousedown`がキャンセルされても[`tab-mouseup`、`tab-clicked`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#when-a-tab-is-clicked)を通知するように戻した（キー入力に関するイベントの仕様と混同していた）：[Move unloaded tabs for Tree Style Tab](https://addons.mozilla.org/firefox/addon/move-unloaded-tabs-for-tst/)との互換性が損なわれていた後退バグの修正
 - 3.4.3 (2020.3.7)
   * ユーザースタイルシートによる既知のカスタマイズとの互換性を向上
 - 3.4.2 (2020.3.7)
   * Linuxにおいて「Plain Dark」の配色がおかしくなっていたのを修正（3.4.0での後退バグ）
 - 3.4.1 (2020.3.6)
   * 音声再生状態を示すインジケータをクリックできなくなっていたのを修正（3.4.0での後退バグ）
 - 3.4.0 (2020.3.6)
   * 「ツリーをたたんだ状態でロック」機能を削除した（別アドオンの[TST Lock Tree Collapsed](https://github.com/piroor/tst-lock-tree-collapsed)に機能を分離した）
   * 目的を選んでドラッグ操作を開始するためのつまみを表示する機能を削除した（別アドオンの[TST Tab Drag Handle](https://github.com/piroor/tst-tab-drag-handle)に機能を分離した）
   * キーボードショートカットのカスタマイズ用UIを設定画面から削除した（Firefox ESR68の時点ですでにそのためのUIがあるため）
   * コンテンツ領域内に確認ダイアログを表示できなくなっていたのを修正（最近のバージョンのFirefoxでの後退バグ）
   * 折りたたまれたツリーに対するミュート・ミュート解除の操作でより適切に音声再生中のタブだけを制御するようにした
   * ツリー表示が無効の時に空のグループタブ内に「初期化中」という事を示すアニメーションが表示されないようにした
   * アドオンから開けないURLを伴ったブックマークを開いたときの動作をより安全にした
   * TSTのタブ以外の物をタブバーにドロップした時にエラーになっていたのを修正（最近のバージョンでの後退バグ）
   * コンテンツ領域内に確認を表示するための適切な権限を取得するようにした
   * 折りたたまれた子タブにフォーカスされたときにツリーを自動展開するかどうかの設定の内部名を、「折りたたまれた子タブにフォーカス可能とするかどうか」という趣旨の名前に変更し、親ツリーが折りたたまれる結果として現在のタブが不可視になる場面にも影響するようにした
   * `about:devtools-toolbox`のタブのアイコンについて適切なアイコンを使うようにした
   * 新しいAPIメッセージを追加した：[`set-extra-tab-contents`、`clear-extra-tab-contents`および`clear-all-extra-tab-contents`](https://github.com/piroor/treestyletab/wiki/Extra-Tab-Contents-API)
   * 新しい通知型のAPIメッセージを追加した：[`tab-dblclicked`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#when-a-tab-is-clicked)、[`tree-collapsed-state-changed`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#when-tree-is-collapsed-or-expanded)、[`try-move-focus-from-collapsing-tree`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#suppress-unintentional-focus-change-by-tst)、[`try-expand-tree-from-focused-parent`、`try-expand-tree-from-focused-bundled-parent`、`try-expand-tree-from-attached-child`、`try-expand-tree-from-focused-collapsed-tab`、`try-expand-tree-from-long-press-ctrl-key`、および`try-expand-tree-from-end-tab-switch`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#suppress-unintentional-expansion-of-collapsed-tree-by-tst)
   * <del>[`tab-mousedown`に続く`tab-mouseup`、`tab-clicked`、`tab-dblclicked`の各通知型メッセージ](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#when-a-tab-is-clicked)について、前の通知に対するキャンセル操作で確実にキャンセルできるようにした</del>
   * プライベートウィンドウへのアクセスをTST上でも許可されていない限り、他のアドオンにはプライベートウィンドウでのイベントを通知しないようにした
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw). Thanks!）
 - 3.3.6 (2020.2.21)
   * 複数のタブが選択されている場合、コンテキストメニューの「このツリーをブックマーク」の実行時にそれら（およびその配下のタブ～をすべてブックマークするようにした
   * ブックマークフォルダ上のコンテキストメニューの「ツリーとしてすべて開く」で開かれるグループタブはペンディング状態にせずすぐ読み込むようにした
   * タブのコンテキストメニューの「タブをミュート」「タブのミュートを解除」について、ツリーが折りたたまれている場合は子孫タブにも結果を反映するようにした（展開されているツリーでは今まで通り）
   * タブの音声再生中ボタンのクリック操作について、折りたたまれたツリーの場合にだけ子孫タブの状態も制御し、展開されているツリーの場合はそのタブのみ状態を変えるようにした
   * タブが非表示状態から表示状態に復帰したときのツリーの自動修復処理が期待通りに働いていない場合があったのを修正
   * 非表示のタブがある状態でタブの親子関係の変更が期待通りにならない場合があったのを修正
   * タブを移動した直後にタブが削除された場合に、無用なリロードが発生しないようにした
 - 3.3.5 (2020.1.24)
   * Ctrl-Shift-Tabでのフォーカス移動で待機状態のタブを飛ばさないようにした
   * アクティブなタブが閉じられた直後にCtrl-Tab/Ctrl-Shift-Tabでタブを切り替えたとき、折り畳まれたツリーの子孫のタブがスキップされない問題を修正
   * ピン留めされたタブを最初のピン留めされていないタブの前の位置にドロップできるようにした
   * ピン留めされていないタブを最後のピン留めされたタブの後の位置にドロップできるようにした
   * ピン留めされていて、且つアイコンの大きさに縮められていないタブについて、タブ上のドロップ位置を上下方向で判定するようにした
   * ドラッグ操作中に折りたたまれたツリーの上でしばらく待ってツリーが自動的に展開されたときに、他のツリーを折りたたむかどうかを制御する上級者向け設定を追加
   * `ru`ロケール更新（by [wvxwxvw](https://github.com/wvxwxvw). Thanks!）
 - 3.3.4 (2020.1.14)
   * 循環参照に起因する意図されないエラーを修正
   * タブの表示／非表示が切り替わった後にツリー構造が意図せず変更されるケースを減らした
   * アクティブなタブが閉じられた直後にCtrl-Tab/Ctrl-Shift-Tabでタブを切り替えたとき、折り畳まれたツリーの子孫のタブがスキップされない問題を修正
   * `kr`ロケール追加（by [BoredSomeone](https://github.com/BoredSomeone). Thanks!）
 - 3.3.3 (2020.1.12)
   * [Bug 1565170](https://bugzilla.mozilla.org/show_bug.cgi?id=1565170)が修正されて以後のバージョンのFirefoxに対応
   * タブを非表示にして再表示した後でタブのフォーカス移動がおかしくなっていたのを修正
   * Ctrl-Tab/Ctrl-Shift-Tabでのタブ切り替えの間、折りたたみ状態をロックしたツリーを展開しないようにした
   * 折りたたみ状態をロックしたツリーの配下のタブが直接選択された場合に、ツリーを自動展開できるようにした
   * タブ内に表示されるコンテンツについて、初期化完了前の物をなるべく見せないようにした
 - 3.3.2 (2020.1.9)
   * タブを誤って閉じてしまうなどの誤操作を防ぐために、クローズボックス以外のタブ内でクリック可能な要素の上でのダブルクリックに対しては組み込みの動作を行わないようにした
 - 3.3.1 (2020.1.9)
   * ツリーのダブルクリックで、ツリーをたたんだ状態のロックを切り替えられるようにした
   * ツリーをたたんだ状態にロックされている場合、新しい子タブが追加されてもツリーを展開しないようにした
   * タブがキャッシュから復元された場合に、折りたたまれた子孫タブの数が更新されない不具合を修正（最近のバージョンでの後退バグ）
   * `ru`ロケール更新（by wvxwxvw. Thanks!）
 - 3.3.0 (2020.1.8)
   * そのタブや配下のタブがアクティブになってもツリーを自動的に展開しないようにする「たたんだ状態でロック」機能を追加した（コンテキストメニューまたはキーボードショートカットで状態を設定できます）
   * ブックマークフォルダをツリーとして開くコンテキストメニュー項目を、ブックマークフォルダ上でコンテキストメニューを開いた時にだけ表示するようにした
   * 現在のタブが閉じられたり、現在のタブを含むツリーが折りたたまれたりした時に、待機状態のタブを可能な限り選択しないようにする設定を追加した
   * 折りたたまれたツリーの親タブのクローズボックスの通常クリックで複数のタブを一度に閉じる場面についての確認ダイアログを表示するかしないか制御する設定を追加
   * ツリーのつまみをPhoton風に変更
   * [macOSでのBug 1561879](https://bugzilla.mozilla.org/show_bug.cgi?id=1561879)によって意図せず引き起こされるごく短時間での不正なドラッグ操作を無視する時間を設定で変更可能にした
   * 設定画面の構成を少し見直し、上級者向けの設定を初期状態では隠すようにした（これに伴い、今までUIを提供していなかった隠し設定のいくつかを上級者向け設定として提供するようにした）
   * APIで呼び出せる新しいメッセージ型を追加：[`toggle-tree-collapsed`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#toggle-collapsed-state-of-tree)、[`lock-tree-collapsed`、`unlock-tree-collapsed` および `toggle-lock-tree-collapsed`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#set-locked-as-collapsed-state-of-tree)
   * APIで[タブを指定する際の別名](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#basics-to-specify-tabs)に `nextVisible`、`previousVisible`（`prevVisible`）、および `Cyclic` が末尾に付くバリエーションを追加
   * APIの[`scroll`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#scroll-the-tab-bar)型のメッセージにおいて、対象ウィンドウを指定する`window`パラメータの値として現在アクティブなウィンドウを指定するキーワード`active`に対応
   * 不要になったライブラリ[webextensions-lib-tab-id-fixer](https://github.com/piroor/webextensions-lib-tab-id-fixer)への依存関係を解消（by adroitwhiz. Thanks!）
   * `ru`ロケール更新（by wvxwxvw. Thanks!）
 - 3.2.6 (2019.12.27)
   * ブラウザのテーマの配色を反映する設定が有効なときはだけダークカラーを反映するようにした
   * テーマで定義される配色により高い優先度を与えるようにした
   * 複数のタブが一度に1つのツリーの中に開かれた場合に、ツリー構造が壊れることがあったのを修正
   * ブックマークフォルダ上のコンテキストメニューに「サブフォルダーも含めてツリーとしてすべて開く」を追加できるようにした
   * ブックマークフォルダ上のコンテキストメニューの「ツリーとしてすべて開く」ではブックマーク項目でないフォルダやセパレータを無視するようにした
   * 「ツリーとしてすべて開く」で開かれたタブをすぐに読み込まずにペンディング状態にするようにした
   * 子タブをウィンドウから切り離した後に親タブの子孫のタブの数の情報が更新されていなかったのを修正
   * [API経由で返される・通知されるタブの情報](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#data-format)に `bundledTabId` を追加した
   * [API経由で通知される `scrolled` 型のメッセージ](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#messages-notified-by-mouse-wheel-rotation)について、`scrollX`と`scrollZ`も参照できるようにした
   * 検索性を高めるため、日本語でのアドオン名を翻訳しないようにし、コンテキストメニュー項目のグループ化用の項目のラベルもアドオン名から「タブのツリーを操作」に変更した
   * グループ化用のタブのタイトル編集時に、日本語入力中のEnterキーで誤って入力が解除されてしまっていたのを修正
   * サブパネルを含まない他のアドオンが読み込まれたときにまでサブパネルを無駄に再読み込みしていたのを修正
   * サイドバーの再読み込み後にサブパネルのリストが空になっていたのを修正
   * バックグラウンドで再読み込みされたタブについて、実際にタイトルが変化した場合にのみ未読として取り扱うようにした
   * `ru`ロケール更新（by wvxwxvw. Thanks!）
   * `zh_CN`ロケール更新（by Siyuan Xu. Thanks!）
 - 3.2.5 (2019.11.14)
   * 暗い配色の時にタブのドロップ位置のマーカーが見えにくくなっていたのを修正
   * Plain、（Plain Dark、）Vertigo、Mixedにおいて、暗い配色が反映されている時はスクロールバーの色もそれに合わせるようにした
   * Firefox自体のキーボードショートカット管理画面において、コマンド名にアクセスキーを表示しないようにした
   * システムの配色が変更されたことを検知していくつかの色を動的に再計算するようにした
   * APIを介して[`group-tab`コマンド](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#create-new-group-from-given-tabs)が呼ばれたときに、開かれたグループタブに対応するオブジェクトを正しく返却するように修正
   * `de`ロケール更新（by SammysHP. Thanks!）
   * `ru`ロケール更新（by wvxwxvw. Thanks!）
 - 3.2.4 (2019.11.7)
   * プラットフォームで暗いテーマが既定のときに、`about:addons`の設定画面の配色を暗い色にするようにした
   * 新しいタブを開くボタンの操作に関する設定がより分かりやすくなるように、ラベルを付け直して項目を並べ替えた
   * プラットフォームで暗いテーマが既定のときに、VertigoとMixedでピン留めされたタブのハイライト表示の色がおかしくなっていたのを修正（3.2.3の後退バグ）
   * グループ化のためのタブの中に表示する既定のアイコンが文字色で表示されていなかったのを修正（3.2.3の後退バグ）
   * Linuxで暗いテーマが反映されている時に、システムの配色やFirefox自体のテーマが反映されなくなっていたのを修正（3.2.3の後退バグ）
   * API経由でブックマークフォルダの内容をツリー構造込みで開く[`open-all-bookmarks-with-structure`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#open-bookmarks-with-structure)コマンドを追加
 - 3.2.3 (2019.11.5)
   * プラットフォームで暗いテーマが既定のときに、Plain, Vertigo, Mixedを暗い色にするようにした
   * プラットフォームで暗いテーマが既定のときに、タブで開かれた設定画面、グループ化用のタブ、初回起動時のタブの配色を暗い色にするようにした
   * タブなどのUIの配色をよりPhoton Design SystemとFirefox自体の配色に合わせるようにした
   * ブラウザの起動時に前回の状態を復元する設定でない場合でも、サブパネルの開閉状態を最後のウィンドウの状態に基づいて初期化するようにした
   * Plain系のテーマでバックグラウンドのタブのhover時の強調表示が一部失われていたのを修正（3.0.xでの後退バグ）
   * `zh-TW`ロケール更新（by Bo-Sian Li, thanks!）
   * `ru`ロケール更新（by wvxwxvw. Thanks!）
 - 3.2.2 (2019.11.3)
   * 確認を表示できずに複数のタブが一度に閉じられた場合に、事後的に通知を表示するようにした（通知をクリックすると操作を取り消せます）
   * 複製元のタブがアクティブだった場合でも、複製後のタブが設定通りに元のタブの兄弟として開かれるように修正
   * いくつかのエッジケースでアクティブなタブがハイライト表示されない問題を修正
   * サイドバー外にタブがドロップされた時のウィンドウからの切り離しについて、より確実に動作するようにした（この変更は[bug 1548949](https://bugzilla.mozilla.org/show_bug.cgi?id=1548949)に対する[回避作](https://github.com/piroor/treestyletab/issues/2256#issuecomment-549072345)に基づくため、複数のFirefoxのインスタンス間でタブをドラッグ&ドロップした場合に、ドロップ先にインポートされるタブとドラッグ元でウィンドウから切り離されるタブという形でタブが複製されてしまうという、エッジケースにおける意図的な後退バグを含みます）
   * タブのラベルが長すぎるかどうかの判定処理が正しく機能しないせいで、ラベルの表示やツールチップが更新されない場合があったのを修正（3.2.0の後退バグ）
   * 以前から使われていたカスタムユーザースタイルとの後方互換性が損なわれていたのを修正（3.2.0の後退バグ）
   * タブを閉じる操作を`beforeunload`イベントでキャンセルした後でもタブを正しく閉じられるように修正（最近のバージョンでの後退バグ）
   * `ru`ロケール更新（by wvxwxvw. Thanks!）
 - 3.2.1 (2019.10.29)
   * 他のアプリケーションから開かれたタブに現在のタブのコンテナーを継承するかどうかの設定が機能していなかったのを修正
 - 3.2.0 (2019.10.28)
   * 他のアプリケーションから開かれたタブの制御に関する設定を独立させた
   * `about:addons`から開かれた検索結果のタブを子タブにするようにした
   * TST上の操作でツリーから作成したブックマークについて、ツリー構造を常に保存するようにした
   * ブックマークのコンテキストメニューに「ツリーとして開く」を追加
   * ブックマークされた内部URL（`moz-extension://...`）を短縮URL（`ext+treestyletab:...`）に自動変換し、環境をまたいだブックマークの同期をしやすくした
   * 「折りたたまれたツリー」の配下にある「展開されたツリーの配下の折りたたまれたタブ」が可視状態で復元されてしまう問題を修正
   * タブの読み込みアイコンのアニメーションのなめらかさを60FPSから30FPSに変更した（詳細は[Bug 1511095](https://bugzilla.mozilla.org/show_bug.cgi?id=1511095)を参照して下さい）
   * グループ化用のタブのコンテンツ領域にグループ化用のタブが表示される場合に、アイコンをフォルダー型で表示するようにした
   * 保守性の向上のためにビューをcustom elements（Web Components）で再実装した（Thanks to saneyuki!）
   * `ru`ロケール更新（by wvxwxvw. Thanks!）
 - 3.1.8 (2019.9.13)
   * パフォーマンス向上とメモリ消費抑制のために内部の処理を若干最適化した（bb010g氏の提案に基づく改善。ありがとうございます！）
   * ツリー構造においてタブの循環参照が発生しにくくなるように対策を強化
   * 現在のタブと同じサイトの子タブが開かれた時に、設定に従って現在のタブのコンテナーを継承した状態でタブを正しく開き直すようにした
   * ユーザーが新規タブのページを空に設定している時に、単一のタブを開き直しても新しい空のタブ向けの挙動（現在のタブの子タブにするなど）を反映しれないようにした
   * ユーザーが新規タブのページを空に設定している時に、Ctrl-Tなどによって開かれた新しい空のタブ向けの挙動（現在のタブの子タブにするなど）をブックマークやロケーションバーから開かれたタブにまでは反映しないようにした
   * 親タブを開き直したときに子タブの順番を反転しないようにした
   * サイドバー内で親のタブを単独で閉じる操作をしたときに、ユーザーが設定したカスタムの動作が正しく反映されていなかったのを修正
   * 他のFirefoxのインスタンスからドラッグされたタブをURLのドロップとして受け入れるようにした
   * Firefoxネイティブのタブバーからサイドバーへタブがドラッグ＆ドロップされた場合に、可能であればURL文字列ではなくタブのドロップとして扱うようにした（この動作は `guessDraggedNativeTabs` を `false` に設定すると無効化できます）
   * ドラッグ＆ドロップでウィンドウから切り離されたツリーのインデントの深さが更新されていなかったのを修正
   * [Simple Tab Groups](https://addons.mozilla.org/firefox/addon/simple-tab-groups/)などのいくつかのアドオンとの併用時の互換性向上のために、タブの表示・非表示が切り替わったタイミングでスクロールバーの表示状態もそれに併せて更新するようにした
   * 設定画面のいくつかのUI要素の外観をより見やすく調整した
   * 「新しいタブの挙動」配下の設定項目について、検索性を高めるために順番や構成を見直した
   * タイトルを指定してグループ化用のタブを開くためのURLとして `ext+treestyletab:group?(title)` を使えるようにした
   * 既定のテーマ以外の時に文字の視認性を高めるための文字の影を正しい色で表示するように修正
   * `de`ロケール更新（by SammysHP. Thanks!）
   * `fr`ロケール更新（by ariasuni and DarckCrystale. Thanks!）
   * `ru`ロケール更新（by wvxwxvw. Thanks!）
 - 3.1.7 (2019.8.9)
   * 親タブが開き直された時にツリー構造の循環参照が発生しないようにした
   * `ru`ロケール更新（by wvxwxvw. Thanks!）
 - 3.1.6 (2019.8.8)
   * `about:treestyletab-group` の代わりとして機能するカスタムURIとして `ext+treestyletab:group` を実装した
   * 親のタブを閉じた時の挙動に関する設定UIを整理した
   * 起動時のツリー構造の復元処理をより最適化した
   * 複数のタブがまとめて移動された場合に、不要なツリー修復処理を行わないようにした（複数のタブをまとめて移動したり表示\非表示を切り替えたりするアドオンとの互換性を向上）
   * ツリー構造周りで循環参照が生じないように対策を講じた
   * 一部の親タブが非表示になっているツリーの中に、そのツリーと関係ないタブが置かれる事がないようにした
   * Firefox 70で廃止される書き方を使っていたコードを修正
   * `fr`ロケール更新（by narzb. Thanks!）
   * `ru`ロケール更新（by wvxwxvw. Thanks!）
 - 3.1.5 (2019.7.9)
   * サブパネルをより安全にした
   * [タブの読み込み中アニメーションのフレームレートを容易に変更できる](https://github.com/piroor/treestyletab/issues/2328#issuecomment-508901706)ように、`--throbber-animation-steps` カスタムプロパティを定義するようにした
 - 3.1.4 (2019.7.5)
   * 「ハイコントラスト」テーマ選択時に反映する色の組み合わせをより安定して視認性を得られる物にした
   * 「サイドバー」テーマ選択時にウィンドウのアクティブ・非アクティブの状態を正しく反映するようにした
   * `about:debugging` のタブのアイコンについて、正しくタブの前景色で塗りつぶすようにした
   * 新しいタブを開く位置を制御する各種オプションの選択肢として「制御せず既定の位置に開く」を選択可能にし、「新しいタブ」ボタンやCtrl-Tの新しい既定の動作とした
 - 3.1.3 (2019.7.1)
   * 他のFirefoxのインスタンスからツリーがドラッグ＆ドロップされた時に、ツリーをインポートするようにした
   * `browser.tabs.insertAfterCurrent`が`true`の時でも、TST以外によって開かれた新しい空のタブの取り扱いの設定を可能な限り尊重するようにした
   * サブパネルの高さを一定以下に制限するようにした
   * WindowsとmacOSでタブが頻繁にウィンドウから切り離されてしまう問題について軽減（あくまで暫定的な対策で、完全な解決はFirefox側での[bug 1561522](https://bugzilla.mozilla.org/show_bug.cgi?id=1561522)と[1561879](https://bugzilla.mozilla.org/show_bug.cgi?id=1561879)の解消を待つ必要があります）
   * セッションデータの肥大化を防ぐために、ツリー情報のキャッシュをウィンドウごとの最後のタブではなく最初のタブに保存するようにした
   * セッションデータの肥大化をさらに防ぐために、ツリー情報のキャッシュをタブではなくウィンドウに対して保存できるようにした（ただし、安全のためこの設定は初期状態で無効になっています）
   * タブのドラッグ中の自動スクロールが異常に高速で行われてしまう問題を修正（もし自動スクロールが遅くなりすぎていてもっと早くスクロールして欲しい場合は、[スクロール可能な領域の端でマウスカーソルを揺すってみて下さい](https://github.com/piroor/treestyletab/issues/2321#issuecomment-506667779)）
   * 新しい空のタブのアイコンが正しく表示されなくなっていたのを修正（3.1.2での後退バグ）
 - 3.1.2 (2019.6.21)
   * 追加の権限が必要である事を示す通知がクリックされた場合に、権限の設定のためにオプションページを開くようにした
   * 最後のサブパネルが削除されたらサブパネル用のヘッダを隠すようにした
   * タブがTemporary Containersなどの他のアドオンによって置き換えられた時に、可能な限りツリー構造を維持するようにした
   * ツリーがウィンドウ間を何度も移動された場合でも、ツリー構造が正しく維持されるようにした
   * すべての子タブが親タブと同時に閉じられた場合に、子タブをグループ化するためのタブを開かない（または、開かれてもすぐに閉じる）ようにした
   * タブごとの音声の再生状態・ミュート状態の更新処理を最適化
   * 「開発者向け」セクション配下に、設定画面のページそのものをタブで開くためのリンクを追加
   * 他のアドオン向けAPI: 他のアドオンがアンインストールまたは無効化された事をTSTに知らせるための機能として、[TSTから他のアドオンへの`wait-for-shutdown`の通知を導入した](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#unregister-from-TST)
 - 3.1.1 (2019.6.13)
   * サイドバーの余白部分でのクリック操作が正しく処理されなくなっていたのを修正（3.1.0での後退バグ）
   * タブのインデント部分のミドルクリックでタブを閉じないようにした
 - 3.1.0 (2019.6.13)
   * 他のアドオンによって[SubPanel API](https://github.com/piroor/treestyletab/wiki/SubPanel-API)経由で登録された任意のコンテンツをサイドバー内に「サブパネル」として埋め込んで表示できるようにした
   * キーボードショートカットを割り当てられるコマンドとして、サブパネルを操作するコマンドを追加（既定の状態では`F2`でサブパネルの表示・非表示を切り替える）
   * インデントの部分をクリックしてタブを切り替える機能が動作しなくなっていたのを修正
   * サイドバー内のタブの表示順を同期している間に他のアドオンなどがタブを並べ替えた場合でも、より正しくタブの表示順を同期するようにした
   * ブックマーク作成時のダイアログにおいて、タイトル入力欄の内容を初期状態で全選択するようにした
   * 他のアドオン向けAPI: [`tab-clicked`の通知が`tab-mouseup`より後に届くように修正](https://github.com/piroor/treestyletab/pull/2306) (by xzn, thanks!)
 - 3.0.17 (2019.6.7)
   * タブの更新内容がサイドバー上のタブに正しく反映されない場合があったのを修正（3.0.16での後退バグ）
   * `de`ロケール更新（by SammysHP, thanks!）
 - 3.0.16 (2019.6.7)
   * 親タブをピン留めしようとした場合、子タブをグループ化用のタブの配下にまとめるようにした
   * ピン留めされたタブと、そこから開かれた子タブをグループ化するためのタブとをより密に連携するようにし、片方がアクティブになったらもう片方もアクティブなタブのように表示・振る舞わせるようにした
   * タブが移動・挿入された位置に基づいてタブのツリー構造を修復する処理において、不可視のタブの存在も考慮に入れるようにした（`browser.tabs.insertAfterCurrent`=true の時にツリーの構造が壊れる問題を修正）
   * タブが開かれた直後に読み込みが中断または終了した場合に、タブが永遠に読み込み中の表示になってしまう事があったのを修正
   * デバッグオプションの配下の奥深くにあったオプション群（全設定の「インポート」「エクスポート」ボタンを含む）を「開発用」セクション直下に移動した
   * デバッグモードにおいて、既定のユーザースタイルシートではなく組み込みのスタイルシートによって各タブの内部的なIDを表示するようにした
   * Sidebar、Metal、Vertigoテーマにおいて、タブの複数選択時に非選択状態のタブを薄い色で表示する機能が働かなくなっていたのを修正（後退バグ）
   * Metalテーマにおいて、ピン留めされたタブがアクティブになっても背景色が変わらなくなっていたのを修正（後退バグ）
   * 複数のタブを一度に閉じる時の確認がより確実に表示されるようにした
   * ツリーの展開時に展開されたツリー全体が画面内に収まるようにサイドバーの内容をスクロールする挙動を停止する隠し設定 `scrollToExpandedTree` を追加した
   * 他のアドオン向けAPI：未登録のアドオンからAPIを呼び出せなくなっていたのを修正（後退バグ）
   * 他のアドオン向けAPI： 最後に登録済みだったアドオンに対して確実に`ready`の通知を送るようにした（もしインストールされているのに動作しないTSTとの連携を前提としたアドオンが有る場合は、手動での再読み込みによる登録のし直しが必要です）
 - 3.0.15 (2019.5.28)
   * サイドバーの空白領域上でのコンテキストメニューを開けなくなっていたのを修正（3.0.12での後退バグ）
   * グループ化用のタブにツリーを表示しないようにするオプションを追加
   * スクロールバーの幅に関する設定項目を削除し、初期状態で細くするようにした（標準的な幅で表示したい場合はユーザースタイルシートで `#tabbar { scrollbar-width: auto; }` 、非表示にしたい場合は `#tabbar { scrollbar-width: none; }` と設定して下さい）
   * スクロールバーの位置に関する設定項目を削除し、左側用のサイドバーでスクロールバーを初期状態で左端に表示するようにした（右端に表示したい場合はユーザースタイルシートで `:root.left #tabbar { direction: ltr; }` と設定して下さい)
   * サイドバーのコンテキストメニューから「タブを複製」を実行した時にタブの挿入位置がおかしくなっていたのを修正
   * Firefox 68以降では、タブを複製中に操作を妨げないようにした
   * ドラッグ中のタブをそれら自身にドロップしても無視するようにした
   * 他のアドオン向けAPI：`fake-contextMenu-click`を正しく通知するようにした。（最近のバージョンでの後退バグ）
 - 3.0.14 (2019.5.25)
   * セキュリティに関する重要なお知らせ：TST 3.0.14よりも以前のTST 2.xおよびTST 3.xのすべてのバージョンにおいて、他のアドオン向けのAPIを介した情報漏洩の問題がありました（WebExtensions APIでそれらの情報にアクセスするために必要な権限を持たない信頼できないアドオンに対してまで、TSTのAPI経由でプライバシーに関わるタブの情報やプライベートウィンドウのタブの情報が意図せず露出してしまっていました）。TST 3.0.14またはそれ以降のバージョンへの更新を強く推奨します。[詳細な情報](https://github.com/piroor/treestyletab/issues/2288#issuecomment-495764504)も併せて参照して下さい。
   * 初回起動時の通知ページから古い情報を削除した
   * 初回起動時の通知ページと設定画面にTSTを拡張する他のアドオンのためのセクションを追加した
   * 他のアドオン向けAPI: 初期状態で`effectiveFavIconUrl`を公開しないようにした
 - 3.0.13 (2019.5.25)
   * サイドバー上のコンテキストメニューの「下のタブを閉じる」と「他のタブを閉じる」が動作しなくなっていたのを修正（3.0.12での後退バグ）
 - 3.0.12 (2019.5.24)
   * MPL1.1とMPL2.0の混在ライセンスである事を明記
   * ドラッグ操作中にタブを自動展開する挙動が働かなくなっていたのを修正
   * ツリーの開閉後にタブのツールチップが更新されなくなっていたのを修正
   * サイドバー上のコンテキストメニューのコマンドから複数のタブを閉じる時に、タブが実際に閉じられるより前に確認を表示するようにした
   * 起動時にツリーのインデントが正しく初期化されないことがあったのを修正
   * 既存の最後のタブが何らかのタブの子である場合に、ブックマークフォルダから開かれた複数のタブが意図せず既存のタブの子になってしまっていたのを修正
   * 異なるウィンドウのピン留めされたタブから複数のタブが開かれた時に、自動でグループ化を試みないようにした
   * グループ化用のタブは `unread` にならないようにした
   * ページのタイトル文字列を常に `data-title` 属性で各タブに設定するようにした
   * インデントの深さを示すカスタムプロパティ `--indent-size` を定義するようにした
   * 他のアドオン向けAPI：ツリー構造が変化した時に [`tree-attached` および `tree-detached`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#when-tree-structure-is-modified) を通知するようにした
   * 他のアドオン向けAPI：[プライベートウィンドウ由来の通知メッセージは初期状態では通知しないようにした](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#information-in-private-windows)（[`permissions-changed` が通知されたタイミング](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#when-permissions-for-your-addon-are-changed)でアドオンの再初期化などが必要になるかも知れません）
   * 他のアドオン向けAPI：[タブの詳細な情報は初期状態では公開しないようにした](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#data-format)（タブの完全な情報が常に必要な場合は、[特別なパーミッション](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#extra-permissions)を要求する必要があります）
   * `de`ロケール更新（by SammysHP, thanks!）
 - 3.0.11 (2019.5.4)
   * タブの同期が崩れた際の復帰処理において、無限再読み込みが発生する場合があったのを修正
   * スクリプト実行権限が許可されていない時にタブのグループ化の確認ダイアログが表示されない問題を修正
   * 手動でのセッション復元時に、使い回されたアクティブなタブに関するツリーの情報が復元されていなかったのを修正
   * 親タブを閉じた後に代わりに開かれるグループ化用のタブについては、すべての子が閉じられたときでなく2つ目以降の子がすべて閉じられた時に自動的に閉じるようにした
   * ドラッグ＆ドロップでタブをウィンドウから切り離した後の挙動がおかしくなる事があったのを修正
   * 既存のウィンドウにタブをドロップした場合にアクティブなタブが2つある状態にならないようにした
   * デバッグ時に有用なユーザースタイル指定を初期設定に追加
   * `de`ロケール更新（by SammysHP, thanks!）
 - 3.0.10 (2019.5.2)
   * タブの内部的なインデックスが壊れているせいでタブのクリック時のフォーカスがおかしくなる問題を、より発生しにくくした
   * タイミングの問題でサイドバーの初期化処理が止まってしまう問題を、より発生しにくくした
   * サイドバー外でのタブを閉じる操作を単独のタブに対する操作として扱うよう設定されているときに、サイドバー内の操作で複数のタブが閉じられるときの確認のダイアログが表示されなくなっていたのを修正
   * サイドバー外でのタブを閉じる操作をツリーに対する操作として扱うよう設定されているときに、サイドバー外の操作で複数のタブが閉じられるときの確認のダイアログが表示されなくなっていたのを修正
   * サイドバー外の操作で複数のタブが閉じられるとき、復元可能なタブが1つ以下の場合は確認のダイアログを表示しないようにした（[タブを閉じる前にフックを仕掛けられないというWebExtensionsベースのアドオンの制限事項に由来する制限](https://github.com/piroor/treestyletab/issues/2249#issuecomment-488266835)）
   * Nightly 68.0a1での`about:debugging`と`about:debugging-new`専用のアイコンに対応
   * デバッグログに出力するタイムスタンプについて、よりデバッグに役立つように、年・月・日・タイムゾーンを省略して、時・分・秒に加えてミリ秒を出力するようにした
   * `de`ロケール更新（by SammysHP, Thanks!）
 - 3.0.9 (2019.4.30)
   * タブの情報の不整合を検出した時の自動修復後にツリー構造が失われていたのを修正
   * サイドバーの内容の初期化処理をより安定させた
 - 3.0.8 (2019.4.25)
   * 様々な不具合の原因となる、TSTの初期化中に開かれたタブの存在を把握できないままになる問題を起こらないようにした（[Dan Mooreheadによって提案された](https://github.com/piroor/treestyletab/pull/2239)自動修復機構を含む）
   * すべての追加のコンテキストメニュー項目について、設定でサイドバーのコンテキストメニューのトップレベルに項目を表示できるようにした
   * 初期化中に開かれたタブが読み込み中の表示のままになる問題が起こりにくいように修正
   * ピン留めされたタブを別ウィンドウに切り離した後に、タブバー上のピン留めされたタブのレイアウトが更新されていなかったのを修正
   * キーボードショートカットを設定して使うためのコマンドとして「最後の子タブにフォーカスを移す」「同階層の前のタブにフォーカスを移す」「同階層の次のタブにフォーカスを移す」を追加（[by Sinkerine, thanks!](https://github.com/piroor/treestyletab/pull/2237)）
 - 3.0.7 (2019.4.18)
   * カスタムCSSプロパティのカラーサンプルをより正しく表示するようにした
   * 複製されたタブをどのように開くかの設定が正しく反映されない場合があったのを修正
   * 複数のタブが同時に開かれた場面においては、現在のタブと同じドメインのタブを開いたときの取り扱いを反映しないようにした
   * ドラッグ＆ドロップの操作中に、ドロップ位置のマーカーやドラッグ中の表示が残りにくいようにした
   * テーマの配色をツールバーのアイコンとサイドバーのタブに適用する設定を混同しにくいようにした
 - 3.0.6 (2019.4.12)
   * 初期化に失敗するケースの一つを修正（3.0での後退バグ）
   * Shift-クリックでタブが複数選択されなくなっていたのを修正（最近のバージョンの後退バグ）
   * 新しい空のタブがアクティブなタブの子として開かれる時に、不可視であると設定されたタブがあってもそのタブを考慮した位置にタブを開くように修正
   * [Snap Links Plus](https://addons.mozilla.org/firefox/addon/snaplinksplus/)などによって複数のタブが一度に開かれた場合も、それらの位置を正しく認識するように修正
   * 一度に複数のタブが開かれた時のグループ化用のタブにおいて、自動的なグループ化を抑止するための設定に誘導するヒントを表示するようにした
   * 複数のタブが一度に開かれた時に、グループ化する前に確認を表示するようにした
   * タブのフォーカスを狂わせる原因の一つとなる、不正なindexを伴って開かれるタブへの対策を講じるようにした（[Bug 1504775](https://bugzilla.mozilla.org/show_bug.cgi?id=1504775)も参照して下さい）
   * 復元された、または複製されたタブについては自動グループ化の対象外にするようにした
   * タブのドラッグ中、展開状態のツリーの上でしばらく待った時にツリーが折りたたまれないようにした
   * 新しい色名を使ったテーマとの互換性を向上
 - 3.0.5 (2019.4.3)
   * ピン留めされたタブの前に通常のタブを開こうとしてタブのインデックスが壊れる問題を修正（タブをクリックした時に他のタブにフォーカスが移るというような煩わしい挙動が発生しにくくなります）
   * 他のアドオンやユーザースタイルシートによって非表示のタブが強制的に表示される環境の事を考慮し、タブの配置を決定する際に非表示のタブの存在を考慮するようにした
   * デバッグモードのログにタイムスタンプを含めるようにした
   * 起動中のハングアップ防止のため、起動処理中のエラーハンドリングを追加
   * 追加されたばかりの子タブのインデントの深さが無意味に大きかったのを修正
 - 3.0.4 (2019.4.2)
   * 「ハイコントラスト」選択時にタブの背景色が設定されていなかったのを修正（3.0.3の後退バグ）
   * 折りたたまれた子孫タブが複数選択されているタブについて、追加の強調表示が機能しなくなっていたのを修正（3.0での後退バグ）
   * `browser.tabs.closeWindowWithLastTab`=`false` の時に最後のタブを開き直した後サイドバーが動作しなくなる問題を修正
   * タブをサイドバーの外にドロップした時の挙動の選択肢に「何もしない」を追加
   * サイドバー内のスクロールバーの表示制御にCSSプロパティ `scrollbar-width` を使うようにした
 - 3.0.3 (2019.3.31)
   * タブのウィンドウからの切り離し・ウィンドウ間の移動が正しく処理されなくなっていたのを修正（後退バグ）
   * アニメーション効果無効時に「ツリーを展開したのに子タブが見えない」という状態が発生しないようにした（後退バグ）
   * "Plain"、"Vertigo"、"Mixed"テーマ使用時にブラウザの現在のテーマのヘッダー画像を反映するようにした
   * ユーザースタイルシートでブラウザの現在のテーマの配色を使えるように、カスタムプロパティを定義するようにした
   * ツリー復元用のキャッシュ情報について、必要なタブ以外には可能な限り情報を保存しないようにした
 - 3.0.2 (2019.3.29)
   * 非表示状態のタブがある時に新しいタブを開く位置がずれていたのを修正
   * タブが非表示になる時に自動的にツリー構造を修復する際、折りたたまれたままで見えない・アクセスできないタブが発生しないようにした
   * TSTの新機能を通知するタブが閉じられない問題を修正（後退バグ）
   * `browser.tabs.closeWindowWithLastTab`=`false` の時に最後のタブを閉じた後サイドバーが動作しなくなる問題を修正（後退バグ）
 - 3.0.1 (2019.3.29)
   * ピン留めされたタブがウィンドウから切り離された後にレイアウトがそのままになる問題を修正（3.0の後退バグ）
   * タブの読み込み完了時のアニメーション効果が一部反映されていなかったのを修正（3.0の後退バグ）
 - 3.0 (2019.3.29)
   * WebExtensions APIの非同期処理に基づくタブの取り扱いを安定させた（これまではバックグラウンドページとサイドバーのそれぞれで並行してタブを監視していたため同期が崩れる事があったが、今後はバックグラウンドページのみでタブを監視しサイドバーは単なる描画領域として使用するようにした）
   * 非常に多くのタブを含むウィンドウを開き直したときのツリーの復元処理について、時間がかかっても完遂するようにした（最大待ち時間10分）
   * ブラウザのテーマの配色を反映しない設定を追加
   * `about:performance`のタブのfaviconをFirefoxと同じ物で表示するようにした
   * 開き直されたウィンドウのタブのツリー構造が期待通りに復元されていなかったのを修正
   * 今後のパフォーマンス改善の指標にできるよう、内部的なメッセージのログを収集できるようにした
   * レガシー版からのデータの引き継ぎ機能を削除した
 - 2.8.7 (2019.3.20)
   * バックグラウンドページとサイドバーの間の通信の効率を改善
   * 初期化処理のパフォーマンスを改善
   * バックグラウンドページの内容がキャッシュから復元されサイドバーの内容がキャッシュを使わず構築される場面で初期化に失敗する問題を修正
   * テーマカラーをツールバーアイコンに反映する設定の時にアイコンが見えなくなる不具合を修正
   * ミュートまたは音声再生中のタブを子孫に含む折りたたまれたタブについて、親タブに「ミュート」および「音声再生中」のステータスアイコンが表示されなくなっていたのを修正
   * サイドバーの初期化時にプログレスバーを表示するようにした
 - 2.8.6 (2019.3.16)
   * 公にFirefox ESR60のサポートを終了し、すべての2.8.x系バージョンをESR60非対応とした
   * 起動直後のツリー復元時に、折りたたまれているはずのツリーがすべて展開された状態で表示されてしまう不具合を修正
   * ドラッグされた親タブのみをウィンドウから切り離す、またはブックマークするように設定されている場合でも、サイドバー領域内でのドラッグ＆ドロップ操作時は常にツリー全体を移動するようにした
   * 選択されたタブまたは親タブ単独をドラッグ操作でウィンドウから切り離す際、元のツリーの構造が壊れてしまっていたのを修正
   * Add preview images for some options.
 - 2.8.5 (2019.3.14)
   * タブの数が多い場合にツリーの開閉状態が正しく復元されない事があったのを修正
   * キャッシュを使用した初期化処理を最適化
   * タブが復元されたときに、移動不可能な位置に移動しないようにした（この問題により、キャッシュを無効化しても修正できない壊れたツリー構造が出来てしまうことがあった）
   * 新しい空のタブがアクティブなタブのコンテナを引き継ぐために開き直されるときに、無駄なグループ化用のタブが開かれてしまっていたのを修正
   * グループ化用のタブについて、初期化中はthrobberを表示するようにした
   * グループ化用のタブの内容の更新中にフリーズしにくいようにした
 - 2.8.4 (2019.3.12)
   * サイドバーの空白領域でコンテキストメニューが開かれなくなっていたのを修正（最近のバージョンでの後退バグ）
   * Firefox ESR60でコンテキストメニューの機能が動作しなくなっていたのを修正（最近のバージョンでの後退バグ）
   * コンテキストメニューの追加コマンドについて、複数選択されたタブを対象とした動作がすべてのタブを対象とした動作になっていたのを修正（最近のバージョンでの後退バグ）
   * Ctrl-Tで開かれた新しいタブについて、その時アクティブだったタブのコンテナを引き継ぐ処理が機能していなかったのを修正（最近のバージョンでの後退バグ）
   * Firefox ESR60において、新しいタブを設定アクティブなタブの子として開く設定が機能しなくなっていたのを修正（最近のバージョンでの後退バグ）
   * Firefox ESR60において、アクティブなタブを閉じた後のタブのフォーカス制御が機能しなくなっていたのを修正（最近のバージョンでの後退バグ）
   * タブのラベルが長すぎる場合の省略方法を「..」で省略する設定の時、タブのツールチップが更新されなくなっていたのを修正（最近のバージョンでの後退バグ）
   * Firefox ESR60において、ツリーの最後の子であるアクティブなタブを閉じた場合に、直前の兄弟タブではなく直前の可視状態のタブにフォーカスを移すようにした（Firefox 65移行におけるTST 2.8.0での動作に挙動を合わせた）
 - 2.8.3 (2019.3.7)
   * 他のウィンドウから移動されたタブが内部的に不可視扱いされ、アクティブなタブを閉じた後にアクティブにならないなどの不可解な挙動を示していたのを修正（2.8.0の後退バグ）
   * 新しいタブがサイドバーのスクロール範囲外で開かれた後すぐにスクロール範囲内に移動された場合に、サイドバーを無駄にスクロールしないようにした
   * ピン留めされたタブから開かれたタブをグループ化するタブが、3個目以上の子タブを開くと何度も開かれる問題を修正
   * タブのラベルが長すぎた時の表示の仕方の設定項目をツールバーボタンのショートカット設定に追加
   * 設定のインポート・エクスポートを一般的なファイル選択ダイアログで行うようにした
 - 2.8.2 (2019.3.6)
   * 新しいタブを現在のタブの子として開けなくなっていたのを修正（2.8.0での後退バグ）
   * Firefox ESR60でサイドバーのコンテキストメニューを開けなくなっていたのを修正（2.8.0の後退バグ）
   * サイドバーへのリンクのドロップなどによって位置を指定して開かれたタブは、現在のタブと同じドメインであっても子タブにしないようにした
   * 初回起動時に、元のアクティブなタブと新たに開かれた通知のタブの両方がハイライト表示されてしまう不具合を修正
 - 2.8.1 (2019.3.6)
   * 以前アクティブだったタブの情報に依存する、新しいタブの振る舞いに冠する挙動を修正（2.8.0での後退バグで、以前アクティブだったタブが誤検出される状態になっていた）
   * 音声再生中であることを示すアイコンのクリック操作でミュート/ミュート解除できなくなっていたのを修正（2.8.0での後退バグ）
   * 既存のツリーの中に新しいタブが開かれた時にツリー構造が自動修復されなくなっていたのを修正（2.8.0での後退バグ）
   * 2.8.0での変更に追従して、ツールバーボタンのショートカット設定メニューを更新
 - 2.8.0 (2019.3.5)
   * Firefox ESR60のサポートを終了
   * タブの管理をDOM要素ベースではなくJavaScriptのオブジェクトベースで行うようにした（大量のタブに対する動作パフォーマンスや複数の非同期処理の安定性に関する改善をしやすくするため）
   * 最適化の指標となる情報として、タブの検索処理のパフォーマンスログを収集できるようにした（設定画面の「開発」配下のチェックボックスで機能を有効化する必要があります）
   * タブのコンテキストメニューから「タブを移動」で「タブを新しいウィンドウに移動」した後にすべてのタブが選択されてしまっていたのを修正
   * 動作速度を優先させたい場合のために、タブのラベルが長すぎる場合の省略方法を変更できるようにした
   * タブが他のアドオンによって隠されたときにツリー構造を自動修正できるようにした（※このオプションは初期状態で無効のため、必要に応じて手動で有効に切り替えてください）
   * キーボードショートカットを除く全設定のインポートとエクスポートに対応（設定→開発用→デバッグモード→すべての設定→Import/Export）
   * [Conex](https://addons.mozilla.org/firefox/addon/conex/)との互換性を向上
   * タブをより安全に移動させるための[`move-before`および`move-after`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#move-tree-to-different-position) APIを追加
 - 2.7.23 (2019.2.22)
   * セッション復元後に、折りたたまれたツリー内のタブがフォーカスされてもツリーが自動展開されなかったり、現在のタブを閉じた後に折りたたまれたツリー内のタブにフォーカスが移動したりする問題を修正
 - 2.7.22 (2019.2.20)
   * メニューのコマンドやショートカットが動作しなくなっていたのを修正（2.7.21での後退バグ）
 - 2.7.21 (2019.2.20)
   * 最後の位置以外に新しいタブが挿入されたときに不要なスクロールが行われるようになっていたのを修正（2.7.19の後退バグ）
   * アクティブなタブが閉じられたときに、次の兄弟タブよりも先に、可視状態の最初の子タブにフォーカスを移すようにした（2.7.20の後退バグ）
 - 2.7.20 (2019.2.19)
   * Successor Tabs APIによるTSTでのタブのフォーカス制御を完全に無効化できるようにした
   * Firefox 65以降での`browser.tabs.selectOwnerOnClose`=`true`の挙動の再現度合いを改善
   * Linux環境での既定のテーマを「Mixed」に変更
 - 2.7.19 (2019.2.19)
   * ピン留めされたタブをピン留めされていないタブの後にドロップできないようにした / ピン留めされていないタブをピン留めされている他部の前にドロップできないようにした
   * 「タブを新しいウィンドウに移動」コマンドでタブがツリーごと別ウィンドウに移動された後に、移動されたツリーの構造を正しく復元するようにした
   * タブがウィンドウに切り離された（別ウィンドウに移動された）後にタブのフォーカスがおかしくなる問題を修正
   * アクティブなタブとして開かれた新しいタブをより正しく取り扱うようにした
   * ウィンドウを閉じる時にツリー構造を保存するためノムだな処理が走っていたのを修正
   * 複数選択されたタブをより分かりやすく表示するようにした（[bug 1515686](https://bugzilla.mozilla.org/show_bug.cgi?id=1515686)で行われたFirefox本体のテーマの変更の趣旨に追従）
   * ruロケール更新（by trueR3W1ND, thanks!）
 - 2.7.18 (2019.1.30)
   * 「再読み込み」ボタンのミドルクリックでピン留めされたタブを複製した後にタブのフォーカスが狂う問題を修正
 - 2.7.17 (2019.1.30)
   * リンクやブックマークをドロップして開かれたタブがツリーに正しく組み込まれない問題を修正
   * ピン留めされたタブをアイコンのみの表示にしていない時の余計なマージンをなくした
   * 復元されたタブの `discarded` の状態を正しく認識するようにした
   * 新しく開かれたタブまで自動的にスクロールする場面で、スクロールの最中にマウスのホイールでスクロールが行われた場合は自動スクロールを停止するようにした
   * ドラッグ＆ドロップに関する設定項目にスクリーンショットを追加した
   * 他のアドオンによって不正な（大きすぎる）`index`を指定された状態で開かれたタブについて、より安全に取り扱うようにした
   * タブのラベルが長すぎる場合のフェードアウト処理について、ツリーが展開されたときや復元されたときに状態を更新するようにした
   * キーボードショートカットから複数のタブを閉じる操作を行った際に、複数のタブを閉じる確認のダイアログが表示されていなかったのを修正
   * 他のアドオン向けの新しいとして [`wait-for-shutdown`](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#wait-for-shutdown-type-message) を追加した
 - 2.7.16 (2019.1.13)
   * API実装の致命的な不具合を修正（2.7.15の後退バグ）
 - 2.7.15 (2019.1.13)
   * Firefox側で`browser.tabs.multiselect`=`false`に設定されている環境に対応するための詳細設定を追加
   * 複数のタブを閉じる時の確認ダイアログが他のウィンドウでまで表示されていたのを修正
   * 他のアドオンがAPI経由で特定のメッセージ型を受信するように登録された後で、その情報無しで再登録された場合に、最初に設定された型のメッセージが送られなくなっていたのを修正
 - 2.7.14 (2019.1.12)
   * タブの並び順を同期する処理で無限再帰呼び出しが発生していた問題を修正
   * 並び順を同期したタブのインデックスの振り直しをより効率よく行うようにした
   * 折りたたまれた子孫タブが複数選択されているタブについて、その事をより強調表示するようにした
   * アクティブなタブまたは複数選択されているタブを強調表示する要素のクラス名を `active-marker` から `highlighter` に変更した（ユーザースタイルシートの更新が必要な場合があります）
 - 2.7.13 (2019.1.11)
   * タブの並び順の同期処理をより安定させるようにした
   * 複数のタブを閉じる確認ダイアログの操作が正しく待たれていなかったのを修正
 - 2.7.12 (2019.1.11)
   * Sequence matcherを使ってタブの並び順の同期処理をより効率よく行うようにした
 - 2.7.11 (2019.1.11)
   * 複数のタブが同時に開かれた後にタブの並び順やフォーカスが狂う問題を修正（後退バグ）
   * タブが開かれた直後に開き直された後にタブの並び順やフォーカスが狂う問題を修正（後退バグ）
   * 折りたたまれたツリーをCtrl/Shift-クリックした時のタブの複数選択の挙動がおかしくなっていたのを修正（後退バグ）
   * 「他のタブを閉じる」の実行後にツリー構造が壊れる場合があったのを修正
   * サイドバー上のコンテキストメニューから複数のタブを閉じる操作を行った際に、確認のダイアログが表示されなくなっていたのを修正（後退バグ）
 - 2.7.10 (2019.1.7)
   * 低速な環境でタブを閉じた後にタブのフォーカスがおかしくなる問題を修正（最近のバージョンでの後退バグ）
   * 一度に複数のタブが開かれた後にタブの並び順がおかしくなる問題を修正
   * ブックマークにアクセスする権限がない時はブックマーク関係の設定UIを無効化するようにした
 - 2.7.9 (2019.1.4)
   * TST以外によってタブの順番が並べ替えられた後にタブのフォーカスがおかしくなる問題を修正（最近のバージョンでの後退バグ）
 - 2.7.8 (2019.1.3)
   * コンテキストメニューの再現設定が無効の時に、コンテキストメニュー自体を無効化する代わりに、既定のタブのコンテキストメニューを再現した項目を非表示にするようにした
   * マルチプルタブハンドラがインストールされている場合でも、既に複数選択された状態のタブの上でのボタン長押しからタブをドラッグできるようにした
   * Firefox ESR60でタブを閉じた時の挙動がおかしくなっていたのを修正
   * [API経由で、タブのツリー開閉つまみ・ミュートボタン・クローズボックスのクリック操作をキャンセルできるようにした](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#when-a-tab-is-clicked)
 - 2.7.7 (2018.12.28)
   * 複数のタブを持つウィンドウが閉じられた時に、残ったウィンドウ内で無関係のタブを開き直してしまっていたのを修正
   * タブが開かれた後に更新された場面での取り扱いが壊れていたのを修正（2.7.6での後退バグ）
   * コンテキストメニューの最上位階層に追加された「ツリーを閉じる」「他のツリーを閉じる」が子タブを持たないタブの上で無効化されないように修正
 - 2.7.6 (2018.12.26)
   * 新しく開かれたタブの配置処理を改善（高速なPC上のFirefox ESR60において、開かれたタブが直後にFirefox自身によって移動された場合に最終的な配置位置がおかしくなっていた）
 - 2.7.5 (2018.12.25)
   * 「このツリーを閉じる」などのコンテキストメニュー最上位に追加されるコマンドが機能しなくなっていたのを修正（最近のバージョンでの後退バグ）
   * タブの`successorTabId`を制御するほかのアドオンとの互換性を向上（TSTによる制御を無効化するには「ツリーの挙動」→「現在のタブが最後の子タブだった時に、現在のタブを閉じた後は」→「次のタブにフォーカスを移す（Firefox既定の動作）」を手動で選択する必要があります9
   * コンテキストメニュー項目の表示・非表示の制御をより正しく行うようにした
 - 2.7.4 (2018.12.22)
   * タブの複数選択操作中にアクティブなタブが切り替わらないようにした
   * Firefox ESR60において、リンクから開かれたタブがタブバー末尾に開かれてしまう問題を修正
   * コンテキストメニュー内に無駄なセパレータを表示しないようにした
   * タブ以外の領域上で開かれたコンテキストメニューの「選択されたタブを再読み込み」「選択されたタブをブックマーク」の操作が期待通りに動作しない問題を修正
 - 2.7.3 (2018.12.20)
   * 「閉じたタブを開き直す」などの操作で復元されたタブのツリー構造の取り扱いを改善
   * 同じ一揃いのタブをまとめて閉じようとしている時に、何度も確認を表示しないようにした
   * Firefox 64以降において、コンテキストメニュー項目の挿入位置を一定にするようにした
   * Firefox 61以降での隠し設定 `browser.tabs.closeTabByDblclick`=`true` の挙動を再現する設定を追加した
   * タブをまとめて閉じる際の確認を抑制するためのAPIとして `grant-to-remove-tabs` を追加
 - 2.7.2 (2018.12.18)
   * 新しいタブボタン上で表示されるコンテナ選択リストのアイコンがFirefox 66以降でも表示されるようにした
   * 最後のタブでないタブから開かれたタブが子タブにならない場合があったのを修正（2.7.0での後退バグ）
 - 2.7.1 (2018.12.15)
   * タブの更新とハイライト状態の変更の追跡処理についてさらに最適化（by Lej77, thanks!）
 - 2.7.0 (2018.12.14)
   * マルチプルタブハンドラからコンテキストメニュー項目「タブをグループ化」（選択されているタブから新しくグループを作る）およびそれに対応するキーボードショートカットコマンドを移植した
   * タブの数が非常に多い場面でのタブの複数選択処理のパフォーマンスを向上
   * Firefox 64以降のバージョンでのコンテキストメニューに無駄なセパレータを表示しないようにした
   * Firefox 65以降のバージョンにおいて、現在のタブを閉じた後に直前または直後のタブが意図せずフォーカスされないようにした
   * ピン留めされていないタブに対しても「attention」の印を表示するようにした
   * 「highlighted」の状態の監視処理を効率化
   * コンテキストメニューの「コンテナーを開きなおす」と「タブを複製」を選択された複数のタブに対して使用できるようにした
   * ブックマークやリンクを作成するために開始されたドラッグ操作ではタブをウィンドウに切り離さないようにした
   * 休止状態のタブがCtrl-Tab/Ctrl-Shift-Tabの操作で意図せず復元されてしまった場合に、自動的に再度休止状態に戻すようにした
   * macOS上のFirefox 64以降において、Control-クリックでコンテキストメニューを開いた時に新形式のメニューが開かれなったのを修正（旧形式のメニューを開くには⌘キーを押しながらコンテキストメニューを開いて下さい。WindowsとLinuxでは引き続きCtrlキーを押しながらで旧形式のメニューが開かれます）
   * 複数のアクティブなタブが一度に開かれた場合に、最後にアクティブだったタブに正しくフォーカスするようにした
   * 複数のタブが一度に開かれた場合のタブの並び順を壊れにくくした
   * giffgaff.com などのいくつかのWebサイトでログインできなくなる問題を修正（再度）
   * ドラッグされたタブ自身の上でドロップ操作をした時に、タブが誤って新しいウィンドウに切り離されにくいようにした
   * 現在のタブの次の兄弟として新しいタブを開く設定の時、全体で最後のタブにフォーカスがある状態でタブを開くと意図しない場所にタブが開かれてしまっていたのを修正
   * グループ化用のタブにおいて、サスペンド状態のタブは最後に有効だったアイコンを表示するようにした
   * `get-tree` APIでのレスポンスに含まれるタブの情報に、最後に有効だったアイコンを含めるようにした
   * グループ化用のタブにおいてアイコンのサイズが一定していなかったのを修正
   * [Bug 1502083](https://bugzilla.mozilla.org/show_bug.cgi?id=1502083)で行われたタブのコンテキストメニューの構成変更に追従
   * ツールバー上のボタンの右クリックメニューから各種の設定を直接変更できるようにした
   * 空のコンテキストメニューでエラーが発生しないようにした
   * Firefoxのタブのコンテキストメニューを再現する他のアドオン向けに、TSTと互換性がある形で機能を呼び出すための以下のAPIを追加： `move-to-start`, `move-to-end`, `open-in-new-window`, `reopen-in-container`
   * APIでタブを指定する時のエイリアスとして`highlighted`と`multiselected`を追加（Firefox 63以降でのみ利用可能）
   * `duplicate` APIの`as`オプションについて、省略時はTSTの複製したタブ向けの挙動に従うようにした
   * ウィンドウのIDを返すAPIについて、`windowId`というプロパティ名でも値を返すようにした（後方互換性のため、引き続き`window`というプロパティ名でもウィンドウのIDが返されます）
 - 2.6.8 (2018.11.5)
   * サイドバー上での「タブをまとめて閉じる」配下に「ツリーを閉じる」系の項目を追加できるようにした
   * すべての追加のコンテキストメニュー項目が無効化されている、もしくは有効な項目が1つだけの場合、コンテキストメニューの追加の項目を「ツリー型タブ」サブメニューを表示しないようにした
   * 現在のタブが閉じられた後のフォーカス移動や子孫タブにフォーカスがある状態でツリーが折りたたまれた時のフォーカス移動で、ツリーに含まれるすべてのタブが誤って選択されてしまっていたのを修正
 - 2.6.7 (2018.11.3)
   * 他のツリーのタブが選択されていない時は、アクティブなタブのCtrl-クリックで、折りたたまれた子孫タブのみの選択状態を切り替えられるようにした
   * アクティブでないタブがShift-クリックされた時は、アクティブなタブの折りたたまれた子孫タブも常に選択するようにした
   * APIを経由した他のアドオンの初期化処理に対してタイムアウトを設けるようにした（他のアドオンの初期化処理の完了待ちで固まらないようにした）
 - 2.6.6 (2018.10.31)
   * `documentUrlPatterns`で`moz-extension:`を含むパターンを使っているアドオンとの互換性を向上
   * TSTのAPI経由で取得したタブの`highlighted`プロパティの値が実際の状態と異なっていたのを修正
 - 2.6.5 (2018.10.30)
   * コンテナーが1つしか無い時に「コンテナーを開きなおす」サブメニューが表示されない問題を修正
   * 追加のメニュー項目の有効無効を切り替えた後に「ツリー型タブ」メニューの内容が空になる問題を修正
   * giffgaff.com などのいくつかのWebサイトでログインできなくなる問題を修正
   * タブのドラッグ操作がESCキーでキャンセルされた場合はタブをウィンドウに切り離さないようにした
   * タブのドラッグ中に表示されるメッセージについて、ドロップ時に何が起こるかを寄り詳しく説明するようにした
   * API経由でのメニュー項目の削除時に、子孫項目を再帰的に削除するようにした
 - 2.6.4 (2018.10.19)
   * Firefox 62以前の環境向けに「すべてのタブをブックマーク」「すべてのタブを再読み込み」コマンドを復活させた（※Firefox 63以降では表示されません）
   * `svg.context-properties.content.enabled`が`true`に設定されていて意図的に有効化された場合にのみ、テーマの配色をツールバーのアイコンに反映するようにした
 - 2.6.3 (2018.10.18)
   * タブのドラッグ中に、サイドバー外にドロップすると何が起こるかを説明するメッセージをサイドバーの下端に表示するようにした
   * タブのドラッグ用つまみを初期設定では非表示とした
   * Firefox 62以降において、ツールバーボタンとサイドバーパネル項目の色をテーマの配色に合わせるようにした
 - 2.6.2 (2018.10.18)
   * コンテキストメニューの機能のうち、タブの複製、コンテナーを指定しての開き直し、および新しいウィンドウへの移動が機能しなくなっていたのを修正（2.6.0での後退バグ）
   * アイコンサイズになっているタブの場合、半分より片方（右または左）の上ではタブのドラッグ用つまみを表示しないようにした
   * タブのドラッグ用つまみが表示されるより前にタブがクリックされた場合、つまみを表示しないようにした
   * ブックマークフォルダの選択UI内で不要なセパレータを表示しないようにした
   * 可能であれば、コンテキストメニュー項目のアクセスキーを有効にするようにした
   * Firefox 61以降での`browser.tabs.insertAfterCurrent`=`true`時の挙動を尊重するようにした（この機能によりタブが現在のタブの隣に開かれた場合、TST自身の「新しいタブを開く位置」関係の設定を反映しないようにした）
 - 2.6.1 (2018.10.17)
   * 可能であれば、URLでない文字列がドロップされた時に既定の検索エンジンで検索するようにした
   * テーマの配色が反映された時に[ダミー要素が意図せず露出してしまっていた](https://github.com/piroor/treestyletab/issues/2050)のを修正
 - 2.6.0 (2018.10.16)
   * [Firefox 64以降において、タブのコンテキストメニューに機能を追加する他のアドオンとの互換性を向上した](https://piro.sakura.ne.jp/latest/blosxom/mozilla/xul/2018-10-14_override-context-on-fx64.htm)（これに伴い、タブのコンテキストメニューの項目をFirefox 64準拠の内容とした）
   * タブをサイドバーの外にドラッグした時の挙動について、通常のドラッグとShift-ドラッグのそれぞれに任意の挙動を設定できるようにした（初期状態では、Shift-ドラッグはツリー全体のタブからリンクまたはブックマークを作成）
   * [目的を指定してタブのドラッグを開始するためのつまみ](https://github.com/piroor/treestyletab/issues/2033#issuecomment-422757008)を追加した（タブの端の方をポイントしてしばらく待つと表示されます）
   * ブックマークを追加する際にダイアログを表示するようにした
   * ブックマークが作成される既定のフォルダを設定できるようにした
   * キャッシュを無効化した時にすぐにサイドバーパネルを再読み込みするようにした
   * タブが複数選択されている場合はコンテキストメニューの「タブを複製」を表示しないようにした（Firefoxの機能の動作に合わせた）
   * 新しいタブを開く位置をより正しく判別するようにした
   * タブの読み込みインジケータの同期処理を高速化 (by Lej77, thanks!)
   * 設定ページのキーボードショートカットの項目に「すべて初期値に戻す」ボタンを追加
   * 異なる向きのサイドバー用にキャッシュされたインデント定義を反映しないようにした
 - 2.5.4 (2018.9.10)
   * 起動時のタブの初期化処理をより安全に行うようにした
   * ツリーのウィンドウ外へのドラッグ操作で別ウィンドウへの切り離しを再び可能にし、ツリーのウィンドウ外へのShift-ドラッグでブックマークまたはリンクを作るようにした
   * ツリーのウィンドウ外へのドラッグ操作について、通常のドラッグとShift-ドラッグの効果を入れ換えられるようにした
   * [APIで`tab-mouseover`と`tab-mouseout`をエッジケースにおいても送出するようにした（by klemens, thanks!）](https://github.com/piroor/treestyletab/pull/2008)
   * `de`ロケール更新 (by sicherist, thanks!)
 - 2.5.3 (2018.8.30)
   * Firefox 63以降（[bug 1486050](https://bugzilla.mozilla.org/show_bug.cgi?id=1486050)が修正されて以降のバージョン）のネイティブの複数タブ選択に対応した
   * サイドバー上の偽コンテキストメニューについて、「コンテナーを開きなおす」相当の機能を実装した
   * Firefox 63（[bug 1453153](https://bugzilla.mozilla.org/show_bug.cgi?id=1453153)が修正されて以降のバージョン）において再びタブのドラッグ操作を可能にした
   * Firefox 63（[bug 1396684](https://bugzilla.mozilla.org/show_bug.cgi?id=1396684)が修正されて以降のバージョン）においてタブの`attention`属性をサイドバー内のタブに反映するようにした
   * 英語ロケールの文法ミスを修正
   * サイドバー領域の非常に近い範囲内でドロップされたタブについては、ウィンドウに切り離さないようにした
   * ツリーをドラッグしてURLの一覧としてドロップできるようにした
   * サイドバーにドロップされたURIの一覧について、タブとして開けるようにした
   * 組み込みのSVG画像のfaviconとしての読み込みに失敗する場合があったのを修正
   * [ツールバーボタン無しで権限を設定できるようにした（by Lej77m thanks!)](https://github.com/piroor/treestyletab/pull/2011)
   * [APIで`tab-mouseout`を通知するタイミングを修正した（by klemens, thanks!）](https://github.com/piroor/treestyletab/pull/2008)
   * API経由で送られる`tab-mousedown`、`tab-mouseup`、および`tab-clicked`の型のメッセージについて、イベントがミュート/ミュート解除ボタンの上で起こったかどうかを示す`soundButton`を含めるようにした
 - 2.5.2 (2018.8.20)
   * コンテキストメニューのいくつかの項目について、遅い環境でも安定して動くようにした
 - 2.5.1 (2018.8.19)
   * faviconの読み込みに関連する無限再帰呼び出しの問題を修正（2.5.0での後退バグ）
   * ツリー上のフォーカスを移動する既定のショートカット「Ctrl-Shift-矢印」が文字入力フィールドで一般的に使われているショートカットと衝突していたため削除した
   * すべてのキーボードショートカットについて、各ショートカットの入力欄でのEscapeキー押下でショートカットの割り当てを解除できるようにした
   * キーボードショートカットを設定するUIの並び順がおかしくなっていたのを修正（2.5.0での後退バグ）
   * APIで`tab-mouseout`を通知するタイミングを修正した
   * zh-CNロケール更新（by YFdyh000, thanks!）
 - 2.5.0 (2018.8.17)
   * ES module形式でコードを再構成した（メンテナンス性を向上）
   * 閉じられている最中のタブの上でのクリック操作について、タブバーの余白領域でのクリックとして扱わないようにした
   * コンテキストメニュー項目として「このツリーをたたむ」「このツリーを展開する」を追加した
   * キーボードショートカット用のコマンドとして「このツリーをたたむ」「このツリーを展開する」「親のタブにフォーカス」「最初の子タブにフォーカス」を追加した
   * キーボードショートカット用の「前のタブにフォーカス」「次のタブにフォーカス」コマンドで、フォーカスを循環するようにした
   * キーボードショートカット用の「前のタブにフォーカス」「次のタブにフォーカス」コマンドで、同階層のタブではなく実際の前後のタブにフォーカスするようにした
   * キーボードショートカット用の「前のタブにフォーカス」「次のタブにフォーカス」コマンドに既定のショートカットを割り当てるようにした
   * ピン留めされたタブから開かれたグループ化用のタブについて、縮小されたfaviconをフォルダー型アイコンの上に重ねるようにした
   * ツリーをブックマークする時、ツリーの親になっているグループ化用のタブは除外するようにした
   * 複数のタブをブックマークする時に作成されるフォルダー名をカスタマイズできるようにし、既定の状態で日付を含めるようにした
   * ピン留めされたタブをピン留めされていないタブの間にドラッグ＆ドロップできるようにした（その逆の操作も可能）
   * ピン留めされたタブをドラッグ＆ドロップで新規ウィンドウに切り離せなかったのを修正
   * グループ化用のタブをより安全に復元するようにした（これまでは、復元されたグループ化用のタブの内容が喪失する事があった）
   * グループ化用のタブのタイトルの更新時に、必要無い場合はタブそのものを再読み込みしないようにした
   * グループ化用のタブのタイトルの変更時に、フォームからフォーカスを外して編集を終了したらキャンセルではなく確定として扱うようにした
   * ブックマークフォルダから開かれたタブの自動グループ化が正しく動作しなくなっていたのを修正（最近のバージョンでの後退バグ）
   * ピン留めされたタブから新しく開かれたタブについて、その位置までタブバーを自動スクロールするようにした
   * 現在のタブが折りたたまれた時は直近の祖先タブにフォーカスを移すようにした
   * 画像のみを表示しているタブについて、サイトのfaviconが提供されている場合はFirefoxのタブと同様にfaviconを優先的に表示するようにした
   * "Plain"、"Vertigo"、"Mixed"について"Firefox Color"などのアドオンで適用された配色をより広範に反映するようにした
   * 32ピクセル用のアイコンを追加した
   * ツールバーボタンのアイコン画像を半透明で表示するようにした（by asamuzaK, thanks!）
   * タブの「ドラッグ中」の状態が意図せず残ってしまった場合に、クリック操作で必ず状態を戻すようにした
   * タブの折りたたみ状態の非同期な変更をより堅牢にした（以前は、内部的な折りたたみ状態と表示上の状態が一致しない場合が発生していた）
   * キャッシュを使わずにツリーを復元した時に、ツリーが常に折りたたまれた状態になってしまっていたのを修正
   * セッション復元時に、折りたたまれているはずのツリーの配下に子孫のタブが表示されたままになる事がある問題を起こりにくくした
   * モジュールごとのログ出力を可能にした
   * [チェックボックス型とラジオボタン型のコンテキストメニュー項目](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#add-new-item-to-the-context-menu-on-tabs)と、[`browser.menus.onShown`/`browser.menus.onHidden`互換のAPI](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#update-existing-item)を追加した
   * 画像に非フリーのカラープロファイルが含まれていたのを除去
   * `de`ロケール更新 (by sicherist, thanks!)
   * `ru`, `uk`ロケール追加 (by perdolka, thanks!)
 - 2.4.24 (2018.6.3)
   * いくつかのコンテキストメニューの機能がアニメーション効果無効時に機能しなくなっていたのを修正（2.4.22～2.4.23での後退バグ）
   * 既存のグループ化用タブに`about;treestyletab-group`を読み込むとCPU使用率が100％になる問題を修正
   * Conexがインストールされているとリンクなどのドロップ操作で開かれたタブがすぐに閉じられてしまう不具合を修正
 - 2.4.23 (2018.6.1)
   * 他のアドオン向けに、[サイドバーが開閉されたことを通知するAPI](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#when-the-tst-sidebar-is-shownhidden)を追加
   * キャッシュから復元されたタブのアイコンが正しく反映されない場合があったのを修正
   * タブをドラッグ&ドロップでウィンドウから切り離した際にフリーズする問題を修正
   * タブをドラッグ&ドロップでウィンドウから切り離す操作を若干成功しやすくした
 - 2.4.22 (2018.5.30)
   * ブラウザ起動時のサイドバー初期化処理をより安全に行うようにした
   * 縦スクロールバーがチカチカ出たり消えたりする問題を修正
   * Ctrl-Tで開かれた新しいタブを設定通りの位置に開く機能が期待通りに働かない場合があった問題を解消（したつもり）
   * 同じサイトのタブをロケーションバーから開いた時に子タブにする機能について、空のタブを開いてからページを読み込んだ場合にまで作用してしまっていたのを修正
   * 偽コンテキストメニューについて、項目がクリックされたらすぐにメニューを閉じるようにした
   * 偽コンテキストメニューでセパレータ上にカーソルがあるとキーボードでの操作が機能しなくなる問題を修正
   * 偽コンテキストメニューの項目が増減した場合、自動的にメニューを開き直すようにした
   * 他のアドオンから追加された偽コンテキストメニューの追加項目について、アドオンの登録が解除されても項目が残ったままになっていたのを修正
   * 「Plain」テーマの外観をよりFirefoxの既定のテーマに近づけた
   * サイト固有のfaviconが無い場合のタブのアイコンの表示の仕方を、よりFirefox本体のタブの挙動に近づけた
   * ブラウザ起動時のログを取得できるようにした（ツリー型タブがデバッグモードになっている場合、リモートデバッガ上で `log.logs.join('\n')` を実行するとログを出力できます）
   * `de`ロケール更新 (by sicherist, thanks!)
 - 2.4.21 (2018.5.16)
   * 現在のタブと同じサイトのページが新しい孤立したタブで開かれた場合に、現在のタブの子タブにできるようにした
   * 設定画面をセクションごとに折りたためるようにした
   * コンテキストメニュー内の項目について、同じアクセスキーの項目が他に無ければ即座にコマンドを実行するようにした
   * アクティブなウィンドウ以外にまでタブバーをスクロールするショートカットが作用してしまっていたのを修正
   * セッション復元時に、実際にタブを選択するまでは、グループ化用のタブの初期化を行わないようにした
   * 現在のタブを閉じた後のタブのフォーカスの制御が機能しなくなっていたのを修正（後退バグ）
 - 2.4.20 (2018.5.14)
   * 旧バージョン向けに設定されたスタイル指定でタブのラベルの色を変更できなくなっていたのを修正（後退バグ）
   * [Conex](https://addons.mozilla.org/firefox/addon/conex/)によって開き直されたタブがタブバーから消えてしまう問題を修正（後退バグ？）
   * 新しいアクティブなタブが開かれた時に、複数のタブがアクティブになっているように見える事があったのを修正
 - 2.4.19 (2018.5.13)
   * [タブの上でのマウスの移動を監視するためのAPIを追加した](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#when-the-pointer-is-moved-over-tabs)
   * サイドバー内の書字方向を設定できるようにした
   * 折りたたまれたツリーについてツールチップで子孫タブを表示する機能を無効化できるようにした
   * タブの上でのツールチップについて、タイトルが長すぎて表示しきれない時にだけ表示するようにした
   * アニメーション効果の設定を、偽コンテキストメニューなどのメニュー風UIの表示にも反映するようにした
   * ネイティブのUIに合わせて、偽コンテキストメニューや確認ダイアログでキーが押された瞬間に反応するようにした
   * 複数のツリーが閉じられる操作をした時の確認ダイアログを複数回表示されないようにし、「右側のタブを閉じる」や「他のタブを閉じる」で既に確認済みの場合にも確認ダイアログを表示しないようにした
   * 複数のタブが閉じられる操作をした時の確認ダイアログについて、キーボードでの操作を継続できるように、キーボード操作で表示される場合は可能な限りコンテンツ領域内に表示するようにした
   * 「新しい子タブをツリーの先頭に追加する」設定を、ピン留めされたタブから開かれて自動的にグループ化されたタブにも反映するようにした
   * ピン留めされたタブが無い時にタブを最初のタブの前に移動できなくなっていたのを修正（最近のバージョンでの後退バグ）
   * Ctrl-Shift-PageDownでタブが移動されたときに、ツリーから正しく切り離されるようにした（最近のバージョンでの後退バグ）
   * タブがフォーカスされた時にスクロール位置がずれる現象について、ほとんどの場合で現象が起こらないように対策を取った
   * バックグラウンドのタブをそのままドラッグできるよう、ドラッグ＆ドロップ後にタブのフォーカス状態を再設定しないようにした（Inspired from codes by Lej77, thanks!）
   * タブを中クリックで閉じる操作をAPI経由でキャンセルできるようにした（Inspired from codes by Lej77, thanks!）
   * サイドバー上でのマウスのボタン操作について、同じボタンのmouseupとmousedownをペアで取り扱うようにした（by Lej77, thanks!）
   * タブのラベルについて「..」で省略する代わりに透明にフェードアウトするようにした（by Keith94m thanks!）
   * `de`ロケール更新 (by sicherist, thanks!)
 - 2.4.18 (2018.3.22)
   * 偽コンテキストメニューに項目を追加するAPIにおいて、`enable`と`icons`をパラメータとして受け取れるようにした
   * [`register-self` APIでの`icons`パラメータの指定に対応](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#register-and-unregister)
   * 新しく開かれた子タブが間違った位置に配置される問題について改善
   * スクロールバーとキャッシュの取り扱いに関する設定項目を通常の設定項目の領域に移動した
   * 設定の「詳細」セクションにおいて、大きな入力フィールドを折りたたむようにした
 - 2.4.17 (2018.3.7)
   * タブの既定のアイコンについて、Firefox 60と同じ物を使うようにした
   * アドオンマネージャと設定のタブについて、Firefoxの物と同じアイコンを表示するようにした
   * サイドバー上での偽コンテキストメニューを無効化できるようにした
   * 特定のタブの祖先タブを探す内部処理を高速化した
   * ピン留めされたタブから開かれたタブをグループ化するためのタブについて、ラベルとアイコン画像をピン留めされた親タブとの間で同期するようにした
   * 新しいタブを子タブまたは兄弟タブとして開く設定の時に、新しいタブを明示的に独立したタブとして（タブバーの末尾に）開けない問題を修正
   * API経由でタブの長押しを監視している他のアドオンがいない時は、タブのドラッグ操作を長押しで中断しないようにした
   * 他のアドオンからアドオン名無しで追加された追加のコンテキストメニューを表示できなかったのを修正
   * ユーザーによるプラットフォームごとのスタイル指定を容易にするために、サイドバーパネルのルート要素の`data-user-agent`属性に`HTTP_USER_AGENT`の値を設定するようにした
   * [`get-tree` API](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#data-format)で各タブについて`ancestorTabIds`を返すようにした
   * API経由で通知されるメッセージについて、明示的にそれをlistenすると宣言したアドオンに対してのみメッセージを通知するようにした（ただし後方互換性のため、listenするメッセージの指定が無いときはバージョン2.4.16以前で通知されていたすべてのメッセージを通知します）
 - 2.4.16 (2018.2.12)
   * 既定のショートカットがFirefox自身のショートカットと重ならないようにした（タブバーのスクロールに使うショートカットの既定値をAlt-Shift-Up, Alt-Shift-Down, Alt-Shift-PageUp, Alt-Shift-PageDown, Alt-Shift-Home, Alt-Shift-End.に変更）
   * サイドバーを行単位でスクロールするショートカットで、3行分ずつスクロールするようにした
   * ピン留めされたタブを内部的にも折りたためないようにした（仮に何らかの理由で意図せずピン留めされたタブが折りたたまれようとした場合でも、操作は安全にブロックされます）
   * コンテキストメニューの「このツリーを閉じる」「このツリーの子孫だけをを閉じる」「このツリーを除く他のタブをすべて閉じる」機能が動作しなくなっていたのを修正（2.4.15での後退バグ）
   * 「Metal」テーマにおいて、「新しいタブ」ボタンの上に重ねて表示するボタンの外観を改善
   * `de`ロケール更新 (by sicherist, thanks!)
 - 2.4.15 (2018.2.11)
   * Firefox 60以降においてコマンドに割り当てるキーボードショートカットをカスタマイズできるようにした
   * 偽コンテキストメニューの「すべてのタブをブックマーク」が動作しなくなっていたのを修正（2.4.11～13の後退バグ）
   * 既定のキーボードショートカットとして、Alt-Up（↑）、Alt-Down（↓）、Alt-PageUp、Alt-PageDown、Alt-Home、Alt-Endでサイドバー内のツリーをスクロールできるようにした
   * `zh_TW`ロケール更新 (by Bo-Sian Li, thanks!)
 - 2.4.14 (2018.2.10)
   * 偽コンテキストメニューからのタブの複製、ウィンドウをまたいだタブの移動が正常に行われなくなっていたのを修正（2.4.11での後退バグ）
 - 2.4.13 (2018.2.10)
   * 「前回のセッションを復元」でツリーが復元されなくなっていたのを修正（2.4.12での後退バグ）
 - 2.4.12 (2018.2.9)
   * Ctrl-Tab/Ctrl-Shift-Tabでのタブのフォーカス切り替えで最後にフォーカスされたタブについて、「タブがフォーカスされたらツリーを展開する」設定の状態に基づいてツリーを展開するかどうか判断するようにした
   * 追加のコンテキストメニューにラベルが表示されなくなっていたのを修正（2.4.11での後退バグ）
   * タブの上でのドラッグ操作のパフォーマンスを改善
 - 2.4.11 (2018.2.9)
   * 言語リソースのキー名が[仕様](https://developer.mozilla.org/en-US/Add-ons/WebExtensions/API/i18n/Locale-Specific_Message_reference#Member_details)に則っていなかったのを修正
 - 2.4.10 (2018.2.9)
   * 「新しいタブ」ボタンの長押しの既定の動作をコンテナー選択に変更（Firefoxのタブバーのボタンに合わせた）
   * コンテナー選択用のボタンが非表示の場合は新しいタブを開く位置の選択用ボタンを右側に表示するようにした
   * 新しい子タブをツリーの先頭に挿入する設定の時に、`browser.tabs.selectOwnerOnClose`によるFirefox自身のフォーカス移動が無視されてしまっていたのを修正（2.4.9での後退バグ）
   * ピン留めされたタブから開かれた1つ目のタブが設定通りの位置に配置されなくなっていたのを修正（2.4.9での後退バグ）
   * APIを介した他のアドオンとの連携について、ツリー型タブの方が後から初期化された場合にアドオンの登録や初期化に失敗する場合があったのを修正
   * タブの上でのドラッグ操作のパフォーマンスを改善
   * ツリーの開閉操作のパフォーマンスを改善
 - 2.4.9 (2018.2.8)
   * 「新しいタブ」ボタンの長押しで、位置（関係）を指定して新しいタブを開けるようにした
   * 「新しいタブ」ボタン上でコンテナーを選択するUIの見た目を改善
   * 複数のタブを一度に閉じる操作をしたときは警告するようにした
   * 偽コンテキストメニューの振る舞いを改善し、キーボード操作に対応した
   * [Conex](https://addons.mozilla.org/firefox/addon/conex/)のようにタブを非表示にするアドオンとの互換性を向上した（非表示にされたタブはツリー型タブのサイドバー内でも非表示になります）
   * 新しく開かれたタブがすぐにアクティブになった場合、その位置まで必ずスクロールするようにした
   * 同じピン留めされたタブから開かれたタブをグループ化する機能について、タブが複数開かれた段階で初めてグループ化するようにした
   * 同じピン留めされたタブから開かれたタブをグループ化するためのタブについて、親となるピン留めされたタブのコンテナーを継承するようにした
   * グループ化用のタブの内容として、配下のタブを表示するようにした（項目をクリックするとそのタブにフォーカスします）
   * ツリー型タブの更新時などに、グループ化用のタブの動作が停止する事があったのを修正
   * 他のプロファイルからセッション情報だけを持ち越した場合に、復元されたグループ化用のタブが空のタブになってしまわないようにした
   * グループ化用のタブについて、「一時的なグループ」チェックボックスの説明をより分かりやすくした
   * 内部的に保持されたツリーの状態とサイドバー上に表示されるツリーの状態との間の不整合を軽減
   * [APIでタブを指定する時のエイリアス](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#basics-to-specify-tabs)として、`senderTab`でコンテントスクリプトに対応するタブを指定できるようにした
   * `de`ロケール更新 (by sicherist, thanks!)
 - 2.4.8 (2018.2.1)
   * ツリーがキャッシュから復元された場合の起動時の致命的なエラーを修正
   * フォーカスを移動せず単にCtrlキーを押して放しただけという時に、フォーカス中の折りたたまれたツリーが勝手に展開されてしまっていたのを修正
   * ツリーがキャッシュから復元された場合において、Ctrlキーの検出が初期状態で行われない問題を修正
   * 「新しいタブを開く」ボタン上で右クリックした時に、Windowsにおいて意図せず新しいタブが開かれてしまっていたのを修正
   * 初回起動時のメッセージを含むページを、内部URI`about:treestyletab-startup`で簡単に再表示できるようにした
   * APIにおいて、`tabs.Tab`の拡張型として返される情報の中に、タブのインデントの深さを示す`indent`を含めるようにした
 - 2.4.7 (2018.1.30)
   * キャッシュからのタブ復元時の致命的なエラーを修正
   * Mixedテーマにおいて、アクティブなタブおよびポイントされたタブにマーカーを表示して、Firefox本体のタブに似た見え方になるようにした
   * Linux上でのVertigoテーマとMixedテーマにおいて、アクティブなタブおよびポイントされたタブを強調表示するための色にシステムカラーの`Highlight`を使うようにした
   * Vertigoテーマで背景色が正しく反映されていなかったのを修正
   * `en`ロケール更新 (by Thomas Bertels, thanks!)
   * `zh_TW`ロケール更新 (by Bo-Sian Li, thanks!)
   * `de`ロケール更新 (by sicherist, thanks!)
 - 2.4.6 (2018.1.26)
   * 入れ子になった一時的なグループ化用タブについて、不要になった物が期待通りに自動で閉じられない問題を修正
   * ピン留めされたタブから開かれたタブをグループ化しない設定の時に、ピン留めされたタブから開いたタブがタブバー末尾に開かれなかったのを修正
   * 意図せず読み込まれてしまったタブに対する自動的なアンロード処理を初期状態で無効化した
   * 致命的なエラーによって初期化が完了しない事があったのを修正
 - 2.4.5 (2018.1.26)
   * [現時点では権限 `tabHide` がMozilla Add-ons Webサイトによって拒絶される](https://github.com/mozilla/addons-linter/issues/1788)ため、その権限に依存する「アクティブでないタブを隠す」機能を無効化した
 - 2.4.4 (2018.1.25)
   * アクティブでないタブをFirefoxの上部タブバーから隠す機能を追加（Firefox 59以降で動作し、追加の権限と、Firefoxの隠し設定`extensions.webextensions.tabhide.enabled`の手動での有効化が必要です）
   * 複数のタブが素早く開かれた時のトラッキングをより正確に行うようにした
   * レガシー版と同様に、リンクがタブの上にドロップされた時の開き方をその都度選択できるようにした
   * リンクのドラッグ中にタブの上でしばらく待つとそのタブにフォーカスを切り替える、という挙動が働いていなかったのを修正
   * ツリーの親になっているタブでも、Shift-ドラッグによってツリーから切り離して単独で移動できるようにした
   * 通常のウィンドウとプライベートウィンドウの間でのタブの移動を禁止するようにした（Firefoxの挙動に合わせた）
   * タブの「新しいウィンドウへ移動」およびそれに類する機能について、プライベートウィンドウでも正しく動作するようにした
   * Ctrl-PageUp/Ctrl-PageDownを、タブ切り替えのショートカットとしてCtrl-Tab/Ctrl-Shift-Tabと同様に捕捉するようにした
   * ピン留めされたタブの上でコンテキストメニューから「右側のタブを閉じる」と「他のタブを閉じる」を実行できるようにした（Firefox 59の挙動に合わせた）
   * テーマの背景色を可能な限り早く反映するようにした
   * グループ化用のダミーのタブについて、既定のタイトルをそのグループの最初の子タブのタイトルに同期するようにした
   * グループ化用の他ミーのタブのタイトル編集機能が正しく動作していなかったのを修正
   * 複数のタブが自動でグループ化された時に、グループ化用のタブではなくグループの最初のタブにフォーカスするようにした
   * ピン留めされたタブから開かれたタブが設定通りの位置に配置されていなかったのを修正
   * 異常事態のフェイルセーフとして、親タブがないのに折りたたまれた状態のタブにフォーカスされた時はタブを表示し直すようにした
   * タブの読み込み中表示のアニメーションの画面外描画に起因してCPU使用率が異常に高くなる問題を修正
   * サイドバー内のスクロールバーの表示位置を制御する設定を追加
   * 「タブをウィンドウ外にドラッグ＆ドロップしたら新しいウィンドウに切り離す」という挙動そのものを抑制する隠し設定 `moveDroppedTabToNewWindowForUnhandledDragEvent` を追加
   * Firefox Syncでいくつかの設定を同期するようにした
   * `zh_TW`ロケール更新 (by lycsjm, thanks!)
   * `de` ロケール追加 (by sicherist, thanks!)
   * APIでタブを指定する時に[`current`およびその他の便利なエイリアス](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#basics-to-specify-tabs)を使えるようにした
   * [タブのインデントの深さの増加](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#indent-demote-tab)、[インデントの深さの減少](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#outdent-promote-tab)、[ツリーごとまたは単体での移動](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#move-tree-to-different-position)、[複製](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#duplicate-tab-as-childsibling-tab)、[フォーカス移動](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#focus-to-the-nextprevious-sibling-tab)、[タブのグループ化](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#create-new-group-from-given-tabs)を行うAPIを追加した
 - 2.4.3 (2017.12.12)
   * 単独のタブがグループ化されてしまう問題を修正（2.4.2の後退バグ）
 - 2.4.2 (2017.12.12)
   * Firefoxの再起動やツリー型タブの更新・リロードでグループ化用のタブが失われる問題を修正（2.4.xでの後退バグにより、これらの操作でグループ化用のタブが失われる状態になっていました）
   * ピン留めされたタブから開かれたタブを自動的にグループ化する機能を追加
 - 2.4.1 (2017.12.11)
   * 擬似的な表示を行う際のSVGアイコンとタブの読み込みアイコンの表示の乱れを修正
   * 新しいタブがタブバーの末尾に開かれる時、1つ手前のタブの子にならないようにした
 - 2.4.0 (2017.12.9)
   * キャッシュを使用してツリーの復元を高速化した（キャッシュが原因でツリーが壊れる可能性があります。その場合、ツリー型タブの設定の「デバッグモード」からキャッシュを無効化して下さい。）
   * タブのクローズボックス、「新しいタブ」ボタン、および音声再生状態表示のアイコンを絵文字ではなくSVG画像にした（[Bug 1377302](https://bugzilla.mozilla.org/show_bug.cgi?id=1377302)または[Bug 1421329](https://bugzilla.mozilla.org/show_bug.cgi?id=1421329)が修正されるまでは、CPU負荷の高い擬似的な表示となります。CPU使用率を下げたい場合、`about:config`で`svg.context-properties.content.enabled`を有効にし、ツリー型タブの設定の「デバッグモード」から擬似的なSVGアイコン表示のチェックをOFFにして下さい。）
   * Plain、Flat、Vertigo、Mixedの各テーマについて、LinuxではPhotonの配色ではなくシステムカラーを使うように戻した
   * すべての環境でシステムカラーを使用する「ハイコントラスト」テーマを追加 (contributed by actionless, thanks!)
   * 「Plain」とほとんど差が無かった「Flat」テーマを廃止
   * 「Plain」とその系列のテーマにおいて、ピン留めされたタブがあるときだけタブバーの上端の枠線を表示するようにした
   * macOSでのタブに重なるスクロールバーのための追加のマージンについて、タブバーがスクロール可能なときにのみ適用するようにした
   * タブの未読状態をサイドバーの再読み込み後も維持するようにした
   * タブのアイコンに対する重複したリクエストを行わないようにした (contributed by UENO Katsuhiro, thanks!)
   * グループ化用のタブにおいて、タイトルの編集と一時的なグループの切り替えを可能にした
   * グループ化用のタブについて、一時的なグループとして設定されている場合は自動的には閉じないようにした
   * タブをブックマークツールバーにドロップした時に、タブがウィンドウから切り離されてしまっていたのを修正
   * キー入力に対して無駄なログを出力しないようにした
 - 2.3.0 (2017.11.30)
   * WindowsとLinuxにおいて、既定の状態でスクロールバーを細く見せるようにした
   * macOSでスクロールバーが表示される領域のためにタブ内にマージンを追加するようにした
   * Ctrl-Tab/Ctrl-Shift-Tabでのフォーカス切り替え中に、Shiftキーを押したり放したりしたときにツリーを意図せず展開しないようにした
   * 現在のタブを閉じた後のフォーカスの制御を行わない設定を追加した
   * Firefox 58移行において、現在のタブを閉じた後のフォーカス移動で意図せず復元されてしまったタブを、再度アンロードするようにした
   * プライベートブランジングモード用に`about:privatebrowsing`を空の新規タブの一種と認識するようにした。
   * 親のタブに手動操作で子タブが追加された場面では常にツリーを展開するようにした
   * 最上位の階層のタブから兄弟タブを開く際、期待される通りの位置にタブを開くようにした
   * タブがドラッグ＆ドロップなどの操作で既存のタブの子にされたとき、より適切な位置にタブを配置するようにした
   * ウィンドウ外にタブをドロップしてもタブがウィンドウから切り離されない場合があったのを修正（過去バージョンでは、ドラッグ開始後にまっすぐ左右に動かした時だけドロップ操作でタブが切り離されていた）
   * 複数の新しいタブが開かれた後の自動グループ化後に、グループ内の最初のタブに対する選択状態を復元するようにした
   * 「前回のセッションを復元」などの操作の際のセッション復元処理をより高速に処理するようにした
   * 新しく子タブとして開かれたタブについて、親となったタブのコンテナーを継承するようにした
   * コンテナーの継承が有効な場合に、コンテナー選択UI上に「既定」を表示して既定のコンテナーでタブを明示的に開けるようにした
   * 偽コンテキストメニューから「すべてのタブをブックマーク」できなくなっていたのを修正（後退バグ）
   * 閉じられたタブの要素がDOMツリー状に残ってしまっていたのを、正しく消去するよう修正（後退バグ）
   * タブやfaviconのサイズについて計測誤差が発生していたのを修正（後退バグ）
   * タブの読み込み中のアニメーション効果をFirefox 57においても同期するようにした(Many thanks to Lej77!)
   * 「Plain」「Flat」「Vertigo」「Mixed」および初回インストール後に表示されるページの配色をPhotonの配色に合わせた
   * 「Plain Dark」の配色をFirefox組み込みの「Dark」テーマと同じは移植にした
   * macOSにおいてタブのクローズボックスの表示が小さすぎたのを修正
   * 既定の状態ではコンテナータブの選択メニューを表示しないようにした
   * カスタマイズのベースにする専用のテーマとして「装飾なし」を追加した
   * Darkテーマ選択時のツールバーボタンに白色のアイコンを使うようにした
   * サイドバーの内容のズームイン・ズームアウトを既定の状態で禁止するようにした（デバッグモードで`zoomable`を`true`に設定すると従来の挙動に戻ります）
   * 他のアドオン向けの通知系APIで、タブのmousedownとmouseupの両方を通知できるようにした
   * 他のアドオンがタブバー上での操作を監視している場合でも、「新しいタブ」ボタンの中クリックを認識できるようにした
   * zh_TWロケール追加 (by lycsjm, thanks!)
 - 2.2.11 (2017.11.18)
   * 2.2.10でのタブの数が非常に多い場合のパフォーマンスの低下を改善
 - 2.2.10 (2017.11.18)
   * いくつかの権限を必須でなくした
   * ツリー上にURIでない文字列がドラッグ＆ドロップされた場合に、ホスト名風の形式の場合はホスト名と見なして開くようにした
   * [Firefox Multi-Account Containers](https://addons.mozilla.org/firefox/addon/multi-account-containers)によって開き直されたタブを、なるべく元のタブの位置でツリーに取り込むようにした
   * キーボードショートカットでのタブ切り替え時に、折りたたまれたツリーの上でしばらく滞在したら自動的にツリーを展開するようにした
   * 設定画面に誘導のリンクや追加の説明を追加
   * 子タブが2つだけで2つ目の子タブが選択されているとき、そのタブを閉じるとフォーカスの飛び先が期待と異なる状態になっていたのを修正
   * [自動的なツリー形成を抑止する隠し設定を導入した。](https://github.com/piroor/treestyletab/issues/1544)
 - 2.2.9 (2017.11.17)
   * ピン留めされたタブにインデントが反映されてしまっていたのを修正
   * レガシー版からの移行後に表示されるメッセージのタブを自動的に閉じないようにした
 - 2.2.8 (2017.11.16)
   * タブのタイトルが長すぎるときの省略時の記号の幅を減らした
   * 折りたたまれたツリーを閉じるときに、一瞬ツリーが展開されるようなアニメーションが反映されてしまっていたのを修正（後退バグ）
   * ツリーの子タブが単純に並べ替えられたときに内部的な並び順が更新されていなかったのを修正（後退バグ）
   * 「サイドバー」スキン選択時にタブのクローズボックスの幅が狭まってしまっていたのを修正
 - 2.2.7 (2017.11.15)
   * ウィンドウごとにテーマの色を反映するようにした
 - 2.2.6 (2017.11.15)
   * Ctrl-Tab/Ctrl-Shift-Tabでのタブ切り替え時に、折りたたまれたタブを飛ばすようにした（ただし[いくつかの制限事項あり](https://github.com/piroor/treestyletab/issues/1531#issuecomment-344487289)）（2.2.4の機能として記載していたがファイルのコミット忘れにより動作していなかった）
 - 2.2.5 (2017.11.15)
   * Firefox 57の時点で未実装の機能を呼ばないようにした
 - 2.2.4 (2017.11.15)
   * [VivaldiFox](https://addons.mozilla.org/firefox/addon/vivaldifox/)や[Container Theme](https://addons.mozilla.org/firefox/addon/containers-theme/)などのような拡張機能によるテーマカラーの変更を反映するようにした（WebExtensions APIの制限のため、拡張機能でないテーマは反映されません）
   * 新しいツリーを形成したときに既存のツリーが折りたたまれなくなっていたのを修正（後退バグ）
 - 2.2.3 (2017.11.15)
   * マルチプルタブハンドラとの連携用にAPIを追加
 - 2.2.2 (2017.11.14)
   * ツリーの新しい子を既存の子の上に追加する設定の時にタブの順番が壊れる問題を修正（後退バグ）
 - 2.2.1 (2017.11.14)
   * サイドバー以外の場所でタブを操作した場合にツリーとして扱わない設定を追加
   * タブをウィンドウから切り離した時の動作が壊れていたのを修正（後退バグ）
 - 2.2.0 (2017.11.14)
   * 起動処理、全般的なツリー構造の参照処理、ツリーの開閉処理を高速化
 - 2.1.2 (2017.11.12)
   * 深いレベルのタブを閉じた後にツリーのインデントが失われる問題を修正（後退バグ）
   * セッション情報の移行手順への誘導を追加
 - 2.1.1 (2017.11.11)
   * ツリー開閉時のアニメーション効果を最適化
   * 新しいツリーを形成したとき、設定に従わず他のツリーが展開されたままになっていたのを修正（後退バグ）
   * ダミーのグループ化用のタブについて、キー無しのURLパラメータでの名前指定に対応.
   * ツリー構造のインポートの際に、ロードできるはずのURIがロードされなくなっていたのを修正（後退バグ）
 - 2.1.0 (2017.11.9)
   * セッション復元時のツリーの復元処理を改善
   * Ctrl-T等で開かれるタブの取り扱いを改善
   * 従来の`about:treestyletab-group`を新しい`moz-exteions://...`にリダイレクトするようにした
   * ツリーの最後の子をドラッグ＆ドロップで1つ上位の階層に移動しようとした時にツリーが壊れる問題を修正
   * タブのドラッグ操作中のコピー操作（Ctrlキー）を正しく認識するよう修正（後退バグ）
   * サイドバーの開閉状態をより正しく識別するよう修正（後退バグ）
   * 複製されたタブを開く位置を設定通りに制御するようにした
   * 「新しいウィンドウに移動」コマンドで、指示されたタブだけでなく子孫のタブも一緒に移動するようにした
   * タブをスクロールバー上にドロップできなくした
   * 「新しいウィンドウに移動」で移動された後のタブについてアンロード状態を維持するようにした
   * 偽コンテキストメニューからの操作によってタブを新規ウィンドウに移動できるようにした
   * 「右のタブを閉じる」が期待通りに動作するようにした。
   * グループ化用のダミーのタブの背景色を真っ白ではない落ち着いた色に変更
   * APIの入力として、ウィンドウをまたいだ移動によって変化した不正なIDも受け付けるようにした
 - 2.0.7 (2017.10.18)
   * セッション復元時により安定してツリーを復元するようにした
 - 2.0.6 (2017.10.17)
   * 内部的にツリーが折りたたまれた状態のタブについて、新しい子タブをフォアグラウンドで開けなくなっていたのを修正（2.0.3での後退バグ）
   * クラッシュからの復元時に、可能な限りツリーの開閉状態を復元するようにした
   * 他のアドオンからタブの親子関係を参照できるように、タブの`tabs.Tab.openerTabId`の情報をツリー構造に基づいて更新するようにした
   * タブの`tabs.Tab.openerTabId`が外部要因で変更された場合、ツリー構造に自動的に反映するようにした（※[bug 1409262](https://bugzilla.mozilla.org/show_bug.cgi?id=1409262 "1409262 - Updated openerTabId is not notified via tabs.onUpdated if it is changed by tabs.update()")のため、変更は即座には反映されません）
   * Firefoxの`browser.tabs.selectOwnerOnClose`機能の作用で選択されたタブについて、その位置までタブバーがスクロールしなくなっていたのを修正
 - 2.0.5 (2017.10.14)
   * クラッシュ後のセッション復元時にツリーを可能な限り復元するようにした
   * 新しい子タブを開いた時、親タブが画面外にある場合は子タブの方に優先してスクロールするようにした
   * タブの読み込み完了のアニメーション効果が読み込み完了済みのタブで何度も表示されないようにした
   * タブバー上でのクリックについて、API経由で`tabbar-clicked`を受け取ったアドオンが`true`を返してTSTの既定の挙動をキャンセルできるようにした
   * macOS上でmacOS固有の挙動が反映されていなかったのを修正
 - 2.0.4 (2017.10.10)
   * 新しいタブが開かれてタブバーの内容が溢れるときに、現在のタブが画面外にスクロールしてしまわないようにした
   * ウィンドウのリサイズでタブバーの内容が溢れたときは、画面外にタブがある事を示す青いグラデーションの通知を表示しないようにした
 - 2.0.3 (2017.10.10)
   * FirefoxがファイルやURLの関連付けから起動された場合に、復元されたタブのツリー構造が失われないようにした
   * サイドバー内のUIをメッセージボックス用のシステムフォントで表示するようにした（Firefoxのタブに合わせた）
   * ツリーの最大の深さの設定が正しく機能していなかったのを修正（`0`を指定した場合も含む)
   * 現在のタブを閉じた後のタブのフォーカス制御をより正しく行うようにした
   * 偽コンテキストメニューの「他のタブを閉じる」でピン留めされたタブまで閉じられてしまっていたのを修正
   * 偽コンテキストメニューでクリックされた項目が反応するべき場面でのみ反応するようにした
   * 偽コンテキストメニューが開かれるタイミングを実行環境の一般的なコンテキストメニューと同じにした
   * タブバーのスクロール位置を復元するようにした
   * TSTのサイドバーの初期化処理を並列化し、初期化にかかる時間を短縮した
   * TSTのサイドバーが非表示の時にツリー関連の挙動を反映するかどうかを制御する設定（初期状態で有効）を追加した
   * ホームに複数のURLを設定している場合などで、Firefoxのウィンドウを開いた時に開かれる複数のタブがグループ化されないようにした（「ウィンドウが開かれるのと同時に開かれた」と見なしてタブをグループ化しない最大の遅延時間は初期値500ミリ秒とし、カスタマイズ可能とした）
   * タブの音声再生状態を示すアイコンが正しく更新されていなかったのを修正（2.0.2での後退バグ）
   * 設定に従って、サイドバー内の「新しいタブ」ボタンから正しく現在のタブの次の兄弟として新しいタブを開けるようにした
   * フォーカス移動や現在のタブが閉じられた事によるツリーの自動開閉をより適切に行うようにした
   * ツリーの開閉状態が正しく復元されない場合があったのを修正
   * タブの読み込み状況を示すアニメーションが延々と表示され続けてしまう場合があったのを修正
   * 閉じたタブを開き直した際にツリー構造をより正しく復元するようにした
   * 複製されたタブを閉じた後に開き直すとツリー構造が壊れていたのを修正
   * 「Metal」テーマでタブの高さが想定より細すぎる状態になっていたのを修正
   * ツリーの直後の位置にFirefoxや他のアドオンによって移動されたタブについて、閉じられたツリーであった場合は子として追加しないようにした
   * 無効な中ボタンクリック（ボタンを押してから放すまでの間に他のタブなどの位置にポインタが移動したケース）において、中ボタンクリックされたタブを閉じる機能やタブバーの中ボタンクリックで新しいタブを開く機能が作用しないようにした
   * 復元されたタブ・複製されたタブのフォーカスや位置の制御をより正しく行うようにした
   * 開かれた直後に閉じられたタブによってサイドバー内に閉じられないタブが残ってしまう問題を修正
   * レガシー版TSTと同様に、マウスのボタンを押したら放す前にすぐにそのタブにフォーカスを切り替えるようにした
   * いくつかの設定項目のラベルで「末尾」を示すために「last」と書いていたのを「end」に改めた
   * 新しいタブを開いた時にそのせいでタブバーの内容が溢れた場合、開かれたタブがスクロール範囲外に出たままにならないようにした
   * 他のアドオンからTSTが有効かどうかを確認するためだけのAPIとして[`ping` API](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#uninit-special-features-for-tst-when-tst-is-going-to-be-disabled)を追加した
   * [`get-tree` API](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#get-tree-information)で取得されたタブの`active`の値が期待と異なっていたのを修正
 - 2.0.2 (2017.10.4)
   * Firefoxに合わせて、タブが無い領域でのミドルクリックで新しいタブを開くようにした
   * Firefoxに合わせて、タブの読み込み状況のアニメーションをすべてのタブで同期するようにした
   * Firefoxに合わせて、タブの読み込みが完了した事を知らせるアニメーション効果を反映するように下
   * 偽コンテキストメニューをメニュー用のシステムフォントで表示するようにした
   * タブが無い領域の上で偽コンテキストメニューの項目が機能していなかったのを修正
   * いくつかのテーマでアクティブなタブの読み込み状況のアニメーションが見えなくなっていたのを修正
   * 現在のタブが親を持たない場合に、兄弟の階層に新しくタブを開くときの位置がおかしくなっていたのを修正
   * 2つ目以降のウィンドウにおいて新しく開かれたタブ群を正しくグループ化できていなかったのを修正
   * ウィンドウが閉じられたときに、残りのウィンドウのいずれかでグループ化用のダミーのタブが開かれてしまっていたのを修正
   * 未読のピン留めされたタブについて、アイコンのみの表示でない場合はハイライト表示しないようにした
   * Firefoxの `browser.tabs.selectOwnerOnClose` に基づくタブのフォーカス切り替え動作をより正しく尊重するようにした（ツリー型タブに全面的にタブのフォーカス切り替えを任せる場合は、この隠し設定を`about:config`から手動で無効にして下さい）
   * 新しいタブが連続して開かれたときに、グループ化用のタブ自体を再帰的にグループ化してしまう場合があったのを修正
   * [ホイールスクロールの動作を上書きするためのAPI](https://github.com/piroor/treestyletab/wiki/API-for-other-addons#override-reaction-for-mouse-wheel-rotation-on-the-vertical-tab-bar)を追加。
   * zh-CNロケール更新（by YFdyh000, thanks!）
 - 2.0.1 (2017.9.29)
   * ミドルクリックでタブを閉じる動作について、Firefox本体と同様にボタンを放したときにタブを閉じるようにした
   * タブがドラッグ中である事を示す外観がドラッグ操作のキャンセル後も残る場合があったのを修正
   * タブのドラッグ操作中に意図せずウィンドウから切り離されてしまいやすかったのを修正（ドラッグ中のタブ自身の上でのドロップ操作を単に無視するようにした）
   * 日本語ロケールで一部の翻訳が反映されていなかったのを修正
   * 「Sidebar」テーマでの無駄に大きな余白をなくした（by Niklas Hambüchen. Thanks!）
   * 新しい空のタブを開く操作で開かれたタブの位置を制御するオプションを、キーボードショートカット（Ctrl-Tまたは⌘-T）で「about:newtab」というURIを伴って開かれたタブについても反映するようにした（ただしいくつかの問題があります。[技術的な詳細説明](https://github.com/piroor/treestyletab/issues/1038#issuecomment-332711522)も併せてご覧下さい）
   * 新しいタブの位置を制御するオプション群について、「現在のタブの次の子として開く」設定がより正しく反映されるようにした
   * 現在のタブを閉じた後のタブのフォーカス制御について、制御し切れていない部分があったのを修正
   * サイドバー内のコンテキストメニューの「タブを新しいウィンドウに移動」が動作していなかったのを修正
   * 読み込み中である事を示すアニメーション効果のCPU負荷を低減した
   * WhatsApp Webのタブで異常にCPU負荷が高くなってしまっていたのを修正
   * WhatsApp Webを含むいくつかのWebサイトについて、再起動後もアイコンが復元されるようにした
   * タブのラベルなどの更新をより正しく反映するようにした。例えば、ソースを表示するタブがより確実に正しいタイトルで表示されるようになった。
   * 親のタブを閉じた後でグループ化用のタブで置き換える設定のときに、閉じられた親タブを開き直してもツリー構造が復元されていなかったのを修正
   * 折りたたまれたタブのツールチップに、折りたたまれた子孫タブの名前も出力されるようにした
   * レガシー版TSTからバージョン2以降へのアップデート時に、サイドバーの開き方を案内するメッセージを表示するようにした
   * ピン留めされたタブをアイコン化しないようにする設定を簡単に反映できるようにした
 - 2.0 (2017.9.26)
   * WebExtensionsベースで作り直した
 - 0.19.2017090601
   * Firefox 57以降に対応したバージョンへの移行のために、ツリー型タブの設定とツリー情報がエクスポート可能になりました。設定ダイアログの「詳細」セクションを参照して下さい。
   * 起動時・ウィンドウ単位のセッション復元時にツリーの状態が復元されるタイミングを変更（SSTabRestoringイベントの発生を待たないようにした）
   * ツールバー内のあらゆるアニメーション効果でタブバーの再描画が発生していたのを修正
 - 0.19.2017090201
   * ツールバーの表示・非表示がアニメーション効果を伴って変更されたあともタブバーの表示位置を更新するようにした
   * 新しめのFirefoxで初期化処理に失敗する問題を修正
   * ブックマークサイドバーへの項目のドロップ時にブックマークが二重に作成される問題を修正
   * ruロケール更新（by Infocatcher. Thanks!）
   * fr-FRロケール更新（by AxlMun. Thanks!）
 - 0.19.2017061601
   * Nightly 56.0a1に対応
   * Firefox 52以降でタブバーに複数のファイルをドロップできなくなっていたのを修正
   * 可能な限り新しく開かれたタブの位置までタブバーをスクロールするようにした
   * コンテンツ領域にURIがドロップされた時、そのタブの中で読み込むようにした（常にタブで開かれてしまっていたのを修正）
   * 通知バーが表示された時にタブバーの表示を更新するようにした
   * Firefox 53以降の「Compact Dark」テーマに対応
   * 「同期タブ」サイドバーの項目をミドルクリックしたときは子タブでなく独立したタブとして開くようにした
   * 「コンテナタブ」機能がFirefox 54以降で動かなくなっていたのを修正
 - 0.19.2017031101
   * 最近のバージョンのFirefoxに対応（Nightly 55.0a1にて動作を検証）
   * Firefox 51およびそれ以前のバージョンへの対応を終了
   * 新しい子タブを開く位置の選択肢に「制御しない」を追加（この選択肢においては、新しいタブを開く位置はFirefoxの通常の挙動に従います）
   * 自動的に折りたたまれた（隠された）タブバーを表示するアクションとして（明示的な）「クリック」を追加した
   * 設定`browser.tabs.insertRelatedAfterCurrent`=`true`によって開かれたタブをより正しく子タブとして扱えるようにした
   * タブバーを自動で隠す機能の、マウスの移動を検知する遅延時間の設定UIが機能していなかったのを修正
   * タブバーの位置をドラッグ＆ドロップで動かせなくなっていたのを修正
   * ドラッグ中のツリーを一時的に折りたたむようにした（前のバージョンで実験的に導入した「縮める」動作は廃止）
   * 現在のタブが最後のツリーの中にあるときに、新しい空のタブを現在のタブと同階層に開く設定が期待通りに作用していなかったのを修正
   * タブをまとめて閉じた後で親タブを復元したときに、子タブをまとめて復元する機能が働かなくなっていたのを修正
   * 「Vertigo」スキンの外観がおかしくなっていたのを修正
   * Webサイト作者によってツリー型タブのインストール状況を検知できないようにした
   * ギリシャ語ロケール追加（Translated by Vangelis Skarmoutsos. Thanks!）
   * 既知の不具合：[Firefox 52のバグ](https://github.com/piroor/treestyletab/issues/1202)により、新しく開かれたり折りたたまれた状態から展開されたりしたタブが、マウスのポインタが上に乗るまで表示されないままになります。この問題はFirefox 53以降では解消されています。気になる場合は当座の回避策として、`about:config`で`browser.tabs.animate`を`false`に設定してタブのアニメーション効果を無効化して下さい。
 - 0.18.2016111701
   * 複数の新しいタブをバックグラウンドで開くよう指定された場面で、常に最初のタブが選択されてしまう問題を修正
   * ツリーのドラッグ中にドラッグ中の他のタブを小さく縮めるようにした（実験的な機能）
   * タイトルバー内にUI要素を表示するFirefoxの機能が期待通りに動作しない部分があったのを修正（後退バグ）
   * 新しいタブを隣に開く設定が期待通り動作しない場面があったのを修正
   * macOS（OS X）におけるMetalテーマでのタブ周りの表示崩れを修正 (Many thanks to Andrew Shu! [patch 1](https://github.com/piroor/treestyletab/pull/1192), [patch 2](https://github.com/piroor/treestyletab/pull/1194))
   * Nightly 51.0a1において、ピン留めされたタブ内の録音ボタンの表示が崩れていたのを守勢
   * 古いライブラリや非推奨になったコードを削除
 - 0.18.2016090802
   * `browser.tabs.drawInTitlebar`=`false`の設定の時にブラウザウィンドウの初期化に失敗する問題を修正（0.18.2016090601以降での後退バグ）
 - 0.18.2016090801
   * ブックマークフォルダをタブで開く時の開き方を選択するダイアログをキャンセルできるようにした
     （キャンセルした場合、操作自体が取り消されてタブは一切開かれません）
   * アドオンバリデータで警告されるので`new Function()`を使わないようにした
 - 0.18.2016090601
   * `eval()`を使った関数の書き換えをなくした
   * Firefox 44より古いバージョンのサポートを終了
   * 既に更新が終了した/公開されなくなった古いアドオンとの互換性のためのコードを削除： Google Toolbar, Snap Links, Highlander, PermaTabs, FullerScreen, DragNDrop Toolbars, Optimoz Tweaks, Tabberwocky, Super DragAndGo, Drag de Go, FLST, Mouse Gestures Redox, Aging Tabs, Autohide, Smoothly Close Tabs, IE Tab Plus, Locationbar², DomainTab, TotalToolbar
   * Tab Mix Plus独自のセッション保存機構との互換性のためのコードを削除した（Firefox組み込みのセッション保存機能の使用を強く推奨します。TMPのセッション保存機能を使った場合にどうなるかは全く不明です。）
 - 0.17.2016083101
   * Firefox 51以降でタブの色がおかしくなる問題を修正（[bug 1297157](https://bugzilla.mozilla.org/show_bug.cgi?id=1297157)への追従）
 - 0.17.2016083001
   * 他のアドオンによって複製されたタブの位置の取り扱いを改善した
   * タブの上に他のタブをドロップしやすくした（タブに対するドロップと判定する領域を広げた）
   * タブバー内に検索バーなどを置いた時でもタブバーを縮められるようにした
   * 最後の子タブから開かれたタブの位置の制御に失敗していたのを修正
   * インラインフレームやbaseタグを含むページから開かれたタブが子タブにならない場合があったのを修正
   * 未定義のCSSプロパティによる警告を減らした（by asamuzaK. Thanks!）
   * [Firefox 51でのタブの文脈による色分け機能](https://blog.mozilla.org/tanvi/2016/06/16/contextual-identities-on-the-web/)に対応した
   * 設定ダイアログのペイン切り替えボタンからアイコンを削除（Firefox自体に最適なアイコンが含まれなくなるため）
   * タイトルバーにタブを描画する状態でのuserChrome.cssによるカスタマイズを容易にするための隠し設定 `extensions.treestyletab.blockTabsInTitlebar` を導入した
   * Ctrl-ドラッグ＆ドロップで複製されたタブのツリー構造が失われる問題を修正
   * コンテキストメニューの項目「画像を開く」の選択時の「unsafe CPOW usage」の警告が出ないようにした
 - 0.17.2016061501
   * Firefox 47で、Windowsにおいてメニューバーを表示するとタブバー内のスクロールバーをマウスで操作できなくなる問題を修正
   * タブバーの幅を極端に縮めた後、タブバーがoverflowの状態のままになることがあったのを修正
   * Firefox Developer EditionのDarkテーマとの互換性を向上
   * FireGesturesとの互換性を向上
   * 縮められたタブバーの幅を変更するときに、展開されたタブバーの幅が異常に大きくなることがあったのを修正
   * ツリー型タブ自身で新規タブを開く位置を決定するかどうかを制御する隠し設定 `extensions.treestyletab.controlNewTabPosition` を追加した（Tab Mix Plusのように、ブックマーク等から新しく開くタブの位置を制御する機能を持ったアドオンと併用する場合、この設定の値を`false`にすることでより良い結果を得られるようになる可能性があります）
   * ピン留めされたタブに関する変更に対しては、折りたたまれたタブバーを自動展開しないようにした
 - 0.17.2016031101
   * ウィンドウを開いて最初の1回だけ、ブックマークグループをタブで開く時にツリーにならなくなっていたのを修正（後退バグ）
   * 縦型タブバーにおいて、設定された最大のインデントの深さが保存・反映されなくなっていたのを修正（後退バグ）
   * 音声が再生されていないときにタブの消音を解除できなくなっていたのを修正（後退バグ）
   * `about:treestyletab-group`のタブとツールチップにおけるツリーをXHTML無しで実装するようにした（CSSのマルチカラムレイアウトを使うためだけにXHTMLとXULを混在させる必要はない事が分かったため）
   * タブのツールチップとダミーのグループ化用のタブにおいて、内容が1列に収まらないときだけマルチカラム表示するようにした
 - 0.17.2016030402
   * 短いタイトルのタブしかない場合にツールチップの内容が段組表示されない問題を修正
   * 新しく開かれた空のグループ化用のタブの初期化処理が失敗するようになっていたのを修正
 - 0.17.2016030401
   * マウスの移動でタブバーを自動的に開閉する機能について、開く時と閉じるときでそれぞれ個別に遅延時間を設定できるようにした（`extensions.treestyletab.tabbar.autoHide.delay.show`と`extensions.treestyletab.tabbar.autoHide.delay.hide`）
   * タブバーにスクロールバーが出ている状態でウィンドウの大きさを縮めた際に、現在のタブが画面外に隠れてしまわないようにした
   * 新しいタブが非表示の状態で開かれた場合にはタブバーを自動スクロールしないようにした
   * URIでない文字列（空白文字を含む）をタブバーにドロップした場合に、Firefoxの既定の挙動通りに検索結果のタブを開くようにした
   * タブのツールチップとダミーのグループ化用のタブにおいて、ツリーのマルチカラム表示のレイアウトをより安定した結果が得られるように改善した
   * 複数のタブをホームページに設定しているときの挙動を改善
     * 起動時には、それらをツリーでない個別のタブとして開くようにした
     * ホームボタンの左クリックでは、ツリーでない個別の新規タブとしてホームページ群を開くようにした
     * ホームボタンの中クリックでは、ツリーとしてホームページ群を開くようにした
   * 親のタブを閉じたときにダミーのグループ化用のタブで置き換える設定の時、ツリーをウィドウに切り離すとグループ化用のタブが残ってしまう問題を修正
   * タブバーのスクロールバーを細く表示する機能について、他のカスタマイズ手法と衝突しにくい実装に変更した
   * 縦横どちらの状態でもタブのツリーは常に折りたたみ可能になり、縦置きタブバーではタブのインデント表示も常に有効にするようになりました。
     これらの機能を無効化する設定はありません。
     ツリー表示機能が不要で単に縦置きのタブバーのみを使用したい場合は、[Vertical Tabs](https://addons.mozilla.org/firefox/addon/vertical-tabs/), [Vertical Tabs (Simplified)](https://addons.mozilla.org/firefox/addon/vertical-tabs-simplified/), [Side Tabs](https://addons.mozilla.org/firefox/addon/side-tabs/)などの代替アドオンを使用して下さい。
   * de-DEロケール更新（by Björn Kautler. Thanks!）
   * ruロケール更新（by Infocatcher. Thanks!）
 - 0.16.2016021602
   * 他のアドオンなどによってタブが開かれた際の既定の挙動として、より確実に`relatedToCurrent`=`true`オプション（またはリファラ）を伴って開かれたタブのみを現在のタブの子にするようにした
 - 0.16.2016021601
   * グループ化用のダミーのタブに表示するツリーをマルチカラム表示するようにした（`extensions.treestyletab.groupTab.columnize`を`false`にすると従来の挙動に戻ります）
   * ツールチップ内に表示するツリーをマルチカラム表示するようにした（`extensions.treestyletab.tooltip.columnize`を`false`にすると従来の挙動に戻ります）
   * ブックマークからタブを開くときにバラバラのタブで開く機能が動作しなくなっていたのを修正
   * タブバー内のスクロールバーを細く表示する機能について、より自然に表示するように改善
   * タブバーのスプリッターをミドルクリックした時に、grippyのクリック時と同様にタブバーを開閉するようにした
   * タブバーを自動で隠す機能について、タブのタイトルが更新されたときにフィードバックの一環としてタブバーを自動的に展開するようにした
   * タブバーを自動で隠す機能について、フィードバックとしてタブバーを自動的に展開する場合を細かく制御する隠し設定を追加した（`extensions.treestyletab.tabbar.autoShow.feedback.opened`, `extensions.treestyletab.tabbar.autoShow.feedback.closed`, `extensions.treestyletab.tabbar.autoShow.feedback.moved`, `extensions.treestyletab.tabbar.autoShow.feedback.selected`, `extensions.treestyletab.tabbar.autoShow.feedback.titleChanged`）e
   * タブバーを自動で隠す機能について、フィードバックの通知対象になったタブをハイライト表示するようにした
   * ツリーの親のタブを閉じたときの挙動について「閉じられた親のタブの位置に代わりにダミーのグループ化用のタブを開く」という選択肢を追加した
   * de-DEロケール更新（by Björn Kautler. Thanks!）
   * ruロケール更新（by Infocatcher. Thanks!）
 - 0.16.2016021201
   * [Tab Badge](https://addons.mozilla.org/firefox/addon/tab-badge/)との互換性を向上
   * e10sが有効な時に別プロセスのタブのセッションヒストリに触らないようにした（親のタブを閉じた時、次に親になるタブが別プロセスのタブだと、例外が発生してツリー構造が壊れていた）
   * `eval()`を使った関数の書き換えを減らした
   * [`browser.tabs.insertRelatedAfterCurrent`の設定を強制的に無効化しないようにして、リンクなどから開かれるタブについては既定の挙動を尊重するようにした](https://github.com/piroor/treestyletab/issues/874#issuecomment-183914331)（次項も併せて参照のこと）
   * `gBrowser.addTab()`メソッドに`relatedToCurrent:true`オプションもしくは参照元ページの情報を伴って開かれた新しいタブを、基本的に現在のタブの子として開くようにした
     （この変更により、特別な対応無しの状態でも他のアドオンが開くタブも現在のタブの子タブになるようになった）
   * `window.open()`で開かれたタブについて、参照元ページの情報から親らしきタブが見つからなかった場合は常に独立したタブとして開くようにした
   * 独立したタブを明示的に開くための新しいAPIを追加: `gBrowser.treeStyleTab.readyToOpenOrphanTab()` および `gBrowser.treeStyleTab.readyToOpenOrphanTabNow()`
     （タブを閉じた後で元のタブに自動的にフォーカスを戻すために`relatedToCurrent:true`オプションを指定しつつ独立したタブを開きたい場面向け）
   * 「タブバーを自動的に縮める」設定の時にタブバーをスクロールするとタブバーが勝手に縮んでしまっていたのを修正
   * タブバーを自動で隠す状態の時、Ctrl-Tabでのタブ切り替え時にタブバーが頻繁に出たり消えたりする問題を解消
   * `browser.ctrlTab.previews`が`true`の時でもCtrlキーの長押しなどの操作を受け付けるようにした
   * Ctrl-Shift-PageUp/PageDownでタブを移動した後にツリー構造がおかしくなる事があったのを修正
   * タブのフォーカス移動がツールボックス内のメニュー項目の表示・非表示の切り替えを伴う場合に、タブのフォーカス切り替えでタブバーが自動的に折りたたまれてしまっていたのを修正
 - 0.16.2015122501
   * Firefox 38で初期化に失敗する問題を修正（後退バグ）
   * HTML5 Videoのフルスクリーン表示時に、ピン留めされたタブがあると画面上にゴミが残る問題を修正
   * Firefox 38において、フルスクリーン表示の切り替え後の状態を正しく認識できるよう修正
   * タブバーが縮んだ状態から自動で広げられた時にスクロール位置をリセットしないようにした
 - 0.16.2015113001
   * Speed Dialなどいくつかのアドオンとの併用時に新規タブを開けなくなる問題を修正
   * たたまれたタブバーのスプリッタ上のつまみをクリックした時に、タブバーが展開されなくなっていたのを修正（後退バグ）
   * ブックマーク項目の「新しいフォルダ」や「ブックマークのプロパティ」などが機能しなくなっていたのを修正（後退バグ）
   * タブバーの内容をスクロールさせた時にタブバーが上下にがたつく問題を修正
   * タブバーを自動的に隠す機能について、開発ツール上でポインタがタブバーに近づいた時もタブバーを表示するようにした
   * タブのコンテキストメニューにおいて「タブバーを自動的に隠す」機能の有効無効を切り替えるメニュー項目のラベルを「自動的に隠す」「自動的に縮める」の各モードに合わせて変えるようにした
   * 親タブを閉じたときに最初の子タブを次の親に昇格させる挙動について、閉じられたタブと同階層のタブが無い場合はすべての子タブを閉じられたタブの階層に昇格させる機能を任意に無効化するための隠し設定 `extensions.treestyletab.closeParentBehavior.promoteAllChildrenWhenParentIsLastChild` を追加した
   * タブを並べ替えた後の並び順をより正しく復元するようにした
   * Ctrl-Shift-PageUp/PageDownでのタブの移動でツリーが壊れることがあったのを修正
   * スプリッタのドラッグ操作でタブバーの幅を広げる際に、ウィンドウ幅の半分を上限とするようにした
 - 0.16.2015111001
   * 閉じたウィンドウのメモリがいつまでも解放されない問題を修正（イベントリスナの解除し忘れをなくした）
   * ピン留めされたタブの更新通知が正しく表示されなくなっていたのを修正
   * ツリーをブックマークフォルダとして保存する機能およびブックマークフォルダのプロパティ編集が動作しなくなっていたのを修正
   * タブのクローズボックスのアイコンの高さを変更しないようにした
   * OS Xにおいてナビゲーションツールバーが正しくウィンドウのボタンの下に表示されるように修正
 - 0.16.2015110801
   * メニューバーを常時表示する設定の時はシステムのツールバーを非表示にするようにした（そうしないとメニューバーの余白のドラッグ操作が機能しないため）
   * `GM_openInTab()`で開かれたタブを設定に従って子タブの一覧の最初の位置に挿入するように修正（後退バグ）
   * コンテキストメニューからの検索が動作しなくなっていたのを修正（後退バグ）
 - 0.16.2015110701
   * `TreeStyleTabService.getLastDescendantTab()`が常に正しい値を返すように修正
   * 「ソースを表示」で開かれるタブを現在のタブの子にするようにした
   * ソーシャルAPIによるサイドバーの位置やサイズが変化した時に、右側に置かれたタブバーの表示が追従しない問題を修正
   * ウィンドウがフォーカスされた時やサイドバーパネルを切り替えた時にタブバーの表示を無駄に更新しないようにした
   * OS X上でタブバーにスクロールバーが表示されている時にタブバーの幅が異常に狭くなる問題を修正
   * ツールバーカスタマイズの終了後に意図せずタイトルバーが非表示になってしまう問題を修正
   * Unified Sidebarのような、タブバーの表示を変更する必要があるアドオン向けに、新しい独自DOMイベント `nsDOMTreeStyleTabTabbarRendered` を発行するようにした
   * タブのドラッグ＆ドロップ後やFireGesturesのジェスチャでタブを閉じた後などにタブバーが自動で隠れない問題を修正
   * 設定ダイアログから「タブバーを自動で隠す」の設定を変更した時、現在の状態に適した設定のみを反映するようにした
   * 英語ロケールで`Leftside`および`Rightside`と書いていた箇所を`Left`および`Right`のみに改めた
   * e10s有効時にWeb検索バーやコンテキストメニューからのWeb検索が動作しなくなる問題を修正
   * HTML5のフルスクリーン表示を終了した後にタブバーを正しい位置に表示するように修正
   * HTML5のフルスクリーン表示においてタブバー関連の要素を完全に非表示にするようにした
   * Greasemonkeyの`GM_openInTabs()`で開かれたタブが子タブにならなくなっていたのを修正
   * デバッグメッセージの出力を制御する設定 `extensions.treestyletab.debug.*` を導入した
   * ピン留めされたタブに重ねて表示される音量アイコンの表示崩れを修正
   * [ECMAScript 6の`const`の仕様の反映](https://bugzilla.mozilla.org/show_bug.cgi?id=1202902)に伴い、Firefoxのソース中で`const`で定義されたオブジェクトへの参照に起因するエラーの回避のため、`eval()`による関数の書き換えを減らした
   * タブを並べ替えた後の並び順をより正しく復元するようにした
   * 動画のフルスクリーン表示時やタブバーが折りたたまれた時に、ピン留めされたタブに起因するグレーの矩形を表示しないようにした
   * タブバーの大きさが過度に頻繁に更新されないようにした
     （[Unified Sidebar](https://addons.mozilla.org/firefox/addon/unified-sidebar/)との併用時の動作を改善）
   * Linuxにおいて、縦置きされたタブバー内の「すべてのタブ」ボタンのアイコンを正しく表示するようにした
   * 意図せずツリー構造が壊れてしまう問題のデバッグ用に、各タブに保存されたツリー構造の情報を出力する内部的なメソッド `gBrowser.treeStyleTab.dumpTreeInformation()` を導入した
 - 0.15.20150902901
   * Firefox 40以降での仕様変更に伴う多数の不具合を修正
     ([Xidorn Quan氏のパッチ](https://github.com/piroor/treestyletab/pull/925)を含む。多謝！)
   * Firefox 31のサポートを終了
   * タブバーの幅・高さと位置の固定を制御する設定UIを再導入した。
     設定ダイアログでタブバーの幅・高さを変更した場合、既存のすべてのウィンドウのタブバーの幅・高さがリセットされます。
   * 2回目以降のツールバーカスタマイズでタブバーの表示が壊れる問題を修正
   * "Plain"スキンが選択されているときに現在のタブの色が強調されなくなっていたのを修正
   * タブバーを自動で隠す機能について、タブのプロセス分離の状態が変更された後もマウス関連のイベントを正しく拾うように修正
 - 0.15.2015030601
   * タブバーの幅、位置、「自動で隠す」の状態をウィンドウごとに保存するようにした
   * [Duplicate in Tab Context Menu addon](https://addons.mozilla.org/firefox/duplicate-in-tab-context-menu/)との互換性を向上
   * ColorfulTabsとの互換性を向上（タブをクリックした時に必ずタブバーがスクロールしてしまう不具合を修正）
   * `String.prototype.quote()`を使わないようにした
   * JavaScript 1.7のletブロックを使わないようにした
   * Firefox 36以降で廃止されたnsIPopupBoxObjectインターフェースを使わないようにした
   * Firefox 39以降で、サイドバーの表示状態が変わったあとにタブバーの表示位置を更新するようにした
   * 他のブラウザ用その上に被さらないように、縦置きタブバーにおけるタブのz-indexをリセットするようにした
   * Firefox 36以降においてリンクから子タブを開く操作が正しく動作するように修正
   * Firefox 36以降においてWeb検索バーから子タブを開く操作が正しく動作するように修正
   * E10Sが有効な時に、スクリプトによって複数の子タブが開かれた際のツリー構造をより正しく認識するようにした
   * Firefox Helloのチャットボックスがタブの下に潜り込まないようにした
   * タブバーを自動的に隠す機能について、完全にタブバーが隠れた後に表示されるプレースホルダー上でのポインタの移動を検知できなくなっていたのを修正
 - 0.15.2014120101
   * マルチプロセスモード（E10S）において、`target="_blank"`の指定があるリンクを子タブとして正しく開けるようにした
     （[bugzilla.mozilla.orgの関連バグ](https://bugzilla.mozilla.org/show_bug.cgi?id=1098688)）
   * フルスクリーンモードを終了した後にタブバーが再表示されない問題を修正
     [(by Xinkai. Thanks!)](https://github.com/piroor/treestyletab/pull/790)
   * Firefox 35以前のバージョンにおいて、タブバーの表示・非表示をマウスポインタの位置に応じて自動的に変更する機能が正しく動作しなくなっていたのを修正
 - 0.15.2014111301
   * Firefox 30およびそれ以前のバージョンへの対応を終了
   * マルチプロセスモード（E10S）に対応
     * マルチプロセスのウィンドウでリンクから子タブを正しく開けるようにした[(by Nephyrin. Thanks a lot!)](https://github.com/piroor/treestyletab/pull/760)
   * ダミーのタブを開かない設定の時に、複数のツリーを含むブックマークフォルダをタブで開いた場合にツリー構造を正しく復元するようにした
   * 閉じたタブを開き直したときの位置がおかしくなる問題を修正
   * Nightly 33.0a1において `dom.compartment_per_addon`=`true` に設定した場合でも動作するように暫定的に対処
   * ツールバーカスタマイズを終えた後にタブバーの外観が壊れていたのを修正
   * ブックマークのプロパティのダイアログにおいて、選択した親のタブの情報が保存されていなかったのを修正
   * fr-FR ロケール更新（by AxlMun. Thanks!）
 - 0.14.2014051101
   * `browser.fullscreen.autohide`が`false`に設定されている場合には、フルスクリーンモードでツールバーを隠さないようにした
 - 0.14.2014051001
   * OS Xにおいて、ナビゲーションツールバーと、タイトルバー内のプライベートブラウジングアイコンを正しく表示するようにした（後退バグの修正）
   * タブバーを自動的に隠すモードにおいて、白い背景のWebサイトで背景色の変化が目立たないようにした
   * チェコ語ロケール追加（[by Vlastimil Ovčáčík. Thanks!](https://github.com/piroor/treestyletab/pull/714)）
 - 0.14.2014050601
   * Tabs on Bottomがインストールされている場合はタイトルバーを非表示にできるようにした
   * [Tile Tabs](https://addons.mozilla.org/firefox/addon/tile-tabs/)から開くタブを現在のタブと同階層で開くようにした
 - 0.14.2014050102
   * タブを自動的に縮めるモードにおいて、Unified Sidebarと協調して動作するようにした（後退バグの修正）
 - 0.14.2014050101
   * Nightly 32.0a1に対応
   * DOMフルスクリーンモードでピン留めされたタブが表示されないようにした
 - 0.14.2014043001
   * No Script 2.6.8.20と衝突しないようにした
 - 0.14.2014042701
   * Nightly 31.0a1に対応
   * チェックボックス「新しいツリーが作られた時は、自動的に他のツリーを折りたたむ」を「タブを切り替えた時は、フォーカスされたタブのツリーを自動的に展開して、他のツリーを折りたたむ」から独立させた（設定の意味的に、その挙動まで一緒に変わってしまうこは意図されないため）
   * [Classic Theme Restorer](https://addons.mozilla.org/firefox/addon/classicthemerestorer/)との互換性を改善（タイトルバーへのUI要素の描画を有効化するようにした）
   * Firefox 28以降で起動時にツリーの状態を正しく復元するようにした（後退バグ）
   * コンテキストメニューの「……を検索」からタブを開いたとき、選択範囲に改行が含まれていたり選択範囲が長すぎたりすると、タブが現在のタブの子になっていなかったのを修正
   * タブを複製した後に再起動した際にツリーが壊れる問題を修正
   * ロシア語ロケール更新（[by Infocatcher. Thanks!](https://github.com/piroor/treestyletab/pull/672)）
 - 0.14.2014020901
   * タブバーを自動的に隠す状態の時、タブバーが表示されたら常に現在のタブの位置までタブバーをスクロールするようにした
   * ピン留めされたタブの周囲の空き領域について、タブバー自体のドラッグ操作を受け付けるようにした
   * 縦型タブバーを伴うウィンドウではFirefoxの「ツールバーをタイトルバーに表示する」機能を常に無効化するようにした
   * タブバーを自動的に隠す状態の時、タブバーの開閉でスクロール位置が失われる問題を修正
   * OS X Lionでのフルスクリーン表示において、ナビゲーションツールバーを隠さないようにした
   * タブバーがCtrlキーの長押しで自動的に表示されている間に新しいウィンドウが開かれた場合に、タブバーが自動的に隠れないでそのままになってしまっていたのを修正
   * コンテキストメニューの「～検索」機能から開いたタブが現在のタブの子にならなくなっていたのを修正
   * メニューを持つツールバーボタン上ではタブバー自体のドラッグ操作を開始しないようにした
 - 0.14.2014013001
   * [Nav Bar on Title Bar](https://addons.mozilla.org/firefox/addon/nav-bar-on-title-bar/)との互換性を改善
   * [Tab Control](https://addons.mozilla.org/firefox/addon/tab-control/)との互換性を改善
   * 「ブックマークグループを開く時に現在のタブを置き換える」機能に関するコードを削除（古いFirefoxで既に機能が無くなっていたため）
   * タブバーの表示・非表示を切り替える公開APIが壊れていたのを修正
   * グループ化用のタブ内でのタブのツリー表示について、スクロール可能な領域が無駄に狭かったのを修正
   * ユーザがグループ化用のタブを開かない設定を選択している場合に、ブックマークフォルダをタブのツリーとして開けていなかったのを修正
   * 「Tabs on Top」機能が削除されて以降のバージョンのFirefoxでタブバーの表示が壊れていたのを修正
 - 0.14.2013112901
   * 「タブが1つだけの時にタブバーを隠す」機能を提供するアドオン（Tab Mix Plus、[Hide Tab Bar With One Tab](https://addons.mozilla.org/firefox/addon/hide-tab-bar-with-one-tab/)など）や環境（Pale Moonなど）との互換性を向上
   * [Context Search](http://www.cusser.net/extensions/contextsearch/)との互換性を向上（検索結果を子タブとして開くようにした）
   * タブバーの幅・位置が固定されている時は、ポインタがタブバー上に乗ったらすぐにタブバーを展開するようにした。
   * 「未整理のブックマーク」フォルダにあるブックマーク項目に対して、ブックマーク同士の関連性を変更するためのUIを無効化するようにした（当該フォルダのブックマークすべてを1つのツリーとして開く場面は通常あり得ないため）
   * ピン留めされた未読のタブをツリー型タブ自身で強調表示するようにした
   * タブバーを自動的に隠すモードで、タブを開いたり閉じたりした時にタブバーを一時的に展開する設定を有効にしている時に、タブバーが自動的に隠れなくなってしまっていたのを修正
   * 1つのブックマークフォルダに大量のブックマーク項目が存在している時の、ブックマーク同士の関連性を変更するためのUIの初期化処理について、よりフリーズしにくいように改善したつもり
   * タブバーを自動的にたたむモードで、終了時と次回起動時はに正しくタブバーの大きさを記憶・復元しておくようにした。
   * DOMフルスクリーンからF11キーの押下で抜けた時に、タブバーを正しく再表示するようにした
   * タブバーのスプリッタのつまみをクリックした時に、タブバーを正しく開閉するよう修正
   * タブバーのスプリッタをドラッグした時に、タブバーを正しく開閉するよう修正
   * Tab Mix Plusがある時のタブの背景色が意図せず無効化されてしまっていたのを修正
   * ピン留めされたタブがある時に「すべてのタブの一覧」メニューの内容が正しく表示されるよう修正 ([by Infocatcher.](https://github.com/piroor/treestyletab/pull/606) Thanks!)
   * Australisとの互換性を向上
   * [Greasemonkey](https://addons.mozilla.org/firefox/addon/greasemonkey/) 1.11以降でスクリプトから開かれたタブが子タブにならなくなっていたのを修正
   * フランス語ロケール更新（[by AxlMun. Thanks!](https://github.com/piroor/treestyletab/pull/595)）
 - 0.14.2013100901
   * ブラウズ領域周辺にUI要素が追加された時に、自動的にタブバーの位置やサイズを更新するようにした
   * マルチディスプレイ環境において、タブのツリーに対するツールチップが別の画面に表示されてしまうことがあったのを修正
   * 自動的に折りたたむ（隠す）状態のタブバーがCtrlキーの長押しで表示されている時に、Ctrl-Tなどのキーボードショートカットでタブバーが折りたたまれ（隠され）てしまわないようにした
   * 閉じられようとしているタブにフォーカスしないようにした（[issue #569](https://github.com/piroor/treestyletab/issues/569)などの、閉じられようとしているタブからのTabSelectイベントに起因する問題を解消）
   * DOMフルスクリーンモード（YouTubeなどで使われる）において、Firefox本体の機能と同様に、タブバーの自動表示機能を無効化するようにした
   * 縦型タブバーを使用しているときはブラウザのツールバーを隠さないようにした（Webアプリケーションなどのタブに対して明示的にツールバーを隠す場面を除く）
   * Tab Mix Plusとの併用時にタブの下に余計な線が描画される問題を修正（[by wanabe. Thanks!](https://github.com/piroor/treestyletab/pull/556)）
   * 「何回戻れる？」との互換性を向上（[by wanabe. Thanks!](https://github.com/piroor/treestyletab/pull/554)）
   * [Sidebars List](https://addons.mozilla.org/firefox/addon/sidebars-list/)との互換性を向上（[by Infocatcher. Thanks!](https://github.com/piroor/treestyletab/pull/571)）
 - 0.14.2013082301
   * Firefox 23以降で初期化に失敗する問題を修正（前バージョンでの後退バグ）
   * ロシア語ロケール更新（[by Infocatcher. Thanks!](https://github.com/piroor/treestyletab/pull/542)）
 - 0.14.2013082201
   * Firefox 25に対応
   * 閉じたタブを開き直した時に、そのタブが親タブでなかった場合はツリー構造が復元されなくなっていたのを修正（0.14.2013052901での後退バグ）
   * [DragIt](https://addons.mozilla.org/firefox/addon/dragit-formerly-drag-de-go/)から開いたタブを現在のタブの子にするようにした
   * バックグラウンドのタブに切り替えた時に、タブの操作中にもかかわらずタブバーが自動的に折りたたまれる事があったのを修正
   * Firefox自身の「右のタブを閉じる」機能について、メニュー項目のラベルを縦型タブバーでは「下のタブを閉じる」に変えるようにした
   * 子タブをドラッグしてひとつ上のレベルに移動する操作でツリー構造が壊れる場合があったのを修正
   * Webページ中のスクリプトから開かれたタブを子タブとして開く機能について、より正しく動作するようにした
   * Firefox 22でグループ化用のダミーのタブのアイコンが正しく表示されなくなっていたのを修正
   * グループ化用のダミーのタブでない物をダミーのタブと誤認する場合があったのを修正（[by Infocatcher. Thanks!](https://github.com/piroor/treestyletab/pull/518)）
   * Firefox 23以降で、Firefox 22以前でのみ有効だった「タブが1つだけの時にタブバーを隠す設定」を挙動に反映しないようにした
   * ツールバーの表示・非表示を切り替えた後などにタブバーの見た目が壊れることがあったのを修正
   * [bug489729 (Disable detach and tear off tab)](https://addons.mozilla.org/firefox/addon/bug489729-disable-detach-and-t/)と併用できるようにした
   * グループ化用のダミーのタブについて一時的か永続的かの設定を持たせるようにし、不要になった一時的なダミーのタブのみを自動的に閉じるようにした（自動的に開かれた場合は一時的、手動で開かれた場合は永続的として扱います。ブックマークから開かれた物を永続的なタブにする場合は `extensions.treestyletab.openGroupBookmark.temporaryGroup` を、選択されたタブから新しくツリーを作成する場面で開かれた物を永続的なタブにする場合は `extensions.treestyletab.createSubtree.underParent.temporaryGroup` をそれぞれ `false` に変更して下さい）
   * タブバーのスプリッタ上のつまみをクリックした時に、タブバーの表示・非表示が更新されていなかったのを修正
   * 1つのフォルダの中に非常に多くのブックマークがある時に、ブックマークの編集画面がフリーズしてしまう問題に対処
   * ロシア語ロケール更新（[by Infocatcher. Thanks!](https://github.com/piroor/treestyletab/pull/534)）
 - 0.14.2013052901
   * ピン留めされたタブの外観をより綺麗に調整するようにした
   * 他のグループのタブがある時に、変な位置でタブの間にマージンが適用されてしまう問題について、まだ問題が修正されていなかったケースがあったのを改善（by Drugoy. Thanks!）
   * アドオンバーやツールバー等の表示・非表示が切り替わった際にタブバーの表示が更新されなくなっていたのを修正（0.14.2013040601での後退バグ）
   * [Gmail Panel](https://addons.mozilla.org/firefox/addon/gmail-panel/)などから開かれたタブが意図せず現在のタブの子タブになってしまう問題を修正
   * [セッション保存APIの仕様変更](http://dutherenverseauborddelatable.wordpress.com/2013/05/23/add-on-breakage-continued-list-of-add-ons-that-will-probably-be-affected/)に追従
 - 0.14.2013040601
   * 現在のタブから開かれる子タブの位置を制御する隠し設定 `extensions.treestyletab.autoAttach.fromCurrent` を追加
   * Firefox 20でmoveTabForward/moveTabBackwardでのタブの移動が正しく動作しなくなっていたのを修正
   * 他のグループのタブがある時に、変な位置でタブの間にマージンが適用されてしまう問題を修正
   * ツリーを折りたたむ操作をしても孫階層のツリーが折りたたまれない問題を修正
   * ブラウズ領域の下のコンテナだけでなくツールバーの動的な変更も監視するようにした
   * アドオンが無効化または削除されたときにユーザの設定値を正しく復元するようにした (by saneyuki_s)
   * 他のグループのタブがある時に、タブのドロップ位置がおかしくなる問題を修正
   * Firefox 19以降でツリーをウィンドウ外にドラッグして新しいウィンドウに移動する時に、他のタブが追従しない問題を修正
   * タブのドラッグ中はドロップ位置が分かりやすいように、常にドラッグ中のタブを半透明で表示するようにした
   * タブを他のタブ自身にドロップするときのドロップ操作の反応領域を拡大した（これにより、タブを他のタブにドロップして子タブにするなどの操作をやりやすくなっているはず）
   * jarファイルを含めない形のパッケージングに変更
 - 0.14.2012122901
   * Nightly 20.0a1に対応（MutationObserverの仕様変更に追従）
   * タブ以外のオブジェクトをタブバー上にドラッグしたときにエラーにならないようにした
 - 0.14.2012121401
   * [Linky](https://addons.mozilla.org/firefox/addon/425)で、ダイアログ経由で開かれたタブを現在のタブの子にするようにした
   * タブバーの最小の幅を定義し、毎回起動時にタブバーがそれよりも細くなっていたら最小幅まで戻すようにした（タブバーの方がタブよりも細くなってしまう製でタブバーの幅を広げられなくなる問題への対策）
   * Webページ内にプラグインの領域が含まれている時に、タブバーを自動でたたむ・隠す機能が正しく機能していなかったのを修正
   * 縦置きしたタブバーでのタブのドラッグ＆ドロップ操作を修正（タブを他のタブにドロップしにくかった問題を修正、ピン留めされたタブのアニメーション効果を修正、など）
   * テーマ「なし」の時に、ピン留めされたタブがあり且つタブバー内にスクロールバーが表示されていると、タブバーの左に余計な余白が表示されていたのを修正
   * タブが1つしか開かれていない時にタブバーが隠されなくなっていたのを修正
   * [QuickDrag](https://addons.mozilla.org/firefox/addon/6912)用の動的パッチを修正
   * タブバーが自動的にで隠された時は、タブのインデント幅を0にしないようにした
   * CPU使用率が高くならないよう、mouseleaveイベントを監視しないようにした
   * 設定 `extensions.treestyletab.animation.enabled` の役割を `browser.tabs.animate` に統合
 - 0.14.2012111201
   * 他のコンピュータのタブを「about:sync」タブの子タブとして開く処理が最近のNightlyで機能しなくなっていたのを修正
   * 設定ダイアログを開くとすべてのアニメーション効果が意図せず停止してしまう問題を修正
 - 0.14.2012111001
   * 縦型タブバーでのタブのドラッグ＆ドロップ時にアニメーション効果を正しく適用するようにした（Firefox 17以降）
   * 深くネストしたツリーが折りたたまれたり展開されたりした際に、見えているタブのネストの深さに基づいてインデントの深さを自動的に調整するようにした（この挙動は隠し設定 extensions.treestyletab.indent.autoShrink.onlyForVisible によって無効化できます）
   * タブグループを変更した時にタブのインデントの深さが更新されていなかったのを修正
   * 縦型タブバーと横型タブバーで異なるインデントの深さを設定できるようにした（隠し設定 extensions.treestyletab.indent.horizontal、extensions.treestyletab.indent.vertical、extensions.treestyletab.indent.min.horizontal、extensions.treestyletab.indent.min.verticalで設定できます）
   * スプリッタをダブルクリックした時にタブバーのサイズを既定の状態に戻す際、既定のサイズを設定できるようにした（隠し設定 extensions.treestyletab.tabbar.width.default、extensions.treestyletab.tabbar.height.default、extensions.treestyletab.tabbar.shrunkenWidth.defaultで設定できます）
   * 縦型タブバーでのタブのドラッグ＆ドロップ時にドロップ位置を示すマーカーが表示されなくなる場合があったのを修正
   * 「更新」ボタンをクリックしただけでタブが複製されてしまう不具合を修正
   * 「戻る」「進む」ボタンのメニュー項目からタブを複製した場合に、子タブとして複製するようにした
   * ツールバーの表示・非表示を切り替えた時に現在のタブ以外のタブのクローズボックスが非表示になる問題を修正
   * 複数ウィンドウを開いている環境でタブのアニメーション効果が機能しなくなる場合があったのを修正（したつもり）
   * 内部のコードを整理
 - 0.14.2012081101
   * アニメーション効果を正しく適用するようにした（タブや設定ダイアログのアニメーション効果が意図せず停止したままになってしまう問題を修正）
 - 0.14.2012080901
   * 新しいタブが開かれた後も見えないままになる事があったのを修正（アニメーション効果が意図せず停止してしまう問題を修正）
   * WindowsおよびLinuxにおいて、「Metal」テーマの外観が壊れていたのを修正
   * 孫やひ孫にあたるタブが選択されている状態でツリー全体を折りたたんだ時にツリーの折りたたみの状態が壊れる問題を修正
   * ブックマークサイドバーにドロップされたタブがブックマークされない問題を修正
   * 子孫のタブを収集する時についても、ツリーの循環参照のチェックを行うようにした
 - 0.14.2012080601
   * Firefox 16対応
   * 隠し設定 `extensions.treestyletab.autoExpand.intelligently` が機能しない問題を修正（当該設定を  `false`  にしていた場合は、ツリーにフォーカスしてそれが自動展開される際に、他のツリーを自動的には折りたたまなくなります。）
   * ツールバーカスタマイズの前後でツリーの開閉の状態が失われるようになってしまっていたのを修正
   * タブのツリーをブックマークへドラッグ＆ドロップした時に、入れ子になったブックマークフォルダのツリーを自動的に作成するようにした
   * ブックマークフォルダをタブバーの任意の位置にドロップした際に、その位置にタブのツリーを開くようにした
   * ブラウズ領域の下の部分の高さが増減した際に、縦型タブバーの表示が更新されない場合があった問題に対処
   * ピン留めされたタブを他の最初のピン留めされたタブの隣にドロップしようとした時に、何も起こらない場合があったのを修正
   * ツリーを折りたたんだままの状態で親にあたるタブだけをピン留めした場合に、折りたたまれていた子孫のタブが消えてしまう問題を修正
   * ドラッグ＆ドロップで最後の子タブを1階層上のツリーに紐付け直した時に、ツリーが壊れることがあった問題を修正
   * ツリー型タブの内部的なキャッシュ機構が壊れるために、セッションの復元後にタブのツリーが壊れやすくなっていたのを修正
   * 起動時にタブのツリー構造だけを先行して復元する機能が、正しく動かなくなっていたのを修正
   * タブの親子関係が意図せず循環参照になってしまった事により引き起こされるフリーズを軽減
   * 「タブを下に表示」の状態でのツールボックスにおいて、ツールボックスとコンテンツ領域の間に枠線が表示されていなかったのを修正
   * Linuxにおいて、画面外に新しいタブが開かれた時の通知を正しく表示するように修正
   * 「Metal」テーマをFirefox 14以降のバージョン向けに修正
 - 0.14.2012050301
   * タブのツリー内での階層を1段階上げる操作として、子タブを親タブのすぐ下にドロップするという操作を受け付けるようにした
   * UbuntuのAmbienceテーマなど向けに、「Mixed」と「Flat」のそれぞれのテーマにおけるタブの背景色を変更した
   * 「新しいタブ」ボタンからタブを開く処理について、挙動を正しく制御するようにした
   * 「新しいタブ」ボタンを中クリックした時の挙動について、Firefox自身または他のアドオンによって定義された挙動を優先するようにした
   * タブバーを自動的に縮める設定の時に「NS_ERROR_XPC_BAD_OP_ON_WN_PROTO」エラーが発生していたのを修正
   * 「Sidebar」テーマにおいてピン留めされたタブの表示が壊れていたのを修正
   * Mac OS X上の「Metal」テーマにおいてピン留めされたタブの表示が壊れていたのを修正
   * 縦型のタブバーの幅がピン留めされたタブの幅より小さくなっている時に、ピン留めされたタブの表示がおかしくなっていたのを修正
   * タブをドラッグ＆ドロップした時に、ドロップ先のタブに子タブが無い場合の処理結果がおかしかったのを修正
   * 縦型のタブバーを使用している時に「タブを上部に表示（Tabs on Top）」機能が無効になっていなかったのを修正
   * アンインストール時に、元の「タブを上部に表示（Tabs on Top）」の状態を復元するようにした
   * 「タブを上部に表示（Tabs on Top）」の状態が起動時に毎回リセットされてしまう問題を修正
   * リンクのhover時などに表示されるステータスパネルの最大の表示幅を大きくした（[bug 632634](https://bugzilla.mozilla.org/show_bug.cgi?id=632634)を参照）
   * ツリー型タブによってタブのツールチップが改変されていない場合であっても、ツリーの内容を表示する高機能なツールチップが表示されてしまっていたのを修正
   * ツリーの開閉が設定により無効化されている場合、意図的な操作かどうかにかかわらずタブを非表示にしないようにした
   * ポインタがタブバーから離れた後もツリー開閉用のつまみが「hover」の状態になってしまっていたのを修正
   * 横型のタブバーにおいて、ツリー開閉用のつまみをタブのアイコンの上に重ねて表示しないようにした
   * [Hide Caption Titlebar Plus](https://addons.mozilla.org/firefox/addon/hide-caption-titlebar-plus-sma/)によるメニューバーおよびタブバーのフロート表示と併用できるようにした
 - 0.14.2012021101
   * 横置きされたタブバーにおいて、ツリーの折りたたみのつまみの周辺の外観がおかしかったのを修正（2つ前のバージョンでの後退バグ）
   * 起動時に行う設定内容の移行処理に失敗する事があったのを修正
   * ロシア語ロケール更新（by Infocatcher）
 - 0.14.2012021001
   * 折りたたまれたツリーの上でしばらくCtrlキーを押しっぱなしにしていた場合、「タブを切り替えた時は、フォーカスされたタブのツリーを自動的に展開して、他のツリーを折りたたむ」のチェックが外れている場合であってもツリーを自動的に展開するようにした（この挙動は隠し設定 "extensions.treestyletab.autoExpandSubtreeOnSelect.whileFocusMovingByShortcut" により無効化できます）
   * ユーザの設定ツリーのつまみを非表示にしている場合でもつまみが表示されたままになっていたのを修正（1つ前のバージョンでの後退バグ）
   * Tab Mix Plusと併用した場合に終了時のセッション保存に失敗する問題を修正（1つ前のバージョンでの後退バグ）
   * 横置きされたタブバーにおいて、折りたたまれたタブのアイコンが表示されたままになっていたのを修正（1つ前のバージョンでの後退バグ）
   * 折りたたまれたツリーの中のタブが直接選択された時に、「タブを切り替えた時は、フォーカスされたタブのツリーを自動的に展開して、他のツリーを折りたたむ」のチェックが外れている場合であってもこの機能が発動してしまっていたのを修正
   * 最後の親タブにリンクをドロップした時に、ユーザの設定でツリーの最後の子として新しいタブを開くようになっている場合でも、タブが最初の子として開かれてしまっていたのを修正
 - 0.14.2012020901
   * Nightly 13.0a1対応
   * 他のタブ関係のアドオンとの互換性を向上。&lt;tab/&gt;に独自のバインディングを適用しないようになりました。
   * 最近のNightlyで、あるウィンドウ内の最後のツリーを別のウィンドウにドラッグ＆ドロップで移動した場合に、タブバーの外観や挙動が全面的に壊れていたのを修正
   * Firefoxのウィンドウの外にツリーがドロップされた時に、タブが新しいウィンドウに移動せずに複製されてしまっていたのを修正
   * タブバーを自動で（縮めるのではなく）隠す機能が有効になっている時に、マウスのポインタがウィンドウの端ではなく本来のタブバーの位置に近づいただけでタブバーが表示されてしまっていたのを修正
   * 最初のタブが非表示になっている時に、タブバーの自動スクロールが機能しない問題を修正
   * タブバーの位置が上で、且つ位置と大きさが固定されている時に、ポップアップウィンドウがWebページによって開かれると「タブを上部に表示」機能が意図せず有効化されてしまっていたのを修正
   * Firebugのパネルの表示を切り替えた時など、いくつかの場合でタブバーの表示サイズが正しく更新されない場合があったのを修正
   * 「このツリーをブックマーク」機能がFirefox 9移行で正しく働いていなかったのを修正
   * 閉じられたツリーを復元するかどうかの確認が翻訳済みのバージョンにおいて機能していなかったのを修正（問題があったのはda-DK, de-DE, es-ES, fr-FR, it-IT, pl, ru-RU, sv-SE, zh-CNおよびzh-TWのロケールを使用していた場合です）
   * Tab Mix Plusとサードパーティ製のテーマを併用した時に、横置きされたタブバーにおいて折りたたまれたはずのタブバーの幅が異常に大きくなってしまっていたのを修正
   * ロシア語ロケール更新（by Infocatcher）
 - 0.14.2012012901
   * 手動で展開されたツリーはタブのフォーカス移動によって自動的に折りたたまれないようにした（Windows Explorerと同じ挙動にした）
   * タブバーがマウス操作によって自動的に表示された場合、キーボード操作ではタブバーを自動的には縮めない（隠さない）ようにした
   * 閉じられたツリーの中のタブが復元された場合、ツリー全体を復元するかどうかを通知ポップアップ（Doorhangar）で訊ねるようにした
   * Shiftキーを押下している間はタブバーを自動的に縮める（または隠す）機能を一時的に無効化するようにした
   * グループ化用のタブをブックマークした場合、ブックマークフォルダとして保存するようにした
   * 縦型タブバーの現在のスクロール範囲の外で新しいタブが開かれた場合に、アニメーション効果で通知するようにした
   * タブバーの内容が水平方向に溢れていた場合に、縦置きされたタブバーの内容が溢れているかどうかの判定がおかしくなっていたのを修正
   * Ctrl-Shift-「`」およびCtrl-Shift-「~」によるタブグループの切り替えでツリー構造が破壊される問題を修正
   * 2つ目以降のウィンドウにおいて、セッション復元時のツリー構造の復元に時間がかかる状態のままだったのを修正
   * 自動的に縮められたタブバーの自動展開に関するおかしな挙動を修正
   * 現在のタブの内容が&lt;embed&gt;を含んでいる時に、タブバー自体のドラッグ＆ドロップが機能しなくなっていたのを修正
   * アイコン化されていないピン留めされたタブはハイライト表示しないようにした
   * グループ化用のタブにおいてF2キーが動作しなくなっていたのを修正（前のバージョンでの後退バグ）
   * グループ化用のタブのタイトルを変更した場合に、結果がセッションに保存されなくなっていたのを修正（前のバージョンでの後退バグ）
   * Tab Mix Plusと組み合わせた場合に、普通のタブが無い状態で2つ目以降のピン留めされたタブが復元されない問題を修正
   * ブラウザ全体が遅くなっている時、手動で行ったタブバーのスクロール操作がツリー型タブ自身のアニメーション効果によってキャンセルされてしまう事があったのを修正
   * 新しいタブを開いた後にタブバーのスクロール位置が意図せず飛んでしまう問題を修正
   * ウィンドウが閉じられる間にAPIが呼ばれた場合にツリー型タブ全体の動作がおかしくなる問題について改善
   * 新しいタブを開いた瞬間に（情報化タブなどのアドオンを併用していて）多数の処理が走った場合に、新しく開かれたタブの位置までタブバーがスクロールされない問題を修正
   * グループ化用のタブに表示されるツリー全体の高さが小さすぎたのを修正
   * タブに表示されるカウンターの役割をタブバーの横置き・縦置きの状態の変化に応じて自動的に切り替えるようにした（横置きタブバーではそのタブ自身を含むツリー内のすべてのタブの数を表示し、縦置きタブバーではそのタブ自身を含まないツリー内の折りたたまれた子孫タブの数だけを表示）。この挙動は隠し設定 `extensions.treestyletab.counter.role.horizontal` および `extensions.treestyletab.counter.role.vertical` で変更できます。[詳細は#197での議論を参照して下さい。](https://github.com/piroor/treestyletab/issues/197)
   * Nightly 12.0a1へ対応
   * Firefox 3.6への対応を終了
 - 0.13.2011121501
   * Tab Mix Plusがインストールされていると、TMP独自のセッション復元機能が無効化されている場合であっても高速なツリーの復元が機能しなくなっていたのを修正
   * 既存のツリーの中に移動されたタブがツリーに自動的に組み込まれなくなっていたのを修正（0.13.2011121401でのリグレッション。TMP等で新しいタブを開く位置を変更していた場合に、ツリーが壊れる恐れがあった.）
 - 0.13.2011121401
   * Firefoxの起動時に前回終了時のツリー構造を高速に復元できるようになった。（正しく動作しない場合は、about:configを開いて `extensions.treestyletab.restoreTree.level` を `0` に設定すると従来通りの動作に戻ります）
   * グループ化のためのダミーのタブの内容として、そのツリーに属しているタブをリンク状に表示するようにした（左クリックでそのタブに切り替え、中クリックでそのタブを閉じる）
   * タブ自体がフォーカスされている時、矢印キーの動作をWindows Explorerのフォルダペインでの挙動に合わせた（「→」キーでツリーを開くか最初の子タブにフォーカス、「←」キーで親タブにフォーカスするかツリーをたたむ）（※注意：マウスでのクリック操作でタブにフォーカスしたい場合、userChrome.cssに  `.tabbrowser-tab { -moz-user-focus: normal !important; }`  という風な記述を追加する必要があります)
   * 「タブバーを自動的に隠す」機能について、コンテンツ領域がPDFやFlashなどのプラグインによって秒がされている場合であってもタブバーが自動的に隠れるようにした（従来は、このような場面ではタブバーが表示されたままになってしまっていた）。（この機能は不可視のポップアップを開く事により実現しているため、副作用として何らかのトラブルが起こり得ます。正しく動作しない場合は、about:configを開いて `extensions.treestyletab.tabbar.autoHide.contentAreaScreen.enabled` を `false` に設定すると従来通りの動作に戻ります。）
   * ツリーをまとめて閉じた後にその中のタブを1つ復元した場合に、タブの復元完了を待たずにすぐにツリーの他のタブを復元するかどうか確認するようにした
   * ツリーの高機能なツールチップにおいて、中クリックでタブを閉じられるようにした
   * Firefoxのウィンドウをフルスクリーン表示または最大化した状態で終了した時に、次回起動時にタブバーの幅が105ピクセル程度の細い幅になってしまう問題を修正
   * Nightly 11.0a1において「タブを一覧表示します」ボタンのポップアップメニューの項目がインデント表示されない問題を修正
   * Panoramaでバックグラウンドのタブグループに属しているツリーの開閉の状態について、フォアグラウンドのグループのツリーの開閉が影響しないようにした
   * ツリーをまとめて閉じた後にツリー全体を復元するための確認UIが機能していなかったのを修正
   * ツリーの高機能なツールチップがマルチディスプレイ環境において必ずプライマリディスプレイに表示されてしまっていたのを修正
   * 「タブバーを自動的に隠す」機能によって幅が縮められたタブバーについて、幅があまりに狭すぎるとマウスの移動でタブバーが開かれなくなっていたのを修正
   * Linux環境固有のスタイル指定が機能していなかったのを修正
   * GNOME3環境で、タブバーのスクロールバーが細い幅にならない問題に対処
   * APIの  `partTab()`  を  `detachTab()`  に名称変更した（後方互換性のため、従来の名称でも依然利用可能
 - 0.12.2011120101
   * Ctrl-Tab/Ctrl-Shift-Tabでタブのフォーカスを切り替えている時に、折りたたまれたツリーの上でCtrlキーを押したまましばらく待つとツリーを自動的に展開するようにした（待ち時間は隠し設定の `extensions.treestyletab.autoCollapseExpandSubtreeOnSelect.whileFocusMovingByShortcut.delay` で変更可能）
   * グループ化用のダミーのタブにおいて、F2キーでタイトルの編集を開始できるようにした
   * ツリーの上でのツールチップにおいて、最初は先頭のタブ10個だけについて情報を表示し、そのまましばらく待つとツリーのすべてのタブを表示するスクロール可能なツールチップに自動的に表示を切り替えるようにした（待ち時間は隠し設定の `extensions.treestyletab.tooltip.fullTooltipDelay` で変更可能）
   * タブのクローズボックスの上でのツールチップにおいて、ツリーに含まれるタブの情報も表示するようにした
   * ピン留めされたタブの計算処理を簡素化した（新しい真偽値の設定 `extensions.treestyletab.pinnedTab.faviconized` によって、ピン留めされたタブを通常のタブの大きさで表示するかアイコンだけの表示にするかを切り替えられるようにした）
   * 2011年11月30日付けのNightly 11で動かなくなっていたのを修正（「MozBeforePaint」イベントの使用をやめた）
   * ツリーのインデントの部分にタブがドロップされた時におかしな結果になっていたのを修正
   * 「自動で隠す」機能によって幅が縮められた状態のタブバーの幅をドラッグ操作で変えられなくなってしまっていたのを修正（スプリッタの上にポインタが到達する前にタブバーが展開されてしまっていた）
   * ツリーの上でのツールチップにおいて、常にツリーの内容を表示するようにした（折りたたまれたツリーでのみツリーの内容を表示する従来の挙動に戻したい場合は、隠し設定 `extensions.treestyletab.tooltip.mode` を `1` に設定する。0はツリーの内容を全く表示しない、2は常にツリーの内容を表示する。）
   * 折りたたまれたツリーに表示されるタブの数のカウンターについて、そのタブ自身も含めたそのツリーのすべてのタブの数を表示するようにした
 - 0.12.2011110101
   * ブックマークフォルダからタブを開けなくなっていたのを修正（0.12.2011102901でのリグレッション）
 - 0.12.2011103101
   * 右側にタブバーを置いている場合にピン留めされたタブの表示位置がおかしくなっていたのを修正（0.12.2011102901でのリグレッション）
   * 縦置きされたタブバーにおいて、タブの読み込み中のアイコンの表示が縦置きされたタブバー用に調整されていなかったのを修正
 - 0.12.2011102901
   * 親のタブがPanoramaの他のグループに移動された場合、子孫のタブもそのグループにまとめて移動するようにした
   * 親のタブがピン留めされた時、その子孫のタブの位置が意図せず動いてしまわないようにした
   * タブバーを自動で隠す設定の時、VertigoおよびSidebarスタイルの時は背景を明るいグレーで描画するようにした
   * Nightlyにおいて、ピン留めされたタブが1箇所に重なって配置されてしまっていたのを修正
   * Greasemonkeyスクリプトによって開かれたタブが現在のタブの子にならなくなっていたのを修正
   * Tab Utilitiesがインストールされている時に、2つ目以降のウィンドウでブックマークグループをタブで開いても開かれたタブがツリーにならない問題を修正
   * TreeStyleTabService.treeViewEnabled に何度も同じ値が設定された時に、ツリーの折りたたみ用のつまみが消えたままになってしまう問題を修正
   * [Colorful Tabs](https://addons.mozilla.org/firefox/addon/1368)用の互換性のためのコードが機能していなかったのを修正（ツリーに属するタブは親のタブと同じ色になるようになった）
   * 「新しいタブ」ボタンから開かれる子タブがユーザ設定に関わらず常に最後の子になっていたのを修正
   * 繁体中国語ロケール更新（by bootleq）
 - 0.12.2011082901
   * 註：このバージョンおよびこれ以前のバージョンは、[bug 455694](https://bugzilla.mozilla.org/show_bug.cgi?id=455694)および[bug 674925](https://bugzilla.mozilla.org/show_bug.cgi?id=674925)の影響によりFirefox 8以降には非対応です
   * タブのグループ化のためのダミーのタブについて、同階層の他のタブが無くなった時はダミーのタブを自動的に閉じるようにした
   * ピン留めされたタブのサイズを制御する隠し設定 "extensions.treestyletab.pinnedTab.width" と "extensions.treestyletab.pinnedTab.height" を追加した（幅を `-1` に設定するとピン留めされたタブがタブバーの幅一杯に広がります）
   * 上および下に置かれたタブバーのアイコンについて、折りたたみ用のつまみを表示する必要が無い時は左にスペースを空けないようにした
   * 子タブを閉じた時、他にまだ子タブがあるにもかかわらず親のタブにフォーカスが移ってしまう事があったのを修正
   * ウィンドウが最大化されている時は自動的にウィンドウの大きさを変えないようにした
   * Firefox 4以降において、コンテキストメニューの「○○で○○を検索」で開かれたタブが子タブになっていなかったのを修正
   * ドラッグ＆ドロップ中にタブバーが意図せず表示/折りたたみを繰り返してしまっていたのを修正
   * タブバーが自動的に折りたたまれたり展開されたりする時にタブバーのスクロール位置が失われてしまっていたのを修正
   * [bug 440093](https://bugzilla.mozilla.org/show_bug.cgi?id=440093)のため、最近のFirefoxではブックマークグループに関する設定で「現在のタブを置き換える」にあたる項目を表示しないようにした
   * [Snap Links Plus 2.1](http://snaplinks.mozdev.org/)と併用できるようにした
   * [Duplicate This Tab](https://addons.mozilla.org/firefox/addon/duplicate-this-tab/)で開かれたタブが現在のタブの子になるようにした
   * [InstaClick](https://addons.mozilla.org/firefox/addon/instaclick/)で開かれたタブが現在のタブの子になるようにした
   * Menu Editorでメニューの項目が取り除かれている時は、メニュー項目の表示・非表示を動的に切り替えないようにした
   * Tab Ulititiesによってタブがハイライト表示されている時にタブのアイコンが消えていたのを修正
   * Greasemonkeyスクリプト中の `GM_openInTab()` で開かれたタブが現在のタブの子にならなくなっていたのを修正
 - 0.12.2011061701
   * タブやリンクをドラッグしている間、自動的に隠されたタブバーを表示するようにした
   * 他のアドオン向けに、複数のタブをツリー構造を保ったまま操作するための新しいAPIを追加： `gBrowser.treeStyleTab.moveTabs()` ,  `gBrowser.treeStyleTab.importTabs()` ,  `gBrowser.treeStyleTab.duplicateTabs()` 
   * タブバーを自動で隠す機能が壊れていたのを修正
   * Nightly 7.0a1でnsIDOM3Nodeインターフェースが削除されたまに動かなくなっていたのを修正
   * アニメーション効果が意図せず停止されてしまう不具合を修正
   * [ColorfulTabs](https://addons.mozilla.org/firefox/addon/colorfultabs/)との併用時にタブバーが意図せずスクロールされてしまう問題に対処
 - 0.12.2011060202
   * マルチプルタブハンドラとの併用時に、選択された複数のタブのドラッグ＆ドロップでブックマークを追加できない問題を修正
   * Tab Mix Plusなどの他のアドオンとの互換性を保つための処理が一部動作しなくなっていたのを修正
 - 0.12.2011060201
   * Firefox 3.5への対応を終了
   * Panoramaにおけるグループの切り替え処理を最適化
   * 起動速度について改善（CSSのリファクタリング、共通コードのJavaScriptコードモジュール化など）
   * 「新しいタブを開く」ボタンや「移動」ボタン上でのミドルクリックについて、タブを現在のタブの子として開くようにした（設定で挙動を変更可能）
   * [Locationbar²](https://addons.mozilla.org/ja/firefox/addon/locationbar%C2%B2/)との併用時、パスのセグメントから開かれたタブを現在のタブの子にするようにした
   * アドオン向けの新しいAPIを追加： `TreeStyleTabService.readyToOpenChildTabNow()` ,  `TreeStyleTabService.readyToOpenNextSiblingTabNow()` ,  `TreeStyleTabService.readyToOpenNewTabGroupNow()`  これらは、新しいタブが開かれる事自体がキャンセルされる可能性がある場面で新しい子タブを開く事を予約する場合に役立ちます。これらのAPIによって行われた新しい子タブの予約は時間が過ぎたら自動的にキャンセルされるため、手動で  `TreeStyleTabService.stopToOpenChildTab()`  を呼ぶ必要がありません。
   * 縦型タブバーの中に置かれたツールバー項目の中のテキストボックスの内容が表示されない問題を修正
   * ポップアップウィンドウとして開かれたウィンドウにおいて縦型タブバーが消えていなかったのを修正
   * 縦型タブバーにおいて、最後のタブより後に折りたたまれたタブがある時にドロップ位置のインジケータが表示されていなかったのを修正
   * 折りたたまれた子タブを持つ最上位の親タブをドラッグ＆ドロップで移動した時に、意図せずツリーが展開されてしまっていたのを修正
   * Firefox 4において「開いているタブが1つだけの時にタブバーを表示しない」機能（Firefox自身の機能）が期待通りに動作していなかったのを修正
   * 横置きタブバーが常に一番上に表示されてしまう不具合を修正
   * タブバーのスプリッタのつまみをクリックした時にタブバーが折りたたまれたままになってしまう問題を修正
   * [bug 626903](https://bugzilla.mozilla.org/show_bug.cgi?id=626903)によって導入された「タブの一覧表示時に、画面内にあるタブに対応する項目をハイライト表示する」機能が縦型タブバーで期待通りに動作していなかったのを修正
   * 内部設定 extensions.treestyletab.tabbar.scrollToNewTab.mode が非アクティブ状態で開かれるタブに対して働いていなかったのを修正
   * [All-in-One Sidebar](https://addons.mozilla.org/firefox/addon/1027)との併用時に、AiOSによってサイドバーが自動的に隠された場合にコンテンツ領域の上にタブバーが取り残される形で描画されてしまう問題を修正
   * Nightlyにおいて、[bug 558585](https://bugzilla.mozilla.org/show_bug.cgi?id=558585)で導入された[いくつかのパッチ](http://hg.mozilla.org/mozilla-central/rev/e90bdd97d168)によってタブバーの背景色が白に固定されてしまっていたのを修正
   * da-DKロケール更新（by Regmos）
 - 0.11.2011050602
   * Personasを使用している時に縦型タブバーが正常に機能しない問題を修正
   * 右に置いたタブバーにおいて、ピン留めされたタブの表示が意図せずアニメーションしてしまっていたのを修正
   * 「自動で隠す」機能を有効にした時にピン留めされたタブが表示されなくなってしまう問題を修正
   * 「自動で縮める」機能で幅が狭められた状態のタブバーについて、ウィンドウの右に置いた場合でもリサイズできるようにした
   * Mac OS Xにおいて、タブバーのスプリッタ上にあるつまみをクリックした後にタブバーを再び展開できなかったのを修正
   * 現在のタブが折りたたまれた子タブを持っている時に、現在のタブを閉じると他のツリーが意図せず折りたたまれてしまっていたのを修正
 - 0.11.2011050601
   * 新しい空のタブを開く時、現在のタブの隣に同階層で開けるようにした。
   * 「再読み込み」ボタンのミドルクリックで現在のタブを複製する時、現在のタブの子タブ、同階層のタブ、または現在のタブの隣の同階層のタブとして開けるようにした。
   * 他のアドオン向けの新しいAPIとして、タブを対象のタブと同階層で隣に開くための `TreeStyleTabService.readyToOpenNextSiblingTab(aSourceTab)` を追加。
   * アンインストールされた時に「タブを上に表示」の状態を復元するようにした（※既にツリー型タブを使用している場合は元の状態が分からないため、設定はインストール前の状態には復元されません）
   * マルチプルタブハンドラやTab Utilitiesでタブを選択している場合、ドラッグ＆ドロップ操作では選択されたタブだけを移動するように仕様を変更した
   * アンインストールされた時に、ツリー型タブが変更したFirefoxの隠し設定を元に戻す仕組みがFirefox 4で動作しなくなっていたのを修正
   * 「自動で隠す」の状態の時、右に置いたタブバーが画面外に置かれてしまっていたのを修正
   * ピン留めされたタブの表示位置が「自動で隠す」の状態の時におかしくなっていたのを修正
   * 情報バーによる確認が機能しなくなっていたのを修正
   * 「このツリー以外のタブを閉じる」でピン留めされたタブを閉じないように修正
   * タブバーのスプリッタを右ボタンや中ボタンによるドラッグ操作に反応しないようにした
   * 親のタブを閉じた時の挙動がおかしくなっていたのを修正（extensions.treestyletab.closeRootBehaviorはextensions.treestyletab.closeParentBehaviorが0の時だけ機能するはずだったのが、リグレッションにより期待通りに働かなくなっていた）
   * サイドバーや縦型ツールバー等が表示されている時にステータスパネルの表示位置がおかしくなっていたのを修正
   * 「戻る」「進む」ボタンの中クリックでツリーが壊れていたのを修正
   * [Hide Caption Titlebar Plus](https://addons.mozilla.org/firefox/addon/hide-caption-titlebar-plus-sma/)との併用時に縦型タブバーが正しく機能しなくなっていたのを修正
   * Tab Mix Plusとの併用時にタブを正常にピン留めできなくなっていたのを修正
 - 0.11.2011040804
   * 右に縦置きしたタブバーにおいてピン留めされたタブの表示がおかしくなっていたのを修正（0.11.2011040802でのリグレッション）
 - 0.11.2011040803
   * 「multiselected」属性により選択されているタブをドラッグ＆ドロップした時、選択されていない子タブを持つタブがある場合は選択されているタブだけを移動するようにした
 - 0.11.2011040802
   * 左に縦置きしたタブバーにおいてピン留めを解除されたタブの表示がおかしくなっていたのを修正（0.11.2011040801でのリグレッション）
   * 親と子を両方とも持っているタブをピン留めした時にツリーの表示が壊れる事があったのを修正
   * 「multiselected」属性により選択されているタブをブックマークツリーにドラッグ＆ドロップした場合は、ツリー型タブ自身で処理を行わずにFirefox自体や他のアドオンに処理を任せるようにした
 - 0.11.2011040801
   * 左に縦置きしたタブバーにおいてピン留めされたタブの配置がおかしくなっていたのを修正（0.11.2011040701でのリグレッション）
 - 0.11.2011040701
   * Firefox 4でウィンドウ左に縦置きしたタブバーにおいて、スクロールバーを左端に表示するようにした（隠し設定 "extensions.treestyletab.tabbar.invertScrollbar" で無効化できます）
   * 縦置きしたタブバーのスクロールバーを細い幅で表示するようにした
   * ツリーの最小のインデント幅を3ピクセルとした（隠し設定 "extensions.treestyletab.indent.min" で変更できます）
   * ツリーのインデント幅の自動調節を隠し設定 "extensions.treestyletab.indent.autoShrink" で無効化できるようにした
   * Firefox 4のステータスパネルをタブバーに重ならない位置に表示するようにした（隠し設定 "extensions.treestyletab.repositionStatusPanel" でこの挙動を無効化できます）
   * 他のアドオンとの互換性のためのハックを無効化できるようにした（隠し設定 "extensions.treestyletab.compatibility.*" を参照して下さい）
   * 設定ダイアログやabout:configからタブバーの一部の設定（幅、位置、固定の状態）を変更した場合はすべてのウィンドウですぐに変更を適用するようにした
   * タブバー自体を他のウィンドウにドラッグ＆ドロップしようとするとドロップ先のウィンドウが壊れていたのを修正
   * タブバーが意図せず細くなりすぎてしまった場合に、必要な最小の幅にまで自動的に拡大するようにした
   * Firefox 4でいくつかのテーマにおいて、「タブバーを自動的に隠す」が有効になっている時にコンテンツ表示領域が操作できない矩形の領域で覆われてしまう事があったのを修正
   * Windows Vista/7 でクラシックテーマを使用している（Aero Glassが無効になっている）環境において、Firefox 4で縦置きしたタブバーの表示が壊れていたのを修正
   * 折りたたまれた状態から展開中のタブがある時に、Firefox 4においてタブバーのスムーズスクロールが期待通りに機能していなかったのを修正
   * 折りたたまれた子タブにフォーカスした時にツリーが自動的に展開されない場合があったのを修正
   * Firefox 4においてタブバーに追加された項目の上にタブをドロップできなくなっていたのを修正
   * Firefox 4においてタブバーを縦置きした時にタブバー自体に置かれた「タブを閉じる」ボタンが表示されていなかったのを修正
   * 縦置きしたタブバーにおいてタブのドロップ位置のインジケータが意図せず表示されてしまう場合があったのを修正
   * Firefox 4において[Focus Last Selected Tab](http://www.gozer.org/mozilla/extens
ions/)と併用できなくなっていたのを修正
   * Firefox 4において[Optimoz Tweaks](http://optimoz.mozdev.org/tweaks/)と併用できるようにした
   * Tab Mix Plusによってタブに追加されたプログレスメーターの表示位置を調整
   * Tab Mix Plusによってリンクから開かれたタブが現在のタブの子タブになっていなかったのを修正
   * da-DKロケール追加（Translated by Regmos. Thanks a lot!）
 - 0.11.2011032401
   * Firefox 4でタブバー上に挿入した項目が表示されない問題を修正
   * Firefox 4でタブグループを切り替えるとツリーが壊れる問題を修正
   * [Locationbar2](https://addons.mozilla.org/firefox/addon/locationbar%C2%B2/)との競合を解消
 - 0.11.2011031901
   * 縦型タブバーの中に伸縮可能な項目（検索バーなど）を置いた場合に、タブの数が増えると項目が隠れてしまう問題に対処
   * タブの数が多い時に、タブバー内に挿入されたツールバー項目をクリックするとその下にあるタブが選択されてしまっていたのを修正
   * 2つ目以降のブラウザウィンドウにおいて、1つ目のブラウザウィンドウを閉じた後だとブックマークを正常に開けなくなる問題を修正
   * ツールバーのカスタマイズを行う度にタブよりも前に置いた項目がタブの後に移動されてしまう問題を修正
   * タブバーの上に置いた追加の項目をドラッグ＆ドロップで削除できない場合があったのを修正
   * タブバー内に移動した検索バーの上でのクリック操作が無視される場合があったのを修正
   * 最後のタブのツリー全体を閉じる時にフリーズすることがあったのを修正
   * ピン留めされたタブの上にタブをドロップした時にタブのツリーが壊れることがあったのを修正
   * タブをピン留めした時に、間違った位置にタブが表示されることがあったのを修正
   * [Personal Titlebar](https://addons.mozilla.org/ja/firefox/addon/personal-titlebar/)との併用時にツリー表示が無効化されたままになる問題を修正
   * Tab Mix Plusとの併用時にピン留めされたタブの表示がおかしくなる問題を修正
   * Tab Mix Plusとの併用時に「Default」テーマにおけるピン留めされたタブの表示の崩れを少し修正
   * セッション復元時のツリーの開閉状態を制御する隠し設定 `extensions.treestyletab.collapseExpandSubtree.sessionRestore` を追加（-1＝元の状態を復元、0＝ツリーをたたんだ状態で復元、1＝ツリーを展開した状態で復元）
   * ドイツ語ロケール更新（by Andy Pillip）
 - 0.11.2011021901
   * ツールバーのカスタマイズ時にツリー型タブによるタブのドラッグ＆ドロップ処理が働いてしまう場合があったのを修正
   * Minefieldにおいて、アプリケーションタブのタイトルが変化した時のハイライト表示が働かない問題を修正
   * [TotalToolbar](http://totaltoolbar.mozdev.org/)との互換性を向上
 - 0.11.2011021601
   * ツリーに含まれていたタブを開き直した時に他のタブも併せて復元するかどうかの確認の情報バーについて、各ボタンに適切なアクセスキーを設定するようにした
   * userChrome.css等でタブにフォーカスできるようにしていた場合に、フォーカスリングが表示されるようにした
   * Firefox 3.6以前において、extensions.treestyletab.tabbar.transparent.partialTransparencyの値が1以上の場合はタブバーの背景を描画しないようにした
   * タブの外観として「Default」が選択されている時に、タブのドロップ位置のマーカーを代替のスタイルで表示するようにした
   * Minefieldにおいて、現在のタブを閉じた後に元のタブにフォーカスを戻さなくなっていたのを修正
   * [マルチプルタブハンドラ](http://piro.sakura.ne.jp/xul/_multipletab.html)との併用時において、選択した複数のタブをドラッグ＆ドロップでウィンドウから切り離す操作に失敗するようになっていたのを修正
   * タブをドラッグ＆ドロップでウィンドウから切り離す時に余計なウィンドウが開かれるようになっていたのを修正
   * Minefieldにおいて、タブバーのスプリッタ上のつまみをドラッグした時にタブバーの幅が変わらずにスプリッタだけが移動してしまっていたのを修正
   * [BarTab](https://addons.mozilla.org/firefox/addon/bartab/)がインストールされている場合に、閉じたタブを開き直す操作で復元されたタブが含まれるツリーが意図せず折りたたまれてしまう事がある問題を修正
   * Minefieldにおいて[RequestPolicy](https://addons.mozilla.org/firefox/addon/requestpolicy/)との併用時にタブバーの表示が壊れる問題に対処
   * 簡体中国語ロケール更新（by hzhbest）
   * スペイン語ロケール更新（by Tito Bouzout）
   * スウェーデン語ロケールを追加（by Mikael Hiort af Ornäs）
 - 0.11.2011020402
   * 初期化処理中にエラーが発生していたのを修正
 - 0.11.2011020401
   * Minefieldにおいて、初期状態ではステータスパネルがタブバーに重ならないようにタブバーの反対側に表示するようにした
   * TreeStyleTabService.positionが正しい値を返していなかったのを修正
 - 0.11.2011020301
   * 新しい空のタブを開く時にタブをツリーの中に開くかどうかを設定できるようにした
   * about:sessionrestoreから個別にタブを復元した場合は子タブとして開くようにした
   * タブバーを下に置いた時に[ステータスパネル](https://bugzilla.mozilla.org/show_bug.cgi?id=628654)がタブの下に隠れてしまわないようにした
   * 折りたたまれたツリーをドラッグ＆ドロップで移動した時にツリーの開閉状態が壊れていたのを修正
   * タブバーを自動で隠す設定の時にタブバーの背景の透明度を固定するようにした
   * Tab Mix Plusがあるとタブをドラッグ＆ドロップできなくなる問題に対処
   * [DragNDrop Toolbars](https://addons.mozilla.org/firefox/addon/dragndrop-toolbars/)との併用を可能にした
   * 隠し設定の `extensions.treestyletab.autoAttachNewTabsAsChildren` の名前を `extensions.treestyletab.autoAttach` に変更した
 - 0.11.2011012302
   * plロケールが壊れていたのを修正
 - 0.11.2011012301
   * [Peronal Titlebar](https://addons.mozilla.org/irefox/addon/personal-titlebar/)などでタブバーが他のツールバーに移動された場合、そのツールバー全体を新しいタブバーとして使用するようにした
   * ブックマークグループをツリーとして開いた時のグループ化用タブについて、タイトルをクリックして編集モードに入った時に既存の内容を自動的に選択するようにした
   * タブバーの位置変更用API `TreeStyleTabService.currentTabbarPosition` を `TreeStyleTabService.position` にリネームした（互換性のため旧来の名前でもアクセスは可能です）
   * タブの上でのツールチップの内容が常にツリー開閉用のつまみの物になってしまっていたのを修正
   * Tab Mix Plusと併用した時にタブのアイコン画像が拡大されてしまう問題に対処
   * タブバーを左または右に置いている時にタブのドラッグ＆ドロップなどでドロップ位置のマーカーが意図せず表示されてしまうことがあったのを修正
   * ツリー表示を一時的に無効化するAPI `TreeStyleTabService.treeViewEnabled` でツリー表示を無効化した時、横置きタブバーで重ねられたタブの表示が更新されていなかったのを修正
 - 0.11.2011011301
   * Panoramaでタブを並べ替えた場合にPanorama上のタブの並び順と実際のタブの並び順が一致しなくなる問題を修正
   * Minefieldにおいて、タブバーを自動で隠す機能の有効・無効を切り替えた時にタブバーの幅が元より広がったり狭まったりしていたのを修正
   * ピン留めされたタブの表示位置がおかしくなっていたのを修正
   * ピン留めされたタブの外観を修正
   * セッション復元時などにピン留めされたタブの表示位置が崩れる問題を修正
   * タブバーを自動で隠す機能を有効化している時に、ピン留めされたタブの表示位置が崩れないようにした
   * Minefieldにおいて、「Sidebar」テーマでタブバーの上端に余計な線が表示されていたのを修正
 - 0.11.2011011102
   * DOMイベントを使用したAPIについて、旧来のイベント名（nsDOMというプレフィクスが付かない物）でも `getData()` で情報を取得できるようにした
 - 0.11.2011011101
   * タブバーを自動で隠す機能について、MinefieldにおいてCtrlキーの押下やCtrl-Tabでのタブ切り替えを処理できなくなっていたのを修正
   * タブバーを自動で隠す機能について、通常時とフルスクリーンモード時の設定を個別に変更できるようにした
   * タブバーを自動で隠す機能について、ポインタの位置に応じてタブバーを自動展開する設定が無効になっている場合はタブバー開閉用のプレースホルダを隠すようにした
   * タブバーを自動で隠す機能について、ポインタの位置に応じてタブバーを自動展開する設定を無効にできていなかったのを修正
   * Minefieldでタブバーを自動で隠す機能が有効になっている時、起動時にタブバーの幅が異常に狭くなってしまう事があったのを修正
   * Minefieldでタブバーを自動で隠す機能が有効になっている時、タブバーが展開されている状態でウィンドウをリサイズするとタブバーの表示が壊れていたのを修正
   * Minefieldで起動時にタブバーの表示位置が一瞬だけずれてしまう問題を修正
   * Minefieldでのタブの外観を修正（主にMac OS X向け）
   * Minefieldにおいて、Persona（軽量テーマ）が適用されている時にタブバー内に置かれたボタンが見えなくなってしまう問題を修正
   * Minefieldにおいて、Persona（軽量テーマ）のプレビューでタブバーの表示がおかしくなる問題を修正
   * Linux上のMinefieldにおいて、タブバーを自動で隠す機能が有効になっている時にタブバーをリサイズできなかったのを修正
   * Linux上のMinefieldにおいて、メニューバーが表示されている時にタブバーの上辺に余計な線が表示されていたのを修正
   * コンテキストメニューから選択語句を検索した時に、開かれたタブを現在のタブの子にするようにした
   * extensions.treestyletab.autoAttachSearchResultAsChildrenの値が2の時にWeb検索バーからの検索結果が子タブにならない問題を修正
   * ツリーの親であるタブをブックマークツリー等にドラッグ＆ドロップした時に、ツリーに含まれるタブすべてをブックマークするかどうかを選択できるようにした
   * Mac OS Xにおいてツリーのつまみのクリックが無視されていたのを修正
   * Tab Mix Plusとの併用時に複数のタブのドラッグ＆ドロップができなくなっていたのを修正
   * DOMイベントを使用したAPIについて、Minefieldでのセキュリティ上の制約により、「nsDOM」プレフィクス付きのイベント名で、DataContainerEventとしてイベントを送出するように仕様を変更（後方互換性のため過去のプロパティアクセス表記も利用可能ですが、Firefox 4以降では、場面によってはセキュリティ上の制限からプロパティアクセスを利用できません。安全のため、今後は  `aEvent.getData(プロパティ名)`  でプロパティの内容を参照するようにしてください。）
 - 0.11.2010120903
   * いくつかのWebページでWeb検索バーからの検索ができなくなっていたのを修正
 - 0.11.2010120902
   * 内部エラーによってタブのオーバーフローなどの処理がブロックされていたのを修正
 - 0.11.2010120901
   * タブのコンテキストメニューに「このツリー以外の他のタブをすべて閉じる」を追加
   * FirefoxのWeb検索バーからタブが開かれる場合に、現在のタブで選択されている語句が検索された時は現在のタブの子にするようにした（隠し設定 `extensions.treestyletab.autoAttachSearchResultAsChildren` を2に変更すると検索結果のタブを常に現在のタブの子として開き、0に変更すると子タブにしない）
   * [DomainTab](https://addons.mozilla.org/firefox/addon/13906/)によって開かれたタブを現在のタブの子にするようにした
   * 設定ダイアログが正常に機能しなくなっていたのを修正
 - 0.11.2010120802
   * Firefox自身や他のアドオンの初期化処理を意図せずブロックしてしまう場合があったのを修正
 - 0.11.2010120801
   * 1つのイベントループ中にAPI経由で複数の子タブが開かれた場合、ツリーの子タブの挿入位置の設定に関わらず、それらのタブは開かれた順に表示するようにした。
   * Minefield上で「Metal」テーマが壊れていたのを修正
   * Minefield上で、タブバーを自動的に隠す設定の時にタブバーのリサイザが表示されなくなっていたのを修正
   * Minefield上で、サイドバーの開閉時に常にタブバーの位置を更新するようにした
   * Minefield上でタブのツールチップの内容が更新されていなかったのを修正
   * コードを整理
 - 0.11.2010120301
   * タブ以外のドラッグ＆ドロップをハンドリングできていなかったのを修正
   * タブバーを自動的に開閉する設定の時に印刷プレビューの画面がガタついていたのを修正
   * All-in-One Sidebarなどと併用した時に印刷プレビューを終了してもタブバーが消えたままになる事があったのを修正
   * 複数ウィンドウを開いている時にタブバーの幅がおかしくなることがあったのを修正
   * TreeStyleTabFocusNextTabイベントが発行されておらず、常にフォーカス制御が無効になってしまっていたのを修正
 - 0.11.2010120202
   * ブックマークサイドバー等にツリーをドロップした場合、ツリーに属しているすべてのタブをブックマークするようにした
 - 0.11.2010120201
   * Windows上のFirefox 3.6以前では複数タブのドラッグ時にカーソルの形を変えないようにした（ドラッグ操作のフィードバック用画像が表示されないバグのため）
   * タブバーのドラッグ＆ドロップ操作が壊れていたのを修正（0.11.2010120101でのリグレッション）
 - 0.11.2010120101
   * Firefox 3.0のサポートを終了
   * HTML5のドラッグ＆ドロップイベントに対応し、Tab Utilitiesなどによる複数タブのドラッグ＆ドロップを受け付けるようにした
   * ツリーの階層の深さを制限できるようにした（初期値：999階層まで）
   * 縦型のタブバーにおいても、ツリーのインデント表示が無効の場合はタブのグループの間に余白を設けてグループを識別しやすいようにした
   * 新しいAPIとして `getAncestorTabs()` と「TreeStyleTabFocusNextTab」イベントを追加し、TreeStyleTabFocusNextTabイベントをキャンセルすることでツリー型タブによるタブのフォーカス制御（現在のタブを閉じたときにどのタブにフォーカスを移すかの判断）を無効化できるようにした
   * Minefieldにおいて、折りたたまれた状態から展開される途中のタブが半透明になっていなかったのを修正
   * 設定でアニメーション効果が有効な場合は、ツリーの開閉時のアニメーション効果を常に適用するようにした
 - 0.11.2010112601
   * リンクから自動的にタブを開く機能を[リンクから新しいタブを開く](http://piro.sakura.ne.jp/xul//xul/_openlinkintab.html)に分離した
   * ロケーションバーから自動的にタブを開く機能を[ロケーションバーから新しいタブを開く](http://piro.sakura.ne.jp/xul//xul/_newtabfromlocationbar.html)に分離した
   * タブバーが横置きされている時のタブのドロップ位置のマーカーをより目立つようにした。
   * Minefieldにおいて、横置きされたタブバーでタブのツリーを折りたたんだ時に、折りたたまれたタブを親のタブの後ろに重ねて表示するようにした。（今までの挙動に戻す場合、隠し設定のextensions.treestyletab.stackCollapsedTabsを変更してください。）
   * Minefieldにおいて、横置きされたタブバーの中のタブの幅が異常に広がる事があったのを修正
   * Minefieldにおいて、タブバーが横置きされている時にタブのドロップ位置のマーカーが消えなくなっていたのを修正
   * タブのインデント表示を制御する設定項目が無視されるようになっていたのを修正
   * LinuxおよびMac OS Xでテーマ選択の結果が保存されない問題を修正
 - 0.10.2010111301
   * Minefieldにおいて、ブックマークをタブで開けなくなっていたのを修正
   * Minefieldにおいて、リンクから開かれたタブが子タブになら無くなっていたのを修正
   * about:configやabout:pluginsなどをロケーションバーから開く際、別ドメインとして扱うようにした
   * 初期状態で、ロケーションバーでのAlt-Enterは常に新しいタブを開くようにした（Altが押されていない時の反対の動作をさせたい場合は extensions.treestyletab.urlbar.invertDefaultBehavior をtrueにする）
 - 0.10.2010102501
   * [Bug 586234](https://bugzilla.mozilla.org/show_bug.cgi?id=586234)の変更によって、リンクから開かれたタブが現在のタブの子タブにならなくなっていたのを修正
   * [Bug 568691](https://bugzilla.mozilla.org/show_bug.cgi?id=568691)の変更によって、プラットフォームごとの初期設定が適用されなくなっていたのを修正
   * セッション復元時にツリーが壊れる可能性があったのを修正（0.10.2010102401でのregression）
   * Minefieldで設定ダイアログのアイコンが表示されていなかったのを修正
 - 0.10.2010102401
   * [Bug 448546](https://bugzilla.mozilla.org/show_bug.cgi?id=448546)の変更によって、開かれたタブが現在のタブの子にならない場合が生じていたのを修正
   * [Bug 568691](https://bugzilla.mozilla.org/show_bug.cgi?id=568691)の変更によってプラットフォーム別のコードが読み込まれなくなっていたのを修正
   * [Bug 586068](https://bugzilla.mozilla.org/show_bug.cgi?id=586068)の変更によってセッションが復元されなくなっていたのを修正
   * [Bug 602964](https://bugzilla.mozilla.org/show_bug.cgi?id=602964)の変更によってタブの構造が変化した事に追従
   * Tab Candyによって非表示にされたタブがある時にツリーの挙動がおかしくなることがあったのを改善（不可視のタブは常に可視のタブの後に配置するようにした）
   * ポップアップメニューが開いている間はポインタの移動によるタブバーの自動開閉を無効化する、という処理が期待通りに動いていなかったのを修正
   * タブバー上でダブルクリックした時に、一部のアドオンがインストールされているとタブが二重に開かれることがあったのを修正
 - 0.10.2010091901
   * Firefox 3.6以前でタブが半透明のままになっていたのを修正（0.10.2010091801でのregression）
   * 「子タブをリロードする」機能で親タブまでリロードしてしまっていたのを修正
   * [Tab Utilities](https://addons.mozilla.org/firefox/addon/59961/)によってリンクから開かれるタブが子タブにならない問題に対処
   * リンクから自動的にタブを開く機能について、開かれるタブを現在のタブの子タブにするかどうかを隠し設定により明示的に設定できるようにした
     * extensions.treestyletab.openOuterLinkInNewTab.asChild：他のサイトへのリンクを子タブにするかどうか
     * extensions.treestyletab.openAnyLinkInNewTab.asChild：同じサイトへのリンクを子タブにするかどうか
   * 親のタブを閉じたらすべての子タブをツリーから解放する設定の時、子タブをタブバーの最下部ではなく、最も近い自然な位置（最上位の親タブの次の兄弟タブの直前）に置くようにした（extensions.treestyletab.closeParentBehavior.moveDetachedTabsToBottomをtrueに変更するとこれまでと同じ挙動になる）
 - 0.10.2010091801
   * Panoramaによるグループの変更について、Panoramaから通常の表示に戻る時にまとめて結果をツリーに反映するようにした
   * 閉じられないタブが残ってしまう問題について修正したつもり
   * ツールバーのカスタマイズ中はタブバーの移動をできなくする変更が機能していなかったのを修正
   * [Bug 544818 - Progress "Line" indicator for loading tabs](https://bugzilla.mozilla.org/show_bug.cgi?id=544818)による変更に追従
 - 0.10.2010091602
   * Minefieldでタブバーを右に置いていて、タブが1つだけの時にタブバーを自動的に隠す設定にしている場合に、2つ目のタブを開いた後にタブバーが完全には表示されない問題を修正
   * Minefieldにおいて、タブバーを自動的に隠す設定の時に、展開された状態のタブバーをリサイズできなくなっていたのを修正
   * Minefieldではタブの一覧の表示用ボタンはツールバのボタンとしてカスタマイズ可能なため、ツリー型タブの設定項目としては表示しないようにした
 - 0.10.2010091601
   * Minefield 4.0b7preの最新ビルドに対応（Firefox 4.0beta6以前はサポート対象外）
   * [Bug 593967 - Add more elements into tabbrowser tabs for easier stylability](https://bugzilla.mozilla.org/show_bug.cgi?id=593967) による仕様変更に追従
   * タブバーのタイトルバー的な挙動について、タブバーをドラッグ＆ドロップで移動できる局面と、タブバーが左右または下に置かれている場合はタイトルバー的な挙動を常に無効にするようにした
   * タブが1つだけ開かれている状態から2つ目のタブを開いた時に、タブバーの状態が更新されない問題を修正
   * Minefieldでフラグ指定付きのウィンドウを開いた時に、初期化処理が途中でエラーによって停止してしまうせいで、開かれたウィンドウの内容が表示されない問題を修正
   * Mac OS X上でCtrl-Tabのタブ切り替えに関する機能が動作していなかったのを修正（Command-Tabで行うものと誤認していた）
 - 0.10.2010091401
   * Tab Panoramaでタブをグループ分けしている時、グループ内のすべてのタブを一度に閉じるとウィンドウまで閉じてしまっていたのを修正
   * Tab Panoramaでタブをグループ分けしている時、「タブの一覧」が正常に機能していなかったのを修正
   * [Tab Utilities](https://addons.mozilla.org/firefox/addon/59961/)がインストールされている場合に「タブの一覧」のポップアップ内の項目が正常にインデントされていなかったのを修正
   * サイドバー等で `TreeStyleTabService.readyToOpenChildTab()` が呼ばれた場合にタブが開かれない問題を修正（reported by Bert Blaha）
   * Minefieldでタブバーのスプリッタ内のつまみ（grippy）をクリックした時の挙動がおかしかったのを修正
   * ウィンドウの大きさが意図せず小さくなってしまう問題を修正（0.10.2010091001でのregression）
 - 0.10.2010091001
   * Minefield 4.0b6preに対応したつもり
   * Minefieldで違うグループにタブが移動された場合、ツリーから切り離すようにした
   * Minefieldの「Tabs From Other Computers」から開いたタブを子タブにするようにした
   * Windows以外ではAeroPeek用のファイルを読み込まないようにした
   * Metalテーマでtwistyの位置がずれていたのを修正
   * Metalテーマでクローズボックス周辺の余白を小さくした
   * タブにそのタブ自身から取得したセッション情報を再設定した時に、ツリーの親子関係を維持するようにした
   * [IE Tab Plus](https://addons.mozilla.org/firefox/addon/10909/)で開かれるタブを子タブにするようにした
   * [Tab Utilities](https://addons.mozilla.org/firefox/addon/59961/)でpinned状態にされたタブからは子タブを開かないようにした
 - 0.10.2010080802
   * Minefield 4.0b4preで閉じたはずのタブが残ってしまう問題に対処（[Bug 585417](https://bugzilla.mozilla.org/show_bug.cgi?id=585417)）
   * Minefield 4.0b4preで新しく開かれたタブのインデントの増減がアニメーションされなくなっていたのを修正
   * Minefield 4.0b4preでロケーションバーから自動的にタブを開く機能が働かなくなっていたのを修正
 - 0.10.2010080801
   * [Bug 380960 - Implement closing tabs animation](https://bugzilla.mozilla.org/show_bug.cgi?id=380960)の変更に追従
   * Minefield 4.0b4preでツリーを展開する時のアニメーション効果が適用されない問題を修正
   * フランス語ロケール更新（by Laurent Haas）
 - 0.10.2010073001
   * twistyの表示スタイルの設定が、Firefox起動直後の初期化処理において反映されていなかったのを修正
   * ブックマークフォルダから複数のツリーを開く時、常にすべてのサブツリーを展開するようにした（extensions.treestyletab.openGroupBookmark.behaviorから2048を引くと今までと同じ挙動）
   * フランス語ロケール更新（by Laurent Haas）
 - 0.10.2010072901
   * Minefield 4.0b3preでタブのコンテキストメニューを開けなくなっていたのを修正
   * Minefield 4.0b3preでタブを既定の位置以外に置いている時、タブバーの余白でタブのコンテキストメニューを表示するようにした
   * Minefield 4.0b3preでタブの透明度が1で固定されてしまう問題を修正
   * browser.tabs.autoHideの影響でタブバーが隠される時、Minefield 4.0b3preで空のタブバーが表示されたままになる問題に対処
   * [プライベートブラウジングモードに入る時にタブが見えなくなる事がある問題](http://piro.sakura.ne.jp/cgi-bin/bbs.cgi?2736)を修正
   * [Bug 574654](https://bugzilla.mozilla.org/show_bug.cgi?id=574654)の変更に追従
   * 新しく開かれたタブについて、そのタブが見える位置までスクロールした時に現在のタブがスクロールアウトしてしまわないのであれば、新しいタブの位置までスクロールするようにした（extensions.treestyletab.tabbar.scrollToNewTab.mode（初期値は1）を0にするとこれまでと同じ挙動、2にすると常に新しいタブの位置までスクロールする）
   * フランス語ロケール追加（translated by Laurent Haas）
 - 0.10.2010070301
   * Minefield 4.0b2preで起動できなくなる問題を解消
   * Minefield 4.0b2preでタブバーの上でコンテキストメニューを開けない問題に対処
   * Minefield 4.0b2preで、アドオンマネージャのタブを開いていると起動後のセッション復元が中途半端なところで止まってしまう問題を修正
   * Tabs on Topにチェックを入れた時に、タブバーの固定状態だけが設定変更されてTabs on Topが有効にならずに終わってしまう問題を修正
   * タブバーを自動で隠す設定のとき、コンテンツ領域の描画がずれたままになる事があったのを修正
   * [Firefox Sync（Weave）](http://www.mozilla.com/firefox/sync) 1.4でTabs from Other Computersから開いたタブが子タブにならなくなっていたのを修正
 - 0.10.2010062901
   * Minefield 3.7a6preにおいて、 `pinTab()` されたタブをタブバーの上端にアイコン状に表示するようにした
   * Minefield 3.7a6preでタブバーを上に置いた状態ではツールバーのカスタマイズ用メニューの「Tabs on Top」のチェック状態とタブバーの固定状態とを関連付けて動的に変更するようにした
   * Minefield 3.7a6preでタブバーをドラッグできなくなっていたのを修正
   * Minefield 3.7a6preで、画面の描画を止める時にウィンドウの位置が変わってしまう問題に対処
   * Minefield 3.7a6preでタブバー上でのドラッグ中の自動スクロールが効かなくなっていたのを修正
   * タブバーを自動的に隠す設定の時、タブバーの開閉の瞬間にコンテンツ領域をクリックするとページの内容が選択された状態になってしまう問題に対処
   * [タブバーをウィンドウ外にドロップすると空のウィンドウが開かれてしまう問題](http://piro.sakura.ne.jp/cgi-bin/bbs.cgi?2698)を修正
   * [Mouse Gestures Redox](http://www.mousegestures.org/)で開かれるタブを子タブにするようにした（by A A）
   * [Firefox Sync（Weave）](http://www.mozilla.com/firefox/sync)でTabs from Other Computersから開いたタブを子タブにするようにした
   * ロシア語ロケール更新（by L'Autour）
 - 0.10.2010051201
   * タブバーの位置、タブバーのサイズ、タブバーのサイズ固定の状態、タブバーを自動で隠す機能の有効無効をウィンドウごとに変更できるようにした
   * TrunkではタブのアニメーションをCSS Transitionsで行うようにした
   * ツリー型タブが有効な間はbrowser.tabs.insertRelatedAfterCurrentをfalseに固定するようにした
   * Windows 7において、AeroPeekが無効化されている環境でまで勝手にAeroPeekが有効化された状態になってしまっていたのを修正
   * ツリー型タブの機能で自動的にリンクをタブで開けなくなっていたのを修正
   * Libraryやブックマークのプロパティで、ツリーの親の変更が保存されない事があったのを修正
   * ツールチップ等の大きさが意図せず固定されてしまう問題を修正したつもり
   * ブックマークフォルダの内容をタブで開く際に、現在のタブが空でTab Mix Plusによって空のタブが使い回されると、開かれたタブのツリー構造が壊れる問題について対処した。
 - 0.10.2010043001
   * Windows 7のAero Peekで、折りたたまれたツリーのタブに対応する項目を表示しないようにしてみた
   * [Bug 457187 - Make the tabs toolbar customizable](https://bugzilla.mozilla.org/show_bug.cgi?id=457187)、[Bug 544815 - Allow for placing Tabs over the Navigation Bar with option for Tabs under the Navigation Bar (add tabs on top option)](https://bugzilla.mozilla.org/show_bug.cgi?id=544815)、[Bug 545714 - Consolidate browser and nsContentAreaDragDrop.cpp dropped link handlers](https://bugzilla.mozilla.org/show_bug.cgi?id=545714)、[Bug 556739 - PlacesUIUtils should be a module instead](https://bugzilla.mozilla.org/show_bug.cgi?id=556739)による仕様変更に追従
   * Minefield 3.7a5preで、[タブバーの幅を狭くしすぎるとsplitterにタブバーが重なってタブバーの幅を元に戻せなくなる問題](http://piro.sakura.ne.jp/cgi-bin/bbs.cgi?2664)を修正
   * Minefield 3.7a5preで、[一度も展開していないブックマークフォルダの内容をタブで開けない問題](http://piro.sakura.ne.jp/cgi-bin/bbs.cgi?2663)を修正
   * Minefield 3.7a5preで、 `window.open()` のオプション指定によって一部のUIが隠されたウィンドウが開かれた時に、タブバーの位置に空白ができてしまう問題を修正
   * Minefield 3.7a5preで一部のコンテキストメニューの項目が機能しない問題を修正
   * Linuxで「Plain」「Mixed」テーマの外観がおかしくなっていたのを修正
   * LinuxでタブのCtrl-ドロップが正しく機能しなくなっていたのを修正
   * [タブバーの余白領域にリンクなどをドラッグした際、最初または最後のタブの上へのドラッグとして扱われてしまっていた](http://piro.sakura.ne.jp/cgi-bin/bbs.cgi?2687)のを修正
   * リンクをタブの上にドラッグした時、遅延無しでタブがすぐに切り替わってしまっていたのを修正（Firefox既定の動作と同様に、一定時間待ってからタブを切り替えるようにした）
   * twisty/タブバーのスプリッタ/タブバーの余白でのクリック操作について、Ctrl-クリックやミドルクリックの時は反応しないようにした
   * ツールバーのカスタマイズ中は、タブバーのドラッグ＆ドロップを無効化するようにした
   * タブバーの幅や高さがウィンドウの大きさをなるべく超えないようにした（ウィンドウよりも大きな幅に設定されそうになった場合、自動的にウィンドウ幅よりも小さな幅に調整するようにした）
   * [TooManyTabs](https://addons.mozilla.org/firefox/addon/9429)、Tab Mix Plusなどと組み合わせた際にtwistyのクリックによるツリーの開閉ができなくなっていたのを修正
   * Tab Mix Plusによるタブのフォーカス制御が働かなくなっていたのを修正
   * Tab Mix Plusとの組み合わせ時にツリー型タブ側の「リンクをすべてタブで開く」機能が働いていなかったようだったので対策を施した
   * [TotalToolbar](http://totaltoolbar.mozdev.org/)との競合を解消
   * [Weave](https://mozillalabs.com/weave/)によって「タブの一覧」ポップアップの内容が改変されている時に、「タブの一覧」ポップアップの項目のインデントが崩れる問題を修正
   * 無用なトラブルを起こさないよう、[Session Manager](https://addons.mozilla.org/firefox/addon/2324)でのセッション復元時にはタブを一旦すべて閉じるようにした
   * de-DEロケール更新（by Andy Pillip）
   * zh-CNロケール更新（by hzhbest）
 - 0.10.2010040201
   * [Bug 554991 - allow tab context menu to be modified by normal XUL overlays](https://bugzilla.mozilla.org/show_bug.cgi?id=554991)による仕様変更に追従
 - 0.10.2010040102
   * 組み込みテーマ「Metal」と「Sidebar」でウィンドウのフォーカス状態が表示に反映されなくなっていたのを修正
   * 組み込みテーマ「Vertigo」の外観が壊れていたのを修正
   * 組み込みテーマ「Plain」をLinuxでのデフォルトテーマとして復活させた
 - 0.10.2010040101
   * 組み込みのテーマから「プレーン」を削除し、代わりに「Mixed」からドロップシャドウの効果を外した「Flat」を追加した
   * Minefield 3.7a4pre対応：[Bug 508482](https://bugzilla.mozilla.org/show_bug.cgi?id=508482)によって導入された `:-moz-window-inactive` 疑似クラスを利用するようにした
   * Minefield 3.7a4pre対応：フルスクリーンモード切り替え時のアニメーションが効かなくなっていたのを修正
   * Minefield 3.7a4pre対応：フルスクリーンモードに切り替えた時にコンテンツ表示領域がものすごく小さくなってしまう問題に対処
   * Minefield 3.7a4preにおいてタブバーの再描画の回数を減らした
   * ブックマークのプロパティを表示するとフリーズすることがあったのを修正
   * フルスクリーンモードでタブのコンテキストメニューの「タブバーを自動的に隠す」が期待通りの動作になっていなかったのを修正
   * [AutoHide](http://www.krickelkrackel.de/autohide/)と併用した時に、フルスクリーンモードで画面描画がおかしくなっていた問題に対処
   * [AutoHide](http://www.krickelkrackel.de/autohide/)と併用した時に、前回終了時がフルスクリーンモードだと次回起動時の「タブバーを自動的に隠す」機能の挙動がおかしくなる問題を修正
   * 「Mixed」スタイル適用時に、[Tab Mix Plus](https://addons.mozilla.org/firefox/addon/1122)、[Tab Mix Lite](https://addons.mozilla.org/firefox/addon/12444)、[Tabberwocky](https://addons.mozilla.org/firefox/addon/14439)、[Tab Utilities](https://addons.mozilla.org/firefox/addon/59961)、[Super Tab Mode](https://addons.mozilla.org/firefox/addon/13288)、[Remove New Tab Button](https://addons.mozilla.org/firefox/addon/10535)によって「新しいタブ」ボタンが隠されている時にボタンの影が表示されてしまっていた問題に対処
   * [Super Tab Mode](https://addons.mozilla.org/firefox/addon/13288)のタブを開く位置の制御を、ユーザに問い合わせてから無効化するようにした
   * [Super Tab Mode](https://addons.mozilla.org/firefox/addon/13288)によるタブのロックに対応
   * [Tab Utilities](https://addons.mozilla.org/firefox/addon/59961)および[Super Tab Mode](https://addons.mozilla.org/firefox/addon/13288)によって現在のタブを閉じた時のフォーカスが制御されている場合は、ツリー型タブの側ではフォーカスを制御しないようにした
 - 0.10.2010032902
   * 一部の処理でMinefield 3.7a4pre以前と以後の判別に失敗していたのを修正
 - 0.10.2010032901
   * Minefield 3.7a4preで印刷プレビュー時にタブバーのプレースホルダが表示されたままになっていたのを修正
 - 0.10.2010032802
   * Minefield 3.7a4preでタブバーの左に余白ができていたのを修正
 - 0.10.2010032801
   * Minefield 3.7a4pre対応
   * スプリッタのダブルクリックでタブバーの幅・高さを初期値にリセットするようにした
   * Firefox 3.5以降ですべてのタブの一覧のポップアップの中に影が表示されていたのを修正
   * アドオンの有効無効切り替え時に、内部で変更した隠し設定の値を元に戻す処理が期待通りに働いていなかったのを修正
   * ポップアップに対する内部処理がWebページ内のselect要素等が生成するポップアップにまで反応していたのを修正
   * [Smoothly Close Tabs](https://addons.mozilla.org/firefox/addon/71410)と同時に利用できるようにした（つもり）
   * [Tab Kit](https://addons.mozilla.org/firefox/addon/5447)がある時にスプリッタが二重に表示されてしまう問題に対処
   * plロケール更新（by Leszek(teo)Życzkowski）
 - 0.9.2010020502
   * 組み込みのテーマの画像が一部読み込まれていなかったのを修正（リグレッション）
 - 0.9.2010020501
   * [SidebarStyleTab](https://addons.mozilla.org/firefox/addon/58998)の外観を組み込みのテーマとして統合した（thanks, Philipp von Weitershausen!）
   * 閉じたタブを開き直す時、同時に閉じられた他のタブもまとめて復元できるようにした
   * ブックマークの保存が開始されていない時にブックマークの保存の終了処理を呼ぶとエラーになっていたのを、エラーにならないようにした
   * Firefox 3.6以降で前回終了時のタブの開閉状態が失われる問題を修正
   * タブバーを右に置いている時、起動時に一瞬だけ左にタブバーが見えていたのをごまかすようにした
   * サブツリーを折りたためない設定のとき、favicon付近をクリックしてもタブのフォーカスが切り替わらないことがあったのを修正
   * [Tab Utilities](https://addons.mozilla.org/ja/firefox/addon/59961)との組み合わせでタブが縦にセンタリングされてしまう問題に対処
   * Tab Mix Plusと同時に利用していて、アニメーション効果を無効にしている時などに、一部のタブが見えなくなってしまう問題を修正
   * 以下のAPIを追加：     * markAsClosedSet()
     * unmarkAsClosedSet()
     * splitTabsToSubtrees()
     * ツリーを閉じる前後に TreeStyleTabSubtreeClosing / TreeStyleTabSubtreeClosed イベントを発行するようにした
 - 0.8.2009122501
   * [Tabberwocky](https://addons.mozilla.org/firefox/addon/14439)と協調して動作するようにした
   * タブバーを自動的に隠す設定の時、タブバーを展開している間にウィンドウをリサイズするとタブバーの背景がウィンドウに合わせてリサイズされていなかったのを修正
   * タブバーの位置を変更した後でスプリッタの挙動がおかしくなる場合があった問題に対処
   * TabOpenイベントが発行される前にタブが移動された場合でもツリー構造が壊れないようにした
   * 内部的に使用していたID、メソッド名、設定名に含まれる「SubTree」をすべて「Subtree」に統一した。これにより以下の隠し設定の名前も変化した。
     *  `extensions.treestyletab.autoExpandSubtreeOnCollapsedChildFocused` ：折りたたまれたツリーの中のタブにフォーカスした時に、ツリーを自動的に展開するかどうか
     *  `extensions.treestyletab.autoCollapseExpandSubtreeOnSelect.whileFocusMovingByShortcut` ：Ctrl-Tabによるタブの切り替え中にツリーを展開するかどうか
 - 0.8.2009122401
   * タブを閉じた後に、選択範囲のコピー＆ペーストができなくなったり一部のキーボードショートカットが効かなくなったりする問題を修正（0.8.2009122101～0.8.2009122103の後退バグ）
   * 現在のタブを閉じた時に、予想だにしない位置のタブにフォーカスが飛んでしまうことがあったのを修正（内部的に保持された子タブの並び順が実際の表示と食い違っていた場合があったのを修正）
   * [Multi Links](https://addons.mozilla.org/firefox/addon/13494)と協調して動作するようにした
 - 0.8.2009122103
   * フルズームを使用したページでタブバーの背景がずれる問題を修正
 - 0.8.2009122102
   * 親タブを閉じて最初の子タブが新しい親に昇格する時、折りたたまれたタブが見えなくなってしまう問題を修正
 - 0.8.2009122101
   * [Selection Links](https://addons.mozilla.org/firefox/addon/8644)と協調して動作するようにした
   * [Selection Links](https://addons.mozilla.org/firefox/addon/8644)との協調動作に伴って、選択範囲のリンクをタブで開く機能を廃止した
   * 「新しいタブ」ボタンの表示・非表示を切り替えるオプションを削除した（ `.tabs-newtab-button { visibility: collapse !important; }`  で代用可能なので）
   * タブバーを自動的に隠す設定の時の、タブバーの表示・非表示切り替え処理を高速化
   * タブバーをドラッグ＆ドロップしている間はプラグインによって描画される領域を隠すようにした（PDFなどを開いたタブが選択されている時にドラッグ＆ドロップでタブバーを移動できない問題への対処）
   * Firefox 3.0以降で標準機能の、リンク等をタブの上にドラッグしてしばらく待つとそのタブにフォーカスを移す機能が働かなくなっていたのを修正
   * [Jetpack](https://jetpack.mozillalabs.com/)が入っている環境でタブバーを自動的に隠す設定を有効にしているとブラウズ領域が真っ白になってしまう問題を修正
   * JetpackのSlidebarのボタンなど、タブバー内に要素が追加されているとタブバーの背景の描画位置がずれる問題を修正
   * タブのツールチップで、子孫タブが無い時にまで頭に「*」が付いていたのを修正
   * タブのクローズボックスなどでタブを閉じる時にツリー全体が閉じられようとしている場合、複数のタブを閉じてよいかどうかの確認を表示するようにした
   * ツリー全体を閉じることでウィンドウも同時に閉じられる場合に、最後に表示していたセッションが保存されていなかったのを修正
   * 1つのブックマークフォルダの中に2つ以上の親タブが存在しており、すべての親タブが1つ以上の子を持っている場合、ダミーの親タブを開かないようにした（ `extensions.treestyletab.openGroupBookmark.behavior` の値に1024を足すことで以前の挙動に戻すことも可能）
   * [Session Manager](https://addons.mozilla.org/firefox/addon/2324) 0.6.7でセッションプロンプトを表示する設定にして、セッションリストアをキャンセルした場合に、ウインドウサイズがタイトルバーだけになる不具合を修正（[patched by Alice0775](http://piro.sakura.ne.jp/cgi-bin/bbs.cgi?2565)）
   * [Session Manager](https://addons.mozilla.org/firefox/addon/2324)でのセッション復元時に、すべてのツリーが常に展開された状態になっていたのを修正
   * [Session Manager](https://addons.mozilla.org/firefox/addon/2324)でのセッション復元時に、折りたたまれたツリーがあるとセッション復元に失敗する場合があったのを修正
   * 隠し設定 `extensions.treestyletab.compatibility.TMP` で、ツリー型タブ側のTab Mix Plus用コードを全面的に無効化できるようにした
   * Tab Mix Plusが入っていると、タブバーを上に置いていた場合にタブをドラッグ＆ドロップできない問題を修正
   * Tab Mix Plus内臓のセッションマネージャを使っているとツリー構造が復元されない問題に対処
   * 他のアドオンから利用できる新しいAPIを追加した：     *  `gBrowser.treeStyleTab.partAllChildren(aTab)` 
     *  `TreeStyleTabService.currentTabbarPosition` 
     *  `TreeStyleTabService.treeViewEnabled` 
     *  `TreeStyleTabService.promoteTab(aTab)` 
     *  `TreeStyleTabService.promoteCurrentTab()` 
     *  `TreeStyleTabService.demoteTab(aTab)` 
     *  `TreeStyleTabService.demoteCurrentTab()` 
   * タブバーを自動的に隠す設定の時、tabbrowser要素の `treestyletab-tabbar-autohide-state` 属性の値として現在のタブバーの状態を保持するようにした
   * pl-PLロケール更新（by Jacek Chrząszcz）
 - 0.8.2009102801
   * ツリーの親だったタブを開き直した時に、復元されたツリーがすぐ折りたたまれてしまう問題を修正
 - 0.8.2009102701
   * 選択範囲のリンクをまとめてタブで開く機能について、重複するリンクは除外するようにした
   * 設定パネル内のタブの選択状態を復元するようにした
   * [PermaTabs Mod](https://addons.mozilla.org/firefox/addon/7816)で復元されたタブのツリー構造を復元するようにした
   * スキーマ部分を省略したURI文字列をロケーションバーに入力した場合、ドメインの判別に失敗していたのを修正
   * 親のタブを閉じて最初の子タブが新しい親になった時、ツリーが折りたたまれてしまう事があったのを修正
   * 最後の子タブを閉じた後に閉じたタブを開き直すと、復元されたツリーが折りたたまれてしまっていたのを修正
   * タブのツリーを折りたためない設定の時、子タブにフォーカスが移らなくなる事があったのを修正
   * タブバー内でタブ以外がドラッグされていた時にエラーが発生していたのを修正
   * Trunkでのタブの円グラフ型プログレスアイコンに対応
   * zh-CNロケール更新（by hzhbest）
   * de-DEロケール更新（by Andy Pillip）
 - 0.8.2009100101
   * セッション復元時にツリー構造やタブの順番が崩れる問題について改善
 - 0.8.2009093001
   * 展開されたサブツリーへ子タブを追加した場合は、他のサブツリーを自動的に閉じないようにした
   * セッション復元時にツリー構造やタブの順番が崩れる問題について改善
   * リンクをCtrl/Command-左クリックした時、browser.tabs.loadDivertedInBackgroundではなくbrowser.tabs.loadInBackgroundの設定に従うようにした
   * Google Toolbar Sidewikiとの競合を解消
 - 0.8.2009090901
   * Firefox 3.5以降で、親のタブと同時に子孫のタブもすべて閉じる設定の時、最後のタブを閉じた後に空のタブが2つ開かれる問題を修正
   * Firefox 3.5以降で、タブバーのスプリッタ上のgrippyをクリックすると正しくタブバーの幅・高さがトグルしない問題を修正
   * ページ内のスクリプト等によってscrollイベントが頻繁に発行されるWebページにおいて、必要のない場合にまで再描画が行われるために極端にCPUを占有してしまっていたのを修正
   * リンクの左クリックによって自動的に開かれたタブについて、browser.tabs.loadDivertedInBackgroundの設定を反映するようにした
   * アンインストールされた際に、Firefox本体の隠し設定を変更した箇所を元に戻すようにした
 - 0.8.2009090403
   * タブバーのドラッグ操作を目立たないようにした（フィードバックイメージを表示しないようにし、現在の位置から他の位置に移動しそうになった時にだけ表示を切り替えるようにした）
   * タブバーのスプリッタ付近ではタブバーのドラッグ操作を無効にするようにした（無視する範囲の広さは `extensions.treestyletab.tabbar.fixed.insensitiveArea` で変更可能）
   * [Snap Links Plus](http://snaplinks.mozdev.org/)で開かれたタブを現在のタブの子にするようにした
   * タブバーを自動的に隠す設定が無効になっている時にまでタブが半透明で表示されていたのを修正
 - 0.8.2009090402
   * Firefox 3.0.xでタブバーの透明度の設定UIが正しく動作していなかったのを修正
   * スクロールバーやポップアップメニュー上でのドラッグ操作でまでタブバーが移動されていたのを修正
   * タブバーのリサイズを終了した後、背景が描画されないままになっていたのを修正
   * [Drag &amp; Drop.io](https://addons.mozilla.org/firefox/addon/8482)との競合を解消
   * 中国語ロケール更新 by hzhbest
 - 0.8.2009090201
   * タブバーのドラッグ＆ドロップでタブバーの位置を変更できるようにした（Shift-ドラッグで、タブバーが固定されていても強制的に移動する）
   * タブのフォーカス移動でツリーの自動開閉を行う設定の時、Ctrl-Tabでのフォーカス移動に際しては、Ctrlキーを放したタイミングで初めてツリーの開閉を制御するようにした（以前の挙動に戻す場合は `extensions.treestyletab.autoCollapseExpandSubTreeOnSelect.whileFocusMovingByShortcut` を `true` に設定する）
   * 設定ダイアログの構成を変更
   * タブのコンテキストメニューから、タブバーの位置を変更する項目を削除
   * セッション復元時に現在のタブの前後のタブの並びが崩れる問題について改善
   * ウィンドウをまたいだタブの移動で、折りたたまれたタブが正しく移動されない問題を修正
   * 折りたたまれたツリーの中のタブがフォーカスされた時、設定の如何に関わらず他のツリーが自動的に折りたたまれていなかったのを修正
   * タブバーを下に置いた時、スプリッタの位置がおかしくなる問題を修正
   * Tab Mix Plusで現在のタブの次の位置に新しいタブを開く設定の時、ブックマーク等から開いたタブの位置がおかしくなっていたのを修正
   * 中国語ロケール更新 by hzhbest
   * 台湾中国語ロケール更新 by Tsprajna
 - 0.8.2009081101
   * タブのツールチップにツリーの内容を表示しない設定を追加
   * 履歴サイドバーパネルから複数の項目を一度に開く時も、ブックマークフォルダをタブで開く場合と同じ挙動になるようにした
   * ブックマークのプロパティでタブの親子関係をより自由に変更できるようにした
   * スターアイコンによるブックマークの登録用パネルが正常に機能しなくなっていたのを修正
   * ドラッグ＆ドロップされたツリーの構造が崩れることがあったのを修正
   * テーマによってタブバーの幅が異常に狭くなってしまうことがあったのを修正
   * Firefox 3.0.xでフォルダ内のブックマークを開けなくなっていたのを修正
   * フルスクリーンモードで、ツールバーを自動で隠さない設定の時はタブバーを自動で隠さないようにした（フルスクリーンモードで常にタブバーが自動で隠れていたのを修正）
   * セッション復元時にタブの並び順が変わってしまうことがあったのを修正（0.8.2009073101での後退バグ）
   * ブックマークのプロパティの初期化処理が何度も走っていたのを修正
   * ブックマークのツリー構造を復元しない設定を可能にした（extensions.treestyletab.openGroupBookmark.behaviorの値に512を足すとツリー構造を復元しない）
   * ドイツ語ロケール更新 by Andy Pillip
   * 中国語ロケール更新 by hzhbest
 - 0.8.2009073102
   * ブックマークのプロパティが機能しなくなっていたのを修正（0.8.2009073101での後退バグ）
 - 0.8.2009073101
   * Firefox 2系列のサポートを終了
   * ツリーの親を閉じる時に最初の子を新しい親にする設定の時でも、閉じようとしているタブの他の同階層のタブが無い場合は、最初の子を新しい親にしないようにした
   * 特定のツリーやすべてのタブをブックマークする時、ツリーの構造もブックマークに保存しておき、タブとしてまとめて開く際にツリー構造を復元するようにした
   * ツリーをまとめてブックマークする時は、親のタブの名前をフォルダ名のデフォルト値にするようにした
   * ブックマークと履歴の管理ウィンドウにおいて、選択した項目をまとめてタブで開く時に、ツリー型タブによる制御が行われていなかったのを修正
   * サブツリーが折りたたまれたタブのツールチップで、折りたたまれた物も含めたツリー全体の内容を表示するようにした
   * タブにリンクをドロップした時とブックマークフォルダをタブで開く時の挙動について、機能を実行した時にダイアログから動作を選べるようにした
   * 現在のタブを閉じた後に、期待されている物と異なるタブがフォーカスされてしまうことがあった問題を修正
   * Tab Mix Plusがある時、ブックマークの保存に失敗する問題を修正
   * Tab Mix Plusがある時、タブバーの位置を変更するとタブの表示がおかしくなる問題を修正
 - 0.7.2009072401
   * マルチプルタブハンドラとの連携時に、選択したタブをひとつのツリーにまとめる機能を追加
   * ツリーの子が存在しなくなる時は常に、ダミーの親タブを自動で閉じるようにした
   * twistyのスタイル「auto」を、情報化タブのサムネイル表示が有効で且つラベルの横に挿入する設定の時は常にretro扱いにするようにした
   * 「新しいタブ」「タブの一覧表示」の各ボタンを表示するかどうかのチェックボックスの状態を、タブバーの横置き・縦置きのそれぞれで保持するようにした
   * 現在のタブを閉じた時、前の兄弟タブではなく、直前の折りたたまれていないタブにフォーカスを移すようにした（挙動の仕様変更）
   * Firefox 3.5正式版で、タブをドロップした時の処理が一部正常に働いていなかったのを修正
   * タブバーを縦置きしている時に、コンテンツ領域へのタブのドロップでウィンドウを分割できない問題を修正
   * タブバーの縦横を切り替えた時、タブがあふれているかどうかの状態が更新さていなかったのを修正
   * [Focus Last Selected Tab 0.9.5.x](http://www.gozer.org/mozilla/extensions/)と同時に利用できるようにした
   * Tab Mix Plusで、現在のタブを閉じた後に常に右のタブにフォーカスする設定の時も、ツリー型タブ自身による処理を優先するようにした
   * ドイツ語ロケール更新（by Andy Pillip）
 - 0.7.2009071001
   * 上または下に置いたタブバーの高さを自由に変更できるようにした
   * ツリーのインデント、折りたたみの可否の設定をタブバーの横置き時と縦置き時とで別々に保存するようにした
   * ブックマークのフォルダからサブツリーを開く際のダミーのタブについて、自由に名前を変えられるようにした
   * タブのツリーをまとめてブックマークする時、親にあたるダミーのタブを保存対象から除外するようにした
   * タブのフォーカス移動によるツリーの自動展開機能について、現在のタブを閉じた後のフォーカス移動では自動展開を行わないようにする設定を追加
   * 折りたたまれたタブにフォーカスした時に、ツリーを展開するか親のタブにフォーカスを移すかを、隠し設定 `extensions.treestyletab.autoExpandSubTreeOnCollapsedChildFocused` で制御できるようにした
   * タブバーの縦横切り替え時にインデントが正しく更新されない場合があったのを修正
   * ツリーの子にあたるタブを選択した状態でセッションを保存した場合に、選択されたタブの位置がセッション復元時におかしくなる問題を修正
   * タブのコンテキストメニューのうちいくつかの項目が表示されなくなってしまっていたのを修正
   * Tab Mix Plusでタブを開く位置を現在のタブのすぐ次の位置に設定していると、ツリー構造が壊れる問題を修正
   * Tab Mix Plusがあると画面外のタブにフォーカスした時に自動的にスクロールしない問題を修正
   * マルチプルタブハンドラと組み合わせた時に、「このツリーをブックマーク」で二重にブックマークが作成されてしまう問題を修正
   * ロシア語ロケールを使用すると設定ダイアログが機能しなくなっていたのを修正
   * zh-CNロケール更新（by hzhbest）
   * zh-TWロケール更新（by Tsprajna）
 - 0.7.2009070701
   * タブのコンテキストメニューに「このツリーを再読み込み」「このタブの子タブをすべて再読み込み」を追加
   * 親のタブを閉じた時に最初の子を新しい親に昇格させる設定の時、現在のタブを閉じるとフォーカスが最初の子ではなく兄弟タブの方に移ってしまう問題を修正
   * プライベートブラウジングモードに入る時、折りたたまれたサブツリーがあるとモードの移行に失敗する問題を修正
   * 最後のタブを閉じた後、左（上）のタブにフォーカスを移す際は、必ず同じ階層のタブにフォーカスするようにした
   * Firefox 3.0で、ブックマークグループを開いた後にダミーのタブの最後の子を閉じると、すべてのタブが不正に閉じられてしまっていたのを修正
   * タブのコンテキストメニューに挿入されるメニュー項目の並びがおかしくなっていたのを修正
   * 台湾中国語ロケール更新（by Tsprajna）
   * ドイツ語ロケール更新（by Andy Pillip）
 - 0.7.2009062901
   * ツリーの親を閉じた時、最初の子タブを新しい親に昇格するようにした（設定で従来の挙動に戻すことも可能）
   * ブックマークフォルダの内容をタブのツリーとして開く時、最初の項目をツリーの親にする代わりに、ツリーの親にするためのダミーのタブを開くようにした
   * 複数のタブをまとめて閉じる時、閉じるタブの数を正しく表示するようにした
   * 横置き状態のタブバーについて、サブツリーの折りたたみが無効化された状態の時、タブのクローズボックスを押しにくくなっていたのを修正
   * 開発者向けの新しいイベントを追加：TreeStyleTabParted（タブがツリーから解放された時）、TreeStyleTabAutoHideStateChanging（自動開閉の状態が変化した時）
   * Firefox 3.5 on Mac OS XでタブのThrobberが表示されなくなる問題に対処
   * イタリア語ロケール更新（by Godai71）
   * ドイツ語ロケール更新（by Andy Pillip）
 - 0.7.2009051501
   * タブバーが自動的に開閉された後でタブのクローズボックスの表示・非表示が更新されない問題を修正
   * マルチプルタブハンドラが無い環境でコンテキストメニューの追加項目が表示されなくなっていたのを修正（0.7.2009051301での後退バグ）
   * タブの幅を変えた後に伸縮前後のタブ幅の自動調整が働かなくなっていたのを修正（0.7.2009051301での後退バグ）
   * ツールチップ等の展開が途中でキャンセルされた後に、他のポップアップメニューを開いて閉じるまでタブバーの自動開閉が働かなくなっていたのを修正（0.7.2009051301での後退バグ）
 - 0.7.2009051301
   * タブ自体の外観（インデントなど）とタブの内容とを別々に左右反転できるようにした
   * 上に置いたタブバーでインデント表示を有効にしている時の外観をプラットフォームごとに調整した
   * タブのコンテキストメニューに限らず、全てのポップアップメニューについて、表示中はタブバーの自動開閉を行わないようにした
   * 上または下に置いたタブバーでツリーの折りたたみを有効にしている場合、水平方向の折りたたみもアニメーションするようにした
   * クローズボックスの表示位置だけを変更する設定（ extensions.treestyletab.tabbar.invertClosebox ）を隠し設定として、Mac OS Xでのデフォルト設定を他のプラットフォームと同じに戻した
   * 上または下に置かれたタブのインデント幅を一定の範囲に収めるようにした
   * [TooManyTabs](https://addons.mozilla.org/firefox/addon/9429)がインストールされている場合は、厳密にtwistyの上でクリックした時以外はツリーの開閉を行わないようにした
   * 複数のタブを一括で閉じた後、インデントが崩れる問題を修正
   * タブの内容を左右反転している時、クローズボックスの表示・非表示が切り替わった後でタブの内容の並び順が壊れる問題を修正
   * 空のタブが1つだけあるときに、過去に閉じたタブを開き直すと、タブバーの上端にスペースが空いてしまう問題を修正
   * キーボードショートカットを実行してCtrlキーから指を放した後にタブバーが自動表示されてしまうことがあったのを修正
   * [情報化タブ](http://piro.sakura.ne.jp/xul/_informationaltab.html)でタブの中にサムネイルを表示している場合に、新しくタブを開いた時にタブバーの表示がおかしくなる問題を修正
 - 0.7.2009043002
   * Minefieldで動作しなくなっていたのを修正
 - 0.7.2009043001
   * [分割ブラウザ](http://piro.sakura.ne.jp/xul/_splitbrowser.html)で、他のペインが存在するときにメインのブラウズ領域の最後のタブを別のウィンドウに移動した場合、ウィンドウを閉じないようにした
 - 0.7.2009042803
   * URIでない文字列のロケーションバーへの入力が機能しなくなっていたのを修正（0.7.2009042801のregression）
 - 0.7.2009042802
   * localhostなどの特殊なホスト名の時に、同じサイトかどうかの判別でエラーが発生していたのを修正（0.7.2009042801のregression）
 - 0.7.2009042801
   * 同じサイトかどうかの判別にFirefox内蔵のEffective TLDリストを使うようにした（Firefox 3以降のみ）
   * タブのクローズボックスの位置だけを左に移せるようにした（Mac OS XではデフォルトでON）
   * サブツリーの折りたたみが無効なときや、子タブを持たないタブの場合は、アイコン上で発生したクリックイベントをキャンセルしないようにした
   * 子タブにフォーカスしたまま親タブのサブツリーを折りたたんだ時、親タブにフォーカスが移りつつサブツリーが折りたたまれるはずが、サブツリーが再び自動的に展開されてしまう問題を修正（0.7.2009040901のregression）
   * [Highlander](https://addons.mozilla.org/firefox/addon/4086)等一部のアドオンを併用しているときに、リンクから開いた新しいタブが子タブにならないことがある問題を修正
   * ブックマークフォルダの「タブですべて開く」で開かれたタブが設定通りにツリーにならない問題を修正
   * ブックマークの開き方の設定項目のうち、Firefoxのデフォルトの挙動の項目のラベルをFirefox 3の挙動に合わせて修正
   * トップレベルのタブとその子タブの間にタブが移動されたとき、自動でツリーに組み込まれない場合があったのを修正
   * [Chromifox Basic](https://addons.mozilla.org/firefox/addon/8782)との競合を解消
   * [FullerScreen 2.4](https://addons.mozilla.org/firefox/addon/4650)との競合を解消
   * [AutoHide 1.5.4](http://www.krickelkrackel.de/autohide/)との競合を解消
   * [Duplicate Tab 1.0.2](https://addons.mozilla.org/firefox/addon/28)との競合を解消
   * [QuickDrag 2.0.1](https://addons.mozilla.org/firefox/addon/6912)の仕様変更に追従
   * Tab Mix Plus 0.3.7.3との競合に一応対処
   * Tab Mix Plusの「強制的に新しいタブに開くリンクの種類」の設定で開かれたタブが子タブにならない問題を修正
   * zh-TWロケール修正
   * pl-PLロケール更新（by Andrzej Pasterczyk）
 - 0.7.2009042301
   * 子孫タブを持つ子タブを閉じた時に、インデントが崩れたりメモリリークが発生したりしていたのを修正（0.7.2009042101のregression）
 - 0.7.2009042101
   * 「タブの一覧表示」ボタンの表示/非表示を制御するチェックボックスを常に表示するようにした
   * Firefox 3.5用の「新しいタブ」ボタンの表示/非表示を制御するチェックボックスは、それ以前のバージョンでは表示しないようにした
   * 設定パネルでタブバーの位置を縦と横の間で切り替える時だけチェックボックスのチェック状態をリセットするようにした
   * タブを折りたためない設定の時は、タブの折りたたみのアニメーション効果を無効にするようにした
   * タブバーが上または下にあるとき、twistyの開閉表示を反転するようにした（Modern系のみ）
   * アニメーション効果の開始タイミングを変更
   * 親タブを閉じた後にその子タブを閉じられたタブの階層に挿入する設定の時、親タブである現在のタブを閉じると、最初の子ではない別のタブにフォーカスが移ってしまっていたのを修正（0.7.2009040901のregression）
   * 「自動で隠す」が有効な時、タブバーの幅を変えられなくなっていたのを修正（いつの頃からかのregression）
   * 折りたたまれた状態のタブバーの幅を、展開された状態よりも広くできるようになってしまっていたのを修正（いつの頃からかのregression）
   * 現在のタブを閉じた後、閉じられたサブツリーを持つ子タブにフォーカスが移るとき、フォーカスされるべきタブが見えなくなってしまうことがある問題を修正
   * 上に置いたタブをインデント表示する設定において、タブをポイントした時にタブの高さが変わらないようにした
   * タブの幅に関する設定の変更を即座にGUIに反映するようにした
   * APIとして `TreeStyleTabService.setTabbarWidth()` と `TreeStyleTabService.setContentWidth()` を追加
   * it-ITロケール更新（by Godai71）
   * de-DEロケール更新（by Andy Pillip）
 - 0.7.2009040901
   * ツリーの折りたたみ等をアニメーション表示するようにした
   * ツリーの親を閉じた時の挙動について、常に全ての子孫タブを閉じる設定を追加した
   * タブのドラッグ時にタブバーを自動スクロールするようにした
   * タブバー上の「タブを閉じる」ボタンのクリックでタブが2つ閉じられるようになってしまっていたのを修正
   * ツリーの複製やウィンドウをまたいだツリーの移動でタブの並び順が壊れるようになってしまっていたのを修正
   * 右や下に置かれたタブバーの自動開閉に失敗するようになっていたのを修正
   * pl-PLロケール追加（by Andrzej Pasterczyk）
 - 0.7.2009040201
   * Minefieldで動作しなくなっていたのを修正
   * タブバーを自動開閉する状態の時、全画面Flash等のページでもポインタの移動に反応できるようにした
   * タブバーを自動開閉する状態の時、タブ切り替えのショートカットで表示されたタブバーの上にポインタが移動した場合は、キーを放した後もタブバーを表示したままにするようにした
   * フルスクリーンモードにおいて、タブ切り替えのショートカットでタブバーが自動表示されない問題を修正
   * タブバーにpaddingが設定されているテーマで、タブバーの自動開閉でタブバーの幅が無限に広がる問題を修正
   * フルスクリーンモードに切り替えた時に、タブバーの幅が小さくなってしまう問題を修正
   * フルスクリーンを解除した時に再描画がかかっていない状態になる場合があったのを修正
   * インストール後の初回起動時に、以前から開かれていたタブに対して子タブを追加できない問題を修正
   * タブバーの「新しいタブ」ボタンが機能しなくなっていたのを修正
 - 0.7.2009032801
   * 「Vertigo」スタイルがFirefox 3.0以前の環境で壊れていたのを修正
 - 0.7.2009032701
   * 「Mixed」スタイルのタブの外観をアップデートした
   * [Mouseless Browsing](https://addons.mozilla.org/firefox/addon/879)でリンクを開けなくなっていたのを修正
   * タブのドラッグ＆ドロップ時にツールチップ上にタブをドロップしてしまうトラブルを避けるため、タブのドラッグ中は強制的にツールチップを閉じるようにした
 - 0.7.2009032502
   * Metalでタブのアイコンの背景画像をアニメーションさせるようにした（Firefox 3以降）
 - 0.7.2009032501
   * 新スタイル「Metal」を追加し、Mac OS Xでのデフォルト設定とした
   * Linux、Mac OS Xでタブの影がおかしかったのを修正
   * テーマによってはタブバーの自動開閉で無限に再描画が発生する問題を修正
   * 他のウィンドウからツリーごとドロップしたタブのツリー構造が失われる問題を修正
   * タブの折りたたみ状態の変化に応じてTreeStyleTabCollapsedStateChangeイベントを発行するようにした
   * ドイツ語ロケール更新（by Andy Pillip）
 - 0.7.2009031701
   * [QuickDrag](https://addons.mozilla.org/firefox/addon/6912)、[Linky](https://addons.mozilla.org/firefox/addon/425)、[Mouseless Browsing](https://addons.mozilla.org/firefox/addon/879)、[Snap Links](https://addons.mozilla.org/firefox/addon/4336)と連係して動作するようにした
   * 子タブの挿入位置をサブツリーの最初の位置にしている時は、タブの上にタブをドロップした時の動作もその設定に従うようにした
   * タブのクローズボックスをタブバーだけに表示する設定の時、クローズボックスが機能しなくなる問題を修正
   * タブの上にタブをドロップした時の挙動が全体的にバグってたのを修正
   * タブバーに表示されたタブのクローズボックスの表示スタイルを、他のボタンに合わせるようにした
   * Tab Mix Plusの「新しいタブ」ボタンの外観を他のボタンに合わせるようにした
   * Tab Mix Plusがインストールされている環境では画面外のタブにフォーカスした時に自動的にスクロールしない問題を修正
   * イタリア語ロケール更新(by Godai71)
 - 0.7.2009030901
   * Firefox 3.5以降ではツリー表示されたタブに影を表示するようにした
   * 親タブの直後に子タブをドロップした場合、ドロップされたタブを親タブの兄弟にするようにした
   * タブの上にタブをドロップした場合、常に最後の子タブとして追加するようにした
   * Shiretoko 3.1b4preで縦置きされたタブバーの内容が溢れても「新しいタブ」ボタンの表示が切り替わらなくなっていたのを修正
   * Ctrl-Tab等でのタブのフォーカス移動について、最初のタブと最後のタブの間でループしなくなっていたのを修正
 - 0.7.2009021201
   * Firefox 3.1b3pre対応
   * SVG要素のXLinkなど、標準ではリンクとしては無視されるはずの物がリンクとして読み込まれていたのを修正
   * 親のタブを閉じた時、最初の子タブではなく最後の子タブにフォーカスが移ることがあったのを修正
   * 選択範囲のリンクをタブで開く機能について、分割された複数の選択範囲に対応した
 - 0.7.2008122801
   * タブバー上のボタンを操作できなくなっていたのを修正
   * ルーマニア語ロケール追加（by L'Autour）
 - 0.7.2008120401
   * [Tab History](https://addons.mozilla.org/firefox/addon/1859)との競合を解消したつもり
   * [Aging Tabs](https://addons.mozilla.org/firefox/addon/3542)との競合を解消
   * Shiretoko 3.1b3preでファイルやリンクなどをタブやタブバーの上にドロップしても正常に処理されなくなっていたのを修正
   * タブのインデント部分のクリックをタブのクリックと見なし、フルスクリーン表示で画面端でのクリックでもタブを選択できるようにした（旧来の動作に戻したい場合は extensions.treestyletab.clickOnIndentSpaces.enabled を  `false`  に設定してください）
 - 0.7.2008120201
   * Minefield 3.1b3preでタブをドラッグ＆ドロップで移動できなくなっていたのを修正
   * Minefield 3.1b3preでリンクのドラッグ＆ドロップで新規タブを開けなくなっていたのを修正
   * Minefield 3.1b3preでタブをウィンドウ外にドロップした時にサブツリーを別ウィンドウに切り離せるようにした
   * Minefield 3.1b3preの「新しいタブを開く」ボタンを隠す設定を追加
   * 「タブの一覧表示」ボタンを隠す設定がMinefield 3.1b3preで効いていなかったのを修正
   * [SBMカウンタ](http://miniturbo.org/)で開かれるタブを子タブにするようにした
   * [マルチプルタブハンドラ](http://piro.sakura.ne.jp/xul/_multipletab.html)でタブ選択時のメニューのセパレータの表示・非表示が更新されなくなる問題を修正
 - 0.7.2008110801
   * 最大化状態でFirefoxを終了して次に起動した時に、ウィンドウの最大化が解除されてしまう問題を修正
 - 0.7.2008110701
   * タブをタブバーの空き領域にドロップできなくなっていたのを修正
   * Minefield 3.1b2preで動作しなくなっていたのを修正
   * スペイン語ロケール更新（by tito）
   * イタリア語ロケール更新（by Godai71）
   * ドイツ語ロケール更新（by Andy Pillip）
 - 0.7.2008101801
   * Minefield 3.1b2preで、ウィンドウ間でタブを移動する時に、内容の再読み込み無しでタブを移動するようにした
   * Tab Mix Plusがインストールされているとタブのサブツリーをブックマークできなくなる問題を修正
 - 0.7.2008101502
   * Minefield 3.1b2preでタブバーを自動開閉する時に画面がちらつく問題を修正
   * [LastTab](https://addons.mozilla.org/firefox/addon/112)との競合を解消
 - 0.7.2008101501
   * Minefield 3.1b2preで動作するようにした
   * サブツリーをまとめてブックマークする機能を追加
   * タブバーの幅を変えた後にインデント幅を自動調整するようにした
   * [Menu Edit](https://addons.mozilla.org/firefox/addon/710)で項目が無限増殖する問題に対処
   * [Link Widgets](https://addons.mozilla.org/firefox/addon/2933)などとの競合を解消
   * [FireGestures](https://addons.mozilla.org/firefox/addon/6366)の仕様変更に追従
   * フルスクリーン表示を解除した後にタブのインデントが0のままになる問題を修正
   * タブバーを自動で隠す設定を解除した後、ブラウザ領域がズレたままになってしまうことがある問題に対処
   * 全てのリンクや外部リンクをタブで開く機能が働かなくなっていたのを修正
   * 2つめ以降のウィンドウでcanvasの初期化に失敗していたのを修正
   * 選択されているタブの直接の親でない上位のタブのサブツリーを折りたたむ時、直接の親のサブツリーが折りたたまれずに残ってしまう問題を修正
   * 複数タブを閉じる時の警告に出る、閉じるタブの個数を正しい数にした
   * [Session Manager](https://addons.mozilla.org/firefox/addon/2324)と組み合わせて利用する時に、前回終了時の選択されていたタブのツリー構造が次回起動時のセッション復元で失われる問題を修正
   * ドイツ語ロケール更新
   * イタリア語ロケール更新
 - 0.7.2008062001
   * Tab Mix Plusのセッション保存機能に対応
   * Tab Mix Plusとの組み合わせ時に左右に置いたタブバーでタブがスクロールアウトされているかどうか正しく判別されない問題を修正（extensions.treestyletab.TMP.doNotUpdate.isTabVisibleを `true` にすると旧版の挙動に戻ります）
   * 縦置きされたタブバーでタブを閉じた時にスクロール位置が意図せず失われてしまう問題に対処
 - 0.7.2008061901
   * テーマ標準のタブの外観をそのまま使えるようにした
   * タブのスタイル指定を若干変更した
   * Greasemonkey 0.8以降の変更に追従
   * タブバーの幅を縮めるモードにおいて、キーボード操作などによる自動展開が機能していなかったのを修正
   * タブを右か左に置いた時、タブを閉じた後にタブバーが常に一番上までスクロールしたままになる問題に対処
   * マルチプルタブハンドラと同時に使用した時にタブのコンテキストメニューが壊れる問題を修正
 - 0.7.2008061701
   * 自動でタブバーを隠す機能について、完全にタブバーを隠すのではなく、幅を縮めた状態で表示しておくモードを加えた（inspired from Zusukar's patch）
   * Firefox 3のフルズームに対応
   * Firefox 3のフルスクリーン表示との連携を強化
 - 0.6.2008061601
   * Mac OS XでもFirefox 3ではドラッグ中にツリーを展開するようにした
   * Mac OS Xでの外観を修正
 - 0.6.2008050601
   * 台湾中国語ロケール追加（by HkYtrewq）
 - 0.6.2008050101
   * タブバーを自動で隠す時の挙動を細かく設定できるようにした
   * スクロールバーの操作中はタブバーの自動開閉を行わないようにした
   * GreasemonkeyのGM_openInTab関数で開いたタブを現在のタブの子にするようにした
   * Linux上のMinefieldで設定ダイアログの表示がおかしくなる問題を修正
   * タブを開き直した時にツリー構造が壊れることがあったのを修正
   * Tab Mix Plusをインストールした状態でブックマークグループを開くと常にツリー化されていたのを修正
   * Firefox 3の仕様変更に追従
   * ドイツ語ロケール追加（by Andy Pillip）
 - 0.6.2008031101
   * キーボードショートカットを使った直後などにタブバーが表示されてしまう問題を修正
   * タブバー部分を完全な透明ではなく半透明にするようにした
   * 中国語ロケール更新
 - 0.6.2008030904
   * タブバーを自動で隠す機能がMinefieldで機能しなくなっていたのを修正
 - 0.6.2008030903
   * タブバーを自動で隠す設定の時、左右または下に置いたタブバーを透過表示するようにした
 - 0.6.2008030902
   * Ctrlキーの長押しがLinuxで機能していなかったのを修正
   * 起動時に初期化されていないcanvasが表示されてしまう場合があったのを修正
 - 0.6.2008030901
   * タブバーを自動で隠す機能について、自動表示する場面を細かく設定できるようにした
   * タブバーを自動的に表示する時の画面のちらつきを軽減
   * [FireGestures](https://addons.mozilla.org/firefox/addon/6366)で開かれるタブをツリーの子にするようにした
   * スペイン語ロケール追加（by tito, Thanks!）
   * Minefield 3.0b5preでの動作を確認
 - 0.5.2008030303
   * アップデートする度に一部の設定が初期化されてしまう問題を修正
   * ウィンドウ右側に置いて表示を左右反転したタブのクローズボックスの位置がおかしくなる問題を修正
 - 0.5.2008030302
   * [All-in-One Sidebar](https://addons.mozilla.org/firefox/addon/1027)で隠し設定 `extensions.aios.tbx.tabbar` によって利用できるタブバー左右のツールバーに対応（タブバーを縦置きした場合、タブバーの上下にこれらのツールバーが表示されるようにした）
 - 0.5.2008030301
   * ツリーのつまみの表示スタイルに「自動」を追加し、デフォルト設定とした
   * Tab Mix Plus 0.3.6.1の変更に追従
   * Firefox 3とTab Mix Plusの組み合わせに対応
   * [FLST](https://addons.mozilla.org/firefox/addon/32)、[Tabbrowser Preferences](https://addons.mozilla.org/firefox/addon/158)との競合を解消
   * 中国語ロケール追加（by [Fatiaomao](http://fatiaomao.yo2.cn/), Thanks!）
 - 0.5.2008022901
   * ツリーのつまみの表示スタイルを変えられるようにした
 - 0.5.2008022801
   * [ColorfulTabs](https://addons.mozilla.org/firefox/addon/1368)を導入している場合、子供のタブは親のタブの色を継承するようにした
   * [Super DragAndGo](https://addons.mozilla.org/firefox/addon/137)、[Drag de Go](https://addons.mozilla.org/firefox/addon/2918)でページ内のドラッグ＆ドロップにより開かれる新規タブを現在のタブの子にするようにした
   * リンクから開かれたタブなどを自動的に子タブにする機能をすべて無効化する隠し設定 `extensions.treestyletab.autoAttachNewTabsAsChildren` を追加（それらの操作を無効化したい場合は `false` に値を変更する）
 - 0.5.2008022702
   * Firefox 3でブックマークグループを開くときの挙動を制御できていなかったのを修正
   * ロケーションバーからの入力でタブを開く機能などが動かなくなっていたのを修正（0.5.2008022701での後退バグの修正）
 - 0.5.2008022701
   * タブバー上でのコンテキストメニューから、タブバーの表示位置をダイナミックに変更できるようにした
   * [Highlander](https://addons.mozilla.org/firefox/addon/4086)、[PermaTabs](https://addons.mozilla.org/ja/firefox/addon/2558)との競合を解消したつもり
   * イタリア語ロケール更新（by Godai71.Extenzilla）
 - 0.5.2008022501
   * 英語ロケールのミスを修正
   * 「タブバーを固定」の状態が次回起動時に復元されない問題を修正
 - 0.5.2008022402
   * Firefox 3において、異なるウィンドウをまたいだドラッグ＆ドロップによるツリーの移動に対応した
 - 0.5.2008022401
   * [マルチプルタブハンドラ](http://piro.sakura.ne.jp/xul/_multipletab.html)による複数タブのドラッグ操作に対応
   * Firefox 3でタブのドロップ時の処理が正しく動いていなかったのを修正
 - 0.5.2008022301
   * ロケーションバーから自動的にタブを開く機能について、異なるドメインの時も子タブとして開くオプションを追加
   * タブバーの幅を固定してスプリッタを非表示にする機能を追加
   * iFoxなどのいくつかのテーマとの互換性を向上した
   * タブバーでのダブルクリック操作が機能しない問題を修正
 - 0.5.2008022201
   * Firefox 3 beta3対応
   * ブックマークサイドバーから開いたタブがツリーにならない問題を修正
   * タブバーの自動開閉の詳細設定のUIを加えた
   * Tab Mix Plusのタブバー多段表示機能と組み合わせた際の挙動を改善
 - 0.5.2007120101
   * ツリーの開閉ボタンをポイントした時、ツールチップやアイコンの変化でフィードバックを行うようにした
 - 0.5.2007113001
   * 最後のツリーが選択され、且つ子孫が折りたたまれている状態で、そのタブを閉じた時に、何もタブが選択されていない状態になってしまっていたのを修正
 - 0.5.2007112801
   * 「このタブの子タブをすべて閉じる」機能、「このサブツリーを閉じる」の中クリックで「このタブの子タブをすべて閉じる」の動作をする機能をタブのコンテキストメニューに加えた
   * サブツリーの中から他のサブツリーの中へタブをドラッグ＆ドロップで移動した時、タブが折りたたまれたままになってしまっていたのを修正
   * タブの移動、親子関係の復元などに関する内部処理を色々書き直した
   * イタリア語ロケール更新（by Godai71.Extenzilla）
 - 0.5.2007112401
   * セッション復元時にツリーが壊れることがあったのを修正
   * 親となるタブを復元していない状態で子孫のタブだけを復元するとツリーが壊れることがあったのを修正
   * ブックマークグループをサブツリーとして開く設定の時、最後のタブが空だとサブツリーが正しく形成されない問題を修正
   * 何かのはずみでツリーのインデント幅が極端に小さくなってしまうことがあったのを修正
   * サブツリーの親を子孫のタブの上にドラッグした時にドロップ禁止の状態にならなくなっていたのを修正
 - 0.5.2007111801
   * タブへのドラッグ＆ドロップ時に、サブツリーが折りたたまれたタブの上でしばらく待ったらサブツリーを展開するようにした
   * 「サブツリーを閉じる」「サブツリーをすべてたたむ」「サブツリーをすべて展開する」が機能しなくなっていたのを修正
 - 0.5.2007111702
   * [マルチプルタブハンドラ](http://piro.sakura.ne.jp/xul/_multipletab.html)などによる、Firefox 2のセッション保存APIを使ったタブの複製でツリーが壊れる問題を修正
 - 0.5.2007111701
   * 「ツリーをすべてたたむ」「ツリーをすべて展開する」をタブのコンテキストメニューに加えた
   * 「タブの一覧を表示」のポップアップの内容を、タブのツリーに合わせてインデント表示するようにした
   * イタリア語ロケール更新
 - 0.5.2007111502
   * キーボードショートカットなどで前後のタブにフォーカスを移動できなくなっていたのを修正
   * Tab Mix Plusと併用した時にtarget属性が指定されたリンクが新しいタブと現在のタブの両方で読み込まれてしまう問題に対処
   * 開き直されたタブのインデントがおかしくなることがあったのを修正
   * 開き直された親タブにおいて、折りたたまれた子孫タブの数の表示がおかしくなることがあったのを修正
 - 0.5.2007111501
   * Tab Mix Plus、[分割ブラウザ](http://piro.sakura.ne.jp/xul/_splitbrowser.html)と組み合わせた際の連携を改善
   * すべてのタブが一つのサブツリーになっている時、そのツリー全体をまとめて閉じようとするとエラーになる問題を修正
   * 初期化前のタブが移動された時にツリーが壊れることがあったのを修正
 - 0.4.2007111302
   * Tab Mix Plusと組み合わせて利用するとタブを開く際にツリーが壊れることがある問題について改善
 - 0.4.2007111301
   * 子タブがあるタブを閉じた時に、見えないタブが残ってしまうことがあった問題を修正
   * Tab Mix Plusと組み合わせて利用できるようにした（左右にタブバーを表示するモード以外の動作は未検証、まだまだバグ多し）
 - 0.4.2007111001
   * 縦置きしたタブバーを自動で隠す機能を加えた
   * Minefieldでタブバーのスプリッタ中央のグリッピーをクリックした時にタブバーを開閉するようにした
   * 縦置きされたタブバーにおいて「タブの一覧を表示」ボタンの表示・非表示を設定できるようにした
   * Firefox 3以降ではタブバーのスクロールバーを左端に表示する機能を無効にした（動作しないので）
 - 0.3.2007110701
   * タブバーの表示位置を動的に変更できなくなっていたのを修正
   * タブのアイコンの表示位置がおかしくなっていたのを修正
 - 0.3.2007110601
   * 左に縦置きしたタブバーのスクロールバーを左端に表示する設定の時、タブバーが最初のタブの内容領域にはみ出てしまう問題に対処
   * ウィンドウ右でのタブの内容の反転表示の方法を変えた
   * イタリア語ロケール追加（by Godai71.Extenzilla）
 - 0.3.2007110501
   * タブバーのスクロールバーを左端に表示する設定の時、スクロールバーが表示されているとタブのクローズボックスをクリックできなくなる問題に対処
 - 0.3.2007103102
   * 新しい子タブを開く時、サブツリーの最初の子タブとして挿入するか、サブツリーの最後の子タブとして追加するかを設定できるようにした
 - 0.3.2007103101
   * [ImgLikeOpera](https://addons.mozilla.org/firefox/addon/1672)との衝突を解消
   * [マルチプルタブハンドラ](http://piro.sakura.ne.jp/xul/_multipletab.html)で選択したタブに対するポップアップメニューの初期化に失敗する問題を修正
 - 0.3.2007103002
   * タブのコンテキストメニューの「このサブツリーを閉じる」を、マルチプルタブハンドラ無しでも追加するようにした
   * Mac OS X上のFirefoxで左右に表示したタブの表示が崩れる問題を修正
 - 0.3.2007103001
   * リンクやロケーションバーからの入力に対して自動的に新しいタブを開く機能について、CtrlキーやAltキーなど通常の「タブで開く」モディファイアキーが入力されている時は動作を反転するようにした
   * サブツリーの中の最初の子タブを閉じたときに、フォーカスするべきでないタブにフォーカスを移してしまっていたのを修正
 - 0.3.2007102904
   * タブを閉じた時、親タブの子タブ一覧からそのタブが削除されないことがある問題を修正
 - 0.3.2007102903
   * リンク先が javascript: となっているリンクをクリックした時に空のタブが開かれてしまう問題を修正
 - 0.3.2007102902
   * javascript: なリンクをクリックした時に空のタブが開かれてしまう問題を修正
 - 0.3.2007102901
   * 他のサイトへのリンクまたはすべてのリンクを常にタブで開く機能を追加
   * ロケーションバーからの入力に対して新しいタブを開く機能について、判別が不完全だったのを修正
 - 0.3.2007102701
   * ロケーションバーへの入力からタブを自動的に開く機能を追加（同じドメインのページは新しい子タブ、違うドメインのページは新しいタブ）
   * [Session Manager](https://addons.mozilla.org/firefox/addon/2324)などでのセッション保存APIを用いたセッションの保存時に、タブのツリーの状態が完全には保存されていなかったのを修正
   * moveTabToメソッドで直接タブの位置を動かされた時に、自動的にタブの親子関係を調整するようにした
 - 0.2.2007102602
   * サブツリーが折りたたまれていないタブにまで子孫タブの数が表示されてしまっていたのを修正
 - 0.2.2007102601
   * タブバーを上または下に表示する時は、サブツリー同士の間にスペースを空けてサブツリーを判別しやすいようにした
   * タブバーを上または下に表示する時は、タブのインデント表示とサブツリーの折りたたみを初期状態で無効にするようにした
 - 0.2.2007102501
   * タブバーをウィンドウ上部やウィンドウ下部に表示できるようにした
 - 0.1.2007102401
   * コンテキストメニューの「画像を表示」「背景画像を表示」「辞書を追加」（スペルチェック辞書用の機能）、フィードの購読機能、「ホーム」ボタンの中クリックの際に複数のタブを開く場合について、現在のタブの子として開くようにした
   * [LDR](http://reader.livedoor.com/)のようにタブバーのスクロールバーを左端に表示するようにした
 - 0.1.2007102301
   * サブツリーの自動開閉の判断基準を変更
 - 0.1.2007102204
   * 選択範囲のリンクを子タブとして開く機能を追加
   * タブバーを右に表示する際に、UIの左右反転を無効にできるようにした
 - 0.1.2007102203
   * Minefieldにおいて、ブックマークのフォルダをタブで開く時の挙動を制御できるようにした
   *  `tabbrowser.loadTabs()` のための新しいAPIを追加
 - 0.1.2007102202
   * Minefieldでも動くようにした
   * 外観の初期設定を「Mixed」に変更した
 - 0.1.2007102201
   * 文字列やリンクのタブ上へのドロップの際の挙動を変更できるようにした
   * [Autohide](http://www.krickelkrackel.de/autohide/)のフルスクリーン表示に対応（左にタブバーを表示している場合のみ）
   * [コンテキストメニュー拡張](http://piro.sakura.ne.jp/xul/ctxextensions/)、[分割ブラウザ](http://piro.sakura.ne.jp/xul/_splitbrowser.html)との衝突を解消
   * 他のアドオンから連携しやすいようにAPIを整えた
 - 0.1.2007102102
   * 起動時にエラーが出て動かない問題を修正
   * タブのドロップ後の処理を間違えていたのを修正
 - 0.1.2007102101
   * 公開
