/*
 * Decompiled with CFR 0.152.
 */
package adql.db.exception;

import adql.db.exception.UnresolvedColumnException;
import adql.db.exception.UnresolvedFunctionException;
import adql.db.exception.UnresolvedTableException;
import adql.parser.grammar.ParseException;
import java.util.ArrayList;
import java.util.Iterator;

public class UnresolvedIdentifiersException
extends ParseException
implements Iterable<ParseException> {
    private static final long serialVersionUID = 1L;
    protected final String itemNature;
    protected ArrayList<ParseException> exceptions;
    private String unresolvedIdentifiers = null;

    public UnresolvedIdentifiersException() {
        this((String)null);
    }

    public UnresolvedIdentifiersException(String itemNature) {
        this.itemNature = itemNature == null || itemNature.trim().isEmpty() ? "unresolved identifier" : itemNature;
        this.exceptions = new ArrayList();
    }

    public final void addException(ParseException pe) {
        if (pe != null) {
            this.exceptions.add(pe);
            if (pe instanceof UnresolvedColumnException) {
                String colName = ((UnresolvedColumnException)pe).getColumnName();
                if (colName != null && colName.trim().length() > 0) {
                    this.addIdentifierName(colName + " " + pe.getPosition());
                }
            } else if (pe instanceof UnresolvedTableException) {
                String tableName = ((UnresolvedTableException)pe).getTableName();
                if (tableName != null && tableName.trim().length() > 0) {
                    this.addIdentifierName(tableName + " " + pe.getPosition());
                }
            } else if (pe instanceof UnresolvedFunctionException) {
                String fctName;
                String string = fctName = ((UnresolvedFunctionException)pe).getFunction() == null ? null : ((UnresolvedFunctionException)pe).getFunction().getName() + "(...)";
                if (fctName != null && fctName.trim().length() > 0) {
                    this.addIdentifierName(fctName + " " + pe.getPosition());
                }
            } else if (pe instanceof UnresolvedIdentifiersException) {
                this.addIdentifierName(((UnresolvedIdentifiersException)pe).unresolvedIdentifiers);
            }
        }
    }

    private final void addIdentifierName(String name) {
        if (name != null && name.trim().length() > 0) {
            this.unresolvedIdentifiers = this.unresolvedIdentifiers == null ? "" : this.unresolvedIdentifiers + ", ";
            this.unresolvedIdentifiers = this.unresolvedIdentifiers + name;
        }
    }

    public final int getNbErrors() {
        return this.exceptions.size();
    }

    public final Iterator<ParseException> getErrors() {
        return this.exceptions.iterator();
    }

    @Override
    public final Iterator<ParseException> iterator() {
        return this.getErrors();
    }

    @Override
    public String getMessage() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.exceptions.size()).append(" " + this.itemNature + "s").append(this.unresolvedIdentifiers != null ? ": " + this.unresolvedIdentifiers : "").append('!');
        for (ParseException pe : this.exceptions) {
            buf.append("\n  - ").append(pe.getMessage());
        }
        return buf.toString();
    }
}

