# Silver-Platter

<div align="center">
  <img src="https://github.com/jelmer/silver-platter/blob/master/logo.png" alt="Silver-Platter logo" width="200px"/>
</div>

Silver-Platter makes it possible to contribute automatable changes to source
code in a version control system
([codemods](https://github.com/jelmer/awesome-codemods)).

It automatically creates a local checkout of a remote repository,
makes user-specified changes, publishes those changes on the remote hosting
site and then creates a pull request.

In addition to that, it can also perform basic maintenance on branches
that have been proposed for merging - such as restarting them if they
have conflicts due to upstream changes.

Silver-Platter powers the [Debian Janitor](https://janitor.debian.org/) and
[Kali Janitor](https://janitor.kali.org/). However, it is an independent project
and can be used fine as a standalone tool. The UI is still a bit rough around
the edges, I'd be grateful for any feedback from people using it - please file
bugs in the issue tracker at <https://github.com/jelmer/silver-platter/issues/new>.

## Installation

### From Source (Recommended)

```bash
# Clone the repository
git clone https://github.com/jelmer/silver-platter
cd silver-platter

# Build and install using Cargo
cargo build --release
cargo install --path .
```

### Prerequisites

- Rust toolchain (install via [rustup](https://rustup.rs/))
- Git and/or Bazaar (depending on repositories you work with)
- Python 3.9+ (for the Python bindings, optional)

## Getting Started

To log in to a code-hosting site, use ``svp login``:

```shell

svp login https://github.com/
```

The simplest way to create a change as a merge proposal is to run something like:

```shell

svp run --mode=propose ./framwork.sh https://github.com/jelmer/dulwich
```

where ``framwork.sh`` makes some modifications to a working copy and prints the
commit message and body for the pull request to standard out. For example:

```shell

#!/bin/sh
sed -i 's/framwork/framework/' README.rst
echo "Fix common typo: framwork ⇒ framework"
```

If you leave pending changes, silver-platter will automatically create a commit
and use the output from the script as the commit message. Scripts also
create their own commits if they prefer - this is especially useful if they
would like to create multiple commits.

## Recipes

To make this process a little bit easier to repeat, recipe files can be used.
For the example above, we could create a ``framwork.yaml`` with the following
contents:

```yaml
---
name: framwork
command: |-
 sed -i 's/framwork/framework/' README.rst
 echo "Fix common typo: framwork ⇒ framework"
mode: propose
merge-request:
  commit-message: Fix a typo
  description:
    markdown: |-
      I spotted that we often mistype *framework* as *framwork*.
```

To execute this recipe, run:

```shell
svp run --recipe=framwork.yaml https://github.com/jelmer/dulwich
```

See `recipe.example.yaml` for an example recipe with plenty of comments.

In addition, you can run a particular recipe over a set of repositories by
specifying a candidate list.
For example, if *candidates.yaml* looked like this:

```yaml
---
- url: https://github.com/dulwich/dulwich
- url: https://github.com/jelmer/xandikos
```

then the following command would process each repository in turn:

```shell
svp run --recipe=framwork.yaml --candidates=candidates.yaml
```

## Monorepo Support

Silver-Platter supports creating multiple pull requests for different paths within a single repository (monorepos). This is useful when you want to apply changes to specific subdirectories and create separate pull requests for each.

To use monorepo support, specify the `--paths` option with comma-separated paths:

```shell
svp run --mode=propose --paths=frontend,backend ./update-deps.sh https://github.com/org/monorepo
```

This will:
1. Run the script in each specified subdirectory (`frontend` and `backend`)
2. Create separate branches with path-specific suffixes (`update-deps-frontend`, `update-deps-backend`)
3. Only include changes within each respective directory
4. Create separate pull requests for each path

The script will be executed with the working directory set to each specified path, and only files within that path will be committed and included in the pull request.

### Using Paths in Candidates

You can also specify paths directly in your candidates.yaml file for repositories that should be processed as monorepos:

```yaml
---
- url: https://github.com/org/monorepo
  name: monorepo
  paths:
    - frontend
    - backend
    - docs
- url: https://github.com/org/single-repo
  name: single-repo
  # No paths specified, will be processed normally
```

When a candidate has `paths` specified, silver-platter will automatically create separate pull requests for each path. The CLI `--paths` option will be ignored for candidates that have their own `paths` defined.

## Batch Mode

Use batch mode when you're going to make a large number of changes and would
like to review or modify the diffs before sending them out:

```shell

svp batch generate --recipe=framwork.yaml --candidates=candidates.yaml framwork
```

This will then create a directory called "framwork", with a file called
``batch.yaml`` with all the pending changes:

```yaml

name: framwork
work:
- url: https://github.com/dulwich/dulwich
  name: dulwich
  description: I spotted that we often mistype *framework* as *framwork*.
  commit-message: Fix a typo
  mode: propose
- url: https://github.com/jelmer/xandikos
  name: dulwich
  description: I spotted that we often mistype *framework* as *framwork*.
  commit-message: Fix a typo
  mode: propose
recipe: ../framwork.yaml
```

For each of the candidates, a clone with the changes is created. You can introspect
and modify the clones as appropriate.

After you review the changes, edit batch.yaml as you see fit - remove
entries that don't appear to be correct, edit the details for the merge
requests, etc.

Once you're happy, you can publish the results:

```shell

svp batch publish framwork
```

This will publish all the changes, using the mode and parameters specified in
``batch.yaml``.

``batch.yaml`` is automatically stripped of any entries in work that have fully
landed, i.e. where the pull request has been merged or where the changes were
pushed to the origin.

To check up on the status of your changes, run ``svp batch status``:

```shell

svp batch status framwork
```

And to refresh any merge proposals that may have become out of date,
run publish again:

```shell

svp batch publish framwork
```

## Supported hosters

At the moment, the following code hosters are supported:

* [GitHub](https://github.com/)
* [Launchpad](https://launchpad.net/)
* [GitLab](https://gitlab.com/) instances, such as Debian's
  [Salsa](https://salsa.debian.org) or [GNOME's GitLab](https://gitlab.gnome.org/)

## Working with Debian packages

Several common operations for Debian packages have dedicated subcommands
under the ``debian-svp`` command. These will also automatically look up
packaging repository location for any Debian package names that are
specified.

* *upload-pending*: Build and upload a package and push/propose the
  changelog updates.
* *run*: Similar to *svp run* but specific to Debian packages:
  it ensures that the *upstream* and *pristine-tar* branches are available as
  well, can optionally update the changelog, and can test that the branch still
  builds.

Some Debian-specific example recipes are provided in `examples/debian/`:

* *lintian-fixes.yaml*: Run the
  [lintian-brush](https://packages.debian.org/lintian-brush)
  command to fix common issues reported by [lintian](https://salsa.debian.org/qa/lintian).
* *new-upstream-release.yaml*: Merge in a new upstream release.
* *multi-arch-hints.yaml*: Apply multi-arch hints.
* *orphan.yaml*: Mark a package as orphaned, update its Maintainer
  field and move it to the common Debian salsa group.
* *rules-requires-root.yaml*: Mark a package as "Rules-Requires-Root: no"
* *cme.yaml*: Run "cme fix dpkg", from the
  [cme package](https://packages.debian.org/cme).

*debian-svp run* takes package name arguments that will be resolved
to repository locations from the *Vcs-Git* field in the package.

See ``debian-svp COMMAND --help`` for more details.

Examples running ``debian-svp``:

```console

# Create merge proposal running lintian-brush against Samba
debian-svp run --recipe=examples/lintian-brush.yaml samba

# Upload pending changes for tdb
debian-svp upload-pending tdb

# Upload pending changes for any packages maintained by Jelmer,
# querying vcswatch.
debian-svp upload-pending --vcswatch --maintainer jelmer@debian.org

# Import the latest upstream release for tdb, without testing
# the build afterwards.
debian-svp run --recipe=examples/debian/new-upstream-release.yaml \
    --no-build-verify tdb

# Apply multi-arch hints to tdb
debian-svp run --recipe=examples/debian/multiarch-hints.yaml tdb
```

The following environment variables are provided for Debian packages:

* ``DEB_SOURCE``: the source package name
* ``DEB_UPDATE_CHANGELOG``: indicates whether a changelog entry should
  be added. Either "leave" (leave alone) or "update" (update changelog).

## Credentials

The ``svp hosters`` subcommand can be used to display the hosting sites that
silver-platter is aware of:

```shell

svp hosters
```

And to log into a new hosting site, simply run ``svp login BASE-URL``, e.g.:

```shell

svp login https://launchpad.net/
```

## Command Reference

### Main Commands

- `svp run` - Run a codemod on one or more repositories
- `svp apply` - Apply changes to a local checkout without publishing
- `svp forges` - List known code hosting platforms  
- `svp login` - Authenticate with a hosting platform
- `svp proposals` - List your merge proposals
- `svp batch generate` - Generate batch changes for review
- `svp batch publish` - Publish reviewed batch changes

### Exit Codes

``svp run`` will exit 0 if no changes have been made, 1 if at least one
repository has been changed and 2 in case of trouble.

## Documentation

- [Python API](README.python.md) - Using Silver-Platter as a Python library  
- [Codemod Protocol](codemod-protocol.md) - Writing codemods that work with Silver-Platter
- [Recipe Examples](examples/recipes/) - Common recipe patterns
- [Development Notes](devnotes/) - Architecture and design documentation

## Contributing

Contributions are welcome! Please see our [Code of Conduct](CODE_OF_CONDUCT.md) and
feel free to [file issues](https://github.com/jelmer/silver-platter/issues/new) or submit pull requests.

## License

Silver-Platter is licensed under the GNU General Public License v3.0 or later.
See [LICENSE](LICENSE) for details.
