% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blob.R
\name{content}
\alias{content}
\title{Content of blob}
\usage{
content(blob = NULL, split = TRUE, raw = FALSE)
}
\arguments{
\item{blob}{The blob object.}

\item{split}{Split blob content to text lines. Default TRUE.}

\item{raw}{When \code{TRUE}, get the content of the blob as a raw
vector, else as a character vector. Default is \code{FALSE}.}
}
\value{
The content of the blob. NA_character_ if the blob is
    binary and \code{raw} is \code{FALSE}.
}
\description{
Content of blob
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user and commit a file
config(repo, user.name = "Alice", user.email = "alice@example.org")
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Display content of blob.
content(tree(commits(repo)[[1]])["example.txt"])
}
}
