# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.azurearcdata import AzureArcDataManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-azurearcdata
# USAGE
    python create_or_update_data_controller.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = AzureArcDataManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="00000000-1111-2222-3333-444444444444",
    )

    response = client.data_controllers.begin_put_data_controller(
        resource_group_name="testrg",
        data_controller_name="testdataController",
        data_controller_resource={
            "extendedLocation": {
                "name": "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.ExtendedLocation/customLocations/arclocation",
                "type": "CustomLocation",
            },
            "location": "northeurope",
            "properties": {
                "basicLoginInformation": {"password": "********", "username": "username"},
                "clusterId": "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/connectedk8s",
                "extensionId": "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/connectedk8s/providers/Microsoft.KubernetesConfiguration/extensions/extension",
                "infrastructure": "onpremises",
                "logAnalyticsWorkspaceConfig": {
                    "primaryKey": "********",
                    "workspaceId": "00000000-1111-2222-3333-444444444444",
                },
                "logsDashboardCredential": {"password": "********", "username": "username"},
                "metricsDashboardCredential": {"password": "********", "username": "username"},
                "onPremiseProperty": {
                    "id": "12345678-1234-1234-ab12-1a2b3c4d5e6f",
                    "publicSigningKey": "publicOnPremSigningKey",
                },
                "uploadServicePrincipal": {
                    "authority": "https://login.microsoftonline.com/",
                    "clientId": "00000000-1111-2222-3333-444444444444",
                    "clientSecret": "********",
                    "tenantId": "00000000-1111-2222-3333-444444444444",
                },
                "uploadWatermark": {
                    "logs": "2020-01-01T17:18:19.1234567Z",
                    "metrics": "2020-01-01T17:18:19.1234567Z",
                    "usages": "2020-01-01T17:18:19.1234567Z",
                },
            },
            "tags": {"mytag": "myval"},
        },
    ).result()
    print(response)


# x-ms-original-file: specification/azurearcdata/resource-manager/Microsoft.AzureArcData/preview/2022-03-01-preview/examples/CreateOrUpdateDataController.json
if __name__ == "__main__":
    main()
