# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class AdditionalUnattendContent(_serialization.Model):
    """Specifies additional XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup. Contents are defined by setting name, component name, and the pass in which the content is applied.

    :ivar pass_name: The pass name. Currently, the only allowable value is OobeSystem. Default
     value is "OobeSystem".
    :vartype pass_name: str
    :ivar component_name: The component name. Currently, the only allowable value is
     Microsoft-Windows-Shell-Setup. Default value is "Microsoft-Windows-Shell-Setup".
    :vartype component_name: str
    :ivar setting_name: Specifies the name of the setting to which the content applies. Possible
     values are: FirstLogonCommands and AutoLogon. Known values are: "AutoLogon" and
     "FirstLogonCommands".
    :vartype setting_name: str or ~azure.mgmt.compute.v2017_12_01.models.SettingNames
    :ivar content: Specifies the XML formatted content that is added to the unattend.xml file for
     the specified path and component. The XML must be less than 4KB and must include the root
     element for the setting or feature that is being inserted.
    :vartype content: str
    """

    _attribute_map = {
        "pass_name": {"key": "passName", "type": "str"},
        "component_name": {"key": "componentName", "type": "str"},
        "setting_name": {"key": "settingName", "type": "str"},
        "content": {"key": "content", "type": "str"},
    }

    def __init__(
        self,
        *,
        pass_name: Optional[str] = None,
        component_name: Optional[str] = None,
        setting_name: Optional[Union[str, "_models.SettingNames"]] = None,
        content: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword pass_name: The pass name. Currently, the only allowable value is OobeSystem. Default
         value is "OobeSystem".
        :paramtype pass_name: str
        :keyword component_name: The component name. Currently, the only allowable value is
         Microsoft-Windows-Shell-Setup. Default value is "Microsoft-Windows-Shell-Setup".
        :paramtype component_name: str
        :keyword setting_name: Specifies the name of the setting to which the content applies. Possible
         values are: FirstLogonCommands and AutoLogon. Known values are: "AutoLogon" and
         "FirstLogonCommands".
        :paramtype setting_name: str or ~azure.mgmt.compute.v2017_12_01.models.SettingNames
        :keyword content: Specifies the XML formatted content that is added to the unattend.xml file
         for the specified path and component. The XML must be less than 4KB and must include the root
         element for the setting or feature that is being inserted.
        :paramtype content: str
        """
        super().__init__(**kwargs)
        self.pass_name = pass_name
        self.component_name = component_name
        self.setting_name = setting_name
        self.content = content


class ApiEntityReference(_serialization.Model):
    """The API entity reference.

    :ivar id: The ARM resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: The ARM resource id in the form of
         /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class ApiError(_serialization.Model):
    """Api error.

    :ivar details: The Api error details.
    :vartype details: list[~azure.mgmt.compute.v2017_12_01.models.ApiErrorBase]
    :ivar innererror: The Api inner error.
    :vartype innererror: ~azure.mgmt.compute.v2017_12_01.models.InnerError
    :ivar code: The error code.
    :vartype code: str
    :ivar target: The target of the particular error.
    :vartype target: str
    :ivar message: The error message.
    :vartype message: str
    """

    _attribute_map = {
        "details": {"key": "details", "type": "[ApiErrorBase]"},
        "innererror": {"key": "innererror", "type": "InnerError"},
        "code": {"key": "code", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        details: Optional[List["_models.ApiErrorBase"]] = None,
        innererror: Optional["_models.InnerError"] = None,
        code: Optional[str] = None,
        target: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword details: The Api error details.
        :paramtype details: list[~azure.mgmt.compute.v2017_12_01.models.ApiErrorBase]
        :keyword innererror: The Api inner error.
        :paramtype innererror: ~azure.mgmt.compute.v2017_12_01.models.InnerError
        :keyword code: The error code.
        :paramtype code: str
        :keyword target: The target of the particular error.
        :paramtype target: str
        :keyword message: The error message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.details = details
        self.innererror = innererror
        self.code = code
        self.target = target
        self.message = message


class ApiErrorBase(_serialization.Model):
    """Api error base.

    :ivar code: The error code.
    :vartype code: str
    :ivar target: The target of the particular error.
    :vartype target: str
    :ivar message: The error message.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self, *, code: Optional[str] = None, target: Optional[str] = None, message: Optional[str] = None, **kwargs
    ):
        """
        :keyword code: The error code.
        :paramtype code: str
        :keyword target: The target of the particular error.
        :paramtype target: str
        :keyword message: The error message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.target = target
        self.message = message


class AutoOSUpgradePolicy(_serialization.Model):
    """The configuration parameters used for performing automatic OS upgrade.

    :ivar disable_auto_rollback: Whether OS image rollback feature should be disabled. Default
     value is false.
    :vartype disable_auto_rollback: bool
    """

    _attribute_map = {
        "disable_auto_rollback": {"key": "disableAutoRollback", "type": "bool"},
    }

    def __init__(self, *, disable_auto_rollback: Optional[bool] = None, **kwargs):
        """
        :keyword disable_auto_rollback: Whether OS image rollback feature should be disabled. Default
         value is false.
        :paramtype disable_auto_rollback: bool
        """
        super().__init__(**kwargs)
        self.disable_auto_rollback = disable_auto_rollback


class Resource(_serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class AvailabilitySet(Resource):
    """Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified in the same availability set are allocated to different nodes to maximize availability. For more information about availability sets, see `Manage the availability of virtual machines <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-manage-availability?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_. :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Planned maintenance for virtual machines in Azure <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-planned-maintenance?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_ :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation time. An existing VM cannot be added to an availability set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Sku of the availability set.
    :vartype sku: ~azure.mgmt.compute.v2017_12_01.models.Sku
    :ivar platform_update_domain_count: Update Domain count.
    :vartype platform_update_domain_count: int
    :ivar platform_fault_domain_count: Fault Domain count.
    :vartype platform_fault_domain_count: int
    :ivar virtual_machines: A list of references to all virtual machines in the availability set.
    :vartype virtual_machines: list[~azure.mgmt.compute.v2017_12_01.models.SubResource]
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2017_12_01.models.InstanceViewStatus]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "statuses": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "platform_update_domain_count": {"key": "properties.platformUpdateDomainCount", "type": "int"},
        "platform_fault_domain_count": {"key": "properties.platformFaultDomainCount", "type": "int"},
        "virtual_machines": {"key": "properties.virtualMachines", "type": "[SubResource]"},
        "statuses": {"key": "properties.statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        platform_update_domain_count: Optional[int] = None,
        platform_fault_domain_count: Optional[int] = None,
        virtual_machines: Optional[List["_models.SubResource"]] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Sku of the availability set.
        :paramtype sku: ~azure.mgmt.compute.v2017_12_01.models.Sku
        :keyword platform_update_domain_count: Update Domain count.
        :paramtype platform_update_domain_count: int
        :keyword platform_fault_domain_count: Fault Domain count.
        :paramtype platform_fault_domain_count: int
        :keyword virtual_machines: A list of references to all virtual machines in the availability
         set.
        :paramtype virtual_machines: list[~azure.mgmt.compute.v2017_12_01.models.SubResource]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.platform_update_domain_count = platform_update_domain_count
        self.platform_fault_domain_count = platform_fault_domain_count
        self.virtual_machines = virtual_machines
        self.statuses = None


class AvailabilitySetListResult(_serialization.Model):
    """The List Availability Set operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of availability sets. Required.
    :vartype value: list[~azure.mgmt.compute.v2017_12_01.models.AvailabilitySet]
    :ivar next_link: The URI to fetch the next page of AvailabilitySets. Call ListNext() with this
     URI to fetch the next page of AvailabilitySets.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AvailabilitySet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.AvailabilitySet"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The list of availability sets. Required.
        :paramtype value: list[~azure.mgmt.compute.v2017_12_01.models.AvailabilitySet]
        :keyword next_link: The URI to fetch the next page of AvailabilitySets. Call ListNext() with
         this URI to fetch the next page of AvailabilitySets.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class UpdateResource(_serialization.Model):
    """The Update Resource model definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class AvailabilitySetUpdate(UpdateResource):
    """Specifies information about the availability set that the virtual machine should be assigned to. Only tags may be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Sku of the availability set.
    :vartype sku: ~azure.mgmt.compute.v2017_12_01.models.Sku
    :ivar platform_update_domain_count: Update Domain count.
    :vartype platform_update_domain_count: int
    :ivar platform_fault_domain_count: Fault Domain count.
    :vartype platform_fault_domain_count: int
    :ivar virtual_machines: A list of references to all virtual machines in the availability set.
    :vartype virtual_machines: list[~azure.mgmt.compute.v2017_12_01.models.SubResource]
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2017_12_01.models.InstanceViewStatus]
    """

    _validation = {
        "statuses": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "platform_update_domain_count": {"key": "properties.platformUpdateDomainCount", "type": "int"},
        "platform_fault_domain_count": {"key": "properties.platformFaultDomainCount", "type": "int"},
        "virtual_machines": {"key": "properties.virtualMachines", "type": "[SubResource]"},
        "statuses": {"key": "properties.statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        platform_update_domain_count: Optional[int] = None,
        platform_fault_domain_count: Optional[int] = None,
        virtual_machines: Optional[List["_models.SubResource"]] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Sku of the availability set.
        :paramtype sku: ~azure.mgmt.compute.v2017_12_01.models.Sku
        :keyword platform_update_domain_count: Update Domain count.
        :paramtype platform_update_domain_count: int
        :keyword platform_fault_domain_count: Fault Domain count.
        :paramtype platform_fault_domain_count: int
        :keyword virtual_machines: A list of references to all virtual machines in the availability
         set.
        :paramtype virtual_machines: list[~azure.mgmt.compute.v2017_12_01.models.SubResource]
        """
        super().__init__(tags=tags, **kwargs)
        self.sku = sku
        self.platform_update_domain_count = platform_update_domain_count
        self.platform_fault_domain_count = platform_fault_domain_count
        self.virtual_machines = virtual_machines
        self.statuses = None


class BootDiagnostics(_serialization.Model):
    """Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a screenshot of the VM from the hypervisor.

    :ivar enabled: Whether boot diagnostics should be enabled on the Virtual Machine.
    :vartype enabled: bool
    :ivar storage_uri: Uri of the storage account to use for placing the console output and
     screenshot.
    :vartype storage_uri: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "storage_uri": {"key": "storageUri", "type": "str"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, storage_uri: Optional[str] = None, **kwargs):
        """
        :keyword enabled: Whether boot diagnostics should be enabled on the Virtual Machine.
        :paramtype enabled: bool
        :keyword storage_uri: Uri of the storage account to use for placing the console output and
         screenshot.
        :paramtype storage_uri: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.storage_uri = storage_uri


class BootDiagnosticsInstanceView(_serialization.Model):
    """The instance view of a virtual machine boot diagnostics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar console_screenshot_blob_uri: The console screenshot blob URI.
    :vartype console_screenshot_blob_uri: str
    :ivar serial_console_log_blob_uri: The Linux serial console log blob Uri.
    :vartype serial_console_log_blob_uri: str
    """

    _validation = {
        "console_screenshot_blob_uri": {"readonly": True},
        "serial_console_log_blob_uri": {"readonly": True},
    }

    _attribute_map = {
        "console_screenshot_blob_uri": {"key": "consoleScreenshotBlobUri", "type": "str"},
        "serial_console_log_blob_uri": {"key": "serialConsoleLogBlobUri", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.console_screenshot_blob_uri = None
        self.serial_console_log_blob_uri = None


class ComputeLongRunningOperationProperties(_serialization.Model):
    """Compute-specific operation properties, including output.

    :ivar output: Operation output data (raw JSON).
    :vartype output: JSON
    """

    _attribute_map = {
        "output": {"key": "output", "type": "object"},
    }

    def __init__(self, *, output: Optional[JSON] = None, **kwargs):
        """
        :keyword output: Operation output data (raw JSON).
        :paramtype output: JSON
        """
        super().__init__(**kwargs)
        self.output = output


class ComputeOperationListResult(_serialization.Model):
    """The List Compute Operation operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of compute operations.
    :vartype value: list[~azure.mgmt.compute.v2017_12_01.models.ComputeOperationValue]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ComputeOperationValue]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None


class ComputeOperationValue(_serialization.Model):
    """Describes the properties of a Compute Operation value.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar origin: The origin of the compute operation.
    :vartype origin: str
    :ivar name: The name of the compute operation.
    :vartype name: str
    :ivar operation: The display name of the compute operation.
    :vartype operation: str
    :ivar resource: The display name of the resource the operation applies to.
    :vartype resource: str
    :ivar description: The description of the operation.
    :vartype description: str
    :ivar provider: The resource provider for the operation.
    :vartype provider: str
    """

    _validation = {
        "origin": {"readonly": True},
        "name": {"readonly": True},
        "operation": {"readonly": True},
        "resource": {"readonly": True},
        "description": {"readonly": True},
        "provider": {"readonly": True},
    }

    _attribute_map = {
        "origin": {"key": "origin", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "operation": {"key": "display.operation", "type": "str"},
        "resource": {"key": "display.resource", "type": "str"},
        "description": {"key": "display.description", "type": "str"},
        "provider": {"key": "display.provider", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.origin = None
        self.name = None
        self.operation = None
        self.resource = None
        self.description = None
        self.provider = None


class DataDisk(_serialization.Model):
    """Describes a data disk.

    All required parameters must be populated in order to send to Azure.

    :ivar lun: Specifies the logical unit number of the data disk. This value is used to identify
     data disks within the VM and therefore must be unique for each data disk attached to a VM.
     Required.
    :vartype lun: int
    :ivar name: The disk name.
    :vartype name: str
    :ivar vhd: The virtual hard disk.
    :vartype vhd: ~azure.mgmt.compute.v2017_12_01.models.VirtualHardDisk
    :ivar image: The source user image virtual hard disk. The virtual hard disk will be copied
     before being attached to the virtual machine. If SourceImage is provided, the destination
     virtual hard drive must not exist.
    :vartype image: ~azure.mgmt.compute.v2017_12_01.models.VirtualHardDisk
    :ivar caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.v2017_12_01.models.CachingTypes
    :ivar write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :vartype write_accelerator_enabled: bool
    :ivar create_option: Specifies how the virtual machine should be
     created.:code:`<br>`:code:`<br>` Possible values are::code:`<br>`:code:`<br>` **Attach** \u2013
     This value is used when you are using a specialized disk to create the virtual
     machine.:code:`<br>`:code:`<br>` **FromImage** \u2013 This value is used when you are using an
     image to create the virtual machine. If you are using a platform image, you also use the
     imageReference element described above. If you are using a marketplace image, you  also use the
     plan element previously described. Required. Known values are: "FromImage", "Empty", and
     "Attach".
    :vartype create_option: str or ~azure.mgmt.compute.v2017_12_01.models.DiskCreateOptionTypes
    :ivar disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :vartype disk_size_gb: int
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk: ~azure.mgmt.compute.v2017_12_01.models.ManagedDiskParameters
    """

    _validation = {
        "lun": {"required": True},
        "create_option": {"required": True},
    }

    _attribute_map = {
        "lun": {"key": "lun", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "vhd": {"key": "vhd", "type": "VirtualHardDisk"},
        "image": {"key": "image", "type": "VirtualHardDisk"},
        "caching": {"key": "caching", "type": "str"},
        "write_accelerator_enabled": {"key": "writeAcceleratorEnabled", "type": "bool"},
        "create_option": {"key": "createOption", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "managed_disk": {"key": "managedDisk", "type": "ManagedDiskParameters"},
    }

    def __init__(
        self,
        *,
        lun: int,
        create_option: Union[str, "_models.DiskCreateOptionTypes"],
        name: Optional[str] = None,
        vhd: Optional["_models.VirtualHardDisk"] = None,
        image: Optional["_models.VirtualHardDisk"] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["_models.ManagedDiskParameters"] = None,
        **kwargs
    ):
        """
        :keyword lun: Specifies the logical unit number of the data disk. This value is used to
         identify data disks within the VM and therefore must be unique for each data disk attached to a
         VM. Required.
        :paramtype lun: int
        :keyword name: The disk name.
        :paramtype name: str
        :keyword vhd: The virtual hard disk.
        :paramtype vhd: ~azure.mgmt.compute.v2017_12_01.models.VirtualHardDisk
        :keyword image: The source user image virtual hard disk. The virtual hard disk will be copied
         before being attached to the virtual machine. If SourceImage is provided, the destination
         virtual hard drive must not exist.
        :paramtype image: ~azure.mgmt.compute.v2017_12_01.models.VirtualHardDisk
        :keyword caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
         :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
         storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.v2017_12_01.models.CachingTypes
        :keyword write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
         disabled on the disk.
        :paramtype write_accelerator_enabled: bool
        :keyword create_option: Specifies how the virtual machine should be
         created.:code:`<br>`:code:`<br>` Possible values are::code:`<br>`:code:`<br>` **Attach** \u2013
         This value is used when you are using a specialized disk to create the virtual
         machine.:code:`<br>`:code:`<br>` **FromImage** \u2013 This value is used when you are using an
         image to create the virtual machine. If you are using a platform image, you also use the
         imageReference element described above. If you are using a marketplace image, you  also use the
         plan element previously described. Required. Known values are: "FromImage", "Empty", and
         "Attach".
        :paramtype create_option: str or ~azure.mgmt.compute.v2017_12_01.models.DiskCreateOptionTypes
        :keyword disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can
         be used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
         This value cannot be larger than 1023 GB.
        :paramtype disk_size_gb: int
        :keyword managed_disk: The managed disk parameters.
        :paramtype managed_disk: ~azure.mgmt.compute.v2017_12_01.models.ManagedDiskParameters
        """
        super().__init__(**kwargs)
        self.lun = lun
        self.name = name
        self.vhd = vhd
        self.image = image
        self.caching = caching
        self.write_accelerator_enabled = write_accelerator_enabled
        self.create_option = create_option
        self.disk_size_gb = disk_size_gb
        self.managed_disk = managed_disk


class DataDiskImage(_serialization.Model):
    """Contains the data disk images information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar lun: Specifies the logical unit number of the data disk. This value is used to identify
     data disks within the VM and therefore must be unique for each data disk attached to a VM.
    :vartype lun: int
    """

    _validation = {
        "lun": {"readonly": True},
    }

    _attribute_map = {
        "lun": {"key": "lun", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.lun = None


class DiagnosticsProfile(_serialization.Model):
    """Specifies the boot diagnostic settings state. :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.

    :ivar boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
     Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
     view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
     screenshot of the VM from the hypervisor.
    :vartype boot_diagnostics: ~azure.mgmt.compute.v2017_12_01.models.BootDiagnostics
    """

    _attribute_map = {
        "boot_diagnostics": {"key": "bootDiagnostics", "type": "BootDiagnostics"},
    }

    def __init__(self, *, boot_diagnostics: Optional["_models.BootDiagnostics"] = None, **kwargs):
        """
        :keyword boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
         Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
         view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
         screenshot of the VM from the hypervisor.
        :paramtype boot_diagnostics: ~azure.mgmt.compute.v2017_12_01.models.BootDiagnostics
        """
        super().__init__(**kwargs)
        self.boot_diagnostics = boot_diagnostics


class DiskEncryptionSettings(_serialization.Model):
    """Describes a Encryption Settings for a Disk.

    :ivar disk_encryption_key: Specifies the location of the disk encryption key, which is a Key
     Vault Secret.
    :vartype disk_encryption_key: ~azure.mgmt.compute.v2017_12_01.models.KeyVaultSecretReference
    :ivar key_encryption_key: Specifies the location of the key encryption key in Key Vault.
    :vartype key_encryption_key: ~azure.mgmt.compute.v2017_12_01.models.KeyVaultKeyReference
    :ivar enabled: Specifies whether disk encryption should be enabled on the virtual machine.
    :vartype enabled: bool
    """

    _attribute_map = {
        "disk_encryption_key": {"key": "diskEncryptionKey", "type": "KeyVaultSecretReference"},
        "key_encryption_key": {"key": "keyEncryptionKey", "type": "KeyVaultKeyReference"},
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        disk_encryption_key: Optional["_models.KeyVaultSecretReference"] = None,
        key_encryption_key: Optional["_models.KeyVaultKeyReference"] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword disk_encryption_key: Specifies the location of the disk encryption key, which is a Key
         Vault Secret.
        :paramtype disk_encryption_key: ~azure.mgmt.compute.v2017_12_01.models.KeyVaultSecretReference
        :keyword key_encryption_key: Specifies the location of the key encryption key in Key Vault.
        :paramtype key_encryption_key: ~azure.mgmt.compute.v2017_12_01.models.KeyVaultKeyReference
        :keyword enabled: Specifies whether disk encryption should be enabled on the virtual machine.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.disk_encryption_key = disk_encryption_key
        self.key_encryption_key = key_encryption_key
        self.enabled = enabled


class DiskInstanceView(_serialization.Model):
    """The instance view of the disk.

    :ivar name: The disk name.
    :vartype name: str
    :ivar encryption_settings: Specifies the encryption settings for the OS Disk.
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :vartype encryption_settings:
     list[~azure.mgmt.compute.v2017_12_01.models.DiskEncryptionSettings]
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2017_12_01.models.InstanceViewStatus]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "encryption_settings": {"key": "encryptionSettings", "type": "[DiskEncryptionSettings]"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        encryption_settings: Optional[List["_models.DiskEncryptionSettings"]] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        **kwargs
    ):
        """
        :keyword name: The disk name.
        :paramtype name: str
        :keyword encryption_settings: Specifies the encryption settings for the OS Disk.
         :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
        :paramtype encryption_settings:
         list[~azure.mgmt.compute.v2017_12_01.models.DiskEncryptionSettings]
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.v2017_12_01.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.name = name
        self.encryption_settings = encryption_settings
        self.statuses = statuses


class HardwareProfile(_serialization.Model):
    """Specifies the hardware settings for the virtual machine.

    :ivar vm_size: Specifies the size of the virtual machine. For more information about virtual
     machine sizes, see `Sizes for virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-sizes?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
     :code:`<br>`:code:`<br>` The available VM sizes depend on region and availability set. For a
     list of available sizes use these APIs:  :code:`<br>`:code:`<br>` `List all available virtual
     machine sizes in an availability set
     <https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes>`_
     :code:`<br>`:code:`<br>` `List all available virtual machine sizes in a region
     <https://docs.microsoft.com/rest/api/compute/virtualmachinesizes/list>`_
     :code:`<br>`:code:`<br>` `List all available virtual machine sizes for resizing
     <https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes>`_. Known
     values are: "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A0",
     "Standard_A1", "Standard_A2", "Standard_A3", "Standard_A4", "Standard_A5", "Standard_A6",
     "Standard_A7", "Standard_A8", "Standard_A9", "Standard_A10", "Standard_A11", "Standard_A1_v2",
     "Standard_A2_v2", "Standard_A4_v2", "Standard_A8_v2", "Standard_A2m_v2", "Standard_A4m_v2",
     "Standard_A8m_v2", "Standard_B1s", "Standard_B1ms", "Standard_B2s", "Standard_B2ms",
     "Standard_B4ms", "Standard_B8ms", "Standard_D1", "Standard_D2", "Standard_D3", "Standard_D4",
     "Standard_D11", "Standard_D12", "Standard_D13", "Standard_D14", "Standard_D1_v2",
     "Standard_D2_v2", "Standard_D3_v2", "Standard_D4_v2", "Standard_D5_v2", "Standard_D2_v3",
     "Standard_D4_v3", "Standard_D8_v3", "Standard_D16_v3", "Standard_D32_v3", "Standard_D64_v3",
     "Standard_D2s_v3", "Standard_D4s_v3", "Standard_D8s_v3", "Standard_D16s_v3",
     "Standard_D32s_v3", "Standard_D64s_v3", "Standard_D11_v2", "Standard_D12_v2",
     "Standard_D13_v2", "Standard_D14_v2", "Standard_D15_v2", "Standard_DS1", "Standard_DS2",
     "Standard_DS3", "Standard_DS4", "Standard_DS11", "Standard_DS12", "Standard_DS13",
     "Standard_DS14", "Standard_DS1_v2", "Standard_DS2_v2", "Standard_DS3_v2", "Standard_DS4_v2",
     "Standard_DS5_v2", "Standard_DS11_v2", "Standard_DS12_v2", "Standard_DS13_v2",
     "Standard_DS14_v2", "Standard_DS15_v2", "Standard_DS13-4_v2", "Standard_DS13-2_v2",
     "Standard_DS14-8_v2", "Standard_DS14-4_v2", "Standard_E2_v3", "Standard_E4_v3",
     "Standard_E8_v3", "Standard_E16_v3", "Standard_E32_v3", "Standard_E64_v3", "Standard_E2s_v3",
     "Standard_E4s_v3", "Standard_E8s_v3", "Standard_E16s_v3", "Standard_E32s_v3",
     "Standard_E64s_v3", "Standard_E32-16_v3", "Standard_E32-8s_v3", "Standard_E64-32s_v3",
     "Standard_E64-16s_v3", "Standard_F1", "Standard_F2", "Standard_F4", "Standard_F8",
     "Standard_F16", "Standard_F1s", "Standard_F2s", "Standard_F4s", "Standard_F8s",
     "Standard_F16s", "Standard_F2s_v2", "Standard_F4s_v2", "Standard_F8s_v2", "Standard_F16s_v2",
     "Standard_F32s_v2", "Standard_F64s_v2", "Standard_F72s_v2", "Standard_G1", "Standard_G2",
     "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2", "Standard_GS3",
     "Standard_GS4", "Standard_GS5", "Standard_GS4-8", "Standard_GS4-4", "Standard_GS5-16",
     "Standard_GS5-8", "Standard_H8", "Standard_H16", "Standard_H8m", "Standard_H16m",
     "Standard_H16r", "Standard_H16mr", "Standard_L4s", "Standard_L8s", "Standard_L16s",
     "Standard_L32s", "Standard_M64s", "Standard_M64ms", "Standard_M128s", "Standard_M128ms",
     "Standard_M64-32ms", "Standard_M64-16ms", "Standard_M128-64ms", "Standard_M128-32ms",
     "Standard_NC6", "Standard_NC12", "Standard_NC24", "Standard_NC24r", "Standard_NC6s_v2",
     "Standard_NC12s_v2", "Standard_NC24s_v2", "Standard_NC24rs_v2", "Standard_NC6s_v3",
     "Standard_NC12s_v3", "Standard_NC24s_v3", "Standard_NC24rs_v3", "Standard_ND6s",
     "Standard_ND12s", "Standard_ND24s", "Standard_ND24rs", "Standard_NV6", "Standard_NV12", and
     "Standard_NV24".
    :vartype vm_size: str or ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineSizeTypes
    """

    _attribute_map = {
        "vm_size": {"key": "vmSize", "type": "str"},
    }

    def __init__(self, *, vm_size: Optional[Union[str, "_models.VirtualMachineSizeTypes"]] = None, **kwargs):
        """
        :keyword vm_size: Specifies the size of the virtual machine. For more information about virtual
         machine sizes, see `Sizes for virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-sizes?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
         :code:`<br>`:code:`<br>` The available VM sizes depend on region and availability set. For a
         list of available sizes use these APIs:  :code:`<br>`:code:`<br>` `List all available virtual
         machine sizes in an availability set
         <https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes>`_
         :code:`<br>`:code:`<br>` `List all available virtual machine sizes in a region
         <https://docs.microsoft.com/rest/api/compute/virtualmachinesizes/list>`_
         :code:`<br>`:code:`<br>` `List all available virtual machine sizes for resizing
         <https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes>`_. Known
         values are: "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A0",
         "Standard_A1", "Standard_A2", "Standard_A3", "Standard_A4", "Standard_A5", "Standard_A6",
         "Standard_A7", "Standard_A8", "Standard_A9", "Standard_A10", "Standard_A11", "Standard_A1_v2",
         "Standard_A2_v2", "Standard_A4_v2", "Standard_A8_v2", "Standard_A2m_v2", "Standard_A4m_v2",
         "Standard_A8m_v2", "Standard_B1s", "Standard_B1ms", "Standard_B2s", "Standard_B2ms",
         "Standard_B4ms", "Standard_B8ms", "Standard_D1", "Standard_D2", "Standard_D3", "Standard_D4",
         "Standard_D11", "Standard_D12", "Standard_D13", "Standard_D14", "Standard_D1_v2",
         "Standard_D2_v2", "Standard_D3_v2", "Standard_D4_v2", "Standard_D5_v2", "Standard_D2_v3",
         "Standard_D4_v3", "Standard_D8_v3", "Standard_D16_v3", "Standard_D32_v3", "Standard_D64_v3",
         "Standard_D2s_v3", "Standard_D4s_v3", "Standard_D8s_v3", "Standard_D16s_v3",
         "Standard_D32s_v3", "Standard_D64s_v3", "Standard_D11_v2", "Standard_D12_v2",
         "Standard_D13_v2", "Standard_D14_v2", "Standard_D15_v2", "Standard_DS1", "Standard_DS2",
         "Standard_DS3", "Standard_DS4", "Standard_DS11", "Standard_DS12", "Standard_DS13",
         "Standard_DS14", "Standard_DS1_v2", "Standard_DS2_v2", "Standard_DS3_v2", "Standard_DS4_v2",
         "Standard_DS5_v2", "Standard_DS11_v2", "Standard_DS12_v2", "Standard_DS13_v2",
         "Standard_DS14_v2", "Standard_DS15_v2", "Standard_DS13-4_v2", "Standard_DS13-2_v2",
         "Standard_DS14-8_v2", "Standard_DS14-4_v2", "Standard_E2_v3", "Standard_E4_v3",
         "Standard_E8_v3", "Standard_E16_v3", "Standard_E32_v3", "Standard_E64_v3", "Standard_E2s_v3",
         "Standard_E4s_v3", "Standard_E8s_v3", "Standard_E16s_v3", "Standard_E32s_v3",
         "Standard_E64s_v3", "Standard_E32-16_v3", "Standard_E32-8s_v3", "Standard_E64-32s_v3",
         "Standard_E64-16s_v3", "Standard_F1", "Standard_F2", "Standard_F4", "Standard_F8",
         "Standard_F16", "Standard_F1s", "Standard_F2s", "Standard_F4s", "Standard_F8s",
         "Standard_F16s", "Standard_F2s_v2", "Standard_F4s_v2", "Standard_F8s_v2", "Standard_F16s_v2",
         "Standard_F32s_v2", "Standard_F64s_v2", "Standard_F72s_v2", "Standard_G1", "Standard_G2",
         "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2", "Standard_GS3",
         "Standard_GS4", "Standard_GS5", "Standard_GS4-8", "Standard_GS4-4", "Standard_GS5-16",
         "Standard_GS5-8", "Standard_H8", "Standard_H16", "Standard_H8m", "Standard_H16m",
         "Standard_H16r", "Standard_H16mr", "Standard_L4s", "Standard_L8s", "Standard_L16s",
         "Standard_L32s", "Standard_M64s", "Standard_M64ms", "Standard_M128s", "Standard_M128ms",
         "Standard_M64-32ms", "Standard_M64-16ms", "Standard_M128-64ms", "Standard_M128-32ms",
         "Standard_NC6", "Standard_NC12", "Standard_NC24", "Standard_NC24r", "Standard_NC6s_v2",
         "Standard_NC12s_v2", "Standard_NC24s_v2", "Standard_NC24rs_v2", "Standard_NC6s_v3",
         "Standard_NC12s_v3", "Standard_NC24s_v3", "Standard_NC24rs_v3", "Standard_ND6s",
         "Standard_ND12s", "Standard_ND24s", "Standard_ND24rs", "Standard_NV6", "Standard_NV12", and
         "Standard_NV24".
        :paramtype vm_size: str or ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineSizeTypes
        """
        super().__init__(**kwargs)
        self.vm_size = vm_size


class Image(Resource):
    """The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar source_virtual_machine: The source virtual machine from which Image is created.
    :vartype source_virtual_machine: ~azure.mgmt.compute.v2017_12_01.models.SubResource
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile: ~azure.mgmt.compute.v2017_12_01.models.ImageStorageProfile
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "source_virtual_machine": {"key": "properties.sourceVirtualMachine", "type": "SubResource"},
        "storage_profile": {"key": "properties.storageProfile", "type": "ImageStorageProfile"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        source_virtual_machine: Optional["_models.SubResource"] = None,
        storage_profile: Optional["_models.ImageStorageProfile"] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword source_virtual_machine: The source virtual machine from which Image is created.
        :paramtype source_virtual_machine: ~azure.mgmt.compute.v2017_12_01.models.SubResource
        :keyword storage_profile: Specifies the storage settings for the virtual machine disks.
        :paramtype storage_profile: ~azure.mgmt.compute.v2017_12_01.models.ImageStorageProfile
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.source_virtual_machine = source_virtual_machine
        self.storage_profile = storage_profile
        self.provisioning_state = None


class ImageDataDisk(_serialization.Model):
    """Describes a data disk.

    All required parameters must be populated in order to send to Azure.

    :ivar lun: Specifies the logical unit number of the data disk. This value is used to identify
     data disks within the VM and therefore must be unique for each data disk attached to a VM.
     Required.
    :vartype lun: int
    :ivar snapshot: The snapshot.
    :vartype snapshot: ~azure.mgmt.compute.v2017_12_01.models.SubResource
    :ivar managed_disk: The managedDisk.
    :vartype managed_disk: ~azure.mgmt.compute.v2017_12_01.models.SubResource
    :ivar blob_uri: The Virtual Hard Disk.
    :vartype blob_uri: str
    :ivar caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.v2017_12_01.models.CachingTypes
    :ivar disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
     used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :vartype disk_size_gb: int
    :ivar storage_account_type: Specifies the storage account type for the managed disk. Possible
     values are: Standard_LRS or Premium_LRS. Known values are: "Standard_LRS" and "Premium_LRS".
    :vartype storage_account_type: str or
     ~azure.mgmt.compute.v2017_12_01.models.StorageAccountTypes
    """

    _validation = {
        "lun": {"required": True},
    }

    _attribute_map = {
        "lun": {"key": "lun", "type": "int"},
        "snapshot": {"key": "snapshot", "type": "SubResource"},
        "managed_disk": {"key": "managedDisk", "type": "SubResource"},
        "blob_uri": {"key": "blobUri", "type": "str"},
        "caching": {"key": "caching", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
    }

    def __init__(
        self,
        *,
        lun: int,
        snapshot: Optional["_models.SubResource"] = None,
        managed_disk: Optional["_models.SubResource"] = None,
        blob_uri: Optional[str] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = None,
        **kwargs
    ):
        """
        :keyword lun: Specifies the logical unit number of the data disk. This value is used to
         identify data disks within the VM and therefore must be unique for each data disk attached to a
         VM. Required.
        :paramtype lun: int
        :keyword snapshot: The snapshot.
        :paramtype snapshot: ~azure.mgmt.compute.v2017_12_01.models.SubResource
        :keyword managed_disk: The managedDisk.
        :paramtype managed_disk: ~azure.mgmt.compute.v2017_12_01.models.SubResource
        :keyword blob_uri: The Virtual Hard Disk.
        :paramtype blob_uri: str
        :keyword caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
         :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
         storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.v2017_12_01.models.CachingTypes
        :keyword disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
         used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
         This value cannot be larger than 1023 GB.
        :paramtype disk_size_gb: int
        :keyword storage_account_type: Specifies the storage account type for the managed disk.
         Possible values are: Standard_LRS or Premium_LRS. Known values are: "Standard_LRS" and
         "Premium_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.v2017_12_01.models.StorageAccountTypes
        """
        super().__init__(**kwargs)
        self.lun = lun
        self.snapshot = snapshot
        self.managed_disk = managed_disk
        self.blob_uri = blob_uri
        self.caching = caching
        self.disk_size_gb = disk_size_gb
        self.storage_account_type = storage_account_type


class ImageListResult(_serialization.Model):
    """The List Image operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of Images. Required.
    :vartype value: list[~azure.mgmt.compute.v2017_12_01.models.Image]
    :ivar next_link: The uri to fetch the next page of Images. Call ListNext() with this to fetch
     the next page of Images.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Image]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Image"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The list of Images. Required.
        :paramtype value: list[~azure.mgmt.compute.v2017_12_01.models.Image]
        :keyword next_link: The uri to fetch the next page of Images. Call ListNext() with this to
         fetch the next page of Images.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ImageOSDisk(_serialization.Model):
    """Describes an Operating System disk.

    All required parameters must be populated in order to send to Azure.

    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk if creating a VM from a custom image. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Required. Known values
     are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.v2017_12_01.models.OperatingSystemTypes
    :ivar os_state: The OS State. Required. Known values are: "Generalized" and "Specialized".
    :vartype os_state: str or ~azure.mgmt.compute.v2017_12_01.models.OperatingSystemStateTypes
    :ivar snapshot: The snapshot.
    :vartype snapshot: ~azure.mgmt.compute.v2017_12_01.models.SubResource
    :ivar managed_disk: The managedDisk.
    :vartype managed_disk: ~azure.mgmt.compute.v2017_12_01.models.SubResource
    :ivar blob_uri: The Virtual Hard Disk.
    :vartype blob_uri: str
    :ivar caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.v2017_12_01.models.CachingTypes
    :ivar disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
     used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :vartype disk_size_gb: int
    :ivar storage_account_type: Specifies the storage account type for the managed disk. Possible
     values are: Standard_LRS or Premium_LRS. Known values are: "Standard_LRS" and "Premium_LRS".
    :vartype storage_account_type: str or
     ~azure.mgmt.compute.v2017_12_01.models.StorageAccountTypes
    """

    _validation = {
        "os_type": {"required": True},
        "os_state": {"required": True},
    }

    _attribute_map = {
        "os_type": {"key": "osType", "type": "str"},
        "os_state": {"key": "osState", "type": "str"},
        "snapshot": {"key": "snapshot", "type": "SubResource"},
        "managed_disk": {"key": "managedDisk", "type": "SubResource"},
        "blob_uri": {"key": "blobUri", "type": "str"},
        "caching": {"key": "caching", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
    }

    def __init__(
        self,
        *,
        os_type: Union[str, "_models.OperatingSystemTypes"],
        os_state: Union[str, "_models.OperatingSystemStateTypes"],
        snapshot: Optional["_models.SubResource"] = None,
        managed_disk: Optional["_models.SubResource"] = None,
        blob_uri: Optional[str] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = None,
        **kwargs
    ):
        """
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk if creating a VM from a custom image. :code:`<br>`:code:`<br>` Possible values are:
         :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Required. Known values
         are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.v2017_12_01.models.OperatingSystemTypes
        :keyword os_state: The OS State. Required. Known values are: "Generalized" and "Specialized".
        :paramtype os_state: str or ~azure.mgmt.compute.v2017_12_01.models.OperatingSystemStateTypes
        :keyword snapshot: The snapshot.
        :paramtype snapshot: ~azure.mgmt.compute.v2017_12_01.models.SubResource
        :keyword managed_disk: The managedDisk.
        :paramtype managed_disk: ~azure.mgmt.compute.v2017_12_01.models.SubResource
        :keyword blob_uri: The Virtual Hard Disk.
        :paramtype blob_uri: str
        :keyword caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
         :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
         storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.v2017_12_01.models.CachingTypes
        :keyword disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
         used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
         This value cannot be larger than 1023 GB.
        :paramtype disk_size_gb: int
        :keyword storage_account_type: Specifies the storage account type for the managed disk.
         Possible values are: Standard_LRS or Premium_LRS. Known values are: "Standard_LRS" and
         "Premium_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.v2017_12_01.models.StorageAccountTypes
        """
        super().__init__(**kwargs)
        self.os_type = os_type
        self.os_state = os_state
        self.snapshot = snapshot
        self.managed_disk = managed_disk
        self.blob_uri = blob_uri
        self.caching = caching
        self.disk_size_gb = disk_size_gb
        self.storage_account_type = storage_account_type


class SubResource(_serialization.Model):
    """SubResource.

    :ivar id: Resource Id.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource Id.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class ImageReference(SubResource):
    """Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations. NOTE: Image reference publisher and offer can only be set when you create the scale set.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar publisher: The image publisher.
    :vartype publisher: str
    :ivar offer: Specifies the offer of the platform image or marketplace image used to create the
     virtual machine.
    :vartype offer: str
    :ivar sku: The image SKU.
    :vartype sku: str
    :ivar version: Specifies the version of the platform image or marketplace image used to create
     the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and
     Build are decimal numbers. Specify 'latest' to use the latest version of an image available at
     deploy time. Even if you use 'latest', the VM image will not automatically update after deploy
     time even if a new version becomes available.
    :vartype version: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "offer": {"key": "offer", "type": "str"},
        "sku": {"key": "sku", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        publisher: Optional[str] = None,
        offer: Optional[str] = None,
        sku: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword publisher: The image publisher.
        :paramtype publisher: str
        :keyword offer: Specifies the offer of the platform image or marketplace image used to create
         the virtual machine.
        :paramtype offer: str
        :keyword sku: The image SKU.
        :paramtype sku: str
        :keyword version: Specifies the version of the platform image or marketplace image used to
         create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major,
         Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image
         available at deploy time. Even if you use 'latest', the VM image will not automatically update
         after deploy time even if a new version becomes available.
        :paramtype version: str
        """
        super().__init__(id=id, **kwargs)
        self.publisher = publisher
        self.offer = offer
        self.sku = sku
        self.version = version


class ImageStorageProfile(_serialization.Model):
    """Describes a storage profile.

    :ivar os_disk: Specifies information about the operating system disk used by the virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
    :vartype os_disk: ~azure.mgmt.compute.v2017_12_01.models.ImageOSDisk
    :ivar data_disks: Specifies the parameters that are used to add a data disk to a virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
    :vartype data_disks: list[~azure.mgmt.compute.v2017_12_01.models.ImageDataDisk]
    :ivar zone_resilient: Specifies whether an image is zone resilient or not. Default is false.
     Zone resilient images can be created only in regions that provide Zone Redundant Storage (ZRS).
    :vartype zone_resilient: bool
    """

    _attribute_map = {
        "os_disk": {"key": "osDisk", "type": "ImageOSDisk"},
        "data_disks": {"key": "dataDisks", "type": "[ImageDataDisk]"},
        "zone_resilient": {"key": "zoneResilient", "type": "bool"},
    }

    def __init__(
        self,
        *,
        os_disk: Optional["_models.ImageOSDisk"] = None,
        data_disks: Optional[List["_models.ImageDataDisk"]] = None,
        zone_resilient: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword os_disk: Specifies information about the operating system disk used by the virtual
         machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
         for Azure virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
        :paramtype os_disk: ~azure.mgmt.compute.v2017_12_01.models.ImageOSDisk
        :keyword data_disks: Specifies the parameters that are used to add a data disk to a virtual
         machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
         for Azure virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
        :paramtype data_disks: list[~azure.mgmt.compute.v2017_12_01.models.ImageDataDisk]
        :keyword zone_resilient: Specifies whether an image is zone resilient or not. Default is false.
         Zone resilient images can be created only in regions that provide Zone Redundant Storage (ZRS).
        :paramtype zone_resilient: bool
        """
        super().__init__(**kwargs)
        self.os_disk = os_disk
        self.data_disks = data_disks
        self.zone_resilient = zone_resilient


class ImageUpdate(UpdateResource):
    """The source user image virtual hard disk. Only tags may be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar source_virtual_machine: The source virtual machine from which Image is created.
    :vartype source_virtual_machine: ~azure.mgmt.compute.v2017_12_01.models.SubResource
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile: ~azure.mgmt.compute.v2017_12_01.models.ImageStorageProfile
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "source_virtual_machine": {"key": "properties.sourceVirtualMachine", "type": "SubResource"},
        "storage_profile": {"key": "properties.storageProfile", "type": "ImageStorageProfile"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        source_virtual_machine: Optional["_models.SubResource"] = None,
        storage_profile: Optional["_models.ImageStorageProfile"] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword source_virtual_machine: The source virtual machine from which Image is created.
        :paramtype source_virtual_machine: ~azure.mgmt.compute.v2017_12_01.models.SubResource
        :keyword storage_profile: Specifies the storage settings for the virtual machine disks.
        :paramtype storage_profile: ~azure.mgmt.compute.v2017_12_01.models.ImageStorageProfile
        """
        super().__init__(tags=tags, **kwargs)
        self.source_virtual_machine = source_virtual_machine
        self.storage_profile = storage_profile
        self.provisioning_state = None


class InnerError(_serialization.Model):
    """Inner error details.

    :ivar exceptiontype: The exception type.
    :vartype exceptiontype: str
    :ivar errordetail: The internal error message or exception dump.
    :vartype errordetail: str
    """

    _attribute_map = {
        "exceptiontype": {"key": "exceptiontype", "type": "str"},
        "errordetail": {"key": "errordetail", "type": "str"},
    }

    def __init__(self, *, exceptiontype: Optional[str] = None, errordetail: Optional[str] = None, **kwargs):
        """
        :keyword exceptiontype: The exception type.
        :paramtype exceptiontype: str
        :keyword errordetail: The internal error message or exception dump.
        :paramtype errordetail: str
        """
        super().__init__(**kwargs)
        self.exceptiontype = exceptiontype
        self.errordetail = errordetail


class InstanceViewStatus(_serialization.Model):
    """Instance view status.

    :ivar code: The status code.
    :vartype code: str
    :ivar level: The level code. Known values are: "Info", "Warning", and "Error".
    :vartype level: str or ~azure.mgmt.compute.v2017_12_01.models.StatusLevelTypes
    :ivar display_status: The short localizable label for the status.
    :vartype display_status: str
    :ivar message: The detailed status message, including for alerts and error messages.
    :vartype message: str
    :ivar time: The time of the status.
    :vartype time: ~datetime.datetime
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "level": {"key": "level", "type": "str"},
        "display_status": {"key": "displayStatus", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "time": {"key": "time", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        level: Optional[Union[str, "_models.StatusLevelTypes"]] = None,
        display_status: Optional[str] = None,
        message: Optional[str] = None,
        time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword code: The status code.
        :paramtype code: str
        :keyword level: The level code. Known values are: "Info", "Warning", and "Error".
        :paramtype level: str or ~azure.mgmt.compute.v2017_12_01.models.StatusLevelTypes
        :keyword display_status: The short localizable label for the status.
        :paramtype display_status: str
        :keyword message: The detailed status message, including for alerts and error messages.
        :paramtype message: str
        :keyword time: The time of the status.
        :paramtype time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.code = code
        self.level = level
        self.display_status = display_status
        self.message = message
        self.time = time


class KeyVaultKeyReference(_serialization.Model):
    """Describes a reference to Key Vault Key.

    All required parameters must be populated in order to send to Azure.

    :ivar key_url: The URL referencing a key encryption key in Key Vault. Required.
    :vartype key_url: str
    :ivar source_vault: The relative URL of the Key Vault containing the key. Required.
    :vartype source_vault: ~azure.mgmt.compute.v2017_12_01.models.SubResource
    """

    _validation = {
        "key_url": {"required": True},
        "source_vault": {"required": True},
    }

    _attribute_map = {
        "key_url": {"key": "keyUrl", "type": "str"},
        "source_vault": {"key": "sourceVault", "type": "SubResource"},
    }

    def __init__(self, *, key_url: str, source_vault: "_models.SubResource", **kwargs):
        """
        :keyword key_url: The URL referencing a key encryption key in Key Vault. Required.
        :paramtype key_url: str
        :keyword source_vault: The relative URL of the Key Vault containing the key. Required.
        :paramtype source_vault: ~azure.mgmt.compute.v2017_12_01.models.SubResource
        """
        super().__init__(**kwargs)
        self.key_url = key_url
        self.source_vault = source_vault


class KeyVaultSecretReference(_serialization.Model):
    """Describes a reference to Key Vault Secret.

    All required parameters must be populated in order to send to Azure.

    :ivar secret_url: The URL referencing a secret in a Key Vault. Required.
    :vartype secret_url: str
    :ivar source_vault: The relative URL of the Key Vault containing the secret. Required.
    :vartype source_vault: ~azure.mgmt.compute.v2017_12_01.models.SubResource
    """

    _validation = {
        "secret_url": {"required": True},
        "source_vault": {"required": True},
    }

    _attribute_map = {
        "secret_url": {"key": "secretUrl", "type": "str"},
        "source_vault": {"key": "sourceVault", "type": "SubResource"},
    }

    def __init__(self, *, secret_url: str, source_vault: "_models.SubResource", **kwargs):
        """
        :keyword secret_url: The URL referencing a secret in a Key Vault. Required.
        :paramtype secret_url: str
        :keyword source_vault: The relative URL of the Key Vault containing the secret. Required.
        :paramtype source_vault: ~azure.mgmt.compute.v2017_12_01.models.SubResource
        """
        super().__init__(**kwargs)
        self.secret_url = secret_url
        self.source_vault = source_vault


class LinuxConfiguration(_serialization.Model):
    """Specifies the Linux operating system settings on the virtual machine. :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on Azure-Endorsed Distributions <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_ :code:`<br>`:code:`<br>` For running non-endorsed distributions, see `Information for Non-Endorsed Distributions <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.

    :ivar disable_password_authentication: Specifies whether password authentication should be
     disabled.
    :vartype disable_password_authentication: bool
    :ivar ssh: Specifies the ssh key configuration for a Linux OS.
    :vartype ssh: ~azure.mgmt.compute.v2017_12_01.models.SshConfiguration
    """

    _attribute_map = {
        "disable_password_authentication": {"key": "disablePasswordAuthentication", "type": "bool"},
        "ssh": {"key": "ssh", "type": "SshConfiguration"},
    }

    def __init__(
        self,
        *,
        disable_password_authentication: Optional[bool] = None,
        ssh: Optional["_models.SshConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword disable_password_authentication: Specifies whether password authentication should be
         disabled.
        :paramtype disable_password_authentication: bool
        :keyword ssh: Specifies the ssh key configuration for a Linux OS.
        :paramtype ssh: ~azure.mgmt.compute.v2017_12_01.models.SshConfiguration
        """
        super().__init__(**kwargs)
        self.disable_password_authentication = disable_password_authentication
        self.ssh = ssh


class ListUsagesResult(_serialization.Model):
    """The List Usages operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of compute resource usages. Required.
    :vartype value: list[~azure.mgmt.compute.v2017_12_01.models.Usage]
    :ivar next_link: The URI to fetch the next page of compute resource usage information. Call
     ListNext() with this to fetch the next page of compute resource usage information.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Usage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Usage"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The list of compute resource usages. Required.
        :paramtype value: list[~azure.mgmt.compute.v2017_12_01.models.Usage]
        :keyword next_link: The URI to fetch the next page of compute resource usage information. Call
         ListNext() with this to fetch the next page of compute resource usage information.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class LogAnalyticsInputBase(_serialization.Model):
    """Api input base class for LogAnalytics Api.

    All required parameters must be populated in order to send to Azure.

    :ivar blob_container_sas_uri: SAS Uri of the logging blob container to which LogAnalytics Api
     writes output logs to. Required.
    :vartype blob_container_sas_uri: str
    :ivar from_time: From time of the query. Required.
    :vartype from_time: ~datetime.datetime
    :ivar to_time: To time of the query. Required.
    :vartype to_time: ~datetime.datetime
    :ivar group_by_throttle_policy: Group query result by Throttle Policy applied.
    :vartype group_by_throttle_policy: bool
    :ivar group_by_operation_name: Group query result by Operation Name.
    :vartype group_by_operation_name: bool
    :ivar group_by_resource_name: Group query result by Resource Name.
    :vartype group_by_resource_name: bool
    """

    _validation = {
        "blob_container_sas_uri": {"required": True},
        "from_time": {"required": True},
        "to_time": {"required": True},
    }

    _attribute_map = {
        "blob_container_sas_uri": {"key": "blobContainerSasUri", "type": "str"},
        "from_time": {"key": "fromTime", "type": "iso-8601"},
        "to_time": {"key": "toTime", "type": "iso-8601"},
        "group_by_throttle_policy": {"key": "groupByThrottlePolicy", "type": "bool"},
        "group_by_operation_name": {"key": "groupByOperationName", "type": "bool"},
        "group_by_resource_name": {"key": "groupByResourceName", "type": "bool"},
    }

    def __init__(
        self,
        *,
        blob_container_sas_uri: str,
        from_time: datetime.datetime,
        to_time: datetime.datetime,
        group_by_throttle_policy: Optional[bool] = None,
        group_by_operation_name: Optional[bool] = None,
        group_by_resource_name: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword blob_container_sas_uri: SAS Uri of the logging blob container to which LogAnalytics
         Api writes output logs to. Required.
        :paramtype blob_container_sas_uri: str
        :keyword from_time: From time of the query. Required.
        :paramtype from_time: ~datetime.datetime
        :keyword to_time: To time of the query. Required.
        :paramtype to_time: ~datetime.datetime
        :keyword group_by_throttle_policy: Group query result by Throttle Policy applied.
        :paramtype group_by_throttle_policy: bool
        :keyword group_by_operation_name: Group query result by Operation Name.
        :paramtype group_by_operation_name: bool
        :keyword group_by_resource_name: Group query result by Resource Name.
        :paramtype group_by_resource_name: bool
        """
        super().__init__(**kwargs)
        self.blob_container_sas_uri = blob_container_sas_uri
        self.from_time = from_time
        self.to_time = to_time
        self.group_by_throttle_policy = group_by_throttle_policy
        self.group_by_operation_name = group_by_operation_name
        self.group_by_resource_name = group_by_resource_name


class OperationStatusResponse(_serialization.Model):
    """Operation status response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation ID.
    :vartype name: str
    :ivar status: Operation status.
    :vartype status: str
    :ivar start_time: Start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar error: Api error.
    :vartype error: ~azure.mgmt.compute.v2017_12_01.models.ApiError
    """

    _validation = {
        "name": {"readonly": True},
        "status": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "error": {"key": "error", "type": "ApiError"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.status = None
        self.start_time = None
        self.end_time = None
        self.error = None


class LogAnalyticsOperationResult(OperationStatusResponse):
    """LogAnalytics operation status response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation ID.
    :vartype name: str
    :ivar status: Operation status.
    :vartype status: str
    :ivar start_time: Start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar error: Api error.
    :vartype error: ~azure.mgmt.compute.v2017_12_01.models.ApiError
    :ivar properties: LogAnalyticsOutput.
    :vartype properties: ~azure.mgmt.compute.v2017_12_01.models.LogAnalyticsOutput
    """

    _validation = {
        "name": {"readonly": True},
        "status": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
        "error": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "error": {"key": "error", "type": "ApiError"},
        "properties": {"key": "properties", "type": "LogAnalyticsOutput"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.properties = None


class LogAnalyticsOutput(_serialization.Model):
    """LogAnalytics output properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar output: Output file Uri path to blob container.
    :vartype output: str
    """

    _validation = {
        "output": {"readonly": True},
    }

    _attribute_map = {
        "output": {"key": "output", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.output = None


class MaintenanceRedeployStatus(_serialization.Model):
    """Maintenance Operation Status.

    :ivar is_customer_initiated_maintenance_allowed: True, if customer is allowed to perform
     Maintenance.
    :vartype is_customer_initiated_maintenance_allowed: bool
    :ivar pre_maintenance_window_start_time: Start Time for the Pre Maintenance Window.
    :vartype pre_maintenance_window_start_time: ~datetime.datetime
    :ivar pre_maintenance_window_end_time: End Time for the Pre Maintenance Window.
    :vartype pre_maintenance_window_end_time: ~datetime.datetime
    :ivar maintenance_window_start_time: Start Time for the Maintenance Window.
    :vartype maintenance_window_start_time: ~datetime.datetime
    :ivar maintenance_window_end_time: End Time for the Maintenance Window.
    :vartype maintenance_window_end_time: ~datetime.datetime
    :ivar last_operation_result_code: The Last Maintenance Operation Result Code. Known values are:
     "None", "RetryLater", "MaintenanceAborted", and "MaintenanceCompleted".
    :vartype last_operation_result_code: str or
     ~azure.mgmt.compute.v2017_12_01.models.MaintenanceOperationResultCodeTypes
    :ivar last_operation_message: Message returned for the last Maintenance Operation.
    :vartype last_operation_message: str
    """

    _attribute_map = {
        "is_customer_initiated_maintenance_allowed": {"key": "isCustomerInitiatedMaintenanceAllowed", "type": "bool"},
        "pre_maintenance_window_start_time": {"key": "preMaintenanceWindowStartTime", "type": "iso-8601"},
        "pre_maintenance_window_end_time": {"key": "preMaintenanceWindowEndTime", "type": "iso-8601"},
        "maintenance_window_start_time": {"key": "maintenanceWindowStartTime", "type": "iso-8601"},
        "maintenance_window_end_time": {"key": "maintenanceWindowEndTime", "type": "iso-8601"},
        "last_operation_result_code": {"key": "lastOperationResultCode", "type": "str"},
        "last_operation_message": {"key": "lastOperationMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        is_customer_initiated_maintenance_allowed: Optional[bool] = None,
        pre_maintenance_window_start_time: Optional[datetime.datetime] = None,
        pre_maintenance_window_end_time: Optional[datetime.datetime] = None,
        maintenance_window_start_time: Optional[datetime.datetime] = None,
        maintenance_window_end_time: Optional[datetime.datetime] = None,
        last_operation_result_code: Optional[Union[str, "_models.MaintenanceOperationResultCodeTypes"]] = None,
        last_operation_message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword is_customer_initiated_maintenance_allowed: True, if customer is allowed to perform
         Maintenance.
        :paramtype is_customer_initiated_maintenance_allowed: bool
        :keyword pre_maintenance_window_start_time: Start Time for the Pre Maintenance Window.
        :paramtype pre_maintenance_window_start_time: ~datetime.datetime
        :keyword pre_maintenance_window_end_time: End Time for the Pre Maintenance Window.
        :paramtype pre_maintenance_window_end_time: ~datetime.datetime
        :keyword maintenance_window_start_time: Start Time for the Maintenance Window.
        :paramtype maintenance_window_start_time: ~datetime.datetime
        :keyword maintenance_window_end_time: End Time for the Maintenance Window.
        :paramtype maintenance_window_end_time: ~datetime.datetime
        :keyword last_operation_result_code: The Last Maintenance Operation Result Code. Known values
         are: "None", "RetryLater", "MaintenanceAborted", and "MaintenanceCompleted".
        :paramtype last_operation_result_code: str or
         ~azure.mgmt.compute.v2017_12_01.models.MaintenanceOperationResultCodeTypes
        :keyword last_operation_message: Message returned for the last Maintenance Operation.
        :paramtype last_operation_message: str
        """
        super().__init__(**kwargs)
        self.is_customer_initiated_maintenance_allowed = is_customer_initiated_maintenance_allowed
        self.pre_maintenance_window_start_time = pre_maintenance_window_start_time
        self.pre_maintenance_window_end_time = pre_maintenance_window_end_time
        self.maintenance_window_start_time = maintenance_window_start_time
        self.maintenance_window_end_time = maintenance_window_end_time
        self.last_operation_result_code = last_operation_result_code
        self.last_operation_message = last_operation_message


class ManagedDiskParameters(SubResource):
    """The parameters of a managed disk.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar storage_account_type: Specifies the storage account type for the managed disk. Possible
     values are: Standard_LRS or Premium_LRS. Known values are: "Standard_LRS" and "Premium_LRS".
    :vartype storage_account_type: str or
     ~azure.mgmt.compute.v2017_12_01.models.StorageAccountTypes
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        storage_account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword storage_account_type: Specifies the storage account type for the managed disk.
         Possible values are: Standard_LRS or Premium_LRS. Known values are: "Standard_LRS" and
         "Premium_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.v2017_12_01.models.StorageAccountTypes
        """
        super().__init__(id=id, **kwargs)
        self.storage_account_type = storage_account_type


class NetworkInterfaceReference(SubResource):
    """Describes a network interface reference.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :vartype primary: bool
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "primary": {"key": "properties.primary", "type": "bool"},
    }

    def __init__(
        self, *, id: Optional[str] = None, primary: Optional[bool] = None, **kwargs  # pylint: disable=redefined-builtin
    ):
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword primary: Specifies the primary network interface in case the virtual machine has more
         than 1 network interface.
        :paramtype primary: bool
        """
        super().__init__(id=id, **kwargs)
        self.primary = primary


class NetworkProfile(_serialization.Model):
    """Specifies the network interfaces of the virtual machine.

    :ivar network_interfaces: Specifies the list of resource Ids for the network interfaces
     associated with the virtual machine.
    :vartype network_interfaces:
     list[~azure.mgmt.compute.v2017_12_01.models.NetworkInterfaceReference]
    """

    _attribute_map = {
        "network_interfaces": {"key": "networkInterfaces", "type": "[NetworkInterfaceReference]"},
    }

    def __init__(self, *, network_interfaces: Optional[List["_models.NetworkInterfaceReference"]] = None, **kwargs):
        """
        :keyword network_interfaces: Specifies the list of resource Ids for the network interfaces
         associated with the virtual machine.
        :paramtype network_interfaces:
         list[~azure.mgmt.compute.v2017_12_01.models.NetworkInterfaceReference]
        """
        super().__init__(**kwargs)
        self.network_interfaces = network_interfaces


class OSDisk(_serialization.Model):
    """Specifies information about the operating system disk used by the virtual machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs for Azure virtual machines <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.

    All required parameters must be populated in order to send to Azure.

    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk if creating a VM from user-image or a specialized VHD. :code:`<br>`:code:`<br>` Possible
     values are: :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known
     values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.v2017_12_01.models.OperatingSystemTypes
    :ivar encryption_settings: Specifies the encryption settings for the OS Disk.
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :vartype encryption_settings: ~azure.mgmt.compute.v2017_12_01.models.DiskEncryptionSettings
    :ivar name: The disk name.
    :vartype name: str
    :ivar vhd: The virtual hard disk.
    :vartype vhd: ~azure.mgmt.compute.v2017_12_01.models.VirtualHardDisk
    :ivar image: The source user image virtual hard disk. The virtual hard disk will be copied
     before being attached to the virtual machine. If SourceImage is provided, the destination
     virtual hard drive must not exist.
    :vartype image: ~azure.mgmt.compute.v2017_12_01.models.VirtualHardDisk
    :ivar caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.v2017_12_01.models.CachingTypes
    :ivar write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :vartype write_accelerator_enabled: bool
    :ivar create_option: Specifies how the virtual machine should be
     created.:code:`<br>`:code:`<br>` Possible values are::code:`<br>`:code:`<br>` **Attach** \u2013
     This value is used when you are using a specialized disk to create the virtual
     machine.:code:`<br>`:code:`<br>` **FromImage** \u2013 This value is used when you are using an
     image to create the virtual machine. If you are using a platform image, you also use the
     imageReference element described above. If you are using a marketplace image, you  also use the
     plan element previously described. Required. Known values are: "FromImage", "Empty", and
     "Attach".
    :vartype create_option: str or ~azure.mgmt.compute.v2017_12_01.models.DiskCreateOptionTypes
    :ivar disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :vartype disk_size_gb: int
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk: ~azure.mgmt.compute.v2017_12_01.models.ManagedDiskParameters
    """

    _validation = {
        "create_option": {"required": True},
    }

    _attribute_map = {
        "os_type": {"key": "osType", "type": "str"},
        "encryption_settings": {"key": "encryptionSettings", "type": "DiskEncryptionSettings"},
        "name": {"key": "name", "type": "str"},
        "vhd": {"key": "vhd", "type": "VirtualHardDisk"},
        "image": {"key": "image", "type": "VirtualHardDisk"},
        "caching": {"key": "caching", "type": "str"},
        "write_accelerator_enabled": {"key": "writeAcceleratorEnabled", "type": "bool"},
        "create_option": {"key": "createOption", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "managed_disk": {"key": "managedDisk", "type": "ManagedDiskParameters"},
    }

    def __init__(
        self,
        *,
        create_option: Union[str, "_models.DiskCreateOptionTypes"],
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        encryption_settings: Optional["_models.DiskEncryptionSettings"] = None,
        name: Optional[str] = None,
        vhd: Optional["_models.VirtualHardDisk"] = None,
        image: Optional["_models.VirtualHardDisk"] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["_models.ManagedDiskParameters"] = None,
        **kwargs
    ):
        """
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk if creating a VM from user-image or a specialized VHD. :code:`<br>`:code:`<br>`
         Possible values are: :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**.
         Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.v2017_12_01.models.OperatingSystemTypes
        :keyword encryption_settings: Specifies the encryption settings for the OS Disk.
         :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
        :paramtype encryption_settings: ~azure.mgmt.compute.v2017_12_01.models.DiskEncryptionSettings
        :keyword name: The disk name.
        :paramtype name: str
        :keyword vhd: The virtual hard disk.
        :paramtype vhd: ~azure.mgmt.compute.v2017_12_01.models.VirtualHardDisk
        :keyword image: The source user image virtual hard disk. The virtual hard disk will be copied
         before being attached to the virtual machine. If SourceImage is provided, the destination
         virtual hard drive must not exist.
        :paramtype image: ~azure.mgmt.compute.v2017_12_01.models.VirtualHardDisk
        :keyword caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
         :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
         storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.v2017_12_01.models.CachingTypes
        :keyword write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
         disabled on the disk.
        :paramtype write_accelerator_enabled: bool
        :keyword create_option: Specifies how the virtual machine should be
         created.:code:`<br>`:code:`<br>` Possible values are::code:`<br>`:code:`<br>` **Attach** \u2013
         This value is used when you are using a specialized disk to create the virtual
         machine.:code:`<br>`:code:`<br>` **FromImage** \u2013 This value is used when you are using an
         image to create the virtual machine. If you are using a platform image, you also use the
         imageReference element described above. If you are using a marketplace image, you  also use the
         plan element previously described. Required. Known values are: "FromImage", "Empty", and
         "Attach".
        :paramtype create_option: str or ~azure.mgmt.compute.v2017_12_01.models.DiskCreateOptionTypes
        :keyword disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can
         be used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
         This value cannot be larger than 1023 GB.
        :paramtype disk_size_gb: int
        :keyword managed_disk: The managed disk parameters.
        :paramtype managed_disk: ~azure.mgmt.compute.v2017_12_01.models.ManagedDiskParameters
        """
        super().__init__(**kwargs)
        self.os_type = os_type
        self.encryption_settings = encryption_settings
        self.name = name
        self.vhd = vhd
        self.image = image
        self.caching = caching
        self.write_accelerator_enabled = write_accelerator_enabled
        self.create_option = create_option
        self.disk_size_gb = disk_size_gb
        self.managed_disk = managed_disk


class OSDiskImage(_serialization.Model):
    """Contains the os disk image information.

    All required parameters must be populated in order to send to Azure.

    :ivar operating_system: The operating system of the osDiskImage. Required. Known values are:
     "Windows" and "Linux".
    :vartype operating_system: str or ~azure.mgmt.compute.v2017_12_01.models.OperatingSystemTypes
    """

    _validation = {
        "operating_system": {"required": True},
    }

    _attribute_map = {
        "operating_system": {"key": "operatingSystem", "type": "str"},
    }

    def __init__(self, *, operating_system: Union[str, "_models.OperatingSystemTypes"], **kwargs):
        """
        :keyword operating_system: The operating system of the osDiskImage. Required. Known values are:
         "Windows" and "Linux".
        :paramtype operating_system: str or ~azure.mgmt.compute.v2017_12_01.models.OperatingSystemTypes
        """
        super().__init__(**kwargs)
        self.operating_system = operating_system


class OSProfile(_serialization.Model):
    """Specifies the operating system settings for the virtual machine.

    :ivar computer_name: Specifies the host OS name of the virtual machine.
     :code:`<br>`:code:`<br>` This name cannot be updated after the VM is created.
     :code:`<br>`:code:`<br>` **Max-length (Windows):** 15 characters :code:`<br>`:code:`<br>`
     **Max-length (Linux):** 64 characters. :code:`<br>`:code:`<br>` For naming conventions and
     restrictions see `Azure infrastructure services implementation guidelines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-infrastructure-subscription-accounts-guidelines?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#1-naming-conventions>`_.
    :vartype computer_name: str
    :ivar admin_username: Specifies the name of the administrator account. :code:`<br>`:code:`<br>`
     **Windows-only restriction:** Cannot end in "." :code:`<br>`:code:`<br>` **Disallowed values:**
     "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1",
     "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest",
     "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2",
     "test3", "user4", "user5". :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character
     :code:`<br>`:code:`<br>` **Max-length (Linux):** 64 characters :code:`<br>`:code:`<br>`
     **Max-length (Windows):** 20 characters  :code:`<br>`:code:`<br>`:code:`<li>` For root access
     to the Linux VM, see `Using root privileges on Linux virtual machines in Azure
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_\
     :code:`<br>`:code:`<li>` For a list of built-in system users on Linux that should not be used
     in this field, see `Selecting User Names for Linux on Azure
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
    :vartype admin_username: str
    :ivar admin_password: Specifies the password of the administrator account.
     :code:`<br>`:code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`:code:`<br>`
     **Minimum-length (Linux):** 6 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 123
     characters :code:`<br>`:code:`<br>` **Max-length (Linux):** 72 characters
     :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be
     fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a
     digit :code:`<br>` Has a special character (Regex match [\W_]) :code:`<br>`:code:`<br>`
     **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
     "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`:code:`<br>` For
     resetting the password, see `How to reset the Remote Desktop service or its login password in a
     Windows VM
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_
     :code:`<br>`:code:`<br>` For resetting root password, see `Manage users, SSH, and check or
     repair disks on Azure Linux VMs using the VMAccess Extension
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#reset-root-password>`_.
    :vartype admin_password: str
    :ivar custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
     string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum
     length of the binary array is 65535 bytes. :code:`<br>`:code:`<br>` For using cloud-init for
     your VM, see `Using cloud-init to customize a Linux VM during creation
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
    :vartype custom_data: str
    :ivar windows_configuration: Specifies Windows operating system settings on the virtual
     machine.
    :vartype windows_configuration: ~azure.mgmt.compute.v2017_12_01.models.WindowsConfiguration
    :ivar linux_configuration: Specifies the Linux operating system settings on the virtual
     machine. :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on
     Azure-Endorsed Distributions
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_
     :code:`<br>`:code:`<br>` For running non-endorsed distributions, see `Information for
     Non-Endorsed Distributions
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
    :vartype linux_configuration: ~azure.mgmt.compute.v2017_12_01.models.LinuxConfiguration
    :ivar secrets: Specifies set of certificates that should be installed onto the virtual machine.
    :vartype secrets: list[~azure.mgmt.compute.v2017_12_01.models.VaultSecretGroup]
    """

    _attribute_map = {
        "computer_name": {"key": "computerName", "type": "str"},
        "admin_username": {"key": "adminUsername", "type": "str"},
        "admin_password": {"key": "adminPassword", "type": "str"},
        "custom_data": {"key": "customData", "type": "str"},
        "windows_configuration": {"key": "windowsConfiguration", "type": "WindowsConfiguration"},
        "linux_configuration": {"key": "linuxConfiguration", "type": "LinuxConfiguration"},
        "secrets": {"key": "secrets", "type": "[VaultSecretGroup]"},
    }

    def __init__(
        self,
        *,
        computer_name: Optional[str] = None,
        admin_username: Optional[str] = None,
        admin_password: Optional[str] = None,
        custom_data: Optional[str] = None,
        windows_configuration: Optional["_models.WindowsConfiguration"] = None,
        linux_configuration: Optional["_models.LinuxConfiguration"] = None,
        secrets: Optional[List["_models.VaultSecretGroup"]] = None,
        **kwargs
    ):
        """
        :keyword computer_name: Specifies the host OS name of the virtual machine.
         :code:`<br>`:code:`<br>` This name cannot be updated after the VM is created.
         :code:`<br>`:code:`<br>` **Max-length (Windows):** 15 characters :code:`<br>`:code:`<br>`
         **Max-length (Linux):** 64 characters. :code:`<br>`:code:`<br>` For naming conventions and
         restrictions see `Azure infrastructure services implementation guidelines
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-infrastructure-subscription-accounts-guidelines?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#1-naming-conventions>`_.
        :paramtype computer_name: str
        :keyword admin_username: Specifies the name of the administrator account.
         :code:`<br>`:code:`<br>` **Windows-only restriction:** Cannot end in "."
         :code:`<br>`:code:`<br>` **Disallowed values:** "administrator", "admin", "user", "user1",
         "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2",
         "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql",
         "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
         :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character :code:`<br>`:code:`<br>`
         **Max-length (Linux):** 64 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 20
         characters  :code:`<br>`:code:`<br>`:code:`<li>` For root access to the Linux VM, see `Using
         root privileges on Linux virtual machines in Azure
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_\
         :code:`<br>`:code:`<li>` For a list of built-in system users on Linux that should not be used
         in this field, see `Selecting User Names for Linux on Azure
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
        :paramtype admin_username: str
        :keyword admin_password: Specifies the password of the administrator account.
         :code:`<br>`:code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`:code:`<br>`
         **Minimum-length (Linux):** 6 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 123
         characters :code:`<br>`:code:`<br>` **Max-length (Linux):** 72 characters
         :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be
         fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a
         digit :code:`<br>` Has a special character (Regex match [\W_]) :code:`<br>`:code:`<br>`
         **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
         "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`:code:`<br>` For
         resetting the password, see `How to reset the Remote Desktop service or its login password in a
         Windows VM
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_
         :code:`<br>`:code:`<br>` For resetting root password, see `Manage users, SSH, and check or
         repair disks on Azure Linux VMs using the VMAccess Extension
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#reset-root-password>`_.
        :paramtype admin_password: str
        :keyword custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
         string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum
         length of the binary array is 65535 bytes. :code:`<br>`:code:`<br>` For using cloud-init for
         your VM, see `Using cloud-init to customize a Linux VM during creation
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
        :paramtype custom_data: str
        :keyword windows_configuration: Specifies Windows operating system settings on the virtual
         machine.
        :paramtype windows_configuration: ~azure.mgmt.compute.v2017_12_01.models.WindowsConfiguration
        :keyword linux_configuration: Specifies the Linux operating system settings on the virtual
         machine. :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on
         Azure-Endorsed Distributions
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_
         :code:`<br>`:code:`<br>` For running non-endorsed distributions, see `Information for
         Non-Endorsed Distributions
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
        :paramtype linux_configuration: ~azure.mgmt.compute.v2017_12_01.models.LinuxConfiguration
        :keyword secrets: Specifies set of certificates that should be installed onto the virtual
         machine.
        :paramtype secrets: list[~azure.mgmt.compute.v2017_12_01.models.VaultSecretGroup]
        """
        super().__init__(**kwargs)
        self.computer_name = computer_name
        self.admin_username = admin_username
        self.admin_password = admin_password
        self.custom_data = custom_data
        self.windows_configuration = windows_configuration
        self.linux_configuration = linux_configuration
        self.secrets = secrets


class Plan(_serialization.Model):
    """Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.

    :ivar name: The plan ID.
    :vartype name: str
    :ivar publisher: The publisher ID.
    :vartype publisher: str
    :ivar product: Specifies the product of the image from the marketplace. This is the same value
     as Offer under the imageReference element.
    :vartype product: str
    :ivar promotion_code: The promotion code.
    :vartype promotion_code: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "product": {"key": "product", "type": "str"},
        "promotion_code": {"key": "promotionCode", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        publisher: Optional[str] = None,
        product: Optional[str] = None,
        promotion_code: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The plan ID.
        :paramtype name: str
        :keyword publisher: The publisher ID.
        :paramtype publisher: str
        :keyword product: Specifies the product of the image from the marketplace. This is the same
         value as Offer under the imageReference element.
        :paramtype product: str
        :keyword promotion_code: The promotion code.
        :paramtype promotion_code: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product
        self.promotion_code = promotion_code


class PurchasePlan(_serialization.Model):
    """Used for establishing the purchase context of any 3rd Party artifact through MarketPlace.

    All required parameters must be populated in order to send to Azure.

    :ivar publisher: The publisher ID. Required.
    :vartype publisher: str
    :ivar name: The plan ID. Required.
    :vartype name: str
    :ivar product: Specifies the product of the image from the marketplace. This is the same value
     as Offer under the imageReference element. Required.
    :vartype product: str
    """

    _validation = {
        "publisher": {"required": True},
        "name": {"required": True},
        "product": {"required": True},
    }

    _attribute_map = {
        "publisher": {"key": "publisher", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "product": {"key": "product", "type": "str"},
    }

    def __init__(self, *, publisher: str, name: str, product: str, **kwargs):
        """
        :keyword publisher: The publisher ID. Required.
        :paramtype publisher: str
        :keyword name: The plan ID. Required.
        :paramtype name: str
        :keyword product: Specifies the product of the image from the marketplace. This is the same
         value as Offer under the imageReference element. Required.
        :paramtype product: str
        """
        super().__init__(**kwargs)
        self.publisher = publisher
        self.name = name
        self.product = product


class RecoveryWalkResponse(_serialization.Model):
    """Response after calling a manual recovery walk.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar walk_performed: Whether the recovery walk was performed.
    :vartype walk_performed: bool
    :ivar next_platform_update_domain: The next update domain that needs to be walked. Null means
     walk spanning all update domains has been completed.
    :vartype next_platform_update_domain: int
    """

    _validation = {
        "walk_performed": {"readonly": True},
        "next_platform_update_domain": {"readonly": True},
    }

    _attribute_map = {
        "walk_performed": {"key": "walkPerformed", "type": "bool"},
        "next_platform_update_domain": {"key": "nextPlatformUpdateDomain", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.walk_performed = None
        self.next_platform_update_domain = None


class RequestRateByIntervalInput(LogAnalyticsInputBase):
    """Api request input for LogAnalytics getRequestRateByInterval Api.

    All required parameters must be populated in order to send to Azure.

    :ivar blob_container_sas_uri: SAS Uri of the logging blob container to which LogAnalytics Api
     writes output logs to. Required.
    :vartype blob_container_sas_uri: str
    :ivar from_time: From time of the query. Required.
    :vartype from_time: ~datetime.datetime
    :ivar to_time: To time of the query. Required.
    :vartype to_time: ~datetime.datetime
    :ivar group_by_throttle_policy: Group query result by Throttle Policy applied.
    :vartype group_by_throttle_policy: bool
    :ivar group_by_operation_name: Group query result by Operation Name.
    :vartype group_by_operation_name: bool
    :ivar group_by_resource_name: Group query result by Resource Name.
    :vartype group_by_resource_name: bool
    :ivar interval_length: Interval value in minutes used to create LogAnalytics call rate logs.
     Required. Known values are: "ThreeMins", "FiveMins", "ThirtyMins", and "SixtyMins".
    :vartype interval_length: str or ~azure.mgmt.compute.v2017_12_01.models.IntervalInMins
    """

    _validation = {
        "blob_container_sas_uri": {"required": True},
        "from_time": {"required": True},
        "to_time": {"required": True},
        "interval_length": {"required": True},
    }

    _attribute_map = {
        "blob_container_sas_uri": {"key": "blobContainerSasUri", "type": "str"},
        "from_time": {"key": "fromTime", "type": "iso-8601"},
        "to_time": {"key": "toTime", "type": "iso-8601"},
        "group_by_throttle_policy": {"key": "groupByThrottlePolicy", "type": "bool"},
        "group_by_operation_name": {"key": "groupByOperationName", "type": "bool"},
        "group_by_resource_name": {"key": "groupByResourceName", "type": "bool"},
        "interval_length": {"key": "intervalLength", "type": "str"},
    }

    def __init__(
        self,
        *,
        blob_container_sas_uri: str,
        from_time: datetime.datetime,
        to_time: datetime.datetime,
        interval_length: Union[str, "_models.IntervalInMins"],
        group_by_throttle_policy: Optional[bool] = None,
        group_by_operation_name: Optional[bool] = None,
        group_by_resource_name: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword blob_container_sas_uri: SAS Uri of the logging blob container to which LogAnalytics
         Api writes output logs to. Required.
        :paramtype blob_container_sas_uri: str
        :keyword from_time: From time of the query. Required.
        :paramtype from_time: ~datetime.datetime
        :keyword to_time: To time of the query. Required.
        :paramtype to_time: ~datetime.datetime
        :keyword group_by_throttle_policy: Group query result by Throttle Policy applied.
        :paramtype group_by_throttle_policy: bool
        :keyword group_by_operation_name: Group query result by Operation Name.
        :paramtype group_by_operation_name: bool
        :keyword group_by_resource_name: Group query result by Resource Name.
        :paramtype group_by_resource_name: bool
        :keyword interval_length: Interval value in minutes used to create LogAnalytics call rate logs.
         Required. Known values are: "ThreeMins", "FiveMins", "ThirtyMins", and "SixtyMins".
        :paramtype interval_length: str or ~azure.mgmt.compute.v2017_12_01.models.IntervalInMins
        """
        super().__init__(
            blob_container_sas_uri=blob_container_sas_uri,
            from_time=from_time,
            to_time=to_time,
            group_by_throttle_policy=group_by_throttle_policy,
            group_by_operation_name=group_by_operation_name,
            group_by_resource_name=group_by_resource_name,
            **kwargs
        )
        self.interval_length = interval_length


class RollbackStatusInfo(_serialization.Model):
    """Information about rollback on failed VM instances after a OS Upgrade operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar successfully_rolledback_instance_count: The number of instances which have been
     successfully rolled back.
    :vartype successfully_rolledback_instance_count: int
    :ivar failed_rolledback_instance_count: The number of instances which failed to rollback.
    :vartype failed_rolledback_instance_count: int
    :ivar rollback_error: Error details if OS rollback failed.
    :vartype rollback_error: ~azure.mgmt.compute.v2017_12_01.models.ApiError
    """

    _validation = {
        "successfully_rolledback_instance_count": {"readonly": True},
        "failed_rolledback_instance_count": {"readonly": True},
        "rollback_error": {"readonly": True},
    }

    _attribute_map = {
        "successfully_rolledback_instance_count": {"key": "successfullyRolledbackInstanceCount", "type": "int"},
        "failed_rolledback_instance_count": {"key": "failedRolledbackInstanceCount", "type": "int"},
        "rollback_error": {"key": "rollbackError", "type": "ApiError"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.successfully_rolledback_instance_count = None
        self.failed_rolledback_instance_count = None
        self.rollback_error = None


class RollingUpgradePolicy(_serialization.Model):
    """The configuration parameters used while performing a rolling upgrade.

    :ivar max_batch_instance_percent: The maximum percent of total virtual machine instances that
     will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum,
     unhealthy instances in previous or future batches can cause the percentage of instances in a
     batch to decrease to ensure higher reliability. The default value for this parameter is 20%.
    :vartype max_batch_instance_percent: int
    :ivar max_unhealthy_instance_percent: The maximum percentage of the total virtual machine
     instances in the scale set that can be simultaneously unhealthy, either as a result of being
     upgraded, or by being found in an unhealthy state by the virtual machine health checks before
     the rolling upgrade aborts. This constraint will be checked prior to starting any batch. The
     default value for this parameter is 20%.
    :vartype max_unhealthy_instance_percent: int
    :ivar max_unhealthy_upgraded_instance_percent: The maximum percentage of upgraded virtual
     machine instances that can be found to be in an unhealthy state. This check will happen after
     each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. The
     default value for this parameter is 20%.
    :vartype max_unhealthy_upgraded_instance_percent: int
    :ivar pause_time_between_batches: The wait time between completing the update for all virtual
     machines in one batch and starting the next batch. The time duration should be specified in ISO
     8601 format. The default value is 0 seconds (PT0S).
    :vartype pause_time_between_batches: str
    """

    _validation = {
        "max_batch_instance_percent": {"maximum": 100, "minimum": 5},
        "max_unhealthy_instance_percent": {"maximum": 100, "minimum": 5},
        "max_unhealthy_upgraded_instance_percent": {"maximum": 100, "minimum": 0},
    }

    _attribute_map = {
        "max_batch_instance_percent": {"key": "maxBatchInstancePercent", "type": "int"},
        "max_unhealthy_instance_percent": {"key": "maxUnhealthyInstancePercent", "type": "int"},
        "max_unhealthy_upgraded_instance_percent": {"key": "maxUnhealthyUpgradedInstancePercent", "type": "int"},
        "pause_time_between_batches": {"key": "pauseTimeBetweenBatches", "type": "str"},
    }

    def __init__(
        self,
        *,
        max_batch_instance_percent: Optional[int] = None,
        max_unhealthy_instance_percent: Optional[int] = None,
        max_unhealthy_upgraded_instance_percent: Optional[int] = None,
        pause_time_between_batches: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword max_batch_instance_percent: The maximum percent of total virtual machine instances
         that will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum,
         unhealthy instances in previous or future batches can cause the percentage of instances in a
         batch to decrease to ensure higher reliability. The default value for this parameter is 20%.
        :paramtype max_batch_instance_percent: int
        :keyword max_unhealthy_instance_percent: The maximum percentage of the total virtual machine
         instances in the scale set that can be simultaneously unhealthy, either as a result of being
         upgraded, or by being found in an unhealthy state by the virtual machine health checks before
         the rolling upgrade aborts. This constraint will be checked prior to starting any batch. The
         default value for this parameter is 20%.
        :paramtype max_unhealthy_instance_percent: int
        :keyword max_unhealthy_upgraded_instance_percent: The maximum percentage of upgraded virtual
         machine instances that can be found to be in an unhealthy state. This check will happen after
         each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. The
         default value for this parameter is 20%.
        :paramtype max_unhealthy_upgraded_instance_percent: int
        :keyword pause_time_between_batches: The wait time between completing the update for all
         virtual machines in one batch and starting the next batch. The time duration should be
         specified in ISO 8601 format. The default value is 0 seconds (PT0S).
        :paramtype pause_time_between_batches: str
        """
        super().__init__(**kwargs)
        self.max_batch_instance_percent = max_batch_instance_percent
        self.max_unhealthy_instance_percent = max_unhealthy_instance_percent
        self.max_unhealthy_upgraded_instance_percent = max_unhealthy_upgraded_instance_percent
        self.pause_time_between_batches = pause_time_between_batches


class RollingUpgradeProgressInfo(_serialization.Model):
    """Information about the number of virtual machine instances in each upgrade state.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar successful_instance_count: The number of instances that have been successfully upgraded.
    :vartype successful_instance_count: int
    :ivar failed_instance_count: The number of instances that have failed to be upgraded
     successfully.
    :vartype failed_instance_count: int
    :ivar in_progress_instance_count: The number of instances that are currently being upgraded.
    :vartype in_progress_instance_count: int
    :ivar pending_instance_count: The number of instances that have not yet begun to be upgraded.
    :vartype pending_instance_count: int
    """

    _validation = {
        "successful_instance_count": {"readonly": True},
        "failed_instance_count": {"readonly": True},
        "in_progress_instance_count": {"readonly": True},
        "pending_instance_count": {"readonly": True},
    }

    _attribute_map = {
        "successful_instance_count": {"key": "successfulInstanceCount", "type": "int"},
        "failed_instance_count": {"key": "failedInstanceCount", "type": "int"},
        "in_progress_instance_count": {"key": "inProgressInstanceCount", "type": "int"},
        "pending_instance_count": {"key": "pendingInstanceCount", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.successful_instance_count = None
        self.failed_instance_count = None
        self.in_progress_instance_count = None
        self.pending_instance_count = None


class RollingUpgradeRunningStatus(_serialization.Model):
    """Information about the current running state of the overall upgrade.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Code indicating the current status of the upgrade. Known values are:
     "RollingForward", "Cancelled", "Completed", and "Faulted".
    :vartype code: str or ~azure.mgmt.compute.v2017_12_01.models.RollingUpgradeStatusCode
    :ivar start_time: Start time of the upgrade.
    :vartype start_time: ~datetime.datetime
    :ivar last_action: The last action performed on the rolling upgrade. Known values are: "Start"
     and "Cancel".
    :vartype last_action: str or ~azure.mgmt.compute.v2017_12_01.models.RollingUpgradeActionType
    :ivar last_action_time: Last action time of the upgrade.
    :vartype last_action_time: ~datetime.datetime
    """

    _validation = {
        "code": {"readonly": True},
        "start_time": {"readonly": True},
        "last_action": {"readonly": True},
        "last_action_time": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "last_action": {"key": "lastAction", "type": "str"},
        "last_action_time": {"key": "lastActionTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.start_time = None
        self.last_action = None
        self.last_action_time = None


class RollingUpgradeStatusInfo(Resource):
    """The status of the latest virtual machine scale set rolling upgrade.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar policy: The rolling upgrade policies applied for this upgrade.
    :vartype policy: ~azure.mgmt.compute.v2017_12_01.models.RollingUpgradePolicy
    :ivar running_status: Information about the current running state of the overall upgrade.
    :vartype running_status: ~azure.mgmt.compute.v2017_12_01.models.RollingUpgradeRunningStatus
    :ivar progress: Information about the number of virtual machine instances in each upgrade
     state.
    :vartype progress: ~azure.mgmt.compute.v2017_12_01.models.RollingUpgradeProgressInfo
    :ivar error: Error details for this upgrade, if there are any.
    :vartype error: ~azure.mgmt.compute.v2017_12_01.models.ApiError
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "policy": {"readonly": True},
        "running_status": {"readonly": True},
        "progress": {"readonly": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "policy": {"key": "properties.policy", "type": "RollingUpgradePolicy"},
        "running_status": {"key": "properties.runningStatus", "type": "RollingUpgradeRunningStatus"},
        "progress": {"key": "properties.progress", "type": "RollingUpgradeProgressInfo"},
        "error": {"key": "properties.error", "type": "ApiError"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.policy = None
        self.running_status = None
        self.progress = None
        self.error = None


class RunCommandDocumentBase(_serialization.Model):
    """Describes the properties of a Run Command metadata.

    All required parameters must be populated in order to send to Azure.

    :ivar schema: The VM run command schema. Required.
    :vartype schema: str
    :ivar id: The VM run command id. Required.
    :vartype id: str
    :ivar os_type: The Operating System type. Required. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.v2017_12_01.models.OperatingSystemTypes
    :ivar label: The VM run command label. Required.
    :vartype label: str
    :ivar description: The VM run command description. Required.
    :vartype description: str
    """

    _validation = {
        "schema": {"required": True},
        "id": {"required": True},
        "os_type": {"required": True},
        "label": {"required": True},
        "description": {"required": True},
    }

    _attribute_map = {
        "schema": {"key": "$schema", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        schema: str,
        id: str,  # pylint: disable=redefined-builtin
        os_type: Union[str, "_models.OperatingSystemTypes"],
        label: str,
        description: str,
        **kwargs
    ):
        """
        :keyword schema: The VM run command schema. Required.
        :paramtype schema: str
        :keyword id: The VM run command id. Required.
        :paramtype id: str
        :keyword os_type: The Operating System type. Required. Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.v2017_12_01.models.OperatingSystemTypes
        :keyword label: The VM run command label. Required.
        :paramtype label: str
        :keyword description: The VM run command description. Required.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.schema = schema
        self.id = id
        self.os_type = os_type
        self.label = label
        self.description = description


class RunCommandDocument(RunCommandDocumentBase):
    """Describes the properties of a Run Command.

    All required parameters must be populated in order to send to Azure.

    :ivar schema: The VM run command schema. Required.
    :vartype schema: str
    :ivar id: The VM run command id. Required.
    :vartype id: str
    :ivar os_type: The Operating System type. Required. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.v2017_12_01.models.OperatingSystemTypes
    :ivar label: The VM run command label. Required.
    :vartype label: str
    :ivar description: The VM run command description. Required.
    :vartype description: str
    :ivar script: The script to be executed. Required.
    :vartype script: list[str]
    :ivar parameters: The parameters used by the script.
    :vartype parameters: list[~azure.mgmt.compute.v2017_12_01.models.RunCommandParameterDefinition]
    """

    _validation = {
        "schema": {"required": True},
        "id": {"required": True},
        "os_type": {"required": True},
        "label": {"required": True},
        "description": {"required": True},
        "script": {"required": True},
    }

    _attribute_map = {
        "schema": {"key": "$schema", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "script": {"key": "script", "type": "[str]"},
        "parameters": {"key": "parameters", "type": "[RunCommandParameterDefinition]"},
    }

    def __init__(
        self,
        *,
        schema: str,
        id: str,  # pylint: disable=redefined-builtin
        os_type: Union[str, "_models.OperatingSystemTypes"],
        label: str,
        description: str,
        script: List[str],
        parameters: Optional[List["_models.RunCommandParameterDefinition"]] = None,
        **kwargs
    ):
        """
        :keyword schema: The VM run command schema. Required.
        :paramtype schema: str
        :keyword id: The VM run command id. Required.
        :paramtype id: str
        :keyword os_type: The Operating System type. Required. Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.v2017_12_01.models.OperatingSystemTypes
        :keyword label: The VM run command label. Required.
        :paramtype label: str
        :keyword description: The VM run command description. Required.
        :paramtype description: str
        :keyword script: The script to be executed. Required.
        :paramtype script: list[str]
        :keyword parameters: The parameters used by the script.
        :paramtype parameters:
         list[~azure.mgmt.compute.v2017_12_01.models.RunCommandParameterDefinition]
        """
        super().__init__(schema=schema, id=id, os_type=os_type, label=label, description=description, **kwargs)
        self.script = script
        self.parameters = parameters


class RunCommandInput(_serialization.Model):
    """Capture Virtual Machine parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar command_id: The run command id. Required.
    :vartype command_id: str
    :ivar script: Optional. The script to be executed.  When this value is given, the given script
     will override the default script of the command.
    :vartype script: list[str]
    :ivar parameters: The run command parameters.
    :vartype parameters: list[~azure.mgmt.compute.v2017_12_01.models.RunCommandInputParameter]
    """

    _validation = {
        "command_id": {"required": True},
    }

    _attribute_map = {
        "command_id": {"key": "commandId", "type": "str"},
        "script": {"key": "script", "type": "[str]"},
        "parameters": {"key": "parameters", "type": "[RunCommandInputParameter]"},
    }

    def __init__(
        self,
        *,
        command_id: str,
        script: Optional[List[str]] = None,
        parameters: Optional[List["_models.RunCommandInputParameter"]] = None,
        **kwargs
    ):
        """
        :keyword command_id: The run command id. Required.
        :paramtype command_id: str
        :keyword script: Optional. The script to be executed.  When this value is given, the given
         script will override the default script of the command.
        :paramtype script: list[str]
        :keyword parameters: The run command parameters.
        :paramtype parameters: list[~azure.mgmt.compute.v2017_12_01.models.RunCommandInputParameter]
        """
        super().__init__(**kwargs)
        self.command_id = command_id
        self.script = script
        self.parameters = parameters


class RunCommandInputParameter(_serialization.Model):
    """Describes the properties of a run command parameter.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The run command parameter name. Required.
    :vartype name: str
    :ivar value: The run command parameter value. Required.
    :vartype value: str
    """

    _validation = {
        "name": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: str, value: str, **kwargs):
        """
        :keyword name: The run command parameter name. Required.
        :paramtype name: str
        :keyword value: The run command parameter value. Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class RunCommandListResult(_serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of virtual machine run commands. Required.
    :vartype value: list[~azure.mgmt.compute.v2017_12_01.models.RunCommandDocumentBase]
    :ivar next_link: The uri to fetch the next page of run commands. Call ListNext() with this to
     fetch the next page of run commands.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RunCommandDocumentBase]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.RunCommandDocumentBase"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The list of virtual machine run commands. Required.
        :paramtype value: list[~azure.mgmt.compute.v2017_12_01.models.RunCommandDocumentBase]
        :keyword next_link: The uri to fetch the next page of run commands. Call ListNext() with this
         to fetch the next page of run commands.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RunCommandParameterDefinition(_serialization.Model):
    """Describes the properties of a run command parameter.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The run command parameter name. Required.
    :vartype name: str
    :ivar type: The run command parameter type. Required.
    :vartype type: str
    :ivar default_value: The run command parameter default value.
    :vartype default_value: str
    :ivar required: The run command parameter required.
    :vartype required: bool
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "default_value": {"key": "defaultValue", "type": "str"},
        "required": {"key": "required", "type": "bool"},
    }

    def __init__(self, *, name: str, type: str, default_value: Optional[str] = None, required: bool = False, **kwargs):
        """
        :keyword name: The run command parameter name. Required.
        :paramtype name: str
        :keyword type: The run command parameter type. Required.
        :paramtype type: str
        :keyword default_value: The run command parameter default value.
        :paramtype default_value: str
        :keyword required: The run command parameter required.
        :paramtype required: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type
        self.default_value = default_value
        self.required = required


class RunCommandResult(OperationStatusResponse):
    """Run command operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation ID.
    :vartype name: str
    :ivar status: Operation status.
    :vartype status: str
    :ivar start_time: Start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar error: Api error.
    :vartype error: ~azure.mgmt.compute.v2017_12_01.models.ApiError
    :ivar output: Operation output data (raw JSON).
    :vartype output: JSON
    """

    _validation = {
        "name": {"readonly": True},
        "status": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "error": {"key": "error", "type": "ApiError"},
        "output": {"key": "properties.output", "type": "object"},
    }

    def __init__(self, *, output: Optional[JSON] = None, **kwargs):
        """
        :keyword output: Operation output data (raw JSON).
        :paramtype output: JSON
        """
        super().__init__(**kwargs)
        self.output = output


class Sku(_serialization.Model):
    """Describes a virtual machine scale set sku. NOTE: If the new VM SKU is not supported on the hardware the scale set is currently on, you need to deallocate the VMs in the scale set before you modify the SKU name.

    :ivar name: The sku name.
    :vartype name: str
    :ivar tier: Specifies the tier of virtual machines in a scale set.:code:`<br />`:code:`<br />`
     Possible Values::code:`<br />`:code:`<br />` **Standard**\ :code:`<br />`:code:`<br />`
     **Basic**.
    :vartype tier: str
    :ivar capacity: Specifies the number of virtual machines in the scale set.
    :vartype capacity: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self, *, name: Optional[str] = None, tier: Optional[str] = None, capacity: Optional[int] = None, **kwargs
    ):
        """
        :keyword name: The sku name.
        :paramtype name: str
        :keyword tier: Specifies the tier of virtual machines in a scale set.:code:`<br />`:code:`<br
         />` Possible Values::code:`<br />`:code:`<br />` **Standard**\ :code:`<br />`:code:`<br />`
         **Basic**.
        :paramtype tier: str
        :keyword capacity: Specifies the number of virtual machines in the scale set.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity


class SshConfiguration(_serialization.Model):
    """SSH configuration for Linux based VMs running on Azure.

    :ivar public_keys: The list of SSH public keys used to authenticate with linux based VMs.
    :vartype public_keys: list[~azure.mgmt.compute.v2017_12_01.models.SshPublicKey]
    """

    _attribute_map = {
        "public_keys": {"key": "publicKeys", "type": "[SshPublicKey]"},
    }

    def __init__(self, *, public_keys: Optional[List["_models.SshPublicKey"]] = None, **kwargs):
        """
        :keyword public_keys: The list of SSH public keys used to authenticate with linux based VMs.
        :paramtype public_keys: list[~azure.mgmt.compute.v2017_12_01.models.SshPublicKey]
        """
        super().__init__(**kwargs)
        self.public_keys = public_keys


class SshPublicKey(_serialization.Model):
    """Contains information about SSH certificate public key and the path on the Linux VM where the public key is placed.

    :ivar path: Specifies the full path on the created VM where ssh public key is stored. If the
     file already exists, the specified key is appended to the file. Example:
     /home/user/.ssh/authorized_keys.
    :vartype path: str
    :ivar key_data: SSH public key certificate used to authenticate with the VM through ssh. The
     key needs to be at least 2048-bit and in ssh-rsa format. :code:`<br>`:code:`<br>` For creating
     ssh keys, see `Create SSH keys on Linux and Mac for Linux VMs in Azure
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
    :vartype key_data: str
    """

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "key_data": {"key": "keyData", "type": "str"},
    }

    def __init__(self, *, path: Optional[str] = None, key_data: Optional[str] = None, **kwargs):
        """
        :keyword path: Specifies the full path on the created VM where ssh public key is stored. If the
         file already exists, the specified key is appended to the file. Example:
         /home/user/.ssh/authorized_keys.
        :paramtype path: str
        :keyword key_data: SSH public key certificate used to authenticate with the VM through ssh. The
         key needs to be at least 2048-bit and in ssh-rsa format. :code:`<br>`:code:`<br>` For creating
         ssh keys, see `Create SSH keys on Linux and Mac for Linux VMs in Azure
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
        :paramtype key_data: str
        """
        super().__init__(**kwargs)
        self.path = path
        self.key_data = key_data


class StorageProfile(_serialization.Model):
    """Specifies the storage settings for the virtual machine disks.

    :ivar image_reference: Specifies information about the image to use. You can specify
     information about platform images, marketplace images, or virtual machine images. This element
     is required when you want to use a platform image, marketplace image, or virtual machine image,
     but is not used in other creation operations.
    :vartype image_reference: ~azure.mgmt.compute.v2017_12_01.models.ImageReference
    :ivar os_disk: Specifies information about the operating system disk used by the virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
    :vartype os_disk: ~azure.mgmt.compute.v2017_12_01.models.OSDisk
    :ivar data_disks: Specifies the parameters that are used to add a data disk to a virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
    :vartype data_disks: list[~azure.mgmt.compute.v2017_12_01.models.DataDisk]
    """

    _attribute_map = {
        "image_reference": {"key": "imageReference", "type": "ImageReference"},
        "os_disk": {"key": "osDisk", "type": "OSDisk"},
        "data_disks": {"key": "dataDisks", "type": "[DataDisk]"},
    }

    def __init__(
        self,
        *,
        image_reference: Optional["_models.ImageReference"] = None,
        os_disk: Optional["_models.OSDisk"] = None,
        data_disks: Optional[List["_models.DataDisk"]] = None,
        **kwargs
    ):
        """
        :keyword image_reference: Specifies information about the image to use. You can specify
         information about platform images, marketplace images, or virtual machine images. This element
         is required when you want to use a platform image, marketplace image, or virtual machine image,
         but is not used in other creation operations.
        :paramtype image_reference: ~azure.mgmt.compute.v2017_12_01.models.ImageReference
        :keyword os_disk: Specifies information about the operating system disk used by the virtual
         machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
         for Azure virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
        :paramtype os_disk: ~azure.mgmt.compute.v2017_12_01.models.OSDisk
        :keyword data_disks: Specifies the parameters that are used to add a data disk to a virtual
         machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
         for Azure virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
        :paramtype data_disks: list[~azure.mgmt.compute.v2017_12_01.models.DataDisk]
        """
        super().__init__(**kwargs)
        self.image_reference = image_reference
        self.os_disk = os_disk
        self.data_disks = data_disks


class SubResourceReadOnly(_serialization.Model):
    """SubResourceReadOnly.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None


class ThrottledRequestsInput(LogAnalyticsInputBase):
    """Api request input for LogAnalytics getThrottledRequests Api.

    All required parameters must be populated in order to send to Azure.

    :ivar blob_container_sas_uri: SAS Uri of the logging blob container to which LogAnalytics Api
     writes output logs to. Required.
    :vartype blob_container_sas_uri: str
    :ivar from_time: From time of the query. Required.
    :vartype from_time: ~datetime.datetime
    :ivar to_time: To time of the query. Required.
    :vartype to_time: ~datetime.datetime
    :ivar group_by_throttle_policy: Group query result by Throttle Policy applied.
    :vartype group_by_throttle_policy: bool
    :ivar group_by_operation_name: Group query result by Operation Name.
    :vartype group_by_operation_name: bool
    :ivar group_by_resource_name: Group query result by Resource Name.
    :vartype group_by_resource_name: bool
    """

    _validation = {
        "blob_container_sas_uri": {"required": True},
        "from_time": {"required": True},
        "to_time": {"required": True},
    }

    _attribute_map = {
        "blob_container_sas_uri": {"key": "blobContainerSasUri", "type": "str"},
        "from_time": {"key": "fromTime", "type": "iso-8601"},
        "to_time": {"key": "toTime", "type": "iso-8601"},
        "group_by_throttle_policy": {"key": "groupByThrottlePolicy", "type": "bool"},
        "group_by_operation_name": {"key": "groupByOperationName", "type": "bool"},
        "group_by_resource_name": {"key": "groupByResourceName", "type": "bool"},
    }

    def __init__(
        self,
        *,
        blob_container_sas_uri: str,
        from_time: datetime.datetime,
        to_time: datetime.datetime,
        group_by_throttle_policy: Optional[bool] = None,
        group_by_operation_name: Optional[bool] = None,
        group_by_resource_name: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword blob_container_sas_uri: SAS Uri of the logging blob container to which LogAnalytics
         Api writes output logs to. Required.
        :paramtype blob_container_sas_uri: str
        :keyword from_time: From time of the query. Required.
        :paramtype from_time: ~datetime.datetime
        :keyword to_time: To time of the query. Required.
        :paramtype to_time: ~datetime.datetime
        :keyword group_by_throttle_policy: Group query result by Throttle Policy applied.
        :paramtype group_by_throttle_policy: bool
        :keyword group_by_operation_name: Group query result by Operation Name.
        :paramtype group_by_operation_name: bool
        :keyword group_by_resource_name: Group query result by Resource Name.
        :paramtype group_by_resource_name: bool
        """
        super().__init__(
            blob_container_sas_uri=blob_container_sas_uri,
            from_time=from_time,
            to_time=to_time,
            group_by_throttle_policy=group_by_throttle_policy,
            group_by_operation_name=group_by_operation_name,
            group_by_resource_name=group_by_resource_name,
            **kwargs
        )


class UpgradeOperationHistoricalStatusInfo(_serialization.Model):
    """Virtual Machine Scale Set OS Upgrade History operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar properties: Information about the properties of the upgrade operation.
    :vartype properties:
     ~azure.mgmt.compute.v2017_12_01.models.UpgradeOperationHistoricalStatusInfoProperties
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    """

    _validation = {
        "properties": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "UpgradeOperationHistoricalStatusInfoProperties"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.properties = None
        self.type = None
        self.location = None


class UpgradeOperationHistoricalStatusInfoProperties(_serialization.Model):
    """Describes each OS upgrade on the Virtual Machine Scale Set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar running_status: Information about the overall status of the upgrade operation.
    :vartype running_status: ~azure.mgmt.compute.v2017_12_01.models.UpgradeOperationHistoryStatus
    :ivar progress: Counts of the VMs in each state.
    :vartype progress: ~azure.mgmt.compute.v2017_12_01.models.RollingUpgradeProgressInfo
    :ivar error: Error Details for this upgrade if there are any.
    :vartype error: ~azure.mgmt.compute.v2017_12_01.models.ApiError
    :ivar started_by: Invoker of the Upgrade Operation. Known values are: "Unknown", "User", and
     "Platform".
    :vartype started_by: str or ~azure.mgmt.compute.v2017_12_01.models.UpgradeOperationInvoker
    :ivar target_image_reference: Image Reference details.
    :vartype target_image_reference: ~azure.mgmt.compute.v2017_12_01.models.ImageReference
    :ivar rollback_info: Information about OS rollback if performed.
    :vartype rollback_info: ~azure.mgmt.compute.v2017_12_01.models.RollbackStatusInfo
    """

    _validation = {
        "running_status": {"readonly": True},
        "progress": {"readonly": True},
        "error": {"readonly": True},
        "started_by": {"readonly": True},
        "target_image_reference": {"readonly": True},
        "rollback_info": {"readonly": True},
    }

    _attribute_map = {
        "running_status": {"key": "runningStatus", "type": "UpgradeOperationHistoryStatus"},
        "progress": {"key": "progress", "type": "RollingUpgradeProgressInfo"},
        "error": {"key": "error", "type": "ApiError"},
        "started_by": {"key": "startedBy", "type": "str"},
        "target_image_reference": {"key": "targetImageReference", "type": "ImageReference"},
        "rollback_info": {"key": "rollbackInfo", "type": "RollbackStatusInfo"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.running_status = None
        self.progress = None
        self.error = None
        self.started_by = None
        self.target_image_reference = None
        self.rollback_info = None


class UpgradeOperationHistoryStatus(_serialization.Model):
    """Information about the current running state of the overall upgrade.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Code indicating the current status of the upgrade. Known values are:
     "RollingForward", "Cancelled", "Completed", and "Faulted".
    :vartype code: str or ~azure.mgmt.compute.v2017_12_01.models.UpgradeState
    :ivar start_time: Start time of the upgrade.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the upgrade.
    :vartype end_time: ~datetime.datetime
    """

    _validation = {
        "code": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.start_time = None
        self.end_time = None


class UpgradePolicy(_serialization.Model):
    """Describes an upgrade policy - automatic, manual, or rolling.

    :ivar mode: Specifies the mode of an upgrade to virtual machines in the scale set.:code:`<br
     />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />` **Manual** - You  control
     the application of updates to virtual machines in the scale set. You do this by using the
     manualUpgrade action.:code:`<br />`:code:`<br />` **Automatic** - All virtual machines in the
     scale set are  automatically updated at the same time. Known values are: "Automatic", "Manual",
     and "Rolling".
    :vartype mode: str or ~azure.mgmt.compute.v2017_12_01.models.UpgradeMode
    :ivar rolling_upgrade_policy: The configuration parameters used while performing a rolling
     upgrade.
    :vartype rolling_upgrade_policy: ~azure.mgmt.compute.v2017_12_01.models.RollingUpgradePolicy
    :ivar automatic_os_upgrade: Whether OS upgrades should automatically be applied to scale set
     instances in a rolling fashion when a newer version of the image becomes available.
    :vartype automatic_os_upgrade: bool
    :ivar auto_os_upgrade_policy: Configuration parameters used for performing automatic OS
     Upgrade.
    :vartype auto_os_upgrade_policy: ~azure.mgmt.compute.v2017_12_01.models.AutoOSUpgradePolicy
    """

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
        "rolling_upgrade_policy": {"key": "rollingUpgradePolicy", "type": "RollingUpgradePolicy"},
        "automatic_os_upgrade": {"key": "automaticOSUpgrade", "type": "bool"},
        "auto_os_upgrade_policy": {"key": "autoOSUpgradePolicy", "type": "AutoOSUpgradePolicy"},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "_models.UpgradeMode"]] = None,
        rolling_upgrade_policy: Optional["_models.RollingUpgradePolicy"] = None,
        automatic_os_upgrade: Optional[bool] = None,
        auto_os_upgrade_policy: Optional["_models.AutoOSUpgradePolicy"] = None,
        **kwargs
    ):
        """
        :keyword mode: Specifies the mode of an upgrade to virtual machines in the scale set.:code:`<br
         />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />` **Manual** - You  control
         the application of updates to virtual machines in the scale set. You do this by using the
         manualUpgrade action.:code:`<br />`:code:`<br />` **Automatic** - All virtual machines in the
         scale set are  automatically updated at the same time. Known values are: "Automatic", "Manual",
         and "Rolling".
        :paramtype mode: str or ~azure.mgmt.compute.v2017_12_01.models.UpgradeMode
        :keyword rolling_upgrade_policy: The configuration parameters used while performing a rolling
         upgrade.
        :paramtype rolling_upgrade_policy: ~azure.mgmt.compute.v2017_12_01.models.RollingUpgradePolicy
        :keyword automatic_os_upgrade: Whether OS upgrades should automatically be applied to scale set
         instances in a rolling fashion when a newer version of the image becomes available.
        :paramtype automatic_os_upgrade: bool
        :keyword auto_os_upgrade_policy: Configuration parameters used for performing automatic OS
         Upgrade.
        :paramtype auto_os_upgrade_policy: ~azure.mgmt.compute.v2017_12_01.models.AutoOSUpgradePolicy
        """
        super().__init__(**kwargs)
        self.mode = mode
        self.rolling_upgrade_policy = rolling_upgrade_policy
        self.automatic_os_upgrade = automatic_os_upgrade
        self.auto_os_upgrade_policy = auto_os_upgrade_policy


class Usage(_serialization.Model):
    """Describes Compute Resource Usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar unit: An enum describing the unit of usage measurement. Required. Default value is
     "Count".
    :vartype unit: str
    :ivar current_value: The current usage of the resource. Required.
    :vartype current_value: int
    :ivar limit: The maximum permitted usage of the resource. Required.
    :vartype limit: int
    :ivar name: The name of the type of usage. Required.
    :vartype name: ~azure.mgmt.compute.v2017_12_01.models.UsageName
    """

    _validation = {
        "unit": {"required": True, "constant": True},
        "current_value": {"required": True},
        "limit": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "unit": {"key": "unit", "type": "str"},
        "current_value": {"key": "currentValue", "type": "int"},
        "limit": {"key": "limit", "type": "int"},
        "name": {"key": "name", "type": "UsageName"},
    }

    unit = "Count"

    def __init__(self, *, current_value: int, limit: int, name: "_models.UsageName", **kwargs):
        """
        :keyword current_value: The current usage of the resource. Required.
        :paramtype current_value: int
        :keyword limit: The maximum permitted usage of the resource. Required.
        :paramtype limit: int
        :keyword name: The name of the type of usage. Required.
        :paramtype name: ~azure.mgmt.compute.v2017_12_01.models.UsageName
        """
        super().__init__(**kwargs)
        self.current_value = current_value
        self.limit = limit
        self.name = name


class UsageName(_serialization.Model):
    """The Usage Names.

    :ivar value: The name of the resource.
    :vartype value: str
    :ivar localized_value: The localized name of the resource.
    :vartype localized_value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, localized_value: Optional[str] = None, **kwargs):
        """
        :keyword value: The name of the resource.
        :paramtype value: str
        :keyword localized_value: The localized name of the resource.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class VaultCertificate(_serialization.Model):
    """Describes a single certificate reference in a Key Vault, and where the certificate should reside on the VM.

    :ivar certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as
     a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key vault
     <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
     certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded
     in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`
     "data":":code:`<Base64-encoded-certificate>`",:code:`<br>`  "dataType":"pfx",:code:`<br>`
     "password":":code:`<pfx-file-password>`":code:`<br>`}.
    :vartype certificate_url: str
    :ivar certificate_store: For Windows VMs, specifies the certificate store on the Virtual
     Machine to which the certificate should be added. The specified certificate store is implicitly
     in the LocalMachine account. :code:`<br>`:code:`<br>`For Linux VMs, the certificate file is
     placed under the /var/lib/waagent directory, with the file name &lt;UppercaseThumbprint&gt;.crt
     for the X509 certificate file and &lt;UppercaseThumbprint&gt;.prv for private key. Both of
     these files are .pem formatted.
    :vartype certificate_store: str
    """

    _attribute_map = {
        "certificate_url": {"key": "certificateUrl", "type": "str"},
        "certificate_store": {"key": "certificateStore", "type": "str"},
    }

    def __init__(self, *, certificate_url: Optional[str] = None, certificate_store: Optional[str] = None, **kwargs):
        """
        :keyword certificate_url: This is the URL of a certificate that has been uploaded to Key Vault
         as a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key vault
         <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
         certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded
         in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`
         "data":":code:`<Base64-encoded-certificate>`",:code:`<br>`  "dataType":"pfx",:code:`<br>`
         "password":":code:`<pfx-file-password>`":code:`<br>`}.
        :paramtype certificate_url: str
        :keyword certificate_store: For Windows VMs, specifies the certificate store on the Virtual
         Machine to which the certificate should be added. The specified certificate store is implicitly
         in the LocalMachine account. :code:`<br>`:code:`<br>`For Linux VMs, the certificate file is
         placed under the /var/lib/waagent directory, with the file name &lt;UppercaseThumbprint&gt;.crt
         for the X509 certificate file and &lt;UppercaseThumbprint&gt;.prv for private key. Both of
         these files are .pem formatted.
        :paramtype certificate_store: str
        """
        super().__init__(**kwargs)
        self.certificate_url = certificate_url
        self.certificate_store = certificate_store


class VaultSecretGroup(_serialization.Model):
    """Describes a set of certificates which are all in the same Key Vault.

    :ivar source_vault: The relative URL of the Key Vault containing all of the certificates in
     VaultCertificates.
    :vartype source_vault: ~azure.mgmt.compute.v2017_12_01.models.SubResource
    :ivar vault_certificates: The list of key vault references in SourceVault which contain
     certificates.
    :vartype vault_certificates: list[~azure.mgmt.compute.v2017_12_01.models.VaultCertificate]
    """

    _attribute_map = {
        "source_vault": {"key": "sourceVault", "type": "SubResource"},
        "vault_certificates": {"key": "vaultCertificates", "type": "[VaultCertificate]"},
    }

    def __init__(
        self,
        *,
        source_vault: Optional["_models.SubResource"] = None,
        vault_certificates: Optional[List["_models.VaultCertificate"]] = None,
        **kwargs
    ):
        """
        :keyword source_vault: The relative URL of the Key Vault containing all of the certificates in
         VaultCertificates.
        :paramtype source_vault: ~azure.mgmt.compute.v2017_12_01.models.SubResource
        :keyword vault_certificates: The list of key vault references in SourceVault which contain
         certificates.
        :paramtype vault_certificates: list[~azure.mgmt.compute.v2017_12_01.models.VaultCertificate]
        """
        super().__init__(**kwargs)
        self.source_vault = source_vault
        self.vault_certificates = vault_certificates


class VirtualHardDisk(_serialization.Model):
    """Describes the uri of a disk.

    :ivar uri: Specifies the virtual hard disk's uri.
    :vartype uri: str
    """

    _attribute_map = {
        "uri": {"key": "uri", "type": "str"},
    }

    def __init__(self, *, uri: Optional[str] = None, **kwargs):
        """
        :keyword uri: Specifies the virtual hard disk's uri.
        :paramtype uri: str
        """
        super().__init__(**kwargs)
        self.uri = uri


class VirtualMachine(Resource):  # pylint: disable=too-many-instance-attributes
    """Describes a Virtual Machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :vartype plan: ~azure.mgmt.compute.v2017_12_01.models.Plan
    :ivar resources: The virtual machine child extension resources.
    :vartype resources: list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineExtension]
    :ivar identity: The identity of the virtual machine, if configured.
    :vartype identity: ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineIdentity
    :ivar zones: The virtual machine zones.
    :vartype zones: list[str]
    :ivar hardware_profile: Specifies the hardware settings for the virtual machine.
    :vartype hardware_profile: ~azure.mgmt.compute.v2017_12_01.models.HardwareProfile
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile: ~azure.mgmt.compute.v2017_12_01.models.StorageProfile
    :ivar os_profile: Specifies the operating system settings for the virtual machine.
    :vartype os_profile: ~azure.mgmt.compute.v2017_12_01.models.OSProfile
    :ivar network_profile: Specifies the network interfaces of the virtual machine.
    :vartype network_profile: ~azure.mgmt.compute.v2017_12_01.models.NetworkProfile
    :ivar diagnostics_profile: Specifies the boot diagnostic settings state.
     :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
    :vartype diagnostics_profile: ~azure.mgmt.compute.v2017_12_01.models.DiagnosticsProfile
    :ivar availability_set: Specifies information about the availability set that the virtual
     machine should be assigned to. Virtual machines specified in the same availability set are
     allocated to different nodes to maximize availability. For more information about availability
     sets, see `Manage the availability of virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-manage-availability?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
     :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Planned
     maintenance for virtual machines in Azure
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-planned-maintenance?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_
     :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
     time. An existing VM cannot be added to an availability set.
    :vartype availability_set: ~azure.mgmt.compute.v2017_12_01.models.SubResource
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine instance view.
    :vartype instance_view: ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineInstanceView
    :ivar license_type: Specifies that the image or disk that is being used was licensed
     on-premises. This element is only used for images that contain the Windows Server operating
     system. :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` Windows_Client
     :code:`<br>`:code:`<br>` Windows_Server :code:`<br>`:code:`<br>` If this element is included in
     a request for an update, the value must match the initial value. This value cannot be updated.
     :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :vartype license_type: str
    :ivar vm_id: Specifies the VM unique ID which is a 128-bits identifier that is encoded and
     stored in all Azure IaaS VMs SMBIOS and can be read using platform BIOS commands.
    :vartype vm_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "resources": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "instance_view": {"readonly": True},
        "vm_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "plan": {"key": "plan", "type": "Plan"},
        "resources": {"key": "resources", "type": "[VirtualMachineExtension]"},
        "identity": {"key": "identity", "type": "VirtualMachineIdentity"},
        "zones": {"key": "zones", "type": "[str]"},
        "hardware_profile": {"key": "properties.hardwareProfile", "type": "HardwareProfile"},
        "storage_profile": {"key": "properties.storageProfile", "type": "StorageProfile"},
        "os_profile": {"key": "properties.osProfile", "type": "OSProfile"},
        "network_profile": {"key": "properties.networkProfile", "type": "NetworkProfile"},
        "diagnostics_profile": {"key": "properties.diagnosticsProfile", "type": "DiagnosticsProfile"},
        "availability_set": {"key": "properties.availabilitySet", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "VirtualMachineInstanceView"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
        "vm_id": {"key": "properties.vmId", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["_models.Plan"] = None,
        identity: Optional["_models.VirtualMachineIdentity"] = None,
        zones: Optional[List[str]] = None,
        hardware_profile: Optional["_models.HardwareProfile"] = None,
        storage_profile: Optional["_models.StorageProfile"] = None,
        os_profile: Optional["_models.OSProfile"] = None,
        network_profile: Optional["_models.NetworkProfile"] = None,
        diagnostics_profile: Optional["_models.DiagnosticsProfile"] = None,
        availability_set: Optional["_models.SubResource"] = None,
        license_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword plan: Specifies information about the marketplace image used to create the virtual
         machine. This element is only used for marketplace images. Before you can use a marketplace
         image from an API, you must enable the image for programmatic use.  In the Azure portal, find
         the marketplace image that you want to use and then click **Want to deploy programmatically,
         Get Started ->**. Enter any required information and then click **Save**.
        :paramtype plan: ~azure.mgmt.compute.v2017_12_01.models.Plan
        :keyword identity: The identity of the virtual machine, if configured.
        :paramtype identity: ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineIdentity
        :keyword zones: The virtual machine zones.
        :paramtype zones: list[str]
        :keyword hardware_profile: Specifies the hardware settings for the virtual machine.
        :paramtype hardware_profile: ~azure.mgmt.compute.v2017_12_01.models.HardwareProfile
        :keyword storage_profile: Specifies the storage settings for the virtual machine disks.
        :paramtype storage_profile: ~azure.mgmt.compute.v2017_12_01.models.StorageProfile
        :keyword os_profile: Specifies the operating system settings for the virtual machine.
        :paramtype os_profile: ~azure.mgmt.compute.v2017_12_01.models.OSProfile
        :keyword network_profile: Specifies the network interfaces of the virtual machine.
        :paramtype network_profile: ~azure.mgmt.compute.v2017_12_01.models.NetworkProfile
        :keyword diagnostics_profile: Specifies the boot diagnostic settings state.
         :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
        :paramtype diagnostics_profile: ~azure.mgmt.compute.v2017_12_01.models.DiagnosticsProfile
        :keyword availability_set: Specifies information about the availability set that the virtual
         machine should be assigned to. Virtual machines specified in the same availability set are
         allocated to different nodes to maximize availability. For more information about availability
         sets, see `Manage the availability of virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-manage-availability?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
         :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Planned
         maintenance for virtual machines in Azure
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-planned-maintenance?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_
         :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
         time. An existing VM cannot be added to an availability set.
        :paramtype availability_set: ~azure.mgmt.compute.v2017_12_01.models.SubResource
        :keyword license_type: Specifies that the image or disk that is being used was licensed
         on-premises. This element is only used for images that contain the Windows Server operating
         system. :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` Windows_Client
         :code:`<br>`:code:`<br>` Windows_Server :code:`<br>`:code:`<br>` If this element is included in
         a request for an update, the value must match the initial value. This value cannot be updated.
         :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_
         :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
        :paramtype license_type: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.plan = plan
        self.resources = None
        self.identity = identity
        self.zones = zones
        self.hardware_profile = hardware_profile
        self.storage_profile = storage_profile
        self.os_profile = os_profile
        self.network_profile = network_profile
        self.diagnostics_profile = diagnostics_profile
        self.availability_set = availability_set
        self.provisioning_state = None
        self.instance_view = None
        self.license_type = license_type
        self.vm_id = None


class VirtualMachineAgentInstanceView(_serialization.Model):
    """The instance view of the VM Agent running on the virtual machine.

    :ivar vm_agent_version: The VM Agent full version.
    :vartype vm_agent_version: str
    :ivar extension_handlers: The virtual machine extension handler instance view.
    :vartype extension_handlers:
     list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineExtensionHandlerInstanceView]
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2017_12_01.models.InstanceViewStatus]
    """

    _attribute_map = {
        "vm_agent_version": {"key": "vmAgentVersion", "type": "str"},
        "extension_handlers": {"key": "extensionHandlers", "type": "[VirtualMachineExtensionHandlerInstanceView]"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        vm_agent_version: Optional[str] = None,
        extension_handlers: Optional[List["_models.VirtualMachineExtensionHandlerInstanceView"]] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        **kwargs
    ):
        """
        :keyword vm_agent_version: The VM Agent full version.
        :paramtype vm_agent_version: str
        :keyword extension_handlers: The virtual machine extension handler instance view.
        :paramtype extension_handlers:
         list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineExtensionHandlerInstanceView]
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.v2017_12_01.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.vm_agent_version = vm_agent_version
        self.extension_handlers = extension_handlers
        self.statuses = statuses


class VirtualMachineCaptureParameters(_serialization.Model):
    """Capture Virtual Machine parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar vhd_prefix: The captured virtual hard disk's name prefix. Required.
    :vartype vhd_prefix: str
    :ivar destination_container_name: The destination container name. Required.
    :vartype destination_container_name: str
    :ivar overwrite_vhds: Specifies whether to overwrite the destination virtual hard disk, in case
     of conflict. Required.
    :vartype overwrite_vhds: bool
    """

    _validation = {
        "vhd_prefix": {"required": True},
        "destination_container_name": {"required": True},
        "overwrite_vhds": {"required": True},
    }

    _attribute_map = {
        "vhd_prefix": {"key": "vhdPrefix", "type": "str"},
        "destination_container_name": {"key": "destinationContainerName", "type": "str"},
        "overwrite_vhds": {"key": "overwriteVhds", "type": "bool"},
    }

    def __init__(self, *, vhd_prefix: str, destination_container_name: str, overwrite_vhds: bool, **kwargs):
        """
        :keyword vhd_prefix: The captured virtual hard disk's name prefix. Required.
        :paramtype vhd_prefix: str
        :keyword destination_container_name: The destination container name. Required.
        :paramtype destination_container_name: str
        :keyword overwrite_vhds: Specifies whether to overwrite the destination virtual hard disk, in
         case of conflict. Required.
        :paramtype overwrite_vhds: bool
        """
        super().__init__(**kwargs)
        self.vhd_prefix = vhd_prefix
        self.destination_container_name = destination_container_name
        self.overwrite_vhds = overwrite_vhds


class VirtualMachineCaptureResult(SubResource):
    """Resource Id.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar output: Operation output data (raw JSON).
    :vartype output: JSON
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "output": {"key": "properties.output", "type": "object"},
    }

    def __init__(
        self, *, id: Optional[str] = None, output: Optional[JSON] = None, **kwargs  # pylint: disable=redefined-builtin
    ):
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword output: Operation output data (raw JSON).
        :paramtype output: JSON
        """
        super().__init__(id=id, **kwargs)
        self.output = output


class VirtualMachineExtension(Resource):  # pylint: disable=too-many-instance-attributes
    """Describes a Virtual Machine Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :vartype force_update_tag: str
    :ivar publisher: The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type_properties_type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :vartype type_properties_type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar settings: Json formatted public settings for the extension.
    :vartype settings: JSON
    :ivar protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :vartype protected_settings: JSON
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine extension instance view.
    :vartype instance_view:
     ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineExtensionInstanceView
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "force_update_tag": {"key": "properties.forceUpdateTag", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "type_handler_version": {"key": "properties.typeHandlerVersion", "type": "str"},
        "auto_upgrade_minor_version": {"key": "properties.autoUpgradeMinorVersion", "type": "bool"},
        "settings": {"key": "properties.settings", "type": "object"},
        "protected_settings": {"key": "properties.protectedSettings", "type": "object"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "VirtualMachineExtensionInstanceView"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type_properties_type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        settings: Optional[JSON] = None,
        protected_settings: Optional[JSON] = None,
        instance_view: Optional["_models.VirtualMachineExtensionInstanceView"] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword force_update_tag: How the extension handler should be forced to update even if the
         extension configuration has not changed.
        :paramtype force_update_tag: str
        :keyword publisher: The name of the extension handler publisher.
        :paramtype publisher: str
        :keyword type_properties_type: Specifies the type of the extension; an example is
         "CustomScriptExtension".
        :paramtype type_properties_type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
         version if one is available at deployment time. Once deployed, however, the extension will not
         upgrade minor versions unless redeployed, even with this property set to true.
        :paramtype auto_upgrade_minor_version: bool
        :keyword settings: Json formatted public settings for the extension.
        :paramtype settings: JSON
        :keyword protected_settings: The extension can contain either protectedSettings or
         protectedSettingsFromKeyVault or no protected settings at all.
        :paramtype protected_settings: JSON
        :keyword instance_view: The virtual machine extension instance view.
        :paramtype instance_view:
         ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineExtensionInstanceView
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type_properties_type = type_properties_type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.settings = settings
        self.protected_settings = protected_settings
        self.provisioning_state = None
        self.instance_view = instance_view


class VirtualMachineExtensionHandlerInstanceView(_serialization.Model):
    """The instance view of a virtual machine extension handler.

    :ivar type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :vartype type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar status: The extension handler status.
    :vartype status: ~azure.mgmt.compute.v2017_12_01.models.InstanceViewStatus
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "type_handler_version": {"key": "typeHandlerVersion", "type": "str"},
        "status": {"key": "status", "type": "InstanceViewStatus"},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        status: Optional["_models.InstanceViewStatus"] = None,
        **kwargs
    ):
        """
        :keyword type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :paramtype type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword status: The extension handler status.
        :paramtype status: ~azure.mgmt.compute.v2017_12_01.models.InstanceViewStatus
        """
        super().__init__(**kwargs)
        self.type = type
        self.type_handler_version = type_handler_version
        self.status = status


class VirtualMachineExtensionImage(Resource):
    """Describes a Virtual Machine Extension Image.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar operating_system: The operating system this extension supports.
    :vartype operating_system: str
    :ivar compute_role: The type of role (IaaS or PaaS) this extension supports.
    :vartype compute_role: str
    :ivar handler_schema: The schema defined by publisher, where extension consumers should provide
     settings in a matching schema.
    :vartype handler_schema: str
    :ivar vm_scale_set_enabled: Whether the extension can be used on xRP VMScaleSets. By default
     existing extensions are usable on scalesets, but there might be cases where a publisher wants
     to explicitly indicate the extension is only enabled for CRP VMs but not VMSS.
    :vartype vm_scale_set_enabled: bool
    :ivar supports_multiple_extensions: Whether the handler can support multiple extensions.
    :vartype supports_multiple_extensions: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "operating_system": {"key": "properties.operatingSystem", "type": "str"},
        "compute_role": {"key": "properties.computeRole", "type": "str"},
        "handler_schema": {"key": "properties.handlerSchema", "type": "str"},
        "vm_scale_set_enabled": {"key": "properties.vmScaleSetEnabled", "type": "bool"},
        "supports_multiple_extensions": {"key": "properties.supportsMultipleExtensions", "type": "bool"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        operating_system: Optional[str] = None,
        compute_role: Optional[str] = None,
        handler_schema: Optional[str] = None,
        vm_scale_set_enabled: Optional[bool] = None,
        supports_multiple_extensions: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword operating_system: The operating system this extension supports.
        :paramtype operating_system: str
        :keyword compute_role: The type of role (IaaS or PaaS) this extension supports.
        :paramtype compute_role: str
        :keyword handler_schema: The schema defined by publisher, where extension consumers should
         provide settings in a matching schema.
        :paramtype handler_schema: str
        :keyword vm_scale_set_enabled: Whether the extension can be used on xRP VMScaleSets. By default
         existing extensions are usable on scalesets, but there might be cases where a publisher wants
         to explicitly indicate the extension is only enabled for CRP VMs but not VMSS.
        :paramtype vm_scale_set_enabled: bool
        :keyword supports_multiple_extensions: Whether the handler can support multiple extensions.
        :paramtype supports_multiple_extensions: bool
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.operating_system = operating_system
        self.compute_role = compute_role
        self.handler_schema = handler_schema
        self.vm_scale_set_enabled = vm_scale_set_enabled
        self.supports_multiple_extensions = supports_multiple_extensions


class VirtualMachineExtensionInstanceView(_serialization.Model):
    """The instance view of a virtual machine extension.

    :ivar name: The virtual machine extension name.
    :vartype name: str
    :ivar type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :vartype type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar substatuses: The resource status information.
    :vartype substatuses: list[~azure.mgmt.compute.v2017_12_01.models.InstanceViewStatus]
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2017_12_01.models.InstanceViewStatus]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "type_handler_version": {"key": "typeHandlerVersion", "type": "str"},
        "substatuses": {"key": "substatuses", "type": "[InstanceViewStatus]"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        substatuses: Optional[List["_models.InstanceViewStatus"]] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        **kwargs
    ):
        """
        :keyword name: The virtual machine extension name.
        :paramtype name: str
        :keyword type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :paramtype type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword substatuses: The resource status information.
        :paramtype substatuses: list[~azure.mgmt.compute.v2017_12_01.models.InstanceViewStatus]
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.v2017_12_01.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type
        self.type_handler_version = type_handler_version
        self.substatuses = substatuses
        self.statuses = statuses


class VirtualMachineExtensionsListResult(_serialization.Model):
    """The List Extension operation response.

    :ivar value: The list of extensions.
    :vartype value: list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineExtension]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineExtension]"},
    }

    def __init__(self, *, value: Optional[List["_models.VirtualMachineExtension"]] = None, **kwargs):
        """
        :keyword value: The list of extensions.
        :paramtype value: list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineExtension]
        """
        super().__init__(**kwargs)
        self.value = value


class VirtualMachineExtensionUpdate(UpdateResource):
    """Describes a Virtual Machine Extension.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :vartype force_update_tag: str
    :ivar publisher: The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :vartype type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar settings: Json formatted public settings for the extension.
    :vartype settings: JSON
    :ivar protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :vartype protected_settings: JSON
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "force_update_tag": {"key": "properties.forceUpdateTag", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "type": {"key": "properties.type", "type": "str"},
        "type_handler_version": {"key": "properties.typeHandlerVersion", "type": "str"},
        "auto_upgrade_minor_version": {"key": "properties.autoUpgradeMinorVersion", "type": "bool"},
        "settings": {"key": "properties.settings", "type": "object"},
        "protected_settings": {"key": "properties.protectedSettings", "type": "object"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        settings: Optional[JSON] = None,
        protected_settings: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword force_update_tag: How the extension handler should be forced to update even if the
         extension configuration has not changed.
        :paramtype force_update_tag: str
        :keyword publisher: The name of the extension handler publisher.
        :paramtype publisher: str
        :keyword type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :paramtype type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
         version if one is available at deployment time. Once deployed, however, the extension will not
         upgrade minor versions unless redeployed, even with this property set to true.
        :paramtype auto_upgrade_minor_version: bool
        :keyword settings: Json formatted public settings for the extension.
        :paramtype settings: JSON
        :keyword protected_settings: The extension can contain either protectedSettings or
         protectedSettingsFromKeyVault or no protected settings at all.
        :paramtype protected_settings: JSON
        """
        super().__init__(tags=tags, **kwargs)
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type = type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.settings = settings
        self.protected_settings = protected_settings


class VirtualMachineHealthStatus(_serialization.Model):
    """The health status of the VM.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The health status information for the VM.
    :vartype status: ~azure.mgmt.compute.v2017_12_01.models.InstanceViewStatus
    """

    _validation = {
        "status": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "InstanceViewStatus"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.status = None


class VirtualMachineIdentity(_serialization.Model):
    """Identity for the virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of virtual machine identity. This property will only be
     provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id associated with the virtual machine. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of identity used for the virtual machine. The type 'SystemAssigned,
     UserAssigned' includes both an implicitly created identity and a set of user assigned
     identities. The type 'None' will remove any identities from the virtual machine. Known values
     are: "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned", and "None".
    :vartype type: str or ~azure.mgmt.compute.v2017_12_01.models.ResourceIdentityType
    :ivar identity_ids: The list of user identities associated with the Virtual Machine. The user
     identity references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/identities/{identityName}'.
    :vartype identity_ids: list[str]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "identity_ids": {"key": "identityIds", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceIdentityType"]] = None,
        identity_ids: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword type: The type of identity used for the virtual machine. The type 'SystemAssigned,
         UserAssigned' includes both an implicitly created identity and a set of user assigned
         identities. The type 'None' will remove any identities from the virtual machine. Known values
         are: "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned", and "None".
        :paramtype type: str or ~azure.mgmt.compute.v2017_12_01.models.ResourceIdentityType
        :keyword identity_ids: The list of user identities associated with the Virtual Machine. The
         user identity references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/identities/{identityName}'.
        :paramtype identity_ids: list[str]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.identity_ids = identity_ids


class VirtualMachineImageResource(SubResource):
    """Virtual machine image resource information.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The name of the resource. Required.
    :vartype name: str
    :ivar location: The supported Azure location of the resource. Required.
    :vartype location: str
    :ivar tags: Specifies the tags that are assigned to the virtual machine. For more information
     about using tags, see `Using tags to organize your Azure resources
     <https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md>`_.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "name": {"required": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        name: str,
        location: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword name: The name of the resource. Required.
        :paramtype name: str
        :keyword location: The supported Azure location of the resource. Required.
        :paramtype location: str
        :keyword tags: Specifies the tags that are assigned to the virtual machine. For more
         information about using tags, see `Using tags to organize your Azure resources
         <https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md>`_.
        :paramtype tags: dict[str, str]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.location = location
        self.tags = tags


class VirtualMachineImage(VirtualMachineImageResource):
    """Describes a Virtual Machine Image.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The name of the resource. Required.
    :vartype name: str
    :ivar location: The supported Azure location of the resource. Required.
    :vartype location: str
    :ivar tags: Specifies the tags that are assigned to the virtual machine. For more information
     about using tags, see `Using tags to organize your Azure resources
     <https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md>`_.
    :vartype tags: dict[str, str]
    :ivar plan: Used for establishing the purchase context of any 3rd Party artifact through
     MarketPlace.
    :vartype plan: ~azure.mgmt.compute.v2017_12_01.models.PurchasePlan
    :ivar os_disk_image: Contains the os disk image information.
    :vartype os_disk_image: ~azure.mgmt.compute.v2017_12_01.models.OSDiskImage
    :ivar data_disk_images:
    :vartype data_disk_images: list[~azure.mgmt.compute.v2017_12_01.models.DataDiskImage]
    """

    _validation = {
        "name": {"required": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "plan": {"key": "properties.plan", "type": "PurchasePlan"},
        "os_disk_image": {"key": "properties.osDiskImage", "type": "OSDiskImage"},
        "data_disk_images": {"key": "properties.dataDiskImages", "type": "[DataDiskImage]"},
    }

    def __init__(
        self,
        *,
        name: str,
        location: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["_models.PurchasePlan"] = None,
        os_disk_image: Optional["_models.OSDiskImage"] = None,
        data_disk_images: Optional[List["_models.DataDiskImage"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword name: The name of the resource. Required.
        :paramtype name: str
        :keyword location: The supported Azure location of the resource. Required.
        :paramtype location: str
        :keyword tags: Specifies the tags that are assigned to the virtual machine. For more
         information about using tags, see `Using tags to organize your Azure resources
         <https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md>`_.
        :paramtype tags: dict[str, str]
        :keyword plan: Used for establishing the purchase context of any 3rd Party artifact through
         MarketPlace.
        :paramtype plan: ~azure.mgmt.compute.v2017_12_01.models.PurchasePlan
        :keyword os_disk_image: Contains the os disk image information.
        :paramtype os_disk_image: ~azure.mgmt.compute.v2017_12_01.models.OSDiskImage
        :keyword data_disk_images:
        :paramtype data_disk_images: list[~azure.mgmt.compute.v2017_12_01.models.DataDiskImage]
        """
        super().__init__(id=id, name=name, location=location, tags=tags, **kwargs)
        self.plan = plan
        self.os_disk_image = os_disk_image
        self.data_disk_images = data_disk_images


class VirtualMachineInstanceView(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The instance view of a virtual machine.

    :ivar platform_update_domain: Specifies the update domain of the virtual machine.
    :vartype platform_update_domain: int
    :ivar platform_fault_domain: Specifies the fault domain of the virtual machine.
    :vartype platform_fault_domain: int
    :ivar computer_name: The computer name assigned to the virtual machine.
    :vartype computer_name: str
    :ivar os_name: The Operating System running on the virtual machine.
    :vartype os_name: str
    :ivar os_version: The version of Operating System running on the virtual machine.
    :vartype os_version: str
    :ivar rdp_thumb_print: The Remote desktop certificate thumbprint.
    :vartype rdp_thumb_print: str
    :ivar vm_agent: The VM Agent running on the virtual machine.
    :vartype vm_agent: ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineAgentInstanceView
    :ivar maintenance_redeploy_status: The Maintenance Operation status on the virtual machine.
    :vartype maintenance_redeploy_status:
     ~azure.mgmt.compute.v2017_12_01.models.MaintenanceRedeployStatus
    :ivar disks: The virtual machine disk information.
    :vartype disks: list[~azure.mgmt.compute.v2017_12_01.models.DiskInstanceView]
    :ivar extensions: The extensions information.
    :vartype extensions:
     list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineExtensionInstanceView]
    :ivar boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
     Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
     view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
     screenshot of the VM from the hypervisor.
    :vartype boot_diagnostics: ~azure.mgmt.compute.v2017_12_01.models.BootDiagnosticsInstanceView
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2017_12_01.models.InstanceViewStatus]
    """

    _attribute_map = {
        "platform_update_domain": {"key": "platformUpdateDomain", "type": "int"},
        "platform_fault_domain": {"key": "platformFaultDomain", "type": "int"},
        "computer_name": {"key": "computerName", "type": "str"},
        "os_name": {"key": "osName", "type": "str"},
        "os_version": {"key": "osVersion", "type": "str"},
        "rdp_thumb_print": {"key": "rdpThumbPrint", "type": "str"},
        "vm_agent": {"key": "vmAgent", "type": "VirtualMachineAgentInstanceView"},
        "maintenance_redeploy_status": {"key": "maintenanceRedeployStatus", "type": "MaintenanceRedeployStatus"},
        "disks": {"key": "disks", "type": "[DiskInstanceView]"},
        "extensions": {"key": "extensions", "type": "[VirtualMachineExtensionInstanceView]"},
        "boot_diagnostics": {"key": "bootDiagnostics", "type": "BootDiagnosticsInstanceView"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        platform_update_domain: Optional[int] = None,
        platform_fault_domain: Optional[int] = None,
        computer_name: Optional[str] = None,
        os_name: Optional[str] = None,
        os_version: Optional[str] = None,
        rdp_thumb_print: Optional[str] = None,
        vm_agent: Optional["_models.VirtualMachineAgentInstanceView"] = None,
        maintenance_redeploy_status: Optional["_models.MaintenanceRedeployStatus"] = None,
        disks: Optional[List["_models.DiskInstanceView"]] = None,
        extensions: Optional[List["_models.VirtualMachineExtensionInstanceView"]] = None,
        boot_diagnostics: Optional["_models.BootDiagnosticsInstanceView"] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        **kwargs
    ):
        """
        :keyword platform_update_domain: Specifies the update domain of the virtual machine.
        :paramtype platform_update_domain: int
        :keyword platform_fault_domain: Specifies the fault domain of the virtual machine.
        :paramtype platform_fault_domain: int
        :keyword computer_name: The computer name assigned to the virtual machine.
        :paramtype computer_name: str
        :keyword os_name: The Operating System running on the virtual machine.
        :paramtype os_name: str
        :keyword os_version: The version of Operating System running on the virtual machine.
        :paramtype os_version: str
        :keyword rdp_thumb_print: The Remote desktop certificate thumbprint.
        :paramtype rdp_thumb_print: str
        :keyword vm_agent: The VM Agent running on the virtual machine.
        :paramtype vm_agent: ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineAgentInstanceView
        :keyword maintenance_redeploy_status: The Maintenance Operation status on the virtual machine.
        :paramtype maintenance_redeploy_status:
         ~azure.mgmt.compute.v2017_12_01.models.MaintenanceRedeployStatus
        :keyword disks: The virtual machine disk information.
        :paramtype disks: list[~azure.mgmt.compute.v2017_12_01.models.DiskInstanceView]
        :keyword extensions: The extensions information.
        :paramtype extensions:
         list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineExtensionInstanceView]
        :keyword boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
         Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
         view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
         screenshot of the VM from the hypervisor.
        :paramtype boot_diagnostics: ~azure.mgmt.compute.v2017_12_01.models.BootDiagnosticsInstanceView
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.v2017_12_01.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.platform_update_domain = platform_update_domain
        self.platform_fault_domain = platform_fault_domain
        self.computer_name = computer_name
        self.os_name = os_name
        self.os_version = os_version
        self.rdp_thumb_print = rdp_thumb_print
        self.vm_agent = vm_agent
        self.maintenance_redeploy_status = maintenance_redeploy_status
        self.disks = disks
        self.extensions = extensions
        self.boot_diagnostics = boot_diagnostics
        self.statuses = statuses


class VirtualMachineListResult(_serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of virtual machines. Required.
    :vartype value: list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachine]
    :ivar next_link: The URI to fetch the next page of VMs. Call ListNext() with this URI to fetch
     the next page of Virtual Machines.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachine]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.VirtualMachine"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The list of virtual machines. Required.
        :paramtype value: list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachine]
        :keyword next_link: The URI to fetch the next page of VMs. Call ListNext() with this URI to
         fetch the next page of Virtual Machines.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSet(Resource):  # pylint: disable=too-many-instance-attributes
    """Describes a Virtual Machine Scale Set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The virtual machine scale set sku.
    :vartype sku: ~azure.mgmt.compute.v2017_12_01.models.Sku
    :ivar plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :vartype plan: ~azure.mgmt.compute.v2017_12_01.models.Plan
    :ivar identity: The identity of the virtual machine scale set, if configured.
    :vartype identity: ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetIdentity
    :ivar zones: The virtual machine scale set zones. NOTE: Availability zones can only be set when
     you create the scale set.
    :vartype zones: list[str]
    :ivar upgrade_policy: The upgrade policy.
    :vartype upgrade_policy: ~azure.mgmt.compute.v2017_12_01.models.UpgradePolicy
    :ivar virtual_machine_profile: The virtual machine profile.
    :vartype virtual_machine_profile:
     ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetVMProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar overprovision: Specifies whether the Virtual Machine Scale Set should be overprovisioned.
    :vartype overprovision: bool
    :ivar unique_id: Specifies the ID which uniquely identifies a Virtual Machine Scale Set.
    :vartype unique_id: str
    :ivar single_placement_group: When true this limits the scale set to a single placement group,
     of max size 100 virtual machines.
    :vartype single_placement_group: bool
    :ivar zone_balance: Whether to force strictly even Virtual Machine distribution cross x-zones
     in case there is zone outage.
    :vartype zone_balance: bool
    :ivar platform_fault_domain_count: Fault Domain count for each placement group.
    :vartype platform_fault_domain_count: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "unique_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "plan": {"key": "plan", "type": "Plan"},
        "identity": {"key": "identity", "type": "VirtualMachineScaleSetIdentity"},
        "zones": {"key": "zones", "type": "[str]"},
        "upgrade_policy": {"key": "properties.upgradePolicy", "type": "UpgradePolicy"},
        "virtual_machine_profile": {
            "key": "properties.virtualMachineProfile",
            "type": "VirtualMachineScaleSetVMProfile",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "overprovision": {"key": "properties.overprovision", "type": "bool"},
        "unique_id": {"key": "properties.uniqueId", "type": "str"},
        "single_placement_group": {"key": "properties.singlePlacementGroup", "type": "bool"},
        "zone_balance": {"key": "properties.zoneBalance", "type": "bool"},
        "platform_fault_domain_count": {"key": "properties.platformFaultDomainCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        plan: Optional["_models.Plan"] = None,
        identity: Optional["_models.VirtualMachineScaleSetIdentity"] = None,
        zones: Optional[List[str]] = None,
        upgrade_policy: Optional["_models.UpgradePolicy"] = None,
        virtual_machine_profile: Optional["_models.VirtualMachineScaleSetVMProfile"] = None,
        overprovision: Optional[bool] = None,
        single_placement_group: Optional[bool] = None,
        zone_balance: Optional[bool] = None,
        platform_fault_domain_count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The virtual machine scale set sku.
        :paramtype sku: ~azure.mgmt.compute.v2017_12_01.models.Sku
        :keyword plan: Specifies information about the marketplace image used to create the virtual
         machine. This element is only used for marketplace images. Before you can use a marketplace
         image from an API, you must enable the image for programmatic use.  In the Azure portal, find
         the marketplace image that you want to use and then click **Want to deploy programmatically,
         Get Started ->**. Enter any required information and then click **Save**.
        :paramtype plan: ~azure.mgmt.compute.v2017_12_01.models.Plan
        :keyword identity: The identity of the virtual machine scale set, if configured.
        :paramtype identity: ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetIdentity
        :keyword zones: The virtual machine scale set zones. NOTE: Availability zones can only be set
         when you create the scale set.
        :paramtype zones: list[str]
        :keyword upgrade_policy: The upgrade policy.
        :paramtype upgrade_policy: ~azure.mgmt.compute.v2017_12_01.models.UpgradePolicy
        :keyword virtual_machine_profile: The virtual machine profile.
        :paramtype virtual_machine_profile:
         ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetVMProfile
        :keyword overprovision: Specifies whether the Virtual Machine Scale Set should be
         overprovisioned.
        :paramtype overprovision: bool
        :keyword single_placement_group: When true this limits the scale set to a single placement
         group, of max size 100 virtual machines.
        :paramtype single_placement_group: bool
        :keyword zone_balance: Whether to force strictly even Virtual Machine distribution cross
         x-zones in case there is zone outage.
        :paramtype zone_balance: bool
        :keyword platform_fault_domain_count: Fault Domain count for each placement group.
        :paramtype platform_fault_domain_count: int
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.plan = plan
        self.identity = identity
        self.zones = zones
        self.upgrade_policy = upgrade_policy
        self.virtual_machine_profile = virtual_machine_profile
        self.provisioning_state = None
        self.overprovision = overprovision
        self.unique_id = None
        self.single_placement_group = single_placement_group
        self.zone_balance = zone_balance
        self.platform_fault_domain_count = platform_fault_domain_count


class VirtualMachineScaleSetDataDisk(_serialization.Model):
    """Describes a virtual machine scale set data disk.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The disk name.
    :vartype name: str
    :ivar lun: Specifies the logical unit number of the data disk. This value is used to identify
     data disks within the VM and therefore must be unique for each data disk attached to a VM.
     Required.
    :vartype lun: int
    :ivar caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.v2017_12_01.models.CachingTypes
    :ivar write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :vartype write_accelerator_enabled: bool
    :ivar create_option: The create option. Required. Known values are: "FromImage", "Empty", and
     "Attach".
    :vartype create_option: str or ~azure.mgmt.compute.v2017_12_01.models.DiskCreateOptionTypes
    :ivar disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :vartype disk_size_gb: int
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk:
     ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetManagedDiskParameters
    """

    _validation = {
        "lun": {"required": True},
        "create_option": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "lun": {"key": "lun", "type": "int"},
        "caching": {"key": "caching", "type": "str"},
        "write_accelerator_enabled": {"key": "writeAcceleratorEnabled", "type": "bool"},
        "create_option": {"key": "createOption", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "managed_disk": {"key": "managedDisk", "type": "VirtualMachineScaleSetManagedDiskParameters"},
    }

    def __init__(
        self,
        *,
        lun: int,
        create_option: Union[str, "_models.DiskCreateOptionTypes"],
        name: Optional[str] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["_models.VirtualMachineScaleSetManagedDiskParameters"] = None,
        **kwargs
    ):
        """
        :keyword name: The disk name.
        :paramtype name: str
        :keyword lun: Specifies the logical unit number of the data disk. This value is used to
         identify data disks within the VM and therefore must be unique for each data disk attached to a
         VM. Required.
        :paramtype lun: int
        :keyword caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
         :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
         storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.v2017_12_01.models.CachingTypes
        :keyword write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
         disabled on the disk.
        :paramtype write_accelerator_enabled: bool
        :keyword create_option: The create option. Required. Known values are: "FromImage", "Empty",
         and "Attach".
        :paramtype create_option: str or ~azure.mgmt.compute.v2017_12_01.models.DiskCreateOptionTypes
        :keyword disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can
         be used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
         This value cannot be larger than 1023 GB.
        :paramtype disk_size_gb: int
        :keyword managed_disk: The managed disk parameters.
        :paramtype managed_disk:
         ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetManagedDiskParameters
        """
        super().__init__(**kwargs)
        self.name = name
        self.lun = lun
        self.caching = caching
        self.write_accelerator_enabled = write_accelerator_enabled
        self.create_option = create_option
        self.disk_size_gb = disk_size_gb
        self.managed_disk = managed_disk


class VirtualMachineScaleSetExtension(SubResourceReadOnly):
    """Describes a Virtual Machine Scale Set Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The name of the extension.
    :vartype name: str
    :ivar force_update_tag: If a value is provided and is different from the previous value, the
     extension handler will be forced to update even if the extension configuration has not changed.
    :vartype force_update_tag: str
    :ivar publisher: The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :vartype type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar settings: Json formatted public settings for the extension.
    :vartype settings: JSON
    :ivar protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :vartype protected_settings: JSON
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "force_update_tag": {"key": "properties.forceUpdateTag", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "type": {"key": "properties.type", "type": "str"},
        "type_handler_version": {"key": "properties.typeHandlerVersion", "type": "str"},
        "auto_upgrade_minor_version": {"key": "properties.autoUpgradeMinorVersion", "type": "bool"},
        "settings": {"key": "properties.settings", "type": "object"},
        "protected_settings": {"key": "properties.protectedSettings", "type": "object"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        settings: Optional[JSON] = None,
        protected_settings: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the extension.
        :paramtype name: str
        :keyword force_update_tag: If a value is provided and is different from the previous value, the
         extension handler will be forced to update even if the extension configuration has not changed.
        :paramtype force_update_tag: str
        :keyword publisher: The name of the extension handler publisher.
        :paramtype publisher: str
        :keyword type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :paramtype type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
         version if one is available at deployment time. Once deployed, however, the extension will not
         upgrade minor versions unless redeployed, even with this property set to true.
        :paramtype auto_upgrade_minor_version: bool
        :keyword settings: Json formatted public settings for the extension.
        :paramtype settings: JSON
        :keyword protected_settings: The extension can contain either protectedSettings or
         protectedSettingsFromKeyVault or no protected settings at all.
        :paramtype protected_settings: JSON
        """
        super().__init__(**kwargs)
        self.name = name
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type = type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.settings = settings
        self.protected_settings = protected_settings
        self.provisioning_state = None


class VirtualMachineScaleSetExtensionListResult(_serialization.Model):
    """The List VM scale set extension operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of VM scale set extensions. Required.
    :vartype value: list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetExtension]
    :ivar next_link: The uri to fetch the next page of VM scale set extensions. Call ListNext()
     with this to fetch the next page of VM scale set extensions.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineScaleSetExtension]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.VirtualMachineScaleSetExtension"], next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The list of VM scale set extensions. Required.
        :paramtype value: list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetExtension]
        :keyword next_link: The uri to fetch the next page of VM scale set extensions. Call ListNext()
         with this to fetch the next page of VM scale set extensions.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetExtensionProfile(_serialization.Model):
    """Describes a virtual machine scale set extension profile.

    :ivar extensions: The virtual machine scale set child extension resources.
    :vartype extensions:
     list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetExtension]
    """

    _attribute_map = {
        "extensions": {"key": "extensions", "type": "[VirtualMachineScaleSetExtension]"},
    }

    def __init__(self, *, extensions: Optional[List["_models.VirtualMachineScaleSetExtension"]] = None, **kwargs):
        """
        :keyword extensions: The virtual machine scale set child extension resources.
        :paramtype extensions:
         list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetExtension]
        """
        super().__init__(**kwargs)
        self.extensions = extensions


class VirtualMachineScaleSetIdentity(_serialization.Model):
    """Identity for the virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of virtual machine scale set identity. This property will
     only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id associated with the virtual machine scale set. This property
     will only be provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of identity used for the virtual machine scale set. The type
     'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user
     assigned identities. The type 'None' will remove any identities from the virtual machine scale
     set. Known values are: "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned", and
     "None".
    :vartype type: str or ~azure.mgmt.compute.v2017_12_01.models.ResourceIdentityType
    :ivar identity_ids: The list of user identities associated with the virtual machine scale set.
     The user identity references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/identities/{identityName}'.
    :vartype identity_ids: list[str]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "identity_ids": {"key": "identityIds", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceIdentityType"]] = None,
        identity_ids: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword type: The type of identity used for the virtual machine scale set. The type
         'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user
         assigned identities. The type 'None' will remove any identities from the virtual machine scale
         set. Known values are: "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned", and
         "None".
        :paramtype type: str or ~azure.mgmt.compute.v2017_12_01.models.ResourceIdentityType
        :keyword identity_ids: The list of user identities associated with the virtual machine scale
         set. The user identity references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/identities/{identityName}'.
        :paramtype identity_ids: list[str]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.identity_ids = identity_ids


class VirtualMachineScaleSetInstanceView(_serialization.Model):
    """The instance view of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar virtual_machine: The instance view status summary for the virtual machine scale set.
    :vartype virtual_machine:
     ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetInstanceViewStatusesSummary
    :ivar extensions: The extensions information.
    :vartype extensions:
     list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetVMExtensionsSummary]
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2017_12_01.models.InstanceViewStatus]
    """

    _validation = {
        "virtual_machine": {"readonly": True},
        "extensions": {"readonly": True},
    }

    _attribute_map = {
        "virtual_machine": {"key": "virtualMachine", "type": "VirtualMachineScaleSetInstanceViewStatusesSummary"},
        "extensions": {"key": "extensions", "type": "[VirtualMachineScaleSetVMExtensionsSummary]"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(self, *, statuses: Optional[List["_models.InstanceViewStatus"]] = None, **kwargs):
        """
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.v2017_12_01.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.virtual_machine = None
        self.extensions = None
        self.statuses = statuses


class VirtualMachineScaleSetInstanceViewStatusesSummary(_serialization.Model):
    """Instance view statuses summary for virtual machines of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar statuses_summary: The extensions information.
    :vartype statuses_summary:
     list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineStatusCodeCount]
    """

    _validation = {
        "statuses_summary": {"readonly": True},
    }

    _attribute_map = {
        "statuses_summary": {"key": "statusesSummary", "type": "[VirtualMachineStatusCodeCount]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.statuses_summary = None


class VirtualMachineScaleSetIPConfiguration(SubResource):
    """Describes a virtual machine scale set network profile's IP configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The IP configuration name. Required.
    :vartype name: str
    :ivar subnet: Specifies the identifier of the subnet.
    :vartype subnet: ~azure.mgmt.compute.v2017_12_01.models.ApiEntityReference
    :ivar primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :vartype primary: bool
    :ivar public_ip_address_configuration: The publicIPAddressConfiguration.
    :vartype public_ip_address_configuration:
     ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetPublicIPAddressConfiguration
    :ivar private_ip_address_version: Available from Api-Version 2017-03-30 onwards, it represents
     whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible
     values are: 'IPv4' and 'IPv6'. Known values are: "IPv4" and "IPv6".
    :vartype private_ip_address_version: str or ~azure.mgmt.compute.v2017_12_01.models.IPVersion
    :ivar application_gateway_backend_address_pools: Specifies an array of references to backend
     address pools of application gateways. A scale set can reference backend address pools of
     multiple application gateways. Multiple scale sets cannot use the same application gateway.
    :vartype application_gateway_backend_address_pools:
     list[~azure.mgmt.compute.v2017_12_01.models.SubResource]
    :ivar load_balancer_backend_address_pools: Specifies an array of references to backend address
     pools of load balancers. A scale set can reference backend address pools of one public and one
     internal load balancer. Multiple scale sets cannot use the same load balancer.
    :vartype load_balancer_backend_address_pools:
     list[~azure.mgmt.compute.v2017_12_01.models.SubResource]
    :ivar load_balancer_inbound_nat_pools: Specifies an array of references to inbound Nat pools of
     the load balancers. A scale set can reference inbound nat pools of one public and one internal
     load balancer. Multiple scale sets cannot use the same load balancer.
    :vartype load_balancer_inbound_nat_pools:
     list[~azure.mgmt.compute.v2017_12_01.models.SubResource]
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "ApiEntityReference"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "public_ip_address_configuration": {
            "key": "properties.publicIPAddressConfiguration",
            "type": "VirtualMachineScaleSetPublicIPAddressConfiguration",
        },
        "private_ip_address_version": {"key": "properties.privateIPAddressVersion", "type": "str"},
        "application_gateway_backend_address_pools": {
            "key": "properties.applicationGatewayBackendAddressPools",
            "type": "[SubResource]",
        },
        "load_balancer_backend_address_pools": {
            "key": "properties.loadBalancerBackendAddressPools",
            "type": "[SubResource]",
        },
        "load_balancer_inbound_nat_pools": {"key": "properties.loadBalancerInboundNatPools", "type": "[SubResource]"},
    }

    def __init__(
        self,
        *,
        name: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        subnet: Optional["_models.ApiEntityReference"] = None,
        primary: Optional[bool] = None,
        public_ip_address_configuration: Optional["_models.VirtualMachineScaleSetPublicIPAddressConfiguration"] = None,
        private_ip_address_version: Optional[Union[str, "_models.IPVersion"]] = None,
        application_gateway_backend_address_pools: Optional[List["_models.SubResource"]] = None,
        load_balancer_backend_address_pools: Optional[List["_models.SubResource"]] = None,
        load_balancer_inbound_nat_pools: Optional[List["_models.SubResource"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword name: The IP configuration name. Required.
        :paramtype name: str
        :keyword subnet: Specifies the identifier of the subnet.
        :paramtype subnet: ~azure.mgmt.compute.v2017_12_01.models.ApiEntityReference
        :keyword primary: Specifies the primary network interface in case the virtual machine has more
         than 1 network interface.
        :paramtype primary: bool
        :keyword public_ip_address_configuration: The publicIPAddressConfiguration.
        :paramtype public_ip_address_configuration:
         ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetPublicIPAddressConfiguration
        :keyword private_ip_address_version: Available from Api-Version 2017-03-30 onwards, it
         represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.
         Possible values are: 'IPv4' and 'IPv6'. Known values are: "IPv4" and "IPv6".
        :paramtype private_ip_address_version: str or ~azure.mgmt.compute.v2017_12_01.models.IPVersion
        :keyword application_gateway_backend_address_pools: Specifies an array of references to backend
         address pools of application gateways. A scale set can reference backend address pools of
         multiple application gateways. Multiple scale sets cannot use the same application gateway.
        :paramtype application_gateway_backend_address_pools:
         list[~azure.mgmt.compute.v2017_12_01.models.SubResource]
        :keyword load_balancer_backend_address_pools: Specifies an array of references to backend
         address pools of load balancers. A scale set can reference backend address pools of one public
         and one internal load balancer. Multiple scale sets cannot use the same load balancer.
        :paramtype load_balancer_backend_address_pools:
         list[~azure.mgmt.compute.v2017_12_01.models.SubResource]
        :keyword load_balancer_inbound_nat_pools: Specifies an array of references to inbound Nat pools
         of the load balancers. A scale set can reference inbound nat pools of one public and one
         internal load balancer. Multiple scale sets cannot use the same load balancer.
        :paramtype load_balancer_inbound_nat_pools:
         list[~azure.mgmt.compute.v2017_12_01.models.SubResource]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.subnet = subnet
        self.primary = primary
        self.public_ip_address_configuration = public_ip_address_configuration
        self.private_ip_address_version = private_ip_address_version
        self.application_gateway_backend_address_pools = application_gateway_backend_address_pools
        self.load_balancer_backend_address_pools = load_balancer_backend_address_pools
        self.load_balancer_inbound_nat_pools = load_balancer_inbound_nat_pools


class VirtualMachineScaleSetListOSUpgradeHistory(_serialization.Model):
    """List of Virtual Machine Scale Set OS Upgrade History operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of OS upgrades performed on the virtual machine scale set. Required.
    :vartype value:
     list[~azure.mgmt.compute.v2017_12_01.models.UpgradeOperationHistoricalStatusInfo]
    :ivar next_link: The uri to fetch the next page of OS Upgrade History. Call ListNext() with
     this to fetch the next page of history of upgrades.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[UpgradeOperationHistoricalStatusInfo]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.UpgradeOperationHistoricalStatusInfo"], next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The list of OS upgrades performed on the virtual machine scale set. Required.
        :paramtype value:
         list[~azure.mgmt.compute.v2017_12_01.models.UpgradeOperationHistoricalStatusInfo]
        :keyword next_link: The uri to fetch the next page of OS Upgrade History. Call ListNext() with
         this to fetch the next page of history of upgrades.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetListResult(_serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of virtual machine scale sets. Required.
    :vartype value: list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSet]
    :ivar next_link: The uri to fetch the next page of Virtual Machine Scale Sets. Call ListNext()
     with this to fetch the next page of VMSS.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineScaleSet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.VirtualMachineScaleSet"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The list of virtual machine scale sets. Required.
        :paramtype value: list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSet]
        :keyword next_link: The uri to fetch the next page of Virtual Machine Scale Sets. Call
         ListNext() with this to fetch the next page of VMSS.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetListSkusResult(_serialization.Model):
    """The Virtual Machine Scale Set List Skus operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of skus available for the virtual machine scale set. Required.
    :vartype value: list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetSku]
    :ivar next_link: The uri to fetch the next page of Virtual Machine Scale Set Skus. Call
     ListNext() with this to fetch the next page of VMSS Skus.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineScaleSetSku]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.VirtualMachineScaleSetSku"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The list of skus available for the virtual machine scale set. Required.
        :paramtype value: list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetSku]
        :keyword next_link: The uri to fetch the next page of Virtual Machine Scale Set Skus. Call
         ListNext() with this to fetch the next page of VMSS Skus.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetListWithLinkResult(_serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of virtual machine scale sets. Required.
    :vartype value: list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSet]
    :ivar next_link: The uri to fetch the next page of Virtual Machine Scale Sets. Call ListNext()
     with this to fetch the next page of Virtual Machine Scale Sets.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineScaleSet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.VirtualMachineScaleSet"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The list of virtual machine scale sets. Required.
        :paramtype value: list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSet]
        :keyword next_link: The uri to fetch the next page of Virtual Machine Scale Sets. Call
         ListNext() with this to fetch the next page of Virtual Machine Scale Sets.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetManagedDiskParameters(_serialization.Model):
    """Describes the parameters of a ScaleSet managed disk.

    :ivar storage_account_type: Specifies the storage account type for the managed disk. Managed OS
     disk storage account type can only be set when you create the scale set. Possible values are:
     Standard_LRS or Premium_LRS. Known values are: "Standard_LRS" and "Premium_LRS".
    :vartype storage_account_type: str or
     ~azure.mgmt.compute.v2017_12_01.models.StorageAccountTypes
    """

    _attribute_map = {
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
    }

    def __init__(self, *, storage_account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = None, **kwargs):
        """
        :keyword storage_account_type: Specifies the storage account type for the managed disk. Managed
         OS disk storage account type can only be set when you create the scale set. Possible values
         are: Standard_LRS or Premium_LRS. Known values are: "Standard_LRS" and "Premium_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.v2017_12_01.models.StorageAccountTypes
        """
        super().__init__(**kwargs)
        self.storage_account_type = storage_account_type


class VirtualMachineScaleSetNetworkConfiguration(SubResource):
    """Describes a virtual machine scale set network profile's network configurations.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The network configuration name. Required.
    :vartype name: str
    :ivar primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :vartype primary: bool
    :ivar enable_accelerated_networking: Specifies whether the network interface is accelerated
     networking-enabled.
    :vartype enable_accelerated_networking: bool
    :ivar network_security_group: The network security group.
    :vartype network_security_group: ~azure.mgmt.compute.v2017_12_01.models.SubResource
    :ivar dns_settings: The dns settings to be applied on the network interfaces.
    :vartype dns_settings:
     ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetNetworkConfigurationDnsSettings
    :ivar ip_configurations: Specifies the IP configurations of the network interface.
    :vartype ip_configurations:
     list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetIPConfiguration]
    :ivar enable_ip_forwarding: Whether IP forwarding enabled on this NIC.
    :vartype enable_ip_forwarding: bool
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "enable_accelerated_networking": {"key": "properties.enableAcceleratedNetworking", "type": "bool"},
        "network_security_group": {"key": "properties.networkSecurityGroup", "type": "SubResource"},
        "dns_settings": {
            "key": "properties.dnsSettings",
            "type": "VirtualMachineScaleSetNetworkConfigurationDnsSettings",
        },
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[VirtualMachineScaleSetIPConfiguration]"},
        "enable_ip_forwarding": {"key": "properties.enableIPForwarding", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        primary: Optional[bool] = None,
        enable_accelerated_networking: Optional[bool] = None,
        network_security_group: Optional["_models.SubResource"] = None,
        dns_settings: Optional["_models.VirtualMachineScaleSetNetworkConfigurationDnsSettings"] = None,
        ip_configurations: Optional[List["_models.VirtualMachineScaleSetIPConfiguration"]] = None,
        enable_ip_forwarding: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword name: The network configuration name. Required.
        :paramtype name: str
        :keyword primary: Specifies the primary network interface in case the virtual machine has more
         than 1 network interface.
        :paramtype primary: bool
        :keyword enable_accelerated_networking: Specifies whether the network interface is accelerated
         networking-enabled.
        :paramtype enable_accelerated_networking: bool
        :keyword network_security_group: The network security group.
        :paramtype network_security_group: ~azure.mgmt.compute.v2017_12_01.models.SubResource
        :keyword dns_settings: The dns settings to be applied on the network interfaces.
        :paramtype dns_settings:
         ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetNetworkConfigurationDnsSettings
        :keyword ip_configurations: Specifies the IP configurations of the network interface.
        :paramtype ip_configurations:
         list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetIPConfiguration]
        :keyword enable_ip_forwarding: Whether IP forwarding enabled on this NIC.
        :paramtype enable_ip_forwarding: bool
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.primary = primary
        self.enable_accelerated_networking = enable_accelerated_networking
        self.network_security_group = network_security_group
        self.dns_settings = dns_settings
        self.ip_configurations = ip_configurations
        self.enable_ip_forwarding = enable_ip_forwarding


class VirtualMachineScaleSetNetworkConfigurationDnsSettings(_serialization.Model):
    """Describes a virtual machines scale sets network configuration's DNS settings.

    :ivar dns_servers: List of DNS servers IP addresses.
    :vartype dns_servers: list[str]
    """

    _attribute_map = {
        "dns_servers": {"key": "dnsServers", "type": "[str]"},
    }

    def __init__(self, *, dns_servers: Optional[List[str]] = None, **kwargs):
        """
        :keyword dns_servers: List of DNS servers IP addresses.
        :paramtype dns_servers: list[str]
        """
        super().__init__(**kwargs)
        self.dns_servers = dns_servers


class VirtualMachineScaleSetNetworkProfile(_serialization.Model):
    """Describes a virtual machine scale set network profile.

    :ivar health_probe: A reference to a load balancer probe used to determine the health of an
     instance in the virtual machine scale set. The reference will be in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
    :vartype health_probe: ~azure.mgmt.compute.v2017_12_01.models.ApiEntityReference
    :ivar network_interface_configurations: The list of network configurations.
    :vartype network_interface_configurations:
     list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetNetworkConfiguration]
    """

    _attribute_map = {
        "health_probe": {"key": "healthProbe", "type": "ApiEntityReference"},
        "network_interface_configurations": {
            "key": "networkInterfaceConfigurations",
            "type": "[VirtualMachineScaleSetNetworkConfiguration]",
        },
    }

    def __init__(
        self,
        *,
        health_probe: Optional["_models.ApiEntityReference"] = None,
        network_interface_configurations: Optional[List["_models.VirtualMachineScaleSetNetworkConfiguration"]] = None,
        **kwargs
    ):
        """
        :keyword health_probe: A reference to a load balancer probe used to determine the health of an
         instance in the virtual machine scale set. The reference will be in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
        :paramtype health_probe: ~azure.mgmt.compute.v2017_12_01.models.ApiEntityReference
        :keyword network_interface_configurations: The list of network configurations.
        :paramtype network_interface_configurations:
         list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetNetworkConfiguration]
        """
        super().__init__(**kwargs)
        self.health_probe = health_probe
        self.network_interface_configurations = network_interface_configurations


class VirtualMachineScaleSetOSDisk(_serialization.Model):
    """Describes a virtual machine scale set operating system disk.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The disk name.
    :vartype name: str
    :ivar caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.v2017_12_01.models.CachingTypes
    :ivar write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :vartype write_accelerator_enabled: bool
    :ivar create_option: Specifies how the virtual machines in the scale set should be
     created.:code:`<br>`:code:`<br>` The only allowed value is: **FromImage** \u2013 This value is
     used when you are using an image to create the virtual machine. If you are using a platform
     image, you also use the imageReference element described above. If you are using a marketplace
     image, you  also use the plan element previously described. Required. Known values are:
     "FromImage", "Empty", and "Attach".
    :vartype create_option: str or ~azure.mgmt.compute.v2017_12_01.models.DiskCreateOptionTypes
    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk if creating a VM from user-image or a specialized VHD. :code:`<br>`:code:`<br>` Possible
     values are: :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known
     values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.v2017_12_01.models.OperatingSystemTypes
    :ivar image: Specifies information about the unmanaged user image to base the scale set on.
    :vartype image: ~azure.mgmt.compute.v2017_12_01.models.VirtualHardDisk
    :ivar vhd_containers: Specifies the container urls that are used to store operating system
     disks for the scale set.
    :vartype vhd_containers: list[str]
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk:
     ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetManagedDiskParameters
    """

    _validation = {
        "create_option": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "caching": {"key": "caching", "type": "str"},
        "write_accelerator_enabled": {"key": "writeAcceleratorEnabled", "type": "bool"},
        "create_option": {"key": "createOption", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "image": {"key": "image", "type": "VirtualHardDisk"},
        "vhd_containers": {"key": "vhdContainers", "type": "[str]"},
        "managed_disk": {"key": "managedDisk", "type": "VirtualMachineScaleSetManagedDiskParameters"},
    }

    def __init__(
        self,
        *,
        create_option: Union[str, "_models.DiskCreateOptionTypes"],
        name: Optional[str] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        image: Optional["_models.VirtualHardDisk"] = None,
        vhd_containers: Optional[List[str]] = None,
        managed_disk: Optional["_models.VirtualMachineScaleSetManagedDiskParameters"] = None,
        **kwargs
    ):
        """
        :keyword name: The disk name.
        :paramtype name: str
        :keyword caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
         :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
         storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.v2017_12_01.models.CachingTypes
        :keyword write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
         disabled on the disk.
        :paramtype write_accelerator_enabled: bool
        :keyword create_option: Specifies how the virtual machines in the scale set should be
         created.:code:`<br>`:code:`<br>` The only allowed value is: **FromImage** \u2013 This value is
         used when you are using an image to create the virtual machine. If you are using a platform
         image, you also use the imageReference element described above. If you are using a marketplace
         image, you  also use the plan element previously described. Required. Known values are:
         "FromImage", "Empty", and "Attach".
        :paramtype create_option: str or ~azure.mgmt.compute.v2017_12_01.models.DiskCreateOptionTypes
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk if creating a VM from user-image or a specialized VHD. :code:`<br>`:code:`<br>`
         Possible values are: :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**.
         Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.v2017_12_01.models.OperatingSystemTypes
        :keyword image: Specifies information about the unmanaged user image to base the scale set on.
        :paramtype image: ~azure.mgmt.compute.v2017_12_01.models.VirtualHardDisk
        :keyword vhd_containers: Specifies the container urls that are used to store operating system
         disks for the scale set.
        :paramtype vhd_containers: list[str]
        :keyword managed_disk: The managed disk parameters.
        :paramtype managed_disk:
         ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetManagedDiskParameters
        """
        super().__init__(**kwargs)
        self.name = name
        self.caching = caching
        self.write_accelerator_enabled = write_accelerator_enabled
        self.create_option = create_option
        self.os_type = os_type
        self.image = image
        self.vhd_containers = vhd_containers
        self.managed_disk = managed_disk


class VirtualMachineScaleSetOSProfile(_serialization.Model):
    """Describes a virtual machine scale set OS profile.

    :ivar computer_name_prefix: Specifies the computer name prefix for all of the virtual machines
     in the scale set. Computer name prefixes must be 1 to 15 characters long.
    :vartype computer_name_prefix: str
    :ivar admin_username: Specifies the name of the administrator account. :code:`<br>`:code:`<br>`
     **Windows-only restriction:** Cannot end in "." :code:`<br>`:code:`<br>` **Disallowed values:**
     "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1",
     "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest",
     "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2",
     "test3", "user4", "user5". :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character
     :code:`<br>`:code:`<br>` **Max-length (Linux):** 64 characters :code:`<br>`:code:`<br>`
     **Max-length (Windows):** 20 characters  :code:`<br>`:code:`<br>`:code:`<li>` For root access
     to the Linux VM, see `Using root privileges on Linux virtual machines in Azure
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_\
     :code:`<br>`:code:`<li>` For a list of built-in system users on Linux that should not be used
     in this field, see `Selecting User Names for Linux on Azure
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
    :vartype admin_username: str
    :ivar admin_password: Specifies the password of the administrator account.
     :code:`<br>`:code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`:code:`<br>`
     **Minimum-length (Linux):** 6 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 123
     characters :code:`<br>`:code:`<br>` **Max-length (Linux):** 72 characters
     :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be
     fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a
     digit :code:`<br>` Has a special character (Regex match [\W_]) :code:`<br>`:code:`<br>`
     **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
     "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`:code:`<br>` For
     resetting the password, see `How to reset the Remote Desktop service or its login password in a
     Windows VM
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_
     :code:`<br>`:code:`<br>` For resetting root password, see `Manage users, SSH, and check or
     repair disks on Azure Linux VMs using the VMAccess Extension
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#reset-root-password>`_.
    :vartype admin_password: str
    :ivar custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
     string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum
     length of the binary array is 65535 bytes. :code:`<br>`:code:`<br>` For using cloud-init for
     your VM, see `Using cloud-init to customize a Linux VM during creation
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
    :vartype custom_data: str
    :ivar windows_configuration: Specifies Windows operating system settings on the virtual
     machine.
    :vartype windows_configuration: ~azure.mgmt.compute.v2017_12_01.models.WindowsConfiguration
    :ivar linux_configuration: Specifies the Linux operating system settings on the virtual
     machine. :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on
     Azure-Endorsed Distributions
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_
     :code:`<br>`:code:`<br>` For running non-endorsed distributions, see `Information for
     Non-Endorsed Distributions
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
    :vartype linux_configuration: ~azure.mgmt.compute.v2017_12_01.models.LinuxConfiguration
    :ivar secrets: Specifies set of certificates that should be installed onto the virtual machines
     in the scale set.
    :vartype secrets: list[~azure.mgmt.compute.v2017_12_01.models.VaultSecretGroup]
    """

    _attribute_map = {
        "computer_name_prefix": {"key": "computerNamePrefix", "type": "str"},
        "admin_username": {"key": "adminUsername", "type": "str"},
        "admin_password": {"key": "adminPassword", "type": "str"},
        "custom_data": {"key": "customData", "type": "str"},
        "windows_configuration": {"key": "windowsConfiguration", "type": "WindowsConfiguration"},
        "linux_configuration": {"key": "linuxConfiguration", "type": "LinuxConfiguration"},
        "secrets": {"key": "secrets", "type": "[VaultSecretGroup]"},
    }

    def __init__(
        self,
        *,
        computer_name_prefix: Optional[str] = None,
        admin_username: Optional[str] = None,
        admin_password: Optional[str] = None,
        custom_data: Optional[str] = None,
        windows_configuration: Optional["_models.WindowsConfiguration"] = None,
        linux_configuration: Optional["_models.LinuxConfiguration"] = None,
        secrets: Optional[List["_models.VaultSecretGroup"]] = None,
        **kwargs
    ):
        """
        :keyword computer_name_prefix: Specifies the computer name prefix for all of the virtual
         machines in the scale set. Computer name prefixes must be 1 to 15 characters long.
        :paramtype computer_name_prefix: str
        :keyword admin_username: Specifies the name of the administrator account.
         :code:`<br>`:code:`<br>` **Windows-only restriction:** Cannot end in "."
         :code:`<br>`:code:`<br>` **Disallowed values:** "administrator", "admin", "user", "user1",
         "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2",
         "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql",
         "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
         :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character :code:`<br>`:code:`<br>`
         **Max-length (Linux):** 64 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 20
         characters  :code:`<br>`:code:`<br>`:code:`<li>` For root access to the Linux VM, see `Using
         root privileges on Linux virtual machines in Azure
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_\
         :code:`<br>`:code:`<li>` For a list of built-in system users on Linux that should not be used
         in this field, see `Selecting User Names for Linux on Azure
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
        :paramtype admin_username: str
        :keyword admin_password: Specifies the password of the administrator account.
         :code:`<br>`:code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`:code:`<br>`
         **Minimum-length (Linux):** 6 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 123
         characters :code:`<br>`:code:`<br>` **Max-length (Linux):** 72 characters
         :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be
         fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a
         digit :code:`<br>` Has a special character (Regex match [\W_]) :code:`<br>`:code:`<br>`
         **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
         "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`:code:`<br>` For
         resetting the password, see `How to reset the Remote Desktop service or its login password in a
         Windows VM
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_
         :code:`<br>`:code:`<br>` For resetting root password, see `Manage users, SSH, and check or
         repair disks on Azure Linux VMs using the VMAccess Extension
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#reset-root-password>`_.
        :paramtype admin_password: str
        :keyword custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
         string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum
         length of the binary array is 65535 bytes. :code:`<br>`:code:`<br>` For using cloud-init for
         your VM, see `Using cloud-init to customize a Linux VM during creation
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
        :paramtype custom_data: str
        :keyword windows_configuration: Specifies Windows operating system settings on the virtual
         machine.
        :paramtype windows_configuration: ~azure.mgmt.compute.v2017_12_01.models.WindowsConfiguration
        :keyword linux_configuration: Specifies the Linux operating system settings on the virtual
         machine. :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on
         Azure-Endorsed Distributions
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_
         :code:`<br>`:code:`<br>` For running non-endorsed distributions, see `Information for
         Non-Endorsed Distributions
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
        :paramtype linux_configuration: ~azure.mgmt.compute.v2017_12_01.models.LinuxConfiguration
        :keyword secrets: Specifies set of certificates that should be installed onto the virtual
         machines in the scale set.
        :paramtype secrets: list[~azure.mgmt.compute.v2017_12_01.models.VaultSecretGroup]
        """
        super().__init__(**kwargs)
        self.computer_name_prefix = computer_name_prefix
        self.admin_username = admin_username
        self.admin_password = admin_password
        self.custom_data = custom_data
        self.windows_configuration = windows_configuration
        self.linux_configuration = linux_configuration
        self.secrets = secrets


class VirtualMachineScaleSetPublicIPAddressConfiguration(_serialization.Model):
    """Describes a virtual machines scale set IP Configuration's PublicIPAddress configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The publicIP address configuration name. Required.
    :vartype name: str
    :ivar idle_timeout_in_minutes: The idle timeout of the public IP address.
    :vartype idle_timeout_in_minutes: int
    :ivar dns_settings: The dns settings to be applied on the publicIP addresses .
    :vartype dns_settings:
     ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "idle_timeout_in_minutes": {"key": "properties.idleTimeoutInMinutes", "type": "int"},
        "dns_settings": {
            "key": "properties.dnsSettings",
            "type": "VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings",
        },
    }

    def __init__(
        self,
        *,
        name: str,
        idle_timeout_in_minutes: Optional[int] = None,
        dns_settings: Optional["_models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings"] = None,
        **kwargs
    ):
        """
        :keyword name: The publicIP address configuration name. Required.
        :paramtype name: str
        :keyword idle_timeout_in_minutes: The idle timeout of the public IP address.
        :paramtype idle_timeout_in_minutes: int
        :keyword dns_settings: The dns settings to be applied on the publicIP addresses .
        :paramtype dns_settings:
         ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings
        """
        super().__init__(**kwargs)
        self.name = name
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.dns_settings = dns_settings


class VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings(_serialization.Model):
    """Describes a virtual machines scale sets network configuration's DNS settings.

    All required parameters must be populated in order to send to Azure.

    :ivar domain_name_label: The Domain name label.The concatenation of the domain name label and
     vm index will be the domain name labels of the PublicIPAddress resources that will be created.
     Required.
    :vartype domain_name_label: str
    """

    _validation = {
        "domain_name_label": {"required": True},
    }

    _attribute_map = {
        "domain_name_label": {"key": "domainNameLabel", "type": "str"},
    }

    def __init__(self, *, domain_name_label: str, **kwargs):
        """
        :keyword domain_name_label: The Domain name label.The concatenation of the domain name label
         and vm index will be the domain name labels of the PublicIPAddress resources that will be
         created. Required.
        :paramtype domain_name_label: str
        """
        super().__init__(**kwargs)
        self.domain_name_label = domain_name_label


class VirtualMachineScaleSetSku(_serialization.Model):
    """Describes an available virtual machine scale set sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The type of resource the sku applies to.
    :vartype resource_type: str
    :ivar sku: The Sku.
    :vartype sku: ~azure.mgmt.compute.v2017_12_01.models.Sku
    :ivar capacity: Specifies the number of virtual machines in the scale set.
    :vartype capacity: ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetSkuCapacity
    """

    _validation = {
        "resource_type": {"readonly": True},
        "sku": {"readonly": True},
        "capacity": {"readonly": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "capacity": {"key": "capacity", "type": "VirtualMachineScaleSetSkuCapacity"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.resource_type = None
        self.sku = None
        self.capacity = None


class VirtualMachineScaleSetSkuCapacity(_serialization.Model):
    """Describes scaling information of a sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar minimum: The minimum capacity.
    :vartype minimum: int
    :ivar maximum: The maximum capacity that can be set.
    :vartype maximum: int
    :ivar default_capacity: The default capacity.
    :vartype default_capacity: int
    :ivar scale_type: The scale type applicable to the sku. Known values are: "Automatic" and
     "None".
    :vartype scale_type: str or
     ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetSkuScaleType
    """

    _validation = {
        "minimum": {"readonly": True},
        "maximum": {"readonly": True},
        "default_capacity": {"readonly": True},
        "scale_type": {"readonly": True},
    }

    _attribute_map = {
        "minimum": {"key": "minimum", "type": "int"},
        "maximum": {"key": "maximum", "type": "int"},
        "default_capacity": {"key": "defaultCapacity", "type": "int"},
        "scale_type": {"key": "scaleType", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.minimum = None
        self.maximum = None
        self.default_capacity = None
        self.scale_type = None


class VirtualMachineScaleSetStorageProfile(_serialization.Model):
    """Describes a virtual machine scale set storage profile.

    :ivar image_reference: Specifies information about the image to use. You can specify
     information about platform images, marketplace images, or virtual machine images. This element
     is required when you want to use a platform image, marketplace image, or virtual machine image,
     but is not used in other creation operations.
    :vartype image_reference: ~azure.mgmt.compute.v2017_12_01.models.ImageReference
    :ivar os_disk: Specifies information about the operating system disk used by the virtual
     machines in the scale set. :code:`<br>`:code:`<br>` For more information about disks, see
     `About disks and VHDs for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
    :vartype os_disk: ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetOSDisk
    :ivar data_disks: Specifies the parameters that are used to add data disks to the virtual
     machines in the scale set. :code:`<br>`:code:`<br>` For more information about disks, see
     `About disks and VHDs for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
    :vartype data_disks:
     list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetDataDisk]
    """

    _attribute_map = {
        "image_reference": {"key": "imageReference", "type": "ImageReference"},
        "os_disk": {"key": "osDisk", "type": "VirtualMachineScaleSetOSDisk"},
        "data_disks": {"key": "dataDisks", "type": "[VirtualMachineScaleSetDataDisk]"},
    }

    def __init__(
        self,
        *,
        image_reference: Optional["_models.ImageReference"] = None,
        os_disk: Optional["_models.VirtualMachineScaleSetOSDisk"] = None,
        data_disks: Optional[List["_models.VirtualMachineScaleSetDataDisk"]] = None,
        **kwargs
    ):
        """
        :keyword image_reference: Specifies information about the image to use. You can specify
         information about platform images, marketplace images, or virtual machine images. This element
         is required when you want to use a platform image, marketplace image, or virtual machine image,
         but is not used in other creation operations.
        :paramtype image_reference: ~azure.mgmt.compute.v2017_12_01.models.ImageReference
        :keyword os_disk: Specifies information about the operating system disk used by the virtual
         machines in the scale set. :code:`<br>`:code:`<br>` For more information about disks, see
         `About disks and VHDs for Azure virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
        :paramtype os_disk: ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetOSDisk
        :keyword data_disks: Specifies the parameters that are used to add data disks to the virtual
         machines in the scale set. :code:`<br>`:code:`<br>` For more information about disks, see
         `About disks and VHDs for Azure virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
        :paramtype data_disks:
         list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetDataDisk]
        """
        super().__init__(**kwargs)
        self.image_reference = image_reference
        self.os_disk = os_disk
        self.data_disks = data_disks


class VirtualMachineScaleSetUpdate(UpdateResource):
    """Describes a Virtual Machine Scale Set.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The virtual machine scale set sku.
    :vartype sku: ~azure.mgmt.compute.v2017_12_01.models.Sku
    :ivar plan: The purchase plan when deploying a virtual machine scale set from VM Marketplace
     images.
    :vartype plan: ~azure.mgmt.compute.v2017_12_01.models.Plan
    :ivar identity: The identity of the virtual machine scale set, if configured.
    :vartype identity: ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetIdentity
    :ivar upgrade_policy: The upgrade policy.
    :vartype upgrade_policy: ~azure.mgmt.compute.v2017_12_01.models.UpgradePolicy
    :ivar virtual_machine_profile: The virtual machine profile.
    :vartype virtual_machine_profile:
     ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetUpdateVMProfile
    :ivar overprovision: Specifies whether the Virtual Machine Scale Set should be overprovisioned.
    :vartype overprovision: bool
    :ivar single_placement_group: When true this limits the scale set to a single placement group,
     of max size 100 virtual machines. NOTE: If singlePlacementGroup is true, it may be modified to
     false. However, if singlePlacementGroup is false, it may not be modified to true.
    :vartype single_placement_group: bool
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "plan": {"key": "plan", "type": "Plan"},
        "identity": {"key": "identity", "type": "VirtualMachineScaleSetIdentity"},
        "upgrade_policy": {"key": "properties.upgradePolicy", "type": "UpgradePolicy"},
        "virtual_machine_profile": {
            "key": "properties.virtualMachineProfile",
            "type": "VirtualMachineScaleSetUpdateVMProfile",
        },
        "overprovision": {"key": "properties.overprovision", "type": "bool"},
        "single_placement_group": {"key": "properties.singlePlacementGroup", "type": "bool"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        plan: Optional["_models.Plan"] = None,
        identity: Optional["_models.VirtualMachineScaleSetIdentity"] = None,
        upgrade_policy: Optional["_models.UpgradePolicy"] = None,
        virtual_machine_profile: Optional["_models.VirtualMachineScaleSetUpdateVMProfile"] = None,
        overprovision: Optional[bool] = None,
        single_placement_group: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The virtual machine scale set sku.
        :paramtype sku: ~azure.mgmt.compute.v2017_12_01.models.Sku
        :keyword plan: The purchase plan when deploying a virtual machine scale set from VM Marketplace
         images.
        :paramtype plan: ~azure.mgmt.compute.v2017_12_01.models.Plan
        :keyword identity: The identity of the virtual machine scale set, if configured.
        :paramtype identity: ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetIdentity
        :keyword upgrade_policy: The upgrade policy.
        :paramtype upgrade_policy: ~azure.mgmt.compute.v2017_12_01.models.UpgradePolicy
        :keyword virtual_machine_profile: The virtual machine profile.
        :paramtype virtual_machine_profile:
         ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetUpdateVMProfile
        :keyword overprovision: Specifies whether the Virtual Machine Scale Set should be
         overprovisioned.
        :paramtype overprovision: bool
        :keyword single_placement_group: When true this limits the scale set to a single placement
         group, of max size 100 virtual machines. NOTE: If singlePlacementGroup is true, it may be
         modified to false. However, if singlePlacementGroup is false, it may not be modified to true.
        :paramtype single_placement_group: bool
        """
        super().__init__(tags=tags, **kwargs)
        self.sku = sku
        self.plan = plan
        self.identity = identity
        self.upgrade_policy = upgrade_policy
        self.virtual_machine_profile = virtual_machine_profile
        self.overprovision = overprovision
        self.single_placement_group = single_placement_group


class VirtualMachineScaleSetUpdateIPConfiguration(SubResource):
    """Describes a virtual machine scale set network profile's IP configuration.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The IP configuration name.
    :vartype name: str
    :ivar subnet: The subnet.
    :vartype subnet: ~azure.mgmt.compute.v2017_12_01.models.ApiEntityReference
    :ivar primary: Specifies the primary IP Configuration in case the network interface has more
     than one IP Configuration.
    :vartype primary: bool
    :ivar public_ip_address_configuration: The publicIPAddressConfiguration.
    :vartype public_ip_address_configuration:
     ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetUpdatePublicIPAddressConfiguration
    :ivar private_ip_address_version: Available from Api-Version 2017-03-30 onwards, it represents
     whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible
     values are: 'IPv4' and 'IPv6'. Known values are: "IPv4" and "IPv6".
    :vartype private_ip_address_version: str or ~azure.mgmt.compute.v2017_12_01.models.IPVersion
    :ivar application_gateway_backend_address_pools: The application gateway backend address pools.
    :vartype application_gateway_backend_address_pools:
     list[~azure.mgmt.compute.v2017_12_01.models.SubResource]
    :ivar load_balancer_backend_address_pools: The load balancer backend address pools.
    :vartype load_balancer_backend_address_pools:
     list[~azure.mgmt.compute.v2017_12_01.models.SubResource]
    :ivar load_balancer_inbound_nat_pools: The load balancer inbound nat pools.
    :vartype load_balancer_inbound_nat_pools:
     list[~azure.mgmt.compute.v2017_12_01.models.SubResource]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "ApiEntityReference"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "public_ip_address_configuration": {
            "key": "properties.publicIPAddressConfiguration",
            "type": "VirtualMachineScaleSetUpdatePublicIPAddressConfiguration",
        },
        "private_ip_address_version": {"key": "properties.privateIPAddressVersion", "type": "str"},
        "application_gateway_backend_address_pools": {
            "key": "properties.applicationGatewayBackendAddressPools",
            "type": "[SubResource]",
        },
        "load_balancer_backend_address_pools": {
            "key": "properties.loadBalancerBackendAddressPools",
            "type": "[SubResource]",
        },
        "load_balancer_inbound_nat_pools": {"key": "properties.loadBalancerInboundNatPools", "type": "[SubResource]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        subnet: Optional["_models.ApiEntityReference"] = None,
        primary: Optional[bool] = None,
        public_ip_address_configuration: Optional[
            "_models.VirtualMachineScaleSetUpdatePublicIPAddressConfiguration"
        ] = None,
        private_ip_address_version: Optional[Union[str, "_models.IPVersion"]] = None,
        application_gateway_backend_address_pools: Optional[List["_models.SubResource"]] = None,
        load_balancer_backend_address_pools: Optional[List["_models.SubResource"]] = None,
        load_balancer_inbound_nat_pools: Optional[List["_models.SubResource"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword name: The IP configuration name.
        :paramtype name: str
        :keyword subnet: The subnet.
        :paramtype subnet: ~azure.mgmt.compute.v2017_12_01.models.ApiEntityReference
        :keyword primary: Specifies the primary IP Configuration in case the network interface has more
         than one IP Configuration.
        :paramtype primary: bool
        :keyword public_ip_address_configuration: The publicIPAddressConfiguration.
        :paramtype public_ip_address_configuration:
         ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetUpdatePublicIPAddressConfiguration
        :keyword private_ip_address_version: Available from Api-Version 2017-03-30 onwards, it
         represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.
         Possible values are: 'IPv4' and 'IPv6'. Known values are: "IPv4" and "IPv6".
        :paramtype private_ip_address_version: str or ~azure.mgmt.compute.v2017_12_01.models.IPVersion
        :keyword application_gateway_backend_address_pools: The application gateway backend address
         pools.
        :paramtype application_gateway_backend_address_pools:
         list[~azure.mgmt.compute.v2017_12_01.models.SubResource]
        :keyword load_balancer_backend_address_pools: The load balancer backend address pools.
        :paramtype load_balancer_backend_address_pools:
         list[~azure.mgmt.compute.v2017_12_01.models.SubResource]
        :keyword load_balancer_inbound_nat_pools: The load balancer inbound nat pools.
        :paramtype load_balancer_inbound_nat_pools:
         list[~azure.mgmt.compute.v2017_12_01.models.SubResource]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.subnet = subnet
        self.primary = primary
        self.public_ip_address_configuration = public_ip_address_configuration
        self.private_ip_address_version = private_ip_address_version
        self.application_gateway_backend_address_pools = application_gateway_backend_address_pools
        self.load_balancer_backend_address_pools = load_balancer_backend_address_pools
        self.load_balancer_inbound_nat_pools = load_balancer_inbound_nat_pools


class VirtualMachineScaleSetUpdateNetworkConfiguration(SubResource):
    """Describes a virtual machine scale set network profile's network configurations.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The network configuration name.
    :vartype name: str
    :ivar primary: Whether this is a primary NIC on a virtual machine.
    :vartype primary: bool
    :ivar enable_accelerated_networking: Specifies whether the network interface is accelerated
     networking-enabled.
    :vartype enable_accelerated_networking: bool
    :ivar network_security_group: The network security group.
    :vartype network_security_group: ~azure.mgmt.compute.v2017_12_01.models.SubResource
    :ivar dns_settings: The dns settings to be applied on the network interfaces.
    :vartype dns_settings:
     ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetNetworkConfigurationDnsSettings
    :ivar ip_configurations: The virtual machine scale set IP Configuration.
    :vartype ip_configurations:
     list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetUpdateIPConfiguration]
    :ivar enable_ip_forwarding: Whether IP forwarding enabled on this NIC.
    :vartype enable_ip_forwarding: bool
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "enable_accelerated_networking": {"key": "properties.enableAcceleratedNetworking", "type": "bool"},
        "network_security_group": {"key": "properties.networkSecurityGroup", "type": "SubResource"},
        "dns_settings": {
            "key": "properties.dnsSettings",
            "type": "VirtualMachineScaleSetNetworkConfigurationDnsSettings",
        },
        "ip_configurations": {
            "key": "properties.ipConfigurations",
            "type": "[VirtualMachineScaleSetUpdateIPConfiguration]",
        },
        "enable_ip_forwarding": {"key": "properties.enableIPForwarding", "type": "bool"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        primary: Optional[bool] = None,
        enable_accelerated_networking: Optional[bool] = None,
        network_security_group: Optional["_models.SubResource"] = None,
        dns_settings: Optional["_models.VirtualMachineScaleSetNetworkConfigurationDnsSettings"] = None,
        ip_configurations: Optional[List["_models.VirtualMachineScaleSetUpdateIPConfiguration"]] = None,
        enable_ip_forwarding: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword name: The network configuration name.
        :paramtype name: str
        :keyword primary: Whether this is a primary NIC on a virtual machine.
        :paramtype primary: bool
        :keyword enable_accelerated_networking: Specifies whether the network interface is accelerated
         networking-enabled.
        :paramtype enable_accelerated_networking: bool
        :keyword network_security_group: The network security group.
        :paramtype network_security_group: ~azure.mgmt.compute.v2017_12_01.models.SubResource
        :keyword dns_settings: The dns settings to be applied on the network interfaces.
        :paramtype dns_settings:
         ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetNetworkConfigurationDnsSettings
        :keyword ip_configurations: The virtual machine scale set IP Configuration.
        :paramtype ip_configurations:
         list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetUpdateIPConfiguration]
        :keyword enable_ip_forwarding: Whether IP forwarding enabled on this NIC.
        :paramtype enable_ip_forwarding: bool
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.primary = primary
        self.enable_accelerated_networking = enable_accelerated_networking
        self.network_security_group = network_security_group
        self.dns_settings = dns_settings
        self.ip_configurations = ip_configurations
        self.enable_ip_forwarding = enable_ip_forwarding


class VirtualMachineScaleSetUpdateNetworkProfile(_serialization.Model):
    """Describes a virtual machine scale set network profile.

    :ivar network_interface_configurations: The list of network configurations.
    :vartype network_interface_configurations:
     list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetUpdateNetworkConfiguration]
    """

    _attribute_map = {
        "network_interface_configurations": {
            "key": "networkInterfaceConfigurations",
            "type": "[VirtualMachineScaleSetUpdateNetworkConfiguration]",
        },
    }

    def __init__(
        self,
        *,
        network_interface_configurations: Optional[
            List["_models.VirtualMachineScaleSetUpdateNetworkConfiguration"]
        ] = None,
        **kwargs
    ):
        """
        :keyword network_interface_configurations: The list of network configurations.
        :paramtype network_interface_configurations:
         list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetUpdateNetworkConfiguration]
        """
        super().__init__(**kwargs)
        self.network_interface_configurations = network_interface_configurations


class VirtualMachineScaleSetUpdateOSDisk(_serialization.Model):
    """Describes virtual machine scale set operating system disk Update Object. This should be used for Updating VMSS OS Disk.

    :ivar caching: The caching type. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.v2017_12_01.models.CachingTypes
    :ivar write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :vartype write_accelerator_enabled: bool
    :ivar image: The Source User Image VirtualHardDisk. This VirtualHardDisk will be copied before
     using it to attach to the Virtual Machine. If SourceImage is provided, the destination
     VirtualHardDisk should not exist.
    :vartype image: ~azure.mgmt.compute.v2017_12_01.models.VirtualHardDisk
    :ivar vhd_containers: The list of virtual hard disk container uris.
    :vartype vhd_containers: list[str]
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk:
     ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetManagedDiskParameters
    """

    _attribute_map = {
        "caching": {"key": "caching", "type": "str"},
        "write_accelerator_enabled": {"key": "writeAcceleratorEnabled", "type": "bool"},
        "image": {"key": "image", "type": "VirtualHardDisk"},
        "vhd_containers": {"key": "vhdContainers", "type": "[str]"},
        "managed_disk": {"key": "managedDisk", "type": "VirtualMachineScaleSetManagedDiskParameters"},
    }

    def __init__(
        self,
        *,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        image: Optional["_models.VirtualHardDisk"] = None,
        vhd_containers: Optional[List[str]] = None,
        managed_disk: Optional["_models.VirtualMachineScaleSetManagedDiskParameters"] = None,
        **kwargs
    ):
        """
        :keyword caching: The caching type. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.v2017_12_01.models.CachingTypes
        :keyword write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
         disabled on the disk.
        :paramtype write_accelerator_enabled: bool
        :keyword image: The Source User Image VirtualHardDisk. This VirtualHardDisk will be copied
         before using it to attach to the Virtual Machine. If SourceImage is provided, the destination
         VirtualHardDisk should not exist.
        :paramtype image: ~azure.mgmt.compute.v2017_12_01.models.VirtualHardDisk
        :keyword vhd_containers: The list of virtual hard disk container uris.
        :paramtype vhd_containers: list[str]
        :keyword managed_disk: The managed disk parameters.
        :paramtype managed_disk:
         ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetManagedDiskParameters
        """
        super().__init__(**kwargs)
        self.caching = caching
        self.write_accelerator_enabled = write_accelerator_enabled
        self.image = image
        self.vhd_containers = vhd_containers
        self.managed_disk = managed_disk


class VirtualMachineScaleSetUpdateOSProfile(_serialization.Model):
    """Describes a virtual machine scale set OS profile.

    :ivar custom_data: A base-64 encoded string of custom data.
    :vartype custom_data: str
    :ivar windows_configuration: The Windows Configuration of the OS profile.
    :vartype windows_configuration: ~azure.mgmt.compute.v2017_12_01.models.WindowsConfiguration
    :ivar linux_configuration: The Linux Configuration of the OS profile.
    :vartype linux_configuration: ~azure.mgmt.compute.v2017_12_01.models.LinuxConfiguration
    :ivar secrets: The List of certificates for addition to the VM.
    :vartype secrets: list[~azure.mgmt.compute.v2017_12_01.models.VaultSecretGroup]
    """

    _attribute_map = {
        "custom_data": {"key": "customData", "type": "str"},
        "windows_configuration": {"key": "windowsConfiguration", "type": "WindowsConfiguration"},
        "linux_configuration": {"key": "linuxConfiguration", "type": "LinuxConfiguration"},
        "secrets": {"key": "secrets", "type": "[VaultSecretGroup]"},
    }

    def __init__(
        self,
        *,
        custom_data: Optional[str] = None,
        windows_configuration: Optional["_models.WindowsConfiguration"] = None,
        linux_configuration: Optional["_models.LinuxConfiguration"] = None,
        secrets: Optional[List["_models.VaultSecretGroup"]] = None,
        **kwargs
    ):
        """
        :keyword custom_data: A base-64 encoded string of custom data.
        :paramtype custom_data: str
        :keyword windows_configuration: The Windows Configuration of the OS profile.
        :paramtype windows_configuration: ~azure.mgmt.compute.v2017_12_01.models.WindowsConfiguration
        :keyword linux_configuration: The Linux Configuration of the OS profile.
        :paramtype linux_configuration: ~azure.mgmt.compute.v2017_12_01.models.LinuxConfiguration
        :keyword secrets: The List of certificates for addition to the VM.
        :paramtype secrets: list[~azure.mgmt.compute.v2017_12_01.models.VaultSecretGroup]
        """
        super().__init__(**kwargs)
        self.custom_data = custom_data
        self.windows_configuration = windows_configuration
        self.linux_configuration = linux_configuration
        self.secrets = secrets


class VirtualMachineScaleSetUpdatePublicIPAddressConfiguration(_serialization.Model):
    """Describes a virtual machines scale set IP Configuration's PublicIPAddress configuration.

    :ivar name: The publicIP address configuration name.
    :vartype name: str
    :ivar idle_timeout_in_minutes: The idle timeout of the public IP address.
    :vartype idle_timeout_in_minutes: int
    :ivar dns_settings: The dns settings to be applied on the publicIP addresses .
    :vartype dns_settings:
     ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "idle_timeout_in_minutes": {"key": "properties.idleTimeoutInMinutes", "type": "int"},
        "dns_settings": {
            "key": "properties.dnsSettings",
            "type": "VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings",
        },
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        dns_settings: Optional["_models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings"] = None,
        **kwargs
    ):
        """
        :keyword name: The publicIP address configuration name.
        :paramtype name: str
        :keyword idle_timeout_in_minutes: The idle timeout of the public IP address.
        :paramtype idle_timeout_in_minutes: int
        :keyword dns_settings: The dns settings to be applied on the publicIP addresses .
        :paramtype dns_settings:
         ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings
        """
        super().__init__(**kwargs)
        self.name = name
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.dns_settings = dns_settings


class VirtualMachineScaleSetUpdateStorageProfile(_serialization.Model):
    """Describes a virtual machine scale set storage profile.

    :ivar image_reference: The image reference.
    :vartype image_reference: ~azure.mgmt.compute.v2017_12_01.models.ImageReference
    :ivar os_disk: The OS disk.
    :vartype os_disk: ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetUpdateOSDisk
    :ivar data_disks: The data disks.
    :vartype data_disks:
     list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetDataDisk]
    """

    _attribute_map = {
        "image_reference": {"key": "imageReference", "type": "ImageReference"},
        "os_disk": {"key": "osDisk", "type": "VirtualMachineScaleSetUpdateOSDisk"},
        "data_disks": {"key": "dataDisks", "type": "[VirtualMachineScaleSetDataDisk]"},
    }

    def __init__(
        self,
        *,
        image_reference: Optional["_models.ImageReference"] = None,
        os_disk: Optional["_models.VirtualMachineScaleSetUpdateOSDisk"] = None,
        data_disks: Optional[List["_models.VirtualMachineScaleSetDataDisk"]] = None,
        **kwargs
    ):
        """
        :keyword image_reference: The image reference.
        :paramtype image_reference: ~azure.mgmt.compute.v2017_12_01.models.ImageReference
        :keyword os_disk: The OS disk.
        :paramtype os_disk: ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetUpdateOSDisk
        :keyword data_disks: The data disks.
        :paramtype data_disks:
         list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetDataDisk]
        """
        super().__init__(**kwargs)
        self.image_reference = image_reference
        self.os_disk = os_disk
        self.data_disks = data_disks


class VirtualMachineScaleSetUpdateVMProfile(_serialization.Model):
    """Describes a virtual machine scale set virtual machine profile.

    :ivar os_profile: The virtual machine scale set OS profile.
    :vartype os_profile:
     ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetUpdateOSProfile
    :ivar storage_profile: The virtual machine scale set storage profile.
    :vartype storage_profile:
     ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetUpdateStorageProfile
    :ivar network_profile: The virtual machine scale set network profile.
    :vartype network_profile:
     ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetUpdateNetworkProfile
    :ivar diagnostics_profile: The virtual machine scale set diagnostics profile.
    :vartype diagnostics_profile: ~azure.mgmt.compute.v2017_12_01.models.DiagnosticsProfile
    :ivar extension_profile: The virtual machine scale set extension profile.
    :vartype extension_profile:
     ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetExtensionProfile
    :ivar license_type: The license type, which is for bring your own license scenario.
    :vartype license_type: str
    """

    _attribute_map = {
        "os_profile": {"key": "osProfile", "type": "VirtualMachineScaleSetUpdateOSProfile"},
        "storage_profile": {"key": "storageProfile", "type": "VirtualMachineScaleSetUpdateStorageProfile"},
        "network_profile": {"key": "networkProfile", "type": "VirtualMachineScaleSetUpdateNetworkProfile"},
        "diagnostics_profile": {"key": "diagnosticsProfile", "type": "DiagnosticsProfile"},
        "extension_profile": {"key": "extensionProfile", "type": "VirtualMachineScaleSetExtensionProfile"},
        "license_type": {"key": "licenseType", "type": "str"},
    }

    def __init__(
        self,
        *,
        os_profile: Optional["_models.VirtualMachineScaleSetUpdateOSProfile"] = None,
        storage_profile: Optional["_models.VirtualMachineScaleSetUpdateStorageProfile"] = None,
        network_profile: Optional["_models.VirtualMachineScaleSetUpdateNetworkProfile"] = None,
        diagnostics_profile: Optional["_models.DiagnosticsProfile"] = None,
        extension_profile: Optional["_models.VirtualMachineScaleSetExtensionProfile"] = None,
        license_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword os_profile: The virtual machine scale set OS profile.
        :paramtype os_profile:
         ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetUpdateOSProfile
        :keyword storage_profile: The virtual machine scale set storage profile.
        :paramtype storage_profile:
         ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetUpdateStorageProfile
        :keyword network_profile: The virtual machine scale set network profile.
        :paramtype network_profile:
         ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetUpdateNetworkProfile
        :keyword diagnostics_profile: The virtual machine scale set diagnostics profile.
        :paramtype diagnostics_profile: ~azure.mgmt.compute.v2017_12_01.models.DiagnosticsProfile
        :keyword extension_profile: The virtual machine scale set extension profile.
        :paramtype extension_profile:
         ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetExtensionProfile
        :keyword license_type: The license type, which is for bring your own license scenario.
        :paramtype license_type: str
        """
        super().__init__(**kwargs)
        self.os_profile = os_profile
        self.storage_profile = storage_profile
        self.network_profile = network_profile
        self.diagnostics_profile = diagnostics_profile
        self.extension_profile = extension_profile
        self.license_type = license_type


class VirtualMachineScaleSetVM(Resource):  # pylint: disable=too-many-instance-attributes
    """Describes a virtual machine scale set virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar instance_id: The virtual machine instance ID.
    :vartype instance_id: str
    :ivar sku: The virtual machine SKU.
    :vartype sku: ~azure.mgmt.compute.v2017_12_01.models.Sku
    :ivar plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :vartype plan: ~azure.mgmt.compute.v2017_12_01.models.Plan
    :ivar resources: The virtual machine child extension resources.
    :vartype resources: list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineExtension]
    :ivar latest_model_applied: Specifies whether the latest model has been applied to the virtual
     machine.
    :vartype latest_model_applied: bool
    :ivar vm_id: Azure VM unique ID.
    :vartype vm_id: str
    :ivar instance_view: The virtual machine instance view.
    :vartype instance_view:
     ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetVMInstanceView
    :ivar hardware_profile: Specifies the hardware settings for the virtual machine.
    :vartype hardware_profile: ~azure.mgmt.compute.v2017_12_01.models.HardwareProfile
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile: ~azure.mgmt.compute.v2017_12_01.models.StorageProfile
    :ivar os_profile: Specifies the operating system settings for the virtual machine.
    :vartype os_profile: ~azure.mgmt.compute.v2017_12_01.models.OSProfile
    :ivar network_profile: Specifies the network interfaces of the virtual machine.
    :vartype network_profile: ~azure.mgmt.compute.v2017_12_01.models.NetworkProfile
    :ivar diagnostics_profile: Specifies the boot diagnostic settings state.
     :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
    :vartype diagnostics_profile: ~azure.mgmt.compute.v2017_12_01.models.DiagnosticsProfile
    :ivar availability_set: Specifies information about the availability set that the virtual
     machine should be assigned to. Virtual machines specified in the same availability set are
     allocated to different nodes to maximize availability. For more information about availability
     sets, see `Manage the availability of virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-manage-availability?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
     :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Planned
     maintenance for virtual machines in Azure
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-planned-maintenance?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_
     :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
     time. An existing VM cannot be added to an availability set.
    :vartype availability_set: ~azure.mgmt.compute.v2017_12_01.models.SubResource
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar license_type: Specifies that the image or disk that is being used was licensed
     on-premises. This element is only used for images that contain the Windows Server operating
     system. :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` Windows_Client
     :code:`<br>`:code:`<br>` Windows_Server :code:`<br>`:code:`<br>` If this element is included in
     a request for an update, the value must match the initial value. This value cannot be updated.
     :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :vartype license_type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "instance_id": {"readonly": True},
        "sku": {"readonly": True},
        "resources": {"readonly": True},
        "latest_model_applied": {"readonly": True},
        "vm_id": {"readonly": True},
        "instance_view": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "instance_id": {"key": "instanceId", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "plan": {"key": "plan", "type": "Plan"},
        "resources": {"key": "resources", "type": "[VirtualMachineExtension]"},
        "latest_model_applied": {"key": "properties.latestModelApplied", "type": "bool"},
        "vm_id": {"key": "properties.vmId", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "VirtualMachineScaleSetVMInstanceView"},
        "hardware_profile": {"key": "properties.hardwareProfile", "type": "HardwareProfile"},
        "storage_profile": {"key": "properties.storageProfile", "type": "StorageProfile"},
        "os_profile": {"key": "properties.osProfile", "type": "OSProfile"},
        "network_profile": {"key": "properties.networkProfile", "type": "NetworkProfile"},
        "diagnostics_profile": {"key": "properties.diagnosticsProfile", "type": "DiagnosticsProfile"},
        "availability_set": {"key": "properties.availabilitySet", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["_models.Plan"] = None,
        hardware_profile: Optional["_models.HardwareProfile"] = None,
        storage_profile: Optional["_models.StorageProfile"] = None,
        os_profile: Optional["_models.OSProfile"] = None,
        network_profile: Optional["_models.NetworkProfile"] = None,
        diagnostics_profile: Optional["_models.DiagnosticsProfile"] = None,
        availability_set: Optional["_models.SubResource"] = None,
        license_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword plan: Specifies information about the marketplace image used to create the virtual
         machine. This element is only used for marketplace images. Before you can use a marketplace
         image from an API, you must enable the image for programmatic use.  In the Azure portal, find
         the marketplace image that you want to use and then click **Want to deploy programmatically,
         Get Started ->**. Enter any required information and then click **Save**.
        :paramtype plan: ~azure.mgmt.compute.v2017_12_01.models.Plan
        :keyword hardware_profile: Specifies the hardware settings for the virtual machine.
        :paramtype hardware_profile: ~azure.mgmt.compute.v2017_12_01.models.HardwareProfile
        :keyword storage_profile: Specifies the storage settings for the virtual machine disks.
        :paramtype storage_profile: ~azure.mgmt.compute.v2017_12_01.models.StorageProfile
        :keyword os_profile: Specifies the operating system settings for the virtual machine.
        :paramtype os_profile: ~azure.mgmt.compute.v2017_12_01.models.OSProfile
        :keyword network_profile: Specifies the network interfaces of the virtual machine.
        :paramtype network_profile: ~azure.mgmt.compute.v2017_12_01.models.NetworkProfile
        :keyword diagnostics_profile: Specifies the boot diagnostic settings state.
         :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
        :paramtype diagnostics_profile: ~azure.mgmt.compute.v2017_12_01.models.DiagnosticsProfile
        :keyword availability_set: Specifies information about the availability set that the virtual
         machine should be assigned to. Virtual machines specified in the same availability set are
         allocated to different nodes to maximize availability. For more information about availability
         sets, see `Manage the availability of virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-manage-availability?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
         :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Planned
         maintenance for virtual machines in Azure
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-planned-maintenance?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_
         :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
         time. An existing VM cannot be added to an availability set.
        :paramtype availability_set: ~azure.mgmt.compute.v2017_12_01.models.SubResource
        :keyword license_type: Specifies that the image or disk that is being used was licensed
         on-premises. This element is only used for images that contain the Windows Server operating
         system. :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` Windows_Client
         :code:`<br>`:code:`<br>` Windows_Server :code:`<br>`:code:`<br>` If this element is included in
         a request for an update, the value must match the initial value. This value cannot be updated.
         :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_
         :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
        :paramtype license_type: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.instance_id = None
        self.sku = None
        self.plan = plan
        self.resources = None
        self.latest_model_applied = None
        self.vm_id = None
        self.instance_view = None
        self.hardware_profile = hardware_profile
        self.storage_profile = storage_profile
        self.os_profile = os_profile
        self.network_profile = network_profile
        self.diagnostics_profile = diagnostics_profile
        self.availability_set = availability_set
        self.provisioning_state = None
        self.license_type = license_type


class VirtualMachineScaleSetVMExtensionsSummary(_serialization.Model):
    """Extensions summary for virtual machines of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The extension name.
    :vartype name: str
    :ivar statuses_summary: The extensions information.
    :vartype statuses_summary:
     list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineStatusCodeCount]
    """

    _validation = {
        "name": {"readonly": True},
        "statuses_summary": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "statuses_summary": {"key": "statusesSummary", "type": "[VirtualMachineStatusCodeCount]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.statuses_summary = None


class VirtualMachineScaleSetVMInstanceIDs(_serialization.Model):
    """Specifies a list of virtual machine instance IDs from the VM scale set.

    :ivar instance_ids: The virtual machine scale set instance ids. Omitting the virtual machine
     scale set instance ids will result in the operation being performed on all virtual machines in
     the virtual machine scale set.
    :vartype instance_ids: list[str]
    """

    _attribute_map = {
        "instance_ids": {"key": "instanceIds", "type": "[str]"},
    }

    def __init__(self, *, instance_ids: Optional[List[str]] = None, **kwargs):
        """
        :keyword instance_ids: The virtual machine scale set instance ids. Omitting the virtual machine
         scale set instance ids will result in the operation being performed on all virtual machines in
         the virtual machine scale set.
        :paramtype instance_ids: list[str]
        """
        super().__init__(**kwargs)
        self.instance_ids = instance_ids


class VirtualMachineScaleSetVMInstanceRequiredIDs(_serialization.Model):
    """Specifies a list of virtual machine instance IDs from the VM scale set.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_ids: The virtual machine scale set instance ids. Required.
    :vartype instance_ids: list[str]
    """

    _validation = {
        "instance_ids": {"required": True},
    }

    _attribute_map = {
        "instance_ids": {"key": "instanceIds", "type": "[str]"},
    }

    def __init__(self, *, instance_ids: List[str], **kwargs):
        """
        :keyword instance_ids: The virtual machine scale set instance ids. Required.
        :paramtype instance_ids: list[str]
        """
        super().__init__(**kwargs)
        self.instance_ids = instance_ids


class VirtualMachineScaleSetVMInstanceView(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The instance view of a virtual machine scale set VM.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar platform_update_domain: The Update Domain count.
    :vartype platform_update_domain: int
    :ivar platform_fault_domain: The Fault Domain count.
    :vartype platform_fault_domain: int
    :ivar rdp_thumb_print: The Remote desktop certificate thumbprint.
    :vartype rdp_thumb_print: str
    :ivar vm_agent: The VM Agent running on the virtual machine.
    :vartype vm_agent: ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineAgentInstanceView
    :ivar maintenance_redeploy_status: The Maintenance Operation status on the virtual machine.
    :vartype maintenance_redeploy_status:
     ~azure.mgmt.compute.v2017_12_01.models.MaintenanceRedeployStatus
    :ivar disks: The disks information.
    :vartype disks: list[~azure.mgmt.compute.v2017_12_01.models.DiskInstanceView]
    :ivar extensions: The extensions information.
    :vartype extensions:
     list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineExtensionInstanceView]
    :ivar vm_health: The health status for the VM.
    :vartype vm_health: ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineHealthStatus
    :ivar boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
     Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
     view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
     screenshot of the VM from the hypervisor.
    :vartype boot_diagnostics: ~azure.mgmt.compute.v2017_12_01.models.BootDiagnosticsInstanceView
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2017_12_01.models.InstanceViewStatus]
    :ivar placement_group_id: The placement group in which the VM is running. If the VM is
     deallocated it will not have a placementGroupId.
    :vartype placement_group_id: str
    """

    _validation = {
        "vm_health": {"readonly": True},
    }

    _attribute_map = {
        "platform_update_domain": {"key": "platformUpdateDomain", "type": "int"},
        "platform_fault_domain": {"key": "platformFaultDomain", "type": "int"},
        "rdp_thumb_print": {"key": "rdpThumbPrint", "type": "str"},
        "vm_agent": {"key": "vmAgent", "type": "VirtualMachineAgentInstanceView"},
        "maintenance_redeploy_status": {"key": "maintenanceRedeployStatus", "type": "MaintenanceRedeployStatus"},
        "disks": {"key": "disks", "type": "[DiskInstanceView]"},
        "extensions": {"key": "extensions", "type": "[VirtualMachineExtensionInstanceView]"},
        "vm_health": {"key": "vmHealth", "type": "VirtualMachineHealthStatus"},
        "boot_diagnostics": {"key": "bootDiagnostics", "type": "BootDiagnosticsInstanceView"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
        "placement_group_id": {"key": "placementGroupId", "type": "str"},
    }

    def __init__(
        self,
        *,
        platform_update_domain: Optional[int] = None,
        platform_fault_domain: Optional[int] = None,
        rdp_thumb_print: Optional[str] = None,
        vm_agent: Optional["_models.VirtualMachineAgentInstanceView"] = None,
        maintenance_redeploy_status: Optional["_models.MaintenanceRedeployStatus"] = None,
        disks: Optional[List["_models.DiskInstanceView"]] = None,
        extensions: Optional[List["_models.VirtualMachineExtensionInstanceView"]] = None,
        boot_diagnostics: Optional["_models.BootDiagnosticsInstanceView"] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        placement_group_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword platform_update_domain: The Update Domain count.
        :paramtype platform_update_domain: int
        :keyword platform_fault_domain: The Fault Domain count.
        :paramtype platform_fault_domain: int
        :keyword rdp_thumb_print: The Remote desktop certificate thumbprint.
        :paramtype rdp_thumb_print: str
        :keyword vm_agent: The VM Agent running on the virtual machine.
        :paramtype vm_agent: ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineAgentInstanceView
        :keyword maintenance_redeploy_status: The Maintenance Operation status on the virtual machine.
        :paramtype maintenance_redeploy_status:
         ~azure.mgmt.compute.v2017_12_01.models.MaintenanceRedeployStatus
        :keyword disks: The disks information.
        :paramtype disks: list[~azure.mgmt.compute.v2017_12_01.models.DiskInstanceView]
        :keyword extensions: The extensions information.
        :paramtype extensions:
         list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineExtensionInstanceView]
        :keyword boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
         Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
         view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
         screenshot of the VM from the hypervisor.
        :paramtype boot_diagnostics: ~azure.mgmt.compute.v2017_12_01.models.BootDiagnosticsInstanceView
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.v2017_12_01.models.InstanceViewStatus]
        :keyword placement_group_id: The placement group in which the VM is running. If the VM is
         deallocated it will not have a placementGroupId.
        :paramtype placement_group_id: str
        """
        super().__init__(**kwargs)
        self.platform_update_domain = platform_update_domain
        self.platform_fault_domain = platform_fault_domain
        self.rdp_thumb_print = rdp_thumb_print
        self.vm_agent = vm_agent
        self.maintenance_redeploy_status = maintenance_redeploy_status
        self.disks = disks
        self.extensions = extensions
        self.vm_health = None
        self.boot_diagnostics = boot_diagnostics
        self.statuses = statuses
        self.placement_group_id = placement_group_id


class VirtualMachineScaleSetVMListResult(_serialization.Model):
    """The List Virtual Machine Scale Set VMs operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of virtual machine scale sets VMs. Required.
    :vartype value: list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetVM]
    :ivar next_link: The uri to fetch the next page of Virtual Machine Scale Set VMs. Call
     ListNext() with this to fetch the next page of VMSS VMs.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineScaleSetVM]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.VirtualMachineScaleSetVM"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The list of virtual machine scale sets VMs. Required.
        :paramtype value: list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetVM]
        :keyword next_link: The uri to fetch the next page of Virtual Machine Scale Set VMs. Call
         ListNext() with this to fetch the next page of VMSS VMs.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetVMProfile(_serialization.Model):
    """Describes a virtual machine scale set virtual machine profile.

    :ivar os_profile: Specifies the operating system settings for the virtual machines in the scale
     set.
    :vartype os_profile: ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetOSProfile
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile:
     ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetStorageProfile
    :ivar network_profile: Specifies properties of the network interfaces of the virtual machines
     in the scale set.
    :vartype network_profile:
     ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetNetworkProfile
    :ivar diagnostics_profile: Specifies the boot diagnostic settings state.
     :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
    :vartype diagnostics_profile: ~azure.mgmt.compute.v2017_12_01.models.DiagnosticsProfile
    :ivar extension_profile: Specifies a collection of settings for extensions installed on virtual
     machines in the scale set.
    :vartype extension_profile:
     ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetExtensionProfile
    :ivar license_type: Specifies that the image or disk that is being used was licensed
     on-premises. This element is only used for images that contain the Windows Server operating
     system. :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` Windows_Client
     :code:`<br>`:code:`<br>` Windows_Server :code:`<br>`:code:`<br>` If this element is included in
     a request for an update, the value must match the initial value. This value cannot be updated.
     :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :vartype license_type: str
    :ivar priority: Specifies the priority for the virtual machines in the scale set.
     :code:`<br>`:code:`<br>`Minimum api-version: 2017-10-30-preview. Known values are: "Regular"
     and "Low".
    :vartype priority: str or ~azure.mgmt.compute.v2017_12_01.models.VirtualMachinePriorityTypes
    :ivar eviction_policy: Specifies the eviction policy for virtual machines in a low priority
     scale set. :code:`<br>`:code:`<br>`Minimum api-version: 2017-10-30-preview. Known values are:
     "Deallocate" and "Delete".
    :vartype eviction_policy: str or
     ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineEvictionPolicyTypes
    """

    _attribute_map = {
        "os_profile": {"key": "osProfile", "type": "VirtualMachineScaleSetOSProfile"},
        "storage_profile": {"key": "storageProfile", "type": "VirtualMachineScaleSetStorageProfile"},
        "network_profile": {"key": "networkProfile", "type": "VirtualMachineScaleSetNetworkProfile"},
        "diagnostics_profile": {"key": "diagnosticsProfile", "type": "DiagnosticsProfile"},
        "extension_profile": {"key": "extensionProfile", "type": "VirtualMachineScaleSetExtensionProfile"},
        "license_type": {"key": "licenseType", "type": "str"},
        "priority": {"key": "priority", "type": "str"},
        "eviction_policy": {"key": "evictionPolicy", "type": "str"},
    }

    def __init__(
        self,
        *,
        os_profile: Optional["_models.VirtualMachineScaleSetOSProfile"] = None,
        storage_profile: Optional["_models.VirtualMachineScaleSetStorageProfile"] = None,
        network_profile: Optional["_models.VirtualMachineScaleSetNetworkProfile"] = None,
        diagnostics_profile: Optional["_models.DiagnosticsProfile"] = None,
        extension_profile: Optional["_models.VirtualMachineScaleSetExtensionProfile"] = None,
        license_type: Optional[str] = None,
        priority: Optional[Union[str, "_models.VirtualMachinePriorityTypes"]] = None,
        eviction_policy: Optional[Union[str, "_models.VirtualMachineEvictionPolicyTypes"]] = None,
        **kwargs
    ):
        """
        :keyword os_profile: Specifies the operating system settings for the virtual machines in the
         scale set.
        :paramtype os_profile: ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetOSProfile
        :keyword storage_profile: Specifies the storage settings for the virtual machine disks.
        :paramtype storage_profile:
         ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetStorageProfile
        :keyword network_profile: Specifies properties of the network interfaces of the virtual
         machines in the scale set.
        :paramtype network_profile:
         ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetNetworkProfile
        :keyword diagnostics_profile: Specifies the boot diagnostic settings state.
         :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
        :paramtype diagnostics_profile: ~azure.mgmt.compute.v2017_12_01.models.DiagnosticsProfile
        :keyword extension_profile: Specifies a collection of settings for extensions installed on
         virtual machines in the scale set.
        :paramtype extension_profile:
         ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineScaleSetExtensionProfile
        :keyword license_type: Specifies that the image or disk that is being used was licensed
         on-premises. This element is only used for images that contain the Windows Server operating
         system. :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` Windows_Client
         :code:`<br>`:code:`<br>` Windows_Server :code:`<br>`:code:`<br>` If this element is included in
         a request for an update, the value must match the initial value. This value cannot be updated.
         :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_
         :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
        :paramtype license_type: str
        :keyword priority: Specifies the priority for the virtual machines in the scale set.
         :code:`<br>`:code:`<br>`Minimum api-version: 2017-10-30-preview. Known values are: "Regular"
         and "Low".
        :paramtype priority: str or ~azure.mgmt.compute.v2017_12_01.models.VirtualMachinePriorityTypes
        :keyword eviction_policy: Specifies the eviction policy for virtual machines in a low priority
         scale set. :code:`<br>`:code:`<br>`Minimum api-version: 2017-10-30-preview. Known values are:
         "Deallocate" and "Delete".
        :paramtype eviction_policy: str or
         ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineEvictionPolicyTypes
        """
        super().__init__(**kwargs)
        self.os_profile = os_profile
        self.storage_profile = storage_profile
        self.network_profile = network_profile
        self.diagnostics_profile = diagnostics_profile
        self.extension_profile = extension_profile
        self.license_type = license_type
        self.priority = priority
        self.eviction_policy = eviction_policy


class VirtualMachineSize(_serialization.Model):
    """Describes the properties of a VM size.

    :ivar name: The name of the virtual machine size.
    :vartype name: str
    :ivar number_of_cores: The number of cores supported by the virtual machine size.
    :vartype number_of_cores: int
    :ivar os_disk_size_in_mb: The OS disk size, in MB, allowed by the virtual machine size.
    :vartype os_disk_size_in_mb: int
    :ivar resource_disk_size_in_mb: The resource disk size, in MB, allowed by the virtual machine
     size.
    :vartype resource_disk_size_in_mb: int
    :ivar memory_in_mb: The amount of memory, in MB, supported by the virtual machine size.
    :vartype memory_in_mb: int
    :ivar max_data_disk_count: The maximum number of data disks that can be attached to the virtual
     machine size.
    :vartype max_data_disk_count: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "number_of_cores": {"key": "numberOfCores", "type": "int"},
        "os_disk_size_in_mb": {"key": "osDiskSizeInMB", "type": "int"},
        "resource_disk_size_in_mb": {"key": "resourceDiskSizeInMB", "type": "int"},
        "memory_in_mb": {"key": "memoryInMB", "type": "int"},
        "max_data_disk_count": {"key": "maxDataDiskCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        number_of_cores: Optional[int] = None,
        os_disk_size_in_mb: Optional[int] = None,
        resource_disk_size_in_mb: Optional[int] = None,
        memory_in_mb: Optional[int] = None,
        max_data_disk_count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the virtual machine size.
        :paramtype name: str
        :keyword number_of_cores: The number of cores supported by the virtual machine size.
        :paramtype number_of_cores: int
        :keyword os_disk_size_in_mb: The OS disk size, in MB, allowed by the virtual machine size.
        :paramtype os_disk_size_in_mb: int
        :keyword resource_disk_size_in_mb: The resource disk size, in MB, allowed by the virtual
         machine size.
        :paramtype resource_disk_size_in_mb: int
        :keyword memory_in_mb: The amount of memory, in MB, supported by the virtual machine size.
        :paramtype memory_in_mb: int
        :keyword max_data_disk_count: The maximum number of data disks that can be attached to the
         virtual machine size.
        :paramtype max_data_disk_count: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.number_of_cores = number_of_cores
        self.os_disk_size_in_mb = os_disk_size_in_mb
        self.resource_disk_size_in_mb = resource_disk_size_in_mb
        self.memory_in_mb = memory_in_mb
        self.max_data_disk_count = max_data_disk_count


class VirtualMachineSizeListResult(_serialization.Model):
    """The List Virtual Machine operation response.

    :ivar value: The list of virtual machine sizes.
    :vartype value: list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineSize]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineSize]"},
    }

    def __init__(self, *, value: Optional[List["_models.VirtualMachineSize"]] = None, **kwargs):
        """
        :keyword value: The list of virtual machine sizes.
        :paramtype value: list[~azure.mgmt.compute.v2017_12_01.models.VirtualMachineSize]
        """
        super().__init__(**kwargs)
        self.value = value


class VirtualMachineStatusCodeCount(_serialization.Model):
    """The status code and count of the virtual machine scale set instance view status summary.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The instance view status code.
    :vartype code: str
    :ivar count: The number of instances having a particular status code.
    :vartype count: int
    """

    _validation = {
        "code": {"readonly": True},
        "count": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "count": {"key": "count", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.count = None


class VirtualMachineUpdate(UpdateResource):  # pylint: disable=too-many-instance-attributes
    """Describes a Virtual Machine Update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :vartype plan: ~azure.mgmt.compute.v2017_12_01.models.Plan
    :ivar identity: The identity of the virtual machine, if configured.
    :vartype identity: ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineIdentity
    :ivar zones: The virtual machine zones.
    :vartype zones: list[str]
    :ivar hardware_profile: Specifies the hardware settings for the virtual machine.
    :vartype hardware_profile: ~azure.mgmt.compute.v2017_12_01.models.HardwareProfile
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile: ~azure.mgmt.compute.v2017_12_01.models.StorageProfile
    :ivar os_profile: Specifies the operating system settings for the virtual machine.
    :vartype os_profile: ~azure.mgmt.compute.v2017_12_01.models.OSProfile
    :ivar network_profile: Specifies the network interfaces of the virtual machine.
    :vartype network_profile: ~azure.mgmt.compute.v2017_12_01.models.NetworkProfile
    :ivar diagnostics_profile: Specifies the boot diagnostic settings state.
     :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
    :vartype diagnostics_profile: ~azure.mgmt.compute.v2017_12_01.models.DiagnosticsProfile
    :ivar availability_set: Specifies information about the availability set that the virtual
     machine should be assigned to. Virtual machines specified in the same availability set are
     allocated to different nodes to maximize availability. For more information about availability
     sets, see `Manage the availability of virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-manage-availability?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
     :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Planned
     maintenance for virtual machines in Azure
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-planned-maintenance?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_
     :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
     time. An existing VM cannot be added to an availability set.
    :vartype availability_set: ~azure.mgmt.compute.v2017_12_01.models.SubResource
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine instance view.
    :vartype instance_view: ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineInstanceView
    :ivar license_type: Specifies that the image or disk that is being used was licensed
     on-premises. This element is only used for images that contain the Windows Server operating
     system. :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` Windows_Client
     :code:`<br>`:code:`<br>` Windows_Server :code:`<br>`:code:`<br>` If this element is included in
     a request for an update, the value must match the initial value. This value cannot be updated.
     :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :vartype license_type: str
    :ivar vm_id: Specifies the VM unique ID which is a 128-bits identifier that is encoded and
     stored in all Azure IaaS VMs SMBIOS and can be read using platform BIOS commands.
    :vartype vm_id: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "instance_view": {"readonly": True},
        "vm_id": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "plan": {"key": "plan", "type": "Plan"},
        "identity": {"key": "identity", "type": "VirtualMachineIdentity"},
        "zones": {"key": "zones", "type": "[str]"},
        "hardware_profile": {"key": "properties.hardwareProfile", "type": "HardwareProfile"},
        "storage_profile": {"key": "properties.storageProfile", "type": "StorageProfile"},
        "os_profile": {"key": "properties.osProfile", "type": "OSProfile"},
        "network_profile": {"key": "properties.networkProfile", "type": "NetworkProfile"},
        "diagnostics_profile": {"key": "properties.diagnosticsProfile", "type": "DiagnosticsProfile"},
        "availability_set": {"key": "properties.availabilitySet", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "VirtualMachineInstanceView"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
        "vm_id": {"key": "properties.vmId", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["_models.Plan"] = None,
        identity: Optional["_models.VirtualMachineIdentity"] = None,
        zones: Optional[List[str]] = None,
        hardware_profile: Optional["_models.HardwareProfile"] = None,
        storage_profile: Optional["_models.StorageProfile"] = None,
        os_profile: Optional["_models.OSProfile"] = None,
        network_profile: Optional["_models.NetworkProfile"] = None,
        diagnostics_profile: Optional["_models.DiagnosticsProfile"] = None,
        availability_set: Optional["_models.SubResource"] = None,
        license_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword plan: Specifies information about the marketplace image used to create the virtual
         machine. This element is only used for marketplace images. Before you can use a marketplace
         image from an API, you must enable the image for programmatic use.  In the Azure portal, find
         the marketplace image that you want to use and then click **Want to deploy programmatically,
         Get Started ->**. Enter any required information and then click **Save**.
        :paramtype plan: ~azure.mgmt.compute.v2017_12_01.models.Plan
        :keyword identity: The identity of the virtual machine, if configured.
        :paramtype identity: ~azure.mgmt.compute.v2017_12_01.models.VirtualMachineIdentity
        :keyword zones: The virtual machine zones.
        :paramtype zones: list[str]
        :keyword hardware_profile: Specifies the hardware settings for the virtual machine.
        :paramtype hardware_profile: ~azure.mgmt.compute.v2017_12_01.models.HardwareProfile
        :keyword storage_profile: Specifies the storage settings for the virtual machine disks.
        :paramtype storage_profile: ~azure.mgmt.compute.v2017_12_01.models.StorageProfile
        :keyword os_profile: Specifies the operating system settings for the virtual machine.
        :paramtype os_profile: ~azure.mgmt.compute.v2017_12_01.models.OSProfile
        :keyword network_profile: Specifies the network interfaces of the virtual machine.
        :paramtype network_profile: ~azure.mgmt.compute.v2017_12_01.models.NetworkProfile
        :keyword diagnostics_profile: Specifies the boot diagnostic settings state.
         :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
        :paramtype diagnostics_profile: ~azure.mgmt.compute.v2017_12_01.models.DiagnosticsProfile
        :keyword availability_set: Specifies information about the availability set that the virtual
         machine should be assigned to. Virtual machines specified in the same availability set are
         allocated to different nodes to maximize availability. For more information about availability
         sets, see `Manage the availability of virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-manage-availability?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
         :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Planned
         maintenance for virtual machines in Azure
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-planned-maintenance?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_
         :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
         time. An existing VM cannot be added to an availability set.
        :paramtype availability_set: ~azure.mgmt.compute.v2017_12_01.models.SubResource
        :keyword license_type: Specifies that the image or disk that is being used was licensed
         on-premises. This element is only used for images that contain the Windows Server operating
         system. :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` Windows_Client
         :code:`<br>`:code:`<br>` Windows_Server :code:`<br>`:code:`<br>` If this element is included in
         a request for an update, the value must match the initial value. This value cannot be updated.
         :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_
         :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
        :paramtype license_type: str
        """
        super().__init__(tags=tags, **kwargs)
        self.plan = plan
        self.identity = identity
        self.zones = zones
        self.hardware_profile = hardware_profile
        self.storage_profile = storage_profile
        self.os_profile = os_profile
        self.network_profile = network_profile
        self.diagnostics_profile = diagnostics_profile
        self.availability_set = availability_set
        self.provisioning_state = None
        self.instance_view = None
        self.license_type = license_type
        self.vm_id = None


class WindowsConfiguration(_serialization.Model):
    """Specifies Windows operating system settings on the virtual machine.

    :ivar provision_vm_agent: Indicates whether virtual machine agent should be provisioned on the
     virtual machine. :code:`<br>`:code:`<br>` When this property is not specified in the request
     body, default behavior is to set it to true.  This will ensure that VM Agent is installed on
     the VM so that extensions can be added to the VM later.
    :vartype provision_vm_agent: bool
    :ivar enable_automatic_updates: Indicates whether virtual machine is enabled for automatic
     updates.
    :vartype enable_automatic_updates: bool
    :ivar time_zone: Specifies the time zone of the virtual machine. e.g. "Pacific Standard Time".
    :vartype time_zone: str
    :ivar additional_unattend_content: Specifies additional base-64 encoded XML formatted
     information that can be included in the Unattend.xml file, which is used by Windows Setup.
    :vartype additional_unattend_content:
     list[~azure.mgmt.compute.v2017_12_01.models.AdditionalUnattendContent]
    :ivar win_rm: Specifies the Windows Remote Management listeners. This enables remote Windows
     PowerShell.
    :vartype win_rm: ~azure.mgmt.compute.v2017_12_01.models.WinRMConfiguration
    """

    _attribute_map = {
        "provision_vm_agent": {"key": "provisionVMAgent", "type": "bool"},
        "enable_automatic_updates": {"key": "enableAutomaticUpdates", "type": "bool"},
        "time_zone": {"key": "timeZone", "type": "str"},
        "additional_unattend_content": {"key": "additionalUnattendContent", "type": "[AdditionalUnattendContent]"},
        "win_rm": {"key": "winRM", "type": "WinRMConfiguration"},
    }

    def __init__(
        self,
        *,
        provision_vm_agent: Optional[bool] = None,
        enable_automatic_updates: Optional[bool] = None,
        time_zone: Optional[str] = None,
        additional_unattend_content: Optional[List["_models.AdditionalUnattendContent"]] = None,
        win_rm: Optional["_models.WinRMConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword provision_vm_agent: Indicates whether virtual machine agent should be provisioned on
         the virtual machine. :code:`<br>`:code:`<br>` When this property is not specified in the
         request body, default behavior is to set it to true.  This will ensure that VM Agent is
         installed on the VM so that extensions can be added to the VM later.
        :paramtype provision_vm_agent: bool
        :keyword enable_automatic_updates: Indicates whether virtual machine is enabled for automatic
         updates.
        :paramtype enable_automatic_updates: bool
        :keyword time_zone: Specifies the time zone of the virtual machine. e.g. "Pacific Standard
         Time".
        :paramtype time_zone: str
        :keyword additional_unattend_content: Specifies additional base-64 encoded XML formatted
         information that can be included in the Unattend.xml file, which is used by Windows Setup.
        :paramtype additional_unattend_content:
         list[~azure.mgmt.compute.v2017_12_01.models.AdditionalUnattendContent]
        :keyword win_rm: Specifies the Windows Remote Management listeners. This enables remote Windows
         PowerShell.
        :paramtype win_rm: ~azure.mgmt.compute.v2017_12_01.models.WinRMConfiguration
        """
        super().__init__(**kwargs)
        self.provision_vm_agent = provision_vm_agent
        self.enable_automatic_updates = enable_automatic_updates
        self.time_zone = time_zone
        self.additional_unattend_content = additional_unattend_content
        self.win_rm = win_rm


class WinRMConfiguration(_serialization.Model):
    """Describes Windows Remote Management configuration of the VM.

    :ivar listeners: The list of Windows Remote Management listeners.
    :vartype listeners: list[~azure.mgmt.compute.v2017_12_01.models.WinRMListener]
    """

    _attribute_map = {
        "listeners": {"key": "listeners", "type": "[WinRMListener]"},
    }

    def __init__(self, *, listeners: Optional[List["_models.WinRMListener"]] = None, **kwargs):
        """
        :keyword listeners: The list of Windows Remote Management listeners.
        :paramtype listeners: list[~azure.mgmt.compute.v2017_12_01.models.WinRMListener]
        """
        super().__init__(**kwargs)
        self.listeners = listeners


class WinRMListener(_serialization.Model):
    """Describes Protocol and thumbprint of Windows Remote Management listener.

    :ivar protocol: Specifies the protocol of listener. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`\ **http** :code:`<br>`:code:`<br>` **https**. Known values are: "Http" and
     "Https".
    :vartype protocol: str or ~azure.mgmt.compute.v2017_12_01.models.ProtocolTypes
    :ivar certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as
     a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key vault
     <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
     certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded
     in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`
     "data":":code:`<Base64-encoded-certificate>`",:code:`<br>`  "dataType":"pfx",:code:`<br>`
     "password":":code:`<pfx-file-password>`":code:`<br>`}.
    :vartype certificate_url: str
    """

    _attribute_map = {
        "protocol": {"key": "protocol", "type": "str"},
        "certificate_url": {"key": "certificateUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        protocol: Optional[Union[str, "_models.ProtocolTypes"]] = None,
        certificate_url: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword protocol: Specifies the protocol of listener. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`\ **http** :code:`<br>`:code:`<br>` **https**. Known values are: "Http" and
         "Https".
        :paramtype protocol: str or ~azure.mgmt.compute.v2017_12_01.models.ProtocolTypes
        :keyword certificate_url: This is the URL of a certificate that has been uploaded to Key Vault
         as a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key vault
         <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
         certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded
         in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`
         "data":":code:`<Base64-encoded-certificate>`",:code:`<br>`  "dataType":"pfx",:code:`<br>`
         "password":":code:`<pfx-file-password>`":code:`<br>`}.
        :paramtype certificate_url: str
        """
        super().__init__(**kwargs)
        self.protocol = protocol
        self.certificate_url = certificate_url
