# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TrainRequest(Model):
    """Contract to initiate a train request.

    All required parameters must be populated in order to send to Azure.

    :param source: Required. Get or set source path.
    :type source: str
    """

    _validation = {
        'source': {'required': True, 'max_length': 2048, 'min_length': 0},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'str'},
    }

    def __init__(self, *, source: str, **kwargs) -> None:
        super(TrainRequest, self).__init__(**kwargs)
        self.source = source
