/*
 * Copyright 2019-present MongoDB, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


#include "../mongocrypt-os-private.h"

#ifndef _WIN32

#include <pthread.h>

static pthread_once_t once_control = PTHREAD_ONCE_INIT;

int
_mongocrypt_once (void (*init_routine) (void))
{
   return (pthread_once (&once_control, init_routine));
}

#endif /* _WIN32 */