# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.partitioned_data_set_collection_algorithm import PartitionedDataSetCollectionAlgorithm


class CONVERGECFDReader(PartitionedDataSetCollectionAlgorithm):
    r"""
    CONVERGECFDReader - Reader for CONVERGE CFD post files.
    
    Superclass: PartitionedDataSetCollectionAlgorithm
    
    This class reads CONVERGE CFD post files containing meshes, surfaces,
    and parcels. Each stream in a file is read as a top-level block and
    meshes, surfaces, and parcels are datasets under each stream block.
    
    Cell data arrays associated with mesh cells can be individually
    selected for reading using the cell_array_status API.
    
    Point data arrays associated with parcels can be individually
    selected for reading using the parcel_array_status API.
    
    Time series are supported. The reader assumes a time series is
    defined in a sequence of files that follow the naming convention
    
    <prefix><zero-padded index>[_][].h5
    
    where the prefix is determined from the file_name property passed to
    the reader. The underscore and time elements are optional. The time
    value associated with each file is read from metadata in the file.
    
    Parallel data loading is not supported.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCONVERGECFDReader, obj, update, **traits)
    
    file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        Specify file name of the Exodus file.
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    def _get_cell_data_array_selection(self):
        return wrap_vtk(self._vtk_obj.GetCellDataArraySelection())
    cell_data_array_selection = traits.Property(_get_cell_data_array_selection, desc=\
        r"""
        Access the cell data array selection to specify which cell data
        arrays should be read. Only the specified cell data arrays will
        be read from the file.
        """
    )

    def _get_parcel_data_array_selection(self):
        return wrap_vtk(self._vtk_obj.GetParcelDataArraySelection())
    parcel_data_array_selection = traits.Property(_get_parcel_data_array_selection, desc=\
        r"""
        Access the parcel data array selection to specify which point
        data arrays should be read and associated parcel. Only the
        specified parcel data arrays will be read from the file.
        """
    )

    def can_read_file(self, *args):
        """
        can_read_file(self, fname:str) -> int
        C++: virtual int can_read_file(const char *fname)
        Determine if the file can be read with this reader.
        """
        ret = self._wrap_call(self._vtk_obj.CanReadFile, *args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('file_name',
    'GetFileName'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'file_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CONVERGECFDReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CONVERGECFDReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['file_name']),
            title='Edit CONVERGECFDReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CONVERGECFDReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

