# Ask that uname -s be performed and store the value in SYSTEM_UNAME_S for
# later reference.

macro(get_uname_string)

execute_process(COMMAND uname -s OUTPUT_VARIABLE SYSTEM_UNAME_S)

if(${SYSTEM_UNAME_S} MATCHES "MSYS_NT-10.0-*")
    message(STATUS "System detected as Windows10 with UCRT64, setting WIN32 AND WIN10UCRT64")
	# Note that WIN32 is set even on 64 bits systems.
	set(WIN32 1)
	# This setting is only for CMake consumption
	set(WIN10UCRT64 1)
	# This definition is to be able to test #ifdef WIN10UCRT64 in source code files
	add_definitions(-DWIN10UCRT64)
#else()
	#message(STATUS "System is not Windows.")
endif()

endmacro()

get_uname_string()

