/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper;

import com.google.caliper.Environment;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multimap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class EnvironmentGetter {
    public Environment getEnvironmentSnapshot() {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        Properties sysProps = System.getProperties();
        String version = (String)sysProps.get("java.version");
        String alternateVersion = (String)sysProps.get("java.runtime.version");
        if (alternateVersion != null && alternateVersion.length() > version.length()) {
            version = alternateVersion;
        }
        propertyMap.put("jre.version", version);
        propertyMap.put("jre.vmname", (String)sysProps.get("java.vm.name"));
        propertyMap.put("jre.vmversion", (String)sysProps.get("java.vm.version"));
        propertyMap.put("jre.availableProcessors", Integer.toString(Runtime.getRuntime().availableProcessors()));
        String osName = (String)sysProps.get("os.name");
        propertyMap.put("os.name", osName);
        propertyMap.put("os.version", (String)sysProps.get("os.version"));
        propertyMap.put("os.arch", (String)sysProps.get("os.arch"));
        try {
            propertyMap.put("host.name", InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException ignored) {
            // empty catch block
        }
        if (osName.equals("Linux")) {
            this.getLinuxEnvironment(propertyMap);
        }
        return new Environment(propertyMap);
    }

    private void getLinuxEnvironment(Map<String, String> propertyMap) {
        Multimap<String, String> cpuInfo = EnvironmentGetter.propertiesFromLinuxFile("/proc/cpuinfo");
        propertyMap.put("host.cpus", Integer.toString(cpuInfo.get((Object)"processor").size()));
        String s = "cpu cores";
        propertyMap.put("host.cpu.cores", EnvironmentGetter.describe(cpuInfo, s));
        propertyMap.put("host.cpu.names", EnvironmentGetter.describe(cpuInfo, "model name"));
        propertyMap.put("host.cpu.cachesize", EnvironmentGetter.describe(cpuInfo, "cache size"));
        Multimap<String, String> memInfo = EnvironmentGetter.propertiesFromLinuxFile("/proc/meminfo");
        propertyMap.put("host.memory.physical", memInfo.get((Object)"MemTotal").toString());
        propertyMap.put("host.memory.swap", memInfo.get((Object)"SwapTotal").toString());
        this.getAndroidEnvironment(propertyMap);
    }

    private void getAndroidEnvironment(Map<String, String> propertyMap) {
        try {
            Map<String, String> map = EnvironmentGetter.getAndroidProperties();
            String manufacturer = map.get("ro.product.manufacturer");
            String device = map.get("ro.product.device");
            propertyMap.put("android.device", manufacturer + " " + device);
            String brand = map.get("ro.product.brand");
            String model = map.get("ro.product.model");
            propertyMap.put("android.model", brand + " " + model);
            String release = map.get("ro.build.version.release");
            String id = map.get("ro.build.id");
            propertyMap.put("android.release", release + " " + id);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String describe(Multimap<String, String> cpuInfo, String s) {
        Collection strings = cpuInfo.get((Object)s);
        return strings.size() == 1 ? (String)strings.iterator().next() : ImmutableMultiset.copyOf((Iterable)strings).toString();
    }

    private static Multimap<String, String> propertiesFileToMultimap(Reader reader) throws IOException {
        String line;
        ImmutableMultimap.Builder result = ImmutableMultimap.builder();
        BufferedReader in = new BufferedReader(reader);
        while ((line = in.readLine()) != null) {
            String[] parts = line.split("\\s*\\:\\s*", 2);
            if (parts.length != 2) continue;
            result.put((Object)parts[0], (Object)parts[1]);
        }
        in.close();
        return result.build();
    }

    private static Multimap<String, String> propertiesFromLinuxFile(String file) {
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"/bin/cat", file});
            return EnvironmentGetter.propertiesFileToMultimap(new InputStreamReader(process.getInputStream(), "ISO-8859-1"));
        }
        catch (IOException e) {
            return ImmutableMultimap.of();
        }
    }

    public static void main(String[] args) {
        Environment snapshot = new EnvironmentGetter().getEnvironmentSnapshot();
        for (Map.Entry<String, String> entry : snapshot.getProperties().entrySet()) {
            System.out.println(entry.getKey() + " " + entry.getValue());
        }
    }

    private static Map<String, String> getAndroidProperties() throws IOException {
        String line;
        HashMap<String, String> result = new HashMap<String, String>();
        Process process = Runtime.getRuntime().exec(new String[]{"/system/bin/getprop"});
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), "ISO-8859-1"));
        Pattern pattern = Pattern.compile("\\[([^\\]]*)\\]: \\[([^\\]]*)\\]");
        while ((line = reader.readLine()) != null) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) continue;
            result.put(matcher.group(1), matcher.group(2));
        }
        return result;
    }
}

