#include "opt_rr.h"

namespace ADNS {
	
	OPT_RR::OPT_RR()
	{
		array<Byte>^ b = gcnew array<Byte>(1);
		b[0] = 0;
		dname = gcnew DOMAIN_NAME(b);
		rr_type = RR_TYPE::OPT;
		payload_size = 512;
		ext_rcode = gcnew array<Byte>(4);
		ext_rcode->Clear(ext_rcode,0,4);
		option_codes = gcnew List<UInt16>(0);
		option_data = gcnew List<array<Byte>^>(0);

	}
	
	Void OPT_RR::SetDnssecOk(bool b)
	{
		if (b)
			ext_rcode[2] = ext_rcode[2] | 0x80;
		else
			ext_rcode[2] = ext_rcode[2] & 0x7F;

		return;
	}

	bool OPT_RR::GetDnssecOk()
	{
		if (ext_rcode[0] & 0x80)
			return true;

		return false;
	}


	Byte OPT_RR::GetExtendedRcode()
	{
		return ext_rcode[0];
	}

	Void OPT_RR::SetExtendedRcode(Byte c)
	{
		ext_rcode[0] = c;
		return;
	}

	Byte OPT_RR::GetVersion()
	{
		return ext_rcode[1];
	}

	Void OPT_RR::SetVersion(Byte c)
	{
		ext_rcode[1] = c;
		return;
	}


	UInt16 OPT_RR::GetPayloadSize()
	{
		return payload_size;
	}

	Void OPT_RR::SetPayloadSize(UInt16 ps)
	{
		payload_size = ps;
		return;
	}

	array<Byte>^ OPT_RR::GetOptionData(UInt16 optcode)
	{
		int pos;
		array<Byte>^ output;

		pos = option_codes->IndexOf(optcode);
		if (pos == -1)
			return nullptr;

		output = gcnew array<Byte>(option_data[pos]->Length);
		option_data[pos]->CopyTo(output,0);

		return output;

	}

	array<UInt16>^ OPT_RR::GetOptions()
	{
		return option_codes->ToArray();
	}
	
	bool OPT_RR::SetOption(UInt16 ocode, array<Byte>^ odata)
	{
		array<Byte>^ tmp;

		if (option_codes->IndexOf(ocode) != -1)
			return false;

		option_codes->Add(ocode);
		tmp = gcnew array<Byte>(odata->Length);
		odata->CopyTo(tmp,0);
		option_data->Add(tmp);
		UpdateRdata();

		return true;
	}

	bool OPT_RR::RemoveOption(UInt16 ocode)
	{
		int pos = 0;
		pos = option_codes->IndexOf(ocode);

		if (pos == -1)
			return false;

		option_codes->RemoveAt(pos);
		option_data->RemoveAt(pos);
		UpdateRdata();

		return true;
	}

	array<Byte>^ OPT_RR::ToWire()
	{
		array<Byte>^ output;
		int rdlength = 0;

		if (rdata)
			rdlength = rdata->Length;

		output = gcnew array<Byte>(rdlength + dname->Size() + 10);
		dname->GetName()->CopyTo(output,0);
		BitConverter::GetBytes(IPAddress::HostToNetworkOrder((short int) rr_type))->CopyTo(output,dname->Size());
		BitConverter::GetBytes(IPAddress::HostToNetworkOrder((short int) payload_size))->CopyTo(output,dname->Size() + 2);
		output[dname->Size() + 4] = ext_rcode[0];
		output[dname->Size() + 5] = ext_rcode[1];
		output[dname->Size() + 6] = ext_rcode[2];
		output[dname->Size() + 7] = ext_rcode[3];
		BitConverter::GetBytes(IPAddress::HostToNetworkOrder((short int) rdlength))->CopyTo(output,dname->Size() + 8);
		if (rdata)
			rdata->CopyTo(output,dname->Size() + 10);

		return output;
	}


	Void OPT_RR::UpdateRdata()
	{
		int total_size = 0;
		int i = 0;
		int pos = 0;

		for (i = 0; i < option_data->Count; ++i)
		{
			total_size += option_data[i]->Length + 2; //+4 for the option code and the option length
		}

		if (!rdata)
			rdata = gcnew array<Byte>(total_size);
		else
			rdata->Resize(rdata,total_size);

		for (i = 0; i < option_data->Count; ++i)
		{
			BitConverter::GetBytes(IPAddress::HostToNetworkOrder((short int) option_codes[i]))->CopyTo(rdata,pos);
			pos += 2;
			BitConverter::GetBytes(IPAddress::HostToNetworkOrder((short int) option_data[i]->Length))->CopyTo(rdata,pos);
			pos += 2;
			option_data[i]->CopyTo(rdata,pos);
			pos += option_data[i]->Length;
		}

		return;
	}

	String^ OPT_RR::Print()
	{
		String^ output = gcnew String("");
		int i = 0;

		output += ". ";
		output += " " + Enum::GetName(RR_TYPE::typeid,rr_type);
		output += " " + Convert::ToString(payload_size);
		output += " ";
		for (i = 0; i < 4; ++i)
			output += Convert::ToString(ext_rcode[i]);
		for (i = 0; i < option_data->Count; ++i)
		{
			output += " (" + Convert::ToString(option_codes[i])+ ")";
		}

		return output;
	}

	OPT_RR^ OPT_RR::Clone()
	{
		int i = 0;
		OPT_RR^ newrr = gcnew OPT_RR();
		newrr->rr_type = rr_type;
		newrr->owner = owner->Clone();
		newrr->ttl = ttl;
		newrr->rr_class = rr_class;
		newrr->dname = dname->Clone();
		newrr->payload_size = payload_size;
		newrr->ext_rcode = gcnew array<Byte>(ext_rcode->Length);
		ext_rcode->CopyTo(newrr->ext_rcode,0);
		newrr->option_codes = gcnew List<UInt16>(0);
		for (i = 0; i < option_codes->Count; ++i)
			newrr->option_codes->Add(option_codes[i]);
		newrr->option_data = gcnew List<array<Byte>^>(0);
		for (i = 0; i < option_data->Count; ++i)
		{
			array<Byte>^ tmp = gcnew array<Byte>(option_data[i]->Length);
			option_data[i]->CopyTo(tmp,0);
			newrr->option_data->Add(tmp);
		}
		newrr->UpdateRdata();
		return newrr;
	}
	
	ResourceRecord^ OPT_RR::ParseResourceRecord(array<Byte>^ domainname, UInt16 rr_type, UInt16 rr_class, UInt32 ttl, UInt16 rdata_len, array<Byte>^ packet, int rdata_start)
	{
		OPT_RR^ optout;
		array<Byte>^ tmparray;
		int pos;
		int len;
		UInt16 optcode;

		optout = gcnew OPT_RR();
		optout->SetPayloadSize(rr_class);
		tmparray = BitConverter::GetBytes(IPAddress::HostToNetworkOrder((int) ttl));
		optout->SetExtendedRcode(tmparray[0]);
		optout->SetVersion(tmparray[1]);
		if (tmparray[3] & 0x80)
			optout->SetDnssecOk(true);
		pos = rdata_start;
		while (pos < rdata_start + rdata_len)
		{
			optcode = IPAddress::NetworkToHostOrder((short int)BitConverter::ToUInt16(packet,pos));
			pos += 2;
			len = IPAddress::NetworkToHostOrder((short int)BitConverter::ToUInt16(packet,pos));
			pos += 2;
			tmparray->Resize(tmparray,len);
			packet->Copy(packet,pos,tmparray,0,len);
			optout->SetOption(optcode,tmparray);
			pos += len;
		}
		return optout;
	}

	String^ OPT_RR::PrintRR(ResourceRecord^ rec)
	{
		return safe_cast<OPT_RR^>(rec)->Print();
	}

	ResourceRecord^ OPT_RR::CloneRR(ResourceRecord^ rec)
	{
		return safe_cast<OPT_RR^>(rec)->Clone();
	}
}