// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file bitsetsCdrAux.ipp
 * This source file contains some declarations of CDR related functions.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__BITSETSCDRAUX_IPP
#define FAST_DDS_GENERATED__BITSETSCDRAUX_IPP

#include "bitsetsCdrAux.hpp"

#include <fastcdr/Cdr.h>
#include <fastcdr/CdrSizeCalculator.hpp>


#include <fastcdr/exceptions/BadParamException.h>
using namespace eprosima::fastcdr::exception;

namespace eprosima {
namespace fastcdr {

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const InnerTypedBitsetHelper&,
        size_t& current_alignment)
{
    return calculator.calculate_serialized_size(std::bitset<57>{}, current_alignment);
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const InnerTypedBitsetHelper& data)
{
    std::bitset<57> bitset;

        bitset <<= 16;
        bitset |= (data.ushort_bitfield & 0xFFFF);

        bitset <<= 16;
        bitset |= (data.short_bitfield & 0xFFFF);

        bitset <<= 8;
        bitset |= (data.uint8_bitfield & 0xFF);

        bitset <<= 8;
        bitset |= (data.int8_bitfield & 0xFF);

        bitset <<= 8;
        bitset |= (data.byte_bitfield & 0xFF);

        bitset <<= 1;
        bitset |= (data.boolean_bitfield & 0x1);


    scdr << bitset;
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& dcdr,
        InnerTypedBitsetHelper& data)
{
    std::bitset<57> bitset;
    dcdr >> bitset;

        data.boolean_bitfield = static_cast<bool>(bitset.to_ullong() & 0x1);
        bitset >>= 1;

        data.byte_bitfield = static_cast<uint8_t>(bitset.to_ullong() & 0xFF);
        bitset >>= 8;

        data.int8_bitfield = static_cast<int8_t>(bitset.to_ullong() & 0xFF);
        bitset >>= 8;

        data.uint8_bitfield = static_cast<uint8_t>(bitset.to_ullong() & 0xFF);
        bitset >>= 8;

        data.short_bitfield = static_cast<int16_t>(bitset.to_ullong() & 0xFFFF);
        bitset >>= 16;

        data.ushort_bitfield = static_cast<uint16_t>(bitset.to_ullong() & 0xFFFF);
        bitset >>= 16;

}

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const InnerTypedBitsetHelper2&,
        size_t& current_alignment)
{
    return calculator.calculate_serialized_size(std::bitset<64>{}, current_alignment);
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const InnerTypedBitsetHelper2& data)
{
    std::bitset<64> bitset;

        bitset <<= 32;
        bitset |= (data.ulong_bitfield & 0xFFFFFFFF);

        bitset <<= 32;
        bitset |= (data.long_bitfield & 0xFFFFFFFF);


    scdr << bitset;
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& dcdr,
        InnerTypedBitsetHelper2& data)
{
    std::bitset<64> bitset;
    dcdr >> bitset;

        data.long_bitfield = static_cast<int32_t>(bitset.to_ullong() & 0xFFFFFFFF);
        bitset >>= 32;

        data.ulong_bitfield = static_cast<uint32_t>(bitset.to_ullong() & 0xFFFFFFFF);
        bitset >>= 32;

}

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const InnerTypedBitsetHelper3&,
        size_t& current_alignment)
{
    return calculator.calculate_serialized_size(std::bitset<64>{}, current_alignment);
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const InnerTypedBitsetHelper3& data)
{
    std::bitset<64> bitset;

        bitset <<= 64;
        bitset |= (data.long_long_bitfield & 0xFFFFFFFFFFFFFFFF);


    scdr << bitset;
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& dcdr,
        InnerTypedBitsetHelper3& data)
{
    std::bitset<64> bitset;
    dcdr >> bitset;

        data.long_long_bitfield = static_cast<int64_t>(bitset.to_ullong() & 0xFFFFFFFFFFFFFFFF);
        bitset >>= 64;

}

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const InnerTypedBitsetHelper4&,
        size_t& current_alignment)
{
    return calculator.calculate_serialized_size(std::bitset<64>{}, current_alignment);
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const InnerTypedBitsetHelper4& data)
{
    std::bitset<64> bitset;

        bitset <<= 64;
        bitset |= (data.ulong_long_bitfield & 0xFFFFFFFFFFFFFFFF);


    scdr << bitset;
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& dcdr,
        InnerTypedBitsetHelper4& data)
{
    std::bitset<64> bitset;
    dcdr >> bitset;

        data.ulong_long_bitfield = static_cast<uint64_t>(bitset.to_ullong() & 0xFFFFFFFFFFFFFFFF);
        bitset >>= 64;

}

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const BitsetStruct& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.var_InnerBitsetHelper(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.var_InnerTypedBitsetHelper(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.var_InnerTypedBitsetHelper2(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                data.var_InnerTypedBitsetHelper3(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(4),
                data.var_InnerTypedBitsetHelper4(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const BitsetStruct& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.var_InnerBitsetHelper()
        << eprosima::fastcdr::MemberId(1) << data.var_InnerTypedBitsetHelper()
        << eprosima::fastcdr::MemberId(2) << data.var_InnerTypedBitsetHelper2()
        << eprosima::fastcdr::MemberId(3) << data.var_InnerTypedBitsetHelper3()
        << eprosima::fastcdr::MemberId(4) << data.var_InnerTypedBitsetHelper4()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        BitsetStruct& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.var_InnerBitsetHelper();
                                            break;

                                        case 1:
                                                dcdr >> data.var_InnerTypedBitsetHelper();
                                            break;

                                        case 2:
                                                dcdr >> data.var_InnerTypedBitsetHelper2();
                                            break;

                                        case 3:
                                                dcdr >> data.var_InnerTypedBitsetHelper3();
                                            break;

                                        case 4:
                                                dcdr >> data.var_InnerTypedBitsetHelper4();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const BitsetStruct& data)
{

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.var_InnerBitsetHelper();

                        scdr << data.var_InnerTypedBitsetHelper();

                        scdr << data.var_InnerTypedBitsetHelper2();

                        scdr << data.var_InnerTypedBitsetHelper3();

                        scdr << data.var_InnerTypedBitsetHelper4();

}



} // namespace fastcdr
} // namespace eprosima

#endif // FAST_DDS_GENERATED__BITSETSCDRAUX_IPP

