#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/wait.h>
#include <string.h>

int main(int argc, char **argv)
{
  if(argc != 2)
  {
    fprintf(stderr, "ERROR: Must specify device for smartctl\n");
    return 1;
  }
  if(strncmp(argv[1], "/dev/sd", 7))
  {
    fprintf(stderr, "ERROR: First parameter must specify a /dev/sd device\n");
    return 1;
  }
  if(argv[1][7] < 'a' || argv[1][7] > 'z' || (argv[1][8] && (argv[1][8] < 'a' || argv[1][8] > 'z' || argv[1][9])))
  {
    fprintf(stderr, "ERROR: Device didn't match /dev/sd[a-z] or /dev/sd[a-z][a-z]\n");
    return 1;
  }
  char * const child_args[] = { "/usr/sbin/smartctl", "-H", argv[1], NULL };
  execv(child_args[0], child_args);
  fprintf(stderr, "ERROR: Can't execute %s\n", child_args[0]);
  return 1;
}

