## Description
[Please provide a general introduction to the issue/proposal.]

[If reporting a bug, attach the entire traceback from Python and follow the way to reproduce below]
[If proposing an enhancement/new feature, provide links to related articles, reference examples, etc.]


## Way to reproduce
[If reporting a bug, please include the following important information:]
- [ ] Code example
- [ ] Relevant images (if any)
- [ ] Operating system and version (run `python -c "import platform; print(platform.platform())"`)
- [ ] Python version (run `python -c "import sys; print("Python", sys.version)"`)
- [ ] dipy version (run `python -c "import dipy; print(dipy.__version__)"`)
- [ ] dependency version (numpy, scipy, nibabel, h5py, cvxpy, fury)
    * import numpy; print("NumPy", numpy.__version__)
    * import scipy; print("SciPy", scipy.__version__)
    * import nibabel; print("Nibabel", nibabel.__version__)
    * import h5py; print("H5py", h5py.__version__)
    * import cvxpy; print("Cvxpy", cvxpy.__version__)
    * import fury; print("fury", fury.__version__)
