/*-
 * Copyright (c) 1998-2005 Joao Cabral
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *      DHIS(c)  Dynamic Host Information System Release 5
 */

/* Command strings to send to external process */

#define	SADD	"add"
#define	SDELETE	"delete"
#define	SUPDATE	"update"
#define	SRELOAD	"reload"
#define	SEXIT	"exit"


struct service_fds_s {
		   int fd;
		   int pid;
		   struct service_fds_s *next;
};

struct service_s {
		   unsigned char service[128];
		   unsigned char command[256];
		   int nprocs;
		   struct service_fds_s *rrfdp;
		   struct service_fds_s *fdp;
		   struct service_s *next;
};

void mark_online(int,int);
void mark_update(int,int,int);
void mark_offline(int,int);
int read_services(unsigned char *);
int init_services(void);
void sigchld();
struct service_s *service_get_by_name(unsigned char *);
void service_issue_command(unsigned char *,int,unsigned char *,unsigned char *);
void fork_cmd(unsigned char *,int,unsigned char *);
void service_free(void);
void service_send_term(void);
void service_send_reload(void);
