# Generated by Django 4.2.23 on 2026-02-19 19:13

from django.db import migrations, models

import debusine.assets.models
import debusine.db.constraints


class Migration(migrations.Migration):
    dependencies = [
        ('db', '0042_add_scheduler_tags_for_tasks'),
    ]

    operations = [
        migrations.RemoveConstraint(
            model_name='asset',
            name='db_asset_workspace_not_null',
        ),
        migrations.AlterField(
            model_name='asset',
            name='category',
            field=models.CharField(
                choices=[
                    (
                        debusine.assets.models.AssetCategory[
                            'CLOUD_PROVIDER_ACCOUNT'
                        ],
                        debusine.assets.models.AssetCategory[
                            'CLOUD_PROVIDER_ACCOUNT'
                        ],
                    ),
                    (
                        debusine.assets.models.AssetCategory['SIGNING_KEY'],
                        debusine.assets.models.AssetCategory['SIGNING_KEY'],
                    ),
                    (
                        debusine.assets.models.AssetCategory[
                            'APT_AUTHENTICATION'
                        ],
                        debusine.assets.models.AssetCategory[
                            'APT_AUTHENTICATION'
                        ],
                    ),
                ],
                max_length=255,
            ),
        ),
        migrations.AlterField(
            model_name='assetusagerole',
            name='role',
            field=models.CharField(
                choices=[
                    ('signer', 'Signer'),
                    ('repository_signer', 'Repository signer'),
                    ('apt_authenticator', 'Can use APT authentication'),
                ],
                max_length=32,
            ),
        ),
        migrations.AddConstraint(
            model_name='asset',
            constraint=models.CheckConstraint(
                check=models.Q(
                    models.Q(
                        (
                            'category',
                            debusine.assets.models.AssetCategory[
                                'APT_AUTHENTICATION'
                            ],
                        ),
                        _negated=True,
                    ),
                    ('data__name__regex', '^[A-Za-z][A-Za-z0-9+._-]*$'),
                    _connector='OR',
                ),
                name='db_asset_apt_auth_name',
            ),
        ),
        migrations.AddConstraint(
            model_name='asset',
            constraint=debusine.db.constraints.JsonDataUniqueConstraint(
                condition=models.Q(
                    (
                        'category',
                        debusine.assets.models.AssetCategory[
                            'APT_AUTHENTICATION'
                        ],
                    )
                ),
                fields=('workspace', "data->>'name'"),
                name='db_asset_unique_apt_auth_workspace_name',
                nulls_distinct=False,
            ),
        ),
        migrations.AddConstraint(
            model_name='asset',
            constraint=models.CheckConstraint(
                check=models.Q(
                    models.Q(
                        (
                            'category__in',
                            {
                                debusine.assets.models.AssetCategory[
                                    'APT_AUTHENTICATION'
                                ],
                                debusine.assets.models.AssetCategory[
                                    'SIGNING_KEY'
                                ],
                            },
                        ),
                        _negated=True,
                    ),
                    ('workspace__isnull', False),
                    _connector='OR',
                ),
                name='db_asset_workspace_not_null',
            ),
        ),
    ]
