// Copyright 2022-2023 Bloomberg Finance L.P
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef INCLUDED_CLANGSCANDEPS
#define INCLUDED_CLANGSCANDEPS

#include <metricsconfig.h>
#include <parsedcommand.h>
#include <set>
#include <string>

namespace recc {

struct ClangScanDeps {
    /**
     * Get dependencies for the specified target using clang-scan-deps.
     *
     * Returns true if successful, false if clang-scan-deps support is not
     * available or failed.
     */
    static bool
    dependenciesForTarget(const ParsedCommand &parsedCommand,
                          const std::string &target,
                          std::set<std::string> *result,
                          const CounterMetricCallback &recordCounterMetric);
};

} // namespace recc

#endif
