//This file is part of AcetoneISO. Copyright 2006,2007,2008,2009, 2010 Marco Di Antonio and Fabrizio Di Marco (acetoneiso@gmail.com)
//
//    AcetoneISO is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    AcetoneISO is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with AcetoneISO.  If not, see <http://www.gnu.org/licenses/>.

void acetoneiso::split()
{
//7z a -v100m test tales_radiant_mythology.cso
  QDir bin("/usr/bin");
  QFile split;
  QDir::setCurrent( bin.path() );
  split.setFileName("7z");

  QDir Home = QDir::home();
  QString fileName = QFileDialog::getOpenFileName(this,tr("Open Image to be splitted"),Home.path() , tr("Image Files (*.iso *.daa *.bin *.mdf *.ashdisc *.bwi *.b5i *.lcd *.img *.cdi *.cif *.p01 *.pdi *.nrg *.ncd *.pxi *.gi *.fcd *.vcd *.c2d *.dmg *.gpg)"));
  if ( fileName.isNull() ) {
    return;
  }

  QString split_folder = QFileDialog::getSaveFileName(this, tr("AcetoneISO::Insert volume name"), Home.path() + "/AcetoneISO_Volumes");
  if ( split_folder.isNull() ) {
    return;
  }

  bool ok;
  int i = QInputDialog::getInteger(this, tr("AcetoneISO::Split number"),tr("Please insert the volume number in MegaByte:"), 99, 1, 100000, 1, &ok);
  if (!ok) {
    return;
  }

  QString file;
  file = QString::number(i).append("m");
  file.prepend("-v");
  bin = split_folder;
  QDir::setCurrent( bin.path() );
  disable_all_button_processes();
  SPlit.start("7z",QStringList()  << "a" << "-y" << "-t7z" << "-m0=lzma" << "-mx=0" << "-mfb=8" << "-md=2m" << "-ms=on" << file << split_folder << fileName);
  progBarra();


}

void acetoneiso::merge()
{

/* QFileDialog dialog(this, tr("AcetoneISO::Select Parts keeping CTRL key pressed"), Home.path());
 dialog.setFileMode(QFileDialog::ExistingFiles);
 dialog.setViewMode(QFileDialog::Detail); 
 QStringList fileNames;
if (dialog.exec()) {
   fileNames = dialog.selectedFiles();
   if (!fileNames.isEmpty()) {
      QString merged = QFileDialog::getSaveFileName(this, tr("AcetoneISO::Save merged image"),Home.path() + "/Acetone_merged");
      if (merged.isNull() ) {
         return;
       }
      else{
         CAt.setReadChannel(QProcess::StandardOutput);//imposto il canale di lettura del processo
         CAt.setStandardOutputFile( merged,   QIODevice::Truncate );//l'output di cat va nel file merged.
         CAt.start("cat", QStringList() <<  fileNames );//faccio partire il processo cat.
         progBarra();
       }
    }
 }*/
  QDir bin("/usr/bin");
  QFile split;
  QDir::setCurrent( bin.path() );
  split.setFileName("7z");

  QDir Home = QDir::home();
  QString fileName = QFileDialog::getOpenFileName(this,tr("Select first volume part"),Home.path() , tr("7Z 001 (*.001)"));
  if ( fileName.isNull() ) {
    return;
  }

  QString folder = QFileDialog::getExistingDirectory(this, tr("AcetoneISO::Select where to extract image"),Home.path());
  if (folder.isNull() ) {
    return;
  }
  
  QString file;
  folder.prepend("-o");
  disable_all_button_processes();
  SPlit.start("7z",QStringList()  << "x" << "-y" << folder << fileName);
  progBarra();
		 
	   //7z x -y -oDesktop/ iso_acetoneiso2.iso.7z

}


