/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#include "GraphicExportFilter.hxx"
#include <comphelper/servicedecl.hxx>

#define GRAPHIC_EXPORT_FILTER_SERVICE "com.sun.star.comp.GraphicExportFilter"

comphelper::service_decl::class_<GraphicExportFilter> const serviceGraphicExportFilter;
const comphelper::service_decl::ServiceDecl graphicExportFilter(
    serviceGraphicExportFilter,
    GRAPHIC_EXPORT_FILTER_SERVICE,
    "com.sun.star.document.ExportFilter" );


extern "C" SAL_DLLPUBLIC_EXPORT void* graphicfilter_component_getFactory(
    char const* pImplementationName, void*, void*)
{
    if ( rtl_str_compare (pImplementationName, GRAPHIC_EXPORT_FILTER_SERVICE) == 0 )
    {
        return comphelper::service_decl::component_getFactoryHelper( pImplementationName, {&graphicExportFilter} );
    }
    return nullptr;
}

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
