# 2022-08-16 Triage Log

A fairly quiet week for performance, with the exception of the LLVM 15 upgrade
which resulted in many changes, mostly to the positive.

Triage done by **@simulacrum**.
Revision range: [cc4dd6fc9f1a5c798df269933c7e442b79661a86..14a459bf37bc19476d43e0045d078121c12d3fef](https://perf.rust-lang.org/?start=cc4dd6fc9f1a5c798df269933c7e442b79661a86&end=14a459bf37bc19476d43e0045d078121c12d3fef&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u) | mean | max | count |
|:----------------:|:----:|:---:|:-----:|
| Regressions ❌ <br /> (primary) | 0.7% | 7.7% | 62    |
| Regressions ❌ <br /> (secondary) | 1.3% | 5.0% | 51    |
| Improvements ✅ <br /> (primary) | -1.8% | -6.9% | 93    |
| Improvements ✅ <br /> (secondary) | -2.4% | -22.0% | 128   |
| All ❌✅ (primary) | -0.8% | 7.7% | 155   |


2 Regressions, 4 Improvements, 2 Mixed; 1 of them in rollups
38 artifact comparisons made in total

#### Regressions

consider unnormalized types for implied bounds [#99217](https://github.com/rust-lang/rust/pull/99217) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6d3f1beae1720055e5a30f4dbe7a9e7fb810c65e&end=63e4312e6bd50ec9859c363402209809fb8155d5&stat=instructions:u)

| (instructions:u) | mean | max | count |
|:----------------:|:----:|:---:|:-----:|
| Regressions ❌ <br /> (primary) | 0.7% | 1.9% | 37    |
| Regressions ❌ <br /> (secondary) | 2.0% | 2.4% | 11    |
| Improvements ✅ <br /> (primary) | -    | -   | 0     |
| Improvements ✅ <br /> (secondary) | -    | -   | 0     |
| All ❌✅ (primary) | 0.7% | 1.9% | 37    |

This regression is caused by a soundness fix.
[#99725](https://github.com/rust-lang/rust/pull/99725) recovered a small amount
of the lost performance here.

rustdoc: Merge source code pages HTML elements together [#100429](https://github.com/rust-lang/rust/pull/100429) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4c5665583815a0f0f3e22516441efb43ea6dede2&end=801821d1560f84e4716fcbd9244ec959320a13d5&stat=instructions:u)

| (instructions:u) | mean | max | count |
|:----------------:|:----:|:---:|:-----:|
| Regressions ❌ <br /> (primary) | 0.6% | 1.4% | 12    |
| Regressions ❌ <br /> (secondary) | 1.8% | 3.1% | 8     |
| Improvements ✅ <br /> (primary) | -    | -   | 0     |
| Improvements ✅ <br /> (secondary) | -    | -   | 0     |
| All ❌✅ (primary) | 0.6% | 1.4% | 12    |

The regressions are limited to doc benchmarks and the underlying change reduces
the number of DOM elements generated by ~30% across a few samples (see PR
description for details). Those sizes aren't measured by perf.rust-lang.org
today, so there's no reflection of that here, but the size improvement is a
welcome one.

#### Improvements

Reoptimize layout array [#99174](https://github.com/rust-lang/rust/pull/99174) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=29e4a9ee0253cd39e552a77f51f11f9a5f1c41e6&end=908fc5b26d15fc96d630ab921e70b2db77a532c4&stat=instructions:u)

| (instructions:u) | mean | max | count |
|:----------------:|:----:|:---:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -   | 0     |
| Regressions ❌ <br /> (secondary) | -    | -   | 0     |
| Improvements ✅ <br /> (primary) | -0.4% | -0.8% | 10    |
| Improvements ✅ <br /> (secondary) | -0.8% | -1.2% | 5     |
| All ❌✅ (primary) | -0.4% | -0.8% | 10    |


Remove manual implementations of HashStable for hir::Expr and hir::Ty. [#100237](https://github.com/rust-lang/rust/pull/100237) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3694b7d307b7516757651952b30bb97b6ba5c049&end=ef9810a3e2a9a16e79176cb0d3466ea82d239942&stat=instructions:u)

| (instructions:u) | mean | max | count |
|:----------------:|:----:|:---:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -   | 0     |
| Regressions ❌ <br /> (secondary) | -    | -   | 0     |
| Improvements ✅ <br /> (primary) | -0.2% | -0.2% | 3     |
| Improvements ✅ <br /> (secondary) | -    | -   | 0     |
| All ❌✅ (primary) | -0.2% | -0.2% | 3     |

Possibly spurious, but leaving in the report -- bitmaps-3.1.0 check typically does not [see] this much impact on a run to run basis so it's probably at least partially real.

[see]: https://perf.rust-lang.org/index.html?start=2022-07-01&end=ef9810a3e2a9a16e79176cb0d3466ea82d239942&benchmark=bitmaps-3.1.0&profile=check&scenario=incr-unchanged&stat=instructions:u&kind=percentfromfirst


Shrink `ast::Attribute`. [#100441](https://github.com/rust-lang/rust/pull/100441) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8556e6620e4866526b3cea767ad8c20ae877a569&end=14a459bf37bc19476d43e0045d078121c12d3fef&stat=instructions:u)

| (instructions:u) | mean | max | count |
|:----------------:|:----:|:---:|:-----:|
| Regressions ❌ <br /> (primary) | 0.6% | 0.6% | 1     |
| Regressions ❌ <br /> (secondary) | 0.2% | 0.2% | 1     |
| Improvements ✅ <br /> (primary) | -0.6% | -1.4% | 22    |
| Improvements ✅ <br /> (secondary) | -1.0% | -1.5% | 23    |
| All ❌✅ (primary) | -0.5% | -1.4% | 23    |

Mostly an improvement in doc benchmarks, though a few check benchmarks improved
as well. An excellent win for memory usage, with up to 5.8% wins on helloworld.

passes: load `defined_lib_features` query less [#100328](https://github.com/rust-lang/rust/pull/100328) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=569788e47ee3595c9c6f0e332844d982b3e991c2&end=0068b8bf4b150b506ef0871be4e8652fd4308f84&stat=instructions:u)

| (instructions:u) | mean | max | count |
|:----------------:|:----:|:---:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -   | 0     |
| Regressions ❌ <br /> (secondary) | 0.8% | 1.5% | 3     |
| Improvements ✅ <br /> (primary) | -0.4% | -0.4% | 1     |
| Improvements ✅ <br /> (secondary) | -1.2% | -1.8% | 8     |
| All ❌✅ (primary) | -0.4% | -0.4% | 1     |

The regressions here appear to be spurious, with performance recovering on the
next commit. Otherwise, this is a good improvement.

#### Mixed

Rollup of 13 pull requests [#100426](https://github.com/rust-lang/rust/pull/100426) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=20ffea6938b5839c390252e07940b99e3b6a889a&end=2ed0f29168f5bc116e747152be600519b5d78bfd&stat=instructions:u)

| (instructions:u) | mean | max | count |
|:----------------:|:----:|:---:|:-----:|
| Regressions ❌ <br /> (primary) | 0.3% | 0.4% | 4     |
| Regressions ❌ <br /> (secondary) | 0.5% | 0.7% | 5     |
| Improvements ✅ <br /> (primary) | -0.9% | -0.9% | 1     |
| Improvements ✅ <br /> (secondary) | -1.8% | -1.8% | 1     |
| All ❌✅ (primary) | 0.0% | -0.9% | 5     |

Small-ish regression narrowed down to
[#99337](https://github.com/rust-lang/rust/pull/99337), some active work in
this area of rustdoc is likely to help here soon.

Update to LLVM 15 [#99464](https://github.com/rust-lang/rust/pull/99464) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b998821e4c51c44a9ebee395c91323c374236bbb&end=e2b52ff73edc8b0b7c74bc28760d618187731fe8&stat=instructions:u)

| (instructions:u) | mean | max | count |
|:----------------:|:----:|:---:|:-----:|
| Regressions ❌ <br /> (primary) | 0.8% | 7.5% | 40    |
| Regressions ❌ <br /> (secondary) | 1.2% | 4.4% | 29    |
| Improvements ✅ <br /> (primary) | -1.5% | -6.0% | 100   |
| Improvements ✅ <br /> (secondary) | -2.6% | -21.6% | 94    |
| All ❌✅ (primary) | -0.9% | 7.5% | 140   |

Overall the benefits here outweigh the negatives, with a number of good
improvements. LLVM upgrades are something we're going to keep rolling forward
on regardless. For wall time metrics the improvement here looks particularly
nice, with bootstrap times improved by ~4%, shaving 30 seconds of the total
time measured by perf.

