// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/logging/v2/logging_config.proto

package logging

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "github.com/golang/protobuf/ptypes/duration"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// LogBucket lifecycle states (Beta).
type LifecycleState int32

const (
	// Unspecified state.  This is only used/useful for distinguishing
	// unset values.
	LifecycleState_LIFECYCLE_STATE_UNSPECIFIED LifecycleState = 0
	// The normal and active state.
	LifecycleState_ACTIVE LifecycleState = 1
	// The bucket has been marked for deletion by the user.
	LifecycleState_DELETE_REQUESTED LifecycleState = 2
)

var LifecycleState_name = map[int32]string{
	0: "LIFECYCLE_STATE_UNSPECIFIED",
	1: "ACTIVE",
	2: "DELETE_REQUESTED",
}

var LifecycleState_value = map[string]int32{
	"LIFECYCLE_STATE_UNSPECIFIED": 0,
	"ACTIVE":                      1,
	"DELETE_REQUESTED":            2,
}

func (x LifecycleState) String() string {
	return proto.EnumName(LifecycleState_name, int32(x))
}

func (LifecycleState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_775871f9b2cdbeb8, []int{0}
}

// Available log entry formats. Log entries can be written to
// Logging in either format and can be exported in either format.
// Version 2 is the preferred format.
type LogSink_VersionFormat int32

const (
	// An unspecified format version that will default to V2.
	LogSink_VERSION_FORMAT_UNSPECIFIED LogSink_VersionFormat = 0
	// `LogEntry` version 2 format.
	LogSink_V2 LogSink_VersionFormat = 1
	// `LogEntry` version 1 format.
	LogSink_V1 LogSink_VersionFormat = 2
)

var LogSink_VersionFormat_name = map[int32]string{
	0: "VERSION_FORMAT_UNSPECIFIED",
	1: "V2",
	2: "V1",
}

var LogSink_VersionFormat_value = map[string]int32{
	"VERSION_FORMAT_UNSPECIFIED": 0,
	"V2":                         1,
	"V1":                         2,
}

func (x LogSink_VersionFormat) String() string {
	return proto.EnumName(LogSink_VersionFormat_name, int32(x))
}

func (LogSink_VersionFormat) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_775871f9b2cdbeb8, []int{1, 0}
}

// Describes a repository of logs (Beta).
type LogBucket struct {
	// The resource name of the bucket.
	// For example:
	// "projects/my-project-id/locations/my-location/buckets/my-bucket-id The
	// supported locations are:
	//   "global"
	//   "us-central1"
	//
	// For the location of `global` it is unspecified where logs are actually
	// stored.
	// Once a bucket has been created, the location can not be changed.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Describes this bucket.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The creation timestamp of the bucket. This is not set for any of the
	// default buckets.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last update timestamp of the bucket.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Logs will be retained by default for this amount of time, after which they
	// will automatically be deleted. The minimum retention period is 1 day.
	// If this value is set to zero at bucket creation time, the default time of
	// 30 days will be used.
	RetentionDays int32 `protobuf:"varint,11,opt,name=retention_days,json=retentionDays,proto3" json:"retention_days,omitempty"`
	// Output only. The bucket lifecycle state.
	LifecycleState       LifecycleState `protobuf:"varint,12,opt,name=lifecycle_state,json=lifecycleState,proto3,enum=google.logging.v2.LifecycleState" json:"lifecycle_state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *LogBucket) Reset()         { *m = LogBucket{} }
func (m *LogBucket) String() string { return proto.CompactTextString(m) }
func (*LogBucket) ProtoMessage()    {}
func (*LogBucket) Descriptor() ([]byte, []int) {
	return fileDescriptor_775871f9b2cdbeb8, []int{0}
}

func (m *LogBucket) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogBucket.Unmarshal(m, b)
}
func (m *LogBucket) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogBucket.Marshal(b, m, deterministic)
}
func (m *LogBucket) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogBucket.Merge(m, src)
}
func (m *LogBucket) XXX_Size() int {
	return xxx_messageInfo_LogBucket.Size(m)
}
func (m *LogBucket) XXX_DiscardUnknown() {
	xxx_messageInfo_LogBucket.DiscardUnknown(m)
}

var xxx_messageInfo_LogBucket proto.InternalMessageInfo

func (m *LogBucket) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *LogBucket) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *LogBucket) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *LogBucket) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *LogBucket) GetRetentionDays() int32 {
	if m != nil {
		return m.RetentionDays
	}
	return 0
}

func (m *LogBucket) GetLifecycleState() LifecycleState {
	if m != nil {
		return m.LifecycleState
	}
	return LifecycleState_LIFECYCLE_STATE_UNSPECIFIED
}

// Describes a sink used to export log entries to one of the following
// destinations in any project: a Cloud Storage bucket, a BigQuery dataset, or a
// Cloud Pub/Sub topic. A logs filter controls which log entries are exported.
// The sink must be created within a project, organization, billing account, or
// folder.
type LogSink struct {
	// Required. The client-assigned sink identifier, unique within the project. Example:
	// `"my-syslog-errors-to-pubsub"`. Sink identifiers are limited to 100
	// characters and can include only the following characters: upper and
	// lower-case alphanumeric characters, underscores, hyphens, and periods.
	// First character has to be alphanumeric.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The export destination:
	//
	//     "storage.googleapis.com/[GCS_BUCKET]"
	//     "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]"
	//     "pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]"
	//
	// The sink's `writer_identity`, set when the sink is created, must
	// have permission to write to the destination or else the log
	// entries are not exported. For more information, see
	// [Exporting Logs with Sinks](https://cloud.google.com/logging/docs/api/tasks/exporting-logs).
	Destination string `protobuf:"bytes,3,opt,name=destination,proto3" json:"destination,omitempty"`
	// Optional. An [advanced logs filter](https://cloud.google.com/logging/docs/view/advanced-queries). The only
	// exported log entries are those that are in the resource owning the sink and
	// that match the filter. For example:
	//
	//     logName="projects/[PROJECT_ID]/logs/[LOG_ID]" AND severity>=ERROR
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. A description of this sink.
	// The maximum length of the description is 8000 characters.
	Description string `protobuf:"bytes,18,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. If set to True, then this sink is disabled and it does not
	// export any log entries.
	Disabled bool `protobuf:"varint,19,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// Deprecated. The log entry format to use for this sink's exported log
	// entries. The v2 format is used by default and cannot be changed.
	OutputVersionFormat LogSink_VersionFormat `protobuf:"varint,6,opt,name=output_version_format,json=outputVersionFormat,proto3,enum=google.logging.v2.LogSink_VersionFormat" json:"output_version_format,omitempty"` // Deprecated: Do not use.
	// Output only. An IAM identity–a service account or group&mdash;under which Logging
	// writes the exported log entries to the sink's destination. This field is
	// set by [sinks.create][google.logging.v2.ConfigServiceV2.CreateSink] and
	// [sinks.update][google.logging.v2.ConfigServiceV2.UpdateSink] based on the
	// value of `unique_writer_identity` in those methods.
	//
	// Until you grant this identity write-access to the destination, log entry
	// exports from this sink will fail. For more information,
	// see [Granting Access for a
	// Resource](https://cloud.google.com/iam/docs/granting-roles-to-service-accounts#granting_access_to_a_service_account_for_a_resource).
	// Consult the destination service's documentation to determine the
	// appropriate IAM roles to assign to the identity.
	WriterIdentity string `protobuf:"bytes,8,opt,name=writer_identity,json=writerIdentity,proto3" json:"writer_identity,omitempty"`
	// Optional. This field applies only to sinks owned by organizations and
	// folders. If the field is false, the default, only the logs owned by the
	// sink's parent resource are available for export. If the field is true, then
	// logs from all the projects, folders, and billing accounts contained in the
	// sink's parent resource are also available for export. Whether a particular
	// log entry from the children is exported depends on the sink's filter
	// expression. For example, if this field is true, then the filter
	// `resource.type=gce_instance` would export all Compute Engine VM instance
	// log entries from all projects in the sink's parent. To only export entries
	// from certain child projects, filter on the project part of the log name:
	//
	//     logName:("projects/test-project1/" OR "projects/test-project2/") AND
	//     resource.type=gce_instance
	IncludeChildren bool `protobuf:"varint,9,opt,name=include_children,json=includeChildren,proto3" json:"include_children,omitempty"`
	// Destination dependent options.
	//
	// Types that are valid to be assigned to Options:
	//	*LogSink_BigqueryOptions
	Options isLogSink_Options `protobuf_oneof:"options"`
	// Output only. The creation timestamp of the sink.
	//
	// This field may not be present for older sinks.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,13,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last update timestamp of the sink.
	//
	// This field may not be present for older sinks.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,14,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *LogSink) Reset()         { *m = LogSink{} }
func (m *LogSink) String() string { return proto.CompactTextString(m) }
func (*LogSink) ProtoMessage()    {}
func (*LogSink) Descriptor() ([]byte, []int) {
	return fileDescriptor_775871f9b2cdbeb8, []int{1}
}

func (m *LogSink) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogSink.Unmarshal(m, b)
}
func (m *LogSink) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogSink.Marshal(b, m, deterministic)
}
func (m *LogSink) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogSink.Merge(m, src)
}
func (m *LogSink) XXX_Size() int {
	return xxx_messageInfo_LogSink.Size(m)
}
func (m *LogSink) XXX_DiscardUnknown() {
	xxx_messageInfo_LogSink.DiscardUnknown(m)
}

var xxx_messageInfo_LogSink proto.InternalMessageInfo

func (m *LogSink) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *LogSink) GetDestination() string {
	if m != nil {
		return m.Destination
	}
	return ""
}

func (m *LogSink) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *LogSink) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *LogSink) GetDisabled() bool {
	if m != nil {
		return m.Disabled
	}
	return false
}

// Deprecated: Do not use.
func (m *LogSink) GetOutputVersionFormat() LogSink_VersionFormat {
	if m != nil {
		return m.OutputVersionFormat
	}
	return LogSink_VERSION_FORMAT_UNSPECIFIED
}

func (m *LogSink) GetWriterIdentity() string {
	if m != nil {
		return m.WriterIdentity
	}
	return ""
}

func (m *LogSink) GetIncludeChildren() bool {
	if m != nil {
		return m.IncludeChildren
	}
	return false
}

type isLogSink_Options interface {
	isLogSink_Options()
}

type LogSink_BigqueryOptions struct {
	BigqueryOptions *BigQueryOptions `protobuf:"bytes,12,opt,name=bigquery_options,json=bigqueryOptions,proto3,oneof"`
}

func (*LogSink_BigqueryOptions) isLogSink_Options() {}

func (m *LogSink) GetOptions() isLogSink_Options {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *LogSink) GetBigqueryOptions() *BigQueryOptions {
	if x, ok := m.GetOptions().(*LogSink_BigqueryOptions); ok {
		return x.BigqueryOptions
	}
	return nil
}

func (m *LogSink) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *LogSink) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*LogSink) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*LogSink_BigqueryOptions)(nil),
	}
}

// Options that change functionality of a sink exporting data to BigQuery.
type BigQueryOptions struct {
	// Optional. Whether to use [BigQuery's partition
	// tables](https://cloud.google.com/bigquery/docs/partitioned-tables). By default, Logging
	// creates dated tables based on the log entries' timestamps, e.g.
	// syslog_20170523. With partitioned tables the date suffix is no longer
	// present and [special query
	// syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables) has to be used instead.
	// In both cases, tables are sharded based on UTC timezone.
	UsePartitionedTables bool `protobuf:"varint,1,opt,name=use_partitioned_tables,json=usePartitionedTables,proto3" json:"use_partitioned_tables,omitempty"`
	// Output only. True if new timestamp column based partitioning is in use,
	// false if legacy ingestion-time partitioning is in use.
	// All new sinks will have this field set true and will use timestamp column
	// based partitioning. If use_partitioned_tables is false, this value has no
	// meaning and will be false. Legacy sinks using partitioned tables will have
	// this field set to false.
	UsesTimestampColumnPartitioning bool     `protobuf:"varint,3,opt,name=uses_timestamp_column_partitioning,json=usesTimestampColumnPartitioning,proto3" json:"uses_timestamp_column_partitioning,omitempty"`
	XXX_NoUnkeyedLiteral            struct{} `json:"-"`
	XXX_unrecognized                []byte   `json:"-"`
	XXX_sizecache                   int32    `json:"-"`
}

func (m *BigQueryOptions) Reset()         { *m = BigQueryOptions{} }
func (m *BigQueryOptions) String() string { return proto.CompactTextString(m) }
func (*BigQueryOptions) ProtoMessage()    {}
func (*BigQueryOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_775871f9b2cdbeb8, []int{2}
}

func (m *BigQueryOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BigQueryOptions.Unmarshal(m, b)
}
func (m *BigQueryOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BigQueryOptions.Marshal(b, m, deterministic)
}
func (m *BigQueryOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BigQueryOptions.Merge(m, src)
}
func (m *BigQueryOptions) XXX_Size() int {
	return xxx_messageInfo_BigQueryOptions.Size(m)
}
func (m *BigQueryOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_BigQueryOptions.DiscardUnknown(m)
}

var xxx_messageInfo_BigQueryOptions proto.InternalMessageInfo

func (m *BigQueryOptions) GetUsePartitionedTables() bool {
	if m != nil {
		return m.UsePartitionedTables
	}
	return false
}

func (m *BigQueryOptions) GetUsesTimestampColumnPartitioning() bool {
	if m != nil {
		return m.UsesTimestampColumnPartitioning
	}
	return false
}

// The parameters to `ListBuckets` (Beta).
type ListBucketsRequest struct {
	// Required. The parent resource whose buckets are to be listed:
	//
	//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
	//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]"
	//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]"
	//
	// Note: The locations portion of the resource must be specified, but
	// supplying the character `-` in place of [LOCATION_ID] will return all
	// buckets.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. If present, then retrieve the next batch of results from the
	// preceding call to this method. `pageToken` must be the value of
	// `nextPageToken` from the previous response. The values of other method
	// parameters should be identical to those in the previous call.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The maximum number of results to return from this request.
	// Non-positive values are ignored. The presence of `nextPageToken` in the
	// response indicates that more results might be available.
	PageSize             int32    `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListBucketsRequest) Reset()         { *m = ListBucketsRequest{} }
func (m *ListBucketsRequest) String() string { return proto.CompactTextString(m) }
func (*ListBucketsRequest) ProtoMessage()    {}
func (*ListBucketsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_775871f9b2cdbeb8, []int{3}
}

func (m *ListBucketsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListBucketsRequest.Unmarshal(m, b)
}
func (m *ListBucketsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListBucketsRequest.Marshal(b, m, deterministic)
}
func (m *ListBucketsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBucketsRequest.Merge(m, src)
}
func (m *ListBucketsRequest) XXX_Size() int {
	return xxx_messageInfo_ListBucketsRequest.Size(m)
}
func (m *ListBucketsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBucketsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListBucketsRequest proto.InternalMessageInfo

func (m *ListBucketsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListBucketsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListBucketsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// The response from ListBuckets (Beta).
type ListBucketsResponse struct {
	// A list of buckets.
	Buckets []*LogBucket `protobuf:"bytes,1,rep,name=buckets,proto3" json:"buckets,omitempty"`
	// If there might be more results than appear in this response, then
	// `nextPageToken` is included. To get the next set of results, call the same
	// method again using the value of `nextPageToken` as `pageToken`.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListBucketsResponse) Reset()         { *m = ListBucketsResponse{} }
func (m *ListBucketsResponse) String() string { return proto.CompactTextString(m) }
func (*ListBucketsResponse) ProtoMessage()    {}
func (*ListBucketsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_775871f9b2cdbeb8, []int{4}
}

func (m *ListBucketsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListBucketsResponse.Unmarshal(m, b)
}
func (m *ListBucketsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListBucketsResponse.Marshal(b, m, deterministic)
}
func (m *ListBucketsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBucketsResponse.Merge(m, src)
}
func (m *ListBucketsResponse) XXX_Size() int {
	return xxx_messageInfo_ListBucketsResponse.Size(m)
}
func (m *ListBucketsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBucketsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListBucketsResponse proto.InternalMessageInfo

func (m *ListBucketsResponse) GetBuckets() []*LogBucket {
	if m != nil {
		return m.Buckets
	}
	return nil
}

func (m *ListBucketsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The parameters to `UpdateBucket` (Beta).
type UpdateBucketRequest struct {
	// Required. The full resource name of the bucket to update.
	//
	//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
	//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
	//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
	//
	// Example:
	// `"projects/my-project-id/locations/my-location/buckets/my-bucket-id"`. Also
	// requires permission "resourcemanager.projects.updateLiens" to set the
	// locked property
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The updated bucket.
	Bucket *LogBucket `protobuf:"bytes,2,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. Field mask that specifies the fields in `bucket` that need an update. A
	// bucket field will be overwritten if, and only if, it is in the update
	// mask. `name` and output only fields cannot be updated.
	//
	// For a detailed `FieldMask` definition, see
	// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMask
	//
	// Example: `updateMask=retention_days`.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateBucketRequest) Reset()         { *m = UpdateBucketRequest{} }
func (m *UpdateBucketRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateBucketRequest) ProtoMessage()    {}
func (*UpdateBucketRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_775871f9b2cdbeb8, []int{5}
}

func (m *UpdateBucketRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateBucketRequest.Unmarshal(m, b)
}
func (m *UpdateBucketRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateBucketRequest.Marshal(b, m, deterministic)
}
func (m *UpdateBucketRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateBucketRequest.Merge(m, src)
}
func (m *UpdateBucketRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateBucketRequest.Size(m)
}
func (m *UpdateBucketRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateBucketRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateBucketRequest proto.InternalMessageInfo

func (m *UpdateBucketRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateBucketRequest) GetBucket() *LogBucket {
	if m != nil {
		return m.Bucket
	}
	return nil
}

func (m *UpdateBucketRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The parameters to `GetBucket` (Beta).
type GetBucketRequest struct {
	// Required. The resource name of the bucket:
	//
	//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
	//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
	//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
	//
	// Example:
	// `"projects/my-project-id/locations/my-location/buckets/my-bucket-id"`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetBucketRequest) Reset()         { *m = GetBucketRequest{} }
func (m *GetBucketRequest) String() string { return proto.CompactTextString(m) }
func (*GetBucketRequest) ProtoMessage()    {}
func (*GetBucketRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_775871f9b2cdbeb8, []int{6}
}

func (m *GetBucketRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetBucketRequest.Unmarshal(m, b)
}
func (m *GetBucketRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetBucketRequest.Marshal(b, m, deterministic)
}
func (m *GetBucketRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetBucketRequest.Merge(m, src)
}
func (m *GetBucketRequest) XXX_Size() int {
	return xxx_messageInfo_GetBucketRequest.Size(m)
}
func (m *GetBucketRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetBucketRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetBucketRequest proto.InternalMessageInfo

func (m *GetBucketRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The parameters to `ListSinks`.
type ListSinksRequest struct {
	// Required. The parent resource whose sinks are to be listed:
	//
	//     "projects/[PROJECT_ID]"
	//     "organizations/[ORGANIZATION_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]"
	//     "folders/[FOLDER_ID]"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. If present, then retrieve the next batch of results from the
	// preceding call to this method. `pageToken` must be the value of
	// `nextPageToken` from the previous response. The values of other method
	// parameters should be identical to those in the previous call.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The maximum number of results to return from this request.
	// Non-positive values are ignored. The presence of `nextPageToken` in the
	// response indicates that more results might be available.
	PageSize             int32    `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSinksRequest) Reset()         { *m = ListSinksRequest{} }
func (m *ListSinksRequest) String() string { return proto.CompactTextString(m) }
func (*ListSinksRequest) ProtoMessage()    {}
func (*ListSinksRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_775871f9b2cdbeb8, []int{7}
}

func (m *ListSinksRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSinksRequest.Unmarshal(m, b)
}
func (m *ListSinksRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSinksRequest.Marshal(b, m, deterministic)
}
func (m *ListSinksRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSinksRequest.Merge(m, src)
}
func (m *ListSinksRequest) XXX_Size() int {
	return xxx_messageInfo_ListSinksRequest.Size(m)
}
func (m *ListSinksRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSinksRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListSinksRequest proto.InternalMessageInfo

func (m *ListSinksRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListSinksRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListSinksRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Result returned from `ListSinks`.
type ListSinksResponse struct {
	// A list of sinks.
	Sinks []*LogSink `protobuf:"bytes,1,rep,name=sinks,proto3" json:"sinks,omitempty"`
	// If there might be more results than appear in this response, then
	// `nextPageToken` is included. To get the next set of results, call the same
	// method again using the value of `nextPageToken` as `pageToken`.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSinksResponse) Reset()         { *m = ListSinksResponse{} }
func (m *ListSinksResponse) String() string { return proto.CompactTextString(m) }
func (*ListSinksResponse) ProtoMessage()    {}
func (*ListSinksResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_775871f9b2cdbeb8, []int{8}
}

func (m *ListSinksResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSinksResponse.Unmarshal(m, b)
}
func (m *ListSinksResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSinksResponse.Marshal(b, m, deterministic)
}
func (m *ListSinksResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSinksResponse.Merge(m, src)
}
func (m *ListSinksResponse) XXX_Size() int {
	return xxx_messageInfo_ListSinksResponse.Size(m)
}
func (m *ListSinksResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSinksResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSinksResponse proto.InternalMessageInfo

func (m *ListSinksResponse) GetSinks() []*LogSink {
	if m != nil {
		return m.Sinks
	}
	return nil
}

func (m *ListSinksResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The parameters to `GetSink`.
type GetSinkRequest struct {
	// Required. The resource name of the sink:
	//
	//     "projects/[PROJECT_ID]/sinks/[SINK_ID]"
	//     "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
	//     "folders/[FOLDER_ID]/sinks/[SINK_ID]"
	//
	// Example: `"projects/my-project-id/sinks/my-sink-id"`.
	SinkName             string   `protobuf:"bytes,1,opt,name=sink_name,json=sinkName,proto3" json:"sink_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSinkRequest) Reset()         { *m = GetSinkRequest{} }
func (m *GetSinkRequest) String() string { return proto.CompactTextString(m) }
func (*GetSinkRequest) ProtoMessage()    {}
func (*GetSinkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_775871f9b2cdbeb8, []int{9}
}

func (m *GetSinkRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSinkRequest.Unmarshal(m, b)
}
func (m *GetSinkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSinkRequest.Marshal(b, m, deterministic)
}
func (m *GetSinkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSinkRequest.Merge(m, src)
}
func (m *GetSinkRequest) XXX_Size() int {
	return xxx_messageInfo_GetSinkRequest.Size(m)
}
func (m *GetSinkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSinkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSinkRequest proto.InternalMessageInfo

func (m *GetSinkRequest) GetSinkName() string {
	if m != nil {
		return m.SinkName
	}
	return ""
}

// The parameters to `CreateSink`.
type CreateSinkRequest struct {
	// Required. The resource in which to create the sink:
	//
	//     "projects/[PROJECT_ID]"
	//     "organizations/[ORGANIZATION_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]"
	//     "folders/[FOLDER_ID]"
	//
	// Examples: `"projects/my-logging-project"`, `"organizations/123456789"`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The new sink, whose `name` parameter is a sink identifier that
	// is not already in use.
	Sink *LogSink `protobuf:"bytes,2,opt,name=sink,proto3" json:"sink,omitempty"`
	// Optional. Determines the kind of IAM identity returned as `writer_identity`
	// in the new sink. If this value is omitted or set to false, and if the
	// sink's parent is a project, then the value returned as `writer_identity` is
	// the same group or service account used by Logging before the addition of
	// writer identities to this API. The sink's destination must be in the same
	// project as the sink itself.
	//
	// If this field is set to true, or if the sink is owned by a non-project
	// resource such as an organization, then the value of `writer_identity` will
	// be a unique service account used only for exports from the new sink. For
	// more information, see `writer_identity` in [LogSink][google.logging.v2.LogSink].
	UniqueWriterIdentity bool     `protobuf:"varint,3,opt,name=unique_writer_identity,json=uniqueWriterIdentity,proto3" json:"unique_writer_identity,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateSinkRequest) Reset()         { *m = CreateSinkRequest{} }
func (m *CreateSinkRequest) String() string { return proto.CompactTextString(m) }
func (*CreateSinkRequest) ProtoMessage()    {}
func (*CreateSinkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_775871f9b2cdbeb8, []int{10}
}

func (m *CreateSinkRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateSinkRequest.Unmarshal(m, b)
}
func (m *CreateSinkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateSinkRequest.Marshal(b, m, deterministic)
}
func (m *CreateSinkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateSinkRequest.Merge(m, src)
}
func (m *CreateSinkRequest) XXX_Size() int {
	return xxx_messageInfo_CreateSinkRequest.Size(m)
}
func (m *CreateSinkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateSinkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateSinkRequest proto.InternalMessageInfo

func (m *CreateSinkRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateSinkRequest) GetSink() *LogSink {
	if m != nil {
		return m.Sink
	}
	return nil
}

func (m *CreateSinkRequest) GetUniqueWriterIdentity() bool {
	if m != nil {
		return m.UniqueWriterIdentity
	}
	return false
}

// The parameters to `UpdateSink`.
type UpdateSinkRequest struct {
	// Required. The full resource name of the sink to update, including the parent
	// resource and the sink identifier:
	//
	//     "projects/[PROJECT_ID]/sinks/[SINK_ID]"
	//     "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
	//     "folders/[FOLDER_ID]/sinks/[SINK_ID]"
	//
	// Example: `"projects/my-project-id/sinks/my-sink-id"`.
	SinkName string `protobuf:"bytes,1,opt,name=sink_name,json=sinkName,proto3" json:"sink_name,omitempty"`
	// Required. The updated sink, whose name is the same identifier that appears as part
	// of `sink_name`.
	Sink *LogSink `protobuf:"bytes,2,opt,name=sink,proto3" json:"sink,omitempty"`
	// Optional. See [sinks.create][google.logging.v2.ConfigServiceV2.CreateSink]
	// for a description of this field. When updating a sink, the effect of this
	// field on the value of `writer_identity` in the updated sink depends on both
	// the old and new values of this field:
	//
	// +   If the old and new values of this field are both false or both true,
	//     then there is no change to the sink's `writer_identity`.
	// +   If the old value is false and the new value is true, then
	//     `writer_identity` is changed to a unique service account.
	// +   It is an error if the old value is true and the new value is
	//     set to false or defaulted to false.
	UniqueWriterIdentity bool `protobuf:"varint,3,opt,name=unique_writer_identity,json=uniqueWriterIdentity,proto3" json:"unique_writer_identity,omitempty"`
	// Optional. Field mask that specifies the fields in `sink` that need
	// an update. A sink field will be overwritten if, and only if, it is
	// in the update mask. `name` and output only fields cannot be updated.
	//
	// An empty updateMask is temporarily treated as using the following mask
	// for backwards compatibility purposes:
	//   destination,filter,includeChildren
	// At some point in the future, behavior will be removed and specifying an
	// empty updateMask will be an error.
	//
	// For a detailed `FieldMask` definition, see
	// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMask
	//
	// Example: `updateMask=filter`.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateSinkRequest) Reset()         { *m = UpdateSinkRequest{} }
func (m *UpdateSinkRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateSinkRequest) ProtoMessage()    {}
func (*UpdateSinkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_775871f9b2cdbeb8, []int{11}
}

func (m *UpdateSinkRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateSinkRequest.Unmarshal(m, b)
}
func (m *UpdateSinkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateSinkRequest.Marshal(b, m, deterministic)
}
func (m *UpdateSinkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateSinkRequest.Merge(m, src)
}
func (m *UpdateSinkRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateSinkRequest.Size(m)
}
func (m *UpdateSinkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateSinkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateSinkRequest proto.InternalMessageInfo

func (m *UpdateSinkRequest) GetSinkName() string {
	if m != nil {
		return m.SinkName
	}
	return ""
}

func (m *UpdateSinkRequest) GetSink() *LogSink {
	if m != nil {
		return m.Sink
	}
	return nil
}

func (m *UpdateSinkRequest) GetUniqueWriterIdentity() bool {
	if m != nil {
		return m.UniqueWriterIdentity
	}
	return false
}

func (m *UpdateSinkRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The parameters to `DeleteSink`.
type DeleteSinkRequest struct {
	// Required. The full resource name of the sink to delete, including the parent
	// resource and the sink identifier:
	//
	//     "projects/[PROJECT_ID]/sinks/[SINK_ID]"
	//     "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
	//     "folders/[FOLDER_ID]/sinks/[SINK_ID]"
	//
	// Example: `"projects/my-project-id/sinks/my-sink-id"`.
	SinkName             string   `protobuf:"bytes,1,opt,name=sink_name,json=sinkName,proto3" json:"sink_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteSinkRequest) Reset()         { *m = DeleteSinkRequest{} }
func (m *DeleteSinkRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteSinkRequest) ProtoMessage()    {}
func (*DeleteSinkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_775871f9b2cdbeb8, []int{12}
}

func (m *DeleteSinkRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteSinkRequest.Unmarshal(m, b)
}
func (m *DeleteSinkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteSinkRequest.Marshal(b, m, deterministic)
}
func (m *DeleteSinkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteSinkRequest.Merge(m, src)
}
func (m *DeleteSinkRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteSinkRequest.Size(m)
}
func (m *DeleteSinkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteSinkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteSinkRequest proto.InternalMessageInfo

func (m *DeleteSinkRequest) GetSinkName() string {
	if m != nil {
		return m.SinkName
	}
	return ""
}

// Specifies a set of log entries that are not to be stored in
// Logging. If your GCP resource receives a large volume of logs, you can
// use exclusions to reduce your chargeable logs. Exclusions are
// processed after log sinks, so you can export log entries before they are
// excluded. Note that organization-level and folder-level exclusions don't
// apply to child resources, and that you can't exclude audit log entries.
type LogExclusion struct {
	// Required. A client-assigned identifier, such as `"load-balancer-exclusion"`.
	// Identifiers are limited to 100 characters and can include only letters,
	// digits, underscores, hyphens, and periods. First character has to be
	// alphanumeric.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A description of this exclusion.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Required. An [advanced logs filter](https://cloud.google.com/logging/docs/view/advanced-queries)
	// that matches the log entries to be excluded. By using the
	// [sample function](https://cloud.google.com/logging/docs/view/advanced-queries#sample),
	// you can exclude less than 100% of the matching log entries.
	// For example, the following query matches 99% of low-severity log
	// entries from Google Cloud Storage buckets:
	//
	// `"resource.type=gcs_bucket severity<ERROR sample(insertId, 0.99)"`
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. If set to True, then this exclusion is disabled and it does not
	// exclude any log entries. You can [update an
	// exclusion][google.logging.v2.ConfigServiceV2.UpdateExclusion] to change the
	// value of this field.
	Disabled bool `protobuf:"varint,4,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// Output only. The creation timestamp of the exclusion.
	//
	// This field may not be present for older exclusions.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last update timestamp of the exclusion.
	//
	// This field may not be present for older exclusions.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *LogExclusion) Reset()         { *m = LogExclusion{} }
func (m *LogExclusion) String() string { return proto.CompactTextString(m) }
func (*LogExclusion) ProtoMessage()    {}
func (*LogExclusion) Descriptor() ([]byte, []int) {
	return fileDescriptor_775871f9b2cdbeb8, []int{13}
}

func (m *LogExclusion) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogExclusion.Unmarshal(m, b)
}
func (m *LogExclusion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogExclusion.Marshal(b, m, deterministic)
}
func (m *LogExclusion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogExclusion.Merge(m, src)
}
func (m *LogExclusion) XXX_Size() int {
	return xxx_messageInfo_LogExclusion.Size(m)
}
func (m *LogExclusion) XXX_DiscardUnknown() {
	xxx_messageInfo_LogExclusion.DiscardUnknown(m)
}

var xxx_messageInfo_LogExclusion proto.InternalMessageInfo

func (m *LogExclusion) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *LogExclusion) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *LogExclusion) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *LogExclusion) GetDisabled() bool {
	if m != nil {
		return m.Disabled
	}
	return false
}

func (m *LogExclusion) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *LogExclusion) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// The parameters to `ListExclusions`.
type ListExclusionsRequest struct {
	// Required. The parent resource whose exclusions are to be listed.
	//
	//     "projects/[PROJECT_ID]"
	//     "organizations/[ORGANIZATION_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]"
	//     "folders/[FOLDER_ID]"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. If present, then retrieve the next batch of results from the
	// preceding call to this method. `pageToken` must be the value of
	// `nextPageToken` from the previous response. The values of other method
	// parameters should be identical to those in the previous call.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The maximum number of results to return from this request.
	// Non-positive values are ignored. The presence of `nextPageToken` in the
	// response indicates that more results might be available.
	PageSize             int32    `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListExclusionsRequest) Reset()         { *m = ListExclusionsRequest{} }
func (m *ListExclusionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListExclusionsRequest) ProtoMessage()    {}
func (*ListExclusionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_775871f9b2cdbeb8, []int{14}
}

func (m *ListExclusionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListExclusionsRequest.Unmarshal(m, b)
}
func (m *ListExclusionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListExclusionsRequest.Marshal(b, m, deterministic)
}
func (m *ListExclusionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListExclusionsRequest.Merge(m, src)
}
func (m *ListExclusionsRequest) XXX_Size() int {
	return xxx_messageInfo_ListExclusionsRequest.Size(m)
}
func (m *ListExclusionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListExclusionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListExclusionsRequest proto.InternalMessageInfo

func (m *ListExclusionsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListExclusionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListExclusionsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Result returned from `ListExclusions`.
type ListExclusionsResponse struct {
	// A list of exclusions.
	Exclusions []*LogExclusion `protobuf:"bytes,1,rep,name=exclusions,proto3" json:"exclusions,omitempty"`
	// If there might be more results than appear in this response, then
	// `nextPageToken` is included. To get the next set of results, call the same
	// method again using the value of `nextPageToken` as `pageToken`.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListExclusionsResponse) Reset()         { *m = ListExclusionsResponse{} }
func (m *ListExclusionsResponse) String() string { return proto.CompactTextString(m) }
func (*ListExclusionsResponse) ProtoMessage()    {}
func (*ListExclusionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_775871f9b2cdbeb8, []int{15}
}

func (m *ListExclusionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListExclusionsResponse.Unmarshal(m, b)
}
func (m *ListExclusionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListExclusionsResponse.Marshal(b, m, deterministic)
}
func (m *ListExclusionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListExclusionsResponse.Merge(m, src)
}
func (m *ListExclusionsResponse) XXX_Size() int {
	return xxx_messageInfo_ListExclusionsResponse.Size(m)
}
func (m *ListExclusionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListExclusionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListExclusionsResponse proto.InternalMessageInfo

func (m *ListExclusionsResponse) GetExclusions() []*LogExclusion {
	if m != nil {
		return m.Exclusions
	}
	return nil
}

func (m *ListExclusionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The parameters to `GetExclusion`.
type GetExclusionRequest struct {
	// Required. The resource name of an existing exclusion:
	//
	//     "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
	//     "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
	//     "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]"
	//
	// Example: `"projects/my-project-id/exclusions/my-exclusion-id"`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetExclusionRequest) Reset()         { *m = GetExclusionRequest{} }
func (m *GetExclusionRequest) String() string { return proto.CompactTextString(m) }
func (*GetExclusionRequest) ProtoMessage()    {}
func (*GetExclusionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_775871f9b2cdbeb8, []int{16}
}

func (m *GetExclusionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetExclusionRequest.Unmarshal(m, b)
}
func (m *GetExclusionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetExclusionRequest.Marshal(b, m, deterministic)
}
func (m *GetExclusionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetExclusionRequest.Merge(m, src)
}
func (m *GetExclusionRequest) XXX_Size() int {
	return xxx_messageInfo_GetExclusionRequest.Size(m)
}
func (m *GetExclusionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetExclusionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetExclusionRequest proto.InternalMessageInfo

func (m *GetExclusionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The parameters to `CreateExclusion`.
type CreateExclusionRequest struct {
	// Required. The parent resource in which to create the exclusion:
	//
	//     "projects/[PROJECT_ID]"
	//     "organizations/[ORGANIZATION_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]"
	//     "folders/[FOLDER_ID]"
	//
	// Examples: `"projects/my-logging-project"`, `"organizations/123456789"`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The new exclusion, whose `name` parameter is an exclusion name
	// that is not already used in the parent resource.
	Exclusion            *LogExclusion `protobuf:"bytes,2,opt,name=exclusion,proto3" json:"exclusion,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *CreateExclusionRequest) Reset()         { *m = CreateExclusionRequest{} }
func (m *CreateExclusionRequest) String() string { return proto.CompactTextString(m) }
func (*CreateExclusionRequest) ProtoMessage()    {}
func (*CreateExclusionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_775871f9b2cdbeb8, []int{17}
}

func (m *CreateExclusionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateExclusionRequest.Unmarshal(m, b)
}
func (m *CreateExclusionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateExclusionRequest.Marshal(b, m, deterministic)
}
func (m *CreateExclusionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateExclusionRequest.Merge(m, src)
}
func (m *CreateExclusionRequest) XXX_Size() int {
	return xxx_messageInfo_CreateExclusionRequest.Size(m)
}
func (m *CreateExclusionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateExclusionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateExclusionRequest proto.InternalMessageInfo

func (m *CreateExclusionRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateExclusionRequest) GetExclusion() *LogExclusion {
	if m != nil {
		return m.Exclusion
	}
	return nil
}

// The parameters to `UpdateExclusion`.
type UpdateExclusionRequest struct {
	// Required. The resource name of the exclusion to update:
	//
	//     "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
	//     "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
	//     "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]"
	//
	// Example: `"projects/my-project-id/exclusions/my-exclusion-id"`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. New values for the existing exclusion. Only the fields specified in
	// `update_mask` are relevant.
	Exclusion *LogExclusion `protobuf:"bytes,2,opt,name=exclusion,proto3" json:"exclusion,omitempty"`
	// Required. A non-empty list of fields to change in the existing exclusion. New values
	// for the fields are taken from the corresponding fields in the
	// [LogExclusion][google.logging.v2.LogExclusion] included in this request. Fields not mentioned in
	// `update_mask` are not changed and are ignored in the request.
	//
	// For example, to change the filter and description of an exclusion,
	// specify an `update_mask` of `"filter,description"`.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateExclusionRequest) Reset()         { *m = UpdateExclusionRequest{} }
func (m *UpdateExclusionRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateExclusionRequest) ProtoMessage()    {}
func (*UpdateExclusionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_775871f9b2cdbeb8, []int{18}
}

func (m *UpdateExclusionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateExclusionRequest.Unmarshal(m, b)
}
func (m *UpdateExclusionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateExclusionRequest.Marshal(b, m, deterministic)
}
func (m *UpdateExclusionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateExclusionRequest.Merge(m, src)
}
func (m *UpdateExclusionRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateExclusionRequest.Size(m)
}
func (m *UpdateExclusionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateExclusionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateExclusionRequest proto.InternalMessageInfo

func (m *UpdateExclusionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateExclusionRequest) GetExclusion() *LogExclusion {
	if m != nil {
		return m.Exclusion
	}
	return nil
}

func (m *UpdateExclusionRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The parameters to `DeleteExclusion`.
type DeleteExclusionRequest struct {
	// Required. The resource name of an existing exclusion to delete:
	//
	//     "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
	//     "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
	//     "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]"
	//
	// Example: `"projects/my-project-id/exclusions/my-exclusion-id"`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteExclusionRequest) Reset()         { *m = DeleteExclusionRequest{} }
func (m *DeleteExclusionRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteExclusionRequest) ProtoMessage()    {}
func (*DeleteExclusionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_775871f9b2cdbeb8, []int{19}
}

func (m *DeleteExclusionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteExclusionRequest.Unmarshal(m, b)
}
func (m *DeleteExclusionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteExclusionRequest.Marshal(b, m, deterministic)
}
func (m *DeleteExclusionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteExclusionRequest.Merge(m, src)
}
func (m *DeleteExclusionRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteExclusionRequest.Size(m)
}
func (m *DeleteExclusionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteExclusionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteExclusionRequest proto.InternalMessageInfo

func (m *DeleteExclusionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The parameters to
// [GetCmekSettings][google.logging.v2.ConfigServiceV2.GetCmekSettings].
//
// See [Enabling CMEK for Logs Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
// for more information.
type GetCmekSettingsRequest struct {
	// Required. The resource for which to retrieve CMEK settings.
	//
	//     "projects/[PROJECT_ID]/cmekSettings"
	//     "organizations/[ORGANIZATION_ID]/cmekSettings"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]/cmekSettings"
	//     "folders/[FOLDER_ID]/cmekSettings"
	//
	// Example: `"organizations/12345/cmekSettings"`.
	//
	// Note: CMEK for the Logs Router can currently only be configured for GCP
	// organizations. Once configured, it applies to all projects and folders in
	// the GCP organization.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetCmekSettingsRequest) Reset()         { *m = GetCmekSettingsRequest{} }
func (m *GetCmekSettingsRequest) String() string { return proto.CompactTextString(m) }
func (*GetCmekSettingsRequest) ProtoMessage()    {}
func (*GetCmekSettingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_775871f9b2cdbeb8, []int{20}
}

func (m *GetCmekSettingsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetCmekSettingsRequest.Unmarshal(m, b)
}
func (m *GetCmekSettingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetCmekSettingsRequest.Marshal(b, m, deterministic)
}
func (m *GetCmekSettingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetCmekSettingsRequest.Merge(m, src)
}
func (m *GetCmekSettingsRequest) XXX_Size() int {
	return xxx_messageInfo_GetCmekSettingsRequest.Size(m)
}
func (m *GetCmekSettingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetCmekSettingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetCmekSettingsRequest proto.InternalMessageInfo

func (m *GetCmekSettingsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The parameters to
// [UpdateCmekSettings][google.logging.v2.ConfigServiceV2.UpdateCmekSettings].
//
// See [Enabling CMEK for Logs Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
// for more information.
type UpdateCmekSettingsRequest struct {
	// Required. The resource name for the CMEK settings to update.
	//
	//     "projects/[PROJECT_ID]/cmekSettings"
	//     "organizations/[ORGANIZATION_ID]/cmekSettings"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]/cmekSettings"
	//     "folders/[FOLDER_ID]/cmekSettings"
	//
	// Example: `"organizations/12345/cmekSettings"`.
	//
	// Note: CMEK for the Logs Router can currently only be configured for GCP
	// organizations. Once configured, it applies to all projects and folders in
	// the GCP organization.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The CMEK settings to update.
	//
	// See [Enabling CMEK for Logs
	// Router](https://cloud.google.com/logging/docs/routing/managed-encryption) for more information.
	CmekSettings *CmekSettings `protobuf:"bytes,2,opt,name=cmek_settings,json=cmekSettings,proto3" json:"cmek_settings,omitempty"`
	// Optional. Field mask identifying which fields from `cmek_settings` should
	// be updated. A field will be overwritten if and only if it is in the update
	// mask. Output only fields cannot be updated.
	//
	// See [FieldMask][google.protobuf.FieldMask] for more information.
	//
	// Example: `"updateMask=kmsKeyName"`
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateCmekSettingsRequest) Reset()         { *m = UpdateCmekSettingsRequest{} }
func (m *UpdateCmekSettingsRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateCmekSettingsRequest) ProtoMessage()    {}
func (*UpdateCmekSettingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_775871f9b2cdbeb8, []int{21}
}

func (m *UpdateCmekSettingsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateCmekSettingsRequest.Unmarshal(m, b)
}
func (m *UpdateCmekSettingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateCmekSettingsRequest.Marshal(b, m, deterministic)
}
func (m *UpdateCmekSettingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateCmekSettingsRequest.Merge(m, src)
}
func (m *UpdateCmekSettingsRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateCmekSettingsRequest.Size(m)
}
func (m *UpdateCmekSettingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateCmekSettingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateCmekSettingsRequest proto.InternalMessageInfo

func (m *UpdateCmekSettingsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateCmekSettingsRequest) GetCmekSettings() *CmekSettings {
	if m != nil {
		return m.CmekSettings
	}
	return nil
}

func (m *UpdateCmekSettingsRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Describes the customer-managed encryption key (CMEK) settings associated with
// a project, folder, organization, billing account, or flexible resource.
//
// Note: CMEK for the Logs Router can currently only be configured for GCP
// organizations. Once configured, it applies to all projects and folders in the
// GCP organization.
//
// See [Enabling CMEK for Logs Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
// for more information.
type CmekSettings struct {
	// Output only. The resource name of the CMEK settings.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource name for the configured Cloud KMS key.
	//
	// KMS key name format:
	//     "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]"
	//
	// For example:
	//     `"projects/my-project-id/locations/my-region/keyRings/key-ring-name/cryptoKeys/key-name"`
	//
	//
	//
	// To enable CMEK for the Logs Router, set this field to a valid
	// `kms_key_name` for which the associated service account has the required
	// `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key.
	//
	// The Cloud KMS key used by the Log Router can be updated by changing the
	// `kms_key_name` to a new valid key name. Encryption operations that are in
	// progress will be completed with the key that was in use when they started.
	// Decryption operations will be completed using the key that was used at the
	// time of encryption unless access to that key has been revoked.
	//
	// To disable CMEK for the Logs Router, set this field to an empty string.
	//
	// See [Enabling CMEK for Logs
	// Router](https://cloud.google.com/logging/docs/routing/managed-encryption) for more information.
	KmsKeyName string `protobuf:"bytes,2,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// Output only. The service account that will be used by the Logs Router to access your
	// Cloud KMS key.
	//
	// Before enabling CMEK for Logs Router, you must first assign the role
	// `roles/cloudkms.cryptoKeyEncrypterDecrypter` to the service account that
	// the Logs Router will use to access your Cloud KMS key. Use
	// [GetCmekSettings][google.logging.v2.ConfigServiceV2.GetCmekSettings] to
	// obtain the service account ID.
	//
	// See [Enabling CMEK for Logs
	// Router](https://cloud.google.com/logging/docs/routing/managed-encryption) for more information.
	ServiceAccountId     string   `protobuf:"bytes,3,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CmekSettings) Reset()         { *m = CmekSettings{} }
func (m *CmekSettings) String() string { return proto.CompactTextString(m) }
func (*CmekSettings) ProtoMessage()    {}
func (*CmekSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_775871f9b2cdbeb8, []int{22}
}

func (m *CmekSettings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CmekSettings.Unmarshal(m, b)
}
func (m *CmekSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CmekSettings.Marshal(b, m, deterministic)
}
func (m *CmekSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CmekSettings.Merge(m, src)
}
func (m *CmekSettings) XXX_Size() int {
	return xxx_messageInfo_CmekSettings.Size(m)
}
func (m *CmekSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_CmekSettings.DiscardUnknown(m)
}

var xxx_messageInfo_CmekSettings proto.InternalMessageInfo

func (m *CmekSettings) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CmekSettings) GetKmsKeyName() string {
	if m != nil {
		return m.KmsKeyName
	}
	return ""
}

func (m *CmekSettings) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.logging.v2.LifecycleState", LifecycleState_name, LifecycleState_value)
	proto.RegisterEnum("google.logging.v2.LogSink_VersionFormat", LogSink_VersionFormat_name, LogSink_VersionFormat_value)
	proto.RegisterType((*LogBucket)(nil), "google.logging.v2.LogBucket")
	proto.RegisterType((*LogSink)(nil), "google.logging.v2.LogSink")
	proto.RegisterType((*BigQueryOptions)(nil), "google.logging.v2.BigQueryOptions")
	proto.RegisterType((*ListBucketsRequest)(nil), "google.logging.v2.ListBucketsRequest")
	proto.RegisterType((*ListBucketsResponse)(nil), "google.logging.v2.ListBucketsResponse")
	proto.RegisterType((*UpdateBucketRequest)(nil), "google.logging.v2.UpdateBucketRequest")
	proto.RegisterType((*GetBucketRequest)(nil), "google.logging.v2.GetBucketRequest")
	proto.RegisterType((*ListSinksRequest)(nil), "google.logging.v2.ListSinksRequest")
	proto.RegisterType((*ListSinksResponse)(nil), "google.logging.v2.ListSinksResponse")
	proto.RegisterType((*GetSinkRequest)(nil), "google.logging.v2.GetSinkRequest")
	proto.RegisterType((*CreateSinkRequest)(nil), "google.logging.v2.CreateSinkRequest")
	proto.RegisterType((*UpdateSinkRequest)(nil), "google.logging.v2.UpdateSinkRequest")
	proto.RegisterType((*DeleteSinkRequest)(nil), "google.logging.v2.DeleteSinkRequest")
	proto.RegisterType((*LogExclusion)(nil), "google.logging.v2.LogExclusion")
	proto.RegisterType((*ListExclusionsRequest)(nil), "google.logging.v2.ListExclusionsRequest")
	proto.RegisterType((*ListExclusionsResponse)(nil), "google.logging.v2.ListExclusionsResponse")
	proto.RegisterType((*GetExclusionRequest)(nil), "google.logging.v2.GetExclusionRequest")
	proto.RegisterType((*CreateExclusionRequest)(nil), "google.logging.v2.CreateExclusionRequest")
	proto.RegisterType((*UpdateExclusionRequest)(nil), "google.logging.v2.UpdateExclusionRequest")
	proto.RegisterType((*DeleteExclusionRequest)(nil), "google.logging.v2.DeleteExclusionRequest")
	proto.RegisterType((*GetCmekSettingsRequest)(nil), "google.logging.v2.GetCmekSettingsRequest")
	proto.RegisterType((*UpdateCmekSettingsRequest)(nil), "google.logging.v2.UpdateCmekSettingsRequest")
	proto.RegisterType((*CmekSettings)(nil), "google.logging.v2.CmekSettings")
}

func init() {
	proto.RegisterFile("google/logging/v2/logging_config.proto", fileDescriptor_775871f9b2cdbeb8)
}

var fileDescriptor_775871f9b2cdbeb8 = []byte{
	// 2712 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x5a, 0x51, 0x6c, 0x1c, 0x47,
	0x19, 0xee, 0xec, 0x39, 0x4e, 0x3c, 0x76, 0xec, 0xcb, 0xa4, 0x71, 0xae, 0x97, 0x34, 0x76, 0x36,
	0xb1, 0x63, 0x5f, 0x9c, 0xbb, 0x66, 0x13, 0xa2, 0xd4, 0x14, 0xd2, 0xb5, 0x73, 0x76, 0x2d, 0xdc,
	0xc4, 0x3d, 0x3b, 0x86, 0x58, 0x91, 0xb6, 0xeb, 0xbb, 0xf1, 0x65, 0xf1, 0xde, 0xee, 0x65, 0x77,
	0xcf, 0xa9, 0x63, 0xf9, 0x01, 0x1e, 0x79, 0x02, 0x21, 0x24, 0x10, 0x55, 0xa1, 0x48, 0x15, 0x08,
	0x84, 0x78, 0x04, 0x04, 0x12, 0x85, 0xc2, 0x4b, 0x1f, 0xaa, 0x42, 0xdf, 0xac, 0x4a, 0x2d, 0x12,
	0x48, 0x95, 0x05, 0x0f, 0x88, 0x07, 0x10, 0x08, 0x81, 0x76, 0x76, 0x76, 0x77, 0x76, 0x6f, 0x77,
	0x6f, 0x2f, 0xb1, 0x78, 0xf2, 0x7a, 0xe6, 0xfb, 0xff, 0xfd, 0xf7, 0x9b, 0xef, 0xff, 0x67, 0xe6,
	0xd7, 0xc1, 0xf1, 0xba, 0xae, 0xd7, 0x55, 0x5c, 0x52, 0xf5, 0x7a, 0x5d, 0xd1, 0xea, 0xa5, 0x2d,
	0xc1, 0x7d, 0x94, 0xaa, 0xba, 0xb6, 0xa1, 0xd4, 0x8b, 0x4d, 0x43, 0xb7, 0x74, 0x74, 0xcc, 0xc1,
	0x15, 0xe9, 0x64, 0x71, 0x4b, 0xc8, 0x9f, 0xa4, 0xa6, 0x72, 0x53, 0x29, 0x55, 0x55, 0x05, 0x6b,
	0x96, 0x83, 0xcd, 0x8f, 0x30, 0x13, 0x1b, 0x0a, 0x56, 0x6b, 0xd2, 0x3a, 0xbe, 0x2f, 0x6f, 0x29,
	0xba, 0x41, 0x01, 0xcf, 0x30, 0x00, 0x03, 0x9b, 0x7a, 0xcb, 0xa8, 0x62, 0x3a, 0x75, 0x86, 0x4e,
	0x91, 0xff, 0xd6, 0x5b, 0x1b, 0xa5, 0x5a, 0xcb, 0x90, 0x2d, 0x45, 0xd7, 0xe8, 0xfc, 0xa9, 0xf0,
	0x3c, 0x6e, 0x34, 0xad, 0x6d, 0x3a, 0x39, 0x1a, 0x9e, 0x74, 0xde, 0xde, 0x90, 0xcd, 0xcd, 0x50,
	0x68, 0x1e, 0xc2, 0x52, 0x1a, 0xd8, 0xb4, 0xe4, 0x46, 0x93, 0x02, 0x4e, 0x33, 0xa1, 0xc9, 0x9a,
	0xa6, 0x5b, 0xe4, 0xe5, 0xa6, 0x33, 0xcb, 0xff, 0xb9, 0x07, 0xf6, 0x2d, 0xea, 0xf5, 0x99, 0x56,
	0x75, 0x13, 0x5b, 0x08, 0xc1, 0x1e, 0x4d, 0x6e, 0xe0, 0x1c, 0x18, 0x05, 0x13, 0x7d, 0x15, 0xf2,
	0x8c, 0x46, 0x61, 0x7f, 0x0d, 0x9b, 0x55, 0x43, 0x69, 0xda, 0x76, 0xb9, 0x0c, 0x99, 0x62, 0x87,
	0xd0, 0x8b, 0xb0, 0xbf, 0x6a, 0x60, 0xd9, 0xc2, 0x92, 0xfd, 0xee, 0x5c, 0xcf, 0x28, 0x98, 0xe8,
	0x17, 0xf2, 0x45, 0xca, 0xaf, 0x1b, 0x58, 0x71, 0xc5, 0x0d, 0x6c, 0x26, 0xf3, 0xb1, 0x98, 0xa9,
	0x40, 0xc7, 0xc6, 0x1e, 0xb5, 0x3d, 0xb4, 0x9a, 0x35, 0xcf, 0xc3, 0xa1, 0x94, 0x1e, 0x1c, 0x1b,
	0xe2, 0x61, 0x0c, 0x0e, 0x1a, 0xd8, 0xc2, 0x9a, 0x1d, 0x90, 0x54, 0x93, 0xb7, 0xcd, 0x5c, 0xff,
	0x28, 0x98, 0x38, 0x54, 0x39, 0xea, 0x8d, 0xde, 0x94, 0xb7, 0x4d, 0x74, 0x1b, 0x0e, 0xa9, 0xca,
	0x06, 0xae, 0x6e, 0x57, 0x55, 0x2c, 0x99, 0x96, 0x6c, 0xe1, 0xdc, 0xc0, 0x28, 0x98, 0x18, 0x14,
	0xce, 0x16, 0xdb, 0xe4, 0x50, 0x5c, 0x74, 0x91, 0xcb, 0x36, 0xd0, 0x79, 0xe7, 0xa0, 0x1a, 0x18,
	0x9c, 0x7e, 0x8b, 0xdb, 0x17, 0xdf, 0xe4, 0xe0, 0xa8, 0x6b, 0xe6, 0x78, 0x91, 0x9b, 0x8a, 0x59,
	0xac, 0xea, 0x8d, 0x92, 0x4f, 0xed, 0xf5, 0xa6, 0xa1, 0x7f, 0x11, 0x57, 0x2d, 0xb3, 0xb4, 0x43,
	0x9f, 0x76, 0x4b, 0xaa, 0x5e, 0x75, 0x16, 0xa3, 0xb4, 0xe3, 0x3e, 0xee, 0x96, 0xd6, 0x09, 0xde,
	0x2c, 0xed, 0x38, 0x0f, 0xbb, 0x68, 0x46, 0x37, 0xea, 0xb2, 0xa6, 0x3c, 0x72, 0xa1, 0xec, 0xbf,
	0x69, 0x7d, 0x5c, 0xdb, 0xd0, 0xd5, 0x1a, 0x36, 0xcc, 0xd2, 0x8e, 0xf3, 0x90, 0xd6, 0x6e, 0x7e,
	0x5d, 0x51, 0x55, 0x45, 0xab, 0x8b, 0xd5, 0xaa, 0xde, 0xd2, 0xc8, 0x8c, 0x33, 0x20, 0xc9, 0xce,
	0x48, 0x4a, 0x47, 0xfc, 0x87, 0xbd, 0xf0, 0xf0, 0xa2, 0x5e, 0x5f, 0x56, 0xb4, 0x4d, 0x74, 0x92,
	0x55, 0x99, 0x4d, 0x2b, 0x47, 0xa5, 0x76, 0x91, 0x48, 0xcd, 0x52, 0x34, 0xd9, 0x97, 0xda, 0x4c,
	0xdf, 0xc7, 0x22, 0xf7, 0x2f, 0x31, 0x03, 0x41, 0xa1, 0xc2, 0xce, 0xa2, 0x53, 0xb0, 0x77, 0x43,
	0x51, 0x2d, 0x6c, 0x10, 0xb9, 0x10, 0x3f, 0xa0, 0x42, 0x87, 0xd0, 0x58, 0x50, 0xb4, 0xc8, 0x47,
	0x04, 0x94, 0x3b, 0x02, 0x8f, 0xd4, 0x14, 0x53, 0x5e, 0x57, 0x71, 0x2d, 0x77, 0x7c, 0x14, 0x4c,
	0x1c, 0x71, 0x30, 0xde, 0x20, 0x7a, 0x15, 0x9e, 0xd0, 0x5b, 0x56, 0xb3, 0x65, 0x49, 0x5b, 0xd8,
	0x30, 0x6d, 0x6d, 0x6d, 0xe8, 0x46, 0x43, 0xb6, 0x72, 0xbd, 0x44, 0x35, 0x13, 0x51, 0xaa, 0x71,
	0xbe, 0xb2, 0xb8, 0xea, 0x18, 0xcc, 0x11, 0xfc, 0x0c, 0x97, 0x03, 0x95, 0xe3, 0x8e, 0xab, 0xc0,
	0x04, 0x9a, 0x82, 0x43, 0x0f, 0x0d, 0xc5, 0xc2, 0x86, 0xa4, 0xd4, 0x6c, 0xa1, 0x5a, 0xdb, 0xb9,
	0x23, 0x6e, 0xb4, 0x99, 0xca, 0xa0, 0x33, 0xb7, 0x40, 0xa7, 0x50, 0x11, 0x66, 0x15, 0xad, 0xaa,
	0xb6, 0x6a, 0x58, 0xaa, 0xde, 0x57, 0xd4, 0x9a, 0x81, 0xb5, 0x5c, 0x9f, 0x1f, 0xf8, 0x10, 0x9d,
	0x9c, 0xa5, 0x73, 0x68, 0x05, 0x66, 0xd7, 0x95, 0xfa, 0x83, 0x16, 0x36, 0xb6, 0x25, 0x9d, 0x7c,
	0xb3, 0x49, 0x04, 0xdf, 0x2f, 0xf0, 0x11, 0xa1, 0xcf, 0x28, 0xf5, 0x57, 0x6c, 0xe8, 0x6d, 0x07,
	0x49, 0x7c, 0xbe, 0xf4, 0x54, 0x65, 0xc8, 0x75, 0x41, 0xc7, 0xc3, 0x09, 0x7f, 0xf4, 0x89, 0x13,
	0x7e, 0xb0, 0xeb, 0x84, 0xe7, 0x6f, 0xc0, 0xa3, 0x41, 0x22, 0xcf, 0xc0, 0xfc, 0x6a, 0xb9, 0xb2,
	0xbc, 0x70, 0xfb, 0x96, 0x34, 0x77, 0xbb, 0xf2, 0xb2, 0xb8, 0x22, 0xdd, 0xb9, 0xb5, 0xbc, 0x54,
	0x9e, 0x5d, 0x98, 0x5b, 0x28, 0xdf, 0xcc, 0x3e, 0x85, 0x7a, 0x21, 0xb7, 0x2a, 0x64, 0x01, 0xf9,
	0x7b, 0x39, 0xcb, 0x4d, 0xff, 0x0a, 0xec, 0x8b, 0xbf, 0x00, 0xf0, 0x4c, 0x7c, 0xe6, 0x12, 0xb1,
	0x8e, 0x44, 0xe4, 0xad, 0xa9, 0x68, 0x9b, 0x66, 0x69, 0xc7, 0xfe, 0xb3, 0x8b, 0x26, 0x13, 0xd3,
	0x33, 0x00, 0x7d, 0xb6, 0x2d, 0x0b, 0x03, 0xd3, 0xc5, 0xce, 0xc9, 0xc6, 0xe2, 0x67, 0xfa, 0xe0,
	0x61, 0xba, 0xa6, 0xfc, 0x1b, 0x00, 0x0e, 0x85, 0x56, 0x0f, 0x3d, 0x0f, 0x87, 0x5b, 0x26, 0x96,
	0x9a, 0xb2, 0x61, 0x29, 0xf6, 0x08, 0xae, 0x49, 0x96, 0xad, 0x6a, 0x93, 0x24, 0x1e, 0x55, 0xcc,
	0xd3, 0x2d, 0x13, 0x2f, 0xf9, 0x88, 0x15, 0x02, 0x40, 0x4b, 0x90, 0x6f, 0x99, 0xd8, 0x94, 0xbc,
	0xbd, 0x44, 0xaa, 0xea, 0x6a, 0xab, 0xa1, 0xf9, 0xce, 0x14, 0xad, 0x4e, 0xf2, 0xf3, 0x88, 0xb3,
	0x32, 0x23, 0x36, 0xdc, 0x5b, 0xad, 0x59, 0x02, 0x5e, 0x62, 0xb0, 0xfc, 0xeb, 0x00, 0xa2, 0x45,
	0xc5, 0xb4, 0x9c, 0x6a, 0x68, 0x56, 0xf0, 0x83, 0x16, 0x36, 0x2d, 0xf4, 0x22, 0xec, 0x6d, 0xca,
	0x06, 0xd6, 0x2c, 0x5a, 0x0c, 0x26, 0x48, 0xb2, 0xf3, 0xa8, 0x63, 0x3d, 0xad, 0x50, 0x3b, 0xc4,
	0x43, 0xd8, 0x94, 0xeb, 0x58, 0xb2, 0xf4, 0x4d, 0xac, 0xe5, 0x38, 0x3f, 0xd1, 0xfb, 0xec, 0xe1,
	0x15, 0x7b, 0x14, 0x8d, 0x42, 0xf2, 0x8f, 0x64, 0x2a, 0x8f, 0x30, 0x89, 0xfa, 0x10, 0xcd, 0x73,
	0x7b, 0x74, 0x59, 0x79, 0x84, 0xf9, 0x16, 0x3c, 0x1e, 0x88, 0xce, 0x6c, 0xea, 0x9a, 0x89, 0xd1,
	0x35, 0x78, 0x98, 0x56, 0xb2, 0x1c, 0x18, 0xcd, 0x4c, 0xf4, 0x0b, 0xa7, 0xa3, 0x13, 0x9e, 0xc6,
	0xe4, 0x82, 0xd1, 0x38, 0x1c, 0xd2, 0xf0, 0x6b, 0x96, 0x14, 0x8e, 0xac, 0x72, 0xd4, 0x1e, 0x5e,
	0x72, 0x03, 0xe3, 0xdf, 0x07, 0xf0, 0xf8, 0x1d, 0xa2, 0x69, 0xea, 0x81, 0xd2, 0xf2, 0x42, 0xa0,
	0x42, 0x52, 0x52, 0x3a, 0x6f, 0x32, 0xb4, 0x8c, 0x3e, 0x0f, 0x7b, 0x9d, 0x40, 0xc8, 0x4b, 0x3b,
	0x04, 0xed, 0xd4, 0x5f, 0x6a, 0xc0, 0xe4, 0xa5, 0x7d, 0xc4, 0x88, 0xdd, 0xca, 0xe7, 0xec, 0x53,
	0xc8, 0xcb, 0xb2, 0xb9, 0xe9, 0x58, 0xd3, 0xbc, 0xb4, 0x07, 0xf8, 0x25, 0x98, 0x9d, 0xc7, 0xd6,
	0x01, 0x7e, 0x0e, 0xff, 0x4d, 0x00, 0xb3, 0xf6, 0xe2, 0xd8, 0xe9, 0xe8, 0x09, 0xe7, 0xb3, 0x21,
	0xe1, 0x8c, 0x13, 0xa7, 0xa3, 0xa8, 0x43, 0x3a, 0x1f, 0xb0, 0x6c, 0x1a, 0xf0, 0x18, 0x13, 0x19,
	0x15, 0xcd, 0x73, 0xf0, 0x10, 0x49, 0x53, 0x2a, 0x99, 0x7c, 0xfc, 0x1e, 0x51, 0x71, 0x80, 0xa9,
	0xe5, 0x72, 0x07, 0x0e, 0xce, 0x63, 0xf2, 0x36, 0x97, 0x86, 0x59, 0xd8, 0x67, 0xbb, 0x90, 0x18,
	0x7a, 0x29, 0x13, 0x9d, 0x0a, 0x5b, 0xe5, 0x88, 0x6d, 0x78, 0xcb, 0x26, 0xf8, 0x1d, 0x00, 0x8f,
	0xcd, 0x92, 0xda, 0xcc, 0xba, 0x7e, 0x52, 0x86, 0xaf, 0xc0, 0x1e, 0xfb, 0x0d, 0x54, 0x83, 0x09,
	0x2c, 0xd0, 0x13, 0x80, 0x0d, 0x26, 0x35, 0x4b, 0x53, 0x1e, 0xb4, 0xb0, 0x14, 0xde, 0x14, 0x33,
	0x6c, 0xcd, 0x22, 0x90, 0xcf, 0x07, 0xb6, 0x46, 0xfe, 0x2b, 0x1c, 0x3c, 0xe6, 0xe4, 0xd2, 0x41,
	0x13, 0xf4, 0xff, 0xfe, 0x94, 0xc7, 0xca, 0x42, 0x10, 0xc8, 0xc2, 0x2f, 0xc0, 0x63, 0x37, 0xb1,
	0x8a, 0x0f, 0x9e, 0x0b, 0xfe, 0xbf, 0x19, 0x38, 0xb0, 0xa8, 0xd7, 0xcb, 0xaf, 0x55, 0xd5, 0x96,
	0xbd, 0xfb, 0xc6, 0x9f, 0xe6, 0x42, 0x67, 0x30, 0x2e, 0xe6, 0x0c, 0xe6, 0x9f, 0xe3, 0x32, 0xbe,
	0x07, 0xf7, 0x1c, 0xc7, 0x1e, 0xd0, 0x7a, 0xa2, 0x0e, 0x68, 0xa1, 0xa3, 0xc8, 0xa1, 0x27, 0x3e,
	0x8a, 0xf4, 0x76, 0x7d, 0x14, 0x99, 0xfe, 0x0b, 0xd8, 0x17, 0x3f, 0x01, 0xf0, 0x5c, 0x3c, 0x87,
	0x3e, 0x5b, 0x93, 0x11, 0xc7, 0x09, 0xec, 0xce, 0x9a, 0xa5, 0x1d, 0xef, 0x79, 0x17, 0x5d, 0x49,
	0x3c, 0x58, 0xc4, 0x18, 0x5d, 0x68, 0x3b, 0x62, 0xc4, 0x00, 0xaf, 0x77, 0x3e, 0x6c, 0x44, 0x5b,
	0xf2, 0xdf, 0x03, 0xf0, 0x84, 0x5d, 0xf5, 0xbc, 0x8f, 0x32, 0x7d, 0x81, 0x05, 0x4b, 0xc6, 0x45,
	0xa2, 0xae, 0x31, 0x94, 0x86, 0x99, 0x03, 0xae, 0xcc, 0x5f, 0x02, 0x70, 0x38, 0x1c, 0x24, 0xad,
	0xcf, 0x37, 0x20, 0xf4, 0xbf, 0x8c, 0x16, 0xe9, 0x91, 0xe8, 0x9c, 0xf6, 0xa3, 0x63, 0x4c, 0x52,
	0x97, 0xeb, 0x55, 0x78, 0x7c, 0x1e, 0xfb, 0x11, 0xb8, 0x2c, 0xdd, 0x08, 0x24, 0x0c, 0xe5, 0x28,
	0x95, 0x7a, 0xe8, 0x86, 0xf8, 0x26, 0x80, 0xc3, 0x4e, 0xbd, 0x6e, 0xf3, 0x7d, 0x20, 0x2b, 0x30,
	0x03, 0xfb, 0xbc, 0xaf, 0xa5, 0x35, 0xaf, 0x13, 0x3f, 0x4e, 0xd6, 0xfa, 0x66, 0xfc, 0x47, 0x00,
	0x0e, 0x3b, 0xd5, 0xf8, 0xc0, 0xbf, 0xff, 0x20, 0xe2, 0x0b, 0x97, 0xd8, 0x4c, 0xf7, 0x07, 0x9d,
	0xbb, 0x70, 0xd8, 0x29, 0xb1, 0x07, 0xbf, 0xc0, 0x77, 0xe1, 0xf0, 0x3c, 0xb6, 0x66, 0x1b, 0x78,
	0x73, 0x19, 0x5b, 0x96, 0xa2, 0xd5, 0xcd, 0xc7, 0x73, 0x1d, 0xf0, 0xe0, 0xb8, 0xfe, 0x35, 0x80,
	0xcf, 0x38, 0xeb, 0x12, 0xe5, 0x3e, 0xb6, 0x96, 0x2f, 0xc0, 0xa3, 0xd5, 0x06, 0xde, 0x94, 0x4c,
	0x6a, 0x90, 0x40, 0x3b, 0xeb, 0xd7, 0x71, 0x31, 0x50, 0x65, 0x86, 0x1e, 0x8b, 0xf9, 0xe0, 0xe6,
	0xf6, 0x0e, 0x07, 0x07, 0xd8, 0xb7, 0xb4, 0x87, 0x9d, 0xf1, 0x7a, 0x57, 0x03, 0x9b, 0x0d, 0x53,
	0xda, 0xc4, 0xdb, 0xce, 0xa6, 0xe7, 0xa4, 0x29, 0xdc, 0x6c, 0x98, 0x9f, 0xc3, 0xdb, 0x64, 0x6b,
	0xbf, 0x0c, 0x91, 0x89, 0x8d, 0x2d, 0xa5, 0x8a, 0xdd, 0xba, 0x27, 0x29, 0x35, 0x7f, 0x27, 0xca,
	0x54, 0xb2, 0x74, 0x9a, 0xd6, 0xc9, 0x85, 0xda, 0xf4, 0x6f, 0xc1, 0xbe, 0xf8, 0x36, 0x48, 0x45,
	0x7a, 0xe4, 0xed, 0x31, 0xc0, 0x46, 0xf2, 0xed, 0x31, 0x00, 0x6d, 0xbf, 0x3d, 0x06, 0xa6, 0x53,
	0xdc, 0x1e, 0x59, 0x7c, 0x61, 0x19, 0x0e, 0x06, 0x1b, 0x5c, 0x68, 0x04, 0x9e, 0x5a, 0x5c, 0x98,
	0x2b, 0xcf, 0xde, 0x9d, 0x5d, 0x2c, 0x4b, 0xcb, 0x2b, 0xe2, 0x4a, 0x39, 0x74, 0x85, 0x86, 0xb0,
	0x57, 0x9c, 0x5d, 0x59, 0x58, 0x2d, 0x67, 0x01, 0x7a, 0x1a, 0x66, 0x6f, 0x96, 0x17, 0xcb, 0x2b,
	0x65, 0xa9, 0x52, 0x7e, 0xe5, 0x4e, 0x79, 0x79, 0xa5, 0x7c, 0x33, 0xcb, 0x09, 0x3f, 0xb9, 0x00,
	0x87, 0x66, 0x49, 0x97, 0x75, 0xd9, 0xa1, 0x6d, 0x55, 0x40, 0x1f, 0x72, 0xb0, 0x9f, 0xb9, 0x5c,
	0xa1, 0xb1, 0xc8, 0x56, 0x5b, 0xf8, 0x6a, 0x98, 0x1f, 0xef, 0x04, 0x73, 0xca, 0x39, 0xff, 0x1f,
	0xb0, 0x27, 0xd2, 0xca, 0xf5, 0xe5, 0x0f, 0xfe, 0xf4, 0x75, 0xee, 0xaf, 0x00, 0x9d, 0x2f, 0x6d,
	0x09, 0xa5, 0x1d, 0x67, 0xec, 0x33, 0x85, 0x52, 0x81, 0xe9, 0x51, 0x15, 0xbc, 0xde, 0xd4, 0xda,
	0x25, 0x74, 0x91, 0xc5, 0x79, 0x2b, 0x15, 0x03, 0x17, 0xd0, 0x73, 0x2c, 0x3c, 0xb8, 0x6e, 0x31,
	0x36, 0x53, 0xa8, 0xc0, 0xda, 0xb8, 0x0b, 0x18, 0x83, 0xbe, 0x8a, 0x04, 0x16, 0x1d, 0x5e, 0xcf,
	0x68, 0x2b, 0xf4, 0x73, 0x0e, 0xf6, 0x79, 0x37, 0x2e, 0x74, 0x2e, 0x82, 0xb5, 0xf0, 0x7d, 0x2c,
	0x9f, 0x78, 0x21, 0xe4, 0x3f, 0x01, 0x84, 0xc7, 0x3f, 0xba, 0x3c, 0xda, 0x99, 0x13, 0x66, 0xd1,
	0x6b, 0xf0, 0x15, 0x76, 0x3d, 0x1e, 0x09, 0x2e, 0x9a, 0x45, 0x16, 0xee, 0xf2, 0x48, 0xe0, 0x09,
	0x2c, 0xb2, 0x36, 0x2e, 0x8f, 0xc4, 0x26, 0x92, 0x45, 0x16, 0x3d, 0x81, 0xc6, 0x7d, 0x74, 0x3b,
	0x8b, 0x3e, 0x12, 0xfd, 0x9d, 0x83, 0x03, 0xec, 0xfd, 0x1b, 0x45, 0x89, 0x2e, 0xe2, 0x82, 0xde,
	0x81, 0xc1, 0xd7, 0x39, 0xc2, 0xe0, 0x37, 0x38, 0x21, 0x15, 0x83, 0xd3, 0xf4, 0xf6, 0xbd, 0xf6,
	0x29, 0xa1, 0x1b, 0x26, 0x3d, 0xb3, 0x69, 0xa1, 0x6b, 0x46, 0x3d, 0xdb, 0xab, 0x42, 0x17, 0xcc,
	0x7a, 0x56, 0x2f, 0x08, 0x42, 0x12, 0xc3, 0xc9, 0xd6, 0xe8, 0xab, 0x1c, 0xec, 0xf3, 0xae, 0xcd,
	0x91, 0x8a, 0x0d, 0x5f, 0xf7, 0xf3, 0xe7, 0x93, 0x41, 0xb4, 0x14, 0xfc, 0x34, 0x54, 0x0a, 0xbe,
	0x0f, 0xd0, 0x70, 0xa8, 0x14, 0xd0, 0x16, 0xda, 0xda, 0x08, 0x7a, 0x36, 0x3a, 0xf9, 0x5d, 0xc0,
	0x79, 0xc4, 0x27, 0xa4, 0xbb, 0x8b, 0x3a, 0x83, 0x4e, 0x47, 0x26, 0xb8, 0x3b, 0x3f, 0x1e, 0xac,
	0x45, 0x6d, 0x54, 0x51, 0x1c, 0x7a, 0x83, 0x83, 0x87, 0xe9, 0xd5, 0x1e, 0x9d, 0x8d, 0x4e, 0x61,
	0xe6, 0x26, 0x97, 0x4f, 0xb8, 0x82, 0xf2, 0x1f, 0x80, 0x3d, 0xd1, 0xbf, 0xe7, 0x11, 0x1e, 0xde,
	0x06, 0xe8, 0x14, 0x09, 0xc3, 0x1b, 0x26, 0x6a, 0x74, 0x9a, 0x89, 0x85, 0x5d, 0xef, 0x5b, 0xfd,
	0x69, 0x46, 0x7c, 0x1e, 0x6a, 0x12, 0x5d, 0x08, 0xa1, 0xc2, 0x5a, 0xf3, 0xa0, 0xe7, 0xd0, 0xd9,
	0x10, 0xd4, 0x97, 0x96, 0x07, 0xba, 0x88, 0x26, 0x43, 0xa0, 0x76, 0x25, 0xb9, 0x60, 0xf4, 0x23,
	0x0e, 0x42, 0xbf, 0x47, 0x81, 0xa2, 0xf4, 0xd0, 0xd6, 0xc2, 0x48, 0xa4, 0x69, 0x0f, 0xec, 0x89,
	0xfd, 0xce, 0xb2, 0x4c, 0xd9, 0x6f, 0x21, 0x44, 0xfd, 0x0e, 0xf0, 0x31, 0x82, 0x99, 0x26, 0x97,
	0xfa, 0xb5, 0x31, 0x3e, 0x59, 0x36, 0x14, 0x56, 0xe0, 0x53, 0x88, 0x87, 0x62, 0xcf, 0xf3, 0x89,
	0x12, 0xa2, 0xa8, 0x29, 0x3e, 0x95, 0x90, 0x1c, 0x34, 0xfa, 0x4e, 0x0f, 0x84, 0x7e, 0x2f, 0x24,
	0x92, 0xad, 0xb6, 0x56, 0x49, 0x22, 0x5b, 0xef, 0x65, 0xf6, 0xc4, 0xbc, 0xb7, 0x50, 0x84, 0xb0,
	0x29, 0xe6, 0x14, 0xb7, 0x27, 0x0e, 0x06, 0x27, 0x09, 0x9b, 0xdf, 0xca, 0xe4, 0x93, 0x64, 0xe7,
	0x72, 0x95, 0x4f, 0x21, 0x3e, 0x8a, 0x2d, 0xe5, 0xd3, 0x4a, 0x90, 0x1a, 0x4c, 0xe6, 0x3b, 0x0b,
	0x91, 0x42, 0x2f, 0xe7, 0xd3, 0xcb, 0xd1, 0x0d, 0x5d, 0xe8, 0x22, 0x74, 0xa1, 0xdb, 0xd0, 0x85,
	0xf4, 0xa1, 0x0b, 0xdd, 0x86, 0x8e, 0xbe, 0xcb, 0x41, 0xe8, 0x77, 0x88, 0x22, 0x15, 0xd2, 0xd6,
	0x40, 0xca, 0x0f, 0xb7, 0x9d, 0xd2, 0xcb, 0x8d, 0xa6, 0xb5, 0x1d, 0x5d, 0x72, 0x0a, 0xc9, 0x25,
	0xa7, 0x90, 0xaa, 0xe4, 0x14, 0xd2, 0x97, 0x9c, 0x42, 0x9a, 0x92, 0x53, 0xe8, 0xa2, 0xe4, 0xfc,
	0x8c, 0xb3, 0x4f, 0xc8, 0x6c, 0x0b, 0x01, 0x4d, 0xc4, 0x6c, 0x43, 0x6d, 0xad, 0x90, 0xfc, 0x64,
	0x0a, 0x24, 0xdd, 0xb5, 0xde, 0x0f, 0xed, 0x5a, 0x5e, 0xb5, 0x66, 0x8b, 0x90, 0xdf, 0x7e, 0x08,
	0xef, 0x4c, 0x6c, 0x0d, 0x62, 0x50, 0x6e, 0xb5, 0x8e, 0x2b, 0x41, 0x0c, 0xd4, 0xad, 0xd6, 0xed,
	0x15, 0x88, 0x01, 0xb9, 0xd5, 0x3a, 0xbe, 0x00, 0x31, 0x1d, 0x92, 0x1f, 0x70, 0x70, 0x80, 0x6d,
	0x7d, 0x44, 0x9e, 0xab, 0x22, 0x7a, 0x23, 0xf9, 0x4e, 0xf7, 0x78, 0xfe, 0x3d, 0xb0, 0x27, 0xf6,
	0xb4, 0x6f, 0x6c, 0x9e, 0xc0, 0x98, 0x9e, 0x15, 0xb3, 0xb1, 0x85, 0x05, 0x16, 0x44, 0xb9, 0x54,
	0x45, 0x0a, 0x2c, 0x08, 0x75, 0xa9, 0x0a, 0x09, 0x2c, 0x08, 0x72, 0xa9, 0x8a, 0x11, 0x58, 0x00,
	0x8c, 0xfe, 0xc6, 0xc1, 0xa1, 0x50, 0x33, 0x07, 0x4d, 0xc6, 0xee, 0x6e, 0xdd, 0x13, 0xf6, 0x35,
	0x6e, 0x4f, 0xcc, 0xd2, 0x7d, 0xce, 0x7b, 0x33, 0x21, 0xef, 0x1f, 0x80, 0x4f, 0xd2, 0xd9, 0xb4,
	0xdf, 0x2d, 0x59, 0x2b, 0xf1, 0x29, 0x24, 0xc7, 0x1a, 0x5c, 0xe5, 0xd3, 0xaa, 0x8f, 0xb5, 0x2a,
	0xf2, 0x9d, 0x85, 0xc8, 0xe2, 0xaf, 0xf1, 0xe9, 0x35, 0xc9, 0xd8, 0xa1, 0x7f, 0x73, 0x70, 0x28,
	0xd4, 0x9c, 0x8a, 0xe4, 0x3c, 0xba, 0x81, 0xd5, 0x99, 0xf3, 0x6f, 0x73, 0x7b, 0x62, 0x9e, 0xec,
	0x85, 0xde, 0x3b, 0xd9, 0xdd, 0x92, 0xb2, 0x2f, 0x24, 0x49, 0x37, 0xc0, 0xbe, 0x90, 0x42, 0xc5,
	0x01, 0xf6, 0x85, 0xb4, 0x82, 0x0e, 0xb0, 0x2f, 0x74, 0xd6, 0x76, 0x80, 0x7d, 0x21, 0xbd, 0xcc,
	0x59, 0xf6, 0xdf, 0xe2, 0xe0, 0x50, 0xa8, 0x73, 0x16, 0xc9, 0x7e, 0x74, 0x77, 0x2d, 0x76, 0x13,
	0x0a, 0x57, 0x86, 0x42, 0x72, 0x65, 0x28, 0xa4, 0xaa, 0x0c, 0x85, 0xf4, 0x95, 0xa1, 0x90, 0xa6,
	0x32, 0x14, 0xba, 0xa8, 0x0c, 0x3f, 0x06, 0x70, 0x28, 0xd4, 0x06, 0x8c, 0xe4, 0x29, 0xba, 0x55,
	0x98, 0xef, 0xd4, 0x9b, 0xe3, 0x6f, 0x11, 0xa2, 0x5e, 0x0a, 0x55, 0xd0, 0x60, 0x97, 0x28, 0xb1,
	0x36, 0x86, 0x1a, 0x50, 0xbf, 0x07, 0x10, 0xb5, 0xb7, 0x16, 0xd1, 0x54, 0x6c, 0x62, 0x3d, 0x56,
	0xd4, 0x2a, 0x89, 0x7a, 0x43, 0x48, 0x8a, 0x7a, 0x3a, 0xd8, 0xac, 0x5c, 0xbb, 0x2e, 0xa4, 0xfd,
	0x88, 0x90, 0x65, 0xfe, 0x23, 0xf0, 0xae, 0x38, 0x1c, 0xdd, 0xe8, 0xfb, 0x83, 0xf8, 0x1b, 0x70,
	0xdf, 0xb2, 0x9a, 0xe6, 0x74, 0xa9, 0xf4, 0xf0, 0xe1, 0xc3, 0x70, 0x1b, 0x50, 0x6e, 0x59, 0xf7,
	0x4b, 0x55, 0x55, 0x6f, 0xd5, 0x2e, 0x35, 0x55, 0xd9, 0xda, 0xd0, 0x8d, 0xc6, 0x54, 0x77, 0xf0,
	0xa2, 0x81, 0xe5, 0xda, 0x25, 0x5d, 0x53, 0xb7, 0x3b, 0x1a, 0xba, 0x11, 0xca, 0xb5, 0x86, 0xa2,
	0xa5, 0x46, 0xdb, 0xfe, 0x67, 0x7e, 0x99, 0xd9, 0x17, 0x5f, 0x85, 0x17, 0x63, 0x9a, 0x99, 0xb7,
	0x19, 0xb2, 0x16, 0xe9, 0xad, 0x1e, 0x5d, 0xee, 0xfa, 0x07, 0x69, 0xfb, 0xe2, 0x2d, 0x38, 0x16,
	0xf3, 0x8a, 0x39, 0x92, 0x2b, 0x9e, 0xf3, 0xb1, 0x54, 0xbf, 0x54, 0xdb, 0x17, 0xeb, 0xf0, 0x52,
	0x8c, 0xc3, 0x99, 0x40, 0x5e, 0x79, 0x8e, 0xaf, 0x3d, 0xde, 0x4f, 0xd9, 0xe0, 0x89, 0xaa, 0xde,
	0x68, 0x17, 0xe5, 0x0c, 0x5a, 0x74, 0x9e, 0x9d, 0x6e, 0xe7, 0x92, 0x5d, 0x8b, 0x96, 0xc0, 0xda,
	0x75, 0x0a, 0xac, 0xeb, 0xaa, 0xac, 0xd5, 0x8b, 0xba, 0x51, 0x2f, 0xd5, 0xb1, 0x46, 0x2a, 0x55,
	0xc9, 0x0f, 0x93, 0xf9, 0x6d, 0xea, 0xa7, 0xe9, 0xe3, 0x3f, 0x01, 0xf8, 0x21, 0x77, 0x72, 0xde,
	0xb1, 0x9e, 0xb5, 0x75, 0x50, 0xa4, 0x2f, 0x28, 0xae, 0x0a, 0xef, 0xba, 0x33, 0xf7, 0xc8, 0xcc,
	0x3d, 0x3a, 0x73, 0x6f, 0x55, 0x58, 0xef, 0x25, 0xbe, 0xaf, 0xfc, 0x2f, 0x00, 0x00, 0xff, 0xff,
	0x9f, 0x05, 0x14, 0xf4, 0xf6, 0x2a, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ConfigServiceV2Client is the client API for ConfigServiceV2 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ConfigServiceV2Client interface {
	// Lists buckets (Beta).
	ListBuckets(ctx context.Context, in *ListBucketsRequest, opts ...grpc.CallOption) (*ListBucketsResponse, error)
	// Gets a bucket (Beta).
	GetBucket(ctx context.Context, in *GetBucketRequest, opts ...grpc.CallOption) (*LogBucket, error)
	// Updates a bucket. This method replaces the following fields in the
	// existing bucket with values from the new bucket: `retention_period`
	//
	// If the retention period is decreased and the bucket is locked,
	// FAILED_PRECONDITION will be returned.
	//
	// If the bucket has a LifecycleState of DELETE_REQUESTED, FAILED_PRECONDITION
	// will be returned.
	//
	// A buckets region may not be modified after it is created.
	// This method is in Beta.
	UpdateBucket(ctx context.Context, in *UpdateBucketRequest, opts ...grpc.CallOption) (*LogBucket, error)
	// Lists sinks.
	ListSinks(ctx context.Context, in *ListSinksRequest, opts ...grpc.CallOption) (*ListSinksResponse, error)
	// Gets a sink.
	GetSink(ctx context.Context, in *GetSinkRequest, opts ...grpc.CallOption) (*LogSink, error)
	// Creates a sink that exports specified log entries to a destination. The
	// export of newly-ingested log entries begins immediately, unless the sink's
	// `writer_identity` is not permitted to write to the destination. A sink can
	// export log entries only from the resource owning the sink.
	CreateSink(ctx context.Context, in *CreateSinkRequest, opts ...grpc.CallOption) (*LogSink, error)
	// Updates a sink. This method replaces the following fields in the existing
	// sink with values from the new sink: `destination`, and `filter`.
	//
	// The updated sink might also have a new `writer_identity`; see the
	// `unique_writer_identity` field.
	UpdateSink(ctx context.Context, in *UpdateSinkRequest, opts ...grpc.CallOption) (*LogSink, error)
	// Deletes a sink. If the sink has a unique `writer_identity`, then that
	// service account is also deleted.
	DeleteSink(ctx context.Context, in *DeleteSinkRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists all the exclusions in a parent resource.
	ListExclusions(ctx context.Context, in *ListExclusionsRequest, opts ...grpc.CallOption) (*ListExclusionsResponse, error)
	// Gets the description of an exclusion.
	GetExclusion(ctx context.Context, in *GetExclusionRequest, opts ...grpc.CallOption) (*LogExclusion, error)
	// Creates a new exclusion in a specified parent resource.
	// Only log entries belonging to that resource can be excluded.
	// You can have up to 10 exclusions in a resource.
	CreateExclusion(ctx context.Context, in *CreateExclusionRequest, opts ...grpc.CallOption) (*LogExclusion, error)
	// Changes one or more properties of an existing exclusion.
	UpdateExclusion(ctx context.Context, in *UpdateExclusionRequest, opts ...grpc.CallOption) (*LogExclusion, error)
	// Deletes an exclusion.
	DeleteExclusion(ctx context.Context, in *DeleteExclusionRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Gets the Logs Router CMEK settings for the given resource.
	//
	// Note: CMEK for the Logs Router can currently only be configured for GCP
	// organizations. Once configured, it applies to all projects and folders in
	// the GCP organization.
	//
	// See [Enabling CMEK for Logs
	// Router](https://cloud.google.com/logging/docs/routing/managed-encryption) for more information.
	GetCmekSettings(ctx context.Context, in *GetCmekSettingsRequest, opts ...grpc.CallOption) (*CmekSettings, error)
	// Updates the Logs Router CMEK settings for the given resource.
	//
	// Note: CMEK for the Logs Router can currently only be configured for GCP
	// organizations. Once configured, it applies to all projects and folders in
	// the GCP organization.
	//
	// [UpdateCmekSettings][google.logging.v2.ConfigServiceV2.UpdateCmekSettings]
	// will fail if 1) `kms_key_name` is invalid, or 2) the associated service
	// account does not have the required
	// `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key, or
	// 3) access to the key is disabled.
	//
	// See [Enabling CMEK for Logs
	// Router](https://cloud.google.com/logging/docs/routing/managed-encryption) for more information.
	UpdateCmekSettings(ctx context.Context, in *UpdateCmekSettingsRequest, opts ...grpc.CallOption) (*CmekSettings, error)
}

type configServiceV2Client struct {
	cc grpc.ClientConnInterface
}

func NewConfigServiceV2Client(cc grpc.ClientConnInterface) ConfigServiceV2Client {
	return &configServiceV2Client{cc}
}

func (c *configServiceV2Client) ListBuckets(ctx context.Context, in *ListBucketsRequest, opts ...grpc.CallOption) (*ListBucketsResponse, error) {
	out := new(ListBucketsResponse)
	err := c.cc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/ListBuckets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) GetBucket(ctx context.Context, in *GetBucketRequest, opts ...grpc.CallOption) (*LogBucket, error) {
	out := new(LogBucket)
	err := c.cc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/GetBucket", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) UpdateBucket(ctx context.Context, in *UpdateBucketRequest, opts ...grpc.CallOption) (*LogBucket, error) {
	out := new(LogBucket)
	err := c.cc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/UpdateBucket", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) ListSinks(ctx context.Context, in *ListSinksRequest, opts ...grpc.CallOption) (*ListSinksResponse, error) {
	out := new(ListSinksResponse)
	err := c.cc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/ListSinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) GetSink(ctx context.Context, in *GetSinkRequest, opts ...grpc.CallOption) (*LogSink, error) {
	out := new(LogSink)
	err := c.cc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/GetSink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) CreateSink(ctx context.Context, in *CreateSinkRequest, opts ...grpc.CallOption) (*LogSink, error) {
	out := new(LogSink)
	err := c.cc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/CreateSink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) UpdateSink(ctx context.Context, in *UpdateSinkRequest, opts ...grpc.CallOption) (*LogSink, error) {
	out := new(LogSink)
	err := c.cc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/UpdateSink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) DeleteSink(ctx context.Context, in *DeleteSinkRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/DeleteSink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) ListExclusions(ctx context.Context, in *ListExclusionsRequest, opts ...grpc.CallOption) (*ListExclusionsResponse, error) {
	out := new(ListExclusionsResponse)
	err := c.cc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/ListExclusions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) GetExclusion(ctx context.Context, in *GetExclusionRequest, opts ...grpc.CallOption) (*LogExclusion, error) {
	out := new(LogExclusion)
	err := c.cc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/GetExclusion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) CreateExclusion(ctx context.Context, in *CreateExclusionRequest, opts ...grpc.CallOption) (*LogExclusion, error) {
	out := new(LogExclusion)
	err := c.cc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/CreateExclusion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) UpdateExclusion(ctx context.Context, in *UpdateExclusionRequest, opts ...grpc.CallOption) (*LogExclusion, error) {
	out := new(LogExclusion)
	err := c.cc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/UpdateExclusion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) DeleteExclusion(ctx context.Context, in *DeleteExclusionRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/DeleteExclusion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) GetCmekSettings(ctx context.Context, in *GetCmekSettingsRequest, opts ...grpc.CallOption) (*CmekSettings, error) {
	out := new(CmekSettings)
	err := c.cc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/GetCmekSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) UpdateCmekSettings(ctx context.Context, in *UpdateCmekSettingsRequest, opts ...grpc.CallOption) (*CmekSettings, error) {
	out := new(CmekSettings)
	err := c.cc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/UpdateCmekSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConfigServiceV2Server is the server API for ConfigServiceV2 service.
type ConfigServiceV2Server interface {
	// Lists buckets (Beta).
	ListBuckets(context.Context, *ListBucketsRequest) (*ListBucketsResponse, error)
	// Gets a bucket (Beta).
	GetBucket(context.Context, *GetBucketRequest) (*LogBucket, error)
	// Updates a bucket. This method replaces the following fields in the
	// existing bucket with values from the new bucket: `retention_period`
	//
	// If the retention period is decreased and the bucket is locked,
	// FAILED_PRECONDITION will be returned.
	//
	// If the bucket has a LifecycleState of DELETE_REQUESTED, FAILED_PRECONDITION
	// will be returned.
	//
	// A buckets region may not be modified after it is created.
	// This method is in Beta.
	UpdateBucket(context.Context, *UpdateBucketRequest) (*LogBucket, error)
	// Lists sinks.
	ListSinks(context.Context, *ListSinksRequest) (*ListSinksResponse, error)
	// Gets a sink.
	GetSink(context.Context, *GetSinkRequest) (*LogSink, error)
	// Creates a sink that exports specified log entries to a destination. The
	// export of newly-ingested log entries begins immediately, unless the sink's
	// `writer_identity` is not permitted to write to the destination. A sink can
	// export log entries only from the resource owning the sink.
	CreateSink(context.Context, *CreateSinkRequest) (*LogSink, error)
	// Updates a sink. This method replaces the following fields in the existing
	// sink with values from the new sink: `destination`, and `filter`.
	//
	// The updated sink might also have a new `writer_identity`; see the
	// `unique_writer_identity` field.
	UpdateSink(context.Context, *UpdateSinkRequest) (*LogSink, error)
	// Deletes a sink. If the sink has a unique `writer_identity`, then that
	// service account is also deleted.
	DeleteSink(context.Context, *DeleteSinkRequest) (*empty.Empty, error)
	// Lists all the exclusions in a parent resource.
	ListExclusions(context.Context, *ListExclusionsRequest) (*ListExclusionsResponse, error)
	// Gets the description of an exclusion.
	GetExclusion(context.Context, *GetExclusionRequest) (*LogExclusion, error)
	// Creates a new exclusion in a specified parent resource.
	// Only log entries belonging to that resource can be excluded.
	// You can have up to 10 exclusions in a resource.
	CreateExclusion(context.Context, *CreateExclusionRequest) (*LogExclusion, error)
	// Changes one or more properties of an existing exclusion.
	UpdateExclusion(context.Context, *UpdateExclusionRequest) (*LogExclusion, error)
	// Deletes an exclusion.
	DeleteExclusion(context.Context, *DeleteExclusionRequest) (*empty.Empty, error)
	// Gets the Logs Router CMEK settings for the given resource.
	//
	// Note: CMEK for the Logs Router can currently only be configured for GCP
	// organizations. Once configured, it applies to all projects and folders in
	// the GCP organization.
	//
	// See [Enabling CMEK for Logs
	// Router](https://cloud.google.com/logging/docs/routing/managed-encryption) for more information.
	GetCmekSettings(context.Context, *GetCmekSettingsRequest) (*CmekSettings, error)
	// Updates the Logs Router CMEK settings for the given resource.
	//
	// Note: CMEK for the Logs Router can currently only be configured for GCP
	// organizations. Once configured, it applies to all projects and folders in
	// the GCP organization.
	//
	// [UpdateCmekSettings][google.logging.v2.ConfigServiceV2.UpdateCmekSettings]
	// will fail if 1) `kms_key_name` is invalid, or 2) the associated service
	// account does not have the required
	// `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key, or
	// 3) access to the key is disabled.
	//
	// See [Enabling CMEK for Logs
	// Router](https://cloud.google.com/logging/docs/routing/managed-encryption) for more information.
	UpdateCmekSettings(context.Context, *UpdateCmekSettingsRequest) (*CmekSettings, error)
}

// UnimplementedConfigServiceV2Server can be embedded to have forward compatible implementations.
type UnimplementedConfigServiceV2Server struct {
}

func (*UnimplementedConfigServiceV2Server) ListBuckets(ctx context.Context, req *ListBucketsRequest) (*ListBucketsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBuckets not implemented")
}
func (*UnimplementedConfigServiceV2Server) GetBucket(ctx context.Context, req *GetBucketRequest) (*LogBucket, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBucket not implemented")
}
func (*UnimplementedConfigServiceV2Server) UpdateBucket(ctx context.Context, req *UpdateBucketRequest) (*LogBucket, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBucket not implemented")
}
func (*UnimplementedConfigServiceV2Server) ListSinks(ctx context.Context, req *ListSinksRequest) (*ListSinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSinks not implemented")
}
func (*UnimplementedConfigServiceV2Server) GetSink(ctx context.Context, req *GetSinkRequest) (*LogSink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSink not implemented")
}
func (*UnimplementedConfigServiceV2Server) CreateSink(ctx context.Context, req *CreateSinkRequest) (*LogSink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSink not implemented")
}
func (*UnimplementedConfigServiceV2Server) UpdateSink(ctx context.Context, req *UpdateSinkRequest) (*LogSink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSink not implemented")
}
func (*UnimplementedConfigServiceV2Server) DeleteSink(ctx context.Context, req *DeleteSinkRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSink not implemented")
}
func (*UnimplementedConfigServiceV2Server) ListExclusions(ctx context.Context, req *ListExclusionsRequest) (*ListExclusionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListExclusions not implemented")
}
func (*UnimplementedConfigServiceV2Server) GetExclusion(ctx context.Context, req *GetExclusionRequest) (*LogExclusion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetExclusion not implemented")
}
func (*UnimplementedConfigServiceV2Server) CreateExclusion(ctx context.Context, req *CreateExclusionRequest) (*LogExclusion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateExclusion not implemented")
}
func (*UnimplementedConfigServiceV2Server) UpdateExclusion(ctx context.Context, req *UpdateExclusionRequest) (*LogExclusion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateExclusion not implemented")
}
func (*UnimplementedConfigServiceV2Server) DeleteExclusion(ctx context.Context, req *DeleteExclusionRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteExclusion not implemented")
}
func (*UnimplementedConfigServiceV2Server) GetCmekSettings(ctx context.Context, req *GetCmekSettingsRequest) (*CmekSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCmekSettings not implemented")
}
func (*UnimplementedConfigServiceV2Server) UpdateCmekSettings(ctx context.Context, req *UpdateCmekSettingsRequest) (*CmekSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCmekSettings not implemented")
}

func RegisterConfigServiceV2Server(s *grpc.Server, srv ConfigServiceV2Server) {
	s.RegisterService(&_ConfigServiceV2_serviceDesc, srv)
}

func _ConfigServiceV2_ListBuckets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBucketsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).ListBuckets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/ListBuckets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).ListBuckets(ctx, req.(*ListBucketsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_GetBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).GetBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/GetBucket",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).GetBucket(ctx, req.(*GetBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_UpdateBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).UpdateBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/UpdateBucket",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).UpdateBucket(ctx, req.(*UpdateBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_ListSinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).ListSinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/ListSinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).ListSinks(ctx, req.(*ListSinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_GetSink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).GetSink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/GetSink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).GetSink(ctx, req.(*GetSinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_CreateSink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).CreateSink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/CreateSink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).CreateSink(ctx, req.(*CreateSinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_UpdateSink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).UpdateSink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/UpdateSink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).UpdateSink(ctx, req.(*UpdateSinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_DeleteSink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).DeleteSink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/DeleteSink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).DeleteSink(ctx, req.(*DeleteSinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_ListExclusions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListExclusionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).ListExclusions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/ListExclusions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).ListExclusions(ctx, req.(*ListExclusionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_GetExclusion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetExclusionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).GetExclusion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/GetExclusion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).GetExclusion(ctx, req.(*GetExclusionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_CreateExclusion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateExclusionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).CreateExclusion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/CreateExclusion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).CreateExclusion(ctx, req.(*CreateExclusionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_UpdateExclusion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateExclusionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).UpdateExclusion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/UpdateExclusion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).UpdateExclusion(ctx, req.(*UpdateExclusionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_DeleteExclusion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteExclusionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).DeleteExclusion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/DeleteExclusion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).DeleteExclusion(ctx, req.(*DeleteExclusionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_GetCmekSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCmekSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).GetCmekSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/GetCmekSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).GetCmekSettings(ctx, req.(*GetCmekSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_UpdateCmekSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCmekSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).UpdateCmekSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/UpdateCmekSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).UpdateCmekSettings(ctx, req.(*UpdateCmekSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ConfigServiceV2_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.logging.v2.ConfigServiceV2",
	HandlerType: (*ConfigServiceV2Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListBuckets",
			Handler:    _ConfigServiceV2_ListBuckets_Handler,
		},
		{
			MethodName: "GetBucket",
			Handler:    _ConfigServiceV2_GetBucket_Handler,
		},
		{
			MethodName: "UpdateBucket",
			Handler:    _ConfigServiceV2_UpdateBucket_Handler,
		},
		{
			MethodName: "ListSinks",
			Handler:    _ConfigServiceV2_ListSinks_Handler,
		},
		{
			MethodName: "GetSink",
			Handler:    _ConfigServiceV2_GetSink_Handler,
		},
		{
			MethodName: "CreateSink",
			Handler:    _ConfigServiceV2_CreateSink_Handler,
		},
		{
			MethodName: "UpdateSink",
			Handler:    _ConfigServiceV2_UpdateSink_Handler,
		},
		{
			MethodName: "DeleteSink",
			Handler:    _ConfigServiceV2_DeleteSink_Handler,
		},
		{
			MethodName: "ListExclusions",
			Handler:    _ConfigServiceV2_ListExclusions_Handler,
		},
		{
			MethodName: "GetExclusion",
			Handler:    _ConfigServiceV2_GetExclusion_Handler,
		},
		{
			MethodName: "CreateExclusion",
			Handler:    _ConfigServiceV2_CreateExclusion_Handler,
		},
		{
			MethodName: "UpdateExclusion",
			Handler:    _ConfigServiceV2_UpdateExclusion_Handler,
		},
		{
			MethodName: "DeleteExclusion",
			Handler:    _ConfigServiceV2_DeleteExclusion_Handler,
		},
		{
			MethodName: "GetCmekSettings",
			Handler:    _ConfigServiceV2_GetCmekSettings_Handler,
		},
		{
			MethodName: "UpdateCmekSettings",
			Handler:    _ConfigServiceV2_UpdateCmekSettings_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/logging/v2/logging_config.proto",
}
