#include "xflens/cxxlapack/netlib/netlib.h"

#ifndef INTEGER
#    ifndef MKL_ILP64
typedef int INTEGER;
#    else
typedef long INTEGER;
#    endif
#endif

#ifndef FLOAT
typedef float FLOAT;
#endif

#ifndef DOUBLE
typedef double DOUBLE;
#endif

#ifndef FLOAT_COMPLEX
typedef float FLOAT_COMPLEX;
#endif

#ifndef DOUBLE_COMPLEX
typedef double DOUBLE_COMPLEX;
#endif

#ifndef LOGICAL
typedef int LOGICAL;
#endif

#ifndef UNKNOWN
typedef void UNKNOWN;
#endif

//-- cbbcsd --------------------------------------------------------------------
void
LAPACK_IMPL(cbbcsd)(const char       *JOBU1,
                    const char       *JOBU2,
                    const char       *JOBV1T,
                    const char       *JOBV2T,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *Q,
                    FLOAT            *THETA,
                    FLOAT            *PHI,
                    FLOAT_COMPLEX    *U1,
                    const INTEGER    *LDU1,
                    FLOAT_COMPLEX    *U2,
                    const INTEGER    *LDU2,
                    FLOAT_COMPLEX    *V1T,
                    const INTEGER    *LDV1T,
                    FLOAT_COMPLEX    *V2T,
                    const INTEGER    *LDV2T,
                    FLOAT            *B11D,
                    FLOAT            *B11E,
                    FLOAT            *B12D,
                    FLOAT            *B12E,
                    const FLOAT      *B21D,
                    const FLOAT      *B21E,
                    const FLOAT      *B22D,
                    const FLOAT      *B22E,
                    FLOAT            *RWORK,
                    const INTEGER    *LRWORK,
                    INTEGER          *INFO);

//-- cbdsqr --------------------------------------------------------------------
void
LAPACK_IMPL(cbdsqr)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NCVT,
                    const INTEGER    *NRU,
                    const INTEGER    *NCC,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *VT,
                    const INTEGER    *LDVT,
                    FLOAT_COMPLEX    *U,
                    const INTEGER    *LDU,
                    FLOAT_COMPLEX    *C,
                    const INTEGER    *LDC,
                    FLOAT            *RWORK,
                    INTEGER          *INFO);

//-- cgbbrd --------------------------------------------------------------------
void
LAPACK_IMPL(cgbbrd)(const char       *VECT,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NCC,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    FLOAT_COMPLEX    *PT,
                    const INTEGER    *LDPT,
                    FLOAT_COMPLEX    *C,
                    const INTEGER    *LDC,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO);

//-- cgbcon --------------------------------------------------------------------
void
LAPACK_IMPL(cgbcon)(const char           *NORM,
                    const INTEGER        *N,
                    const INTEGER        *KL,
                    const INTEGER        *KU,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    const INTEGER        *IPIV,
                    const FLOAT          *ANORM,
                    FLOAT                *RCOND,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- cgbequ --------------------------------------------------------------------
void
LAPACK_IMPL(cgbequ)(const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *KL,
                    const INTEGER        *KU,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    FLOAT                *R,
                    FLOAT                *C,
                    FLOAT                *ROWCND,
                    FLOAT                *COLCND,
                    FLOAT                *AMAX,
                    INTEGER              *INFO);

//-- cgbequb -------------------------------------------------------------------
void
LAPACK_IMPL(cgbequb)(const INTEGER            *M,
                     const INTEGER            *N,
                     const INTEGER            *KL,
                     const INTEGER            *KU,
                     const FLOAT_COMPLEX      *AB,
                     const INTEGER            *LDAB,
                     FLOAT                    *R,
                     FLOAT                    *C,
                     FLOAT                    *ROWCND,
                     FLOAT                    *COLCND,
                     FLOAT                    *AMAX,
                     INTEGER                  *INFO);

//-- cgbrfs --------------------------------------------------------------------
void
LAPACK_IMPL(cgbrfs)(const char           *TRANS,
                    const INTEGER        *N,
                    const INTEGER        *KL,
                    const INTEGER        *KU,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    const FLOAT_COMPLEX  *AFB,
                    const INTEGER        *LDAFB,
                    const INTEGER        *IPIV,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- cgbrfsx -------------------------------------------------------------------
void
LAPACK_IMPL(cgbrfsx)(const char               *TRANS,
                     const char               *EQUED,
                     const INTEGER            *N,
                     const INTEGER            *KL,
                     const INTEGER            *KU,
                     const INTEGER            *NRHS,
                     const FLOAT_COMPLEX      *AB,
                     const INTEGER            *LDAB,
                     const FLOAT_COMPLEX      *AFB,
                     const INTEGER            *LDAFB,
                     const INTEGER            *IPIV,
                     FLOAT                    *R,
                     FLOAT                    *C,
                     const FLOAT_COMPLEX      *B,
                     const INTEGER            *LDB,
                     FLOAT_COMPLEX            *X,
                     const INTEGER            *LDX,
                     FLOAT                    *RCOND,
                     FLOAT                    *BERR,
                     const INTEGER            *N_ERR_BNDS,
                     FLOAT                    *ERR_BNDS_NORM,
                     FLOAT                    *ERR_BNDS_COMP,
                     const INTEGER            *NPARAMS,
                     FLOAT                    *PARAMS,
                     FLOAT_COMPLEX            *WORK,
                     FLOAT                    *RWORK,
                     INTEGER                  *INFO);

//-- cgbsv ---------------------------------------------------------------------
void
LAPACK_IMPL(cgbsv)(const INTEGER        *N,
                   const INTEGER        *KL,
                   const INTEGER        *KU,
                   const INTEGER        *NRHS,
                   FLOAT_COMPLEX        *AB,
                   const INTEGER        *LDAB,
                   INTEGER              *IPIV,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- cgbsvx --------------------------------------------------------------------
void
LAPACK_IMPL(cgbsvx)(const char       *FACT,
                    const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const INTEGER    *NRHS,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    FLOAT_COMPLEX    *AFB,
                    const INTEGER    *LDAFB,
                    INTEGER          *IPIV,
                    char             *EQUED,
                    FLOAT            *R,
                    FLOAT            *C,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *X,
                    const INTEGER    *LDX,
                    FLOAT            *RCOND,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO);

//-- cgbsvxx -------------------------------------------------------------------
void
LAPACK_IMPL(cgbsvxx)(const char       *FACT,
                     const char       *TRANS,
                     const INTEGER    *N,
                     const INTEGER    *KL,
                     const INTEGER    *KU,
                     const INTEGER    *NRHS,
                     FLOAT_COMPLEX    *AB,
                     const INTEGER    *LDAB,
                     FLOAT_COMPLEX    *AFB,
                     const INTEGER    *LDAFB,
                     INTEGER          *IPIV,
                     char             *EQUED,
                     FLOAT            *R,
                     FLOAT            *C,
                     FLOAT_COMPLEX    *B,
                     const INTEGER    *LDB,
                     FLOAT_COMPLEX    *X,
                     const INTEGER    *LDX,
                     FLOAT            *RCOND,
                     FLOAT            *RPVGRW,
                     FLOAT            *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     FLOAT            *ERR_BNDS_NORM,
                     FLOAT            *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     FLOAT            *PARAMS,
                     FLOAT_COMPLEX    *WORK,
                     FLOAT            *RWORK,
                     INTEGER          *INFO);

//-- cgbtf2 --------------------------------------------------------------------
void
LAPACK_IMPL(cgbtf2)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- cgbtrf --------------------------------------------------------------------
void
LAPACK_IMPL(cgbtrf)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- cgbtrs --------------------------------------------------------------------
void
LAPACK_IMPL(cgbtrs)(const char           *TRANS,
                    const INTEGER        *N,
                    const INTEGER        *KL,
                    const INTEGER        *KU,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    const INTEGER        *IPIV,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO);

//-- cgebak --------------------------------------------------------------------
void
LAPACK_IMPL(cgebak)(const char       *JOB,
                    const char       *SIDE,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    const FLOAT      *SCALE,
                    const INTEGER    *M,
                    FLOAT_COMPLEX    *V,
                    const INTEGER    *LDV,
                    INTEGER          *INFO);

//-- cgebal --------------------------------------------------------------------
void
LAPACK_IMPL(cgebal)(const char       *JOB,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    FLOAT            *SCALE,
                    INTEGER          *INFO);

//-- cgebd2 --------------------------------------------------------------------
void
LAPACK_IMPL(cgebd2)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *TAUQ,
                    FLOAT_COMPLEX    *TAUP,
                    FLOAT_COMPLEX    *WORK,
                    INTEGER          *INFO);

//-- cgebrd --------------------------------------------------------------------
void
LAPACK_IMPL(cgebrd)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *TAUQ,
                    FLOAT_COMPLEX    *TAUP,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- cgecon --------------------------------------------------------------------
void
LAPACK_IMPL(cgecon)(const char           *NORM,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT          *ANORM,
                    FLOAT                *RCOND,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- cgeequ --------------------------------------------------------------------
void
LAPACK_IMPL(cgeequ)(const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT                *R,
                    FLOAT                *C,
                    FLOAT                *ROWCND,
                    FLOAT                *COLCND,
                    FLOAT                *AMAX,
                    INTEGER              *INFO);

//-- cgeequb -------------------------------------------------------------------
void
LAPACK_IMPL(cgeequb)(const INTEGER            *M,
                     const INTEGER            *N,
                     const FLOAT_COMPLEX      *A,
                     const INTEGER            *LDA,
                     FLOAT                    *R,
                     FLOAT                    *C,
                     FLOAT                    *ROWCND,
                     FLOAT                    *COLCND,
                     FLOAT                    *AMAX,
                     INTEGER                  *INFO);

//-- cgees ---------------------------------------------------------------------
void
LAPACK_IMPL(cgees)(const char           *JOBVS,
                   const char           *SORT,
                   LOGICAL              (*SELECT)(const FLOAT_COMPLEX *),
                   const INTEGER        *N,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA,
                   INTEGER              *SDIM,
                   FLOAT_COMPLEX        *W,
                   FLOAT_COMPLEX        *VS,
                   const INTEGER        *LDVS,
                   FLOAT_COMPLEX        *WORK,
                   const INTEGER        *LWORK,
                   FLOAT                *RWORK,
                   LOGICAL              *BWORK,
                   INTEGER              *INFO);

//-- cgeesx --------------------------------------------------------------------
void
LAPACK_IMPL(cgeesx)(const char       *JOBVS,
                    const char       *SORT,
                    LOGICAL          (*SELECT)(const FLOAT_COMPLEX *),
                    const char       *SENSE,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *SDIM,
                    FLOAT_COMPLEX    *W,
                    FLOAT_COMPLEX    *VS,
                    const INTEGER    *LDVS,
                    FLOAT            *RCONDE,
                    FLOAT            *RCONDV,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    LOGICAL          *BWORK,
                    INTEGER          *INFO);

//-- cgeev ---------------------------------------------------------------------
void
LAPACK_IMPL(cgeev)(const char           *JOBVL,
                   const char           *JOBVR,
                   const INTEGER        *N,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA,
                   FLOAT_COMPLEX        *W,
                   FLOAT_COMPLEX        *VL,
                   const INTEGER        *LDVL,
                   FLOAT_COMPLEX        *VR,
                   const INTEGER        *LDVR,
                   FLOAT_COMPLEX        *WORK,
                   const INTEGER        *LWORK,
                   FLOAT                *RWORK,
                   INTEGER              *INFO);

//-- cgeevx --------------------------------------------------------------------
void
LAPACK_IMPL(cgeevx)(const char       *BALANC,
                    const char       *JOBVL,
                    const char       *JOBVR,
                    const char       *SENSE,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *W,
                    FLOAT_COMPLEX    *VL,
                    const INTEGER    *LDVL,
                    FLOAT_COMPLEX    *VR,
                    const INTEGER    *LDVR,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    FLOAT            *SCALE,
                    FLOAT            *ABNRM,
                    FLOAT            *RCONDE,
                    FLOAT            *RCONDV,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO);

//-- cgegs ---------------------------------------------------------------------
void
LAPACK_IMPL(cgegs)(const char           *JOBVSL,
                   const char           *JOBVSR,
                   const INTEGER        *N,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   FLOAT_COMPLEX        *ALPHA,
                   FLOAT_COMPLEX        *BETA,
                   FLOAT_COMPLEX        *VSL,
                   const INTEGER        *LDVSL,
                   FLOAT_COMPLEX        *VSR,
                   const INTEGER        *LDVSR,
                   FLOAT_COMPLEX        *WORK,
                   const INTEGER        *LWORK,
                   FLOAT                *RWORK,
                   INTEGER              *INFO);

//-- cgegv ---------------------------------------------------------------------
void
LAPACK_IMPL(cgegv)(const char           *JOBVL,
                   const char           *JOBVR,
                   const INTEGER        *N,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   FLOAT_COMPLEX        *ALPHA,
                   FLOAT_COMPLEX        *BETA,
                   FLOAT_COMPLEX        *VL,
                   const INTEGER        *LDVL,
                   FLOAT_COMPLEX        *VR,
                   const INTEGER        *LDVR,
                   FLOAT_COMPLEX        *WORK,
                   const INTEGER        *LWORK,
                   FLOAT                *RWORK,
                   INTEGER              *INFO);

//-- cgehd2 --------------------------------------------------------------------
void
LAPACK_IMPL(cgehd2)(const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    INTEGER          *INFO);

//-- cgehrd --------------------------------------------------------------------
void
LAPACK_IMPL(cgehrd)(const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- cgelq2 --------------------------------------------------------------------
void
LAPACK_IMPL(cgelq2)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    INTEGER          *INFO);

//-- cgelqf --------------------------------------------------------------------
void
LAPACK_IMPL(cgelqf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- cgels ---------------------------------------------------------------------
void
LAPACK_IMPL(cgels)(const char           *TRANS,
                   const INTEGER        *M,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   FLOAT_COMPLEX        *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO);

//-- cgelsd --------------------------------------------------------------------
void
LAPACK_IMPL(cgelsd)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT            *S,
                    const FLOAT      *RCOND,
                    INTEGER          *RANK,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- cgelss --------------------------------------------------------------------
void
LAPACK_IMPL(cgelss)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT            *S,
                    const FLOAT      *RCOND,
                    INTEGER          *RANK,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO);

//-- cgelsx --------------------------------------------------------------------
void
LAPACK_IMPL(cgelsx)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    INTEGER          *JPVT,
                    const FLOAT      *RCOND,
                    INTEGER          *RANK,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO);

//-- cgelsy --------------------------------------------------------------------
void
LAPACK_IMPL(cgelsy)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    INTEGER          *JPVT,
                    const FLOAT      *RCOND,
                    INTEGER          *RANK,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO);

//-- cgeql2 --------------------------------------------------------------------
void
LAPACK_IMPL(cgeql2)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    INTEGER          *INFO);

//-- cgeqlf --------------------------------------------------------------------
void
LAPACK_IMPL(cgeqlf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- cgeqp3 --------------------------------------------------------------------
void
LAPACK_IMPL(cgeqp3)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO);

//-- cgeqpf --------------------------------------------------------------------
void
LAPACK_IMPL(cgeqpf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO);

//-- cgeqr2 --------------------------------------------------------------------
void
LAPACK_IMPL(cgeqr2)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    INTEGER          *INFO);

//-- cgeqr2p -------------------------------------------------------------------
void
LAPACK_IMPL(cgeqr2p)(const INTEGER    *M,
                     const INTEGER    *N,
                     FLOAT_COMPLEX    *A,
                     const INTEGER    *LDA,
                     FLOAT_COMPLEX    *TAU,
                     FLOAT_COMPLEX    *WORK,
                     INTEGER          *INFO);

//-- cgeqrf --------------------------------------------------------------------
void
LAPACK_IMPL(cgeqrf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- cgeqrfp -------------------------------------------------------------------
void
LAPACK_IMPL(cgeqrfp)(const INTEGER    *M,
                     const INTEGER    *N,
                     FLOAT_COMPLEX    *A,
                     const INTEGER    *LDA,
                     FLOAT_COMPLEX    *TAU,
                     FLOAT_COMPLEX    *WORK,
                     const INTEGER    *LWORK,
                     INTEGER          *INFO);

//-- cgerfs --------------------------------------------------------------------
void
LAPACK_IMPL(cgerfs)(const char           *TRANS,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *AF,
                    const INTEGER        *LDAF,
                    const INTEGER        *IPIV,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- cgerfsx -------------------------------------------------------------------
void
LAPACK_IMPL(cgerfsx)(const char               *TRANS,
                     const char               *EQUED,
                     const INTEGER            *N,
                     const INTEGER            *NRHS,
                     const FLOAT_COMPLEX      *A,
                     const INTEGER            *LDA,
                     const FLOAT_COMPLEX      *AF,
                     const INTEGER            *LDAF,
                     const INTEGER            *IPIV,
                     const FLOAT              *R,
                     const FLOAT              *C,
                     const FLOAT_COMPLEX      *B,
                     const INTEGER            *LDB,
                     FLOAT_COMPLEX            *X,
                     const INTEGER            *LDX,
                     FLOAT                    *RCOND,
                     FLOAT                    *BERR,
                     const INTEGER            *N_ERR_BNDS,
                     FLOAT                    *ERR_BNDS_NORM,
                     FLOAT                    *ERR_BNDS_COMP,
                     const INTEGER            *NPARAMS,
                     FLOAT                    *PARAMS,
                     FLOAT_COMPLEX            *WORK,
                     FLOAT                    *RWORK,
                     INTEGER                  *INFO);

//-- cgerq2 --------------------------------------------------------------------
void
LAPACK_IMPL(cgerq2)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    INTEGER          *INFO);

//-- cgerqf --------------------------------------------------------------------
void
LAPACK_IMPL(cgerqf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- cgesc2 --------------------------------------------------------------------
void
LAPACK_IMPL(cgesc2)(const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT_COMPLEX        *RHS,
                    const INTEGER        *IPIV,
                    const INTEGER        *JPIV,
                    FLOAT                *SCALE);

//-- cgesdd --------------------------------------------------------------------
void
LAPACK_IMPL(cgesdd)(const char       *JOBZ,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT            *S,
                    FLOAT_COMPLEX    *U,
                    const INTEGER    *LDU,
                    FLOAT_COMPLEX    *VT,
                    const INTEGER    *LDVT,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- cgesv ---------------------------------------------------------------------
void
LAPACK_IMPL(cgesv)(const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA,
                   INTEGER              *IPIV,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- cgesvd --------------------------------------------------------------------
void
LAPACK_IMPL(cgesvd)(const char       *JOBU,
                    const char       *JOBVT,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT            *S,
                    FLOAT_COMPLEX    *U,
                    const INTEGER    *LDU,
                    FLOAT_COMPLEX    *VT,
                    const INTEGER    *LDVT,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO);

//-- cgesvx --------------------------------------------------------------------
void
LAPACK_IMPL(cgesvx)(const char       *FACT,
                    const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *AF,
                    const INTEGER    *LDAF,
                    INTEGER          *IPIV,
                    char             *EQUED,
                    FLOAT            *R,
                    FLOAT            *C,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *X,
                    const INTEGER    *LDX,
                    FLOAT            *RCOND,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO);

//-- cgesvxx -------------------------------------------------------------------
void
LAPACK_IMPL(cgesvxx)(const char       *FACT,
                     const char       *TRANS,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     FLOAT_COMPLEX    *A,
                     const INTEGER    *LDA,
                     FLOAT_COMPLEX    *AF,
                     const INTEGER    *LDAF,
                     INTEGER          *IPIV,
                     char             *EQUED,
                     FLOAT            *R,
                     FLOAT            *C,
                     FLOAT_COMPLEX    *B,
                     const INTEGER    *LDB,
                     FLOAT_COMPLEX    *X,
                     const INTEGER    *LDX,
                     FLOAT            *RCOND,
                     FLOAT            *RPVGRW,
                     FLOAT            *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     FLOAT            *ERR_BNDS_NORM,
                     FLOAT            *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     FLOAT            *PARAMS,
                     FLOAT_COMPLEX    *WORK,
                     FLOAT            *RWORK,
                     INTEGER          *INFO);

//-- cgetc2 --------------------------------------------------------------------
void
LAPACK_IMPL(cgetc2)(const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *JPIV,
                    INTEGER          *INFO);

//-- cgetf2 --------------------------------------------------------------------
void
LAPACK_IMPL(cgetf2)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- cgetrf --------------------------------------------------------------------
void
LAPACK_IMPL(cgetrf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- cgetri --------------------------------------------------------------------
void
LAPACK_IMPL(cgetri)(const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    const INTEGER    *IPIV,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- cgetrs --------------------------------------------------------------------
void
LAPACK_IMPL(cgetrs)(const char           *TRANS,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const INTEGER        *IPIV,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO);

//-- cggbak --------------------------------------------------------------------
void
LAPACK_IMPL(cggbak)(const char       *JOB,
                    const char       *SIDE,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    const FLOAT      *LSCALE,
                    const FLOAT      *RSCALE,
                    const INTEGER    *M,
                    FLOAT_COMPLEX    *V,
                    const INTEGER    *LDV,
                    INTEGER          *INFO);

//-- cggbal --------------------------------------------------------------------
void
LAPACK_IMPL(cggbal)(const char       *JOB,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    FLOAT            *LSCALE,
                    FLOAT            *RSCALE,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- cgges ---------------------------------------------------------------------
void
LAPACK_IMPL(cgges)(const char           *JOBVSL,
                   const char           *JOBVSR,
                   const char           *SORT,
                   const LOGICAL        *SELCTG,
                   const INTEGER        *N,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   INTEGER              *SDIM,
                   FLOAT_COMPLEX        *ALPHA,
                   FLOAT_COMPLEX        *BETA,
                   FLOAT_COMPLEX        *VSL,
                   const INTEGER        *LDVSL,
                   FLOAT_COMPLEX        *VSR,
                   const INTEGER        *LDVSR,
                   FLOAT_COMPLEX        *WORK,
                   const INTEGER        *LWORK,
                   FLOAT                *RWORK,
                   LOGICAL              *BWORK,
                   INTEGER              *INFO);

//-- cggesx --------------------------------------------------------------------
void
LAPACK_IMPL(cggesx)(const char       *JOBVSL,
                    const char       *JOBVSR,
                    const char       *SORT,
                    const LOGICAL    *SELCTG,
                    const char       *SENSE,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    INTEGER          *SDIM,
                    FLOAT_COMPLEX    *ALPHA,
                    FLOAT_COMPLEX    *BETA,
                    FLOAT_COMPLEX    *VSL,
                    const INTEGER    *LDVSL,
                    FLOAT_COMPLEX    *VSR,
                    const INTEGER    *LDVSR,
                    FLOAT            *RCONDE,
                    FLOAT            *RCONDV,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    LOGICAL          *BWORK,
                    INTEGER          *INFO);

//-- cggev ---------------------------------------------------------------------
void
LAPACK_IMPL(cggev)(const char           *JOBVL,
                   const char           *JOBVR,
                   const INTEGER        *N,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   FLOAT_COMPLEX        *ALPHA,
                   FLOAT_COMPLEX        *BETA,
                   FLOAT_COMPLEX        *VL,
                   const INTEGER        *LDVL,
                   FLOAT_COMPLEX        *VR,
                   const INTEGER        *LDVR,
                   FLOAT_COMPLEX        *WORK,
                   const INTEGER        *LWORK,
                   FLOAT                *RWORK,
                   INTEGER              *INFO);

//-- cggevx --------------------------------------------------------------------
void
LAPACK_IMPL(cggevx)(const char       *BALANC,
                    const char       *JOBVL,
                    const char       *JOBVR,
                    const char       *SENSE,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *ALPHA,
                    FLOAT_COMPLEX    *BETA,
                    FLOAT_COMPLEX    *VL,
                    const INTEGER    *LDVL,
                    FLOAT_COMPLEX    *VR,
                    const INTEGER    *LDVR,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    FLOAT            *LSCALE,
                    FLOAT            *RSCALE,
                    FLOAT            *ABNRM,
                    FLOAT            *BBNRM,
                    FLOAT            *RCONDE,
                    FLOAT            *RCONDV,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    LOGICAL          *BWORK,
                    INTEGER          *INFO);

//-- cggglm --------------------------------------------------------------------
void
LAPACK_IMPL(cggglm)(const INTEGER    *N,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *D,
                    FLOAT_COMPLEX    *X,
                    FLOAT_COMPLEX    *Y,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- cgghrd --------------------------------------------------------------------
void
LAPACK_IMPL(cgghrd)(const char       *COMPQ,
                    const char       *COMPZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *INFO);

//-- cgglse --------------------------------------------------------------------
void
LAPACK_IMPL(cgglse)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *P,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *C,
                    FLOAT_COMPLEX    *D,
                    FLOAT_COMPLEX    *X,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- cggqrf --------------------------------------------------------------------
void
LAPACK_IMPL(cggqrf)(const INTEGER    *N,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAUA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *TAUB,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- cggrqf --------------------------------------------------------------------
void
LAPACK_IMPL(cggrqf)(const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAUA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *TAUB,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- cggsvd --------------------------------------------------------------------
void
LAPACK_IMPL(cggsvd)(const char       *JOBU,
                    const char       *JOBV,
                    const char       *JOBQ,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *P,
                    INTEGER          *K,
                    INTEGER          *L,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT            *ALPHA,
                    FLOAT            *BETA,
                    FLOAT_COMPLEX    *U,
                    const INTEGER    *LDU,
                    FLOAT_COMPLEX    *V,
                    const INTEGER    *LDV,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- cggsvp --------------------------------------------------------------------
void
LAPACK_IMPL(cggsvp)(const char       *JOBU,
                    const char       *JOBV,
                    const char       *JOBQ,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    const FLOAT      *TOLA,
                    const FLOAT      *TOLB,
                    INTEGER          *K,
                    INTEGER          *L,
                    FLOAT_COMPLEX    *U,
                    const INTEGER    *LDU,
                    FLOAT_COMPLEX    *V,
                    const INTEGER    *LDV,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    INTEGER          *IWORK,
                    FLOAT            *RWORK,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    INTEGER          *INFO);

//-- cgtcon --------------------------------------------------------------------
void
LAPACK_IMPL(cgtcon)(const char           *NORM,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *DL,
                    const FLOAT_COMPLEX  *D,
                    const FLOAT_COMPLEX  *DU,
                    const FLOAT_COMPLEX  *DU2,
                    const INTEGER        *IPIV,
                    const FLOAT          *ANORM,
                    FLOAT                *RCOND,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO);

//-- cgtrfs --------------------------------------------------------------------
void
LAPACK_IMPL(cgtrfs)(const char           *TRANS,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *DL,
                    const FLOAT_COMPLEX  *D,
                    const FLOAT_COMPLEX  *DU,
                    const FLOAT_COMPLEX  *DLF,
                    const FLOAT_COMPLEX  *DF,
                    const FLOAT_COMPLEX  *DUF,
                    const FLOAT_COMPLEX  *DU2,
                    const INTEGER        *IPIV,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- cgtsv ---------------------------------------------------------------------
void
LAPACK_IMPL(cgtsv)(const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT_COMPLEX        *DL,
                   FLOAT_COMPLEX        *D,
                   FLOAT_COMPLEX        *DU,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- cgtsvx --------------------------------------------------------------------
void
LAPACK_IMPL(cgtsvx)(const char           *FACT,
                    const char           *TRANS,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *DL,
                    const FLOAT_COMPLEX  *D,
                    const FLOAT_COMPLEX  *DU,
                    FLOAT_COMPLEX        *DLF,
                    FLOAT_COMPLEX        *DF,
                    FLOAT_COMPLEX        *DUF,
                    FLOAT_COMPLEX        *DU2,
                    INTEGER              *IPIV,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *RCOND,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- cgttrf --------------------------------------------------------------------
void
LAPACK_IMPL(cgttrf)(const INTEGER    *N,
                    FLOAT_COMPLEX    *DL,
                    FLOAT_COMPLEX    *D,
                    FLOAT_COMPLEX    *DU,
                    FLOAT_COMPLEX    *DU2,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- cgttrs --------------------------------------------------------------------
void
LAPACK_IMPL(cgttrs)(const char           *TRANS,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *DL,
                    const FLOAT_COMPLEX  *D,
                    const FLOAT_COMPLEX  *DU,
                    const FLOAT_COMPLEX  *DU2,
                    const INTEGER        *IPIV,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO);

//-- cgtts2 --------------------------------------------------------------------
void
LAPACK_IMPL(cgtts2)(const INTEGER        *ITRANS,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *DL,
                    const FLOAT_COMPLEX  *D,
                    const FLOAT_COMPLEX  *DU,
                    const FLOAT_COMPLEX  *DU2,
                    const INTEGER        *IPIV,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB);

//-- chbev ---------------------------------------------------------------------
void
LAPACK_IMPL(chbev)(const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *KD,
                   FLOAT_COMPLEX        *AB,
                   const INTEGER        *LDAB,
                   FLOAT                *W,
                   FLOAT_COMPLEX        *Z,
                   const INTEGER        *LDZ,
                   FLOAT_COMPLEX        *WORK,
                   FLOAT                *RWORK,
                   INTEGER              *INFO);

//-- chbevd --------------------------------------------------------------------
void
LAPACK_IMPL(chbevd)(const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    const INTEGER    *LRWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- chbevx --------------------------------------------------------------------
void
LAPACK_IMPL(chbevx)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *ABSTOL,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- chbgst --------------------------------------------------------------------
void
LAPACK_IMPL(chbgst)(const char           *VECT,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *KA,
                    const INTEGER        *KB,
                    FLOAT_COMPLEX        *AB,
                    const INTEGER        *LDAB,
                    const FLOAT_COMPLEX  *BB,
                    const INTEGER        *LDBB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- chbgv ---------------------------------------------------------------------
void
LAPACK_IMPL(chbgv)(const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *KA,
                   const INTEGER        *KB,
                   FLOAT_COMPLEX        *AB,
                   const INTEGER        *LDAB,
                   FLOAT_COMPLEX        *BB,
                   const INTEGER        *LDBB,
                   FLOAT                *W,
                   FLOAT_COMPLEX        *Z,
                   const INTEGER        *LDZ,
                   FLOAT_COMPLEX        *WORK,
                   FLOAT                *RWORK,
                   INTEGER              *INFO);

//-- chbgvd --------------------------------------------------------------------
void
LAPACK_IMPL(chbgvd)(const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KA,
                    const INTEGER    *KB,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    FLOAT_COMPLEX    *BB,
                    const INTEGER    *LDBB,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    const INTEGER    *LRWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- chbgvx --------------------------------------------------------------------
void
LAPACK_IMPL(chbgvx)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KA,
                    const INTEGER    *KB,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    FLOAT_COMPLEX    *BB,
                    const INTEGER    *LDBB,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *ABSTOL,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- chbtrd --------------------------------------------------------------------
void
LAPACK_IMPL(chbtrd)(const char       *VECT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    FLOAT_COMPLEX    *WORK,
                    INTEGER          *INFO);

//-- checon --------------------------------------------------------------------
void
LAPACK_IMPL(checon)(const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const INTEGER        *IPIV,
                    const FLOAT          *ANORM,
                    FLOAT                *RCOND,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO);

//-- cheequb -------------------------------------------------------------------
void
LAPACK_IMPL(cheequb)(const char               *UPLO,
                     const INTEGER            *N,
                     const FLOAT_COMPLEX      *A,
                     const INTEGER            *LDA,
                     FLOAT                    *S,
                     FLOAT                    *SCOND,
                     FLOAT                    *AMAX,
                     const FLOAT_COMPLEX      *WORK,
                     INTEGER                  *INFO);

//-- cheev ---------------------------------------------------------------------
void
LAPACK_IMPL(cheev)(const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA,
                   FLOAT                *W,
                   FLOAT_COMPLEX        *WORK,
                   const INTEGER        *LWORK,
                   FLOAT                *RWORK,
                   INTEGER              *INFO);

//-- cheevd --------------------------------------------------------------------
void
LAPACK_IMPL(cheevd)(const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    const INTEGER    *LRWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- cheevr --------------------------------------------------------------------
void
LAPACK_IMPL(cheevr)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *ABSTOL,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *ISUPPZ,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    const INTEGER    *LRWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- cheevx --------------------------------------------------------------------
void
LAPACK_IMPL(cheevx)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *ABSTOL,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- chegs2 --------------------------------------------------------------------
void
LAPACK_IMPL(chegs2)(const INTEGER        *ITYPE,
                    const char           *UPLO,
                    const INTEGER        *N,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO);

//-- chegst --------------------------------------------------------------------
void
LAPACK_IMPL(chegst)(const INTEGER        *ITYPE,
                    const char           *UPLO,
                    const INTEGER        *N,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO);

//-- chegv ---------------------------------------------------------------------
void
LAPACK_IMPL(chegv)(const INTEGER        *ITYPE,
                   const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   FLOAT                *W,
                   FLOAT_COMPLEX        *WORK,
                   const INTEGER        *LWORK,
                   FLOAT                *RWORK,
                   INTEGER              *INFO);

//-- chegvd --------------------------------------------------------------------
void
LAPACK_IMPL(chegvd)(const INTEGER    *ITYPE,
                    const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    const INTEGER    *LRWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- chegvx --------------------------------------------------------------------
void
LAPACK_IMPL(chegvx)(const INTEGER    *ITYPE,
                    const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *ABSTOL,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- cherfs --------------------------------------------------------------------
void
LAPACK_IMPL(cherfs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *AF,
                    const INTEGER        *LDAF,
                    const INTEGER        *IPIV,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- cherfsx -------------------------------------------------------------------
void
LAPACK_IMPL(cherfsx)(const char               *UPLO,
                     const char               *EQUED,
                     const INTEGER            *N,
                     const INTEGER            *NRHS,
                     const FLOAT_COMPLEX      *A,
                     const INTEGER            *LDA,
                     const FLOAT_COMPLEX      *AF,
                     const INTEGER            *LDAF,
                     const INTEGER            *IPIV,
                     FLOAT                    *S,
                     const FLOAT_COMPLEX      *B,
                     const INTEGER            *LDB,
                     FLOAT_COMPLEX            *X,
                     const INTEGER            *LDX,
                     FLOAT                    *RCOND,
                     FLOAT                    *BERR,
                     const INTEGER            *N_ERR_BNDS,
                     FLOAT                    *ERR_BNDS_NORM,
                     FLOAT                    *ERR_BNDS_COMP,
                     const INTEGER            *NPARAMS,
                     FLOAT                    *PARAMS,
                     FLOAT_COMPLEX            *WORK,
                     FLOAT                    *RWORK,
                     INTEGER                  *INFO);

//-- chesv ---------------------------------------------------------------------
void
LAPACK_IMPL(chesv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA,
                   INTEGER              *IPIV,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   FLOAT_COMPLEX        *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO);

//-- chesvx --------------------------------------------------------------------
void
LAPACK_IMPL(chesvx)(const char           *FACT,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT_COMPLEX        *AF,
                    const INTEGER        *LDAF,
                    INTEGER              *IPIV,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *RCOND,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- chesvxx -------------------------------------------------------------------
void
LAPACK_IMPL(chesvxx)(const char       *FACT,
                     const char       *UPLO,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     FLOAT_COMPLEX    *A,
                     const INTEGER    *LDA,
                     FLOAT_COMPLEX    *AF,
                     const INTEGER    *LDAF,
                     INTEGER          *IPIV,
                     char             *EQUED,
                     FLOAT            *S,
                     FLOAT_COMPLEX    *B,
                     const INTEGER    *LDB,
                     FLOAT_COMPLEX    *X,
                     const INTEGER    *LDX,
                     FLOAT            *RCOND,
                     FLOAT            *RPVGRW,
                     FLOAT            *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     FLOAT            *ERR_BNDS_NORM,
                     FLOAT            *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     FLOAT            *PARAMS,
                     FLOAT_COMPLEX    *WORK,
                     FLOAT            *RWORK,
                     INTEGER          *INFO);

//-- cheswapr ------------------------------------------------------------------
void
LAPACK_IMPL(cheswapr)(const char       *UPLO,
                      const INTEGER    *N,
                      FLOAT_COMPLEX    *A,
                      const INTEGER    *LDA,
                      const INTEGER    *I1,
                      const INTEGER    *I2);

//-- chetd2 --------------------------------------------------------------------
void
LAPACK_IMPL(chetd2)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *TAU,
                    INTEGER          *INFO);

//-- chetf2 --------------------------------------------------------------------
void
LAPACK_IMPL(chetf2)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- chetrd --------------------------------------------------------------------
void
LAPACK_IMPL(chetrd)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- chetrf --------------------------------------------------------------------
void
LAPACK_IMPL(chetrf)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- chetri --------------------------------------------------------------------
void
LAPACK_IMPL(chetri)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    const INTEGER    *IPIV,
                    FLOAT_COMPLEX    *WORK,
                    INTEGER          *INFO);

//-- chetri2 -------------------------------------------------------------------
void
LAPACK_IMPL(chetri2)(const char       *UPLO,
                     const INTEGER    *N,
                     FLOAT_COMPLEX    *A,
                     const INTEGER    *LDA,
                     const INTEGER    *IPIV,
                     FLOAT_COMPLEX    *WORK,
                     const INTEGER    *LWORK,
                     INTEGER          *INFO);

//-- chetri2x ------------------------------------------------------------------
void
LAPACK_IMPL(chetri2x)(const char       *UPLO,
                      const INTEGER    *N,
                      FLOAT_COMPLEX    *A,
                      const INTEGER    *LDA,
                      const INTEGER    *IPIV,
                      FLOAT_COMPLEX    *WORK,
                      const INTEGER    *NB,
                      INTEGER          *INFO);

//-- chetrs --------------------------------------------------------------------
void
LAPACK_IMPL(chetrs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const INTEGER        *IPIV,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO);

//-- chetrs2 -------------------------------------------------------------------
void
LAPACK_IMPL(chetrs2)(const char               *UPLO,
                     const INTEGER            *N,
                     const INTEGER            *NRHS,
                     const FLOAT_COMPLEX      *A,
                     const INTEGER            *LDA,
                     const INTEGER            *IPIV,
                     FLOAT_COMPLEX            *B,
                     const INTEGER            *LDB,
                     FLOAT_COMPLEX            *WORK,
                     INTEGER                  *INFO);

//-- chfrk ---------------------------------------------------------------------
void
LAPACK_IMPL(chfrk)(const char               *TRANSR,
                   const char               *UPLO,
                   const char               *TRANS,
                   const INTEGER            *N,
                   const INTEGER            *K,
                   const FLOAT              *ALPHA,
                   const FLOAT_COMPLEX      *A,
                   const INTEGER            *LDA,
                   const FLOAT              *BETA,
                   FLOAT_COMPLEX            *C);

//-- chgeqz --------------------------------------------------------------------
void
LAPACK_IMPL(chgeqz)(const char       *JOB,
                    const char       *COMPQ,
                    const char       *COMPZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT_COMPLEX    *H,
                    const INTEGER    *LDH,
                    FLOAT_COMPLEX    *T,
                    const INTEGER    *LDT,
                    FLOAT_COMPLEX    *ALPHA,
                    FLOAT_COMPLEX    *BETA,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO);

//-- chla_transtype ------------------------------------------------------------
char
LAPACK_IMPL(chla_transtype)(const INTEGER    *TRANS);

//-- chpcon --------------------------------------------------------------------
void
LAPACK_IMPL(chpcon)(const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *AP,
                    const INTEGER        *IPIV,
                    const FLOAT          *ANORM,
                    FLOAT                *RCOND,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO);

//-- chpev ---------------------------------------------------------------------
void
LAPACK_IMPL(chpev)(const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   FLOAT_COMPLEX        *AP,
                   FLOAT                *W,
                   FLOAT_COMPLEX        *Z,
                   const INTEGER        *LDZ,
                   FLOAT_COMPLEX        *WORK,
                   FLOAT                *RWORK,
                   INTEGER              *INFO);

//-- chpevd --------------------------------------------------------------------
void
LAPACK_IMPL(chpevd)(const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    const INTEGER    *LRWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- chpevx --------------------------------------------------------------------
void
LAPACK_IMPL(chpevx)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *ABSTOL,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- chpgst --------------------------------------------------------------------
void
LAPACK_IMPL(chpgst)(const INTEGER        *ITYPE,
                    const char           *UPLO,
                    const INTEGER        *N,
                    FLOAT_COMPLEX        *AP,
                    const FLOAT_COMPLEX  *BP,
                    INTEGER              *INFO);

//-- chpgv ---------------------------------------------------------------------
void
LAPACK_IMPL(chpgv)(const INTEGER        *ITYPE,
                   const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   FLOAT_COMPLEX        *AP,
                   FLOAT_COMPLEX        *BP,
                   FLOAT                *W,
                   FLOAT_COMPLEX        *Z,
                   const INTEGER        *LDZ,
                   FLOAT_COMPLEX        *WORK,
                   FLOAT                *RWORK,
                   INTEGER              *INFO);

//-- chpgvd --------------------------------------------------------------------
void
LAPACK_IMPL(chpgvd)(const INTEGER    *ITYPE,
                    const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    FLOAT_COMPLEX    *BP,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    const INTEGER    *LRWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- chpgvx --------------------------------------------------------------------
void
LAPACK_IMPL(chpgvx)(const INTEGER    *ITYPE,
                    const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    FLOAT_COMPLEX    *BP,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *ABSTOL,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- chprfs --------------------------------------------------------------------
void
LAPACK_IMPL(chprfs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AP,
                    const FLOAT_COMPLEX  *AFP,
                    const INTEGER        *IPIV,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- chpsv ---------------------------------------------------------------------
void
LAPACK_IMPL(chpsv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT_COMPLEX        *AP,
                   INTEGER              *IPIV,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- chpsvx --------------------------------------------------------------------
void
LAPACK_IMPL(chpsvx)(const char           *FACT,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AP,
                    FLOAT_COMPLEX        *AFP,
                    INTEGER              *IPIV,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *RCOND,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- chptrd --------------------------------------------------------------------
void
LAPACK_IMPL(chptrd)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *TAU,
                    INTEGER          *INFO);

//-- chptrf --------------------------------------------------------------------
void
LAPACK_IMPL(chptrf)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- chptri --------------------------------------------------------------------
void
LAPACK_IMPL(chptri)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    const INTEGER    *IPIV,
                    FLOAT_COMPLEX    *WORK,
                    INTEGER          *INFO);

//-- chptrs --------------------------------------------------------------------
void
LAPACK_IMPL(chptrs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AP,
                    const INTEGER        *IPIV,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO);

//-- chsein --------------------------------------------------------------------
void
LAPACK_IMPL(chsein)(const char           *SIDE,
                    const char           *EIGSRC,
                    const char           *INITV,
                    const LOGICAL        *SELECT,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *H,
                    const INTEGER        *LDH,
                    FLOAT_COMPLEX        *W,
                    FLOAT_COMPLEX        *VL,
                    const INTEGER        *LDVL,
                    FLOAT_COMPLEX        *VR,
                    const INTEGER        *LDVR,
                    const INTEGER        *MM,
                    INTEGER              *M,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *IFAILL,
                    INTEGER              *IFAILR,
                    INTEGER              *INFO);

//-- chseqr --------------------------------------------------------------------
void
LAPACK_IMPL(chseqr)(const char       *JOB,
                    const char       *COMPZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT_COMPLEX    *H,
                    const INTEGER    *LDH,
                    FLOAT_COMPLEX    *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- cla_gbamv -----------------------------------------------------------------
void
LAPACK_IMPL(cla_gbamv)(const INTEGER            *TRANS,
                       const INTEGER            *M,
                       const INTEGER            *N,
                       const INTEGER            *KL,
                       const INTEGER            *KU,
                       const FLOAT              *ALPHA,
                       const FLOAT_COMPLEX      *AB,
                       const INTEGER            *LDAB,
                       const FLOAT_COMPLEX      *X,
                       const INTEGER            *INCX,
                       const FLOAT              *BETA,
                       FLOAT                    *Y,
                       const INTEGER            *INCY);

//-- cla_gbrcond_c -------------------------------------------------------------
FLOAT
LAPACK_IMPL(cla_gbrcond_c)(const char               *TRANS,
                           const INTEGER            *N,
                           const INTEGER            *KL,
                           const INTEGER            *KU,
                           const FLOAT_COMPLEX      *AB,
                           const INTEGER            *LDAB,
                           const FLOAT_COMPLEX      *AFB,
                           const INTEGER            *LDAFB,
                           const INTEGER            *IPIV,
                           const FLOAT              *C,
                           const LOGICAL            *CAPPLY,
                           INTEGER                  *INFO,
                           const FLOAT_COMPLEX      *WORK,
                           const FLOAT              *RWORK);

//-- cla_gbrcond_x -------------------------------------------------------------
FLOAT
LAPACK_IMPL(cla_gbrcond_x)(const char               *TRANS,
                           const INTEGER            *N,
                           const INTEGER            *KL,
                           const INTEGER            *KU,
                           const FLOAT_COMPLEX      *AB,
                           const INTEGER            *LDAB,
                           const FLOAT_COMPLEX      *AFB,
                           const INTEGER            *LDAFB,
                           const INTEGER            *IPIV,
                           const FLOAT_COMPLEX      *X,
                           INTEGER                  *INFO,
                           const FLOAT_COMPLEX      *WORK,
                           const FLOAT              *RWORK);

//-- cla_gbrfsx_extended -------------------------------------------------------
void
LAPACK_IMPL(cla_gbrfsx_extended)(const INTEGER            *PREC_TYPE,
                                 const INTEGER            *TRANS_TYPE,
                                 const INTEGER            *N,
                                 const INTEGER            *KL,
                                 const INTEGER            *KU,
                                 const INTEGER            *NRHS,
                                 const FLOAT_COMPLEX      *AB,
                                 const INTEGER            *LDAB,
                                 const FLOAT_COMPLEX      *AFB,
                                 const INTEGER            *LDAFB,
                                 const INTEGER            *IPIV,
                                 const LOGICAL            *COLEQU,
                                 const FLOAT              *C,
                                 const FLOAT_COMPLEX      *B,
                                 const INTEGER            *LDB,
                                 FLOAT_COMPLEX            *Y,
                                 const INTEGER            *LDY,
                                 FLOAT                    *BERR_OUT,
                                 const INTEGER            *N_NORMS,
                                 FLOAT                    *ERR_BNDS_NORM,
                                 FLOAT                    *ERR_BNDS_COMP,
                                 const FLOAT_COMPLEX      *RES,
                                 const FLOAT              *AYB,
                                 const FLOAT_COMPLEX      *DY,
                                 const FLOAT_COMPLEX      *Y_TAIL,
                                 const FLOAT              *RCOND,
                                 const INTEGER            *ITHRESH,
                                 const FLOAT              *RTHRESH,
                                 const FLOAT              *DZ_UB,
                                 const LOGICAL            *IGNORE_CWISE,
                                 INTEGER                  *INFO);

//-- cla_gbrpvgrw --------------------------------------------------------------
FLOAT
LAPACK_IMPL(cla_gbrpvgrw)(const INTEGER            *N,
                          const INTEGER            *KL,
                          const INTEGER            *KU,
                          const INTEGER            *NCOLS,
                          const FLOAT_COMPLEX      *AB,
                          const INTEGER            *LDAB,
                          const FLOAT_COMPLEX      *AFB,
                          const INTEGER            *LDAFB);

//-- cla_geamv -----------------------------------------------------------------
void
LAPACK_IMPL(cla_geamv)(const INTEGER            *TRANS,
                       const INTEGER            *M,
                       const INTEGER            *N,
                       const FLOAT              *ALPHA,
                       const FLOAT_COMPLEX      *A,
                       const INTEGER            *LDA,
                       const FLOAT_COMPLEX      *X,
                       const INTEGER            *INCX,
                       const FLOAT              *BETA,
                       FLOAT                    *Y,
                       const INTEGER            *INCY);

//-- cla_gercond_c -------------------------------------------------------------
FLOAT
LAPACK_IMPL(cla_gercond_c)(const char               *TRANS,
                           const INTEGER            *N,
                           const FLOAT_COMPLEX      *A,
                           const INTEGER            *LDA,
                           const FLOAT_COMPLEX      *AF,
                           const INTEGER            *LDAF,
                           const INTEGER            *IPIV,
                           const FLOAT              *C,
                           const LOGICAL            *CAPPLY,
                           INTEGER                  *INFO,
                           const FLOAT_COMPLEX      *WORK,
                           const FLOAT              *RWORK);

//-- cla_gercond_x -------------------------------------------------------------
FLOAT
LAPACK_IMPL(cla_gercond_x)(const char               *TRANS,
                           const INTEGER            *N,
                           const FLOAT_COMPLEX      *A,
                           const INTEGER            *LDA,
                           const FLOAT_COMPLEX      *AF,
                           const INTEGER            *LDAF,
                           const INTEGER            *IPIV,
                           const FLOAT_COMPLEX      *X,
                           INTEGER                  *INFO,
                           const FLOAT_COMPLEX      *WORK,
                           const FLOAT              *RWORK);

//-- cla_gerfsx_extended -------------------------------------------------------
void
LAPACK_IMPL(cla_gerfsx_extended)(const INTEGER            *PREC_TYPE,
                                 const INTEGER            *TRANS_TYPE,
                                 const INTEGER            *N,
                                 const INTEGER            *NRHS,
                                 const FLOAT_COMPLEX      *A,
                                 const INTEGER            *LDA,
                                 const FLOAT_COMPLEX      *AF,
                                 const INTEGER            *LDAF,
                                 const INTEGER            *IPIV,
                                 const LOGICAL            *COLEQU,
                                 const FLOAT              *C,
                                 const FLOAT_COMPLEX      *B,
                                 const INTEGER            *LDB,
                                 FLOAT_COMPLEX            *Y,
                                 const INTEGER            *LDY,
                                 FLOAT                    *BERR_OUT,
                                 const INTEGER            *N_NORMS,
                                 const FLOAT              *ERRS_N,
                                 const FLOAT              *ERRS_C,
                                 const FLOAT_COMPLEX      *RES,
                                 const FLOAT              *AYB,
                                 const FLOAT_COMPLEX      *DY,
                                 const FLOAT_COMPLEX      *Y_TAIL,
                                 const FLOAT              *RCOND,
                                 const INTEGER            *ITHRESH,
                                 const FLOAT              *RTHRESH,
                                 const FLOAT              *DZ_UB,
                                 const LOGICAL            *IGNORE_CWISE,
                                 INTEGER                  *INFO);

//-- cla_heamv -----------------------------------------------------------------
void
LAPACK_IMPL(cla_heamv)(const INTEGER            *UPLO,
                       const INTEGER            *N,
                       const FLOAT              *ALPHA,
                       const FLOAT_COMPLEX      *A,
                       const INTEGER            *LDA,
                       const FLOAT_COMPLEX      *X,
                       const INTEGER            *INCX,
                       const FLOAT              *BETA,
                       FLOAT                    *Y,
                       const INTEGER            *INCY);

//-- cla_hercond_c -------------------------------------------------------------
FLOAT
LAPACK_IMPL(cla_hercond_c)(const char               *UPLO,
                           const INTEGER            *N,
                           const FLOAT_COMPLEX      *A,
                           const INTEGER            *LDA,
                           const FLOAT_COMPLEX      *AF,
                           const INTEGER            *LDAF,
                           const INTEGER            *IPIV,
                           const FLOAT              *C,
                           const LOGICAL            *CAPPLY,
                           INTEGER                  *INFO,
                           const FLOAT_COMPLEX      *WORK,
                           const FLOAT              *RWORK);

//-- cla_hercond_x -------------------------------------------------------------
FLOAT
LAPACK_IMPL(cla_hercond_x)(const char               *UPLO,
                           const INTEGER            *N,
                           const FLOAT_COMPLEX      *A,
                           const INTEGER            *LDA,
                           const FLOAT_COMPLEX      *AF,
                           const INTEGER            *LDAF,
                           const INTEGER            *IPIV,
                           const FLOAT_COMPLEX      *X,
                           INTEGER                  *INFO,
                           const FLOAT_COMPLEX      *WORK,
                           const FLOAT              *RWORK);

//-- cla_herfsx_extended -------------------------------------------------------
void
LAPACK_IMPL(cla_herfsx_extended)(const INTEGER            *PREC_TYPE,
                                 const char               *UPLO,
                                 const INTEGER            *N,
                                 const INTEGER            *NRHS,
                                 const FLOAT_COMPLEX      *A,
                                 const INTEGER            *LDA,
                                 const FLOAT_COMPLEX      *AF,
                                 const INTEGER            *LDAF,
                                 const INTEGER            *IPIV,
                                 const LOGICAL            *COLEQU,
                                 const FLOAT              *C,
                                 const FLOAT_COMPLEX      *B,
                                 const INTEGER            *LDB,
                                 FLOAT_COMPLEX            *Y,
                                 const INTEGER            *LDY,
                                 FLOAT                    *BERR_OUT,
                                 const INTEGER            *N_NORMS,
                                 FLOAT                    *ERR_BNDS_NORM,
                                 FLOAT                    *ERR_BNDS_COMP,
                                 const FLOAT_COMPLEX      *RES,
                                 const FLOAT              *AYB,
                                 const FLOAT_COMPLEX      *DY,
                                 const FLOAT_COMPLEX      *Y_TAIL,
                                 const FLOAT              *RCOND,
                                 const INTEGER            *ITHRESH,
                                 const FLOAT              *RTHRESH,
                                 const FLOAT              *DZ_UB,
                                 const LOGICAL            *IGNORE_CWISE,
                                 INTEGER                  *INFO);

//-- cla_herpvgrw --------------------------------------------------------------
FLOAT
LAPACK_IMPL(cla_herpvgrw)(const char               *UPLO,
                          const INTEGER            *N,
                          const INTEGER            *INFO,
                          const FLOAT_COMPLEX      *A,
                          const INTEGER            *LDA,
                          const FLOAT_COMPLEX      *AF,
                          const INTEGER            *LDAF,
                          const INTEGER            *IPIV,
                          const FLOAT              *WORK);

//-- cla_lin_berr --------------------------------------------------------------
void
LAPACK_IMPL(cla_lin_berr)(const INTEGER            *N,
                          const INTEGER            *NZ,
                          const INTEGER            *NRHS,
                          const FLOAT_COMPLEX      *RES,
                          const FLOAT              *AYB,
                          FLOAT                    *BERR);

//-- cla_porcond_c -------------------------------------------------------------
FLOAT
LAPACK_IMPL(cla_porcond_c)(const char               *UPLO,
                           const INTEGER            *N,
                           const FLOAT_COMPLEX      *A,
                           const INTEGER            *LDA,
                           const FLOAT_COMPLEX      *AF,
                           const INTEGER            *LDAF,
                           const FLOAT              *C,
                           const LOGICAL            *CAPPLY,
                           INTEGER                  *INFO,
                           const FLOAT_COMPLEX      *WORK,
                           const FLOAT              *RWORK);

//-- cla_porcond_x -------------------------------------------------------------
FLOAT
LAPACK_IMPL(cla_porcond_x)(const char               *UPLO,
                           const INTEGER            *N,
                           const FLOAT_COMPLEX      *A,
                           const INTEGER            *LDA,
                           const FLOAT_COMPLEX      *AF,
                           const INTEGER            *LDAF,
                           const FLOAT_COMPLEX      *X,
                           INTEGER                  *INFO,
                           const FLOAT_COMPLEX      *WORK,
                           const FLOAT              *RWORK);

//-- cla_porfsx_extended -------------------------------------------------------
void
LAPACK_IMPL(cla_porfsx_extended)(const INTEGER            *PREC_TYPE,
                                 const char               *UPLO,
                                 const INTEGER            *N,
                                 const INTEGER            *NRHS,
                                 const FLOAT_COMPLEX      *A,
                                 const INTEGER            *LDA,
                                 const FLOAT_COMPLEX      *AF,
                                 const INTEGER            *LDAF,
                                 const LOGICAL            *COLEQU,
                                 const FLOAT              *C,
                                 const FLOAT_COMPLEX      *B,
                                 const INTEGER            *LDB,
                                 FLOAT_COMPLEX            *Y,
                                 const INTEGER            *LDY,
                                 FLOAT                    *BERR_OUT,
                                 const INTEGER            *N_NORMS,
                                 FLOAT                    *ERR_BNDS_NORM,
                                 FLOAT                    *ERR_BNDS_COMP,
                                 const FLOAT_COMPLEX      *RES,
                                 const FLOAT              *AYB,
                                 const FLOAT_COMPLEX      *DY,
                                 const FLOAT_COMPLEX      *Y_TAIL,
                                 const FLOAT              *RCOND,
                                 const INTEGER            *ITHRESH,
                                 const FLOAT              *RTHRESH,
                                 const FLOAT              *DZ_UB,
                                 const LOGICAL            *IGNORE_CWISE,
                                 INTEGER                  *INFO);

//-- cla_porpvgrw --------------------------------------------------------------
FLOAT
LAPACK_IMPL(cla_porpvgrw)(const char               *UPLO,
                          const INTEGER            *NCOLS,
                          const FLOAT_COMPLEX      *A,
                          const INTEGER            *LDA,
                          const FLOAT_COMPLEX      *AF,
                          const INTEGER            *LDAF,
                          const FLOAT              *WORK);

//-- cla_rpvgrw ----------------------------------------------------------------
FLOAT
LAPACK_IMPL(cla_rpvgrw)(const INTEGER        *N,
                        const INTEGER        *NCOLS,
                        const FLOAT_COMPLEX  *A,
                        const INTEGER        *LDA,
                        const FLOAT_COMPLEX  *AF,
                        const INTEGER        *LDAF);

//-- cla_syamv -----------------------------------------------------------------
void
LAPACK_IMPL(cla_syamv)(const INTEGER            *UPLO,
                       const INTEGER            *N,
                       const FLOAT              *ALPHA,
                       const FLOAT_COMPLEX      *A,
                       const INTEGER            *LDA,
                       const FLOAT_COMPLEX      *X,
                       const INTEGER            *INCX,
                       const FLOAT              *BETA,
                       FLOAT                    *Y,
                       const INTEGER            *INCY);

//-- cla_syrcond_c -------------------------------------------------------------
FLOAT
LAPACK_IMPL(cla_syrcond_c)(const char               *UPLO,
                           const INTEGER            *N,
                           const FLOAT_COMPLEX      *A,
                           const INTEGER            *LDA,
                           const FLOAT_COMPLEX      *AF,
                           const INTEGER            *LDAF,
                           const INTEGER            *IPIV,
                           const FLOAT              *C,
                           const LOGICAL            *CAPPLY,
                           INTEGER                  *INFO,
                           const FLOAT_COMPLEX      *WORK,
                           const FLOAT              *RWORK);

//-- cla_syrcond_x -------------------------------------------------------------
FLOAT
LAPACK_IMPL(cla_syrcond_x)(const char               *UPLO,
                           const INTEGER            *N,
                           const FLOAT_COMPLEX      *A,
                           const INTEGER            *LDA,
                           const FLOAT_COMPLEX      *AF,
                           const INTEGER            *LDAF,
                           const INTEGER            *IPIV,
                           const FLOAT_COMPLEX      *X,
                           INTEGER                  *INFO,
                           const FLOAT_COMPLEX      *WORK,
                           const FLOAT              *RWORK);

//-- cla_syrfsx_extended -------------------------------------------------------
void
LAPACK_IMPL(cla_syrfsx_extended)(const INTEGER            *PREC_TYPE,
                                 const char               *UPLO,
                                 const INTEGER            *N,
                                 const INTEGER            *NRHS,
                                 const FLOAT_COMPLEX      *A,
                                 const INTEGER            *LDA,
                                 const FLOAT_COMPLEX      *AF,
                                 const INTEGER            *LDAF,
                                 const INTEGER            *IPIV,
                                 const LOGICAL            *COLEQU,
                                 const FLOAT              *C,
                                 const FLOAT_COMPLEX      *B,
                                 const INTEGER            *LDB,
                                 FLOAT_COMPLEX            *Y,
                                 const INTEGER            *LDY,
                                 FLOAT                    *BERR_OUT,
                                 const INTEGER            *N_NORMS,
                                 FLOAT                    *ERR_BNDS_NORM,
                                 FLOAT                    *ERR_BNDS_COMP,
                                 const FLOAT_COMPLEX      *RES,
                                 const FLOAT              *AYB,
                                 const FLOAT_COMPLEX      *DY,
                                 const FLOAT_COMPLEX      *Y_TAIL,
                                 const FLOAT              *RCOND,
                                 const INTEGER            *ITHRESH,
                                 const FLOAT              *RTHRESH,
                                 const FLOAT              *DZ_UB,
                                 const LOGICAL            *IGNORE_CWISE,
                                 INTEGER                  *INFO);

//-- cla_syrpvgrw --------------------------------------------------------------
FLOAT
LAPACK_IMPL(cla_syrpvgrw)(const char               *UPLO,
                          const INTEGER            *N,
                          const INTEGER            *INFO,
                          const FLOAT_COMPLEX      *A,
                          const INTEGER            *LDA,
                          const FLOAT_COMPLEX      *AF,
                          const INTEGER            *LDAF,
                          const INTEGER            *IPIV,
                          const FLOAT              *WORK);

//-- cla_wwaddw ----------------------------------------------------------------
void
LAPACK_IMPL(cla_wwaddw)(const INTEGER        *N,
                        FLOAT_COMPLEX        *X,
                        FLOAT_COMPLEX        *Y,
                        const FLOAT_COMPLEX  *W);

//-- clabrd --------------------------------------------------------------------
void
LAPACK_IMPL(clabrd)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NB,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *TAUQ,
                    FLOAT_COMPLEX    *TAUP,
                    FLOAT_COMPLEX    *X,
                    const INTEGER    *LDX,
                    FLOAT_COMPLEX    *Y,
                    const INTEGER    *LDY);

//-- clacgv --------------------------------------------------------------------
void
LAPACK_IMPL(clacgv)(const INTEGER    *N,
                    FLOAT_COMPLEX    *X,
                    const INTEGER    *INCX);

//-- clacn2 --------------------------------------------------------------------
void
LAPACK_IMPL(clacn2)(const INTEGER    *N,
                    FLOAT_COMPLEX    *V,
                    FLOAT_COMPLEX    *X,
                    FLOAT            *EST,
                    INTEGER          *KASE,
                    INTEGER          *ISAVE);

//-- clacon --------------------------------------------------------------------
void
LAPACK_IMPL(clacon)(const INTEGER    *N,
                    FLOAT_COMPLEX    *V,
                    FLOAT_COMPLEX    *X,
                    FLOAT            *EST,
                    INTEGER          *KASE);

//-- clacp2 --------------------------------------------------------------------
void
LAPACK_IMPL(clacp2)(const char       *UPLO,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB);

//-- clacpy --------------------------------------------------------------------
void
LAPACK_IMPL(clacpy)(const char           *UPLO,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB);

//-- clacrm --------------------------------------------------------------------
void
LAPACK_IMPL(clacrm)(const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT          *B,
                    const INTEGER        *LDB,
                    const FLOAT_COMPLEX  *C,
                    const INTEGER        *LDC,
                    FLOAT                *RWORK);

//-- clacrt --------------------------------------------------------------------
void
LAPACK_IMPL(clacrt)(const INTEGER        *N,
                    FLOAT_COMPLEX        *CX,
                    const INTEGER        *INCX,
                    FLOAT_COMPLEX        *CY,
                    const INTEGER        *INCY,
                    const FLOAT_COMPLEX  *C,
                    const FLOAT_COMPLEX  *S);

//-- cladiv --------------------------------------------------------------------
FLOAT_COMPLEX
LAPACK_IMPL(cladiv)(const FLOAT_COMPLEX  *X,
                    const FLOAT_COMPLEX  *Y);

//-- claed0 --------------------------------------------------------------------
void
LAPACK_IMPL(claed0)(const INTEGER    *QSIZ,
                    const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    FLOAT_COMPLEX    *QSTORE,
                    const INTEGER    *LDQS,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- claed7 --------------------------------------------------------------------
void
LAPACK_IMPL(claed7)(const INTEGER    *N,
                    const INTEGER    *CUTPNT,
                    const INTEGER    *QSIZ,
                    const INTEGER    *TLVLS,
                    const INTEGER    *CURLVL,
                    const INTEGER    *CURPBM,
                    FLOAT            *D,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    const FLOAT      *RHO,
                    INTEGER          *INDXQ,
                    FLOAT            *QSTORE,
                    INTEGER          *QPTR,
                    const INTEGER    *PRMPTR,
                    const INTEGER    *PERM,
                    const INTEGER    *GIVPTR,
                    const INTEGER    *GIVCOL,
                    const FLOAT      *GIVNUM,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- claed8 --------------------------------------------------------------------
void
LAPACK_IMPL(claed8)(INTEGER          *K,
                    const INTEGER    *N,
                    const INTEGER    *QSIZ,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    FLOAT            *D,
                    FLOAT            *RHO,
                    const INTEGER    *CUTPNT,
                    const FLOAT      *Z,
                    FLOAT            *DLAMDA,
                    FLOAT_COMPLEX    *Q2,
                    const INTEGER    *LDQ2,
                    FLOAT            *W,
                    INTEGER          *INDXP,
                    INTEGER          *INDX,
                    const INTEGER    *INDXQ,
                    INTEGER          *PERM,
                    INTEGER          *GIVPTR,
                    INTEGER          *GIVCOL,
                    FLOAT            *GIVNUM,
                    INTEGER          *INFO);

//-- claein --------------------------------------------------------------------
void
LAPACK_IMPL(claein)(const LOGICAL        *RIGHTV,
                    const LOGICAL        *NOINIT,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *H,
                    const INTEGER        *LDH,
                    const FLOAT_COMPLEX  *W,
                    FLOAT_COMPLEX        *V,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    FLOAT                *RWORK,
                    const FLOAT          *EPS3,
                    const FLOAT          *SMLNUM,
                    INTEGER              *INFO);

//-- claesy --------------------------------------------------------------------
void
LAPACK_IMPL(claesy)(const FLOAT_COMPLEX  *A,
                    const FLOAT_COMPLEX  *B,
                    const FLOAT_COMPLEX  *C,
                    FLOAT_COMPLEX        *RT1,
                    FLOAT_COMPLEX        *RT2,
                    FLOAT_COMPLEX        *EVSCAL,
                    FLOAT_COMPLEX        *CS1,
                    FLOAT_COMPLEX        *SN1);

//-- claev2 --------------------------------------------------------------------
void
LAPACK_IMPL(claev2)(const FLOAT_COMPLEX  *A,
                    const FLOAT_COMPLEX  *B,
                    const FLOAT_COMPLEX  *C,
                    FLOAT                *RT1,
                    FLOAT                *RT2,
                    FLOAT                *CS1,
                    FLOAT_COMPLEX        *SN1);

//-- clag2z --------------------------------------------------------------------
void
LAPACK_IMPL(clag2z)(const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *SA,
                    const INTEGER        *LDSA,
                    DOUBLE_COMPLEX       *A,
                    const INTEGER        *LDA,
                    INTEGER              *INFO);

//-- clags2 --------------------------------------------------------------------
void
LAPACK_IMPL(clags2)(const LOGICAL        *UPPER,
                    const FLOAT          *A1,
                    const FLOAT_COMPLEX  *A2,
                    const FLOAT          *A3,
                    const FLOAT          *B1,
                    const FLOAT_COMPLEX  *B2,
                    const FLOAT          *B3,
                    FLOAT                *CSU,
                    FLOAT_COMPLEX        *SNU,
                    FLOAT                *CSV,
                    FLOAT_COMPLEX        *SNV,
                    FLOAT                *CSQ,
                    FLOAT_COMPLEX        *SNQ);

//-- clagtm --------------------------------------------------------------------
void
LAPACK_IMPL(clagtm)(const char           *TRANS,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT          *ALPHA,
                    const FLOAT_COMPLEX  *DL,
                    const FLOAT_COMPLEX  *D,
                    const FLOAT_COMPLEX  *DU,
                    const FLOAT_COMPLEX  *X,
                    const INTEGER        *LDX,
                    const FLOAT          *BETA,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB);

//-- clahef --------------------------------------------------------------------
void
LAPACK_IMPL(clahef)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NB,
                    INTEGER          *KB,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    FLOAT_COMPLEX    *W,
                    const INTEGER    *LDW,
                    INTEGER          *INFO);

//-- clahqr --------------------------------------------------------------------
void
LAPACK_IMPL(clahqr)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT_COMPLEX    *H,
                    const INTEGER    *LDH,
                    FLOAT_COMPLEX    *W,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *INFO);

//-- clahr2 --------------------------------------------------------------------
void
LAPACK_IMPL(clahr2)(const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *NB,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *T,
                    const INTEGER    *LDT,
                    FLOAT_COMPLEX    *Y,
                    const INTEGER    *LDY);

//-- clahrd --------------------------------------------------------------------
void
LAPACK_IMPL(clahrd)(const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *NB,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *T,
                    const INTEGER    *LDT,
                    FLOAT_COMPLEX    *Y,
                    const INTEGER    *LDY);

//-- claic1 --------------------------------------------------------------------
void
LAPACK_IMPL(claic1)(const INTEGER        *JOB,
                    const INTEGER        *J,
                    const FLOAT_COMPLEX  *X,
                    const FLOAT          *SEST,
                    const FLOAT_COMPLEX  *W,
                    const FLOAT_COMPLEX  *GAMMA,
                    FLOAT                *SESTPR,
                    FLOAT_COMPLEX        *S,
                    FLOAT_COMPLEX        *C);

//-- clals0 --------------------------------------------------------------------
void
LAPACK_IMPL(clals0)(const INTEGER    *ICOMPQ,
                    const INTEGER    *NL,
                    const INTEGER    *NR,
                    const INTEGER    *SQRE,
                    const INTEGER    *NRHS,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *BX,
                    const INTEGER    *LDBX,
                    const INTEGER    *PERM,
                    const INTEGER    *GIVPTR,
                    const INTEGER    *GIVCOL,
                    const INTEGER    *LDGCOL,
                    const FLOAT      *GIVNUM,
                    const INTEGER    *LDGNUM,
                    const FLOAT      *POLES,
                    const FLOAT      *DIFL,
                    const FLOAT      *DIFR,
                    const FLOAT      *Z,
                    const INTEGER    *K,
                    const FLOAT      *C,
                    const FLOAT      *S,
                    FLOAT            *RWORK,
                    INTEGER          *INFO);

//-- clalsa --------------------------------------------------------------------
void
LAPACK_IMPL(clalsa)(const INTEGER    *ICOMPQ,
                    const INTEGER    *SMLSIZ,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *BX,
                    const INTEGER    *LDBX,
                    const FLOAT      *U,
                    const INTEGER    *LDU,
                    const FLOAT      *VT,
                    const INTEGER    *K,
                    const FLOAT      *DIFL,
                    const FLOAT      *DIFR,
                    const FLOAT      *Z,
                    const FLOAT      *POLES,
                    const INTEGER    *GIVPTR,
                    const INTEGER    *GIVCOL,
                    const INTEGER    *LDGCOL,
                    const INTEGER    *PERM,
                    const FLOAT      *GIVNUM,
                    const FLOAT      *C,
                    const FLOAT      *S,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- clalsd --------------------------------------------------------------------
void
LAPACK_IMPL(clalsd)(const char       *UPLO,
                    const INTEGER    *SMLSIZ,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    const FLOAT      *RCOND,
                    INTEGER          *RANK,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- clangb --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(clangb)(const char           *NORM,
                    const INTEGER        *N,
                    const INTEGER        *KL,
                    const INTEGER        *KU,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    FLOAT                *WORK);

//-- clange --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(clange)(const char           *NORM,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT                *WORK);

//-- clangt --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(clangt)(const char           *NORM,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *DL,
                    const FLOAT_COMPLEX  *D,
                    const FLOAT_COMPLEX  *DU);

//-- clanhb --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(clanhb)(const char           *NORM,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    FLOAT                *WORK);

//-- clanhe --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(clanhe)(const char           *NORM,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT                *WORK);

//-- clanhf --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(clanhf)(const char           *NORM,
                    const char           *TRANSR,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    FLOAT                *WORK);

//-- clanhp --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(clanhp)(const char           *NORM,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *AP,
                    FLOAT                *WORK);

//-- clanhs --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(clanhs)(const char           *NORM,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT                *WORK);

//-- clanht --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(clanht)(const char           *NORM,
                    const INTEGER        *N,
                    const FLOAT          *D,
                    const FLOAT_COMPLEX  *E);

//-- clansb --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(clansb)(const char           *NORM,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    FLOAT                *WORK);

//-- clansp --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(clansp)(const char           *NORM,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *AP,
                    FLOAT                *WORK);

//-- clansy --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(clansy)(const char           *NORM,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT                *WORK);

//-- clantb --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(clantb)(const char           *NORM,
                    const char           *UPLO,
                    const char           *DIAG,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    FLOAT                *WORK);

//-- clantp --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(clantp)(const char           *NORM,
                    const char           *UPLO,
                    const char           *DIAG,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *AP,
                    FLOAT                *WORK);

//-- clantr --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(clantr)(const char           *NORM,
                    const char           *UPLO,
                    const char           *DIAG,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT                *WORK);

//-- clapll --------------------------------------------------------------------
void
LAPACK_IMPL(clapll)(const INTEGER    *N,
                    FLOAT_COMPLEX    *X,
                    const INTEGER    *INCX,
                    FLOAT_COMPLEX    *Y,
                    const INTEGER    *INCY,
                    FLOAT            *SSMIN);

//-- clapmr --------------------------------------------------------------------
void
LAPACK_IMPL(clapmr)(const LOGICAL    *FORWRD,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *X,
                    const INTEGER    *LDX,
                    INTEGER          *K);

//-- clapmt --------------------------------------------------------------------
void
LAPACK_IMPL(clapmt)(const LOGICAL    *FORWRD,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *X,
                    const INTEGER    *LDX,
                    INTEGER          *K);

//-- claqgb --------------------------------------------------------------------
void
LAPACK_IMPL(claqgb)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    const FLOAT      *R,
                    const FLOAT      *C,
                    const FLOAT      *ROWCND,
                    const FLOAT      *COLCND,
                    const FLOAT      *AMAX,
                    char             *EQUED);

//-- claqge --------------------------------------------------------------------
void
LAPACK_IMPL(claqge)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    const FLOAT      *R,
                    const FLOAT      *C,
                    const FLOAT      *ROWCND,
                    const FLOAT      *COLCND,
                    const FLOAT      *AMAX,
                    char             *EQUED);

//-- claqhb --------------------------------------------------------------------
void
LAPACK_IMPL(claqhb)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *S,
                    const FLOAT      *SCOND,
                    const FLOAT      *AMAX,
                    char             *EQUED);

//-- claqhe --------------------------------------------------------------------
void
LAPACK_IMPL(claqhe)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    const FLOAT      *S,
                    const FLOAT      *SCOND,
                    const FLOAT      *AMAX,
                    char             *EQUED);

//-- claqhp --------------------------------------------------------------------
void
LAPACK_IMPL(claqhp)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    const FLOAT      *S,
                    const FLOAT      *SCOND,
                    const FLOAT      *AMAX,
                    char             *EQUED);

//-- claqp2 --------------------------------------------------------------------
void
LAPACK_IMPL(claqp2)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *OFFSET,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT            *VN1,
                    FLOAT            *VN2,
                    FLOAT_COMPLEX    *WORK);

//-- claqps --------------------------------------------------------------------
void
LAPACK_IMPL(claqps)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *OFFSET,
                    const INTEGER    *NB,
                    INTEGER          *KB,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT            *VN1,
                    FLOAT            *VN2,
                    FLOAT_COMPLEX    *AUXV,
                    FLOAT_COMPLEX    *F,
                    const INTEGER    *LDF);

//-- claqr0 --------------------------------------------------------------------
void
LAPACK_IMPL(claqr0)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT_COMPLEX    *H,
                    const INTEGER    *LDH,
                    FLOAT_COMPLEX    *W,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- claqr1 --------------------------------------------------------------------
void
LAPACK_IMPL(claqr1)(const INTEGER        *N,
                    const FLOAT_COMPLEX  *H,
                    const INTEGER        *LDH,
                    const FLOAT_COMPLEX  *S1,
                    const FLOAT_COMPLEX  *S2,
                    FLOAT_COMPLEX        *V);

//-- claqr2 --------------------------------------------------------------------
void
LAPACK_IMPL(claqr2)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *KTOP,
                    const INTEGER    *KBOT,
                    const INTEGER    *NW,
                    FLOAT_COMPLEX    *H,
                    const INTEGER    *LDH,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *NS,
                    INTEGER          *ND,
                    FLOAT_COMPLEX    *SH,
                    FLOAT_COMPLEX    *V,
                    const INTEGER    *LDV,
                    const INTEGER    *NH,
                    FLOAT_COMPLEX    *T,
                    const INTEGER    *LDT,
                    const INTEGER    *NV,
                    FLOAT_COMPLEX    *WV,
                    const INTEGER    *LDWV,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK);

//-- claqr3 --------------------------------------------------------------------
void
LAPACK_IMPL(claqr3)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *KTOP,
                    const INTEGER    *KBOT,
                    const INTEGER    *NW,
                    FLOAT_COMPLEX    *H,
                    const INTEGER    *LDH,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *NS,
                    INTEGER          *ND,
                    FLOAT_COMPLEX    *SH,
                    FLOAT_COMPLEX    *V,
                    const INTEGER    *LDV,
                    const INTEGER    *NH,
                    FLOAT_COMPLEX    *T,
                    const INTEGER    *LDT,
                    const INTEGER    *NV,
                    FLOAT_COMPLEX    *WV,
                    const INTEGER    *LDWV,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK);

//-- claqr4 --------------------------------------------------------------------
void
LAPACK_IMPL(claqr4)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT_COMPLEX    *H,
                    const INTEGER    *LDH,
                    FLOAT_COMPLEX    *W,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- claqr5 --------------------------------------------------------------------
void
LAPACK_IMPL(claqr5)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *KACC22,
                    const INTEGER    *N,
                    const INTEGER    *KTOP,
                    const INTEGER    *KBOT,
                    const INTEGER    *NSHFTS,
                    FLOAT_COMPLEX    *S,
                    FLOAT_COMPLEX    *H,
                    const INTEGER    *LDH,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *V,
                    const INTEGER    *LDV,
                    FLOAT_COMPLEX    *U,
                    const INTEGER    *LDU,
                    const INTEGER    *NV,
                    FLOAT_COMPLEX    *WV,
                    const INTEGER    *LDWV,
                    const INTEGER    *NH,
                    FLOAT_COMPLEX    *WH,
                    const INTEGER    *LDWH);

//-- claqsb --------------------------------------------------------------------
void
LAPACK_IMPL(claqsb)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    const FLOAT      *S,
                    const FLOAT      *SCOND,
                    const FLOAT      *AMAX,
                    char             *EQUED);

//-- claqsp --------------------------------------------------------------------
void
LAPACK_IMPL(claqsp)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    const FLOAT      *S,
                    const FLOAT      *SCOND,
                    const FLOAT      *AMAX,
                    char             *EQUED);

//-- claqsy --------------------------------------------------------------------
void
LAPACK_IMPL(claqsy)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    const FLOAT      *S,
                    const FLOAT      *SCOND,
                    const FLOAT      *AMAX,
                    char             *EQUED);

//-- clar1v --------------------------------------------------------------------
void
LAPACK_IMPL(clar1v)(const INTEGER    *N,
                    const INTEGER    *B1,
                    const INTEGER    *BN,
                    const FLOAT      *LAMBDA,
                    const FLOAT      *D,
                    const FLOAT      *L,
                    const FLOAT      *LD,
                    const FLOAT      *LLD,
                    const FLOAT      *PIVMIN,
                    const FLOAT      *GAPTOL,
                    FLOAT_COMPLEX    *Z,
                    const LOGICAL    *WANTNC,
                    INTEGER          *NEGCNT,
                    FLOAT            *ZTZ,
                    FLOAT            *MINGMA,
                    INTEGER          *R,
                    INTEGER          *ISUPPZ,
                    FLOAT            *NRMINV,
                    FLOAT            *RESID,
                    FLOAT            *RQCORR,
                    FLOAT            *WORK);

//-- clar2v --------------------------------------------------------------------
void
LAPACK_IMPL(clar2v)(const INTEGER        *N,
                    FLOAT_COMPLEX        *X,
                    FLOAT_COMPLEX        *Y,
                    FLOAT_COMPLEX        *Z,
                    const INTEGER        *INCX,
                    const FLOAT          *C,
                    const FLOAT_COMPLEX  *S,
                    const INTEGER        *INCC);

//-- clarcm --------------------------------------------------------------------
void
LAPACK_IMPL(clarcm)(const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT          *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    const FLOAT_COMPLEX  *C,
                    const INTEGER        *LDC,
                    FLOAT                *RWORK);

//-- clarf ---------------------------------------------------------------------
void
LAPACK_IMPL(clarf)(const char               *SIDE,
                   const INTEGER            *M,
                   const INTEGER            *N,
                   const FLOAT_COMPLEX      *V,
                   const INTEGER            *INCV,
                   const FLOAT_COMPLEX      *TAU,
                   FLOAT_COMPLEX            *C,
                   const INTEGER            *LDC,
                   FLOAT_COMPLEX            *WORK);

//-- clarfb --------------------------------------------------------------------
void
LAPACK_IMPL(clarfb)(const char           *SIDE,
                    const char           *TRANS,
                    const char           *DIRECT,
                    const char           *STOREV,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const FLOAT_COMPLEX  *V,
                    const INTEGER        *LDV,
                    const FLOAT_COMPLEX  *T,
                    const INTEGER        *LDT,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LDWORK);

//-- clarfg --------------------------------------------------------------------
void
LAPACK_IMPL(clarfg)(const INTEGER    *N,
                    FLOAT_COMPLEX    *ALPHA,
                    FLOAT_COMPLEX    *X,
                    const INTEGER    *INCX,
                    FLOAT_COMPLEX    *TAU);

//-- clarfgp -------------------------------------------------------------------
void
LAPACK_IMPL(clarfgp)(const INTEGER    *N,
                     FLOAT_COMPLEX    *ALPHA,
                     FLOAT_COMPLEX    *X,
                     const INTEGER    *INCX,
                     FLOAT_COMPLEX    *TAU);

//-- clarft --------------------------------------------------------------------
void
LAPACK_IMPL(clarft)(const char           *DIRECT,
                    const char           *STOREV,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    FLOAT_COMPLEX        *V,
                    const INTEGER        *LDV,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *T,
                    const INTEGER        *LDT);

//-- clarfx --------------------------------------------------------------------
void
LAPACK_IMPL(clarfx)(const char           *SIDE,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *V,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK);

//-- clargv --------------------------------------------------------------------
void
LAPACK_IMPL(clargv)(const INTEGER    *N,
                    FLOAT_COMPLEX    *X,
                    const INTEGER    *INCX,
                    FLOAT_COMPLEX    *Y,
                    const INTEGER    *INCY,
                    FLOAT            *C,
                    const INTEGER    *INCC);

//-- clarnv --------------------------------------------------------------------
void
LAPACK_IMPL(clarnv)(const INTEGER    *IDIST,
                    INTEGER          *ISEED,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *X);

//-- clarrv --------------------------------------------------------------------
void
LAPACK_IMPL(clarrv)(const INTEGER    *N,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    FLOAT            *D,
                    FLOAT            *L,
                    const FLOAT      *PIVMIN,
                    const INTEGER    *ISPLIT,
                    const INTEGER    *M,
                    const INTEGER    *DOL,
                    const INTEGER    *DOU,
                    const FLOAT      *MINRGP,
                    const FLOAT      *RTOL1,
                    const FLOAT      *RTOL2,
                    FLOAT            *W,
                    FLOAT            *WERR,
                    FLOAT            *WGAP,
                    const INTEGER    *IBLOCK,
                    const INTEGER    *INDEXW,
                    const FLOAT      *GERS,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *ISUPPZ,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- clarscl2 ------------------------------------------------------------------
void
LAPACK_IMPL(clarscl2)(const INTEGER    *M,
                      const INTEGER    *N,
                      const FLOAT      *D,
                      FLOAT_COMPLEX    *X,
                      const INTEGER    *LDX);

//-- clartg --------------------------------------------------------------------
void
LAPACK_IMPL(clartg)(const FLOAT_COMPLEX  *F,
                    const FLOAT_COMPLEX  *G,
                    FLOAT                *CS,
                    FLOAT_COMPLEX        *SN,
                    FLOAT_COMPLEX        *R);

//-- clartv --------------------------------------------------------------------
void
LAPACK_IMPL(clartv)(const INTEGER        *N,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *INCX,
                    FLOAT_COMPLEX        *Y,
                    const INTEGER        *INCY,
                    const FLOAT          *C,
                    const FLOAT_COMPLEX  *S,
                    const INTEGER        *INCC);

//-- clarz ---------------------------------------------------------------------
void
LAPACK_IMPL(clarz)(const char               *SIDE,
                   const INTEGER            *M,
                   const INTEGER            *N,
                   const INTEGER            *L,
                   const FLOAT_COMPLEX      *V,
                   const INTEGER            *INCV,
                   const FLOAT_COMPLEX      *TAU,
                   FLOAT_COMPLEX            *C,
                   const INTEGER            *LDC,
                   FLOAT_COMPLEX            *WORK);

//-- clarzb --------------------------------------------------------------------
void
LAPACK_IMPL(clarzb)(const char           *SIDE,
                    const char           *TRANS,
                    const char           *DIRECT,
                    const char           *STOREV,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const INTEGER        *L,
                    const FLOAT_COMPLEX  *V,
                    const INTEGER        *LDV,
                    const FLOAT_COMPLEX  *T,
                    const INTEGER        *LDT,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LDWORK);

//-- clarzt --------------------------------------------------------------------
void
LAPACK_IMPL(clarzt)(const char           *DIRECT,
                    const char           *STOREV,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    FLOAT_COMPLEX        *V,
                    const INTEGER        *LDV,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *T,
                    const INTEGER        *LDT);

//-- clascl --------------------------------------------------------------------
void
LAPACK_IMPL(clascl)(const char       *TYPE,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const FLOAT      *CFROM,
                    const FLOAT      *CTO,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- clascl2 -------------------------------------------------------------------
void
LAPACK_IMPL(clascl2)(const INTEGER    *M,
                     const INTEGER    *N,
                     const FLOAT      *D,
                     FLOAT_COMPLEX    *X,
                     const INTEGER    *LDX);

//-- claset --------------------------------------------------------------------
void
LAPACK_IMPL(claset)(const char           *UPLO,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *ALPHA,
                    const FLOAT_COMPLEX  *BETA,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA);

//-- clasr ---------------------------------------------------------------------
void
LAPACK_IMPL(clasr)(const char           *SIDE,
                   const char           *PIVOT,
                   const char           *DIRECT,
                   const INTEGER        *M,
                   const INTEGER        *N,
                   const FLOAT          *C,
                   const FLOAT          *S,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA);

//-- classq --------------------------------------------------------------------
void
LAPACK_IMPL(classq)(const INTEGER        *N,
                    const FLOAT_COMPLEX  *X,
                    const INTEGER        *INCX,
                    FLOAT                *SCALE,
                    FLOAT                *SUMSQ);

//-- claswp --------------------------------------------------------------------
void
LAPACK_IMPL(claswp)(const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    const INTEGER    *K1,
                    const INTEGER    *K2,
                    const INTEGER    *IPIV,
                    const INTEGER    *INCX);

//-- clasyf --------------------------------------------------------------------
void
LAPACK_IMPL(clasyf)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NB,
                    INTEGER          *KB,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    FLOAT_COMPLEX    *W,
                    const INTEGER    *LDW,
                    INTEGER          *INFO);

//-- clatbs --------------------------------------------------------------------
void
LAPACK_IMPL(clatbs)(const char           *UPLO,
                    const char           *TRANS,
                    const char           *DIAG,
                    const char           *NORMIN,
                    const INTEGER        *N,
                    const INTEGER        *KD,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    FLOAT_COMPLEX        *X,
                    FLOAT                *SCALE,
                    FLOAT                *CNORM,
                    INTEGER              *INFO);

//-- clatdf --------------------------------------------------------------------
void
LAPACK_IMPL(clatdf)(const INTEGER        *IJOB,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *Z,
                    const INTEGER        *LDZ,
                    FLOAT_COMPLEX        *RHS,
                    FLOAT                *RDSUM,
                    FLOAT                *RDSCAL,
                    const INTEGER        *IPIV,
                    const INTEGER        *JPIV);

//-- clatps --------------------------------------------------------------------
void
LAPACK_IMPL(clatps)(const char           *UPLO,
                    const char           *TRANS,
                    const char           *DIAG,
                    const char           *NORMIN,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *AP,
                    FLOAT_COMPLEX        *X,
                    FLOAT                *SCALE,
                    FLOAT                *CNORM,
                    INTEGER              *INFO);

//-- clatrd --------------------------------------------------------------------
void
LAPACK_IMPL(clatrd)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NB,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *W,
                    const INTEGER    *LDW);

//-- clatrs --------------------------------------------------------------------
void
LAPACK_IMPL(clatrs)(const char           *UPLO,
                    const char           *TRANS,
                    const char           *DIAG,
                    const char           *NORMIN,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT_COMPLEX        *X,
                    FLOAT                *SCALE,
                    FLOAT                *CNORM,
                    INTEGER              *INFO);

//-- clatrz --------------------------------------------------------------------
void
LAPACK_IMPL(clatrz)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *L,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK);

//-- clatzm --------------------------------------------------------------------
void
LAPACK_IMPL(clatzm)(const char           *SIDE,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *V,
                    const INTEGER        *INCV,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C1,
                    FLOAT_COMPLEX        *C2,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK);

//-- clauu2 --------------------------------------------------------------------
void
LAPACK_IMPL(clauu2)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- clauum --------------------------------------------------------------------
void
LAPACK_IMPL(clauum)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- cpbcon --------------------------------------------------------------------
void
LAPACK_IMPL(cpbcon)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *KD,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    const FLOAT          *ANORM,
                    FLOAT                *RCOND,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- cpbequ --------------------------------------------------------------------
void
LAPACK_IMPL(cpbequ)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *KD,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    FLOAT                *S,
                    FLOAT                *SCOND,
                    FLOAT                *AMAX,
                    INTEGER              *INFO);

//-- cpbrfs --------------------------------------------------------------------
void
LAPACK_IMPL(cpbrfs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *KD,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    const FLOAT_COMPLEX  *AFB,
                    const INTEGER        *LDAFB,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- cpbstf --------------------------------------------------------------------
void
LAPACK_IMPL(cpbstf)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *INFO);

//-- cpbsv ---------------------------------------------------------------------
void
LAPACK_IMPL(cpbsv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *KD,
                   const INTEGER        *NRHS,
                   FLOAT_COMPLEX        *AB,
                   const INTEGER        *LDAB,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- cpbsvx --------------------------------------------------------------------
void
LAPACK_IMPL(cpbsvx)(const char       *FACT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const INTEGER    *NRHS,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    FLOAT_COMPLEX    *AFB,
                    const INTEGER    *LDAFB,
                    char             *EQUED,
                    FLOAT            *S,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *X,
                    const INTEGER    *LDX,
                    FLOAT            *RCOND,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO);

//-- cpbtf2 --------------------------------------------------------------------
void
LAPACK_IMPL(cpbtf2)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *INFO);

//-- cpbtrf --------------------------------------------------------------------
void
LAPACK_IMPL(cpbtrf)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *INFO);

//-- cpbtrs --------------------------------------------------------------------
void
LAPACK_IMPL(cpbtrs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *KD,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO);

//-- cpftrf --------------------------------------------------------------------
void
LAPACK_IMPL(cpftrf)(const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    INTEGER          *INFO);

//-- cpftri --------------------------------------------------------------------
void
LAPACK_IMPL(cpftri)(const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    INTEGER          *INFO);

//-- cpftrs --------------------------------------------------------------------
void
LAPACK_IMPL(cpftrs)(const char           *TRANSR,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *A,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO);

//-- cpocon --------------------------------------------------------------------
void
LAPACK_IMPL(cpocon)(const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT          *ANORM,
                    FLOAT                *RCOND,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- cpoequ --------------------------------------------------------------------
void
LAPACK_IMPL(cpoequ)(const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT                *S,
                    FLOAT                *SCOND,
                    FLOAT                *AMAX,
                    INTEGER              *INFO);

//-- cpoequb -------------------------------------------------------------------
void
LAPACK_IMPL(cpoequb)(const INTEGER            *N,
                     const FLOAT_COMPLEX      *A,
                     const INTEGER            *LDA,
                     FLOAT                    *S,
                     FLOAT                    *SCOND,
                     FLOAT                    *AMAX,
                     INTEGER                  *INFO);

//-- cporfs --------------------------------------------------------------------
void
LAPACK_IMPL(cporfs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *AF,
                    const INTEGER        *LDAF,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- cporfsx -------------------------------------------------------------------
void
LAPACK_IMPL(cporfsx)(const char               *UPLO,
                     const char               *EQUED,
                     const INTEGER            *N,
                     const INTEGER            *NRHS,
                     const FLOAT_COMPLEX      *A,
                     const INTEGER            *LDA,
                     const FLOAT_COMPLEX      *AF,
                     const INTEGER            *LDAF,
                     FLOAT                    *S,
                     const FLOAT_COMPLEX      *B,
                     const INTEGER            *LDB,
                     FLOAT_COMPLEX            *X,
                     const INTEGER            *LDX,
                     FLOAT                    *RCOND,
                     FLOAT                    *BERR,
                     const INTEGER            *N_ERR_BNDS,
                     FLOAT                    *ERR_BNDS_NORM,
                     FLOAT                    *ERR_BNDS_COMP,
                     const INTEGER            *NPARAMS,
                     FLOAT                    *PARAMS,
                     FLOAT_COMPLEX            *WORK,
                     FLOAT                    *RWORK,
                     INTEGER                  *INFO);

//-- cposv ---------------------------------------------------------------------
void
LAPACK_IMPL(cposv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- cposvx --------------------------------------------------------------------
void
LAPACK_IMPL(cposvx)(const char       *FACT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *AF,
                    const INTEGER    *LDAF,
                    char             *EQUED,
                    FLOAT            *S,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *X,
                    const INTEGER    *LDX,
                    FLOAT            *RCOND,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO);

//-- cposvxx -------------------------------------------------------------------
void
LAPACK_IMPL(cposvxx)(const char       *FACT,
                     const char       *UPLO,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     FLOAT_COMPLEX    *A,
                     const INTEGER    *LDA,
                     FLOAT_COMPLEX    *AF,
                     const INTEGER    *LDAF,
                     char             *EQUED,
                     FLOAT            *S,
                     FLOAT_COMPLEX    *B,
                     const INTEGER    *LDB,
                     FLOAT_COMPLEX    *X,
                     const INTEGER    *LDX,
                     FLOAT            *RCOND,
                     FLOAT            *RPVGRW,
                     FLOAT            *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     FLOAT            *ERR_BNDS_NORM,
                     FLOAT            *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     FLOAT            *PARAMS,
                     FLOAT_COMPLEX    *WORK,
                     FLOAT            *RWORK,
                     INTEGER          *INFO);

//-- cpotf2 --------------------------------------------------------------------
void
LAPACK_IMPL(cpotf2)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- cpotrf --------------------------------------------------------------------
void
LAPACK_IMPL(cpotrf)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- cpotri --------------------------------------------------------------------
void
LAPACK_IMPL(cpotri)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- cpotrs --------------------------------------------------------------------
void
LAPACK_IMPL(cpotrs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO);

//-- cppcon --------------------------------------------------------------------
void
LAPACK_IMPL(cppcon)(const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *AP,
                    const FLOAT          *ANORM,
                    FLOAT                *RCOND,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- cppequ --------------------------------------------------------------------
void
LAPACK_IMPL(cppequ)(const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *AP,
                    FLOAT                *S,
                    FLOAT                *SCOND,
                    FLOAT                *AMAX,
                    INTEGER              *INFO);

//-- cpprfs --------------------------------------------------------------------
void
LAPACK_IMPL(cpprfs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AP,
                    const FLOAT_COMPLEX  *AFP,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- cppsv ---------------------------------------------------------------------
void
LAPACK_IMPL(cppsv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT_COMPLEX        *AP,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- cppsvx --------------------------------------------------------------------
void
LAPACK_IMPL(cppsvx)(const char       *FACT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT_COMPLEX    *AP,
                    FLOAT_COMPLEX    *AFP,
                    char             *EQUED,
                    FLOAT            *S,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *X,
                    const INTEGER    *LDX,
                    FLOAT            *RCOND,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO);

//-- cpptrf --------------------------------------------------------------------
void
LAPACK_IMPL(cpptrf)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    INTEGER          *INFO);

//-- cpptri --------------------------------------------------------------------
void
LAPACK_IMPL(cpptri)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    INTEGER          *INFO);

//-- cpptrs --------------------------------------------------------------------
void
LAPACK_IMPL(cpptrs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AP,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO);

//-- cpstf2 --------------------------------------------------------------------
void
LAPACK_IMPL(cpstf2)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *PIV,
                    INTEGER          *RANK,
                    const FLOAT      *TOL,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- cpstrf --------------------------------------------------------------------
void
LAPACK_IMPL(cpstrf)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *PIV,
                    INTEGER          *RANK,
                    const FLOAT      *TOL,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- cptcon --------------------------------------------------------------------
void
LAPACK_IMPL(cptcon)(const INTEGER        *N,
                    const FLOAT          *D,
                    const FLOAT_COMPLEX  *E,
                    const FLOAT          *ANORM,
                    FLOAT                *RCOND,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- cpteqr --------------------------------------------------------------------
void
LAPACK_IMPL(cpteqr)(const char       *COMPZ,
                    const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- cptrfs --------------------------------------------------------------------
void
LAPACK_IMPL(cptrfs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT          *D,
                    const FLOAT_COMPLEX  *E,
                    const FLOAT          *DF,
                    const FLOAT_COMPLEX  *EF,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- cptsv ---------------------------------------------------------------------
void
LAPACK_IMPL(cptsv)(const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT                *D,
                   FLOAT_COMPLEX        *E,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- cptsvx --------------------------------------------------------------------
void
LAPACK_IMPL(cptsvx)(const char           *FACT,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT          *D,
                    const FLOAT_COMPLEX  *E,
                    FLOAT                *DF,
                    FLOAT_COMPLEX        *EF,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *RCOND,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- cpttrf --------------------------------------------------------------------
void
LAPACK_IMPL(cpttrf)(const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT_COMPLEX    *E,
                    INTEGER          *INFO);

//-- cpttrs --------------------------------------------------------------------
void
LAPACK_IMPL(cpttrs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT          *D,
                    const FLOAT_COMPLEX  *E,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO);

//-- cptts2 --------------------------------------------------------------------
void
LAPACK_IMPL(cptts2)(const INTEGER        *IUPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT          *D,
                    const FLOAT_COMPLEX  *E,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB);

//-- crot ----------------------------------------------------------------------
void
LAPACK_IMPL(crot)(const INTEGER            *N,
                  FLOAT_COMPLEX            *CX,
                  const INTEGER            *INCX,
                  FLOAT_COMPLEX            *CY,
                  const INTEGER            *INCY,
                  const FLOAT              *C,
                  const FLOAT_COMPLEX      *S);

//-- cspcon --------------------------------------------------------------------
void
LAPACK_IMPL(cspcon)(const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *AP,
                    const INTEGER        *IPIV,
                    const FLOAT          *ANORM,
                    FLOAT                *RCOND,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO);

//-- cspmv ---------------------------------------------------------------------
void
LAPACK_IMPL(cspmv)(const char               *UPLO,
                   const INTEGER            *N,
                   const FLOAT_COMPLEX      *ALPHA,
                   const FLOAT_COMPLEX      *AP,
                   const FLOAT_COMPLEX      *X,
                   const INTEGER            *INCX,
                   const FLOAT_COMPLEX      *BETA,
                   FLOAT_COMPLEX            *Y,
                   const INTEGER            *INCY);

//-- cspr ----------------------------------------------------------------------
void
LAPACK_IMPL(cspr)(const char               *UPLO,
                  const INTEGER            *N,
                  const FLOAT_COMPLEX      *ALPHA,
                  const FLOAT_COMPLEX      *X,
                  const INTEGER            *INCX,
                  FLOAT_COMPLEX            *AP);

//-- csprfs --------------------------------------------------------------------
void
LAPACK_IMPL(csprfs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AP,
                    const FLOAT_COMPLEX  *AFP,
                    const INTEGER        *IPIV,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- cspsv ---------------------------------------------------------------------
void
LAPACK_IMPL(cspsv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT_COMPLEX        *AP,
                   INTEGER              *IPIV,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- cspsvx --------------------------------------------------------------------
void
LAPACK_IMPL(cspsvx)(const char           *FACT,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AP,
                    FLOAT_COMPLEX        *AFP,
                    INTEGER              *IPIV,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *RCOND,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- csptrf --------------------------------------------------------------------
void
LAPACK_IMPL(csptrf)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- csptri --------------------------------------------------------------------
void
LAPACK_IMPL(csptri)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    const INTEGER    *IPIV,
                    FLOAT_COMPLEX    *WORK,
                    INTEGER          *INFO);

//-- csptrs --------------------------------------------------------------------
void
LAPACK_IMPL(csptrs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AP,
                    const INTEGER        *IPIV,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO);

//-- csrscl --------------------------------------------------------------------
void
LAPACK_IMPL(csrscl)(const INTEGER    *N,
                    const FLOAT      *SA,
                    FLOAT_COMPLEX    *SX,
                    const INTEGER    *INCX);

//-- cstedc --------------------------------------------------------------------
void
LAPACK_IMPL(cstedc)(const char       *COMPZ,
                    const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    const INTEGER    *LRWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- cstegr --------------------------------------------------------------------
void
LAPACK_IMPL(cstegr)(const char       *JOBZ,
                    const char       *RANGE,
                    const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *E,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *ABSTOL,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *ISUPPZ,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- cstein --------------------------------------------------------------------
void
LAPACK_IMPL(cstein)(const INTEGER    *N,
                    const FLOAT      *D,
                    const FLOAT      *E,
                    const INTEGER    *M,
                    const FLOAT      *W,
                    const INTEGER    *IBLOCK,
                    const INTEGER    *ISPLIT,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- cstemr --------------------------------------------------------------------
void
LAPACK_IMPL(cstemr)(const char       *JOBZ,
                    const char       *RANGE,
                    const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *E,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    const INTEGER    *NZC,
                    INTEGER          *ISUPPZ,
                    LOGICAL          *TRYRAC,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- csteqr --------------------------------------------------------------------
void
LAPACK_IMPL(csteqr)(const char       *COMPZ,
                    const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- csycon --------------------------------------------------------------------
void
LAPACK_IMPL(csycon)(const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const INTEGER        *IPIV,
                    const FLOAT          *ANORM,
                    FLOAT                *RCOND,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO);

//-- csyconv -------------------------------------------------------------------
void
LAPACK_IMPL(csyconv)(const char               *UPLO,
                     const char               *WAY,
                     const INTEGER            *N,
                     const FLOAT_COMPLEX      *A,
                     const INTEGER            *LDA,
                     const INTEGER            *IPIV,
                     FLOAT_COMPLEX            *WORK,
                     INTEGER                  *INFO);

//-- csyequb -------------------------------------------------------------------
void
LAPACK_IMPL(csyequb)(const char               *UPLO,
                     const INTEGER            *N,
                     const FLOAT_COMPLEX      *A,
                     const INTEGER            *LDA,
                     FLOAT                    *S,
                     FLOAT                    *SCOND,
                     FLOAT                    *AMAX,
                     FLOAT_COMPLEX            *WORK,
                     INTEGER                  *INFO);

//-- csymv ---------------------------------------------------------------------
void
LAPACK_IMPL(csymv)(const char               *UPLO,
                   const INTEGER            *N,
                   const FLOAT_COMPLEX      *ALPHA,
                   const FLOAT_COMPLEX      *A,
                   const INTEGER            *LDA,
                   const FLOAT_COMPLEX      *X,
                   const INTEGER            *INCX,
                   const FLOAT_COMPLEX      *BETA,
                   FLOAT_COMPLEX            *Y,
                   const INTEGER            *INCY);

//-- csyr ----------------------------------------------------------------------
void
LAPACK_IMPL(csyr)(const char               *UPLO,
                  const INTEGER            *N,
                  const FLOAT_COMPLEX      *ALPHA,
                  const FLOAT_COMPLEX      *X,
                  const INTEGER            *INCX,
                  FLOAT_COMPLEX            *A,
                  const INTEGER            *LDA);

//-- csyrfs --------------------------------------------------------------------
void
LAPACK_IMPL(csyrfs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *AF,
                    const INTEGER        *LDAF,
                    const INTEGER        *IPIV,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- csyrfsx -------------------------------------------------------------------
void
LAPACK_IMPL(csyrfsx)(const char               *UPLO,
                     const char               *EQUED,
                     const INTEGER            *N,
                     const INTEGER            *NRHS,
                     const FLOAT_COMPLEX      *A,
                     const INTEGER            *LDA,
                     const FLOAT_COMPLEX      *AF,
                     const INTEGER            *LDAF,
                     const INTEGER            *IPIV,
                     FLOAT                    *S,
                     const FLOAT_COMPLEX      *B,
                     const INTEGER            *LDB,
                     FLOAT_COMPLEX            *X,
                     const INTEGER            *LDX,
                     FLOAT                    *RCOND,
                     FLOAT                    *BERR,
                     const INTEGER            *N_ERR_BNDS,
                     FLOAT                    *ERR_BNDS_NORM,
                     FLOAT                    *ERR_BNDS_COMP,
                     const INTEGER            *NPARAMS,
                     FLOAT                    *PARAMS,
                     FLOAT_COMPLEX            *WORK,
                     FLOAT                    *RWORK,
                     INTEGER                  *INFO);

//-- csysv ---------------------------------------------------------------------
void
LAPACK_IMPL(csysv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA,
                   INTEGER              *IPIV,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   FLOAT_COMPLEX        *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO);

//-- csysvx --------------------------------------------------------------------
void
LAPACK_IMPL(csysvx)(const char           *FACT,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT_COMPLEX        *AF,
                    const INTEGER        *LDAF,
                    INTEGER              *IPIV,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *RCOND,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- csysvxx -------------------------------------------------------------------
void
LAPACK_IMPL(csysvxx)(const char       *FACT,
                     const char       *UPLO,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     FLOAT_COMPLEX    *A,
                     const INTEGER    *LDA,
                     FLOAT_COMPLEX    *AF,
                     const INTEGER    *LDAF,
                     INTEGER          *IPIV,
                     char             *EQUED,
                     FLOAT            *S,
                     FLOAT_COMPLEX    *B,
                     const INTEGER    *LDB,
                     FLOAT_COMPLEX    *X,
                     const INTEGER    *LDX,
                     FLOAT            *RCOND,
                     FLOAT            *RPVGRW,
                     FLOAT            *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     FLOAT            *ERR_BNDS_NORM,
                     FLOAT            *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     FLOAT            *PARAMS,
                     FLOAT_COMPLEX    *WORK,
                     FLOAT            *RWORK,
                     INTEGER          *INFO);

//-- csyswapr ------------------------------------------------------------------
void
LAPACK_IMPL(csyswapr)(const char       *UPLO,
                      const INTEGER    *N,
                      FLOAT_COMPLEX    *A,
                      const INTEGER    *LDA,
                      const INTEGER    *I1,
                      const INTEGER    *I2);

//-- csytf2 --------------------------------------------------------------------
void
LAPACK_IMPL(csytf2)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- csytrf --------------------------------------------------------------------
void
LAPACK_IMPL(csytrf)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- csytri --------------------------------------------------------------------
void
LAPACK_IMPL(csytri)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    const INTEGER    *IPIV,
                    FLOAT_COMPLEX    *WORK,
                    INTEGER          *INFO);

//-- csytri2 -------------------------------------------------------------------
void
LAPACK_IMPL(csytri2)(const char       *UPLO,
                     const INTEGER    *N,
                     FLOAT_COMPLEX    *A,
                     const INTEGER    *LDA,
                     const INTEGER    *IPIV,
                     FLOAT_COMPLEX    *WORK,
                     const INTEGER    *LWORK,
                     INTEGER          *INFO);

//-- csytri2x ------------------------------------------------------------------
void
LAPACK_IMPL(csytri2x)(const char       *UPLO,
                      const INTEGER    *N,
                      FLOAT_COMPLEX    *A,
                      const INTEGER    *LDA,
                      const INTEGER    *IPIV,
                      FLOAT_COMPLEX    *WORK,
                      const INTEGER    *NB,
                      INTEGER          *INFO);

//-- csytrs --------------------------------------------------------------------
void
LAPACK_IMPL(csytrs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const INTEGER        *IPIV,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO);

//-- csytrs2 -------------------------------------------------------------------
void
LAPACK_IMPL(csytrs2)(const char               *UPLO,
                     const INTEGER            *N,
                     const INTEGER            *NRHS,
                     const FLOAT_COMPLEX      *A,
                     const INTEGER            *LDA,
                     const INTEGER            *IPIV,
                     FLOAT_COMPLEX            *B,
                     const INTEGER            *LDB,
                     FLOAT_COMPLEX            *WORK,
                     INTEGER                  *INFO);

//-- ctbcon --------------------------------------------------------------------
void
LAPACK_IMPL(ctbcon)(const char           *NORM,
                    const char           *UPLO,
                    const char           *DIAG,
                    const INTEGER        *N,
                    const INTEGER        *KD,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    FLOAT                *RCOND,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- ctbrfs --------------------------------------------------------------------
void
LAPACK_IMPL(ctbrfs)(const char           *UPLO,
                    const char           *TRANS,
                    const char           *DIAG,
                    const INTEGER        *N,
                    const INTEGER        *KD,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    const FLOAT_COMPLEX  *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- ctbtrs --------------------------------------------------------------------
void
LAPACK_IMPL(ctbtrs)(const char           *UPLO,
                    const char           *TRANS,
                    const char           *DIAG,
                    const INTEGER        *N,
                    const INTEGER        *KD,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO);

//-- ctfsm ---------------------------------------------------------------------
void
LAPACK_IMPL(ctfsm)(const char               *TRANSR,
                   const char               *SIDE,
                   const char               *UPLO,
                   const char               *TRANS,
                   const char               *DIAG,
                   const INTEGER            *M,
                   const INTEGER            *N,
                   const FLOAT_COMPLEX      *ALPHA,
                   const FLOAT_COMPLEX      *A,
                   FLOAT_COMPLEX            *B,
                   const INTEGER            *LDB);

//-- ctftri --------------------------------------------------------------------
void
LAPACK_IMPL(ctftri)(const char       *TRANSR,
                    const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    INTEGER          *INFO);

//-- ctfttp --------------------------------------------------------------------
void
LAPACK_IMPL(ctfttp)(const char           *TRANSR,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *ARF,
                    FLOAT_COMPLEX        *AP,
                    INTEGER              *INFO);

//-- ctfttr --------------------------------------------------------------------
void
LAPACK_IMPL(ctfttr)(const char           *TRANSR,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *ARF,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    INTEGER              *INFO);

//-- ctgevc --------------------------------------------------------------------
void
LAPACK_IMPL(ctgevc)(const char           *SIDE,
                    const char           *HOWMNY,
                    const LOGICAL        *SELECT,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *S,
                    const INTEGER        *LDS,
                    const FLOAT_COMPLEX  *P,
                    const INTEGER        *LDP,
                    FLOAT_COMPLEX        *VL,
                    const INTEGER        *LDVL,
                    FLOAT_COMPLEX        *VR,
                    const INTEGER        *LDVR,
                    const INTEGER        *MM,
                    INTEGER              *M,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- ctgex2 --------------------------------------------------------------------
void
LAPACK_IMPL(ctgex2)(const LOGICAL    *WANTQ,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    const INTEGER    *J1,
                    INTEGER          *INFO);

//-- ctgexc --------------------------------------------------------------------
void
LAPACK_IMPL(ctgexc)(const LOGICAL    *WANTQ,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    const INTEGER    *IFST,
                    INTEGER          *ILST,
                    INTEGER          *INFO);

//-- ctgsen --------------------------------------------------------------------
void
LAPACK_IMPL(ctgsen)(const INTEGER    *IJOB,
                    const LOGICAL    *WANTQ,
                    const LOGICAL    *WANTZ,
                    const LOGICAL    *SELECT,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *ALPHA,
                    FLOAT_COMPLEX    *BETA,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *M,
                    FLOAT            *PL,
                    FLOAT            *PR,
                    FLOAT            *DIF,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- ctgsja --------------------------------------------------------------------
void
LAPACK_IMPL(ctgsja)(const char       *JOBU,
                    const char       *JOBV,
                    const char       *JOBQ,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *L,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    const FLOAT      *TOLA,
                    const FLOAT      *TOLB,
                    FLOAT            *ALPHA,
                    FLOAT            *BETA,
                    FLOAT_COMPLEX    *U,
                    const INTEGER    *LDU,
                    FLOAT_COMPLEX    *V,
                    const INTEGER    *LDV,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    FLOAT_COMPLEX    *WORK,
                    INTEGER          *NCYCLE,
                    INTEGER          *INFO);

//-- ctgsna --------------------------------------------------------------------
void
LAPACK_IMPL(ctgsna)(const char           *JOB,
                    const char           *HOWMNY,
                    const LOGICAL        *SELECT,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    const FLOAT_COMPLEX  *VL,
                    const INTEGER        *LDVL,
                    const FLOAT_COMPLEX  *VR,
                    const INTEGER        *LDVR,
                    FLOAT                *S,
                    FLOAT                *DIF,
                    const INTEGER        *MM,
                    INTEGER              *M,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *IWORK,
                    INTEGER              *INFO);

//-- ctgsy2 --------------------------------------------------------------------
void
LAPACK_IMPL(ctgsy2)(const char           *TRANS,
                    const INTEGER        *IJOB,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    const FLOAT_COMPLEX  *D,
                    const INTEGER        *LDD,
                    const FLOAT_COMPLEX  *E,
                    const INTEGER        *LDE,
                    FLOAT_COMPLEX        *F,
                    const INTEGER        *LDF,
                    FLOAT                *SCALE,
                    FLOAT                *RDSUM,
                    FLOAT                *RDSCAL,
                    INTEGER              *INFO);

//-- ctgsyl --------------------------------------------------------------------
void
LAPACK_IMPL(ctgsyl)(const char           *TRANS,
                    const INTEGER        *IJOB,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    const FLOAT_COMPLEX  *D,
                    const INTEGER        *LDD,
                    const FLOAT_COMPLEX  *E,
                    const INTEGER        *LDE,
                    FLOAT_COMPLEX        *F,
                    const INTEGER        *LDF,
                    FLOAT                *SCALE,
                    FLOAT                *DIF,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *IWORK,
                    INTEGER              *INFO);

//-- ctpcon --------------------------------------------------------------------
void
LAPACK_IMPL(ctpcon)(const char           *NORM,
                    const char           *UPLO,
                    const char           *DIAG,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *AP,
                    FLOAT                *RCOND,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- ctprfs --------------------------------------------------------------------
void
LAPACK_IMPL(ctprfs)(const char           *UPLO,
                    const char           *TRANS,
                    const char           *DIAG,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AP,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    const FLOAT_COMPLEX  *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- ctptri --------------------------------------------------------------------
void
LAPACK_IMPL(ctptri)(const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    INTEGER          *INFO);

//-- ctptrs --------------------------------------------------------------------
void
LAPACK_IMPL(ctptrs)(const char           *UPLO,
                    const char           *TRANS,
                    const char           *DIAG,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AP,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO);

//-- ctpttf --------------------------------------------------------------------
void
LAPACK_IMPL(ctpttf)(const char           *TRANSR,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *AP,
                    FLOAT_COMPLEX        *ARF,
                    INTEGER              *INFO);

//-- ctpttr --------------------------------------------------------------------
void
LAPACK_IMPL(ctpttr)(const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *AP,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    INTEGER              *INFO);

//-- ctrcon --------------------------------------------------------------------
void
LAPACK_IMPL(ctrcon)(const char           *NORM,
                    const char           *UPLO,
                    const char           *DIAG,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT                *RCOND,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- ctrevc --------------------------------------------------------------------
void
LAPACK_IMPL(ctrevc)(const char       *SIDE,
                    const char       *HOWMNY,
                    const LOGICAL    *SELECT,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *T,
                    const INTEGER    *LDT,
                    FLOAT_COMPLEX    *VL,
                    const INTEGER    *LDVL,
                    FLOAT_COMPLEX    *VR,
                    const INTEGER    *LDVR,
                    const INTEGER    *MM,
                    INTEGER          *M,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO);

//-- ctrexc --------------------------------------------------------------------
void
LAPACK_IMPL(ctrexc)(const char       *COMPQ,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *T,
                    const INTEGER    *LDT,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    const INTEGER    *IFST,
                    const INTEGER    *ILST,
                    INTEGER          *INFO);

//-- ctrrfs --------------------------------------------------------------------
void
LAPACK_IMPL(ctrrfs)(const char           *UPLO,
                    const char           *TRANS,
                    const char           *DIAG,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    const FLOAT_COMPLEX  *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- ctrsen --------------------------------------------------------------------
void
LAPACK_IMPL(ctrsen)(const char       *JOB,
                    const char       *COMPQ,
                    const LOGICAL    *SELECT,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *T,
                    const INTEGER    *LDT,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    FLOAT_COMPLEX    *W,
                    INTEGER          *M,
                    FLOAT            *S,
                    FLOAT            *SEP,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- ctrsna --------------------------------------------------------------------
void
LAPACK_IMPL(ctrsna)(const char           *JOB,
                    const char           *HOWMNY,
                    const LOGICAL        *SELECT,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *T,
                    const INTEGER        *LDT,
                    const FLOAT_COMPLEX  *VL,
                    const INTEGER        *LDVL,
                    const FLOAT_COMPLEX  *VR,
                    const INTEGER        *LDVR,
                    FLOAT                *S,
                    FLOAT                *SEP,
                    const INTEGER        *MM,
                    INTEGER              *M,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LDWORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO);

//-- ctrsyl --------------------------------------------------------------------
void
LAPACK_IMPL(ctrsyl)(const char           *TRANA,
                    const char           *TRANB,
                    const INTEGER        *ISGN,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT                *SCALE,
                    INTEGER              *INFO);

//-- ctrti2 --------------------------------------------------------------------
void
LAPACK_IMPL(ctrti2)(const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- ctrtri --------------------------------------------------------------------
void
LAPACK_IMPL(ctrtri)(const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- ctrtrs --------------------------------------------------------------------
void
LAPACK_IMPL(ctrtrs)(const char           *UPLO,
                    const char           *TRANS,
                    const char           *DIAG,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO);

//-- ctrttf --------------------------------------------------------------------
void
LAPACK_IMPL(ctrttf)(const char           *TRANSR,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT_COMPLEX        *ARF,
                    INTEGER              *INFO);

//-- ctrttp --------------------------------------------------------------------
void
LAPACK_IMPL(ctrttp)(const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT_COMPLEX        *AP,
                    INTEGER              *INFO);

//-- ctzrqf --------------------------------------------------------------------
void
LAPACK_IMPL(ctzrqf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    INTEGER          *INFO);

//-- ctzrzf --------------------------------------------------------------------
void
LAPACK_IMPL(ctzrzf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- cunbdb --------------------------------------------------------------------
void
LAPACK_IMPL(cunbdb)(const char       *TRANS,
                    const char       *SIGNS,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *Q,
                    FLOAT_COMPLEX    *X11,
                    const INTEGER    *LDX11,
                    FLOAT_COMPLEX    *X12,
                    const INTEGER    *LDX12,
                    FLOAT_COMPLEX    *X21,
                    const INTEGER    *LDX21,
                    FLOAT_COMPLEX    *X22,
                    const INTEGER    *LDX22,
                    FLOAT            *THETA,
                    FLOAT            *PHI,
                    FLOAT_COMPLEX    *TAUP1,
                    FLOAT_COMPLEX    *TAUP2,
                    FLOAT_COMPLEX    *TAUQ1,
                    FLOAT_COMPLEX    *TAUQ2,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- cuncsd --------------------------------------------------------------------
void
LAPACK_IMPL(cuncsd)(const char           *JOBU1,
                    const char           *JOBU2,
                    const char           *JOBV1T,
                    const char           *JOBV2T,
                    const char           *TRANS,
                    const char           *SIGNS,
                    const INTEGER        *M,
                    const INTEGER        *P,
                    const INTEGER        *Q,
                    const FLOAT_COMPLEX  *X11,
                    const INTEGER        *LDX11,
                    const FLOAT_COMPLEX  *X12,
                    const INTEGER        *LDX12,
                    const FLOAT_COMPLEX  *X21,
                    const INTEGER        *LDX21,
                    const FLOAT_COMPLEX  *X22,
                    const INTEGER        *LDX22,
                    FLOAT                *THETA,
                    FLOAT_COMPLEX        *U1,
                    const INTEGER        *LDU1,
                    FLOAT_COMPLEX        *U2,
                    const INTEGER        *LDU2,
                    FLOAT_COMPLEX        *V1T,
                    const INTEGER        *LDV1T,
                    FLOAT_COMPLEX        *V2T,
                    const INTEGER        *LDV2T,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    FLOAT                *RWORK,
                    const INTEGER        *LRWORK,
                    INTEGER              *IWORK,
                    INTEGER              *INFO);

//-- cung2l --------------------------------------------------------------------
void
LAPACK_IMPL(cung2l)(const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO);

//-- cung2r --------------------------------------------------------------------
void
LAPACK_IMPL(cung2r)(const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO);

//-- cungbr --------------------------------------------------------------------
void
LAPACK_IMPL(cungbr)(const char           *VECT,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO);

//-- cunghr --------------------------------------------------------------------
void
LAPACK_IMPL(cunghr)(const INTEGER        *N,
                    const INTEGER        *ILO,
                    const INTEGER        *IHI,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO);

//-- cungl2 --------------------------------------------------------------------
void
LAPACK_IMPL(cungl2)(const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO);

//-- cunglq --------------------------------------------------------------------
void
LAPACK_IMPL(cunglq)(const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO);

//-- cungql --------------------------------------------------------------------
void
LAPACK_IMPL(cungql)(const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO);

//-- cungqr --------------------------------------------------------------------
void
LAPACK_IMPL(cungqr)(const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO);

//-- cungr2 --------------------------------------------------------------------
void
LAPACK_IMPL(cungr2)(const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO);

//-- cungrq --------------------------------------------------------------------
void
LAPACK_IMPL(cungrq)(const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO);

//-- cungtr --------------------------------------------------------------------
void
LAPACK_IMPL(cungtr)(const char           *UPLO,
                    const INTEGER        *N,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO);

//-- cunm2l --------------------------------------------------------------------
void
LAPACK_IMPL(cunm2l)(const char           *SIDE,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO);

//-- cunm2r --------------------------------------------------------------------
void
LAPACK_IMPL(cunm2r)(const char           *SIDE,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO);

//-- cunmbr --------------------------------------------------------------------
void
LAPACK_IMPL(cunmbr)(const char           *VECT,
                    const char           *SIDE,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO);

//-- cunmhr --------------------------------------------------------------------
void
LAPACK_IMPL(cunmhr)(const char           *SIDE,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *ILO,
                    const INTEGER        *IHI,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO);

//-- cunml2 --------------------------------------------------------------------
void
LAPACK_IMPL(cunml2)(const char           *SIDE,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO);

//-- cunmlq --------------------------------------------------------------------
void
LAPACK_IMPL(cunmlq)(const char           *SIDE,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO);

//-- cunmql --------------------------------------------------------------------
void
LAPACK_IMPL(cunmql)(const char           *SIDE,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO);

//-- cunmqr --------------------------------------------------------------------
void
LAPACK_IMPL(cunmqr)(const char           *SIDE,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO);

//-- cunmr2 --------------------------------------------------------------------
void
LAPACK_IMPL(cunmr2)(const char           *SIDE,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO);

//-- cunmr3 --------------------------------------------------------------------
void
LAPACK_IMPL(cunmr3)(const char           *SIDE,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const INTEGER        *L,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO);

//-- cunmrq --------------------------------------------------------------------
void
LAPACK_IMPL(cunmrq)(const char           *SIDE,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO);

//-- cunmrz --------------------------------------------------------------------
void
LAPACK_IMPL(cunmrz)(const char           *SIDE,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const INTEGER        *L,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO);

//-- cunmtr --------------------------------------------------------------------
void
LAPACK_IMPL(cunmtr)(const char           *SIDE,
                    const char           *UPLO,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO);

//-- cupgtr --------------------------------------------------------------------
void
LAPACK_IMPL(cupgtr)(const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *AP,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *Q,
                    const INTEGER        *LDQ,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO);

//-- cupmtr --------------------------------------------------------------------
void
LAPACK_IMPL(cupmtr)(const char           *SIDE,
                    const char           *UPLO,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *AP,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO);

//-- dbbcsd --------------------------------------------------------------------
void
LAPACK_IMPL(dbbcsd)(const char       *JOBU1,
                    const char       *JOBU2,
                    const char       *JOBV1T,
                    const char       *JOBV2T,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *Q,
                    DOUBLE           *THETA,
                    DOUBLE           *PHI,
                    DOUBLE           *U1,
                    const INTEGER    *LDU1,
                    DOUBLE           *U2,
                    const INTEGER    *LDU2,
                    DOUBLE           *V1T,
                    const INTEGER    *LDV1T,
                    DOUBLE           *V2T,
                    const INTEGER    *LDV2T,
                    DOUBLE           *B11D,
                    DOUBLE           *B11E,
                    DOUBLE           *B12D,
                    DOUBLE           *B12E,
                    const DOUBLE     *B21D,
                    const DOUBLE     *B21E,
                    const DOUBLE     *B22D,
                    const DOUBLE     *B22E,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dbdsdc --------------------------------------------------------------------
void
LAPACK_IMPL(dbdsdc)(const char       *UPLO,
                    const char       *COMPQ,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *VT,
                    const INTEGER    *LDVT,
                    DOUBLE           *Q,
                    INTEGER          *IQ,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dbdsqr --------------------------------------------------------------------
void
LAPACK_IMPL(dbdsqr)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NCVT,
                    const INTEGER    *NRU,
                    const INTEGER    *NCC,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *VT,
                    const INTEGER    *LDVT,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- ddisna --------------------------------------------------------------------
void
LAPACK_IMPL(ddisna)(const char       *JOB,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *D,
                    DOUBLE           *SEP,
                    INTEGER          *INFO);

//-- dgbbrd --------------------------------------------------------------------
void
LAPACK_IMPL(dgbbrd)(const char       *VECT,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NCC,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    DOUBLE           *PT,
                    const INTEGER    *LDPT,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dgbcon --------------------------------------------------------------------
void
LAPACK_IMPL(dgbcon)(const char       *NORM,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    const INTEGER    *IPIV,
                    const DOUBLE     *ANORM,
                    DOUBLE           *RCOND,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dgbequ --------------------------------------------------------------------
void
LAPACK_IMPL(dgbequ)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *R,
                    DOUBLE           *C,
                    DOUBLE           *ROWCND,
                    DOUBLE           *COLCND,
                    DOUBLE           *AMAX,
                    INTEGER          *INFO);

//-- dgbequb -------------------------------------------------------------------
void
LAPACK_IMPL(dgbequb)(const INTEGER    *M,
                     const INTEGER    *N,
                     const INTEGER    *KL,
                     const INTEGER    *KU,
                     const DOUBLE     *AB,
                     const INTEGER    *LDAB,
                     DOUBLE           *R,
                     DOUBLE           *C,
                     DOUBLE           *ROWCND,
                     DOUBLE           *COLCND,
                     DOUBLE           *AMAX,
                     INTEGER          *INFO);

//-- dgbrfs --------------------------------------------------------------------
void
LAPACK_IMPL(dgbrfs)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const INTEGER    *NRHS,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    const DOUBLE     *AFB,
                    const INTEGER    *LDAFB,
                    const INTEGER    *IPIV,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dgbrfsx -------------------------------------------------------------------
void
LAPACK_IMPL(dgbrfsx)(const char       *TRANS,
                     const char       *EQUED,
                     const INTEGER    *N,
                     const INTEGER    *KL,
                     const INTEGER    *KU,
                     const INTEGER    *NRHS,
                     const DOUBLE     *AB,
                     const INTEGER    *LDAB,
                     const DOUBLE     *AFB,
                     const INTEGER    *LDAFB,
                     const INTEGER    *IPIV,
                     DOUBLE           *R,
                     DOUBLE           *C,
                     const DOUBLE     *B,
                     const INTEGER    *LDB,
                     DOUBLE           *X,
                     const INTEGER    *LDX,
                     DOUBLE           *RCOND,
                     DOUBLE           *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     DOUBLE           *ERR_BNDS_NORM,
                     DOUBLE           *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     DOUBLE           *PARAMS,
                     DOUBLE           *WORK,
                     INTEGER          *IWORK,
                     INTEGER          *INFO);

//-- dgbsv ---------------------------------------------------------------------
void
LAPACK_IMPL(dgbsv)(const INTEGER        *N,
                   const INTEGER        *KL,
                   const INTEGER        *KU,
                   const INTEGER        *NRHS,
                   DOUBLE               *AB,
                   const INTEGER        *LDAB,
                   INTEGER              *IPIV,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- dgbsvx --------------------------------------------------------------------
void
LAPACK_IMPL(dgbsvx)(const char       *FACT,
                    const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const INTEGER    *NRHS,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *AFB,
                    const INTEGER    *LDAFB,
                    INTEGER          *IPIV,
                    char             *EQUED,
                    DOUBLE           *R,
                    DOUBLE           *C,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *RCOND,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dgbsvxx -------------------------------------------------------------------
void
LAPACK_IMPL(dgbsvxx)(const char       *FACT,
                     const char       *TRANS,
                     const INTEGER    *N,
                     const INTEGER    *KL,
                     const INTEGER    *KU,
                     const INTEGER    *NRHS,
                     DOUBLE           *AB,
                     const INTEGER    *LDAB,
                     DOUBLE           *AFB,
                     const INTEGER    *LDAFB,
                     INTEGER          *IPIV,
                     char             *EQUED,
                     DOUBLE           *R,
                     DOUBLE           *C,
                     DOUBLE           *B,
                     const INTEGER    *LDB,
                     DOUBLE           *X,
                     const INTEGER    *LDX,
                     DOUBLE           *RCOND,
                     DOUBLE           *RPVGRW,
                     DOUBLE           *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     DOUBLE           *ERR_BNDS_NORM,
                     DOUBLE           *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     DOUBLE           *PARAMS,
                     DOUBLE           *WORK,
                     INTEGER          *IWORK,
                     INTEGER          *INFO);

//-- dgbtf2 --------------------------------------------------------------------
void
LAPACK_IMPL(dgbtf2)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- dgbtrf --------------------------------------------------------------------
void
LAPACK_IMPL(dgbtrf)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- dgbtrs --------------------------------------------------------------------
void
LAPACK_IMPL(dgbtrs)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const INTEGER    *NRHS,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    const INTEGER    *IPIV,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- dgebak --------------------------------------------------------------------
void
LAPACK_IMPL(dgebak)(const char       *JOB,
                    const char       *SIDE,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    const DOUBLE     *SCALE,
                    const INTEGER    *M,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    INTEGER          *INFO);

//-- dgebal --------------------------------------------------------------------
void
LAPACK_IMPL(dgebal)(const char       *JOB,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    DOUBLE           *SCALE,
                    INTEGER          *INFO);

//-- dgebd2 --------------------------------------------------------------------
void
LAPACK_IMPL(dgebd2)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *TAUQ,
                    DOUBLE           *TAUP,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dgebrd --------------------------------------------------------------------
void
LAPACK_IMPL(dgebrd)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *TAUQ,
                    DOUBLE           *TAUP,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dgecon --------------------------------------------------------------------
void
LAPACK_IMPL(dgecon)(const char       *NORM,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *ANORM,
                    DOUBLE           *RCOND,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dgeequ --------------------------------------------------------------------
void
LAPACK_IMPL(dgeequ)(const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *R,
                    DOUBLE           *C,
                    DOUBLE           *ROWCND,
                    DOUBLE           *COLCND,
                    DOUBLE           *AMAX,
                    INTEGER          *INFO);

//-- dgeequb -------------------------------------------------------------------
void
LAPACK_IMPL(dgeequb)(const INTEGER    *M,
                     const INTEGER    *N,
                     const DOUBLE     *A,
                     const INTEGER    *LDA,
                     DOUBLE           *R,
                     DOUBLE           *C,
                     DOUBLE           *ROWCND,
                     DOUBLE           *COLCND,
                     DOUBLE           *AMAX,
                     INTEGER          *INFO);

//-- dgees ---------------------------------------------------------------------
void
LAPACK_IMPL(dgees)(const char        *JOBVS,
                   const char        *SORT,
                   LOGICAL           (*SELECT)(const DOUBLE *, const DOUBLE *),
                   const INTEGER     *N,
                   DOUBLE            *A,
                   const INTEGER     *LDA,
                   INTEGER           *SDIM,
                   DOUBLE            *WR,
                   DOUBLE            *WI,
                   DOUBLE            *VS,
                   const INTEGER     *LDVS,
                   DOUBLE            *WORK,
                   const INTEGER     *LWORK,
                   LOGICAL           *BWORK,
                   INTEGER           *INFO);

//-- dgeesx --------------------------------------------------------------------
void
LAPACK_IMPL(dgeesx)(const char       *JOBVS,
                    const char       *SORT,
                    LOGICAL           (*SELECT)(const DOUBLE *, const DOUBLE *),
                    const char       *SENSE,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *SDIM,
                    DOUBLE           *WR,
                    DOUBLE           *WI,
                    DOUBLE           *VS,
                    const INTEGER    *LDVS,
                    DOUBLE           *RCONDE,
                    DOUBLE           *RCONDV,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    LOGICAL          *BWORK,
                    INTEGER          *INFO);

//-- dgeev ---------------------------------------------------------------------
void
LAPACK_IMPL(dgeev)(const char           *JOBVL,
                   const char           *JOBVR,
                   const INTEGER        *N,
                   DOUBLE               *A,
                   const INTEGER        *LDA,
                   DOUBLE               *WR,
                   DOUBLE               *WI,
                   DOUBLE               *VL,
                   const INTEGER        *LDVL,
                   DOUBLE               *VR,
                   const INTEGER        *LDVR,
                   DOUBLE               *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO);

//-- dgeevx --------------------------------------------------------------------
void
LAPACK_IMPL(dgeevx)(const char       *BALANC,
                    const char       *JOBVL,
                    const char       *JOBVR,
                    const char       *SENSE,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *WR,
                    DOUBLE           *WI,
                    DOUBLE           *VL,
                    const INTEGER    *LDVL,
                    DOUBLE           *VR,
                    const INTEGER    *LDVR,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    DOUBLE           *SCALE,
                    DOUBLE           *ABNRM,
                    DOUBLE           *RCONDE,
                    DOUBLE           *RCONDV,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dgegs ---------------------------------------------------------------------
void
LAPACK_IMPL(dgegs)(const char           *JOBVSL,
                   const char           *JOBVSR,
                   const INTEGER        *N,
                   DOUBLE               *A,
                   const INTEGER        *LDA,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   DOUBLE               *ALPHAR,
                   DOUBLE               *ALPHAI,
                   DOUBLE               *BETA,
                   DOUBLE               *VSL,
                   const INTEGER        *LDVSL,
                   DOUBLE               *VSR,
                   const INTEGER        *LDVSR,
                   DOUBLE               *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO);

//-- dgegv ---------------------------------------------------------------------
void
LAPACK_IMPL(dgegv)(const char           *JOBVL,
                   const char           *JOBVR,
                   const INTEGER        *N,
                   DOUBLE               *A,
                   const INTEGER        *LDA,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   DOUBLE               *ALPHAR,
                   DOUBLE               *ALPHAI,
                   DOUBLE               *BETA,
                   DOUBLE               *VL,
                   const INTEGER        *LDVL,
                   DOUBLE               *VR,
                   const INTEGER        *LDVR,
                   DOUBLE               *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO);

//-- dgehd2 --------------------------------------------------------------------
void
LAPACK_IMPL(dgehd2)(const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dgehrd --------------------------------------------------------------------
void
LAPACK_IMPL(dgehrd)(const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dgejsv --------------------------------------------------------------------
void
LAPACK_IMPL(dgejsv)(const char       *JOBA,
                    const char       *JOBU,
                    const char       *JOBV,
                    const char       *JOBR,
                    const char       *JOBT,
                    const char       *JOBP,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *SVA,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dgelq2 --------------------------------------------------------------------
void
LAPACK_IMPL(dgelq2)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dgelqf --------------------------------------------------------------------
void
LAPACK_IMPL(dgelqf)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dgels ---------------------------------------------------------------------
void
LAPACK_IMPL(dgels)(const char           *TRANS,
                   const INTEGER        *M,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   DOUBLE               *A,
                   const INTEGER        *LDA,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   DOUBLE               *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO);

//-- dgelsd --------------------------------------------------------------------
void
LAPACK_IMPL(dgelsd)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *S,
                    const DOUBLE     *RCOND,
                    INTEGER          *RANK,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dgelss --------------------------------------------------------------------
void
LAPACK_IMPL(dgelss)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *S,
                    const DOUBLE     *RCOND,
                    INTEGER          *RANK,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dgelsx --------------------------------------------------------------------
void
LAPACK_IMPL(dgelsx)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *JPVT,
                    const DOUBLE     *RCOND,
                    INTEGER          *RANK,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dgelsy --------------------------------------------------------------------
void
LAPACK_IMPL(dgelsy)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *JPVT,
                    const DOUBLE     *RCOND,
                    INTEGER          *RANK,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dgeql2 --------------------------------------------------------------------
void
LAPACK_IMPL(dgeql2)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dgeqlf --------------------------------------------------------------------
void
LAPACK_IMPL(dgeqlf)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dgeqp3 --------------------------------------------------------------------
void
LAPACK_IMPL(dgeqp3)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dgeqpf --------------------------------------------------------------------
void
LAPACK_IMPL(dgeqpf)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dgeqr2 --------------------------------------------------------------------
void
LAPACK_IMPL(dgeqr2)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dgeqr2p -------------------------------------------------------------------
void
LAPACK_IMPL(dgeqr2p)(const INTEGER    *M,
                     const INTEGER    *N,
                     DOUBLE           *A,
                     const INTEGER    *LDA,
                     DOUBLE           *TAU,
                     DOUBLE           *WORK,
                     INTEGER          *INFO);

//-- dgeqrf --------------------------------------------------------------------
void
LAPACK_IMPL(dgeqrf)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dgeqrfp -------------------------------------------------------------------
void
LAPACK_IMPL(dgeqrfp)(const INTEGER    *M,
                     const INTEGER    *N,
                     DOUBLE           *A,
                     const INTEGER    *LDA,
                     DOUBLE           *TAU,
                     DOUBLE           *WORK,
                     const INTEGER    *LWORK,
                     INTEGER          *INFO);

//-- dgerfs --------------------------------------------------------------------
void
LAPACK_IMPL(dgerfs)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *AF,
                    const INTEGER    *LDAF,
                    const INTEGER    *IPIV,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dgerfsx -------------------------------------------------------------------
void
LAPACK_IMPL(dgerfsx)(const char       *TRANS,
                     const char       *EQUED,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     const DOUBLE     *A,
                     const INTEGER    *LDA,
                     const DOUBLE     *AF,
                     const INTEGER    *LDAF,
                     const INTEGER    *IPIV,
                     const DOUBLE     *R,
                     const DOUBLE     *C,
                     const DOUBLE     *B,
                     const INTEGER    *LDB,
                     DOUBLE           *X,
                     const INTEGER    *LDX,
                     DOUBLE           *RCOND,
                     DOUBLE           *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     DOUBLE           *ERR_BNDS_NORM,
                     DOUBLE           *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     DOUBLE           *PARAMS,
                     DOUBLE           *WORK,
                     INTEGER          *IWORK,
                     INTEGER          *INFO);

//-- dgerq2 --------------------------------------------------------------------
void
LAPACK_IMPL(dgerq2)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dgerqf --------------------------------------------------------------------
void
LAPACK_IMPL(dgerqf)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dgesc2 --------------------------------------------------------------------
void
LAPACK_IMPL(dgesc2)(const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *RHS,
                    const INTEGER    *IPIV,
                    const INTEGER    *JPIV,
                    DOUBLE           *SCALE);

//-- dgesdd --------------------------------------------------------------------
void
LAPACK_IMPL(dgesdd)(const char       *JOBZ,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *S,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *VT,
                    const INTEGER    *LDVT,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dgesv ---------------------------------------------------------------------
void
LAPACK_IMPL(dgesv)(const INTEGER        *N,
                   const INTEGER        *NRHS,
                   DOUBLE               *A,
                   const INTEGER        *LDA,
                   INTEGER              *IPIV,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- dgesvd --------------------------------------------------------------------
void
LAPACK_IMPL(dgesvd)(const char       *JOBU,
                    const char       *JOBVT,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *S,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *VT,
                    const INTEGER    *LDVT,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dgesvj --------------------------------------------------------------------
void
LAPACK_IMPL(dgesvj)(const char       *JOBA,
                    const char       *JOBU,
                    const char       *JOBV,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *SVA,
                    const INTEGER    *MV,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dgesvx --------------------------------------------------------------------
void
LAPACK_IMPL(dgesvx)(const char       *FACT,
                    const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *AF,
                    const INTEGER    *LDAF,
                    INTEGER          *IPIV,
                    char             *EQUED,
                    DOUBLE           *R,
                    DOUBLE           *C,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *RCOND,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dgesvxx -------------------------------------------------------------------
void
LAPACK_IMPL(dgesvxx)(const char       *FACT,
                     const char       *TRANS,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     DOUBLE           *A,
                     const INTEGER    *LDA,
                     DOUBLE           *AF,
                     const INTEGER    *LDAF,
                     INTEGER          *IPIV,
                     char             *EQUED,
                     DOUBLE           *R,
                     DOUBLE           *C,
                     DOUBLE           *B,
                     const INTEGER    *LDB,
                     DOUBLE           *X,
                     const INTEGER    *LDX,
                     DOUBLE           *RCOND,
                     DOUBLE           *RPVGRW,
                     DOUBLE           *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     DOUBLE           *ERR_BNDS_NORM,
                     DOUBLE           *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     DOUBLE           *PARAMS,
                     DOUBLE           *WORK,
                     INTEGER          *IWORK,
                     INTEGER          *INFO);

//-- dgetc2 --------------------------------------------------------------------
void
LAPACK_IMPL(dgetc2)(const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *JPIV,
                    INTEGER          *INFO);

//-- dgetf2 --------------------------------------------------------------------
void
LAPACK_IMPL(dgetf2)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- dgetrf --------------------------------------------------------------------
void
LAPACK_IMPL(dgetrf)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- dgetri --------------------------------------------------------------------
void
LAPACK_IMPL(dgetri)(const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const INTEGER    *IPIV,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dgetrs --------------------------------------------------------------------
void
LAPACK_IMPL(dgetrs)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const INTEGER    *IPIV,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- dggbak --------------------------------------------------------------------
void
LAPACK_IMPL(dggbak)(const char       *JOB,
                    const char       *SIDE,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    const DOUBLE     *LSCALE,
                    const DOUBLE     *RSCALE,
                    const INTEGER    *M,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    INTEGER          *INFO);

//-- dggbal --------------------------------------------------------------------
void
LAPACK_IMPL(dggbal)(const char       *JOB,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    DOUBLE           *LSCALE,
                    DOUBLE           *RSCALE,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dgges ---------------------------------------------------------------------
void
LAPACK_IMPL(dgges)(const char           *JOBVSL,
                   const char           *JOBVSR,
                   const char           *SORT,
                   const LOGICAL        *SELCTG,
                   const INTEGER        *N,
                   DOUBLE               *A,
                   const INTEGER        *LDA,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   INTEGER              *SDIM,
                   DOUBLE               *ALPHAR,
                   DOUBLE               *ALPHAI,
                   DOUBLE               *BETA,
                   DOUBLE               *VSL,
                   const INTEGER        *LDVSL,
                   DOUBLE               *VSR,
                   const INTEGER        *LDVSR,
                   DOUBLE               *WORK,
                   const INTEGER        *LWORK,
                   LOGICAL              *BWORK,
                   INTEGER              *INFO);

//-- dggesx --------------------------------------------------------------------
void
LAPACK_IMPL(dggesx)(const char       *JOBVSL,
                    const char       *JOBVSR,
                    const char       *SORT,
                    const LOGICAL    *SELCTG,
                    const char       *SENSE,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *SDIM,
                    DOUBLE           *ALPHAR,
                    DOUBLE           *ALPHAI,
                    DOUBLE           *BETA,
                    DOUBLE           *VSL,
                    const INTEGER    *LDVSL,
                    DOUBLE           *VSR,
                    const INTEGER    *LDVSR,
                    DOUBLE           *RCONDE,
                    DOUBLE           *RCONDV,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    LOGICAL          *BWORK,
                    INTEGER          *INFO);

//-- dggev ---------------------------------------------------------------------
void
LAPACK_IMPL(dggev)(const char           *JOBVL,
                   const char           *JOBVR,
                   const INTEGER        *N,
                   DOUBLE               *A,
                   const INTEGER        *LDA,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   DOUBLE               *ALPHAR,
                   DOUBLE               *ALPHAI,
                   DOUBLE               *BETA,
                   DOUBLE               *VL,
                   const INTEGER        *LDVL,
                   DOUBLE               *VR,
                   const INTEGER        *LDVR,
                   DOUBLE               *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO);

//-- dggevx --------------------------------------------------------------------
void
LAPACK_IMPL(dggevx)(const char       *BALANC,
                    const char       *JOBVL,
                    const char       *JOBVR,
                    const char       *SENSE,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *ALPHAR,
                    DOUBLE           *ALPHAI,
                    DOUBLE           *BETA,
                    DOUBLE           *VL,
                    const INTEGER    *LDVL,
                    DOUBLE           *VR,
                    const INTEGER    *LDVR,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    DOUBLE           *LSCALE,
                    DOUBLE           *RSCALE,
                    DOUBLE           *ABNRM,
                    DOUBLE           *BBNRM,
                    DOUBLE           *RCONDE,
                    DOUBLE           *RCONDV,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    LOGICAL          *BWORK,
                    INTEGER          *INFO);

//-- dggglm --------------------------------------------------------------------
void
LAPACK_IMPL(dggglm)(const INTEGER    *N,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *D,
                    DOUBLE           *X,
                    DOUBLE           *Y,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dgghrd --------------------------------------------------------------------
void
LAPACK_IMPL(dgghrd)(const char       *COMPQ,
                    const char       *COMPZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *INFO);

//-- dgglse --------------------------------------------------------------------
void
LAPACK_IMPL(dgglse)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *P,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *C,
                    DOUBLE           *D,
                    DOUBLE           *X,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dggqrf --------------------------------------------------------------------
void
LAPACK_IMPL(dggqrf)(const INTEGER    *N,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAUA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *TAUB,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dggrqf --------------------------------------------------------------------
void
LAPACK_IMPL(dggrqf)(const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAUA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *TAUB,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dggsvd --------------------------------------------------------------------
void
LAPACK_IMPL(dggsvd)(const char       *JOBU,
                    const char       *JOBV,
                    const char       *JOBQ,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *P,
                    INTEGER          *K,
                    INTEGER          *L,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *ALPHA,
                    DOUBLE           *BETA,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dggsvp --------------------------------------------------------------------
void
LAPACK_IMPL(dggsvp)(const char       *JOBU,
                    const char       *JOBV,
                    const char       *JOBQ,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    const DOUBLE     *TOLA,
                    const DOUBLE     *TOLB,
                    INTEGER          *K,
                    INTEGER          *L,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    INTEGER          *IWORK,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dgsvj0 --------------------------------------------------------------------
void
LAPACK_IMPL(dgsvj0)(const char       *JOBV,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *D,
                    DOUBLE           *SVA,
                    const INTEGER    *MV,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    const DOUBLE     *EPS,
                    const DOUBLE     *SFMIN,
                    const DOUBLE     *TOL,
                    const INTEGER    *NSWEEP,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dgsvj1 --------------------------------------------------------------------
void
LAPACK_IMPL(dgsvj1)(const char       *JOBV,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *N1,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *D,
                    DOUBLE           *SVA,
                    const INTEGER    *MV,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    const DOUBLE     *EPS,
                    const DOUBLE     *SFMIN,
                    const DOUBLE     *TOL,
                    const INTEGER    *NSWEEP,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dgtcon --------------------------------------------------------------------
void
LAPACK_IMPL(dgtcon)(const char       *NORM,
                    const INTEGER    *N,
                    const DOUBLE     *DL,
                    const DOUBLE     *D,
                    const DOUBLE     *DU,
                    const DOUBLE     *DU2,
                    const INTEGER    *IPIV,
                    const DOUBLE     *ANORM,
                    DOUBLE           *RCOND,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dgtrfs --------------------------------------------------------------------
void
LAPACK_IMPL(dgtrfs)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *DL,
                    const DOUBLE     *D,
                    const DOUBLE     *DU,
                    const DOUBLE     *DLF,
                    const DOUBLE     *DF,
                    const DOUBLE     *DUF,
                    const DOUBLE     *DU2,
                    const INTEGER    *IPIV,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dgtsv ---------------------------------------------------------------------
void
LAPACK_IMPL(dgtsv)(const INTEGER        *N,
                   const INTEGER        *NRHS,
                   DOUBLE               *DL,
                   DOUBLE               *D,
                   DOUBLE               *DU,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- dgtsvx --------------------------------------------------------------------
void
LAPACK_IMPL(dgtsvx)(const char       *FACT,
                    const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *DL,
                    const DOUBLE     *D,
                    const DOUBLE     *DU,
                    DOUBLE           *DLF,
                    DOUBLE           *DF,
                    DOUBLE           *DUF,
                    DOUBLE           *DU2,
                    INTEGER          *IPIV,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *RCOND,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dgttrf --------------------------------------------------------------------
void
LAPACK_IMPL(dgttrf)(const INTEGER    *N,
                    DOUBLE           *DL,
                    DOUBLE           *D,
                    DOUBLE           *DU,
                    DOUBLE           *DU2,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- dgttrs --------------------------------------------------------------------
void
LAPACK_IMPL(dgttrs)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *DL,
                    const DOUBLE     *D,
                    const DOUBLE     *DU,
                    const DOUBLE     *DU2,
                    const INTEGER    *IPIV,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- dgtts2 --------------------------------------------------------------------
void
LAPACK_IMPL(dgtts2)(const INTEGER    *ITRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *DL,
                    const DOUBLE     *D,
                    const DOUBLE     *DU,
                    const DOUBLE     *DU2,
                    const INTEGER    *IPIV,
                    DOUBLE           *B,
                    const INTEGER    *LDB);

//-- dhgeqz --------------------------------------------------------------------
void
LAPACK_IMPL(dhgeqz)(const char       *JOB,
                    const char       *COMPQ,
                    const char       *COMPZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    DOUBLE           *H,
                    const INTEGER    *LDH,
                    DOUBLE           *T,
                    const INTEGER    *LDT,
                    DOUBLE           *ALPHAR,
                    DOUBLE           *ALPHAI,
                    DOUBLE           *BETA,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dhsein --------------------------------------------------------------------
void
LAPACK_IMPL(dhsein)(const char       *SIDE,
                    const char       *EIGSRC,
                    const char       *INITV,
                    LOGICAL          *SELECT,
                    const INTEGER    *N,
                    const DOUBLE     *H,
                    const INTEGER    *LDH,
                    DOUBLE           *WR,
                    const DOUBLE     *WI,
                    DOUBLE           *VL,
                    const INTEGER    *LDVL,
                    DOUBLE           *VR,
                    const INTEGER    *LDVR,
                    const INTEGER    *MM,
                    INTEGER          *M,
                    DOUBLE           *WORK,
                    INTEGER          *IFAILL,
                    INTEGER          *IFAILR,
                    INTEGER          *INFO);

//-- dhseqr --------------------------------------------------------------------
void
LAPACK_IMPL(dhseqr)(const char       *JOB,
                    const char       *COMPZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    DOUBLE           *H,
                    const INTEGER    *LDH,
                    DOUBLE           *WR,
                    DOUBLE           *WI,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- disnan --------------------------------------------------------------------
LOGICAL
LAPACK_IMPL(disnan)(const DOUBLE     *DIN);

//-- dla_gbamv -----------------------------------------------------------------
void
LAPACK_IMPL(dla_gbamv)(const INTEGER        *TRANS,
                       const INTEGER        *M,
                       const INTEGER        *N,
                       const INTEGER        *KL,
                       const INTEGER        *KU,
                       const DOUBLE         *ALPHA,
                       const DOUBLE         *AB,
                       const INTEGER        *LDAB,
                       const DOUBLE         *X,
                       const INTEGER        *INCX,
                       const DOUBLE         *BETA,
                       DOUBLE               *Y,
                       const INTEGER        *INCY);

//-- dla_gbrcond ---------------------------------------------------------------
DOUBLE
LAPACK_IMPL(dla_gbrcond)(const char       *TRANS,
                         const INTEGER    *N,
                         const INTEGER    *KL,
                         const INTEGER    *KU,
                         const DOUBLE     *AB,
                         const INTEGER    *LDAB,
                         const DOUBLE     *AFB,
                         const INTEGER    *LDAFB,
                         const INTEGER    *IPIV,
                         const INTEGER    *CMODE,
                         const DOUBLE     *C,
                         INTEGER          *INFO,
                         const DOUBLE     *WORK,
                         const INTEGER    *IWORK);

//-- dla_gbrfsx_extended -------------------------------------------------------
void
LAPACK_IMPL(dla_gbrfsx_extended)(const INTEGER    *PREC_TYPE,
                                 const INTEGER    *TRANS_TYPE,
                                 const INTEGER    *N,
                                 const INTEGER    *KL,
                                 const INTEGER    *KU,
                                 const INTEGER    *NRHS,
                                 const DOUBLE     *AB,
                                 const INTEGER    *LDAB,
                                 const DOUBLE     *AFB,
                                 const INTEGER    *LDAFB,
                                 const INTEGER    *IPIV,
                                 const LOGICAL    *COLEQU,
                                 const DOUBLE     *C,
                                 const DOUBLE     *B,
                                 const INTEGER    *LDB,
                                 DOUBLE           *Y,
                                 const INTEGER    *LDY,
                                 DOUBLE           *BERR_OUT,
                                 const INTEGER    *N_NORMS,
                                 DOUBLE           *ERR_BNDS_NORM,
                                 DOUBLE           *ERR_BNDS_COMP,
                                 const DOUBLE     *RES,
                                 const DOUBLE     *AYB,
                                 const DOUBLE     *DY,
                                 const DOUBLE     *Y_TAIL,
                                 const DOUBLE     *RCOND,
                                 const INTEGER    *ITHRESH,
                                 const DOUBLE     *RTHRESH,
                                 const DOUBLE     *DZ_UB,
                                 const LOGICAL    *IGNORE_CWISE,
                                 INTEGER          *INFO);

//-- dla_gbrpvgrw --------------------------------------------------------------
DOUBLE
LAPACK_IMPL(dla_gbrpvgrw)(const INTEGER    *N,
                          const INTEGER    *KL,
                          const INTEGER    *KU,
                          const INTEGER    *NCOLS,
                          const DOUBLE     *AB,
                          const INTEGER    *LDAB,
                          const DOUBLE     *AFB,
                          const INTEGER    *LDAFB);

//-- dla_geamv -----------------------------------------------------------------
void
LAPACK_IMPL(dla_geamv)(const INTEGER        *TRANS,
                       const INTEGER        *M,
                       const INTEGER        *N,
                       const DOUBLE         *ALPHA,
                       const DOUBLE         *A,
                       const INTEGER        *LDA,
                       const DOUBLE         *X,
                       const INTEGER        *INCX,
                       const DOUBLE         *BETA,
                       DOUBLE               *Y,
                       const INTEGER        *INCY);

//-- dla_gercond ---------------------------------------------------------------
DOUBLE
LAPACK_IMPL(dla_gercond)(const char       *TRANS,
                         const INTEGER    *N,
                         const DOUBLE     *A,
                         const INTEGER    *LDA,
                         const DOUBLE     *AF,
                         const INTEGER    *LDAF,
                         const INTEGER    *IPIV,
                         const INTEGER    *CMODE,
                         const DOUBLE     *C,
                         INTEGER          *INFO,
                         const DOUBLE     *WORK,
                         const INTEGER    *IWORK);

//-- dla_gerfsx_extended -------------------------------------------------------
void
LAPACK_IMPL(dla_gerfsx_extended)(const INTEGER    *PREC_TYPE,
                                 const INTEGER    *TRANS_TYPE,
                                 const INTEGER    *N,
                                 const INTEGER    *NRHS,
                                 const DOUBLE     *A,
                                 const INTEGER    *LDA,
                                 const DOUBLE     *AF,
                                 const INTEGER    *LDAF,
                                 const INTEGER    *IPIV,
                                 const LOGICAL    *COLEQU,
                                 const DOUBLE     *C,
                                 const DOUBLE     *B,
                                 const INTEGER    *LDB,
                                 DOUBLE           *Y,
                                 const INTEGER    *LDY,
                                 DOUBLE           *BERR_OUT,
                                 const INTEGER    *N_NORMS,
                                 const DOUBLE     *ERRS_N,
                                 const DOUBLE     *ERRS_C,
                                 const DOUBLE     *RES,
                                 const DOUBLE     *AYB,
                                 const DOUBLE     *DY,
                                 const DOUBLE     *Y_TAIL,
                                 const DOUBLE     *RCOND,
                                 const INTEGER    *ITHRESH,
                                 const DOUBLE     *RTHRESH,
                                 const DOUBLE     *DZ_UB,
                                 const LOGICAL    *IGNORE_CWISE,
                                 INTEGER          *INFO);

//-- dla_lin_berr --------------------------------------------------------------
void
LAPACK_IMPL(dla_lin_berr)(const INTEGER    *N,
                          const INTEGER    *NZ,
                          const INTEGER    *NRHS,
                          const DOUBLE     *RES,
                          const DOUBLE     *AYB,
                          DOUBLE           *BERR);

//-- dla_porcond ---------------------------------------------------------------
DOUBLE
LAPACK_IMPL(dla_porcond)(const char       *UPLO,
                         const INTEGER    *N,
                         const DOUBLE     *A,
                         const INTEGER    *LDA,
                         const DOUBLE     *AF,
                         const INTEGER    *LDAF,
                         const INTEGER    *CMODE,
                         const DOUBLE     *C,
                         INTEGER          *INFO,
                         const DOUBLE     *WORK,
                         const INTEGER    *IWORK);

//-- dla_porfsx_extended -------------------------------------------------------
void
LAPACK_IMPL(dla_porfsx_extended)(const INTEGER    *PREC_TYPE,
                                 const char       *UPLO,
                                 const INTEGER    *N,
                                 const INTEGER    *NRHS,
                                 const DOUBLE     *A,
                                 const INTEGER    *LDA,
                                 const DOUBLE     *AF,
                                 const INTEGER    *LDAF,
                                 const LOGICAL    *COLEQU,
                                 const DOUBLE     *C,
                                 const DOUBLE     *B,
                                 const INTEGER    *LDB,
                                 DOUBLE           *Y,
                                 const INTEGER    *LDY,
                                 DOUBLE           *BERR_OUT,
                                 const INTEGER    *N_NORMS,
                                 DOUBLE           *ERR_BNDS_NORM,
                                 DOUBLE           *ERR_BNDS_COMP,
                                 const DOUBLE     *RES,
                                 const DOUBLE     *AYB,
                                 const DOUBLE     *DY,
                                 const DOUBLE     *Y_TAIL,
                                 const DOUBLE     *RCOND,
                                 const INTEGER    *ITHRESH,
                                 const DOUBLE     *RTHRESH,
                                 const DOUBLE     *DZ_UB,
                                 const LOGICAL    *IGNORE_CWISE,
                                 INTEGER          *INFO);

//-- dla_porpvgrw --------------------------------------------------------------
DOUBLE
LAPACK_IMPL(dla_porpvgrw)(const char       *UPLO,
                          const INTEGER    *NCOLS,
                          const DOUBLE     *A,
                          const INTEGER    *LDA,
                          const DOUBLE     *AF,
                          const INTEGER    *LDAF,
                          const DOUBLE     *WORK);

//-- dla_rpvgrw ----------------------------------------------------------------
DOUBLE
LAPACK_IMPL(dla_rpvgrw)(const INTEGER    *N,
                        const INTEGER    *NCOLS,
                        const DOUBLE     *A,
                        const INTEGER    *LDA,
                        const DOUBLE     *AF,
                        const INTEGER    *LDAF);

//-- dla_syamv -----------------------------------------------------------------
void
LAPACK_IMPL(dla_syamv)(const INTEGER        *UPLO,
                       const INTEGER        *N,
                       const DOUBLE         *ALPHA,
                       const DOUBLE         *A,
                       const INTEGER        *LDA,
                       const DOUBLE         *X,
                       const INTEGER        *INCX,
                       const DOUBLE         *BETA,
                       DOUBLE               *Y,
                       const INTEGER        *INCY);

//-- dla_syrcond ---------------------------------------------------------------
DOUBLE
LAPACK_IMPL(dla_syrcond)(const char       *UPLO,
                         const INTEGER    *N,
                         const DOUBLE     *A,
                         const INTEGER    *LDA,
                         const DOUBLE     *AF,
                         const INTEGER    *LDAF,
                         const INTEGER    *IPIV,
                         const INTEGER    *CMODE,
                         const DOUBLE     *C,
                         INTEGER          *INFO,
                         const DOUBLE     *WORK,
                         const INTEGER    *IWORK);

//-- dla_syrfsx_extended -------------------------------------------------------
void
LAPACK_IMPL(dla_syrfsx_extended)(const INTEGER    *PREC_TYPE,
                                 const char       *UPLO,
                                 const INTEGER    *N,
                                 const INTEGER    *NRHS,
                                 const DOUBLE     *A,
                                 const INTEGER    *LDA,
                                 const DOUBLE     *AF,
                                 const INTEGER    *LDAF,
                                 const INTEGER    *IPIV,
                                 const LOGICAL    *COLEQU,
                                 const DOUBLE     *C,
                                 const DOUBLE     *B,
                                 const INTEGER    *LDB,
                                 DOUBLE           *Y,
                                 const INTEGER    *LDY,
                                 DOUBLE           *BERR_OUT,
                                 const INTEGER    *N_NORMS,
                                 DOUBLE           *ERR_BNDS_NORM,
                                 DOUBLE           *ERR_BNDS_COMP,
                                 const DOUBLE     *RES,
                                 const DOUBLE     *AYB,
                                 const DOUBLE     *DY,
                                 const DOUBLE     *Y_TAIL,
                                 const DOUBLE     *RCOND,
                                 const INTEGER    *ITHRESH,
                                 const DOUBLE     *RTHRESH,
                                 const DOUBLE     *DZ_UB,
                                 const LOGICAL    *IGNORE_CWISE,
                                 INTEGER          *INFO);

//-- dla_syrpvgrw --------------------------------------------------------------
DOUBLE
LAPACK_IMPL(dla_syrpvgrw)(const char       *UPLO,
                          const INTEGER    *N,
                          const INTEGER    *INFO,
                          const DOUBLE     *A,
                          const INTEGER    *LDA,
                          const DOUBLE     *AF,
                          const INTEGER    *LDAF,
                          const INTEGER    *IPIV,
                          const DOUBLE     *WORK);

//-- dla_wwaddw ----------------------------------------------------------------
void
LAPACK_IMPL(dla_wwaddw)(const INTEGER    *N,
                        DOUBLE           *X,
                        DOUBLE           *Y,
                        const DOUBLE     *W);

//-- dlabad --------------------------------------------------------------------
void
LAPACK_IMPL(dlabad)(DOUBLE   *SMALL,
                    DOUBLE   *LARGE);

//-- dlabrd --------------------------------------------------------------------
void
LAPACK_IMPL(dlabrd)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NB,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *TAUQ,
                    DOUBLE           *TAUP,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *Y,
                    const INTEGER    *LDY);

//-- dlacn2 --------------------------------------------------------------------
void
LAPACK_IMPL(dlacn2)(const INTEGER    *N,
                    DOUBLE           *V,
                    DOUBLE           *X,
                    INTEGER          *ISGN,
                    DOUBLE           *EST,
                    INTEGER          *KASE,
                    INTEGER          *ISAVE);

//-- dlacon --------------------------------------------------------------------
void
LAPACK_IMPL(dlacon)(const INTEGER    *N,
                    DOUBLE           *V,
                    DOUBLE           *X,
                    INTEGER          *ISGN,
                    DOUBLE           *EST,
                    INTEGER          *KASE);

//-- dlacpy --------------------------------------------------------------------
void
LAPACK_IMPL(dlacpy)(const char       *UPLO,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB);

//-- dladiv --------------------------------------------------------------------
void
LAPACK_IMPL(dladiv)(const DOUBLE     *A,
                    const DOUBLE     *B,
                    const DOUBLE     *C,
                    const DOUBLE     *D,
                    DOUBLE           *P,
                    DOUBLE           *Q);

//-- dlae2 ---------------------------------------------------------------------
void
LAPACK_IMPL(dlae2)(const DOUBLE     *A,
                   const DOUBLE     *B,
                   const DOUBLE     *C,
                   DOUBLE           *RT1,
                   DOUBLE           *RT2);

//-- dlaebz --------------------------------------------------------------------
void
LAPACK_IMPL(dlaebz)(const INTEGER    *IJOB,
                    const INTEGER    *NITMAX,
                    const INTEGER    *N,
                    const INTEGER    *MMAX,
                    const INTEGER    *MINP,
                    const INTEGER    *NBMIN,
                    const DOUBLE     *ABSTOL,
                    const DOUBLE     *RELTOL,
                    const DOUBLE     *PIVMIN,
                    const DOUBLE     *D,
                    const DOUBLE     *E,
                    const DOUBLE     *E2,
                    INTEGER          *NVAL,
                    DOUBLE           *AB,
                    DOUBLE           *C,
                    INTEGER          *MOUT,
                    INTEGER          *NAB,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dlaed0 --------------------------------------------------------------------
void
LAPACK_IMPL(dlaed0)(const INTEGER    *ICOMPQ,
                    const INTEGER    *QSIZ,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    const DOUBLE     *E,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    DOUBLE           *QSTORE,
                    const INTEGER    *LDQS,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dlaed1 --------------------------------------------------------------------
void
LAPACK_IMPL(dlaed1)(const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    INTEGER          *INDXQ,
                    const DOUBLE     *RHO,
                    const INTEGER    *CUTPNT,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dlaed2 --------------------------------------------------------------------
void
LAPACK_IMPL(dlaed2)(INTEGER          *K,
                    const INTEGER    *N,
                    const INTEGER    *N1,
                    DOUBLE           *D,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    INTEGER          *INDXQ,
                    DOUBLE           *RHO,
                    const DOUBLE     *Z,
                    DOUBLE           *DLAMDA,
                    DOUBLE           *W,
                    DOUBLE           *Q2,
                    INTEGER          *INDX,
                    INTEGER          *INDXC,
                    INTEGER          *INDXP,
                    INTEGER          *COLTYP,
                    INTEGER          *INFO);

//-- dlaed3 --------------------------------------------------------------------
void
LAPACK_IMPL(dlaed3)(const INTEGER    *K,
                    const INTEGER    *N,
                    const INTEGER    *N1,
                    DOUBLE           *D,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    const DOUBLE     *RHO,
                    DOUBLE           *DLAMDA,
                    const DOUBLE     *Q2,
                    const INTEGER    *INDX,
                    const INTEGER    *CTOT,
                    DOUBLE           *W,
                    DOUBLE           *S,
                    INTEGER          *INFO);

//-- dlaed4 --------------------------------------------------------------------
void
LAPACK_IMPL(dlaed4)(const INTEGER    *N,
                    const INTEGER    *I,
                    const DOUBLE     *D,
                    const DOUBLE     *Z,
                    DOUBLE           *DELTA,
                    const DOUBLE     *RHO,
                    DOUBLE           *DLAM,
                    INTEGER          *INFO);

//-- dlaed5 --------------------------------------------------------------------
void
LAPACK_IMPL(dlaed5)(const INTEGER    *I,
                    const DOUBLE     *D,
                    const DOUBLE     *Z,
                    DOUBLE           *DELTA,
                    const DOUBLE     *RHO,
                    DOUBLE           *DLAM);

//-- dlaed6 --------------------------------------------------------------------
void
LAPACK_IMPL(dlaed6)(const INTEGER    *KNITER,
                    const LOGICAL    *ORGATI,
                    const DOUBLE     *RHO,
                    const DOUBLE     *D,
                    const DOUBLE     *Z,
                    const DOUBLE     *FINIT,
                    DOUBLE           *TAU,
                    INTEGER          *INFO);

//-- dlaed7 --------------------------------------------------------------------
void
LAPACK_IMPL(dlaed7)(const INTEGER    *ICOMPQ,
                    const INTEGER    *N,
                    const INTEGER    *QSIZ,
                    const INTEGER    *TLVLS,
                    const INTEGER    *CURLVL,
                    const INTEGER    *CURPBM,
                    DOUBLE           *D,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    INTEGER          *INDXQ,
                    const DOUBLE     *RHO,
                    const INTEGER    *CUTPNT,
                    DOUBLE           *QSTORE,
                    INTEGER          *QPTR,
                    const INTEGER    *PRMPTR,
                    const INTEGER    *PERM,
                    const INTEGER    *GIVPTR,
                    const INTEGER    *GIVCOL,
                    const DOUBLE     *GIVNUM,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dlaed8 --------------------------------------------------------------------
void
LAPACK_IMPL(dlaed8)(const INTEGER    *ICOMPQ,
                    INTEGER          *K,
                    const INTEGER    *N,
                    const INTEGER    *QSIZ,
                    DOUBLE           *D,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    const INTEGER    *INDXQ,
                    DOUBLE           *RHO,
                    const INTEGER    *CUTPNT,
                    const DOUBLE     *Z,
                    DOUBLE           *DLAMDA,
                    DOUBLE           *Q2,
                    const INTEGER    *LDQ2,
                    DOUBLE           *W,
                    INTEGER          *PERM,
                    INTEGER          *GIVPTR,
                    INTEGER          *GIVCOL,
                    DOUBLE           *GIVNUM,
                    INTEGER          *INDXP,
                    INTEGER          *INDX,
                    INTEGER          *INFO);

//-- dlaed9 --------------------------------------------------------------------
void
LAPACK_IMPL(dlaed9)(const INTEGER    *K,
                    const INTEGER    *KSTART,
                    const INTEGER    *KSTOP,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    const DOUBLE     *RHO,
                    const DOUBLE     *DLAMDA,
                    const DOUBLE     *W,
                    DOUBLE           *S,
                    const INTEGER    *LDS,
                    INTEGER          *INFO);

//-- dlaeda --------------------------------------------------------------------
void
LAPACK_IMPL(dlaeda)(const INTEGER    *N,
                    const INTEGER    *TLVLS,
                    const INTEGER    *CURLVL,
                    const INTEGER    *CURPBM,
                    const INTEGER    *PRMPTR,
                    const INTEGER    *PERM,
                    const INTEGER    *GIVPTR,
                    const INTEGER    *GIVCOL,
                    const DOUBLE     *GIVNUM,
                    const DOUBLE     *Q,
                    const INTEGER    *QPTR,
                    DOUBLE           *Z,
                    DOUBLE           *ZTEMP,
                    INTEGER          *INFO);

//-- dlaein --------------------------------------------------------------------
void
LAPACK_IMPL(dlaein)(const LOGICAL    *RIGHTV,
                    const LOGICAL    *NOINIT,
                    const INTEGER    *N,
                    const DOUBLE     *H,
                    const INTEGER    *LDH,
                    const DOUBLE     *WR,
                    const DOUBLE     *WI,
                    DOUBLE           *VR,
                    DOUBLE           *VI,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *WORK,
                    const DOUBLE     *EPS3,
                    const DOUBLE     *SMLNUM,
                    const DOUBLE     *BIGNUM,
                    INTEGER          *INFO);

//-- dlaev2 --------------------------------------------------------------------
void
LAPACK_IMPL(dlaev2)(const DOUBLE     *A,
                    const DOUBLE     *B,
                    const DOUBLE     *C,
                    DOUBLE           *RT1,
                    DOUBLE           *RT2,
                    DOUBLE           *CS1,
                    DOUBLE           *SN1);

//-- dlaexc --------------------------------------------------------------------
void
LAPACK_IMPL(dlaexc)(const LOGICAL    *WANTQ,
                    const INTEGER    *N,
                    DOUBLE           *T,
                    const INTEGER    *LDT,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    const INTEGER    *J1,
                    const INTEGER    *N1,
                    const INTEGER    *N2,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dlag2 ---------------------------------------------------------------------
void
LAPACK_IMPL(dlag2)(const DOUBLE         *A,
                   const INTEGER        *LDA,
                   const DOUBLE         *B,
                   const INTEGER        *LDB,
                   const DOUBLE         *SAFMIN,
                   DOUBLE               *SCALE1,
                   DOUBLE               *SCALE2,
                   DOUBLE               *WR1,
                   DOUBLE               *WR2,
                   DOUBLE               *WI);

//-- dlag2s --------------------------------------------------------------------
void
LAPACK_IMPL(dlag2s)(const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    FLOAT            *SA,
                    const INTEGER    *LDSA,
                    INTEGER          *INFO);

//-- dlags2 --------------------------------------------------------------------
void
LAPACK_IMPL(dlags2)(const LOGICAL    *UPPER,
                    const DOUBLE     *A1,
                    const DOUBLE     *A2,
                    const DOUBLE     *A3,
                    const DOUBLE     *B1,
                    const DOUBLE     *B2,
                    const DOUBLE     *B3,
                    DOUBLE           *CSU,
                    DOUBLE           *SNU,
                    DOUBLE           *CSV,
                    DOUBLE           *SNV,
                    DOUBLE           *CSQ,
                    DOUBLE           *SNQ);

//-- dlagtf --------------------------------------------------------------------
void
LAPACK_IMPL(dlagtf)(const INTEGER    *N,
                    DOUBLE           *A,
                    const DOUBLE     *LAMBDA,
                    DOUBLE           *B,
                    DOUBLE           *C,
                    const DOUBLE     *TOL,
                    DOUBLE           *D,
                    INTEGER          *IN,
                    INTEGER          *INFO);

//-- dlagtm --------------------------------------------------------------------
void
LAPACK_IMPL(dlagtm)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *ALPHA,
                    const DOUBLE     *DL,
                    const DOUBLE     *D,
                    const DOUBLE     *DU,
                    const DOUBLE     *X,
                    const INTEGER    *LDX,
                    const DOUBLE     *BETA,
                    DOUBLE           *B,
                    const INTEGER    *LDB);

//-- dlagts --------------------------------------------------------------------
void
LAPACK_IMPL(dlagts)(const INTEGER    *JOB,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const DOUBLE     *B,
                    const DOUBLE     *C,
                    const DOUBLE     *D,
                    const INTEGER    *IN,
                    DOUBLE           *Y,
                    DOUBLE           *TOL,
                    INTEGER          *INFO);

//-- dlagv2 --------------------------------------------------------------------
void
LAPACK_IMPL(dlagv2)(DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *ALPHAR,
                    DOUBLE           *ALPHAI,
                    DOUBLE           *BETA,
                    DOUBLE           *CSL,
                    DOUBLE           *SNL,
                    DOUBLE           *CSR,
                    DOUBLE           *SNR);

//-- dlahqr --------------------------------------------------------------------
void
LAPACK_IMPL(dlahqr)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    DOUBLE           *H,
                    const INTEGER    *LDH,
                    DOUBLE           *WR,
                    DOUBLE           *WI,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *INFO);

//-- dlahr2 --------------------------------------------------------------------
void
LAPACK_IMPL(dlahr2)(const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *NB,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *T,
                    const INTEGER    *LDT,
                    DOUBLE           *Y,
                    const INTEGER    *LDY);

//-- dlahrd --------------------------------------------------------------------
void
LAPACK_IMPL(dlahrd)(const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *NB,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *T,
                    const INTEGER    *LDT,
                    DOUBLE           *Y,
                    const INTEGER    *LDY);

//-- dlaic1 --------------------------------------------------------------------
void
LAPACK_IMPL(dlaic1)(const INTEGER    *JOB,
                    const INTEGER    *J,
                    const DOUBLE     *X,
                    const DOUBLE     *SEST,
                    const DOUBLE     *W,
                    const DOUBLE     *GAMMA,
                    DOUBLE           *SESTPR,
                    DOUBLE           *S,
                    DOUBLE           *C);

//-- dlaisnan ------------------------------------------------------------------
LOGICAL
LAPACK_IMPL(dlaisnan)(const DOUBLE     *DIN1,
                      const DOUBLE     *DIN2);

//-- dlaln2 --------------------------------------------------------------------
void
LAPACK_IMPL(dlaln2)(const LOGICAL    *LTRANS,
                    const INTEGER    *NA,
                    const INTEGER    *NW,
                    const DOUBLE     *SMIN,
                    const DOUBLE     *CA,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *D1,
                    const DOUBLE     *D2,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    const DOUBLE     *WR,
                    const DOUBLE     *WI,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *SCALE,
                    DOUBLE           *XNORM,
                    INTEGER          *INFO);

//-- dlals0 --------------------------------------------------------------------
void
LAPACK_IMPL(dlals0)(const INTEGER    *ICOMPQ,
                    const INTEGER    *NL,
                    const INTEGER    *NR,
                    const INTEGER    *SQRE,
                    const INTEGER    *NRHS,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *BX,
                    const INTEGER    *LDBX,
                    const INTEGER    *PERM,
                    const INTEGER    *GIVPTR,
                    const INTEGER    *GIVCOL,
                    const INTEGER    *LDGCOL,
                    const DOUBLE     *GIVNUM,
                    const INTEGER    *LDGNUM,
                    const DOUBLE     *POLES,
                    const DOUBLE     *DIFL,
                    const DOUBLE     *DIFR,
                    const DOUBLE     *Z,
                    const INTEGER    *K,
                    const DOUBLE     *C,
                    const DOUBLE     *S,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dlalsa --------------------------------------------------------------------
void
LAPACK_IMPL(dlalsa)(const INTEGER    *ICOMPQ,
                    const INTEGER    *SMLSIZ,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *BX,
                    const INTEGER    *LDBX,
                    const DOUBLE     *U,
                    const INTEGER    *LDU,
                    const DOUBLE     *VT,
                    const INTEGER    *K,
                    const DOUBLE     *DIFL,
                    const DOUBLE     *DIFR,
                    const DOUBLE     *Z,
                    const DOUBLE     *POLES,
                    const INTEGER    *GIVPTR,
                    const INTEGER    *GIVCOL,
                    const INTEGER    *LDGCOL,
                    const INTEGER    *PERM,
                    const DOUBLE     *GIVNUM,
                    const DOUBLE     *C,
                    const DOUBLE     *S,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dlalsd --------------------------------------------------------------------
void
LAPACK_IMPL(dlalsd)(const char       *UPLO,
                    const INTEGER    *SMLSIZ,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    const DOUBLE     *RCOND,
                    INTEGER          *RANK,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dlamch --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(dlamch)(const char   *CMACH);

//-- dlamrg --------------------------------------------------------------------
void
LAPACK_IMPL(dlamrg)(const INTEGER    *N1,
                    const INTEGER    *N2,
                    const DOUBLE     *A,
                    const INTEGER    *DTRD1,
                    const INTEGER    *DTRD2,
                    INTEGER          *INDEX);

//-- dlaneg --------------------------------------------------------------------
INTEGER
LAPACK_IMPL(dlaneg)(const INTEGER    *N,
                    const DOUBLE     *D,
                    const DOUBLE     *LLD,
                    const DOUBLE     *SIGMA,
                    const DOUBLE     *PIVMIN,
                    const INTEGER    *R);

//-- dlangb --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(dlangb)(const char       *NORM,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *WORK);

//-- dlange --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(dlange)(const char       *NORM,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *WORK);

//-- dlangt --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(dlangt)(const char       *NORM,
                    const INTEGER    *N,
                    const DOUBLE     *DL,
                    const DOUBLE     *D,
                    const DOUBLE     *DU);

//-- dlanhs --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(dlanhs)(const char       *NORM,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *WORK);

//-- dlansb --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(dlansb)(const char       *NORM,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *WORK);

//-- dlansf --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(dlansf)(const char       *NORM,
                    const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    DOUBLE           *WORK);

//-- dlansp --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(dlansp)(const char       *NORM,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *AP,
                    DOUBLE           *WORK);

//-- dlanst --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(dlanst)(const char       *NORM,
                    const INTEGER    *N,
                    const DOUBLE     *D,
                    const DOUBLE     *E);

//-- dlansy --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(dlansy)(const char       *NORM,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *WORK);

//-- dlantb --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(dlantb)(const char       *NORM,
                    const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *WORK);

//-- dlantp --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(dlantp)(const char       *NORM,
                    const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const DOUBLE     *AP,
                    DOUBLE           *WORK);

//-- dlantr --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(dlantr)(const char       *NORM,
                    const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *WORK);

//-- dlanv2 --------------------------------------------------------------------
void
LAPACK_IMPL(dlanv2)(DOUBLE   *A,
                    DOUBLE   *B,
                    DOUBLE   *C,
                    DOUBLE   *D,
                    DOUBLE   *RT1R,
                    DOUBLE   *RT1I,
                    DOUBLE   *RT2R,
                    DOUBLE   *RT2I,
                    DOUBLE   *CS,
                    DOUBLE   *SN);

//-- dlapll --------------------------------------------------------------------
void
LAPACK_IMPL(dlapll)(const INTEGER    *N,
                    DOUBLE           *X,
                    const INTEGER    *INCX,
                    DOUBLE           *Y,
                    const INTEGER    *INCY,
                    DOUBLE           *SSMIN);

//-- dlapmr --------------------------------------------------------------------
void
LAPACK_IMPL(dlapmr)(const LOGICAL    *FORWRD,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    INTEGER          *K);

//-- dlapmt --------------------------------------------------------------------
void
LAPACK_IMPL(dlapmt)(const LOGICAL    *FORWRD,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    INTEGER          *K);

//-- dlapy2 --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(dlapy2)(const DOUBLE     *X,
                    const DOUBLE     *Y);

//-- dlapy3 --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(dlapy3)(const DOUBLE     *X,
                    const DOUBLE     *Y,
                    const DOUBLE     *Z);

//-- dlaqgb --------------------------------------------------------------------
void
LAPACK_IMPL(dlaqgb)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    const DOUBLE     *R,
                    const DOUBLE     *C,
                    const DOUBLE     *ROWCND,
                    const DOUBLE     *COLCND,
                    const DOUBLE     *AMAX,
                    char             *EQUED);

//-- dlaqge --------------------------------------------------------------------
void
LAPACK_IMPL(dlaqge)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *R,
                    const DOUBLE     *C,
                    const DOUBLE     *ROWCND,
                    const DOUBLE     *COLCND,
                    const DOUBLE     *AMAX,
                    char             *EQUED);

//-- dlaqp2 --------------------------------------------------------------------
void
LAPACK_IMPL(dlaqp2)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *OFFSET,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    DOUBLE           *TAU,
                    DOUBLE           *VN1,
                    DOUBLE           *VN2,
                    DOUBLE           *WORK);

//-- dlaqps --------------------------------------------------------------------
void
LAPACK_IMPL(dlaqps)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *OFFSET,
                    const INTEGER    *NB,
                    INTEGER          *KB,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    DOUBLE           *TAU,
                    DOUBLE           *VN1,
                    DOUBLE           *VN2,
                    DOUBLE           *AUXV,
                    DOUBLE           *F,
                    const INTEGER    *LDF);

//-- dlaqr0 --------------------------------------------------------------------
void
LAPACK_IMPL(dlaqr0)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    DOUBLE           *H,
                    const INTEGER    *LDH,
                    DOUBLE           *WR,
                    DOUBLE           *WI,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dlaqr1 --------------------------------------------------------------------
void
LAPACK_IMPL(dlaqr1)(const INTEGER    *N,
                    const DOUBLE     *H,
                    const INTEGER    *LDH,
                    const DOUBLE     *SR1,
                    const DOUBLE     *SI1,
                    const DOUBLE     *SR2,
                    const DOUBLE     *SI2,
                    DOUBLE           *V);

//-- dlaqr2 --------------------------------------------------------------------
void
LAPACK_IMPL(dlaqr2)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *KTOP,
                    const INTEGER    *KBOT,
                    const INTEGER    *NW,
                    DOUBLE           *H,
                    const INTEGER    *LDH,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *NS,
                    INTEGER          *ND,
                    DOUBLE           *SR,
                    DOUBLE           *SI,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    const INTEGER    *NH,
                    DOUBLE           *T,
                    const INTEGER    *LDT,
                    const INTEGER    *NV,
                    DOUBLE           *WV,
                    const INTEGER    *LDWV,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK);

//-- dlaqr3 --------------------------------------------------------------------
void
LAPACK_IMPL(dlaqr3)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *KTOP,
                    const INTEGER    *KBOT,
                    const INTEGER    *NW,
                    DOUBLE           *H,
                    const INTEGER    *LDH,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *NS,
                    INTEGER          *ND,
                    DOUBLE           *SR,
                    DOUBLE           *SI,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    const INTEGER    *NH,
                    DOUBLE           *T,
                    const INTEGER    *LDT,
                    const INTEGER    *NV,
                    DOUBLE           *WV,
                    const INTEGER    *LDWV,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK);

//-- dlaqr4 --------------------------------------------------------------------
void
LAPACK_IMPL(dlaqr4)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    DOUBLE           *H,
                    const INTEGER    *LDH,
                    DOUBLE           *WR,
                    DOUBLE           *WI,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dlaqr5 --------------------------------------------------------------------
void
LAPACK_IMPL(dlaqr5)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *KACC22,
                    const INTEGER    *N,
                    const INTEGER    *KTOP,
                    const INTEGER    *KBOT,
                    const INTEGER    *NSHFTS,
                    DOUBLE           *SR,
                    DOUBLE           *SI,
                    DOUBLE           *H,
                    const INTEGER    *LDH,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    const INTEGER    *NV,
                    DOUBLE           *WV,
                    const INTEGER    *LDWV,
                    const INTEGER    *NH,
                    DOUBLE           *WH,
                    const INTEGER    *LDWH);

//-- dlaqsb --------------------------------------------------------------------
void
LAPACK_IMPL(dlaqsb)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    const DOUBLE     *S,
                    const DOUBLE     *SCOND,
                    const DOUBLE     *AMAX,
                    char             *EQUED);

//-- dlaqsp --------------------------------------------------------------------
void
LAPACK_IMPL(dlaqsp)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *AP,
                    const DOUBLE     *S,
                    const DOUBLE     *SCOND,
                    const DOUBLE     *AMAX,
                    char             *EQUED);

//-- dlaqsy --------------------------------------------------------------------
void
LAPACK_IMPL(dlaqsy)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *S,
                    const DOUBLE     *SCOND,
                    const DOUBLE     *AMAX,
                    char             *EQUED);

//-- dlaqtr --------------------------------------------------------------------
void
LAPACK_IMPL(dlaqtr)(const LOGICAL    *LTRAN,
                    const LOGICAL    *LREAL,
                    const INTEGER    *N,
                    const DOUBLE     *T,
                    const INTEGER    *LDT,
                    const DOUBLE     *B,
                    const DOUBLE     *W,
                    DOUBLE           *SCALE,
                    DOUBLE           *X,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dlar1v --------------------------------------------------------------------
void
LAPACK_IMPL(dlar1v)(const INTEGER    *N,
                    const INTEGER    *B1,
                    const INTEGER    *BN,
                    const DOUBLE     *LAMBDA,
                    const DOUBLE     *D,
                    const DOUBLE     *L,
                    const DOUBLE     *LD,
                    const DOUBLE     *LLD,
                    const DOUBLE     *PIVMIN,
                    const DOUBLE     *GAPTOL,
                    DOUBLE           *Z,
                    const LOGICAL    *WANTNC,
                    INTEGER          *NEGCNT,
                    DOUBLE           *ZTZ,
                    DOUBLE           *MINGMA,
                    INTEGER          *R,
                    INTEGER          *ISUPPZ,
                    DOUBLE           *NRMINV,
                    DOUBLE           *RESID,
                    DOUBLE           *RQCORR,
                    DOUBLE           *WORK);

//-- dlar2v --------------------------------------------------------------------
void
LAPACK_IMPL(dlar2v)(const INTEGER    *N,
                    DOUBLE           *X,
                    DOUBLE           *Y,
                    DOUBLE           *Z,
                    const INTEGER    *INCX,
                    const DOUBLE     *C,
                    const DOUBLE     *S,
                    const INTEGER    *INCC);

//-- dlarf ---------------------------------------------------------------------
void
LAPACK_IMPL(dlarf)(const char           *SIDE,
                   const INTEGER        *M,
                   const INTEGER        *N,
                   const DOUBLE         *V,
                   const INTEGER        *INCV,
                   const DOUBLE         *TAU,
                   DOUBLE               *C,
                   const INTEGER        *LDC,
                   DOUBLE               *WORK);

//-- dlarfb --------------------------------------------------------------------
void
LAPACK_IMPL(dlarfb)(const char       *SIDE,
                    const char       *TRANS,
                    const char       *DIRECT,
                    const char       *STOREV,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const DOUBLE     *V,
                    const INTEGER    *LDV,
                    const DOUBLE     *T,
                    const INTEGER    *LDT,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    const INTEGER    *LDWORK);

//-- dlarfg --------------------------------------------------------------------
void
LAPACK_IMPL(dlarfg)(const INTEGER    *N,
                    DOUBLE           *ALPHA,
                    DOUBLE           *X,
                    const INTEGER    *INCX,
                    DOUBLE           *TAU);

//-- dlarfgp -------------------------------------------------------------------
void
LAPACK_IMPL(dlarfgp)(const INTEGER    *N,
                     DOUBLE           *ALPHA,
                     DOUBLE           *X,
                     const INTEGER    *INCX,
                     DOUBLE           *TAU);

//-- dlarft --------------------------------------------------------------------
void
LAPACK_IMPL(dlarft)(const char       *DIRECT,
                    const char       *STOREV,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    const DOUBLE     *TAU,
                    DOUBLE           *T,
                    const INTEGER    *LDT);

//-- dlarfx --------------------------------------------------------------------
void
LAPACK_IMPL(dlarfx)(const char       *SIDE,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *V,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK);

//-- dlargv --------------------------------------------------------------------
void
LAPACK_IMPL(dlargv)(const INTEGER    *N,
                    DOUBLE           *X,
                    const INTEGER    *INCX,
                    DOUBLE           *Y,
                    const INTEGER    *INCY,
                    DOUBLE           *C,
                    const INTEGER    *INCC);

//-- dlarnv --------------------------------------------------------------------
void
LAPACK_IMPL(dlarnv)(const INTEGER    *IDIST,
                    INTEGER          *ISEED,
                    const INTEGER    *N,
                    DOUBLE           *X);

//-- dlarra --------------------------------------------------------------------
void
LAPACK_IMPL(dlarra)(const INTEGER    *N,
                    const DOUBLE     *D,
                    DOUBLE           *E,
                    DOUBLE           *E2,
                    const DOUBLE     *SPLTOL,
                    const DOUBLE     *TNRM,
                    INTEGER          *NSPLIT,
                    INTEGER          *ISPLIT,
                    INTEGER          *INFO);

//-- dlarrb --------------------------------------------------------------------
void
LAPACK_IMPL(dlarrb)(const INTEGER    *N,
                    const DOUBLE     *D,
                    const DOUBLE     *LLD,
                    const INTEGER    *IFIRST,
                    const INTEGER    *ILAST,
                    const DOUBLE     *RTOL1,
                    const DOUBLE     *RTOL2,
                    const INTEGER    *OFFSET,
                    DOUBLE           *W,
                    DOUBLE           *WGAP,
                    DOUBLE           *WERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    const DOUBLE     *PIVMIN,
                    const DOUBLE     *SPDIAM,
                    const INTEGER    *TWIST,
                    INTEGER          *INFO);

//-- dlarrc --------------------------------------------------------------------
void
LAPACK_IMPL(dlarrc)(const char       *JOBT,
                    const INTEGER    *N,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const DOUBLE     *D,
                    const DOUBLE     *E,
                    const DOUBLE     *PIVMIN,
                    INTEGER          *EIGCNT,
                    INTEGER          *LCNT,
                    INTEGER          *RCNT,
                    INTEGER          *INFO);

//-- dlarrd --------------------------------------------------------------------
void
LAPACK_IMPL(dlarrd)(const char       *RANGE,
                    const char       *ORDER,
                    const INTEGER    *N,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *GERS,
                    const DOUBLE     *RELTOL,
                    const DOUBLE     *D,
                    const DOUBLE     *E,
                    const DOUBLE     *E2,
                    const DOUBLE     *PIVMIN,
                    const INTEGER    *NSPLIT,
                    const INTEGER    *ISPLIT,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE           *WERR,
                    DOUBLE           *WL,
                    DOUBLE           *WU,
                    INTEGER          *IBLOCK,
                    INTEGER          *INDEXW,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dlarre --------------------------------------------------------------------
void
LAPACK_IMPL(dlarre)(const char       *RANGE,
                    const INTEGER    *N,
                    DOUBLE           *VL,
                    DOUBLE           *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *E2,
                    const DOUBLE     *RTOL1,
                    const DOUBLE     *RTOL2,
                    const DOUBLE     *SPLTOL,
                    INTEGER          *NSPLIT,
                    INTEGER          *ISPLIT,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE           *WERR,
                    DOUBLE           *WGAP,
                    INTEGER          *IBLOCK,
                    INTEGER          *INDEXW,
                    DOUBLE           *GERS,
                    DOUBLE           *PIVMIN,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dlarrf --------------------------------------------------------------------
void
LAPACK_IMPL(dlarrf)(const INTEGER    *N,
                    const DOUBLE     *D,
                    const DOUBLE     *L,
                    const DOUBLE     *LD,
                    const INTEGER    *CLSTRT,
                    const INTEGER    *CLEND,
                    const DOUBLE     *W,
                    DOUBLE           *WGAP,
                    const DOUBLE     *WERR,
                    const DOUBLE     *SPDIAM,
                    const DOUBLE     *CLGAPL,
                    const DOUBLE     *CLGAPR,
                    const DOUBLE     *PIVMIN,
                    DOUBLE           *SIGMA,
                    DOUBLE           *DPLUS,
                    DOUBLE           *LPLUS,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dlarrj --------------------------------------------------------------------
void
LAPACK_IMPL(dlarrj)(const INTEGER    *N,
                    const DOUBLE     *D,
                    const DOUBLE     *E2,
                    const INTEGER    *IFIRST,
                    const INTEGER    *ILAST,
                    const DOUBLE     *RTOL,
                    const INTEGER    *OFFSET,
                    DOUBLE           *W,
                    DOUBLE           *WERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    const DOUBLE     *PIVMIN,
                    const DOUBLE     *SPDIAM,
                    INTEGER          *INFO);

//-- dlarrk --------------------------------------------------------------------
void
LAPACK_IMPL(dlarrk)(const INTEGER    *N,
                    const INTEGER    *IW,
                    const DOUBLE     *GL,
                    const DOUBLE     *GU,
                    const DOUBLE     *D,
                    const DOUBLE     *E2,
                    const DOUBLE     *PIVMIN,
                    const DOUBLE     *RELTOL,
                    DOUBLE           *W,
                    DOUBLE           *WERR,
                    INTEGER          *INFO);

//-- dlarrr --------------------------------------------------------------------
void
LAPACK_IMPL(dlarrr)(const INTEGER    *N,
                    const DOUBLE     *D,
                    DOUBLE           *E,
                    INTEGER          *INFO);

//-- dlarrv --------------------------------------------------------------------
void
LAPACK_IMPL(dlarrv)(const INTEGER    *N,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    DOUBLE           *D,
                    DOUBLE           *L,
                    const DOUBLE     *PIVMIN,
                    const INTEGER    *ISPLIT,
                    const INTEGER    *M,
                    const INTEGER    *DOL,
                    const INTEGER    *DOU,
                    const DOUBLE     *MINRGP,
                    const DOUBLE     *RTOL1,
                    const DOUBLE     *RTOL2,
                    DOUBLE           *W,
                    DOUBLE           *WERR,
                    DOUBLE           *WGAP,
                    const INTEGER    *IBLOCK,
                    const INTEGER    *INDEXW,
                    const DOUBLE     *GERS,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *ISUPPZ,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dlarscl2 ------------------------------------------------------------------
void
LAPACK_IMPL(dlarscl2)(const INTEGER    *M,
                      const INTEGER    *N,
                      const DOUBLE     *D,
                      DOUBLE           *X,
                      const INTEGER    *LDX);

//-- dlartg --------------------------------------------------------------------
void
LAPACK_IMPL(dlartg)(const DOUBLE     *F,
                    const DOUBLE     *G,
                    DOUBLE           *CS,
                    DOUBLE           *SN,
                    DOUBLE           *R);

//-- dlartgp -------------------------------------------------------------------
void
LAPACK_IMPL(dlartgp)(const DOUBLE     *F,
                     const DOUBLE     *G,
                     DOUBLE           *CS,
                     DOUBLE           *SN,
                     DOUBLE           *R);

//-- dlartgs -------------------------------------------------------------------
void
LAPACK_IMPL(dlartgs)(const DOUBLE     *X,
                     const DOUBLE     *Y,
                     const DOUBLE     *SIGMA,
                     DOUBLE           *CS,
                     DOUBLE           *SN);

//-- dlartv --------------------------------------------------------------------
void
LAPACK_IMPL(dlartv)(const INTEGER    *N,
                    DOUBLE           *X,
                    const INTEGER    *INCX,
                    DOUBLE           *Y,
                    const INTEGER    *INCY,
                    const DOUBLE     *C,
                    const DOUBLE     *S,
                    const INTEGER    *INCC);

//-- dlaruv --------------------------------------------------------------------
void
LAPACK_IMPL(dlaruv)(INTEGER          *ISEED,
                    const INTEGER    *N,
                    DOUBLE           *X);

//-- dlarz ---------------------------------------------------------------------
void
LAPACK_IMPL(dlarz)(const char           *SIDE,
                   const INTEGER        *M,
                   const INTEGER        *N,
                   const INTEGER        *L,
                   const DOUBLE         *V,
                   const INTEGER        *INCV,
                   const DOUBLE         *TAU,
                   DOUBLE               *C,
                   const INTEGER        *LDC,
                   DOUBLE               *WORK);

//-- dlarzb --------------------------------------------------------------------
void
LAPACK_IMPL(dlarzb)(const char       *SIDE,
                    const char       *TRANS,
                    const char       *DIRECT,
                    const char       *STOREV,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *L,
                    const DOUBLE     *V,
                    const INTEGER    *LDV,
                    const DOUBLE     *T,
                    const INTEGER    *LDT,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    const INTEGER    *LDWORK);

//-- dlarzt --------------------------------------------------------------------
void
LAPACK_IMPL(dlarzt)(const char       *DIRECT,
                    const char       *STOREV,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    const DOUBLE     *TAU,
                    DOUBLE           *T,
                    const INTEGER    *LDT);

//-- dlas2 ---------------------------------------------------------------------
void
LAPACK_IMPL(dlas2)(const DOUBLE     *F,
                   const DOUBLE     *G,
                   const DOUBLE     *H,
                   DOUBLE           *SSMIN,
                   DOUBLE           *SSMAX);

//-- dlascl --------------------------------------------------------------------
void
LAPACK_IMPL(dlascl)(const char       *TYPE,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const DOUBLE     *CFROM,
                    const DOUBLE     *CTO,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- dlascl2 -------------------------------------------------------------------
void
LAPACK_IMPL(dlascl2)(const INTEGER    *M,
                     const INTEGER    *N,
                     const DOUBLE     *D,
                     DOUBLE           *X,
                     const INTEGER    *LDX);

//-- dlasd0 --------------------------------------------------------------------
void
LAPACK_IMPL(dlasd0)(const INTEGER    *N,
                    const INTEGER    *SQRE,
                    DOUBLE           *D,
                    const DOUBLE     *E,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *VT,
                    const INTEGER    *LDVT,
                    const INTEGER    *SMLSIZ,
                    INTEGER          *IWORK,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dlasd1 --------------------------------------------------------------------
void
LAPACK_IMPL(dlasd1)(const INTEGER    *NL,
                    const INTEGER    *NR,
                    const INTEGER    *SQRE,
                    DOUBLE           *D,
                    DOUBLE           *ALPHA,
                    DOUBLE           *BETA,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *VT,
                    const INTEGER    *LDVT,
                    INTEGER          *IDXQ,
                    INTEGER          *IWORK,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dlasd2 --------------------------------------------------------------------
void
LAPACK_IMPL(dlasd2)(const INTEGER    *NL,
                    const INTEGER    *NR,
                    const INTEGER    *SQRE,
                    INTEGER          *K,
                    DOUBLE           *D,
                    DOUBLE           *Z,
                    const DOUBLE     *ALPHA,
                    const DOUBLE     *BETA,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *VT,
                    const INTEGER    *LDVT,
                    DOUBLE           *DSIGMA,
                    DOUBLE           *U2,
                    const INTEGER    *LDU2,
                    DOUBLE           *VT2,
                    const INTEGER    *LDVT2,
                    INTEGER          *IDXP,
                    INTEGER          *IDX,
                    INTEGER          *IDXC,
                    INTEGER          *IDXQ,
                    INTEGER          *COLTYP,
                    INTEGER          *INFO);

//-- dlasd3 --------------------------------------------------------------------
void
LAPACK_IMPL(dlasd3)(const INTEGER    *NL,
                    const INTEGER    *NR,
                    const INTEGER    *SQRE,
                    const INTEGER    *K,
                    DOUBLE           *D,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    const DOUBLE     *DSIGMA,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *U2,
                    const INTEGER    *LDU2,
                    DOUBLE           *VT,
                    const INTEGER    *LDVT,
                    DOUBLE           *VT2,
                    const INTEGER    *LDVT2,
                    const INTEGER    *IDXC,
                    const INTEGER    *CTOT,
                    const DOUBLE     *Z,
                    INTEGER          *INFO);

//-- dlasd4 --------------------------------------------------------------------
void
LAPACK_IMPL(dlasd4)(const INTEGER    *N,
                    const INTEGER    *I,
                    const DOUBLE     *D,
                    const DOUBLE     *Z,
                    DOUBLE           *DELTA,
                    const DOUBLE     *RHO,
                    DOUBLE           *SIGMA,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dlasd5 --------------------------------------------------------------------
void
LAPACK_IMPL(dlasd5)(const INTEGER    *I,
                    const DOUBLE     *D,
                    const DOUBLE     *Z,
                    DOUBLE           *DELTA,
                    const DOUBLE     *RHO,
                    DOUBLE           *DSIGMA,
                    DOUBLE           *WORK);

//-- dlasd6 --------------------------------------------------------------------
void
LAPACK_IMPL(dlasd6)(const INTEGER    *ICOMPQ,
                    const INTEGER    *NL,
                    const INTEGER    *NR,
                    const INTEGER    *SQRE,
                    DOUBLE           *D,
                    DOUBLE           *VF,
                    DOUBLE           *VL,
                    DOUBLE           *ALPHA,
                    DOUBLE           *BETA,
                    INTEGER          *IDXQ,
                    INTEGER          *PERM,
                    INTEGER          *GIVPTR,
                    INTEGER          *GIVCOL,
                    const INTEGER    *LDGCOL,
                    DOUBLE           *GIVNUM,
                    const INTEGER    *LDGNUM,
                    DOUBLE           *POLES,
                    DOUBLE           *DIFL,
                    DOUBLE           *DIFR,
                    DOUBLE           *Z,
                    INTEGER          *K,
                    DOUBLE           *C,
                    DOUBLE           *S,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dlasd7 --------------------------------------------------------------------
void
LAPACK_IMPL(dlasd7)(const INTEGER    *ICOMPQ,
                    const INTEGER    *NL,
                    const INTEGER    *NR,
                    const INTEGER    *SQRE,
                    INTEGER          *K,
                    DOUBLE           *D,
                    DOUBLE           *Z,
                    DOUBLE           *ZW,
                    DOUBLE           *VF,
                    DOUBLE           *VFW,
                    DOUBLE           *VL,
                    DOUBLE           *VLW,
                    const DOUBLE     *ALPHA,
                    const DOUBLE     *BETA,
                    DOUBLE           *DSIGMA,
                    INTEGER          *IDX,
                    INTEGER          *IDXP,
                    const INTEGER    *IDXQ,
                    INTEGER          *PERM,
                    INTEGER          *GIVPTR,
                    INTEGER          *GIVCOL,
                    const INTEGER    *LDGCOL,
                    DOUBLE           *GIVNUM,
                    const INTEGER    *LDGNUM,
                    DOUBLE           *C,
                    DOUBLE           *S,
                    INTEGER          *INFO);

//-- dlasd8 --------------------------------------------------------------------
void
LAPACK_IMPL(dlasd8)(const INTEGER    *ICOMPQ,
                    const INTEGER    *K,
                    DOUBLE           *D,
                    DOUBLE           *Z,
                    DOUBLE           *VF,
                    DOUBLE           *VL,
                    DOUBLE           *DIFL,
                    DOUBLE           *DIFR,
                    const INTEGER    *LDDIFR,
                    DOUBLE           *DSIGMA,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dlasda --------------------------------------------------------------------
void
LAPACK_IMPL(dlasda)(const INTEGER    *ICOMPQ,
                    const INTEGER    *SMLSIZ,
                    const INTEGER    *N,
                    const INTEGER    *SQRE,
                    DOUBLE           *D,
                    const DOUBLE     *E,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *VT,
                    INTEGER          *K,
                    DOUBLE           *DIFL,
                    DOUBLE           *DIFR,
                    DOUBLE           *Z,
                    DOUBLE           *POLES,
                    INTEGER          *GIVPTR,
                    INTEGER          *GIVCOL,
                    const INTEGER    *LDGCOL,
                    INTEGER          *PERM,
                    DOUBLE           *GIVNUM,
                    DOUBLE           *C,
                    DOUBLE           *S,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dlasdq --------------------------------------------------------------------
void
LAPACK_IMPL(dlasdq)(const char       *UPLO,
                    const INTEGER    *SQRE,
                    const INTEGER    *N,
                    const INTEGER    *NCVT,
                    const INTEGER    *NRU,
                    const INTEGER    *NCC,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *VT,
                    const INTEGER    *LDVT,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dlasdt --------------------------------------------------------------------
void
LAPACK_IMPL(dlasdt)(const INTEGER    *N,
                    INTEGER          *LVL,
                    INTEGER          *ND,
                    INTEGER          *INODE,
                    INTEGER          *NDIML,
                    INTEGER          *NDIMR,
                    const INTEGER    *MSUB);

//-- dlaset --------------------------------------------------------------------
void
LAPACK_IMPL(dlaset)(const char       *UPLO,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *ALPHA,
                    const DOUBLE     *BETA,
                    DOUBLE           *A,
                    const INTEGER    *LDA);

//-- dlasq1 --------------------------------------------------------------------
void
LAPACK_IMPL(dlasq1)(const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dlasq2 --------------------------------------------------------------------
void
LAPACK_IMPL(dlasq2)(const INTEGER    *N,
                    DOUBLE           *Z,
                    INTEGER          *INFO);

//-- dlasq3 --------------------------------------------------------------------
void
LAPACK_IMPL(dlasq3)(const INTEGER    *I0,
                    INTEGER          *N0,
                    const DOUBLE     *Z,
                    INTEGER          *PP,
                    DOUBLE           *DMIN,
                    DOUBLE           *SIGMA,
                    DOUBLE           *DESIG,
                    const DOUBLE     *QMAX,
                    INTEGER          *NFAIL,
                    INTEGER          *ITER,
                    INTEGER          *NDIV,
                    const LOGICAL    *IEEE,
                    INTEGER          *TTYPE,
                    DOUBLE           *DMIN1,
                    DOUBLE           *DMIN2,
                    DOUBLE           *DN,
                    DOUBLE           *DN1,
                    DOUBLE           *DN2,
                    DOUBLE           *G,
                    DOUBLE           *TAU);

//-- dlasq4 --------------------------------------------------------------------
void
LAPACK_IMPL(dlasq4)(const INTEGER    *I0,
                    const INTEGER    *N0,
                    const DOUBLE     *Z,
                    const INTEGER    *PP,
                    const INTEGER    *N0IN,
                    const DOUBLE     *DMIN,
                    const DOUBLE     *DMIN1,
                    const DOUBLE     *DMIN2,
                    const DOUBLE     *DN,
                    const DOUBLE     *DN1,
                    const DOUBLE     *DN2,
                    DOUBLE           *TAU,
                    INTEGER          *TTYPE,
                    DOUBLE           *G);

//-- dlasq5 --------------------------------------------------------------------
void
LAPACK_IMPL(dlasq5)(const INTEGER    *I0,
                    const INTEGER    *N0,
                    const DOUBLE     *Z,
                    const INTEGER    *PP,
                    const DOUBLE     *TAU,
                    DOUBLE           *DMIN,
                    DOUBLE           *DMIN1,
                    DOUBLE           *DMIN2,
                    DOUBLE           *DN,
                    DOUBLE           *DNM1,
                    DOUBLE           *DNM2,
                    const LOGICAL    *IEEE);

//-- dlasq6 --------------------------------------------------------------------
void
LAPACK_IMPL(dlasq6)(const INTEGER    *I0,
                    const INTEGER    *N0,
                    const DOUBLE     *Z,
                    const INTEGER    *PP,
                    DOUBLE           *DMIN,
                    DOUBLE           *DMIN1,
                    DOUBLE           *DMIN2,
                    DOUBLE           *DN,
                    DOUBLE           *DNM1,
                    DOUBLE           *DNM2);

//-- dlasr ---------------------------------------------------------------------
void
LAPACK_IMPL(dlasr)(const char           *SIDE,
                   const char           *PIVOT,
                   const char           *DIRECT,
                   const INTEGER        *M,
                   const INTEGER        *N,
                   const DOUBLE         *C,
                   const DOUBLE         *S,
                   DOUBLE               *A,
                   const INTEGER        *LDA);

//-- dlasrt --------------------------------------------------------------------
void
LAPACK_IMPL(dlasrt)(const char       *ID,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    INTEGER          *INFO);

//-- dlassq --------------------------------------------------------------------
void
LAPACK_IMPL(dlassq)(const INTEGER    *N,
                    const DOUBLE     *X,
                    const INTEGER    *INCX,
                    DOUBLE           *SCALE,
                    DOUBLE           *SUMSQ);

//-- dlasv2 --------------------------------------------------------------------
void
LAPACK_IMPL(dlasv2)(const DOUBLE     *F,
                    const DOUBLE     *G,
                    const DOUBLE     *H,
                    DOUBLE           *SSMIN,
                    DOUBLE           *SSMAX,
                    DOUBLE           *SNR,
                    DOUBLE           *CSR,
                    DOUBLE           *SNL,
                    DOUBLE           *CSL);

//-- dlaswp --------------------------------------------------------------------
void
LAPACK_IMPL(dlaswp)(const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const INTEGER    *K1,
                    const INTEGER    *K2,
                    const INTEGER    *IPIV,
                    const INTEGER    *INCX);

//-- dlasy2 --------------------------------------------------------------------
void
LAPACK_IMPL(dlasy2)(const LOGICAL    *LTRANL,
                    const LOGICAL    *LTRANR,
                    const INTEGER    *ISGN,
                    const INTEGER    *N1,
                    const INTEGER    *N2,
                    const DOUBLE     *TL,
                    const INTEGER    *LDTL,
                    const DOUBLE     *TR,
                    const INTEGER    *LDTR,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *SCALE,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *XNORM,
                    INTEGER          *INFO);

//-- dlasyf --------------------------------------------------------------------
void
LAPACK_IMPL(dlasyf)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NB,
                    INTEGER          *KB,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    DOUBLE           *W,
                    const INTEGER    *LDW,
                    INTEGER          *INFO);

//-- dlat2s --------------------------------------------------------------------
void
LAPACK_IMPL(dlat2s)(const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    FLOAT            *SA,
                    const INTEGER    *LDSA,
                    INTEGER          *INFO);

//-- dlatbs --------------------------------------------------------------------
void
LAPACK_IMPL(dlatbs)(const char       *UPLO,
                    const char       *TRANS,
                    const char       *DIAG,
                    const char       *NORMIN,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *X,
                    DOUBLE           *SCALE,
                    DOUBLE           *CNORM,
                    INTEGER          *INFO);

//-- dlatdf --------------------------------------------------------------------
void
LAPACK_IMPL(dlatdf)(const INTEGER    *IJOB,
                    const INTEGER    *N,
                    const DOUBLE     *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *RHS,
                    DOUBLE           *RDSUM,
                    DOUBLE           *RDSCAL,
                    const INTEGER    *IPIV,
                    const INTEGER    *JPIV);

//-- dlatps --------------------------------------------------------------------
void
LAPACK_IMPL(dlatps)(const char       *UPLO,
                    const char       *TRANS,
                    const char       *DIAG,
                    const char       *NORMIN,
                    const INTEGER    *N,
                    const DOUBLE     *AP,
                    DOUBLE           *X,
                    DOUBLE           *SCALE,
                    DOUBLE           *CNORM,
                    INTEGER          *INFO);

//-- dlatrd --------------------------------------------------------------------
void
LAPACK_IMPL(dlatrd)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NB,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *E,
                    DOUBLE           *TAU,
                    DOUBLE           *W,
                    const INTEGER    *LDW);

//-- dlatrs --------------------------------------------------------------------
void
LAPACK_IMPL(dlatrs)(const char       *UPLO,
                    const char       *TRANS,
                    const char       *DIAG,
                    const char       *NORMIN,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *X,
                    DOUBLE           *SCALE,
                    DOUBLE           *CNORM,
                    INTEGER          *INFO);

//-- dlatrz --------------------------------------------------------------------
void
LAPACK_IMPL(dlatrz)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *L,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK);

//-- dlatzm --------------------------------------------------------------------
void
LAPACK_IMPL(dlatzm)(const char       *SIDE,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *V,
                    const INTEGER    *INCV,
                    const DOUBLE     *TAU,
                    DOUBLE           *C1,
                    DOUBLE           *C2,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK);

//-- dlauu2 --------------------------------------------------------------------
void
LAPACK_IMPL(dlauu2)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- dlauum --------------------------------------------------------------------
void
LAPACK_IMPL(dlauum)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- dopgtr --------------------------------------------------------------------
void
LAPACK_IMPL(dopgtr)(const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *AP,
                    const DOUBLE     *TAU,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dopmtr --------------------------------------------------------------------
void
LAPACK_IMPL(dopmtr)(const char       *SIDE,
                    const char       *UPLO,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *AP,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dorbdb --------------------------------------------------------------------
void
LAPACK_IMPL(dorbdb)(const char       *TRANS,
                    const char       *SIGNS,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *Q,
                    DOUBLE           *X11,
                    const INTEGER    *LDX11,
                    DOUBLE           *X12,
                    const INTEGER    *LDX12,
                    DOUBLE           *X21,
                    const INTEGER    *LDX21,
                    DOUBLE           *X22,
                    const INTEGER    *LDX22,
                    DOUBLE           *THETA,
                    DOUBLE           *PHI,
                    DOUBLE           *TAUP1,
                    DOUBLE           *TAUP2,
                    DOUBLE           *TAUQ1,
                    DOUBLE           *TAUQ2,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dorcsd --------------------------------------------------------------------
void
LAPACK_IMPL(dorcsd)(const char       *JOBU1,
                    const char       *JOBU2,
                    const char       *JOBV1T,
                    const char       *JOBV2T,
                    const char       *TRANS,
                    const char       *SIGNS,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *Q,
                    const DOUBLE     *X11,
                    const INTEGER    *LDX11,
                    const DOUBLE     *X12,
                    const INTEGER    *LDX12,
                    const DOUBLE     *X21,
                    const INTEGER    *LDX21,
                    const DOUBLE     *X22,
                    const INTEGER    *LDX22,
                    DOUBLE           *THETA,
                    DOUBLE           *U1,
                    const INTEGER    *LDU1,
                    DOUBLE           *U2,
                    const INTEGER    *LDU2,
                    DOUBLE           *V1T,
                    const INTEGER    *LDV1T,
                    DOUBLE           *V2T,
                    const INTEGER    *LDV2T,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dorg2l --------------------------------------------------------------------
void
LAPACK_IMPL(dorg2l)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dorg2r --------------------------------------------------------------------
void
LAPACK_IMPL(dorg2r)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dorgbr --------------------------------------------------------------------
void
LAPACK_IMPL(dorgbr)(const char       *VECT,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dorghr --------------------------------------------------------------------
void
LAPACK_IMPL(dorghr)(const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dorgl2 --------------------------------------------------------------------
void
LAPACK_IMPL(dorgl2)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dorglq --------------------------------------------------------------------
void
LAPACK_IMPL(dorglq)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dorgql --------------------------------------------------------------------
void
LAPACK_IMPL(dorgql)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dorgqr --------------------------------------------------------------------
void
LAPACK_IMPL(dorgqr)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dorgr2 --------------------------------------------------------------------
void
LAPACK_IMPL(dorgr2)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dorgrq --------------------------------------------------------------------
void
LAPACK_IMPL(dorgrq)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dorgtr --------------------------------------------------------------------
void
LAPACK_IMPL(dorgtr)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dorm2l --------------------------------------------------------------------
void
LAPACK_IMPL(dorm2l)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dorm2r --------------------------------------------------------------------
void
LAPACK_IMPL(dorm2r)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dormbr --------------------------------------------------------------------
void
LAPACK_IMPL(dormbr)(const char       *VECT,
                    const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dormhr --------------------------------------------------------------------
void
LAPACK_IMPL(dormhr)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dorml2 --------------------------------------------------------------------
void
LAPACK_IMPL(dorml2)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dormlq --------------------------------------------------------------------
void
LAPACK_IMPL(dormlq)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dormql --------------------------------------------------------------------
void
LAPACK_IMPL(dormql)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dormqr --------------------------------------------------------------------
void
LAPACK_IMPL(dormqr)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dormr2 --------------------------------------------------------------------
void
LAPACK_IMPL(dormr2)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dormr3 --------------------------------------------------------------------
void
LAPACK_IMPL(dormr3)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *L,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dormrq --------------------------------------------------------------------
void
LAPACK_IMPL(dormrq)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dormrz --------------------------------------------------------------------
void
LAPACK_IMPL(dormrz)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *L,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dormtr --------------------------------------------------------------------
void
LAPACK_IMPL(dormtr)(const char       *SIDE,
                    const char       *UPLO,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dpbcon --------------------------------------------------------------------
void
LAPACK_IMPL(dpbcon)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    const DOUBLE     *ANORM,
                    DOUBLE           *RCOND,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dpbequ --------------------------------------------------------------------
void
LAPACK_IMPL(dpbequ)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *S,
                    DOUBLE           *SCOND,
                    DOUBLE           *AMAX,
                    INTEGER          *INFO);

//-- dpbrfs --------------------------------------------------------------------
void
LAPACK_IMPL(dpbrfs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const INTEGER    *NRHS,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    const DOUBLE     *AFB,
                    const INTEGER    *LDAFB,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dpbstf --------------------------------------------------------------------
void
LAPACK_IMPL(dpbstf)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *INFO);

//-- dpbsv ---------------------------------------------------------------------
void
LAPACK_IMPL(dpbsv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *KD,
                   const INTEGER        *NRHS,
                   DOUBLE               *AB,
                   const INTEGER        *LDAB,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- dpbsvx --------------------------------------------------------------------
void
LAPACK_IMPL(dpbsvx)(const char       *FACT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const INTEGER    *NRHS,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *AFB,
                    const INTEGER    *LDAFB,
                    char             *EQUED,
                    DOUBLE           *S,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *RCOND,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dpbtf2 --------------------------------------------------------------------
void
LAPACK_IMPL(dpbtf2)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *INFO);

//-- dpbtrf --------------------------------------------------------------------
void
LAPACK_IMPL(dpbtrf)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *INFO);

//-- dpbtrs --------------------------------------------------------------------
void
LAPACK_IMPL(dpbtrs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const INTEGER    *NRHS,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- dpftrf --------------------------------------------------------------------
void
LAPACK_IMPL(dpftrf)(const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    INTEGER          *INFO);

//-- dpftri --------------------------------------------------------------------
void
LAPACK_IMPL(dpftri)(const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    INTEGER          *INFO);

//-- dpftrs --------------------------------------------------------------------
void
LAPACK_IMPL(dpftrs)(const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *A,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- dpocon --------------------------------------------------------------------
void
LAPACK_IMPL(dpocon)(const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *ANORM,
                    DOUBLE           *RCOND,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dpoequ --------------------------------------------------------------------
void
LAPACK_IMPL(dpoequ)(const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *S,
                    DOUBLE           *SCOND,
                    DOUBLE           *AMAX,
                    INTEGER          *INFO);

//-- dpoequb -------------------------------------------------------------------
void
LAPACK_IMPL(dpoequb)(const INTEGER    *N,
                     const DOUBLE     *A,
                     const INTEGER    *LDA,
                     DOUBLE           *S,
                     DOUBLE           *SCOND,
                     DOUBLE           *AMAX,
                     INTEGER          *INFO);

//-- dporfs --------------------------------------------------------------------
void
LAPACK_IMPL(dporfs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *AF,
                    const INTEGER    *LDAF,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dporfsx -------------------------------------------------------------------
void
LAPACK_IMPL(dporfsx)(const char       *UPLO,
                     const char       *EQUED,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     const DOUBLE     *A,
                     const INTEGER    *LDA,
                     const DOUBLE     *AF,
                     const INTEGER    *LDAF,
                     DOUBLE           *S,
                     const DOUBLE     *B,
                     const INTEGER    *LDB,
                     DOUBLE           *X,
                     const INTEGER    *LDX,
                     DOUBLE           *RCOND,
                     DOUBLE           *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     DOUBLE           *ERR_BNDS_NORM,
                     DOUBLE           *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     DOUBLE           *PARAMS,
                     DOUBLE           *WORK,
                     INTEGER          *IWORK,
                     INTEGER          *INFO);

//-- dposv ---------------------------------------------------------------------
void
LAPACK_IMPL(dposv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   DOUBLE               *A,
                   const INTEGER        *LDA,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- dposvx --------------------------------------------------------------------
void
LAPACK_IMPL(dposvx)(const char       *FACT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *AF,
                    const INTEGER    *LDAF,
                    char             *EQUED,
                    DOUBLE           *S,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *RCOND,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dposvxx -------------------------------------------------------------------
void
LAPACK_IMPL(dposvxx)(const char       *FACT,
                     const char       *UPLO,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     DOUBLE           *A,
                     const INTEGER    *LDA,
                     DOUBLE           *AF,
                     const INTEGER    *LDAF,
                     char             *EQUED,
                     DOUBLE           *S,
                     DOUBLE           *B,
                     const INTEGER    *LDB,
                     DOUBLE           *X,
                     const INTEGER    *LDX,
                     DOUBLE           *RCOND,
                     DOUBLE           *RPVGRW,
                     DOUBLE           *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     DOUBLE           *ERR_BNDS_NORM,
                     DOUBLE           *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     DOUBLE           *PARAMS,
                     DOUBLE           *WORK,
                     INTEGER          *IWORK,
                     INTEGER          *INFO);

//-- dpotf2 --------------------------------------------------------------------
void
LAPACK_IMPL(dpotf2)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- dpotrf --------------------------------------------------------------------
void
LAPACK_IMPL(dpotrf)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- dpotri --------------------------------------------------------------------
void
LAPACK_IMPL(dpotri)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- dpotrs --------------------------------------------------------------------
void
LAPACK_IMPL(dpotrs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- dppcon --------------------------------------------------------------------
void
LAPACK_IMPL(dppcon)(const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *AP,
                    const DOUBLE     *ANORM,
                    DOUBLE           *RCOND,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dppequ --------------------------------------------------------------------
void
LAPACK_IMPL(dppequ)(const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *AP,
                    DOUBLE           *S,
                    DOUBLE           *SCOND,
                    DOUBLE           *AMAX,
                    INTEGER          *INFO);

//-- dpprfs --------------------------------------------------------------------
void
LAPACK_IMPL(dpprfs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *AP,
                    const DOUBLE     *AFP,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dppsv ---------------------------------------------------------------------
void
LAPACK_IMPL(dppsv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   DOUBLE               *AP,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- dppsvx --------------------------------------------------------------------
void
LAPACK_IMPL(dppsvx)(const char       *FACT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE           *AP,
                    DOUBLE           *AFP,
                    char             *EQUED,
                    DOUBLE           *S,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *RCOND,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dpptrf --------------------------------------------------------------------
void
LAPACK_IMPL(dpptrf)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *AP,
                    INTEGER          *INFO);

//-- dpptri --------------------------------------------------------------------
void
LAPACK_IMPL(dpptri)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *AP,
                    INTEGER          *INFO);

//-- dpptrs --------------------------------------------------------------------
void
LAPACK_IMPL(dpptrs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *AP,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- dpstf2 --------------------------------------------------------------------
void
LAPACK_IMPL(dpstf2)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *PIV,
                    INTEGER          *RANK,
                    const DOUBLE     *TOL,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dpstrf --------------------------------------------------------------------
void
LAPACK_IMPL(dpstrf)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *PIV,
                    INTEGER          *RANK,
                    const DOUBLE     *TOL,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dptcon --------------------------------------------------------------------
void
LAPACK_IMPL(dptcon)(const INTEGER    *N,
                    const DOUBLE     *D,
                    const DOUBLE     *E,
                    const DOUBLE     *ANORM,
                    DOUBLE           *RCOND,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dpteqr --------------------------------------------------------------------
void
LAPACK_IMPL(dpteqr)(const char       *COMPZ,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dptrfs --------------------------------------------------------------------
void
LAPACK_IMPL(dptrfs)(const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *D,
                    const DOUBLE     *E,
                    const DOUBLE     *DF,
                    const DOUBLE     *EF,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dptsv ---------------------------------------------------------------------
void
LAPACK_IMPL(dptsv)(const INTEGER        *N,
                   const INTEGER        *NRHS,
                   DOUBLE               *D,
                   DOUBLE               *E,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- dptsvx --------------------------------------------------------------------
void
LAPACK_IMPL(dptsvx)(const char       *FACT,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *D,
                    const DOUBLE     *E,
                    DOUBLE           *DF,
                    DOUBLE           *EF,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *RCOND,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dpttrf --------------------------------------------------------------------
void
LAPACK_IMPL(dpttrf)(const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    INTEGER          *INFO);

//-- dpttrs --------------------------------------------------------------------
void
LAPACK_IMPL(dpttrs)(const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *D,
                    const DOUBLE     *E,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- dptts2 --------------------------------------------------------------------
void
LAPACK_IMPL(dptts2)(const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *D,
                    const DOUBLE     *E,
                    DOUBLE           *B,
                    const INTEGER    *LDB);

//-- drscl ---------------------------------------------------------------------
void
LAPACK_IMPL(drscl)(const INTEGER        *N,
                   const DOUBLE         *SA,
                   DOUBLE               *SX,
                   const INTEGER        *INCX);

//-- dsbev ---------------------------------------------------------------------
void
LAPACK_IMPL(dsbev)(const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *KD,
                   DOUBLE               *AB,
                   const INTEGER        *LDAB,
                   DOUBLE               *W,
                   DOUBLE               *Z,
                   const INTEGER        *LDZ,
                   DOUBLE               *WORK,
                   INTEGER              *INFO);

//-- dsbevd --------------------------------------------------------------------
void
LAPACK_IMPL(dsbevd)(const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- dsbevx --------------------------------------------------------------------
void
LAPACK_IMPL(dsbevx)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- dsbgst --------------------------------------------------------------------
void
LAPACK_IMPL(dsbgst)(const char       *VECT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KA,
                    const INTEGER    *KB,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    const DOUBLE     *BB,
                    const INTEGER    *LDBB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dsbgv ---------------------------------------------------------------------
void
LAPACK_IMPL(dsbgv)(const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *KA,
                   const INTEGER        *KB,
                   DOUBLE               *AB,
                   const INTEGER        *LDAB,
                   DOUBLE               *BB,
                   const INTEGER        *LDBB,
                   DOUBLE               *W,
                   DOUBLE               *Z,
                   const INTEGER        *LDZ,
                   DOUBLE               *WORK,
                   INTEGER              *INFO);

//-- dsbgvd --------------------------------------------------------------------
void
LAPACK_IMPL(dsbgvd)(const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KA,
                    const INTEGER    *KB,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *BB,
                    const INTEGER    *LDBB,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- dsbgvx --------------------------------------------------------------------
void
LAPACK_IMPL(dsbgvx)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KA,
                    const INTEGER    *KB,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *BB,
                    const INTEGER    *LDBB,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- dsbtrd --------------------------------------------------------------------
void
LAPACK_IMPL(dsbtrd)(const char       *VECT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dsfrk ---------------------------------------------------------------------
void
LAPACK_IMPL(dsfrk)(const char           *TRANSR,
                   const char           *UPLO,
                   const char           *TRANS,
                   const INTEGER        *N,
                   const INTEGER        *K,
                   const DOUBLE         *ALPHA,
                   const DOUBLE         *A,
                   const INTEGER        *LDA,
                   const DOUBLE         *BETA,
                   DOUBLE               *C);

//-- dsgesv --------------------------------------------------------------------
void
LAPACK_IMPL(dsgesv)(const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *WORK,
                    FLOAT            *SWORK,
                    INTEGER          *ITER,
                    INTEGER          *INFO);

//-- dspcon --------------------------------------------------------------------
void
LAPACK_IMPL(dspcon)(const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *AP,
                    const INTEGER    *IPIV,
                    const DOUBLE     *ANORM,
                    DOUBLE           *RCOND,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dspev ---------------------------------------------------------------------
void
LAPACK_IMPL(dspev)(const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   DOUBLE               *AP,
                   DOUBLE               *W,
                   DOUBLE               *Z,
                   const INTEGER        *LDZ,
                   DOUBLE               *WORK,
                   INTEGER              *INFO);

//-- dspevd --------------------------------------------------------------------
void
LAPACK_IMPL(dspevd)(const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *AP,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- dspevx --------------------------------------------------------------------
void
LAPACK_IMPL(dspevx)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *AP,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- dspgst --------------------------------------------------------------------
void
LAPACK_IMPL(dspgst)(const INTEGER    *ITYPE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *AP,
                    const DOUBLE     *BP,
                    INTEGER          *INFO);

//-- dspgv ---------------------------------------------------------------------
void
LAPACK_IMPL(dspgv)(const INTEGER        *ITYPE,
                   const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   DOUBLE               *AP,
                   DOUBLE               *BP,
                   DOUBLE               *W,
                   DOUBLE               *Z,
                   const INTEGER        *LDZ,
                   DOUBLE               *WORK,
                   INTEGER              *INFO);

//-- dspgvd --------------------------------------------------------------------
void
LAPACK_IMPL(dspgvd)(const INTEGER    *ITYPE,
                    const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *AP,
                    DOUBLE           *BP,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- dspgvx --------------------------------------------------------------------
void
LAPACK_IMPL(dspgvx)(const INTEGER    *ITYPE,
                    const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *AP,
                    DOUBLE           *BP,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- dsposv --------------------------------------------------------------------
void
LAPACK_IMPL(dsposv)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *WORK,
                    FLOAT            *SWORK,
                    INTEGER          *ITER,
                    INTEGER          *INFO);

//-- dsprfs --------------------------------------------------------------------
void
LAPACK_IMPL(dsprfs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *AP,
                    const DOUBLE     *AFP,
                    const INTEGER    *IPIV,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dspsv ---------------------------------------------------------------------
void
LAPACK_IMPL(dspsv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   DOUBLE               *AP,
                   INTEGER              *IPIV,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- dspsvx --------------------------------------------------------------------
void
LAPACK_IMPL(dspsvx)(const char       *FACT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *AP,
                    DOUBLE           *AFP,
                    INTEGER          *IPIV,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *RCOND,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dsptrd --------------------------------------------------------------------
void
LAPACK_IMPL(dsptrd)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *AP,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *TAU,
                    INTEGER          *INFO);

//-- dsptrf --------------------------------------------------------------------
void
LAPACK_IMPL(dsptrf)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *AP,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- dsptri --------------------------------------------------------------------
void
LAPACK_IMPL(dsptri)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *AP,
                    const INTEGER    *IPIV,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dsptrs --------------------------------------------------------------------
void
LAPACK_IMPL(dsptrs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *AP,
                    const INTEGER    *IPIV,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- dstebz --------------------------------------------------------------------
void
LAPACK_IMPL(dstebz)(const char       *RANGE,
                    const char       *ORDER,
                    const INTEGER    *N,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    const DOUBLE     *D,
                    const DOUBLE     *E,
                    INTEGER          *M,
                    INTEGER          *NSPLIT,
                    DOUBLE           *W,
                    INTEGER          *IBLOCK,
                    INTEGER          *ISPLIT,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dstedc --------------------------------------------------------------------
void
LAPACK_IMPL(dstedc)(const char       *COMPZ,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- dstegr --------------------------------------------------------------------
void
LAPACK_IMPL(dstegr)(const char       *JOBZ,
                    const char       *RANGE,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *ISUPPZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- dstein --------------------------------------------------------------------
void
LAPACK_IMPL(dstein)(const INTEGER    *N,
                    const DOUBLE     *D,
                    const DOUBLE     *E,
                    const INTEGER    *M,
                    const DOUBLE     *W,
                    const INTEGER    *IBLOCK,
                    const INTEGER    *ISPLIT,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- dstemr --------------------------------------------------------------------
void
LAPACK_IMPL(dstemr)(const char       *JOBZ,
                    const char       *RANGE,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    const INTEGER    *NZC,
                    INTEGER          *ISUPPZ,
                    LOGICAL          *TRYRAC,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- dsteqr --------------------------------------------------------------------
void
LAPACK_IMPL(dsteqr)(const char       *COMPZ,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dsterf --------------------------------------------------------------------
void
LAPACK_IMPL(dsterf)(const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    INTEGER          *INFO);

//-- dstev ---------------------------------------------------------------------
void
LAPACK_IMPL(dstev)(const char           *JOBZ,
                   const INTEGER        *N,
                   DOUBLE               *D,
                   DOUBLE               *E,
                   DOUBLE               *Z,
                   const INTEGER        *LDZ,
                   DOUBLE               *WORK,
                   INTEGER              *INFO);

//-- dstevd --------------------------------------------------------------------
void
LAPACK_IMPL(dstevd)(const char       *JOBZ,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- dstevr --------------------------------------------------------------------
void
LAPACK_IMPL(dstevr)(const char       *JOBZ,
                    const char       *RANGE,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *ISUPPZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- dstevx --------------------------------------------------------------------
void
LAPACK_IMPL(dstevx)(const char       *JOBZ,
                    const char       *RANGE,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- dsycon --------------------------------------------------------------------
void
LAPACK_IMPL(dsycon)(const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const INTEGER    *IPIV,
                    const DOUBLE     *ANORM,
                    DOUBLE           *RCOND,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dsyconv -------------------------------------------------------------------
void
LAPACK_IMPL(dsyconv)(const char       *UPLO,
                     const char       *WAY,
                     const INTEGER    *N,
                     const DOUBLE     *A,
                     const INTEGER    *LDA,
                     const INTEGER    *IPIV,
                     DOUBLE           *WORK,
                     INTEGER          *INFO);

//-- dsyequb -------------------------------------------------------------------
void
LAPACK_IMPL(dsyequb)(const char       *UPLO,
                     const INTEGER    *N,
                     const DOUBLE     *A,
                     const INTEGER    *LDA,
                     DOUBLE           *S,
                     DOUBLE           *SCOND,
                     DOUBLE           *AMAX,
                     DOUBLE           *WORK,
                     INTEGER          *INFO);

//-- dsyev ---------------------------------------------------------------------
void
LAPACK_IMPL(dsyev)(const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   DOUBLE               *A,
                   const INTEGER        *LDA,
                   DOUBLE               *W,
                   DOUBLE               *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO);

//-- dsyevd --------------------------------------------------------------------
void
LAPACK_IMPL(dsyevd)(const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *W,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- dsyevr --------------------------------------------------------------------
void
LAPACK_IMPL(dsyevr)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *ISUPPZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- dsyevx --------------------------------------------------------------------
void
LAPACK_IMPL(dsyevx)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- dsygs2 --------------------------------------------------------------------
void
LAPACK_IMPL(dsygs2)(const INTEGER    *ITYPE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- dsygst --------------------------------------------------------------------
void
LAPACK_IMPL(dsygst)(const INTEGER    *ITYPE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- dsygv ---------------------------------------------------------------------
void
LAPACK_IMPL(dsygv)(const INTEGER        *ITYPE,
                   const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   DOUBLE               *A,
                   const INTEGER        *LDA,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   DOUBLE               *W,
                   DOUBLE               *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO);

//-- dsygvd --------------------------------------------------------------------
void
LAPACK_IMPL(dsygvd)(const INTEGER    *ITYPE,
                    const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *W,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- dsygvx --------------------------------------------------------------------
void
LAPACK_IMPL(dsygvx)(const INTEGER    *ITYPE,
                    const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- dsyrfs --------------------------------------------------------------------
void
LAPACK_IMPL(dsyrfs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *AF,
                    const INTEGER    *LDAF,
                    const INTEGER    *IPIV,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dsyrfsx -------------------------------------------------------------------
void
LAPACK_IMPL(dsyrfsx)(const char       *UPLO,
                     const char       *EQUED,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     const DOUBLE     *A,
                     const INTEGER    *LDA,
                     const DOUBLE     *AF,
                     const INTEGER    *LDAF,
                     const INTEGER    *IPIV,
                     DOUBLE           *S,
                     const DOUBLE     *B,
                     const INTEGER    *LDB,
                     DOUBLE           *X,
                     const INTEGER    *LDX,
                     DOUBLE           *RCOND,
                     DOUBLE           *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     DOUBLE           *ERR_BNDS_NORM,
                     DOUBLE           *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     DOUBLE           *PARAMS,
                     DOUBLE           *WORK,
                     INTEGER          *IWORK,
                     INTEGER          *INFO);

//-- dsysv ---------------------------------------------------------------------
void
LAPACK_IMPL(dsysv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   DOUBLE               *A,
                   const INTEGER        *LDA,
                   INTEGER              *IPIV,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   DOUBLE               *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO);

//-- dsysvx --------------------------------------------------------------------
void
LAPACK_IMPL(dsysvx)(const char       *FACT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *AF,
                    const INTEGER    *LDAF,
                    INTEGER          *IPIV,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *RCOND,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dsysvxx -------------------------------------------------------------------
void
LAPACK_IMPL(dsysvxx)(const char       *FACT,
                     const char       *UPLO,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     DOUBLE           *A,
                     const INTEGER    *LDA,
                     DOUBLE           *AF,
                     const INTEGER    *LDAF,
                     INTEGER          *IPIV,
                     char             *EQUED,
                     DOUBLE           *S,
                     DOUBLE           *B,
                     const INTEGER    *LDB,
                     DOUBLE           *X,
                     const INTEGER    *LDX,
                     DOUBLE           *RCOND,
                     DOUBLE           *RPVGRW,
                     DOUBLE           *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     DOUBLE           *ERR_BNDS_NORM,
                     DOUBLE           *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     DOUBLE           *PARAMS,
                     DOUBLE           *WORK,
                     INTEGER          *IWORK,
                     INTEGER          *INFO);

//-- dsyswapr ------------------------------------------------------------------
void
LAPACK_IMPL(dsyswapr)(const char       *UPLO,
                      const INTEGER    *N,
                      DOUBLE           *A,
                      const INTEGER    *LDA,
                      const INTEGER    *I1,
                      const INTEGER    *I2);

//-- dsytd2 --------------------------------------------------------------------
void
LAPACK_IMPL(dsytd2)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *TAU,
                    INTEGER          *INFO);

//-- dsytf2 --------------------------------------------------------------------
void
LAPACK_IMPL(dsytf2)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- dsytrd --------------------------------------------------------------------
void
LAPACK_IMPL(dsytrd)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dsytrf --------------------------------------------------------------------
void
LAPACK_IMPL(dsytrf)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dsytri --------------------------------------------------------------------
void
LAPACK_IMPL(dsytri)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const INTEGER    *IPIV,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dsytri2 -------------------------------------------------------------------
void
LAPACK_IMPL(dsytri2)(const char       *UPLO,
                     const INTEGER    *N,
                     DOUBLE           *A,
                     const INTEGER    *LDA,
                     const INTEGER    *IPIV,
                     DOUBLE           *WORK,
                     const INTEGER    *LWORK,
                     INTEGER          *INFO);

//-- dsytri2x ------------------------------------------------------------------
void
LAPACK_IMPL(dsytri2x)(const char       *UPLO,
                      const INTEGER    *N,
                      DOUBLE           *A,
                      const INTEGER    *LDA,
                      const INTEGER    *IPIV,
                      DOUBLE           *WORK,
                      const INTEGER    *NB,
                      INTEGER          *INFO);

//-- dsytrs --------------------------------------------------------------------
void
LAPACK_IMPL(dsytrs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const INTEGER    *IPIV,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- dsytrs2 -------------------------------------------------------------------
void
LAPACK_IMPL(dsytrs2)(const char       *UPLO,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     const DOUBLE     *A,
                     const INTEGER    *LDA,
                     const INTEGER    *IPIV,
                     DOUBLE           *B,
                     const INTEGER    *LDB,
                     DOUBLE           *WORK,
                     INTEGER          *INFO);

//-- dtbcon --------------------------------------------------------------------
void
LAPACK_IMPL(dtbcon)(const char       *NORM,
                    const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *RCOND,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dtbrfs --------------------------------------------------------------------
void
LAPACK_IMPL(dtbrfs)(const char       *UPLO,
                    const char       *TRANS,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const INTEGER    *NRHS,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    const DOUBLE     *X,
                    const INTEGER    *LDX,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dtbtrs --------------------------------------------------------------------
void
LAPACK_IMPL(dtbtrs)(const char       *UPLO,
                    const char       *TRANS,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const INTEGER    *NRHS,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- dtfsm ---------------------------------------------------------------------
void
LAPACK_IMPL(dtfsm)(const char           *TRANSR,
                   const char           *SIDE,
                   const char           *UPLO,
                   const char           *TRANS,
                   const char           *DIAG,
                   const INTEGER        *M,
                   const INTEGER        *N,
                   const DOUBLE         *ALPHA,
                   const DOUBLE         *A,
                   DOUBLE               *B,
                   const INTEGER        *LDB);

//-- dtftri --------------------------------------------------------------------
void
LAPACK_IMPL(dtftri)(const char       *TRANSR,
                    const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    INTEGER          *INFO);

//-- dtfttp --------------------------------------------------------------------
void
LAPACK_IMPL(dtfttp)(const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *ARF,
                    DOUBLE           *AP,
                    INTEGER          *INFO);

//-- dtfttr --------------------------------------------------------------------
void
LAPACK_IMPL(dtfttr)(const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *ARF,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- dtgevc --------------------------------------------------------------------
void
LAPACK_IMPL(dtgevc)(const char       *SIDE,
                    const char       *HOWMNY,
                    const LOGICAL    *SELECT,
                    const INTEGER    *N,
                    const DOUBLE     *S,
                    const INTEGER    *LDS,
                    const DOUBLE     *P,
                    const INTEGER    *LDP,
                    DOUBLE           *VL,
                    const INTEGER    *LDVL,
                    DOUBLE           *VR,
                    const INTEGER    *LDVR,
                    const INTEGER    *MM,
                    INTEGER          *M,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dtgex2 --------------------------------------------------------------------
void
LAPACK_IMPL(dtgex2)(const LOGICAL    *WANTQ,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    const INTEGER    *J1,
                    const INTEGER    *N1,
                    const INTEGER    *N2,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dtgexc --------------------------------------------------------------------
void
LAPACK_IMPL(dtgexc)(const LOGICAL    *WANTQ,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *IFST,
                    INTEGER          *ILST,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dtgsen --------------------------------------------------------------------
void
LAPACK_IMPL(dtgsen)(const INTEGER    *IJOB,
                    const LOGICAL    *WANTQ,
                    const LOGICAL    *WANTZ,
                    const LOGICAL    *SELECT,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *ALPHAR,
                    DOUBLE           *ALPHAI,
                    DOUBLE           *BETA,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *M,
                    DOUBLE           *PL,
                    DOUBLE           *PR,
                    DOUBLE           *DIF,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- dtgsja --------------------------------------------------------------------
void
LAPACK_IMPL(dtgsja)(const char       *JOBU,
                    const char       *JOBV,
                    const char       *JOBQ,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *L,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    const DOUBLE     *TOLA,
                    const DOUBLE     *TOLB,
                    DOUBLE           *ALPHA,
                    DOUBLE           *BETA,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    DOUBLE           *WORK,
                    INTEGER          *NCYCLE,
                    INTEGER          *INFO);

//-- dtgsna --------------------------------------------------------------------
void
LAPACK_IMPL(dtgsna)(const char       *JOB,
                    const char       *HOWMNY,
                    const LOGICAL    *SELECT,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    const DOUBLE     *VL,
                    const INTEGER    *LDVL,
                    const DOUBLE     *VR,
                    const INTEGER    *LDVR,
                    DOUBLE           *S,
                    DOUBLE           *DIF,
                    const INTEGER    *MM,
                    INTEGER          *M,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dtgsy2 --------------------------------------------------------------------
void
LAPACK_IMPL(dtgsy2)(const char       *TRANS,
                    const INTEGER    *IJOB,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    const DOUBLE     *D,
                    const INTEGER    *LDD,
                    const DOUBLE     *E,
                    const INTEGER    *LDE,
                    DOUBLE           *F,
                    const INTEGER    *LDF,
                    DOUBLE           *SCALE,
                    DOUBLE           *RDSUM,
                    DOUBLE           *RDSCAL,
                    INTEGER          *IWORK,
                    INTEGER          *PQ,
                    INTEGER          *INFO);

//-- dtgsyl --------------------------------------------------------------------
void
LAPACK_IMPL(dtgsyl)(const char       *TRANS,
                    const INTEGER    *IJOB,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    const DOUBLE     *D,
                    const INTEGER    *LDD,
                    const DOUBLE     *E,
                    const INTEGER    *LDE,
                    DOUBLE           *F,
                    const INTEGER    *LDF,
                    DOUBLE           *SCALE,
                    DOUBLE           *DIF,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dtpcon --------------------------------------------------------------------
void
LAPACK_IMPL(dtpcon)(const char       *NORM,
                    const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const DOUBLE     *AP,
                    DOUBLE           *RCOND,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dtprfs --------------------------------------------------------------------
void
LAPACK_IMPL(dtprfs)(const char       *UPLO,
                    const char       *TRANS,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *AP,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    const DOUBLE     *X,
                    const INTEGER    *LDX,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dtptri --------------------------------------------------------------------
void
LAPACK_IMPL(dtptri)(const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    DOUBLE           *AP,
                    INTEGER          *INFO);

//-- dtptrs --------------------------------------------------------------------
void
LAPACK_IMPL(dtptrs)(const char       *UPLO,
                    const char       *TRANS,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *AP,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- dtpttf --------------------------------------------------------------------
void
LAPACK_IMPL(dtpttf)(const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *AP,
                    DOUBLE           *ARF,
                    INTEGER          *INFO);

//-- dtpttr --------------------------------------------------------------------
void
LAPACK_IMPL(dtpttr)(const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *AP,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- dtrcon --------------------------------------------------------------------
void
LAPACK_IMPL(dtrcon)(const char       *NORM,
                    const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *RCOND,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dtrevc --------------------------------------------------------------------
void
LAPACK_IMPL(dtrevc)(const char       *SIDE,
                    const char       *HOWMNY,
                    LOGICAL          *SELECT,
                    const INTEGER    *N,
                    const DOUBLE     *T,
                    const INTEGER    *LDT,
                    DOUBLE           *VL,
                    const INTEGER    *LDVL,
                    DOUBLE           *VR,
                    const INTEGER    *LDVR,
                    const INTEGER    *MM,
                    INTEGER          *M,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dtrexc --------------------------------------------------------------------
void
LAPACK_IMPL(dtrexc)(const char       *COMPQ,
                    const INTEGER    *N,
                    DOUBLE           *T,
                    const INTEGER    *LDT,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    INTEGER          *IFST,
                    INTEGER          *ILST,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- dtrrfs --------------------------------------------------------------------
void
LAPACK_IMPL(dtrrfs)(const char       *UPLO,
                    const char       *TRANS,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    const DOUBLE     *X,
                    const INTEGER    *LDX,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dtrsen --------------------------------------------------------------------
void
LAPACK_IMPL(dtrsen)(const char       *JOB,
                    const char       *COMPQ,
                    const LOGICAL    *SELECT,
                    const INTEGER    *N,
                    DOUBLE           *T,
                    const INTEGER    *LDT,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    DOUBLE           *WR,
                    DOUBLE           *WI,
                    INTEGER          *M,
                    DOUBLE           *S,
                    DOUBLE           *SEP,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- dtrsna --------------------------------------------------------------------
void
LAPACK_IMPL(dtrsna)(const char       *JOB,
                    const char       *HOWMNY,
                    const LOGICAL    *SELECT,
                    const INTEGER    *N,
                    const DOUBLE     *T,
                    const INTEGER    *LDT,
                    const DOUBLE     *VL,
                    const INTEGER    *LDVL,
                    const DOUBLE     *VR,
                    const INTEGER    *LDVR,
                    DOUBLE           *S,
                    DOUBLE           *SEP,
                    const INTEGER    *MM,
                    INTEGER          *M,
                    DOUBLE           *WORK,
                    const INTEGER    *LDWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- dtrsyl --------------------------------------------------------------------
void
LAPACK_IMPL(dtrsyl)(const char       *TRANA,
                    const char       *TRANB,
                    const INTEGER    *ISGN,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *SCALE,
                    INTEGER          *INFO);

//-- dtrti2 --------------------------------------------------------------------
void
LAPACK_IMPL(dtrti2)(const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- dtrtri --------------------------------------------------------------------
void
LAPACK_IMPL(dtrtri)(const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- dtrtrs --------------------------------------------------------------------
void
LAPACK_IMPL(dtrtrs)(const char       *UPLO,
                    const char       *TRANS,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- dtrttf --------------------------------------------------------------------
void
LAPACK_IMPL(dtrttf)(const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *ARF,
                    INTEGER          *INFO);

//-- dtrttp --------------------------------------------------------------------
void
LAPACK_IMPL(dtrttp)(const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *AP,
                    INTEGER          *INFO);

//-- dtzrqf --------------------------------------------------------------------
void
LAPACK_IMPL(dtzrqf)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    INTEGER          *INFO);

//-- dtzrzf --------------------------------------------------------------------
void
LAPACK_IMPL(dtzrzf)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- dzsum1 --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(dzsum1)(const INTEGER            *N,
                    const DOUBLE_COMPLEX     *CX,
                    const INTEGER            *INCX);

//-- icmax1 --------------------------------------------------------------------
INTEGER
LAPACK_IMPL(icmax1)(const INTEGER        *N,
                    const FLOAT_COMPLEX  *CX,
                    const INTEGER        *INCX);

//-- ieeeck --------------------------------------------------------------------
INTEGER
LAPACK_IMPL(ieeeck)(const INTEGER    *ISPEC,
                    const FLOAT      *ZERO,
                    const FLOAT      *ONE);

//-- ilaclc --------------------------------------------------------------------
INTEGER
LAPACK_IMPL(ilaclc)(const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA);

//-- ilaclr --------------------------------------------------------------------
INTEGER
LAPACK_IMPL(ilaclr)(const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA);

//-- iladiag -------------------------------------------------------------------
INTEGER
LAPACK_IMPL(iladiag)(const char   *DIAG);

//-- iladlc --------------------------------------------------------------------
INTEGER
LAPACK_IMPL(iladlc)(const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA);

//-- iladlr --------------------------------------------------------------------
INTEGER
LAPACK_IMPL(iladlr)(const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA);

//-- ilaprec -------------------------------------------------------------------
INTEGER
LAPACK_IMPL(ilaprec)(const char   *PREC);

//-- ilaslc --------------------------------------------------------------------
INTEGER
LAPACK_IMPL(ilaslc)(const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA);

//-- ilaslr --------------------------------------------------------------------
INTEGER
LAPACK_IMPL(ilaslr)(const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA);

//-- ilatrans ------------------------------------------------------------------
INTEGER
LAPACK_IMPL(ilatrans)(const char       *TRANS);

//-- ilauplo -------------------------------------------------------------------
INTEGER
LAPACK_IMPL(ilauplo)(const char   *UPLO);

//-- ilaver --------------------------------------------------------------------
void
LAPACK_IMPL(ilaver)(INTEGER  *VERS_MAJOR,
                    INTEGER  *VERS_MINOR,
                    INTEGER  *VERS_PATCH);

//-- ilazlc --------------------------------------------------------------------
INTEGER
LAPACK_IMPL(ilazlc)(const INTEGER            *M,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA);

//-- ilazlr --------------------------------------------------------------------
INTEGER
LAPACK_IMPL(ilazlr)(const INTEGER            *M,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA);

//-- iparmq --------------------------------------------------------------------
INTEGER
LAPACK_IMPL(iparmq)(const INTEGER    *ISPEC,
                    const char       *NAME,
                    const char       *OPTS,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    const INTEGER    *LWORK);

//-- izmax1 --------------------------------------------------------------------
INTEGER
LAPACK_IMPL(izmax1)(const INTEGER            *N,
                    const DOUBLE_COMPLEX     *CX,
                    const INTEGER            *INCX);

//-- lsame ---------------------------------------------------------------------
LOGICAL
LAPACK_IMPL(lsame)(const char       *CA,
                   const char       *CB);

//-- lsamen --------------------------------------------------------------------
LOGICAL
LAPACK_IMPL(lsamen)(const INTEGER    *N,
                    const char       *CA,
                    const char       *CB);

//-- sbbcsd --------------------------------------------------------------------
void
LAPACK_IMPL(sbbcsd)(const char       *JOBU1,
                    const char       *JOBU2,
                    const char       *JOBV1T,
                    const char       *JOBV2T,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *Q,
                    FLOAT            *THETA,
                    FLOAT            *PHI,
                    FLOAT            *U1,
                    const INTEGER    *LDU1,
                    FLOAT            *U2,
                    const INTEGER    *LDU2,
                    FLOAT            *V1T,
                    const INTEGER    *LDV1T,
                    FLOAT            *V2T,
                    const INTEGER    *LDV2T,
                    FLOAT            *B11D,
                    FLOAT            *B11E,
                    FLOAT            *B12D,
                    FLOAT            *B12E,
                    const FLOAT      *B21D,
                    const FLOAT      *B21E,
                    const FLOAT      *B22D,
                    const FLOAT      *B22E,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sbdsdc --------------------------------------------------------------------
void
LAPACK_IMPL(sbdsdc)(const char       *UPLO,
                    const char       *COMPQ,
                    const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT            *U,
                    const INTEGER    *LDU,
                    FLOAT            *VT,
                    const INTEGER    *LDVT,
                    FLOAT            *Q,
                    INTEGER          *IQ,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- sbdsqr --------------------------------------------------------------------
void
LAPACK_IMPL(sbdsqr)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NCVT,
                    const INTEGER    *NRU,
                    const INTEGER    *NCC,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT            *VT,
                    const INTEGER    *LDVT,
                    FLOAT            *U,
                    const INTEGER    *LDU,
                    FLOAT            *C,
                    const INTEGER    *LDC,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- scsum1 --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(scsum1)(const INTEGER        *N,
                    const FLOAT_COMPLEX  *CX,
                    const INTEGER        *INCX);

//-- sdisna --------------------------------------------------------------------
void
LAPACK_IMPL(sdisna)(const char       *JOB,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *D,
                    FLOAT            *SEP,
                    INTEGER          *INFO);

//-- sgbbrd --------------------------------------------------------------------
void
LAPACK_IMPL(sgbbrd)(const char       *VECT,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NCC,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    FLOAT            *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    FLOAT            *PT,
                    const INTEGER    *LDPT,
                    FLOAT            *C,
                    const INTEGER    *LDC,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- sgbcon --------------------------------------------------------------------
void
LAPACK_IMPL(sgbcon)(const char       *NORM,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const FLOAT      *AB,
                    const INTEGER    *LDAB,
                    const INTEGER    *IPIV,
                    const FLOAT      *ANORM,
                    FLOAT            *RCOND,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- sgbequ --------------------------------------------------------------------
void
LAPACK_IMPL(sgbequ)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const FLOAT      *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *R,
                    FLOAT            *C,
                    FLOAT            *ROWCND,
                    FLOAT            *COLCND,
                    FLOAT            *AMAX,
                    INTEGER          *INFO);

//-- sgbequb -------------------------------------------------------------------
void
LAPACK_IMPL(sgbequb)(const INTEGER    *M,
                     const INTEGER    *N,
                     const INTEGER    *KL,
                     const INTEGER    *KU,
                     const FLOAT      *AB,
                     const INTEGER    *LDAB,
                     FLOAT            *R,
                     FLOAT            *C,
                     FLOAT            *ROWCND,
                     FLOAT            *COLCND,
                     FLOAT            *AMAX,
                     INTEGER          *INFO);

//-- sgbrfs --------------------------------------------------------------------
void
LAPACK_IMPL(sgbrfs)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const INTEGER    *NRHS,
                    const FLOAT      *AB,
                    const INTEGER    *LDAB,
                    const FLOAT      *AFB,
                    const INTEGER    *LDAFB,
                    const INTEGER    *IPIV,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- sgbrfsx -------------------------------------------------------------------
void
LAPACK_IMPL(sgbrfsx)(const char       *TRANS,
                     const char       *EQUED,
                     const INTEGER    *N,
                     const INTEGER    *KL,
                     const INTEGER    *KU,
                     const INTEGER    *NRHS,
                     const FLOAT      *AB,
                     const INTEGER    *LDAB,
                     const FLOAT      *AFB,
                     const INTEGER    *LDAFB,
                     const INTEGER    *IPIV,
                     FLOAT            *R,
                     FLOAT            *C,
                     const FLOAT      *B,
                     const INTEGER    *LDB,
                     FLOAT            *X,
                     const INTEGER    *LDX,
                     FLOAT            *RCOND,
                     FLOAT            *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     FLOAT            *ERR_BNDS_NORM,
                     FLOAT            *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     FLOAT            *PARAMS,
                     FLOAT            *WORK,
                     INTEGER          *IWORK,
                     INTEGER          *INFO);

//-- sgbsv ---------------------------------------------------------------------
void
LAPACK_IMPL(sgbsv)(const INTEGER        *N,
                   const INTEGER        *KL,
                   const INTEGER        *KU,
                   const INTEGER        *NRHS,
                   FLOAT                *AB,
                   const INTEGER        *LDAB,
                   INTEGER              *IPIV,
                   FLOAT                *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- sgbsvx --------------------------------------------------------------------
void
LAPACK_IMPL(sgbsvx)(const char       *FACT,
                    const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const INTEGER    *NRHS,
                    FLOAT            *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *AFB,
                    const INTEGER    *LDAFB,
                    INTEGER          *IPIV,
                    char             *EQUED,
                    FLOAT            *R,
                    FLOAT            *C,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *RCOND,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- sgbsvxx -------------------------------------------------------------------
void
LAPACK_IMPL(sgbsvxx)(const char       *FACT,
                     const char       *TRANS,
                     const INTEGER    *N,
                     const INTEGER    *KL,
                     const INTEGER    *KU,
                     const INTEGER    *NRHS,
                     FLOAT            *AB,
                     const INTEGER    *LDAB,
                     FLOAT            *AFB,
                     const INTEGER    *LDAFB,
                     INTEGER          *IPIV,
                     char             *EQUED,
                     FLOAT            *R,
                     FLOAT            *C,
                     FLOAT            *B,
                     const INTEGER    *LDB,
                     FLOAT            *X,
                     const INTEGER    *LDX,
                     FLOAT            *RCOND,
                     FLOAT            *RPVGRW,
                     FLOAT            *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     FLOAT            *ERR_BNDS_NORM,
                     FLOAT            *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     FLOAT            *PARAMS,
                     FLOAT            *WORK,
                     INTEGER          *IWORK,
                     INTEGER          *INFO);

//-- sgbtf2 --------------------------------------------------------------------
void
LAPACK_IMPL(sgbtf2)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    FLOAT            *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- sgbtrf --------------------------------------------------------------------
void
LAPACK_IMPL(sgbtrf)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    FLOAT            *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- sgbtrs --------------------------------------------------------------------
void
LAPACK_IMPL(sgbtrs)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const INTEGER    *NRHS,
                    const FLOAT      *AB,
                    const INTEGER    *LDAB,
                    const INTEGER    *IPIV,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- sgebak --------------------------------------------------------------------
void
LAPACK_IMPL(sgebak)(const char       *JOB,
                    const char       *SIDE,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    const FLOAT      *SCALE,
                    const INTEGER    *M,
                    FLOAT            *V,
                    const INTEGER    *LDV,
                    INTEGER          *INFO);

//-- sgebal --------------------------------------------------------------------
void
LAPACK_IMPL(sgebal)(const char       *JOB,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    FLOAT            *SCALE,
                    INTEGER          *INFO);

//-- sgebd2 --------------------------------------------------------------------
void
LAPACK_IMPL(sgebd2)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT            *TAUQ,
                    FLOAT            *TAUP,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- sgebrd --------------------------------------------------------------------
void
LAPACK_IMPL(sgebrd)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT            *TAUQ,
                    FLOAT            *TAUP,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sgecon --------------------------------------------------------------------
void
LAPACK_IMPL(sgecon)(const char       *NORM,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const FLOAT      *ANORM,
                    FLOAT            *RCOND,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- sgeequ --------------------------------------------------------------------
void
LAPACK_IMPL(sgeequ)(const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    FLOAT            *R,
                    FLOAT            *C,
                    FLOAT            *ROWCND,
                    FLOAT            *COLCND,
                    FLOAT            *AMAX,
                    INTEGER          *INFO);

//-- sgeequb -------------------------------------------------------------------
void
LAPACK_IMPL(sgeequb)(const INTEGER    *M,
                     const INTEGER    *N,
                     const FLOAT      *A,
                     const INTEGER    *LDA,
                     FLOAT            *R,
                     FLOAT            *C,
                     FLOAT            *ROWCND,
                     FLOAT            *COLCND,
                     FLOAT            *AMAX,
                     INTEGER          *INFO);

//-- sgees ---------------------------------------------------------------------
void
LAPACK_IMPL(sgees)(const char        *JOBVS,
                   const char        *SORT,
                   LOGICAL           (*SELECT)(const FLOAT *, const FLOAT *),
                   const INTEGER     *N,
                   FLOAT             *A,
                   const INTEGER     *LDA,
                   INTEGER           *SDIM,
                   FLOAT             *WR,
                   FLOAT             *WI,
                   FLOAT             *VS,
                   const INTEGER     *LDVS,
                   FLOAT             *WORK,
                   const INTEGER     *LWORK,
                   LOGICAL           *BWORK,
                   INTEGER           *INFO);

//-- sgeesx --------------------------------------------------------------------
void
LAPACK_IMPL(sgeesx)(const char       *JOBVS,
                    const char       *SORT,
                   LOGICAL           (*SELECT)(const FLOAT *, const FLOAT *),
                    const char       *SENSE,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *SDIM,
                    FLOAT            *WR,
                    FLOAT            *WI,
                    FLOAT            *VS,
                    const INTEGER    *LDVS,
                    FLOAT            *RCONDE,
                    FLOAT            *RCONDV,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    LOGICAL          *BWORK,
                    INTEGER          *INFO);

//-- sgeev ---------------------------------------------------------------------
void
LAPACK_IMPL(sgeev)(const char           *JOBVL,
                   const char           *JOBVR,
                   const INTEGER        *N,
                   FLOAT                *A,
                   const INTEGER        *LDA,
                   FLOAT                *WR,
                   FLOAT                *WI,
                   FLOAT                *VL,
                   const INTEGER        *LDVL,
                   FLOAT                *VR,
                   const INTEGER        *LDVR,
                   FLOAT                *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO);

//-- sgeevx --------------------------------------------------------------------
void
LAPACK_IMPL(sgeevx)(const char       *BALANC,
                    const char       *JOBVL,
                    const char       *JOBVR,
                    const char       *SENSE,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *WR,
                    FLOAT            *WI,
                    FLOAT            *VL,
                    const INTEGER    *LDVL,
                    FLOAT            *VR,
                    const INTEGER    *LDVR,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    FLOAT            *SCALE,
                    FLOAT            *ABNRM,
                    FLOAT            *RCONDE,
                    FLOAT            *RCONDV,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- sgegs ---------------------------------------------------------------------
void
LAPACK_IMPL(sgegs)(const char           *JOBVSL,
                   const char           *JOBVSR,
                   const INTEGER        *N,
                   FLOAT                *A,
                   const INTEGER        *LDA,
                   FLOAT                *B,
                   const INTEGER        *LDB,
                   FLOAT                *ALPHAR,
                   FLOAT                *ALPHAI,
                   FLOAT                *BETA,
                   FLOAT                *VSL,
                   const INTEGER        *LDVSL,
                   FLOAT                *VSR,
                   const INTEGER        *LDVSR,
                   FLOAT                *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO);

//-- sgegv ---------------------------------------------------------------------
void
LAPACK_IMPL(sgegv)(const char           *JOBVL,
                   const char           *JOBVR,
                   const INTEGER        *N,
                   FLOAT                *A,
                   const INTEGER        *LDA,
                   FLOAT                *B,
                   const INTEGER        *LDB,
                   FLOAT                *ALPHAR,
                   FLOAT                *ALPHAI,
                   FLOAT                *BETA,
                   FLOAT                *VL,
                   const INTEGER        *LDVL,
                   FLOAT                *VR,
                   const INTEGER        *LDVR,
                   FLOAT                *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO);

//-- sgehd2 --------------------------------------------------------------------
void
LAPACK_IMPL(sgehd2)(const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- sgehrd --------------------------------------------------------------------
void
LAPACK_IMPL(sgehrd)(const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sgejsv --------------------------------------------------------------------
void
LAPACK_IMPL(sgejsv)(const char       *JOBA,
                    const char       *JOBU,
                    const char       *JOBV,
                    const char       *JOBR,
                    const char       *JOBT,
                    const char       *JOBP,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const FLOAT      *SVA,
                    const FLOAT      *U,
                    const INTEGER    *LDU,
                    const FLOAT      *V,
                    const INTEGER    *LDV,
                    const FLOAT      *WORK,
                    const INTEGER    *LWORK,
                    const INTEGER    *IWORK,
                    const INTEGER    *INFO);

//-- sgelq2 --------------------------------------------------------------------
void
LAPACK_IMPL(sgelq2)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- sgelqf --------------------------------------------------------------------
void
LAPACK_IMPL(sgelqf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sgels ---------------------------------------------------------------------
void
LAPACK_IMPL(sgels)(const char           *TRANS,
                   const INTEGER        *M,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT                *A,
                   const INTEGER        *LDA,
                   FLOAT                *B,
                   const INTEGER        *LDB,
                   FLOAT                *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO);

//-- sgelsd --------------------------------------------------------------------
void
LAPACK_IMPL(sgelsd)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *S,
                    const FLOAT      *RCOND,
                    INTEGER          *RANK,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- sgelss --------------------------------------------------------------------
void
LAPACK_IMPL(sgelss)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *S,
                    const FLOAT      *RCOND,
                    INTEGER          *RANK,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sgelsx --------------------------------------------------------------------
void
LAPACK_IMPL(sgelsx)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    INTEGER          *JPVT,
                    const FLOAT      *RCOND,
                    INTEGER          *RANK,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- sgelsy --------------------------------------------------------------------
void
LAPACK_IMPL(sgelsy)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    INTEGER          *JPVT,
                    const FLOAT      *RCOND,
                    INTEGER          *RANK,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sgeql2 --------------------------------------------------------------------
void
LAPACK_IMPL(sgeql2)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- sgeqlf --------------------------------------------------------------------
void
LAPACK_IMPL(sgeqlf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sgeqp3 --------------------------------------------------------------------
void
LAPACK_IMPL(sgeqp3)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sgeqpf --------------------------------------------------------------------
void
LAPACK_IMPL(sgeqpf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- sgeqr2 --------------------------------------------------------------------
void
LAPACK_IMPL(sgeqr2)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- sgeqr2p -------------------------------------------------------------------
void
LAPACK_IMPL(sgeqr2p)(const INTEGER    *M,
                     const INTEGER    *N,
                     FLOAT            *A,
                     const INTEGER    *LDA,
                     FLOAT            *TAU,
                     FLOAT            *WORK,
                     INTEGER          *INFO);

//-- sgeqrf --------------------------------------------------------------------
void
LAPACK_IMPL(sgeqrf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sgeqrfp -------------------------------------------------------------------
void
LAPACK_IMPL(sgeqrfp)(const INTEGER    *M,
                     const INTEGER    *N,
                     FLOAT            *A,
                     const INTEGER    *LDA,
                     FLOAT            *TAU,
                     FLOAT            *WORK,
                     const INTEGER    *LWORK,
                     INTEGER          *INFO);

//-- sgerfs --------------------------------------------------------------------
void
LAPACK_IMPL(sgerfs)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const FLOAT      *AF,
                    const INTEGER    *LDAF,
                    const INTEGER    *IPIV,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- sgerfsx -------------------------------------------------------------------
void
LAPACK_IMPL(sgerfsx)(const char       *TRANS,
                     const char       *EQUED,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     const FLOAT      *A,
                     const INTEGER    *LDA,
                     const FLOAT      *AF,
                     const INTEGER    *LDAF,
                     const INTEGER    *IPIV,
                     const FLOAT      *R,
                     const FLOAT      *C,
                     const FLOAT      *B,
                     const INTEGER    *LDB,
                     FLOAT            *X,
                     const INTEGER    *LDX,
                     FLOAT            *RCOND,
                     FLOAT            *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     FLOAT            *ERR_BNDS_NORM,
                     FLOAT            *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     FLOAT            *PARAMS,
                     FLOAT            *WORK,
                     INTEGER          *IWORK,
                     INTEGER          *INFO);

//-- sgerq2 --------------------------------------------------------------------
void
LAPACK_IMPL(sgerq2)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- sgerqf --------------------------------------------------------------------
void
LAPACK_IMPL(sgerqf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sgesc2 --------------------------------------------------------------------
void
LAPACK_IMPL(sgesc2)(const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    FLOAT            *RHS,
                    const INTEGER    *IPIV,
                    const INTEGER    *JPIV,
                    FLOAT            *SCALE);

//-- sgesdd --------------------------------------------------------------------
void
LAPACK_IMPL(sgesdd)(const char       *JOBZ,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *S,
                    FLOAT            *U,
                    const INTEGER    *LDU,
                    FLOAT            *VT,
                    const INTEGER    *LDVT,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- sgesv ---------------------------------------------------------------------
void
LAPACK_IMPL(sgesv)(const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT                *A,
                   const INTEGER        *LDA,
                   INTEGER              *IPIV,
                   FLOAT                *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- sgesvd --------------------------------------------------------------------
void
LAPACK_IMPL(sgesvd)(const char       *JOBU,
                    const char       *JOBVT,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *S,
                    FLOAT            *U,
                    const INTEGER    *LDU,
                    FLOAT            *VT,
                    const INTEGER    *LDVT,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sgesvj --------------------------------------------------------------------
void
LAPACK_IMPL(sgesvj)(const char       *JOBA,
                    const char       *JOBU,
                    const char       *JOBV,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *SVA,
                    const INTEGER    *MV,
                    FLOAT            *V,
                    const INTEGER    *LDV,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sgesvx --------------------------------------------------------------------
void
LAPACK_IMPL(sgesvx)(const char       *FACT,
                    const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *AF,
                    const INTEGER    *LDAF,
                    INTEGER          *IPIV,
                    char             *EQUED,
                    FLOAT            *R,
                    FLOAT            *C,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *RCOND,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- sgesvxx -------------------------------------------------------------------
void
LAPACK_IMPL(sgesvxx)(const char       *FACT,
                     const char       *TRANS,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     FLOAT            *A,
                     const INTEGER    *LDA,
                     FLOAT            *AF,
                     const INTEGER    *LDAF,
                     INTEGER          *IPIV,
                     char             *EQUED,
                     FLOAT            *R,
                     FLOAT            *C,
                     FLOAT            *B,
                     const INTEGER    *LDB,
                     FLOAT            *X,
                     const INTEGER    *LDX,
                     FLOAT            *RCOND,
                     FLOAT            *RPVGRW,
                     FLOAT            *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     FLOAT            *ERR_BNDS_NORM,
                     FLOAT            *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     FLOAT            *PARAMS,
                     FLOAT            *WORK,
                     INTEGER          *IWORK,
                     INTEGER          *INFO);

//-- sgetc2 --------------------------------------------------------------------
void
LAPACK_IMPL(sgetc2)(const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *JPIV,
                    INTEGER          *INFO);

//-- sgetf2 --------------------------------------------------------------------
void
LAPACK_IMPL(sgetf2)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- sgetrf --------------------------------------------------------------------
void
LAPACK_IMPL(sgetrf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- sgetri --------------------------------------------------------------------
void
LAPACK_IMPL(sgetri)(const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    const INTEGER    *IPIV,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sgetrs --------------------------------------------------------------------
void
LAPACK_IMPL(sgetrs)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const INTEGER    *IPIV,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- sggbak --------------------------------------------------------------------
void
LAPACK_IMPL(sggbak)(const char       *JOB,
                    const char       *SIDE,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    const FLOAT      *LSCALE,
                    const FLOAT      *RSCALE,
                    const INTEGER    *M,
                    FLOAT            *V,
                    const INTEGER    *LDV,
                    INTEGER          *INFO);

//-- sggbal --------------------------------------------------------------------
void
LAPACK_IMPL(sggbal)(const char       *JOB,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    FLOAT            *LSCALE,
                    FLOAT            *RSCALE,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- sgges ---------------------------------------------------------------------
void
LAPACK_IMPL(sgges)(const char           *JOBVSL,
                   const char           *JOBVSR,
                   const char           *SORT,
                   const LOGICAL        *SELCTG,
                   const INTEGER        *N,
                   FLOAT                *A,
                   const INTEGER        *LDA,
                   FLOAT                *B,
                   const INTEGER        *LDB,
                   INTEGER              *SDIM,
                   FLOAT                *ALPHAR,
                   FLOAT                *ALPHAI,
                   FLOAT                *BETA,
                   FLOAT                *VSL,
                   const INTEGER        *LDVSL,
                   FLOAT                *VSR,
                   const INTEGER        *LDVSR,
                   FLOAT                *WORK,
                   const INTEGER        *LWORK,
                   LOGICAL              *BWORK,
                   INTEGER              *INFO);

//-- sggesx --------------------------------------------------------------------
void
LAPACK_IMPL(sggesx)(const char       *JOBVSL,
                    const char       *JOBVSR,
                    const char       *SORT,
                    const LOGICAL    *SELCTG,
                    const char       *SENSE,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    INTEGER          *SDIM,
                    FLOAT            *ALPHAR,
                    FLOAT            *ALPHAI,
                    FLOAT            *BETA,
                    FLOAT            *VSL,
                    const INTEGER    *LDVSL,
                    FLOAT            *VSR,
                    const INTEGER    *LDVSR,
                    FLOAT            *RCONDE,
                    FLOAT            *RCONDV,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    LOGICAL          *BWORK,
                    INTEGER          *INFO);

//-- sggev ---------------------------------------------------------------------
void
LAPACK_IMPL(sggev)(const char           *JOBVL,
                   const char           *JOBVR,
                   const INTEGER        *N,
                   FLOAT                *A,
                   const INTEGER        *LDA,
                   FLOAT                *B,
                   const INTEGER        *LDB,
                   FLOAT                *ALPHAR,
                   FLOAT                *ALPHAI,
                   FLOAT                *BETA,
                   FLOAT                *VL,
                   const INTEGER        *LDVL,
                   FLOAT                *VR,
                   const INTEGER        *LDVR,
                   FLOAT                *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO);

//-- sggevx --------------------------------------------------------------------
void
LAPACK_IMPL(sggevx)(const char       *BALANC,
                    const char       *JOBVL,
                    const char       *JOBVR,
                    const char       *SENSE,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *ALPHAR,
                    FLOAT            *ALPHAI,
                    FLOAT            *BETA,
                    FLOAT            *VL,
                    const INTEGER    *LDVL,
                    FLOAT            *VR,
                    const INTEGER    *LDVR,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    FLOAT            *LSCALE,
                    FLOAT            *RSCALE,
                    FLOAT            *ABNRM,
                    FLOAT            *BBNRM,
                    FLOAT            *RCONDE,
                    FLOAT            *RCONDV,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    LOGICAL          *BWORK,
                    INTEGER          *INFO);

//-- sggglm --------------------------------------------------------------------
void
LAPACK_IMPL(sggglm)(const INTEGER    *N,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *D,
                    FLOAT            *X,
                    FLOAT            *Y,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sgghrd --------------------------------------------------------------------
void
LAPACK_IMPL(sgghrd)(const char       *COMPQ,
                    const char       *COMPZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *INFO);

//-- sgglse --------------------------------------------------------------------
void
LAPACK_IMPL(sgglse)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *P,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *C,
                    FLOAT            *D,
                    FLOAT            *X,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sggqrf --------------------------------------------------------------------
void
LAPACK_IMPL(sggqrf)(const INTEGER    *N,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAUA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *TAUB,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sggrqf --------------------------------------------------------------------
void
LAPACK_IMPL(sggrqf)(const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAUA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *TAUB,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sggsvd --------------------------------------------------------------------
void
LAPACK_IMPL(sggsvd)(const char       *JOBU,
                    const char       *JOBV,
                    const char       *JOBQ,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *P,
                    INTEGER          *K,
                    INTEGER          *L,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *ALPHA,
                    FLOAT            *BETA,
                    FLOAT            *U,
                    const INTEGER    *LDU,
                    FLOAT            *V,
                    const INTEGER    *LDV,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- sggsvp --------------------------------------------------------------------
void
LAPACK_IMPL(sggsvp)(const char       *JOBU,
                    const char       *JOBV,
                    const char       *JOBQ,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    const FLOAT      *TOLA,
                    const FLOAT      *TOLB,
                    INTEGER          *K,
                    INTEGER          *L,
                    FLOAT            *U,
                    const INTEGER    *LDU,
                    FLOAT            *V,
                    const INTEGER    *LDV,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    INTEGER          *IWORK,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- sgsvj0 --------------------------------------------------------------------
void
LAPACK_IMPL(sgsvj0)(const char       *JOBV,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *D,
                    FLOAT            *SVA,
                    const INTEGER    *MV,
                    FLOAT            *V,
                    const INTEGER    *LDV,
                    const FLOAT      *EPS,
                    const FLOAT      *SFMIN,
                    const FLOAT      *TOL,
                    const INTEGER    *NSWEEP,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sgsvj1 --------------------------------------------------------------------
void
LAPACK_IMPL(sgsvj1)(const char       *JOBV,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *N1,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *D,
                    FLOAT            *SVA,
                    const INTEGER    *MV,
                    FLOAT            *V,
                    const INTEGER    *LDV,
                    const FLOAT      *EPS,
                    const FLOAT      *SFMIN,
                    const FLOAT      *TOL,
                    const INTEGER    *NSWEEP,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sgtcon --------------------------------------------------------------------
void
LAPACK_IMPL(sgtcon)(const char       *NORM,
                    const INTEGER    *N,
                    const FLOAT      *DL,
                    const FLOAT      *D,
                    const FLOAT      *DU,
                    const FLOAT      *DU2,
                    const INTEGER    *IPIV,
                    const FLOAT      *ANORM,
                    FLOAT            *RCOND,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- sgtrfs --------------------------------------------------------------------
void
LAPACK_IMPL(sgtrfs)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *DL,
                    const FLOAT      *D,
                    const FLOAT      *DU,
                    const FLOAT      *DLF,
                    const FLOAT      *DF,
                    const FLOAT      *DUF,
                    const FLOAT      *DU2,
                    const INTEGER    *IPIV,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- sgtsv ---------------------------------------------------------------------
void
LAPACK_IMPL(sgtsv)(const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT                *DL,
                   FLOAT                *D,
                   FLOAT                *DU,
                   FLOAT                *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- sgtsvx --------------------------------------------------------------------
void
LAPACK_IMPL(sgtsvx)(const char       *FACT,
                    const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *DL,
                    const FLOAT      *D,
                    const FLOAT      *DU,
                    FLOAT            *DLF,
                    FLOAT            *DF,
                    FLOAT            *DUF,
                    FLOAT            *DU2,
                    INTEGER          *IPIV,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *RCOND,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- sgttrf --------------------------------------------------------------------
void
LAPACK_IMPL(sgttrf)(const INTEGER    *N,
                    FLOAT            *DL,
                    FLOAT            *D,
                    FLOAT            *DU,
                    FLOAT            *DU2,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- sgttrs --------------------------------------------------------------------
void
LAPACK_IMPL(sgttrs)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *DL,
                    const FLOAT      *D,
                    const FLOAT      *DU,
                    const FLOAT      *DU2,
                    const INTEGER    *IPIV,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- sgtts2 --------------------------------------------------------------------
void
LAPACK_IMPL(sgtts2)(const INTEGER    *ITRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *DL,
                    const FLOAT      *D,
                    const FLOAT      *DU,
                    const FLOAT      *DU2,
                    const INTEGER    *IPIV,
                    FLOAT            *B,
                    const INTEGER    *LDB);

//-- shgeqz --------------------------------------------------------------------
void
LAPACK_IMPL(shgeqz)(const char       *JOB,
                    const char       *COMPQ,
                    const char       *COMPZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT            *H,
                    const INTEGER    *LDH,
                    FLOAT            *T,
                    const INTEGER    *LDT,
                    FLOAT            *ALPHAR,
                    FLOAT            *ALPHAI,
                    FLOAT            *BETA,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- shsein --------------------------------------------------------------------
void
LAPACK_IMPL(shsein)(const char       *SIDE,
                    const char       *EIGSRC,
                    const char       *INITV,
                    LOGICAL          *SELECT,
                    const INTEGER    *N,
                    const FLOAT      *H,
                    const INTEGER    *LDH,
                    FLOAT            *WR,
                    const FLOAT      *WI,
                    FLOAT            *VL,
                    const INTEGER    *LDVL,
                    FLOAT            *VR,
                    const INTEGER    *LDVR,
                    const INTEGER    *MM,
                    INTEGER          *M,
                    FLOAT            *WORK,
                    INTEGER          *IFAILL,
                    INTEGER          *IFAILR,
                    INTEGER          *INFO);

//-- shseqr --------------------------------------------------------------------
void
LAPACK_IMPL(shseqr)(const char       *JOB,
                    const char       *COMPZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT            *H,
                    const INTEGER    *LDH,
                    FLOAT            *WR,
                    FLOAT            *WI,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sisnan --------------------------------------------------------------------
LOGICAL
LAPACK_IMPL(sisnan)(const FLOAT  *SIN);

//-- sla_gbamv -----------------------------------------------------------------
void
LAPACK_IMPL(sla_gbamv)(const INTEGER        *TRANS,
                       const INTEGER        *M,
                       const INTEGER        *N,
                       const INTEGER        *KL,
                       const INTEGER        *KU,
                       const FLOAT          *ALPHA,
                       const FLOAT          *AB,
                       const INTEGER        *LDAB,
                       const FLOAT          *X,
                       const INTEGER        *INCX,
                       const FLOAT          *BETA,
                       FLOAT                *Y,
                       const INTEGER        *INCY);

//-- sla_gbrcond ---------------------------------------------------------------
FLOAT
LAPACK_IMPL(sla_gbrcond)(const char       *TRANS,
                         const INTEGER    *N,
                         const INTEGER    *KL,
                         const INTEGER    *KU,
                         const FLOAT      *AB,
                         const INTEGER    *LDAB,
                         const FLOAT      *AFB,
                         const INTEGER    *LDAFB,
                         const INTEGER    *IPIV,
                         const INTEGER    *CMODE,
                         const FLOAT      *C,
                         INTEGER          *INFO,
                         const FLOAT      *WORK,
                         const INTEGER    *IWORK);

//-- sla_gbrfsx_extended -------------------------------------------------------
void
LAPACK_IMPL(sla_gbrfsx_extended)(const INTEGER    *PREC_TYPE,
                                 const INTEGER    *TRANS_TYPE,
                                 const INTEGER    *N,
                                 const INTEGER    *KL,
                                 const INTEGER    *KU,
                                 const INTEGER    *NRHS,
                                 const FLOAT      *AB,
                                 const INTEGER    *LDAB,
                                 const FLOAT      *AFB,
                                 const INTEGER    *LDAFB,
                                 const INTEGER    *IPIV,
                                 const LOGICAL    *COLEQU,
                                 const FLOAT      *C,
                                 const FLOAT      *B,
                                 const INTEGER    *LDB,
                                 FLOAT            *Y,
                                 const INTEGER    *LDY,
                                 FLOAT            *BERR_OUT,
                                 const INTEGER    *N_NORMS,
                                 FLOAT            *ERR_BNDS_NORM,
                                 FLOAT            *ERR_BNDS_COMP,
                                 const FLOAT      *RES,
                                 const FLOAT      *AYB,
                                 const FLOAT      *DY,
                                 const FLOAT      *Y_TAIL,
                                 const FLOAT      *RCOND,
                                 const INTEGER    *ITHRESH,
                                 const FLOAT      *RTHRESH,
                                 const FLOAT      *DZ_UB,
                                 const LOGICAL    *IGNORE_CWISE,
                                 INTEGER          *INFO);

//-- sla_gbrpvgrw --------------------------------------------------------------
FLOAT
LAPACK_IMPL(sla_gbrpvgrw)(const INTEGER    *N,
                          const INTEGER    *KL,
                          const INTEGER    *KU,
                          const INTEGER    *NCOLS,
                          const FLOAT      *AB,
                          const INTEGER    *LDAB,
                          const FLOAT      *AFB,
                          const INTEGER    *LDAFB);

//-- sla_geamv -----------------------------------------------------------------
void
LAPACK_IMPL(sla_geamv)(const INTEGER        *TRANS,
                       const INTEGER        *M,
                       const INTEGER        *N,
                       const FLOAT          *ALPHA,
                       const FLOAT          *A,
                       const INTEGER        *LDA,
                       const FLOAT          *X,
                       const INTEGER        *INCX,
                       const FLOAT          *BETA,
                       FLOAT                *Y,
                       const INTEGER        *INCY);

//-- sla_gercond ---------------------------------------------------------------
FLOAT
LAPACK_IMPL(sla_gercond)(const char       *TRANS,
                         const INTEGER    *N,
                         const FLOAT      *A,
                         const INTEGER    *LDA,
                         const FLOAT      *AF,
                         const INTEGER    *LDAF,
                         const INTEGER    *IPIV,
                         const INTEGER    *CMODE,
                         const FLOAT      *C,
                         INTEGER          *INFO,
                         const FLOAT      *WORK,
                         const INTEGER    *IWORK);

//-- sla_gerfsx_extended -------------------------------------------------------
void
LAPACK_IMPL(sla_gerfsx_extended)(const INTEGER    *PREC_TYPE,
                                 const INTEGER    *TRANS_TYPE,
                                 const INTEGER    *N,
                                 const INTEGER    *NRHS,
                                 const FLOAT      *A,
                                 const INTEGER    *LDA,
                                 const FLOAT      *AF,
                                 const INTEGER    *LDAF,
                                 const INTEGER    *IPIV,
                                 const LOGICAL    *COLEQU,
                                 const FLOAT      *C,
                                 const FLOAT      *B,
                                 const INTEGER    *LDB,
                                 FLOAT            *Y,
                                 const INTEGER    *LDY,
                                 FLOAT            *BERR_OUT,
                                 const INTEGER    *N_NORMS,
                                 FLOAT            *ERR_BNDS_NORM,
                                 FLOAT            *ERR_BNDS_COMP,
                                 const FLOAT      *RES,
                                 const FLOAT      *AYB,
                                 const FLOAT      *DY,
                                 const FLOAT      *Y_TAIL,
                                 const FLOAT      *RCOND,
                                 const INTEGER    *ITHRESH,
                                 const FLOAT      *RTHRESH,
                                 const FLOAT      *DZ_UB,
                                 const LOGICAL    *IGNORE_CWISE,
                                 INTEGER          *INFO);

//-- sla_lin_berr --------------------------------------------------------------
void
LAPACK_IMPL(sla_lin_berr)(const INTEGER    *N,
                          const INTEGER    *NZ,
                          const INTEGER    *NRHS,
                          const FLOAT      *RES,
                          const FLOAT      *AYB,
                          FLOAT            *BERR);

//-- sla_porcond ---------------------------------------------------------------
FLOAT
LAPACK_IMPL(sla_porcond)(const char       *UPLO,
                         const INTEGER    *N,
                         const FLOAT      *A,
                         const INTEGER    *LDA,
                         const FLOAT      *AF,
                         const INTEGER    *LDAF,
                         const INTEGER    *CMODE,
                         const FLOAT      *C,
                         INTEGER          *INFO,
                         const FLOAT      *WORK,
                         const INTEGER    *IWORK);

//-- sla_porfsx_extended -------------------------------------------------------
void
LAPACK_IMPL(sla_porfsx_extended)(const INTEGER    *PREC_TYPE,
                                 const char       *UPLO,
                                 const INTEGER    *N,
                                 const INTEGER    *NRHS,
                                 const FLOAT      *A,
                                 const INTEGER    *LDA,
                                 const FLOAT      *AF,
                                 const INTEGER    *LDAF,
                                 const LOGICAL    *COLEQU,
                                 const FLOAT      *C,
                                 const FLOAT      *B,
                                 const INTEGER    *LDB,
                                 FLOAT            *Y,
                                 const INTEGER    *LDY,
                                 FLOAT            *BERR_OUT,
                                 const INTEGER    *N_NORMS,
                                 FLOAT            *ERR_BNDS_NORM,
                                 FLOAT            *ERR_BNDS_COMP,
                                 const FLOAT      *RES,
                                 const FLOAT      *AYB,
                                 const FLOAT      *DY,
                                 const FLOAT      *Y_TAIL,
                                 const FLOAT      *RCOND,
                                 const INTEGER    *ITHRESH,
                                 const FLOAT      *RTHRESH,
                                 const FLOAT      *DZ_UB,
                                 const LOGICAL    *IGNORE_CWISE,
                                 INTEGER          *INFO);

//-- sla_porpvgrw --------------------------------------------------------------
FLOAT
LAPACK_IMPL(sla_porpvgrw)(const char       *UPLO,
                          const INTEGER    *NCOLS,
                          const FLOAT      *A,
                          const INTEGER    *LDA,
                          const FLOAT      *AF,
                          const INTEGER    *LDAF,
                          const FLOAT      *WORK);

//-- sla_rpvgrw ----------------------------------------------------------------
FLOAT
LAPACK_IMPL(sla_rpvgrw)(const INTEGER    *N,
                        const INTEGER    *NCOLS,
                        const FLOAT      *A,
                        const INTEGER    *LDA,
                        const FLOAT      *AF,
                        const INTEGER    *LDAF);

//-- sla_syamv -----------------------------------------------------------------
void
LAPACK_IMPL(sla_syamv)(const INTEGER        *UPLO,
                       const INTEGER        *N,
                       const FLOAT          *ALPHA,
                       const FLOAT          *A,
                       const INTEGER        *LDA,
                       const FLOAT          *X,
                       const INTEGER        *INCX,
                       const FLOAT          *BETA,
                       FLOAT                *Y,
                       const INTEGER        *INCY);

//-- sla_syrcond ---------------------------------------------------------------
FLOAT
LAPACK_IMPL(sla_syrcond)(const char       *UPLO,
                         const INTEGER    *N,
                         const FLOAT      *A,
                         const INTEGER    *LDA,
                         const FLOAT      *AF,
                         const INTEGER    *LDAF,
                         const INTEGER    *IPIV,
                         const INTEGER    *CMODE,
                         const FLOAT      *C,
                         INTEGER          *INFO,
                         const FLOAT      *WORK,
                         const INTEGER    *IWORK);

//-- sla_syrfsx_extended -------------------------------------------------------
void
LAPACK_IMPL(sla_syrfsx_extended)(const INTEGER    *PREC_TYPE,
                                 const char       *UPLO,
                                 const INTEGER    *N,
                                 const INTEGER    *NRHS,
                                 const FLOAT      *A,
                                 const INTEGER    *LDA,
                                 const FLOAT      *AF,
                                 const INTEGER    *LDAF,
                                 const INTEGER    *IPIV,
                                 const LOGICAL    *COLEQU,
                                 const FLOAT      *C,
                                 const FLOAT      *B,
                                 const INTEGER    *LDB,
                                 FLOAT            *Y,
                                 const INTEGER    *LDY,
                                 FLOAT            *BERR_OUT,
                                 const INTEGER    *N_NORMS,
                                 FLOAT            *ERR_BNDS_NORM,
                                 FLOAT            *ERR_BNDS_COMP,
                                 const FLOAT      *RES,
                                 const FLOAT      *AYB,
                                 const FLOAT      *DY,
                                 const FLOAT      *Y_TAIL,
                                 const FLOAT      *RCOND,
                                 const INTEGER    *ITHRESH,
                                 const FLOAT      *RTHRESH,
                                 const FLOAT      *DZ_UB,
                                 const LOGICAL    *IGNORE_CWISE,
                                 INTEGER          *INFO);

//-- sla_syrpvgrw --------------------------------------------------------------
FLOAT
LAPACK_IMPL(sla_syrpvgrw)(const char       *UPLO,
                          const INTEGER    *N,
                          const INTEGER    *INFO,
                          const FLOAT      *A,
                          const INTEGER    *LDA,
                          const FLOAT      *AF,
                          const INTEGER    *LDAF,
                          const INTEGER    *IPIV,
                          const FLOAT      *WORK);

//-- sla_wwaddw ----------------------------------------------------------------
void
LAPACK_IMPL(sla_wwaddw)(const INTEGER    *N,
                        FLOAT            *X,
                        FLOAT            *Y,
                        const FLOAT      *W);

//-- slabad --------------------------------------------------------------------
void
LAPACK_IMPL(slabad)(FLOAT    *SMALL,
                    FLOAT    *LARGE);

//-- slabrd --------------------------------------------------------------------
void
LAPACK_IMPL(slabrd)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NB,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT            *TAUQ,
                    FLOAT            *TAUP,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *Y,
                    const INTEGER    *LDY);

//-- slacn2 --------------------------------------------------------------------
void
LAPACK_IMPL(slacn2)(const INTEGER    *N,
                    FLOAT            *V,
                    FLOAT            *X,
                    INTEGER          *ISGN,
                    FLOAT            *EST,
                    INTEGER          *KASE,
                    INTEGER          *ISAVE);

//-- slacon --------------------------------------------------------------------
void
LAPACK_IMPL(slacon)(const INTEGER    *N,
                    FLOAT            *V,
                    FLOAT            *X,
                    INTEGER          *ISGN,
                    FLOAT            *EST,
                    INTEGER          *KASE);

//-- slacpy --------------------------------------------------------------------
void
LAPACK_IMPL(slacpy)(const char       *UPLO,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB);

//-- sladiv --------------------------------------------------------------------
void
LAPACK_IMPL(sladiv)(const FLOAT  *A,
                    const FLOAT  *B,
                    const FLOAT  *C,
                    const FLOAT  *D,
                    FLOAT        *P,
                    FLOAT        *Q);

//-- slae2 ---------------------------------------------------------------------
void
LAPACK_IMPL(slae2)(const FLOAT      *A,
                   const FLOAT      *B,
                   const FLOAT      *C,
                   FLOAT            *RT1,
                   FLOAT            *RT2);

//-- slaebz --------------------------------------------------------------------
void
LAPACK_IMPL(slaebz)(const INTEGER    *IJOB,
                    const INTEGER    *NITMAX,
                    const INTEGER    *N,
                    const INTEGER    *MMAX,
                    const INTEGER    *MINP,
                    const INTEGER    *NBMIN,
                    const FLOAT      *ABSTOL,
                    const FLOAT      *RELTOL,
                    const FLOAT      *PIVMIN,
                    const FLOAT      *D,
                    const FLOAT      *E,
                    const FLOAT      *E2,
                    INTEGER          *NVAL,
                    FLOAT            *AB,
                    FLOAT            *C,
                    INTEGER          *MOUT,
                    INTEGER          *NAB,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- slaed0 --------------------------------------------------------------------
void
LAPACK_IMPL(slaed0)(const INTEGER    *ICOMPQ,
                    const INTEGER    *QSIZ,
                    const INTEGER    *N,
                    FLOAT            *D,
                    const FLOAT      *E,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    FLOAT            *QSTORE,
                    const INTEGER    *LDQS,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- slaed1 --------------------------------------------------------------------
void
LAPACK_IMPL(slaed1)(const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    INTEGER          *INDXQ,
                    const FLOAT      *RHO,
                    const INTEGER    *CUTPNT,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- slaed2 --------------------------------------------------------------------
void
LAPACK_IMPL(slaed2)(INTEGER          *K,
                    const INTEGER    *N,
                    const INTEGER    *N1,
                    FLOAT            *D,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    INTEGER          *INDXQ,
                    FLOAT            *RHO,
                    const FLOAT      *Z,
                    FLOAT            *DLAMDA,
                    FLOAT            *W,
                    FLOAT            *Q2,
                    INTEGER          *INDX,
                    INTEGER          *INDXC,
                    INTEGER          *INDXP,
                    INTEGER          *COLTYP,
                    INTEGER          *INFO);

//-- slaed3 --------------------------------------------------------------------
void
LAPACK_IMPL(slaed3)(const INTEGER    *K,
                    const INTEGER    *N,
                    const INTEGER    *N1,
                    FLOAT            *D,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    const FLOAT      *RHO,
                    FLOAT            *DLAMDA,
                    const FLOAT      *Q2,
                    const INTEGER    *INDX,
                    const INTEGER    *CTOT,
                    FLOAT            *W,
                    FLOAT            *S,
                    INTEGER          *INFO);

//-- slaed4 --------------------------------------------------------------------
void
LAPACK_IMPL(slaed4)(const INTEGER    *N,
                    const INTEGER    *I,
                    const FLOAT      *D,
                    const FLOAT      *Z,
                    FLOAT            *DELTA,
                    const FLOAT      *RHO,
                    FLOAT            *DLAM,
                    INTEGER          *INFO);

//-- slaed5 --------------------------------------------------------------------
void
LAPACK_IMPL(slaed5)(const INTEGER    *I,
                    const FLOAT      *D,
                    const FLOAT      *Z,
                    FLOAT            *DELTA,
                    const FLOAT      *RHO,
                    FLOAT            *DLAM);

//-- slaed6 --------------------------------------------------------------------
void
LAPACK_IMPL(slaed6)(const INTEGER    *KNITER,
                    const LOGICAL    *ORGATI,
                    const FLOAT      *RHO,
                    const FLOAT      *D,
                    const FLOAT      *Z,
                    const FLOAT      *FINIT,
                    FLOAT            *TAU,
                    INTEGER          *INFO);

//-- slaed7 --------------------------------------------------------------------
void
LAPACK_IMPL(slaed7)(const INTEGER    *ICOMPQ,
                    const INTEGER    *N,
                    const INTEGER    *QSIZ,
                    const INTEGER    *TLVLS,
                    const INTEGER    *CURLVL,
                    const INTEGER    *CURPBM,
                    FLOAT            *D,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    INTEGER          *INDXQ,
                    const FLOAT      *RHO,
                    const INTEGER    *CUTPNT,
                    FLOAT            *QSTORE,
                    INTEGER          *QPTR,
                    const INTEGER    *PRMPTR,
                    const INTEGER    *PERM,
                    const INTEGER    *GIVPTR,
                    const INTEGER    *GIVCOL,
                    const FLOAT      *GIVNUM,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- slaed8 --------------------------------------------------------------------
void
LAPACK_IMPL(slaed8)(const INTEGER    *ICOMPQ,
                    INTEGER          *K,
                    const INTEGER    *N,
                    const INTEGER    *QSIZ,
                    FLOAT            *D,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    const INTEGER    *INDXQ,
                    FLOAT            *RHO,
                    const INTEGER    *CUTPNT,
                    const FLOAT      *Z,
                    FLOAT            *DLAMDA,
                    FLOAT            *Q2,
                    const INTEGER    *LDQ2,
                    FLOAT            *W,
                    INTEGER          *PERM,
                    INTEGER          *GIVPTR,
                    INTEGER          *GIVCOL,
                    FLOAT            *GIVNUM,
                    INTEGER          *INDXP,
                    INTEGER          *INDX,
                    INTEGER          *INFO);

//-- slaed9 --------------------------------------------------------------------
void
LAPACK_IMPL(slaed9)(const INTEGER    *K,
                    const INTEGER    *KSTART,
                    const INTEGER    *KSTOP,
                    const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    const FLOAT      *RHO,
                    const FLOAT      *DLAMDA,
                    const FLOAT      *W,
                    FLOAT            *S,
                    const INTEGER    *LDS,
                    INTEGER          *INFO);

//-- slaeda --------------------------------------------------------------------
void
LAPACK_IMPL(slaeda)(const INTEGER    *N,
                    const INTEGER    *TLVLS,
                    const INTEGER    *CURLVL,
                    const INTEGER    *CURPBM,
                    const INTEGER    *PRMPTR,
                    const INTEGER    *PERM,
                    const INTEGER    *GIVPTR,
                    const INTEGER    *GIVCOL,
                    const FLOAT      *GIVNUM,
                    const FLOAT      *Q,
                    const INTEGER    *QPTR,
                    FLOAT            *Z,
                    FLOAT            *ZTEMP,
                    INTEGER          *INFO);

//-- slaein --------------------------------------------------------------------
void
LAPACK_IMPL(slaein)(const LOGICAL    *RIGHTV,
                    const LOGICAL    *NOINIT,
                    const INTEGER    *N,
                    const FLOAT      *H,
                    const INTEGER    *LDH,
                    const FLOAT      *WR,
                    const FLOAT      *WI,
                    FLOAT            *VR,
                    FLOAT            *VI,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *WORK,
                    const FLOAT      *EPS3,
                    const FLOAT      *SMLNUM,
                    const FLOAT      *BIGNUM,
                    INTEGER          *INFO);

//-- slaev2 --------------------------------------------------------------------
void
LAPACK_IMPL(slaev2)(const FLOAT  *A,
                    const FLOAT  *B,
                    const FLOAT  *C,
                    FLOAT        *RT1,
                    FLOAT        *RT2,
                    FLOAT        *CS1,
                    FLOAT        *SN1);

//-- slaexc --------------------------------------------------------------------
void
LAPACK_IMPL(slaexc)(const LOGICAL    *WANTQ,
                    const INTEGER    *N,
                    FLOAT            *T,
                    const INTEGER    *LDT,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    const INTEGER    *J1,
                    const INTEGER    *N1,
                    const INTEGER    *N2,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- slag2 ---------------------------------------------------------------------
void
LAPACK_IMPL(slag2)(const FLOAT          *A,
                   const INTEGER        *LDA,
                   const FLOAT          *B,
                   const INTEGER        *LDB,
                   const FLOAT          *SAFMIN,
                   FLOAT                *SCALE1,
                   FLOAT                *SCALE2,
                   FLOAT                *WR1,
                   FLOAT                *WR2,
                   FLOAT                *WI);

//-- slag2d --------------------------------------------------------------------
void
LAPACK_IMPL(slag2d)(const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *SA,
                    const INTEGER    *LDSA,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- slags2 --------------------------------------------------------------------
void
LAPACK_IMPL(slags2)(const LOGICAL    *UPPER,
                    const FLOAT      *A1,
                    const FLOAT      *A2,
                    const FLOAT      *A3,
                    const FLOAT      *B1,
                    const FLOAT      *B2,
                    const FLOAT      *B3,
                    FLOAT            *CSU,
                    FLOAT            *SNU,
                    FLOAT            *CSV,
                    FLOAT            *SNV,
                    FLOAT            *CSQ,
                    FLOAT            *SNQ);

//-- slagtf --------------------------------------------------------------------
void
LAPACK_IMPL(slagtf)(const INTEGER    *N,
                    FLOAT            *A,
                    const FLOAT      *LAMBDA,
                    FLOAT            *B,
                    FLOAT            *C,
                    const FLOAT      *TOL,
                    FLOAT            *D,
                    INTEGER          *IN,
                    INTEGER          *INFO);

//-- slagtm --------------------------------------------------------------------
void
LAPACK_IMPL(slagtm)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *ALPHA,
                    const FLOAT      *DL,
                    const FLOAT      *D,
                    const FLOAT      *DU,
                    const FLOAT      *X,
                    const INTEGER    *LDX,
                    const FLOAT      *BETA,
                    FLOAT            *B,
                    const INTEGER    *LDB);

//-- slagts --------------------------------------------------------------------
void
LAPACK_IMPL(slagts)(const INTEGER    *JOB,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const FLOAT      *B,
                    const FLOAT      *C,
                    const FLOAT      *D,
                    const INTEGER    *IN,
                    FLOAT            *Y,
                    FLOAT            *TOL,
                    INTEGER          *INFO);

//-- slagv2 --------------------------------------------------------------------
void
LAPACK_IMPL(slagv2)(FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *ALPHAR,
                    FLOAT            *ALPHAI,
                    FLOAT            *BETA,
                    FLOAT            *CSL,
                    FLOAT            *SNL,
                    FLOAT            *CSR,
                    FLOAT            *SNR);

//-- slahqr --------------------------------------------------------------------
void
LAPACK_IMPL(slahqr)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT            *H,
                    const INTEGER    *LDH,
                    FLOAT            *WR,
                    FLOAT            *WI,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *INFO);

//-- slahr2 --------------------------------------------------------------------
void
LAPACK_IMPL(slahr2)(const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *NB,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAU,
                    FLOAT            *T,
                    const INTEGER    *LDT,
                    FLOAT            *Y,
                    const INTEGER    *LDY);

//-- slahrd --------------------------------------------------------------------
void
LAPACK_IMPL(slahrd)(const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *NB,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAU,
                    FLOAT            *T,
                    const INTEGER    *LDT,
                    FLOAT            *Y,
                    const INTEGER    *LDY);

//-- slaic1 --------------------------------------------------------------------
void
LAPACK_IMPL(slaic1)(const INTEGER    *JOB,
                    const INTEGER    *J,
                    const FLOAT      *X,
                    const FLOAT      *SEST,
                    const FLOAT      *W,
                    const FLOAT      *GAMMA,
                    FLOAT            *SESTPR,
                    FLOAT            *S,
                    FLOAT            *C);

//-- slaisnan ------------------------------------------------------------------
LOGICAL
LAPACK_IMPL(slaisnan)(const FLOAT      *SIN1,
                      const FLOAT      *SIN2);

//-- slaln2 --------------------------------------------------------------------
void
LAPACK_IMPL(slaln2)(const LOGICAL    *LTRANS,
                    const INTEGER    *NA,
                    const INTEGER    *NW,
                    const FLOAT      *SMIN,
                    const FLOAT      *CA,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const FLOAT      *D1,
                    const FLOAT      *D2,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    const FLOAT      *WR,
                    const FLOAT      *WI,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *SCALE,
                    FLOAT            *XNORM,
                    INTEGER          *INFO);

//-- slals0 --------------------------------------------------------------------
void
LAPACK_IMPL(slals0)(const INTEGER    *ICOMPQ,
                    const INTEGER    *NL,
                    const INTEGER    *NR,
                    const INTEGER    *SQRE,
                    const INTEGER    *NRHS,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *BX,
                    const INTEGER    *LDBX,
                    const INTEGER    *PERM,
                    const INTEGER    *GIVPTR,
                    const INTEGER    *GIVCOL,
                    const INTEGER    *LDGCOL,
                    const FLOAT      *GIVNUM,
                    const INTEGER    *LDGNUM,
                    const FLOAT      *POLES,
                    const FLOAT      *DIFL,
                    const FLOAT      *DIFR,
                    const FLOAT      *Z,
                    const INTEGER    *K,
                    const FLOAT      *C,
                    const FLOAT      *S,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- slalsa --------------------------------------------------------------------
void
LAPACK_IMPL(slalsa)(const INTEGER    *ICOMPQ,
                    const INTEGER    *SMLSIZ,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *BX,
                    const INTEGER    *LDBX,
                    const FLOAT      *U,
                    const INTEGER    *LDU,
                    const FLOAT      *VT,
                    const INTEGER    *K,
                    const FLOAT      *DIFL,
                    const FLOAT      *DIFR,
                    const FLOAT      *Z,
                    const FLOAT      *POLES,
                    const INTEGER    *GIVPTR,
                    const INTEGER    *GIVCOL,
                    const INTEGER    *LDGCOL,
                    const INTEGER    *PERM,
                    const FLOAT      *GIVNUM,
                    const FLOAT      *C,
                    const FLOAT      *S,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- slalsd --------------------------------------------------------------------
void
LAPACK_IMPL(slalsd)(const char       *UPLO,
                    const INTEGER    *SMLSIZ,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    const FLOAT      *RCOND,
                    INTEGER          *RANK,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- slamrg --------------------------------------------------------------------
void
LAPACK_IMPL(slamrg)(const INTEGER    *N1,
                    const INTEGER    *N2,
                    const FLOAT      *A,
                    const INTEGER    *STRD1,
                    const INTEGER    *STRD2,
                    INTEGER          *INDEX);

//-- slaneg --------------------------------------------------------------------
INTEGER
LAPACK_IMPL(slaneg)(const INTEGER    *N,
                    const FLOAT      *D,
                    const FLOAT      *LLD,
                    const FLOAT      *SIGMA,
                    const FLOAT      *PIVMIN,
                    const INTEGER    *R);

//-- slangb --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(slangb)(const char       *NORM,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const FLOAT      *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *WORK);

//-- slange --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(slange)(const char       *NORM,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    FLOAT            *WORK);

//-- slangt --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(slangt)(const char       *NORM,
                    const INTEGER    *N,
                    const FLOAT      *DL,
                    const FLOAT      *D,
                    const FLOAT      *DU);

//-- slanhs --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(slanhs)(const char       *NORM,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    FLOAT            *WORK);

//-- slansb --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(slansb)(const char       *NORM,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const FLOAT      *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *WORK);

//-- slansf --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(slansf)(const char       *NORM,
                    const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    FLOAT            *WORK);

//-- slansp --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(slansp)(const char       *NORM,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const FLOAT      *AP,
                    FLOAT            *WORK);

//-- slanst --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(slanst)(const char       *NORM,
                    const INTEGER    *N,
                    const FLOAT      *D,
                    const FLOAT      *E);

//-- slansy --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(slansy)(const char       *NORM,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    FLOAT            *WORK);

//-- slantb --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(slantb)(const char       *NORM,
                    const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const FLOAT      *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *WORK);

//-- slantp --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(slantp)(const char       *NORM,
                    const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const FLOAT      *AP,
                    FLOAT            *WORK);

//-- slantr --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(slantr)(const char       *NORM,
                    const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    FLOAT            *WORK);

//-- slanv2 --------------------------------------------------------------------
void
LAPACK_IMPL(slanv2)(FLOAT    *A,
                    FLOAT    *B,
                    FLOAT    *C,
                    FLOAT    *D,
                    FLOAT    *RT1R,
                    FLOAT    *RT1I,
                    FLOAT    *RT2R,
                    FLOAT    *RT2I,
                    FLOAT    *CS,
                    FLOAT    *SN);

//-- slapll --------------------------------------------------------------------
void
LAPACK_IMPL(slapll)(const INTEGER    *N,
                    FLOAT            *X,
                    const INTEGER    *INCX,
                    FLOAT            *Y,
                    const INTEGER    *INCY,
                    FLOAT            *SSMIN);

//-- slapmr --------------------------------------------------------------------
void
LAPACK_IMPL(slapmr)(const LOGICAL    *FORWRD,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    INTEGER          *K);

//-- slapmt --------------------------------------------------------------------
void
LAPACK_IMPL(slapmt)(const LOGICAL    *FORWRD,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    INTEGER          *K);

//-- slapy2 --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(slapy2)(const FLOAT  *X,
                    const FLOAT  *Y);

//-- slapy3 --------------------------------------------------------------------
FLOAT
LAPACK_IMPL(slapy3)(const FLOAT  *X,
                    const FLOAT  *Y,
                    const FLOAT  *Z);

//-- slaqgb --------------------------------------------------------------------
void
LAPACK_IMPL(slaqgb)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    FLOAT            *AB,
                    const INTEGER    *LDAB,
                    const FLOAT      *R,
                    const FLOAT      *C,
                    const FLOAT      *ROWCND,
                    const FLOAT      *COLCND,
                    const FLOAT      *AMAX,
                    char             *EQUED);

//-- slaqge --------------------------------------------------------------------
void
LAPACK_IMPL(slaqge)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    const FLOAT      *R,
                    const FLOAT      *C,
                    const FLOAT      *ROWCND,
                    const FLOAT      *COLCND,
                    const FLOAT      *AMAX,
                    char             *EQUED);

//-- slaqp2 --------------------------------------------------------------------
void
LAPACK_IMPL(slaqp2)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *OFFSET,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    FLOAT            *TAU,
                    FLOAT            *VN1,
                    FLOAT            *VN2,
                    FLOAT            *WORK);

//-- slaqps --------------------------------------------------------------------
void
LAPACK_IMPL(slaqps)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *OFFSET,
                    const INTEGER    *NB,
                    INTEGER          *KB,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    FLOAT            *TAU,
                    FLOAT            *VN1,
                    FLOAT            *VN2,
                    FLOAT            *AUXV,
                    FLOAT            *F,
                    const INTEGER    *LDF);

//-- slaqr0 --------------------------------------------------------------------
void
LAPACK_IMPL(slaqr0)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT            *H,
                    const INTEGER    *LDH,
                    FLOAT            *WR,
                    FLOAT            *WI,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- slaqr1 --------------------------------------------------------------------
void
LAPACK_IMPL(slaqr1)(const INTEGER    *N,
                    const FLOAT      *H,
                    const INTEGER    *LDH,
                    const FLOAT      *SR1,
                    const FLOAT      *SI1,
                    const FLOAT      *SR2,
                    const FLOAT      *SI2,
                    FLOAT            *V);

//-- slaqr2 --------------------------------------------------------------------
void
LAPACK_IMPL(slaqr2)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *KTOP,
                    const INTEGER    *KBOT,
                    const INTEGER    *NW,
                    FLOAT            *H,
                    const INTEGER    *LDH,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *NS,
                    INTEGER          *ND,
                    FLOAT            *SR,
                    FLOAT            *SI,
                    FLOAT            *V,
                    const INTEGER    *LDV,
                    const INTEGER    *NH,
                    FLOAT            *T,
                    const INTEGER    *LDT,
                    const INTEGER    *NV,
                    FLOAT            *WV,
                    const INTEGER    *LDWV,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK);

//-- slaqr3 --------------------------------------------------------------------
void
LAPACK_IMPL(slaqr3)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *KTOP,
                    const INTEGER    *KBOT,
                    const INTEGER    *NW,
                    FLOAT            *H,
                    const INTEGER    *LDH,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *NS,
                    INTEGER          *ND,
                    FLOAT            *SR,
                    FLOAT            *SI,
                    FLOAT            *V,
                    const INTEGER    *LDV,
                    const INTEGER    *NH,
                    FLOAT            *T,
                    const INTEGER    *LDT,
                    const INTEGER    *NV,
                    FLOAT            *WV,
                    const INTEGER    *LDWV,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK);

//-- slaqr4 --------------------------------------------------------------------
void
LAPACK_IMPL(slaqr4)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT            *H,
                    const INTEGER    *LDH,
                    FLOAT            *WR,
                    FLOAT            *WI,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- slaqr5 --------------------------------------------------------------------
void
LAPACK_IMPL(slaqr5)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *KACC22,
                    const INTEGER    *N,
                    const INTEGER    *KTOP,
                    const INTEGER    *KBOT,
                    const INTEGER    *NSHFTS,
                    FLOAT            *SR,
                    FLOAT            *SI,
                    FLOAT            *H,
                    const INTEGER    *LDH,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *V,
                    const INTEGER    *LDV,
                    FLOAT            *U,
                    const INTEGER    *LDU,
                    const INTEGER    *NV,
                    FLOAT            *WV,
                    const INTEGER    *LDWV,
                    const INTEGER    *NH,
                    FLOAT            *WH,
                    const INTEGER    *LDWH);

//-- slaqsb --------------------------------------------------------------------
void
LAPACK_IMPL(slaqsb)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    FLOAT            *AB,
                    const INTEGER    *LDAB,
                    const FLOAT      *S,
                    const FLOAT      *SCOND,
                    const FLOAT      *AMAX,
                    char             *EQUED);

//-- slaqsp --------------------------------------------------------------------
void
LAPACK_IMPL(slaqsp)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *AP,
                    const FLOAT      *S,
                    const FLOAT      *SCOND,
                    const FLOAT      *AMAX,
                    char             *EQUED);

//-- slaqsy --------------------------------------------------------------------
void
LAPACK_IMPL(slaqsy)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    const FLOAT      *S,
                    const FLOAT      *SCOND,
                    const FLOAT      *AMAX,
                    char             *EQUED);

//-- slaqtr --------------------------------------------------------------------
void
LAPACK_IMPL(slaqtr)(const LOGICAL    *LTRAN,
                    const LOGICAL    *LREAL,
                    const INTEGER    *N,
                    const FLOAT      *T,
                    const INTEGER    *LDT,
                    const FLOAT      *B,
                    const FLOAT      *W,
                    FLOAT            *SCALE,
                    FLOAT            *X,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- slar1v --------------------------------------------------------------------
void
LAPACK_IMPL(slar1v)(const INTEGER    *N,
                    const INTEGER    *B1,
                    const INTEGER    *BN,
                    const FLOAT      *LAMBDA,
                    const FLOAT      *D,
                    const FLOAT      *L,
                    const FLOAT      *LD,
                    const FLOAT      *LLD,
                    const FLOAT      *PIVMIN,
                    const FLOAT      *GAPTOL,
                    FLOAT            *Z,
                    const LOGICAL    *WANTNC,
                    INTEGER          *NEGCNT,
                    FLOAT            *ZTZ,
                    FLOAT            *MINGMA,
                    INTEGER          *R,
                    INTEGER          *ISUPPZ,
                    FLOAT            *NRMINV,
                    FLOAT            *RESID,
                    FLOAT            *RQCORR,
                    FLOAT            *WORK);

//-- slar2v --------------------------------------------------------------------
void
LAPACK_IMPL(slar2v)(const INTEGER    *N,
                    FLOAT            *X,
                    FLOAT            *Y,
                    FLOAT            *Z,
                    const INTEGER    *INCX,
                    const FLOAT      *C,
                    const FLOAT      *S,
                    const INTEGER    *INCC);

//-- slarf ---------------------------------------------------------------------
void
LAPACK_IMPL(slarf)(const char           *SIDE,
                   const INTEGER        *M,
                   const INTEGER        *N,
                   const FLOAT          *V,
                   const INTEGER        *INCV,
                   const FLOAT          *TAU,
                   FLOAT                *C,
                   const INTEGER        *LDC,
                   FLOAT                *WORK);

//-- slarfb --------------------------------------------------------------------
void
LAPACK_IMPL(slarfb)(const char       *SIDE,
                    const char       *TRANS,
                    const char       *DIRECT,
                    const char       *STOREV,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const FLOAT      *V,
                    const INTEGER    *LDV,
                    const FLOAT      *T,
                    const INTEGER    *LDT,
                    FLOAT            *C,
                    const INTEGER    *LDC,
                    FLOAT            *WORK,
                    const INTEGER    *LDWORK);

//-- slarfg --------------------------------------------------------------------
void
LAPACK_IMPL(slarfg)(const INTEGER    *N,
                    FLOAT            *ALPHA,
                    FLOAT            *X,
                    const INTEGER    *INCX,
                    FLOAT            *TAU);

//-- slarfgp -------------------------------------------------------------------
void
LAPACK_IMPL(slarfgp)(const INTEGER    *N,
                     FLOAT            *ALPHA,
                     FLOAT            *X,
                     const INTEGER    *INCX,
                     FLOAT            *TAU);

//-- slarft --------------------------------------------------------------------
void
LAPACK_IMPL(slarft)(const char       *DIRECT,
                    const char       *STOREV,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    FLOAT            *V,
                    const INTEGER    *LDV,
                    const FLOAT      *TAU,
                    FLOAT            *T,
                    const INTEGER    *LDT);

//-- slarfx --------------------------------------------------------------------
void
LAPACK_IMPL(slarfx)(const char       *SIDE,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *V,
                    const FLOAT      *TAU,
                    FLOAT            *C,
                    const INTEGER    *LDC,
                    FLOAT            *WORK);

//-- slargv --------------------------------------------------------------------
void
LAPACK_IMPL(slargv)(const INTEGER    *N,
                    FLOAT            *X,
                    const INTEGER    *INCX,
                    FLOAT            *Y,
                    const INTEGER    *INCY,
                    FLOAT            *C,
                    const INTEGER    *INCC);

//-- slarnv --------------------------------------------------------------------
void
LAPACK_IMPL(slarnv)(const INTEGER    *IDIST,
                    INTEGER          *ISEED,
                    const INTEGER    *N,
                    FLOAT            *X);

//-- slarra --------------------------------------------------------------------
void
LAPACK_IMPL(slarra)(const INTEGER    *N,
                    const FLOAT      *D,
                    FLOAT            *E,
                    FLOAT            *E2,
                    const FLOAT      *SPLTOL,
                    const FLOAT      *TNRM,
                    INTEGER          *NSPLIT,
                    INTEGER          *ISPLIT,
                    INTEGER          *INFO);

//-- slarrb --------------------------------------------------------------------
void
LAPACK_IMPL(slarrb)(const INTEGER    *N,
                    const FLOAT      *D,
                    const FLOAT      *LLD,
                    const INTEGER    *IFIRST,
                    const INTEGER    *ILAST,
                    const FLOAT      *RTOL1,
                    const FLOAT      *RTOL2,
                    const INTEGER    *OFFSET,
                    FLOAT            *W,
                    FLOAT            *WGAP,
                    FLOAT            *WERR,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    const FLOAT      *PIVMIN,
                    const FLOAT      *SPDIAM,
                    const INTEGER    *TWIST,
                    INTEGER          *INFO);

//-- slarrc --------------------------------------------------------------------
void
LAPACK_IMPL(slarrc)(const char       *JOBT,
                    const INTEGER    *N,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const FLOAT      *D,
                    const FLOAT      *E,
                    const FLOAT      *PIVMIN,
                    INTEGER          *EIGCNT,
                    INTEGER          *LCNT,
                    INTEGER          *RCNT,
                    INTEGER          *INFO);

//-- slarrd --------------------------------------------------------------------
void
LAPACK_IMPL(slarrd)(const char       *RANGE,
                    const char       *ORDER,
                    const INTEGER    *N,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *GERS,
                    const FLOAT      *RELTOL,
                    const FLOAT      *D,
                    const FLOAT      *E,
                    const FLOAT      *E2,
                    const FLOAT      *PIVMIN,
                    const INTEGER    *NSPLIT,
                    const INTEGER    *ISPLIT,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT            *WERR,
                    FLOAT            *WL,
                    FLOAT            *WU,
                    INTEGER          *IBLOCK,
                    INTEGER          *INDEXW,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- slarre --------------------------------------------------------------------
void
LAPACK_IMPL(slarre)(const char       *RANGE,
                    const INTEGER    *N,
                    FLOAT            *VL,
                    FLOAT            *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT            *E2,
                    const FLOAT      *RTOL1,
                    const FLOAT      *RTOL2,
                    const FLOAT      *SPLTOL,
                    INTEGER          *NSPLIT,
                    INTEGER          *ISPLIT,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT            *WERR,
                    FLOAT            *WGAP,
                    INTEGER          *IBLOCK,
                    INTEGER          *INDEXW,
                    FLOAT            *GERS,
                    FLOAT            *PIVMIN,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- slarrf --------------------------------------------------------------------
void
LAPACK_IMPL(slarrf)(const INTEGER    *N,
                    const FLOAT      *D,
                    const FLOAT      *L,
                    const FLOAT      *LD,
                    const INTEGER    *CLSTRT,
                    const INTEGER    *CLEND,
                    const FLOAT      *W,
                    FLOAT            *WGAP,
                    const FLOAT      *WERR,
                    const FLOAT      *SPDIAM,
                    const FLOAT      *CLGAPL,
                    const FLOAT      *CLGAPR,
                    const FLOAT      *PIVMIN,
                    FLOAT            *SIGMA,
                    FLOAT            *DPLUS,
                    FLOAT            *LPLUS,
                    FLOAT            *WORK,
                    const INTEGER    *INFO);

//-- slarrj --------------------------------------------------------------------
void
LAPACK_IMPL(slarrj)(const INTEGER    *N,
                    const FLOAT      *D,
                    const FLOAT      *E2,
                    const INTEGER    *IFIRST,
                    const INTEGER    *ILAST,
                    const FLOAT      *RTOL,
                    const INTEGER    *OFFSET,
                    FLOAT            *W,
                    FLOAT            *WERR,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    const FLOAT      *PIVMIN,
                    const FLOAT      *SPDIAM,
                    INTEGER          *INFO);

//-- slarrk --------------------------------------------------------------------
void
LAPACK_IMPL(slarrk)(const INTEGER    *N,
                    const INTEGER    *IW,
                    const FLOAT      *GL,
                    const FLOAT      *GU,
                    const FLOAT      *D,
                    const FLOAT      *E2,
                    const FLOAT      *PIVMIN,
                    const FLOAT      *RELTOL,
                    FLOAT            *W,
                    FLOAT            *WERR,
                    INTEGER          *INFO);

//-- slarrr --------------------------------------------------------------------
void
LAPACK_IMPL(slarrr)(const INTEGER    *N,
                    const FLOAT      *D,
                    FLOAT            *E,
                    INTEGER          *INFO);

//-- slarrv --------------------------------------------------------------------
void
LAPACK_IMPL(slarrv)(const INTEGER    *N,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    FLOAT            *D,
                    FLOAT            *L,
                    const FLOAT      *PIVMIN,
                    const INTEGER    *ISPLIT,
                    const INTEGER    *M,
                    const INTEGER    *DOL,
                    const INTEGER    *DOU,
                    const FLOAT      *MINRGP,
                    const FLOAT      *RTOL1,
                    const FLOAT      *RTOL2,
                    FLOAT            *W,
                    FLOAT            *WERR,
                    FLOAT            *WGAP,
                    const INTEGER    *IBLOCK,
                    const INTEGER    *INDEXW,
                    const FLOAT      *GERS,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *ISUPPZ,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- slarscl2 ------------------------------------------------------------------
void
LAPACK_IMPL(slarscl2)(const INTEGER    *M,
                      const INTEGER    *N,
                      const FLOAT      *D,
                      FLOAT            *X,
                      const INTEGER    *LDX);

//-- slartg --------------------------------------------------------------------
void
LAPACK_IMPL(slartg)(const FLOAT  *F,
                    const FLOAT  *G,
                    FLOAT        *CS,
                    FLOAT        *SN,
                    FLOAT        *R);

//-- slartgp -------------------------------------------------------------------
void
LAPACK_IMPL(slartgp)(const FLOAT      *F,
                     const FLOAT      *G,
                     FLOAT            *CS,
                     FLOAT            *SN,
                     FLOAT            *R);

//-- slartgs -------------------------------------------------------------------
void
LAPACK_IMPL(slartgs)(const FLOAT      *X,
                     const FLOAT      *Y,
                     const FLOAT      *SIGMA,
                     FLOAT            *CS,
                     FLOAT            *SN);

//-- slartv --------------------------------------------------------------------
void
LAPACK_IMPL(slartv)(const INTEGER    *N,
                    FLOAT            *X,
                    const INTEGER    *INCX,
                    FLOAT            *Y,
                    const INTEGER    *INCY,
                    const FLOAT      *C,
                    const FLOAT      *S,
                    const INTEGER    *INCC);

//-- slaruv --------------------------------------------------------------------
void
LAPACK_IMPL(slaruv)(INTEGER          *ISEED,
                    const INTEGER    *N,
                    FLOAT            *X);

//-- slarz ---------------------------------------------------------------------
void
LAPACK_IMPL(slarz)(const char           *SIDE,
                   const INTEGER        *M,
                   const INTEGER        *N,
                   const INTEGER        *L,
                   const FLOAT          *V,
                   const INTEGER        *INCV,
                   const FLOAT          *TAU,
                   FLOAT                *C,
                   const INTEGER        *LDC,
                   FLOAT                *WORK);

//-- slarzb --------------------------------------------------------------------
void
LAPACK_IMPL(slarzb)(const char       *SIDE,
                    const char       *TRANS,
                    const char       *DIRECT,
                    const char       *STOREV,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *L,
                    const FLOAT      *V,
                    const INTEGER    *LDV,
                    const FLOAT      *T,
                    const INTEGER    *LDT,
                    FLOAT            *C,
                    const INTEGER    *LDC,
                    FLOAT            *WORK,
                    const INTEGER    *LDWORK);

//-- slarzt --------------------------------------------------------------------
void
LAPACK_IMPL(slarzt)(const char       *DIRECT,
                    const char       *STOREV,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    FLOAT            *V,
                    const INTEGER    *LDV,
                    const FLOAT      *TAU,
                    FLOAT            *T,
                    const INTEGER    *LDT);

//-- slas2 ---------------------------------------------------------------------
void
LAPACK_IMPL(slas2)(const FLOAT      *F,
                   const FLOAT      *G,
                   const FLOAT      *H,
                   FLOAT            *SSMIN,
                   FLOAT            *SSMAX);

//-- slascl --------------------------------------------------------------------
void
LAPACK_IMPL(slascl)(const char       *TYPE,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const FLOAT      *CFROM,
                    const FLOAT      *CTO,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- slascl2 -------------------------------------------------------------------
void
LAPACK_IMPL(slascl2)(const INTEGER    *M,
                     const INTEGER    *N,
                     const FLOAT      *D,
                     FLOAT            *X,
                     const INTEGER    *LDX);

//-- slasd0 --------------------------------------------------------------------
void
LAPACK_IMPL(slasd0)(const INTEGER    *N,
                    const INTEGER    *SQRE,
                    FLOAT            *D,
                    const FLOAT      *E,
                    FLOAT            *U,
                    const INTEGER    *LDU,
                    FLOAT            *VT,
                    const INTEGER    *LDVT,
                    const INTEGER    *SMLSIZ,
                    INTEGER          *IWORK,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- slasd1 --------------------------------------------------------------------
void
LAPACK_IMPL(slasd1)(const INTEGER    *NL,
                    const INTEGER    *NR,
                    const INTEGER    *SQRE,
                    FLOAT            *D,
                    FLOAT            *ALPHA,
                    FLOAT            *BETA,
                    FLOAT            *U,
                    const INTEGER    *LDU,
                    FLOAT            *VT,
                    const INTEGER    *LDVT,
                    INTEGER          *IDXQ,
                    INTEGER          *IWORK,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- slasd2 --------------------------------------------------------------------
void
LAPACK_IMPL(slasd2)(const INTEGER    *NL,
                    const INTEGER    *NR,
                    const INTEGER    *SQRE,
                    INTEGER          *K,
                    FLOAT            *D,
                    FLOAT            *Z,
                    const FLOAT      *ALPHA,
                    const FLOAT      *BETA,
                    FLOAT            *U,
                    const INTEGER    *LDU,
                    FLOAT            *VT,
                    const INTEGER    *LDVT,
                    FLOAT            *DSIGMA,
                    FLOAT            *U2,
                    const INTEGER    *LDU2,
                    FLOAT            *VT2,
                    const INTEGER    *LDVT2,
                    INTEGER          *IDXP,
                    INTEGER          *IDX,
                    INTEGER          *IDXC,
                    INTEGER          *IDXQ,
                    INTEGER          *COLTYP,
                    INTEGER          *INFO);

//-- slasd3 --------------------------------------------------------------------
void
LAPACK_IMPL(slasd3)(const INTEGER    *NL,
                    const INTEGER    *NR,
                    const INTEGER    *SQRE,
                    const INTEGER    *K,
                    FLOAT            *D,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    FLOAT            *DSIGMA,
                    FLOAT            *U,
                    const INTEGER    *LDU,
                    const FLOAT      *U2,
                    const INTEGER    *LDU2,
                    FLOAT            *VT,
                    const INTEGER    *LDVT,
                    FLOAT            *VT2,
                    const INTEGER    *LDVT2,
                    const INTEGER    *IDXC,
                    const INTEGER    *CTOT,
                    FLOAT            *Z,
                    INTEGER          *INFO);

//-- slasd4 --------------------------------------------------------------------
void
LAPACK_IMPL(slasd4)(const INTEGER    *N,
                    const INTEGER    *I,
                    const FLOAT      *D,
                    const FLOAT      *Z,
                    FLOAT            *DELTA,
                    const FLOAT      *RHO,
                    FLOAT            *SIGMA,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- slasd5 --------------------------------------------------------------------
void
LAPACK_IMPL(slasd5)(const INTEGER    *I,
                    const FLOAT      *D,
                    const FLOAT      *Z,
                    FLOAT            *DELTA,
                    const FLOAT      *RHO,
                    FLOAT            *DSIGMA,
                    FLOAT            *WORK);

//-- slasd6 --------------------------------------------------------------------
void
LAPACK_IMPL(slasd6)(const INTEGER    *ICOMPQ,
                    const INTEGER    *NL,
                    const INTEGER    *NR,
                    const INTEGER    *SQRE,
                    FLOAT            *D,
                    FLOAT            *VF,
                    FLOAT            *VL,
                    FLOAT            *ALPHA,
                    FLOAT            *BETA,
                    INTEGER          *IDXQ,
                    INTEGER          *PERM,
                    INTEGER          *GIVPTR,
                    INTEGER          *GIVCOL,
                    const INTEGER    *LDGCOL,
                    FLOAT            *GIVNUM,
                    const INTEGER    *LDGNUM,
                    FLOAT            *POLES,
                    FLOAT            *DIFL,
                    FLOAT            *DIFR,
                    FLOAT            *Z,
                    INTEGER          *K,
                    FLOAT            *C,
                    FLOAT            *S,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- slasd7 --------------------------------------------------------------------
void
LAPACK_IMPL(slasd7)(const INTEGER    *ICOMPQ,
                    const INTEGER    *NL,
                    const INTEGER    *NR,
                    const INTEGER    *SQRE,
                    INTEGER          *K,
                    FLOAT            *D,
                    FLOAT            *Z,
                    FLOAT            *ZW,
                    FLOAT            *VF,
                    FLOAT            *VFW,
                    FLOAT            *VL,
                    FLOAT            *VLW,
                    const FLOAT      *ALPHA,
                    const FLOAT      *BETA,
                    FLOAT            *DSIGMA,
                    INTEGER          *IDX,
                    INTEGER          *IDXP,
                    const INTEGER    *IDXQ,
                    INTEGER          *PERM,
                    INTEGER          *GIVPTR,
                    INTEGER          *GIVCOL,
                    const INTEGER    *LDGCOL,
                    FLOAT            *GIVNUM,
                    const INTEGER    *LDGNUM,
                    FLOAT            *C,
                    FLOAT            *S,
                    INTEGER          *INFO);

//-- slasd8 --------------------------------------------------------------------
void
LAPACK_IMPL(slasd8)(const INTEGER    *ICOMPQ,
                    const INTEGER    *K,
                    FLOAT            *D,
                    FLOAT            *Z,
                    FLOAT            *VF,
                    FLOAT            *VL,
                    FLOAT            *DIFL,
                    FLOAT            *DIFR,
                    const INTEGER    *LDDIFR,
                    FLOAT            *DSIGMA,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- slasda --------------------------------------------------------------------
void
LAPACK_IMPL(slasda)(const INTEGER    *ICOMPQ,
                    const INTEGER    *SMLSIZ,
                    const INTEGER    *N,
                    const INTEGER    *SQRE,
                    FLOAT            *D,
                    const FLOAT      *E,
                    FLOAT            *U,
                    const INTEGER    *LDU,
                    FLOAT            *VT,
                    INTEGER          *K,
                    FLOAT            *DIFL,
                    FLOAT            *DIFR,
                    FLOAT            *Z,
                    FLOAT            *POLES,
                    INTEGER          *GIVPTR,
                    INTEGER          *GIVCOL,
                    const INTEGER    *LDGCOL,
                    INTEGER          *PERM,
                    FLOAT            *GIVNUM,
                    FLOAT            *C,
                    FLOAT            *S,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- slasdq --------------------------------------------------------------------
void
LAPACK_IMPL(slasdq)(const char       *UPLO,
                    const INTEGER    *SQRE,
                    const INTEGER    *N,
                    const INTEGER    *NCVT,
                    const INTEGER    *NRU,
                    const INTEGER    *NCC,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT            *VT,
                    const INTEGER    *LDVT,
                    FLOAT            *U,
                    const INTEGER    *LDU,
                    FLOAT            *C,
                    const INTEGER    *LDC,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- slasdt --------------------------------------------------------------------
void
LAPACK_IMPL(slasdt)(const INTEGER    *N,
                    INTEGER          *LVL,
                    INTEGER          *ND,
                    INTEGER          *INODE,
                    INTEGER          *NDIML,
                    INTEGER          *NDIMR,
                    const INTEGER    *MSUB);

//-- slaset --------------------------------------------------------------------
void
LAPACK_IMPL(slaset)(const char       *UPLO,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *ALPHA,
                    const FLOAT      *BETA,
                    FLOAT            *A,
                    const INTEGER    *LDA);

//-- slasq1 --------------------------------------------------------------------
void
LAPACK_IMPL(slasq1)(const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- slasq2 --------------------------------------------------------------------
void
LAPACK_IMPL(slasq2)(const INTEGER    *N,
                    FLOAT            *Z,
                    INTEGER          *INFO);

//-- slasq3 --------------------------------------------------------------------
void
LAPACK_IMPL(slasq3)(const INTEGER    *I0,
                    INTEGER          *N0,
                    const FLOAT      *Z,
                    INTEGER          *PP,
                    FLOAT            *DMIN,
                    FLOAT            *SIGMA,
                    FLOAT            *DESIG,
                    const FLOAT      *QMAX,
                    INTEGER          *NFAIL,
                    INTEGER          *ITER,
                    INTEGER          *NDIV,
                    const LOGICAL    *IEEE,
                    INTEGER          *TTYPE,
                    FLOAT            *DMIN1,
                    FLOAT            *DMIN2,
                    FLOAT            *DN,
                    FLOAT            *DN1,
                    FLOAT            *DN2,
                    FLOAT            *G,
                    FLOAT            *TAU);

//-- slasq4 --------------------------------------------------------------------
void
LAPACK_IMPL(slasq4)(const INTEGER    *I0,
                    const INTEGER    *N0,
                    const FLOAT      *Z,
                    const INTEGER    *PP,
                    const INTEGER    *N0IN,
                    const FLOAT      *DMIN,
                    const FLOAT      *DMIN1,
                    const FLOAT      *DMIN2,
                    const FLOAT      *DN,
                    const FLOAT      *DN1,
                    const FLOAT      *DN2,
                    FLOAT            *TAU,
                    INTEGER          *TTYPE,
                    FLOAT            *G);

//-- slasq5 --------------------------------------------------------------------
void
LAPACK_IMPL(slasq5)(const INTEGER    *I0,
                    const INTEGER    *N0,
                    const FLOAT      *Z,
                    const INTEGER    *PP,
                    const FLOAT      *TAU,
                    FLOAT            *DMIN,
                    FLOAT            *DMIN1,
                    FLOAT            *DMIN2,
                    FLOAT            *DN,
                    FLOAT            *DNM1,
                    FLOAT            *DNM2,
                    const LOGICAL    *IEEE);

//-- slasq6 --------------------------------------------------------------------
void
LAPACK_IMPL(slasq6)(const INTEGER    *I0,
                    const INTEGER    *N0,
                    const FLOAT      *Z,
                    const INTEGER    *PP,
                    FLOAT            *DMIN,
                    FLOAT            *DMIN1,
                    FLOAT            *DMIN2,
                    FLOAT            *DN,
                    FLOAT            *DNM1,
                    FLOAT            *DNM2);

//-- slasr ---------------------------------------------------------------------
void
LAPACK_IMPL(slasr)(const char           *SIDE,
                   const char           *PIVOT,
                   const char           *DIRECT,
                   const INTEGER        *M,
                   const INTEGER        *N,
                   const FLOAT          *C,
                   const FLOAT          *S,
                   FLOAT                *A,
                   const INTEGER        *LDA);

//-- slasrt --------------------------------------------------------------------
void
LAPACK_IMPL(slasrt)(const char       *ID,
                    const INTEGER    *N,
                    FLOAT            *D,
                    INTEGER          *INFO);

//-- slassq --------------------------------------------------------------------
void
LAPACK_IMPL(slassq)(const INTEGER    *N,
                    const FLOAT      *X,
                    const INTEGER    *INCX,
                    FLOAT            *SCALE,
                    FLOAT            *SUMSQ);

//-- slasv2 --------------------------------------------------------------------
void
LAPACK_IMPL(slasv2)(const FLOAT  *F,
                    const FLOAT  *G,
                    const FLOAT  *H,
                    FLOAT        *SSMIN,
                    FLOAT        *SSMAX,
                    FLOAT        *SNR,
                    FLOAT        *CSR,
                    FLOAT        *SNL,
                    FLOAT        *CSL);

//-- slaswp --------------------------------------------------------------------
void
LAPACK_IMPL(slaswp)(const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    const INTEGER    *K1,
                    const INTEGER    *K2,
                    const INTEGER    *IPIV,
                    const INTEGER    *INCX);

//-- slasy2 --------------------------------------------------------------------
void
LAPACK_IMPL(slasy2)(const LOGICAL    *LTRANL,
                    const LOGICAL    *LTRANR,
                    const INTEGER    *ISGN,
                    const INTEGER    *N1,
                    const INTEGER    *N2,
                    const FLOAT      *TL,
                    const INTEGER    *LDTL,
                    const FLOAT      *TR,
                    const INTEGER    *LDTR,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    FLOAT            *SCALE,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *XNORM,
                    INTEGER          *INFO);

//-- slasyf --------------------------------------------------------------------
void
LAPACK_IMPL(slasyf)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NB,
                    INTEGER          *KB,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    FLOAT            *W,
                    const INTEGER    *LDW,
                    INTEGER          *INFO);

//-- slatbs --------------------------------------------------------------------
void
LAPACK_IMPL(slatbs)(const char       *UPLO,
                    const char       *TRANS,
                    const char       *DIAG,
                    const char       *NORMIN,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const FLOAT      *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *X,
                    FLOAT            *SCALE,
                    FLOAT            *CNORM,
                    INTEGER          *INFO);

//-- slatdf --------------------------------------------------------------------
void
LAPACK_IMPL(slatdf)(const INTEGER    *IJOB,
                    const INTEGER    *N,
                    const FLOAT      *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *RHS,
                    FLOAT            *RDSUM,
                    FLOAT            *RDSCAL,
                    const INTEGER    *IPIV,
                    const INTEGER    *JPIV);

//-- slatps --------------------------------------------------------------------
void
LAPACK_IMPL(slatps)(const char       *UPLO,
                    const char       *TRANS,
                    const char       *DIAG,
                    const char       *NORMIN,
                    const INTEGER    *N,
                    const FLOAT      *AP,
                    FLOAT            *X,
                    FLOAT            *SCALE,
                    FLOAT            *CNORM,
                    INTEGER          *INFO);

//-- slatrd --------------------------------------------------------------------
void
LAPACK_IMPL(slatrd)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NB,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *E,
                    FLOAT            *TAU,
                    FLOAT            *W,
                    const INTEGER    *LDW);

//-- slatrs --------------------------------------------------------------------
void
LAPACK_IMPL(slatrs)(const char       *UPLO,
                    const char       *TRANS,
                    const char       *DIAG,
                    const char       *NORMIN,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    FLOAT            *X,
                    FLOAT            *SCALE,
                    FLOAT            *CNORM,
                    INTEGER          *INFO);

//-- slatrz --------------------------------------------------------------------
void
LAPACK_IMPL(slatrz)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *L,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAU,
                    FLOAT            *WORK);

//-- slatzm --------------------------------------------------------------------
void
LAPACK_IMPL(slatzm)(const char       *SIDE,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *V,
                    const INTEGER    *INCV,
                    const FLOAT      *TAU,
                    FLOAT            *C1,
                    FLOAT            *C2,
                    const INTEGER    *LDC,
                    FLOAT            *WORK);

//-- slauu2 --------------------------------------------------------------------
void
LAPACK_IMPL(slauu2)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- slauum --------------------------------------------------------------------
void
LAPACK_IMPL(slauum)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- sopgtr --------------------------------------------------------------------
void
LAPACK_IMPL(sopgtr)(const char       *UPLO,
                    const INTEGER    *N,
                    const FLOAT      *AP,
                    const FLOAT      *TAU,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- sopmtr --------------------------------------------------------------------
void
LAPACK_IMPL(sopmtr)(const char       *SIDE,
                    const char       *UPLO,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *AP,
                    const FLOAT      *TAU,
                    FLOAT            *C,
                    const INTEGER    *LDC,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- sorbdb --------------------------------------------------------------------
void
LAPACK_IMPL(sorbdb)(const char       *TRANS,
                    const char       *SIGNS,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *Q,
                    FLOAT            *X11,
                    const INTEGER    *LDX11,
                    FLOAT            *X12,
                    const INTEGER    *LDX12,
                    FLOAT            *X21,
                    const INTEGER    *LDX21,
                    FLOAT            *X22,
                    const INTEGER    *LDX22,
                    FLOAT            *THETA,
                    FLOAT            *PHI,
                    FLOAT            *TAUP1,
                    FLOAT            *TAUP2,
                    FLOAT            *TAUQ1,
                    FLOAT            *TAUQ2,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sorcsd --------------------------------------------------------------------
void
LAPACK_IMPL(sorcsd)(const char       *JOBU1,
                    const char       *JOBU2,
                    const char       *JOBV1T,
                    const char       *JOBV2T,
                    const char       *TRANS,
                    const char       *SIGNS,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *Q,
                    const FLOAT      *X11,
                    const INTEGER    *LDX11,
                    const FLOAT      *X12,
                    const INTEGER    *LDX12,
                    const FLOAT      *X21,
                    const INTEGER    *LDX21,
                    const FLOAT      *X22,
                    const INTEGER    *LDX22,
                    FLOAT            *THETA,
                    FLOAT            *U1,
                    const INTEGER    *LDU1,
                    FLOAT            *U2,
                    const INTEGER    *LDU2,
                    FLOAT            *V1T,
                    const INTEGER    *LDV1T,
                    FLOAT            *V2T,
                    const INTEGER    *LDV2T,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- sorg2l --------------------------------------------------------------------
void
LAPACK_IMPL(sorg2l)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    const FLOAT      *TAU,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- sorg2r --------------------------------------------------------------------
void
LAPACK_IMPL(sorg2r)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    const FLOAT      *TAU,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- sorgbr --------------------------------------------------------------------
void
LAPACK_IMPL(sorgbr)(const char       *VECT,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    const FLOAT      *TAU,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sorghr --------------------------------------------------------------------
void
LAPACK_IMPL(sorghr)(const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    const FLOAT      *TAU,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sorgl2 --------------------------------------------------------------------
void
LAPACK_IMPL(sorgl2)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    const FLOAT      *TAU,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- sorglq --------------------------------------------------------------------
void
LAPACK_IMPL(sorglq)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    const FLOAT      *TAU,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sorgql --------------------------------------------------------------------
void
LAPACK_IMPL(sorgql)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    const FLOAT      *TAU,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sorgqr --------------------------------------------------------------------
void
LAPACK_IMPL(sorgqr)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    const FLOAT      *TAU,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sorgr2 --------------------------------------------------------------------
void
LAPACK_IMPL(sorgr2)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    const FLOAT      *TAU,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- sorgrq --------------------------------------------------------------------
void
LAPACK_IMPL(sorgrq)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    const FLOAT      *TAU,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sorgtr --------------------------------------------------------------------
void
LAPACK_IMPL(sorgtr)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    const FLOAT      *TAU,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sorm2l --------------------------------------------------------------------
void
LAPACK_IMPL(sorm2l)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const FLOAT      *TAU,
                    FLOAT            *C,
                    const INTEGER    *LDC,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- sorm2r --------------------------------------------------------------------
void
LAPACK_IMPL(sorm2r)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const FLOAT      *TAU,
                    FLOAT            *C,
                    const INTEGER    *LDC,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- sormbr --------------------------------------------------------------------
void
LAPACK_IMPL(sormbr)(const char       *VECT,
                    const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const FLOAT      *TAU,
                    FLOAT            *C,
                    const INTEGER    *LDC,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sormhr --------------------------------------------------------------------
void
LAPACK_IMPL(sormhr)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const FLOAT      *TAU,
                    FLOAT            *C,
                    const INTEGER    *LDC,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sorml2 --------------------------------------------------------------------
void
LAPACK_IMPL(sorml2)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const FLOAT      *TAU,
                    FLOAT            *C,
                    const INTEGER    *LDC,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- sormlq --------------------------------------------------------------------
void
LAPACK_IMPL(sormlq)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    const FLOAT      *TAU,
                    FLOAT            *C,
                    const INTEGER    *LDC,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sormql --------------------------------------------------------------------
void
LAPACK_IMPL(sormql)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const FLOAT      *TAU,
                    FLOAT            *C,
                    const INTEGER    *LDC,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sormqr --------------------------------------------------------------------
void
LAPACK_IMPL(sormqr)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    const FLOAT      *TAU,
                    FLOAT            *C,
                    const INTEGER    *LDC,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sormr2 --------------------------------------------------------------------
void
LAPACK_IMPL(sormr2)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const FLOAT      *TAU,
                    FLOAT            *C,
                    const INTEGER    *LDC,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- sormr3 --------------------------------------------------------------------
void
LAPACK_IMPL(sormr3)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *L,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const FLOAT      *TAU,
                    FLOAT            *C,
                    const INTEGER    *LDC,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- sormrq --------------------------------------------------------------------
void
LAPACK_IMPL(sormrq)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const FLOAT      *TAU,
                    FLOAT            *C,
                    const INTEGER    *LDC,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sormrz --------------------------------------------------------------------
void
LAPACK_IMPL(sormrz)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *L,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const FLOAT      *TAU,
                    FLOAT            *C,
                    const INTEGER    *LDC,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- sormtr --------------------------------------------------------------------
void
LAPACK_IMPL(sormtr)(const char       *SIDE,
                    const char       *UPLO,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const FLOAT      *TAU,
                    FLOAT            *C,
                    const INTEGER    *LDC,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- spbcon --------------------------------------------------------------------
void
LAPACK_IMPL(spbcon)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const FLOAT      *AB,
                    const INTEGER    *LDAB,
                    const FLOAT      *ANORM,
                    FLOAT            *RCOND,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- spbequ --------------------------------------------------------------------
void
LAPACK_IMPL(spbequ)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const FLOAT      *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *S,
                    FLOAT            *SCOND,
                    FLOAT            *AMAX,
                    INTEGER          *INFO);

//-- spbrfs --------------------------------------------------------------------
void
LAPACK_IMPL(spbrfs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const INTEGER    *NRHS,
                    const FLOAT      *AB,
                    const INTEGER    *LDAB,
                    const FLOAT      *AFB,
                    const INTEGER    *LDAFB,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- spbstf --------------------------------------------------------------------
void
LAPACK_IMPL(spbstf)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    FLOAT            *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *INFO);

//-- spbsv ---------------------------------------------------------------------
void
LAPACK_IMPL(spbsv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *KD,
                   const INTEGER        *NRHS,
                   FLOAT                *AB,
                   const INTEGER        *LDAB,
                   FLOAT                *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- spbsvx --------------------------------------------------------------------
void
LAPACK_IMPL(spbsvx)(const char       *FACT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const INTEGER    *NRHS,
                    FLOAT            *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *AFB,
                    const INTEGER    *LDAFB,
                    char             *EQUED,
                    FLOAT            *S,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *RCOND,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- spbtf2 --------------------------------------------------------------------
void
LAPACK_IMPL(spbtf2)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    FLOAT            *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *INFO);

//-- spbtrf --------------------------------------------------------------------
void
LAPACK_IMPL(spbtrf)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    FLOAT            *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *INFO);

//-- spbtrs --------------------------------------------------------------------
void
LAPACK_IMPL(spbtrs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const INTEGER    *NRHS,
                    const FLOAT      *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- spftrf --------------------------------------------------------------------
void
LAPACK_IMPL(spftrf)(const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *A,
                    INTEGER          *INFO);

//-- spftri --------------------------------------------------------------------
void
LAPACK_IMPL(spftri)(const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *A,
                    INTEGER          *INFO);

//-- spftrs --------------------------------------------------------------------
void
LAPACK_IMPL(spftrs)(const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *A,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- spocon --------------------------------------------------------------------
void
LAPACK_IMPL(spocon)(const char       *UPLO,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const FLOAT      *ANORM,
                    FLOAT            *RCOND,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- spoequ --------------------------------------------------------------------
void
LAPACK_IMPL(spoequ)(const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    FLOAT            *S,
                    FLOAT            *SCOND,
                    FLOAT            *AMAX,
                    INTEGER          *INFO);

//-- spoequb -------------------------------------------------------------------
void
LAPACK_IMPL(spoequb)(const INTEGER    *N,
                     const FLOAT      *A,
                     const INTEGER    *LDA,
                     FLOAT            *S,
                     FLOAT            *SCOND,
                     FLOAT            *AMAX,
                     INTEGER          *INFO);

//-- sporfs --------------------------------------------------------------------
void
LAPACK_IMPL(sporfs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const FLOAT      *AF,
                    const INTEGER    *LDAF,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- sporfsx -------------------------------------------------------------------
void
LAPACK_IMPL(sporfsx)(const char       *UPLO,
                     const char       *EQUED,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     const FLOAT      *A,
                     const INTEGER    *LDA,
                     const FLOAT      *AF,
                     const INTEGER    *LDAF,
                     FLOAT            *S,
                     const FLOAT      *B,
                     const INTEGER    *LDB,
                     FLOAT            *X,
                     const INTEGER    *LDX,
                     FLOAT            *RCOND,
                     FLOAT            *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     FLOAT            *ERR_BNDS_NORM,
                     FLOAT            *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     FLOAT            *PARAMS,
                     FLOAT            *WORK,
                     INTEGER          *IWORK,
                     INTEGER          *INFO);

//-- sposv ---------------------------------------------------------------------
void
LAPACK_IMPL(sposv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT                *A,
                   const INTEGER        *LDA,
                   FLOAT                *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- sposvx --------------------------------------------------------------------
void
LAPACK_IMPL(sposvx)(const char       *FACT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *AF,
                    const INTEGER    *LDAF,
                    char             *EQUED,
                    FLOAT            *S,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *RCOND,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- sposvxx -------------------------------------------------------------------
void
LAPACK_IMPL(sposvxx)(const char       *FACT,
                     const char       *UPLO,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     FLOAT            *A,
                     const INTEGER    *LDA,
                     FLOAT            *AF,
                     const INTEGER    *LDAF,
                     char             *EQUED,
                     FLOAT            *S,
                     FLOAT            *B,
                     const INTEGER    *LDB,
                     FLOAT            *X,
                     const INTEGER    *LDX,
                     FLOAT            *RCOND,
                     FLOAT            *RPVGRW,
                     FLOAT            *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     FLOAT            *ERR_BNDS_NORM,
                     FLOAT            *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     FLOAT            *PARAMS,
                     FLOAT            *WORK,
                     INTEGER          *IWORK,
                     INTEGER          *INFO);

//-- spotf2 --------------------------------------------------------------------
void
LAPACK_IMPL(spotf2)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- spotrf --------------------------------------------------------------------
void
LAPACK_IMPL(spotrf)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- spotri --------------------------------------------------------------------
void
LAPACK_IMPL(spotri)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- spotrs --------------------------------------------------------------------
void
LAPACK_IMPL(spotrs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- sppcon --------------------------------------------------------------------
void
LAPACK_IMPL(sppcon)(const char       *UPLO,
                    const INTEGER    *N,
                    const FLOAT      *AP,
                    const FLOAT      *ANORM,
                    FLOAT            *RCOND,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- sppequ --------------------------------------------------------------------
void
LAPACK_IMPL(sppequ)(const char       *UPLO,
                    const INTEGER    *N,
                    const FLOAT      *AP,
                    FLOAT            *S,
                    FLOAT            *SCOND,
                    FLOAT            *AMAX,
                    INTEGER          *INFO);

//-- spprfs --------------------------------------------------------------------
void
LAPACK_IMPL(spprfs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *AP,
                    const FLOAT      *AFP,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- sppsv ---------------------------------------------------------------------
void
LAPACK_IMPL(sppsv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT                *AP,
                   FLOAT                *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- sppsvx --------------------------------------------------------------------
void
LAPACK_IMPL(sppsvx)(const char       *FACT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT            *AP,
                    FLOAT            *AFP,
                    char             *EQUED,
                    FLOAT            *S,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *RCOND,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- spptrf --------------------------------------------------------------------
void
LAPACK_IMPL(spptrf)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *AP,
                    INTEGER          *INFO);

//-- spptri --------------------------------------------------------------------
void
LAPACK_IMPL(spptri)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *AP,
                    INTEGER          *INFO);

//-- spptrs --------------------------------------------------------------------
void
LAPACK_IMPL(spptrs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *AP,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- spstf2 --------------------------------------------------------------------
void
LAPACK_IMPL(spstf2)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *PIV,
                    INTEGER          *RANK,
                    const FLOAT      *TOL,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- spstrf --------------------------------------------------------------------
void
LAPACK_IMPL(spstrf)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *PIV,
                    INTEGER          *RANK,
                    const FLOAT      *TOL,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- sptcon --------------------------------------------------------------------
void
LAPACK_IMPL(sptcon)(const INTEGER    *N,
                    const FLOAT      *D,
                    const FLOAT      *E,
                    const FLOAT      *ANORM,
                    FLOAT            *RCOND,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- spteqr --------------------------------------------------------------------
void
LAPACK_IMPL(spteqr)(const char       *COMPZ,
                    const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- sptrfs --------------------------------------------------------------------
void
LAPACK_IMPL(sptrfs)(const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *D,
                    const FLOAT      *E,
                    const FLOAT      *DF,
                    const FLOAT      *EF,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- sptsv ---------------------------------------------------------------------
void
LAPACK_IMPL(sptsv)(const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT                *D,
                   FLOAT                *E,
                   FLOAT                *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- sptsvx --------------------------------------------------------------------
void
LAPACK_IMPL(sptsvx)(const char       *FACT,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *D,
                    const FLOAT      *E,
                    FLOAT            *DF,
                    FLOAT            *EF,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *RCOND,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- spttrf --------------------------------------------------------------------
void
LAPACK_IMPL(spttrf)(const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *E,
                    INTEGER          *INFO);

//-- spttrs --------------------------------------------------------------------
void
LAPACK_IMPL(spttrs)(const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *D,
                    const FLOAT      *E,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- sptts2 --------------------------------------------------------------------
void
LAPACK_IMPL(sptts2)(const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *D,
                    const FLOAT      *E,
                    FLOAT            *B,
                    const INTEGER    *LDB);

//-- srscl ---------------------------------------------------------------------
void
LAPACK_IMPL(srscl)(const INTEGER        *N,
                   const FLOAT          *SA,
                   FLOAT                *SX,
                   const INTEGER        *INCX);

//-- ssbev ---------------------------------------------------------------------
void
LAPACK_IMPL(ssbev)(const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *KD,
                   FLOAT                *AB,
                   const INTEGER        *LDAB,
                   FLOAT                *W,
                   FLOAT                *Z,
                   const INTEGER        *LDZ,
                   FLOAT                *WORK,
                   INTEGER              *INFO);

//-- ssbevd --------------------------------------------------------------------
void
LAPACK_IMPL(ssbevd)(const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    FLOAT            *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *W,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- ssbevx --------------------------------------------------------------------
void
LAPACK_IMPL(ssbevx)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    FLOAT            *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *ABSTOL,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- ssbgst --------------------------------------------------------------------
void
LAPACK_IMPL(ssbgst)(const char       *VECT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KA,
                    const INTEGER    *KB,
                    FLOAT            *AB,
                    const INTEGER    *LDAB,
                    const FLOAT      *BB,
                    const INTEGER    *LDBB,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- ssbgv ---------------------------------------------------------------------
void
LAPACK_IMPL(ssbgv)(const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *KA,
                   const INTEGER        *KB,
                   FLOAT                *AB,
                   const INTEGER        *LDAB,
                   FLOAT                *BB,
                   const INTEGER        *LDBB,
                   FLOAT                *W,
                   FLOAT                *Z,
                   const INTEGER        *LDZ,
                   FLOAT                *WORK,
                   INTEGER              *INFO);

//-- ssbgvd --------------------------------------------------------------------
void
LAPACK_IMPL(ssbgvd)(const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KA,
                    const INTEGER    *KB,
                    FLOAT            *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *BB,
                    const INTEGER    *LDBB,
                    FLOAT            *W,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- ssbgvx --------------------------------------------------------------------
void
LAPACK_IMPL(ssbgvx)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KA,
                    const INTEGER    *KB,
                    FLOAT            *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *BB,
                    const INTEGER    *LDBB,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *ABSTOL,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- ssbtrd --------------------------------------------------------------------
void
LAPACK_IMPL(ssbtrd)(const char       *VECT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    FLOAT            *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- ssfrk ---------------------------------------------------------------------
void
LAPACK_IMPL(ssfrk)(const char           *TRANSR,
                   const char           *UPLO,
                   const char           *TRANS,
                   const INTEGER        *N,
                   const INTEGER        *K,
                   const FLOAT          *ALPHA,
                   const FLOAT          *A,
                   const INTEGER        *LDA,
                   const FLOAT          *BETA,
                   FLOAT                *C);

//-- sspcon --------------------------------------------------------------------
void
LAPACK_IMPL(sspcon)(const char       *UPLO,
                    const INTEGER    *N,
                    const FLOAT      *AP,
                    const INTEGER    *IPIV,
                    const FLOAT      *ANORM,
                    FLOAT            *RCOND,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- sspev ---------------------------------------------------------------------
void
LAPACK_IMPL(sspev)(const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   FLOAT                *AP,
                   FLOAT                *W,
                   FLOAT                *Z,
                   const INTEGER        *LDZ,
                   FLOAT                *WORK,
                   INTEGER              *INFO);

//-- sspevd --------------------------------------------------------------------
void
LAPACK_IMPL(sspevd)(const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *AP,
                    FLOAT            *W,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- sspevx --------------------------------------------------------------------
void
LAPACK_IMPL(sspevx)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *AP,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *ABSTOL,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- sspgst --------------------------------------------------------------------
void
LAPACK_IMPL(sspgst)(const INTEGER    *ITYPE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *AP,
                    const FLOAT      *BP,
                    INTEGER          *INFO);

//-- sspgv ---------------------------------------------------------------------
void
LAPACK_IMPL(sspgv)(const INTEGER        *ITYPE,
                   const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   FLOAT                *AP,
                   FLOAT                *BP,
                   FLOAT                *W,
                   FLOAT                *Z,
                   const INTEGER        *LDZ,
                   FLOAT                *WORK,
                   INTEGER              *INFO);

//-- sspgvd --------------------------------------------------------------------
void
LAPACK_IMPL(sspgvd)(const INTEGER    *ITYPE,
                    const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *AP,
                    FLOAT            *BP,
                    FLOAT            *W,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- sspgvx --------------------------------------------------------------------
void
LAPACK_IMPL(sspgvx)(const INTEGER    *ITYPE,
                    const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *AP,
                    FLOAT            *BP,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *ABSTOL,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- ssprfs --------------------------------------------------------------------
void
LAPACK_IMPL(ssprfs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *AP,
                    const FLOAT      *AFP,
                    const INTEGER    *IPIV,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- sspsv ---------------------------------------------------------------------
void
LAPACK_IMPL(sspsv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT                *AP,
                   INTEGER              *IPIV,
                   FLOAT                *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- sspsvx --------------------------------------------------------------------
void
LAPACK_IMPL(sspsvx)(const char       *FACT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *AP,
                    FLOAT            *AFP,
                    INTEGER          *IPIV,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *RCOND,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- ssptrd --------------------------------------------------------------------
void
LAPACK_IMPL(ssptrd)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *AP,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT            *TAU,
                    INTEGER          *INFO);

//-- ssptrf --------------------------------------------------------------------
void
LAPACK_IMPL(ssptrf)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *AP,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- ssptri --------------------------------------------------------------------
void
LAPACK_IMPL(ssptri)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *AP,
                    const INTEGER    *IPIV,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- ssptrs --------------------------------------------------------------------
void
LAPACK_IMPL(ssptrs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *AP,
                    const INTEGER    *IPIV,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- sstebz --------------------------------------------------------------------
void
LAPACK_IMPL(sstebz)(const char       *RANGE,
                    const char       *ORDER,
                    const INTEGER    *N,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *ABSTOL,
                    const FLOAT      *D,
                    const FLOAT      *E,
                    INTEGER          *M,
                    INTEGER          *NSPLIT,
                    FLOAT            *W,
                    INTEGER          *IBLOCK,
                    INTEGER          *ISPLIT,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- sstedc --------------------------------------------------------------------
void
LAPACK_IMPL(sstedc)(const char       *COMPZ,
                    const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- sstegr --------------------------------------------------------------------
void
LAPACK_IMPL(sstegr)(const char       *JOBZ,
                    const char       *RANGE,
                    const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *E,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *ABSTOL,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *ISUPPZ,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- sstein --------------------------------------------------------------------
void
LAPACK_IMPL(sstein)(const INTEGER    *N,
                    const FLOAT      *D,
                    const FLOAT      *E,
                    const INTEGER    *M,
                    const FLOAT      *W,
                    const INTEGER    *IBLOCK,
                    const INTEGER    *ISPLIT,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- sstemr --------------------------------------------------------------------
void
LAPACK_IMPL(sstemr)(const char       *JOBZ,
                    const char       *RANGE,
                    const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *E,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    const INTEGER    *NZC,
                    INTEGER          *ISUPPZ,
                    LOGICAL          *TRYRAC,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- ssteqr --------------------------------------------------------------------
void
LAPACK_IMPL(ssteqr)(const char       *COMPZ,
                    const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- ssterf --------------------------------------------------------------------
void
LAPACK_IMPL(ssterf)(const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *E,
                    INTEGER          *INFO);

//-- sstev ---------------------------------------------------------------------
void
LAPACK_IMPL(sstev)(const char           *JOBZ,
                   const INTEGER        *N,
                   FLOAT                *D,
                   FLOAT                *E,
                   FLOAT                *Z,
                   const INTEGER        *LDZ,
                   FLOAT                *WORK,
                   INTEGER              *INFO);

//-- sstevd --------------------------------------------------------------------
void
LAPACK_IMPL(sstevd)(const char       *JOBZ,
                    const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- sstevr --------------------------------------------------------------------
void
LAPACK_IMPL(sstevr)(const char       *JOBZ,
                    const char       *RANGE,
                    const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *E,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *ABSTOL,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *ISUPPZ,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- sstevx --------------------------------------------------------------------
void
LAPACK_IMPL(sstevx)(const char       *JOBZ,
                    const char       *RANGE,
                    const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *E,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *ABSTOL,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- ssycon --------------------------------------------------------------------
void
LAPACK_IMPL(ssycon)(const char       *UPLO,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const INTEGER    *IPIV,
                    const FLOAT      *ANORM,
                    FLOAT            *RCOND,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- ssyconv -------------------------------------------------------------------
void
LAPACK_IMPL(ssyconv)(const char       *UPLO,
                     const char       *WAY,
                     const INTEGER    *N,
                     const FLOAT      *A,
                     const INTEGER    *LDA,
                     const INTEGER    *IPIV,
                     FLOAT            *WORK,
                     INTEGER          *INFO);

//-- ssyequb -------------------------------------------------------------------
void
LAPACK_IMPL(ssyequb)(const char       *UPLO,
                     const INTEGER    *N,
                     const FLOAT      *A,
                     const INTEGER    *LDA,
                     FLOAT            *S,
                     FLOAT            *SCOND,
                     FLOAT            *AMAX,
                     FLOAT            *WORK,
                     INTEGER          *INFO);

//-- ssyev ---------------------------------------------------------------------
void
LAPACK_IMPL(ssyev)(const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   FLOAT                *A,
                   const INTEGER        *LDA,
                   FLOAT                *W,
                   FLOAT                *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO);

//-- ssyevd --------------------------------------------------------------------
void
LAPACK_IMPL(ssyevd)(const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *W,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- ssyevr --------------------------------------------------------------------
void
LAPACK_IMPL(ssyevr)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *ABSTOL,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *ISUPPZ,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- ssyevx --------------------------------------------------------------------
void
LAPACK_IMPL(ssyevx)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *ABSTOL,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- ssygs2 --------------------------------------------------------------------
void
LAPACK_IMPL(ssygs2)(const INTEGER    *ITYPE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- ssygst --------------------------------------------------------------------
void
LAPACK_IMPL(ssygst)(const INTEGER    *ITYPE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- ssygv ---------------------------------------------------------------------
void
LAPACK_IMPL(ssygv)(const INTEGER        *ITYPE,
                   const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   FLOAT                *A,
                   const INTEGER        *LDA,
                   FLOAT                *B,
                   const INTEGER        *LDB,
                   FLOAT                *W,
                   FLOAT                *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO);

//-- ssygvd --------------------------------------------------------------------
void
LAPACK_IMPL(ssygvd)(const INTEGER    *ITYPE,
                    const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *W,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- ssygvx --------------------------------------------------------------------
void
LAPACK_IMPL(ssygvx)(const INTEGER    *ITYPE,
                    const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *ABSTOL,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- ssyrfs --------------------------------------------------------------------
void
LAPACK_IMPL(ssyrfs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const FLOAT      *AF,
                    const INTEGER    *LDAF,
                    const INTEGER    *IPIV,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- ssyrfsx -------------------------------------------------------------------
void
LAPACK_IMPL(ssyrfsx)(const char       *UPLO,
                     const char       *EQUED,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     const FLOAT      *A,
                     const INTEGER    *LDA,
                     const FLOAT      *AF,
                     const INTEGER    *LDAF,
                     const INTEGER    *IPIV,
                     FLOAT            *S,
                     const FLOAT      *B,
                     const INTEGER    *LDB,
                     FLOAT            *X,
                     const INTEGER    *LDX,
                     FLOAT            *RCOND,
                     FLOAT            *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     FLOAT            *ERR_BNDS_NORM,
                     FLOAT            *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     FLOAT            *PARAMS,
                     FLOAT            *WORK,
                     INTEGER          *IWORK,
                     INTEGER          *INFO);

//-- ssysv ---------------------------------------------------------------------
void
LAPACK_IMPL(ssysv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT                *A,
                   const INTEGER        *LDA,
                   INTEGER              *IPIV,
                   FLOAT                *B,
                   const INTEGER        *LDB,
                   FLOAT                *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO);

//-- ssysvx --------------------------------------------------------------------
void
LAPACK_IMPL(ssysvx)(const char       *FACT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    FLOAT            *AF,
                    const INTEGER    *LDAF,
                    INTEGER          *IPIV,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *RCOND,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- ssysvxx -------------------------------------------------------------------
void
LAPACK_IMPL(ssysvxx)(const char       *FACT,
                     const char       *UPLO,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     FLOAT            *A,
                     const INTEGER    *LDA,
                     FLOAT            *AF,
                     const INTEGER    *LDAF,
                     INTEGER          *IPIV,
                     char             *EQUED,
                     FLOAT            *S,
                     FLOAT            *B,
                     const INTEGER    *LDB,
                     FLOAT            *X,
                     const INTEGER    *LDX,
                     FLOAT            *RCOND,
                     FLOAT            *RPVGRW,
                     FLOAT            *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     FLOAT            *ERR_BNDS_NORM,
                     FLOAT            *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     FLOAT            *PARAMS,
                     FLOAT            *WORK,
                     INTEGER          *IWORK,
                     INTEGER          *INFO);

//-- ssyswapr ------------------------------------------------------------------
void
LAPACK_IMPL(ssyswapr)(const char       *UPLO,
                      const INTEGER    *N,
                      FLOAT            *A,
                      const INTEGER    *LDA,
                      const INTEGER    *I1,
                      const INTEGER    *I2);

//-- ssytd2 --------------------------------------------------------------------
void
LAPACK_IMPL(ssytd2)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT            *TAU,
                    INTEGER          *INFO);

//-- ssytf2 --------------------------------------------------------------------
void
LAPACK_IMPL(ssytf2)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- ssytrd --------------------------------------------------------------------
void
LAPACK_IMPL(ssytrd)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- ssytrf --------------------------------------------------------------------
void
LAPACK_IMPL(ssytrf)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- ssytri --------------------------------------------------------------------
void
LAPACK_IMPL(ssytri)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    const INTEGER    *IPIV,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- ssytri2 -------------------------------------------------------------------
void
LAPACK_IMPL(ssytri2)(const char       *UPLO,
                     const INTEGER    *N,
                     FLOAT            *A,
                     const INTEGER    *LDA,
                     const INTEGER    *IPIV,
                     FLOAT            *WORK,
                     const INTEGER    *LWORK,
                     INTEGER          *INFO);

//-- ssytri2x ------------------------------------------------------------------
void
LAPACK_IMPL(ssytri2x)(const char       *UPLO,
                      const INTEGER    *N,
                      FLOAT            *A,
                      const INTEGER    *LDA,
                      const INTEGER    *IPIV,
                      FLOAT            *WORK,
                      const INTEGER    *NB,
                      INTEGER          *INFO);

//-- ssytrs --------------------------------------------------------------------
void
LAPACK_IMPL(ssytrs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const INTEGER    *IPIV,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- ssytrs2 -------------------------------------------------------------------
void
LAPACK_IMPL(ssytrs2)(const char       *UPLO,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     const FLOAT      *A,
                     const INTEGER    *LDA,
                     const INTEGER    *IPIV,
                     FLOAT            *B,
                     const INTEGER    *LDB,
                     FLOAT            *WORK,
                     INTEGER          *INFO);

//-- stbcon --------------------------------------------------------------------
void
LAPACK_IMPL(stbcon)(const char       *NORM,
                    const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const FLOAT      *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *RCOND,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- stbrfs --------------------------------------------------------------------
void
LAPACK_IMPL(stbrfs)(const char       *UPLO,
                    const char       *TRANS,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const INTEGER    *NRHS,
                    const FLOAT      *AB,
                    const INTEGER    *LDAB,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    const FLOAT      *X,
                    const INTEGER    *LDX,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- stbtrs --------------------------------------------------------------------
void
LAPACK_IMPL(stbtrs)(const char       *UPLO,
                    const char       *TRANS,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const INTEGER    *NRHS,
                    const FLOAT      *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- stfsm ---------------------------------------------------------------------
void
LAPACK_IMPL(stfsm)(const char           *TRANSR,
                   const char           *SIDE,
                   const char           *UPLO,
                   const char           *TRANS,
                   const char           *DIAG,
                   const INTEGER        *M,
                   const INTEGER        *N,
                   const FLOAT          *ALPHA,
                   const FLOAT          *A,
                   FLOAT                *B,
                   const INTEGER        *LDB);

//-- stftri --------------------------------------------------------------------
void
LAPACK_IMPL(stftri)(const char       *TRANSR,
                    const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    FLOAT            *A,
                    INTEGER          *INFO);

//-- stfttp --------------------------------------------------------------------
void
LAPACK_IMPL(stfttp)(const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const FLOAT      *ARF,
                    FLOAT            *AP,
                    INTEGER          *INFO);

//-- stfttr --------------------------------------------------------------------
void
LAPACK_IMPL(stfttr)(const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const FLOAT      *ARF,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- stgevc --------------------------------------------------------------------
void
LAPACK_IMPL(stgevc)(const char       *SIDE,
                    const char       *HOWMNY,
                    const LOGICAL    *SELECT,
                    const INTEGER    *N,
                    const FLOAT      *S,
                    const INTEGER    *LDS,
                    const FLOAT      *P,
                    const INTEGER    *LDP,
                    FLOAT            *VL,
                    const INTEGER    *LDVL,
                    FLOAT            *VR,
                    const INTEGER    *LDVR,
                    const INTEGER    *MM,
                    INTEGER          *M,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- stgex2 --------------------------------------------------------------------
void
LAPACK_IMPL(stgex2)(const LOGICAL    *WANTQ,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    const INTEGER    *J1,
                    const INTEGER    *N1,
                    const INTEGER    *N2,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- stgexc --------------------------------------------------------------------
void
LAPACK_IMPL(stgexc)(const LOGICAL    *WANTQ,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *IFST,
                    INTEGER          *ILST,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- stgsen --------------------------------------------------------------------
void
LAPACK_IMPL(stgsen)(const INTEGER    *IJOB,
                    const LOGICAL    *WANTQ,
                    const LOGICAL    *WANTZ,
                    const LOGICAL    *SELECT,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *ALPHAR,
                    FLOAT            *ALPHAI,
                    FLOAT            *BETA,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *M,
                    FLOAT            *PL,
                    FLOAT            *PR,
                    FLOAT            *DIF,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- stgsja --------------------------------------------------------------------
void
LAPACK_IMPL(stgsja)(const char       *JOBU,
                    const char       *JOBV,
                    const char       *JOBQ,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *L,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    const FLOAT      *TOLA,
                    const FLOAT      *TOLB,
                    FLOAT            *ALPHA,
                    FLOAT            *BETA,
                    FLOAT            *U,
                    const INTEGER    *LDU,
                    FLOAT            *V,
                    const INTEGER    *LDV,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    FLOAT            *WORK,
                    INTEGER          *NCYCLE,
                    INTEGER          *INFO);

//-- stgsna --------------------------------------------------------------------
void
LAPACK_IMPL(stgsna)(const char       *JOB,
                    const char       *HOWMNY,
                    const LOGICAL    *SELECT,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    const FLOAT      *VL,
                    const INTEGER    *LDVL,
                    const FLOAT      *VR,
                    const INTEGER    *LDVR,
                    FLOAT            *S,
                    FLOAT            *DIF,
                    const INTEGER    *MM,
                    INTEGER          *M,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- stgsy2 --------------------------------------------------------------------
void
LAPACK_IMPL(stgsy2)(const char       *TRANS,
                    const INTEGER    *IJOB,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    FLOAT            *C,
                    const INTEGER    *LDC,
                    const FLOAT      *D,
                    const INTEGER    *LDD,
                    const FLOAT      *E,
                    const INTEGER    *LDE,
                    FLOAT            *F,
                    const INTEGER    *LDF,
                    FLOAT            *SCALE,
                    FLOAT            *RDSUM,
                    FLOAT            *RDSCAL,
                    INTEGER          *IWORK,
                    INTEGER          *PQ,
                    INTEGER          *INFO);

//-- stgsyl --------------------------------------------------------------------
void
LAPACK_IMPL(stgsyl)(const char       *TRANS,
                    const INTEGER    *IJOB,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    FLOAT            *C,
                    const INTEGER    *LDC,
                    const FLOAT      *D,
                    const INTEGER    *LDD,
                    const FLOAT      *E,
                    const INTEGER    *LDE,
                    FLOAT            *F,
                    const INTEGER    *LDF,
                    FLOAT            *SCALE,
                    FLOAT            *DIF,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- stpcon --------------------------------------------------------------------
void
LAPACK_IMPL(stpcon)(const char       *NORM,
                    const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const FLOAT      *AP,
                    FLOAT            *RCOND,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- stprfs --------------------------------------------------------------------
void
LAPACK_IMPL(stprfs)(const char       *UPLO,
                    const char       *TRANS,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *AP,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    const FLOAT      *X,
                    const INTEGER    *LDX,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- stptri --------------------------------------------------------------------
void
LAPACK_IMPL(stptri)(const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    FLOAT            *AP,
                    INTEGER          *INFO);

//-- stptrs --------------------------------------------------------------------
void
LAPACK_IMPL(stptrs)(const char       *UPLO,
                    const char       *TRANS,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *AP,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- stpttf --------------------------------------------------------------------
void
LAPACK_IMPL(stpttf)(const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const FLOAT      *AP,
                    FLOAT            *ARF,
                    INTEGER          *INFO);

//-- stpttr --------------------------------------------------------------------
void
LAPACK_IMPL(stpttr)(const char       *UPLO,
                    const INTEGER    *N,
                    const FLOAT      *AP,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- strcon --------------------------------------------------------------------
void
LAPACK_IMPL(strcon)(const char       *NORM,
                    const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    FLOAT            *RCOND,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- strevc --------------------------------------------------------------------
void
LAPACK_IMPL(strevc)(const char       *SIDE,
                    const char       *HOWMNY,
                    LOGICAL          *SELECT,
                    const INTEGER    *N,
                    const FLOAT      *T,
                    const INTEGER    *LDT,
                    FLOAT            *VL,
                    const INTEGER    *LDVL,
                    FLOAT            *VR,
                    const INTEGER    *LDVR,
                    const INTEGER    *MM,
                    INTEGER          *M,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- strexc --------------------------------------------------------------------
void
LAPACK_IMPL(strexc)(const char       *COMPQ,
                    const INTEGER    *N,
                    FLOAT            *T,
                    const INTEGER    *LDT,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    INTEGER          *IFST,
                    INTEGER          *ILST,
                    FLOAT            *WORK,
                    INTEGER          *INFO);

//-- strrfs --------------------------------------------------------------------
void
LAPACK_IMPL(strrfs)(const char       *UPLO,
                    const char       *TRANS,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    const FLOAT      *X,
                    const INTEGER    *LDX,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- strsen --------------------------------------------------------------------
void
LAPACK_IMPL(strsen)(const char       *JOB,
                    const char       *COMPQ,
                    const LOGICAL    *SELECT,
                    const INTEGER    *N,
                    FLOAT            *T,
                    const INTEGER    *LDT,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    FLOAT            *WR,
                    FLOAT            *WI,
                    INTEGER          *M,
                    FLOAT            *S,
                    FLOAT            *SEP,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- strsna --------------------------------------------------------------------
void
LAPACK_IMPL(strsna)(const char       *JOB,
                    const char       *HOWMNY,
                    const LOGICAL    *SELECT,
                    const INTEGER    *N,
                    const FLOAT      *T,
                    const INTEGER    *LDT,
                    const FLOAT      *VL,
                    const INTEGER    *LDVL,
                    const FLOAT      *VR,
                    const INTEGER    *LDVR,
                    FLOAT            *S,
                    FLOAT            *SEP,
                    const INTEGER    *MM,
                    INTEGER          *M,
                    FLOAT            *WORK,
                    const INTEGER    *LDWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- strsyl --------------------------------------------------------------------
void
LAPACK_IMPL(strsyl)(const char       *TRANA,
                    const char       *TRANB,
                    const INTEGER    *ISGN,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    FLOAT            *C,
                    const INTEGER    *LDC,
                    FLOAT            *SCALE,
                    INTEGER          *INFO);

//-- strti2 --------------------------------------------------------------------
void
LAPACK_IMPL(strti2)(const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- strtri --------------------------------------------------------------------
void
LAPACK_IMPL(strtri)(const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- strtrs --------------------------------------------------------------------
void
LAPACK_IMPL(strtrs)(const char       *UPLO,
                    const char       *TRANS,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO);

//-- strttf --------------------------------------------------------------------
void
LAPACK_IMPL(strttf)(const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    FLOAT            *ARF,
                    INTEGER          *INFO);

//-- strttp --------------------------------------------------------------------
void
LAPACK_IMPL(strttp)(const char       *UPLO,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    FLOAT            *AP,
                    INTEGER          *INFO);

//-- stzrqf --------------------------------------------------------------------
void
LAPACK_IMPL(stzrqf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAU,
                    INTEGER          *INFO);

//-- stzrzf --------------------------------------------------------------------
void
LAPACK_IMPL(stzrzf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- xerbla_array --------------------------------------------------------------
void
LAPACK_IMPL(xerbla_array)(const char       *SRNAME_ARRAY,
                          const INTEGER    *SRNAME_LEN,
                          const INTEGER    *INFO);

//-- zbbcsd --------------------------------------------------------------------
void
LAPACK_IMPL(zbbcsd)(const char       *JOBU1,
                    const char       *JOBU2,
                    const char       *JOBV1T,
                    const char       *JOBV2T,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *Q,
                    DOUBLE           *THETA,
                    DOUBLE           *PHI,
                    DOUBLE_COMPLEX   *U1,
                    const INTEGER    *LDU1,
                    DOUBLE_COMPLEX   *U2,
                    const INTEGER    *LDU2,
                    DOUBLE_COMPLEX   *V1T,
                    const INTEGER    *LDV1T,
                    DOUBLE_COMPLEX   *V2T,
                    const INTEGER    *LDV2T,
                    DOUBLE           *B11D,
                    DOUBLE           *B11E,
                    DOUBLE           *B12D,
                    DOUBLE           *B12E,
                    const DOUBLE     *B21D,
                    const DOUBLE     *B21E,
                    const DOUBLE     *B22D,
                    const DOUBLE     *B22E,
                    DOUBLE           *RWORK,
                    const INTEGER    *LRWORK,
                    INTEGER          *INFO);

//-- zbdsqr --------------------------------------------------------------------
void
LAPACK_IMPL(zbdsqr)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NCVT,
                    const INTEGER    *NRU,
                    const INTEGER    *NCC,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE_COMPLEX   *VT,
                    const INTEGER    *LDVT,
                    DOUBLE_COMPLEX   *U,
                    const INTEGER    *LDU,
                    DOUBLE_COMPLEX   *C,
                    const INTEGER    *LDC,
                    DOUBLE           *RWORK,
                    INTEGER          *INFO);

//-- zcgesv --------------------------------------------------------------------
void
LAPACK_IMPL(zcgesv)(const INTEGER            *N,
                    const INTEGER            *NRHS,
                    DOUBLE_COMPLEX           *A,
                    const INTEGER            *LDA,
                    INTEGER                  *IPIV,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    DOUBLE_COMPLEX           *X,
                    const INTEGER            *LDX,
                    DOUBLE_COMPLEX           *WORK,
                    FLOAT_COMPLEX            *SWORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *ITER,
                    INTEGER                  *INFO);

//-- zcposv --------------------------------------------------------------------
void
LAPACK_IMPL(zcposv)(const char               *UPLO,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    DOUBLE_COMPLEX           *A,
                    const INTEGER            *LDA,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    DOUBLE_COMPLEX           *X,
                    const INTEGER            *LDX,
                    DOUBLE_COMPLEX           *WORK,
                    FLOAT_COMPLEX            *SWORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *ITER,
                    INTEGER                  *INFO);

//-- zdrscl --------------------------------------------------------------------
void
LAPACK_IMPL(zdrscl)(const INTEGER    *N,
                    const DOUBLE     *SA,
                    DOUBLE_COMPLEX   *SX,
                    const INTEGER    *INCX);

//-- zgbbrd --------------------------------------------------------------------
void
LAPACK_IMPL(zgbbrd)(const char       *VECT,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NCC,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    DOUBLE_COMPLEX   *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE_COMPLEX   *Q,
                    const INTEGER    *LDQ,
                    DOUBLE_COMPLEX   *PT,
                    const INTEGER    *LDPT,
                    DOUBLE_COMPLEX   *C,
                    const INTEGER    *LDC,
                    DOUBLE_COMPLEX   *WORK,
                    DOUBLE           *RWORK,
                    INTEGER          *INFO);

//-- zgbcon --------------------------------------------------------------------
void
LAPACK_IMPL(zgbcon)(const char               *NORM,
                    const INTEGER            *N,
                    const INTEGER            *KL,
                    const INTEGER            *KU,
                    const DOUBLE_COMPLEX     *AB,
                    const INTEGER            *LDAB,
                    const INTEGER            *IPIV,
                    const DOUBLE             *ANORM,
                    DOUBLE                   *RCOND,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- zgbequ --------------------------------------------------------------------
void
LAPACK_IMPL(zgbequ)(const INTEGER            *M,
                    const INTEGER            *N,
                    const INTEGER            *KL,
                    const INTEGER            *KU,
                    const DOUBLE_COMPLEX     *AB,
                    const INTEGER            *LDAB,
                    DOUBLE                   *R,
                    DOUBLE                   *C,
                    DOUBLE                   *ROWCND,
                    DOUBLE                   *COLCND,
                    DOUBLE                   *AMAX,
                    INTEGER                  *INFO);

//-- zgbequb -------------------------------------------------------------------
void
LAPACK_IMPL(zgbequb)(const INTEGER            *M,
                     const INTEGER            *N,
                     const INTEGER            *KL,
                     const INTEGER            *KU,
                     const DOUBLE_COMPLEX     *AB,
                     const INTEGER            *LDAB,
                     DOUBLE                   *R,
                     DOUBLE                   *C,
                     DOUBLE                   *ROWCND,
                     DOUBLE                   *COLCND,
                     DOUBLE                   *AMAX,
                     INTEGER                  *INFO);

//-- zgbrfs --------------------------------------------------------------------
void
LAPACK_IMPL(zgbrfs)(const char               *TRANS,
                    const INTEGER            *N,
                    const INTEGER            *KL,
                    const INTEGER            *KU,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *AB,
                    const INTEGER            *LDAB,
                    const DOUBLE_COMPLEX     *AFB,
                    const INTEGER            *LDAFB,
                    const INTEGER            *IPIV,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    DOUBLE_COMPLEX           *X,
                    const INTEGER            *LDX,
                    DOUBLE                   *FERR,
                    DOUBLE                   *BERR,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- zgbrfsx -------------------------------------------------------------------
void
LAPACK_IMPL(zgbrfsx)(const char               *TRANS,
                     const char               *EQUED,
                     const INTEGER            *N,
                     const INTEGER            *KL,
                     const INTEGER            *KU,
                     const INTEGER            *NRHS,
                     const DOUBLE_COMPLEX     *AB,
                     const INTEGER            *LDAB,
                     const DOUBLE_COMPLEX     *AFB,
                     const INTEGER            *LDAFB,
                     const INTEGER            *IPIV,
                     DOUBLE                   *R,
                     DOUBLE                   *C,
                     const DOUBLE_COMPLEX     *B,
                     const INTEGER            *LDB,
                     DOUBLE_COMPLEX           *X,
                     const INTEGER            *LDX,
                     DOUBLE                   *RCOND,
                     DOUBLE                   *BERR,
                     const INTEGER            *N_ERR_BNDS,
                     DOUBLE                   *ERR_BNDS_NORM,
                     DOUBLE                   *ERR_BNDS_COMP,
                     const INTEGER            *NPARAMS,
                     DOUBLE                   *PARAMS,
                     DOUBLE_COMPLEX           *WORK,
                     DOUBLE                   *RWORK,
                     INTEGER                  *INFO);

//-- zgbsv ---------------------------------------------------------------------
void
LAPACK_IMPL(zgbsv)(const INTEGER        *N,
                   const INTEGER        *KL,
                   const INTEGER        *KU,
                   const INTEGER        *NRHS,
                   DOUBLE_COMPLEX       *AB,
                   const INTEGER        *LDAB,
                   INTEGER              *IPIV,
                   DOUBLE_COMPLEX       *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- zgbsvx --------------------------------------------------------------------
void
LAPACK_IMPL(zgbsvx)(const char       *FACT,
                    const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const INTEGER    *NRHS,
                    DOUBLE_COMPLEX   *AB,
                    const INTEGER    *LDAB,
                    DOUBLE_COMPLEX   *AFB,
                    const INTEGER    *LDAFB,
                    INTEGER          *IPIV,
                    char             *EQUED,
                    DOUBLE           *R,
                    DOUBLE           *C,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB,
                    DOUBLE_COMPLEX   *X,
                    const INTEGER    *LDX,
                    DOUBLE           *RCOND,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE_COMPLEX   *WORK,
                    DOUBLE           *RWORK,
                    INTEGER          *INFO);

//-- zgbsvxx -------------------------------------------------------------------
void
LAPACK_IMPL(zgbsvxx)(const char       *FACT,
                     const char       *TRANS,
                     const INTEGER    *N,
                     const INTEGER    *KL,
                     const INTEGER    *KU,
                     const INTEGER    *NRHS,
                     DOUBLE_COMPLEX   *AB,
                     const INTEGER    *LDAB,
                     DOUBLE_COMPLEX   *AFB,
                     const INTEGER    *LDAFB,
                     INTEGER          *IPIV,
                     char             *EQUED,
                     DOUBLE           *R,
                     DOUBLE           *C,
                     DOUBLE_COMPLEX   *B,
                     const INTEGER    *LDB,
                     DOUBLE_COMPLEX   *X,
                     const INTEGER    *LDX,
                     DOUBLE           *RCOND,
                     DOUBLE           *RPVGRW,
                     DOUBLE           *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     DOUBLE           *ERR_BNDS_NORM,
                     DOUBLE           *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     DOUBLE           *PARAMS,
                     DOUBLE_COMPLEX   *WORK,
                     DOUBLE           *RWORK,
                     INTEGER          *INFO);

//-- zgbtf2 --------------------------------------------------------------------
void
LAPACK_IMPL(zgbtf2)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    DOUBLE_COMPLEX   *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- zgbtrf --------------------------------------------------------------------
void
LAPACK_IMPL(zgbtrf)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    DOUBLE_COMPLEX   *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- zgbtrs --------------------------------------------------------------------
void
LAPACK_IMPL(zgbtrs)(const char               *TRANS,
                    const INTEGER            *N,
                    const INTEGER            *KL,
                    const INTEGER            *KU,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *AB,
                    const INTEGER            *LDAB,
                    const INTEGER            *IPIV,
                    DOUBLE_COMPLEX           *B,
                    const INTEGER            *LDB,
                    INTEGER                  *INFO);

//-- zgebak --------------------------------------------------------------------
void
LAPACK_IMPL(zgebak)(const char       *JOB,
                    const char       *SIDE,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    const DOUBLE     *SCALE,
                    const INTEGER    *M,
                    DOUBLE_COMPLEX   *V,
                    const INTEGER    *LDV,
                    INTEGER          *INFO);

//-- zgebal --------------------------------------------------------------------
void
LAPACK_IMPL(zgebal)(const char       *JOB,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    DOUBLE           *SCALE,
                    INTEGER          *INFO);

//-- zgebd2 --------------------------------------------------------------------
void
LAPACK_IMPL(zgebd2)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE_COMPLEX   *TAUQ,
                    DOUBLE_COMPLEX   *TAUP,
                    DOUBLE_COMPLEX   *WORK,
                    INTEGER          *INFO);

//-- zgebrd --------------------------------------------------------------------
void
LAPACK_IMPL(zgebrd)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE_COMPLEX   *TAUQ,
                    DOUBLE_COMPLEX   *TAUP,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- zgecon --------------------------------------------------------------------
void
LAPACK_IMPL(zgecon)(const char               *NORM,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    const DOUBLE             *ANORM,
                    DOUBLE                   *RCOND,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- zgeequ --------------------------------------------------------------------
void
LAPACK_IMPL(zgeequ)(const INTEGER            *M,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    DOUBLE                   *R,
                    DOUBLE                   *C,
                    DOUBLE                   *ROWCND,
                    DOUBLE                   *COLCND,
                    DOUBLE                   *AMAX,
                    INTEGER                  *INFO);

//-- zgeequb -------------------------------------------------------------------
void
LAPACK_IMPL(zgeequb)(const INTEGER            *M,
                     const INTEGER            *N,
                     const DOUBLE_COMPLEX     *A,
                     const INTEGER            *LDA,
                     DOUBLE                   *R,
                     DOUBLE                   *C,
                     DOUBLE                   *ROWCND,
                     DOUBLE                   *COLCND,
                     DOUBLE                   *AMAX,
                     INTEGER                  *INFO);

//-- zgees ---------------------------------------------------------------------
void
LAPACK_IMPL(zgees)(const char           *JOBVS,
                   const char           *SORT,
                   LOGICAL              (*SELECT)(const DOUBLE_COMPLEX *),
                   const INTEGER        *N,
                   DOUBLE_COMPLEX       *A,
                   const INTEGER        *LDA,
                   INTEGER              *SDIM,
                   DOUBLE_COMPLEX       *W,
                   DOUBLE_COMPLEX       *VS,
                   const INTEGER        *LDVS,
                   DOUBLE_COMPLEX       *WORK,
                   const INTEGER        *LWORK,
                   DOUBLE               *RWORK,
                   LOGICAL              *BWORK,
                   INTEGER              *INFO);

//-- zgeesx --------------------------------------------------------------------
void
LAPACK_IMPL(zgeesx)(const char       *JOBVS,
                    const char       *SORT,
                    LOGICAL          (*SELECT)(const DOUBLE_COMPLEX *),
                    const char       *SENSE,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    INTEGER          *SDIM,
                    DOUBLE_COMPLEX   *W,
                    DOUBLE_COMPLEX   *VS,
                    const INTEGER    *LDVS,
                    DOUBLE           *RCONDE,
                    DOUBLE           *RCONDV,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    DOUBLE           *RWORK,
                    LOGICAL          *BWORK,
                    INTEGER          *INFO);

//-- zgeev ---------------------------------------------------------------------
void
LAPACK_IMPL(zgeev)(const char           *JOBVL,
                   const char           *JOBVR,
                   const INTEGER        *N,
                   DOUBLE_COMPLEX       *A,
                   const INTEGER        *LDA,
                   DOUBLE_COMPLEX       *W,
                   DOUBLE_COMPLEX       *VL,
                   const INTEGER        *LDVL,
                   DOUBLE_COMPLEX       *VR,
                   const INTEGER        *LDVR,
                   DOUBLE_COMPLEX       *WORK,
                   const INTEGER        *LWORK,
                   DOUBLE               *RWORK,
                   INTEGER              *INFO);

//-- zgeevx --------------------------------------------------------------------
void
LAPACK_IMPL(zgeevx)(const char       *BALANC,
                    const char       *JOBVL,
                    const char       *JOBVR,
                    const char       *SENSE,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *W,
                    DOUBLE_COMPLEX   *VL,
                    const INTEGER    *LDVL,
                    DOUBLE_COMPLEX   *VR,
                    const INTEGER    *LDVR,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    DOUBLE           *SCALE,
                    DOUBLE           *ABNRM,
                    DOUBLE           *RCONDE,
                    DOUBLE           *RCONDV,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    DOUBLE           *RWORK,
                    INTEGER          *INFO);

//-- zgegs ---------------------------------------------------------------------
void
LAPACK_IMPL(zgegs)(const char           *JOBVSL,
                   const char           *JOBVSR,
                   const INTEGER        *N,
                   DOUBLE_COMPLEX       *A,
                   const INTEGER        *LDA,
                   DOUBLE_COMPLEX       *B,
                   const INTEGER        *LDB,
                   DOUBLE_COMPLEX       *ALPHA,
                   DOUBLE_COMPLEX       *BETA,
                   DOUBLE_COMPLEX       *VSL,
                   const INTEGER        *LDVSL,
                   DOUBLE_COMPLEX       *VSR,
                   const INTEGER        *LDVSR,
                   DOUBLE_COMPLEX       *WORK,
                   const INTEGER        *LWORK,
                   DOUBLE               *RWORK,
                   INTEGER              *INFO);

//-- zgegv ---------------------------------------------------------------------
void
LAPACK_IMPL(zgegv)(const char           *JOBVL,
                   const char           *JOBVR,
                   const INTEGER        *N,
                   DOUBLE_COMPLEX       *A,
                   const INTEGER        *LDA,
                   DOUBLE_COMPLEX       *B,
                   const INTEGER        *LDB,
                   DOUBLE_COMPLEX       *ALPHA,
                   DOUBLE_COMPLEX       *BETA,
                   DOUBLE_COMPLEX       *VL,
                   const INTEGER        *LDVL,
                   DOUBLE_COMPLEX       *VR,
                   const INTEGER        *LDVR,
                   DOUBLE_COMPLEX       *WORK,
                   const INTEGER        *LWORK,
                   DOUBLE               *RWORK,
                   INTEGER              *INFO);

//-- zgehd2 --------------------------------------------------------------------
void
LAPACK_IMPL(zgehd2)(const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *TAU,
                    DOUBLE_COMPLEX   *WORK,
                    INTEGER          *INFO);

//-- zgehrd --------------------------------------------------------------------
void
LAPACK_IMPL(zgehrd)(const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *TAU,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- zgelq2 --------------------------------------------------------------------
void
LAPACK_IMPL(zgelq2)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *TAU,
                    DOUBLE_COMPLEX   *WORK,
                    INTEGER          *INFO);

//-- zgelqf --------------------------------------------------------------------
void
LAPACK_IMPL(zgelqf)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *TAU,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- zgels ---------------------------------------------------------------------
void
LAPACK_IMPL(zgels)(const char           *TRANS,
                   const INTEGER        *M,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   DOUBLE_COMPLEX       *A,
                   const INTEGER        *LDA,
                   DOUBLE_COMPLEX       *B,
                   const INTEGER        *LDB,
                   DOUBLE_COMPLEX       *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO);

//-- zgelsd --------------------------------------------------------------------
void
LAPACK_IMPL(zgelsd)(const INTEGER            *M,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    DOUBLE_COMPLEX           *B,
                    const INTEGER            *LDB,
                    DOUBLE                   *S,
                    const DOUBLE             *RCOND,
                    INTEGER                  *RANK,
                    DOUBLE_COMPLEX           *WORK,
                    const INTEGER            *LWORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *IWORK,
                    INTEGER                  *INFO);

//-- zgelss --------------------------------------------------------------------
void
LAPACK_IMPL(zgelss)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB,
                    DOUBLE           *S,
                    const DOUBLE     *RCOND,
                    INTEGER          *RANK,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    DOUBLE           *RWORK,
                    INTEGER          *INFO);

//-- zgelsx --------------------------------------------------------------------
void
LAPACK_IMPL(zgelsx)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB,
                    INTEGER          *JPVT,
                    const DOUBLE     *RCOND,
                    INTEGER          *RANK,
                    DOUBLE_COMPLEX   *WORK,
                    DOUBLE           *RWORK,
                    INTEGER          *INFO);

//-- zgelsy --------------------------------------------------------------------
void
LAPACK_IMPL(zgelsy)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB,
                    INTEGER          *JPVT,
                    const DOUBLE     *RCOND,
                    INTEGER          *RANK,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    DOUBLE           *RWORK,
                    INTEGER          *INFO);

//-- zgeql2 --------------------------------------------------------------------
void
LAPACK_IMPL(zgeql2)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *TAU,
                    DOUBLE_COMPLEX   *WORK,
                    INTEGER          *INFO);

//-- zgeqlf --------------------------------------------------------------------
void
LAPACK_IMPL(zgeqlf)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *TAU,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- zgeqp3 --------------------------------------------------------------------
void
LAPACK_IMPL(zgeqp3)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    DOUBLE_COMPLEX   *TAU,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    DOUBLE           *RWORK,
                    INTEGER          *INFO);

//-- zgeqpf --------------------------------------------------------------------
void
LAPACK_IMPL(zgeqpf)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    DOUBLE_COMPLEX   *TAU,
                    DOUBLE_COMPLEX   *WORK,
                    DOUBLE           *RWORK,
                    INTEGER          *INFO);

//-- zgeqr2 --------------------------------------------------------------------
void
LAPACK_IMPL(zgeqr2)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *TAU,
                    DOUBLE_COMPLEX   *WORK,
                    INTEGER          *INFO);

//-- zgeqr2p -------------------------------------------------------------------
void
LAPACK_IMPL(zgeqr2p)(const INTEGER    *M,
                     const INTEGER    *N,
                     DOUBLE_COMPLEX   *A,
                     const INTEGER    *LDA,
                     DOUBLE_COMPLEX   *TAU,
                     DOUBLE_COMPLEX   *WORK,
                     INTEGER          *INFO);

//-- zgeqrf --------------------------------------------------------------------
void
LAPACK_IMPL(zgeqrf)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *TAU,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- zgeqrfp -------------------------------------------------------------------
void
LAPACK_IMPL(zgeqrfp)(const INTEGER    *M,
                     const INTEGER    *N,
                     DOUBLE_COMPLEX   *A,
                     const INTEGER    *LDA,
                     DOUBLE_COMPLEX   *TAU,
                     DOUBLE_COMPLEX   *WORK,
                     const INTEGER    *LWORK,
                     INTEGER          *INFO);

//-- zgerfs --------------------------------------------------------------------
void
LAPACK_IMPL(zgerfs)(const char               *TRANS,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    const DOUBLE_COMPLEX     *AF,
                    const INTEGER            *LDAF,
                    const INTEGER            *IPIV,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    DOUBLE_COMPLEX           *X,
                    const INTEGER            *LDX,
                    DOUBLE                   *FERR,
                    DOUBLE                   *BERR,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- zgerfsx -------------------------------------------------------------------
void
LAPACK_IMPL(zgerfsx)(const char               *TRANS,
                     const char               *EQUED,
                     const INTEGER            *N,
                     const INTEGER            *NRHS,
                     const DOUBLE_COMPLEX     *A,
                     const INTEGER            *LDA,
                     const DOUBLE_COMPLEX     *AF,
                     const INTEGER            *LDAF,
                     const INTEGER            *IPIV,
                     const DOUBLE             *R,
                     const DOUBLE             *C,
                     const DOUBLE_COMPLEX     *B,
                     const INTEGER            *LDB,
                     DOUBLE_COMPLEX           *X,
                     const INTEGER            *LDX,
                     DOUBLE                   *RCOND,
                     DOUBLE                   *BERR,
                     const INTEGER            *N_ERR_BNDS,
                     DOUBLE                   *ERR_BNDS_NORM,
                     DOUBLE                   *ERR_BNDS_COMP,
                     const INTEGER            *NPARAMS,
                     DOUBLE                   *PARAMS,
                     DOUBLE_COMPLEX           *WORK,
                     DOUBLE                   *RWORK,
                     INTEGER                  *INFO);

//-- zgerq2 --------------------------------------------------------------------
void
LAPACK_IMPL(zgerq2)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *TAU,
                    DOUBLE_COMPLEX   *WORK,
                    INTEGER          *INFO);

//-- zgerqf --------------------------------------------------------------------
void
LAPACK_IMPL(zgerqf)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *TAU,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- zgesc2 --------------------------------------------------------------------
void
LAPACK_IMPL(zgesc2)(const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    DOUBLE_COMPLEX           *RHS,
                    const INTEGER            *IPIV,
                    const INTEGER            *JPIV,
                    DOUBLE                   *SCALE);

//-- zgesdd --------------------------------------------------------------------
void
LAPACK_IMPL(zgesdd)(const char       *JOBZ,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE           *S,
                    DOUBLE_COMPLEX   *U,
                    const INTEGER    *LDU,
                    DOUBLE_COMPLEX   *VT,
                    const INTEGER    *LDVT,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    DOUBLE           *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- zgesv ---------------------------------------------------------------------
void
LAPACK_IMPL(zgesv)(const INTEGER        *N,
                   const INTEGER        *NRHS,
                   DOUBLE_COMPLEX       *A,
                   const INTEGER        *LDA,
                   INTEGER              *IPIV,
                   DOUBLE_COMPLEX       *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- zgesvd --------------------------------------------------------------------
void
LAPACK_IMPL(zgesvd)(const char       *JOBU,
                    const char       *JOBVT,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE           *S,
                    DOUBLE_COMPLEX   *U,
                    const INTEGER    *LDU,
                    DOUBLE_COMPLEX   *VT,
                    const INTEGER    *LDVT,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    DOUBLE           *RWORK,
                    INTEGER          *INFO);

//-- zgesvx --------------------------------------------------------------------
void
LAPACK_IMPL(zgesvx)(const char       *FACT,
                    const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *AF,
                    const INTEGER    *LDAF,
                    INTEGER          *IPIV,
                    char             *EQUED,
                    DOUBLE           *R,
                    DOUBLE           *C,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB,
                    DOUBLE_COMPLEX   *X,
                    const INTEGER    *LDX,
                    DOUBLE           *RCOND,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE_COMPLEX   *WORK,
                    DOUBLE           *RWORK,
                    INTEGER          *INFO);

//-- zgesvxx -------------------------------------------------------------------
void
LAPACK_IMPL(zgesvxx)(const char       *FACT,
                     const char       *TRANS,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     DOUBLE_COMPLEX   *A,
                     const INTEGER    *LDA,
                     DOUBLE_COMPLEX   *AF,
                     const INTEGER    *LDAF,
                     INTEGER          *IPIV,
                     char             *EQUED,
                     DOUBLE           *R,
                     DOUBLE           *C,
                     DOUBLE_COMPLEX   *B,
                     const INTEGER    *LDB,
                     DOUBLE_COMPLEX   *X,
                     const INTEGER    *LDX,
                     DOUBLE           *RCOND,
                     DOUBLE           *RPVGRW,
                     DOUBLE           *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     DOUBLE           *ERR_BNDS_NORM,
                     DOUBLE           *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     DOUBLE           *PARAMS,
                     DOUBLE_COMPLEX   *WORK,
                     DOUBLE           *RWORK,
                     INTEGER          *INFO);

//-- zgetc2 --------------------------------------------------------------------
void
LAPACK_IMPL(zgetc2)(const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *JPIV,
                    INTEGER          *INFO);

//-- zgetf2 --------------------------------------------------------------------
void
LAPACK_IMPL(zgetf2)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- zgetrf --------------------------------------------------------------------
void
LAPACK_IMPL(zgetrf)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- zgetri --------------------------------------------------------------------
void
LAPACK_IMPL(zgetri)(const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    const INTEGER    *IPIV,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- zgetrs --------------------------------------------------------------------
void
LAPACK_IMPL(zgetrs)(const char               *TRANS,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    const INTEGER            *IPIV,
                    DOUBLE_COMPLEX           *B,
                    const INTEGER            *LDB,
                    INTEGER                  *INFO);

//-- zggbak --------------------------------------------------------------------
void
LAPACK_IMPL(zggbak)(const char       *JOB,
                    const char       *SIDE,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    const DOUBLE     *LSCALE,
                    const DOUBLE     *RSCALE,
                    const INTEGER    *M,
                    DOUBLE_COMPLEX   *V,
                    const INTEGER    *LDV,
                    INTEGER          *INFO);

//-- zggbal --------------------------------------------------------------------
void
LAPACK_IMPL(zggbal)(const char       *JOB,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    DOUBLE           *LSCALE,
                    DOUBLE           *RSCALE,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- zgges ---------------------------------------------------------------------
void
LAPACK_IMPL(zgges)(const char           *JOBVSL,
                   const char           *JOBVSR,
                   const char           *SORT,
                   const LOGICAL        *SELCTG,
                   const INTEGER        *N,
                   DOUBLE_COMPLEX       *A,
                   const INTEGER        *LDA,
                   DOUBLE_COMPLEX       *B,
                   const INTEGER        *LDB,
                   INTEGER              *SDIM,
                   DOUBLE_COMPLEX       *ALPHA,
                   DOUBLE_COMPLEX       *BETA,
                   DOUBLE_COMPLEX       *VSL,
                   const INTEGER        *LDVSL,
                   DOUBLE_COMPLEX       *VSR,
                   const INTEGER        *LDVSR,
                   DOUBLE_COMPLEX       *WORK,
                   const INTEGER        *LWORK,
                   DOUBLE               *RWORK,
                   LOGICAL              *BWORK,
                   INTEGER              *INFO);

//-- zggesx --------------------------------------------------------------------
void
LAPACK_IMPL(zggesx)(const char       *JOBVSL,
                    const char       *JOBVSR,
                    const char       *SORT,
                    const LOGICAL    *SELCTG,
                    const char       *SENSE,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB,
                    INTEGER          *SDIM,
                    DOUBLE_COMPLEX   *ALPHA,
                    DOUBLE_COMPLEX   *BETA,
                    DOUBLE_COMPLEX   *VSL,
                    const INTEGER    *LDVSL,
                    DOUBLE_COMPLEX   *VSR,
                    const INTEGER    *LDVSR,
                    DOUBLE           *RCONDE,
                    DOUBLE           *RCONDV,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    DOUBLE           *RWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    LOGICAL          *BWORK,
                    INTEGER          *INFO);

//-- zggev ---------------------------------------------------------------------
void
LAPACK_IMPL(zggev)(const char           *JOBVL,
                   const char           *JOBVR,
                   const INTEGER        *N,
                   DOUBLE_COMPLEX       *A,
                   const INTEGER        *LDA,
                   DOUBLE_COMPLEX       *B,
                   const INTEGER        *LDB,
                   DOUBLE_COMPLEX       *ALPHA,
                   DOUBLE_COMPLEX       *BETA,
                   DOUBLE_COMPLEX       *VL,
                   const INTEGER        *LDVL,
                   DOUBLE_COMPLEX       *VR,
                   const INTEGER        *LDVR,
                   DOUBLE_COMPLEX       *WORK,
                   const INTEGER        *LWORK,
                   DOUBLE               *RWORK,
                   INTEGER              *INFO);

//-- zggevx --------------------------------------------------------------------
void
LAPACK_IMPL(zggevx)(const char       *BALANC,
                    const char       *JOBVL,
                    const char       *JOBVR,
                    const char       *SENSE,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB,
                    DOUBLE_COMPLEX   *ALPHA,
                    DOUBLE_COMPLEX   *BETA,
                    DOUBLE_COMPLEX   *VL,
                    const INTEGER    *LDVL,
                    DOUBLE_COMPLEX   *VR,
                    const INTEGER    *LDVR,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    DOUBLE           *LSCALE,
                    DOUBLE           *RSCALE,
                    DOUBLE           *ABNRM,
                    DOUBLE           *BBNRM,
                    DOUBLE           *RCONDE,
                    DOUBLE           *RCONDV,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    DOUBLE           *RWORK,
                    INTEGER          *IWORK,
                    LOGICAL          *BWORK,
                    INTEGER          *INFO);

//-- zggglm --------------------------------------------------------------------
void
LAPACK_IMPL(zggglm)(const INTEGER    *N,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB,
                    DOUBLE_COMPLEX   *D,
                    DOUBLE_COMPLEX   *X,
                    DOUBLE_COMPLEX   *Y,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- zgghrd --------------------------------------------------------------------
void
LAPACK_IMPL(zgghrd)(const char       *COMPQ,
                    const char       *COMPZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB,
                    DOUBLE_COMPLEX   *Q,
                    const INTEGER    *LDQ,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *INFO);

//-- zgglse --------------------------------------------------------------------
void
LAPACK_IMPL(zgglse)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *P,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB,
                    DOUBLE_COMPLEX   *C,
                    DOUBLE_COMPLEX   *D,
                    DOUBLE_COMPLEX   *X,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- zggqrf --------------------------------------------------------------------
void
LAPACK_IMPL(zggqrf)(const INTEGER    *N,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *TAUA,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB,
                    DOUBLE_COMPLEX   *TAUB,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- zggrqf --------------------------------------------------------------------
void
LAPACK_IMPL(zggrqf)(const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *TAUA,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB,
                    DOUBLE_COMPLEX   *TAUB,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- zggsvd --------------------------------------------------------------------
void
LAPACK_IMPL(zggsvd)(const char       *JOBU,
                    const char       *JOBV,
                    const char       *JOBQ,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *P,
                    INTEGER          *K,
                    INTEGER          *L,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB,
                    DOUBLE           *ALPHA,
                    DOUBLE           *BETA,
                    DOUBLE_COMPLEX   *U,
                    const INTEGER    *LDU,
                    DOUBLE_COMPLEX   *V,
                    const INTEGER    *LDV,
                    DOUBLE_COMPLEX   *Q,
                    const INTEGER    *LDQ,
                    DOUBLE_COMPLEX   *WORK,
                    DOUBLE           *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- zggsvp --------------------------------------------------------------------
void
LAPACK_IMPL(zggsvp)(const char       *JOBU,
                    const char       *JOBV,
                    const char       *JOBQ,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB,
                    const DOUBLE     *TOLA,
                    const DOUBLE     *TOLB,
                    INTEGER          *K,
                    INTEGER          *L,
                    DOUBLE_COMPLEX   *U,
                    const INTEGER    *LDU,
                    DOUBLE_COMPLEX   *V,
                    const INTEGER    *LDV,
                    DOUBLE_COMPLEX   *Q,
                    const INTEGER    *LDQ,
                    INTEGER          *IWORK,
                    DOUBLE           *RWORK,
                    DOUBLE_COMPLEX   *TAU,
                    DOUBLE_COMPLEX   *WORK,
                    INTEGER          *INFO);

//-- zgtcon --------------------------------------------------------------------
void
LAPACK_IMPL(zgtcon)(const char               *NORM,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *DL,
                    const DOUBLE_COMPLEX     *D,
                    const DOUBLE_COMPLEX     *DU,
                    const DOUBLE_COMPLEX     *DU2,
                    const INTEGER            *IPIV,
                    const DOUBLE             *ANORM,
                    DOUBLE                   *RCOND,
                    DOUBLE_COMPLEX           *WORK,
                    INTEGER                  *INFO);

//-- zgtrfs --------------------------------------------------------------------
void
LAPACK_IMPL(zgtrfs)(const char               *TRANS,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *DL,
                    const DOUBLE_COMPLEX     *D,
                    const DOUBLE_COMPLEX     *DU,
                    const DOUBLE_COMPLEX     *DLF,
                    const DOUBLE_COMPLEX     *DF,
                    const DOUBLE_COMPLEX     *DUF,
                    const DOUBLE_COMPLEX     *DU2,
                    const INTEGER            *IPIV,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    DOUBLE_COMPLEX           *X,
                    const INTEGER            *LDX,
                    DOUBLE                   *FERR,
                    DOUBLE                   *BERR,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- zgtsv ---------------------------------------------------------------------
void
LAPACK_IMPL(zgtsv)(const INTEGER        *N,
                   const INTEGER        *NRHS,
                   DOUBLE_COMPLEX       *DL,
                   DOUBLE_COMPLEX       *D,
                   DOUBLE_COMPLEX       *DU,
                   DOUBLE_COMPLEX       *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- zgtsvx --------------------------------------------------------------------
void
LAPACK_IMPL(zgtsvx)(const char               *FACT,
                    const char               *TRANS,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *DL,
                    const DOUBLE_COMPLEX     *D,
                    const DOUBLE_COMPLEX     *DU,
                    DOUBLE_COMPLEX           *DLF,
                    DOUBLE_COMPLEX           *DF,
                    DOUBLE_COMPLEX           *DUF,
                    DOUBLE_COMPLEX           *DU2,
                    INTEGER                  *IPIV,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    DOUBLE_COMPLEX           *X,
                    const INTEGER            *LDX,
                    DOUBLE                   *RCOND,
                    DOUBLE                   *FERR,
                    DOUBLE                   *BERR,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- zgttrf --------------------------------------------------------------------
void
LAPACK_IMPL(zgttrf)(const INTEGER    *N,
                    DOUBLE_COMPLEX   *DL,
                    DOUBLE_COMPLEX   *D,
                    DOUBLE_COMPLEX   *DU,
                    DOUBLE_COMPLEX   *DU2,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- zgttrs --------------------------------------------------------------------
void
LAPACK_IMPL(zgttrs)(const char               *TRANS,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *DL,
                    const DOUBLE_COMPLEX     *D,
                    const DOUBLE_COMPLEX     *DU,
                    const DOUBLE_COMPLEX     *DU2,
                    const INTEGER            *IPIV,
                    DOUBLE_COMPLEX           *B,
                    const INTEGER            *LDB,
                    INTEGER                  *INFO);

//-- zgtts2 --------------------------------------------------------------------
void
LAPACK_IMPL(zgtts2)(const INTEGER            *ITRANS,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *DL,
                    const DOUBLE_COMPLEX     *D,
                    const DOUBLE_COMPLEX     *DU,
                    const DOUBLE_COMPLEX     *DU2,
                    const INTEGER            *IPIV,
                    DOUBLE_COMPLEX           *B,
                    const INTEGER            *LDB);

//-- zhbev ---------------------------------------------------------------------
void
LAPACK_IMPL(zhbev)(const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *KD,
                   DOUBLE_COMPLEX       *AB,
                   const INTEGER        *LDAB,
                   DOUBLE               *W,
                   DOUBLE_COMPLEX       *Z,
                   const INTEGER        *LDZ,
                   DOUBLE_COMPLEX       *WORK,
                   DOUBLE               *RWORK,
                   INTEGER              *INFO);

//-- zhbevd --------------------------------------------------------------------
void
LAPACK_IMPL(zhbevd)(const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    DOUBLE_COMPLEX   *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *W,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    DOUBLE           *RWORK,
                    const INTEGER    *LRWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- zhbevx --------------------------------------------------------------------
void
LAPACK_IMPL(zhbevx)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    DOUBLE_COMPLEX   *AB,
                    const INTEGER    *LDAB,
                    DOUBLE_COMPLEX   *Q,
                    const INTEGER    *LDQ,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    DOUBLE_COMPLEX   *WORK,
                    DOUBLE           *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- zhbgst --------------------------------------------------------------------
void
LAPACK_IMPL(zhbgst)(const char               *VECT,
                    const char               *UPLO,
                    const INTEGER            *N,
                    const INTEGER            *KA,
                    const INTEGER            *KB,
                    DOUBLE_COMPLEX           *AB,
                    const INTEGER            *LDAB,
                    const DOUBLE_COMPLEX     *BB,
                    const INTEGER            *LDBB,
                    DOUBLE_COMPLEX           *X,
                    const INTEGER            *LDX,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- zhbgv ---------------------------------------------------------------------
void
LAPACK_IMPL(zhbgv)(const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *KA,
                   const INTEGER        *KB,
                   DOUBLE_COMPLEX       *AB,
                   const INTEGER        *LDAB,
                   DOUBLE_COMPLEX       *BB,
                   const INTEGER        *LDBB,
                   DOUBLE               *W,
                   DOUBLE_COMPLEX       *Z,
                   const INTEGER        *LDZ,
                   DOUBLE_COMPLEX       *WORK,
                   DOUBLE               *RWORK,
                   INTEGER              *INFO);

//-- zhbgvd --------------------------------------------------------------------
void
LAPACK_IMPL(zhbgvd)(const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KA,
                    const INTEGER    *KB,
                    DOUBLE_COMPLEX   *AB,
                    const INTEGER    *LDAB,
                    DOUBLE_COMPLEX   *BB,
                    const INTEGER    *LDBB,
                    DOUBLE           *W,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    DOUBLE           *RWORK,
                    const INTEGER    *LRWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- zhbgvx --------------------------------------------------------------------
void
LAPACK_IMPL(zhbgvx)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KA,
                    const INTEGER    *KB,
                    DOUBLE_COMPLEX   *AB,
                    const INTEGER    *LDAB,
                    DOUBLE_COMPLEX   *BB,
                    const INTEGER    *LDBB,
                    DOUBLE_COMPLEX   *Q,
                    const INTEGER    *LDQ,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    DOUBLE_COMPLEX   *WORK,
                    DOUBLE           *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- zhbtrd --------------------------------------------------------------------
void
LAPACK_IMPL(zhbtrd)(const char       *VECT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    DOUBLE_COMPLEX   *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE_COMPLEX   *Q,
                    const INTEGER    *LDQ,
                    DOUBLE_COMPLEX   *WORK,
                    INTEGER          *INFO);

//-- zhecon --------------------------------------------------------------------
void
LAPACK_IMPL(zhecon)(const char               *UPLO,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    const INTEGER            *IPIV,
                    const DOUBLE             *ANORM,
                    DOUBLE                   *RCOND,
                    DOUBLE_COMPLEX           *WORK,
                    INTEGER                  *INFO);

//-- zheequb -------------------------------------------------------------------
void
LAPACK_IMPL(zheequb)(const char               *UPLO,
                     const INTEGER            *N,
                     const DOUBLE_COMPLEX     *A,
                     const INTEGER            *LDA,
                     DOUBLE                   *S,
                     DOUBLE                   *SCOND,
                     DOUBLE                   *AMAX,
                     const DOUBLE_COMPLEX     *WORK,
                     INTEGER                  *INFO);

//-- zheev ---------------------------------------------------------------------
void
LAPACK_IMPL(zheev)(const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   DOUBLE_COMPLEX       *A,
                   const INTEGER        *LDA,
                   DOUBLE               *W,
                   DOUBLE_COMPLEX       *WORK,
                   const INTEGER        *LWORK,
                   DOUBLE               *RWORK,
                   INTEGER              *INFO);

//-- zheevd --------------------------------------------------------------------
void
LAPACK_IMPL(zheevd)(const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE           *W,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    DOUBLE           *RWORK,
                    const INTEGER    *LRWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- zheevr --------------------------------------------------------------------
void
LAPACK_IMPL(zheevr)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *ISUPPZ,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    DOUBLE           *RWORK,
                    const INTEGER    *LRWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- zheevx --------------------------------------------------------------------
void
LAPACK_IMPL(zheevx)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    DOUBLE           *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- zhegs2 --------------------------------------------------------------------
void
LAPACK_IMPL(zhegs2)(const INTEGER            *ITYPE,
                    const char               *UPLO,
                    const INTEGER            *N,
                    DOUBLE_COMPLEX           *A,
                    const INTEGER            *LDA,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    INTEGER                  *INFO);

//-- zhegst --------------------------------------------------------------------
void
LAPACK_IMPL(zhegst)(const INTEGER            *ITYPE,
                    const char               *UPLO,
                    const INTEGER            *N,
                    DOUBLE_COMPLEX           *A,
                    const INTEGER            *LDA,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    INTEGER                  *INFO);

//-- zhegv ---------------------------------------------------------------------
void
LAPACK_IMPL(zhegv)(const INTEGER        *ITYPE,
                   const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   DOUBLE_COMPLEX       *A,
                   const INTEGER        *LDA,
                   DOUBLE_COMPLEX       *B,
                   const INTEGER        *LDB,
                   DOUBLE               *W,
                   DOUBLE_COMPLEX       *WORK,
                   const INTEGER        *LWORK,
                   DOUBLE               *RWORK,
                   INTEGER              *INFO);

//-- zhegvd --------------------------------------------------------------------
void
LAPACK_IMPL(zhegvd)(const INTEGER    *ITYPE,
                    const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB,
                    DOUBLE           *W,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    DOUBLE           *RWORK,
                    const INTEGER    *LRWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- zhegvx --------------------------------------------------------------------
void
LAPACK_IMPL(zhegvx)(const INTEGER    *ITYPE,
                    const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    DOUBLE           *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- zherfs --------------------------------------------------------------------
void
LAPACK_IMPL(zherfs)(const char               *UPLO,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    const DOUBLE_COMPLEX     *AF,
                    const INTEGER            *LDAF,
                    const INTEGER            *IPIV,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    DOUBLE_COMPLEX           *X,
                    const INTEGER            *LDX,
                    DOUBLE                   *FERR,
                    DOUBLE                   *BERR,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- zherfsx -------------------------------------------------------------------
void
LAPACK_IMPL(zherfsx)(const char               *UPLO,
                     const char               *EQUED,
                     const INTEGER            *N,
                     const INTEGER            *NRHS,
                     const DOUBLE_COMPLEX     *A,
                     const INTEGER            *LDA,
                     const DOUBLE_COMPLEX     *AF,
                     const INTEGER            *LDAF,
                     const INTEGER            *IPIV,
                     DOUBLE                   *S,
                     const DOUBLE_COMPLEX     *B,
                     const INTEGER            *LDB,
                     DOUBLE_COMPLEX           *X,
                     const INTEGER            *LDX,
                     DOUBLE                   *RCOND,
                     DOUBLE                   *BERR,
                     const INTEGER            *N_ERR_BNDS,
                     DOUBLE                   *ERR_BNDS_NORM,
                     DOUBLE                   *ERR_BNDS_COMP,
                     const INTEGER            *NPARAMS,
                     DOUBLE                   *PARAMS,
                     DOUBLE_COMPLEX           *WORK,
                     DOUBLE                   *RWORK,
                     INTEGER                  *INFO);

//-- zhesv ---------------------------------------------------------------------
void
LAPACK_IMPL(zhesv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   DOUBLE_COMPLEX       *A,
                   const INTEGER        *LDA,
                   INTEGER              *IPIV,
                   DOUBLE_COMPLEX       *B,
                   const INTEGER        *LDB,
                   DOUBLE_COMPLEX       *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO);

//-- zhesvx --------------------------------------------------------------------
void
LAPACK_IMPL(zhesvx)(const char               *FACT,
                    const char               *UPLO,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    DOUBLE_COMPLEX           *AF,
                    const INTEGER            *LDAF,
                    INTEGER                  *IPIV,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    DOUBLE_COMPLEX           *X,
                    const INTEGER            *LDX,
                    DOUBLE                   *RCOND,
                    DOUBLE                   *FERR,
                    DOUBLE                   *BERR,
                    DOUBLE_COMPLEX           *WORK,
                    const INTEGER            *LWORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- zhesvxx -------------------------------------------------------------------
void
LAPACK_IMPL(zhesvxx)(const char       *FACT,
                     const char       *UPLO,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     DOUBLE_COMPLEX   *A,
                     const INTEGER    *LDA,
                     DOUBLE_COMPLEX   *AF,
                     const INTEGER    *LDAF,
                     INTEGER          *IPIV,
                     char             *EQUED,
                     DOUBLE           *S,
                     DOUBLE_COMPLEX   *B,
                     const INTEGER    *LDB,
                     DOUBLE_COMPLEX   *X,
                     const INTEGER    *LDX,
                     DOUBLE           *RCOND,
                     DOUBLE           *RPVGRW,
                     DOUBLE           *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     DOUBLE           *ERR_BNDS_NORM,
                     DOUBLE           *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     DOUBLE           *PARAMS,
                     DOUBLE_COMPLEX   *WORK,
                     DOUBLE           *RWORK,
                     INTEGER          *INFO);

//-- zheswapr ------------------------------------------------------------------
void
LAPACK_IMPL(zheswapr)(const char           *UPLO,
                      const INTEGER        *N,
                      DOUBLE_COMPLEX       *A,
                      const INTEGER        *LDA,
                      const INTEGER        *I1,
                      const INTEGER        *I2);

//-- zhetd2 --------------------------------------------------------------------
void
LAPACK_IMPL(zhetd2)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE_COMPLEX   *TAU,
                    INTEGER          *INFO);

//-- zhetf2 --------------------------------------------------------------------
void
LAPACK_IMPL(zhetf2)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- zhetrd --------------------------------------------------------------------
void
LAPACK_IMPL(zhetrd)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE_COMPLEX   *TAU,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- zhetrf --------------------------------------------------------------------
void
LAPACK_IMPL(zhetrf)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- zhetri --------------------------------------------------------------------
void
LAPACK_IMPL(zhetri)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    const INTEGER    *IPIV,
                    DOUBLE_COMPLEX   *WORK,
                    INTEGER          *INFO);

//-- zhetri2 -------------------------------------------------------------------
void
LAPACK_IMPL(zhetri2)(const char       *UPLO,
                     const INTEGER    *N,
                     DOUBLE_COMPLEX   *A,
                     const INTEGER    *LDA,
                     const INTEGER    *IPIV,
                     DOUBLE_COMPLEX   *WORK,
                     const INTEGER    *LWORK,
                     INTEGER          *INFO);

//-- zhetri2x ------------------------------------------------------------------
void
LAPACK_IMPL(zhetri2x)(const char           *UPLO,
                      const INTEGER        *N,
                      DOUBLE_COMPLEX       *A,
                      const INTEGER        *LDA,
                      const INTEGER        *IPIV,
                      DOUBLE_COMPLEX       *WORK,
                      const INTEGER        *NB,
                      INTEGER              *INFO);

//-- zhetrs --------------------------------------------------------------------
void
LAPACK_IMPL(zhetrs)(const char               *UPLO,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    const INTEGER            *IPIV,
                    DOUBLE_COMPLEX           *B,
                    const INTEGER            *LDB,
                    INTEGER                  *INFO);

//-- zhetrs2 -------------------------------------------------------------------
void
LAPACK_IMPL(zhetrs2)(const char         *UPLO,
                     const INTEGER      *N,
                     const INTEGER      *NRHS,
                     DOUBLE_COMPLEX     *A,
                     const INTEGER      *LDA,
                     const INTEGER      *IPIV,
                     DOUBLE_COMPLEX     *B,
                     const INTEGER      *LDB,
                     DOUBLE_COMPLEX     *WORK,
                     INTEGER            *INFO);

//-- zhfrk ---------------------------------------------------------------------
void
LAPACK_IMPL(zhfrk)(const char               *TRANSR,
                   const char               *UPLO,
                   const char               *TRANS,
                   const INTEGER            *N,
                   const INTEGER            *K,
                   const DOUBLE             *ALPHA,
                   const DOUBLE_COMPLEX     *A,
                   const INTEGER            *LDA,
                   const DOUBLE             *BETA,
                   DOUBLE_COMPLEX           *C);

//-- zhgeqz --------------------------------------------------------------------
void
LAPACK_IMPL(zhgeqz)(const char       *JOB,
                    const char       *COMPQ,
                    const char       *COMPZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    DOUBLE_COMPLEX   *H,
                    const INTEGER    *LDH,
                    DOUBLE_COMPLEX   *T,
                    const INTEGER    *LDT,
                    DOUBLE_COMPLEX   *ALPHA,
                    DOUBLE_COMPLEX   *BETA,
                    DOUBLE_COMPLEX   *Q,
                    const INTEGER    *LDQ,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    DOUBLE           *RWORK,
                    INTEGER          *INFO);

//-- zhpcon --------------------------------------------------------------------
void
LAPACK_IMPL(zhpcon)(const char               *UPLO,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *AP,
                    const INTEGER            *IPIV,
                    const DOUBLE             *ANORM,
                    DOUBLE                   *RCOND,
                    DOUBLE_COMPLEX           *WORK,
                    INTEGER                  *INFO);

//-- zhpev ---------------------------------------------------------------------
void
LAPACK_IMPL(zhpev)(const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   DOUBLE_COMPLEX       *AP,
                   DOUBLE               *W,
                   DOUBLE_COMPLEX       *Z,
                   const INTEGER        *LDZ,
                   DOUBLE_COMPLEX       *WORK,
                   DOUBLE               *RWORK,
                   INTEGER              *INFO);

//-- zhpevd --------------------------------------------------------------------
void
LAPACK_IMPL(zhpevd)(const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *AP,
                    DOUBLE           *W,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    DOUBLE           *RWORK,
                    const INTEGER    *LRWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- zhpevx --------------------------------------------------------------------
void
LAPACK_IMPL(zhpevx)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *AP,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    DOUBLE_COMPLEX   *WORK,
                    DOUBLE           *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- zhpgst --------------------------------------------------------------------
void
LAPACK_IMPL(zhpgst)(const INTEGER            *ITYPE,
                    const char               *UPLO,
                    const INTEGER            *N,
                    DOUBLE_COMPLEX           *AP,
                    const DOUBLE_COMPLEX     *BP,
                    INTEGER                  *INFO);

//-- zhpgv ---------------------------------------------------------------------
void
LAPACK_IMPL(zhpgv)(const INTEGER        *ITYPE,
                   const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   DOUBLE_COMPLEX       *AP,
                   DOUBLE_COMPLEX       *BP,
                   DOUBLE               *W,
                   DOUBLE_COMPLEX       *Z,
                   const INTEGER        *LDZ,
                   DOUBLE_COMPLEX       *WORK,
                   DOUBLE               *RWORK,
                   INTEGER              *INFO);

//-- zhpgvd --------------------------------------------------------------------
void
LAPACK_IMPL(zhpgvd)(const INTEGER    *ITYPE,
                    const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *AP,
                    DOUBLE_COMPLEX   *BP,
                    DOUBLE           *W,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    DOUBLE           *RWORK,
                    const INTEGER    *LRWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- zhpgvx --------------------------------------------------------------------
void
LAPACK_IMPL(zhpgvx)(const INTEGER    *ITYPE,
                    const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *AP,
                    DOUBLE_COMPLEX   *BP,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    DOUBLE_COMPLEX   *WORK,
                    DOUBLE           *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- zhprfs --------------------------------------------------------------------
void
LAPACK_IMPL(zhprfs)(const char               *UPLO,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *AP,
                    const DOUBLE_COMPLEX     *AFP,
                    const INTEGER            *IPIV,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    DOUBLE_COMPLEX           *X,
                    const INTEGER            *LDX,
                    DOUBLE                   *FERR,
                    DOUBLE                   *BERR,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- zhpsv ---------------------------------------------------------------------
void
LAPACK_IMPL(zhpsv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   DOUBLE_COMPLEX       *AP,
                   INTEGER              *IPIV,
                   DOUBLE_COMPLEX       *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- zhpsvx --------------------------------------------------------------------
void
LAPACK_IMPL(zhpsvx)(const char               *FACT,
                    const char               *UPLO,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *AP,
                    DOUBLE_COMPLEX           *AFP,
                    INTEGER                  *IPIV,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    DOUBLE_COMPLEX           *X,
                    const INTEGER            *LDX,
                    DOUBLE                   *RCOND,
                    DOUBLE                   *FERR,
                    DOUBLE                   *BERR,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- zhptrd --------------------------------------------------------------------
void
LAPACK_IMPL(zhptrd)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *AP,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE_COMPLEX   *TAU,
                    INTEGER          *INFO);

//-- zhptrf --------------------------------------------------------------------
void
LAPACK_IMPL(zhptrf)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *AP,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- zhptri --------------------------------------------------------------------
void
LAPACK_IMPL(zhptri)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *AP,
                    const INTEGER    *IPIV,
                    DOUBLE_COMPLEX   *WORK,
                    INTEGER          *INFO);

//-- zhptrs --------------------------------------------------------------------
void
LAPACK_IMPL(zhptrs)(const char               *UPLO,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *AP,
                    const INTEGER            *IPIV,
                    DOUBLE_COMPLEX           *B,
                    const INTEGER            *LDB,
                    INTEGER                  *INFO);

//-- zhsein --------------------------------------------------------------------
void
LAPACK_IMPL(zhsein)(const char               *SIDE,
                    const char               *EIGSRC,
                    const char               *INITV,
                    const LOGICAL            *SELECT,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *H,
                    const INTEGER            *LDH,
                    DOUBLE_COMPLEX           *W,
                    DOUBLE_COMPLEX           *VL,
                    const INTEGER            *LDVL,
                    DOUBLE_COMPLEX           *VR,
                    const INTEGER            *LDVR,
                    const INTEGER            *MM,
                    INTEGER                  *M,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *IFAILL,
                    INTEGER                  *IFAILR,
                    INTEGER                  *INFO);

//-- zhseqr --------------------------------------------------------------------
void
LAPACK_IMPL(zhseqr)(const char       *JOB,
                    const char       *COMPZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    DOUBLE_COMPLEX   *H,
                    const INTEGER    *LDH,
                    DOUBLE_COMPLEX   *W,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- zla_gbamv -----------------------------------------------------------------
void
LAPACK_IMPL(zla_gbamv)(const INTEGER            *TRANS,
                       const INTEGER            *M,
                       const INTEGER            *N,
                       const INTEGER            *KL,
                       const INTEGER            *KU,
                       const DOUBLE             *ALPHA,
                       const DOUBLE_COMPLEX     *AB,
                       const INTEGER            *LDAB,
                       const DOUBLE_COMPLEX     *X,
                       const INTEGER            *INCX,
                       const DOUBLE             *BETA,
                       DOUBLE                   *Y,
                       const INTEGER            *INCY);

//-- zla_gbrcond_c -------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zla_gbrcond_c)(const char               *TRANS,
                           const INTEGER            *N,
                           const INTEGER            *KL,
                           const INTEGER            *KU,
                           const DOUBLE_COMPLEX     *AB,
                           const INTEGER            *LDAB,
                           const DOUBLE_COMPLEX     *AFB,
                           const INTEGER            *LDAFB,
                           const INTEGER            *IPIV,
                           const DOUBLE             *C,
                           const LOGICAL            *CAPPLY,
                           INTEGER                  *INFO,
                           const DOUBLE_COMPLEX     *WORK,
                           const DOUBLE             *RWORK);

//-- zla_gbrcond_x -------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zla_gbrcond_x)(const char               *TRANS,
                           const INTEGER            *N,
                           const INTEGER            *KL,
                           const INTEGER            *KU,
                           const DOUBLE_COMPLEX     *AB,
                           const INTEGER            *LDAB,
                           const DOUBLE_COMPLEX     *AFB,
                           const INTEGER            *LDAFB,
                           const INTEGER            *IPIV,
                           const DOUBLE_COMPLEX     *X,
                           INTEGER                  *INFO,
                           const DOUBLE_COMPLEX     *WORK,
                           const DOUBLE             *RWORK);

//-- zla_gbrfsx_extended -------------------------------------------------------
void
LAPACK_IMPL(zla_gbrfsx_extended)(const INTEGER            *PREC_TYPE,
                                 const INTEGER            *TRANS_TYPE,
                                 const INTEGER            *N,
                                 const INTEGER            *KL,
                                 const INTEGER            *KU,
                                 const INTEGER            *NRHS,
                                 const DOUBLE_COMPLEX     *AB,
                                 const INTEGER            *LDAB,
                                 const DOUBLE_COMPLEX     *AFB,
                                 const INTEGER            *LDAFB,
                                 const INTEGER            *IPIV,
                                 const LOGICAL            *COLEQU,
                                 const DOUBLE             *C,
                                 const DOUBLE_COMPLEX     *B,
                                 const INTEGER            *LDB,
                                 DOUBLE_COMPLEX           *Y,
                                 const INTEGER            *LDY,
                                 DOUBLE                   *BERR_OUT,
                                 const INTEGER            *N_NORMS,
                                 DOUBLE                   *ERR_BNDS_NORM,
                                 DOUBLE                   *ERR_BNDS_COMP,
                                 const DOUBLE_COMPLEX     *RES,
                                 const DOUBLE             *AYB,
                                 const DOUBLE_COMPLEX     *DY,
                                 const DOUBLE_COMPLEX     *Y_TAIL,
                                 const DOUBLE             *RCOND,
                                 const INTEGER            *ITHRESH,
                                 const DOUBLE             *RTHRESH,
                                 const DOUBLE             *DZ_UB,
                                 const LOGICAL            *IGNORE_CWISE,
                                 INTEGER                  *INFO);

//-- zla_gbrpvgrw --------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zla_gbrpvgrw)(const INTEGER            *N,
                          const INTEGER            *KL,
                          const INTEGER            *KU,
                          const INTEGER            *NCOLS,
                          const DOUBLE_COMPLEX     *AB,
                          const INTEGER            *LDAB,
                          const DOUBLE_COMPLEX     *AFB,
                          const INTEGER            *LDAFB);

//-- zla_geamv -----------------------------------------------------------------
void
LAPACK_IMPL(zla_geamv)(const INTEGER            *TRANS,
                       const INTEGER            *M,
                       const INTEGER            *N,
                       const DOUBLE             *ALPHA,
                       const DOUBLE_COMPLEX     *A,
                       const INTEGER            *LDA,
                       const DOUBLE_COMPLEX     *X,
                       const INTEGER            *INCX,
                       const DOUBLE             *BETA,
                       DOUBLE                   *Y,
                       const INTEGER            *INCY);

//-- zla_gercond_c -------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zla_gercond_c)(const char               *TRANS,
                           const INTEGER            *N,
                           const DOUBLE_COMPLEX     *A,
                           const INTEGER            *LDA,
                           const DOUBLE_COMPLEX     *AF,
                           const INTEGER            *LDAF,
                           const INTEGER            *IPIV,
                           const DOUBLE             *C,
                           const LOGICAL            *CAPPLY,
                           INTEGER                  *INFO,
                           const DOUBLE_COMPLEX     *WORK,
                           const DOUBLE             *RWORK);

//-- zla_gercond_x -------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zla_gercond_x)(const char               *TRANS,
                           const INTEGER            *N,
                           const DOUBLE_COMPLEX     *A,
                           const INTEGER            *LDA,
                           const DOUBLE_COMPLEX     *AF,
                           const INTEGER            *LDAF,
                           const INTEGER            *IPIV,
                           const DOUBLE_COMPLEX     *X,
                           INTEGER                  *INFO,
                           const DOUBLE_COMPLEX     *WORK,
                           const DOUBLE             *RWORK);

//-- zla_gerfsx_extended -------------------------------------------------------
void
LAPACK_IMPL(zla_gerfsx_extended)(const INTEGER            *PREC_TYPE,
                                 const INTEGER            *TRANS_TYPE,
                                 const INTEGER            *N,
                                 const INTEGER            *NRHS,
                                 const DOUBLE_COMPLEX     *A,
                                 const INTEGER            *LDA,
                                 const DOUBLE_COMPLEX     *AF,
                                 const INTEGER            *LDAF,
                                 const INTEGER            *IPIV,
                                 const LOGICAL            *COLEQU,
                                 const DOUBLE             *C,
                                 const DOUBLE_COMPLEX     *B,
                                 const INTEGER            *LDB,
                                 DOUBLE_COMPLEX           *Y,
                                 const INTEGER            *LDY,
                                 DOUBLE                   *BERR_OUT,
                                 const INTEGER            *N_NORMS,
                                 const DOUBLE             *ERRS_N,
                                 const DOUBLE             *ERRS_C,
                                 const DOUBLE_COMPLEX     *RES,
                                 const DOUBLE             *AYB,
                                 const DOUBLE_COMPLEX     *DY,
                                 const DOUBLE_COMPLEX     *Y_TAIL,
                                 const DOUBLE             *RCOND,
                                 const INTEGER            *ITHRESH,
                                 const DOUBLE             *RTHRESH,
                                 const DOUBLE             *DZ_UB,
                                 const LOGICAL            *IGNORE_CWISE,
                                 INTEGER                  *INFO);

//-- zla_heamv -----------------------------------------------------------------
void
LAPACK_IMPL(zla_heamv)(const INTEGER            *UPLO,
                       const INTEGER            *N,
                       const DOUBLE             *ALPHA,
                       const DOUBLE_COMPLEX     *A,
                       const INTEGER            *LDA,
                       const DOUBLE_COMPLEX     *X,
                       const INTEGER            *INCX,
                       const DOUBLE             *BETA,
                       DOUBLE                   *Y,
                       const INTEGER            *INCY);

//-- zla_hercond_c -------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zla_hercond_c)(const char               *UPLO,
                           const INTEGER            *N,
                           const DOUBLE_COMPLEX     *A,
                           const INTEGER            *LDA,
                           const DOUBLE_COMPLEX     *AF,
                           const INTEGER            *LDAF,
                           const INTEGER            *IPIV,
                           const DOUBLE             *C,
                           const LOGICAL            *CAPPLY,
                           INTEGER                  *INFO,
                           const DOUBLE_COMPLEX     *WORK,
                           const DOUBLE             *RWORK);

//-- zla_hercond_x -------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zla_hercond_x)(const char               *UPLO,
                           const INTEGER            *N,
                           const DOUBLE_COMPLEX     *A,
                           const INTEGER            *LDA,
                           const DOUBLE_COMPLEX     *AF,
                           const INTEGER            *LDAF,
                           const INTEGER            *IPIV,
                           const DOUBLE_COMPLEX     *X,
                           INTEGER                  *INFO,
                           const DOUBLE_COMPLEX     *WORK,
                           const DOUBLE             *RWORK);

//-- zla_herfsx_extended -------------------------------------------------------
void
LAPACK_IMPL(zla_herfsx_extended)(const INTEGER            *PREC_TYPE,
                                 const char               *UPLO,
                                 const INTEGER            *N,
                                 const INTEGER            *NRHS,
                                 const DOUBLE_COMPLEX     *A,
                                 const INTEGER            *LDA,
                                 const DOUBLE_COMPLEX     *AF,
                                 const INTEGER            *LDAF,
                                 const INTEGER            *IPIV,
                                 const LOGICAL            *COLEQU,
                                 const DOUBLE             *C,
                                 const DOUBLE_COMPLEX     *B,
                                 const INTEGER            *LDB,
                                 DOUBLE_COMPLEX           *Y,
                                 const INTEGER            *LDY,
                                 DOUBLE                   *BERR_OUT,
                                 const INTEGER            *N_NORMS,
                                 DOUBLE                   *ERR_BNDS_NORM,
                                 DOUBLE                   *ERR_BNDS_COMP,
                                 const DOUBLE_COMPLEX     *RES,
                                 const DOUBLE             *AYB,
                                 const DOUBLE_COMPLEX     *DY,
                                 const DOUBLE_COMPLEX     *Y_TAIL,
                                 const DOUBLE             *RCOND,
                                 const INTEGER            *ITHRESH,
                                 const DOUBLE             *RTHRESH,
                                 const DOUBLE             *DZ_UB,
                                 const LOGICAL            *IGNORE_CWISE,
                                 INTEGER                  *INFO);

//-- zla_herpvgrw --------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zla_herpvgrw)(const char               *UPLO,
                          const INTEGER            *N,
                          const INTEGER            *INFO,
                          const DOUBLE_COMPLEX     *A,
                          const INTEGER            *LDA,
                          const DOUBLE_COMPLEX     *AF,
                          const INTEGER            *LDAF,
                          const INTEGER            *IPIV,
                          const DOUBLE             *WORK);

//-- zla_lin_berr --------------------------------------------------------------
void
LAPACK_IMPL(zla_lin_berr)(const INTEGER            *N,
                          const INTEGER            *NZ,
                          const INTEGER            *NRHS,
                          const DOUBLE_COMPLEX     *RES,
                          const DOUBLE             *AYB,
                          DOUBLE                   *BERR);

//-- zla_porcond_c -------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zla_porcond_c)(const char               *UPLO,
                           const INTEGER            *N,
                           const DOUBLE_COMPLEX     *A,
                           const INTEGER            *LDA,
                           const DOUBLE_COMPLEX     *AF,
                           const INTEGER            *LDAF,
                           const DOUBLE             *C,
                           const LOGICAL            *CAPPLY,
                           INTEGER                  *INFO,
                           const DOUBLE_COMPLEX     *WORK,
                           const DOUBLE             *RWORK);

//-- zla_porcond_x -------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zla_porcond_x)(const char               *UPLO,
                           const INTEGER            *N,
                           const DOUBLE_COMPLEX     *A,
                           const INTEGER            *LDA,
                           const DOUBLE_COMPLEX     *AF,
                           const INTEGER            *LDAF,
                           const DOUBLE_COMPLEX     *X,
                           INTEGER                  *INFO,
                           const DOUBLE_COMPLEX     *WORK,
                           const DOUBLE             *RWORK);

//-- zla_porfsx_extended -------------------------------------------------------
void
LAPACK_IMPL(zla_porfsx_extended)(const INTEGER            *PREC_TYPE,
                                 const char               *UPLO,
                                 const INTEGER            *N,
                                 const INTEGER            *NRHS,
                                 const DOUBLE_COMPLEX     *A,
                                 const INTEGER            *LDA,
                                 const DOUBLE_COMPLEX     *AF,
                                 const INTEGER            *LDAF,
                                 const LOGICAL            *COLEQU,
                                 const DOUBLE             *C,
                                 const DOUBLE_COMPLEX     *B,
                                 const INTEGER            *LDB,
                                 DOUBLE_COMPLEX           *Y,
                                 const INTEGER            *LDY,
                                 DOUBLE                   *BERR_OUT,
                                 const INTEGER            *N_NORMS,
                                 DOUBLE                   *ERR_BNDS_NORM,
                                 DOUBLE                   *ERR_BNDS_COMP,
                                 const DOUBLE_COMPLEX     *RES,
                                 const DOUBLE             *AYB,
                                 const DOUBLE_COMPLEX     *DY,
                                 const DOUBLE_COMPLEX     *Y_TAIL,
                                 const DOUBLE             *RCOND,
                                 const INTEGER            *ITHRESH,
                                 const DOUBLE             *RTHRESH,
                                 const DOUBLE             *DZ_UB,
                                 const LOGICAL            *IGNORE_CWISE,
                                 INTEGER                  *INFO);

//-- zla_porpvgrw --------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zla_porpvgrw)(const char               *UPLO,
                          const INTEGER            *NCOLS,
                          const DOUBLE_COMPLEX     *A,
                          const INTEGER            *LDA,
                          const DOUBLE_COMPLEX     *AF,
                          const INTEGER            *LDAF,
                          const DOUBLE             *WORK);

//-- zla_rpvgrw ----------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zla_rpvgrw)(const INTEGER            *N,
                        const INTEGER            *NCOLS,
                        const DOUBLE_COMPLEX     *A,
                        const INTEGER            *LDA,
                        const DOUBLE_COMPLEX     *AF,
                        const INTEGER            *LDAF);

//-- zla_syamv -----------------------------------------------------------------
void
LAPACK_IMPL(zla_syamv)(const INTEGER            *UPLO,
                       const INTEGER            *N,
                       const DOUBLE             *ALPHA,
                       const DOUBLE_COMPLEX     *A,
                       const INTEGER            *LDA,
                       const DOUBLE_COMPLEX     *X,
                       const INTEGER            *INCX,
                       const DOUBLE             *BETA,
                       DOUBLE                   *Y,
                       const INTEGER            *INCY);

//-- zla_syrcond_c -------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zla_syrcond_c)(const char               *UPLO,
                           const INTEGER            *N,
                           const DOUBLE_COMPLEX     *A,
                           const INTEGER            *LDA,
                           const DOUBLE_COMPLEX     *AF,
                           const INTEGER            *LDAF,
                           const INTEGER            *IPIV,
                           const DOUBLE             *C,
                           const LOGICAL            *CAPPLY,
                           INTEGER                  *INFO,
                           const DOUBLE_COMPLEX     *WORK,
                           const DOUBLE             *RWORK);

//-- zla_syrcond_x -------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zla_syrcond_x)(const char               *UPLO,
                           const INTEGER            *N,
                           const DOUBLE_COMPLEX     *A,
                           const INTEGER            *LDA,
                           const DOUBLE_COMPLEX     *AF,
                           const INTEGER            *LDAF,
                           const INTEGER            *IPIV,
                           const DOUBLE_COMPLEX     *X,
                           INTEGER                  *INFO,
                           const DOUBLE_COMPLEX     *WORK,
                           const DOUBLE             *RWORK);

//-- zla_syrfsx_extended -------------------------------------------------------
void
LAPACK_IMPL(zla_syrfsx_extended)(const INTEGER            *PREC_TYPE,
                                 const char               *UPLO,
                                 const INTEGER            *N,
                                 const INTEGER            *NRHS,
                                 const DOUBLE_COMPLEX     *A,
                                 const INTEGER            *LDA,
                                 const DOUBLE_COMPLEX     *AF,
                                 const INTEGER            *LDAF,
                                 const INTEGER            *IPIV,
                                 const LOGICAL            *COLEQU,
                                 const DOUBLE             *C,
                                 const DOUBLE_COMPLEX     *B,
                                 const INTEGER            *LDB,
                                 DOUBLE_COMPLEX           *Y,
                                 const INTEGER            *LDY,
                                 DOUBLE                   *BERR_OUT,
                                 const INTEGER            *N_NORMS,
                                 DOUBLE                   *ERR_BNDS_NORM,
                                 DOUBLE                   *ERR_BNDS_COMP,
                                 const DOUBLE_COMPLEX     *RES,
                                 const DOUBLE             *AYB,
                                 const DOUBLE_COMPLEX     *DY,
                                 const DOUBLE_COMPLEX     *Y_TAIL,
                                 const DOUBLE             *RCOND,
                                 const INTEGER            *ITHRESH,
                                 const DOUBLE             *RTHRESH,
                                 const DOUBLE             *DZ_UB,
                                 const LOGICAL            *IGNORE_CWISE,
                                 INTEGER                  *INFO);

//-- zla_syrpvgrw --------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zla_syrpvgrw)(const char               *UPLO,
                          const INTEGER            *N,
                          const INTEGER            *INFO,
                          const DOUBLE_COMPLEX     *A,
                          const INTEGER            *LDA,
                          const DOUBLE_COMPLEX     *AF,
                          const INTEGER            *LDAF,
                          const INTEGER            *IPIV,
                          const DOUBLE             *WORK);

//-- zla_wwaddw ----------------------------------------------------------------
void
LAPACK_IMPL(zla_wwaddw)(const INTEGER            *N,
                        DOUBLE_COMPLEX           *X,
                        DOUBLE_COMPLEX           *Y,
                        const DOUBLE_COMPLEX     *W);

//-- zlabrd --------------------------------------------------------------------
void
LAPACK_IMPL(zlabrd)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NB,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE_COMPLEX   *TAUQ,
                    DOUBLE_COMPLEX   *TAUP,
                    DOUBLE_COMPLEX   *X,
                    const INTEGER    *LDX,
                    DOUBLE_COMPLEX   *Y,
                    const INTEGER    *LDY);

//-- zlacgv --------------------------------------------------------------------
void
LAPACK_IMPL(zlacgv)(const INTEGER    *N,
                    DOUBLE_COMPLEX   *X,
                    const INTEGER    *INCX);

//-- zlacn2 --------------------------------------------------------------------
void
LAPACK_IMPL(zlacn2)(const INTEGER    *N,
                    DOUBLE_COMPLEX   *V,
                    DOUBLE_COMPLEX   *X,
                    DOUBLE           *EST,
                    INTEGER          *KASE,
                    INTEGER          *ISAVE);

//-- zlacon --------------------------------------------------------------------
void
LAPACK_IMPL(zlacon)(const INTEGER    *N,
                    DOUBLE_COMPLEX   *V,
                    DOUBLE_COMPLEX   *X,
                    DOUBLE           *EST,
                    INTEGER          *KASE);

//-- zlacp2 --------------------------------------------------------------------
void
LAPACK_IMPL(zlacp2)(const char       *UPLO,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB);

//-- zlacpy --------------------------------------------------------------------
void
LAPACK_IMPL(zlacpy)(const char               *UPLO,
                    const INTEGER            *M,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    DOUBLE_COMPLEX           *B,
                    const INTEGER            *LDB);

//-- zlacrm --------------------------------------------------------------------
void
LAPACK_IMPL(zlacrm)(const INTEGER            *M,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    const DOUBLE             *B,
                    const INTEGER            *LDB,
                    const DOUBLE_COMPLEX     *C,
                    const INTEGER            *LDC,
                    DOUBLE                   *RWORK);

//-- zlacrt --------------------------------------------------------------------
void
LAPACK_IMPL(zlacrt)(const INTEGER            *N,
                    DOUBLE_COMPLEX           *CX,
                    const INTEGER            *INCX,
                    DOUBLE_COMPLEX           *CY,
                    const INTEGER            *INCY,
                    const DOUBLE_COMPLEX     *C,
                    const DOUBLE_COMPLEX     *S);

//-- zladiv --------------------------------------------------------------------
DOUBLE_COMPLEX
LAPACK_IMPL(zladiv)(const DOUBLE_COMPLEX     *X,
                    const DOUBLE_COMPLEX     *Y);

//-- zlaed0 --------------------------------------------------------------------
void
LAPACK_IMPL(zlaed0)(const INTEGER    *QSIZ,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE_COMPLEX   *Q,
                    const INTEGER    *LDQ,
                    DOUBLE_COMPLEX   *QSTORE,
                    const INTEGER    *LDQS,
                    DOUBLE           *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- zlaed7 --------------------------------------------------------------------
void
LAPACK_IMPL(zlaed7)(const INTEGER    *N,
                    const INTEGER    *CUTPNT,
                    const INTEGER    *QSIZ,
                    const INTEGER    *TLVLS,
                    const INTEGER    *CURLVL,
                    const INTEGER    *CURPBM,
                    DOUBLE           *D,
                    DOUBLE_COMPLEX   *Q,
                    const INTEGER    *LDQ,
                    const DOUBLE     *RHO,
                    INTEGER          *INDXQ,
                    DOUBLE           *QSTORE,
                    INTEGER          *QPTR,
                    const INTEGER    *PRMPTR,
                    const INTEGER    *PERM,
                    const INTEGER    *GIVPTR,
                    const INTEGER    *GIVCOL,
                    const DOUBLE     *GIVNUM,
                    DOUBLE_COMPLEX   *WORK,
                    DOUBLE           *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- zlaed8 --------------------------------------------------------------------
void
LAPACK_IMPL(zlaed8)(INTEGER          *K,
                    const INTEGER    *N,
                    const INTEGER    *QSIZ,
                    DOUBLE_COMPLEX   *Q,
                    const INTEGER    *LDQ,
                    DOUBLE           *D,
                    DOUBLE           *RHO,
                    const INTEGER    *CUTPNT,
                    const DOUBLE     *Z,
                    DOUBLE           *DLAMDA,
                    DOUBLE_COMPLEX   *Q2,
                    const INTEGER    *LDQ2,
                    DOUBLE           *W,
                    INTEGER          *INDXP,
                    INTEGER          *INDX,
                    const INTEGER    *INDXQ,
                    INTEGER          *PERM,
                    INTEGER          *GIVPTR,
                    INTEGER          *GIVCOL,
                    DOUBLE           *GIVNUM,
                    INTEGER          *INFO);

//-- zlaein --------------------------------------------------------------------
void
LAPACK_IMPL(zlaein)(const LOGICAL            *RIGHTV,
                    const LOGICAL            *NOINIT,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *H,
                    const INTEGER            *LDH,
                    const DOUBLE_COMPLEX     *W,
                    DOUBLE_COMPLEX           *V,
                    DOUBLE_COMPLEX           *B,
                    const INTEGER            *LDB,
                    DOUBLE                   *RWORK,
                    const DOUBLE             *EPS3,
                    const DOUBLE             *SMLNUM,
                    INTEGER                  *INFO);

//-- zlaesy --------------------------------------------------------------------
void
LAPACK_IMPL(zlaesy)(const DOUBLE_COMPLEX     *A,
                    const DOUBLE_COMPLEX     *B,
                    const DOUBLE_COMPLEX     *C,
                    DOUBLE_COMPLEX           *RT1,
                    DOUBLE_COMPLEX           *RT2,
                    DOUBLE_COMPLEX           *EVSCAL,
                    DOUBLE_COMPLEX           *CS1,
                    DOUBLE_COMPLEX           *SN1);

//-- zlaev2 --------------------------------------------------------------------
void
LAPACK_IMPL(zlaev2)(const DOUBLE_COMPLEX     *A,
                    const DOUBLE_COMPLEX     *B,
                    const DOUBLE_COMPLEX     *C,
                    DOUBLE                   *RT1,
                    DOUBLE                   *RT2,
                    DOUBLE                   *CS1,
                    DOUBLE_COMPLEX           *SN1);

//-- zlag2c --------------------------------------------------------------------
void
LAPACK_IMPL(zlag2c)(const INTEGER            *M,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    FLOAT_COMPLEX            *SA,
                    const INTEGER            *LDSA,
                    INTEGER                  *INFO);

//-- zlags2 --------------------------------------------------------------------
void
LAPACK_IMPL(zlags2)(const LOGICAL            *UPPER,
                    const DOUBLE             *A1,
                    const DOUBLE_COMPLEX     *A2,
                    const DOUBLE             *A3,
                    const DOUBLE             *B1,
                    const DOUBLE_COMPLEX     *B2,
                    const DOUBLE             *B3,
                    DOUBLE                   *CSU,
                    DOUBLE_COMPLEX           *SNU,
                    DOUBLE                   *CSV,
                    DOUBLE_COMPLEX           *SNV,
                    DOUBLE                   *CSQ,
                    DOUBLE_COMPLEX           *SNQ);

//-- zlagtm --------------------------------------------------------------------
void
LAPACK_IMPL(zlagtm)(const char               *TRANS,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE             *ALPHA,
                    const DOUBLE_COMPLEX     *DL,
                    const DOUBLE_COMPLEX     *D,
                    const DOUBLE_COMPLEX     *DU,
                    const DOUBLE_COMPLEX     *X,
                    const INTEGER            *LDX,
                    const DOUBLE             *BETA,
                    DOUBLE_COMPLEX           *B,
                    const INTEGER            *LDB);

//-- zlahef --------------------------------------------------------------------
void
LAPACK_IMPL(zlahef)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NB,
                    INTEGER          *KB,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    DOUBLE_COMPLEX   *W,
                    const INTEGER    *LDW,
                    INTEGER          *INFO);

//-- zlahqr --------------------------------------------------------------------
void
LAPACK_IMPL(zlahqr)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    DOUBLE_COMPLEX   *H,
                    const INTEGER    *LDH,
                    DOUBLE_COMPLEX   *W,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *INFO);

//-- zlahr2 --------------------------------------------------------------------
void
LAPACK_IMPL(zlahr2)(const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *NB,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *TAU,
                    DOUBLE_COMPLEX   *T,
                    const INTEGER    *LDT,
                    DOUBLE_COMPLEX   *Y,
                    const INTEGER    *LDY);

//-- zlahrd --------------------------------------------------------------------
void
LAPACK_IMPL(zlahrd)(const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *NB,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *TAU,
                    DOUBLE_COMPLEX   *T,
                    const INTEGER    *LDT,
                    DOUBLE_COMPLEX   *Y,
                    const INTEGER    *LDY);

//-- zlaic1 --------------------------------------------------------------------
void
LAPACK_IMPL(zlaic1)(const INTEGER            *JOB,
                    const INTEGER            *J,
                    const DOUBLE_COMPLEX     *X,
                    const DOUBLE             *SEST,
                    const DOUBLE_COMPLEX     *W,
                    const DOUBLE_COMPLEX     *GAMMA,
                    DOUBLE                   *SESTPR,
                    DOUBLE_COMPLEX           *S,
                    DOUBLE_COMPLEX           *C);

//-- zlals0 --------------------------------------------------------------------
void
LAPACK_IMPL(zlals0)(const INTEGER    *ICOMPQ,
                    const INTEGER    *NL,
                    const INTEGER    *NR,
                    const INTEGER    *SQRE,
                    const INTEGER    *NRHS,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB,
                    DOUBLE_COMPLEX   *BX,
                    const INTEGER    *LDBX,
                    const INTEGER    *PERM,
                    const INTEGER    *GIVPTR,
                    const INTEGER    *GIVCOL,
                    const INTEGER    *LDGCOL,
                    const DOUBLE     *GIVNUM,
                    const INTEGER    *LDGNUM,
                    const DOUBLE     *POLES,
                    const DOUBLE     *DIFL,
                    const DOUBLE     *DIFR,
                    const DOUBLE     *Z,
                    const INTEGER    *K,
                    const DOUBLE     *C,
                    const DOUBLE     *S,
                    DOUBLE           *RWORK,
                    INTEGER          *INFO);

//-- zlalsa --------------------------------------------------------------------
void
LAPACK_IMPL(zlalsa)(const INTEGER    *ICOMPQ,
                    const INTEGER    *SMLSIZ,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB,
                    DOUBLE_COMPLEX   *BX,
                    const INTEGER    *LDBX,
                    const DOUBLE     *U,
                    const INTEGER    *LDU,
                    const DOUBLE     *VT,
                    const INTEGER    *K,
                    const DOUBLE     *DIFL,
                    const DOUBLE     *DIFR,
                    const DOUBLE     *Z,
                    const DOUBLE     *POLES,
                    const INTEGER    *GIVPTR,
                    const INTEGER    *GIVCOL,
                    const INTEGER    *LDGCOL,
                    const INTEGER    *PERM,
                    const DOUBLE     *GIVNUM,
                    const DOUBLE     *C,
                    const DOUBLE     *S,
                    DOUBLE           *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- zlalsd --------------------------------------------------------------------
void
LAPACK_IMPL(zlalsd)(const char       *UPLO,
                    const INTEGER    *SMLSIZ,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB,
                    const DOUBLE     *RCOND,
                    INTEGER          *RANK,
                    DOUBLE_COMPLEX   *WORK,
                    DOUBLE           *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- zlangb --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zlangb)(const char               *NORM,
                    const INTEGER            *N,
                    const INTEGER            *KL,
                    const INTEGER            *KU,
                    const DOUBLE_COMPLEX     *AB,
                    const INTEGER            *LDAB,
                    DOUBLE                   *WORK);

//-- zlange --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zlange)(const char               *NORM,
                    const INTEGER            *M,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    DOUBLE                   *WORK);

//-- zlangt --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zlangt)(const char               *NORM,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *DL,
                    const DOUBLE_COMPLEX     *D,
                    const DOUBLE_COMPLEX     *DU);

//-- zlanhb --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zlanhb)(const char               *NORM,
                    const char               *UPLO,
                    const INTEGER            *N,
                    const INTEGER            *K,
                    const DOUBLE_COMPLEX     *AB,
                    const INTEGER            *LDAB,
                    DOUBLE                   *WORK);

//-- zlanhe --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zlanhe)(const char               *NORM,
                    const char               *UPLO,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    DOUBLE                   *WORK);

//-- zlanhf --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zlanhf)(const char               *NORM,
                    const char               *TRANSR,
                    const char               *UPLO,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    DOUBLE                   *WORK);

//-- zlanhp --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zlanhp)(const char               *NORM,
                    const char               *UPLO,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *AP,
                    DOUBLE                   *WORK);

//-- zlanhs --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zlanhs)(const char               *NORM,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    DOUBLE                   *WORK);

//-- zlanht --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zlanht)(const char               *NORM,
                    const INTEGER            *N,
                    const DOUBLE             *D,
                    const DOUBLE_COMPLEX     *E);

//-- zlansb --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zlansb)(const char               *NORM,
                    const char               *UPLO,
                    const INTEGER            *N,
                    const INTEGER            *K,
                    const DOUBLE_COMPLEX     *AB,
                    const INTEGER            *LDAB,
                    DOUBLE                   *WORK);

//-- zlansp --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zlansp)(const char               *NORM,
                    const char               *UPLO,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *AP,
                    DOUBLE                   *WORK);

//-- zlansy --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zlansy)(const char               *NORM,
                    const char               *UPLO,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    DOUBLE                   *WORK);

//-- zlantb --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zlantb)(const char               *NORM,
                    const char               *UPLO,
                    const char               *DIAG,
                    const INTEGER            *N,
                    const INTEGER            *K,
                    const DOUBLE_COMPLEX     *AB,
                    const INTEGER            *LDAB,
                    DOUBLE                   *WORK);

//-- zlantp --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zlantp)(const char               *NORM,
                    const char               *UPLO,
                    const char               *DIAG,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *AP,
                    DOUBLE                   *WORK);

//-- zlantr --------------------------------------------------------------------
DOUBLE
LAPACK_IMPL(zlantr)(const char               *NORM,
                    const char               *UPLO,
                    const char               *DIAG,
                    const INTEGER            *M,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    DOUBLE                   *WORK);

//-- zlapll --------------------------------------------------------------------
void
LAPACK_IMPL(zlapll)(const INTEGER    *N,
                    DOUBLE_COMPLEX   *X,
                    const INTEGER    *INCX,
                    DOUBLE_COMPLEX   *Y,
                    const INTEGER    *INCY,
                    DOUBLE           *SSMIN);

//-- zlapmr --------------------------------------------------------------------
void
LAPACK_IMPL(zlapmr)(const LOGICAL    *FORWRD,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *X,
                    const INTEGER    *LDX,
                    INTEGER          *K);

//-- zlapmt --------------------------------------------------------------------
void
LAPACK_IMPL(zlapmt)(const LOGICAL    *FORWRD,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *X,
                    const INTEGER    *LDX,
                    INTEGER          *K);

//-- zlaqgb --------------------------------------------------------------------
void
LAPACK_IMPL(zlaqgb)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    DOUBLE_COMPLEX   *AB,
                    const INTEGER    *LDAB,
                    const DOUBLE     *R,
                    const DOUBLE     *C,
                    const DOUBLE     *ROWCND,
                    const DOUBLE     *COLCND,
                    const DOUBLE     *AMAX,
                    char             *EQUED);

//-- zlaqge --------------------------------------------------------------------
void
LAPACK_IMPL(zlaqge)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *R,
                    const DOUBLE     *C,
                    const DOUBLE     *ROWCND,
                    const DOUBLE     *COLCND,
                    const DOUBLE     *AMAX,
                    char             *EQUED);

//-- zlaqhb --------------------------------------------------------------------
void
LAPACK_IMPL(zlaqhb)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    DOUBLE_COMPLEX   *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *S,
                    const DOUBLE     *SCOND,
                    const DOUBLE     *AMAX,
                    char             *EQUED);

//-- zlaqhe --------------------------------------------------------------------
void
LAPACK_IMPL(zlaqhe)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *S,
                    const DOUBLE     *SCOND,
                    const DOUBLE     *AMAX,
                    char             *EQUED);

//-- zlaqhp --------------------------------------------------------------------
void
LAPACK_IMPL(zlaqhp)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *AP,
                    const DOUBLE     *S,
                    const DOUBLE     *SCOND,
                    const DOUBLE     *AMAX,
                    char             *EQUED);

//-- zlaqp2 --------------------------------------------------------------------
void
LAPACK_IMPL(zlaqp2)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *OFFSET,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    DOUBLE_COMPLEX   *TAU,
                    DOUBLE           *VN1,
                    DOUBLE           *VN2,
                    DOUBLE_COMPLEX   *WORK);

//-- zlaqps --------------------------------------------------------------------
void
LAPACK_IMPL(zlaqps)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *OFFSET,
                    const INTEGER    *NB,
                    INTEGER          *KB,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    DOUBLE_COMPLEX   *TAU,
                    DOUBLE           *VN1,
                    DOUBLE           *VN2,
                    DOUBLE_COMPLEX   *AUXV,
                    DOUBLE_COMPLEX   *F,
                    const INTEGER    *LDF);

//-- zlaqr0 --------------------------------------------------------------------
void
LAPACK_IMPL(zlaqr0)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    DOUBLE_COMPLEX   *H,
                    const INTEGER    *LDH,
                    DOUBLE_COMPLEX   *W,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- zlaqr1 --------------------------------------------------------------------
void
LAPACK_IMPL(zlaqr1)(const INTEGER            *N,
                    const DOUBLE_COMPLEX     *H,
                    const INTEGER            *LDH,
                    const DOUBLE_COMPLEX     *S1,
                    const DOUBLE_COMPLEX     *S2,
                    DOUBLE_COMPLEX           *V);

//-- zlaqr2 --------------------------------------------------------------------
void
LAPACK_IMPL(zlaqr2)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *KTOP,
                    const INTEGER    *KBOT,
                    const INTEGER    *NW,
                    DOUBLE_COMPLEX   *H,
                    const INTEGER    *LDH,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *NS,
                    INTEGER          *ND,
                    DOUBLE_COMPLEX   *SH,
                    DOUBLE_COMPLEX   *V,
                    const INTEGER    *LDV,
                    const INTEGER    *NH,
                    DOUBLE_COMPLEX   *T,
                    const INTEGER    *LDT,
                    const INTEGER    *NV,
                    DOUBLE_COMPLEX   *WV,
                    const INTEGER    *LDWV,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK);

//-- zlaqr3 --------------------------------------------------------------------
void
LAPACK_IMPL(zlaqr3)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *KTOP,
                    const INTEGER    *KBOT,
                    const INTEGER    *NW,
                    DOUBLE_COMPLEX   *H,
                    const INTEGER    *LDH,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *NS,
                    INTEGER          *ND,
                    DOUBLE_COMPLEX   *SH,
                    DOUBLE_COMPLEX   *V,
                    const INTEGER    *LDV,
                    const INTEGER    *NH,
                    DOUBLE_COMPLEX   *T,
                    const INTEGER    *LDT,
                    const INTEGER    *NV,
                    DOUBLE_COMPLEX   *WV,
                    const INTEGER    *LDWV,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK);

//-- zlaqr4 --------------------------------------------------------------------
void
LAPACK_IMPL(zlaqr4)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    DOUBLE_COMPLEX   *H,
                    const INTEGER    *LDH,
                    DOUBLE_COMPLEX   *W,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- zlaqr5 --------------------------------------------------------------------
void
LAPACK_IMPL(zlaqr5)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *KACC22,
                    const INTEGER    *N,
                    const INTEGER    *KTOP,
                    const INTEGER    *KBOT,
                    const INTEGER    *NSHFTS,
                    DOUBLE_COMPLEX   *S,
                    DOUBLE_COMPLEX   *H,
                    const INTEGER    *LDH,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    DOUBLE_COMPLEX   *V,
                    const INTEGER    *LDV,
                    DOUBLE_COMPLEX   *U,
                    const INTEGER    *LDU,
                    const INTEGER    *NV,
                    DOUBLE_COMPLEX   *WV,
                    const INTEGER    *LDWV,
                    const INTEGER    *NH,
                    DOUBLE_COMPLEX   *WH,
                    const INTEGER    *LDWH);

//-- zlaqsb --------------------------------------------------------------------
void
LAPACK_IMPL(zlaqsb)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    DOUBLE_COMPLEX   *AB,
                    const INTEGER    *LDAB,
                    const DOUBLE     *S,
                    const DOUBLE     *SCOND,
                    const DOUBLE     *AMAX,
                    char             *EQUED);

//-- zlaqsp --------------------------------------------------------------------
void
LAPACK_IMPL(zlaqsp)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *AP,
                    const DOUBLE     *S,
                    const DOUBLE     *SCOND,
                    const DOUBLE     *AMAX,
                    char             *EQUED);

//-- zlaqsy --------------------------------------------------------------------
void
LAPACK_IMPL(zlaqsy)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *S,
                    const DOUBLE     *SCOND,
                    const DOUBLE     *AMAX,
                    char             *EQUED);

//-- zlar1v --------------------------------------------------------------------
void
LAPACK_IMPL(zlar1v)(const INTEGER    *N,
                    const INTEGER    *B1,
                    const INTEGER    *BN,
                    const DOUBLE     *LAMBDA,
                    const DOUBLE     *D,
                    const DOUBLE     *L,
                    const DOUBLE     *LD,
                    const DOUBLE     *LLD,
                    const DOUBLE     *PIVMIN,
                    const DOUBLE     *GAPTOL,
                    DOUBLE_COMPLEX   *Z,
                    const LOGICAL    *WANTNC,
                    INTEGER          *NEGCNT,
                    DOUBLE           *ZTZ,
                    DOUBLE           *MINGMA,
                    INTEGER          *R,
                    INTEGER          *ISUPPZ,
                    DOUBLE           *NRMINV,
                    DOUBLE           *RESID,
                    DOUBLE           *RQCORR,
                    DOUBLE           *WORK);

//-- zlar2v --------------------------------------------------------------------
void
LAPACK_IMPL(zlar2v)(const INTEGER            *N,
                    DOUBLE_COMPLEX           *X,
                    DOUBLE_COMPLEX           *Y,
                    DOUBLE_COMPLEX           *Z,
                    const INTEGER            *INCX,
                    const DOUBLE             *C,
                    const DOUBLE_COMPLEX     *S,
                    const INTEGER            *INCC);

//-- zlarcm --------------------------------------------------------------------
void
LAPACK_IMPL(zlarcm)(const INTEGER            *M,
                    const INTEGER            *N,
                    const DOUBLE             *A,
                    const INTEGER            *LDA,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    const DOUBLE_COMPLEX     *C,
                    const INTEGER            *LDC,
                    DOUBLE                   *RWORK);

//-- zlarf ---------------------------------------------------------------------
void
LAPACK_IMPL(zlarf)(const char               *SIDE,
                   const INTEGER            *M,
                   const INTEGER            *N,
                   const DOUBLE_COMPLEX     *V,
                   const INTEGER            *INCV,
                   const DOUBLE_COMPLEX     *TAU,
                   DOUBLE_COMPLEX           *C,
                   const INTEGER            *LDC,
                   DOUBLE_COMPLEX           *WORK);

//-- zlarfb --------------------------------------------------------------------
void
LAPACK_IMPL(zlarfb)(const char               *SIDE,
                    const char               *TRANS,
                    const char               *DIRECT,
                    const char               *STOREV,
                    const INTEGER            *M,
                    const INTEGER            *N,
                    const INTEGER            *K,
                    const DOUBLE_COMPLEX     *V,
                    const INTEGER            *LDV,
                    const DOUBLE_COMPLEX     *T,
                    const INTEGER            *LDT,
                    DOUBLE_COMPLEX           *C,
                    const INTEGER            *LDC,
                    DOUBLE_COMPLEX           *WORK,
                    const INTEGER            *LDWORK);

//-- zlarfg --------------------------------------------------------------------
void
LAPACK_IMPL(zlarfg)(const INTEGER    *N,
                    DOUBLE_COMPLEX   *ALPHA,
                    DOUBLE_COMPLEX   *X,
                    const INTEGER    *INCX,
                    DOUBLE_COMPLEX   *TAU);

//-- zlarfgp -------------------------------------------------------------------
void
LAPACK_IMPL(zlarfgp)(const INTEGER    *N,
                     DOUBLE_COMPLEX   *ALPHA,
                     DOUBLE_COMPLEX   *X,
                     const INTEGER    *INCX,
                     DOUBLE_COMPLEX   *TAU);

//-- zlarft --------------------------------------------------------------------
void
LAPACK_IMPL(zlarft)(const char               *DIRECT,
                    const char               *STOREV,
                    const INTEGER            *N,
                    const INTEGER            *K,
                    DOUBLE_COMPLEX           *V,
                    const INTEGER            *LDV,
                    const DOUBLE_COMPLEX     *TAU,
                    DOUBLE_COMPLEX           *T,
                    const INTEGER            *LDT);

//-- zlarfx --------------------------------------------------------------------
void
LAPACK_IMPL(zlarfx)(const char               *SIDE,
                    const INTEGER            *M,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *V,
                    const DOUBLE_COMPLEX     *TAU,
                    DOUBLE_COMPLEX           *C,
                    const INTEGER            *LDC,
                    DOUBLE_COMPLEX           *WORK);

//-- zlargv --------------------------------------------------------------------
void
LAPACK_IMPL(zlargv)(const INTEGER    *N,
                    DOUBLE_COMPLEX   *X,
                    const INTEGER    *INCX,
                    DOUBLE_COMPLEX   *Y,
                    const INTEGER    *INCY,
                    DOUBLE           *C,
                    const INTEGER    *INCC);

//-- zlarnv --------------------------------------------------------------------
void
LAPACK_IMPL(zlarnv)(const INTEGER    *IDIST,
                    INTEGER          *ISEED,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *X);

//-- zlarrv --------------------------------------------------------------------
void
LAPACK_IMPL(zlarrv)(const INTEGER    *N,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    DOUBLE           *D,
                    DOUBLE           *L,
                    const DOUBLE     *PIVMIN,
                    const INTEGER    *ISPLIT,
                    const INTEGER    *M,
                    const INTEGER    *DOL,
                    const INTEGER    *DOU,
                    const DOUBLE     *MINRGP,
                    const DOUBLE     *RTOL1,
                    const DOUBLE     *RTOL2,
                    DOUBLE           *W,
                    DOUBLE           *WERR,
                    DOUBLE           *WGAP,
                    const INTEGER    *IBLOCK,
                    const INTEGER    *INDEXW,
                    const DOUBLE     *GERS,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *ISUPPZ,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO);

//-- zlarscl2 ------------------------------------------------------------------
void
LAPACK_IMPL(zlarscl2)(const INTEGER        *M,
                      const INTEGER        *N,
                      const DOUBLE         *D,
                      DOUBLE_COMPLEX       *X,
                      const INTEGER        *LDX);

//-- zlartg --------------------------------------------------------------------
void
LAPACK_IMPL(zlartg)(const DOUBLE_COMPLEX     *F,
                    const DOUBLE_COMPLEX     *G,
                    DOUBLE                   *CS,
                    DOUBLE_COMPLEX           *SN,
                    DOUBLE_COMPLEX           *R);

//-- zlartv --------------------------------------------------------------------
void
LAPACK_IMPL(zlartv)(const INTEGER            *N,
                    DOUBLE_COMPLEX           *X,
                    const INTEGER            *INCX,
                    DOUBLE_COMPLEX           *Y,
                    const INTEGER            *INCY,
                    const DOUBLE             *C,
                    const DOUBLE_COMPLEX     *S,
                    const INTEGER            *INCC);

//-- zlarz ---------------------------------------------------------------------
void
LAPACK_IMPL(zlarz)(const char               *SIDE,
                   const INTEGER            *M,
                   const INTEGER            *N,
                   const INTEGER            *L,
                   const DOUBLE_COMPLEX     *V,
                   const INTEGER            *INCV,
                   const DOUBLE_COMPLEX     *TAU,
                   DOUBLE_COMPLEX           *C,
                   const INTEGER            *LDC,
                   DOUBLE_COMPLEX           *WORK);

//-- zlarzb --------------------------------------------------------------------
void
LAPACK_IMPL(zlarzb)(const char               *SIDE,
                    const char               *TRANS,
                    const char               *DIRECT,
                    const char               *STOREV,
                    const INTEGER            *M,
                    const INTEGER            *N,
                    const INTEGER            *K,
                    const INTEGER            *L,
                    const DOUBLE_COMPLEX     *V,
                    const INTEGER            *LDV,
                    const DOUBLE_COMPLEX     *T,
                    const INTEGER            *LDT,
                    DOUBLE_COMPLEX           *C,
                    const INTEGER            *LDC,
                    DOUBLE_COMPLEX           *WORK,
                    const INTEGER            *LDWORK);

//-- zlarzt --------------------------------------------------------------------
void
LAPACK_IMPL(zlarzt)(const char               *DIRECT,
                    const char               *STOREV,
                    const INTEGER            *N,
                    const INTEGER            *K,
                    DOUBLE_COMPLEX           *V,
                    const INTEGER            *LDV,
                    const DOUBLE_COMPLEX     *TAU,
                    DOUBLE_COMPLEX           *T,
                    const INTEGER            *LDT);

//-- zlascl --------------------------------------------------------------------
void
LAPACK_IMPL(zlascl)(const char       *TYPE,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const DOUBLE     *CFROM,
                    const DOUBLE     *CTO,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- zlascl2 -------------------------------------------------------------------
void
LAPACK_IMPL(zlascl2)(const INTEGER    *M,
                     const INTEGER    *N,
                     const DOUBLE     *D,
                     DOUBLE_COMPLEX   *X,
                     const INTEGER    *LDX);

//-- zlaset --------------------------------------------------------------------
void
LAPACK_IMPL(zlaset)(const char               *UPLO,
                    const INTEGER            *M,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *ALPHA,
                    const DOUBLE_COMPLEX     *BETA,
                    DOUBLE_COMPLEX           *A,
                    const INTEGER            *LDA);

//-- zlasr ---------------------------------------------------------------------
void
LAPACK_IMPL(zlasr)(const char           *SIDE,
                   const char           *PIVOT,
                   const char           *DIRECT,
                   const INTEGER        *M,
                   const INTEGER        *N,
                   const DOUBLE         *C,
                   const DOUBLE         *S,
                   DOUBLE_COMPLEX       *A,
                   const INTEGER        *LDA);

//-- zlassq --------------------------------------------------------------------
void
LAPACK_IMPL(zlassq)(const INTEGER            *N,
                    const DOUBLE_COMPLEX     *X,
                    const INTEGER            *INCX,
                    DOUBLE                   *SCALE,
                    DOUBLE                   *SUMSQ);

//-- zlaswp --------------------------------------------------------------------
void
LAPACK_IMPL(zlaswp)(const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    const INTEGER    *K1,
                    const INTEGER    *K2,
                    const INTEGER    *IPIV,
                    const INTEGER    *INCX);

//-- zlasyf --------------------------------------------------------------------
void
LAPACK_IMPL(zlasyf)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NB,
                    INTEGER          *KB,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    DOUBLE_COMPLEX   *W,
                    const INTEGER    *LDW,
                    INTEGER          *INFO);

//-- zlat2c --------------------------------------------------------------------
void
LAPACK_IMPL(zlat2c)(const char               *UPLO,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    FLOAT_COMPLEX            *SA,
                    const INTEGER            *LDSA,
                    INTEGER                  *INFO);

//-- zlatbs --------------------------------------------------------------------
void
LAPACK_IMPL(zlatbs)(const char               *UPLO,
                    const char               *TRANS,
                    const char               *DIAG,
                    const char               *NORMIN,
                    const INTEGER            *N,
                    const INTEGER            *KD,
                    const DOUBLE_COMPLEX     *AB,
                    const INTEGER            *LDAB,
                    DOUBLE_COMPLEX           *X,
                    DOUBLE                   *SCALE,
                    DOUBLE                   *CNORM,
                    INTEGER                  *INFO);

//-- zlatdf --------------------------------------------------------------------
void
LAPACK_IMPL(zlatdf)(const INTEGER            *IJOB,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *Z,
                    const INTEGER            *LDZ,
                    DOUBLE_COMPLEX           *RHS,
                    DOUBLE                   *RDSUM,
                    DOUBLE                   *RDSCAL,
                    const INTEGER            *IPIV,
                    const INTEGER            *JPIV);

//-- zlatps --------------------------------------------------------------------
void
LAPACK_IMPL(zlatps)(const char               *UPLO,
                    const char               *TRANS,
                    const char               *DIAG,
                    const char               *NORMIN,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *AP,
                    DOUBLE_COMPLEX           *X,
                    DOUBLE                   *SCALE,
                    DOUBLE                   *CNORM,
                    INTEGER                  *INFO);

//-- zlatrd --------------------------------------------------------------------
void
LAPACK_IMPL(zlatrd)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NB,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE           *E,
                    DOUBLE_COMPLEX   *TAU,
                    DOUBLE_COMPLEX   *W,
                    const INTEGER    *LDW);

//-- zlatrs --------------------------------------------------------------------
void
LAPACK_IMPL(zlatrs)(const char               *UPLO,
                    const char               *TRANS,
                    const char               *DIAG,
                    const char               *NORMIN,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    DOUBLE_COMPLEX           *X,
                    DOUBLE                   *SCALE,
                    DOUBLE                   *CNORM,
                    INTEGER                  *INFO);

//-- zlatrz --------------------------------------------------------------------
void
LAPACK_IMPL(zlatrz)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *L,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *TAU,
                    DOUBLE_COMPLEX   *WORK);

//-- zlatzm --------------------------------------------------------------------
void
LAPACK_IMPL(zlatzm)(const char               *SIDE,
                    const INTEGER            *M,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *V,
                    const INTEGER            *INCV,
                    const DOUBLE_COMPLEX     *TAU,
                    DOUBLE_COMPLEX           *C1,
                    DOUBLE_COMPLEX           *C2,
                    const INTEGER            *LDC,
                    DOUBLE_COMPLEX           *WORK);

//-- zlauu2 --------------------------------------------------------------------
void
LAPACK_IMPL(zlauu2)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- zlauum --------------------------------------------------------------------
void
LAPACK_IMPL(zlauum)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- zpbcon --------------------------------------------------------------------
void
LAPACK_IMPL(zpbcon)(const char               *UPLO,
                    const INTEGER            *N,
                    const INTEGER            *KD,
                    const DOUBLE_COMPLEX     *AB,
                    const INTEGER            *LDAB,
                    const DOUBLE             *ANORM,
                    DOUBLE                   *RCOND,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- zpbequ --------------------------------------------------------------------
void
LAPACK_IMPL(zpbequ)(const char               *UPLO,
                    const INTEGER            *N,
                    const INTEGER            *KD,
                    const DOUBLE_COMPLEX     *AB,
                    const INTEGER            *LDAB,
                    DOUBLE                   *S,
                    DOUBLE                   *SCOND,
                    DOUBLE                   *AMAX,
                    INTEGER                  *INFO);

//-- zpbrfs --------------------------------------------------------------------
void
LAPACK_IMPL(zpbrfs)(const char               *UPLO,
                    const INTEGER            *N,
                    const INTEGER            *KD,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *AB,
                    const INTEGER            *LDAB,
                    const DOUBLE_COMPLEX     *AFB,
                    const INTEGER            *LDAFB,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    DOUBLE_COMPLEX           *X,
                    const INTEGER            *LDX,
                    DOUBLE                   *FERR,
                    DOUBLE                   *BERR,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- zpbstf --------------------------------------------------------------------
void
LAPACK_IMPL(zpbstf)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    DOUBLE_COMPLEX   *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *INFO);

//-- zpbsv ---------------------------------------------------------------------
void
LAPACK_IMPL(zpbsv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *KD,
                   const INTEGER        *NRHS,
                   DOUBLE_COMPLEX       *AB,
                   const INTEGER        *LDAB,
                   DOUBLE_COMPLEX       *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- zpbsvx --------------------------------------------------------------------
void
LAPACK_IMPL(zpbsvx)(const char       *FACT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const INTEGER    *NRHS,
                    DOUBLE_COMPLEX   *AB,
                    const INTEGER    *LDAB,
                    DOUBLE_COMPLEX   *AFB,
                    const INTEGER    *LDAFB,
                    char             *EQUED,
                    DOUBLE           *S,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB,
                    DOUBLE_COMPLEX   *X,
                    const INTEGER    *LDX,
                    DOUBLE           *RCOND,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE_COMPLEX   *WORK,
                    DOUBLE           *RWORK,
                    INTEGER          *INFO);

//-- zpbtf2 --------------------------------------------------------------------
void
LAPACK_IMPL(zpbtf2)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    DOUBLE_COMPLEX   *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *INFO);

//-- zpbtrf --------------------------------------------------------------------
void
LAPACK_IMPL(zpbtrf)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    DOUBLE_COMPLEX   *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *INFO);

//-- zpbtrs --------------------------------------------------------------------
void
LAPACK_IMPL(zpbtrs)(const char               *UPLO,
                    const INTEGER            *N,
                    const INTEGER            *KD,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *AB,
                    const INTEGER            *LDAB,
                    DOUBLE_COMPLEX           *B,
                    const INTEGER            *LDB,
                    INTEGER                  *INFO);

//-- zpftrf --------------------------------------------------------------------
void
LAPACK_IMPL(zpftrf)(const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    INTEGER          *INFO);

//-- zpftri --------------------------------------------------------------------
void
LAPACK_IMPL(zpftri)(const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    INTEGER          *INFO);

//-- zpftrs --------------------------------------------------------------------
void
LAPACK_IMPL(zpftrs)(const char               *TRANSR,
                    const char               *UPLO,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *A,
                    DOUBLE_COMPLEX           *B,
                    const INTEGER            *LDB,
                    INTEGER                  *INFO);

//-- zpocon --------------------------------------------------------------------
void
LAPACK_IMPL(zpocon)(const char               *UPLO,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    const DOUBLE             *ANORM,
                    DOUBLE                   *RCOND,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- zpoequ --------------------------------------------------------------------
void
LAPACK_IMPL(zpoequ)(const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    DOUBLE                   *S,
                    DOUBLE                   *SCOND,
                    DOUBLE                   *AMAX,
                    INTEGER                  *INFO);

//-- zpoequb -------------------------------------------------------------------
void
LAPACK_IMPL(zpoequb)(const INTEGER            *N,
                     const DOUBLE_COMPLEX     *A,
                     const INTEGER            *LDA,
                     DOUBLE                   *S,
                     DOUBLE                   *SCOND,
                     DOUBLE                   *AMAX,
                     INTEGER                  *INFO);

//-- zporfs --------------------------------------------------------------------
void
LAPACK_IMPL(zporfs)(const char               *UPLO,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    const DOUBLE_COMPLEX     *AF,
                    const INTEGER            *LDAF,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    DOUBLE_COMPLEX           *X,
                    const INTEGER            *LDX,
                    DOUBLE                   *FERR,
                    DOUBLE                   *BERR,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- zporfsx -------------------------------------------------------------------
void
LAPACK_IMPL(zporfsx)(const char               *UPLO,
                     const char               *EQUED,
                     const INTEGER            *N,
                     const INTEGER            *NRHS,
                     const DOUBLE_COMPLEX     *A,
                     const INTEGER            *LDA,
                     const DOUBLE_COMPLEX     *AF,
                     const INTEGER            *LDAF,
                     DOUBLE                   *S,
                     const DOUBLE_COMPLEX     *B,
                     const INTEGER            *LDB,
                     DOUBLE_COMPLEX           *X,
                     const INTEGER            *LDX,
                     DOUBLE                   *RCOND,
                     DOUBLE                   *BERR,
                     const INTEGER            *N_ERR_BNDS,
                     DOUBLE                   *ERR_BNDS_NORM,
                     DOUBLE                   *ERR_BNDS_COMP,
                     const INTEGER            *NPARAMS,
                     DOUBLE                   *PARAMS,
                     DOUBLE_COMPLEX           *WORK,
                     DOUBLE                   *RWORK,
                     INTEGER                  *INFO);

//-- zposv ---------------------------------------------------------------------
void
LAPACK_IMPL(zposv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   DOUBLE_COMPLEX       *A,
                   const INTEGER        *LDA,
                   DOUBLE_COMPLEX       *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- zposvx --------------------------------------------------------------------
void
LAPACK_IMPL(zposvx)(const char       *FACT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *AF,
                    const INTEGER    *LDAF,
                    char             *EQUED,
                    DOUBLE           *S,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB,
                    DOUBLE_COMPLEX   *X,
                    const INTEGER    *LDX,
                    DOUBLE           *RCOND,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE_COMPLEX   *WORK,
                    DOUBLE           *RWORK,
                    INTEGER          *INFO);

//-- zposvxx -------------------------------------------------------------------
void
LAPACK_IMPL(zposvxx)(const char       *FACT,
                     const char       *UPLO,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     DOUBLE_COMPLEX   *A,
                     const INTEGER    *LDA,
                     DOUBLE_COMPLEX   *AF,
                     const INTEGER    *LDAF,
                     char             *EQUED,
                     DOUBLE           *S,
                     DOUBLE_COMPLEX   *B,
                     const INTEGER    *LDB,
                     DOUBLE_COMPLEX   *X,
                     const INTEGER    *LDX,
                     DOUBLE           *RCOND,
                     DOUBLE           *RPVGRW,
                     DOUBLE           *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     DOUBLE           *ERR_BNDS_NORM,
                     DOUBLE           *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     DOUBLE           *PARAMS,
                     DOUBLE_COMPLEX   *WORK,
                     DOUBLE           *RWORK,
                     INTEGER          *INFO);

//-- zpotf2 --------------------------------------------------------------------
void
LAPACK_IMPL(zpotf2)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- zpotrf --------------------------------------------------------------------
void
LAPACK_IMPL(zpotrf)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- zpotri --------------------------------------------------------------------
void
LAPACK_IMPL(zpotri)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- zpotrs --------------------------------------------------------------------
void
LAPACK_IMPL(zpotrs)(const char               *UPLO,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    DOUBLE_COMPLEX           *B,
                    const INTEGER            *LDB,
                    INTEGER                  *INFO);

//-- zppcon --------------------------------------------------------------------
void
LAPACK_IMPL(zppcon)(const char               *UPLO,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *AP,
                    const DOUBLE             *ANORM,
                    DOUBLE                   *RCOND,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- zppequ --------------------------------------------------------------------
void
LAPACK_IMPL(zppequ)(const char               *UPLO,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *AP,
                    DOUBLE                   *S,
                    DOUBLE                   *SCOND,
                    DOUBLE                   *AMAX,
                    INTEGER                  *INFO);

//-- zpprfs --------------------------------------------------------------------
void
LAPACK_IMPL(zpprfs)(const char               *UPLO,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *AP,
                    const DOUBLE_COMPLEX     *AFP,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    DOUBLE_COMPLEX           *X,
                    const INTEGER            *LDX,
                    DOUBLE                   *FERR,
                    DOUBLE                   *BERR,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- zppsv ---------------------------------------------------------------------
void
LAPACK_IMPL(zppsv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   DOUBLE_COMPLEX       *AP,
                   DOUBLE_COMPLEX       *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- zppsvx --------------------------------------------------------------------
void
LAPACK_IMPL(zppsvx)(const char       *FACT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE_COMPLEX   *AP,
                    DOUBLE_COMPLEX   *AFP,
                    char             *EQUED,
                    DOUBLE           *S,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB,
                    DOUBLE_COMPLEX   *X,
                    const INTEGER    *LDX,
                    DOUBLE           *RCOND,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE_COMPLEX   *WORK,
                    DOUBLE           *RWORK,
                    INTEGER          *INFO);

//-- zpptrf --------------------------------------------------------------------
void
LAPACK_IMPL(zpptrf)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *AP,
                    INTEGER          *INFO);

//-- zpptri --------------------------------------------------------------------
void
LAPACK_IMPL(zpptri)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *AP,
                    INTEGER          *INFO);

//-- zpptrs --------------------------------------------------------------------
void
LAPACK_IMPL(zpptrs)(const char               *UPLO,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *AP,
                    DOUBLE_COMPLEX           *B,
                    const INTEGER            *LDB,
                    INTEGER                  *INFO);

//-- zpstf2 --------------------------------------------------------------------
void
LAPACK_IMPL(zpstf2)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    INTEGER          *PIV,
                    INTEGER          *RANK,
                    const DOUBLE     *TOL,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- zpstrf --------------------------------------------------------------------
void
LAPACK_IMPL(zpstrf)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    INTEGER          *PIV,
                    INTEGER          *RANK,
                    const DOUBLE     *TOL,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- zptcon --------------------------------------------------------------------
void
LAPACK_IMPL(zptcon)(const INTEGER            *N,
                    const DOUBLE             *D,
                    const DOUBLE_COMPLEX     *E,
                    const DOUBLE             *ANORM,
                    DOUBLE                   *RCOND,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- zpteqr --------------------------------------------------------------------
void
LAPACK_IMPL(zpteqr)(const char       *COMPZ,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- zptrfs --------------------------------------------------------------------
void
LAPACK_IMPL(zptrfs)(const char               *UPLO,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE             *D,
                    const DOUBLE_COMPLEX     *E,
                    const DOUBLE             *DF,
                    const DOUBLE_COMPLEX     *EF,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    DOUBLE_COMPLEX           *X,
                    const INTEGER            *LDX,
                    DOUBLE                   *FERR,
                    DOUBLE                   *BERR,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- zptsv ---------------------------------------------------------------------
void
LAPACK_IMPL(zptsv)(const INTEGER        *N,
                   const INTEGER        *NRHS,
                   DOUBLE               *D,
                   DOUBLE_COMPLEX       *E,
                   DOUBLE_COMPLEX       *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- zptsvx --------------------------------------------------------------------
void
LAPACK_IMPL(zptsvx)(const char               *FACT,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE             *D,
                    const DOUBLE_COMPLEX     *E,
                    DOUBLE                   *DF,
                    DOUBLE_COMPLEX           *EF,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    DOUBLE_COMPLEX           *X,
                    const INTEGER            *LDX,
                    DOUBLE                   *RCOND,
                    DOUBLE                   *FERR,
                    DOUBLE                   *BERR,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- zpttrf --------------------------------------------------------------------
void
LAPACK_IMPL(zpttrf)(const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE_COMPLEX   *E,
                    INTEGER          *INFO);

//-- zpttrs --------------------------------------------------------------------
void
LAPACK_IMPL(zpttrs)(const char               *UPLO,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE             *D,
                    const DOUBLE_COMPLEX     *E,
                    DOUBLE_COMPLEX           *B,
                    const INTEGER            *LDB,
                    INTEGER                  *INFO);

//-- zptts2 --------------------------------------------------------------------
void
LAPACK_IMPL(zptts2)(const INTEGER            *IUPLO,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE             *D,
                    const DOUBLE_COMPLEX     *E,
                    DOUBLE_COMPLEX           *B,
                    const INTEGER            *LDB);

//-- zrot ----------------------------------------------------------------------
void
LAPACK_IMPL(zrot)(const INTEGER            *N,
                  DOUBLE_COMPLEX           *CX,
                  const INTEGER            *INCX,
                  DOUBLE_COMPLEX           *CY,
                  const INTEGER            *INCY,
                  const DOUBLE             *C,
                  const DOUBLE_COMPLEX     *S);

//-- zspcon --------------------------------------------------------------------
void
LAPACK_IMPL(zspcon)(const char               *UPLO,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *AP,
                    const INTEGER            *IPIV,
                    const DOUBLE             *ANORM,
                    DOUBLE                   *RCOND,
                    DOUBLE_COMPLEX           *WORK,
                    INTEGER                  *INFO);

//-- zspmv ---------------------------------------------------------------------
void
LAPACK_IMPL(zspmv)(const char               *UPLO,
                   const INTEGER            *N,
                   const DOUBLE_COMPLEX     *ALPHA,
                   const DOUBLE_COMPLEX     *AP,
                   const DOUBLE_COMPLEX     *X,
                   const INTEGER            *INCX,
                   const DOUBLE_COMPLEX     *BETA,
                   DOUBLE_COMPLEX           *Y,
                   const INTEGER            *INCY);

//-- zspr ----------------------------------------------------------------------
void
LAPACK_IMPL(zspr)(const char               *UPLO,
                  const INTEGER            *N,
                  const DOUBLE_COMPLEX     *ALPHA,
                  const DOUBLE_COMPLEX     *X,
                  const INTEGER            *INCX,
                  DOUBLE_COMPLEX           *AP);

//-- zsprfs --------------------------------------------------------------------
void
LAPACK_IMPL(zsprfs)(const char               *UPLO,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *AP,
                    const DOUBLE_COMPLEX     *AFP,
                    const INTEGER            *IPIV,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    DOUBLE_COMPLEX           *X,
                    const INTEGER            *LDX,
                    DOUBLE                   *FERR,
                    DOUBLE                   *BERR,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- zspsv ---------------------------------------------------------------------
void
LAPACK_IMPL(zspsv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   DOUBLE_COMPLEX       *AP,
                   INTEGER              *IPIV,
                   DOUBLE_COMPLEX       *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO);

//-- zspsvx --------------------------------------------------------------------
void
LAPACK_IMPL(zspsvx)(const char               *FACT,
                    const char               *UPLO,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *AP,
                    DOUBLE_COMPLEX           *AFP,
                    INTEGER                  *IPIV,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    DOUBLE_COMPLEX           *X,
                    const INTEGER            *LDX,
                    DOUBLE                   *RCOND,
                    DOUBLE                   *FERR,
                    DOUBLE                   *BERR,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- zsptrf --------------------------------------------------------------------
void
LAPACK_IMPL(zsptrf)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *AP,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- zsptri --------------------------------------------------------------------
void
LAPACK_IMPL(zsptri)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *AP,
                    const INTEGER    *IPIV,
                    DOUBLE_COMPLEX   *WORK,
                    INTEGER          *INFO);

//-- zsptrs --------------------------------------------------------------------
void
LAPACK_IMPL(zsptrs)(const char               *UPLO,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *AP,
                    const INTEGER            *IPIV,
                    DOUBLE_COMPLEX           *B,
                    const INTEGER            *LDB,
                    INTEGER                  *INFO);

//-- zstedc --------------------------------------------------------------------
void
LAPACK_IMPL(zstedc)(const char       *COMPZ,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    DOUBLE           *RWORK,
                    const INTEGER    *LRWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- zstegr --------------------------------------------------------------------
void
LAPACK_IMPL(zstegr)(const char       *JOBZ,
                    const char       *RANGE,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *ISUPPZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- zstein --------------------------------------------------------------------
void
LAPACK_IMPL(zstein)(const INTEGER    *N,
                    const DOUBLE     *D,
                    const DOUBLE     *E,
                    const INTEGER    *M,
                    const DOUBLE     *W,
                    const INTEGER    *IBLOCK,
                    const INTEGER    *ISPLIT,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO);

//-- zstemr --------------------------------------------------------------------
void
LAPACK_IMPL(zstemr)(const char       *JOBZ,
                    const char       *RANGE,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    const INTEGER    *NZC,
                    INTEGER          *ISUPPZ,
                    LOGICAL          *TRYRAC,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- zsteqr --------------------------------------------------------------------
void
LAPACK_IMPL(zsteqr)(const char       *COMPZ,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    INTEGER          *INFO);

//-- zsycon --------------------------------------------------------------------
void
LAPACK_IMPL(zsycon)(const char               *UPLO,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    const INTEGER            *IPIV,
                    const DOUBLE             *ANORM,
                    DOUBLE                   *RCOND,
                    DOUBLE_COMPLEX           *WORK,
                    INTEGER                  *INFO);

//-- zsyconv -------------------------------------------------------------------
void
LAPACK_IMPL(zsyconv)(const char       *UPLO,
                     const char       *WAY,
                     const INTEGER    *N,
                     DOUBLE_COMPLEX   *A,
                     const INTEGER    *LDA,
                     const INTEGER    *IPIV,
                     DOUBLE_COMPLEX   *WORK,
                     INTEGER          *INFO);

//-- zsyequb -------------------------------------------------------------------
void
LAPACK_IMPL(zsyequb)(const char               *UPLO,
                     const INTEGER            *N,
                     const DOUBLE_COMPLEX     *A,
                     const INTEGER            *LDA,
                     DOUBLE                   *S,
                     DOUBLE                   *SCOND,
                     DOUBLE                   *AMAX,
                     DOUBLE_COMPLEX           *WORK,
                     INTEGER                  *INFO);

//-- zsymv ---------------------------------------------------------------------
void
LAPACK_IMPL(zsymv)(const char               *UPLO,
                   const INTEGER            *N,
                   const DOUBLE_COMPLEX     *ALPHA,
                   const DOUBLE_COMPLEX     *A,
                   const INTEGER            *LDA,
                   const DOUBLE_COMPLEX     *X,
                   const INTEGER            *INCX,
                   const DOUBLE_COMPLEX     *BETA,
                   DOUBLE_COMPLEX           *Y,
                   const INTEGER            *INCY);

//-- zsyr ----------------------------------------------------------------------
void
LAPACK_IMPL(zsyr)(const char               *UPLO,
                  const INTEGER            *N,
                  const DOUBLE_COMPLEX     *ALPHA,
                  const DOUBLE_COMPLEX     *X,
                  const INTEGER            *INCX,
                  DOUBLE_COMPLEX           *A,
                  const INTEGER            *LDA);

//-- zsyrfs --------------------------------------------------------------------
void
LAPACK_IMPL(zsyrfs)(const char               *UPLO,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    const DOUBLE_COMPLEX     *AF,
                    const INTEGER            *LDAF,
                    const INTEGER            *IPIV,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    DOUBLE_COMPLEX           *X,
                    const INTEGER            *LDX,
                    DOUBLE                   *FERR,
                    DOUBLE                   *BERR,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- zsyrfsx -------------------------------------------------------------------
void
LAPACK_IMPL(zsyrfsx)(const char               *UPLO,
                     const char               *EQUED,
                     const INTEGER            *N,
                     const INTEGER            *NRHS,
                     const DOUBLE_COMPLEX     *A,
                     const INTEGER            *LDA,
                     const DOUBLE_COMPLEX     *AF,
                     const INTEGER            *LDAF,
                     const INTEGER            *IPIV,
                     DOUBLE                   *S,
                     const DOUBLE_COMPLEX     *B,
                     const INTEGER            *LDB,
                     DOUBLE_COMPLEX           *X,
                     const INTEGER            *LDX,
                     DOUBLE                   *RCOND,
                     DOUBLE                   *BERR,
                     const INTEGER            *N_ERR_BNDS,
                     DOUBLE                   *ERR_BNDS_NORM,
                     DOUBLE                   *ERR_BNDS_COMP,
                     const INTEGER            *NPARAMS,
                     DOUBLE                   *PARAMS,
                     DOUBLE_COMPLEX           *WORK,
                     DOUBLE                   *RWORK,
                     INTEGER                  *INFO);

//-- zsysv ---------------------------------------------------------------------
void
LAPACK_IMPL(zsysv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   DOUBLE_COMPLEX       *A,
                   const INTEGER        *LDA,
                   INTEGER              *IPIV,
                   DOUBLE_COMPLEX       *B,
                   const INTEGER        *LDB,
                   DOUBLE_COMPLEX       *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO);

//-- zsysvx --------------------------------------------------------------------
void
LAPACK_IMPL(zsysvx)(const char               *FACT,
                    const char               *UPLO,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    DOUBLE_COMPLEX           *AF,
                    const INTEGER            *LDAF,
                    INTEGER                  *IPIV,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    DOUBLE_COMPLEX           *X,
                    const INTEGER            *LDX,
                    DOUBLE                   *RCOND,
                    DOUBLE                   *FERR,
                    DOUBLE                   *BERR,
                    DOUBLE_COMPLEX           *WORK,
                    const INTEGER            *LWORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- zsysvxx -------------------------------------------------------------------
void
LAPACK_IMPL(zsysvxx)(const char       *FACT,
                     const char       *UPLO,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     DOUBLE_COMPLEX   *A,
                     const INTEGER    *LDA,
                     DOUBLE_COMPLEX   *AF,
                     const INTEGER    *LDAF,
                     INTEGER          *IPIV,
                     char             *EQUED,
                     DOUBLE           *S,
                     DOUBLE_COMPLEX   *B,
                     const INTEGER    *LDB,
                     DOUBLE_COMPLEX   *X,
                     const INTEGER    *LDX,
                     DOUBLE           *RCOND,
                     DOUBLE           *RPVGRW,
                     DOUBLE           *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     DOUBLE           *ERR_BNDS_NORM,
                     DOUBLE           *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     DOUBLE           *PARAMS,
                     DOUBLE_COMPLEX   *WORK,
                     DOUBLE           *RWORK,
                     INTEGER          *INFO);

//-- zsyswapr ------------------------------------------------------------------
void
LAPACK_IMPL(zsyswapr)(const char       *UPLO,
                      const INTEGER    *N,
                      DOUBLE_COMPLEX   *A,
                      const INTEGER    *LDA,
                      const INTEGER    *I1,
                      const INTEGER    *I2);

//-- zsytf2 --------------------------------------------------------------------
void
LAPACK_IMPL(zsytf2)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *INFO);

//-- zsytrf --------------------------------------------------------------------
void
LAPACK_IMPL(zsytrf)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- zsytri --------------------------------------------------------------------
void
LAPACK_IMPL(zsytri)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    const INTEGER    *IPIV,
                    DOUBLE_COMPLEX   *WORK,
                    INTEGER          *INFO);

//-- zsytri2 -------------------------------------------------------------------
void
LAPACK_IMPL(zsytri2)(const char       *UPLO,
                     const INTEGER    *N,
                     DOUBLE_COMPLEX   *A,
                     const INTEGER    *LDA,
                     const INTEGER    *IPIV,
                     DOUBLE_COMPLEX   *WORK,
                     const INTEGER    *LWORK,
                     INTEGER          *INFO);

//-- zsytri2x ------------------------------------------------------------------
void
LAPACK_IMPL(zsytri2x)(const char       *UPLO,
                      const INTEGER    *N,
                      DOUBLE_COMPLEX   *A,
                      const INTEGER    *LDA,
                      const INTEGER    *IPIV,
                      DOUBLE_COMPLEX   *WORK,
                      const INTEGER    *NB,
                      INTEGER          *INFO);

//-- zsytrs --------------------------------------------------------------------
void
LAPACK_IMPL(zsytrs)(const char               *UPLO,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    const INTEGER            *IPIV,
                    DOUBLE_COMPLEX           *B,
                    const INTEGER            *LDB,
                    INTEGER                  *INFO);

//-- zsytrs2 -------------------------------------------------------------------
void
LAPACK_IMPL(zsytrs2)(const char       *UPLO,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     DOUBLE_COMPLEX   *A,
                     const INTEGER    *LDA,
                     const INTEGER    *IPIV,
                     DOUBLE_COMPLEX   *B,
                     const INTEGER    *LDB,
                     DOUBLE_COMPLEX   *WORK,
                     INTEGER          *INFO);

//-- ztbcon --------------------------------------------------------------------
void
LAPACK_IMPL(ztbcon)(const char               *NORM,
                    const char               *UPLO,
                    const char               *DIAG,
                    const INTEGER            *N,
                    const INTEGER            *KD,
                    const DOUBLE_COMPLEX     *AB,
                    const INTEGER            *LDAB,
                    DOUBLE                   *RCOND,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- ztbrfs --------------------------------------------------------------------
void
LAPACK_IMPL(ztbrfs)(const char               *UPLO,
                    const char               *TRANS,
                    const char               *DIAG,
                    const INTEGER            *N,
                    const INTEGER            *KD,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *AB,
                    const INTEGER            *LDAB,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    const DOUBLE_COMPLEX     *X,
                    const INTEGER            *LDX,
                    DOUBLE                   *FERR,
                    DOUBLE                   *BERR,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- ztbtrs --------------------------------------------------------------------
void
LAPACK_IMPL(ztbtrs)(const char               *UPLO,
                    const char               *TRANS,
                    const char               *DIAG,
                    const INTEGER            *N,
                    const INTEGER            *KD,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *AB,
                    const INTEGER            *LDAB,
                    DOUBLE_COMPLEX           *B,
                    const INTEGER            *LDB,
                    INTEGER                  *INFO);

//-- ztfsm ---------------------------------------------------------------------
void
LAPACK_IMPL(ztfsm)(const char               *TRANSR,
                   const char               *SIDE,
                   const char               *UPLO,
                   const char               *TRANS,
                   const char               *DIAG,
                   const INTEGER            *M,
                   const INTEGER            *N,
                   const DOUBLE_COMPLEX     *ALPHA,
                   const DOUBLE_COMPLEX     *A,
                   DOUBLE_COMPLEX           *B,
                   const INTEGER            *LDB);

//-- ztftri --------------------------------------------------------------------
void
LAPACK_IMPL(ztftri)(const char       *TRANSR,
                    const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    INTEGER          *INFO);

//-- ztfttp --------------------------------------------------------------------
void
LAPACK_IMPL(ztfttp)(const char               *TRANSR,
                    const char               *UPLO,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *ARF,
                    DOUBLE_COMPLEX           *AP,
                    INTEGER                  *INFO);

//-- ztfttr --------------------------------------------------------------------
void
LAPACK_IMPL(ztfttr)(const char               *TRANSR,
                    const char               *UPLO,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *ARF,
                    DOUBLE_COMPLEX           *A,
                    const INTEGER            *LDA,
                    INTEGER                  *INFO);

//-- ztgevc --------------------------------------------------------------------
void
LAPACK_IMPL(ztgevc)(const char               *SIDE,
                    const char               *HOWMNY,
                    const LOGICAL            *SELECT,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *S,
                    const INTEGER            *LDS,
                    const DOUBLE_COMPLEX     *P,
                    const INTEGER            *LDP,
                    DOUBLE_COMPLEX           *VL,
                    const INTEGER            *LDVL,
                    DOUBLE_COMPLEX           *VR,
                    const INTEGER            *LDVR,
                    const INTEGER            *MM,
                    INTEGER                  *M,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- ztgex2 --------------------------------------------------------------------
void
LAPACK_IMPL(ztgex2)(const LOGICAL    *WANTQ,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB,
                    DOUBLE_COMPLEX   *Q,
                    const INTEGER    *LDQ,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    const INTEGER    *J1,
                    INTEGER          *INFO);

//-- ztgexc --------------------------------------------------------------------
void
LAPACK_IMPL(ztgexc)(const LOGICAL    *WANTQ,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB,
                    DOUBLE_COMPLEX   *Q,
                    const INTEGER    *LDQ,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    const INTEGER    *IFST,
                    INTEGER          *ILST,
                    INTEGER          *INFO);

//-- ztgsen --------------------------------------------------------------------
void
LAPACK_IMPL(ztgsen)(const INTEGER    *IJOB,
                    const LOGICAL    *WANTQ,
                    const LOGICAL    *WANTZ,
                    const LOGICAL    *SELECT,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB,
                    DOUBLE_COMPLEX   *ALPHA,
                    DOUBLE_COMPLEX   *BETA,
                    DOUBLE_COMPLEX   *Q,
                    const INTEGER    *LDQ,
                    DOUBLE_COMPLEX   *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *M,
                    DOUBLE           *PL,
                    DOUBLE           *PR,
                    DOUBLE           *DIF,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO);

//-- ztgsja --------------------------------------------------------------------
void
LAPACK_IMPL(ztgsja)(const char       *JOBU,
                    const char       *JOBV,
                    const char       *JOBQ,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *L,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *B,
                    const INTEGER    *LDB,
                    const DOUBLE     *TOLA,
                    const DOUBLE     *TOLB,
                    DOUBLE           *ALPHA,
                    DOUBLE           *BETA,
                    DOUBLE_COMPLEX   *U,
                    const INTEGER    *LDU,
                    DOUBLE_COMPLEX   *V,
                    const INTEGER    *LDV,
                    DOUBLE_COMPLEX   *Q,
                    const INTEGER    *LDQ,
                    DOUBLE_COMPLEX   *WORK,
                    INTEGER          *NCYCLE,
                    INTEGER          *INFO);

//-- ztgsna --------------------------------------------------------------------
void
LAPACK_IMPL(ztgsna)(const char               *JOB,
                    const char               *HOWMNY,
                    const LOGICAL            *SELECT,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    const DOUBLE_COMPLEX     *VL,
                    const INTEGER            *LDVL,
                    const DOUBLE_COMPLEX     *VR,
                    const INTEGER            *LDVR,
                    DOUBLE                   *S,
                    DOUBLE                   *DIF,
                    const INTEGER            *MM,
                    INTEGER                  *M,
                    DOUBLE_COMPLEX           *WORK,
                    const INTEGER            *LWORK,
                    INTEGER                  *IWORK,
                    INTEGER                  *INFO);

//-- ztgsy2 --------------------------------------------------------------------
void
LAPACK_IMPL(ztgsy2)(const char               *TRANS,
                    const INTEGER            *IJOB,
                    const INTEGER            *M,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    DOUBLE_COMPLEX           *C,
                    const INTEGER            *LDC,
                    const DOUBLE_COMPLEX     *D,
                    const INTEGER            *LDD,
                    const DOUBLE_COMPLEX     *E,
                    const INTEGER            *LDE,
                    DOUBLE_COMPLEX           *F,
                    const INTEGER            *LDF,
                    DOUBLE                   *SCALE,
                    DOUBLE                   *RDSUM,
                    DOUBLE                   *RDSCAL,
                    INTEGER                  *INFO);

//-- ztgsyl --------------------------------------------------------------------
void
LAPACK_IMPL(ztgsyl)(const char               *TRANS,
                    const INTEGER            *IJOB,
                    const INTEGER            *M,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    DOUBLE_COMPLEX           *C,
                    const INTEGER            *LDC,
                    const DOUBLE_COMPLEX     *D,
                    const INTEGER            *LDD,
                    const DOUBLE_COMPLEX     *E,
                    const INTEGER            *LDE,
                    DOUBLE_COMPLEX           *F,
                    const INTEGER            *LDF,
                    DOUBLE                   *SCALE,
                    DOUBLE                   *DIF,
                    DOUBLE_COMPLEX           *WORK,
                    const INTEGER            *LWORK,
                    INTEGER                  *IWORK,
                    INTEGER                  *INFO);

//-- ztpcon --------------------------------------------------------------------
void
LAPACK_IMPL(ztpcon)(const char               *NORM,
                    const char               *UPLO,
                    const char               *DIAG,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *AP,
                    DOUBLE                   *RCOND,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- ztprfs --------------------------------------------------------------------
void
LAPACK_IMPL(ztprfs)(const char               *UPLO,
                    const char               *TRANS,
                    const char               *DIAG,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *AP,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    const DOUBLE_COMPLEX     *X,
                    const INTEGER            *LDX,
                    DOUBLE                   *FERR,
                    DOUBLE                   *BERR,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- ztptri --------------------------------------------------------------------
void
LAPACK_IMPL(ztptri)(const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *AP,
                    INTEGER          *INFO);

//-- ztptrs --------------------------------------------------------------------
void
LAPACK_IMPL(ztptrs)(const char               *UPLO,
                    const char               *TRANS,
                    const char               *DIAG,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *AP,
                    DOUBLE_COMPLEX           *B,
                    const INTEGER            *LDB,
                    INTEGER                  *INFO);

//-- ztpttf --------------------------------------------------------------------
void
LAPACK_IMPL(ztpttf)(const char               *TRANSR,
                    const char               *UPLO,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *AP,
                    DOUBLE_COMPLEX           *ARF,
                    INTEGER                  *INFO);

//-- ztpttr --------------------------------------------------------------------
void
LAPACK_IMPL(ztpttr)(const char               *UPLO,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *AP,
                    DOUBLE_COMPLEX           *A,
                    const INTEGER            *LDA,
                    INTEGER                  *INFO);

//-- ztrcon --------------------------------------------------------------------
void
LAPACK_IMPL(ztrcon)(const char               *NORM,
                    const char               *UPLO,
                    const char               *DIAG,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    DOUBLE                   *RCOND,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- ztrevc --------------------------------------------------------------------
void
LAPACK_IMPL(ztrevc)(const char       *SIDE,
                    const char       *HOWMNY,
                    const LOGICAL    *SELECT,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *T,
                    const INTEGER    *LDT,
                    DOUBLE_COMPLEX   *VL,
                    const INTEGER    *LDVL,
                    DOUBLE_COMPLEX   *VR,
                    const INTEGER    *LDVR,
                    const INTEGER    *MM,
                    INTEGER          *M,
                    DOUBLE_COMPLEX   *WORK,
                    DOUBLE           *RWORK,
                    INTEGER          *INFO);

//-- ztrexc --------------------------------------------------------------------
void
LAPACK_IMPL(ztrexc)(const char       *COMPQ,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *T,
                    const INTEGER    *LDT,
                    DOUBLE_COMPLEX   *Q,
                    const INTEGER    *LDQ,
                    const INTEGER    *IFST,
                    const INTEGER    *ILST,
                    INTEGER          *INFO);

//-- ztrrfs --------------------------------------------------------------------
void
LAPACK_IMPL(ztrrfs)(const char               *UPLO,
                    const char               *TRANS,
                    const char               *DIAG,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    const DOUBLE_COMPLEX     *X,
                    const INTEGER            *LDX,
                    DOUBLE                   *FERR,
                    DOUBLE                   *BERR,
                    DOUBLE_COMPLEX           *WORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- ztrsen --------------------------------------------------------------------
void
LAPACK_IMPL(ztrsen)(const char       *JOB,
                    const char       *COMPQ,
                    const LOGICAL    *SELECT,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *T,
                    const INTEGER    *LDT,
                    DOUBLE_COMPLEX   *Q,
                    const INTEGER    *LDQ,
                    DOUBLE_COMPLEX   *W,
                    INTEGER          *M,
                    DOUBLE           *S,
                    DOUBLE           *SEP,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- ztrsna --------------------------------------------------------------------
void
LAPACK_IMPL(ztrsna)(const char               *JOB,
                    const char               *HOWMNY,
                    const LOGICAL            *SELECT,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *T,
                    const INTEGER            *LDT,
                    const DOUBLE_COMPLEX     *VL,
                    const INTEGER            *LDVL,
                    const DOUBLE_COMPLEX     *VR,
                    const INTEGER            *LDVR,
                    DOUBLE                   *S,
                    DOUBLE                   *SEP,
                    const INTEGER            *MM,
                    INTEGER                  *M,
                    DOUBLE_COMPLEX           *WORK,
                    const INTEGER            *LDWORK,
                    DOUBLE                   *RWORK,
                    INTEGER                  *INFO);

//-- ztrsyl --------------------------------------------------------------------
void
LAPACK_IMPL(ztrsyl)(const char               *TRANA,
                    const char               *TRANB,
                    const INTEGER            *ISGN,
                    const INTEGER            *M,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    const DOUBLE_COMPLEX     *B,
                    const INTEGER            *LDB,
                    DOUBLE_COMPLEX           *C,
                    const INTEGER            *LDC,
                    DOUBLE                   *SCALE,
                    INTEGER                  *INFO);

//-- ztrti2 --------------------------------------------------------------------
void
LAPACK_IMPL(ztrti2)(const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- ztrtri --------------------------------------------------------------------
void
LAPACK_IMPL(ztrtri)(const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO);

//-- ztrtrs --------------------------------------------------------------------
void
LAPACK_IMPL(ztrtrs)(const char               *UPLO,
                    const char               *TRANS,
                    const char               *DIAG,
                    const INTEGER            *N,
                    const INTEGER            *NRHS,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    DOUBLE_COMPLEX           *B,
                    const INTEGER            *LDB,
                    INTEGER                  *INFO);

//-- ztrttf --------------------------------------------------------------------
void
LAPACK_IMPL(ztrttf)(const char               *TRANSR,
                    const char               *UPLO,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    DOUBLE_COMPLEX           *ARF,
                    INTEGER                  *INFO);

//-- ztrttp --------------------------------------------------------------------
void
LAPACK_IMPL(ztrttp)(const char               *UPLO,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA,
                    DOUBLE_COMPLEX           *AP,
                    INTEGER                  *INFO);

//-- ztzrqf --------------------------------------------------------------------
void
LAPACK_IMPL(ztzrqf)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *TAU,
                    INTEGER          *INFO);

//-- ztzrzf --------------------------------------------------------------------
void
LAPACK_IMPL(ztzrzf)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE_COMPLEX   *A,
                    const INTEGER    *LDA,
                    DOUBLE_COMPLEX   *TAU,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- zunbdb --------------------------------------------------------------------
void
LAPACK_IMPL(zunbdb)(const char       *TRANS,
                    const char       *SIGNS,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *Q,
                    DOUBLE_COMPLEX   *X11,
                    const INTEGER    *LDX11,
                    DOUBLE_COMPLEX   *X12,
                    const INTEGER    *LDX12,
                    DOUBLE_COMPLEX   *X21,
                    const INTEGER    *LDX21,
                    DOUBLE_COMPLEX   *X22,
                    const INTEGER    *LDX22,
                    DOUBLE           *THETA,
                    DOUBLE           *PHI,
                    DOUBLE_COMPLEX   *TAUP1,
                    DOUBLE_COMPLEX   *TAUP2,
                    DOUBLE_COMPLEX   *TAUQ1,
                    DOUBLE_COMPLEX   *TAUQ2,
                    DOUBLE_COMPLEX   *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO);

//-- zuncsd --------------------------------------------------------------------
void
LAPACK_IMPL(zuncsd)(const char               *JOBU1,
                    const char               *JOBU2,
                    const char               *JOBV1T,
                    const char               *JOBV2T,
                    const char               *TRANS,
                    const char               *SIGNS,
                    const INTEGER            *M,
                    const INTEGER            *P,
                    const INTEGER            *Q,
                    const DOUBLE_COMPLEX     *X11,
                    const INTEGER            *LDX11,
                    const DOUBLE_COMPLEX     *X12,
                    const INTEGER            *LDX12,
                    const DOUBLE_COMPLEX     *X21,
                    const INTEGER            *LDX21,
                    const DOUBLE_COMPLEX     *X22,
                    const INTEGER            *LDX22,
                    DOUBLE                   *THETA,
                    DOUBLE_COMPLEX           *U1,
                    const INTEGER            *LDU1,
                    DOUBLE_COMPLEX           *U2,
                    const INTEGER            *LDU2,
                    DOUBLE_COMPLEX           *V1T,
                    const INTEGER            *LDV1T,
                    DOUBLE_COMPLEX           *V2T,
                    const INTEGER            *LDV2T,
                    DOUBLE_COMPLEX           *WORK,
                    const INTEGER            *LWORK,
                    DOUBLE                   *RWORK,
                    const INTEGER            *LRWORK,
                    INTEGER                  *IWORK,
                    INTEGER                  *INFO);

//-- zung2l --------------------------------------------------------------------
void
LAPACK_IMPL(zung2l)(const INTEGER            *M,
                    const INTEGER            *N,
                    const INTEGER            *K,
                    DOUBLE_COMPLEX           *A,
                    const INTEGER            *LDA,
                    const DOUBLE_COMPLEX     *TAU,
                    DOUBLE_COMPLEX           *WORK,
                    INTEGER                  *INFO);

//-- zung2r --------------------------------------------------------------------
void
LAPACK_IMPL(zung2r)(const INTEGER            *M,
                    const INTEGER            *N,
                    const INTEGER            *K,
                    DOUBLE_COMPLEX           *A,
                    const INTEGER            *LDA,
                    const DOUBLE_COMPLEX     *TAU,
                    DOUBLE_COMPLEX           *WORK,
                    INTEGER                  *INFO);

//-- zungbr --------------------------------------------------------------------
void
LAPACK_IMPL(zungbr)(const char               *VECT,
                    const INTEGER            *M,
                    const INTEGER            *N,
                    const INTEGER            *K,
                    DOUBLE_COMPLEX           *A,
                    const INTEGER            *LDA,
                    const DOUBLE_COMPLEX     *TAU,
                    DOUBLE_COMPLEX           *WORK,
                    const INTEGER            *LWORK,
                    INTEGER                  *INFO);

//-- zunghr --------------------------------------------------------------------
void
LAPACK_IMPL(zunghr)(const INTEGER            *N,
                    const INTEGER            *ILO,
                    const INTEGER            *IHI,
                    DOUBLE_COMPLEX           *A,
                    const INTEGER            *LDA,
                    const DOUBLE_COMPLEX     *TAU,
                    DOUBLE_COMPLEX           *WORK,
                    const INTEGER            *LWORK,
                    INTEGER                  *INFO);

//-- zungl2 --------------------------------------------------------------------
void
LAPACK_IMPL(zungl2)(const INTEGER            *M,
                    const INTEGER            *N,
                    const INTEGER            *K,
                    DOUBLE_COMPLEX           *A,
                    const INTEGER            *LDA,
                    const DOUBLE_COMPLEX     *TAU,
                    DOUBLE_COMPLEX           *WORK,
                    INTEGER                  *INFO);

//-- zunglq --------------------------------------------------------------------
void
LAPACK_IMPL(zunglq)(const INTEGER            *M,
                    const INTEGER            *N,
                    const INTEGER            *K,
                    DOUBLE_COMPLEX           *A,
                    const INTEGER            *LDA,
                    const DOUBLE_COMPLEX     *TAU,
                    DOUBLE_COMPLEX           *WORK,
                    const INTEGER            *LWORK,
                    INTEGER                  *INFO);

//-- zungql ----------------------