# Поведение прокрутки страницы

При переходе между страницами в рамках клиентской маршрутизации, можно сохранять позицию прокрутки для каждой записи в истории (что обычно делают браузеры при работе с традиционными приложениями), или же прокручивать страницу наверх. `vue-router` позволяет использовать оба варианта, и даже более того — позволяет полностью настроить поведение прокрутки при навигации.

**Примечание: эта возможность работает если браузер поддерживает `history.pushState`.**

При создании экземпляра маршрутизатора, вы можете указать функцию `scrollBehavior`:

```js
const router = new VueRouter({
  routes: [...],
  scrollBehavior (to, from, savedPosition) {
    // возвращаем требуемую позицию прокрутки
  }
})
```

Функция `scrollBehavior` получает объекты маршрутов `to` и `from`. В третьем параметре, `savedPosition`, передаётся сохранённая в истории браузера позиция прокрутки (только в случае `popstate`-перехода, вызванного нажатием кнопок вперёд/назад в браузере).

Функция возвращает объект позиции прокрутки. Он может иметь одну из двух форм:

- `{ x: number, y: number }`
- `{ selector: string, offset? : { x: number, y: number }}` (offset поддерживается в 2.6.0+)

Если возвращается пустой объект или значение, приводимое к ложному, прокрутки не будет.

Например:

```js
scrollBehavior (to, from, savedPosition) {
  return { x: 0, y: 0 }
}
```

Таким образом мы заставим браузер прокручивать к началу каждой открытой страницы.

Возврат `savedPosition` позволяет эмулировать нативное поведение браузера при использовании кнопок назад/вперёд:

```js
scrollBehavior (to, from, savedPosition) {
  if (savedPosition) {
    return savedPosition
  } else {
    return { x: 0, y: 0 }
  }
}
```

Эмулировать поведение "прокрутки к якорю" на странице можно так:

```js
scrollBehavior (to, from, savedPosition) {
  if (to.hash) {
    return {
      selector: to.hash
      // , offset: { x: 0, y: 10 }
    }
  }
}
```

Можно также использовать [метаданные путей](meta.md) для более сложного управления прокруткой. Полную реализацию этого подхода можно посмотреть в [этом примере](https://github.com/vuejs/vue-router/blob/dev/examples/scroll-behavior/app.js).

## Асинхронная прокрутка

> Добавлено в версии 2.8.0

Можно также вернуть Promise, который разрешится объектом с желаемой позицией прокрутки:

```js
scrollBehavior (to, from, savedPosition) {
  return new Promise((resolve, reject) => {
    setTimeout(() => {
      resolve({ x: 0, y: 0 })
    }, 500)
  })
}
```

Это можно связать с событиями компонента transition на уровне страницы, чтобы реализовать такое поведение прокрутки, которое сочетается с анимациями перехода между страницами, но из-за множества возможных вариантов и комплексности примеров, мы просто предоставляем этот простой пример, чтобы показать где можно разместить собственную реализацию.
