/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "vdk/button.h"
#include "vdk/colors.h"

static char * small_tick_xpm[] = {
"22 22 4 1",
" 	c None",
".	c #000000000000",
"X	c #820782078207",
"o	c #FFFFFFFFFFFF",
"                      ",
"                      ",
"                      ",
"                      ",
"                      ",
"                .X.   ",
"               XoX.   ",
"              XoX.    ",
"             XoX.     ",
"       X    XoX.      ",
"      XoX  Xo..       ",
"     Xo  X.o X.       ",
"     .X   o ..        ",
"     ..X    X.        ",
"      ..X  X.         ",
"       ..X X.         ",
"        ..X.          ",
"         ...          ",
"          .           ",
"                      ",
"                      ",
"                      "};

#include <vdk/tooltips.h>
VDKButton::VDKButton(VDKForm* owner,char* tipString):
  VDKAbstractButton(owner)
{
  def_pixmap = NULL;
  widget = gtk_button_new();
  box = gtk_hbox_new(FALSE,0);
  gtk_container_border_width(GTK_CONTAINER(box),0);
  if(tipString)
    tip = new VDKTooltip(owner,this,tipString);
  else
    tip = NULL;
  gtk_signal_connect(GTK_OBJECT(widget),"clicked",
		     GTK_SIGNAL_FUNC(VDKObject::VDKSignalPipe),
		     (gpointer) &s_clicked);
  gtk_signal_connect(GTK_OBJECT(widget),"enter",
		     GTK_SIGNAL_FUNC(VDKObject::VDKSignalPipe),
		     (gpointer) &s_enter);
  gtk_signal_connect(GTK_OBJECT(widget),"leave",
		     GTK_SIGNAL_FUNC(VDKObject::VDKSignalPipe),
		     (gpointer) &s_leave);
  ConnectDefaultSignals();
#ifdef USE_SIGCPLUSPLUS
  make_gtksigc_connection(this, widget);
#endif // USE_SIGCPLUSPLUS
}


void 
VDKButton::_add_default()
{
  GdkBitmap *mask;
  GtkStyle* style = gtk_widget_get_style(Owner()->Window());
  def_pixmap = gdk_pixmap_create_from_xpm_d(Owner()->Window()->window,
					    &mask,
					    &style->bg[GTK_STATE_NORMAL],
					    small_tick_xpm);
  GtkWidget* pixmapWidget = gtk_pixmap_new(def_pixmap,mask);
  gtk_box_pack_start(GTK_BOX(box),pixmapWidget,FALSE,FALSE,1);
  gtk_widget_show(pixmapWidget);
  GTK_WIDGET_SET_FLAGS(Widget(),GTK_CAN_DEFAULT);
  gtk_widget_grab_default(Widget());
}





















