# 2024-06-03 Triage Log

A quiet week; we did have one quite serious regression (#115105, "enable
DestinationPropagation by default"), but it was shortly reverted (#125794).
The only other PR identified as potentially problematic was rollup
[PR #125824](https://github.com/rust-lang/rust/pull/125824), but even
that is relatively limited in its effect.

Triage done by **@pnkfelix**.
Revision range: [a59072ec..1d52972d](https://perf.rust-lang.org/?start=a59072ec4fb6824213df5e9de8cae4812fd4fe97&end=1d52972dd8592edf4026aa577c8ce69acc0ac2d1&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.9%  | [0.2%, 2.0%]   | 28    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.2%, 0.6%]   | 6     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-1.2%, -0.2%] | 30    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.9%, -0.2%] | 24    |
| All ❌✅ (primary)                 | 0.2%  | [-1.2%, 2.0%]  | 58    |


3 Regressions, 5 Improvements, 6 Mixed; 4 of them in rollups
57 artifact comparisons made in total

#### Regressions

Rollup of 5 pull requests [#125649](https://github.com/rust-lang/rust/pull/125649) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c0d600385bb96cc23d3de8615ee37c01abba6c8a&end=f989d2f62500df1696eb797d8800a705293b43b9&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.3%  | [0.5%, 2.1%]   | 12    |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.4%]   | 3     |
| Improvements ✅ <br /> (primary)   | -0.1% | [-0.1%, -0.1%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 1.2%  | [-0.1%, 2.1%]  | 13    |

* all 12 of the regressing primary benchmarks are diesel-1.4.8 (in a variety of configurations).
* problem was isolated to PR #125089 (improve diagnostic output of non_local_definitions lint)
* Urgau notes: "The lint triggers nearly 150 times in the version of diesel used by rustc-perf, so the benchmark has become a bit a linting machinery benchmark"
* cc rustc-perf#1819
* marked as triaged.

Rollup of 5 pull requests [#125665](https://github.com/rust-lang/rust/pull/125665) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8c4db851a7bb64173832e6602638204ebbd373a8&end=274499dd0ff53b81e93b80520f7afe25adaa2812&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5% | [0.5%, 0.5%] | 1     |
| Regressions ❌ <br /> (secondary)  | 0.4% | [0.2%, 0.5%] | 7     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.5% | [0.5%, 0.5%] | 1     |

* helloworld is sole primary regression.
* marked as triaged (my own opinion is that helloworld is a useful canary when it regresses by a more significant amount than this)
* (also the 30-day history shows the story for helloworld to be quite a bit more complicated than what is presented by the effects of this single PR, there are lots of spikes mixed in there)

fn_arg_sanity_check: fix panic message [#125695](https://github.com/rust-lang/rust/pull/125695) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5870f1ccbbb2661c92cdc356231386210a64d723&end=4cf5723dbe471ef0a32857b968b91498551f5e38&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8% | [0.8%, 0.9%] | 4     |
| Regressions ❌ <br /> (secondary)  | 0.5% | [0.2%, 1.5%] | 19    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.8% | [0.8%, 0.9%] | 4     |

* helloworld is the sole primary regression.
* (already) marked as triaged

#### Improvements

Omit non-needs_drop drop_in_place in vtables [#122662](https://github.com/rust-lang/rust/pull/122662) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7717a306b2678ba9ece19b723c76a6b3a89ba931&end=8c4db851a7bb64173832e6602638204ebbd373a8&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-1.5%, -0.2%] | 9     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-1.0%, -0.2%] | 18    |
| All ❌✅ (primary)                 | -0.6% | [-1.5%, -0.2%] | 9     |

* improvements are to helloworld-opt and regex-opt.
* small but seems real given nature of PR (largely a binary size reduction)

Update cargo [#125682](https://github.com/rust-lang/rust/pull/125682) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=274499dd0ff53b81e93b80520f7afe25adaa2812&end=da159eb331b27df528185c616b394bb0e1d2a4bd&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.6%, -0.5%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.5%, -0.2%] | 12    |
| All ❌✅ (primary)                 | -0.5% | [-0.6%, -0.5%] | 3     |

* improvements are to helloworld-check
* probably just noise

Stabilize `custom_code_classes_in_docs` feature [#124577](https://github.com/rust-lang/rust/pull/124577) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=466be510af95d377a4e9997a6ab7c4db5f91e9ec&end=05965ae238403d8c141170b411245a62aa046240&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.8%, -0.2%] | 9     |
| Improvements ✅ <br /> (secondary) | -0.7% | [-0.9%, -0.5%] | 2     |
| All ❌✅ (primary)                 | -0.4% | [-0.8%, -0.2%] | 9     |

* improvements are to various doc-full benchmarks.
* Probably measurement bias (unless somehow the stability checks are a noticeable expense?)

Increase vtable layout size [#123572](https://github.com/rust-lang/rust/pull/123572) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=acaf0aeed0dfbfc4be9f996344e2c5f294cf5794&end=f2208b32971faba7fa6bf09bd0821adbf3db0c00&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.6%, -0.2%] | 10    |
| All ❌✅ (primary)                 | -     | -              | 0     |

* all "improvements" are to secondary benchmarks: unify-linearly, match-stress, and unused-warnings
* (the improvement from this PR is expected to be realized in runtime performance, especially for code heavy with vtable lookups. Its unsurprising that it wouldn't have a noticeable effect on the compiler tooolchain.)

Avoid checking the edition as much as possible [#125828](https://github.com/rust-lang/rust/pull/125828) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=eda9d7f987de76b9d61c633a6ac328936e1b94f0&end=a6416d8907bc94ef1a032d54cb0443cde963e455&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.3%] | 6     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.5%, -0.3%] | 4     |
| All ❌✅ (primary)                 | -0.4% | [-0.4%, -0.3%] | 6     |

* this is recovering performance that was lost in PR #123865

#### Mixed

Create const block DefIds in typeck instead of ast lowering [#124650](https://github.com/rust-lang/rust/pull/124650) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f989d2f62500df1696eb797d8800a705293b43b9&end=7717a306b2678ba9ece19b723c76a6b3a89ba931&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.2%]   | 3     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.6%, -0.3%] | 6     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 1     |
| All ❌✅ (primary)                 | -0.3% | [-0.6%, 0.2%]  | 8     |

* as previously noted by @lqd : "Tiny changes, and overall more gains than losses, probably not worth investigation effort imho."
* marking as triaged

Rollup of 8 pull requests [#125691](https://github.com/rust-lang/rust/pull/125691) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=da159eb331b27df528185c616b394bb0e1d2a4bd&end=751691271d76b8435559200b84d1947c2bd735bd&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.4%, 0.4%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 1.2%  | [1.2%, 1.2%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.6%, -0.4%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 1     |
| All ❌✅ (primary)                 | -0.2% | [-0.6%, 0.4%]  | 3     |

* regression to image-opt-full
* improvements to webrender-2022-opt-full and regex-opt-incr-patched
* had a broad (if small) improvement to binary sizes, which was isolated to PR #124251
* overall wins seem to outweigh losses; marking as triaged.

don't inhibit random field reordering on repr(packed(1)) [#125360](https://github.com/rust-lang/rust/pull/125360) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4cf5723dbe471ef0a32857b968b91498551f5e38&end=f2e1a3a80ae54734e1a3d306f31c2caebb05de9b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.9%  | [0.6%, 1.3%]   | 13    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.4%, 0.4%]   | 2     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-0.8%, -0.7%] | 4     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.7%, -0.3%] | 13    |
| All ❌✅ (primary)                 | 0.5%  | [-0.8%, 1.3%]  | 17    |

* regressed bitmaps and typenum; improved helloworld
* instruction counts were affected but not cycle counts; [one theory is that object code has extra offset computations or niche computations...](https://github.com/rust-lang/rust/pull/125360#issuecomment-2137781620)
* since cycle count was not affected, does not seem worth further investigation; marking as triaged

Enable DestinationPropagation by default. [#115105](https://github.com/rust-lang/rust/pull/115105) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=91c0823ee63e793d990bb9fed898dc95b5d6db51&end=cfb730450f847bb622243eaaab15e77e58d91767&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.0%  | [0.3%, 3.4%]   | 18    |
| Regressions ❌ <br /> (secondary)  | 1.3%  | [0.3%, 3.3%]   | 22    |
| Improvements ✅ <br /> (primary)   | -0.5% | [-4.0%, -0.2%] | 23    |
| Improvements ✅ <br /> (secondary) | -0.8% | [-1.6%, -0.2%] | 18    |
| All ❌✅ (primary)                 | 0.2%  | [-4.0%, 3.4%]  | 41    |

* was reverted due to injecting [big regression for "Building stage1 codegen backend gcc"](https://github.com/rust-lang/rust/pull/115105#issuecomment-2141019310)
* marking as triaged

Revert "Auto merge of #115105 - cjgillot:dest-prop-default, r=oli-obk" [#125794](https://github.com/rust-lang/rust/pull/125794) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=434999efe6e9aa61afbd8b4ae86864d3ce91c533&end=366da30d554719e7490950aeea5d3f3a5927e313&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 4.2%]   | 18    |
| Regressions ❌ <br /> (secondary)  | 0.8%  | [0.1%, 1.5%]   | 20    |
| Improvements ✅ <br /> (primary)   | -1.0% | [-3.2%, -0.3%] | 15    |
| Improvements ✅ <br /> (secondary) | -1.5% | [-3.1%, -0.4%] | 18    |
| All ❌✅ (primary)                 | -0.2% | [-3.2%, 4.2%]  | 33    |

* revert of above PR
* marking as triaged

Rollup of 7 pull requests [#125824](https://github.com/rust-lang/rust/pull/125824) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2a2c29aafa50bf6fe53d66b32070eba59f860ac3&end=ada5e2c7b5427a591e30baeeee2698a5eb6db0bd&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%  | [0.5%, 1.1%]   | 3     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.4%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.4%  | [-0.4%, 1.1%]  | 4     |

* instruction-counts regressed webrender-2022-opt-full, cargo-opt-{incr-patched, full}
* cycle-counts regressed webrender-2022-opt-{full, incr-full}, cranelift-codegen-opt-incr-full, and clap-opt-incr-patched
* history view for webrender shows that the cycle-count effect seems real though not quite as pronounced as the original measurements indicate.
* there are many potential candidates for the cause here in this rollup.
* not marking as triaged; doing some followup perf runs on individual PR's
