---
layout: post
title: Polyglot 1.10 - i18n_headers improvements
lang: en
description: Jekyll Polyglot 1.10.0 release, with improvements to SEO generation when using the i18n_headers plugin
---

Jekyll-Polyglot 1.10 is now available. It has vast improvements and changes to the `i18n_headers` liquid plugin for SEO improvements, and minor adjustments for parallel build idempotency. Community Contributions and Vibe Coding helped with a large portion of these release features, testing and blog post.

This version of polyglot now requires ruby >= 3.1 , which may break in build systems.

## i18n_headers improvements

the `i18n_headers` plugin now has extended capabilities as part of this release:

* it will add `<link rel="canonical" ...>` for each page language, so indexing is unique across sites.
* it will add `<link rel="alternate" hreflang="x-default" ...>` to point to default language version of a site, when no matching language is requested by the browser.
* it will correctly define `<link rel="alternate" hreflang="..." >` for pages and posts in collections with custom permalinks.
* the default url will now include the `site.baseUrl` if defined

this additionally fixes a bug noticed that caused absolute url relativization to mangle these tags unintentionally. 

## vibe-coded contributions

Using certain [vibe coding](https://en.wikipedia.org/wiki/Vibe_coding) tools have helped find, measure and verify bug fixes and features for this release.
This is a new approach for software development, and it created advanced ruby tests against jekyll plugin code running against many built site languages.

The tests written with vibe coding helped ensure the code coverage remained high, and complex features could be added with confidence. Ensuring the test automation was in place ensured tricky features could be built correctly.

Additionally vibe coding tools helped translate this blog post into many languages.

## community contributions

Jekyll-Polyglot has been supported by humans. Human language documentation is contributed by humans who want to see this plugin documented in their native tongue. Humans contributing bug fixes and documentation are what have helped this plugin reach thousands of downloads a release. AI assisted programming, in my hands or yours, will shape the software we use, and in the many languages we write and speak.

## ruby >= 3.1 required

Ongoing security updates to jekyll-polyglot build-time dependencies required a major version upgrade to ruby 3.1 . This may affect build systems that build their docs with jekyll-polyglot. But now is a good time to upgrade to the latest ruby major by now. Speak up if these changes cause complications with jekyll builds.