/* Generated by re2c */

#include <stddef.h> /* size_t */
#include <stdio.h>
#include <stdlib.h> /* malloc, free */
#include <string.h> /* memcpy */

static void *read_file
    ( const char *fname
    , size_t unit
    , size_t padding
    , size_t *pfsize
    )
{
    void *buffer = NULL;
    size_t fsize = 0;

    /* open file */
    FILE *f = fopen(fname, "rb");
    if (f == NULL) {
        goto error;
    }

    /* get file size */
    fseek(f, 0, SEEK_END);
    fsize = (size_t) ftell(f) / unit;
    fseek(f, 0, SEEK_SET);

    /* allocate memory for file and padding */
    buffer = malloc(unit * (fsize + padding));
    if (buffer == NULL) {
        goto error;
    }

    /* read the whole file in memory */
    if (fread(buffer, unit, fsize, f) != fsize) {
        goto error;
    }

    fclose(f);
    *pfsize = fsize;
    return buffer;

error:
    fprintf(stderr, "error: cannot read file '%s'\n", fname);
    free(buffer);
    if (f != NULL) {
        fclose(f);
    }
    return NULL;
}

#define YYCTYPE unsigned char
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYSHIFT(o) cursor += o
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { goto loop_end; }

static int action_line125
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line125: control flow is undefined"
                " for input at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line125: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line125(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line125: not enough keys\n");
    return 1;
}

int lex_line125()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line125.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    keys = (YYKEYTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line125.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    i = 0;
loop:
    if (!(status == 0 && cursor < eof && i < keys_count)) goto loop_end;
    {
        token = cursor;
        YYCTYPE yych;
        static const unsigned char yybm[] = {
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128,   0, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128,   0, 128, 128, 128, 128,   0, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
        };

        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
        if (yybm[0+yych] & 128) {
            goto yy1;
        }
        if (yych <= '#') goto yy2;
        if (yych <= ':') goto yy3;
        goto yy4;
yy1:
        YYSKIP();
        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
        if (yybm[0+yych] & 128) {
            goto yy1;
        }
        status = check_key_count_line125(keys_count, i, 3)
             || action_line125(&i, keys, input, token, &cursor, 3);
        goto loop;
yy2:
        YYSKIP();
        status = check_key_count_line125(keys_count, i, 3)
             || action_line125(&i, keys, input, token, &cursor, 2);
        goto loop;
yy3:
        YYSKIP();
        status = check_key_count_line125(keys_count, i, 3)
             || action_line125(&i, keys, input, token, &cursor, 0);
        goto loop;
yy4:
        YYSKIP();
        status = check_key_count_line125(keys_count, i, 3)
             || action_line125(&i, keys, input, token, &cursor, 1);
        goto loop;

    }
loop_end:
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line125: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line125: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned char
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYSHIFT(o) cursor += o
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { goto loop_end; }

static int action_line313
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line313: control flow is undefined"
                " for input at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line313: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line313(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line313: not enough keys\n");
    return 1;
}

int lex_line313()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line313.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    keys = (YYKEYTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line313.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    i = 0;
loop:
    if (!(status == 0 && cursor < eof && i < keys_count)) goto loop_end;
    {
        token = cursor;
        YYCTYPE yych;
        static const unsigned char yybm[] = {
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128,   0, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
        };

        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
        if (yybm[0+yych] & 128) {
            goto yy6;
        }
        goto yy7;
yy6:
        YYSKIP();
        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
        if (yybm[0+yych] & 128) {
            goto yy6;
        }
        status = check_key_count_line313(keys_count, i, 3)
             || action_line313(&i, keys, input, token, &cursor, 1);
        goto loop;
yy7:
        YYSKIP();
        status = check_key_count_line313(keys_count, i, 3)
             || action_line313(&i, keys, input, token, &cursor, 0);
        goto loop;

    }
loop_end:
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line313: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line313: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned char
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYSHIFT(o) cursor += o
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { goto loop_end; }

static int action_line320
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line320: control flow is undefined"
                " for input at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line320: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line320(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line320: not enough keys\n");
    return 1;
}

int lex_line320()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line320.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    keys = (YYKEYTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line320.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    i = 0;
loop:
    if (!(status == 0 && cursor < eof && i < keys_count)) goto loop_end;
    {
        token = cursor;
        YYCTYPE yych;
        static const unsigned char yybm[] = {
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0, 128,   0,   0,   0,   0,   0, 
              0, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128,   0,   0,   0,   0,   0, 
              0, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
        };

        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
        if (yybm[0+yych] & 128) {
            goto yy9;
        }
        YYSKIP();
        status = check_key_count_line320(keys_count, i, 3)
             || action_line320(&i, keys, input, token, &cursor, 1);
        goto loop;
yy9:
        YYSKIP();
        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
        if (yybm[0+yych] & 128) {
            goto yy9;
        }
        status = check_key_count_line320(keys_count, i, 3)
             || action_line320(&i, keys, input, token, &cursor, 0);
        goto loop;

    }
loop_end:
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line320: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line320: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned char
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYSHIFT(o) cursor += o
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { goto loop_end; }

static int action_line330
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line330: control flow is undefined"
                " for input at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line330: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line330(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line330: not enough keys\n");
    return 1;
}

int lex_line330()
{
    const size_t padding = 2; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line330.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    keys = (YYKEYTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line330.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    i = 0;
loop:
    if (!(status == 0 && cursor < eof && i < keys_count)) goto loop_end;
    {
        token = cursor;
        YYCTYPE yych;
        static const unsigned char yybm[] = {
              0,   0,   0,   0,   0,   0,   0,   0, 
              0, 128, 128, 128,   0, 128,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
            128,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
        };

        if (YYLESSTHAN(2)) YYFILL(2);
        yych = YYPEEK();
        {
            static void *yytarget[256] = {
                &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
                &&yy11, &&yy13, &&yy13, &&yy13, &&yy11, &&yy13, &&yy11, &&yy11,
                &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
                &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
                &&yy13, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
                &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy14,
                &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
                &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy15, &&yy11,
                &&yy11, &&yy16, &&yy16, &&yy16, &&yy16, &&yy16, &&yy16, &&yy16,
                &&yy16, &&yy16, &&yy16, &&yy16, &&yy16, &&yy16, &&yy16, &&yy16,
                &&yy16, &&yy16, &&yy16, &&yy16, &&yy16, &&yy16, &&yy16, &&yy16,
                &&yy16, &&yy16, &&yy16, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
                &&yy11, &&yy16, &&yy16, &&yy16, &&yy16, &&yy16, &&yy16, &&yy16,
                &&yy16, &&yy16, &&yy16, &&yy16, &&yy16, &&yy16, &&yy16, &&yy16,
                &&yy16, &&yy16, &&yy16, &&yy16, &&yy16, &&yy16, &&yy16, &&yy16,
                &&yy16, &&yy16, &&yy16, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
                &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
                &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
                &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
                &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
                &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
                &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
                &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
                &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
                &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
                &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
                &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
                &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
                &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
                &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
                &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
                &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11
            };
            goto *yytarget[yych];
        }
yy11:
        YYSKIP();
yy12:
        status = check_key_count_line330(keys_count, i, 3)
             || action_line330(&i, keys, input, token, &cursor, 3);
        goto loop;
yy13:
        YYSKIP();
        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
        if (yybm[0+yych] & 128) {
            goto yy13;
        }
        status = check_key_count_line330(keys_count, i, 3)
             || action_line330(&i, keys, input, token, &cursor, 1);
        goto loop;
yy14:
        YYSKIP();
        yych = YYPEEK();
        if (yych != '>') goto yy12;
yy15:
        YYSKIP();
        status = check_key_count_line330(keys_count, i, 3)
             || action_line330(&i, keys, input, token, &cursor, 0);
        goto loop;
yy16:
        YYSKIP();
        status = check_key_count_line330(keys_count, i, 3)
             || action_line330(&i, keys, input, token, &cursor, 2);
        goto loop;

    }
loop_end:
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line330: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line330: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned char
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYSHIFT(o) cursor += o
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { goto loop_end; }

static int action_line339
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line339: control flow is undefined"
                " for input at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line339: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line339(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line339: not enough keys\n");
    return 1;
}

int lex_line339()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line339.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    keys = (YYKEYTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line339.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    i = 0;
loop:
    if (!(status == 0 && cursor < eof && i < keys_count)) goto loop_end;
    {
        token = cursor;
        YYCTYPE yych;
        static const unsigned char yybm[] = {
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0, 128,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128,   0,   0,   0,   0,   0, 
              0, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
        };

        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
        if (yych <= '@') goto yy18;
        if (yych <= 'Z') goto yy19;
        if (yych <= '`') goto yy18;
        if (yych <= 'z') goto yy19;
yy18:
        YYSKIP();
        status = check_key_count_line339(keys_count, i, 3)
             || action_line339(&i, keys, input, token, &cursor, 1);
        goto loop;
yy19:
        YYSKIP();
        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
        if (yybm[0+yych] & 128) {
            goto yy19;
        }
        status = check_key_count_line339(keys_count, i, 3)
             || action_line339(&i, keys, input, token, &cursor, 0);
        goto loop;

    }
loop_end:
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line339: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line339: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned char
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYBACKUP() marker = cursor
#define YYRESTORE() cursor = marker
#define YYSHIFT(o) cursor += o
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { goto loop_end; }

static int action_line346
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line346: control flow is undefined"
                " for input at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line346: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line346(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line346: not enough keys\n");
    return 1;
}

int lex_line346()
{
    const size_t padding = 2; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line346.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    keys = (YYKEYTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line346.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    i = 0;
loop:
    if (!(status == 0 && cursor < eof && i < keys_count)) goto loop_end;
    {
        token = cursor;
        const YYCTYPE *marker = NULL;
        YYCTYPE yych;
        static const unsigned char yybm[] = {
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
            128,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
        };

        if (YYLESSTHAN(2)) YYFILL(2);
        yych = YYPEEK();
        if (yych == ' ') goto yy22;
        if (yych == '=') goto yy23;
        YYSKIP();
yy21:
        status = check_key_count_line346(keys_count, i, 3)
             || action_line346(&i, keys, input, token, &cursor, 1);
        goto loop;
yy22:
        YYSKIP();
        YYBACKUP();
        yych = YYPEEK();
        if (yych == ' ') goto yy24;
        if (yych != '=') goto yy21;
yy23:
        YYSKIP();
        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
        if (yybm[0+yych] & 128) {
            goto yy23;
        }
        status = check_key_count_line346(keys_count, i, 3)
             || action_line346(&i, keys, input, token, &cursor, 0);
        goto loop;
yy24:
        YYSKIP();
        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
        if (yych == ' ') goto yy24;
        if (yych == '=') goto yy23;
        YYRESTORE();
        goto yy21;

    }
loop_end:
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line346: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line346: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYBACKUP
#undef YYRESTORE
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned char
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYBACKUP() marker = cursor
#define YYRESTORE() cursor = marker
#define YYSHIFT(o) cursor += o
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { goto loop_end; }

static int action_line354
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line354: control flow is undefined"
                " for input at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line354: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line354(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line354: not enough keys\n");
    return 1;
}

int lex_line354()
{
    const size_t padding = 2; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line354.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    keys = (YYKEYTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line354.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    i = 0;
loop:
    if (!(status == 0 && cursor < eof && i < keys_count)) goto loop_end;
    {
        token = cursor;
        const YYCTYPE *marker = NULL;
        YYCTYPE yych;
        static const unsigned char yybm[] = {
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 192, 192, 224, 224, 192, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            192, 224, 128, 224, 224, 224, 224,  64, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224,   0, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
        };

        if (YYLESSTHAN(2)) YYFILL(2);
        yych = YYPEEK();
        if (yybm[0+yych] & 32) {
            goto yy26;
        }
        if (yych <= ' ') goto yy27;
        if (yych <= '"') goto yy29;
        if (yych <= '\'') goto yy30;
        goto yy27;
yy26:
        YYSKIP();
        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
        if (yybm[0+yych] & 32) {
            goto yy26;
        }
        status = check_key_count_line354(keys_count, i, 3)
             || action_line354(&i, keys, input, token, &cursor, 2);
        goto loop;
yy27:
        YYSKIP();
yy28:
        status = check_key_count_line354(keys_count, i, 3)
             || action_line354(&i, keys, input, token, &cursor, 3);
        goto loop;
yy29:
        YYSKIP();
        YYBACKUP();
        yych = YYPEEK();
        if (yych == '>') goto yy28;
        goto yy32;
yy30:
        YYSKIP();
        YYBACKUP();
        yych = YYPEEK();
        if (yych == '>') goto yy28;
        goto yy36;
yy31:
        YYSKIP();
        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
yy32:
        if (yybm[0+yych] & 64) {
            goto yy31;
        }
        if (yych <= '"') goto yy34;
yy33:
        YYRESTORE();
        goto yy28;
yy34:
        YYSKIP();
        status = check_key_count_line354(keys_count, i, 3)
             || action_line354(&i, keys, input, token, &cursor, 0);
        goto loop;
yy35:
        YYSKIP();
        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
yy36:
        if (yybm[0+yych] & 128) {
            goto yy35;
        }
        if (yych >= '(') goto yy33;
        YYSKIP();
        status = check_key_count_line354(keys_count, i, 3)
             || action_line354(&i, keys, input, token, &cursor, 1);
        goto loop;

    }
loop_end:
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line354: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line354: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYBACKUP
#undef YYRESTORE
#undef YYLESSTHAN
#undef YYFILL

int main()
{
    if (lex_line125() != 0) {
        return 1;
    }
    if (lex_line313() != 0) {
        return 1;
    }
    if (lex_line320() != 0) {
        return 1;
    }
    if (lex_line330() != 0) {
        return 1;
    }
    if (lex_line339() != 0) {
        return 1;
    }
    if (lex_line346() != 0) {
        return 1;
    }
    if (lex_line354() != 0) {
        return 1;
    }
    return 0;
}
  #:?#:?#:?		#

:?#

:?#:?#:?#:?#:?#:?#:  ?!!#"":$$?%%#&&:''?((#)):**?++#,,:--?..#//:00?11#22:33?44#55:66?77#88:99?;;#<<:==?>>#@@:AA?BB#CC:DD?EE#FF:GG?HH#II:JJ?KK#LL:MM?NN#OO:PP?QQ#RR:SS?TT#UU:VV?WW#XX:YY?ZZ#[[:\\?]]#^^:__?``#aa:bb?cc#dd:ee?ff#gg:hh?ii#jj:kk?ll#mm:nn?oo#pp:qq?rr#ss:tt?uu#vv:ww?xx#yy:zz?{{#||:}}?~~#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?# #:?#:?#:?	#
:?#
:?#:?#:?#:?#:?#:?#: ?!#":$?%#&:'?(#):*?+#,:-?.#/:0?1#2:3?4#5:6?7#8:9?;#<:=?>#@:A?B#C:D?E#F:G?H#I:J?K#L:M?N#O:P?Q#R:S?T#U:V?W#X:Y?Z#[:\?]#^:_?`#a:b?c#d:e?f#g:h?i#j:k?l#m:n?o#p:q?r#s:t?u#v:w?x#y:z?{#|:}?~#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?##:?   <<<<<<<<<		<

<<<

<<<<<<<<<<<<<<<<<<<  <!!<""<##<$$<%%<&&<''<((<))<**<++<,,<--<..<//<00<11<22<33<44<55<66<77<88<99<::<;;<==<>><??<@@<AA<BB<CC<DD<EE<FF<GG<HH<II<JJ<KK<LL<MM<NN<OO<PP<QQ<RR<SS<TT<UU<VV<WW<XX<YY<ZZ<[[<\\<]]<^^<__<``<aa<bb<cc<dd<ee<ff<gg<hh<ii<jj<kk<ll<mm<nn<oo<pp<qq<rr<ss<tt<uu<vv<ww<xx<yy<zz<{{<||<}}<~~<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< <<<<<<<<<	<
<<<
<<<<<<<<<<<<<<<<<<< <!<"<#<$<%<&<'<(<)<*<+<,<-<.</<0<1<2<3<4<5<6<7<8<9<:<;<=<><?<@<A<B<C<D<E<F<G<H<I<J<K<L<M<N<O<P<Q<R<S<T<U<V<W<X<Y<Z<[<\<]<^<_<`<a<b<c<d<e<f<g<h<i<j<k<l<m<n<o<p<q<r<s<t<u<v<w<x<y<z<{<|<}<~<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  	

 !"#$%&'()*+,-./0123456789;<=>?@[\]^_`{|}~:: AABBCCDDEEFFGGHHII	JJ
KKLLMM
NNOOPPQQRRSSTTUUVVWWXXYYZZaabbccddeeff gg!hh"ii#jj$kk%ll&mm'nn(oo)pp*qq+rr,ss-tt.uu/vv0ww1xx2yy3zz4::5AA6BB7CC8DD9EE;FF<GG=HH>II?JJ@KK[LL\MM]NN^OO_PP`QQ{RR|SS}TT~UUVVWWXXYYZZaabbccddeeffgghhiijjkkllmmnnooppqqrrssttuuvvwwxxyyzz::AABBCCDDEEFFGGHHIIJJKKLLMMNNOOPPQQRRSSTTUUVVWWXXYYZZaabbccddeeffgghhiijjkkllmmnnooppqqrrssttuuvvwwxxyyzz::AABBCCDDEEFFGGHHIIJJKKLLMMNNOOPPQQRRSSTTUUVVWWXXYYZZaabbccddeeffgghhiijjkkllmmnnooppqq: ABCDEFGHI	J
KLM
NOPQRSTUVWXYZabcdef g!h"i#j$k%l&m'n(o)p*q+r,s-t.u/v0w1x2y3z4:5A6B7C8D9E;F<G=H>I?J@K[L\M]N^O_P`Q{R|S}T~UVWXYZabcdefghijklmnopqrstuvwxyz:ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz:ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopq                                                                                                                                                                                                                                                                                                                                                                                                                       !"#$%&'()*+,-.0123456789:;<=?@[\]^_`{|}~		 



  		



  		



  		



  		



  		



!  "		#

$%

&  '		(

)*

+  ,		-

./

0  1		2

34

5  6		7

89

:  ;		<

=>

?  @		A

BC

D  E		F

GH

I  J		K

LM

N  O		P

QR

S  T		U

VW

X  Y		Z

[\

]  ^		_

`a

b  c		d

ef

g  h		i

jk

l  m		n

op

q  r		s

tu

v  w		x

yz

{  |		}

~

  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  			 

 	

 	

 	

 	

 	

! "	#
$%
& '	(
)*
+ ,	-
./
0 1	2
34
5 6	7
89
: ;	<
=>
? @	A
BC
D E	F
GH
I J	K
LM
N O	P
QR
S T	U
VW
X Y	Z
[\
] ^	_
`a
b c	d
ef
g h	i
jk
l m	n
op
q r	s
tu
v w	x
yz
{ |	}
~
 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	/>/ /////////	/
///
/////////////////// /!/"/#/$/%/&/'/(/)/*/+/,/-/.///0/1/2/3/4/5/6/7/8/9/:/;/</=/?/@/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/[/\/]/^/_/`/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/{/|/}/~/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////>ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz   	

 !"#$%&'()*+,-./0123456789:;<=>?@[\]^_`{|}~A- BACBDCEDFEGFHGIHJI	KJ
LKMLNM
ONPOQPRQSRTSUTVUWVXWYXZYaZbacbdcedfegf hg!ih"ji#kj$lk%ml&nm'on(po)qp*rq+sr,ts.ut/vu0wv1xw2yx3zy4Az5B-6CA7DB8EC9FD:GE;HF<IG=JH>KI?LJ@MK[NL\OM]PN^QO_RP`SQ{TR|US}VT~WUXVYWZXaYbZcadbecfdgehfigjhkiljmknlompnqorpsqtrusvtwuxvywzxAyBzC-DAEBFCGDHEIFJGKHLIMJNKOLPMQNROSPTQURVSWTXUYVZWaXbYcZdaebfcgdheifjgkhlimjnkolpmqnrosptqurvswtxuyvzwAxByCzD-EAFBGCHDIEJFKGLHMINJOKPLQMRNSOTPUQVRWSXTYUZVaWbXcYdZeafbgchdiejfkglhminjokplqmrnsotpuqA BCDEFGHIJ	K
LMN
OPQRSTUVWXYZabcdefg h!i"j#k$l%m&n'o(p)q*r+s,t.u/v0w1x2y3z4A5B6C7D8E9F:G;H<I=J>K?L@M[N\O]P^Q_R`S{T|U}V~WXYZabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstu                                                                                                                                                                                                                                                                                                                                                                                                                       	

!"#$%&'()*+,-./0123456789:;<>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~ =   =  =  =  =  =  =  =  =  = 	 = 
 =  =  = 
 =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  = ! = " = # = $ = % = & = ' = ( = ) = * = + = , = - = . = / = 0 = 1 = 2 = 3 = 4 = 5 = 6 = 7 = 8 = 9 = : = ; = < = = = > = ? = @ = A = B = C = D = E = F = G = H = I = J = K = L = M = N = O = P = Q = R = S = T = U = V = W = X = Y = Z = [ = \ = ] = ^ = _ = ` = a = b = c = d = e = f = g = h = i = j = k = l = m = n = o = p = q = r = s = t = u = v = w = x = y = z = { = | = } = ~ =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  = = = = = = = = =	 =
 = = =
 = = = = = = = = = = = = = = = = = = =! =" =# =$ =% =& =' =( =) =* =+ =, =- =. =/ =0 =1 =2 =3 =4 =5 =6 =7 =8 =9 =: =; =< == => =? =@ =A =B =C =D =E =F =G =H =I =J =K =L =M =N =O =P =Q =R =S =T =U =V =W =X =Y =Z =[ =\ =] =^ =_ =` =a =b =c =d =e =f =g =h =i =j =k =l =m =n =o =p =q =r =s =t =u =v =w =x =y =z ={ =| =} =~ = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =  =   =  =  =  =  =  =  =  =  =	  =
  =  =  =
  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =!  ="  =#  =$  =%  =&  ='  =(  =)  =*  =+  =,  =-  =.  =/  =0  =1  =2  =3  =4  =5  =6  =7  =8  =9  =:  =;  =<  ==  =>  =?  =@  =A  =B  =C  =D  =E  =F  =G  =H  =I  =J  =K  =L  =M  =N  =O  =P  =Q  =R  =S  =T  =U  =V  =W  =X  =Y  =Z  =[  =\  =]  =^  =_  =`  =a  =b  =c  =d  =e  =f  =g  =h  =i  =j  =k  =l  =m  =n  =o  =p  =q  =r  =s  =t  =u  =v  =w  =x  =y  =z  ={  =|  =}  =~  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =   =    =   =   =   =   =   =   =   =   =	   =
   =   =   =
   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =!   ="   =#   =$   =%   =&   ='   =(   =)   =*   =+   =,   =-   =.   =/   =0   =1   =2   =3   =4   =5   =6   =7   =8   =9   =:   =;   =<   ==   =>   =?   =@   =A   =B   =C   =D   =E   =F   =G   =H   =I   =J   =K   =L   =M   =N   =O   =P   =Q   =R   =S   =T   =U   =V   =W   =X   =Y   =Z   =[   =\   =]   =^   =_   =`   =a   =b   =c   =d   =e   =f   =g   =h   =i   =j   =k   =l   =m   =n   =o   =p   =q   =r   =s   =t   =u   =v   =w   =x   =y   =z   ={   =|   =}   =~   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =                               	   
         
                                                         !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /   0   1   2   3   4   5   6   7   8   9   :   ;   <   >   ?   @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O   P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _   `   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o   p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~                                                                                                                                                                                                                                                                                                                                                                                                                        	  
      
                                      !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                                                                                                                                                                                                                                                             	 
   
                   ! " # $ % & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < > ? @ A B C D E F G H I J K L M N O P Q R S T U V W X Y Z [ \ ] ^ _ ` a b c d e f g h i j k l m n o p q r s t u v w x y z { | } ~                                                                                                                                 = =========	=
===
===================!="=#=$=%=&='=(=)=*=+=,=-=.=/=0=1=2=3=4=5=6=7=8=9=:=;=<===>=?=@=A=B=C=D=E=F=G=H=I=J=K=L=M=N=O=P=Q=R=S=T=U=V=W=X=Y=Z=[=\=]=^=_=`=a=b=c=d=e=f=g=h=i=j=k=l=m=n=o=p=q=r=s=t=u=v=w=x=y=z={=|=}=~=================================================================================================================================                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             	

 "'>	

 "'>	

 "'>	

 "'>	!!
##
$$ %%"&&'((>))	**
++
,, --"..'//>00	11
22
33 44"55'66>77	88
99
:: ;;"<<'==>??	@@
AA
BB CC"DD'EE>FF	GG
HH
II JJ"KK'LL>MM	NN
OO
PP QQ"RR'SS>TT	UU
VV
WW XX"YY'ZZ>[[	\\
]]
^^ __"``'aa>bb	cc
dd
ee ff"gg'hh>ii	jj
kk
ll mm"nn'oo>pp	qq
rr
ss tt"uu'vv>ww	xx
yy
zz {{"||'}}>~~	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

  	

 "'>	

 "'>	

 "'>	

 "'>	!
#
$ %"&'(>)	*
+
, -".'/>0	1
2
3 4"5'6>7	8
9
: ;"<'=>?	@
A
B C"D'E>F	G
H
I J"K'L>M	N
O
P Q"R'S>T	U
V
W X"Y'Z>[	\
]
^ _"`'a>b	c
d
e f"g'h>i	j
k
l m"n'o>p	q
r
s t"u'v>w	x
y
z {"|'}>~	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 	

 >"  """"""""""""""""""		""

""""""

""""""""""""""""""""""""""""""""""""""  ""!!""##""$$""%%""&&""''""((""))""**""++"",,""--""..""//""00""11""22""33""44""55""66""77""88""99""::"";;""<<""==""??""@@""AA""BB""CC""DD""EE""FF""GG""HH""II""JJ""KK""LL""MM""NN""OO""PP""QQ""RR""SS""TT""UU""VV""WW""XX""YY""ZZ""[[""\\""]]""^^""__""``""aa""bb""cc""dd""ee""ff""gg""hh""ii""jj""kk""ll""mm""nn""oo""pp""qq""rr""ss""tt""uu""vv""ww""xx""yy""zz""{{""||""}}""~~""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""  >">">">">">">">">"		>"

>">">"

>">">">">">">">">">">">">">">">">">">"  >"!!>"##>"$$>"%%>"&&>"''>"((>"))>"**>"++>",,>"-->"..>"//>"00>"11>"22>"33>"44>"55>"66>"77>"88>"99>"::>";;>"<<>"==>"??>"@@>"AA>"BB>"CC>"DD>"EE>"FF>"GG>"HH>"II>"JJ>"KK>"LL>"MM>"NN>"OO>"PP>"QQ>"RR>"SS>"TT>"UU>"VV>"WW>"XX>"YY>"ZZ>"[[>"\\>"]]>"^^>"__>"``>"aa>"bb>"cc>"dd>"ee>"ff>"gg>"hh>"ii>"jj>"kk>"ll>"mm>"nn>"oo>"pp>"qq>"rr>"ss>"tt>"uu>"vv>"ww>"xx>"yy>"zz>"{{>"||>"}}>"~~>">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">" """"""""""""""""""	""
""""""
"""""""""""""""""""""""""""""""""""""" ""!""#""$""%""&""'""("")""*""+"",""-"".""/""0""1""2""3""4""5""6""7""8""9"":"";""<""=""?""@""A""B""C""D""E""F""G""H""I""J""K""L""M""N""O""P""Q""R""S""T""U""V""W""X""Y""Z""[""\""]""^""_""`""a""b""c""d""e""f""g""h""i""j""k""l""m""n""o""p""q""r""s""t""u""v""w""x""y""z""{""|""}""~"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""" >">">">">">">">">"	>"
>">">"
>">">">">">">">">">">">">">">">">">">" >"!>"#>"$>"%>"&>"'>"(>")>"*>"+>",>"->".>"/>"0>"1>"2>"3>"4>"5>"6>"7>"8>"9>":>";>"<>"=>"?>"@>"A>"B>"C>"D>"E>"F>"G>"H>"I>"J>"K>"L>"M>"N>"O>"P>"Q>"R>"S>"T>"U>"V>"W>"X>"Y>"Z>"[>"\>"]>"^>"_>"`>"a>"b>"c>"d>"e>"f>"g>"h>"i>"j>"k>"l>"m>"n>"o>"p>"q>"r>"s>"t>"u>"v>"w>"x>"y>"z>"{>"|>"}>"~>">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">""">'  ''''''''''''''''''		''

''''''

''''''''''''''''''''''''''''''''''''''  ''!!''""''##''$$''%%''&&''((''))''**''++'',,''--''..''//''00''11''22''33''44''55''66''77''88''99''::'';;''<<''==''??''@@''AA''BB''CC''DD''EE''FF''GG''HH''II''JJ''KK''LL''MM''NN''OO''PP''QQ''RR''SS''TT''UU''VV''WW''XX''YY''ZZ''[[''\\'']]''^^''__''``''aa''bb''cc''dd''ee''ff''gg''hh''ii''jj''kk''ll''mm''nn''oo''pp''qq''rr''ss''tt''uu''vv''ww''xx''yy''zz''{{''||''}}''~~''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''  >'>'>'>'>'>'>'>'>'		>'

>'>'>'

>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'  >'!!>'"">'##>'$$>'%%>'&&>'((>'))>'**>'++>',,>'-->'..>'//>'00>'11>'22>'33>'44>'55>'66>'77>'88>'99>'::>';;>'<<>'==>'??>'@@>'AA>'BB>'CC>'DD>'EE>'FF>'GG>'HH>'II>'JJ>'KK>'LL>'MM>'NN>'OO>'PP>'QQ>'RR>'SS>'TT>'UU>'VV>'WW>'XX>'YY>'ZZ>'[[>'\\>']]>'^^>'__>'``>'aa>'bb>'cc>'dd>'ee>'ff>'gg>'hh>'ii>'jj>'kk>'ll>'mm>'nn>'oo>'pp>'qq>'rr>'ss>'tt>'uu>'vv>'ww>'xx>'yy>'zz>'{{>'||>'}}>'~~>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>' ''''''''''''''''''	''
''''''
'''''''''''''''''''''''''''''''''''''' ''!''"''#''$''%''&''('')''*''+'',''-''.''/''0''1''2''3''4''5''6''7''8''9'':'';''<''=''?''@''A''B''C''D''E''F''G''H''I''J''K''L''M''N''O''P''Q''R''S''T''U''V''W''X''Y''Z''[''\'']''^''_''`''a''b''c''d''e''f''g''h''i''j''k''l''m''n''o''p''q''r''s''t''u''v''w''x''y''z''{''|''}''~'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''' >'>'>'>'>'>'>'>'>'	>'
>'>'>'
>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>' >'!>'">'#>'$>'%>'&>'(>')>'*>'+>',>'->'.>'/>'0>'1>'2>'3>'4>'5>'6>'7>'8>'9>':>';>'<>'=>'?>'@>'A>'B>'C>'D>'E>'F>'G>'H>'I>'J>'K>'L>'M>'N>'O>'P>'Q>'R>'S>'T>'U>'V>'W>'X>'Y>'Z>'[>'\>']>'^>'_>'`>'a>'b>'c>'d>'e>'f>'g>'h>'i>'j>'k>'l>'m>'n>'o>'p>'q>'r>'s>'t>'u>'v>'w>'x>'y>'z>'{>'|>'}>'~>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'''>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             