% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flextable_sizes.R
\name{dim_pretty}
\alias{dim_pretty}
\title{Calculate optimal column widths and row heights}
\usage{
dim_pretty(x, part = "all", unit = "in", hspans = "none")
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{part}{part selector, see section \emph{Part selection with the \code{part}
parameter} in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.
Value 'all' can be used.}

\item{unit}{unit for returned values, one of "in", "cm", "mm".}

\item{hspans}{specifies how cells that are horizontally are included in the calculation.
It must be one of the following values "none", "divided" or "included". If
"none", widths of horizontally spanned cells is set to 0 (then do not affect the
widths); if "divided", widths of horizontally spanned cells is divided by
the number of spanned cells; if "included", all widths (included horizontally
spanned cells) will be used in the calculation.}
}
\description{
return minimum estimated widths and heights for
each table columns and rows in inches.
}
\examples{
ftab <- flextable(head(mtcars))
dim_pretty(ftab)
}
\seealso{
Other functions for flextable size management: 
\code{\link{autofit}()},
\code{\link{dim.flextable}()},
\code{\link{fit_to_width}()},
\code{\link{flextable_dim}()},
\code{\link{height}()},
\code{\link{hrule}()},
\code{\link{ncol_keys}()},
\code{\link{nrow_part}()},
\code{\link{width}()}
}
\concept{functions for flextable size management}
