// REQUIRES: riscv
// RUN: llvm-mc -filetype=obj -triple=riscv64 %s -o %t.o
// RUN: ld.lld %t.o -o %t.so -shared --noinhibit-exec 2>&1 | FileCheck %s --check-prefix=WARN
// RUN: llvm-readelf -S %t.so | FileCheck --check-prefix=SEC %s
// RUN: llvm-objdump --no-print-imm-hex -s -d %t.so | FileCheck %s

// SEC: .got PROGBITS 0000000000002390

  .section .data
  .globl bar
bar:

  .globl _start
_start:  // PC = 0x33a8
// %gotpcrel(bar)   = 0x2398 (got entry for `bar`) - 0x33a8 (.) = 0xf0efffff
// %gotpcrel(bar+4) = 0x2398 (got entry for `bar`) - 0x33ac (.) + 4 = 0xf0efffff
// %gotpcrel(bar-4) = 0x2398 (got entry for `bar`) - 0x33b0 (.) - 4 = 0xe4efffff
// CHECK:      Contents of section .data:
// CHECK-NEXT:  {{.*}} f0efffff f0efffff e4efffff
  .word %gotpcrel(bar)
  .word %gotpcrel(bar+4)
  .word %gotpcrel(bar-4)

// WARN: relocation R_RISCV_GOT32_PCREL out of range: {{.*}} is not in [-2147483648, 2147483647]; references 'baz'
// WARN: relocation R_RISCV_GOT32_PCREL out of range: {{.*}} is not in [-2147483648, 2147483647]; references 'baz'
  .word %gotpcrel(baz+0xffffffff)
  .word %gotpcrel(baz-0xffffffff)
