/*************************************************************************
* Copyright (C) 2002 Intel Corporation
*
* Licensed under the Apache License,  Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* 	http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law  or agreed  to  in  writing,  software
* distributed under  the License  is  distributed  on  an  "AS IS"  BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the  specific  language  governing  permissions  and
* limitations under the License.
*************************************************************************/

/*
//
//  Purpose:
//     Cryptography Primitive.
//     Digesting message according to SHA256
//
//  Contents:
//        ippsHashMethodSet_SHA256()
//
*/

#include "owndefs.h"
#include "owncp.h"
#include "hash/pcphash.h"
#include "hash/pcphash_rmf.h"
#include "pcptool.h"
#include "hash/sha256/pcpsha256stuff.h"

/*F*
//    Name: ippsHashMethodSet_SHA256
//
// Purpose: Setup SHA256 method.
//
// Returns:                Reason:
//    ippStsNullPtrErr        pMethod == NULL
//    ippStsNoErr             no errors
//
*F*/
IPPFUN(IppStatus, ippsHashMethodSet_SHA256, (IppsHashMethod * pMethod))
{
    /* test pointers */
    IPP_BAD_PTR1_RET(pMethod);

    pMethod->hashAlgId     = ippHashAlg_SHA256;
    pMethod->hashLen       = IPP_SHA256_DIGEST_BITSIZE / 8;
    pMethod->msgBlkSize    = MBS_SHA256;
    pMethod->msgLenRepSize = MLR_SHA256;
    pMethod->stateLen      = IPP_SHA256_STATE_BYTESIZE;
    pMethod->hashInit      = sha256_hashInit;
    pMethod->hashUpdate    = sha256_hashUpdate;
    pMethod->hashOctStr    = sha256_hashOctString;
    pMethod->msgLenRep     = sha256_msgRep;

    return ippStsNoErr;
}
