// Code generated by gqlclientgen - DO NOT EDIT.

package pagessrht

import (
	"context"
	"encoding/json"
	"fmt"
	gqlclient "git.sr.ht/~emersion/gqlclient"
)

type AccessKind string

const (
	AccessKindRo AccessKind = "RO"
	AccessKindRw AccessKind = "RW"
)

type AccessScope string

const (
	AccessScopeProfile AccessScope = "PROFILE"
	AccessScopeSites   AccessScope = "SITES"
	AccessScopePages   AccessScope = "PAGES"
)

type Cursor string

type Entity struct {
	Id      int32          `json:"id"`
	Created gqlclient.Time `json:"created"`
	Updated gqlclient.Time `json:"updated"`
	// The canonical name of this entity. For users, this is their username
	// prefixed with '~'. Additional entity types will be supported in the future.
	CanonicalName string `json:"canonicalName"`

	// Underlying value of the GraphQL interface
	Value EntityValue `json:"-"`
}

func (base *Entity) UnmarshalJSON(b []byte) error {
	type Raw Entity
	var data struct {
		*Raw
		TypeName string `json:"__typename"`
	}
	data.Raw = (*Raw)(base)
	err := json.Unmarshal(b, &data)
	if err != nil {
		return err
	}
	switch data.TypeName {
	case "User":
		base.Value = new(User)
	case "":
		return nil
	default:
		return fmt.Errorf("gqlclient: interface Entity: unknown __typename %q", data.TypeName)
	}
	return json.Unmarshal(b, base.Value)
}

// EntityValue is one of: User
type EntityValue interface {
	isEntity()
}

// Provides a way to configure options for a set of files matching the glob
// pattern.
type FileConfig struct {
	Glob    string      `json:"glob"`
	Options FileOptions `json:"options"`
}

// Options for a file being served.
type FileOptions struct {
	// Value of the Cache-Control header to be used when serving the file.
	CacheControl *string `json:"cacheControl,omitempty"`
}

type OAuthClient struct {
	Uuid string `json:"uuid"`
}

type Protocol string

const (
	ProtocolHttps  Protocol = "HTTPS"
	ProtocolGemini Protocol = "GEMINI"
)

// A published website
type Site struct {
	Id      int32          `json:"id"`
	Created gqlclient.Time `json:"created"`
	Updated gqlclient.Time `json:"updated"`
	// Domain name the site services
	Domain string `json:"domain"`
	// The site protocol
	Protocol Protocol `json:"protocol"`
	// SHA-256 checksum of the source tarball (uncompressed)
	Version string `json:"version"`
	// Path to the file to serve for 404 Not Found responses
	NotFound *string `json:"notFound,omitempty"`
}

type SiteConfig struct {
	// Path to the file to serve for 404 Not Found responses
	NotFound    *string      `json:"notFound,omitempty"`
	FileConfigs []FileConfig `json:"fileConfigs,omitempty"`
}

// A cursor for enumerating site entries
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type SiteCursor struct {
	Results []Site  `json:"results"`
	Cursor  *Cursor `json:"cursor,omitempty"`
}

type SiteEvent struct {
	Uuid  string         `json:"uuid"`
	Event WebhookEvent   `json:"event"`
	Date  gqlclient.Time `json:"date"`
	Site  *Site          `json:"site"`
}

func (*SiteEvent) isWebhookPayload() {}

type User struct {
	Id            int32          `json:"id"`
	Created       gqlclient.Time `json:"created"`
	Updated       gqlclient.Time `json:"updated"`
	CanonicalName string         `json:"canonicalName"`
	Username      string         `json:"username"`
	Email         string         `json:"email"`
	Url           *string        `json:"url,omitempty"`
	Location      *string        `json:"location,omitempty"`
	Bio           *string        `json:"bio,omitempty"`
}

func (*User) isEntity() {}

type UserWebhookInput struct {
	Url    string         `json:"url"`
	Events []WebhookEvent `json:"events"`
	Query  string         `json:"query"`
}

type UserWebhookSubscription struct {
	Id         int32                  `json:"id"`
	Events     []WebhookEvent         `json:"events"`
	Query      string                 `json:"query"`
	Url        string                 `json:"url"`
	Client     *OAuthClient           `json:"client,omitempty"`
	Deliveries *WebhookDeliveryCursor `json:"deliveries"`
	Sample     string                 `json:"sample"`
}

func (*UserWebhookSubscription) isWebhookSubscription() {}

type Version struct {
	Major int32 `json:"major"`
	Minor int32 `json:"minor"`
	Patch int32 `json:"patch"`
	// If this API version is scheduled for deprecation, this is the date on which
	// it will stop working; or null if this API version is not scheduled for
	// deprecation.
	DeprecationDate gqlclient.Time `json:"deprecationDate,omitempty"`
}

type WebhookDelivery struct {
	Uuid         string               `json:"uuid"`
	Date         gqlclient.Time       `json:"date"`
	Event        WebhookEvent         `json:"event"`
	Subscription *WebhookSubscription `json:"subscription"`
	RequestBody  string               `json:"requestBody"`
	// These details are provided only after a response is received from the
	// remote server. If a response is sent whose Content-Type is not text/*, or
	// cannot be decoded as UTF-8, the response body will be null. It will be
	// truncated after 64 KiB.
	ResponseBody    *string `json:"responseBody,omitempty"`
	ResponseHeaders *string `json:"responseHeaders,omitempty"`
	ResponseStatus  *int32  `json:"responseStatus,omitempty"`
}

// A cursor for enumerating a list of webhook deliveries
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type WebhookDeliveryCursor struct {
	Results []WebhookDelivery `json:"results"`
	Cursor  *Cursor           `json:"cursor,omitempty"`
}

type WebhookEvent string

const (
	WebhookEventSitePublished   WebhookEvent = "SITE_PUBLISHED"
	WebhookEventSiteUnpublished WebhookEvent = "SITE_UNPUBLISHED"
)

type WebhookPayload struct {
	Uuid  string         `json:"uuid"`
	Event WebhookEvent   `json:"event"`
	Date  gqlclient.Time `json:"date"`

	// Underlying value of the GraphQL interface
	Value WebhookPayloadValue `json:"-"`
}

func (base *WebhookPayload) UnmarshalJSON(b []byte) error {
	type Raw WebhookPayload
	var data struct {
		*Raw
		TypeName string `json:"__typename"`
	}
	data.Raw = (*Raw)(base)
	err := json.Unmarshal(b, &data)
	if err != nil {
		return err
	}
	switch data.TypeName {
	case "SiteEvent":
		base.Value = new(SiteEvent)
	case "":
		return nil
	default:
		return fmt.Errorf("gqlclient: interface WebhookPayload: unknown __typename %q", data.TypeName)
	}
	return json.Unmarshal(b, base.Value)
}

// WebhookPayloadValue is one of: SiteEvent
type WebhookPayloadValue interface {
	isWebhookPayload()
}

type WebhookSubscription struct {
	Id     int32          `json:"id"`
	Events []WebhookEvent `json:"events"`
	Query  string         `json:"query"`
	Url    string         `json:"url"`
	// If this webhook was registered by an authorized OAuth 2.0 client, this
	// field is non-null.
	Client *OAuthClient `json:"client,omitempty"`
	// All deliveries which have been sent to this webhook.
	Deliveries *WebhookDeliveryCursor `json:"deliveries"`
	// Returns a sample payload for this subscription, for testing purposes
	Sample string `json:"sample"`

	// Underlying value of the GraphQL interface
	Value WebhookSubscriptionValue `json:"-"`
}

func (base *WebhookSubscription) UnmarshalJSON(b []byte) error {
	type Raw WebhookSubscription
	var data struct {
		*Raw
		TypeName string `json:"__typename"`
	}
	data.Raw = (*Raw)(base)
	err := json.Unmarshal(b, &data)
	if err != nil {
		return err
	}
	switch data.TypeName {
	case "UserWebhookSubscription":
		base.Value = new(UserWebhookSubscription)
	case "":
		return nil
	default:
		return fmt.Errorf("gqlclient: interface WebhookSubscription: unknown __typename %q", data.TypeName)
	}
	return json.Unmarshal(b, base.Value)
}

// WebhookSubscriptionValue is one of: UserWebhookSubscription
type WebhookSubscriptionValue interface {
	isWebhookSubscription()
}

// A cursor for enumerating a list of webhook subscriptions
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type WebhookSubscriptionCursor struct {
	Results []WebhookSubscription `json:"results"`
	Cursor  *Cursor               `json:"cursor,omitempty"`
}

func Publish(client *gqlclient.Client, ctx context.Context, domain string, content gqlclient.Upload, protocol Protocol, subdirectory string, siteConfig SiteConfig) (publish *Site, err error) {
	op := gqlclient.NewOperation("mutation publish ($domain: String!, $content: Upload!, $protocol: Protocol!, $subdirectory: String!, $siteConfig: SiteConfig!) {\n\tpublish(domain: $domain, content: $content, protocol: $protocol, subdirectory: $subdirectory, siteConfig: $siteConfig) {\n\t\tdomain\n\t}\n}\n")
	op.Var("domain", domain)
	op.Var("content", content)
	op.Var("protocol", protocol)
	op.Var("subdirectory", subdirectory)
	op.Var("siteConfig", siteConfig)
	var respData struct {
		Publish *Site
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Publish, err
}

func Unpublish(client *gqlclient.Client, ctx context.Context, domain string, protocol Protocol) (unpublish *Site, err error) {
	op := gqlclient.NewOperation("mutation unpublish ($domain: String!, $protocol: Protocol!) {\n\tunpublish(domain: $domain, protocol: $protocol) {\n\t\tdomain\n\t}\n}\n")
	op.Var("domain", domain)
	op.Var("protocol", protocol)
	var respData struct {
		Unpublish *Site
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Unpublish, err
}

func CreateUserWebhook(client *gqlclient.Client, ctx context.Context, config UserWebhookInput) (createUserWebhook *WebhookSubscription, err error) {
	op := gqlclient.NewOperation("mutation createUserWebhook ($config: UserWebhookInput!) {\n\tcreateUserWebhook(config: $config) {\n\t\tid\n\t}\n}\n")
	op.Var("config", config)
	var respData struct {
		CreateUserWebhook *WebhookSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.CreateUserWebhook, err
}

func DeleteUserWebhook(client *gqlclient.Client, ctx context.Context, id int32) (deleteUserWebhook *WebhookSubscription, err error) {
	op := gqlclient.NewOperation("mutation deleteUserWebhook ($id: Int!) {\n\tdeleteUserWebhook(id: $id) {\n\t\tid\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		DeleteUserWebhook *WebhookSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.DeleteUserWebhook, err
}

func Sites(client *gqlclient.Client, ctx context.Context, cursor *Cursor) (sites *SiteCursor, err error) {
	op := gqlclient.NewOperation("query sites ($cursor: Cursor) {\n\tsites(cursor: $cursor) {\n\t\tresults {\n\t\t\tdomain\n\t\t\tprotocol\n\t\t}\n\t\tcursor\n\t}\n}\n")
	op.Var("cursor", cursor)
	var respData struct {
		Sites *SiteCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Sites, err
}

func UserWebhooks(client *gqlclient.Client, ctx context.Context, cursor *Cursor) (userWebhooks *WebhookSubscriptionCursor, err error) {
	op := gqlclient.NewOperation("query userWebhooks ($cursor: Cursor) {\n\tuserWebhooks(cursor: $cursor) {\n\t\tresults {\n\t\t\tid\n\t\t\turl\n\t\t}\n\t\tcursor\n\t}\n}\n")
	op.Var("cursor", cursor)
	var respData struct {
		UserWebhooks *WebhookSubscriptionCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UserWebhooks, err
}
