{-# LANGUAGE ForeignFunctionInterface #-}

#include <bindings.dsl.h>
#include <nettle/chacha-poly1305.h>

module Bindings.Nettle.Cipher.ChaChaPoly1305 where
#strict_import

#num CHACHA_POLY1305_BLOCK_SIZE
#num CHACHA_POLY1305_KEY_SIZE
#num CHACHA_POLY1305_NONCE_SIZE
#num CHACHA_POLY1305_DIGEST_SIZE

#starttype struct chacha_poly1305_ctx
#stoptype

#ccall chacha_poly1305_set_key , Ptr <struct chacha_poly1305_ctx> -> Ptr CUChar -> IO ()
#ccall chacha_poly1305_set_nonce , Ptr <struct chacha_poly1305_ctx> -> Ptr CUChar -> IO ()
#ccall chacha_poly1305_update , Ptr <struct chacha_poly1305_ctx> -> CUInt -> Ptr CUChar -> IO ()
#ccall chacha_poly1305_encrypt , Ptr <struct chacha_poly1305_ctx> -> CUInt -> Ptr CUChar -> Ptr CUChar -> IO ()
#ccall chacha_poly1305_decrypt , Ptr <struct chacha_poly1305_ctx> -> CUInt -> Ptr CUChar -> Ptr CUChar -> IO ()
#ccall chacha_poly1305_digest , Ptr <struct chacha_poly1305_ctx> -> CUInt -> Ptr CUChar -> IO ()
