// testcasetoc.py generated code begin
uint8_t handshake_key[] = { 0xb3, 0x14, 0x88, 0x57, 0xb0, 0x46, 0x5, 0x96, 0x62, 0x37, 0xe0, 0x55, 0xb5, 0x60, 0xc4, 0x6 };
uint8_t ecdh_secret[] = { 0xaa, 0xbc, 0x10, 0x46, 0xd, 0x6d, 0xed, 0x4b, 0x58, 0x33, 0x88, 0xdb, 0xdb, 0x2, 0x86, 0xdb, 0x2d, 0xd8, 0x91, 0x52, 0x37, 0xeb, 0x59, 0x37, 0x42, 0xac, 0xb7, 0x5d, 0x5d, 0x5e, 0x82, 0xb4 };

static const uint8_t crypt_index = 3;
ChiakiGKCrypt gkcrypt;
ChiakiErrorCode err = chiaki_gkcrypt_init(&gkcrypt, NULL, 0, crypt_index, handshake_key, ecdh_secret);
if(err != CHIAKI_ERR_SUCCESS)
	return MUNIT_ERROR;


// -- frame --	ChiakiKeyState key_state;
ChiakiKeyState key_state;
chiaki_key_state_init(&key_state);

uint8_t packet_0[126]; size_t packet_0_size = sizeof(packet_0); if(chiaki_base64_decode("AgAAAAEAAAQBAwlCI7oAAACAA5gAhJT79yG83L9WhXCDP/h48VDjBL03cGscKH6DLQ3ZOzh007JcllEEIpTP3DbJwYAF5MGH2BwWJJTcbZATOGrzCznFMInIL7pWssSgxQBcf2q+u+vECFWQ5zvEQsq4RxQs3bre0DchyEMz", 168, packet_0, &packet_0_size) != CHIAKI_ERR_SUCCESS || packet_0_size != 126) return MUNIT_ERROR;
uint8_t nalu_0[105]; size_t nalu_0_size = sizeof(nalu_0); if(chiaki_base64_decode("AAMAAAABZYiAhn8AL8gD/wh+/miASsv/rw5fm2PYQAAAAwAAAwAFIc42jXIHLchAAAe8A/i2oRmALiO8cB3sEzDosBxyZyFg4KK5rAXoBy0/2EfQAAADAAADAAADAAADAAADAAADAAJq", 140, nalu_0, &nalu_0_size) != CHIAKI_ERR_SUCCESS || nalu_0_size != 105) return MUNIT_ERROR;


ChiakiTakionAVPacket av_packet_0;
memset(&av_packet_0, 0, sizeof(av_packet_0));
chiaki_takion_v9_av_packet_parse(&av_packet_0, &key_state, packet_0, sizeof(packet_0));
munit_assert(av_packet_0.is_video);
munit_assert_size(av_packet_0.data_size, ==, sizeof(nalu_0));
chiaki_gkcrypt_decrypt(&gkcrypt, av_packet_0.key_pos + CHIAKI_GKCRYPT_BLOCK_SIZE, av_packet_0.data, av_packet_0.data_size);
munit_assert_memory_equal(sizeof(nalu_0), av_packet_0.data, nalu_0);


uint8_t packet_1[129]; size_t packet_1_size = sizeof(packet_1); if(chiaki_base64_decode("AgABAAEAIAQBA1qLB8QAAAEAAAAAI6yViW2Gd1ERoIOVS+8J6N4D36erxNa+1CiLmTVZfD+pMvNgT+OSMhXk+tFWDoRga6Nlbn59gIsrQqOeyj7TrFyHsIQdIWc5AAgGBfhi9AX/jVkAcXFy5+4z5Ob/FO4/C5LTEaPXLkvFWdbZ", 172, packet_1, &packet_1_size) != CHIAKI_ERR_SUCCESS || packet_1_size != 129) return MUNIT_ERROR;
uint8_t nalu_1[108]; size_t nalu_1_size = sizeof(nalu_1); if(chiaki_base64_decode("AAMAAAABZYiAhn8AL8gD/wh+/miASsv/rw5fm2PYQAAAAwAAAwAFIc42jXIHLchAAAe8A/i2oRmALiO8cB3sEzDosBxyZyFg4KK5rAXoBy0/2EfQAAADAAADAAADAAADAAADAAADAAJqAAAA", 144, nalu_1, &nalu_1_size) != CHIAKI_ERR_SUCCESS || nalu_1_size != 108) return MUNIT_ERROR;


ChiakiTakionAVPacket av_packet_1;
memset(&av_packet_1, 0, sizeof(av_packet_1));
chiaki_takion_v9_av_packet_parse(&av_packet_1, &key_state, packet_1, sizeof(packet_1));
munit_assert(av_packet_1.is_video);
munit_assert_size(av_packet_1.data_size, ==, sizeof(nalu_1));
chiaki_gkcrypt_decrypt(&gkcrypt, av_packet_1.key_pos + CHIAKI_GKCRYPT_BLOCK_SIZE, av_packet_1.data, av_packet_1.data_size);
munit_assert_memory_equal(sizeof(nalu_1), av_packet_1.data, nalu_1);


uint8_t packet_2[1424]; size_t packet_2_size = sizeof(packet_2); if(chiaki_base64_decode("EgACAAIAAEQBA8fX6tMAAAWAAF4AAAAyCmfH3hbmk3W9636CuDemFcSMDZ6bGzT6hgzm3ohtDQiH+HM913g7g7T+9pTlC/Qq6rPnmCX9UAX7EnjWaPgSook3ZeyAkY2j0T6FhnAg5fdRxJudosanrDvTbb5WWSGkwg/ut/ztG2Z4bD4FPPG9b64D83ln3f96O9NsFOCrsB5iOFVTmWwIlz78BuXTJ3qBUzUyIhQfriQdoDDJud8LeKhqLWlNVlOP8Nbx+I6Hl/wl9ee0rfZuZNsQ66x3cZH2D2blc77cHKgqJyFGen3CQnaaR84fabXXet6EHNkBX/6p87SVIRMfc9DUz/3rGi82c7kKQtyD1E9SH6FGb6KnXJlT7K5HdBJ4jj8+2N4c2L9fyGjv2vaa/I41/+WeBEbkwYmOdKVPEMNQQZCM1EqlKTaKaf52GsqlkfBSk1tkcwmb6tjnVVojGOxa3wV+swozFT2H5L1hQov+E6YFHEcAJ3G+79A9snxJOOZ94fI6Dthsw8qD2Y52Gs2vkJJu1+KzCSiIRD5qkS54S2fspzL1HX9PcyiKurp2vGQITQIEUc6VgcT0ZOqhVj8YJ7d6Q4j9FM3tPFej6Ys9cWZA6nW43WlMrtdhD6pJ9E2cLlKBomUiDNWpW9yKWCjUu2mOE67GG51I0rnIcTvufDK+WaX6NlmEnbg7OTj3xGWGQmrRRfDsHFB1px3CktrMLehPWGZtvz6fyE1wuj0HjiB0ue7733tueqk9xJPzieRq5UTuGyJVaRUOLJpVAHr/CeLEXUDIBQli4e6Gest8UfNmDtefUn95WVdJCR1swSgbNjGTtgyEDJOGHQCXiqK9xUOeGbwSNuUnmXWVFcdctDG1Tr28ulIbM/Rinx/7rGSiVUEpjClexmXrOOZ465jjGOiZe6CLcMf9rYPHaiXEbWcw89MeWiQMn7LIPda68HYBeEPYZN9ihOwMWNN8tFRjfelYavmKrv/VpPr/iMq0kzvxEhAycNHpQEAjRNtvogiPaOAFGyHgTqB8+lQpvf6AW4fp2v6dHMpfV/8JK6diUFb0Ycr65jZ4kxubne/k4UZI+ETOrNy9pHGWDwj3qPc8mFtxlmVKPCm4Ea2OMjkxQqgwbIoyIphdVKHwhjqaxQCC1b+7Xi/i4VpPc04n6TmGQ4ITCHLqPQMxKTn2JdHTtxvipkHnC8D0BX3sRB6ktgAeHo1z0CaUcCEWeyWrnrgnQ0vdZnQGKayELb0svMdVnxKF1OalGsJZ8TfHj4Ys9PQWCU1JUzbQGhuQsbM179rE122pWZLPk7kraViqQq2NiCdEjtn7/tgSalF3D3yit1usVoe6h+SY8x8Qup2lW3YMKiZmbgco4J2lepCDptxJR6ASh1d8qrGjPvSyRJMBxobi7JaG7u7Va8n47OwtCl3X6KgFXHuT2pDLnEdaj2XCy4som3j8VHPWDYLPz6g2mfbePkmq4ogHPxiW7EvECoabFEuBcyp3xPyPbIiaGixETGY1+xoXbD+KNY0uDHSbDRwFISosmuVyVz6eUn/X6gCm9YGpHW+O6YAukrE0gp+0q8rZ9B1PWcidCbsuuCLxPPoQPr3FaDo+khIVl3gh2GtF31NuKJI7W3iSWndUFCALBKD3xaU6n4z0YApENj+8glde358WKlxt9xoe/MxHtF9aCbgqMO+rCaSf4OkCZrOFxZFb2IaVOvSEY3XfdKUwVxreMVIfYd7g2w/PPJbiM4sv/zzHJ7OnNK6vG9jKLp4XznAlcGLFaja48g8Y6CsSaQaImIkw4ZRRsvmif/gQKwRNtPTTpSoLai9udbz592V3B1dVFsqVaBDDjmx8x4ZS0gsw+YjS5++4svlbHFOJnHzSjPOAMDEuc/ONSdX+3G0=", 1900, packet_2, &packet_2_size) != CHIAKI_ERR_SUCCESS || packet_2_size != 1424) return MUNIT_ERROR;
uint8_t nalu_2[1400]; size_t nalu_2_size = sizeof(nalu_2); if(chiaki_base64_decode("AAAAAAABQZoEQi+f4ASkBP/8QW9nJreZ4mlZxu8ZpWqn5dJ7r5pgZIDO0Xv/92AQqshFvRlthKWIEKvbIzWJBTYXkJnzMA+cUNmFVzuBy/0S3aXhO4JsKeQ9q+RAFEm7BECnIqes7Jega69fgZxDsrkfaPNBnbOoX09JcVBFhqBMphwqvpRp/nX8qKy/AN62KakIV7x/qeHcffPA3GfCmX3u2GkyzZnZ79/ALMjifQmc4vPl6B9BdPWZ0U398+tOpqfo0CVWTezXWRC4eFwt0szP3khlpTUiAtHd9vKsL0oaUUMkOn09IlL6Ew7j26PQYyBP+IJ3BIpkpKuwWRqwf2bghibYwmxuzNHQ4MB3RJQURYJwoA8nWUxkicMmMRWhYZ5aK15AxePoq54R39Cz36S3unOYPuHFmSAcywix/J56q4CncP1vzYI9s3vaGVKCaIPbEXA13bXqcyVmf4w8jNi64WsprCjLtbaolk1GUu+f09w04Da7L4RVuUaWQgwaI6RBMbm95APiJDQ4Sd7PJsO+5sSRcgvTES9NVFZI49YjuyLkybuBK9i5FHGnwWHIoaXWviOQbH3gkT5otSbINDjFEr7nwekD0o8DOFRHZw+CLMflTSxvYzdjlsaKu2gOQYTFeai74nuksGgIw8MMMnTh/CN6K79I9V+S1nXIsOikvO9+dbIMPb+3ldyotYPsKdVtwnGlVKDYIdB4LGvTFSAzPgvoS2LfU2qj1P3TRv+zOLPRTw9SgQ/8h1si8iL4jXIdzSB7HQyFtl4k7wEqOTATVt48VRuoH4bEEzH8OnQx9SOxeP4KPLpOx7mU/5dUvCxOKhJPoEwPwQQs2u4GEZKESbbWo4pTo0NeEpGcK9pMJn/sR8Ylq2vcuP+gDF+cHAsbK6C9H6KdxDgt5Q+9y4C3V0MzakhYz5dlYs7zUplr7fcn+Qo/S232G4UJHnAndmCAHyuM9RPrlBRr6Nk4pw7GLRkeB4cQ0D8zLZvDKJD0Lwf4eTBmmaAyKLKmwPdGF5jr1qaYRxL2vEa6CySczQf2guYd9SGNejSo8HNbR+dzlVuk6zBpEseMJFVKkVADb3v27HGjYRWaOCZoQkR+rqGCnQBlK8y0KceVA0AoUXxP+lSEc/OEbRLQv8JOgWGbTLJMu3ep4awMf2c2av7AR2IEIIg/aJKA03k+L2kpNG6HrcDEu42rP/CFNoAtehW07g1fNXr+DVcTuAeyT77eSG9U6ZyQjBAChCSQaEjUevWV3f/w9ZDwbNCxWr0SMVqbSctBnpgmwtXuBRasXRT60JSXFV43pwhkXK19xq0Gj4uAzjDZPqi7vWsZz5dI/J0uBN4MgLxyITTn9T1a8b2Wecd2pIH7/lGHhPuDoeZy6DTHAbatXWIil1kuBFoM0Kr5aJMfloWaX7jyRO7n1KaDBNe1+wcYnco4/UEcyMj7QRBM1QlTupyMdOXMLluozoBLedM6SYDiBurcr5azqBC7RBOFSSKyHEn4h/VpK7eJnfSAAUkU8ktGpdAyfMbWrVjhxCz5uFc+ii2WNXfIW6h9bDvuvork1bT6qnNQi5/g7IwY3kWaEsrvFkwdh7LgWYFcMn32OIxnsRpHl2tUlNeWl3TegKndWViJ5llJ3tI/n/cm8J8g/EMpjssofaqFhYK+vJhTaBif5YvGQWIfBO+2FifcgKuLtMqJhf4Woro72Dklm92PWviukYH++WzOxC5DAIvN4JStGV4pDal1oXPS0za88Jm5+XyJzVAMjNC2CnDA1MQkof7mvRl5JAxNOQgeWnZ2SQ9Y1/Xh2MDCctvTmgcqIsqOEAlKls1piFc0RBykzwuseAy6qorZvxQ910O2cjdhxX/8Ktk=", 1868, nalu_2, &nalu_2_size) != CHIAKI_ERR_SUCCESS || nalu_2_size != 1400) return MUNIT_ERROR;


ChiakiTakionAVPacket av_packet_2;
memset(&av_packet_2, 0, sizeof(av_packet_2));
chiaki_takion_v9_av_packet_parse(&av_packet_2, &key_state, packet_2, sizeof(packet_2));
munit_assert(av_packet_2.is_video);
munit_assert_size(av_packet_2.data_size, ==, sizeof(nalu_2));
chiaki_gkcrypt_decrypt(&gkcrypt, av_packet_2.key_pos + CHIAKI_GKCRYPT_BLOCK_SIZE, av_packet_2.data, av_packet_2.data_size);
munit_assert_memory_equal(sizeof(nalu_2), av_packet_2.data, nalu_2);


uint8_t packet_3[36]; size_t packet_3_size = sizeof(packet_3); if(chiaki_base64_decode("EgADAAIAIEQBA8f0C08AAAsQAF4AAAAxQblNDv49Be5DWfYx", 48, packet_3, &packet_3_size) != CHIAKI_ERR_SUCCESS || packet_3_size != 36) return MUNIT_ERROR;
uint8_t nalu_3[12]; size_t nalu_3_size = sizeof(nalu_3); if(chiaki_base64_decode("BWxK+hg9EhJA95+B", 16, nalu_3, &nalu_3_size) != CHIAKI_ERR_SUCCESS || nalu_3_size != 12) return MUNIT_ERROR;


ChiakiTakionAVPacket av_packet_3;
memset(&av_packet_3, 0, sizeof(av_packet_3));
chiaki_takion_v9_av_packet_parse(&av_packet_3, &key_state, packet_3, sizeof(packet_3));
munit_assert(av_packet_3.is_video);
munit_assert_size(av_packet_3.data_size, ==, sizeof(nalu_3));
chiaki_gkcrypt_decrypt(&gkcrypt, av_packet_3.key_pos + CHIAKI_GKCRYPT_BLOCK_SIZE, av_packet_3.data, av_packet_3.data_size);
munit_assert_memory_equal(sizeof(nalu_3), av_packet_3.data, nalu_3);


uint8_t packet_4[1424]; size_t packet_4_size = sizeof(packet_4); if(chiaki_base64_decode("EgAEAAIAQEQBA1XntcEAAAswAEsAACAypBtYe/N0T4u57Dqsubrk17PQHW8ELyAvaAo/sXzXxU9mPfmnlUiZMXdo6RntpHLZArAW93u0fu9vR9s26Zsp5LB8s/tDFK3EVPUuwddk4bXcGCYS4iUYglddDw6pSfGc2Ps5uC0Nv1prJow/dEDbaMAAgvSyymVBhU1y0Jp/wOv86IiXlXWw5WIZ6L7Q9Zpt4NVBGyXJHETAyWAlw/j97Dczay6TOQ/oGBXG7rE4yhkeDZW7WHv8i/6mXAgROy9S2lqwz4/S7XC8wkBfrGBRZ9O/MZH2/zm0n9Y6PvN28zfy5FLj6K0tsJtSX8mTHiKNjf4cUoeWakPsXKq5p+e5mcggScZmOl2WF7W5U8qXjry+2cumWq/qF/QaSb6wTNcgntyg96MrDweF4H0f9Y3XDFJmgyWbtuqJn82gu9am/8GL5x7Qdn9c54nTU6UKnABYJyiDWVOq3+Thr5yqnBoaeDE+ET5NAy9XPpgD/kbcvYTGHFMcGdfVEs/RWTnJtIIBHn8gEDJnEmxiQ7EWXhozY3SySsp2M6JKyJfcw8C9WlTZUYTTuB4AKebq9JhU3yWD/JAM4ySsWN6ELlI5VXW5wkNkLVOePmz/YY+oPOVDnQT7YLdCrUoamGFF4nFrpdQ+DvIweER49gd8irqjLOBtgF6hTxn6FOSmJFGpxTLpW/0JtHa+cL67q7+JjIjgsGRVsfc53DbckcZwsD9UDcQD1v87EPn9Gjn2ueyWFfdqtvxRuQWJ9wZzi0WA3KHLajEc18yMjIfkCgv9id9hY14Ooxl/XY18B1UEyQ+8H6aEqTfTzjQAO/VNLryejudZWnq5MiVwkHKlKvcE/M8t3yaopnilIdw2FsT8OaCT+wBXxHzmyah2Uqt+jgVYa73bDrxievGyyIQcHt4YvwIsJYINwDbZakRCv0AF/euYyUp5oyadrLUla1BAnk+Rrt37kQJJ5xyKgmLPqYnYx+5AmkOOJajSR1I0w6cM7KjuVVga5DvGwR1UeRJgJBHG3xwN52Qvd0iAnLH1KEp8nl+AJoWUgc1JV7yj5zEAnyRH8nFWwm48cKBoT7jcRqumyLTfjjTJvQEAWOkAzTTCpnUEiePChun7nmHl4ZnOhg9gFKcJxLuMTIzTUnGzRS03J7Ywikqpp192+YZIWbbXx3z2twLxHEm7jY0ETKGg5NMdRlgaDrR7CGO29PJFNYpkSc5ieLZAmHPYhcU8vqrgqNiOZ0GsN9C59vst2NNYxkIwGP46DFCqGUC9Zgjc31RiVYnlKCkUE0XZwMxnOFdiDE9OA5PwajA0kYZN/Y3rAczFfYPsWlfSGZlWmU0lXiwVS75BdUjvWocA9So2gQRR0TmY90Pu2W9h/e6Xuxj77sCNVGsHvrJhivUv2a/vogA/b4FAR0X1HwPu2Cn+atyR+ak9ZwHVYPsFaNT7JwcjqmWvAr0Gmf29ovG9JQ5ONvYuqFPHVUcNqNUN93xHxRhSYJGkOHOkyQYoLbzQF6TLdq6VCb5Px69m0fx7NsocuTID6ZezU3rbUp/fIlB2LY5/hk6gfLKCXwhSeYo1vEqIfE0I920qv/KI5SX2PIgtw2Av98rdnUj4CZkns/wsKx1IKYRfoHAD5+SQsANWgRaN7iFAPCwY2qhGjGBUSQe9EijZwYkohj+Qpv05KdpMCFcbJDxO+/N6ubAB0Pl4OLgjQ/pcB0XYuguXIRJbJ8cb41GosxPvVtwXY/3rQ/Mr8xlvojwzZ4c2TvI1UY/NRZjybshcb6c0I6ewNAik3lFJUyvNWjeTWQ+HmGrUJv+DJyKuooFwMFggbE5WeZ63cYLMw+CDPNmCSR6FFiQD8pEC8yLysJ/CLbuKcCZUL10sEEQ=", 1900, packet_4, &packet_4_size) != CHIAKI_ERR_SUCCESS || packet_4_size != 1424) return MUNIT_ERROR;
uint8_t nalu_4[1400]; size_t nalu_4_size = sizeof(nalu_4); if(chiaki_base64_decode("AAAAAAABQQL5oETPxebVo44rgsAjIDgHI5wkuz0Ww5W/5urZG1Y+OGDPm2TXCd7ak1f8PF8cXyaBxnpMMXVMR5N+90NM9JJSkzjxeW6Hb+IH32ER3FEsljjZQwaPAoj6GvqPvzl5GVk9mVVMg2SZR+LpwiaQaaqkhBSWVYTgTDA4Abhu9nDFFKEQNvadKt+0SWH5PMUxdq1jaIYG7eN22TZvyeKoMWIbY7sPj3pl0LscEsfDxZq+ihozPt7fdK+eYTzf6XfNfj6b5OMJuX3Gahe1q+Lnpr/5xBkUagI+Zk0RczNwwCTAwxYDkcNAb47jrDj7ZRBCDTL3O0S8DH1aol7wU5bl2NlrLGAdStUj1M2G75j1lx3qPxAkPbNmEkgy5FvTw3P7B6oHPRaxAbbZfhjs0Yz/n4QFXcveEsy54b7t/Ad5WZZEOJ5LRiNgJOPUPT+YuCRfGRBlHOTv7h7lVUvWZx9mPsCtjGbk/vXRnlShQAC9Pd+U+fK9eDMxFDO6SONEzmIxwxpdbkYfQhJIbXq33KAce4I7N4B7rv4MfCXxPKCsRQu+CQHC9To3W6cZE6onJ7XTG0+Xdhamegh94lYpqwhhWJXEOPZAKOZrR9ilQ4P9VVy2rmGbty6Go8fPMk2ApsxE7DBcrUPQ7ndmOhrz0NOjZOYI9Cs5LXB6hAVkgJK8QoYLHObH23zmJScQnOoBXJ6tgUm9qGIruoC6tOC2fa41/07lqJB5oJ0fBLGqS95nQj/yldqCmPkJeYeb7BXsIN4qj5mfS+KZ/P2zVTcsOmllQpze5FqQiEwz0PFR6Ko5W1na+VI8AksQEzEaaqrecXfdBxWWrYQkxleDcnuZ1nBuSZPEaTf2WHDFC/fT3GCAIeCL2JkWcyNAbiTYnJynzZCBA3kso7gD4/XeFlPDO2aYuDVICwt9/cuP56o+1vfY7+qEp/ncQqAU5rDGut8jihoD+V90Fv518mDj0WaignibefDmyuePOoJrz7doIcngahoY4t5gJJQIlbIt8td910hJzhnHAfLaW2s0okApQKlh578cDNBHoZgg36rLhSSCONorrKizVhtQ+uUD8yATdYYP7VphtXEk7nE01yY9MoSBxWpd21HPMbWqBs7ocArCzLH/3KXiDrxTkp3VKihoSgmN6dUVL+YDvzEza+CXRfaNfykQh3waTXFAg3PPXNdB8BdNlxPGETU83ppYv97R5BG+Xif0zDALCZxj9bSgwA1MHjzFNdBzktK2HRaCmF3qyp2lQOXJru1JrxoE0L6Ny9mXOpAUc2R3v7n8hguVHL5UMv7EORJKdUwgEOjJ6pfAUOh75K2+eIIS4+Xb0Wxnxqca0/TWZwRAa465OZNZRzxx99NDJkO055cpBcS1l2Pg0YMROOFfiGDkQdvJJpUO63UYiqrJB7BCcs4VQb1dmDcMjQysOtbfGvvEotNHVTN2efF+nkCVIuiAPCxxAnmbSBrjTMWYro7m7m5v8oDkw2/gHwGdJfw9S9L7AxCugzMK/NrqYhcQydx2n07L4DyFXd/mqpcNngjSV1XN7XsQTJHxRRDxmr3/02fjwKjR3oPthCL6FGQBmFyow6QY4ffIQi5KIrXyDJwLLpgqV8XD5O5tfJVz3OsVR8jUyPOc3HfVOv2GGfNCkOFytI9MOwz4XjvXBNveiQFKUNrrh0e5NS9rjGxR0FcRaFM0DrEj1HdQk3r6PcghsjoAo+9I4Y44n/WJWNBKUVcpdNVPug2AAoG5QIRWszIfr5rNyc+xgQcvFVAgvbsZQge/B6voMS8OzdI4rH55bM3/DNDy6d67xej93FD33XDFfJHyYMvXoJHOUQm07br5ID9B5AWyRkvg+zDED6A=", 1868, nalu_4, &nalu_4_size) != CHIAKI_ERR_SUCCESS || nalu_4_size != 1400) return MUNIT_ERROR;


ChiakiTakionAVPacket av_packet_4;
memset(&av_packet_4, 0, sizeof(av_packet_4));
chiaki_takion_v9_av_packet_parse(&av_packet_4, &key_state, packet_4, sizeof(packet_4));
munit_assert(av_packet_4.is_video);
munit_assert_size(av_packet_4.data_size, ==, sizeof(nalu_4));
chiaki_gkcrypt_decrypt(&gkcrypt, av_packet_4.key_pos + CHIAKI_GKCRYPT_BLOCK_SIZE, av_packet_4.data, av_packet_4.data_size);
munit_assert_memory_equal(sizeof(nalu_4), av_packet_4.data, nalu_4);


uint8_t packet_5[163]; size_t packet_5_size = sizeof(packet_5); if(chiaki_base64_decode("EgAFAAIAYEQBAyVRmNUAABDAAEsAACAxLcDgjQdOz39g8DGtikU+c1s0anc0mIORfw2kbN0uuArlwgJUM3Ox+R1M5Fw/EyWfraDrLEF+5rGe7R0lff3aFhGzLJGvFOVD6JjvpL3jqZ8cLUFNU4kPk5HWtov7Gl5E1Z6j7X6hJBJfWiCiG9DXylP2RInLrFo1RV7sjlcoqNt0Y3aatpYsVb9qEw==", 220, packet_5, &packet_5_size) != CHIAKI_ERR_SUCCESS || packet_5_size != 163) return MUNIT_ERROR;
uint8_t nalu_5[139]; size_t nalu_5_size = sizeof(nalu_5); if(chiaki_base64_decode("BO2lWceEiAJacXniOdSY51UunQ1oVFkQsu1i3ihOh/mfR+GpPn/elcT7+H47bR2OD/gDZlqF1Xf6gaPxbcvw6x6pWEesuhECFSnJqVpSPS/trjKSIUCll5OPTx8N3K/JSLgPXRVgW8yGWthXANm3r0cHuP9RVj3Z5aBYe+JQ3+hON8f05Djv37tl8A==", 188, nalu_5, &nalu_5_size) != CHIAKI_ERR_SUCCESS || nalu_5_size != 139) return MUNIT_ERROR;


ChiakiTakionAVPacket av_packet_5;
memset(&av_packet_5, 0, sizeof(av_packet_5));
chiaki_takion_v9_av_packet_parse(&av_packet_5, &key_state, packet_5, sizeof(packet_5));
munit_assert(av_packet_5.is_video);
munit_assert_size(av_packet_5.data_size, ==, sizeof(nalu_5));
chiaki_gkcrypt_decrypt(&gkcrypt, av_packet_5.key_pos + CHIAKI_GKCRYPT_BLOCK_SIZE, av_packet_5.data, av_packet_5.data_size);
munit_assert_memory_equal(sizeof(nalu_5), av_packet_5.data, nalu_5);


uint8_t packet_6[1363]; size_t packet_6_size = sizeof(packet_6); if(chiaki_base64_decode("EgAGAAIAgEQBA5azjhAAABFgAE8AAEAzrgIGreuIfwxq9ASUvQJyV+sk/tN8LQLyD529P2GhbPVwHSzCaPmmRxZNcLxuMiFBrOSd2h0v7QRqQmYSyKFRXTzFO/Oz8Zv50JPqlzGiRN7GS7CfXDyW9pRMRb8xIw+JfURDLWFspim/3b8bIRZb/ernKS+tjCOVgry8Gg5QqjYzskMix/VbfuPHWZ9rfElrnZkOoiy/PJX0wA1EfxrDhnggjQGX1DkPT/pob2J7sVI9h87xIkMXlj9gNougA/oQ9z73U/CVCG60eLWuGyOIXB8OFxr2L+FnCXia6vyIJ3WvDIrUQ2zREJS9LrxAfvE4u9wdSQOmfT0etl5ZsvQjahg8LT6lfHVTDYi2UXoh1uVlM1yLgWurKu5fU7DeEQkAnP4WFFNJvNhnq1jDefN3U/UsM/WrzPKU9sSFvnNNEx3Xzsokr/98qGkqtRTsvPIWeBkQJ0OfBYv6PrMAjwiXRbPNOCpq4gdtfF1E9o3HiLLHfEtX3MQ3p9+CPewzwz1I3f18BJmuc/aKq8YrUxQuoVnYQ81gtVXsvjoYKqow7MYyhwlXskbx+VGkNCK5dJKLNSZCqxq92+S4/spXhwVLaVzAV9I6BiIPWHdzRgWCRygPxLmnFLa+Fdk+25ZqAeCFiN1HLrJLMIEfNr82mIQSG9YbZiKBpfg5CsbjDDGqrEBNHS9dElcOcUoxndinCWVeAaw2LfwuhzHyGFaLzyH4OAqzi2vdYgoe7GgsBrU6Wgbl6F3FhubGERCUyWXt/4qOpDeTJEREfqCwSEn/GaBdIVoby7Twn4rs+BfMxHLIsTEbm/VXwHknF+vq1ZRJxG76fUDIO1Kzjxd9sHIjPDEfbFKnH31czqkM6kT+xJRlaCTrmEKyN38R/oZAIXXT/f1if+ja6aUnrOF2gcVfSCK2Rrf4IGzRlf1CzzwswEnM0hgPdm9lGUquspBkfVXVlL9o7qpWI6U+QG4YHJdRdtSaY+1pM+r8SJDgm8L2Or8KlcgTAfGxze9+K6+RpHhgTjeX0KxZc0020g9+PPs6kqDUjrA+9nH5Uyt6NfSpLWHjGzMWrIg/j1r6EOGqY+nEL7bbdDaVfHhEBxW8cZZOrbaL3rIefkBiIeDHWOa0horMjZ1DthSzYVyii+TkJnmxsGa36pMxnru9A/Exd96ZC2K6XM7wAElHbtMombdQEM5dTy6j1iAWFJhKdIekUQuIi0hPejINVG2SDZInYeLeGR7eucyFdbilncryWHkmOT8y2jJzTdXl3K0XBaITBEI6CJorS8GeaWBjjhcz8y+oonCg1IDP3+p0r/bcluMZnF2QTIyanuIxLGSGWXXMwOEJIyub1trsvDF/xP/UXJ6ROj12gD0B0BRu2oCFm03fbaF3X03UPTxrvG66QzbXPWwtpIa2fmiHEeY6mM45XYKmfVyv4eCKXX3v7YgTCVoosYBYNbdXJUKNTNEk4SNyFvqyZCbSjlHu51g+F0cXxU1s5sIv6TgtYXdKOhHg2S6NnaNW/Ah6L+yMuFisZ6oP8LqpqI9lHG00UW3ZfdppfSCi5YaE+WiunAeAE9pMDW2M4absiM4FpaSVXoQ5fIO0VfaU9nrWL1u2No6+QQ+GvS4Hek3C4DFBoc81A0LO9mn7Cfwc7+kvvVb3YbvYMOveiFNdEFwneVJZWg0MnOa1orJlwt+U3e5PcN0n8rqvAGMkcpXezoNrDmyHNEhVLIHhbbFb78phWwttYk1eIIKXuZQfjv41O5WwKQlRxXg/71QqvFsri5iUbd+hff1BOyNwyA==", 1820, packet_6, &packet_6_size) != CHIAKI_ERR_SUCCESS || packet_6_size != 1363) return MUNIT_ERROR;
uint8_t nalu_6[1339]; size_t nalu_6_size = sizeof(nalu_6); if(chiaki_base64_decode("AD0AAAABQQFUaBEz//49Rahcd06lG38RbOsz8/+BFwO4rCdlpQJCnAKUxM5PafEcXJ77wccH+5O9juJmAOiGIms4bQXIzGjHiyQ8OQuL9TNPHRfX/2LN+ds1vPIzQIULkjm0PRGo7RxQLSx4D/xb4Mrp8Desjb+F66qbz8dn+oO++SyJUK4yMx8vPkuqVy4kts18WoRQlO/4/N1v5zn5zQACriwx04JpNNkh5ioShY6LcFwlOKSiYaNM6IcrrM6ktUTHPsJr1hHSUI9B2jxrYtrNds+G9imdeJy3PXrOds1q4zGEdl4hcSF25gmIb6QEIGXdv3OhFkgEdy6IbLV2av9qQgt3SgmWyHMjfv9Xq7BmTxZDa4+l4I0GHCoytOKTLkWNlTp5BqMulMx+9YckefqtKVCQhD3GPlqHuZa6JTOE+bxiOqVAR0rJNZVw1yuWle8GrC1aM+hsFGQvwcVsC4iOzAuUa7JXnqWtaLCHDzFiHveMaE4GBtgcjmSjqqt4A/YNnSQA4rYMtivVhI6U3bWbZ1Vt+QhHXu9FkeYnla5qItWCg9jZ4OULZ/FiwAVSPTyh8EkSViUuBex6n8C1wDn1/CrHQ++EGomC1mH9VeKbOji8LHpGqM8y0GQrngZhI5o0Qr+hT61zWm+JaPjY1jvcyfSfg8yfwr+KeQ1dnkli2atJvc6L7G0zqoJf0FYeJdk5Bc9TY6zw9mt3h7eqMemZ4R6wEneh8SS47LflymSYdCXa2buPSG9x1wbYZniwZqvxppTJcPzwWq8PoeBTvMwBNU5EdcMETzskO/ftBgLmfpBTsGAwBm1WUuUmV0N7IZPTsKbxQ1YfaIWyAE8KCi0GUI0NpwzmrtFvEtCVIGZ2q3WZ7Bn2YgaIbCz9BAmSbLQ90mhnhSNbetLECPrbj6le48TreDj/GMrmTlsctd1ki1fqikPr5qj5wqKFuVJcPuCAekslhrHtPwQbtPf5WAMeQ/sUIxCBxAo2aJFBQQlhtLJoHpefD50CbrfHVzhPM+R82VZhmKpV8lVMaLukZfK9NCyfQGWkKwHj0MrdIsh+ixIVfFQb/kKVH7g5Ll3T7KQHqYXH63MsHu2hHRRVfmsHnnpKLUBV9ptJwUMncDYclQPEH6k3U9hr7naWuERPvZz7o4r+QHFSdkzotuTrpm1Ou6Q7fT65EKc57umhVzUsz2Y8qh4iVZjc2bVER1+YZId/Ix9DtOcbIj1d6ra4q/c/amWFhAaPvZunWPiXG4IAqpXgpKBQwE9LIeCs7iEVRAuSibfNwM3cpYL25Pi4UL0Pi2vZJAMViZ86KbUJ2DxPNq10+mJEwYBb+b/AqNeb1qCSi5PcO2vAaroV+zz6xT6uAvoecH7DQuoJ7igJb4mjWYfuAm9DBNQtdu7lwx4dB+9MiVGJVujrJhjKz9m1vPJqQIAAFbKUsDPkVc57u7+VuZrk5xhXqphuz2tTd8mAu9QMrq7j8oDjVYrOU3cm9PJncrURt7kTJxLfd5MHn1kZSDxjNCeA1/Nc4yhX44DGUMTgNNId7sUOAvgy1TttSXH+BpVp42D/5wFOcHsYWro9cn5XwhuBJdtHi5TvLWEO291S1yMHD1Co7rqwbVZNL67rLP3xWy8w9kSAZ84dx0KBo/cLFYFOvsByaOhm7oK8U2bcxRhqmAA4VJo3ujxsavX6faLnGNRo41Vb6tdsLlfq1q1QlPoJvcBiBeLrOVCo2i47KTD0UEtOzf5ywcU8hzf6tGU6w77ZttSgOMmDrObAL83JB0Ec6H0DcA==", 1788, nalu_6, &nalu_6_size) != CHIAKI_ERR_SUCCESS || nalu_6_size != 1339) return MUNIT_ERROR;


ChiakiTakionAVPacket av_packet_6;
memset(&av_packet_6, 0, sizeof(av_packet_6));
chiaki_takion_v9_av_packet_parse(&av_packet_6, &key_state, packet_6, sizeof(packet_6));
munit_assert(av_packet_6.is_video);
munit_assert_size(av_packet_6.data_size, ==, sizeof(nalu_6));
chiaki_gkcrypt_decrypt(&gkcrypt, av_packet_6.key_pos + CHIAKI_GKCRYPT_BLOCK_SIZE, av_packet_6.data, av_packet_6.data_size);
munit_assert_memory_equal(sizeof(nalu_6), av_packet_6.data, nalu_6);


uint8_t packet_7[1424]; size_t packet_7_size = sizeof(packet_7); if(chiaki_base64_decode("EgAHAAIAoEQBA/hPwIoAABawAEEAAGAyGS2cnGgJyx35/e08eupzFUcv/jpeBrXw+3Wc2YIwoFSS324yMQIs8Nsm3uD3xIRjONboqv9ruKgZ7flD3A1bKXiVJZ9tuitFizxCV7Ry7eHVs4xUiMFzrN8WPlo2IxBzz8mn6JUtMaWoIbV8WK/OfdA1Aesa1m6VCX/3PBq9/WSBmu4p8fJLCHyodGCoqD0u2IPrhrm6phKJ0vnhlWfRsm4fUxLBUCCpdV5kZzLwd+E43E1kvo01Z9bBdMLQubgCVNTCzDDh5Stq8hIgW/eEi3z320VT9c0Tiqzh5cQqyboQE1ez6/4CZ+KRq+/JdpC/8xr9wJKI7ua44PM1s3yEfB6l+cneDENNTIHyZEdGfWn2dRxiu2Z4kBw4aRswlxGQwPGOJQs/4R/4pKLSisBrfzCRTdZFVEzOLH0eV6koLcYmfwm3HBNis3+Q37RiayBRXjOf4BRymiq83bOjb8vpGw0AvUrP699XqqCCHnzmhtSLP3AOvL0SsdzvIrvRGt9OTFKh7MP4ThdwAYNx40CsasGlTl+PHIrh2UmXA2yMREb3a0PY8kC7M/vOzvBCnjJin8luh7bnJQVp9qKHduH1bBEv4upIQDtgN0G5VbBgx0lsVYMFFtlqgGJxRcOU0/OVkxRCnrHKIn9bLJ2jT2U7cEVw/FNXP83pmQb8Pk4Bh+ppeDk3Sb5LZNErcacs878s53cpxJ1IIhmaj/MMh2D7vVrD3gP2T2pEX3TowLoCocmc8Ch4ZBXrfqorBEf/k5tGgtJqptjdG0PMZO0mfhavwChOjDPGLRToWkgTRi9yxGXIXAUtGm6LnM/Q8Y187NRlhg1eUY/Lfexai3v60MAxqE1fccUEK0FN9TgYZqA6iG2KAI9kcJI3mMxRbfADdmtXodG1pJZzSazCNpZ7K8aAKjpLNK5oyyWsw4qGPaaoUWeN7sbJwW/V15jG/7WULxAUO9Cj39i5qJA2zh2tMo1NNeiufCNX77gz5JdaAEtLI1mZ8zIU05nAkKj8YJ/kDPXx93KO+aTFe4vU8n2Mrlz/Nehdvrm6dDflPFYiuLwi+8ZHyEHsD4UqmHJBH+bseFSmKR69cG6w6SqmzWcOLv1LoefWwIj5OeRbr1cDLhvc+8/3KA4eftMVFGeql32isAg31Uiz1SxiaA8u25KcGLjuHK5DcyQLGJ0xViz15oRLeqJP9AKctG1FB/wfyp7oiW2DH3MRD7yelcQqG/seBSExIOz8spBTyza5bY/GEcffFb1AgZi+ydMNjY7Sn4SyBhzzLWxOZOKKUOkrBXlZXDyHDQQz6owCg7ScWT1jTyYJEqmfS6YyGhHkA4VQxoTCLB3eMvwCzWP5NZXd8oe6YNc8kV82q7/6BKRRX5MHuAeRvVnBKoRd7lcCudhrFG65ME7N5p8Zut0T5Iougyy9gtPjdvPslq3w6CpBFl2swvs1W7qCv4ppF2sEEPu4JFD2ycNqb/6CrlxCrkuzCvJ74ssX4Id5xWzoWB8/ME7uGdrVwDZBmgdxPREvSKcNWb8Sz10ALvjAS4T7/qzWYH1uyPuYVh0YSIfGhqrVIzZuTAU6WmFx+93mGeyIC/bP52YILPkeWt0E3qPZ/SeI8mI13bmjf+37+76L/ClONDw4R+HcKCTaFVnL9N/XysUWHCzbFGgnGpJIxhjyDmkTipsSLENq4sbMGPsKNQv9dN/qnEUR1v6FVaZ2fMVKJ/S1l8QOrYuOeOSZ5+fY0UYCMAY2G+rCgxPlUiv3d1GbJpEqc+Voz3hfYvb0sEgqAcACh/1bFdxxZUK1LQl8TpyE/HrN6j+W64pIMA+TLuiUsXtnJfXhh6I0BcVxrUGRidmX3Jl0bmFiGhP5Pss6kE0=", 1900, packet_7, &packet_7_size) != CHIAKI_ERR_SUCCESS || packet_7_size != 1424) return MUNIT_ERROR;
uint8_t nalu_7[1400]; size_t nalu_7_size = sizeof(nalu_7); if(chiaki_base64_decode("AAAAAAABQQHyaBEz//4AbuU7//xl/5Zm6skEgvEZ2ieKA8qKRcLoOrrTTe0aj435fiUCzzJLHHvYsfIZ8sfjHsI1IKicIcyIV0dp379WRCmM+q8DPuGw/d2h1spAWqYi/au8uQMY2Wp//3mvrD9kYjTulsqIXYmGeAvwo3oRmlRh475dcnj0PgprVEuPTEEAth/0Bit6Ybi7THX0bVGMPido0ciiDty+0Di80DItoYQolQS9bMTmdtuIBl7yBIrkfvo6DBUWAHDQI8jDLEemPTh/n0DEei8ykg2ut7Wwa5IXh6jbdre9Ael+qsY8mAEeQP63QzNWElOv0yj17TSK+Vtb7uCaADbiy/hfSihjRWwrcg4FHSWtw8XYEmpkM8DDIvKm7GU81S93tWTbA8ltI593XKPfKAY+M8bTQ+V8dx3yZIVN1F0YCVsJI1qubO0QbE6rOswFsZqjTXkPw5zL7ERkGvA7Va3pmPOpJfPlMz74LmQ1bMVlWGCIMfQHC61XqIfYNp/Zg/Bv2Iv1oPgXwjo/sF8cI735K3Hj0lRBdomRMPIfxjyWqOVm0BVcK1UVPpxYYVtLBGRjIOMooYYmCBvhrvOKdQUV61c75amGyUq13KC3YTCuK6BdCpT4BWC5okr9TeDJ0b2mb4IwsRW4RlvEIhrKHvtqrEw+qtKOO9lTWXHp+uQcLssyD3/GWmliXJkVkEGFcmET3KBsceFWDFU+C6a771Ry+I6W3PmXKb4yTjTxBXYYipF5nP9skfdAMpnguT9fIwbpWTy3zt9jREYFcRsMh25UlOAwijHNd3NX0ve7aiXUPJvW4Qk9Sx6iV6JtkrUBSQpJ8qq0aZJaxfn/tLoAiplR0cE/2ej2vurZP6OTzBpie5h9HN9BwBOev208hDj1CAUJXJwyrSmn9Ih8pvOP7SeM5Croh4TSiIOv4bq7LEB81OBKxls9g1C/o8ix59lHTsX8Ok7A/YnjXo7F1k4FQ55nvy8Vl6JZyqGBoBaLC2fCcIZ7HfrP+5G5f4VFnzIlJe11XXsKFbxiX/wcg62w4xRKF6EQfRVhK2wyqezhYLE0QRAIoxq5G0v5Vwd9Hc9y4eXeTCoCyPTTprrhd2FmFIRzvNvOU1/q+bfxuV96D63vFQobuxxop9WN9BkNsCNox1pJHTbz7H+uFPBztciLvSieWVx0RlpMKbHQ9GJ/1e4lPEIv7S3ey02x5+qBvSxYJmAUv/cXVxAaI2ULxNMNrtuviYKzN3KGGqEf+phmXDvfCTAG7Y+Qvp3JhyROOnR50hg6lnbAXhIYGs1vRyJhoyriSdgVpY6ytHtAvGmycWj32HrDfshesvLREFj4uaX1V6WsfClcP5qH3bJHOSegTMsYvA1tiHhtDA8JpSd93IfS11Q/BbKPyJP1i9xWXOV6oe5rUlnfrwo1EAjtPp9GzU+Z2E6kp+mwIieYfWFK7j2c4qxqYBBi1z19ts1aXq+y2K666sUdUljrIrP/YphKEnDJNCxG6bTkyeRcBd3vmgjbFzniBFth/LeZQkg+lGJHbktlGb/XkMlHjnxeBw1WXHFBjTdKBgt+3WCff29uFECFeXY0JuSVZSViEjR0atGSHTgyYJDgvbtyyi17dfqqJpuPCfcjVKyhesp3pypAPVC9I7G9RDAcfLkcP3FcSIQiuY1grAo1Afd61/69fi9IGpqAq4hHKgjhYHUnVpFN45RtBGKRcABlZBS4S/Vdtl5790TGSh2jENZKkMtModOkPIiZhScRC9ku2VAQkEAfQByYn4hVTj4lcGJ2fFmaHbXzborr1r1lYzAYgYtkmZHmX6rOAVUnhAO6qrKxXNbUdNejusexyaL/R5W9cKbzL0gEDYw=", 1868, nalu_7, &nalu_7_size) != CHIAKI_ERR_SUCCESS || nalu_7_size != 1400) return MUNIT_ERROR;


ChiakiTakionAVPacket av_packet_7;
memset(&av_packet_7, 0, sizeof(av_packet_7));
chiaki_takion_v9_av_packet_parse(&av_packet_7, &key_state, packet_7, sizeof(packet_7));
munit_assert(av_packet_7.is_video);
munit_assert_size(av_packet_7.data_size, ==, sizeof(nalu_7));
chiaki_gkcrypt_decrypt(&gkcrypt, av_packet_7.key_pos + CHIAKI_GKCRYPT_BLOCK_SIZE, av_packet_7.data, av_packet_7.data_size);
munit_assert_memory_equal(sizeof(nalu_7), av_packet_7.data, nalu_7);


uint8_t packet_8[196]; size_t packet_8_size = sizeof(packet_8); if(chiaki_base64_decode("EgAIAAIAwEQBAwlTy/YAABxAAEEAAGAx76xesUBeyKD9lcl4n7YbW9Pmj8tnYvUSdLTiKrxXiB1BPQjZKAV2x1rocHLRegjsxJZ1DffXKgacw13+4PXD7yGqULfF9Ni1+dcVMND8pA8HMU2ze9FonuVuA7NIGbTCy4zHrS6iEJuaxhfFwkt9CCyubUwiFHKNOlK+utfm0aEhfBk/k35xjBXGNGsyj4UNSgBBuYudfRl0XdiHDdVos+VGbORJpeg+kBU3fA==", 264, packet_8, &packet_8_size) != CHIAKI_ERR_SUCCESS || packet_8_size != 196) return MUNIT_ERROR;
uint8_t nalu_8[172]; size_t nalu_8_size = sizeof(nalu_8); if(chiaki_base64_decode("BMyjv2Q+0B2eEHpzAltlioh+6AmSGgDM8H4t+vBKR/IB29clPybjTjkVzyHDoOhYhj24T8o+oKeKqXeSJrVWEyB7LUd5pD0s7zlAdKRQSYDIityirJ0oW3fNBCJXPpzMyylh/Nqjv9FOC9TDjbNXIGyZXsgzjUuBAV/MOkK2nll9cjq8Mw3bB2nAnRijg8gQhNg1qLbzDmvPrJpS9Y5HcOrVdmjvtTTg/K91pw==", 232, nalu_8, &nalu_8_size) != CHIAKI_ERR_SUCCESS || nalu_8_size != 172) return MUNIT_ERROR;


ChiakiTakionAVPacket av_packet_8;
memset(&av_packet_8, 0, sizeof(av_packet_8));
chiaki_takion_v9_av_packet_parse(&av_packet_8, &key_state, packet_8, sizeof(packet_8));
munit_assert(av_packet_8.is_video);
munit_assert_size(av_packet_8.data_size, ==, sizeof(nalu_8));
chiaki_gkcrypt_decrypt(&gkcrypt, av_packet_8.key_pos + CHIAKI_GKCRYPT_BLOCK_SIZE, av_packet_8.data, av_packet_8.data_size);
munit_assert_memory_equal(sizeof(nalu_8), av_packet_8.data, nalu_8);


uint8_t packet_9[1375]; size_t packet_9_size = sizeof(packet_9); if(chiaki_base64_decode("EgAJAAIA4EQBA/kUl6oAAB0AADAAAIAz7MY54TlevvHShbwbxRdNku2Qn3pFKnG6MaP6+qJVIpNM8zlLy3DJ7+lkjL6AvwTi/kFkAD+ybzlxW5vsM8LKN5rzKFfHC6j5BY1njze0wcNTwaAOlJmYFY642GQjH6a7xwATRySuBkYCdWyVHyD1JvulxG9z2Ac6bbm83Rzyk2lR1ouxXlrCkmwAnQTDlx35zGUZFZhPdpnHz8F1n6YbQXj/7c/cDp47bReSowvhu0lhpP4Trvo8zvYI/o5sQ++7aFdklYdncwISzoJpYstNwBHq+9daVvrW1Rc4wTRgL2AvpeMDu8xQr4moPJqfZyNREFMufYrKvzOQF/0WwMprFG14Z6y0+/c1TJreFbV9mEVDEeV1Lp9yyaym0pwUeJr8xGtlsKadsxYEw0pxRuzp+4h+CP9camZ48TZ95cy2soQeqX8r+Ynoqqqo3ii4nQyxcF7nmMJWYaC/2ktP7J4LLLrUmZ8jPCN/rvicIVocX6uWakpSvjwKbgmrrpm3OIBZ28c+T0zNjOdezUg0GJVWcJctwT+HBW15U9MzHUCtnTIBfsI+1wf/zIgNArgSsp5fd33vQQ8AYVjriS38XrWK2p0QfIWDFw7CrWAwJ+Ey58rAJQ3xKtpd89g1N2x6wzPNSqdssboppWPsz3ZR+rc/koOtstoc9c9Vk8HScW5un8gtFiOvJg2x44lbS783gzoT1xmoHAxbswTJeVcjk3XlBss5Rj8Dd+l23utd4Wm5KfzkskR8OJMxgnutapvcemFqbhogTvBj+jiKugx3ORMZnToZ9NaryH1DIiLltPx/3YY1GZbKwHh+MQ5wAWCdJldi8MGLygAz/+3igQbeKmiYMB8K4B1QkL3alnXz+9PBw+JwANuRVb/219z45+duZHI6DxQmlfdNEdEC5QNVt0fyzhQf0fMAbFGEGUBs/9DurcNiCLnDgMrR3eo0hBBOZmtKsmRDtz74cWZEf/t2WvG30hqXVPhcDAP6lGph/jjaqM0C5B3gEmj67mh9VlRgqWBppGt3cssXQI+bWrU7NR4B5kBF4vf6Id01qpwb9jiC99/NL6TV5m4BDSyOGG+ZXva69UCbWDLCrztLfYMX1j4EYS+kWB9yMGXkUBrjeQPUfGqJdjdbQATMVepKU7LsYf7kp4d/BYWyAFiCkGpWdKUa9CJ/WvD7qUijapGtyMwY69KYaoQN6oRdURaTAel9kaRCTZA/4UkpmcuC8NUGSc26Wa+PwyjdtkzIU1dioxtI2L73LULmpR8LvSLVGv3AD9Mco1k129fUYaBOlFN+OFUVHkRkK5KCwVFMTHZ33U5zsjpvoZNg2biiEIfjq06QpLDGvWbMDA5lOi6SFZoE/Im1joIJr/QPi82jJj5IxxcmTuT+ndPKEE8+kCSaVilUhbfHvlvZw47qrYW3ol0KK0CQ0/VIcMzoWAb/AzN7Jv8uBwZcxd2nLJ6pww8VcddToqECU332lBhXyV7UPSCzAfVXzfwaPj4dQV5H9TElZb5sAdx1ZzE9KIvqbYTFMqVNhHIdUSiP/booL5exxM6fPyulsvdGOFeBy6gZjdnVuJmH1DCzsJ9x0mv+q2E+SJt50fKaBbkPybpmjo0pSvrDfBI43rGd00Sa9wfoH61xvPD092BHkM3kEhkf2sfNqoDggTu/f28nGSNaDt8yPJjee5eAZGudTEoKIOwG0HhU9QMD32wRLNHLh8mQFGvR5suOYwGMjcr52i4fA0SzW/07M1NsVLWF2eRdL2fZIaakfqND4C6Hnz53QWZgaA92OZCm2Esxg8LbzFrenA==", 1836, packet_9, &packet_9_size) != CHIAKI_ERR_SUCCESS || packet_9_size != 1375) return MUNIT_ERROR;
uint8_t nalu_9[1351]; size_t nalu_9_size = sizeof(nalu_9); if(chiaki_base64_decode("ADEAAAABQQCdGgRM//4YFg4TcqcT/7vOOUW2zpLhRD9npwwIWEwtDNAL/oNSXcBcYHgpMeW2V9bIzOJ8OdvBCH9V2vEKrpXIjtpQVeVCGf+QLfV0ObcLtmKvwGKCQzBkPopmZO3z9/zXJfiGAFkg/i7RNLhYIfZfllWaEwuQgf2qOPUFlRgsqdlV1Cwqm4GXpCuVD+M5QiVwPfgP/4ucmU77P9zv5IXwUer5E4mwllcpGH8h8kOURJol2rtvO0C8R8bIBBgUC1fMyrOJBaXvEkVtBCs0YQgF+VieLP685Gd+ol2qVZ8PYvs8BPO1SWVMLz5dMSpDfpwj/ImtA58JsNC+co8XXdkmbTSiNJv2BJ1kdh6fTrXwrLE0ZKX5E+x13wyBeq2KY12P9MugrxEOuilWOgQnTXyDkeQvWC7hyXtztw/tqcVFyRALKNUuekjcGhctd9Lz/unsaUyNfr2hURzwhd/cQaAYlYUmTCx2Q+RaAetwXY2PuKuF7JKy2AEUvT8OfV1+IyIeEZMXtXaqz9J7Qq1mCpVAxTjZrijNrl/3Q0yaU0DApOOZOix/wJUV8JL2RpHdSPONjDFW2Th6eu2TQV+TGAHDEyw/uNERswBbKqlcEN9zjs3yqSjYQ94pzIe43lSPa+RRrMv1QmQJl4vznr2pXUVPdd4U0ZgO5AjMy/g1krPAgU65VxT5g5UHGp0CQG4kBfpoDJ8CuZ+UfKleoi7h2AiaXWHVANn8Tx4RdxAyR0G/OZgYNLlOHxi6LNZxg40jIXRnDlQG2BXJfXeOM9qchYQqGR5slhW2vG1kTjhiUHyZ19VYYGRT3QikIRtf4UhBmwP+7XYaH+ELAHaap5IPup6YXiZw0iaAcUbvxGsbnyDG0y1xdqL7yM4SZCfsfMOOum33bH9sTXg7OEcOYUO3drhT1VJuWKJsv6kv4RRUdHAGtD/VkhDPE4eJLR848mUrNaT64MeUqEvoLM3ieLQAmvx4MPkeQsmXnePwrcS4XjBBKFSVzFgDlD5lH014sgUd4NPxenK5VXXpOBAW/yUu+QnA+VhV42DRHlNp9MNUP/2at+xXuIF/0O8b2UOu86wXiKAnm0IxvSYlFf1F0OxjVc9dQhlVSlp5uzT2p4kOPzLENFrrxrxGRU4Rn5CE8Ipaef3ML4e5lcIPrVw08NQgF+RDsbiigZmg1untxWLIHVqfSWGfM6BmthikZfopJkh023uahtxf407ilKqtELulLNmSwTIN3m87lI6tg4XyIJNF6sqzkWzz7C7HiEl2PdlAexidpxDhToHDxySxKAKa7Qb8whV7m1kcSEap4igNc+760/seaCjXp55G0L3mpcpQ5BRTkhnLyKikhQ7PPIEpMSRf6dVy2FtdXnuYCQBPxYduMSj0LKxefzPZNiSR+n2+An+2tttB1jNxyIgqBEJn1WZ5v4ZTt5h8Md/FByLuqgCeGCoK6+kikK1gHtfmCxCfGfC2z+oixoND5+lNnznWBw/2FuapwJlLN23j/96PBTtpBckno4BVloTlQlpWEXJSslfZRj4TlN72j9RZSGpDVaRSD0nQX9xYZuhXBip+l2YWqPVR8VSLNsJ4mq/3J7nv00ZGr7Ha6BEsPmuQosZyn1oPstBNZMgF0uUMlBrDCF5pLZjK7Ujp2Lb6LNTlehXgYkLgh22byCf5myTWgaroMZPP+zrDVFsUsEt+U4j2RkfAHnfDCsUk7o/XArMgtxW6mycZjWW+0oBkrNDw0U4Pzin31ktGT/gKDjfShvfmq+WLtMGL7EzTF12jOtdhK6DugA==", 1804, nalu_9, &nalu_9_size) != CHIAKI_ERR_SUCCESS || nalu_9_size != 1351) return MUNIT_ERROR;


ChiakiTakionAVPacket av_packet_9;
memset(&av_packet_9, 0, sizeof(av_packet_9));
chiaki_takion_v9_av_packet_parse(&av_packet_9, &key_state, packet_9, sizeof(packet_9));
munit_assert(av_packet_9.is_video);
munit_assert_size(av_packet_9.data_size, ==, sizeof(nalu_9));
chiaki_gkcrypt_decrypt(&gkcrypt, av_packet_9.key_pos + CHIAKI_GKCRYPT_BLOCK_SIZE, av_packet_9.data, av_packet_9.data_size);
munit_assert_memory_equal(sizeof(nalu_9), av_packet_9.data, nalu_9);


uint8_t packet_10[1424]; size_t packet_10_size = sizeof(packet_10); if(chiaki_base64_decode("EgAKAAIBAEQBAwLR/mMAACJgADAAAKAyWX6VmeSNPLmxD5RbsCSgOH+haJibjTB1reHDo2ABnBmPbkMX6IZ9qJf59aDOOxE8w3x2RyeC4bdFQA3PTjWB05N1qpD3lBpF0As70KYwJu4AIptnoo0MeawYhiROW3KVQJ3h4U7/K1p4y7EWPgeq3VdYO3F3+g1HLnMj99qwObdUuZry+38W+NwYe+0tWhSnfcW8EQA6oAAzPboaC8ApQfbbqfBdTU7VDTkGNKV8+aRcFhu0qQhiVsQMtaktt8I+BcfmhMs8woe3a73+KjGXtf/bjgDU08+3LZTMgwbvRiR5jJuKkS55Z2OPhbU9BLQ7aPIlBZpc6gtE7fO8jFP8NdujePEhe+eoAJlnOZL0AOpqOVpNBNPf3cO7tDqxO1gBUkNx9tVdF0X2oLNMLA/+k7DTi4bWZCP1o1UnGOiWErHkZmL7YNCDgxiNlNXO8MzzoHqiBGyL5Pohxcv9RDOjta6PTTMIrEBkORVYwZpQP9oNKjHNuC5lcUjgEjKdkkrfbLGBIWQhir3TzST/wiL4BnqTW7C2IRtUFdSr41CjodnI8JOXEW/eMpdQQhyOUmvLbG4daqr9gQskO8k0skJPSbviWQy/vJw7XXHMxxtI5KJelID6WUcLoAKIJSC9RiYTQNuvMgFFQEzbKBgFNWulv+jFap8OXdmc+szM/dhi11ggfRDluTd/Lpab4zcv8ib0IF6qPTciIgbW+TlR4sH2WYxS3KYvBb+HGC+xytwNxnAvO336Gj9rI7kAdt6fYZz6Hk3OKwxNDlCO/LhNB87FU3W6qVdVmttk4lBupcwrlWWJscAElT23Lr9coHj9nJv2zhlS30ikFspFZO+zQfVOl7fM7ix2AIzXeS0eYhQ6PVoI97TDPrXB/Rp4MS7ugWSHe3RXY7lzO6XwAI2rvqqBX6zILvX6huk6jdD0IsrdKOLsWPrc4HPZK36PLnSiD0wzQkDEh5SYKhUHS9AplE35+nqWC4lvinVIYe4tnN3sHI7a90kV+R9z8ieuDiGeA6pUBM79Q1+tduIaPtAFCFMMHzo527wZO73rnjicJy0XJC+C84GiX7OvEZ5EvqURhJ6A51rhJ0pXGcUIHNOADtTO2puvvrG/LOvTXpqXcpCaH5Z47hi7i6Nwjie5MWQfBmErfK0//Ns14fCZwkxoyX0dIdLU2cXkP2DHnl9FgGqiFc+rO9KVGYuMeXgBpwyWi3jmOmM7OTlTe3hlNow02Oeqsh2Wq50uKmutlUDdb7kjygDm+bRky2ZYewJxElDfndtAjJ8vhVtqbvMV/aLbz6usoi1sijgwcrEQGFVhvChYufKyvLtkdUThNlEZE7N5+aedL6KzYt3luOe+Gen/bDMspgvpPWBfUWzTFt2lBGVDjRLYXii9rt4rYMvWaytg/cn+G7UEyYptf0e62fkVRPaky7cIqVCStWNxZ0WnMKr49Cb4fMHaNyH4JX/0AxVn1AUSXHjHrFduU9ZIUBWf0TNULRZkWhT3iJP8yuSFP4gl9dosm1qZZADR2/9YG6i7Hzsly+Er7nOLTWnmgjDom+jFEuek3LzixeLHHQNhgeil0VyIFu1qZ0QpP+e5K5zECluigpHejkbaxgiZHt+vYqqv3Gk3QvRENU7GlDpVBFg5NxF+xlSDrXCbw353r3lTeAzsUMVzJvx6TpOSL8RQqNfizMv8fhdjTp4MxdmAiP6gKFyZMWC2Ylzhtjr0P8RlFCLy+HZ2LMp9om3tjWff1vJLtZu8PZCs62Hn5+l/sLRsjNquWF1KlN1OgJkXcBijju1fKBCLqxqTaUET+7MNC85BSfF4cpbWeOfIsXQjBfnR6NlUaaLfmdP9YmUT2WhPJP9Xxvs99BhsRlg=", 1900, packet_10, &packet_10_size) != CHIAKI_ERR_SUCCESS || packet_10_size != 1424) return MUNIT_ERROR;
uint8_t nalu_10[1400]; size_t nalu_10_size = sizeof(nalu_10); if(chiaki_base64_decode("AAAAAAABQQC1GgRM//4WixUAs5hj/5I3KgXm0jife2IAbeKMCMpbdE+8KzYNKc+ZtsBC+sHdHxJo/S6HSTLnsw+qmJLGSKJhh8fAxTWWBNhrhIWqKmmLJFwr9Z12xLIWfdNZFbJBBxIQKpTe5ltazOXByC+DBO8WTlmbd5+vsE9Uh6Gw5GXtx9PfcRZncl0gteMENrnj4Lp+ySahGie6QCKzeLiHCUfIceqmywzhH3lnaV6KD7Ghd6cTB0Jteh+5cPwSwUrYXwwW47517Qr/OWGb1HG0HqV2s4la58AcfPoZc45FjMZWN+718l1iWh0/5sCNy8cqEOfGQ6zZlEiBsjUgclnN7NCM/llRk+kfqpUUoTCwh8eLfF2NUUQBmwvEkTCt9Gpiipt2IJ924IWZClULnx3Z6RQmDSDC5lLTXWuTh7u7fSIskVjVdxau3JcAR1EhOyWCcEsYuWSIa8pRXZEsBxl0cPlT+MaOmNdk+NsetdJ/PKJ6EOSk5JmPtT+PcARiy7BrZlrqYRNY1Q4T1x5Yt5Zy/SPTN5dC/VQD18Aze+uQJu73BoeaBOYFY475y61qV2m0qPPyB1HerWZVgABYVQSOS6gHjEHruApvNYvq6M7xaVFIr+AQ6r2IYGRlUi/AJjMRhWbY90UZZGsD2AIQoPkT2accDSHBnRlSh8Pz67a8gr7Y4T4C4XKvdgKR0eogjbt2JT+iiDSCSt4Y1Mch5L+e5jt3NZbQcANAeMtsrNZidWC8OYAyJm+pZ+EJ1C9cL233y6MqSIg1qzNocL6Ih4cdAI8ffZZ897oRrc+RikJxMIcPw3RiY6DJuXb0N6+t4mMDpuZJf4lqVxWFGf/HMRLZaoeikVP+890CtmTyK1KJYfpoW+44+EnZdiQDEicMZQ6+nj9YvGL3S4iMwCuB9kjdC9wQXCwMeSdZ0qAZUmVNXojrjDvzKwOkbJXXx9sFcl4Z6er/oa5g855ccNESk39MiM8Es0wfAAP/EEIb1EL7hbdgukGyRrhpoOb8D2gWQAhTam0OzQ/2BNygKdbhbaBNgputpaXupTwzBTx3T5p4OHDAyYdJt85tZNTkNOGcodYHY4sAHMiyUvvb/EpQ6oMpBNQfj42/Dah8pZgOHfm+kjGITkJv8B2hH6x/yjPV+xdN+/YjeK1Z69vqz63f6L5ppTSI1AwJqN3NyoHEPcf3A6cqwtq8J3cdhad04JkHM1ciaFStT+mlsNxxqftL5DDGRbIkh2fq7y38rn/NHobZexFXJTAJxYgIheSg3TtLX4vTpxzUUKEnfccX6M64KZs5K0ZbVz91+fub8o2er4VEZeWu+Ykcfvwtni5tXlk1yhbhd0cszeFrq2c3L3WNCrfMg3eEUfGvx3mnVaKaUVcE+o2IT2vzMiylep/a9OdKlTo5s84fUMsj7navFKmyFWK91AvFxX/ipkSZvnDaJyzv17rngA1XHM7XR+Jn2gm5VP7CpPn0zX+u0HjSOc1gcO33uI2GR2MXec8T8VOzge9s9xqn1PMjqGKNBRA7QxBMoA81sAimcR3EM9RhTnOY9fVsZAGae7FrcScmbsDTvKFuyYzAuIxog5Qi0AIXwUkKujJCLtOkW1upvjTXUDrWDNKLcKw+5aedgbt+D/AvhDxs1Nneum4iwOcpIZIKcXxmB0/TPvAPm9alt8Ad9NRhfJaxc2WIfRNWYHbF+ynMt6c9vtMuX4QtrNsSBTFfDoEA+LbTFLxTVW378ZvzW/3BphOWQbklwl6MAPRCzqXroTpKTfs8XlqJbPNqlhKnc4O+jaO8BEkMEhu+i8l7PCouexlX9ZTfbi6D6PUtna5CxOskroZ253Ht1DwdIHJB5t30EEbF+HQ=", 1868, nalu_10, &nalu_10_size) != CHIAKI_ERR_SUCCESS || nalu_10_size != 1400) return MUNIT_ERROR;


ChiakiTakionAVPacket av_packet_10;
memset(&av_packet_10, 0, sizeof(av_packet_10));
chiaki_takion_v9_av_packet_parse(&av_packet_10, &key_state, packet_10, sizeof(packet_10));
munit_assert(av_packet_10.is_video);
munit_assert_size(av_packet_10.data_size, ==, sizeof(nalu_10));
chiaki_gkcrypt_decrypt(&gkcrypt, av_packet_10.key_pos + CHIAKI_GKCRYPT_BLOCK_SIZE, av_packet_10.data, av_packet_10.data_size);
munit_assert_memory_equal(sizeof(nalu_10), av_packet_10.data, nalu_10);


uint8_t packet_11[35]; size_t packet_11_size = sizeof(packet_11); if(chiaki_base64_decode("EgALAAIBIEQBA/FpI0YAACfwADAAAKAxlzLDthrdmf5qaV8=", 48, packet_11, &packet_11_size) != CHIAKI_ERR_SUCCESS || packet_11_size != 35) return MUNIT_ERROR;
uint8_t nalu_11[11]; size_t nalu_11_size = sizeof(nalu_11); if(chiaki_base64_decode("BW1F1JVpl1hLJyA=", 16, nalu_11, &nalu_11_size) != CHIAKI_ERR_SUCCESS || nalu_11_size != 11) return MUNIT_ERROR;


ChiakiTakionAVPacket av_packet_11;
memset(&av_packet_11, 0, sizeof(av_packet_11));
chiaki_takion_v9_av_packet_parse(&av_packet_11, &key_state, packet_11, sizeof(packet_11));
munit_assert(av_packet_11.is_video);
munit_assert_size(av_packet_11.data_size, ==, sizeof(nalu_11));
chiaki_gkcrypt_decrypt(&gkcrypt, av_packet_11.key_pos + CHIAKI_GKCRYPT_BLOCK_SIZE, av_packet_11.data, av_packet_11.data_size);
munit_assert_memory_equal(sizeof(nalu_11), av_packet_11.data, nalu_11);


uint8_t packet_12[1424]; size_t packet_12_size = sizeof(packet_12); if(chiaki_base64_decode("EgAMAAIBQEQBAxy4uY4AACgQAC4AAMAyyKNnLvvOHx7usGT88UJni01P5qcq/yiAjrha0P+J/nMTVTaBZvDkxcloNpNF+xfJeE06opVqmII6FLHcqp9mB75F/+5IUskInEQrQnzClvL4h+ztBltlIEYlDrZdw+PN6XGXFRuV63zBaaYZv8nxzRGtQxRJrWChzoqneOVs8jqyxuwD7RTBVKTzOT8/TtrbwxK7AkhDtIqKL53ebUQDb9VosuusA7JnanWvdqIylgkArtUC86GhVBJeD4xVifofI4im0Y22xAJUntEuKX2Gf8RWstafo/Ykhs4aq0nz68EqIaa4jimgpPK2VpNPEAKxYD5tLLkt/1mWP+JdkBuu1vQBEDkPZFyM7g/cuNOqEXNZJx1XR1zkVP8SVjvLn8ohFQdKmTJDoFyqNkKz4BtpL2WvoeCXWxC/kGH5OqcNoBVrflqeQY+sv96bMs+aObgdOuO/dQeShDbnS6VRXPlD5pMPFrEJRGoCHnv/pVpujEaLS16AItVZ6RJkDNf++1JILXSClEltm/ownUVck4ecrrPhXBdzSQAnbnDGH4SdiQ3sxE4XtFsuvCw6+kPBnYvkma7CPcEzc11EHDDMeaiqbb5V3xHAIByB/WWXn+oT5DNslo1/Aei4o7Qjk8KPNCPLd4ELCTg9mrJCO6E5ZFUQClk3RSjrMd/jLScFrpj56Eyu3XNYO68KKtvNSkTOMwpweQRRZWhegORuGP75wDUJdd2fyPuw2TaymssRp3F4b2XGxELgqW/9sXxc1NuEz+UD9vhzwwKIvX4ysXk+uEnuDvCRULU2XuItrbZxV4NAqphaFPPquDa+NpQBN1wSnLEGsp0r7VeIRBExJTilP55ZUMnQNadXtnVmYDIOix8CgFalyVfGE225EzT+s1zmJ0oZ56TqWWtlfMwcdLigPfdfZS7e9T5RP/HgTcsRBRTye5m0nKEe+KKgyNXTGZ+5hIqswOktNkw9tYDpCHcNvjLtc0PYRPsAqGJmKE4i1zgAgiM9YUgSnfQ51b4Rq1+h3G33yB6fRaXCPJOfP8UF1RxYZAk110cdNMAgqR2Ja8DTOioiD34a6zfftP0cBuAFV/B6xbdEjTdu949P0nr/0vbEZUXPh2P/c8xm/0wXTT57tnIXNo5YJl9bs8iXmFivrVd0S2091FDs4f+G1b5+j4g/ZdJcVx5Y2QzSEhCW3kE77BBeG8zRCnKQSDyGimvM8dcKhjKfz5wYPloz2U8ltQmFsWmt/Tv/wh6T5MRiRSNsMsHqEj9sZnRloQK+xn98Yvyb88X6r7MWbjMsSLa+PfCM6qXPDhXlrRIGFgZQFrnPLnnTHvNqHcwnoVc+B75w/4+BFq5DoU+hZ1hSiEne7Gb9JM0lD3WYHKM2ZQ6feuo1WLvoRfhHfFMPzmwodC/3g0dGtE81frOHgXXBEB4xTH6X86IhUD/PTP7KfE5v1SY/MfaXCHkhfOOUolPuRaEubkKF1zA0wThWjoWuryxRDIAmIl8doIq4+Ek6syqVawNeFxKsz7hNW7biKK4BPzjBm8DtxkDl70CAlxXuhO/e3swFPrM44AOsjyAc+jt9dh+XGC06xwVOlgLM8HoP2LwdmgCN7O9dJvmdiUmX6mwhDh3Z8db5YYK5O+m61BLVmgz7TBVafrRb5vbw0c3l7Iw+cJNsR0zRIKanlVZuqPfmrAsJFclwhvmDM8PFp6R/9FOli/WFIE/kaAHUwS5TGGZ1NWOqgL5qpTF4zuLUhfsdOURzMqLrpjnXDfmPcQVbte6T/VAhHqOBMN/toElXWsg7LnvFMzc9SoPxXMESUFIBiaseQlQ62V1RrrK+5D5c/X7WwOPB6t/DbtokzMPvWCYL5iP0K0YIrVs/5x8=", 1900, packet_12, &packet_12_size) != CHIAKI_ERR_SUCCESS || packet_12_size != 1424) return MUNIT_ERROR;
uint8_t nalu_12[1400]; size_t nalu_12_size = sizeof(nalu_12); if(chiaki_base64_decode("AAAAAAABQQDNGgRM//4dfqE9j1rImCPZDp9LcSBUDq3DZXmYcKQ3EV3lTgg/x1o4iUcVkIVRFsooEapnCOVuLxROb/C3444VGx/bBUWBHS6Lov5lIaovzi0ssFDusvDTemWyXSOE1H4ETwr8rIOYBJMm05NoybeqDJn57CUfZFdlgIdVjAdrDn7pARZlvfUsOjTTHSwBuyztFvRNL7FUtPCZTjzpB3lWcckx+2BzVJ+ei5/aArgJFfxYfyiDI6mjSuBAq3mGDQ5s+oRddbaYbcSvlVZeo56XZGBwmS8KSJbLF4XMSenjWSSs4deChWrMQ0nyxt0WF/5G+/JaExy4I5PA/6y6clhNcOSft4tZXFq7fwgcQPgtgpNsC8jXkjudU+94x+dSQG3xlFViegETVOxjUtqYrpxaLv8+V24jhxQKQQgWtgvqd6MpydepkPLVHerncyAYSFLHui7NrW326WD/t5YhjGDNapF8XmxtgFj21RfCMYkTlS7MH79PXabZP+8KeVE2+Dlnm8FRH90gc95dhrOEx7IZWRv1ddhuHXF2xRCFFMl5mF62lcoD0aiKH47Aotl26WgpT30rUvrmPzqAQErzMXNBdoeuWVfW1d2X0AAU7vqWAmIyFwzMQUz4i8oexyCTzlCL0oRCUs/Tyv1HVoJtQtN5mPytuyqIOBpKptB2zumIzUAQVa2G3vROFjMVMU16sDeTOoyMyV/WfKE6alStsnd3EFvin21KLNE7wi1Mu5hF1QXVUEvG3H1+nTv+oNR6YCKENMRVOPyJNf5TiPrByFZRySDZk2UUR/3xAQqPwc73/W26/2Bhx5/QmnuhCSX++skfCbVZ6Z/phLcjUH9kiMf4r4oBizR/4BdWQSY6U7SU69CZNWCFUvrmo1SsLePt2bUWrOtqsJT6NKE2zmOGJ5EnU3aLcqrsdi7xFioQmY3iwUQmTtVOBh574gukl28HoyzNToc1Fcg7r6vO+9Q40LcnWBP0rx5RYUag2a8KguJsfYToBbVZfskbMV+dUw1IAJxww3cfU5t36HQ8/DCGUztLX9qOPl2x64Unrucoaba0r1yQakOQs5Uwqjd1QPV3clvUH4VmFjD616l6IDa5ncm1jE1+8OfqLxRFmQqZdyfeitFUNWMTsy+e3rWMvA6Ls+My1kLU4BeOYMiCUKqC+i1uWHigsNC9aypGCntj8He09DdolgV+1jaDTKQMlg8zddi9xEuLRqRE611YcsXbcbPJ8i67YkpojFB2FQzfvDpI1+JDUKHYNLYgM0KinqCBMaz7XebzfkspbMkmDIfNS9roo6NkqIMTTiLcofuHhYt1jkKIu/pjDx9+THkgj+3rl9XUmL646LHvess5uTEkAUkxOZDxk6AW/bBig8t7UqfxCCwamR1uy1DhgQ3f2ybowuMtP3PQUYfZCaVvfp7a0mlKrudZ8ZkCCsj8kPzWZyJZ/Tql48V0m8jQ3tLkUDa3p3M/duOacJqnMST4l3wUms6k+B2baasaMOQHXNv2A40qyGOFGuqPrbbkOnvMYvIS0KHDDJAfmlvd+yN9Ahc76eRM5+CBD53psLu+opho/vW6MUhraXyV7n9JTZ/3CpdmqBYGunNepmom18yP6QJoBoNYDp+EOE/PKaXo5lWnbXo/dJaNHSI8e6lgSNBCI9kwzy+FAmiQ4B6+EX3Nt4kkHeRbpSUtly/Q2hJCztD7l7hYpw6x3+Fh3uuTx6BY4afSNBOW/p7AwIOn19n32N+wVeMl6rp99Nclt7zFLQMjNKQZB47LRh+27vJxv9LA3d2j+x36AZ6/LPZCIoE9KKUnsNg/7k0/OYnmZQsGzA0z/NvlKZCajb6xTO/Tv+j56tLQSGc=", 1868, nalu_12, &nalu_12_size) != CHIAKI_ERR_SUCCESS || nalu_12_size != 1400) return MUNIT_ERROR;


ChiakiTakionAVPacket av_packet_12;
memset(&av_packet_12, 0, sizeof(av_packet_12));
chiaki_takion_v9_av_packet_parse(&av_packet_12, &key_state, packet_12, sizeof(packet_12));
munit_assert(av_packet_12.is_video);
munit_assert_size(av_packet_12.data_size, ==, sizeof(nalu_12));
chiaki_gkcrypt_decrypt(&gkcrypt, av_packet_12.key_pos + CHIAKI_GKCRYPT_BLOCK_SIZE, av_packet_12.data, av_packet_12.data_size);
munit_assert_memory_equal(sizeof(nalu_12), av_packet_12.data, nalu_12);


uint8_t packet_13[34]; size_t packet_13_size = sizeof(packet_13); if(chiaki_base64_decode("EgANAAIBYEQBA26SNTQAAC2gAC4AAMAxrwAZh6ksY4n2zQ==", 48, packet_13, &packet_13_size) != CHIAKI_ERR_SUCCESS || packet_13_size != 34) return MUNIT_ERROR;
uint8_t nalu_13[10]; size_t nalu_13_size = sizeof(nalu_13); if(chiaki_base64_decode("BW6UnA0HjWWqYA==", 16, nalu_13, &nalu_13_size) != CHIAKI_ERR_SUCCESS || nalu_13_size != 10) return MUNIT_ERROR;


ChiakiTakionAVPacket av_packet_13;
memset(&av_packet_13, 0, sizeof(av_packet_13));
chiaki_takion_v9_av_packet_parse(&av_packet_13, &key_state, packet_13, sizeof(packet_13));
munit_assert(av_packet_13.is_video);
munit_assert_size(av_packet_13.data_size, ==, sizeof(nalu_13));
chiaki_gkcrypt_decrypt(&gkcrypt, av_packet_13.key_pos + CHIAKI_GKCRYPT_BLOCK_SIZE, av_packet_13.data, av_packet_13.data_size);
munit_assert_memory_equal(sizeof(nalu_13), av_packet_13.data, nalu_13);


uint8_t packet_14[1402]; size_t packet_14_size = sizeof(packet_14); if(chiaki_base64_decode("EgAOAAIBgEQBAzZQ0IEAAC3AAEkAAOAzueu1YIFfbPSuNpRpQc0PWyUcoL+tpc5cC4/oNom3/6XmR+3rY2hJ4kV5U1FARGreBcxXaUOma3BUL+9I7HI2BG47vlEEDjbYeFo2/DKazXJVO+AcJZhXJzgVgE1fK4mhYsh5bG0MWEvU3UphWiHZyCvBYVb8Zdy0ccXpGzUSSlZ6EpPR5FwlQLTw0IWFf2jWfWjGcC5/XIW1XkYcLxYrciyo5VPTlb++8ubhzo3AjXYYwk6tNtdtCJ4ChoHnyHpAPdTSxDwCFPxBWOKSk9hLu7/k1iuHQbhmPJoX3bTMCGkzQXwC7vNsYzWGg7IkZSNIYE3l9FgUCfQSwaVVGwhFnavCG9XV3FTUZKzZvcMPt7EfGM3Aq912A79A9IaOe4dJV0cRsY3MKnwuvhEsvjLFkWgQXER8CI62N1phXdAe+6nEw3UoGJm8QzuYNQe1YQvDGtCrOb/tWKE37qtjABXviUWkWU1jwQ3NCog//pC50XpXaZAdXKtudX/H+ViIwStgCG7YxeOODYLiE/Jcs/qHtz41WxmjdxkHMskaX75mqUmPFo8NTBlFNx6JOi4lEjfKUG+riSagY7Sh7Gn7MbGtFzlR3Lv+UtYFg1poS3E2Jms/WKzydTJsBeYCSGLz6I2GFWk6FP6Dr8pkBdwUr4Xj/I/QtbQHwWbv3ob9mIBpLLw0shXwomXMohQw4OFpPaPCo0lGzgVLo/ngHNFuXwOwLD2WgYx9VGDzfiCaR1mPvzpdXKOtVgyq9/5WMle+f7XBiEm7O9RdInvkT36O9IAsF8cGL/mC87LEo1fxGaMv2SHaH5VHHZVoy3KWgfXGAttyBJiz5FDmiszgzltgoSFrJOFa389it1SBHi1qRzkvNNsWQOx21ggysiv6sgIYQCB+y82h29s5y9p16EjB/rDTRcHh+nvk9tK4+ZaKCTNDAO4nYz3sbLGqUQzLbapM0UqH8+zS5tQeEoy8/KR5rnnIYWc3dimC2a6iz5L54lxPM0LGymVDpbAs+l1FA/Ujn42MnVriBBJONCY4zuaaJV92ZhrzATeM24jR25RknUKSMLKhkFv+IPt1/WxbIq+7EU7n8Tf9ENFFSIAUN95BPuSoVlGAgTfHbgaq9Vnz/gi0pTCfsedoKtWtGYNix6u9JzkYf8yv+srAfrxtFP3oo+zIB0CpaRaklag0y/FdLMSLLSNHnhJ0pOCm02vi/wTlMqcSOM5GPfyVB1PP5obPcITWxgxtjb1VHFnj1P53Y76bvoQMEbrXXjaHfgjP99w6YZekXnBqRXvy+fflT39a3vhAz82eu0v2rpwaNhMr/Irfi2o2GL5An7BwL5McPA854tfYQutqutihQzShUq0TrSqq/YluLv0FpCcoDEmw2M2Y2w2Y1LNSsS5sF66EYr+VF1uOsVHSqaOa19Lp1E/MHBzCWvEhuglPx8a7vOH034hXp5tnB16+YrSXypfhNIHxcqNPivX6hLtji4U8QHgCUfQL2acwrcPuvKLs31AMN6r3qL/9f52nOyH8hHiKnJCEFnScDpqZk+FdAcrHbXYdgxrj/IODO14eDp3mHNpWj0fUneCXnV6+x5TBx2FHKJdcrDEdasBQ9wFDswsu7yH7xLVxdSGsUQUOMJ/1KsRQ/G5S6n2/Lanpie2sUFSvbk5oCgVU8FJyPhIq8wE0+X8NRcYpg1V8HH5Yog5/5MTogy82LdH+a6WnJxBm9qHo8OIql5tGWFkpXyVsSYHROvS1AX6L7W3BaqDVXTUanzU59h0ftftWkUhDknDKdjSuwzeU/eZ8+mYfZLQefSMfZtKPoy0BYzQcMZkr2Xc9AeeQMygVYr26hA==", 1872, packet_14, &packet_14_size) != CHIAKI_ERR_SUCCESS || packet_14_size != 1402) return MUNIT_ERROR;
uint8_t nalu_14[1378]; size_t nalu_14_size = sizeof(nalu_14); if(chiaki_base64_decode("ABYAAAABQQDkGgRM//4CXpb7f7//xwtXrcv7zV5cY4pGnA6VBY0/wK+FDnxGCJq+R3DAqGjw8jzz9hrTyfbrRnQqJzVbj5uSJDzfK5W0AYoc3QzmxkUqz7KTeiC8RPpaKGEvDLPoYgYOpMME70B071QcWG5WzdA5J/ScBrhal4gAoYkvqfLKyxRwy/F4LiLflwmpacB1vWI8wM/6V/V8fAf84Jes+jomQ/SHZHFNJL+TWRnVZ10Y6ZmAUX0h22wvn4Aj5kKXZNSWzjHvO14hNDoqfB414h7+MFxZHlVtsv+rUfHReAcR0STZuX9bCYhl7eLjOvwI485A2+6KmuA+0b8nFY5YORBmjaFAweLM/fwx1e0JzWDpH9IgTMK9xiqB3mWAON6On2Z6ilQrF7Hi9VoSwZLhsYws2aqMRg3bkzJCip7I6AUZrc7e7AUev/07CWciobosvX77iSU3LvZR5z18A+uZrpD+4Pus3LW3mbpXok35afvwUYGueh3be5Jkzo8+mvV8w4v/nKvV6XCTBuhLUbbxy5evFXY24n485E9OpOdjMWI+tSx9/NalBD2JV4kcIOZcNtxDkUL7Wn0B7/yh2zEYGR6zX2kNF57FbHcutYwNtQ+2qY4khyhbhVmuwKKmZfCnPb3n0L/nV2KeLgA+sZPZWBxjrqRXUBuGAaJBos1FUtxo3PTF1Ds7u2ds9EaaoT7vFR4YuUocrkLtH5/F5+PtS12+7YSwWrKyj2GWJIp5L5f58iO7Ut/xA2qu+6m0bu3Siqly0IeeGcJalT7JwTEOUJnhBULNrVR6ZqVSS5pE9fm5NcPXZ/o2wkPBl0RiqFtikLFNTE1jAwer0w+YrQwlsDlYQTG91ug24A+/aZHaFGM1Iq9k28ZTMzLDW0dXMILoFoV2WbxoKZP/GNayH6YskwKqOzTMocjYXUES+O1wibk13vvlGldTmLJF56BYWuhuYlRDsnXEEbRg3kAj67Tz+4l8ZqdRZKbJXY1u/BlH0dW36fFwPEXPi7w/zx8DMdMl6qSXNMixun+Kjf/sQUXj3a3hRLt2YDgB1jP4vl5wyk8+UiCPtKMF/KQAnW7FVFjdrL+bcrbabeTBKIDoNScUGeSZ6aSDyFJtn6lPwpxBXPQOdWkXDTTy7lKUgqS+QNuNYIcKM757zJD0nUfJ0o/UShM2iZZC0Di+Xl/Yej9W1fOhOJU/QTkmZrwbMTb7/O3Qp78lLPSt9AvFmDP6yPyBPva32O5sEQJy2MXVsMw81t/iUmqNlPSjC3Psw4fyaSdNb4MnxkqQn8UMGaNAHk+/3oOEcW+vd8xCNGpMrXp/r6c0rzxZpWMJgLJnTeO7g5gahAynn0qTSFO7yejuymV4UYe57oT05XdVmUW3ZZ+jjOdT+SEFgYPNNfP/cP3A28jypnGeuFcNu+abDXvPLXvScQxQkFZTJab8t7gU/A+52XlZ6Dekm3ga6Knt4/nXdihWiOHwqTy8PHJFyDjA3qysiAkqHN4GrFAtskwQmzZ4SsBneJ0qE/5DYSbbZmnjk6NtLkyYx33nhDTNidth4Xm/SGQ1hNvN9psR6ks2XplFUpuR1XLZ1JZ5A/P3JpHJE7rL44+zcKP8H8/zfTvH7KSelT3TdOEHqlQ7JDh6AAy0ekk+UV3F73mz+5NwE4NU2NHN7AHu0WyQejVkJTfGjptVYpECSMKr03665I1wbBqyi8QhdJFdce2e+x3+OV524ADGBPNB8srnqaFGL6kTGBH0e9FUtEwLZDrMw1XiqslV5Af7gt4UtCo/I3FlNIzD+U3v+bbdiXp6oT7/Jyq5Gt35HkghhrYAMX4AKVGI/w==", 1840, nalu_14, &nalu_14_size) != CHIAKI_ERR_SUCCESS || nalu_14_size != 1378) return MUNIT_ERROR;


ChiakiTakionAVPacket av_packet_14;
memset(&av_packet_14, 0, sizeof(av_packet_14));
chiaki_takion_v9_av_packet_parse(&av_packet_14, &key_state, packet_14, sizeof(packet_14));
munit_assert(av_packet_14.is_video);
munit_assert_size(av_packet_14.data_size, ==, sizeof(nalu_14));
chiaki_gkcrypt_decrypt(&gkcrypt, av_packet_14.key_pos + CHIAKI_GKCRYPT_BLOCK_SIZE, av_packet_14.data, av_packet_14.data_size);
munit_assert_memory_equal(sizeof(nalu_14), av_packet_14.data, nalu_14);


uint8_t packet_15[1377]; size_t packet_15_size = sizeof(packet_15); if(chiaki_base64_decode("EgAPAAIBoEQBA/HQAnwAADNAAHAAAQAzdqYtJOnis8/yz4FDcDSjq9aNMpzhF0BTHvenWSGZdD8hp/EX8oRSzqBzcsystVwv7yMafl4NyT4giDQdjGHwrKw2/++/KAJ2Peryn5sXPcSP3SyjLOnSw437grsp6g7j10hmFMe1MSlNJsrUX2MICTB+M36MlDiu0k58UR9pAXnj/IwTFBEKSQ+BiBV95TwwFaHAuvI+E+ZGAqviKCFbm2A6tAzbFUC4FKNlnxBrQ45N88vpbE5IE/zkQl94Jz04rKpbUAmri70uCAzdLDi6BUvxm8vFquJecEb5Pygx+Mh6/B5l4TYMbPzRg/MK4HynoggbsUvVobafMHoUq5gFYOySfmePEvds2ewse7uKBoRma9MV4SSZcXoRscVgTYfWYqGmFpIHaYtpLY+/iS+rmxRF5Ll0QJxmXz00/CByS1pYtnNNWmiMpOH61UkHBF5LZH7j86IBV2Gwgm1As1Och2OFO3/oJ8ipXEM5JpYieTrnTmFQbHUAvNI4vZEocPKGoyuwYRotj7BcUCf9Gn2HHs2x7yGQb5vfoM/1pkcTcTtql7PhlxG9gM4kYfWIYdhYBhs2iRR8r21E3+D/08YOWF9Cd0/UqmjKfVhICj18zrVjGyVfezeXw3jy92IkppQ/SDGiH5Uf0wOvkE//Akh/L0rOIqJsWhbYKXzLynECUUJj+SAuME/CLRbN8iOXt3Qrzl3rMsu/YJfGsyrGN+XVpGeuq43WZPAbez9RoCDjZsqjGOnLRchvArkckUjiElnMeTiWNx5l5lTO6bChcZpAqfZXRVlWHHB09+fDg3QILeCyPCBUax4ZS24fm0yz0xEF7kZSQGwywCQrrmJco55N9AI4zPA5jUH4GR6mrFltn1IKHDUReiMC9Zcf7q044iq9Z1BYcFpcXoAaCv7RQVRcOAda6Z1TH8Ct82KqqL9BUkT07cOF1czwidSO3OwaehsNLYtVRp3zl6gEaQ+wTu+fKHPHMf20LPjHEeSJgXQMni6HnykPPXbK2FF0jW102mF11BWIXVhqz4YyuQfUDvcV8PgdwzuUdXT5DCYTI+reqBt68hiehrTOohS4K4fNlXB//+xiGX7u1b5u6eTJ5PtxGdA8A9NdsuFN+D/2GKQyGbj9ScfyWBYkDwhyCEjRYBr1yUp8nKjyrk76l+A3AzyXvpgtUCeYV/u/J6dph9/xjjXNFGcSK1lXerHAmhbp48DS1GHEQle4Nu8YEQP9t3Hmt3crD0Q64M5M6rN9/REkvT5WchUjGiN52tm/W7sHQ1F69Vn8qwfGpQEUWORJgcalVjdwvk1DdhvD0JS7AfiGPkV2Gjq4fGxwXYDVdDsvH6SQMGbmb4yUijNiWhtzfX9eC5tV7WXsSA+kul9TvWhodWeT6uMJW0VsWz2YpJzMeuk+GuozP/ISt8lP0ZVeF+xUuqTv8Z2uudjq79/oKKoUmKLS7UYN20e9RSNGetWkAndupBbq0YKQQqt2exAIJkLyIbFFYiGgmoxYSVMuCQS+aOtxH7NjF7w4HOGgXHpiu0qX0moFKytXQN67UW6LBZsz+1xNFF/aMIaKeyKOirAjQoriY/6Bgc2YLexlrh0IL8HuRS/X1+4IRgYl9G1UBBldJWtIqF9kelXrEfp9m9gy3NhHzSkXwlMpxwZzPoWGs/3WLPew2B3QOboBcDVrJ4UbryncQy35+BrnmPDWFgYa8FWtxErfWRKSCjTL1oTILPSXkgvw0abW6QHnKRrV5LRownk3L1JtR0oALmhx58Mrcm9HlI359aRc9ccWb6sRN5xij9QQHfmlNQEC", 1836, packet_15, &packet_15_size) != CHIAKI_ERR_SUCCESS || packet_15_size != 1377) return MUNIT_ERROR;
uint8_t nalu_15[1353]; size_t nalu_15_size = sizeof(nalu_15); if(chiaki_base64_decode("AC8AAAABQQBCJoETP/4AKfrf/32z4ob+nMCbUtuYYSus0s+798nlmNpb//ehnTRj0pJZPtaLz5JicNbcWAt0+xPI3cLa63Ptd4YiIqkmSbSnjA2RajTjzn7JmUKuB603eSdTcBMMh+OWcIsucXVaOzGkncruF/gCMZpssjPKmUch3IOa5b5Ub+oKcMpLL7+0plF7IPaDawitAsbVCLLR8ToSYMVG5QaIOMX+oe9b9yCZiVEK6PVRUAVN/YiAch63Rr6LBZAsW1kakiaEtdKk6dAdJs9uw96KWZqTva9ia89CaNtWIwrYZATG8hrej2xJPhD34RyS3yy6k/KV1resVUIH1yTsV6aqIXWNPuxeGlwRxXHGWk3WIlrmoPbwmfLzAVH9eTNvTsEoi7wzy8DNHYvUnU45zPt+cihmqIsawsb+LKvbAh6gO0nVFjUcVYoTjthlJgr4WCYvQABefTN5JizMBc92yrEFHkSJwbQEhvFhp1ZpddL+z8GMrPuBfkF5QNA4m1gsC0mO1ch+9WZTSLD0FzrWQnIIO53dTCys4kSbEAgXg9WqUCyGWL8mC5KgQF3KPXrEyJDtw8kVf3Ix1+v67wAY8Eq6aQUAVYsG9V9ExtTCRZTLwcMdru7vZ+n/ERKoAD5qWLtVY7ytYd0lrWbkZZ30neaTHYdX4xnqBRVn6/qePXKO7lLWmO/72KLGNE1iE9zmUp9N12ofbPHcm1R56RPP4o+ikjkfTNVZfFxJ+fgWXHbzNvAN2KdIgq9PLUry90gcdZIoHYjIhBoug+P05ngFXCJ3dXj0mzruhPJl1arW/KHs12WTQ5E/M1hgGxDeLux8BIH6VRZ0yMNfxDIPiO72xxH7r9m/nvykIVZbuQYxYNN9U2B/CtFTWS+OdQrTpKx+ntcM238X7WlI6BzzXSQZkQOv3DDg+aAT9Sofum2Oefo2U+3n1nYO8GvLE3rvCIW6MdfS3IkPe0XOUDuDdSaliiYzBFQanzblYN2tFeN3sdklKfXJFUG7HI3vnE0HkKGU7E9DX1RWyIL6OD5pA5R9Jb6YXn1qQFO0NvAVuFIyma7LM2TFZ0yo3oXi8LJ24mDJt0Pcc2vObAD2JyXHnlRBvzIfVdIHjsR64JUj0hYIsa7y4D8YbDyoKcYm7AcnJW8yvzUkE7MTK8NxGB1OpIEBS1OdynGlKLMBwKYGNIky93TmtfKYpVCSX/jO7XMBI0q0ZKG/YD1cuF5gNOWwEK7WCeJLEV8sYIo2QbGPcDl6ldVJkPQIQgardJQA9ugC7qYAnSKuoLkhitQ7d2Vrskg0mzMsjK4/S638q9ADvunwnFOMcQoZMDyjHN8N0nDhWcQ+KgHW56/Om7D41q+Drkb4H4uJG6wEZ0Tr7dmHpfyrBdVf+AzHMhXIkNpUa4yM+xsRYi9SIpFhTGtuPWbq/RLOeXf29AnH8vtn9iKaiGK9t43FJ6uLcglIIlYbQY5InSS+AgK9VCuZOCOi6xAtWMeg34DHxd4IMd8mTZpWaeS66cn74fbsLkDNhr1CYfqmrtg/M+23g0YJ7kTT1DQaC7GbhgqB228OrrNX+zyFipeCmi5U925DCGQXTI8cZJ9E5vwU4npKpLwnW4kubC+D53EODM19vUrztpP/IsfeGAaVWA9XOgg7FV+PSZXNvhQeNEDsih6L9HUgtU2FcelwJzw6UBd8sGlgEDG1D26pQkuk9htcXgTUdB9MYH5isKxqTgjqEjVXkwPGcd4HK1E3RNOTy+hhg7bv6hdkTRkGbs3IReLKEX04FJHFT/zsVsnmqmFle5hQ", 1804, nalu_15, &nalu_15_size) != CHIAKI_ERR_SUCCESS || nalu_15_size != 1353) return MUNIT_ERROR;


ChiakiTakionAVPacket av_packet_15;
memset(&av_packet_15, 0, sizeof(av_packet_15));
chiaki_takion_v9_av_packet_parse(&av_packet_15, &key_state, packet_15, sizeof(packet_15));
munit_assert(av_packet_15.is_video);
munit_assert_size(av_packet_15.data_size, ==, sizeof(nalu_15));
chiaki_gkcrypt_decrypt(&gkcrypt, av_packet_15.key_pos + CHIAKI_GKCRYPT_BLOCK_SIZE, av_packet_15.data, av_packet_15.data_size);
munit_assert_memory_equal(sizeof(nalu_15), av_packet_15.data, nalu_15);


uint8_t packet_16[1356]; size_t packet_16_size = sizeof(packet_16); if(chiaki_base64_decode("EgAQAAIBwEQBA/YPlvkAADigAGoAASAziktJWYXDaOHqpOyID3vBIyzVoWyV2Ox3LIkGgwG2Egyp4l/sDCRt3YKeIyx8Z2e9V3OHuXqwlSKeYRHCXttw1IKwx+7eQ5D8Qo+d1uM+mMSOAOhN5kUnicllGRTtPAnf+XvMggZeWQkZjlQfYLXZryCivQv4g1wquB1NUTLUGhEdpbli7Rj4c1ZS0UEfKyxxp4yEAPlTKfXixdNsmJrXF1v7kRX11ERGvR07F3ZHUwZMIT/T6VzCU4zd/WQ9yiyZpHnwAlrhXsL/4cL3uZwNExrSLnJ1t0uenZEeJrb6a6h+3fSvJPC2Y7sfGwr6xu/S4oA9iV3QJ7D+VuCUlcM94j0A4KLCSkJzoeqqNjryuTTEVoMtkbj17h38e/VjjSpqCpxWV9tWg1Ify8MpP6wJMH4sHo83+PslZaAhB7Z1N9+pqbNbbN0Fb/SIvSus/PYc+7y0NxElUmm0hlKAtOWmcwEcudyLpLeETzsPadY97znLpcHvJo9gt/wyn7iIoHCyIxjrsgaaoapBAn2mHdbKWwOPY4+7RojGwQZFdk/FUVrrtLz5FX5m0FKUfT3lCFgagoTUqbfZJJQEQW+awkZiSJteb1n47Z2JW7wZUCHq+OlFOQyv7h7LukRUOsSEbt20nGSiyIM7RIOAW9MJxv0DgGsKs8oyaBwktN52P9lyLD4Czxh5qeG8Ce2ffKFszsnGeVV0lLxRqGHPTl3YmGv2Xh31dn5mHo2hCHS+2xtYuqMzNw4D2f2oatiVljL491NI9DrCztQN4a+UOQsjKmtKHbUSQMgz/uljQLXr8eBQWEXk2Yr9OS79XIrs379QogqDmlNfOTTAz7iq0QT7KzeO687GLYJx9sm+sRYnS8T84Wz93cOAb0+l+l6dqvW4wCE6zWzSvgMYuVoEIQtoERnfP059+TFeKDAqYYeJa9AM4Ew94pGhlpJcE8qA/dum6W36Xllgen5BtCH3KbcAIKuPqqaVJ+Offx16X+wHnODeAwg79vme++OTq7AYIwLQn1l/2A+DogmBIPTHbH50SGM7zt+ogcyEl1hQnPt2WcoKeo5wrHC5HyDeToOWOcIyctHfNkP7jGfP4Cq5+pBcl/y0NdKatWoPGguynxwCeEsBBn5qeKPrMd3jEpOp7A9mD1QXcrodRZnprfng12pftZvpxuV+zY2JxUpxiQ4y9RLc4hnNnAiSnrOK8vES4skUyeQH3/z4xStaYBRP45bOwc8nxzuk3zmQNwpZZVhFS56y3LxK3DJ3jW1VzPoBEFNn1BtaZKLMlu5jqex9w3UrxK2O18spRJUaHql0Ho+2ngM/+CX7d0dLXn78GxAizQmZSRRCQKnrLtb+EqALS+y4zx3IbtYgABRWN27nc9p+AOLHhuPGP4ZZk+bJ0byYVJe1uk+ZDn2P2eShNnmm1dSQqbwYRWVSmCQYs6Diz3DGkTuUleJuydHbU75TWfL53ClK9Xin+NIpjOt73chhTfHtPdS+MEU6tog8ATDTeZ+/fqP4TsfAXg+4T5HEyuhNnBzr9yGCWXsm/a7KeEPqhJzl/cRIlnshRHT+uKpoWlQb0PjzPUlvQvSvCC3Eg7xiYcycxDO78GSHtvBheB1On7ecwBe+5bR06uKqTFxsHxPLzLG/9GY1h2R2Nu6GfKq3Ft7BEr3ncKJ5Ld92GHhaSokRJD+7UizaKMmbNvLnlbEuE+woo0Yoyz0GnhKFZfnzpmIE35OKiolLSsoYzB+WMohoaW8bRurSarIbpNDsel40r0ai4gYhvV/6", 1808, packet_16, &packet_16_size) != CHIAKI_ERR_SUCCESS || packet_16_size != 1356) return MUNIT_ERROR;
uint8_t nalu_16[1332]; size_t nalu_16_size = sizeof(nalu_16); if(chiaki_base64_decode("AEQAAAABQQBQJoETP/5gqzupgeUmA9dN7Z0HwyEyVrxRyX1zzBdDKwyMx3DiCi6IxDaGG3dCtmMyHNfsFUm0+716SPggjfOcwNUQu9bAEP8M/tqq54vAiuC6f45JQlt6NCN/KgZ1rKqEMJg7puSmOgFttfNPGse4BXqgwwWiNWoNSEGWNYOzKkgjqpmBkpnYLEVLjJylBOSx7ktd/AoPXggS0Ee0aV/BcWwTMIj2NBbsxfQ80EDnWCiAUfcC8fsw/sRLxqoetoRa6BSnshIJ0qtf2zPkVR6x4KpTLCTAgvV6mIp3EpAROIC1Bham3KzBk4ISMMQ9mb865Hy1GmEqI3Y3Qu/N4VN9Mm5t8QF/oxNG4tylkPRuiu2UmXemkQCoe181xE7IQNDhcdD7BHGXwKfY2WTwRVtXaPoeogAs2X5dL1H6gBpK3tBtSy5v8qs9k9hWifBYSVZgvyCC5jPFIibz2xGV4dahKeKy+9jtn1yg051IcN27Gew3NinXyWH4lphQ0EfqxmPD4A0krW0HUak49oENsnAcJBlKgY47tbQgN2nagwXxpipzbfkX321Oi0tQL1v4c+J9qv6NicwlDZ3Wb5BOgQPxm2zjs1aMc/tkzSWs86rq4oGlDoeVUn+U4bO++spnbnfggR8f9MMuxuEQQiLOPnn07jSboDHGZjwk+VjuzlT20MpjIoyP8CKcbQ8xa2kYHNgopKkyAjl11X4+f6Dgz98N64GpPqQJqRmo+OBv+42wPe95k0n1NGJV4zY+695ww6vJov+liVb2BXYEIUPYtPnjMZbmD5BtoKC4Mj5z3Ce3r7jwJYWeGfCpZ7IyVFpFhNfraG15WDlz6cwWJo1jSCqHXqUI7QVg2BzbnuAQayaUitPWuHquXMJHowjInBm7n9nZCyZkg9YjXL1O3MgNXLp97oujytN3WwPqdIhf/fosJYLYwi1sWACmpYfe+M0REkHmjl9IMBMzifWSFy8M6MiyEhXwzbmbjKrMv2e24KyGWCYQBO+IXQL62kyk2DiftWuCywkd3Ny5bQ8SVx2Gg1CHpVvQn2zIGi/RzkdvtOY1kpPxgqWzUVLwFP3n5f6UPBIrsZDB3V0GBzBDxZcOYuqzYsLUjfwrYwjLfzifKilmBrxRTJB/u/mo217dvSvcvQ4pj2WFtyX/RryJUzkuNcGHWehLXFwJxN/PZKF852+/vd7g4xnC7rJDhOtkKxKd97BoWHPJmwWPvQRoPxvp8i/xKh9VR7ZVFAf3KLCc2gQDuC9ubILa1zpW5LdsPCH3jPaWgLxVQh5UC3ezQ0Kg5l+8Aj+Iqcwj45ZjfftwcXfkA5ZVpVoZfFsJhCo8rh/bDZnBq2/GrEaMinG2/i5odgGk2jC7VbX5Wy6pxH9gmf9caIlxIU+sX7EntzEzXpSHkpOet9CcJw1AnLZFflAZmkBaB71Q0VoacpAfGa6VREYItrVo2NbiJyjsg/7yB+8I5ySaCQSAngi/IV7ZqPNX8XVPNB0dxMG1saTgAIY15Oe6ouSvQhd1dH0hijeLp+aIctG81bKxzDk/QF4Dl9F9TO4L97MCbtl9NDBk7iy5tuHpjir69lpfp3vhnrf3gM2uNYdwquY31nZLsMGlTix5wOoGOwgf5Y8O/Lo8EF9G8J2pRwAGxhE28Qgds7lTExauZQZNAOuU8zRO+dNOmLgko16oYT1tenZQBiQUgP9g0dMZV155rQZdugNF/9yTeKcr7HlfXC+mfZjMDH0be2xTv461QSwEP3ig23B/yPga", 1776, nalu_16, &nalu_16_size) != CHIAKI_ERR_SUCCESS || nalu_16_size != 1332) return MUNIT_ERROR;


ChiakiTakionAVPacket av_packet_16;
memset(&av_packet_16, 0, sizeof(av_packet_16));
chiaki_takion_v9_av_packet_parse(&av_packet_16, &key_state, packet_16, sizeof(packet_16));
munit_assert(av_packet_16.is_video);
munit_assert_size(av_packet_16.data_size, ==, sizeof(nalu_16));
chiaki_gkcrypt_decrypt(&gkcrypt, av_packet_16.key_pos + CHIAKI_GKCRYPT_BLOCK_SIZE, av_packet_16.data, av_packet_16.data_size);
munit_assert_memory_equal(sizeof(nalu_16), av_packet_16.data, nalu_16);


uint8_t packet_17[1381]; size_t packet_17_size = sizeof(packet_17); if(chiaki_base64_decode("EgARAAIB4EQBAyk8f/gAAD3wAHMAAUAz/PrXb1GIqkfwcn4qD0MEN3vnucZpSKDH8qQBwxys0rujk//EU8LVBJP+gYP8ydJcfVwucn4P6WfD/SxB9tGCk7mh4NDXKqGjMjbo8FqmFW9uIUGhCmDyLgsL6lX/ZPX4Jy6tV2f0WwhappPOHfREnUy7yVRuNiZ9Pu8ynbUhbTAatvnTvnK005UikG3D8pfzYljzu6wwBGgDNcaD4VDcGUG9e6Xun1CRs5FtVqYCeLhZ/QEYHP1fgz5NIYEZUXK63euAXOC6wFoG/a/pV5T9WvTxl9u4V7RRFY/4EjtL0lQYcoQtR92hq2cEse+Mrq+I1J/KCRirtDr4TQk17EByjEb2ReHWB0PdGXzERPv5oJlLbzM1ux6qvTtJ8YExrIfVb7vAgoIutVTcYKVoxRC3kgCyn+TTdJ4ph7Yp4geNq0fhO3zwsuKOOu9sf+qgFUR09tMYOfTNh3QRp5ZUXACsVL3AIgt/7wm/aMI+HVheLHA0V/e3wTmvIjJcWrvTNyMZ1kY0hpb5JctJR8FxFf4EosWmm55bpPESEP91yM5zcm+5FYSQD6s05cqOU80BinEn2quxGAvdkQarbGf6c6cCRvNbcAKiPUOH/qMdNPRvm8yhtfguZpLhkQvocLw8wySwedKgdHoM2GQ8Caz1RgWTfbkna2J1Pn7vnDxHOyf2il5KoLsgm0EwfRWKM2qARGRgOWZly+wv4ZEcGwyeHgmU3/B/v4mPnjoGHUtGja9mPM+t0BW1hxkTgJLtV3T5YlAHIwTz/sl7xSfTMFNaaquD+H0CCCopjhWq7s5EtUNA+vCbPNQw0dpFKehB/rQXr1SJMgpw+iQeeF62JZ28A84bW1F9XkId5jPqtOE7lBa994kzmjUQqrVAo3XZxWWqiuB+YdO0cd+M62yyTcaslzmbta28/KETZKEdsYmuyP/jls4P5a9R2sArj2rcTRH24jQqxCO6ErptTa55YMOyKc43e80LA+IQNhqMxZK7eQZkykAk9lTGHVxInOAk945c1Gn7emnBC7MZ4iRd5eafqaV4Qs0hSJvwchZMjiWsD8zziTyUbOsqgVPT12le4bV8UnxXU5Mv8UeaeNqQzJZ1QcoASn+MNE9bhkgzxfeY9XYJlhUTW+qj+oLpKJIQgGcxyYk6y8nRDR4sG0GkSTxgzce2dLppLYobaU/dMKiLfywSu2zZxxHgn90JxEv8D0Hoc7pyeGbHcLjNn+La7sbiX+gc1O+V4xAy1248dB+PhJXKKQJhuzt9RVV6yyDIObrakFWrAhlymUw2/hF9NUlk9W6VcIsu8MKM0KT6WZPe9ruboscFMpC+Yryxk9tnjyViSWkN1yGRvMgp/MgjPEhy9/tB9jOntd34xeRU/ExzybWI0tf2a37TxcTWeOorDLFsOjaL4pWwQ6FsT34FluyqKHNxgJwEkM5rFzO+uzjhOOqDlrMWcUdbucpn6hoZ+i9frSqxy4/2swfG9ECMj5kXwUDARg7e8MV7YLZa+wB9R8D4sh6rwNcQnYP3bR5KR8rIWDKxT2GT+66odLggT04vKy4MNPCbMxfVsffneI8ghDznMg2ldbq6r1QdS/B0dc+vJrjTcKEAR5I1q79AOxPbK+g6gGePsGCmLIKr7cduy4q2xwLxxNGwp43a0M49SKhKinMwuyNJrNkgmnKgWZIEdYYNi5FFYuZvw0bgbEG2gF0aALzc8tdrnU5w5KwqB9iCjcJjV6f56isEnkk+W1t/glPWS/vuzgxEPouVnDRlUAlJu3tBshj/sVqXRv/B7ny3Vjx5nB9avEcqRhWrIj8FLQ==", 1844, packet_17, &packet_17_size) != CHIAKI_ERR_SUCCESS || packet_17_size != 1381) return MUNIT_ERROR;
uint8_t nalu_17[1357]; size_t nalu_17_size = sizeof(nalu_17); if(chiaki_base64_decode("ACsAAAABQQBdZoETP/4BcBi6eH//n/hE9E0AGU6jeISCmHSuSkYE48UpajTn1ge+ZSgI1r83HaIk3BQ+BkwemI0sQMRrKiZcjARmSlQCWJCbR9872jquD9ABYEJAGtU3NwhCTOAgdkMDRxxic9WaUQpFgdQiOlaNwJIZchR1AHkUgolT5ylfEaqdG2pEXl/gkXGIKOc8SjrSAclp0yK+dv0ehD/9YiZWZgkOonMYZYITvohkJYLfb1Z/rRyHubqeGQ0JqKc3NLzRTckClacwsLztY8A+w1+pGGaJtUbD+VZbnrgTgWCN1xTSsLtZdVrVQkPzrO0ndxCT9m5x4PYqoL1vXe07NBes9IswTu+hlH5qPJcJNPUSX1Lqu1bIDJ34eIPiBSTG/fm3mSUag2CHVjaY+1ETpoqCO4iTZ86r1lh2n87e18GNGhQSf6YGgmZFsetILrG7VR4uEJUO5pYd1TmMgpbZbWzDF+xoCzOuIQS4MmJMLTqiT80+0pwHEgum9X5OaffFzBAOXTw2YPappXhj29eHgGA87/dWcstVD4FaP4a9JCzncTkEydm06T1xxuRl99+zmURxpBEhl0rypsZ6ParXsB3CvDIfnZ56gmZgVmpRn8VrlwRsqLGkPj15elpMY2ICwSW3CSPKHhtx18eEE9JuCPNrVcie6JLTq6IiGAPgWUoXby42sj+wqdOcNfcRx/lNxIxgSrh2hDm+emXS/cL5nMGI6Ya+KHGImqHUtmYcl0RUb8JfGm78OOjKUJ8JKh4bSFxMd6u1owVGUOVYdAX7zdNuDbyRqUbtzi1YH6tY6+To6nvB2ovDdoLYWavZ5xl4Tzz3rtLQjKYKeeX5BJxshNbaXlSo/a3uBP61uOHjaNYyXsaZUvkvE6tHyJikOnh9vL8ILCgY7m63Syhmz0emN7Twzhv30WDhVsV/4l8igtRLWk6e8uSDVfNDeseF2qb46DZ6GsqBB14+vNlNe7nryOGX09qxYRP/bD6YWwfqkCJUSX25s0djnIm9tmrDppHdomFJNyi7Fn+ZAo3aC5QXyf4y4lXKc4D3Lo9Ym4+eylBSDOJutoj0LK36rWbSe0MMHMkj7JkN4X0HzGZ88OhlsSl1YA6TGEqoPCBxYNQrnazPHv4bDjgqNSguYNsPh2R9VGzxbsJZELkhTwJTCyhbOH1u5HiyF3YTNi1sziKJmolWcz0svDnRjaBhaV3OWvgQUnoTWrqHsweAmLuOwWFa1j4jv7Uwxw9mNtZ9/1xbH+3Www7WfXZj5McqutuYrLijmGswdcuRHVhlL4QZc13aXGzPdp1Mkb64VRBNoYQJTpQU10mKgyj7WX1j9E4CBCOik6iQlQAtuNa1kQzyPzQF8OUy/yze5MgkO8BPqL8OAkALlYolbdk2se40YOVPdnNNKFh81TKL6+93N+rqtYjMhdd51IKy/GhqPIeTdsdzWEKYXazClSMXT6ROkhzxEB+Vb40Oz4BAWuBw1OABqvXx95rZcgXFXYClsui+Qz35L2X67wf1p/NuBK6fBv4ui3aeJsboJ32aBrXwzZatzzSebV/SDRrhpaSRJishdOhLh2MTqMQwy+jmgmx0wZCjbKHqqcKseZ2HjzInAbbhotKmkUeexODn5fI3tqMy7KQSB9dXaxtKGvqpX4yDpyl/GFe0VQb9eUFvCToJeniOIiRPq/sTAAWUuDf9wOpB3mfKaPtkSyvDc2u2hlujbUKYCfKQ3EZNwvPSgRt9td91MEfBLGRqg6f4VrVeduPLA+z1kZYvv+UVh1s51bltGP0uAUYZaRjUWmGLpw==", 1812, nalu_17, &nalu_17_size) != CHIAKI_ERR_SUCCESS || nalu_17_size != 1357) return MUNIT_ERROR;


ChiakiTakionAVPacket av_packet_17;
memset(&av_packet_17, 0, sizeof(av_packet_17));
chiaki_takion_v9_av_packet_parse(&av_packet_17, &key_state, packet_17, sizeof(packet_17));
munit_assert(av_packet_17.is_video);
munit_assert_size(av_packet_17.data_size, ==, sizeof(nalu_17));
chiaki_gkcrypt_decrypt(&gkcrypt, av_packet_17.key_pos + CHIAKI_GKCRYPT_BLOCK_SIZE, av_packet_17.data, av_packet_17.data_size);
munit_assert_memory_equal(sizeof(nalu_17), av_packet_17.data, nalu_17);



// -- frame --

uint8_t packet_18[599]; size_t packet_18_size = sizeof(packet_18); if(chiaki_base64_decode("EgASAAICAEQBA2wBjlsAAENQADsAAWAzO/Uwhg3vaVoeDrHSwDaDd44PcTowhIymn4cBeWChpL2G4hKvozU7CslJ0nL8XBvBeL54ZcftRK+gpVL3pt/p4vWuatNmwu3i360lsvET7apDRQ3GIBElAaAPNzmNQRs9dkt4a080+Lac9Rom5YRQ23HEImp6C6wWFhd5vi1AuKxDpfNcKYxwuYTr1G5ZFSmtzHb6n/81Q4TkDb73C5yjMfeWyGJhF8H//wRn11umevrheXr7yE5yn/AmM4o28UJynUFgVMlzCIBRKcFYnXmsFd6qqeHubTk7ySVaDzjVB+5IdyYqrNvmb9sZsX9HqTB665z1/YhKXmprCU7DoozMNnyOk3fZTdg+zqu/CDHlzNkyX79AKQj5+JJItuokIhC5Odi4KpYAerzn+Asyxrn0jCVTVhBKHCjLljWDnlwltv8DuYn+Sjs9U0ibYNMWHSEtFVPxZ7hm+7ZYhzJUST85AYvfUJvGlPxCIxCDRJVvafHr9eXFnlG60VSEhQ9oMK64d2bSVogzdvQcuyIpb48j8/jDPKPuyLdqHA73MQITspbwAMWTmuA++iI/0M02HBgb8k2nX5RBZ0Dhk7PT8ur4RMKVAo/fAmqGVEyWBuw/82cI+aMjncg8OQ1U5rAm/6TsdSMcqqezFRPV3cSTOKkkYG99DmPg/Dq9+o/tzxnw8eCmpKScvgc36zbLGUeXgQQt9gVjC27Oaw1g+2uxfNGqnHyJgaRF8VXB0wEa2kxVxNLY8NUCFraGgN+m0EU3v2Q=", 800, packet_18, &packet_18_size) != CHIAKI_ERR_SUCCESS || packet_18_size != 599) return MUNIT_ERROR;
uint8_t nalu_18[575]; size_t nalu_18_size = sizeof(nalu_18); if(chiaki_base64_decode("AzkAAAABQQBrxoETP/4DLod9xZ//+BSjirzcvUbxJ95KK0Ee19Kalq2RQ91AYzQVIQ9E99RkATuO/f+KvumnreJFieP+U5mnhx/CctnpQyHYnvnrvdXT3hnlyBbsgpU1zc2jlF1jaY5kEQbeG5L0M3+NQ9/bk53oqs78qgEwrdcziIaqmoeO7VYRZ/++jgzdPfdUA0N8KCvYU/XZa2X08ee+XDWfMdK/GmalIP62Au+9d7yf+a2jJOm6AaBQG43p09Sk99KAXlVo//ETKe34uXsIvmYvhsvdqYzyRpBL6RW0/sR79zCGsRjcOw0w1Nv4LAN6ASwVaSiOAxlUimkRjT43IYNpGYQ70saaYUFgJwccUorGgQWvMLscA1TTZ2yK6yrHo6qBDXvVMZHNYmTZOsQCsv5YxFEhwx5+QT4C3a50NLsJY0GIrc34EBD67qOQp4b2Kjt43pY4ycLyter3+jykc+1ZtYlIe+Ecbwhf4cQWX6H6E4orOiGsB/1uZWU3MDDa0/6AgVULQ+6QDg7YjSBBNd8te2jWhJSQUd3F5apnbUBssSnb965s3CsqSvDq7IUV2P9PLlN/hpmOKlFrm41oVPRs0/1Lnu+Det4N3iAoSd4nVS88thuyhSs2Pb7y4G/FsWEaD0d8ic/IJRhahEqwSuTqUrYcD0Nx8XTDLBhjyGMamesNzN6EPahzsPs9UmflNGl09+z1+jXT3jWewRQlwojxPImQ4UgroZzcnPDLz/C4Hyo52GRRSKWbTUA=", 768, nalu_18, &nalu_18_size) != CHIAKI_ERR_SUCCESS || nalu_18_size != 575) return MUNIT_ERROR;


ChiakiTakionAVPacket av_packet_18;
memset(&av_packet_18, 0, sizeof(av_packet_18));
chiaki_takion_v9_av_packet_parse(&av_packet_18, &key_state, packet_18, sizeof(packet_18));
munit_assert(av_packet_18.is_video);
munit_assert_size(av_packet_18.data_size, ==, sizeof(nalu_18));
chiaki_gkcrypt_decrypt(&gkcrypt, av_packet_18.key_pos + CHIAKI_GKCRYPT_BLOCK_SIZE, av_packet_18.data, av_packet_18.data_size);
munit_assert_memory_equal(sizeof(nalu_18), av_packet_18.data, nalu_18);


uint8_t packet_19[1424]; size_t packet_19_size = sizeof(packet_19); if(chiaki_base64_decode("EgATAAICIEQBA1Xi8N0AAEWgAAAAAAAwp9BvtGA7UU6jZlRRJXCf7pEen2kKddGXtWhjPa3oa8Hc5TqGAWcFuYXb/ATp6LIeA+esT0ginLL5wG06nAMoT0Cp5YYIKt/qvVLiIS4b9uk1N57CsDYxierbDvuPb2rbexsF0AqSunZSSFQ/oDawzgFkgCzHZnIh5zsMCMjejRc/oz/un8MhkzVAi3c4RPiolb4e94dhr7ZIrDDyXflUOXPMNyantCGdzn7SoPSjbtNItrF6cs5LWl4CJ4uDY66FmWc3Zuwvrbh5Y0P4cmg+u5rPx5rkSywQJWS3sRl7HEBcu7ygdNvGafzONjAbgX2A949u6Jz7Z5RIsAosP9ptph63lYKRRxLXlFMkGPSemY31gJd7oAWAwoEccGvpgyEckH3kO1sY/zr3fFFVYxpYl4u0+3zoNqd5GNzinCTHzJj2NRR3U0EOhgckUwrHBnwYbY7RF8ee2/rMV+AJ4i9N3OfleiLLuoWiAvRYsh1xqK/Yz4ErnsYY0+bJcol65vAGBwJIFFVhKex+S0AsbYheLN5X8pVXnVgclndS0tT6vohNOqsvZgjxE5XDXKpBGjfY3/p1nbQ0pC4Y1JL7TK2G/9/Eroz4XJAr8fiD7IF6CkCmqYAJrIkoD7WXl6HwlRJTu3YCYojiUM0XyHDfm+kh0abYtau+/UeNWmQXtKUmAwotDuQaH2IV3dgr7WPe53zI2umPKe0wgqKJF5WMdFn57YDmwsxqCBqM+2GifPvxBKxntcMWuNfufVqGDgiDzTlV2wX7wmqdhYfzo8rjJFGBFEGhqYaGXSCOfKbhcD4q10ibBChh1NogTcAjx8rKCu1cxe09kq05HQ7756rR43gJ/yfOJA/0w1sKwTpW2wR6Bl8y30zPFkQj4TIGc1QTer2ujlO8FTZCo+x9eRbDzLtEpm4jdYZh5NwG+ikm7pXkBEqtmqWZVjnpcqFdq9zfwhveHrLy83bR+kRuPDC110/B79jozE/XebKey3yhtdJ7UQvwTYMBJWWsAcYXk36vnWE47pwTn5kN9HKJ8LIQ/0PVPny6N/4LrkurvJKg2xdql3FSg8niTJ+7M3LreUDZiyG7ryXyTAHx3JVnc0Ejqgk/srSq0WHKQFVQLhgzmv2y7/aeIStTNG5BNpfO3s9OvU2qcNOXkpyaMivT/LOY6xDaMeOpk3BQw+jdMYjjA9CFzGIdf5ZCedn/QMMfOG11tyQaogGwjstwcdQol+KZF16RkYi2GAxqMZT8DEAZ+T78vViatwnwQeBOCW/slyhQtRLcaSP8f1+96pP6vjBu5RYXxN3igE1/IZJvxFLh0YNOtdQftw8OEGPxSHYieFUXeRIWqZDInOx+/FzxQsU30HbaIl5FJH/lnUQ8xbmyXe+3xBjrHrGhewCUcFQAX7QkjEiN2VDUdGVSePyvVeUe9hdjQpk87lpJaBE1w/sEa6EJuWn9nOYFRlcG0kt4er9wTMr+5ECkuD1T86T4L40RovqCK/IXqHV1NL6oYoeuwyF3xEGH2xwrMxwzha4r3cRV2XO9sGUTrNL87xpljMsQ/5+fh72g5WeWrplm6MR9KGEM8CDvRji9DHhBatRehENedzTMCvtcDOn2oOYbes1PuT+u2wHA18STnc3Dzhcq9g1QRAZ/9XzHi+5vbJFIPitSEZ20o3jqa0nxQAfKyA256PIrqSJWySAP0wIteRc3VwcaDa63b/lun9jjUxOTJ9sQJxugHsMBK9lmYqc6g9CbWsf/jaBI4qtuC8/SKld2zMBtsNgjnf6koSxJeGLqqQZwQBRLop+0tq+1OpYpzd/N7EFYy1LDhksPsSuT5cXqZMGeyfJGEjQ8UEUStSOaUCGKbydzfatqeSQrSRo=", 1900, packet_19, &packet_19_size) != CHIAKI_ERR_SUCCESS || packet_19_size != 1424) return MUNIT_ERROR;
uint8_t nalu_19[1400]; size_t nalu_19_size = sizeof(nalu_19); if(chiaki_base64_decode("jkAmjgh62+ShYsaNAK6USLqU8Pj6sI4SWVMKCfAgrirchF/Z2D8szFUbZ5cbyfsOnrvN19pb1tHIEz/8ynnCBxJdplqxN7JpVtGDnhERalikdZTr8YivgXdHbVecE65axzIMJlf454IyW5BXvvttnh80eItpJRXlfGo4hHmjLsm0toMXVPkeBE1znxC1nFXUpJ4dpdJaYKlNyv1dgPkdJLV0iHNWXyNpzw3n8k1haK/UdL73CQKfra3QEafn/vOi+CVSQ+HaA4c+VjU6kD11Ky4c98sO7ETAojaXZbwWC/YEJtYhMZHE1Bk33bKghQlTuQFBmgYr/vmYxkr/tAyxTof6sYXsXX/vBfpbSTnMcvMoPjV1h0u9inumWc6C2C2aFCW3oIeMCb7DsbaRRFS5Op2XkNTmcCqz9fNZUWIDNT527jjxtA7GqeNHFxDyeCmgc6mWfSeybwjoRpOinS6ObXHpJ8lZhCc3XpqMXynAJbZI5Aw2nnGC/+9tcmkUAcP0YuMEt+OxSJ1T+9o3B46wdfVShxNfeC8H1b5JzcRsDBDdkdSkXZFBZXCDvWSQxvTkAiUvQPrRq3lLYWu4bjc9VP8LNLOFHFNKbmgsL76lBUiqBPWA/O7clVbQ4WNf34ageyI69ofFHV0TMch0uOdAeQjxvIVNoLgjRvftCgJ4W/f1OiC30bcgamYoeS66PuOKKmYuWQea3uI+ej6Voo/zKI9jJMx1PYzICA98ejODcaf7oAEWi5881pVSQiEdlqvEjefnMwdJxhlArU3iW2KLoVJ03wjhKAdobvJSceNrwiblYjezOtyofx5MrlooLzTroUgku2w0cw8ZaGVGF0riACjD6khZ7s/yOMmGoI7PmdWkMqoiwYKLbuHM90Oh9cIK5IQqcU7MAaLHG1k1ThAj3a0Y6xgoUjsY+Dc1o/XWDSFq01DZ4YjVqnwZmf2M5Sc4aku0FsQv+w5ZFhhdmiPM0CsKdr/E+STlBUDUCDApV1XKlMAfuoUSe0L09A3GsvWIYMVIW5nDAb0fwXsY97oaBBVs0dcKjeOtbngyReb2DUcAB/J/j6P18TdqiqaMoSR/0lsupJgAb96NpWSuZsHD4j6NwT5H/edNP+YvXY+j9noi5fARC7ur6IUSJ9gYWvmGJDhTkwj1XR/AcH2NI+WhsJPvDzNQCyGiM2oiRfCoYltW0RwJs6WI0z0cv7r5LjeQWpJ5Ty6MsqepZ02RPp1MLk073HVroOH2O8NUfF2ERcl7o4kmgNARy6IsPVE0968vkkrtGI4KK3oW/0Au87LUxStE4L4cXGvYR6TFWDLM16VvF/DhgygsDFpI+dsHUuXyAwQRLntRQBas01gtY64QzcdMpNOKPGre63AVMI8cziXOw9up0SS5jo2QnZZg9EBSQwmPJFUAxqkPvJzY/s4gDBudvEQEteiWYPsH8t77fGMvL0apmJ63BsguKSiVwODbVXG3EXZPVf7faeWROIO6/CwbLtPtW5BmpxSkBeKBWROKNjXnD8sbh6GZwS5Vj0PiwhiRAn2TJiNTZuIVLRrZem2T427hGaysRt+LkMwYqRvyNoE6tRACOCFv9f8Cp9H7nMMLd2aTfLeTcdpBhgqsZRGF8kI8F6M7cSeK0X7kUpj/1WCsA/ELD9OwtStc5cY3qGlyt2Bxyeq/DYRoRAyBUeRNYkQjc9n0o/qVoAFbh/an0qeqViTduVyK19o9TJ8uyYI06xTBuEGCTk4O44YGSQVfHVYEx4IsdKcoQ8vAt2Sl/iLvLvoPPysUNvaVSwaqKhDQu0+N2T4xthwsPhL3aI1CVULTpj9cj3vhkUKPnh8aTuYVF82U6NDwyqtEdtzskewZAJD/eAk=", 1868, nalu_19, &nalu_19_size) != CHIAKI_ERR_SUCCESS || nalu_19_size != 1400) return MUNIT_ERROR;


ChiakiTakionAVPacket av_packet_19;
memset(&av_packet_19, 0, sizeof(av_packet_19));
chiaki_takion_v9_av_packet_parse(&av_packet_19, &key_state, packet_19, sizeof(packet_19));
munit_assert(av_packet_19.is_video);
munit_assert_size(av_packet_19.data_size, ==, sizeof(nalu_19));
chiaki_gkcrypt_decrypt(&gkcrypt, av_packet_19.key_pos + CHIAKI_GKCRYPT_BLOCK_SIZE, av_packet_19.data, av_packet_19.data_size);
munit_assert_memory_equal(sizeof(nalu_19), av_packet_19.data, nalu_19);


uint8_t packet_20[1349]; size_t packet_20_size = sizeof(packet_20); if(chiaki_base64_decode("AgAUAAMAABQBA6IyPEIAAFUwALYAFBLs1L4j7MMMkGN7Zz24OcaVjvQl5JsLzmalafevr6Jmi3mBkvMum8Qpq88O9Co8ZsGrpYBpWrBSQL2o1l1zJfg1PQkTP+pASmgifDpElJEMHEH+SW//WnheitWUvRQx+0xtMFAv44WHVO4b9HZGeegiKoXnruMj8NgIxE2P+Dy1XZ+noOBujGCWGxjnAyU+88d+PGNNNyQN3SsJDktTUJkMM6upjmVi9XqwYaIkTrR5faoqDadhzEBWdN9HwDjCb0dOCmbcKDRF+Qy6/IYfQjTqflVn/lpNI/LRQQMXsBE4IV1iJXJDFaOT6vn9NNv6XamkJoilfG53FQDRMsJr+LtUP8VpuDvLIDrG2qjBvlrHSnXqzA3Tvlt17SJE6eQ0BvTmjyK3DN+rKquDZa0vUDJhXeJwIVoImcsfkCOaDJp7NEt8EXSJNFkhr/LJlYJcqbqUh1yy6/ef+pNd6AJ/Jzm7ZkZQvwlv9cRjv+4nSYntudXdtHb0X8hmkQTlGC50p/AQvc7TjNDtU+g6cnKT1KcumAUMTWeL4H3nazUvxDOuwzHH95Ls24vvooqoXbxebBC1Sow4WxJoEjADy2O4eGLCYXHLxp1x8bJoIqOJKUwEpuSPGTPrd7fo9kPY1CIdFiXqia+0+1zCRTotDeP9IRAxYg1UefHaq/iuQ/mh9JOFGuxImMNNVB+zdWE4c++i6aSbaXpR4/XJbq2WXJPZoK4c4fReQrjbtcDjAfucbPjBzm2IPowKO+Nb0l9464/NACFWvEpYOWsv0OAB8Odw7HYmLEkJkW5lac9/oPr1tiKCRn/6ZNS0dYVSEBPLYPTYXESW9JfI2TO28UjsVs4lc+SkGFqQT+wyb2/iwLE94msTXqOpAga3jaA1Pl2v67QQki/w4/s+JRlqQDqU5Qzje9sRHugwIUVwsdRc2E422yznoYd0Najq1pNTR2MJ//j+jAnAsZILWt5UMR70AOXVce/dQrDuYCnotLRysuz++AeikcgXpwysh2IM+FXKR0MoU3auvfwdEcnnN63X5+Anrmiv+ILhPxsrEr+NYCF7TJtCYO7u5wGISxwBO7QTXRfXGi1BOaNL9j62nVxfm2pqof7k7sIm3FPeXwVkYdrbXx4FvbA4BFlQi47+ibZOhVuDsMKKbUoIbxlpO8UmcykCs9UXG5P8VoTU4XJmKmvYhCh6f5mg/i+sBrU8AP6vZejSm07qapAVe3XklX1GnfBwyTv4p8A4VsfvRsTQk8Kg6gywwHhCftiEqgkWyeIIQzV2VESKPi9rvWatdX3qeDLkkmNuH1MSwtd1ab/OSx42GOY0ZUPeKHQ7PUw0rrOVKUe7hdtaMB6E0XhEeBW3rkwV6l1gG+JAa2BgFriujvLDp3HezXbXadQWSG7o616VXpUhGOjmyY9ZxYcdqPsGrbmlh7eySczOa3OOPN6urK8I11w7HR5/aCw8Jol7BBNvsF1YYhqYIGD1vfwg1Z8Ux1h+pyPe9KDFYAZY1KANv3JPkp7tHngYsF4Yvr37hRhCrUvoZxbLrceVyADwCm6QaUk1G72dTDhzJ2fn1mvzWoKngvycQfN6KIwbnSaf+9TE1sY0oMCSH4a8TR+E3Fjz/JF7AMaKojamGRNoxaWqz0IaRFHlJxEoO2JBv39sLBaLIskXTBruFpZp6+55ZTQV2SQ0NtHAMBTfUz5aFbUUAwKZFonKPgj9rI4QK72ihwF6ImKPZXuF0Z6W15aJq8ie7sAMMmgUeIvDNHBOY/kAeSDI0ZU=", 1800, packet_20, &packet_20_size) != CHIAKI_ERR_SUCCESS || packet_20_size != 1349) return MUNIT_ERROR;
uint8_t nalu_20[1328]; size_t nalu_20_size = sizeof(nalu_20); if(chiaki_base64_decode("AAQAAAABQZoIU/+45v4gLpLzVrxG1CUmTzquLbAitW2ubUnhPZh+TykGsqortqBDSsjIDASkbKUOO34M4ZHmWvbivhMQzSxPjP4GWtzqCG5rpXM74lX8DCQrI9+ZDpByzMydqpXmBZ1posLTxwn6evA6hwSmzin8w2NyVfZpofbQf91S5lCF6qMCK7qMN8UNZa1Rcvfci/s+XtU5KJMOy6EdCcZUmHAea7O8KpW8rmZ5WveA1tpeXNnrudynqIfE3kENVpOmLtiA0ztfohZ8zlRca2oN2Q65EHraHMFI6JMFWmhsOGnRJUOTNSIgKXcyteNem20E03nzTncIT8kIpLcyVcck/oQbgnnDNfxExDYmEBL9vZTHMNt44A9qfPs2bYtueUP6fYEMuSETyOAFrMECug/QQ00RN8J6Ebrqtdau6eIfrFMWBS6KHCCAPxc/MOtRkRwULsIZ4nXKw4MJExTp9Xg5qkgUEqYainkgs3wAQaxWRvpTh1Qb27Xhxq5YNBJNAZpO4Kw4K2G2806auItho7hqBWtha7JizfJdWxizeM5r72bn/F5/3n9/aQen98UuhKscK8ZYBD+0wAolx5TjcFUEHCg+NRT7o2KrYwfL6/vOeQdUDp7rfWsuTWQQkvYbL4qGhzs4+oGlGm3TxHUtjWYXwql/cEun4NCb4VisJyKA2+E3rm2uMERVQW6VSdEAf6y+QseMTv2JR3YH05IZFzmfBS7jBwwTlcwTF0QzYrNKcq7z/cLNOSEcJpRTuztpU7KVVDEbzFNjYYfB1f4bWeKuuSTAsc9mmq1yx6WSVrMNw79oJiu4kWAFN5TBdbOhmUyLF18ia4Be6OAlFbinxe25pvVjLXcstOj80nxP+G0l3aGrv+1s1uxlF92FQIIcH5NqCkvATEEKQoEEIBVoleBWuJ1ajd5Y+E2ArVQz23fU7wy0zH9tsfnE7XB5Bzn/MxMdCQI+Xof55FqU3kduasPvx7xp0Xc8C9GD6sJKxAeLWNtEj0PSaB+3wr6e34ycvK5HSjPmartNhgken75uI8okh0vqs4A4HFN/ha+7jyRS818Gv6G4F4FxPyIVa+exStfUuwlqXFBwsgXASoW2j27kReBzB3nDSDNQKUOpCiBe161rNdRCoBQVsfcmBlRCsYNk4jSAW3UkXdo2iVkk0THGyAHc7ePZigYIX1F+kxq2wUkKqp85OCkZFEkIXdPWVvaFQc+8/5TIC8hmiPYiCfRfKcDwBzPBSNvbQVqkFGBQkvFCA44hu+ayVg9IZ6b/t4hlkSaYbK/l3ljztC6mPEygDMCgRxcpyjdHz/+V5hmdtVkCoSHR7FBNIyGWoRnmZj+9u9TlODphw6W9GQNSxUHa8ur/1jMkIa+vQd+tsaiCAZ+463BPmG2GXiO8RddsD1RLcQAhr8l2kjoVBBuE4+Htz6ylZXglyRxJLreJ6GtwsnwGJsHoQi2JAWyfjrZREs6U8+51iYC3OjaVx+SgbUDlLrlFnGPiLtQKwF5U8KzG8aQM3gXjrpS6PcvtNCfEZvfdQnfAWXZRIrblyaPnnR0kzsdg5w35w0wAO6pZe5pwX8d0SoIYsjw3p5MYB/R+UkB1FeixqShzqV1g+vCyvi8aDOm9Vbu7JIllZ3ORdfJvdTRoyQ3923BCPay3Y8J6NmTPm/e4noF2gRL177D4mswvuHcFe8CWaz3HnBO64pDyPy7FyZqZtIvGOKHZW759skeNffdSXnteIb11pTl3CiblpbZww2935ksk9CA=", 1772, nalu_20, &nalu_20_size) != CHIAKI_ERR_SUCCESS || nalu_20_size != 1328) return MUNIT_ERROR;


ChiakiTakionAVPacket av_packet_20;
memset(&av_packet_20, 0, sizeof(av_packet_20));
chiaki_takion_v9_av_packet_parse(&av_packet_20, &key_state, packet_20, sizeof(packet_20));
munit_assert(av_packet_20.is_video);
munit_assert_size(av_packet_20.data_size, ==, sizeof(nalu_20));
chiaki_gkcrypt_decrypt(&gkcrypt, av_packet_20.key_pos + CHIAKI_GKCRYPT_BLOCK_SIZE, av_packet_20.data, av_packet_20.data_size);
munit_assert_memory_equal(sizeof(nalu_20), av_packet_20.data, nalu_20);


uint8_t packet_21[1334]; size_t packet_21_size = sizeof(packet_21); if(chiaki_base64_decode("AgAVAAMAIBQBA4bVRpIAAFpwAMgAYu/88xuha4N8fgx9p1NrR19djiQUA/JapudvDEPQqbZfQOF6jUcZQtnKKGNJ4UMGwufJ/uzDOhDdo8kcQ6P4774DuTAO102stOqTWp+oRqXIPyRqMW1uACM6dJmMErlvA9dUcDlJFsD0maqdx7NvZLNkNrdCa0W/bjBJz9/ejgzVTfxMjMoy7UNG6NdbyrOdD31q7+zE0GRk0KhaDsW1H6rkUZwMiyx40cDg8Q7KLCobPpAFAafxcL2IJxM1lwVTrDBf8/Wnx180xPSWj1E3NYgEJZS7AGtvfgvv6y6PTLvMJt5O+7iu7dkIf0Q9nIPeJvwld8tj4EWnx4IEs+kWtztcIvC3FKzp3lLNnPD6fkE4mzIZkVy6/lWZByk0cv1r8V4YPhtasA6zr0iTBvYCeY2qYLN0XbD+P5gLBsZ8gIl/DYoNJgEsYvjL7qVMAiE9zUCll/jUmsOr1UWAd9q2/0xnKrifdMhDPn54rgznywENzXvGGMlA0Z9SisBXB704FPNWecug7Jc0LmDrdjCDs78bFDORp9g+j/uEqfMesZVKx+afNalWPpJUsiUgxdNVMAEAxwQ7asTPgDDjSUsf1i1fgPMQTGSYKilKlFvYUoKKJ3bUu/xUSluoIctLaP4xi+dm434jkJMYr4nnSRGDtTUE3vBtm0f3L4BBcq8/vaVdr2yZ1Nybp1pCWuo/iNev/NjpOKBNAGrYkY4N2kZ8LLTkYHdHyl7u6bzRMef30Y0RSHqoG9NFGxxSRlXTiHyK0m67QTaWOfBdxTjFlp0dB4bBVKsPDOfvJ4FxZPmoj01XZHrolZAQcu8+FjBzrRIrF6uji2392dUZh6I75kkVe8s+De5iPh9EgHjG1LrvLadXGYCHunChKu43FhZvEFu2QGFJPp6FalcfuowRRVjJFq4h+pyd+Hm7e6xuNrl9P44ANh94WF3FgOfQ3Y0+9AzIPTRWNyuxAEMeUeJJZ6rXN2wYDbXV+3ni3xPGAJm8VyxjlDAtIncl/hO/g6uTIicQwarHObnJxWcAkIKB6X6i7/BehYxbSywHylamQisfnAflsys8fugwgEN0aUo7chQD1OvfSB6vNY4Omam+//cPVB+88ek/rY09V4aJAe07Zptb6qSBwpGFOBJXxDT/kbdReHy+gqkL9CI/dejPR1lk7/8RSirNKmA4cNqsytTrp2K2iN7xo1D2cSU+6t76+WpDmZuFWwgQWk4CSg0dEh2rss7iUPdq8TMCNs2WhFORTODh+bbVZ7wRZO2htPElPWEY1RUEOdhnJwrWEPl7Lm3qoWVShv3yCuHtf/btsT2KuyCGz5jDITfRh8L/JObwklyFKAStmfzNzrVRjfYsHaPgWq1+eM/XIYM0P+UERDe1ZY4i++qJpVyr0ATuEmI5uhRznds0QtIaWBKnnvpDBLp5xWw+27aI6FlO9hPMMbVHhAVPE38uw6VwcbQwStD2PSG6JTvUVAZZx9fNbrxjVp8n8GpugMNHwabzLYy5l1KI24pKrIDm6vsLAepc41wG0VbvbNDtrul44TbkZ7x0V3TjAa48PAUyhQxndrGN9yVyCAXw/3ftllgUXF7ZM1gOf1lO5gbMnsahKsKIChlvJMYGWiMmwIhCL4bNFv5NMmK8p2Lp3aXx7UMz6iGFpUwKBYVhvvuV5tdrl5++gH80HrYYg02dSU+NrQ9tCA19jSDxOBkzI7CJEf0CZyeSlQCt7bA2CGaanKjdBQOxczKKs1vjoDw=", 1780, packet_21, &packet_21_size) != CHIAKI_ERR_SUCCESS || packet_21_size != 1334) return MUNIT_ERROR;
uint8_t nalu_21[1313]; size_t nalu_21_size = sizeof(nalu_21); if(chiaki_base64_decode("ABMAAAABQQFuaCEz/9AkXEmCxD1InUshQuverX4zNPuEk/X0V+zXfPhFvW8r3iiO8REpPnIFM3bN9r7ChCRotpIe9O5xq9zOveGEpTteMmF42K2Xx3WDQBVPjOTY9Dk6r3GSsMUlvQgHyavE8ryIyCN+K782jNsAekZeEXSQ997v6bbsDCNZ2uFDtW6bhgOKgvK1s6CSYJ4PQMdTSvTUBSGSV+NIXFViOTHGEeDj4HvbwGqXHu3EpI7931SGnUGPTsPM5qBFJ2FvldQzGyerLbzIuLp2W9pUmrhtjYv/RY3ygmvPbqCN9AV7O/+1XOWwKz5aks5RZvzWnUz34qt/NicR/PNFNeqFFiGp64B8dlxY9RnudIQ9QuETYU8aI5a3CJ1v5NtRQ++LbzdRad18/ERZoBhWh+R3fE+w3KyjljFynVQuvqk1TEOMpMhmDolMNW/j5bqzID3+NAtoMfc6wAkr7irReeb+e/GHSlee4df4HJAigSGECxolL6cDPrfKpSJGnV7WgfCxzE34JBrKgQbAuUcoHJLMdpvUICjueWLCn20nnP1zVN43ux/KqgJWT/bCCWXWKp8DrCdh/SkUltpLVnz1GOd8fDgywBmDduxC5Ggufs1tzOQZqXx17o7yeQRW7DFg1Psv73yjMF7N0oDjHLjmrxRsnmep/7miGr3/Rfhi+LiZIBa0viMt8mFrTi7+daRV9DgM4RsQQwilGRhjnVBhstI873dCZPxDKrPq5TD60g1b1MvV8cStRIt7WygDklJ+XWyVJ2dWCZr1x87TUS69F7XFBV5Fi9+o0HbxWku9sAbiTI754Vae4n1Ky6vtBX1lCLhwqpw4kW8eYx8/DffDcbu5PsE2j2SoaHaNGi7mG5u8dPIcf1F07Vaj2WVWYjm9M7rRqe5fYf0DhFngvgXdov10A/LgZioqteG2DTKwP50r/InD0a316A/YQxIE+odD6ZRzX9EmtrraxdesRNbQymyoQTBxsxf55L/kMyXDSt9aRJrlT7wH1dWUuRAGx+phM2JlTZd+WorQFUIyeX7sw5BvWs3lgjtoxPy2VrTJ/T3la90Co23N5Yd7QL2Vm+xtvEFZcVIgrn2ic3To3huCPdz/kYQJtU2+0jlLHVWhs7Vr0WC/Drzk/OUb16P06MqGdtI0Ny/BjsCEm3OTtTTXgcxBD/E50dVd3W1dYeqtmD0ndaTmruNouqxEyIeeDerL626nRPwU9kyhbGFXwKyPTeQEYrEp8hcHX63NH/Q43j01xy9vt+Ml1chN8QCPSyBnakCsdyelnqfwqEQIMcpAqA9EOXAUiuM8XABvcJ3vA9XJaGzAHAaP8sn0//NBgtbckVvccV3CK4Pr/uRuQ+tC2c9vx2N7Kp7ikd7pFlzU8NNu6hyK9RZPamwBoGn87I7v+9TMapFeJiG1YJusaZ40skIRu6Syt9eZuam32Vv5zEkb89bIGi/nX0BuTNyf1cFqt6mTMGjvvSnUTq0dHjUxUVrn1wAzSTRax/RUB3mCfTD9WB/scl215MS33vAh4wbw9qCA3Bao6ru/4A+kiOjpp8BVexLGnqcpzqTbPUpTp8qV7qVmAk/GN84DNLb7yzb0ObrXq+KGNfd9E12d5Zk0Jz+PlBtqpFDMe8sdOPXQnP4nSIdQ2qaazj987xhOlygZBF9GWbQFrv2zAfpgZffYQM74Ehhp66GD0Te2P48M7Rqcq2kR49i0k10Rp4qBRGmjeZch7Z1KPAtq1IA=", 1752, nalu_21, &nalu_21_size) != CHIAKI_ERR_SUCCESS || nalu_21_size != 1313) return MUNIT_ERROR;


ChiakiTakionAVPacket av_packet_21;
memset(&av_packet_21, 0, sizeof(av_packet_21));
chiaki_takion_v9_av_packet_parse(&av_packet_21, &key_state, packet_21, sizeof(packet_21));
munit_assert(av_packet_21.is_video);
munit_assert_size(av_packet_21.data_size, ==, sizeof(nalu_21));
chiaki_gkcrypt_decrypt(&gkcrypt, av_packet_21.key_pos + CHIAKI_GKCRYPT_BLOCK_SIZE, av_packet_21.data, av_packet_21.data_size);
munit_assert_memory_equal(sizeof(nalu_21), av_packet_21.data, nalu_21);


uint8_t packet_22[1352]; size_t packet_22_size = sizeof(packet_22); if(chiaki_base64_decode("AgAWAAMAQBQBA5x1jkoAAF+wAOoAddR1vKblyVOAkFtxOcRuknxzPV8OAMSQvNReqkkVInNeQVW9A1ci+unxnYjAQ+Db6Nsnn6yGAgXAS7vlfjkDYmMpMl/6Wp1wl5Vxa6O0bdc9yP13b/PGh07HaXEqWqc+Xo5iCbQBMnZzs9Uruxe4yWDoFgHQpzY9F1rMGRXGYwQW02DENHYqKCYUB9Iny41WT73tG5EfWHk8G0WBrf/vmTCs9CNBEanvNdBTnNu51QJQPcnQ9qPBC4PBL+fxN5fZzakznmrt4mCweB2oKb4gtgeymTEoIZPvpvDZXkv9sfRC0hHxowCUr+zMEGxOTQb6vk/yW+p+PxsyQEmLlVG6DtEwMqqheggorp9/rwWXmA8U/LRw5qDELfZOeCgmf2izUtUKFChbRoa734B4G7ywpwv7XWbd86Rd1w3FZJblYq0GNDOatsCgalhrQ0BazdoBnpOQr8+aUKJn/oep473I8LIOjGxfGroW6L997yvaiB0yq9PA855vWmnuTUPSzp/GJt8NikbhxkIMttBNblCl6/EwdBF2cSDIAqGhOAdwZU5bH1/fjUkQ0IisCLnrqD3pmNo1j9YyMS/awOp9s3wzLZnabBKHboo6Nln4b7hiwyZZ53jkMU9zA7jGQdjVF79i/CyONa/HKMLNo+Cr0ZwfquABu1zsoBhYPyL2pvUOcAS16VL4rEBruTeeSESSn2JJS9U6pP8T4cQvTaQ9O+KNWIvh3R4bIN6JMPPbEag/lo8AtczhHNJgTGYr5901uiygjR1FFc6koWIjjD1BJwS4SVnXaS11cOJKBGshBP1NGH83Kq6Bc/Xc4c7eVBd2QXTpBzb4FOUjB3yeAnGm+oIs8fDvA3M3Gb+TMzaCRYM4SPhXusHedQG1Ha1meg6tFtiwkQgf3EQbDrR7t5BC5LOMGOZR+4nn/hfkaVkqTJ8tkpFdMBh5aJS9wxWQfSRdPEh1ZLx8sxN+ldxN5eUyuJNTXHDkd18n+nOsAaBlxBJCx9+lkZ51WizAGWuY2sR1iepThIeWhh6IlN++PJJzr4yv4j+3BEGtdS8oOj6wBekw1MewKY+/dNXZeZpQT+UKcHrqMFgJiEBQYt7NeZKZ2xIhdp+/WJvrvQiv0NUeG5f92mQmEuQRW1GzS9N3qJwxXpXKn8BMlPKGN+rccaorN7kbBrzFcZ1tB7Rta8bYv3F7maJyctJpwFBNY6oGlTGL1geTvTZtu1mXZrQ9OC2oYVs4wfkoB3a5moItrLczysembAO6BCg1+QjV0qVw2Se7ZZ5nvb9KGmdYTXRC6ZGtXU22aQ/MQ6gvNqZ7uOO03SBPJ/NBnGzgsTeZ2N3CKBIp/bjayT4RN+ad5B95IOSlPCMX8/L1VjQDmog31tAvtlu7YKjvXTd7uGrbvibuQHmjFnat56R9HItsQzJyCp/bv5tgi2NSK2FY3s2zqe24HIMWzclZ5Q0b0bwjFSChhkUiVK42Kv28Yyw3QAz9WcpaSR/BNxYrJ1pfuZ6X/YHUqUhg8U0RzIllEYJDbTqrqh2fryU5ZcbamTQyB4+jCIWr/UOZrc75k8R0HaIPhbRxmSRYF7Gtta92+kmTmSpjnehs7JROjEfnBiZ7ArawnyWKAAhHihN1ryN9SQ0pwB02QoYPnb90rY2Pz/s9ieRrL30CZGftkPIrNXLjb/zGG6L9xwUCT9VqLBE3pIRAEUkDHdRjBYIDNmhCOVCtlwvo5ChLItltfaIVacnUcee78g77/sajnnbGoPC0EWCVq7OjJe5zekxAB/U=", 1804, packet_22, &packet_22_size) != CHIAKI_ERR_SUCCESS || packet_22_size != 1352) return MUNIT_ERROR;
uint8_t nalu_22[1331]; size_t nalu_22_size = sizeof(nalu_22); if(chiaki_base64_decode("AAEAAAABQQC/mghCT9fcMlPQ8f0wyc1mYW1UF/KMHKFKH6KCoTXA3ba2DCVkHWmoxH959gAb4Kx5KdlGQYltMoK7dEEMtCjPd1yhUOu8G3ksNjm+TMAqu0jwhwCgNbk0UVf0w+uicVYIV2AQPglfxMzTvGId/o2D8O5SR9VE8Me/Xl/K+XELY/qzoEpt7tsAWR9ac7EvnqKwn0iRPcfVYzInIqr2XJ55ee72kTVXZmrxXVK8e+dDItkWN5HikGdtF/3qc8nKapHNLl8z+BuGxrEHOvO1NNr3wbW6qzYqiVHDbajfldYnpmKbP4igHyPu6b9sXJQVYbLeI+TH5dguJ/XFzuwU2MohlMnFiYdlLJiostVF7wWIX6XLQzpKRJUNgjMzd2x2SM/xy6I1aAQ/F3cgDgrQSIp2hKdQxNhdbBD7luk0zlTKpi1XMS3T+rHvZovCuOU/KkaecYUea7HvEuIUJu9vN4RAfXPaKGrIEFwldSiM+KWKsxIZRaLLmaOS4JfHrPnG/q0aANrhCxYI3wlhdzmpNCUsMbBJRpL5+0RLv4KtYJsOFz6CdnoRjxBAC+s0AlEB/DQ1HCP9AcMIIu/5dfe0KvVaX9/xznBwyApFY2CGSkLtwipEXFImFrluSe60K26bRSkKc/3hiwRDU/folZPjHMxqYZdPZAClCfZIXbCeUwl5PQHoNoqf5ORuC7V3EnYTVIauczci9T9UzQmfZCFcWFdU8u03bVEzsn6aVrFaKR59pamDBozc2kNQzVsnTfnM3WNQtIWzLka3YZy5Akrf2r+tExgZncA6yBJXBJTLrvgAVKYZo+E1u+hyHx/bYTWG4S1mJYD6jwEq6KMgA1fpJqK3nGaHPmIuwG4wof8JxDdn6YUnmTVDo3RbYPERpoTz22IdXJUFq2IfHxN4D//fQxGh1+fPyK2Vx1Yyncw4ER8/crjQr2OpnSSKkizwKpluo5LegUYxVDApi1ldyIPmq9hVOx4/iTb5GuoTR99SZ/uEBWEn0lbHCFFkhv81sNPQsoR/X0zuRkBVToSJgYj61Hi30AKNp3luDevFNGY/el3KFJsyFNcCduVr7fF7S34v61CaPnnxGLNrhDD0jmMBR1Y3u26mwdpTU+unXHmDq7wMQ+gwiErVcGo1qzAdUUz/FZwofZ5nQUHFDjx0iP8rFUVVQBDCEsT2YbCyd7b67MYU9YlKpkIm0JorPiAYaLcVqZ6UB1PUtIrmjIlQd1mRfZvLoIKpM0e7m6bha+yT42Prmf6z4OJCFGp9WBkmTPGsedG67+8+KY16UmLgRfGRzkQhrS0IYUHkUb+LEtPQ68Ti+cLglBSskH/4glXGF3faWpXwnuW9nWIBuwliB7KUdJr0BBj4Xlz304EKYfqfkQ7vCaxw45IWlHydqgw/Pl3cy8JYG3e3qrjiSKSdVhWDrbdMNCVI0WMjDANudS5ngIVyZh5J6FRfdFoRTQSspeWyapoGOlD2wFRV7LYHSFHvQgVaychGyNQgWaOcxCf9yykxS4KtVtN42MUCKsmiFG77uhPIY4hFyxjWEHXlNg1pjSd80GGk1Ha2oayOVwwdHTytX+TofQocGo/QEDoz0KH1In22l67d86homGUHGruegaJu7Kl4kQPJKvYkZXfimYW5IPjn42NSb670PidWpL3Ba3SnJXcpdAJQkmsmZdHdTbOpvEUrjMAkEHRsGaw33Y+/1SGhfGRV43Enn7onoFrJC2YGnUKVIOrkq5p4jIp9W29ttx+T9beVb030apg=", 1776, nalu_22, &nalu_22_size) != CHIAKI_ERR_SUCCESS || nalu_22_size != 1331) return MUNIT_ERROR;


ChiakiTakionAVPacket av_packet_22;
memset(&av_packet_22, 0, sizeof(av_packet_22));
chiaki_takion_v9_av_packet_parse(&av_packet_22, &key_state, packet_22, sizeof(packet_22));
munit_assert(av_packet_22.is_video);
munit_assert_size(av_packet_22.data_size, ==, sizeof(nalu_22));
chiaki_gkcrypt_decrypt(&gkcrypt, av_packet_22.key_pos + CHIAKI_GKCRYPT_BLOCK_SIZE, av_packet_22.data, av_packet_22.data_size);
munit_assert_memory_equal(sizeof(nalu_22), av_packet_22.data, nalu_22);


uint8_t packet_23[1328]; size_t packet_23_size = sizeof(packet_23); if(chiaki_base64_decode("AgAXAAMAYBQBA8Hy0WkAAGUAAPsAin4FQyiv3yCVWjsTdaBCnwPTKZsqb6PVDxPxfDouNnLHimAMlu2ONbVLrUYDzYr4ODn4+3Z8VkJFfRpwLCh7kvZOzpigSqXfbKnGDMSJ/q7AM+ClVCQTymAV+r/cwpGmHsB3C9erZ7KIAYW+MarkEhIrKCEqhqrbe6vuvgCm4ykLZj/WC+CUN8518BHbfdiRM6txHum/6L/kYT76l/Vs5q8U8Wc7ZOeXYekFb2sY805BqXGjgPEjooHoQFB5nQ2dwXiClUiOzKuKe64KmZAVUdzg+0vYtWgkjdH06wWFvOgJer5BURFbyaseMil4nX2lPVFlTDJArbiiqcqGiaPedF8rc93r6k7eURBBXCaUcO+AWsp/CeyW19E4M2kWS2A2HX/2N6TSSIiW6uyLxduuN8e79D1OVWkt2ytlsbQJpcHQr+Zy+tk0rMAZ+9Ctt6QPFMD+AvJ5whA2/M/V3avDGLJXebykq4uUqy3TchaIqG+uLTh1sd1xd9HRNH6QviC31+cbOm0Z6mXrbKQUFqs8XotCTlZk0MgpuxQ+geVKFIwphrtxIbMqUiIcxhzYBjMBRkC/C6jZdJuz1YOVSk2667+mtpOzAYA7HSDP3anSC4DzUmA6OBFSYDpXSQZXV91W8sMCxdn0+q9/+H+wpFyjTdqzcwirb/bmSZz9Fm4gnbWTOoe/xC8Dks5yz0H3uFup6uXE33opkEjNH1ud2mjpYiLW2SLq3KSctKjuPhLSVsy9/bEYQy1mkCUzau/MhDml93VzHJF5h7DbwHX7ItjfRCeMUOQ8jDTk7uDHSh7+w8+PPkwqiuLQWbSirmS/MkRVe/EO/Hdn3YjNaMtDmUUpEVkG6DF/qQwiwhl2m3CDUxLgLNysWmTL+aalUwIoBxKXgRIUcVI18oSJp2wuow2pAOPwIefP+Kv+zLubBdoRXnic0ecsiqRDq85mYKwmAS1AFZlZSNiXHTFD7Hc+9t47iicn4sASnUCD9VFqvgAp4evi5Ckh+2+K9le4SoN1A3cd37X65obVKH8ykpQavsonZy5os97m752GYOsHHAyXjwrVWjeEb8xzqeLPVqYfhhKd7wzS1yYKjklZiDerVq73LQAiZmzxZvwcc1w9siCk0lcuhbjmov0eDiOomOYDmodKRfuM56pzCjXNXCrt1GB/z8WgHvgpB4Ebxl3ZffebDYmxQBEhY8JgQIu7oDVKVpxXG9dXnbJlQdaHcBd+bLChf3zgpIQU5iwp0U+CdlQE12WjFzsm7HUi1w6BPisGVMwaoGskmd0Eaz6gwTBeFENQ32cbvYFGEJgBcl37i1XNSDFNl9B0O69Qmog1EQi9ZI4v3i1ego0ZxNe41c4aqD2JudNVzE+HFuDjXWxleERdENT8BSt87qNTz8fEDiYWVwjPnyzl4oGhCqSnI4tEXDz+0lPHG/Xx3ttyJnvAwEto9/iFgDvIHVc75MREqm98gWTJPVp0Tz5jFvuyBHvP2doGIqriw+FgzVffp6LKoVNIScEH8XFuVlV6c7C/bhofDpV5AW3aVcAgw3uD+fHhC8W6EO2yTBUNSH68IU8ukXQgO01QZ//sG7LU5SMV7sw0MzULb5qYqH3pE7FtSGlyavo4vfvH6X31SnNQR42DeZIcI8n/77mJTtK5QKTB99obSU0nDxsrF8yBffRu9nOD7elMCVwAqUm4sPs5CQ2MSk4E7d2VP35IU4nZG2ywawR+WbHCp0C/bwAO/rvPLgg=", 1772, packet_23, &packet_23_size) != CHIAKI_ERR_SUCCESS || packet_23_size != 1328) return MUNIT_ERROR;
uint8_t nalu_23[1307]; size_t nalu_23_size = sizeof(nalu_23); if(chiaki_base64_decode("ABkAAAABQQBNJoIQg//eoqCWu3zz+HXFAKq32pQyBi8LkfNPdF1/9RYsjLS7cMNmBGUt0WmWd63aYl5jgl8E7AL+MMB8lb+8Udv9TJf2U1TeMAISiYl/4lNxbQpPjerAYqD4WZDQU6yeaYwSg2yqYc8QTOwCHD3Z0ETXgz7R+3vw1SxsijSubShUmugvuDxIEqNLATEgaMdFOBcEVWZPrnGw2KWjy1/eYFSaPq9s+SQnsRinmkSBWNGNxwlfesIica184uEqwFClFe7btI1G0DsW6SUyl3WSnX8NYDnlc1NDv/IH5EZpE3s+qzQMdP4ueNhILQp9VfqDwefesIilqhcczp+MfMP8Qmpq4RfsoGe8olz0N+2h/Kd/DXNgDvVS5uvurq0NA9LRA/HHwrmrbfymvmcDuKZOq3Ro+5/yiVe7lyeB73EwLpKo0xHyqbvdbqAtQqkkqoW8AzBe0KYyLDMRw2ytzBExLNuy4puAqzGkZKnIO6sII2NkjPjfmZejAORs6rVBasnePV2JdawFlQGFID1MwfzDV6K+Bymei01dq+5tFLfYnBrDnwXtoAUl4VuhS/8S7JsVb12UWh7d9wOWYrXLrZwbqCQOUuZ1nkWrmlvY9AymUJXlg+ehPaAgr7U5noh9vImfcs9UyuVb+FvVeiZtPH6z1XdGLUYrY8CLkgaZLVL2I/JhLGPdNEYj6GFDgfWUSehf1Jzuh+MGQkUxHxf3KFlRLd1W74TNN5fZKdumf+4BdikW4TP7Z/FaWh4ALrE/FybJ3ds8sVKPD3dAaHSGZ5SwsQWSKM1/8IdiXyL0RHvjKlYDgQabcOOiHTxDvTvhIpVvvFt0DuaJAxON86gzNckgcJv8AfI3yTmRVW0UXlXeEcc1sMUF6LS1egJuP8J7aRUFY2xyh1EE8XEmy/YVH0SUaIZde2oEEOGPEmzfV/Wrim/se2iDaVY3mbwf3FqYHJiJwOgacavF4MLcFRwgzzuP9XJ7E5YytdYTY8rKsBDAoer22EWVdSDBtcGWjS93TT8+uTpFc1hBEs5fu8z3PPvvUHENYAw909UkWCJEACeYfxzCLoHnCWl4blcpwYU/BaEeA6RQprpak1tD+ZB/3L1GeHHad2Xa1w5aDQ0UNi6DE0w3vjC8x25P3lOQhvCYD6Axb0HZ8sqfTtQQPtqdfc4b690kw0E6wpDMF8vNYru7XgWaXHVrfJB9a6G+xZ4RHOJfeMc68CpUSTJhBv+PIVgNo1hX//o+cQsD2wLpV8LdkJIOcmYf6wsQbNfeu611mW9iRv7nm4kuTTK2Qy30rUY+OLRhTliFuZt95s8hpnetVTgoQDxwRGUyul6Yv0wZQZtwDQMcRceb+VYcyGxbpq3LEPiZgPUYO3HbPfjvv3Jr7ms9c1UHBqGlD5x3YcOgb0zEsmOgWhrI+k0+CJr2IvAr+GJ6l+FH3PBbmq33gznHLkrk7cfD1GxSs69RCYpH+iLMCiCISujV1Xiiy55CyeYuREX+uW7BmyzYZkZ1/oIrppSwBuGonVmiaByUISxkLIRQ922jWRhXjLCvGZMNCBFNL305alBdhmB1SQyfBn+Ht0ZVAodLeAldHckvh8Q2jfxdeF26vvKeDZcN4vEg5/9PhGriGXE3IwwGyLqQRogw3KImSsovTj/2qhvXLtWe93G0UuPnRZ1c2NXGQUNvRylUbfdkxgUkHxVVrwjWAFDt812YuNz/PG3vwpoY9uccGkzZhvA=", 1744, nalu_23, &nalu_23_size) != CHIAKI_ERR_SUCCESS || nalu_23_size != 1307) return MUNIT_ERROR;


ChiakiTakionAVPacket av_packet_23;
memset(&av_packet_23, 0, sizeof(av_packet_23));
chiaki_takion_v9_av_packet_parse(&av_packet_23, &key_state, packet_23, sizeof(packet_23));
munit_assert(av_packet_23.is_video);
munit_assert_size(av_packet_23.data_size, ==, sizeof(nalu_23));
chiaki_gkcrypt_decrypt(&gkcrypt, av_packet_23.key_pos + CHIAKI_GKCRYPT_BLOCK_SIZE, av_packet_23.data, av_packet_23.data_size);
munit_assert_memory_equal(sizeof(nalu_23), av_packet_23.data, nalu_23);
	


// -- frame --

 // packets: 128, nalus: 96
chiaki_gkcrypt_fini(&gkcrypt);
// testcasetoc.py generated code end
